#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Mon Apr 27 15:35:19 2020
Script permettant d'obtenir un classeur excel contenant les tableaux de distribution
des modalités pour chaque variable (i.e. chaque colonne) du fichier fourni en entrée.
@author: pvernus
"""

import os
from pathlib import Path
import pandas as pd


p = Path("../data")

os.chdir(p)
for f in os.listdir(p):
    stem = Path(f).stem
    df = pd.read_excel(f)
    liste_col = df.columns
    with pd.ExcelWriter("../out/" + stem + "_distrib" +".xlsx") as writer:
# ouverture en lecture du fichier
        for col in liste_col:
            tab_distr = df[col].value_counts()
            tab_distr.to_excel(writer, sheet_name=col)
            
p2 = Path("../scripts")
os.chdir(p2)
    

    