--
-- PostgreSQL database dump
--

-- Dumped from database version 9.3.1
-- Dumped by pg_dump version 9.3.1
-- Started on 2013-11-05 16:27:43 CET

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 7 (class 2615 OID 19337)
-- Name: tables_types; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA tables_types;


SET search_path = tables_types, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 173 (class 1259 OID 19338)
-- Name: parametre; Type: TABLE; Schema: tables_types; Owner: -; Tablespace: 
--

CREATE TABLE parametre (
    pk_parametre integer NOT NULL,
    nom character varying(255),
    descriptif text,
    notes text,
    type_parametre character varying(255),
    cle_importation integer
);


--
-- TOC entry 2369 (class 0 OID 0)
-- Dependencies: 173
-- Name: TABLE parametre; Type: COMMENT; Schema: tables_types; Owner: -
--

COMMENT ON TABLE parametre IS 'Tables qui contient les identifiants et les définitions des paramètres du système';


--
-- TOC entry 174 (class 1259 OID 19344)
-- Name: associer_type_uc_type_role; Type: TABLE; Schema: tables_types; Owner: -; Tablespace: 
--

CREATE TABLE associer_type_uc_type_role (
    pk_associer_type_uc_type_role integer NOT NULL,
    descriptif text,
    notes text,
    fk_type_uc integer,
    type_uc_cle_objet_bhp character varying(20),
    fk_type_role integer,
    type_role_cle_objet_bhp character varying(20),
    date_mise_a_jour timestamp without time zone
);


--
-- TOC entry 175 (class 1259 OID 19350)
-- Name: associer_type_uc_type_role_pk_associer_type_uc_type_role_seq; Type: SEQUENCE; Schema: tables_types; Owner: -
--

CREATE SEQUENCE associer_type_uc_type_role_pk_associer_type_uc_type_role_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2370 (class 0 OID 0)
-- Dependencies: 175
-- Name: associer_type_uc_type_role_pk_associer_type_uc_type_role_seq; Type: SEQUENCE OWNED BY; Schema: tables_types; Owner: -
--

ALTER SEQUENCE associer_type_uc_type_role_pk_associer_type_uc_type_role_seq OWNED BY associer_type_uc_type_role.pk_associer_type_uc_type_role;


--
-- TOC entry 176 (class 1259 OID 19352)
-- Name: associer_types_sous_types_objets; Type: TABLE; Schema: tables_types; Owner: -; Tablespace: 
--

CREATE TABLE associer_types_sous_types_objets (
    pk_associer_types_sous_types_objets integer NOT NULL,
    fk_type integer,
    fk_sous_type integer,
    remarques text,
    si_standard boolean DEFAULT true
);


--
-- TOC entry 177 (class 1259 OID 19359)
-- Name: associer_types_sous_types_pk_associer_types_sous_types_seq; Type: SEQUENCE; Schema: tables_types; Owner: -
--

CREATE SEQUENCE associer_types_sous_types_pk_associer_types_sous_types_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2371 (class 0 OID 0)
-- Dependencies: 177
-- Name: associer_types_sous_types_pk_associer_types_sous_types_seq; Type: SEQUENCE OWNED BY; Schema: tables_types; Owner: -
--

ALTER SEQUENCE associer_types_sous_types_pk_associer_types_sous_types_seq OWNED BY associer_types_sous_types_objets.pk_associer_types_sous_types_objets;


--
-- TOC entry 178 (class 1259 OID 19361)
-- Name: parametres_pk_parametres_seq; Type: SEQUENCE; Schema: tables_types; Owner: -
--

CREATE SEQUENCE parametres_pk_parametres_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2372 (class 0 OID 0)
-- Dependencies: 178
-- Name: parametres_pk_parametres_seq; Type: SEQUENCE OWNED BY; Schema: tables_types; Owner: -
--

ALTER SEQUENCE parametres_pk_parametres_seq OWNED BY parametre.pk_parametre;


--
-- TOC entry 179 (class 1259 OID 19363)
-- Name: type_role; Type: TABLE; Schema: tables_types; Owner: -; Tablespace: 
--

CREATE TABLE type_role (
    pk_type_role integer NOT NULL,
    nom text,
    autres_noms text,
    descriptif text,
    notes text,
    cle_objet_bhp character varying(20),
    date_mise_a_jour timestamp without time zone
);


--
-- TOC entry 180 (class 1259 OID 19369)
-- Name: type_role_pk_type_role_seq; Type: SEQUENCE; Schema: tables_types; Owner: -
--

CREATE SEQUENCE type_role_pk_type_role_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2373 (class 0 OID 0)
-- Dependencies: 180
-- Name: type_role_pk_type_role_seq; Type: SEQUENCE OWNED BY; Schema: tables_types; Owner: -
--

ALTER SEQUENCE type_role_pk_type_role_seq OWNED BY type_role.pk_type_role;


--
-- TOC entry 181 (class 1259 OID 19371)
-- Name: type_unite_connaissance; Type: TABLE; Schema: tables_types; Owner: -; Tablespace: 
--

CREATE TABLE type_unite_connaissance (
    pk_type_unite_connaissance integer NOT NULL,
    nom text,
    autres_noms text,
    descriptif text,
    notes text,
    cle_objet_bhp character varying(20),
    date_mise_a_jour timestamp without time zone,
    si_utilise boolean DEFAULT false,
    fk_categorie_uc integer,
    categorie_uc character varying(15)
);


--
-- TOC entry 182 (class 1259 OID 19378)
-- Name: type_unite_connaissance_pk_type_unite_connaissance_seq; Type: SEQUENCE; Schema: tables_types; Owner: -
--

CREATE SEQUENCE type_unite_connaissance_pk_type_unite_connaissance_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2374 (class 0 OID 0)
-- Dependencies: 182
-- Name: type_unite_connaissance_pk_type_unite_connaissance_seq; Type: SEQUENCE OWNED BY; Schema: tables_types; Owner: -
--

ALTER SEQUENCE type_unite_connaissance_pk_type_unite_connaissance_seq OWNED BY type_unite_connaissance.pk_type_unite_connaissance;


--
-- TOC entry 183 (class 1259 OID 19380)
-- Name: v_association_type_role_type_uc; Type: VIEW; Schema: tables_types; Owner: -
--

CREATE VIEW v_association_type_role_type_uc AS
 SELECT t1.pk_type_unite_connaissance, 
    t1.nom AS nom_type_uc, 
    t1.cle_objet_bhp AS tyin, 
    t1.categorie_uc, 
    t1.si_utilise, 
    t2.pk_associer_type_uc_type_role, 
    t2.descriptif, 
    t2.notes, 
    t3.pk_type_role, 
    t3.nom AS nom_role, 
    t3.cle_objet_bhp AS tyro
   FROM ((type_unite_connaissance t1
   JOIN associer_type_uc_type_role t2 ON ((t2.fk_type_uc = t1.pk_type_unite_connaissance)))
   JOIN type_role t3 ON ((t3.pk_type_role = t2.fk_type_role)));


--
-- TOC entry 184 (class 1259 OID 19385)
-- Name: v_types_sous_types_avec_noms; Type: VIEW; Schema: tables_types; Owner: -
--

CREATE VIEW v_types_sous_types_avec_noms AS
 SELECT t1.pk_associer_types_sous_types_objets, 
    t1.fk_type, 
    t2.nom AS type_objet, 
    t2.descriptif AS descriptif_type, 
    t1.fk_sous_type, 
    t3.nom AS sous_type_objet, 
    t3.descriptif AS descriptif_sous_type, 
    t1.si_standard
   FROM ((associer_types_sous_types_objets t1
   JOIN parametre t2 ON ((t2.pk_parametre = t1.fk_type)))
   JOIN parametre t3 ON ((t3.pk_parametre = t1.fk_sous_type)))
  ORDER BY t2.nom, t3.nom;


--
-- TOC entry 2219 (class 2604 OID 19389)
-- Name: pk_associer_type_uc_type_role; Type: DEFAULT; Schema: tables_types; Owner: -
--

ALTER TABLE ONLY associer_type_uc_type_role ALTER COLUMN pk_associer_type_uc_type_role SET DEFAULT nextval('associer_type_uc_type_role_pk_associer_type_uc_type_role_seq'::regclass);


--
-- TOC entry 2221 (class 2604 OID 19390)
-- Name: pk_associer_types_sous_types_objets; Type: DEFAULT; Schema: tables_types; Owner: -
--

ALTER TABLE ONLY associer_types_sous_types_objets ALTER COLUMN pk_associer_types_sous_types_objets SET DEFAULT nextval('associer_types_sous_types_pk_associer_types_sous_types_seq'::regclass);


--
-- TOC entry 2218 (class 2604 OID 19391)
-- Name: pk_parametre; Type: DEFAULT; Schema: tables_types; Owner: -
--

ALTER TABLE ONLY parametre ALTER COLUMN pk_parametre SET DEFAULT nextval('parametres_pk_parametres_seq'::regclass);


--
-- TOC entry 2222 (class 2604 OID 19392)
-- Name: pk_type_role; Type: DEFAULT; Schema: tables_types; Owner: -
--

ALTER TABLE ONLY type_role ALTER COLUMN pk_type_role SET DEFAULT nextval('type_role_pk_type_role_seq'::regclass);


--
-- TOC entry 2224 (class 2604 OID 19393)
-- Name: pk_type_unite_connaissance; Type: DEFAULT; Schema: tables_types; Owner: -
--

ALTER TABLE ONLY type_unite_connaissance ALTER COLUMN pk_type_unite_connaissance SET DEFAULT nextval('type_unite_connaissance_pk_type_unite_connaissance_seq'::regclass);


--
-- TOC entry 2356 (class 0 OID 19344)
-- Dependencies: 174
-- Data for Name: associer_type_uc_type_role; Type: TABLE DATA; Schema: tables_types; Owner: -
--

INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (163, 'Localise le lieu (principal) de production de l''ouvrage', NULL, 60, 'TyIn68', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (282, NULL, NULL, 88, 'TyIn98', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (283, 'Désigne l''entité auprès de laquelle la représentation est assurée.', NULL, 85, 'TyIn95', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (284, 'Permet d''associer un lieu (de type surface ou autre) qui indique éventuellement l''étendue du pouvoir. Préférer', NULL, 11, 'TyIn99', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (285, 'Un objet abstrait associé via ce rôle indique de quel type de pouvoir il s''agit : souveraineté', NULL, 11, 'TyIn99', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (286, 'Indique par un AbOb de quel type de rattachement il s''agit', NULL, 46, 'TyIn37', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (287, 'L''acteur ou acteur collectif qui exerce un pouvoir', NULL, 11, 'TyIn99', 12, 'TyRo12', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (288, 'L''acteur ou acteur collectif sur lequel porte le pouvoir', NULL, 11, 'TyIn99', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (289, 'Indique les thématiques traitées dans le manuscrit', NULL, 120, 'TyIn42', 97, 'TyRo97', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (290, 'Indique les thématiques traitées dans l''ouvrage imprimé', NULL, 1, 'TyIn3', 97, 'TyRo97', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (291, 'Indique le type de manuscrit. Vérifier si le type ne correpond pas déjà à une information (par ex. lettre)', NULL, 120, 'TyIn42', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (292, 'Indique de quel type d''imprimé il s''agit. Vérifier si un TyIn correspondant à ce type d''imprimé n''existe pas déjà.', NULL, 1, 'TyIn3', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (293, NULL, NULL, 89, 'TyIn101', 136, 'TyRo136', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (294, NULL, NULL, 89, 'TyIn101', 20, 'TyRo20', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (295, 'N''associer qu''un seul acteur par information, même si plusieurs acteurs ont annoté un même exemplaire !!!', NULL, 90, 'TyIn102', 137, 'TyRo137', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (140, NULL, NULL, 54, 'TyIn62', 77, 'TyRo77', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (141, NULL, NULL, 54, 'TyIn62', 7, 'TyRo7', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (307, 'Utiliser si le lieux précis est connu (cf. TyRo135)', NULL, 92, 'TyIn104', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (530, '<p>Associe les personnes directement et effectivement impliquées dans l''entretien.</p>
<p>Traiter avec d''autres Contenus les présents ou simples témoins </p>', '', 138, 'TyCo9', 169, 'TyRo169', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (531, '<p>Associe les personnes directement et effectivement impliquées dans l''entretien.</p>
<p>Traiter avec d''autres Contenus les présents ou simples témoins </p>', '', 145, 'TyCo6', 169, 'TyRo169', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (532, '<p>Permet d''associer l''objet concerné par l''entretien (il peut donc s''agir de tout type d''objet, y compris des Informations)</p>', '', 145, 'TyCo6', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (534, '<p>Renseigne, grâce à l''utilisation d''un objet abstrait, la typologie de l''entretien : entrevue, audience officielle, etc.</p>', '', 145, 'TyCo6', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (535, '<p>L''objet concerné par l''opinion (Acteur, doctrine, etc.).</p>', '', 136, 'TyCo2', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (537, '<p>L''acteur ou l''institution qui exprime une opinion à l''égard de l''objet en question</p>', '', 136, 'TyCo2', 110, 'TyRo110', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (538, '<p>Indique les objets concernés au premier chef par le contenu en question.</p>', '', 137, 'TyCo3', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (539, '<p>Grâce à l''association d''un AbOb opportun, on indique ici de quel type d''opinion il s''agit.</p>
<p>ATTENTION : un seul type d''opinion par Contenu !</p>', '', 136, 'TyCo2', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (1, 'Ce rôle ne doit être renseigné que si on connaît l''objet matériel concret ''lettre''. <br/>
Si on connaît l''existence de la lettre par une autre source, ou par la bibliographie, le TyRo3 ne doit pas être renseigné.', NULL, 132, 'TyIn1', 3, 'TyRo3', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (2, 'On renseigne par ce rôle le lieu de rédaction ou de datation de la lettre, c''est-à-dire le lieu qu''on souhaite voir représenté sur une carte.
/ S''il faut mentionner un autre lieu (prétendu lieu de rédaction, etc.), on peut associer l''autre lieu via une ligne rôle non codée et indiquer dans les notes la raison de l''association', NULL, 132, 'TyIn1', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (3, 'Le destinatare et/ou le lieu où il se trouve (reconstitué par l''historien)', NULL, 132, 'TyIn1', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (4, 'Un acteur individuel ou collectif, ou les deux, tout en spécifiant dans les remarques les particularités de l''association', NULL, 110, 'TyIn2', 1, 'TyRo1', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (5, 'Organisme auquel est destinée la censure', NULL, 110, 'TyIn2', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (6, '/ S''il est connu, on peut renseigner le manuscrit original ou l''imprimé de la censure en tant que MaOb
/ Si plusieurs copies ou imprimés de la censure sont connus, on peut les regrouper dans une information ''oeuvre'' (TyIn27), associant l''auteur et les exempmaires connus, puis associer cette information à la censure via le TyRo3', NULL, 110, 'TyIn2', 3, 'TyRo3', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (142, NULL, NULL, 54, 'TyIn62', 88, 'TyRo88', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (143, 'Permet de localiser l''institution au moment de sa fondation.', NULL, 119, 'TyIn30', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (144, '<p>L''auteur de l''autographe</p>', '', 52, 'TyIn56', 1, 'TyRo1', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (7, 'Ce rôle peut associer la censure à un ouvrage imprimé (objet : bibliographie), à une oeuvre (si, par exemple, on ne sait pas quelle est l''édition censurée), à un manuscrit, ou encore un exemplaire particulier d''imprimé, si on sait quel objet matériel le censeur avait entre ses mains (dans ce cas il faut renseigner également l''oeuvre ou l''ouvrage imprimé), ou encore à une doctirne (AbOb)', NULL, 110, 'TyIn2', 4, 'TyRo4', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (8, '/ Il ne faut renseigner que les lieux principaux et effectifs de publication, ceux qu''on aimerait voir figurer sur une carte.
/ Si l''éditeur est présent dans plusieurs villes, ceci pourra être indiqué dans une information concernant la domiciliation de l''acteur collectif ''éditeur''.', NULL, 1, 'TyIn3', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (9, 'Maison d''éditon ou personne s''occupant de l''impression et de la diffusion d''un ouvrage (publisher). Attention: différent de l''editeur scientifique et de l''imprimeur', NULL, 1, 'TyIn3', 69, 'TyRo69', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (10, NULL, NULL, 4, 'TyIn8', 14, 'TyRo14', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (11, NULL, NULL, 4, 'TyIn8', 15, 'TyRo15', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (12, NULL, NULL, 4, 'TyIn8', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (13, NULL, NULL, 4, 'TyIn8', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (14, NULL, NULL, 5, 'TyIn9', 17, 'TyRo17', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (15, NULL, NULL, 5, 'TyIn9', 18, 'TyRo18', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (16, NULL, NULL, 5, 'TyIn9', 20, 'TyRo20', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (17, NULL, NULL, 5, 'TyIn9', 23, 'TyRo23', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (18, NULL, NULL, 5, 'TyIn9', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (19, NULL, NULL, 5, 'TyIn9', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (20, NULL, NULL, 6, 'TyIn10', 20, 'TyRo20', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (21, NULL, NULL, 6, 'TyIn10', 63, 'TyRo63', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (22, NULL, NULL, 6, 'TyIn10', 64, 'TyRo64', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (23, NULL, NULL, 9, 'TyIn12', 2, 'TyRo2', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (24, NULL, NULL, 9, 'TyIn12', 39, 'TyRo39', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (25, 'Les acteurs s''unissant (maximum 2 !)', NULL, 7, 'TyIn13', 44, 'TyRo44', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (162, 'Utiliser ce rôle pour spécifier de quel type d''union il s''agit (par ex. d''un ''mariage'': AbOb27).<br/>Si, en revanche, on veut renseigner l''évènement mariage, comme cérémonie, ou comme fait juridique, il faudra créer une information spécifique.', NULL, 7, 'TyIn13', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (258, NULL, NULL, 84, 'TyIn94', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (259, NULL, NULL, 84, 'TyIn94', 70, 'TyRo70', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (26, 'La personne qui naît', NULL, 134, 'TyIn14', 40, 'TyRo40', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (27, 'Utiliser pour fournir une localisation précise de la naissance : lieu habité, bâtiment, etc. (on peut utiliser ce rôle pour associer des NaPl ou des ImCo)', NULL, 134, 'TyIn14', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (28, 'Localise la localité et/ou le bâtiment où est célébré le baptême.', NULL, 128, 'TyIn15', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (29, 'Désigne le ou les acteurs qui donnent leur signature en tant que témoins.', NULL, 128, 'TyIn15', 77, 'TyRo77', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (30, 'Désigne le célébrant (prêtre, pasteur, ministre, etc.)', NULL, 128, 'TyIn15', 78, 'TyRo78', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (31, NULL, NULL, 13, 'TyIn16', 19, 'TyRo19', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (32, NULL, NULL, 13, 'TyIn16', 31, 'TyRo31', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (33, NULL, NULL, 14, 'TyIn17', 20, 'TyRo20', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (34, NULL, NULL, 14, 'TyIn17', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (35, NULL, NULL, 14, 'TyIn17', 23, 'TyRo23', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (36, NULL, NULL, 14, 'TyIn17', 32, 'TyRo32', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (37, NULL, NULL, 14, 'TyIn17', 66, 'TyRo66', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (38, NULL, NULL, 15, 'TyIn18', 20, 'TyRo20', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (39, NULL, NULL, 15, 'TyIn18', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (40, NULL, NULL, 15, 'TyIn18', 23, 'TyRo23', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (41, NULL, NULL, 15, 'TyIn18', 33, 'TyRo33', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (42, NULL, NULL, 15, 'TyIn18', 66, 'TyRo66', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (43, NULL, NULL, 16, 'TyIn19', 22, 'TyRo22', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (47, NULL, NULL, 18, 'TyIn21', 27, 'TyRo27', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (48, 'Indique la confession chrétienne dans laquelle le baptême est administré.', NULL, 128, 'TyIn15', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (49, '<p>Associe l''acteur ou l''organisme qui exerce la fonction</p>', '', 122, 'TyIn7', 12, 'TyRo12', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (468, 'Pour définir les objets (matériels, abstraits, etc.) sur lesquels porte la décision.', NULL, 117, 'TyIn125', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (51, '<p>Associe l''organisme concerné par l''exercice de la fonction, par ex. le tribunal auprès duquel l''acteur exerce la fonction de juge</p>', '', 122, 'TyIn7', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (52, '<p>Associe le charactère social ou fonction institutionnelle (les deux étant des SoCh) qui sont exercés</p>', '', 122, 'TyIn7', 47, 'TyRo47', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (53, '<p>L''auteur de l''ouvrage</p>', '', 1, 'TyIn3', 1, 'TyRo1', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (54, '<p>L''ouvrage lui même. En règle générale, il s''agit d''un objet de type Bibl.</p>', '', 1, 'TyIn3', 3, 'TyRo3', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (164, NULL, NULL, 60, 'TyIn68', 1, 'TyRo1', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (55, '<p>L''éditeur scientifique de l''ouvrage, qui se charge de faire imprimer le texte d''un autre auteur, par ex. dans le cas d''un ouvrage publié à titre posthume.</p>', '', 1, 'TyIn3', 46, 'TyRo46', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (56, '<p>L''acteur qui est nommé.</p>
<p>Attention : ne pas renseigner dans le cas d''une information qui hérites ce rôle d''une autre [cf. type de rôle ''objet (être l'')'' ]. </p>', '', 131, 'TyIn6', 11, 'TyRo11', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (57, NULL, NULL, 18, 'TyIn21', 25, 'TyRo25', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (58, NULL, NULL, 19, 'TyIn22', 5, 'TyRo5', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (59, NULL, NULL, 19, 'TyIn22', 20, 'TyRo20', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (60, NULL, NULL, 19, 'TyIn22', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (61, NULL, NULL, 20, 'TyIn23', 20, 'TyRo20', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (62, NULL, NULL, 20, 'TyIn23', 34, 'TyRo34', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (63, NULL, NULL, 20, 'TyIn23', 36, 'TyRo36', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (64, NULL, NULL, 20, 'TyIn23', 37, 'TyRo37', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (65, NULL, NULL, 22, 'TyIn25', 20, 'TyRo20', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (66, NULL, NULL, 22, 'TyIn25', 35, 'TyRo35', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (67, NULL, NULL, 22, 'TyIn25', 36, 'TyRo36', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (68, NULL, NULL, 22, 'TyIn25', 37, 'TyRo37', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (70, NULL, NULL, 25, 'TyIn26', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (71, NULL, NULL, 130, 'TyIn27', 1, 'TyRo1', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (72, NULL, NULL, 23, 'TyIn28', 43, 'TyRo43', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (73, NULL, NULL, 23, 'TyIn28', 20, 'TyRo20', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (74, NULL, NULL, 23, 'TyIn28', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (75, NULL, NULL, 24, 'TyIn29', 48, 'TyRo48', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (76, NULL, NULL, 24, 'TyIn29', 20, 'TyRo20', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (77, NULL, NULL, 8, 'TyIn31', 51, 'TyRo51', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (78, NULL, NULL, 8, 'TyIn31', 49, 'TyRo49', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (79, NULL, NULL, 111, 'TyIn32', 52, 'TyRo52', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (80, NULL, NULL, 111, 'TyIn32', 53, 'TyRo53', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (81, NULL, NULL, 111, 'TyIn32', 68, 'TyRo68', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (82, NULL, NULL, 27, 'TyIn33', 54, 'TyRo54', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (83, NULL, NULL, 27, 'TyIn33', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (84, NULL, NULL, 28, 'TyIn34', 7, 'TyRo7', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (85, NULL, NULL, 28, 'TyIn34', 55, 'TyRo55', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (86, NULL, NULL, 29, 'TyIn35', 56, 'TyRo56', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (87, 'Objet ou information (Info) à localiser', NULL, 30, 'TyIn36', 57, 'TyRo57', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (88, 'Attention : cardinalité maximale 1 = une fiche TyIn par lieu ou immeuble ; utiliser si le lieux précis est connu (cf. TyRo135)', NULL, 30, 'TyIn36', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (89, NULL, NULL, 46, 'TyIn37', 58, 'TyRo58', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (90, NULL, NULL, 46, 'TyIn37', 59, 'TyRo59', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (91, NULL, NULL, 31, 'TyIn38', 60, 'TyRo60', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (92, NULL, NULL, 32, 'TyIn39', 43, 'TyRo43', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (93, NULL, NULL, 32, 'TyIn39', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (97, NULL, NULL, 120, 'TyIn42', 1, 'TyRo1', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (98, 'Le MaOb correspondant au manuscrit', NULL, 120, 'TyIn42', 3, 'TyRo3', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (99, 'Localise la rédaction d''un manuscrit', NULL, 120, 'TyIn42', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (100, NULL, NULL, 35, 'TyIn43', 61, 'TyRo61', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (101, NULL, NULL, 36, 'TyIn44', 61, 'TyRo61', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (102, NULL, NULL, 37, 'TyIn45', 61, 'TyRo61', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (103, NULL, NULL, 38, 'TyIn46', 61, 'TyRo61', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (104, NULL, NULL, 40, 'TyIn48', 20, 'TyRo20', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (105, NULL, NULL, 40, 'TyIn48', 64, 'TyRo64', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (106, NULL, NULL, 40, 'TyIn48', 63, 'TyRo63', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (107, NULL, NULL, 41, 'TyIn49', 20, 'TyRo20', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (108, NULL, NULL, 41, 'TyIn49', 65, 'TyRo65', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (109, NULL, NULL, 41, 'TyIn49', 67, 'TyRo67', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (110, NULL, NULL, 42, 'TyIn50', 20, 'TyRo20', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (111, NULL, NULL, 42, 'TyIn50', 5, 'TyRo5', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (112, NULL, NULL, 113, 'TyIn51', 70, 'TyRo70', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (113, NULL, NULL, 113, 'TyIn51', 71, 'TyRo71', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (137, 'Biens qui sont l''objet de la vente', NULL, 53, 'TyIn61', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (114, NULL, NULL, 113, 'TyIn51', 72, 'TyRo72', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (115, NULL, NULL, 43, 'TyIn52', 73, 'TyRo73', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (116, NULL, NULL, 43, 'TyIn52', 74, 'TyRo74', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (117, NULL, NULL, 43, 'TyIn52', 75, 'TyRo75', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (118, NULL, NULL, 43, 'TyIn52', 13, 'TyRo13', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (119, NULL, NULL, 48, 'TyIn57', 1, 'TyRo1', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (120, NULL, NULL, 48, 'TyIn57', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (121, 'Spécifie la localité ou le bâtiment où à lieu la cérémonie', NULL, 51, 'TyIn58', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (361, 'Précise le genre : nature morte, paysage, portrait', NULL, 60, 'TyIn68', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (123, 'Spécifie le type de cérémonie (baptême, messe, cène,etc.) d''une part, le type de rite d''autre part (catholique, luthérien, orthodoxe, etc.)', NULL, 51, 'TyIn58', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (126, NULL, NULL, 49, 'TyIn59', 74, 'TyRo74', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (127, NULL, NULL, 49, 'TyIn59', 81, 'TyRo81', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (128, 'Actr qui est à l''origine de la demande', NULL, 50, 'TyIn60', 80, 'TyRo80', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (129, 'Désigne la catégorie de funérailles : simples, baroques, etc', NULL, 50, 'TyIn60', 82, 'TyRo82', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (130, 'Actr ou CoAc dont la présence est demandée : pauvres, confréries, etc.', NULL, 50, 'TyIn60', 83, 'TyRo83', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (131, 'Actr dont la présence n''est pas souhaitée', NULL, 50, 'TyIn60', 84, 'TyRo84', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (132, 'Spécifie le célébrant : inidividu particulier, religieux de tel ordre, etc.', NULL, 50, 'TyIn60', 85, 'TyRo85', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (133, 'Spécifie le lieu où les funérailles devront être célébrées : paroisse, monastère, etc.', NULL, 50, 'TyIn60', 86, 'TyRo86', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (134, 'Actr ou Coac qui vend', NULL, 53, 'TyIn61', 17, 'TyRo17', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (135, 'Actr ou Coac qui achète', NULL, 53, 'TyIn61', 18, 'TyRo18', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (136, NULL, NULL, 53, 'TyIn61', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (202, 'Ce type de rôle permet de désigner la personne qui est affectée par exemple dans un régiment.', NULL, 68, 'TyIn77', 116, 'TyRo116', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (203, 'Ce type de rôle sert à désigner le lieux dans lequel se situe le régiment ou le poste d''affectation.', NULL, 68, 'TyIn77', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (204, 'Ce type de rôle sert à désigner l''unité dans laquelle est incorporé un militaire (par exemple un régiment).', NULL, 68, 'TyIn77', 108, 'TyRo108', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (205, '/Ce type de rôle sert à désigner l''individu dont le caractère physique est décrit.
/Il sert également à désigner la partie du corps sur laquelle porte la description (par exemple: dos).', NULL, 69, 'TyIn78', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (206, 'Ce type de rôle sert à désigner l''objet sur lequel porte l''avis ou le jugement', NULL, 123, 'TyIn79', 109, 'TyRo109', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (207, 'Ce type de rôle sert à qualifier la justification de l''avis', NULL, 123, 'TyIn79', 72, 'TyRo72', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (208, 'Ce type de rôle sert à désigner la personne ou l''acteur collectif (par exemple une commission) ou la fonction sociale ( par exemple un directeur) qui formule l''avis.', NULL, 123, 'TyIn79', 110, 'TyRo110', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (209, NULL, NULL, 70, 'TyIn80', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (210, NULL, NULL, 70, 'TyIn80', 111, 'TyRo111', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (211, NULL, NULL, 70, 'TyIn80', 112, 'TyRo112', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (212, 'Ce type de rôle sert à qualifier la personne qui rédige l''inscription dans le registre', NULL, 71, 'TyIn81', 113, 'TyRo113', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (213, 'Ce type de rôle sert à qualifier l''acteur qui fait l''objet de l''inscription.', NULL, 71, 'TyIn81', 114, 'TyRo114', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (214, 'Soit  la partie du monastère où lieu la profession, soit la localité lorsqu''on ignore le nom du monastère', NULL, 72, 'TyIn82', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (215, 'Soit un ordre ou  une congrégation lorsqu''on ignore la maison précise, soit lune communauté religieuse précise dont la fiche CoAc définit l''ordre d''appartenance', NULL, 72, 'TyIn82', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (216, 'Acteur qui préside à la cérémonie.', NULL, 72, 'TyIn82', 55, 'TyRo55', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (217, 'Supérieur(e) qui reçoit les voeux', NULL, 72, 'TyIn82', 70, 'TyRo70', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (218, 'Religieux(se) qui signe l''acte de profession comme témoin', NULL, 72, 'TyIn82', 77, 'TyRo77', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (219, 'Religieux(se) qui prononce ses voeux et en signe l''acte', NULL, 72, 'TyIn82', 115, 'TyRo115', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (220, 'Ce type de rôle sert à qualifier la personne qui fait l''objet de l''affectation', NULL, 73, 'TyIn83', 116, 'TyRo116', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (221, 'Ce type de rôle sert à qualifier la fonction sociale (exemple : métier) ou la fonction institutionnelle à laquelle sera affectée la personne qui fait l''objet de l''affectation.', NULL, 73, 'TyIn83', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (222, 'Ce type de rôle sert à qualifier la personne qui décide de l''affectation. Si on ne connaît pas précisément cette dernière il peut qualifer un acteur collectif (par exemple un service) ou une fonction institutionnelle qui décide de l''affectation (par exemple : chef de service ou chef d''atelier).', NULL, 73, 'TyIn83', 117, 'TyRo117', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (223, 'Ce type d''information  peut servir à associer une information qui justifie l''affectation (par exemple une embauche en cas de première affectation).', NULL, 73, 'TyIn83', 72, 'TyRo72', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (224, 'Ce type de rôle sert à qualifier la personne qui abondonne son cursus scolaire', NULL, 74, 'TyIn84', 118, 'TyRo118', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (226, 'Ce type de rôle sert à qualifier l''établissement dans lequel le cursus scolaire s''effectuait jusqu''à son abandon et/ou le niveau d''enseignement auquel l''abandon de scolarité a été enregistrer (par exemple : terminale, 1ère année de BTS...). La distinction est permise par la nature de l''objet associé.', NULL, 74, 'TyIn84', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (227, 'Ce type de rôle désigne la personne qui obtient la moyenne.', NULL, 75, 'TyIn85', 37, 'TyRo37', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (228, 'Ce type de rôle sert d''abord à associer l''information de TyIn 85 à une information de TyIn96 ''Suivre une formation'' qui permet de connaître l''établissement et ensuite la classe (CoAc) dans laquelle se trouve l''élève ou l''étudiant qui obtient la moyenne', NULL, 75, 'TyIn85', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (229, 'ce type de rôle sert à qualifier le type de moyenne (moyenne annuelle, moyenne trimestrielle...) grâce à un AbOb.', NULL, 75, 'TyIn85', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (225, 'Ce type de rôle sert à qualifier la cause de l''abandon.', NULL, 74, 'TyIn84', 72, 'TyRo72', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (230, 'Attention ne plus utilser ce type de rôle. Créer une information ''présence'' (TyIn104) qui sera associée à l''information réception mondaine par le type de rôle &quot;', NULL, 77, 'TyIn87', 7, 'TyRo7', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (231, 'Ce type de rôle sert à désigner le lieux où se déroule la réception. S''il s''agit de l''adresse des organisateurs et que celle-ci a donné lieu à la création d''une information de type ''localisation'' (TyIn36) on associe cette information à l''information ''réception mondaine'', sinon associer un NaPl.', NULL, 77, 'TyIn87', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (232, 'Ce type de rôle sert à qualifier la nature de la réception mondaine (par exemple : soirée dansante, bal masqué etc.)', NULL, 77, 'TyIn87', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (165, 'Précise le type de représentation : tableau, dessin, statue, etc. Le type est en principe obligatoire.', NULL, 60, 'TyIn68', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (233, 'Ce type de rôle sert à désigner le ou les organisateurs de la réception.', NULL, 77, 'TyIn87', 119, 'TyRo119', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (234, 'NE PLUS UTILISER POUR CE TYIN CREER UNE INFO DE TYPE ''INVITATION'' (TyIn114)', NULL, 77, 'TyIn87', 120, 'TyRo120', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (235, 'NE PLUS UTILISER POUR CE TYIN CREER UNE INFO DE TYPE ''INVITATION'' (TyIn114)', NULL, 77, 'TyIn87', 121, 'TyRo121', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (236, 'ISupérieur(e) qui confirme la validité de la profession', NULL, 72, 'TyIn82', 122, 'TyRo122', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (238, 'Ce type de rôle sert à désigner l''individu qui effectue son service militaire actif.', NULL, 78, 'TyIn88', 123, 'TyRo123', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (239, 'Associe le contrat de fermage au TyIn62 ''passage d''un acte notarié''. Le fermage type l''acte notarié', NULL, 79, 'TyIn89', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (423, 'Permet de qualifier la fonction sociale ou la fonction institutionnelle dans laquelle quelqu''un est réintégré.', NULL, 107, 'TyIn122', 13, 'TyRo13', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (457, 'Celui ou celle à qui est dûe la somme en question (qu''il s''agisse d''un prêt, d''une vente, etc.)', NULL, 114, 'TyIn126', 99, 'TyRo99', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (458, 'Permet de définir les objets matériels et/ou abstraits concernés.', NULL, 115, 'TyIn128', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (460, 'Permet de préciser la nature de la procédure en question.', NULL, 115, 'TyIn128', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (461, '', NULL, 115, 'TyIn128', 168, 'TyRo168', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (462, 'Demandeur : « Celui, celle qui introduit une demande en justice » [http://www.cnrtl.fr/definition/demandeur]', NULL, 115, 'TyIn128', 80, 'TyRo80', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (463, 'Celui ou celle qui émet la requête.', NULL, 116, 'TyIn129', 16, 'TyRo16', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (464, 'Celui ou celle qui reçoit la requête en question', NULL, 116, 'TyIn129', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (465, 'Permet de définir la nature des objets (matériels et/ou abstraits) sur lesquels porte l''acte.', NULL, 116, 'TyIn129', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (466, 'Celui ou celle qui prononce la décision', NULL, 117, 'TyIn125', 167, 'TyRo167', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (467, 'Celui ou celle qui est l''objet de la décision', NULL, 117, 'TyIn125', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (309, NULL, NULL, 93, 'TyIn105', 139, 'TyRo139', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (310, 'En quelle qualité la personne/institution aurait été présente', NULL, 93, 'TyIn105', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (311, 'Evénement ou AbOb qui justifie l''absence (par ex. maladie)', NULL, 93, 'TyIn105', 72, 'TyRo72', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (312, 'Utiliser si on veut retenir l''information que telle personne était absente de tel lieu à tel moment', NULL, 93, 'TyIn105', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (313, 'A utiliser en lien avec le rôle ''qualifier'' : par ex.,', NULL, 93, 'TyIn105', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (314, 'Indique la technique (huile, crayon, etc.)', NULL, 60, 'TyIn68', 147, 'TyRo147', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (320, 'Le manuscrit, l''ouvrage, etc. qui est regroupé dans cette oeuvre, dont il est l''une des expressions', NULL, 130, 'TyIn27', 2, 'TyRo2', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (321, NULL, NULL, 94, 'TyIn107', 128, 'TyRo128', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (322, 'Indique la technique', NULL, 94, 'TyIn107', 147, 'TyRo147', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (323, NULL, NULL, 94, 'TyIn107', 1, 'TyRo1', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (324, 'Le lieu où est effectuée l''estimation', NULL, 26, 'TyIn20', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (325, 'Le destinataire de l''estimation (individuel ou collectif)', NULL, 26, 'TyIn20', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (326, 'Indique la raison, le contexte de l''estimation : vente, inventaire après décès, etc.', NULL, 26, 'TyIn20', 72, 'TyRo72', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (327, 'Associe l''objet abstrait qui représente le critère principal de définition de la collection', NULL, 95, 'TyIn108', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (328, 'Associe l''objet (acteur, institution, etc.) concerné par la collection (hors possession)', NULL, 95, 'TyIn108', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (398, '/ spécifie l''Actr ou le CoAc aui effectue la pirère', NULL, 102, 'TyIn116', 153, 'TyRo153', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (331, 'Associe les objets ou informations (par ex. des sous-collections) appartenant à la collection', NULL, 95, 'TyIn108', 2, 'TyRo2', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (332, 'L''objet principalement concerné, qui joue le rôle principal dans la définition de l''objet abstrait composé', NULL, 96, 'TyIn109', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (333, 'L''objet qui caractérise, ajoute des spécifications à l''objet principal (plusieurs objets possibles, créer plusieurs lignes)', NULL, 96, 'TyIn109', 140, 'TyRo140', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (336, 'Le sujet représenté en termes de concept (AbOb), le sujet concret étant déjà renseigné par le TyRo128', NULL, 94, 'TyIn107', 97, 'TyRo97', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (337, 'Représentation (info) ou objet (MaOb) ayant donné lieu à représentation multiple : par ex., des gravures (multiples) tirées d''une peinture (unique)', NULL, 94, 'TyIn107', 16, 'TyRo16', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (338, 'Lorsque l''éducation se déroule toute entière dans le même lieu, ce rôle associe un lieu (NaPl). Lorsqu''elle se déroule successivement dans plusieurs lieux, ce rôle associe l''information &quot;Localiser&quot; (TyIn08) : créer autant de fiches Infomration qu''il y aura de localisation sucessives.', NULL, 97, 'TyIn110', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (339, 'Désigne la personne qui est éduquée', NULL, 97, 'TyIn110', 13, 'TyRo13', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (340, 'Précise une formation donnée dans le cadre de l''éducation indépendamment d''un cadre scolaire', NULL, 97, 'TyIn110', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (341, 'Concerne l''acteur ou l''acteur collectif qui attribue la charge effective de l''éducation à un acteur ou acteur collectif', NULL, 97, 'TyIn110', 144, 'TyRo144', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (342, 'Désigne l''acteur ou l''acteur collectif  qui a la charge d''éduquer', NULL, 97, 'TyIn110', 145, 'TyRo145', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (343, 'Désigne le rituel utilisé pour le baptême : aspersion, infusion, immersion.', NULL, 128, 'TyIn15', 140, 'TyRo140', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (344, 'Il s''agit de l''auteur du texte de la dédicace', NULL, 135, 'TyIn111', 1, 'TyRo1', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (345, 'Le commanditaire de la dédicace', NULL, 135, 'TyIn111', 16, 'TyRo16', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (346, 'Le destinataire de la dédicace', NULL, 135, 'TyIn111', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (347, 'Le genre auquel appartient le texte de la dédicace: poème, etc.', NULL, 135, 'TyIn111', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (348, 'Auteur du document manuscrit (Actr, CoAc, SoCh)', NULL, 121, 'TyIn131', 1, 'TyRo1', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (349, 'Indique par un AbOb le type du document manuscrit. Un seul type par document.', NULL, 121, 'TyIn131', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (350, 'Indique l''objet concerné par le document. Tout type d''objet peut être associé. Si plusieurs objets sont associés, on peut indiquer avec le qualificatif du rôle quel est l''objet principal.', NULL, 121, 'TyIn131', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (351, 'Permet d''associer des personnes ayant contribué à la rédaction ou à la produciton de l''ouvrage sans pouvoir être qualifiés d''auteur', NULL, 1, 'TyIn3', 146, 'TyRo146', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (352, 'Indique le support matériel de la représentation', NULL, 94, 'TyIn107', 148, 'TyRo148', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (315, 'Dans ce contexte, il s''agit de la localisation de l''objet au moment de rédaction de l''inventaire', NULL, NULL, 'TyIn106', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (316, NULL, NULL, NULL, 'TyIn106', 1, 'TyRo1', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (317, 'Précise le genre : nature morte, paysage, portrait', NULL, NULL, 'TyIn106', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (318, 'Le sujet représenté : personnage, ville, objet, etc.', NULL, NULL, 'TyIn106', 97, 'TyRo97', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (319, 'Précise le type de représentation : tableau, estampe, statue,etc.', NULL, NULL, 'TyIn106', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (166, NULL, NULL, 60, 'TyIn68', 3, 'TyRo3', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (334, NULL, NULL, 96, 'TyIn109', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (237, NULL, NULL, 72, 'TyIn82', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (353, NULL, NULL, 60, 'TyIn68', 148, 'TyRo148', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (354, NULL, NULL, 47, 'TyIn55', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (355, NULL, NULL, 47, 'TyIn55', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (360, 'Précise le type de représentation : photo, estampe, représentation cartographique, etc.', NULL, 94, 'TyIn107', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (362, '/ Précise le type d''événement à l''aide d''un Objet abstrait (AbOb). ATTENTION: un seul type par événement !', NULL, 58, 'TyIn66', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (363, '/ Permet d''associer un événement à une ou plusieurs classes, définies par des Objets abstraits (AbOb)', NULL, 58, 'TyIn66', 141, 'TyRo141', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (364, 'Associe l''obligation au TyIn62 ''passage d''un acte notarié''. L''obligation type l''acte notarié.', NULL, 63, 'TyIn72', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (365, 'Associe la procuration au TyIn62 ''passage d''un acte notarié''. La procuration type l''acte notarié', NULL, 61, 'TyIn70', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (366, 'Ce type de rôle sert à désigner l''information de type Service militaire (TyIn88) qui est à l''origine de l''affectation militaire.', NULL, 68, 'TyIn77', 72, 'TyRo72', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (367, 'Ce type de rôle sert à désigner, si nécessaire,  le trait physique notable (par exemple : bosse)', NULL, 69, 'TyIn78', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (368, 'ce type de rôle sert à qualifier l''avis (par exemple favorable, défavorable...)', NULL, 123, 'TyIn79', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (370, NULL, NULL, 100, 'TyIn114', 121, 'TyRo121', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (371, 'Ce type de rôle sert à désigner l''événement pour lequel l''invitation a été formulée. Si cet événement a fait l''objet d''une fiche information (par exemple de type &quot;réception mondaine&quot;) il sera associé à la l''information &quot;invitation&quot;. Si l''on désire simplement qualifier le type d''événement qui est à l''origine de l''invitation on utilisera un objet abstrait (par exemple : réception, repas, remise de médaille etc.)', NULL, 100, 'TyIn114', 150, 'TyRo150', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (372, 'Ce type de rôle sert à qualifier la discipline (AbOb) pour laquelle la moyenne a été obtenue.', NULL, 75, 'TyIn85', 134, 'TyRo134', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (373, 'Ce type de rôle sert à associer l''information ''réception mondaine'' à l''information ''invitation'' (TyIn114) qui a annoncé la réception.', NULL, 77, 'TyIn87', 150, 'TyRo150', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (374, 'Ce type de rôle sert à associer les informations ''présence'' concernant les participants à la réception avec l''information ''réception''. Ceci permet de connâitre la liste des participants à la réception.', NULL, 77, 'TyIn87', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (375, '/ spécifie le lieu (de type ImCo) ou se déroule le chant', NULL, 99, 'TyIn113', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (376, '/', NULL, 99, 'TyIn113', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (377, '/  spécifie le type de chant', NULL, 99, 'TyIn113', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (378, '/ spécifie le contexte qui donne lieu au chant (AbOb ou TyIn)', NULL, 99, 'TyIn113', 138, 'TyRo138', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (379, '/ spécifie le moment (de la journée) où a lieu le chant', NULL, 99, 'TyIn113', 149, 'TyRo149', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (380, '/ spécifie l''Actr ou le CoAc impliqués dans le chant', NULL, 99, 'TyIn113', 151, 'TyRo151', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (44, 'L''objet concerné par l''estimation', NULL, 26, 'TyIn20', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (45, 'L''auteur de l''estimation (individuel ou collectif)', NULL, 26, 'TyIn20', 26, 'TyRo26', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (46, NULL, NULL, 18, 'TyIn21', 20, 'TyRo20', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (382, '/  spécifie le contexte ou la cause directe (TyIn ou AbOb) qui expliquent la maladie', NULL, 98, 'TyIn112', 16, 'TyRo16', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (383, '/ spécifie l''Actr ou le CoAc concernés par la maladie', NULL, 98, 'TyIn112', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (384, '/ spécifie la nom de la maladie', NULL, 98, 'TyIn112', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (385, '/ spécifie les symptômes de la maladie', NULL, 98, 'TyIn112', 140, 'TyRo140', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (386, '/  spécifie l''Actr ou le CoAc qui a l''initiative du don', NULL, 101, 'TyIn115', 16, 'TyRo16', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (387, '/ spécifie l''Actr ou le CoAc qui reçoit le don', NULL, 101, 'TyIn115', 70, 'TyRo70', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (388, '/ spécifie la nature du don', NULL, 101, 'TyIn115', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (476, 'Associe l''acte lui-même (MaOb ou DoUn)', NULL, 121, 'TyIn131', 3, 'TyRo3', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (389, '/ spécifie l''Actr ou le CoAc qui effectue le don', NULL, 101, 'TyIn115', 152, 'TyRo152', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (390, '/ Spécifie les Actr et CoAc impliqués dans un événement', NULL, 58, 'TyIn66', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (391, '/ Localise l''événement', NULL, 58, 'TyIn66', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (392, '/ spécifie le lieu ou se déroule la prière', NULL, 102, 'TyIn116', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (393, '/ spécifie l''Actr ou le CoAc auquel est adressée la prière', NULL, 102, 'TyIn116', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (394, '/ spécifie le type ou le nom de la prière', NULL, 102, 'TyIn116', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (395, '/ spécifie l''occasion (TyIn ou AbOb) qui donne lieu à la prière', NULL, 102, 'TyIn116', 138, 'TyRo138', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (396, '/ spécifie la classe de prière : funéraire, de louange, etc', NULL, 102, 'TyIn116', 141, 'TyRo141', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (397, '/ spécifie le moment où a lieu la prière', NULL, 102, 'TyIn116', 149, 'TyRo149', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (399, '/ spécifie le lieu (NaPl ou ImCo) où a lieu la lecture', NULL, 103, 'TyIn117', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (400, '/ spécifie le destinataire d''une lecture à voix haute', NULL, 103, 'TyIn117', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (401, '/ spécifie le type de lecture : silencieuse, mentale, vocale, etc.', NULL, 103, 'TyIn117', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (402, '/ spécifie l''Actr qui effectue la lecture', NULL, 103, 'TyIn117', 154, 'TyRo154', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (403, '/ spécifie l''objet qui est lu : titre d''une oeuvre, édition précise, manuscrit, lettre, etc', NULL, 103, 'TyIn117', 155, 'TyRo155', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (356, 'Peinture à l''huile, aquarelle, eau-forte, etc.', NULL, NULL, 'TyIn106', 147, 'TyRo147', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (357, 'Indique le support matériel de la représentation (papier, toile, bois, etc.)', NULL, NULL, 'TyIn106', 148, 'TyRo148', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (358, 'L''objet concret (MaOb) ou une Info concernant un objet concret', NULL, NULL, 'TyIn106', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (359, 'Indique le propriétaire du bien au moment de l''inventaire', NULL, NULL, 'TyIn106', 43, 'TyRo43', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (404, '/ spécifie l''Actr ou le CoAc qui est l''auteur de la préface', NULL, 104, 'TyIn118', 1, 'TyRo1', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (406, '/ spécifie les thèmes abordés par l''auteur de la préface', NULL, 104, 'TyIn118', 97, 'TyRo97', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (407, '/ associe le TyIn ''préface'' à celui qui indique l''existence de l''ouvarge imprimé dans laquelle elle se trouve', NULL, 104, 'TyIn118', 138, 'TyRo138', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (408, '/ spécifie l''Actr qui est l''auteur du poème funéraire', NULL, 10, 'TyIn119', 1, 'TyRo1', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (409, '/ spécifie le destinataire du poème funéraire (Actr)', NULL, 10, 'TyIn119', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (410, '/ spécifie les thèmes abordés par l''auteur du poème funéraire', NULL, 10, 'TyIn119', 97, 'TyRo97', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (411, '/ spécifie s''il s''agit de prose ou de vers', NULL, 10, 'TyIn119', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (412, '/ spécifie la langue utilisée', NULL, 10, 'TyIn119', 140, 'TyRo140', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (413, '/spécifie l''auteur de l''éloge, qui peut être différent de l''auteur de l''ouvrage dans lequel l''éloge est inséré.', NULL, 105, 'TyIn120', 1, 'TyRo1', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (414, '/spécifie l''Actr ou le CoAc à qui est destiné l''éloge', NULL, 105, 'TyIn120', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (415, '/spécifie l''objet del ''éloge qui peut être une qualité morale, un acte, une manière d''exercer une fonction, etc...', NULL, 105, 'TyIn120', 13, 'TyRo13', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (416, '/spécfie l''ouvrage (MaOb, Bibl, ou TyIn) dans lequel est inclus l''éloge', NULL, 105, 'TyIn120', 29, 'TyRo29', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (417, '/spécfie l''événement qui donne lieu à l''éloge.', NULL, 105, 'TyIn120', 138, 'TyRo138', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (418, 'Cause de la démission (un objet abstrait ou une information)', NULL, 106, 'TyIn121', 72, 'TyRo72', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (419, 'Acteur collectif concerné par la démission', NULL, 106, 'TyIn121', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (420, 'fonction sociale ou fonction institutionnelle occupée à laquelle renonce l''acteur qui démissionne', NULL, 106, 'TyIn121', 13, 'TyRo13', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (421, 'désigne la personne ou l''acteur collectif qui démissionne', NULL, 106, 'TyIn121', 157, 'TyRo157', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (422, 'Permet de qualifier la justification de la réintégration', NULL, 107, 'TyIn122', 72, 'TyRo72', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (424, 'Permet de qualifier l''acteur collectif au sein duquel l''acteur collectif est réintégré (exemple : une administration une entreprise...)', NULL, 107, 'TyIn122', 158, 'TyRo158', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (425, 'Permet de désigner la personne qui est réintégrer', NULL, 107, 'TyIn122', 159, 'TyRo159', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (428, 'Désigner le fonctionnaire ou ou l''institution publique chargée de verser le traitement', NULL, 108, 'TyIn123', 71, 'TyRo71', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (429, 'permet de préciser le type de traitement (par exemple : fixe, éventuel etc.)', NULL, 108, 'TyIn123', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (430, 'La personne ou l''institution qui figure comme responsable du placard et de son contenu (Actr, CoAc ou SoCh)', NULL, 109, 'TyIn124', 1, 'TyRo1', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (431, 'L''objet rendu public par le placard (Info, AbOb)', NULL, 109, 'TyIn124', 161, 'TyRo161', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (432, 'L''acteur qui signe le placard en tant qu''auteur ou représentant de l''auteur (Actr, SoCh)', NULL, 109, 'TyIn124', 162, 'TyRo162', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (433, 'L''acteur ou l''institution qui authentifie le placard (Actr, CoAc ou SoCh)', NULL, 109, 'TyIn124', 163, 'TyRo163', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (434, 'Lieu de publication du placard', NULL, 109, 'TyIn124', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (435, 'La maison d''édition', NULL, 109, 'TyIn124', 69, 'TyRo69', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (436, 'L''imprimeur', NULL, 109, 'TyIn124', 164, 'TyRo164', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (437, 'L''organisme qui tient sa séance, en règle générale un CoAc ou, dans un cas plus générique ou non spécifiable, un AbOb', NULL, 28, 'TyIn34', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (439, 'METTRE DANS LE MCD. Permet d''associer l''Information (de type contrat ou autre) qui est à l''origine de la location', NULL, 62, 'TyIn71', 16, 'TyRo16', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (440, 'METTRE DANS LE MCD : association de l''info concernée par la présence', NULL, 92, 'TyIn104', 13, 'TyRo13', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (441, 'METTRE DANS LE MCD. Permet d''associer l''Information (de type contrat ou autre) qui est à l''origine de l''obligation', NULL, 63, 'TyIn72', 16, 'TyRo16', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (442, 'L''institution (CoAc) ou la fonction institutionnelle (SoCh) qui est créée', NULL, 119, 'TyIn30', 49, 'TyRo49', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (443, 'Celui ou celle qui est condamné au versement de l''amende.', NULL, 112, 'TyIn127', 165, 'TyRo165', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (444, 'Celui ou celle qui prononce le jugement.', NULL, 112, 'TyIn127', 167, 'TyRo167', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (445, 'Celui ou celle qui perçoit la recette de l''amende.', NULL, 112, 'TyIn127', 73, 'TyRo73', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (446, 'Permet de qualifier les raisons à l''origine de l''amende. On peut associer un Objet abstrait ou une autre Information.', NULL, 112, 'TyIn127', 72, 'TyRo72', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (447, 'Permet de spécifier la nature du litige ou du délit qui a occasionné l''amende.', NULL, 112, 'TyIn127', 138, 'TyRo138', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (448, 'Indique la personne ou l''acteur collectif ayant eu recours à la juridiction.', NULL, 112, 'TyIn127', 16, 'TyRo16', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (449, 'Désigne la qualité obtenue (SoCh).', NULL, 12, 'TyIn11', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (450, 'Désigne l''individu ou l''acteur collectif qui obtient la qualité.', NULL, 12, 'TyIn11', 37, 'TyRo37', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (477, 'Par défaut, le parrain et/ou la marraine sont considérés comme présents. 
Si on sait qu''ils ne le sont pas, créer une information de TyIn105 "Absence" et l''associer à celle du baptême via un rôle.
Si le parrain ou la marraine se font représenter lors du baptême, créer autant de fiches information de TyIn95 "Représentation" que de personnes représentées et les associer à l''information du baptême via un rôle.', NULL, 128, 'TyIn15', 76, 'TyRo76', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (479, '<p>Lieu de rédaction de l''autographe.</p>
<p><strong>Attention</strong> : ne pas confondre avec le lieu de conservations de l''autographe, qui est donné par la source de l''information (normalement un MaOb). </p>', '', 52, 'TyIn56', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (480, '<p>L''objet concerné par l''opinion exprimée. Il peut s''agir de plusieurs objets (Actr, CoAc, AbOb, MaOb, Bibl, etc.) pour une même opinion.</p>
<p>Tous les types d''objets, y compris d''autres inormations, sont virtuellement suceptibles d''être l''objet d''une opinion.</p>', '', 124, 'TyIn100', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (482, '<p>Le territoire qui est rattaché</p>', '', 127, 'TyIn133', 59, 'TyRo59', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (167, 'Le sujet représenté : femme, vieillard, tel acteur, ville, montagnes, etc.', NULL, 60, 'TyIn68', 97, 'TyRo97', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (138, NULL, NULL, 54, 'TyIn62', 87, 'TyRo87', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (483, '<p>Le territoire de rattachement</p>', '', 127, 'TyIn133', 58, 'TyRo58', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (484, '<p>Permet d''associer un objet abstrait qui indique le type du rattachement</p>', '', 127, 'TyIn133', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (485, '<p>Associe le lieu d''excercice de la fonction s''il est unique ou le lieu de début d''excercice.</p>
<p>Si les lieux d''excercice de la même fonction changent dans le temps, il faut créer des fiches Localisation (TyIn36) et associer l''information à localiser (Exercice de la fonction) avec le TyRo57 à l''Info de type Localisation</p>', '', 122, 'TyIn7', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (122, 'Spécifie le(s) célébrant(s)', NULL, 51, 'TyIn58', 78, 'TyRo78', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (525, 'Associe un objet abstrait qui indique la technique', NULL, 139, 'TyCo4', 147, 'TyRo147', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (526, 'Si on a la possibilité d''identifier l''objet sur lequel porte la description (MaOb ou ImCo), on l''associe avec ce rôle', NULL, 139, 'TyCo4', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (504, '<p>Permet de retenir la présence d''un acteur. </p>
<p>Si la présence doit être décrite de façon plus détaillée (par ex. en termes de durée), ou si les présences sont très nombreuses et ont une signification spécifique, on peut choisir de les traiter par des informations distinctes de type ''Présence'' (TyIn104), en les associant ensuite à la présente information ''Mariage''.</p>', '', 133, 'TyIn134', 7, 'TyRo7', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (505, '<p>Les témoins officiels du mariage.</p>
<p>Attention : pour les autres présents, cf. TyRo7 : être présent.</p>', '', 133, 'TyIn134', 77, 'TyRo77', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (506, '<p>Indique la localisation précise (église, mairie) ou générique (ville, pays) du mariage</p>', '', 133, 'TyIn134', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (507, '<p>[<strong>Héritage de rôles</strong>] Si on a préalablement créé une information de type Union (TyIn13), on pourra rattacher l''Information ''Mariage'' à l''information ''Union'' en utilisant ce rôle ''concerner''.</p>
<p>Dans ce cas, il n''est pas nécessaire de renseigner les rôles de type ''s''unir'' car il sont déjà renseignés dans l''Information de type ''Union''.</p>', '', 133, 'TyIn134', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (381, '/ spécifie notamment la localité touchée par une épidémie', NULL, 98, 'TyIn112', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (451, 'Désigne l''individu ou l''acteur collectif qui attribue la qualité.', NULL, 12, 'TyIn11', 41, 'TyRo41', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (498, '<p>Apporte une qualification plus fine de la typologie ou du rite du mariage, en plus que celle fournie par le rôle ''typer''. Contrairement à ce dernier, les rôles de type ''qualifier'' peuvent être multiples pour une même information.</p>', '', 133, 'TyIn134', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (500, '<p>Le célébrant (laîc ou religieux) du mariage : le curé, le maire, le capitaine du navire, ...</p>', '', 133, 'TyIn134', 78, 'TyRo78', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (501, '<p>[attention : ne plus utiliser ce rôle, créer des informations de type présence]</p>', '<p>[FB, 27.8.2012] Vérifier les données et remplacer par l''Information présence</p>', 25, 'TyIn26', 7, 'TyRo7', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (502, '<p>Associe l''organisme concerné par l''exercice de la fonction ou du caractère social en question, par ex. le tribunal auprès duquel l''acteur exerce la fonction de juge.</p>
<p>Attention : ne pas renseigner dans le cas d''une information qui hérite une partie de ses rôles [cf. type de rôle ''objet (être l'')'' ].  </p>', '', 131, 'TyIn6', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (240, 'Biens concédés à ferme. Il peut s''agir de biens fonds ou de bâtiments localisés, ou de biens désignés comme un ensemble à la fois ImCo et NaPl, que l''on traitera comme un objet abstrait.', NULL, 79, 'TyIn89', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (241, 'Exploitant qui prend à ferme l''''exploitation', NULL, 79, 'TyIn89', 63, 'TyRo63', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (503, '<p>[<strong>Héritage de rôles</strong>] On peut associer avec ce TyRo une information ''Exercice de fonction'' (TyIn7) concernée par la nomination, dont elle est l''objet.</p>
<p>Dans ce cas, si on a renseigné les rôles ''exercer'', ''exercé (être)'' et ''concerner'' dans l''Information de type TyIn7, il n''est pas nécessaire de les répéter dans l''Information de type TyIn6 car ils sont indirectement rattachés à celle-ci via l''association entre les deux Informations.</p>', '', 131, 'TyIn6', 13, 'TyRo13', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (145, NULL, NULL, 55, 'TyIn63', 89, 'TyRo89', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (146, NULL, NULL, 55, 'TyIn63', 90, 'TyRo90', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (147, NULL, NULL, 55, 'TyIn63', 91, 'TyRo91', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (148, NULL, NULL, 55, 'TyIn63', 92, 'TyRo92', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (149, NULL, NULL, 55, 'TyIn63', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (150, NULL, NULL, 56, 'TyIn64', 25, 'TyRo25', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (151, NULL, NULL, 56, 'TyIn64', 93, 'TyRo93', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (152, NULL, NULL, 56, 'TyIn64', 94, 'TyRo94', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (153, NULL, NULL, 56, 'TyIn64', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (154, NULL, NULL, 57, 'TyIn65', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (155, NULL, NULL, 57, 'TyIn65', 80, 'TyRo80', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (197, NULL, NULL, 67, 'TyIn76', 7, 'TyRo7', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (156, NULL, NULL, 56, 'TyIn64', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (157, NULL, NULL, 59, 'TyIn67', 73, 'TyRo73', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (158, NULL, NULL, 59, 'TyIn67', 41, 'TyRo41', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (159, '/ on peut renseigner plusieurs ouvrages dont la lecture a été permise
/ en cas de durée différente du permis de lecture on peut renseigner la durée dans le rôle qui associe l''ouvrage au permis
/ toutefois, si l''information devient trop complexe il est préférable de créer des informations ''filles'', concernant chaque ouvrage, en les associant à l''information ''mère'', dont elles héritent le ''sourçage''', NULL, 59, 'TyIn67', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (160, '/ Lieu de production de la censure : le lieu qu''on veut voir afficher sur une carte. 
/ D''autres lieux (si nécessaire)= peuvent être renseignés, mais le rôle doit être commenté manuellement', NULL, 110, 'TyIn2', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (161, 'Permet de renseigner la typologie de la lettre, en l''associant par exemple à l''objet abstrait ''correspondance diplomatique'', etc.', NULL, 132, 'TyIn1', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (529, '<p>TEST - réutiliser</p>', '', 144, 'TyCo8', 2, 'TyRo2', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (124, NULL, NULL, 49, 'TyIn59', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (125, NULL, NULL, 49, 'TyIn59', 72, 'TyRo72', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (242, 'Propriétaire qui baille à ferme l''exploitation', NULL, 79, 'TyIn89', 64, 'TyRo64', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (243, 'Désigne la maison religieuse (CoAc) vers laquelle a lieu le transfert a lieu et/ou la ville (NaPl) où elle se trouve', NULL, 80, 'TyIn90', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (244, 'Désigne la maison religieuse (CoAc) depuis laquelle a lieu le transfert a lieu et/ou la ville (NaPl) où elle se trouve', NULL, 80, 'TyIn90', 16, 'TyRo16', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (245, 'Désigne le(la) religieux(se) affecté(e) à une autre maison', NULL, 80, 'TyIn90', 116, 'TyRo116', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (246, 'Désigne l''autorité qui décide du transfert', NULL, 80, 'TyIn90', 117, 'TyRo117', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (168, 'Bénéficiaire du capital ou débirentier (qui verse la rente)', NULL, 45, 'TyIn69', 74, 'TyRo74', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (169, 'Bien qui constitue la garantie du contrat de rente', NULL, 45, 'TyIn69', 100, 'TyRo100', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (170, 'Bénéficiaire de la rente ou crédirentier (qui reçoit la rente)', NULL, 45, 'TyIn69', 99, 'TyRo99', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (171, 'Actr ou CoAc qui donne procuration', NULL, 61, 'TyIn70', 19, 'TyRo19', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (172, 'Actr ou CoAc qui reçoit procuration', NULL, 61, 'TyIn70', 31, 'TyRo31', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (173, 'Objet ou Information dans lesquelles la procuration est utilisée', NULL, 61, 'TyIn70', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (174, 'Actr ou CoAc qui prend le bien à bail', NULL, 62, 'TyIn71', 63, 'TyRo63', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (175, 'Actr ou CoAcqui conède le bien à bail', NULL, 62, 'TyIn71', 64, 'TyRo64', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (176, 'Biens loués', NULL, 62, 'TyIn71', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (177, 'Associe la location au TyIn62 ''passage d''un acte notarié''. La location type l''acte notarié', NULL, 62, 'TyIn71', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (178, 'Actro ou Coac qui prend à bail l''ensemble d''un immeuble pour en sous-louer les appartements.', NULL, 62, 'TyIn71', 101, 'TyRo101', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (179, 'Bien qui garantit l''obligation', NULL, 63, 'TyIn72', 100, 'TyRo100', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (180, 'Evénement qui est à l''origine de l''obligation', NULL, 63, 'TyIn72', 72, 'TyRo72', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (181, 'Acteur qui reconnaît sa dette', NULL, 63, 'TyIn72', 74, 'TyRo74', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (182, 'Acteur qui est reconnu pour créancier', NULL, 63, 'TyIn72', 99, 'TyRo99', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (183, 'Associe le contrat de métayage au TyIn62 ''passage d''un acte notarié''. Le métayage type l''acte notarié', NULL, 64, 'TyIn73', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (184, 'Biens concédés en métayage. Il peut s''agir de biens fonds ou de bâtiments localisés, ou de biens désignés comme un ensemble à la fois ImCo et NaPl, que l''on traitera comme un objet abstrait.', NULL, 64, 'TyIn73', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (185, 'Exploitant qui prend l''''exploitation en métayage', NULL, 64, 'TyIn73', 63, 'TyRo63', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (186, 'Propriétaire (Actr ou CoAc) qui baille l''exploitation en métayage', NULL, 64, 'TyIn73', 64, 'TyRo64', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (187, 'Ce type de rôle sert à désigner la fonction institutionnelle ou la fonction sociale occupée par la personne licenciée au moment où survient le licenciement.', NULL, 65, 'TyIn74', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (188, 'Ce type de rôle sert à désignier la ou les causes du licenciement', NULL, 65, 'TyIn74', 72, 'TyRo72', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (189, 'Ce type de rôle sert à désigner la personne ou l''acteur collectif (par exemple l''lentreprise) qui licencie.', NULL, 65, 'TyIn74', 102, 'TyRo102', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (190, 'Ce type de rôle sert à désigner la personne qui est licenciée', NULL, 65, 'TyIn74', 103, 'TyRo103', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (191, 'Ce type de rôle sert à désigner la fonction ou le poste pour laquelle ou lequel une personne a été embauchée.', NULL, 66, 'TyIn75', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (192, 'Ce type de rôle sert à désigner l''employeur qui peut être un individu particulier ou un acteur collectif (une entreprise par exemple)', NULL, 66, 'TyIn75', 104, 'TyRo104', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (193, 'ce type de rôle sert à désigner la personne qui est embauchée.', NULL, 66, 'TyIn75', 105, 'TyRo105', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (194, NULL, NULL, 49, 'TyIn59', 96, 'TyRo96', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (513, 'Permet de typer l''occurrence', NULL, 141, 'TyCo1', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (247, 'Ce rôle a été attribué aux acteurs de façon générique pour ce mcd, les fonctions des acteurs étant précisées par une fiche information &quot;exercice de la fonction&quot; (TyIn7)', NULL, 81, 'TyIn91', 7, 'TyRo7', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (195, 'Il s''agit ici du fait de remettre physiquement l''habit religieux au (à la) postulant(e)', NULL, 67, 'TyIn76', 106, 'TyRo106', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (196, NULL, NULL, 67, 'TyIn76', 70, 'TyRo70', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (198, NULL, NULL, 67, 'TyIn76', 77, 'TyRo77', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (199, NULL, NULL, 67, 'TyIn76', 55, 'TyRo55', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (200, NULL, NULL, 67, 'TyIn76', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (201, 'Selon la source, la destination inidquée peut être soit l''ordre ou la congrégation, soit la communauté religieuse relevant de cet ordre ou congrégation', NULL, 67, 'TyIn76', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (426, 'Désigne le fonctionnaire qui perçoit le traitement', NULL, 108, 'TyIn123', 70, 'TyRo70', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (248, NULL, NULL, 81, 'TyIn91', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (249, NULL, NULL, 81, 'TyIn91', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (250, NULL, NULL, 81, 'TyIn91', 119, 'TyRo119', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (251, NULL, NULL, 82, 'TyIn92', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (252, NULL, NULL, 82, 'TyIn92', 125, 'TyRo125', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (253, NULL, NULL, 82, 'TyIn92', 126, 'TyRo126', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (254, NULL, NULL, 83, 'TyIn93', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (255, NULL, NULL, 83, 'TyIn93', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (256, NULL, NULL, 83, 'TyIn93', 125, 'TyRo125', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (260, NULL, NULL, 84, 'TyIn94', 71, 'TyRo71', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (296, 'Si plusieurs types d''intervention sont insérés pas un même acteur dans un objet matériel, associer plusieurs objets abstraits à la même information.', NULL, 90, 'TyIn102', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (297, 'N''associer qu''un seul objet matériel à une information. ATTENTION : associer l''objet matériel à sa classe (d''habitude Bibl., parfois AbOb) avec le TyIn103 : exemplaire; ne pas renseigner ici l''ouvrage dont ce AbOb est un exemplaire.', NULL, 90, 'TyIn102', 13, 'TyRo13', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (298, 'Permet de spécifier le genre d''exemplaire dont il s''agit', NULL, 91, 'TyIn103', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (299, 'L''objet matériel concerné (en associer seulement un au maximum) (ex TyRo21)', NULL, 91, 'TyIn103', 59, 'TyRo59', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (300, '<p>Ce rôle indique l''acteur, institution, etc. qui exprime l''opinion.</p>', '', 124, 'TyIn100', 110, 'TyRo110', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (301, '<p>L''objet concerné par l''analyse</p>', '', 126, 'TyIn54', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (302, 'L''objet Bibl ou l''Info (éventuellement l''objet abstrait) auquel est rattaché l''exemplaire, dont l''objet matériel est un exemplaire. [14.7.2011 : vérifier si le rattachement à un AbOb est judicieux, cf. MCD actuel]', NULL, 91, 'TyIn103', 58, 'TyRo58', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (303, 'Indique quelle est la cause (au sens large, générique) de l''intervention. On peut associer avec ce rôle une autre information, un objet abstrait, etc.', NULL, 90, 'TyIn102', 138, 'TyRo138', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (304, NULL, NULL, 92, 'TyIn104', 7, 'TyRo7', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (305, 'Exprime le qualificatif propre au présent : ambassadeur, médecin, etc. Si on veut spécifier quelle est l''institution ou le SoCh auquel s''applique le qualificatif, utiliser le rôle concerner (TyRo21) : par exemple, être présent en tant qu''archevêque de Lyon', NULL, 92, 'TyIn104', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (306, 'Raison de la présence : une autre Info ou un AbOb', NULL, 92, 'TyIn104', 72, 'TyRo72', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (536, '<p>A réutiliser</p>', '', 146, 'TyCo7', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (94, NULL, NULL, 33, 'TyIn40', 43, 'TyRo43', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (69, NULL, NULL, 25, 'TyIn26', 45, 'TyRo45', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (95, NULL, NULL, 33, 'TyIn40', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (96, NULL, NULL, 34, 'TyIn41', 60, 'TyRo60', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (139, NULL, NULL, 54, 'TyIn62', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (405, '/ spécifie le destinataire de la préface (Actr, CoAc ou AbOb)', NULL, 104, 'TyIn118', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (486, '<p>Un objet abstrait (AbOb) qui type le contenu.</p>
<p><strong>Attention</strong> :  un seul type par Information !</p>', '', 126, 'TyIn54', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (510, 'Ce rôle indique quelle caractéristique sociale qualifie l''acteur dans la liste', NULL, 141, 'TyCo1', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (511, 'L''acteur collectif auquel appartient l''acteur ou l''institution concernée par cette occurrence de liste. A été utilisé également pour associer les quelques objets Bibl dont le sens est en quelque sorte d''acteur collectif', NULL, 141, 'TyCo1', 39, 'TyRo39', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (512, 'Permet de retenir la localisation indiquée dans l''occurrence : NaPl ou ImCo', NULL, 141, 'TyCo1', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (514, 'Associe un objet abstrait pour caractériser l''occurrence', 'Vérifier la définition', 141, 'TyCo1', 140, 'TyRo140', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (515, 'Ce rôle identifie la localité ou l''église paroissiale où se déroule la cérémonie', NULL, 143, 'TyCo5', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (516, 'Ce rôle identifie le défunt qui est l''objet de la cérémonie enregistrée', NULL, 143, 'TyCo5', 13, 'TyRo13', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (517, 'Ce rôle identifie les personnes mentionnées comme témoins dans l''acte, qu''elles signent ou pas l''acte', NULL, 143, 'TyCo5', 77, 'TyRo77', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (518, 'Ce rôle identifie le prêtre qui célèbre la cérémonie des funérailles', NULL, 143, 'TyCo5', 78, 'TyRo78', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (519, NULL, NULL, 139, 'TyCo4', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (520, 'Spécifie le type de descritpion (un seul rôle pour le type)', NULL, 139, 'TyCo4', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (521, 'Indique l''auteur de l''objet iconographique (Actr, SoCh, event. CoAc)', NULL, 139, 'TyCo4', 1, 'TyRo1', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (522, 'Localisation de l''objet selon la description (ImCo, AbOb)', NULL, 139, 'TyCo4', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (523, 'Le sujet de l''objet iconographique selon la description (AbOb, Actr, ImCo, NaPl, SoCh)', NULL, 139, 'TyCo4', 97, 'TyRo97', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (524, 'Associe un objet abstrait qui indique le support de l''objet iconographique', NULL, 139, 'TyCo4', 148, 'TyRo148', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (257, 'Dans le cas d''un synode réformé, ce rôle concerne le re-ceveur qui est chargé d''effectuer le paiement des crédits attribués', NULL, 83, 'TyIn93', 127, 'TyRo127', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (261, 'Désigne l''entité qui assure la représentation.', NULL, 85, 'TyIn95', 31, 'TyRo31', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (262, 'Désigne en quelle qualité l''entité qui représente assure cette représentation.', NULL, 85, 'TyIn95', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (263, 'Désigne l''entité qui est représentée.', NULL, 85, 'TyIn95', 128, 'TyRo128', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (264, 'Associe la constitution de rente au TyIn62 ''passage d''un acte notarié''. La constitution de rente type l''acte notarié', NULL, 45, 'TyIn69', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (265, 'Associe la vente au TyIn62 ''passage d''un acte notarié''. La vente type l''acte notarié', NULL, 53, 'TyIn61', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (266, NULL, NULL, 86, 'TyIn96', 46, 'TyRo46', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (267, NULL, NULL, 86, 'TyIn96', 129, 'TyRo129', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (268, 'Maison d''éditon ou personne s''occupant de l''impression et de la diffusion d''un ouvrage (publisher). Attention: différent de l''editeur scientifique et de l''imprimeur', NULL, 86, 'TyIn96', 69, 'TyRo69', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (269, NULL, NULL, 86, 'TyIn96', 130, 'TyRo130', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (270, NULL, NULL, 86, 'TyIn96', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (271, 'Utiliser pour spécifier le type de localisation : domiciliation, résidence, etc.', NULL, 30, 'TyIn36', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (272, NULL, NULL, 87, 'TyIn97', 131, 'TyRo131', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (273, 'Ce rôle a été gardé pour être l''équivalent du TyIn7 : Exercice d''une fonction.', NULL, 87, 'TyIn97', 12, 'TyRo12', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (274, 'Ne pas renseigner si l''institution auprès de laquelle s''effectue l''enseignement est déjà localisée.', NULL, 87, 'TyIn97', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (275, 'Qualification de l''enseignement : professeur, chargé de cours, etc. Ce rôle a été gardé pour être l''équivalent du TyIn7 : Exercice d''une fonction.', NULL, 87, 'TyIn97', 47, 'TyRo47', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (276, 'Institution auprès de laquelle s''exerce l''enseignement. Ce rôle a été gardé pour être l''équivalent du TyIn7 : Exercice d''une fonction.', NULL, 87, 'TyIn97', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (277, 'A utiliser dans le contexte de ce TyIn pour spécifier la nature de l''enseignement grâce à un AbOb (cours magistral, séminaire, etc.)', NULL, 87, 'TyIn97', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (278, 'Par ex. qualification théologique, révision préalable à l''impression, etc.', NULL, 110, 'TyIn2', 95, 'TyRo95', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (279, NULL, NULL, 88, 'TyIn98', 134, 'TyRo134', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (280, NULL, NULL, 88, 'TyIn98', 133, 'TyRo133', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (281, NULL, NULL, 88, 'TyIn98', 132, 'TyRo132', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (308, 'Attention : indique uniquement l''institution ou SoCh concerné par le qualificatif de la présente (TyRo95)', NULL, 92, 'TyIn104', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (453, '<p>Permet d''associer l''Information Naissance à une information de type Union (TyIn13), c''est-à-dire d''associer l''acteur qui naît au couple de ses parents biologiques.</p>
<p>Tout autre type de parenté (adoption, etc.), doit être traité par d''autres types d''informations.</p>', '', 134, 'TyIn14', 16, 'TyRo16', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (454, 'Celui ou celle qui s''engage à ce que la transaction soit respectée, et que l''argent soit restitué au créancier.', NULL, 114, 'TyIn126', 100, 'TyRo100', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (455, 'Celui qui doit la somme en question', NULL, 114, 'TyIn126', 74, 'TyRo74', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (456, 'Permet de rattacher un objet abstrait ou une Information qui justifie la caution.', NULL, 114, 'TyIn126', 72, 'TyRo72', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (459, NULL, NULL, 115, 'TyIn128', 77, 'TyRo77', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (329, 'Associe l''objet abstrait qui définit de façon plus fine que le type le critère d''assemblage, la nature de la collection', NULL, 95, 'TyIn108', 141, 'TyRo141', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (330, 'Associe l''objet qui possède la collection', NULL, 95, 'TyIn108', 43, 'TyRo43', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (335, NULL, NULL, 96, 'TyIn109', 141, 'TyRo141', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (527, 'Associe le propriétaire de l''objet. Si le propriétaire est évident (par exemple lors du dépouillement du contenu d''un inventaire après décès), on n''a pas à renseigner ce rôle car cette ''propriété'' pourra être reconstituée par requête.', NULL, 139, 'TyCo4', 43, 'TyRo43', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (528, '<p>Les personnes présentes aux funérailles.</p>', '', 143, 'TyCo5', 7, 'TyRo7', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (533, '<p>Indique l''endroit de l''entretien.</p>', '', 145, 'TyCo6', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (50, '', '', 132, 'TyIn1', 1, 'TyRo1', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (427, 'Désigne la fonction ou sociale ou l''information Exercice de fonction qui justifie le versement du traitement', NULL, 108, 'TyIn123', 72, 'TyRo72', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (487, '<p>La doctrine à laquelle l''acteur ou acteur collectif adhère, sous forme de AbOb ou de Information qui identifie et décrit cette doctrine</p>', '', 125, 'TyIn132', 13, 'TyRo13', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (488, '<p>Indiquer quel est le type d''adhésion à la doctrine en question.</p>
<p><strong>Attention</strong> :  ne pas confondre avec le <em>type de doctrine</em> qui est à renseigner éventuellement du côté des classes de AbOb ; n''utiliser qu''un type par information.</p>', '', 125, 'TyIn132', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (489, '<p>La personne ou l''institution qui adhére à une doctrine, à une confession, etc.</p>', '', 125, 'TyIn132', 171, 'TyRo171', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (490, '<p>Utiliser pour associer l''Information ''naissance'' concernant le baptisé.</p>
<p>Si on crée cette association, il n''est pas nécessaire de créer le rôle de type ''objet (être l'')'' (TyRo13) car l''identité du baptisé est déjà fournie par l''information naissance. </p>', '', 128, 'TyIn15', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (491, '<p>Désigne la personne qui reçoit le baptême.</p>
<p>Cf. le TyRo21 ''concerner '' pour l''association avec la fiche ''naissance'' et, à travers elle, avec l''acteur baptisé.</p>', '', 128, 'TyIn15', 13, 'TyRo13', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (492, '<p>Le lieu où s''effectue la nomination.</p>
<p>Attention : ne pas confondre avec le lieu où sera exercée la fonction. </p>', '', 131, 'TyIn6', 8, 'TyRo8', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (493, '<p>Permet de rattacher cette Information (l''autographe), à une autre Information qui décrit un document autographe ou semblable, en spécifiant dans le rôle les pages ou la localisation précise. </p>
<p>Pour les MaOb utiliser de préférence le sourçage habituel.</p>', '', 52, 'TyIn56', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (494, '<p>Indique le type de mariage : civil, religieux, etc.</p>
<p><strong>Attention</strong> : un seul type par Information ! </p>', '', 133, 'TyIn134', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (495, '<p>Associe le charactère social ou la fonction institutionnelle (les deux étant des SoCh) sur lesquels porte la nomination.</p>
<p>Permet également d''associer le lieu de destination pour l''exercice de la fonction. </p>
<p>Attention : ne pas renseigner, en ce qui concerne le SoCh, dans le cas d''une information qui hérite une partie de ses röles [cf. rôle ''objet (être l'')'' ] </p>', '', 131, 'TyIn6', 9, 'TyRo9', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (496, '<p>L''acteur ou l''organisme responsables de la nomination.</p>', '', 131, 'TyIn6', 10, 'TyRo10', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (497, '<p>Associe les acteurs s''unissant par le lien du mariage.</p>
<p>[Héritage de rôles] Si on a préalablement créé une information de type Union (TyIn13) et qu''on l''a associée à l''information ''Mariage'' avec un rôle de type ''concerner'', il n''est pas nécessaire de renseigner les rôles de type ''s''unir'' car on peut les récupérer depuis l''information de type ''Union''.</p>', '', 133, 'TyIn134', 44, 'TyRo44', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (499, '<p>Associe une information qui justifie ou explique la nomination</p>', '', 131, 'TyIn6', 72, 'TyRo72', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (438, NULL, NULL, 28, 'TyIn34', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (452, 'Associe l''Information qui indique l''appartenance à une institution ou un corps du fait de la qualité obtenue', NULL, 12, 'TyIn11', 166, 'TyRo166', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (508, '<p>Ce rôle concerne l''individu à qui a été attribué la nationalité d''un pays.</p>', '', 76, 'TyIn86', 37, 'TyRo37', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (509, '<p>Ce rôle associe à l''information le pays dont l''acteur possède la nationalité.</p>', '', 76, 'TyIn86', 125, 'TyRo125', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (469, 'Information ou objet abstrait qui est l''occasion de la décision', NULL, 117, 'TyIn125', 72, 'TyRo72', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (369, NULL, NULL, 100, 'TyIn114', 120, 'TyRo120', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (470, 'Celui ou celle qui est chargé de l''application de la décision', NULL, 117, 'TyIn125', 126, 'TyRo126', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (471, 'Identifie l''acteur ou l''acteur collectif qui possède la qualité', NULL, 118, 'TyIn130', 43, 'TyRo43', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (472, 'Désigne la qualité portée par un individu ou par un acteur collectif (SoCh).', NULL, 118, 'TyIn130', 21, 'TyRo21', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (473, 'Associe l''Information qui indique l''appartenance à une institution ou un corps du fait de la qualité obtenue', NULL, 118, 'TyIn130', 166, 'TyRo166', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (474, 'Permet d''associer l''acteur ou l''acteur collectif qui fonde, au sens générique du terme.
Pour préciser le rôle des divers acteurs qui interviennent dans la fondation, il faut créer d''autres types d''informations spécifiques.', NULL, 119, 'TyIn30', 50, 'TyRo50', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (475, 'Utilisé pour spécifier à quelle institution est éventuellement rattaché l''Acteur collectif ou Fonction institutionnelle (SoCh) au moment de sa fondation.
Pour toute modification ultérieure de rattachement, créer des Informations de TyIn37 ''Rattachement à une institution''.', NULL, 119, 'TyIn30', 58, 'TyRo58', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (478, '<p>Associe l''Information qui représente le contexte, l''occasion de la représentation</p>', '', 85, 'TyIn95', 138, 'TyRo138', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (481, '<p>Grâce à l''association d''un AbOb opportun, on indique ici de quel type d''opinion il s''agit.</p>
<p>ATTENTION : un seul type d''opinion par information !</p>', '', 124, 'TyIn100', 98, 'TyRo98', '2012-10-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (540, 'Associer avec ce rôle les objets longitude et latitude et renseigner leurs valeurs dans les propriétés numériques', NULL, 147, NULL, 8, NULL, '2012-11-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (541, 'L''objet concerné par la localisation', NULL, 147, NULL, 21, NULL, '2012-11-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (542, 'L''objet (i.e. l''acteur, l''acteur collectif, etc.) concerné par l''adresse, dont on documente la ou les adresses', NULL, 148, NULL, 21, NULL, '2012-11-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (543, 'On associe en tant qu''objet le type d''adresse : adresse postale, url, téléphone, etc. et on met l''adresse effective dans le champs ''libellé selon la source''', NULL, 148, NULL, 8, NULL, '2012-11-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (544, 'Le projet, film, périodique, etc; concerné', NULL, 149, NULL, 21, NULL, '2012-11-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (545, 'L''acteur, acteur collectif, eventuellemement Caractère social si l''acteur est inconnu qui collabore', NULL, 149, NULL, 169, NULL, '2012-11-23 23:40:53.340336');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (551, 'Associe l''objet concerné par les notes', NULL, 152, NULL, 21, NULL, '2013-07-28 21:34:27.105652');
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (552, 'Associe le ou les objets concernés par la tâche', '', 153, NULL, 21, NULL, NULL);
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (553, 'Localise la tâche', NULL, 153, NULL, 8, NULL, NULL);
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (554, 'Permet d''attribuer un type (Objet abstrait) à la tâche', NULL, 153, NULL, 98, NULL, NULL);
INSERT INTO associer_type_uc_type_role (pk_associer_type_uc_type_role, descriptif, notes, fk_type_uc, type_uc_cle_objet_bhp, fk_type_role, type_role_cle_objet_bhp, date_mise_a_jour) VALUES (555, 'Permet d''associer un objet abstrait indiquant le type de notes (notes de lecture, idées, etc.)', NULL, 152, NULL, 98, NULL, NULL);


--
-- TOC entry 2375 (class 0 OID 0)
-- Dependencies: 175
-- Name: associer_type_uc_type_role_pk_associer_type_uc_type_role_seq; Type: SEQUENCE SET; Schema: tables_types; Owner: -
--

SELECT pg_catalog.setval('associer_type_uc_type_role_pk_associer_type_uc_type_role_seq', 555, true);


--
-- TOC entry 2358 (class 0 OID 19352)
-- Dependencies: 176
-- Data for Name: associer_types_sous_types_objets; Type: TABLE DATA; Schema: tables_types; Owner: -
--

INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (43, 10, 64, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (31, 12, 52, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (33, 11, 54, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (35, 10, 56, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (7, 13, 28, NULL, true);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (13, 13, 34, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (20, 13, 41, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (1, 7, 22, NULL, true);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (10, 16, 30, NULL, true);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (12, 11, 33, NULL, true);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (22, 13, 43, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (8, 13, 29, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (23, 15, 47, NULL, true);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (41, 10, 62, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (25, 15, 45, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (27, 14, 48, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (39, 10, 60, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (2, 14, 23, NULL, true);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (6, 14, 27, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (4, 9, 24, NULL, true);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (5, 7, 26, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (40, 10, 61, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (9, 16, 31, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (11, 11, 32, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (14, 13, 35, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (19, 8, 40, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (21, 13, 42, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (42, 10, 63, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (24, 15, 44, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (26, 14, 46, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (28, 14, 49, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (29, 9, 50, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (32, 12, 53, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (34, 11, 55, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (36, 10, 57, NULL, true);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (38, 10, 59, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (44, 11, 65, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (45, 9, 66, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (46, 12, 67, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (47, 12, 60, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (49, 13, 60, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (50, 11, 60, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (51, 15, 60, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (52, 8, 68, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (53, 14, 69, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (55, 16, 72, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (56, 16, 73, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (57, 12, 74, NULL, true);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (30, 12, 51, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (58, 13, 75, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (59, 13, 76, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (60, 11, 77, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (61, 13, 78, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (62, 12, 58, NULL, false);
INSERT INTO associer_types_sous_types_objets (pk_associer_types_sous_types_objets, fk_type, fk_sous_type, remarques, si_standard) VALUES (3, 8, 89, NULL, true);


--
-- TOC entry 2376 (class 0 OID 0)
-- Dependencies: 177
-- Name: associer_types_sous_types_pk_associer_types_sous_types_seq; Type: SEQUENCE SET; Schema: tables_types; Owner: -
--

SELECT pg_catalog.setval('associer_types_sous_types_pk_associer_types_sous_types_seq', 62, true);


--
-- TOC entry 2355 (class 0 OID 19338)
-- Dependencies: 173
-- Data for Name: parametre; Type: TABLE DATA; Schema: tables_types; Owner: -
--

INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (11, 'Unité documentaire', 'Type d''objet qui résulte de la décomposition d''un autre objet (par ex. la notice d''un dictionnaire décompose le dictionnaire).
Le lien avec l''objet ''parent'' se fait en utilisant une association de type ''Composition''', NULL, 'type_objet', 7);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (16, 'Caractère social', 'Type d''objet : regroupe l''ensemble des fonctions sociales, professions, statuts des personnes, qualités, etc.', NULL, 'type_objet', 41);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (12, 'Objet digital', 'Type d''objet : regroupe tous les objets digitaux au sens d''images digitales, enregistrements sonores et vidéo, pages et sites web, etc.', NULL, 'type_objet', 8);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (7, 'Acteur', 'Type d''objet : tout acteur individuel, réel ou fictif qu''il soit', NULL, 'type_objet', 1);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (8, 'Acteur collectif', 'Type d''objet : les institutions, les familles, tout type de personne morale, etc.', NULL, 'type_objet', 2);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (1, 'exacte', 'Année ou date connue avec précision', NULL, 'certitude_date_annee', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (2, 'reconstituée', 'Année ou date qui n''est pas connue avec précision mais que les sources disponibles permettent de reconstituer avec une certaine précision (dans une fourchette de ± 1 unité', NULL, 'certitude_date_annee', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (3, 'postulée', 'Année ou date inconnue avec précision mais qui peut être calculée à partir de l''age d''exercice d''une fonction ou semblable, fourchette de ±10/20 unités', NULL, 'certitude_date_annee', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (4, 'date de début ou unique', 'Une date unique ou se situant au début d''une période', NULL, 'type_date_uc', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (5, 'date intermédiaire', 'Une date intermédiaire, au milieu d''une période, ne marquant ni le début ni la fin', NULL, 'type_date_uc', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (6, 'date de fin', 'Une date se situant à la fin d''une période', NULL, 'type_date_uc', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (14, 'Lieu', 'Type d''objet', NULL, 'type_objet', 10);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (15, 'Immeuble', 'Type d''objet', NULL, 'type_objet', 11);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (10, 'Objet matériel', 'Type d''entité élementaire qui regroupe tous les objets concrets, matériels.', NULL, 'type_objet', 4);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (13, 'Bibliographie', 'Type d''objet : tout objet bibliographie, en tant que collexion de tous les exemplaires de tel livre, tel article, etc.', NULL, 'type_objet', 9);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (22, 'Etre humain', 'Tout être humain ayant ou ayant eu une existence réelle', NULL, 'sous_type_objets', 14);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (23, 'Lieu habité', 'Type générique de lieu indiquant une ville, village et toute autre sorte de lieu habité par une population ou de individus.', NULL, 'sous_type_objets', 15);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (45, 'Infrastructure', 'Ensemble des installations, des équipements permanents qui conditionnent le fonctionnement d''un organisme ou d''une entreprise, l''activité économique d''une région, d''un pays.', NULL, 'sous_type_objets', 65);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (47, 'Bâtiment', 'Edifice muni d''un toit et de murs, qu''il s''agisse d''une construction à usage d''habitation ou industriel. Les classes permettront de spécifier.', NULL, 'sous_type_objets', 63);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (18, 'reproduit', 'Type d''association entre objets qui indique tout espèce de reproduction : digitale, photographique, sur support imprimé, etc.
Un objet associé avec ce type d''association est donc une reproduction de l''objet concenré', 'Reproduction', 'type_association_objets', 25);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (17, 'documente', 'Type d''association d''objets qui indique que l''objet cible documente (sous quelle forme que ce soit) l''objet concerné.', 'Documentation', 'type_association_objets', 20);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (31, 'Fonction institutionnelle', 'Il s''agit de fonctions précises et individualisée (et non de caractère abstrait ou générique) liées au fonctionnement d''une institution précise. Par ex. Président de la République française, pape, secrétaire de la Congrégation de l''Inquisition, ...', NULL, 'sous_type_objets', 42);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (52, 'Image digitale', 'Photo ou autre image digitale', NULL, 'sous_type_objets', 75);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (24, 'Objet abstrait générique', 'Tout concept, objet symbolique, classe d''objets concrets, etc. Par ex. : économie, philantropie, opinion négative, etc. Les objets abstraits généralisés sont souvent utilisés pour classer les autres objets.', NULL, 'sous_type_objets', 29);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (34, 'Article de quotidien ou magazine', 'Article dans périodique non-scientifique', NULL, 'sous_type_objets', 47);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (29, 'Article de revue scientifique', 'Article dans périodique scientifique (en sciences sociales ou autre)', NULL, 'sous_type_objets', 36);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (43, 'Contribution de colloque', 'Partie d''actes de colloque rédigée par un auteur précis', NULL, 'sous_type_objets', 59);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (28, 'Livre', 'Ouvrage distinct rédigé par un ou plusieurs auteurs', NULL, 'sous_type_objets', 35);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (54, 'Entrée de registre', 'Toute partie de texte répétitive se trouvant dans un registre : entrée de registre de baptême, décision juridique, notariale, etc.', NULL, 'sous_type_objets', 77);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (33, 'Notice', 'Notice de dictionnaire, notice nécrologique, etc. dédiée à un acteur, à un acteur collectif ou à tout autre objet', NULL, 'sous_type_objets', 45);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (58, 'Logiciel', ',,Ensemble des programmes, procédés et règles, et éventuellement de la documentation, relatifs au fonctionnement d''un ensemble de traitement de données`` (J. O., Vocab. de l''informat., 17 janv. 1982)', NULL, 'sous_type_objets', 81);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (56, 'Fonds d''archives', 'Ensemble de documents produits ou reçus par une personne (ou une famille) ou une organisation (institution, entreprise, association) dans le cadre de son activité', NULL, 'sous_type_objets', 79);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (61, 'Exemplaire d''imprimé', 'Exemplaire concret d''un livre (le livre est une entité bibliographique, l''exemplaire dédicacé un objet concret), d''un placard, d''une borchure – l''exemplaire concret conservé et côté.', NULL, 'sous_type_objets', 84);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (64, 'Série archivistique', 'Série organique, série d''archives, sous-série (typage supplémentaire par les classes)', NULL, 'sous_type_objets', 87);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (19, 'classé par', 'Type d''association entre objets qui indique que l''objet concerné (enfant) est classé par l''objet associé (parent).
Attention : ne pas abuser des classes en y saisissant des éléments qui relèvent des Unités de connaissance.', 'Classes', 'type_association_objets', 26);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (20, 'compose', 'Type d''association entre objets qui indique que l''objet concerné est une partie de l''objet associé. 
Utilisé en particulier pour associer les ''Unités documentaires'' à leur source.
La propirété ''Référence précise'' de l''association permet de spécifier les pages, volumes, etc. concernés.', 'Composition', 'type_association_objets', 38);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (9, 'Objet abstrait', 'Les concepts, les lois, etc.', NULL, 'type_objet', 3);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (55, 'Volume de périodique', 'Tel volume précis d''une revue (la revue étant une entité Bibliographie que type Périodique), numéro ou livraison de journal, etc.', NULL, 'sous_type_objets', 78);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (51, 'Enregistrement numérique', 'Enregistrement du son ou de l''image stocké sous forme numérique', NULL, 'sous_type_objets', 69);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (60, 'Autre', 'Sous-type d''objet non spécifié, à défaut de classement plus précis.', NULL, 'sous_type_objets', 83);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (73, 'Diplome, grade', 'Titre, grade émané d''une université, d''une faculté, d''une société savante, d''un corps, d''une école publique. Degré de dignité, d''honneur. Degré d''avancement dans la carrière ', NULL, NULL, NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (48, 'Région géographique', 'Toute région géographique non caractérisée par dimension politique ou ethnique. La dimension peut aller du continent (Europe), à la région correspondant à un territoire délimité géographiquement (Italie) ou historiquement (Allemagne), sans toutefois de connotation politique ou ethnique, à une région au niveau local (Camargue).', NULL, 'sous_type_objets', 67);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (46, 'Adresse', 'Indication précise de l''emplacement où se trouve un lieu ponctuel habité ou non. Les indications d''une adresse portent au minimum un nom de lieu, comme la rue et le numéro de la rue.', NULL, 'sous_type_objets', 66);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (49, 'Elément géographique naturel', 'Eléments géographiques localisés relatifs au milieu naturel, au paysage : montagnes, cols, vallées, fleuves, etc.', NULL, 'sous_type_objets', 68);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (69, 'Surface d''infrasctructure', 'Surface terrestre couverte par des installations, des équipements permanents qui conditionnent le fonctionnement d''un organisme ou d''une entreprise, l''activité économique d''une région, d''un pays.', NULL, NULL, NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (44, 'Partie de bâtiment', 'Élément d''un bâtiment ou d''une habitation, lieu (clos) couvert où l''on habite. N''importe quel espace joint complètement ou partiellement, utilisé ou destiné pour être utilisé pour la vie, le sommeil, la cuisine et le repas.', NULL, 'sous_type_objets', 64);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (70, 'Ensemble de bâtiments', 'L''un avec l''autre, les uns avec les autres, de manière à former une unité enveloppante ou groupante Les éléments composants étant ici des bâtiments', NULL, NULL, NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (26, 'Personnage fictif', 'Personnage de fiction, figure biblique, etc. Tout personnage mentionné dans un récit mais dont on sait qu''il n''a pas réellement existé.', NULL, 'sous_type_objets', 30);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (40, 'Acteur collectif imaginaire', 'Regroupe toutes les institutions ou acteurs collectifs fictifs ou n''ayant pas d''existence réelle mais mentionnés dans un discours, par ex. ''Le clergé italien''', NULL, 'sous_type_objets', 56);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (68, 'Collectivité informelle', 'Acteur collectif dépourvu d''une structure institutionnelle ou formelle', NULL, 'sous_type_objets', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (37, 'Famille', 'Toute famille concrète agissant en tant que collectivité : par ex. les Médicis.', NULL, 'sous_type_objets', 52);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (30, 'Caractère social générique', 'Regroupe toute profession, fonction, statut, etc. entendus en termes généraux, en tant qu''objets abstraits. Par ex. avocat, professeur, éveque, etc.
Pour une fonction précise et institutionnalisée, voir le sous-type d''objet : Fonction institutionnelle.', NULL, 'sous_type_objets', 43);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (72, 'Ordres, décorations, distinctions', 'Marque extérieure d''une distinction honorifique, d''une récompense. Pour spécifier le genre de décoration, etc. utiliser des classes.', NULL, NULL, NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (50, 'Objet abstrait individualisé', 'Regroupe les objets abstrait possédant un caractère individuel, telle une loi de la physique (la première loi de Kepler).', NULL, 'sous_type_objets', 70);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (66, 'Thématique personnelle', 'Regroupe les définitions de mots clés liés à sa propre recherche, permettant un classement des autres objets lié à sa problématique spécifique.', NULL, 'sous_type_objets', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (75, 'Collection d''ouvrages', 'Collection de livres chez tel éditeur, dirigée par tel auteur', NULL, NULL, NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (74, 'Texte ou dessin numérique', 'Tout texte, dessin, schéma, etc. stocké sous forme numérique. Opérer des distinctions plus fines, si besoin est, par des classes.', '', 'sous_type_objets', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (67, 'Dossier', 'En informatique, un répertoire ou un dossier est une liste de descriptions de fichiers se trouvant sur un disque ou autre support. Le disque lui-même, entendu comme un dossier racine, peut également être typé avec ''Dossier''.', NULL, 'sous_type_objets', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (41, 'Chapitre de livre', 'Chapitre de livre au sens bibliographique, c''est-à-dire le texte d''un auteur dans un collectif. Ne pas utiliser pour le chapitre d''un livre entièrement du même auteur : dans ce cas, utiliser Unité documentaire comme type.', NULL, 'sous_type_objets', 57);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (42, 'Périodique', 'Tout type de périodique, revue, comptes-rendus de sociétés savantes, etc.  Le périodique comme tel, pas les volumes ou livraisons : utiliser Unité documentaire pour typer ces derniers.', NULL, 'sous_type_objets', 58);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (76, 'Mémoire', 'Mémoire de master, thèse de doctorat et tout type d''imprimé existant sous plusieurs exemplaires identiques. Utiliser les classes pour spécifier ultérieurement.', NULL, NULL, NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (32, 'Liste nominative', 'Toute liste de noms, telle une liste de membres d''un comité de rédaction d''une revue, liste de prisonniers, liste de participants à une séance d''une insitution, etc.', NULL, 'sous_type_objets', 44);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (65, 'Texte', 'Typologie générique, appliquer une typologie spécifique grâce aux classes. Attention à ne pas confondre avec les Textes numériques (sous-type d''objet digital)', NULL, 'sous_type_objets', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (53, 'Ressource web', 'Une page web, un site web, une URI. Opérer des distinctions plus fines, si besoin est, par des classes.', NULL, 'sous_type_objets', 76);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (35, 'Actes de colloque', 'Ouvrage publiant les communications présentées lors d''un colloque scientifique', NULL, 'sous_type_objets', 48);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (63, 'Objet numismatique', 'Monnaie, médaille, etc. Préciser la typologie exacte par une classe.', NULL, 'sous_type_objets', 86);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (59, 'Ouvrage iconographique', 'Tableau, statue, fresque, etc. Préciser le type exact par une classe.', NULL, 'sous_type_objets', 82);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (57, 'Document manuscrit', 'Lettre, manuscrit d''ouvrage, expertise, etc. (utiliser les classes pour un typage plus fin)', NULL, 'sous_type_objets', 80);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (77, 'Lettre', 'Écrit adressé à quelqu''un pour lui communiquer quelque chose. Permet d''identifier toute lettre qui n''existe pas comme objet indépendant, étant publiée dans un recueil ou édition, ou copiée dans un registre, etc.', NULL, NULL, NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (62, 'Article d''archives', 'La plus petite unité côtée (pour décomposer encore plus, utiliser les unités documentaires).
Unité matérielle de conservation et de conditionnement pour le rangement des documents d''archives; de ce fait, il porte la cote. L''article peut s''identifier au document (registre, pièce) ou en regrouper plusieurs (pièces ou dossiers).', NULL, 'sous_type_objets', 85);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (78, 'Littérature grise', 'Tout type d''imprimé (produit par les instances du gouvernement, de l’enseignement, de l’industrie, etc.), sous un format papier, qui n’est pas contrôlé par l’édition commerciale : un placard, une brochure, une publicité, etc. ', NULL, NULL, NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (79, 'concerne', 'Type d''association d''objets qui indique que l''objet cible est concerné (sous quelle forme que ce soit) par le présent objet.', NULL, 'type_association_objets', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (80, 'Texte', NULL, NULL, 'type_propriete_texte_uc', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (81, 'Complément', NULL, NULL, 'type_propriete_texte_uc', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (82, 'Notice', NULL, NULL, 'type_propriete_texte_uc', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (83, 'Citation', NULL, NULL, 'type_propriete_texte_uc', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (84, 'classer', 'L''objet classe l''UC', NULL, 'type_association_uc_objet', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (85, 'documenter', 'L''objet document l''UC', NULL, 'type_association_uc_objet', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (27, 'Territoire', 'Étendue de la surface terrestre, plus ou moins nettement délimitée, qui présente généralement une certaine unité, un caractère particulier, où est établie une collectivité humaine. Regroupe toutes les surfaces territoriales administratives, juridiques, ecclésiastiques ... définies par des frontières tracées par l''homme et relevant d''une autorité', NULL, '', 28);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (86, 'masculin', 'Acteur de sexe masculin', NULL, 'sexe', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (87, 'féminin', 'Acteur de sexe féminin', NULL, 'sexe', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (88, 'indéterminé', 'Acteur de sexe indéterminé', NULL, 'sexe', NULL);
INSERT INTO parametre (pk_parametre, nom, descriptif, notes, type_parametre, cle_importation) VALUES (89, 'Collectivité structurée', 'Collectivité munie de statuts, régie par la loi ou organisée formellement', NULL, NULL, NULL);


--
-- TOC entry 2377 (class 0 OID 0)
-- Dependencies: 178
-- Name: parametres_pk_parametres_seq; Type: SEQUENCE SET; Schema: tables_types; Owner: -
--

SELECT pg_catalog.setval('parametres_pk_parametres_seq', 89, true);


--
-- TOC entry 2361 (class 0 OID 19363)
-- Dependencies: 179
-- Data for Name: type_role; Type: TABLE DATA; Schema: tables_types; Owner: -
--

INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (1, 'auteur (être l'')', NULL, '/ " Celui ou celle qui a composé une œuvre de littérature, de sciences ou d''art (musique, peinture, sculpture...)." (http://www.cnrtl.fr/definition/auteur - déf. II)
/ Plus généralement, l''auteur d''un document, voire d''une annotation, au sens de celui ou celle qui en est à l''origine, qui en porte l''autorité.', NULL, 'TyRo1', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (2, 'appartenir', NULL, '/ Est ici employé dans le sens de "faire partie organique d''un ensemble".
[http://www.cnrtl.fr/definition/appartenir]', NULL, 'TyRo2', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (3, 'création (être une)', NULL, '"Produit issu de l''activité d''un artiste, écrivain, musicien, etc. et portant la marque de celui-cI" (http://www.cnrtl.fr/definition/creation)', NULL, 'TyRo3', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (4, 'soumis à censure (être)', NULL, '/ "Examen d''une doctrine, d''un écrit ou d''une activité par une autorité instituée à cet effet" 
[http://www.cnrtl.fr/definition/censure]', NULL, 'TyRo4', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (5, 'rédiger', NULL, '/ "Mettre par écrit, en particulier sous une forme définitive ou selon la forme requise".[http://www.cnrtl.fr/definition/rédiger] Spécifie le rôle du rédacteur lorsque celui-ci doit être distingué de l''auteur', NULL, 'TyRo5', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (6, 'copier', NULL, '/ "Reproduire fidèlement une œuvre originale" : texte, tableau, etc. [http://www.cnrtl.fr/definition/copier]', NULL, 'TyRo6', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (8, 'localiser', NULL, '/ Ce type d''association indique une localisation précise d''une information.
/ Si la localisation est générique (par exemple on ne connaît que la ''région'' ou l''Etat'') on utilise de préférence le TyRo135 ''situer (génériquement)''', NULL, 'TyRo8', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (9, 'destination (être la)', NULL, 'Entité vers laquelle se dirige une action, de façon concrète ou abstraite (lieu, institution, acteur)', NULL, 'TyRo9', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (10, 'nommer', NULL, '"Désigner quelqu''un à une charge, à une fonction, à un emploi ; élever quelqu''un à une dignité" (cf. http://www.cnrtl.fr/definition/nommer)', NULL, 'TyRo10', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (11, 'nommé (être)', NULL, '"Etre désigné à une charge, à une fonction, à un emploi ; Etre élevé à une dignité" (cf. http://www.cnrtl.fr/definition/nommer)', NULL, 'TyRo11', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (12, 'exercer', NULL, '/ Pratiquer une activité, un métier, une profession, etc.', NULL, 'TyRo12', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (13, 'objet (être l'')', NULL, 'Associe à l''information l''objet d''une action, d''un droit, etc.', NULL, 'TyRo13', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (14, 'élu (être)', NULL, 'Objet choisi par voie de suffrages (soit à titre de représentant, soit pour lui conférer un titre, une fonction, un honneur, soit pour l''appeler à siéger dans une assemblée).', NULL, 'TyRo14', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (15, 'élire', NULL, 'Choisir (quelqu''un ou une institution) par voie de suffrages (soit à titre de représentant, soit pour lui conférer un titre, une fonction, un honneur, soit pour l''appeler à siéger dans une assemblée).', NULL, 'TyRo15', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (16, 'origine (être l'')', NULL, 'Entité de laquelle part une action, de façon concrète ou abstraite (lieu, institution, acteur)', NULL, 'TyRo16', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (17, 'vendre', NULL, 'Céder un bien contre de l''argent, contre paiement.
[http://www.cnrtl.fr/definition/vendre]', NULL, 'TyRo17', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (18, 'acheter', NULL, 'Obtenir contre paiement la propriété et l''usage.
[http://www.cnrtl.fr/definition/acheter]', NULL, 'TyRo18', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (19, 'mandater quelqu''un', NULL, 'Confier une mission, une charge à quelqu''un', NULL, 'TyRo19', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (20, 'caractériser [Immolyon]', NULL, '[18.2.2011, FB] Relever que ce TyRo semble avoir la même signification que le TyRo21 ''concerner'' - vérifier et éventuellement remplacer
/ pour les objets qui entrent dans une association (bien vendu, échangé, possédé, etc.)', NULL, 'TyRo20', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (22, 'enregistrer', NULL, 'Inscrire sur un registre de manière à conserver (une information).
Transcrire un acte ou un jugement sur un registre public afin d''en assurer l''authenticité.', NULL, 'TyRo22', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (23, 'attester', NULL, 'Fournir une attestation', NULL, 'TyRo23', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (24, 'rédiger', NULL, 'Mettre par écrit, en particulier sous une forme définitive ou selon la forme requise.', NULL, 'TyRo24', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (25, 'léguer', NULL, '/ "Laisser par testament ou par un autre acte de dernière volonté" (http://www.cnrtl.fr/definition/leguer)', NULL, 'TyRo25', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (26, 'estimer', NULL, 'Evaluer approximativement un prix, une quantité, une distance, etc.', NULL, 'TyRo26', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (27, 'hériter', NULL, 'Devenir propriétaire, possesseur (de quelque chose); recevoir (quelque chose) par droit de succession, par héritage.
Prendre possession (de quelque chose), recevoir quelque chose qui était précédemment attribué à une autre personne.', NULL, 'TyRo27', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (28, 'constituer', NULL, 'Attention ! ce TyRo n''est utilisé dans aucune TyIn', NULL, 'TyRo28', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (29, 'contenir', NULL, '''Enfermer dans son espace et sa capacité.'' [http://www.cnrtl.fr/definition/contenir]', NULL, 'TyRo29', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (30, 'déposer', NULL, 'Attention ! ce TyRo n''est utilisé dans aucune TyIn', NULL, 'TyRo30', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (31, 'représenter', NULL, 'Agir ou parler au nom de quelqu''un; remplacer quelqu''un dans l''exercice de ses droits, dans la défense de ses intérêts.[http://www.cnrtl.fr/definition/représenter]', NULL, 'TyRo31', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (32, 'mettre en vente', NULL, 'mettre sur le marché, commercialiser un bien ou un produit', NULL, 'TyRo32', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (33, 'faire une offre', NULL, 'Proposer un prix lors d''une vente', NULL, 'TyRo33', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (34, 'partager', NULL, 'entrer dans  une donation ou un partage, sans que le rôle vis-à-vis de l''objet donné soit précisé.
cette da est notamment utilisée lorsqu''un partage complexe est décomposé en plusieurs fiches', NULL, 'TyRo34', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (35, 'échanger', NULL, 'entrer dans une relation d''échange sans que soit précisé ce que l''acteur apporte ou obtient (auquels cas on utilise les da apporter et obtenir)', NULL, 'TyRo35', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (36, 'apporter', NULL, 'Cas d''un échange ou d''un partage, …', NULL, 'TyRo36', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (37, 'obtenir', NULL, 'Parvenir à se faire accorder, à se faire donner (ce que l''on veut avoir, ce que l''on demande)', NULL, 'TyRo37', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (40, 'naître', NULL, 'Commencer sa vie, entrer dans le processus biologique propre aux êtres animés. Venir au monde.', NULL, 'TyRo40', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (41, 'délivrer', NULL, 'Délivrer un diplôme, une distinction, un titre', 'ex doublon créé par le créateur sous le nom Apporter - da36', 'TyRo41', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (44, 's''unir', NULL, 'Faire exister ensemble des personnes ou leur vie, leur destinée', NULL, 'TyRo44', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (45, 'mourir', NULL, 'Cesser d''exister, perdre la vie.', NULL, 'TyRo45', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (46, 'éditer', NULL, 'Etre l''éditeur scientifique d''un ouvrage, en tant que personne physique ou morale (editor). Différent de l''éditeur commercial (publisher) et de l''imprimeur.', NULL, 'TyRo46', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (47, 'exercé (être)', NULL, 'Il s''agit de la fonction/profession (institutionnelle ou sociale) exercée', NULL, 'TyRo47', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (48, 'coopérer', NULL, 'Action de coopération (commerciale, industrielle, financière, etc.) entre deux acteurs', NULL, 'TyRo48', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (49, 'créée (être)', NULL, 's''applique à la création d''une entreprise', NULL, 'TyRo49', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (50, 'fonder', NULL, 'Rôle de l''acteur ou de l''institution qui fonde une entreprise, une institution, etc.', NULL, 'TyRo50', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (51, 'fusionner', NULL, 'Unir par fusion (des éléments jusque là distincts).', NULL, 'TyRo51', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (52, 'absorber', NULL, 'Faire disparaître qqc. comme par assimilation progressive', NULL, 'TyRo52', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (53, 'absorbé (être)', NULL, 'Etre aborbé, disparaître', NULL, 'TyRo53', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (54, 'disparaître', NULL, 'Cesser d''exister, mourir dans le cas d''une institution', NULL, 'TyRo54', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (55, 'présider', NULL, 'Avoir la présidence, exercer les fonctions de président.', NULL, 'TyRo55', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (56, 'prendre', NULL, 'Choisir, adopter quelque chose et le faire sien en s''en servant selon l''usage normal.', NULL, 'TyRo56', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (57, 'localisé (être)', NULL, 'Ce rôle associe à l''information l''objet qui est à localiser', '[14.6.2010] Renommé. Anciennement : ''domicilier''.', 'TyRo57', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (58, 'rattacher', NULL, 'Signifie l''association avec l''objet historique qui contrôle, qui patronne, qui regroupe, etc. l''objet dont il est question dans l''information, qui est sujet ou dépendant', NULL, 'TyRo58', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (59, 'rattaché (être)', NULL, 'Signifie l''association avec l''objet historique qui contrôle, qui patronne, qui regroupe, etc. l''objet dont il est question dans l''information, qui est sujet ou dépendant', NULL, 'TyRo59', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (60, 'modifier', NULL, 'Apporter un changement, une précision au sens d''un constituant ou d''une proposition. Changer certains traits, éléments ou certaines qualités de quelque chose sans en altérer la nature ou l''essence.', NULL, 'TyRo60', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (61, 'avoir pour', NULL, 'Détermine une valeur quantitative', NULL, 'TyRo61', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (62, 'Caractériser -&gt; da20', NULL, '/ à supprimer suite à vérification si pas utilisé dans les différentes bases. Noter si on peut le supprimer dans les remarques', NULL, 'TyRo62', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (63, 'être locataire', NULL, 'Prendre quelque chose à loyer, en vertu d''un contrat de louage [http://www.cnrtl.fr/definition/locataire]', NULL, 'TyRo63', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (64, 'être bailleur', NULL, 'louer tout type de local', NULL, 'TyRo64', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (65, 'construire', NULL, 'utilisé pour l''acteur qui réalise la construction', NULL, 'TyRo65', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (66, 'recevoir une proposition', NULL, 'être le destinataire d''une proposition de vente ou d''achat', NULL, 'TyRo66', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (67, 'faire construire', NULL, 'commanditaire d''une construction', NULL, 'TyRo67', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (68, 'devenir', NULL, 's''applique lors d''une absorption avec un changement de nom et la création d''une nouvelle', NULL, 'TyRo68', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (69, 'publier (éditer)', NULL, '"Faire paraître un article, une revue, un ouvrage, en assurer l''impression et la diffusion" (http://www.cnrtl.fr/definition/publier, sens C. du mot)', NULL, 'TyRo69', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (70, 'recevoir', NULL, '1. Qqn reçoit (qqc.) (de qqn). 
[Le suj. désigne le plus souvent une pers., un groupe, un organisme]
a) Être mis en possession de, accepter, accueillir (ce qui a été envoyé, transmis, donné).
α) [Le compl. désigne des valeurs concr., matérielles] Recevoir un appel téléphonique, un cadeau, une lettre, un message, un paquet, un télégramme; recevoir de l''argent, l''aumône, un paiement, des subventions, un traitement; reçu mille francs de M. Un Tel; recevoir un prix, une récompense; recevoir des garanties, des offres; recevoir une donation, un legs; recevoir des étrennes. (http://www.cnrtl.fr/definition/recevoir)', NULL, 'TyRo70', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (71, 'verser', NULL, 'Remettre à titre de paiement ou de dépôt, à une personne, un organisme ou une caisse.', NULL, 'TyRo71', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (72, 'justifier', NULL, 'Permet de qualifier la raison, la cause de l''information (par ex. une recette, une présence, etc.).
En régle générale, on peut associer via ce rôle soit un objet abstrait décrivant en général un droit ou une raison qui justifie l''information; soit une autre information qui décrit la raison qui fonde l''information en question', NULL, 'TyRo72', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (73, 'bénéficier', NULL, '"Jouir, profiter de quelque chose.  Bénéficier d''un droit, d''une immunité, d''un non-lieu, d''un privilège, d''un sursis, etc. ." (http://www.cnrtl.fr/definition/beneficier)', NULL, 'TyRo73', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (74, 'débiteur (être)', NULL, '"(Personne) qui est redevable de quelque chose à quelqu''un" (http://www.cnrtl.fr/definition/débiteur)', NULL, 'TyRo74', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (75, 'disposer', NULL, '"Décider d''attribuer à quelqu''un un bien" (http://www.cnrtl.fr/definition/disposer)', NULL, 'TyRo75', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (76, 'parrainer', NULL, '/Servir de parrain ou de marraine à (un enfant). 
/Accorder son parrainage à quelqu''un ou à quelque chose
[http://www.cnrtl.fr/definition/parrainer].', NULL, 'TyRo76', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (42, 'louer', NULL, 'Attention, ce TyRo n''est attribué à aucune TyIn', NULL, 'TyRo42', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (77, 'témoin (être)', NULL, '/ être témoin à un acte civil, judiciaire ou autre', NULL, 'TyRo77', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (78, 'célébrer', NULL, '/Accomplir les cérémonies d''un culte.
[http://www.cnrtl.fr/definition/academie8/célébrer]', NULL, 'TyRo78', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (79, 'associer', NULL, '/"Former une société avec quelqu''un" [http://www.cnrtl.fr/definition/associer]. 
Usage restreint aux TyIn de la classe ''vie économique'' [ClTI2]', NULL, 'TyRo79', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (80, 'demander', NULL, '/ Utilisé pour associer des objets historiques dont le rôle dans l''information est de demander.
/ Par ex. : demander des funérailles, etc.', NULL, 'TyRo80', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (81, 'acquitter (vie économique)', NULL, '/ Constater par une formule (p. ex. pour acquit), suivie de la date et de la signature, le paiement de la dette inscrite sur la pièce [http://www.cnrtl.fr/definition/acquitter]', NULL, 'TyRo81', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (82, 'demander la catégorie', NULL, '/ Spécifie l''objet (à l''intérieur d''un ensemble) sur lequel porte l''information.', NULL, 'TyRo82', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (83, 'demander la présence', NULL, '/ Demander la présence d''un acteur nominativement ou d''un type d''acteur (objet abstrait)
/ A distinguer de "être présent" (TyRo7)', NULL, 'TyRo83', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (84, 'demander l''absence', NULL, '/ Demander l''absence d''un acteur nominativement ou d''un type d''acteur (objet abstrait).', NULL, 'TyRo84', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (85, 'demander le célébrant', NULL, '/ Demander nominativement ou par une typologie d''acteur (objet abstrait) le célébrant d''une cérémonie
/ A distinguer de ''célébrer'' (TyRo78)', NULL, 'TyRo85', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (86, 'demander de localiser', NULL, '/ Demander que l''évènement, etc. se passe à tel lieu, auprès de telle institution, etc.
/ A distinguer de "localiser" (TyRo8)', NULL, 'TyRo86', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (87, 'recevoir un acte notarié', NULL, '/ Etablissement par un notaire d''un acte, ce qui confère à ce dernier le caractère d''authenticité attaché aux actes de l''autorité publique', NULL, 'TyRo87', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (88, 'passer un acte', NULL, '/ Faire établir un acte par un notaire.', NULL, 'TyRo88', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (89, 'mentionné (être)', NULL, '/Etre mentionné dans un document (sans avoir un rôle plus spécifique), dans un ouvrage, etc.', NULL, 'TyRo89', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (90, 'tester', NULL, '/ Indiquer ses dernières volontés par oral ou par écrit.
/ "Faire son testament, exprimer par écrit, et selon les formes requises, ses dernières volontés". (http://www.cnrtl.fr/definition/tester)', NULL, 'TyRo90', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (91, 'légataire universel (être)', NULL, '/"Personne qui bénéficie de la totalité des biens du testateur" [http://www.cnrtl.fr/definition/legataire]
/A distinguer du légataire à titre universel : "personne qui bénéficie d''une part des biens du testateur. Les légataires à titre universel seront tenus de demander la délivrance aux héritiers auxquels une quotité des biens est réservée par la loi; à leur défaut, aux légataires universels (Code civil, 1804, art. 1011, p. 184)" [http://www.cnrtl.fr/definition/legataire]', NULL, 'TyRo91', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (92, 'exécuteur testamentaire (être)', NULL, '/ "Exécuteur testamentaire. Personne désignée par testament et qui est chargée d''accomplir certaines volontés et certains actes énoncés par le testataire" [http://www.cnrtl.fr/definition/executeur]', NULL, 'TyRo92', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (93, 'légataire particulier (être)', NULL, '/ "Personne qui bénéficie d''un bien particulier du testateur." [http://www.cnrtl.fr/definition/légataire]
/ Si la personne ou l''institution concernée ne reçoit qu''une partie d''un legs, à partager avec d''autres, utiliser le TyRo94: légataire particulier partiel (être)', NULL, 'TyRo93', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (94, 'légataire particulier partiel (être)', NULL, '/ Permet de traiter la décomposition d''un legs particulier en plusieurs parties. 
/ A distinguer du TyRo93 : légataire particulier (être)', NULL, 'TyRo94', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (96, 'payeur (être le)', NULL, '/ " Celui (celle) qui paie." [http://www.cnrtl.fr/definition/payeur]
/ Sert à distinguer, si besoin est, le payeur de l''Actr ou du CoAc qui est à l''origine du paiement.
/ Doit être distingué du ''payeur'' dans une institution.', NULL, 'TyRo96', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (99, 'créancier (être)', NULL, '/ "Celui (celle) à qui est due une  somme d''argent."
[http://www.cnrtl.fr/definition/créancier]', NULL, 'TyRo99', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (100, 'garantie de (être la)', NULL, '/ "Action ou moyen de garantir quelque chose à quelqu''un."
[http://www.cnrtl.fr/definition/garantie]', NULL, 'TyRo100', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (101, 'locataire principal (être)', NULL, '/ "Personne qui prend à loyer un logement et le sous-loue en partie ou en totalité à d''autres personnes."
[http://www.cnrtl.fr/definition/locataire]', NULL, 'TyRo101', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (102, 'licencier', NULL, '/ Pour une entreprise ou un employeur individuel, action de renvoyer quelqu''un d''un emploi, d''un poste.', 'Synonymes : congédier, débaucher, renvoyer, révoquer.', 'TyRo102', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (103, 'licencié (être)', NULL, '/ Être renvoyé d''un emploi, d''un poste, par une entreprise ou un employeur individuel.', 'Synonyme : être congédié, débauché, renvoyé, révoqué', 'TyRo103', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (104, 'embaucher', NULL, '/ " Engager (quelqu''un) contre un salaire, pour une durée plus ou moins longue" [http://www.cnrtl.fr/definition/embaucher]', '/Synonyme : recruter.', 'TyRo104', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (105, 'embauché (être)', NULL, '/ "Etre engagé contre un salaire, pour une durée plus ou moins longue" [http://www.cnrtl.fr/definition/embaucher]', 'Synonyme : être recruté', 'TyRo105', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (106, 'remettre', NULL, '/ Attribuer à quelqu''un un objet marquant un caractère distinctif : décoration, médaille, prix, etc.
/ Ce rôle servira aussi pour la vie religieuse : remise d''habit, du chapeau cardinalice, etc.', NULL, 'TyRo106', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (107, 'appelé sous les drapeaux (être)', NULL, '/ Être convoqué pour effectuer son service militaire.', NULL, 'TyRo107', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (108, 'incorporer', NULL, '/ "Introduire une personne dans un groupe humain." [http://www.cnrtl.fr/definition/incorporer]', NULL, 'TyRo108', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (109, 'évalué (être)', NULL, '/ Etre l''objet d''un jugement de valeur, d''une évaluation.', NULL, 'TyRo109', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (111, 'candidater', NULL, '/ Faire acte de candidature.', NULL, 'TyRo111', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (112, 'candidature (être l''objet d''une)', NULL, '/ Ce type de rôle sert à désigner la fonction sociale ou la fonction institutionnelle à laquelle postule un candidat.', NULL, 'TyRo112', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (113, 'inscrire', NULL, '/ "Écrire, noter sur un document, un registre ou tout autre support."[http://www.cnrtl.fr/definition/inscrire]', NULL, 'TyRo113', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (114, 'inscrit (être)', NULL, '/ Pour un acteur, avoir son nom porté dans un registre ou sur un document', NULL, 'TyRo114', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (116, 'affecté (être)', NULL, '/ Pour une personne ou une chose, être l''objet d''une décision d''une autorité la destinant ou l''assignant à un usage ou à un emploi précis.', NULL, 'TyRo116', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (117, 'affecter (à un usage, à un poste, à un service...)', NULL, '/ Destiner ou assigner quelqu''un ou quelque chose à un usage, un service ou un emploi.', NULL, 'TyRo117', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (118, 'abandonner', NULL, '/ "Renoncer à un pouvoir, à des droits, à la possession d''un bien ou à l''utilisation d''une chose." [http://www.cnrtl.fr/definition/abandonner]', NULL, 'TyRo118', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (119, 'organiser', NULL, '/ "Préparer (une réunion, un spectacle, une manifestation, etc.) selon un plan précis, en vue d''un résultat déterminé." [http://www.cnrtl.fr/definition/organiser]', NULL, 'TyRo119', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (120, 'inviter', NULL, '/"Prier de venir (en un lieu), d''assister ou de prendre part (à)." [http://www.cnrtl.fr/definition/inviter]', NULL, 'TyRo120', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (121, 'invité (être)', NULL, '/ Etre "prié de venir (en un lieu), d''assister ou de prendre part (à)." [http://www.cnrtl.fr/definition/inviter]', NULL, 'TyRo121', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (122, 'confirmer', NULL, '/ "Garantir la validité d''un acte public ou privé en donnant son approbation ou en renouvelant (souvent par écrit) une affirmation à ce sujet." [http://www.cnrtl.fr/definition/confirmer]', NULL, 'TyRo122', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (123, 'effectuer', NULL, '/ "Mettre à effet, à exécution ; mener à bien." [http://www.cnrtl.fr/definition/effectuer]', NULL, 'TyRo123', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (124, 'caution (être la)', NULL, '/ "Engagement donné ou pris pour garantir l''exécution d''une obligation; p. méton., somme ou personne servant de garantie." [http://www.cnrtl.fr/definition/caution]', NULL, 'TyRo124', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (125, 'attribuer', NULL, '/ "Donner à quelqu''un une chose dans un partage, une répartition, une adjudication, comme sa part, son lot, etc."  [http://www.cnrtl.fr/definition/attribuer]', 'Rôle créé dans le cadre d''une enquête sur les synodes provinciaux réformés au XVIIe s., puis élargi dans sa signification (bhours 10.04.2011)', 'TyRo125', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (126, 'chargé de (être)', NULL, '/ Forme passive de : " confier la responsabilité, la mission ou le soin de." [http://www.cnrtl.fr/definition/charger]', 'Rôle créé dans le cadre d''une enquête sur les synodes provinciaux réformés au XVIIe s.', 'TyRo126', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (127, 'chargé de verser (être)', NULL, 'Avoir la responsabilité d''effectuer un versement financier', 'Rôle créé dans le cadre d''une enquête sur les synodes provinciaux réformés au XVIIe s.', 'TyRo127', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (128, 'représenté (être)', NULL, '/ Forme passive de :"Rendre présent sous la forme d''un substitut" (http://www.cnrtl.fr/definition/représenter).
/ Plus spécifiquement : Etre présent par le truchement d''une tierce personne désignée pour cela', 'Rôle créé dans le cadre d''une enquête sur les synodes provinciaux réformés au XVIIe s., puis élargi dans sa signification (FB, 19.2.2011)', 'TyRo128', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (129, 'patronner', NULL, '/ "Apporter un soutien financier, aider de sa renommée, de son autorité" (http://www.cnrtl.fr/definition/patronner)', NULL, 'TyRo129', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (130, 'édité (être)', NULL, '/ Etre l''objet, le résultat d''une édition. 
/ Les objets associés relèvent habituellement de la bibliographie, mais on pourait également concevoir une association avec des objets abstraits (par ex. une revue dont on ne connaît pas le titre)', NULL, 'TyRo130', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (131, 'enseigné (être)', NULL, '/ Matière ou sujet d''un enseignement.', NULL, 'TyRo131', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (132, 'se former', NULL, '/ "Acquérir un niveau intellectuel, culturel, etc. en développant certaines connaissances, habitudes, manières, qualités." [http://www.cnrtl.fr/definition/former]', NULL, 'TyRo132', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (133, 'fréquenter', NULL, '/ "Se rendre souvent dans un lieu ou chez quelqu''un." (http://www.cnrtl.fr/definition/fréquenter)', 'A été créé dans le cadre d''un projet sur les professeurs de théologie et de philosophie à l''époque moderne.', 'TyRo133', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (134, 'étudier', NULL, '/ "Suivre un enseignement en vue d''acquérir des connaissances dans un domaine précis." (http://www.cnrtl.fr/definition/étudier)', NULL, 'TyRo134', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (136, 'encadré (être)', NULL, '/ Etre placé dans un cadre, pour un ouvrage iconographique.', 'Rôle défini dans le cadre d''une recherche sur les collections iconographiques des évêques français d''ancien régime.', 'TyRo136', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (137, 'annoter', NULL, '/ Inscrire une annotation dans un texte (MaOb). Le type d''annotation (remarque, correction, rature, censure, etc.) sera spécifié par l''AbOb associé à l''information.', NULL, 'TyRo137', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (139, 'absent (être)', NULL, '/ Ce rôle est à utiliser uniquement par l''information ''Absence'', pour y rattacher l''acteur (Actr) ou l''institution (CoAc) absent(e).', NULL, 'TyRo139', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (110, 'opinion (exprimer une)', NULL, 'Ce r&ocirc;le indique de fa&ccedil;on g&eacute;n&eacute;rique l''acteur, l''institution, le caract&egrave;re social ou fonction institutionnelle qui exprime une opinion.
La connotation plus pr&eacute;cise du type d''opinion (informelle, avis autoris&eacute;, etc.) est exprim&eacute;e par le type d''information. Ce type de r&ocirc;le poss&egrave;de donc une connotation g&eacute;n&eacute;rique.', NULL, 'TyRo110', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (141, 'classer', NULL, '/ "Ranger, distribuer dans des catégories distinctes selon des critères définis" [http://www.cnrtl.fr/definition/classer]', NULL, 'TyRo141', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (142, 'reproduire', NULL, '/ "Produire une copie, une nouvelle version, une représentation de quelque chose." (http://www.cnrtl.fr/definition/reproduire)', NULL, 'TyRo142', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (143, 'documenter', NULL, '/ "Appuyer, étayer (un ouvrage, un travail) par des documents" (http://www.cnrtl.fr/definition/documenter)', NULL, 'TyRo143', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (144, 'confier', NULL, '"Remettre quelqu''un ou quelque chose à la garde, aux soins d''une personne dont on est sûr." (http://www.cnrtl.fr/definition/confier)', NULL, 'TyRo144', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (145, 'éduquer', NULL, '/ "Elever. Donner à quelqu''un, spécialement à un enfant ou à un adolescent, tous les soins nécessaires à la formation et à l''épanouissement de sa personnalité." [http://www.cnrtl.fr/definition/Eduquer]', 'Il s''agit de la responsabilité effective de l''éducation qui met en jeu la ou les personnes qui élèvent un enfant', 'TyRo145', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (146, 'collaborer', NULL, '/ "Travailler en collaboration, Participer à l''élaboration d''une œuvre, contribuer à un résultat" (http://www.cnrtl.fr/definition/collaborer)', NULL, 'TyRo146', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (147, 'technique (être la)', NULL, '/ "Qui est relatif aux procédés utilisés pour la réalisation d''une activité particulière, au savoir-faire requis pour la maîtrise d''une tâche, d''une activité" (http://www.cnrtl.fr/definition/technique)', NULL, 'TyRo147', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (148, 'support (être le)', NULL, '/ "Matériau, milieu matériel sur lequel est appliqué quelque chose".
/ En particulier : "Élément matériel susceptible de recevoir une œuvre graphique ou picturale" [http://www.cnrtl.fr/definition/support/II.C]', NULL, 'TyRo148', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (149, 'avoir lieu', NULL, '/ "Se produire à un endroit ou à un moment donné" [http://www.cnrtl.fr/definition/lieu]', NULL, 'TyRo149', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (150, 'annoncer', NULL, '/"Faire connaître oralement ou par écrit à un moment du temps et de manière à frapper l''attention, une nouvelle encore inconnue ou un événement imminent." [http://www.cnrtl.fr/definition/annoncer]', NULL, 'TyRo150', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (151, 'chanter', NULL, '/ "Chanter  un morceau de musique vocale, une composition lyrique,  une chanson, un refrain, etc 
[http://www.cnrtl.fr/definition/chanter]', 'TyRo créé pour le dépouillement de sermons funéraires luthériens du XVIe s. (Leichenpredigt)', 'TyRo151', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (152, 'donner', NULL, '/ "Céder gratuitement et volontairement la propriété d''une chose" [http://www.cnrtl.fr/definition/donner]', NULL, 'TyRo152', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (153, 'prier', NULL, '/ "S''adresser à Dieu dans une prière instante; s''adresser à un saint pour lui demander d''intercéder auprès de Dieu." [http://www.cnrtl.fr/definition/prier]', NULL, 'TyRo153', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (154, 'Lire', NULL, '/ "Suivre des yeux ce qui est écrit ou imprimé, avec la connaissance des sons que les lettres figurent; soit en ne proférant pas les mots, soit en les proférant à haute voix. " [http://www.cnrtl.fr/definition/academie8/lire]', NULL, 'TyRo154', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (155, 'Lu (être)', NULL, '/ Forme passive du TyRo154 ''lire''', NULL, 'TyRo155', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (157, 'Démissionner', NULL, 'Renoncer officiellement à une fonction, à une charge, à une dignité, donner sa démission. [http://www.cnrtl.fr/definition/démissionner]', NULL, 'TyRo157', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (158, 'Réintégrer', NULL, 'Rétablir un fonctionnaire ou un employé dans son emploi, dans ses fonctions après un congé, une disponibilité ou après annulation d''une décision de révocation.
[http://www.cnrtl.fr/definition/réintégrer]', NULL, 'TyRo158', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (159, 'être réintégré (dans ses fonctions)', NULL, 'Pour un fonctionnaire ou un employé, être rétabli dans son emploi, dans ses fonctions après un congé, une disponibilité ou après annulation d''une décision de révocation.
[http://www.cnrtl.fr/definition/réintégrer]', NULL, 'TyRo159', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (160, 'publier (rendre public)', NULL, '"Faire connaître quelque chose, et (plus usuel) annoncer officiellement quelque chose au moyen d''un texte écrit ou d''un communiqué oral. Publier un avertissement, un bulletin de santé, une circulaire, ses fiançailles, des mensonges, des recherches sur qqc., la vérité." (sens A. du mot, http://www.cnrtl.fr/definition/publier)', NULL, 'TyRo160', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (161, 'publié (rendu public), être', NULL, 'Forme passive de ''publier (au sens de rendre public)''. Cf. TyRo160 pour la définition', NULL, 'TyRo161', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (162, 'signer', NULL, '"Revêtir un écrit de sa signature. Signer un chèque, une lettre; signer un acte, un bail; signer un décret, une loi; signer un chèque* en blanc; signer une pétition; parapher et signer un acte. " (http://www.cnrtl.fr/definition/signer)', NULL, 'TyRo162', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (163, 'authentifier', NULL, '"Attester, certifier le caractère authentique de quelque chose ou de quelqu''un." (http://www.cnrtl.fr/definition/authentifier)', NULL, 'TyRo163', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (164, 'imprimer', NULL, '"Reproduire des caractères ou des images en utilisant les techniques de l''imprimerie. Presse à imprimer; imprimer un livre, une brochure, un manuscrit; imprimer tant d''exemplaires." (Sens II.A.1, http://www.cnrtl.fr/definition/imprimer)', NULL, 'TyRo164', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (115, 'prononcer un engagement', NULL, '/ S''engager par une déclaration solennelle et publique. Par exemple : prononcer un serment, prononcer des voeux de religion, etc.', NULL, 'TyRo115', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (165, 'condamné (être)', NULL, 'Forme passive de : "Déclarer quelqu''un coupable à l''issue d''une sentence judiciaire et le frapper d''une peine" (http://www.cnrtl.fr/definition/condamner)', NULL, 'TyRo165', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (168, 'défendeur (être le)', NULL, 'Personne contre laquelle est intent&eacute;e une action en justice (http://www.cnrtl.fr/definition/d&eacute;fendeur)', NULL, 'TyRo168', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (166, 'impliquer', NULL, '"Supposer, entraîner comme conséquence logique" ( http://www.cnrtl.fr/definition/impliquer).
Utilisé pour typer les rôles qui associent une Information qui découle, est impliquée par l''Information en question (analogue à ''justifier'' mais dans l''autre sens).', NULL, 'TyRo166', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (167, 'prononcer une décision', NULL, '"Énoncer un jugement en vertu d''une autorité, d''un pouvoir reconnu" (http://www.cnrtl.fr/definition/prononcer)', NULL, 'TyRo167', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (140, 'caractériser', NULL, '<p>"Constituer le trait distinctif de quelque chose ou quelqu''un." (http://www.cnrtl.fr/definition/caractériser)</p>', '', 'TyRo140', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (39, 'avoir comme membre', NULL, 'Ce rôle est utilisé pour associer un acteur collectif qui a comme menbre un individu ou un autre acteur collectif', NULL, 'TyRo39', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (135, 'situer (génériquement)', NULL, '[21.3.2012, FB] ATTENTION - NE PLUS UTILISER : ce rôle ne doit plus être utilisé et les données remplacées par le TyRo8. [Ancienne explication : ] Ce type de rôle représente une alternative à ''localiser'' pour exprimer une association avec un lieu (généralement de type ''région'', ''Etat'', etc.) sans connaître la localisation précise de l''information, mais seulement sa situation générale.', NULL, 'TyRo135', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (43, 'posséder', NULL, 'Avoir à soi, disposer en maître de (quelque chose), et pouvoir en tirer profit et jouissance. Synon. détenir, être propriétaire de. Posséder des biens, des fonds, des richesses, des terres, des valeurs, de l''immobilier.', NULL, 'TyRo43', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (138, 'occasionner', NULL, '"&Ecirc;tre (volontairement ou non) l''occasion de (quelque chose). Synon. &ecirc;tre l''occasion de, donner lieu &agrave;" (http://www.cnrtl.fr/definition/occasionner). Utilis&eacute; pour exprimer une causalit&eacute; g&eacute;n&eacute;rique, sans d&eacute;termination pr&eacute;cise. Utilis&eacute; en particulier pour associer d''autres Informations qui sont l''occasion &ndash;au sens de l''origine ou du contexte&ndash; de l''Information en question.', 'Utilis&eacute; en particulier pour sp&eacute;cifier une association entre informations. &nbsp; &nbsp;', 'TyRo138', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (7, 'présent (être)', NULL, '<p>"Qui se trouve dans le lieu ou à proximité de la (des) personne(s) dont on parle; qui assiste à l''événement dont il est question" (http://www.cnrtl.fr/definition/present)</p>
<p>Par un rôle ainsi typé, on relève simplement la présence d''un acteur à un évènement, virtuellement à l''ensemble de sa durée. Si on souhaite retenir les dates ou le moment précis d''une présence, il est préférable de créer une <strong>Information de type ''Présence''</strong> (TyIn104).</p>
<p>Par exemple, pour retenir la présence d''un pasteur à un Synode, il est préférable de créer une information Présence qu''on associera à l''information Synode, en ayant ainsi la possiblité de spécifier si la durée de la présence correspond à celle de l''assemblée, ou est plus courte, etc. En revanche, dans le cas de la présence de quelques personnes à un mariage, on pourra utiliser des rôles du présent type pour les associer à l''évènement.</p>', '<p>[30/08/2012] Pour plus de souplesse, on a renoncé à ce qui suit et on permet les deux possibilités : ''présence'' via un rôle ou via l''association à une information de type Présence, en fonction des cas et de la complexité des informations.</p>
<p>[22/10/2010] ATTENTION : n''utiliser désormais que pour rattacher à l''info "Présence", recoder les autres infos.</p>', 'TyRo7', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (169, 'participer', NULL, '<p>"Prendre part activement à quelque chose. Participer à une activité, à un jury, à un travail, une élection, une cérémonie, une discussion, une expédition, une fête, une opération, une réunion." (http://www.cnrtl.fr/definition/participer)</p>', '', 'TyRo169', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (97, 'sujet (être le)', NULL, '<p>"Ce qui constitue la matière, le thème principal d''une activité intellectuelle ou artistique, indépendamment de l''interprétation qui en est faite ou du résultat obtenu." (http://www.cnrtl.fr/definition/sujet).</p>
<p>Généralement l''objet associé est un AbOb, mais il peut être également un SoCh, un Actr, un CoAc ou autre sujet abordé dans le texte, oeuvre, etc.</p>', '', 'TyRo97', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (171, 'adopter', NULL, '<p>"II.B Choisir de propos délibéré quelque chose pour le faire sien, s''y rallier, y conformer sa vie" (http://www.cnrtl.fr/definition/adopter/)</p>', '', 'TyRo171', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (21, 'concerner', NULL, '<p>Type de rôle générique qui indique sur quels objets historiques porte une information.</p>
<p>Des précisions seront fournies par rapport à chaque TyIn ou TyCo utilisant ce TyRo.</p>', '', 'TyRo21', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (98, 'typer', NULL, '<p>"Marquer d''un type, d''une empreinte correspondant à certaines caractéristiques." (http://www.cnrtl.fr/definition/typer)</p>
<p>En règle générale, on ne doit utiliser qu''un rôle de ce type par Information ou Contenu. Si on souhaite proposer un typage multiple, il faut utiliser les TyRo141 : ''classer'', TyRo95 : ''qualifier'' ou TyRo140 : ''caractériser''.</p>', '', 'TyRo98', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (172, NULL, NULL, '', '', 'TyRo172', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (173, NULL, NULL, '', '', 'TyRo173', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (95, 'qualifier', NULL, '<p>"Marquer de telle qualité, caractériser en attribuant une qualité, une appellation, un titre." [http://www.cnrtl.fr/definition/qualifier]</p>
<p>A distinguer de ''caractériser'' (TyIn140) et de ''typer'' (TyIn98)</p>', '<p>ADMINISTRATEURS : mieux définir l''articulation avec ''caractériser''.</p>
<p>Proposition : utiliser ''typer'' pour une première typologie générale, un seul type par information ; ''qualifier'' pour aporter des précisions typologiques supplémentaires, comme une sorte de sous-type, qui peuvent être multiples ; ''caractériser'' en réserve pour des d''autres types de caractéristiques, en réservante le couple typer-qualifier à un usage général.</p>
<p>Il y a ensuite encore ''classer'' dont le sens pourrait être plus lié à des regroupements selon des critéres à définir – mais là on touche souvent à la problématique de travaux individuels ou de groupes de recherche. </p>', 'TyRo95', NULL);
INSERT INTO type_role (pk_type_role, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour) VALUES (174, 'classé (être)', NULL, 'Associe l''UC classée', NULL, NULL, NULL);


--
-- TOC entry 2378 (class 0 OID 0)
-- Dependencies: 180
-- Name: type_role_pk_type_role_seq; Type: SEQUENCE SET; Schema: tables_types; Owner: -
--

SELECT pg_catalog.setval('type_role_pk_type_role_seq', 174, true);


--
-- TOC entry 2363 (class 0 OID 19371)
-- Dependencies: 181
-- Data for Name: type_unite_connaissance; Type: TABLE DATA; Schema: tables_types; Owner: -
--

INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (147, 'Géolocaliser', NULL, 'Cette unité de connaissance permet de renseigner la géolocalisation d''un lieu grâce à des coordonnées géographiques', NULL, NULL, NULL, true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (4, 'Election', NULL, NULL, NULL, 'TyIn8', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (15, 'Offre d''achat', NULL, NULL, NULL, 'TyIn18', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (24, 'Coopération', NULL, NULL, 'A laisser en suspens', 'TyIn29', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (94, 'Représentation visuelle multiple', 'Ouvrage iconographique – Reproduction digitale', 'Ce type d''information permet de recenser toute forme de représentation visuelle ou ''iconographique'' d''un objet  (un acteur, un lieu, un immeuble, une médaille, etc.) dont il existe (ou a existé) plusieurs exemplaires identiques : une photo, une estampe, une carte géographique, etc. 
Le rôle ''Typer'', obligatoire, permet de spécifier le type de représentation (photo, estampe, etc.) - alors que les TyRo147 et TyRo148 permettront de donner plus de détails le cas échéant.

Si la représentation est connue par sa publication dans un ouvrage, indiquer dans les sources de l''Information la référence bibliographique. 
Même traitement si son existence est connue par la mention dans un manuscrit (MaOb) ou sur un site web  (WeRe) 
En revanche, si on dispose d''une reproduction digitale (DiOb) déposée sur un serveur, à usage interne d''un groupe de recherche, ou si on connaît un site web qui rend accessible une reproduction digitale (WeRe), associer celle-ci à l''information grâce à l''association ''Reproduction''.', NULL, 'TyIn107', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (60, 'Représentation visuelle unique', 'Ouvrage iconographique', '/ Cette information indique l''existence d''une oeuvre iconographique concrète et unique, entendue au sens de forme de représentation iconographique ou visuelle (y compris la sculpture).
/ Normalement, un ouvrage iconographique est connu sous la forme d''un MaOb (un tableau  conservé dans tel musée, telle statue à tel endroit précis, etc.) ou serait identifiable comme tel s''il était connu (par exemple un portrait dont on ne connaît pas le lieu de conservation suite à une vente).
/ Cet objet concret, ayant ou ayant eu une existence réelle, est associé à son(ses) auteur(s), à un type, à un sujet, à un lieu de production.
/ Pour toute représentation dont plusieurs exemplaires identiques sont connus, voir TyIn107, ''Représentation visuelle multiple''
/ si on dispose d''une reproduction digitale déposée sur un serveur, à usage d''un groupe de recherche ou publiable, ou si on connaît un site web qui rend accessible une reproduction digitale, associer celle-ci via l''onglet [en cours] : reproduction de l''objet, tout en spécifiant les métadonnées relatives à celle-ci parmi les ''reproductions digitales'' (DiRe).', NULL, 'TyIn68', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (90, 'Intervention manuscrite', 'Annotation – Expurgation', 'Renseigne toute intervention manuscrite d''un acteur sur un objet matériel, par exemple une annotation dans un livre, une correction dans un manuscrit, etc.
Si une fiche information ''exemplaire'' concernant l''objet sur lequel l''intervention manuscrite a été ajoutée a été créée, on peut rattacher à celle-ci, de façon hiéarchique, la fiche ''intervention manuscrite''', NULL, 'TyIn102', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (124, 'Opinion exprimée à l''égard d''un objet', 'Débat historiographique – Interpretation', '<p>Ce type d''information permet de renseigner une opinion exprim&eacute;e par un acteur, ou &eacute;ventuellement par un acteur collectif, au sujet d''un objet.</p>
<p>En cr&eacute;ant une information caract&eacute;ris&eacute;e avec ce TyIn on exprime l''id&eacute;e d''une opinion g&eacute;n&eacute;rale, telle qu''elle subsiste &agrave; un moment donn&eacute;, ou pendant une certaine p&eacute;riode, et qui peut &ecirc;tre reconstitu&eacute;e &agrave; partir de plusieurs sources. Si on souhaite exprimer une opinion manifest&eacute;e par un auteur dans un document particulier, il faut imp&eacute;rativement utiliser un contenu de TyCo2 (cf. onglet Classes et associations).</p>
<p>L''opinion envisag&eacute;e par le TyIn100 est de type g&eacute;n&eacute;rique, informel. Si on souhaite exprimer une notion plus pr&eacute;cise il faudra utiliser d''autres types d''information, par exemple le TyIn79 pour la "formulation d''un avis autoris&eacute;".&nbsp;</p>
<p>Ce TyIn permet de traiter &eacute;galement des interpr&eacute;tation d''&eacute;v&egrave;nement historiques, des d&eacute;bats historiographiques, etc. : c''est &agrave; l''objet abstrait associ&eacute; via le r&ocirc;le ''typer'' qu''il revient de sp&eacute;cifier s''il s''agit d''un d&eacute;bat historiographique, de l''interpr&eacute;tation d''un &eacute;v&egrave;nement, de l''opinion exprim&eacute;e au sujet d''une doctrine, ou d''un acteur, etc.</p>', NULL, 'TyIn100', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (2, 'Notes de cours', NULL, 'Reportatio', NULL, 'TyIn4', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (91, 'Exemplaire', 'Spécimen', '" Chacun des objets, et généralement des documents ou des ouvrages imprimés, reproduits d''après un type donné. " (http://www.cnrtl.fr/definition/exemplaire)
L''association se fait normalement entre un objet matériel et une référence bibliographique, étant donné que celle-ci représente en quelque sorte une classe d''exemplaires particuliers. 
Un autre cas de figure est celui de l''exemplaire (MaOb) d''une Représentation iconographique multiple (c''est-à-dire une Info de type TyIn107) telle une estampe ou une gravure.', NULL, 'TyIn103', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (65, 'Licenciement', 'congédiement – débauchage – renvoi – révocation', '/Ce type d''information sert à désigner le renvoi de quelqu''un de son emploi ou de son  poste par un acteur colllectif (par exemple une entreprise)  ou par un employeur individuel. 
/La cause du licenciement peut être indiquée soit par un objet abstrait, soit - si un événément particulier est à l''origine du licenciement - par une information.', NULL, 'TyIn74', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (30, 'Localisation', 'Domiciliation', '/ Type d''information générale concernant la domiciliation d''un acteur, d''une entreprise, le territoire d''un état, etc.  ATTENTION : la cardinalité maximale ''1'' sur l''association ''localiser'' impose de créer une fiche ''localisation'' pour chaque lieu (NaPl) qui localise un objet (acteur, acteur collectif). on a en revanche le droit de localiser une information avec un lieu et un immeuble.
/ Pour la localisation lors de la fondation, utiliser le TyIn30 : Création d''une institution
/ Localisation du lieu d''habitation ou de domiciliation d''un acteur ou d''une institution (adresse, commune) entendu au sens général et à spécifier avec le type (domicile fiscal, domicile secondaire, etc.)', NULL, 'TyIn36', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (11, 'Exercice de pouvoir', NULL, '[en construction]
Cette information permet de renseigner les rapports génériques de pouvoir entre acteurs, institutions, institutions entre elles, etc.
Si on veut renseigner un rapport d''appartenance institutionnalisé et stable, utiliser le TyIn37 : Rattachement à une institution', NULL, 'TyIn99', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (66, 'Embauche', 'Recrutement', '/Désigne l''engagement de quelqu''un contre un salaire, en vue d''un travail ou d''une activité et cela pour une durée plus ou moins longue.
/La propriété numérique sert à préciser - si elle est connue - la durée pour laquelle l''embauche a été prévue. Il ne s''agit pas de la durée de l''emploi qui pourra être déduite à partir d''une autre information comme par exemple un type d''information ''licenciement'' (TyIn74) ou ''fonction (exercice)'' (TyIn7)
/Une information ''fonction (exercice)'' (TyIn7) pourra être mise en relation avec un TyIn75.', NULL, 'TyIn75', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (109, 'Placard officiel imprimé', 'Affiche officielle', 'Placard ou affiche imprimée qui publie une décision officielle.
Ce TyIn a été crée pour récenser l''existence de placards issus de la juridiction ecclésiastique ou civile dans l''Italie moderne. L''information rapporte l''existence du placard en tant que collection des exemplaires conservés (MaOb: indiquer ceux qui sont connus dans le sourçage, ne pas associer par un rôle) et elle retient quelques éléments formels tel l''auteur, l''objet qui est rendu public, etc.', 'Problème de la date (préciser) / Distinguer l''information concernant l''affichage', 'TyIn124', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (85, 'Représentation', 'test', 'Etre en situation d''agir, de parler au nom de quelqu''un ou de le remplacer dans l''exercice de ses droits ou dans la défense de ses intérêts.
[http://www.cnrtl.fr/definition/représentation]', 'MCD créé dans le cadre de l''étude des Actes synodes provinciaux de l''Eglise réformée de Bourgogne au XVIIe s. La modélisation associe donc l''information &quot;représentation&quot; à une information &quot;assemblée&quot; qui désigne l''assemblée dans laquelle la représentation a lieu.', 'TyIn95', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (89, 'Encadrement', NULL, 'Ce type d''information permet de décrire la manière dont un ouvrage iconographique (estampe, peinture, dessin, etc) est encadré (taille, matériau, ornementation, etc.)', 'TyIn défini dans le cadre d''une recherche sur les collections iconographiques des évêques français d''ancien régime', 'TyIn101', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (12, 'Qualité (obtenir une)', 'Acquérir une qualité, un titre, un diplôme – Obtenir un diplôme, titre académique, nobiliaire', 'Une Information de ce type renseigne l''évènement de l''aquisition d''un titre académique, d''un titre nobiliaire, etc. Exemples:  docteur en théologie, baron, etc.
Pour le fait de possèder une qualité, indépendamment de son acquisition, utiliser le TyIn130 et lui associer éventuellement l''Information ''acquisition'' via le rôle ''justifier''.', 'Dans le cas d''un titre nobiliaire hérité, l''association &quot;délivrer&quot; (da41) ne doit pas être remplie', 'TyIn11', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (13, 'Intermédiation', NULL, 'Cas où un acteur désigne un autre pour effectuer des démarches à sa place (agent immobilier,…)', 'Cette information est nécessairement associée à une autre (vente, héritage, partage, etc.)', 'TyIn16', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (14, 'Mise en vente', NULL, 'Cas des mises aux enchères - prix demandé initial', NULL, 'TyIn17', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (100, 'Invitation', NULL, 'Action d''inviter à prendre part à un événement, à une réception.', NULL, 'TyIn114', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (17, 'Funérailles', 'Sépulture', '<p>En préparation : ne pas utiliser pour l''instant.</p>', '<p>Donner à cette information un caractère générique, pour tout rite, etc. ?</p>', 'TyIn135', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (16, 'Enregistrement', NULL, 'Enregistrement et authentification des actes publics (notaire, tabellion,…)', 'cette information est nécessairement associée à une autre (vente, contrat de mariage, etc.) elle permet entre autres d''identifier les notaires', 'TyIn19', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (123, 'Avis (formulation d''un)', 'Jugement (formulation d''un) – Opinion (formulation d''une)', '<p>Expression d''une opinion, d''un avis ou d''un jugement r&eacute;sultant d''une r&eacute;flexion, d''une d&eacute;lib&eacute;ration sur une question, un probl&egrave;me pr&eacute;cis et pouvant concerner un objet ou un acteur. Cet avis a donc un caract&egrave;re plus officiel que la simple opinion exprim&eacute;e sur un sujet (cf. TyIn100), il implique une notion d''autorit&eacute;.</p>
<p>Avis : formuler une "opinion r&eacute;sultant d''une r&eacute;flexion, d''une d&eacute;lib&eacute;ration sur une question, un probl&egrave;me pr&eacute;cis, et destin&eacute;e &agrave; &ecirc;tre communiqu&eacute;e." [http://www.cnrtl.fr/definition/avis]</p>
<p>Il convient de cr&eacute;er une information chaque fois qu''un objet ou un acteur historique est concern&eacute; par un avis.</p>', NULL, 'TyIn79', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (129, NULL, NULL, '', '', 'TyIn136', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (18, 'Héritage [Immolyon]', NULL, 'Attention : uniquement pour projet Immolyon, ne pas utiliser dans d''autres contextes.
Concerne les successions, pas les donations ni les partages. Fiche créée pour rendre compte de la transmission des biens immobiliers, même si elle peut servir pour d''autres objets', 'lorsque la valeur des biens immobiliers légués est indiquée, on l''entre comme une estimation, en information associée.
pour les successions complexes il est conseillé de créer plusieurs informations &quot;héritage&quot; associées.', 'TyIn21', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (19, 'Testament [Immolyon]', NULL, '/ tout type de testament (olographe ou non). la date est celle de la rédaction du testament, pour l''ouverture par le notaire, utiliser l''information "Enregistrement" (de19)', 'les dispositions testamentaires peuvent être entrées dans le descriptif mais la transmission elle-même est une autre information (Héritage le plus souvent).', 'TyIn22', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (138, 'A réutiliser', NULL, NULL, NULL, 'TyCo9', '2012-10-23 23:10:36.876166', false, NULL, 'Cont');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (5, 'Vente [Immolyon]', NULL, 'Attention : uniquement pour projet Immolyon, ne pas utiliser dans d''autres contextesCaractérise Tout type de vente d''objet immobilier et mobilier
Réalisé dans le cadre du projet ''Immolyon''. Pour d''autres projets, utiliser ''vente'' (en général) (TyIn)', 'Si plusieurs objets sont vendus et que l''on a à la fois un prix global et un prix par objet, il faut  décomposer l''événement en plusieurs ventes, reliées à la vente centrale', 'TyIn9', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (8, 'Fusion', NULL, 'Fusion entre deux (ou plus) intitutions à 50 % - 50 % ; en cas de changement de raison sociale utilisation de la da51 (création d''une nouvelle institution)', 'A modifier (23/07/2009) intégrer la da &quot;devenir&quot; à la place de &quot;être créer&quot;', 'TyIn31', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (10, 'Epicedium', NULL, 'Poème funéraire', 'TyIn créé pour l''analyse des sermons funéraires (Leichenpredigt) luthériens du XVIe siècle.', 'TyIn119', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (146, 'A réutiliser', NULL, NULL, NULL, 'TyCo7', '2012-10-23 23:10:36.876166', false, NULL, 'Cont');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (20, 'Partage', NULL, 'fiche créee pour rendre compte des transmissions patrimoniales hors héritage (donations, liquidation d''une succession, partage entre propriétaires). Concerne notamment toutes les donations)', 'En cas de partage complexe, il est ocnseillé de créer plusieurs informations &quot;partage&quot; associées entre elles (par exemple, une par immeuble)', 'TyIn23', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (22, 'Échange', NULL, 'Utilisé pour des mutations ne relevant ni de la vente ni des transmissions patrimoniales mais d''un accord (par exemple, traité entre une municipalité et une sociétré immobilière pour un échange de terrains)', 'En cas d''échange complexe (portant par exemple sur plusieurs biens), il est conseillé de créer plusieurs informations &quot;échange&quot; associées.', 'TyIn25', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (23, 'Possession', NULL, 'Possession (si on le souhaite, spécifier le type de bien : biens immobiliers, etc.)', NULL, 'TyIn28', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (27, 'Liquidation', NULL, 'Disparition d''une institution sans reprise par une autre (assimilable à décès pour un acteur)', NULL, 'TyIn33', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (26, 'Estimation', NULL, '<p>Attention : Uniquement pour projet Immolyon, ne pas utiliser dans d''autres contextes.<br /> &Eacute;valuation approximative d''une quantit&eacute; nombrable (valeur, prix, distance, poids, etc.).<br /> Le type de quantit&eacute; sera indiqu&eacute; en choisissant le type de valeur quantitative associ&eacute;e &agrave; l''information.<br /> Il est pr&eacute;f&eacute;rable de d&eacute;composer l''information et de cr&eacute;er un fiche Info pour chaque objet estim&eacute;. <br /> Si on souhaite regrouper les estimations, on cr&eacute;e une Info pour l''&eacute;v&eacute;nement qui constitue le cadre de l''estimation, et on rattache toutes les fiches estim&eacute;es, par voie hi&eacute;rarchique, &agrave; cet &eacute;v&egrave;nement.</p>', NULL, 'TyIn20', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (28, 'Séance', NULL, 'Cette information fait état de la réunion en séance des membres d''une institution ou d''un organisme.
Il s''agit d''un type d''information générique, le type de séance pouvant être spécifié grâce au type de rôle : typer.', NULL, 'TyIn34', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (29, 'Retraite', NULL, 'Départ en retraite', NULL, 'TyIn35', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (83, 'Attribution de crédit', NULL, 'Modélisation des entités et rôles mis en oeuvre dans la décision d''attribuer des crédits à un ou plusieurs acteurs', 'MCD réalisé dans le cadre d''une étude sur les synodes provinciaux réformés du XVIIe siècle. 
L''échéance estune valeur au mêm titre que le montant', 'TyIn93', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (31, 'Changement de nom', NULL, 'Concerne le changement de raison sociale, le changement de nom d''une institution, etc. (sans création d''une nouvelle fiche pour une nouvelle institution)', 'Le titre remplace : &quot;Modification statutaire&quot;. Va être modifier selon nouveau schéma (23/07/2009) deviendrait changement de raison sociale', 'TyIn38', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (32, 'Actionnaire (être)', NULL, 'Possession de parts dans une institution : être actionnaire (dans le cas d''une SA par exemple) ou être associé (dans le cas d''une SNC par exemple)', NULL, 'TyIn39', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (33, 'Possession d''obligations', NULL, 'Etre en possession d''obligations ou de rentes d''Etat émises par une institution.
L''institution concernée est l''émetteur des obligations.', NULL, 'TyIn40', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (34, 'Statut', NULL, 'Concerne la modification statutaire (ex : passage de SARL à SA)', 'Remplace la de38 / va être remplacé lors de la création de la table &quot;forme juridique&quot; / à garder et à changer en &quot;modification statutaire&quot;', 'TyIn41', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (36, 'Effectif', NULL, 'Concerne l''évolution des effectifs d''une institution', NULL, 'TyIn44', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (37, 'Chiffre d''Affaires', NULL, 'Concerne l''évolution du chiffre d''affaire d''une institution', NULL, 'TyIn45', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (38, 'Résultat d''exercice', NULL, 'Concerne le résultat de l''exercice d''une institution (bénéfice ou perte à préciser dans l''information s''il s''agit du résultat avant ou après impôt).', NULL, 'TyIn46', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (39, 'Forme du nom', NULL, 'Ce type d''information indique que la fiche concerne la forme du nom d''un acteur, d''une institution, etc.', 'On insère la CFNA (nom acteur) ou CFNI (nom institution) dans la table externe des associations et on peut donner des indications bibliographiques, insérer des remarques, etc.', 'TyIn47', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (40, 'Location à usage commercial', NULL, 'concerne les locations immobilières. vaut aussi pour les locations à usage industriel et l''immobilier de bureau', NULL, 'TyIn48', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (41, 'Construction', NULL, 'fiche créée pour les constructions d''immeubles, peut concerner d''autres types de constructions.', NULL, 'TyIn49', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (42, 'Réglement de copropriété', NULL, 'désigne l''établissement d''un nouveau réglement de copropriété ou la modification d''un réglement existant', 'les rédacteurs sont les propriétaires de l''immeuble mis en copropriété. si un notaire ou un autre acteur intervient, on utilisera intermédiation (de16) et enregistrement (de19)', 'TyIn50', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (43, 'Pension (ecclésiastique)', NULL, '"DR. CANON. Somme que l''on prenait autrefois, chaque année, sur les revenus d''un bénéfice. Il a résigné son prieuré, et a retenu six cents francs de pension. Il a obtenu trois mille livres de pension sur tel évêché. Un brevet de pension sur une abbaye (Ac. 1798-1878). Un édit de juin 1671 autorisait les titulaires de cures ou de prébendes à les résigner avec réserve de pension (Marion Instit. 1923)." (http://www.cnrtl.fr/definition/pension)', NULL, 'TyIn52', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (45, 'Constitution de rente', NULL, 'Contrat passé par devant notaire en vertu duquel un revenu périodique produit par un capital (ou ''principal'') aliéné ou cédé, est versé par la personne qui bénéficie de ce capital, à celle qui l''a cédé.', 'Ce TyIn est a été construit dans le cadre d''une recherche concernant l''Ancien Régime.', 'TyIn69', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (46, 'Rattachement à une institution', NULL, '<p>Exprime le lien structurel entre acteurs collectifs, notamment entre institutions.</p>
<p>Par ex. un service est rattach&eacute; &agrave; un organisme, ou une province est rattach&eacute;e &agrave; un &eacute;tat.</p>
<p>Le TyRo95 - qualifier permet d''indiquer de quel type de rattachement il s''agit.</p>', NULL, 'TyIn37', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (48, 'Signature autographe', NULL, '/ Indique l''existence d''une signature autographe. On associe à l''information un auteur, concerné par cette information, et (de façon facultative) un lieu de rédaction de l''autographe. Ne pas confondre ce lieu avec celui de conservation de l''autographe, qu''on peut calculer à partir des indications concernant la source de cette information. 
/ Si on a créé une fiche information concernant l''existence du document sur lequel figure l''autographe (par ex. une lettre), on peut rattacher de façon hiérarchique (cardinalité max. 1 à n) l''information ''Autographe'' à l''information ''Lettre''.', NULL, 'TyIn57', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (49, 'Quittance', NULL, '/ Quittance entendue sous la définition de reconnaissance de paiement (ex : loyers, ventes, etc.)
/ Le payeur effectif peut être différent du débiteur
/ Le droit ou obligation qui fonde la quittance peut être associé (via le type de rôle ''justifier'') en tant qu''objet abstrait ou sous forme d''une autre information (par exemple une recette) qui justifie la quittance', NULL, 'TyIn59', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (53, 'Vente', NULL, '"Action de céder un bien contre de l''argent, contre paiement; contrat qui lie le vendeur et l''acheteur"
(http://www.cnrtl.fr/definition/vente)', NULL, 'TyIn61', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (50, 'Demande de funérailles', NULL, 'Ce TyIn analyse la demande de funérailles inscrite dans un testament, qui donne des directives pour l''organisation de la cérémonie.', 'Modélisation réalisée dansle cadre de recherches sur les testaments lyonnais d''Ancien Régime. / Il n''est pas nécessaire de répéter ici l''acteur qui demande les funérailles,  si l''information est reliée à l''information « testament »', 'TyIn60', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (51, 'Célébration religieuse chrétienne', NULL, '<p>Célébration en règle générale, par exemple dans le cas d''une messe. Le TyRo ''typer'' définit aussi bien le rite (protestant ou catholique) que le type de célébration (messe haute, messe basse, mariage, etc.)</p>
<p>Pour le baptême, utiliser le TyIn15. </p>', '', 'TyIn58', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (55, 'Testament', NULL, '/ Déclaration écrite (ou, sous certaines conditions, orale) des dernières volontés d''une personne (cf. http://www.cnrtl.fr/definition/testament).
/ Ce TyIn décrit le testament comme tel et non pas l''acte passé devant le notaire. L''information correspondante à ce cernier doit être saisie séparément (TyIn62), et le testament rattaché à l''acte comme à une information supérieure hiérarchiquement.
/ Les legs et autres dispositions testamentaires sont saisis en tant qu''informations séparées et rattachées hiérarchiquement à celle-ci', NULL, 'TyIn63', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (56, 'Legs', NULL, '/ "Disposition à titre gratuit faite par un testateur de ses biens, en tout ou partie, au profit d''une ou plusieurs personnes physiques ou morales" (http://www.cnrtl.fr/definition/legs)
/ Un legs ne doit porter que sur un seul objet légué. En d''autres termes, pour chaque objet légué il faut rédiger une fiche information.
/ Ce TyIn doit être rattaché de façon hiérarchique au type d''information supérieur: testament (TyIn63).', NULL, 'TyIn64', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (57, 'Demande d''intercession', NULL, '/ Ce TyIn peut être rattaché de façon hiérarchique à d''autres Informations (par ex. testament, faire un voeu, ...)', NULL, 'TyIn65', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (59, 'Permis de lecture', NULL, '/ Délivrer le permis de lire un ouvrage interdit
/ Contexte de création du TyIn : Ancien régime, Inquisition, censure', NULL, 'TyIn67', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (61, 'Procuration', NULL, 'Écrit constatant un mandat attribué à une personne et en déterminant l''étendue (http://www.cnrtl.fr/definition/procuration)', 'Ce TyIn a été créé dans le cadre d''une étude d''actes notariés.', 'TyIn70', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (62, 'Location', NULL, 'Contrat par lequel une personne loue quelque chose (bien foncier ou immobilier, objet matériel) à une autre.', NULL, 'TyIn71', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (63, 'Obligation', NULL, 'Acte authentique par lequel une personne se reconnaît débitrice envers une autre d''une somme d''argent à titre de prêt ou autre cause, aux conditions arrêtées dans cet acte [http://www.cnrtl.fr/definition/Obligation]', NULL, 'TyIn72', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (79, 'Fermage', NULL, 'Mode d''exploitation agricole moyennant un loyer annuel versé par l''exploitant au propriétaire de l''exploitation.', 'Ce TyIn analyse le contenu d''un contrat de fermage. Il est associé au TyIn ''Passage d''un acte notarié'' qui analyse les données relatives au passage de l''acte lui-même (notaire, lieu, circonstances particulières)', 'TyIn89', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (64, 'Métayage', NULL, 'Contrat d''exploitation agricole en vertu  duquel le propriétaire et l''exploitant d''un domaine se partagent la récolte dans des proportions fixées par contrat (http://www.cnrtl.fr/definition/Métayage)', 'Ce TyIn analyse le contenu d''un contrat de métayage. Il est associé au TyIn ''Passage d''un acte notarié'' qui analyse les données relatives au passage de l''acte lui-même (notaire, lieu, circonstances particulières)', 'TyIn73', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (67, 'Vêture', NULL, 'Cérémonie de la prise d''habit par un postulant à un ordre religieux.
 (http://www.cnrtl.fr/definition/vêture)', NULL, 'TyIn76', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (68, 'Affectation militaire', NULL, '/Ce type d''information concerne les différentes affectations que peut connaître un individu effectuant son service militaire ou sa carrière pour un militaire de carrière. Celles-ci constituent des segments dont l''ensemble représente la durée totale du service militaire accompli par un jeune citoyen ou de la carrière d''un militaire.
/la localisation concerne le lieu d''affectation, i.e. lieu de garnison.
/On créera une fiche information "affectation militaire" pour chaque changement de régiment ou de lieu de garnison de l''individu concerné.
/Ce type d''information doit être lié par un type de rôle "justifier" (TyRo72) à un type d''information "service militaire" (TyIn88).', NULL, 'TyIn77', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (84, 'Versement [Dépense]', NULL, 'Action de verser de l''argent, en une seule ou plusieurs fois
[http://www.cnrtl.fr/definition/Versement]', 'MCD créé dans le cadre d''une étude sur les synodes provinciaux réformés du XVIIe s. Il décrit les versements de crédits ordonnés par les synodes provinciaux.
Le choix a été fait de créer un type Information Versement[Dépenses] (TyIn94) en complément du type Information Recettes (TyIn51) car on peut avoir connaissance d''un versement sans avoir de données sur la recette lui correspondant.', 'TyIn94', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (69, 'Caractère physique', NULL, '/Ce TyIn est utilisé pour qualifier un trait physique notable concernant un individu.
/Il est notamment utilisé pour traiter les informations  concernant les caractéristiques physiques d''un individu telles qu''elles sont relevées, par exemple, à l''occasion d''un conseil de révision militaire ou d''une visite d''embauche.
/Si le caractère physique est de nature qualitative on précisera cette nature en associant à l''information un objet abstrait (bosse, rachitisme, malformation...) grâce au type de rôle "qualifier".
/Si le caractère physique est de nature quantitative (taille, poids) on utilisera les valeurs quantitatives.
/Le type de rôle "concerner" sert à désigner, d''une part,  l''individu auquel se rapporte le caractère physique et, d''autre part et éventuellement, la partie du corps concernée (dos, bras, tête...).', NULL, 'TyIn78', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (70, 'Candidature', NULL, '/Définition : acte de postuler à une place, à un poste ou à un titre.', NULL, 'TyIn80', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (71, 'Inscription dans un registre', NULL, '/Définition : Action de porter le nom de quelqu''un ou une mention que l''on veut conserver dans un registre. Cette inscription s''accompagne souvent de l''attribution d''un numéro d''inscription.
/Ce type d''information est  utilisé pour traiter l''enregistrement d''un individu dans un registre (d''embauche, d''enrôlement pour l''armée par exemple). 
/ Généralement la nature de l''inscription est déduite du registre constituant la source de l''information. Cet ''objet matériel (MaOb) est lié à l''information par l''association sourcer qui n''est pas indiquée sur le MCD car elle est commune à toutes les informations.
/A noter que dans le cas d''un registre d''embauche ce type d''information est à distinguer de l''embauche elle-même qui peut se réaliser ensuite - c''est le cas le plus fréquent -, avec un délai plus ou moins long, ou ne pas survenir l''inscription dans le registre.
/ La propriété numérique de l''information sert à enregistrer le n° ou le rang d''inscription de la personne inscrite dans le registre.', NULL, 'TyIn81', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (73, 'Affectation (à emploi, un service, un usage)', NULL, 'Fait par lequel une autorité affecte quelqu''un un emploi ou un service précis; fait d''être affecté à un emploi, à une fonctin  ou à un service précis.
/Ce type d''information peut être précéder par une embauche lorsqu''il s''agit d''une première affectation.', NULL, 'TyIn83', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (74, 'Abandon de scolarité', NULL, 'Ce type d''information est destiné à traiter l''arrêt d''un cursus scolaire par un individu.', NULL, 'TyIn84', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (75, 'Moyenne (obtention d''une)', NULL, 'Ce TyIn est destiné à traiter l''obtention d''une moyenne scolaire.
/Le type de rôle ''qualifier'' (TyRo95) sert à préciser la nature de la moyenne (trimestrielle, semestrielle, annuelle...)
/Ce TyIn sera généralement - si l''information est connue - associer à une information de TyIn96 par le type de rôle ''concerner'' (TyRo21) pour connaître l''établissement dans lequel la formation est suivie.
/ la valeur quantitative sert à indiquer la valeur de la moyenne. Le type de valeur sert à indiquer si la moyenne est sur 20, sur 10 etc.', 'MCD créé dans le cadre de l''étude d''un cursus scolaire', 'TyIn85', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (76, 'Nationalité politique', NULL, 'Ce type d''information est utilisé pour qualifier l''acquisition d''une nationalité politique. Cette dernière est entendue comme un lien juridique et politique qui rattache un individu à un État souverain.
/Ce TyIn ne peut être utilisé pour coder un sentiment d''appartenance à une nationalité qui ne serait pas constituée en Etat-Nation. Un autre TyIn devrait alors être créé.', NULL, 'TyIn86', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (102, 'Prière', NULL, '/ "Élévation de l''âme vers Dieu (ou une divinité) pour lui exprimer son adoration ou sa vénération, ses remerciements ou actions de grâces, pour obtenir ses grâces ou ses faveurs; acte par lequel on s''adresse aux saints pour obtenir leur intercession auprès de Dieu." [http://www.cnrtl.fr/definition/pri%C3%A8re]', 'TyIn créé pour l''analyse des sermons funéraires (Leichenpedigt) luthériens du XVIe siècle.', 'TyIn116', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (103, 'Lecture', NULL, '/ "Action de lire, de déchiffrer visuellement des signes graphiques qui traduisent le langage oral. Lecture à haute voix, mentale, silencieuse. " [http://www.cnrtl.fr/definition/lecture]', NULL, 'TyIn117', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (77, 'Réception mondaine', NULL, 'Réunion de personnes invitées à caractère mondain.
/Pour indiquer la présence d''une personne à une réception mondaine il convient de créer une information ''présence'' (TyIn104) qui sera associée à l''information ''réception mondaine'' par un rôle de type ''concerner'' (TyRo21).
/Pour préciser le lieu où se tient la réception deux cas se présentent : si on sait que la réception se déroule au domicile des organisateurs, en ce cas on associe l''information "réception mondaine'' à l''information ''localisation'' (TyIn36) précisant l''adresse du domicile des organisateurs par un rôle de type localiser (TyRo8) sinon associer un ''named place'' ou lieu avec un TyRo8.
/Si la personne qui invite est différente de l''organisateur il faut créer une information ''invitation'' (TyIn114) qui sera associée à l''information ''réception mondaine'' par un rôle de type ''annoncer'' (TyRo150)', NULL, 'TyIn87', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (78, 'Service militaire actif', NULL, 'Ce type d''information concerne le service militaire actif tel qu''il s''est mis en place en France à partir de 1798 (loi Jourdan).
/Peuvent être rattachées aux informations de ce type celle de type "affectation militaire" (TyIn77)', NULL, 'TyIn88', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (80, 'Transfert d''un(e) religieux(se)', NULL, 'Affectation d''un(e) religieux(se) d''une maison de son ordre à une autre.', 'Ce TyIn a été conçu dans le cadre d''une étude sur les Carmélites françaises de l''Ancien Régime.
Attention : Prévoir une autre modélisation lorsqu''il s''agit du passage d''un ordre religieux à un autre.', 'TyIn90', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (81, 'Assemblée', NULL, 'Modélisation de l''organisation d''une assemblée', 'Mcd réalisé dans le cadre de l''étude des Actes synodes provinciaux de l''Eglise réformée de Bourgogne au XVIIe s. Il propose une modélisation pour toute assemblée. Les liens entre informations sont spécifiques à la modélisation d''un synode. Synode provincial doit être traité tantôt comme un acteur collectif, tantôt comme un objet abstrait, tantôt comme une information.', 'TyIn91', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (82, 'Attribution de l''organisation', NULL, 'Modélisation des entités et rôles mis en oeuvre dans l''attribution à un acteur individuel ou collectif de l''organisation d''un événement.', 'Mcd réalisé dans le cadre d''une étude sur les synodes provinciaux réformés du XVIIe s.
Soit l''attribution de l''organisation se décide au sein d''une asemblée (lien hiérarchique avec l''information TyIn91), soit l''organisation est attribuée par un acteur ou un acteur collectif, nommés ou connus par leur seule fonction sociale (SoCh).', 'TyIn92', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (3, 'Traduction', NULL, 'Traduction d''un manuscrit ou imprimé, produisant un autre manuscrit ou imprimé, avec indication de l''auteur de la traduction et de l''original', NULL, 'TyIn5', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (140, 'A réutiliser', NULL, NULL, NULL, 'TyCo10', '2012-10-23 23:10:36.876166', false, NULL, 'Cont');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (86, 'Edition d''un périodique', NULL, '/ Concerne l''édition de périodiques (revues, séries, etc.). Pour les ouvrages, cf. Ouvrage imprimé (TyIn3)
/ "Assurer la reproduction, la publication et la diffusion d''une œuvre. Éditer une brochure, un dictionnaire, les œuvres complètes de qqn; éditer à ses frais." (http://www.cnrtl.fr/definition/éditer)
/ ATTENTION : les éditeur et publicateurs peuvent être pluriels, mais seulement si leur rôle s''applique à la période donnée par la date de début et de fin de l''information. Si l''éditeur ou la maison d''édition change, il faut créer une nouvelle fiche ''Editer'' avec les dates correspondantes à la nouvelle période.  
/ La localisation, qui peut être plurielle si la maison d''édition a plusieurs sièges, est relative à la période retenue dans la période d''édition. Si le lieu de publication change, il faut créer une deuxième fiche éditer. Par exemple, pour le même périodique, si le lieu d''édition change, il faut créer une nouvelle fiche éditer, en ajoutant un nouveau lieu. D''ailleurs, normalement le changement de lieu d''édition est lié à un changement d''éditeur ou de maison d''édition, ce qui entraîne de toutes façons la création d''une nouvelle fiche', NULL, 'TyIn96', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (104, 'Préface', NULL, '/ "Texte placé en tête d''un ouvrage pour le présenter et le recommander au lecteur, en préciser éventuellement les intentions ou développer des idées plus générales." [http://www.cnrtl.fr/definition/préface]', NULL, 'TyIn118', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (92, 'Présence', NULL, 'Cette information indique la présence d''una acteur ou d''une institution (par exemple une famille) à un évènement. En règle générale, il faut rattacher l''Info ''Présence'' à l''Info de l''évènement en question de façon hiérarchique, c''est-à-dire en copiant la clé Info de l''évènement dans le champ ''Information de rattachement'' de l''Info ''Présence''.
Si le nom précis de la personne présente n''est pas connu, mais seulement sa qualité, on utilise le rôle ''qualifier'', avec sa spécification concerner. Pour des cas plus complexes, par exemple, tel, en qualité d''archvevêque de Lyon, est présent en tant qu''ambassadeur de roi de France, il faut utiliser d''autres types d''information, par exemple ''Représentation''.
Si on souhaite simplement signaler la présence d''une personne dans un lieux, en raison par exemple d''un voyage, on peut utiliser l''Info ''Présence'' sans rattachement à une autre info, et spécifier la raison de la présence avec un AbOb associé via le rôle justifier (TyRo72).
En revanche, pour toute présence à un événement, même connu seulement dans ses traits généraux, on doit créer une Info concernant cet évènement et y rattacher l''Info ''présence''.', NULL, 'TyIn104', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (93, 'Absence', NULL, 'Cette information indique l''absence d''une personne ou d''un acteur collectif (par exemple une famille) lors d''un événement. Les différentes considérations formulées à l''égard de l''information ''Présence'' (TyIn104) s''appliquent à ce TyIn qui, comme le précédent, est associé à la classe ''Participation - présence'' (ClTI20)', NULL, 'TyIn105', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (111, 'Absorption (Intégration)', NULL, 'Absorption d''une institution par une autre. Valable également lors d''un changement de raison sociale avec constitution d''une nouvelle société (id différent)', 'A modifier (23/07/09) supprimer le TyRo68.
Cf. Commentaires.', 'TyIn32', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (142, 'A réutiliser', NULL, NULL, NULL, 'TyCo11', '2012-10-23 23:10:36.876166', false, NULL, 'Cont');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (144, 'A réutiliser', NULL, NULL, NULL, 'TyCo8', '2012-10-23 23:10:36.876166', false, NULL, 'Cont');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (112, 'Amende', NULL, '« Peine pécuniaire infligée pour une infraction » [http://www.cnrtl.fr/definition/amende]
L''information ainsi typée relate uniquement la peine infligée au sens de l''acte de justice qui met en relation les différentes parties. 
Il ne s''agit donc pas de la recette concrète d''une amende : pour saisir celle-ci, utiliser le TyIn51 Recette et associer à l''Information ''Recette'' l''Information ''Amende'' via le rôle ''justifier''.
Le montant de l''amende décidé par le juge doit être renseigné dans le propriétés numériques de l''Information.', NULL, 'TyIn127', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (113, 'Recette', NULL, 'Permet de coder les recettes effectivement reçues de la part d''institutions ou de personnes physiques, due à l''existance d''un droit qui donne lieu à la recette
La raison de la recette, qui est associée via le type de rôle ''justifier'', peut être soit un objet abstrait décrivant en général un droit ou une raison qui justifie la recette; soit une autre information qui décrit la raison qui fonde la recette', NULL, 'TyIn51', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (95, 'Collection', NULL, 'Une information de type collection regroupe une série d''objets ou d''informations qui relèvent d''un ensemble défini à partir d''un critère abstrait. 
Selon l''un des principes fondateurs de SyMoGIH, une collection ne sera pas constituée en fonction d''une problématique de recherche individuelle, mais en ayant le souci de créer une entité ayant une valeur ''objective''. Ainsi, une collection permettra de traiter la ''correspondance'' d''un auteur, la collection de tableaux d''un mécène (si on s''intéresse à celle-ci au sens d''ensemble, sans cerner les entrées et sorties de tableaux, etc.), une série d''archives physiquement dispersée aujourd''hui mais réunie au temps de sa production.
Le critère principal de constitution de la collection sera exprimé par un objet abstrait (AbOb) associé via le rôle ''typer''. Il est par définition unique. L''ObAb correspondant sera défini soigneusement.
Des critères secondaires peuvent être ajoutés avec le TyRo ''classer'' et peuvent être multiples.
Si on veut associer un acteur (Actr), une institution (CoAc) ou un objet précis, ayant une relation spéciale avec la collection on peut utiliser le TyRo ''posséder'' ou le plus générique ''concerner''', 'Type d''information abtstrait de type générique [essai]', 'TyIn108', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (96, 'Objet abstrait composé', NULL, '/ Un objet abstrait composé est un objet abstrait qui résulte de la composition de plusieurs objets abstraits et, éventuellement, des fonctions sociales, des lieux, etc. En remplacement de la création d''un objet absrait (AbOB) reproduisant l''objet abstrait composé, on crée une Information de ce type à laquelle on associe les différents objets abstraits, etc. via le rôle ...
/ Par exemple le portrait d''un prince à cheval comprend deux objets abstraits (le portrait, le cheval) et une fonction sociale (le prince).
/ ATTENTION : définition rôles à compléter - MCD à réaliser', NULL, 'TyIn109', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (97, 'Education', NULL, 'Période de la vie consacrée à l''éducation entendue au sens  de formation générale d'' "une personne, spécialement un enfant ou un adolescent, en développant ses qualités physiques, intellectuelles et morales" [http://www.cnrtl.fr/definition/education]', 'Ce TyIn modélise la charge effective et concrète de l''éducation. Il ne doit pas être cofnfondu avec "Formation (suivre une)"/TyIn98', 'TyIn110', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (98, 'Maladie', NULL, '/ "Altération de l''état de santé se manifestant par un ensemble de signes et de symptômes  et comportant une évolution" [http://www.cnrtl.fr/definition/maladie]
/  Il peut s''agir aussi bien d''une maladie ponctuelle concernant un individu que d''une épidémie  ou d''une endémie abordées dans leur dimension collective.', NULL, 'TyIn112', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (99, 'Chant', NULL, '/ Décrit le fait de chanter.', 'TyIn créé pour l''analyse des Leichenpredigt (sermons funéraires) luthériens du XVIe siècle : décrit le contexte dans lequel l''Actr ou le CoAc sont impliqués dans un chant.', 'TyIn113', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (101, 'Don charitable', NULL, '/ "Bienfait inspiré par l''amour du prochain" [http://www.cnrtl.fr/definition/charité]', 'TyIn créé pour analyser les sermons funéraires (Leichenpredigt) luthériens du XVIe siècle', 'TyIn115', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (105, 'Eloge', NULL, '"Discours prononcé ou écrit vantant les mérites, les qualités de quelqu''un ou de quelque chose."[http://www.cnrtl.fr/definition/eloge]', 'TyIn créé pour l''analyse des sermons funéraires (Leichenpredigt) luthériens du XVIe siècle.', 'TyIn120', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (106, 'Démission', NULL, 'Action, fait pour une personne ou une collectivité de renoncer, généralement de plein gré, à une fonction, à une charge, à une dignité. [http://www.cnrtl.fr/definition/démission]', NULL, 'TyIn121', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (107, 'Réintégration (dans des fonctions)', NULL, 'Fait de rétablir un fonctionnaire dans son emploi, dans ses fonctions après un congé, une disponibilité, ou après annulation d''une décision de révocation   [http://www.cnrtl.fr/definition/réintégrer]', NULL, 'TyIn122', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (54, 'Passage d''un acte notarié', NULL, '/ Faire rédiger un acte par un notaire.
/ Les actes passés seront traités par des Types d''information spécifiques et rattachés à celui-ci en dépendance hiérarchique (filiation de ''l''acte passé'' par rapport au parent ''passage de l''acte'')', NULL, 'TyIn62', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (108, 'Traitement [Rémunération]', NULL, 'Rémunération principale des fonctionnaires publics, civils et militaires. Le plus souvent il est fixe et payable par douzième mensuel. Dans certains cas le traitement est éventuel (cas des conservateurs des hypothèques, des receveurs municipaux, des receveurs de l''enregistrement etc. au XIXe siècle). Parfois le traitement fixe peut se combiner avec un traitement éventuel (cas trésoriers-payeurs généraux, des greffiers des cours et des tribunaux...  au XIXe siècle).
(CNRTL et M. Block, Dictionnaire de l''administration française, Paris, 1877-1885, tome 2, p. 978). 
Le fonctionnaire qui perçoit le traitement est désigné par le TyRo70 (recevoir). 
La justification du traitement, lorsqu''elle est connue, s''accompagne de la création d''une information de type Fonction (exercice de la) (TyIn7) à laquelle l''information "Traitement" est reliée par l''intermédiaire d''un rôle "justifier" (TyRo72). Le traitement est ainsi justifié par la fonction exercée par le fonctionnaire.
Le rôle "verser" (TyRo71) permet de désigner l''institution ou la fonction qui sont chargées de verser le traitement.
Le rôle "qualifier" (TyRo95) permet de préciser le type de traitement (il peut s''agir par exemple d''un traitement fixe ou bien d''un traitement éventuel comme les remises des receveurs de l''enregistrement français, proportionnées au recettes opérées par leurs soins.', 'Ce type d''information a été créé dans le cadre d''un travail sur les employés de l''octroi de Lyon dans la seconde moitié du XIXe siècle.', 'TyIn123', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (114, 'Caution financière', NULL, 'Engagement donné ou pris pour garantir l''exécution d''une obligation financière. 
Les cautions judiciaires sont à traiter par un autre type d''informations. 
Le montant de la caution doit être renseigné parmi les propriétés numériques de l''Information.', '', 'TyIn126', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (115, 'Procès civil', NULL, 'Litige soumis à un tribunal au civil', '', 'TyIn128', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (118, 'Posséder une qualité', NULL, 'Ce TyIn permet d''enregistrer la qualité (Social Character) portée par une personne : qualificatif d''honorabilité (Bourgeois, honorable, etc.), titre de noblesse (ecuyer, marquis, etc.) etc. Il a été créé dans le cadre d''une enquête à partir des qualités attribuées à des individus dans les registres paroissiaux d''ancien régime à Lyon. Il peut être employé pour d''autre cas : par exemple, à l''époque contemporaine pour une qualité d''honneur attribuée à une collectivité : « village des Justes »,  par exemple.', '', 'TyIn130', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (9, 'Appartenance à une institution', 'Être membre d''un acteur collectif', 'Ce Type d''information générique indique la période d''appartenance à une institution (académie, ordre religieux, etc.). 
Pour spécifier la modalité du début (élection, etc.) ou de la fin, créer des fiches spécifiques et les rattacher à celle-ci (cf. MCD, liens ci-dessous)', NULL, 'TyIn12', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (21, 'Vérifier le type d''information', NULL, 'Permet de traiter les infos sans TyIn', '', 'TyIn24', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (121, 'Document ou acte manuscrit', NULL, '<p>Permet de r&eacute;censer l''existence d''un document manuscrit de type juridique, relevant du droit civil, etc. ou ayant un caract&egrave;re en quelque sorte officiel, tel une expertise, etc.&nbsp;<br /> Une information typ&eacute;e par ce TyIn, se limite a indiquer l''existence du document, son auteur, l''objet concern&eacute; (acteur, caract&egrave;re social, immeuble, etc.) et &agrave; indiquer le type de document.<br /> A ne pas confondre avec ''Ouvrage manuscrit'' qui a une connotation de cr&eacute;ation litt&eacute;raire ou artistique.</p>', NULL, 'TyIn131', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (141, 'Entrée de liste nominative', 'Occurrence dans une liste', '<p>Utilis&eacute; dans le contexte de l''ANR MOSARE. Permet de r&eacute;censer les caract&eacute;ristiques d''un acteur (ou institution) tel/telle qu''il/elle figure dans une liste nominative</p>', NULL, 'TyCo1', '2012-10-23 23:10:36.876166', false, NULL, 'Cont');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (136, 'Opinion exprimée à l''égard d''un objet', NULL, 'Ce type de contenu permet de renseigner une opinion exprimée par un acteur, ou éventuellement par un acteur collectif, dans un document précis, ou dans un passage particulier d''un document.
Un tel contenu est donc différent de l''opinion qu''aurait un acteur en général sur un sujet: il faudrait traiter celle-ci sous forme d''information de type TyIn100 (cf. onglet Classes et associations).
ATTENTION : les rôles utilisables sont encore en cours de définition.', NULL, 'TyCo2', '2012-10-23 23:10:36.876166', false, NULL, 'Cont');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (127, 'Rattachement de territoire', NULL, '<p>ATTENTION : ne pas utiliser ce TyIn sans contacter préalablement les administrateurs–données car il relève de la mise en place du Gazetteer.</p>
<p>Les informations de ce type indiquent que tel lieu (NaPl) de type territoire a été rattaché à tel autre lieu (NaPl) de type territoire. </p>
<p>Par exemple, le duché de Milan à été rattaché au territoire de la couronne d''Espagne.</p>
<p>Ce TyIn est analogue au TyIn37 Rattachement mais celui-ci concerne les territoires et permet de traiter les territoires ''composés'' tandis que le TyIn37 autre concerne la relation entre institutions, en tant qu''acteurs collectifs, sans prendre en compte leur territoire.</p>
<p> </p>', '', 'TyIn133', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (128, 'Baptême', NULL, '<p>Sacrement administré à un enfant ou à un adulte afin de l''introduire dans la communauté chrétienne [http://www.cnrtl.fr/definition/baptême].</p>
<p>Ce sacrement est commun à toutes les confessions chrétiennes : utiliser le rôle ''typer'' pour préciser la confession au sein de laquelle est célébré le baptême.</p>
<p>Si on souhaite traiter les liens généalogiques et familiaux, il est nécessaire de produire, en plus de l''information ''Baptême'', une information de type ''Naissance'' car seule celle-ci pourra être associée à l''information de type ''Union'' (TyIn13). Dans ce cas, on peut associer l''information ''naissance'' à l''information ''baptême'', en utilisant un rôle de type ''concerner'' (TyRo21). </p>
<p> </p>
<p> </p>
<p>à laquelle l''information baptême est reliée entant qu''information inférieure (cf. MCD Liens ''Naissance''). Dans ce cas, si l''information ''Baptême'' est sourcée, il n''est pas nécessaire de sourcer l''information naissance car (par défaut) on peut inférer du lien établi que la source est la même. On peut en revanche ajouter des sources supplémentaires pour la naissance, si on en connaît. </p>', '', 'TyIn15', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (135, 'Dédicace', NULL, '<p>Fait de dédier une œuvre à une personne (généralement très connue) par un hommage imprimé en tête d''un lire, sur une gravure, etc. /Hommage manuscrit sur un livre, une oeuvre iconographique, etc. [http://www.cnrtl.fr/definition/Dédicace]</p>', '<p>Il s''agit aussi bien d''une dédicace imprimée (dédier) que d''une dédicace manuscrite (dédicacer) sur un exemplaire unique. La dédicace est associée hirérarchiquement à l''information indiquant l''ouvrage dans lequel elle figure (cf.mcd de l''association avec d''autres informations ; on spécifie dans l''association les propriétés de celle-ci (pagination). Elle peut aussi être associée par un rôle à d''autres types d''information, par ex. à ''autographe'' par le rôle ''concerner''.</p>', 'TyIn111', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (125, 'Adopter une doctrine', 'Adhérer à une confession – Professer une opinion', '<p>Les Information ainsi typées expriment l''idée d''une adhésion dans le temps à une doctrine, à une confession religieuse, à une opinion, etc., en régle général d''un acteur ou d''un acteur collectif (par exemple, parti politique).</p>
<p>On ne doit donc pas les utiliser pour exprimer une opinion donnée, à un moment particulier, –dans le cas il faut utiliser les TyIn100 ou TyIn79, ou le TyCo2– mais elles exprimes plutôt l''état des convictions d''un acteur (ou acteur collectif) à une époque donnée.</p>
<p>Les Informations de  TyIn132 sont susceptibles d''être sourcées de façon multiple.</p>
<p>Attention : ce TyIn n''a pas été prévu pour traiter l''adhésion à une institution mais uniquement, dans un sens intellectuel, à une doctrine, philosophie, confession religieuse, etc.</p>', '', 'TyIn132', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (131, 'Nomination', NULL, '<p>"Désigner quelqu''un à une charge, à une fonction, à un emploi ; élever quelqu''un à une dignité" (cf. http://www.cnrtl.fr/definition/nommer).</p>
<p>Par cette Information, on ne renseigne que l''<strong>évènement de la nomination</strong>. Pour traiter l''exercice de la fonction qui découle de cette nomination, prière de créer une fiche ''Exercice de fonction'' (TyIn7) et associer l''Info ''Exercice'' à l''Info ''Nomination'' via un rôle TyRo13 du côté de la Nomination.</p>
<p><strong><br /></strong></p>', '<p>Le MCD doit être actualisé !</p>', 'TyIn6', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (133, 'Mariage', NULL, '<p style="margin-bottom: 0cm;">Le mariage peut être défini en tant que "Union d''un homme et d''une femme, consacrée par un ensemble d''actes civils ou parfois religieux et destinée à la fondation d''une famille" (http://www.cnrtl.fr/definition/mariage).</p>
<p style="margin-bottom: 0cm;">Le présent type d''information retient la dimension de <strong>cérémonie civile ou religieuse</strong> qui manifeste publiquement cette union, en associant via les rôles appropriés les principaux participants : époux, célébrant(s), témoins.</p>
<p>Pour relever une présence à la cérémonie du mariage, on peut utiliser des rôles de type TyRo7 ou créer une information de type ''Présence'' (TyIn104).</p>
<p><strong>Attention : </strong>l''information ''Mariage'' vise uniquement l''événement, la cérémonie et non pas la notion de couple pouvant donner lieu à la naissance d''enfants. Cette notion est traitée par les informations de type ''Union'' (TyIn13) qui –dans la sémantique de SyMoGIH– jouent un rôle central.</p>
<p>Si on s''intéresse aux relations parentales et généalogiques, il est donc conseillé de créer préalablement à chaque information ''Mariage'' une information ''Union'' comportant les rôles des deux personnes qui s''unissent. On peut ensuite introduire l''information ''Union'' dans l''information ''Mariage'', via le TyRo21: concerner, et il n''est ainsi pas nécessaire de répéter les rôles des époux car ils sont hérités de l''information ''Union'' préalablement créée. Le sourçage se fera par simple copier-coller.</p>
<p> </p>', '', 'TyIn134', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (6, 'Location à usage d''habitation', NULL, 'concerne les locations immobilières', NULL, 'TyIn10', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (35, 'Capital', NULL, 'Concerne l''évolution du capital social d''une institution', NULL, 'TyIn43', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (72, 'Profession religieuse', NULL, 'Acte par lequel un(e) religieux(se) s''engage définitivement après le noviciat en prononçant ses voeux (faire profession ;  prononcer ses voeux). http://www.cnrtl.fr/definition/Profession', 'CeTyIn décrit les rôles des différents acteurs de la cérémonie localise celle-ci', 'TyIn82', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (116, 'Requête', NULL, '« Demande, sollicitation par écrit adressée à quelqu''un ayant autorité pour prendre une décision » [http://www.cnrtl.fr/definition/requ%C3%AAte]. Les requêtes officielles faites sous forme orale peuvent également être traitées par ce TyIn. 
En règle générale une réponse est apportée à toute requête : voir TyIn125 Décision.', NULL, 'TyIn129', '2012-10-23 23:10:36.876166', false, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (139, 'Description d''un objet iconographique', NULL, '[à préciser]', NULL, 'TyCo4', '2012-10-23 23:10:36.876166', false, NULL, 'Cont');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (137, 'Analyse de contenu', NULL, '<p>Type de contenu générique permettant de décomposer le contenu d''un ouvrage, d''un document, etc. en une série d''unités de connaissance atomisées. <br /> Grâce aux rôles (qui ne sont pas munis d''un TyRo prédéfini) les différents objets mentionnés dans le libellé du contentu (acteurs, institutions, concepts, etc.) sont associés à celui-ci. <br />Par conséquent, la relation entre ces objets est décrite par la/les propriété/s texte du contenu.</p>
<p> </p>
<p>On décompose le contenu d''un ouvrage, d''un document, etc. en une série d''informations atomisées et on associe, via les rôles (même non codés) les différents objets mentionnés dans le libellé de l''information (acteurs, institutions, concepts, etc.). La relation entre ces objets est ainsi décrite dans le libellé littéraire de l''information. </p>', '', 'TyCo3', '2012-10-23 23:10:36.876166', true, NULL, 'Cont');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (143, 'Funérailles', NULL, '<p>Analyse les éléments de la cérémonie des funérailles contenus dans un acte de Registre paroissial de Baptême-Mariage-Sépulture français sur le modèle défini par l''édit de Villers-Cotterêts (1539), en vigueur jusqu''à l''établissement de l''Etat-civil (1792).</p>
<p>Attention 1 : étant donné qu''il s''agit de Contenus, les éléments de connaissance retenus (date, présents, etc.) seront saisis tels que les fournit la source. Si on souhaite mobiliser plusieurs sources pour traiter des funérailles, et éventuellement proposer une date corrigée grâce à l''analyse critique, il faut créer une Information.</p>
<p>Attention 2 : l''inhumation proprement dite devra faire l''objet d''une autre modélisation, qui sera référée au même MaOb que les funérailles.</p>', '', 'TyCo5', '2012-10-23 23:10:36.876166', false, NULL, 'Cont');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (44, 'Biographique (Information)', NULL, 'A défaut d''un type d''information précis, ce type d''information permet d''indiquer un type d''information générique concernant la biographie.', NULL, 'TyIn53', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (25, 'Décès', 'Mourir - mort', '<p>Permet de dater et de localiser la mort d''une personne.</p>', NULL, 'TyIn26', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (148, 'Adresse', NULL, 'Permet de saisir la/les adresse d''un correspondant, un acteur collectif, etc. Adresse mail, postale, téléphone, etc.', NULL, NULL, NULL, true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (149, 'Participation à la réalisation', NULL, 'Cette unité de connaissance représente toute collaboration à une revue, à un projet, à la réalisation d''un filme ou d''un spectacle, etc.', NULL, NULL, NULL, true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (145, 'Entretien', NULL, '<p>On peut typer avec ce TyCo les Contenus qui font &eacute;tat d''un entretien entre une ou plusieurs personnes. Si l''objet de l''entretien est connu, on peut l''associer via le r&ocirc;le opportun, de m&ecirc;me que la ''tonalit&eacute;'' de l''entretien (amical, dispute, etc.) peut &ecirc;tre retenue en associant un objet abstrait appropri&eacute;.</p>
<p>&nbsp;</p>
<p>Si on a des pr&eacute;sents ou t&eacute;moins &agrave; l''entretien, il faudrait utiliser d''autres contenus de type Pr&eacute;sence, en associant celui-ci via un r&ocirc;le.&nbsp;</p>', NULL, 'TyCo6', '2012-10-23 23:10:36.876166', true, NULL, 'Cont');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (153, 'Tâche', NULL, 'Prise de notes personnelles sur une tâche ou un travail à accomplir.', NULL, NULL, NULL, true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (152, 'Notes', NULL, 'Notes et réflexions concernant un objet.', NULL, NULL, NULL, true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (7, 'Union', 'Mariage', 'Union de deux personnes pouvant donner lieu à la naissance d''enfants. Utilisé pour le codage selon la modélisation GEDCOM utilisée par les généalogistes (http://fr.wikipedia.org/wiki/Norme_GEDCOM). Le TyIn "Union" indique donc l''existence dans la durée d''un couple, auquel on peut rattacher des naissances, adoptions, etc. Ce rattachement s''effectuera dans l''information correspondante (naissance, adoption, etc.), en y associant l''information "Union" dans un rôle.
<br/>Le TyIn "Union" regroupe toutes les liaisons, indépendamment de leur forme juridique, et il en indique les extrêmes de la durée (date de début/date de fin). Les unions homosexuelles sont également à encoder avec ce TyIn. On pourra utiliser le rôle ''qualifier'' (TyRo95) pour renseigner la typologie de l''union
<br/>Si des phases de l''union sont à renseigner, on doit créer plusieurs informations de type "Union" correspondantes à chacune des phases.<br/>En revanche, si on veut renseigner des moments ponctuels de l''existence de ce couple, tel "mariage", "rupture", etc. il faudra créer des information spécifiques qu''on pourra ensuite rattacher à l''information "Union". 
', NULL, 'TyIn13', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (110, 'Qualification doctrinale', 'Censure théologique - doctrinale', '<p>Examen doctrinal, expertise par des th&eacute;ologiens ou autres sp&eacute;cialistes du savoir th&eacute;ologique ou para-th&eacute;ologique, d''un imprim&eacute; (apr&egrave;s sa publication), d''un manuscrit, d''une doctrine, d''une oeuvre (au sens du TyIn27).<br /> Le r&ocirc;le ''qualifier'' (TyRo95) permet de savoir de quel type de censure il s''agit (qualification theologique, censure doctrinale pr&eacute;alable &agrave; l''impression, etc.)<br /> Contexte de cr&eacute;ation du TyIn : Inquisition romaine, Index</p>', NULL, 'TyIn2', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (88, 'Formation (suivre une)', 'Etudes (faire des)', 'Fait de se former, d''être formé à une ou à plusieurs matières auprès d''un établissement ou d''un maître.
Par principe, il faudrait créer une information par établissement fréquenté. A chaque établissement, on peut associer plusieurs matières et plusieurs maîtres.
Si on veut en revanche spécifier auprès de quel maître a été apprise telle matière, on peut créer une fiche spécifique à cette information. Et éventuellement la relier de façon hiérarchique à une autre information du même type que indique dans quel établissement s''est faite cette formation auprès du maître', NULL, 'TyIn98', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (52, 'Autographe', NULL, '<p>Indique l''existence d''un autographe.</p>
<p>On associe à l''information un auteur, concerné par cette information, et (de façon facultative) un lieu de rédaction de l''autographe. Ne pas confondre ce lieu avec celui de conservation de l''autographe, qu''on peut calculer à partir des indications concernant la source de cette information.</p>
<p>Si on a créé une fiche information concernant l''existence du document sur lequel figure l''autographe (par ex. une lettre, un manuscrit, etc.), on peut le rattacher à l''information ''Autographe'' via le rôle ''concerner'' (cf. la liste des rôles). Sinon on source l''information de façon standard, en indiquant le MaOb concerné et la localisation précise.</p>', '', 'TyIn56', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (47, 'Relation entre personnes', NULL, 'A défaut d''un type d''information précis, ce type d''information permet d''indiquer toute relation entre personnes.', NULL, 'TyIn55', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (87, 'Enseignement', NULL, '/ Exercer la fonction d''enseigner, avec indication de l''institution auprès de laquelle s''exerce l''enseignement et des matières enseignées.
/ Il s''agit d''un cas particulier du TyIn ''Exercice d''une fonction'' : cf. Classe TyIn ''Exercice d''une fonction''.
/ Attention : ne pas renseigner le lieu si on peut localiser l''institution elle-même.', NULL, 'TyIn97', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (1, 'Ouvrage imprimé', NULL, 'Cette information indique tout simplement (et uniquement) l''existence d''une édition imprimée d''un ouvrage. Elle met en lien auteur(s), titre, lieu d''édition, éditeur(s).
Pour les périodiques, il faut utiliser l''information correspondante : ''Editer un périodique'' (TyIn96).
N.B. Si une référence bibliographique a été associée à cette information avec le rôle ''création (être une)'', elle suffit pour sourcer de l''information, il ne faut pas la répéter dans le formulaire des sources de l''information. Aussi, étant donné l''importance de cette information pour le traitement de la bibliographie (car elle est analogue à l''information ''Naissance'' pour les acteurs) elle est visible pour tous.', 'Pour les préfaces, le financement de l''impression, etc. faire autant de fiches séparées et les lier éventuellement à celle-ci.', 'TyIn3', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (120, 'Ouvrage ou création manuscrite', NULL, 'Indique l''existence d''un ouvrage sous forme manuscrite. Ce type d''information implique la notion de création littéraire, artistique, philosophique.
Il s''agit donc d''un type distinct du type ''Document manuscrit'' qui permet de récenser l''existence d''un texte de type juridique, de droit civil, etc.
Il s''agit d''un objet unique, pas d''une classe de manuscrits.
Attention : A ne pas confondre avec ''Autographe'' (TyIn56) qui indique l''existence d''un texte manuscrit de la main de tel acteur. En revanche, on peut associer une information ''Ouvrage manuscrit'' à une information ''Autographe'' pour indiquer quelle est la main (ou les mains) qu''on trouve dans le manuscrit.
Il s''agit généralement d''un texte, mais ce pourrait être aussi un manuscrit musical. Le TyRo95 - qualifier permet de savoir de quel type de manuscrit il s''agit.
En revanche, si un TyIn existe déjà qui peut se présenter sous forme de manuscrit, c''est celui-là qu''il faut utiliser (par exemple, le TyIn1 pour la lettre). Cf. la classe manuscrits qui liste les types de manuscrits existants.', NULL, 'TyIn42', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (126, 'Analyse de contenu', NULL, '<p>A défaut d''un type d''information plus précis, ce TyIn permet de typer toute information relevant de l''analyse de contenu.</p>
<p><strong>Attention</strong> : si on analyse les unités de connaissance que contient un texte, tel une lettre, un ouvrage imprimé, etc. et qu''on n''utilise qu''une seule source comme origine de la connaissance, <span style="text-decoration: underline;">il est demandé</span> de créer un <strong>Contenu</strong> avec le type TyCo3 homologue au TyIn54. </p>
<p>L''utilisation d''une <strong>Information</strong> de type ''Analyse de contenu'' est réservée aux cas qui demandent un sourçage multiple, soit pour un même document connu sous la forme de dirrérents textes, soit pour renseigner de la bibliogrpahie supplémentaire relative à ce même contenu.</p>', '', 'TyIn54', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (117, 'Décision (administrative, judiciaire)', NULL, '«Disposition arrêtée par une autorité compétente, collégiale ou unique, après délibération» (http://www.cnrtl.fr/definition/décision)
Ce type d''information générique vise tout type de decision administrative, judiciaire, etc. 
Le contenu précis de la décision sera indiqué dans le libellé.', NULL, 'TyIn125', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (134, 'Naissance', NULL, '<p>Renseigne le fait de la naissance d''un acteur, en indiquant sa date et son lieu. Une fois les rôles remplis, le libellé de l''information est calculé automatiquement.</p>
<p>Etant donné son importance pour l''identification des acteurs, un information de ce type ne peut pas être cachée. </p>
<p>L''association avec les parents de l''enfant qui naît se fait en associant cette information à une information de type ''Union'' (TyIn13) préalablement créée. Cette association est la seule manière admise dans la sémantique de la BHP pour associer un enfant à ses parents, au sens biologique du terme. Pour l''adoption ou toute autre forme de parenté, il est nécessaire d''utiliser d''autres types d''informations.</p>
<p>Si on souhaite renseigner la présence de tel ou tel acteur à la naissance, on va créer une nouvelle information de type Présence (TyIn104) et on la rattachera à celle-ci via les rôles. <br />Souvent l''information de la naissance est connue grâce à l''acte de baptême. L''information ''baptême'' (TyIn15) est distincte de l''information ''naissance'', elle a une autre signification, notamment pour ce qui concerne la localisation : il faudra donc, à partir de la même source, produire deux informations distinctes.</p>', '', 'TyIn14', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (122, 'Fonction (exercice de la )', 'Excercer une profession, métier, ... – Occuper une position, statut, ...', '<p>Exercice d''une fonction, d''une profession, etc. : type d''information g&eacute;n&eacute;ral qui permet de coder les activit&eacute;s et segments de carri&egrave;re<br /> Pour l''exercice de fonctions sp&eacute;cifiques, ou dans le cadre de recherches sp&eacute;cifiques concernant ces fonctions (par ex. histoire de l''enseignement), utiliser des types d''information sp&eacute;cifiques (par ex. TyIn97: enseignement) <br /> Pour coder, on dispose de deux possibilit&eacute;s : A. soit on utilise une fonction institutionnelle correspondante &agrave; la fonction exerc&eacute;e (SoCh de type Fonction institutionnelle) ; B. soit on utilise une fonction sociale g&eacute;n&eacute;rale (SoCh) et l''institution concern&eacute;e (par ex. administrateur d&eacute;l&eacute;gu&eacute; / soci&eacute;t&eacute; concern&eacute;e)<br /> / Pour distinguer entre les deux institutions, on utilise l''association ''&ecirc;tre exerc&eacute;'' pour la fonction institutionnelle (cas A.) et ''concerner'' pour l''institution de rattachement (cas B.)</p>', '<p>/ ATTENTION : suite aux r&eacute;marques de la s&eacute;ance commune, remplacer da13 (objet) par da21 (concerner) [26.5.2008]</p>', 'TyIn7', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (130, 'Oeuvre', NULL, '<p>Entité abstraite qui indique l''existence d''une création littéraire ou artistique ayant existé sous plusieurs formes différentes (plusieurs éditions d''un même livre, plusieurs versions manuscrites d''un ouvrage ayant circulé, etc.). </p>
<p>Une ''oeuvre'' est utilisée pour associer plusieurs <strong>Informations</strong> (de type ouvrage imprimé, manuscrit, tableau et ses copies, etc.) se rapportant à la même oeuvre. Il s''agit donc une classe abstraite de toutes les réalisations concrètes d''une oeuvre.</p>
<p>Par exemple, si on doit renseigner la lecture d''un ouvrage imprimé dont on connaît plusieurs éditions - mais on ne sait pas laquelle des éditions a été lue par un auteur, on pourra retenir la lecture de l''oeuvre, tout en rattachant à celle-ci tous ses instances connues ( = Informations de type ouvrage imprimé) du même livre. Dans certains cas, un ouvrage imprimé, manuscrit ou autre peut-être rattaché à plusieurs oeuvres, toujours dans le même sens de classement abstrait.</p>
<p><strong>Attention</strong> : ne pas utiliser pour renseigner l''édition d''un ouvrage, un manuscrit, etc. ! </p>', '', 'TyIn27', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (58, 'Evénement', NULL, '/ Permet de traiter de façon générale un événement, à défaut d''un TyIn plus spécifique. ATTENTION : toujours vérifier s''il n''y a pas un évènement plus spécifique déjà défini.
/ Le contenu de l''événement est indiqué dans le libellé de l''information : il faut ensuite associer des objets historiques dont la relation sera décrite par le contenu de l''information.', NULL, 'TyIn66', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (132, 'Lettre', NULL, '<p>Une Info typée par ce TyIn indique l''existence d''une lettre, associant à celle-ci l''auteur, le destinataire, l''objet matériel (s''il est connu), etc.</p>
<p>On peut renseigner également des lettres dont on ne connait pas le texte mais dont on connait l''existence par d''autres sources.</p>
<p>Une fois qu''on a renseigné les rôles, le libellé sera composé automatiquement par l''application.</p>
<p>On peut, si on le souhaite, ajouter une propriété texte de type ''complément'' contenant un court résumé du contenu de la lettre. <br /> ll est toutefois préférable de décomposer son contenu en une série d''unités de connaissance atomisées. Ces contenus ou informations peuvent être retenus sous forme littéraire : à défaut d''un TyCo ou TyIn plus précis, on peut utiliser le TyCo3 : analyse de contenu.</p>
<p><br /> Le fait de sourcer ces Contenus ou Informations avec l''objet matériel (MaOb) ou unité documentaire (DoUn) correspondant à la lettre permettront de retrouver toutes les unités de connaissance tirées de cette lettre.</p>', '', 'TyIn1', '2012-10-23 23:10:36.876166', true, NULL, 'Info');
INSERT INTO type_unite_connaissance (pk_type_unite_connaissance, nom, autres_noms, descriptif, notes, cle_objet_bhp, date_mise_a_jour, si_utilise, fk_categorie_uc, categorie_uc) VALUES (119, 'Création d''une institution', 'Fondation d''un acteur collectif, fonder une institution, création d''une fonction institutionnelle', 'Ce type d''information a une fonction analogue à celle de la naissance pour un acteur : 
indiquer la date et le lieu de création/fondation d''une institution (acteur collectif, caractère social de type Fonction institutionnelle). 
Par exemple, une entreprise, une académie, un siège épiscopal ou inquisitorial, une fonction publique, etc.
L''information peut concerner à la fois un Acteur collectif ou un Caractère social de type Fonction institutionnelle, tel président de la République française, pape, etc.
La localisation renseignée est celle de l''Institution au moment de la fondation. Si elle évolue dans le temps, il faut utiliser le TyIn36 pour renseigner une ou plusieurs nouvelles ''Localisations''.
De même, le rôle ''rattacher'' ne doit être utilisé que pour mentionner le rattachement de l''institution au moment de sa création. Pour toute modification ultérieure de rattachement, il faut utiliser le TyIn37 ''Rattachement à une institution''.', NULL, 'TyIn30', '2012-10-23 23:10:36.876166', true, NULL, 'Info');


--
-- TOC entry 2379 (class 0 OID 0)
-- Dependencies: 182
-- Name: type_unite_connaissance_pk_type_unite_connaissance_seq; Type: SEQUENCE SET; Schema: tables_types; Owner: -
--

SELECT pg_catalog.setval('type_unite_connaissance_pk_type_unite_connaissance_seq', 153, true);


--
-- TOC entry 2228 (class 2606 OID 19395)
-- Name: associer_type_uc_type_role_pkey; Type: CONSTRAINT; Schema: tables_types; Owner: -; Tablespace: 
--

ALTER TABLE ONLY associer_type_uc_type_role
    ADD CONSTRAINT associer_type_uc_type_role_pkey PRIMARY KEY (pk_associer_type_uc_type_role);


--
-- TOC entry 2230 (class 2606 OID 19397)
-- Name: associer_types_sous_types_pkey; Type: CONSTRAINT; Schema: tables_types; Owner: -; Tablespace: 
--

ALTER TABLE ONLY associer_types_sous_types_objets
    ADD CONSTRAINT associer_types_sous_types_pkey PRIMARY KEY (pk_associer_types_sous_types_objets);


--
-- TOC entry 2226 (class 2606 OID 19399)
-- Name: parametres_pkey; Type: CONSTRAINT; Schema: tables_types; Owner: -; Tablespace: 
--

ALTER TABLE ONLY parametre
    ADD CONSTRAINT parametres_pkey PRIMARY KEY (pk_parametre);


--
-- TOC entry 2232 (class 2606 OID 19401)
-- Name: type_role_pkey; Type: CONSTRAINT; Schema: tables_types; Owner: -; Tablespace: 
--

ALTER TABLE ONLY type_role
    ADD CONSTRAINT type_role_pkey PRIMARY KEY (pk_type_role);


--
-- TOC entry 2234 (class 2606 OID 19403)
-- Name: type_unite_connaissance_pkey; Type: CONSTRAINT; Schema: tables_types; Owner: -; Tablespace: 
--

ALTER TABLE ONLY type_unite_connaissance
    ADD CONSTRAINT type_unite_connaissance_pkey PRIMARY KEY (pk_type_unite_connaissance);


-- Completed on 2013-11-05 16:27:44 CET

--
-- PostgreSQL database dump complete
--

