--
-- PostgreSQL database dump
--

-- Dumped from database version 9.3.1
-- Dumped by pg_dump version 9.3.1
-- Started on 2013-11-05 16:28:42 CET

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 8 (class 2615 OID 19409)
-- Name: tables_objet; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA tables_objet;


SET search_path = tables_objet, pg_catalog;

--
-- TOC entry 221 (class 1255 OID 19410)
-- Name: majuscule_sans_accents(text); Type: FUNCTION; Schema: tables_objet; Owner: -
--

CREATE FUNCTION majuscule_sans_accents(text) RETURNS text
    LANGUAGE sql
    AS $_$
/* fonction modifiée par rapport à celle en ligne, ajoutée un translate avec minuscules */
SELECT translate(upper(translate($1, 'àáâåçèéêëìíîïñòóôõöùûüýÿ', 'aaaaceeeeiiiiinooooouuuyy')),  'ÁÀÂÄÃÅÇÉÈÊËÍÏÎÌÑÓÒÔÖÕÚÙÛÜÝ', 'AAAAAACEEEEIIIINOOOOOUUUUY')
$_$;


SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 185 (class 1259 OID 19411)
-- Name: associer_objet; Type: TABLE; Schema: tables_objet; Owner: -; Tablespace: 
--

CREATE TABLE associer_objet (
    pk_associer_objet integer NOT NULL,
    fk_type_association_objet integer,
    fk_objet_concerne integer,
    fk_objet_associe integer,
    descriptif text,
    reference_precise text,
    notes text
);


--
-- TOC entry 186 (class 1259 OID 19417)
-- Name: associer_objet_pk_associer_objet_seq; Type: SEQUENCE; Schema: tables_objet; Owner: -
--

CREATE SEQUENCE associer_objet_pk_associer_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2361 (class 0 OID 0)
-- Dependencies: 186
-- Name: associer_objet_pk_associer_objet_seq; Type: SEQUENCE OWNED BY; Schema: tables_objet; Owner: -
--

ALTER SEQUENCE associer_objet_pk_associer_objet_seq OWNED BY associer_objet.pk_associer_objet;


--
-- TOC entry 187 (class 1259 OID 19419)
-- Name: nom_objet; Type: TABLE; Schema: tables_objet; Owner: -; Tablespace: 
--

CREATE TABLE nom_objet (
    pk_nom_objet integer NOT NULL,
    si_nom_standard boolean,
    nom text,
    descriptif text,
    date_debut character varying(10),
    notes_dd text,
    date_fin character varying(10),
    notes_df text,
    code_langue character(3),
    notes text,
    creation timestamp without time zone DEFAULT now(),
    fk_objet integer,
    fk_type integer,
    type_nom character varying(30)
);


--
-- TOC entry 2362 (class 0 OID 0)
-- Dependencies: 187
-- Name: COLUMN nom_objet.pk_nom_objet; Type: COMMENT; Schema: tables_objet; Owner: -
--

COMMENT ON COLUMN nom_objet.pk_nom_objet IS '
';


--
-- TOC entry 2363 (class 0 OID 0)
-- Dependencies: 187
-- Name: COLUMN nom_objet.fk_objet; Type: COMMENT; Schema: tables_objet; Owner: -
--

COMMENT ON COLUMN nom_objet.fk_objet IS '
';


--
-- TOC entry 188 (class 1259 OID 19426)
-- Name: nom_objet_pk_nom_objet_seq; Type: SEQUENCE; Schema: tables_objet; Owner: -
--

CREATE SEQUENCE nom_objet_pk_nom_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2364 (class 0 OID 0)
-- Dependencies: 188
-- Name: nom_objet_pk_nom_objet_seq; Type: SEQUENCE OWNED BY; Schema: tables_objet; Owner: -
--

ALTER SEQUENCE nom_objet_pk_nom_objet_seq OWNED BY nom_objet.pk_nom_objet;


--
-- TOC entry 189 (class 1259 OID 19428)
-- Name: objet; Type: TABLE; Schema: tables_objet; Owner: -; Tablespace: 
--

CREATE TABLE objet (
    pk_objet integer NOT NULL,
    cle_objet_bhp character varying(20),
    descriptif text,
    notes_dd text,
    notes_df text,
    notes text,
    creation timestamp without time zone DEFAULT now(),
    fk_type_objet integer,
    certitude_dd smallint,
    certitude_df smallint,
    url_objet text,
    fk_sous_type_objet integer,
    annee_debut integer,
    annee_fin integer,
    mois_debut integer,
    jour_debut integer,
    mois_fin integer,
    jour_fin integer,
    cle_importation integer,
    cle_jointure_zotero character varying(30),
    sexe integer,
    longitude numeric,
    latitude numeric
);


--
-- TOC entry 2365 (class 0 OID 0)
-- Dependencies: 189
-- Name: COLUMN objet.annee_debut; Type: COMMENT; Schema: tables_objet; Owner: -
--

COMMENT ON COLUMN objet.annee_debut IS 'La date est exprimée seulement en années';


--
-- TOC entry 2366 (class 0 OID 0)
-- Dependencies: 189
-- Name: COLUMN objet.annee_fin; Type: COMMENT; Schema: tables_objet; Owner: -
--

COMMENT ON COLUMN objet.annee_fin IS 'La date est exprimée seulement en années';


--
-- TOC entry 190 (class 1259 OID 19435)
-- Name: objet_pk_objet_seq; Type: SEQUENCE; Schema: tables_objet; Owner: -
--

CREATE SEQUENCE objet_pk_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2367 (class 0 OID 0)
-- Dependencies: 190
-- Name: objet_pk_objet_seq; Type: SEQUENCE OWNED BY; Schema: tables_objet; Owner: -
--

ALTER SEQUENCE objet_pk_objet_seq OWNED BY objet.pk_objet;


--
-- TOC entry 191 (class 1259 OID 19437)
-- Name: v_noms_standards_objets_dans_ordre_chronologique; Type: VIEW; Schema: tables_objet; Owner: -
--

CREATE VIEW v_noms_standards_objets_dans_ordre_chronologique AS
 SELECT nom_objet.fk_objet, 
    array_to_string(ARRAY( SELECT unnest(array_agg(nom_objet.nom)) AS unnest
          ORDER BY unnest(array_agg(nom_objet.date_debut))), '/'::text) AS nom
   FROM nom_objet
  WHERE (nom_objet.si_nom_standard IS TRUE)
  GROUP BY nom_objet.fk_objet
  ORDER BY array_to_string(ARRAY( SELECT unnest(array_agg(nom_objet.nom)) AS unnest
          ORDER BY unnest(array_agg(nom_objet.date_debut))), '/'::text);


--
-- TOC entry 192 (class 1259 OID 19441)
-- Name: v_objet_avec_type; Type: VIEW; Schema: tables_objet; Owner: -
--

CREATE VIEW v_objet_avec_type AS
 SELECT t1.pk_objet, 
    t2.nom AS type_objet, 
    t3.nom AS sous_type_objet
   FROM ((objet t1
   LEFT JOIN tables_types.parametre t2 ON ((t2.pk_parametre = t1.fk_type_objet)))
   LEFT JOIN tables_types.parametre t3 ON ((t3.pk_parametre = t1.fk_sous_type_objet)));


--
-- TOC entry 193 (class 1259 OID 19446)
-- Name: v_objet_nom_type_sous_type; Type: VIEW; Schema: tables_objet; Owner: -
--

CREATE VIEW v_objet_nom_type_sous_type AS
 SELECT t1.pk_objet, 
    t4.nom, 
    t2.nom AS type_objet, 
    t3.nom AS sous_type_objet
   FROM (((objet t1
   LEFT JOIN tables_types.parametre t2 ON ((t2.pk_parametre = t1.fk_type_objet)))
   LEFT JOIN tables_types.parametre t3 ON ((t3.pk_parametre = t1.fk_sous_type_objet)))
   LEFT JOIN v_noms_standards_objets_dans_ordre_chronologique t4 ON ((t4.fk_objet = t1.pk_objet)));


--
-- TOC entry 194 (class 1259 OID 19451)
-- Name: v_objets_associes; Type: VIEW; Schema: tables_objet; Owner: -
--

CREATE VIEW v_objets_associes AS
 SELECT t1.pk_associer_objet, 
    t1.fk_objet_concerne, 
    t4.nom AS nom_objet_concerne, 
    (t8.nom)::text AS type_objet_concerne, 
    (t10.nom)::text AS sous_type_objet_concerne, 
    t6.annee_debut AS annee_debut_objet_concerne, 
    t1.fk_objet_associe, 
    t2.nom AS nom_objet_associe, 
    (t7.nom)::text AS type_objet_associe, 
    (t9.nom)::text AS sous_type_objet_associe, 
    t5.annee_debut AS annee_debut_objet_associe, 
    t1.reference_precise, 
    t1.fk_type_association_objet, 
    (t3.nom)::text AS type_association, 
    t1.descriptif, 
    t1.notes
   FROM (((((((((associer_objet t1
   JOIN objet t5 ON ((t5.pk_objet = t1.fk_objet_associe)))
   JOIN objet t6 ON ((t6.pk_objet = t1.fk_objet_concerne)))
   JOIN tables_types.parametre t3 ON ((t3.pk_parametre = t1.fk_type_association_objet)))
   LEFT JOIN v_noms_standards_objets_dans_ordre_chronologique t2 ON ((t2.fk_objet = t1.fk_objet_associe)))
   LEFT JOIN v_noms_standards_objets_dans_ordre_chronologique t4 ON ((t4.fk_objet = t1.fk_objet_concerne)))
   LEFT JOIN tables_types.parametre t7 ON ((t7.pk_parametre = t5.fk_type_objet)))
   LEFT JOIN tables_types.parametre t8 ON ((t8.pk_parametre = t6.fk_type_objet)))
   LEFT JOIN tables_types.parametre t9 ON ((t9.pk_parametre = t5.fk_sous_type_objet)))
   LEFT JOIN tables_types.parametre t10 ON ((t10.pk_parametre = t6.fk_sous_type_objet)));


--
-- TOC entry 2218 (class 2604 OID 19456)
-- Name: pk_associer_objet; Type: DEFAULT; Schema: tables_objet; Owner: -
--

ALTER TABLE ONLY associer_objet ALTER COLUMN pk_associer_objet SET DEFAULT nextval('associer_objet_pk_associer_objet_seq'::regclass);


--
-- TOC entry 2220 (class 2604 OID 19457)
-- Name: pk_nom_objet; Type: DEFAULT; Schema: tables_objet; Owner: -
--

ALTER TABLE ONLY nom_objet ALTER COLUMN pk_nom_objet SET DEFAULT nextval('nom_objet_pk_nom_objet_seq'::regclass);


--
-- TOC entry 2222 (class 2604 OID 19458)
-- Name: pk_objet; Type: DEFAULT; Schema: tables_objet; Owner: -
--

ALTER TABLE ONLY objet ALTER COLUMN pk_objet SET DEFAULT nextval('objet_pk_objet_seq'::regclass);


--
-- TOC entry 2351 (class 0 OID 19411)
-- Dependencies: 185
-- Data for Name: associer_objet; Type: TABLE DATA; Schema: tables_objet; Owner: -
--

INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2, 21, 179, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (3, 21, 180, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (4, 21, 181, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (5, 21, 182, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (6, 21, 1, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (7, 21, 2, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (8, 21, 3, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (9, 21, 4, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (10, 21, 5, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (11, 21, 6, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (12, 21, 7, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (13, 21, 8, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (14, 21, 9, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (15, 21, 10, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (16, 21, 11, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (17, 21, 12, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (18, 21, 13, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (19, 21, 14, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (20, 21, 15, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (21, 21, 16, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (22, 21, 17, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (23, 21, 18, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (24, 21, 19, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (25, 21, 20, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (26, 21, 21, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (27, 21, 22, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (28, 21, 23, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (29, 21, 24, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (30, 21, 25, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (31, 21, 26, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (32, 21, 27, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (33, 21, 28, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (34, 21, 29, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (35, 21, 30, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (36, 21, 31, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (37, 21, 32, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (38, 21, 33, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (39, 21, 34, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (40, 21, 35, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (41, 21, 36, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (42, 21, 37, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (43, 21, 38, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (44, 21, 39, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (45, 21, 40, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (46, 21, 41, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (47, 21, 42, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (48, 21, 43, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (49, 21, 44, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (50, 21, 45, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (51, 21, 46, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (52, 21, 47, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (53, 21, 48, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (54, 21, 49, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (55, 21, 50, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (56, 21, 51, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (57, 21, 52, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (58, 21, 53, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (59, 21, 54, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (60, 21, 55, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (61, 21, 56, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (62, 21, 57, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (63, 21, 58, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (64, 21, 59, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (65, 21, 60, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (66, 21, 183, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (67, 21, 61, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (68, 21, 62, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (69, 21, 63, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (70, 21, 64, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (71, 21, 65, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (72, 21, 66, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (73, 21, 67, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (74, 21, 68, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (75, 21, 69, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (76, 21, 70, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (77, 21, 71, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (78, 21, 72, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (79, 21, 73, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (80, 21, 74, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (81, 21, 75, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (82, 21, 76, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (83, 21, 77, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (84, 21, 78, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (85, 21, 79, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (86, 21, 80, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (87, 21, 81, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (88, 21, 82, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (89, 21, 83, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (90, 21, 84, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (91, 21, 85, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (92, 21, 86, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (93, 21, 87, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (94, 21, 88, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (95, 21, 89, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (96, 21, 90, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (97, 21, 91, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (98, 21, 92, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (99, 21, 93, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (100, 21, 94, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (101, 21, 95, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (102, 21, 96, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (103, 21, 97, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (104, 21, 98, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (105, 21, 99, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (106, 21, 100, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (107, 21, 101, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (108, 21, 102, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (109, 21, 103, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (110, 21, 104, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (111, 21, 105, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (112, 21, 106, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (113, 21, 107, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (114, 21, 108, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (115, 21, 109, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (116, 21, 110, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (117, 21, 111, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (118, 21, 112, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (119, 21, 113, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (120, 21, 114, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (121, 21, 115, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (122, 21, 116, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (123, 21, 117, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (124, 21, 118, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (125, 21, 119, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (126, 21, 120, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (127, 21, 121, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (128, 21, 122, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (129, 21, 123, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (130, 21, 124, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (131, 21, 125, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (132, 21, 126, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (133, 21, 127, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (134, 21, 128, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (135, 21, 129, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (136, 21, 130, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (137, 21, 131, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (138, 21, 132, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (139, 21, 133, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (140, 21, 134, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (141, 21, 135, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (142, 21, 136, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (143, 21, 137, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (144, 21, 138, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (145, 21, 139, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (146, 21, 140, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (147, 21, 141, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (148, 21, 142, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (149, 21, 143, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (150, 21, 144, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (151, 21, 145, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (152, 21, 146, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (153, 21, 147, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (154, 21, 148, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (155, 21, 149, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (156, 21, 150, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (157, 21, 151, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (158, 21, 152, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (159, 21, 153, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (160, 21, 154, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (161, 21, 155, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (162, 21, 156, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (163, 21, 157, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (164, 21, 158, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (165, 21, 159, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (166, 21, 160, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (167, 21, 161, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (168, 21, 162, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (169, 21, 163, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (170, 21, 164, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (171, 21, 165, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (172, 21, 166, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (173, 21, 167, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (174, 21, 168, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (175, 21, 169, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (176, 21, 170, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (177, 21, 171, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (178, 21, 172, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (179, 21, 173, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (180, 21, 174, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (181, 21, 175, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (182, 21, 176, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (183, 21, 177, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (184, 21, 178, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (185, 21, 184, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (186, 21, 185, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (187, 21, 186, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (188, 21, 187, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (189, 21, 188, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (190, 21, 189, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (191, 21, 190, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (192, 21, 191, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (193, 21, 192, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (194, 21, 193, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (195, 21, 194, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (196, 21, 195, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (197, 21, 196, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (198, 21, 197, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (199, 21, 198, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (200, 21, 199, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (201, 21, 200, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (202, 21, 201, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (203, 21, 202, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (204, 21, 203, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (205, 21, 204, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (206, 21, 205, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (207, 21, 206, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (208, 21, 207, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (209, 21, 208, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (210, 21, 209, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (211, 21, 210, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (212, 21, 211, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (213, 21, 212, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (214, 21, 213, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (215, 21, 214, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (216, 21, 215, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (217, 21, 216, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (218, 21, 217, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (219, 21, 218, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (220, 21, 219, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (221, 21, 220, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (222, 21, 221, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (223, 21, 222, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (224, 21, 223, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (225, 21, 224, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (226, 21, 225, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (227, 21, 226, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (228, 21, 227, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (229, 21, 228, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (230, 21, 229, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (231, 21, 230, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (232, 21, 231, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (233, 21, 232, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (234, 21, 233, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (235, 21, 234, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (236, 21, 235, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (237, 21, 236, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (238, 21, 237, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (239, 21, 238, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (240, 21, 239, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (241, 21, 240, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (242, 21, 241, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (243, 21, 242, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (244, 21, 243, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (245, 21, 244, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (246, 21, 245, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (247, 21, 246, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (248, 21, 247, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (249, 21, 248, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (250, 21, 249, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (251, 21, 250, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (252, 21, 251, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (253, 21, 252, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (254, 21, 253, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (255, 21, 254, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (256, 21, 255, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (257, 21, 256, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (258, 21, 257, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (259, 21, 258, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (260, 21, 259, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (261, 21, 260, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (262, 21, 261, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (263, 21, 262, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (264, 21, 263, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (265, 21, 264, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (266, 21, 265, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (267, 21, 266, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (268, 21, 267, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (269, 21, 268, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (270, 21, 269, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (271, 21, 270, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (272, 21, 271, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (273, 21, 272, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (274, 21, 273, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (275, 21, 274, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (276, 21, 275, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (277, 21, 276, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (278, 21, 277, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (279, 21, 278, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (280, 21, 279, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (281, 21, 280, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (282, 21, 281, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (283, 21, 282, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (284, 21, 283, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (285, 21, 284, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (286, 21, 285, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (287, 21, 286, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (288, 21, 287, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (289, 21, 288, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (290, 21, 289, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (291, 21, 290, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (292, 21, 291, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (293, 21, 292, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (294, 21, 293, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (295, 21, 294, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (296, 21, 295, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (297, 21, 296, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (298, 21, 297, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (299, 21, 298, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (300, 21, 299, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (301, 21, 300, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (302, 21, 301, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (303, 21, 302, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (304, 21, 303, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (305, 21, 304, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (306, 21, 305, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (307, 21, 306, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (308, 21, 307, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (309, 21, 308, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (310, 21, 309, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (311, 21, 310, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (312, 21, 311, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (313, 21, 312, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (314, 21, 313, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (315, 21, 314, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (316, 21, 315, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (317, 21, 316, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (318, 21, 317, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (319, 21, 318, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (320, 21, 319, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (321, 21, 320, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (322, 21, 321, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (323, 21, 322, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (324, 21, 323, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (325, 21, 324, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (326, 21, 325, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (327, 21, 326, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (328, 21, 327, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (329, 21, 328, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (330, 21, 329, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (331, 21, 330, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (332, 21, 331, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (333, 21, 332, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (334, 21, 333, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (335, 21, 334, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (336, 21, 335, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (337, 21, 336, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (338, 21, 337, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (339, 21, 338, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (340, 21, 339, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (341, 21, 340, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (342, 21, 341, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (343, 21, 342, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (344, 21, 343, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (345, 21, 344, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (346, 21, 345, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (347, 21, 346, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (348, 21, 347, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (349, 21, 348, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (350, 21, 349, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (351, 21, 350, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (352, 21, 351, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (353, 21, 352, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (354, 21, 353, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (355, 21, 354, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (356, 21, 355, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (357, 21, 356, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (358, 21, 357, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (359, 21, 358, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (360, 21, 359, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (361, 21, 360, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (362, 21, 361, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (363, 21, 362, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (364, 21, 363, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (365, 21, 364, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (366, 21, 365, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (367, 21, 366, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (368, 21, 367, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (369, 21, 368, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (370, 21, 369, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (371, 21, 370, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (372, 21, 371, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (373, 21, 372, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (374, 21, 373, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (375, 21, 374, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (376, 21, 375, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (377, 21, 376, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (378, 21, 377, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (379, 21, 378, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (380, 21, 379, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (381, 21, 380, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (382, 21, 381, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (383, 21, 382, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (384, 21, 383, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (385, 21, 384, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (386, 21, 385, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (387, 21, 386, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (388, 21, 387, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (389, 21, 388, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (390, 21, 389, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (391, 21, 390, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (392, 21, 391, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (393, 21, 392, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (394, 21, 393, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (395, 21, 394, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (396, 21, 395, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (397, 21, 396, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (398, 21, 397, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (399, 21, 398, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (400, 21, 399, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (401, 21, 400, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (402, 21, 401, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (403, 21, 402, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (404, 21, 403, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (405, 21, 404, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (406, 21, 405, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (407, 21, 406, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (408, 21, 407, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (409, 21, 408, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (410, 21, 409, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (411, 21, 410, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (412, 21, 411, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (413, 21, 412, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (414, 21, 413, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (415, 21, 414, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (416, 21, 415, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (417, 21, 416, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (418, 21, 417, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (419, 21, 418, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (420, 21, 419, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (421, 21, 420, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (422, 21, 421, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (423, 21, 422, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (424, 21, 423, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (425, 21, 424, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (426, 21, 425, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (427, 21, 426, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (428, 21, 427, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (429, 21, 428, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (430, 21, 429, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (431, 21, 430, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (432, 21, 431, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (433, 21, 432, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (434, 21, 433, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (435, 21, 434, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (436, 21, 435, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (437, 21, 436, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (438, 21, 437, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (439, 21, 438, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (440, 21, 439, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (441, 21, 440, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (442, 21, 441, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (443, 21, 442, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (444, 21, 443, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (445, 21, 444, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (446, 21, 445, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (447, 21, 446, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (448, 21, 447, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (449, 21, 448, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (450, 21, 449, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (451, 21, 450, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (452, 21, 451, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (453, 21, 452, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (454, 21, 453, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (455, 21, 454, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (456, 21, 455, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (457, 21, 456, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (458, 21, 457, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (459, 21, 458, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (460, 21, 459, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (461, 21, 460, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (462, 21, 461, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (463, 21, 462, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (464, 21, 463, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (465, 21, 464, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (466, 21, 465, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (467, 21, 466, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (468, 21, 467, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (469, 21, 468, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (470, 21, 469, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (471, 21, 470, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (472, 21, 471, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (473, 21, 472, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (474, 21, 473, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (475, 21, 474, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (476, 21, 475, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (477, 21, 476, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (478, 21, 477, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (479, 21, 478, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (480, 21, 479, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (481, 21, 480, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (482, 21, 481, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (483, 21, 482, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (484, 21, 483, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (485, 21, 484, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (486, 21, 485, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (487, 21, 486, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (488, 21, 487, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (489, 21, 488, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (490, 21, 489, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (491, 21, 490, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (492, 21, 491, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (493, 21, 492, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (494, 21, 493, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (495, 21, 494, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (496, 21, 495, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (497, 21, 496, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (498, 21, 497, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (499, 21, 498, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (500, 21, 499, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (501, 21, 500, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (502, 21, 501, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (503, 21, 502, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (504, 21, 503, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (505, 21, 504, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (506, 21, 505, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (507, 21, 506, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (508, 21, 507, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (509, 21, 508, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (510, 21, 509, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (511, 21, 510, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (512, 21, 511, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (513, 21, 512, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (514, 21, 513, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (515, 21, 514, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (516, 21, 515, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (517, 21, 516, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (518, 21, 517, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (519, 21, 518, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (520, 21, 519, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (521, 21, 520, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (522, 21, 521, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (523, 21, 522, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (524, 21, 523, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (525, 21, 524, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (526, 21, 525, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (527, 21, 526, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (528, 21, 527, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (529, 21, 528, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (530, 21, 529, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (531, 21, 530, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (532, 21, 531, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (533, 21, 532, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (534, 21, 533, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (535, 21, 534, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (536, 21, 535, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (537, 21, 536, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (538, 21, 537, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (539, 21, 538, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (540, 21, 539, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (541, 21, 540, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (542, 21, 541, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (543, 21, 542, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (544, 21, 543, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (545, 21, 544, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (546, 21, 545, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (547, 21, 546, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (548, 21, 547, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (549, 21, 548, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (550, 21, 549, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (551, 21, 550, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (552, 21, 551, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (553, 21, 552, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (554, 21, 553, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (555, 21, 554, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (556, 21, 555, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (557, 21, 556, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (558, 21, 557, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (559, 21, 558, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (560, 21, 559, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (561, 21, 560, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (562, 21, 561, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (563, 21, 562, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (564, 21, 563, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (565, 21, 564, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (566, 21, 565, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (567, 21, 566, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (568, 21, 567, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (569, 21, 568, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (570, 21, 569, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (571, 21, 570, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (572, 21, 571, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (573, 21, 572, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (574, 21, 573, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (575, 21, 574, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (576, 21, 575, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (577, 21, 576, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (578, 21, 577, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (579, 21, 578, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (580, 21, 579, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (581, 21, 580, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (582, 21, 581, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (583, 21, 582, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (584, 21, 583, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (585, 21, 584, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (586, 21, 585, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (587, 21, 586, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (588, 21, 587, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (589, 21, 588, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (590, 21, 589, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (591, 21, 590, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (592, 21, 591, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (593, 21, 592, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (594, 21, 593, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (595, 21, 594, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (596, 21, 595, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (597, 21, 596, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (598, 21, 597, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (599, 21, 598, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (600, 21, 599, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (601, 21, 600, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (602, 21, 601, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (603, 21, 602, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (604, 21, 603, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (605, 21, 604, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (606, 21, 605, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (607, 21, 606, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (608, 21, 607, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (609, 21, 608, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (610, 21, 609, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (611, 21, 610, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (612, 21, 611, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (613, 21, 612, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (614, 21, 613, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (615, 21, 614, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (616, 21, 615, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (617, 21, 616, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (618, 21, 617, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (619, 21, 618, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (620, 21, 619, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (621, 21, 620, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (622, 21, 621, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (623, 21, 622, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (624, 21, 623, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (625, 21, 624, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (626, 21, 625, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (627, 21, 626, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (628, 21, 627, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (629, 21, 628, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (630, 21, 629, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (631, 21, 630, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (632, 21, 631, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (633, 21, 632, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (634, 21, 633, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (635, 21, 634, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (636, 21, 635, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (637, 21, 636, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (638, 21, 637, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (639, 21, 638, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (640, 21, 639, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (641, 21, 640, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (642, 21, 641, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (643, 21, 642, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (644, 21, 643, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (645, 21, 644, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (646, 21, 645, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (647, 21, 646, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (648, 21, 647, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (649, 21, 648, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (650, 21, 649, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (651, 21, 650, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (652, 21, 651, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (653, 21, 652, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (654, 21, 653, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (655, 21, 654, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (656, 21, 655, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (657, 21, 656, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (658, 21, 657, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (659, 21, 658, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (660, 21, 659, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (661, 21, 660, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (662, 21, 661, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (663, 21, 662, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (664, 21, 663, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (665, 21, 664, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (666, 21, 665, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (667, 21, 666, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (668, 21, 667, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (669, 21, 668, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (670, 21, 669, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (671, 21, 670, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (672, 21, 671, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (673, 21, 672, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (674, 21, 673, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (675, 21, 674, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (676, 21, 675, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (677, 21, 676, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (678, 21, 677, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (679, 21, 678, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (680, 21, 679, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (681, 21, 680, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (682, 21, 681, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (683, 21, 682, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (684, 21, 683, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (685, 21, 684, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (686, 21, 685, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (687, 21, 686, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (688, 21, 687, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (689, 21, 688, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (690, 21, 689, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (691, 21, 690, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (692, 21, 691, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (693, 21, 692, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (694, 21, 693, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (695, 21, 694, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (696, 21, 695, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (697, 21, 696, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (698, 21, 697, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (699, 21, 698, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (700, 21, 699, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (701, 21, 700, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (702, 21, 701, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (703, 21, 702, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (704, 21, 703, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (705, 21, 704, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (706, 21, 705, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (707, 21, 706, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (708, 21, 707, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (709, 21, 708, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (710, 21, 709, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (711, 21, 710, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (712, 21, 711, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (713, 21, 712, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (714, 21, 713, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (715, 21, 714, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (716, 21, 715, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (717, 21, 716, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (718, 21, 717, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (719, 21, 718, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (720, 21, 719, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (721, 21, 720, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (722, 21, 721, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (723, 21, 722, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (724, 21, 723, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (725, 21, 724, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (726, 21, 725, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (727, 21, 726, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (728, 21, 727, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (729, 21, 728, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (730, 21, 729, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (731, 21, 730, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (732, 21, 731, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (733, 21, 732, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (734, 21, 733, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (735, 21, 734, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (736, 21, 735, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (737, 21, 736, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (738, 21, 737, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (739, 21, 738, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (740, 21, 739, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (741, 21, 740, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (742, 21, 741, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (743, 21, 742, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (744, 21, 743, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (745, 21, 744, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (746, 21, 745, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (747, 21, 746, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (748, 21, 747, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (749, 21, 748, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (750, 21, 749, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (751, 21, 750, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (752, 21, 751, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (753, 21, 752, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (754, 21, 753, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (755, 21, 754, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (756, 21, 755, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (757, 21, 756, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (758, 21, 757, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (759, 21, 758, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (760, 21, 759, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (761, 21, 760, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (762, 21, 761, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (763, 21, 762, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (764, 21, 763, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (765, 21, 764, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (766, 21, 765, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (767, 21, 766, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (768, 21, 767, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (769, 21, 768, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (770, 21, 769, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (771, 21, 770, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (772, 21, 771, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (773, 21, 772, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (774, 21, 773, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (775, 21, 774, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (776, 21, 775, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (777, 21, 776, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (778, 21, 777, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (779, 21, 778, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (780, 21, 779, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (781, 21, 780, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (782, 21, 781, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (783, 21, 782, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (784, 21, 783, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (785, 21, 784, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (786, 21, 785, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (787, 21, 786, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (788, 21, 787, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (789, 21, 788, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (790, 21, 789, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (791, 21, 790, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (792, 21, 791, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (793, 21, 792, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (794, 21, 793, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (795, 21, 794, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (796, 21, 795, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (797, 21, 796, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (798, 21, 797, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (799, 21, 798, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (800, 21, 799, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (801, 21, 800, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (802, 21, 801, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (803, 21, 802, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (804, 21, 803, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (805, 21, 804, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (806, 21, 805, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (807, 21, 806, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (808, 21, 807, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (809, 21, 808, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (810, 21, 809, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (811, 21, 810, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (812, 21, 811, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (813, 21, 812, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (814, 21, 813, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (815, 21, 814, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (816, 21, 815, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (817, 21, 816, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (818, 21, 817, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (819, 21, 818, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (820, 21, 819, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (821, 21, 820, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (822, 21, 821, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (823, 21, 822, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (824, 21, 823, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (825, 21, 824, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (826, 21, 825, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (827, 21, 826, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (828, 21, 827, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (829, 21, 828, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (830, 21, 829, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (831, 21, 830, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (832, 21, 831, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (833, 21, 832, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (834, 21, 833, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (835, 21, 834, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (836, 21, 835, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (837, 21, 836, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (838, 21, 837, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (839, 21, 838, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (840, 21, 839, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (841, 21, 840, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (842, 21, 841, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (843, 21, 842, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (844, 21, 843, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (845, 21, 844, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (846, 21, 845, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (847, 21, 846, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (848, 21, 847, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (849, 21, 848, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (850, 21, 849, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (851, 21, 850, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (852, 21, 851, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (853, 21, 852, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (854, 21, 853, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (855, 21, 854, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (856, 21, 855, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (857, 21, 856, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (858, 21, 857, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (859, 21, 858, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (860, 21, 859, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (861, 21, 860, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (862, 21, 861, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (863, 21, 862, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (864, 21, 863, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (865, 21, 864, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (866, 21, 865, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (867, 21, 866, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (868, 21, 867, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (869, 21, 868, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (870, 21, 869, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (871, 21, 870, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (872, 21, 871, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (873, 21, 872, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (874, 21, 873, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (875, 21, 874, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (876, 21, 875, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (877, 21, 876, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (878, 21, 877, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (879, 21, 878, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (880, 21, 879, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (881, 21, 880, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (882, 21, 881, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (883, 21, 882, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (884, 21, 883, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (885, 21, 884, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (886, 21, 885, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (887, 21, 886, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (888, 21, 887, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (889, 21, 888, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (890, 21, 889, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (891, 21, 890, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (892, 21, 891, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (893, 21, 892, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (894, 21, 893, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (895, 21, 894, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (896, 21, 895, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (897, 21, 896, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (898, 21, 897, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (899, 21, 898, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (900, 21, 899, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (901, 21, 900, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (902, 21, 901, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (903, 21, 902, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (904, 21, 903, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (905, 21, 904, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (906, 21, 905, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (907, 21, 906, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (908, 21, 907, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (909, 21, 908, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (910, 21, 909, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (911, 21, 910, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (912, 21, 911, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (913, 21, 912, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (914, 21, 913, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (915, 21, 914, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (916, 21, 915, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (917, 21, 916, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (918, 21, 917, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (919, 21, 918, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (920, 21, 919, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (921, 21, 920, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (922, 21, 921, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (923, 21, 922, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (924, 21, 923, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (925, 21, 924, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (926, 21, 925, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (927, 21, 926, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (928, 21, 927, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (929, 21, 928, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (930, 21, 929, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (931, 21, 930, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (932, 21, 931, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (933, 21, 932, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (934, 21, 933, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (935, 21, 934, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (936, 21, 935, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (937, 21, 936, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (938, 21, 937, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (939, 21, 938, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (940, 21, 939, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (941, 21, 940, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (942, 21, 941, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (943, 21, 942, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (944, 21, 943, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (945, 21, 944, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (946, 21, 945, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (947, 21, 946, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (948, 21, 947, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (949, 21, 948, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (950, 21, 949, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (951, 21, 950, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (952, 21, 951, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (953, 21, 952, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (954, 21, 953, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (955, 21, 954, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (956, 21, 955, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (957, 21, 956, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (958, 21, 957, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (959, 21, 958, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (960, 21, 959, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (961, 21, 960, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (962, 21, 961, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (963, 21, 962, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (964, 21, 963, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (965, 21, 964, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (966, 21, 965, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (967, 21, 966, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (968, 21, 967, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (969, 21, 968, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (970, 21, 969, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (971, 21, 970, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (972, 21, 971, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (973, 21, 972, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (974, 21, 973, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (975, 21, 974, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (976, 21, 975, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (977, 21, 976, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (978, 21, 977, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (979, 21, 978, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (980, 21, 979, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (981, 21, 980, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (982, 21, 981, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (983, 21, 982, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (984, 21, 983, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (985, 21, 984, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (986, 21, 985, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (987, 21, 986, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (988, 21, 987, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (989, 21, 988, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (990, 21, 989, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (991, 21, 990, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (992, 21, 991, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (993, 21, 992, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (994, 21, 993, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (995, 21, 994, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (996, 21, 995, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (997, 21, 996, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (998, 21, 997, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (999, 21, 998, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1000, 21, 999, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1001, 21, 1000, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1002, 21, 1001, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1003, 21, 1002, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1004, 21, 1003, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1005, 21, 1004, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1006, 21, 1005, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1007, 21, 1006, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1008, 21, 1007, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1009, 21, 1008, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1010, 21, 1009, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1011, 21, 1010, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1012, 21, 1011, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1013, 21, 1012, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1014, 21, 1013, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1015, 21, 1014, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1016, 21, 1015, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1017, 21, 1016, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1018, 21, 1017, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1019, 21, 1018, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1020, 21, 1019, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1021, 21, 1020, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1022, 21, 1021, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1023, 21, 1022, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1024, 21, 1023, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1025, 21, 1024, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1026, 21, 1025, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1027, 21, 1026, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1028, 21, 1027, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1029, 21, 1028, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1030, 21, 1029, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1031, 21, 1030, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1032, 21, 1031, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1033, 21, 1032, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1034, 21, 1033, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1035, 21, 1034, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1036, 21, 1035, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1037, 21, 1036, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1038, 21, 1037, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1039, 21, 1038, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1040, 21, 1039, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1041, 21, 1040, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1042, 21, 1041, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1043, 21, 1042, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1044, 21, 1043, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1045, 21, 1044, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1046, 21, 1045, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1047, 21, 1046, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1048, 21, 1047, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1049, 21, 1048, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1050, 21, 1049, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1051, 21, 1050, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1052, 21, 1051, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1053, 21, 1052, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1054, 21, 1053, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1055, 21, 1054, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1056, 21, 1055, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1057, 21, 1056, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1058, 21, 1057, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1059, 21, 1058, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1060, 21, 1059, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1061, 21, 1060, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1062, 21, 1061, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1063, 21, 1062, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1064, 21, 1063, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1065, 21, 1064, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1066, 21, 1065, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1067, 21, 1066, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1068, 21, 1067, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1069, 21, 1068, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1070, 21, 1069, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1071, 21, 1070, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1072, 21, 1071, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1073, 21, 1072, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1074, 21, 1073, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1075, 21, 1074, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1076, 21, 1075, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1077, 21, 1076, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1078, 21, 1077, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1079, 21, 1078, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1080, 21, 1079, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1081, 21, 1080, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1082, 21, 1081, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1083, 21, 1082, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1084, 21, 1083, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1085, 21, 1084, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1086, 21, 1085, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1087, 21, 1086, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1088, 21, 1087, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1089, 21, 1088, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1090, 21, 1089, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1091, 21, 1090, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1092, 21, 1091, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1093, 21, 1092, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1094, 21, 1093, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1095, 21, 1094, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1096, 21, 1095, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1097, 21, 1096, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1098, 21, 1097, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1099, 21, 1098, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1100, 21, 1099, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1101, 21, 1100, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1102, 21, 1101, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1103, 21, 1102, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1104, 21, 1103, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1105, 21, 1104, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1106, 21, 1105, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1107, 21, 1106, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1108, 21, 1107, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1109, 21, 1108, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1110, 21, 1109, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1111, 21, 1110, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1112, 21, 1111, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1113, 21, 1112, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1114, 21, 1113, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1115, 21, 1114, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1116, 21, 1115, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1117, 21, 1116, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1118, 21, 1117, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1119, 21, 1118, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1120, 21, 1119, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1121, 21, 1120, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1122, 21, 1121, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1123, 21, 1122, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1124, 21, 1123, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1125, 21, 1124, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1126, 21, 1125, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1127, 21, 1126, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1128, 21, 1364, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1129, 21, 1127, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1130, 21, 1128, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1131, 21, 1129, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1132, 21, 1130, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1133, 21, 1131, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1134, 21, 1132, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1135, 21, 1133, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1136, 21, 1134, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1137, 21, 1135, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1138, 21, 1136, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1139, 21, 1137, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1140, 21, 1138, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1141, 21, 1139, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1142, 21, 1140, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1143, 21, 1141, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1144, 21, 1142, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1145, 21, 1143, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1146, 21, 1144, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1147, 21, 1145, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1148, 21, 1146, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1149, 21, 1147, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1150, 21, 1148, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1151, 21, 1149, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1152, 21, 1150, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1153, 21, 1151, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1154, 21, 1152, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1155, 21, 1153, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1156, 21, 1154, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1157, 21, 1155, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1158, 21, 1156, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1159, 21, 1157, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1160, 21, 1158, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1161, 21, 1159, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1162, 21, 1160, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1163, 21, 1161, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1164, 21, 1162, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1165, 21, 1163, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1166, 21, 1164, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1167, 21, 1165, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1168, 21, 1166, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1169, 21, 1167, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1170, 21, 1168, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1171, 21, 1169, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1172, 21, 1170, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1173, 21, 1171, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1174, 21, 1172, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1175, 21, 1173, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1176, 21, 1174, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1177, 21, 1175, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1178, 21, 1176, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1179, 21, 1177, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1180, 21, 1178, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1181, 21, 1179, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1182, 21, 1180, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1183, 21, 1181, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1184, 21, 1182, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1185, 21, 1183, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1186, 21, 1184, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1187, 21, 1185, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1188, 21, 1186, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1189, 21, 1187, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1190, 21, 1188, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1191, 21, 1189, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1192, 21, 1190, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1193, 21, 1191, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1194, 21, 1192, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1195, 21, 1193, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1196, 21, 1194, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1197, 21, 1195, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1198, 21, 1196, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1199, 21, 1197, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1200, 21, 1198, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1201, 21, 1199, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1202, 21, 1200, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1203, 21, 1201, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1204, 21, 1202, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1205, 21, 1203, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1206, 21, 1204, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1207, 21, 1205, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1208, 21, 1206, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1209, 21, 1207, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1210, 21, 1208, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1211, 21, 1209, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1212, 21, 1210, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1213, 21, 1211, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1214, 21, 1212, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1215, 21, 1213, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1216, 21, 1214, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1217, 21, 1215, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1218, 21, 1216, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1219, 21, 1217, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1220, 21, 1218, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1221, 21, 1219, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1222, 21, 1220, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1223, 21, 1221, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1224, 21, 1222, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1225, 21, 1223, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1226, 21, 1224, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1227, 21, 1225, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1228, 21, 1226, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1229, 21, 1227, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1230, 21, 1228, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1231, 21, 1229, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1232, 21, 1230, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1233, 21, 1231, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1234, 21, 1232, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1235, 21, 1233, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1236, 21, 1234, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1237, 21, 1235, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1238, 21, 1236, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1239, 21, 1237, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1240, 21, 1238, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1241, 21, 1239, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1242, 21, 1240, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1243, 21, 1241, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1244, 21, 1242, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1245, 21, 1243, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1246, 21, 1244, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1247, 21, 1245, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1248, 21, 1246, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1249, 21, 1247, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1250, 21, 1248, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1251, 21, 1249, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1252, 21, 1250, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1253, 21, 1251, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1254, 21, 1252, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1255, 21, 1253, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1256, 21, 1254, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1257, 21, 1255, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1258, 21, 1256, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1259, 21, 1257, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1260, 21, 1258, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1261, 21, 1259, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1262, 21, 1260, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1263, 21, 1261, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1264, 21, 1262, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1265, 21, 1263, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1266, 21, 1264, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1267, 21, 1265, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1268, 21, 1266, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1269, 21, 1267, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1270, 21, 1268, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1271, 21, 1269, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1272, 21, 1270, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1273, 21, 1271, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1274, 21, 1272, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1275, 21, 1273, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1276, 21, 1274, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1277, 21, 1275, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1278, 21, 1276, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1279, 21, 1277, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1280, 21, 1278, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1281, 21, 1279, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1282, 21, 1280, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1283, 21, 1281, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1284, 21, 1282, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1285, 21, 1283, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1286, 21, 1284, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1287, 21, 1285, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1288, 21, 1286, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1289, 21, 1287, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1290, 21, 1288, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1291, 21, 1289, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1292, 21, 1290, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1293, 21, 1291, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1294, 21, 1292, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1295, 21, 1293, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1296, 21, 1294, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1297, 21, 1295, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1298, 21, 1296, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1299, 21, 1297, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1300, 21, 1298, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1301, 21, 1299, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1302, 21, 1300, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1303, 21, 1301, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1304, 21, 1302, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1305, 21, 1303, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1306, 21, 1304, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1307, 21, 1305, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1308, 21, 1306, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1309, 21, 1307, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1310, 21, 1308, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1311, 21, 1309, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1312, 21, 1310, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1313, 21, 1311, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1314, 21, 1312, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1315, 21, 1313, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1316, 21, 1314, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1317, 21, 1315, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1318, 21, 1316, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1319, 21, 1317, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1320, 21, 1318, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1321, 21, 1319, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1322, 21, 1320, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1323, 21, 1321, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1324, 21, 1322, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1325, 21, 1323, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1326, 21, 1324, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1327, 21, 1325, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1328, 21, 1326, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1329, 21, 1327, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1330, 21, 1328, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1331, 21, 1329, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1332, 21, 1330, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1333, 21, 1331, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1334, 21, 1332, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1335, 21, 1333, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1336, 21, 1334, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1337, 21, 1335, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1338, 21, 1336, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1339, 21, 1337, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1340, 21, 1338, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1341, 21, 1339, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1342, 21, 1340, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1343, 21, 1341, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1344, 21, 1342, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1345, 21, 1343, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1346, 21, 1344, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1347, 21, 1345, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1348, 21, 1346, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1349, 21, 1347, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1350, 21, 1348, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1351, 21, 1349, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1352, 21, 1350, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1353, 21, 1351, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1354, 21, 1352, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1355, 21, 1353, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1356, 21, 1354, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1357, 21, 1355, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1358, 21, 1356, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1359, 21, 1357, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1360, 21, 1358, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1361, 21, 1359, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1362, 21, 1360, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1363, 21, 1361, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1364, 21, 1362, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1365, 21, 1363, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1366, 21, 1365, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1367, 21, 1366, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1368, 21, 1367, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1369, 21, 1368, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1370, 21, 1369, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1371, 21, 1370, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1372, 21, 1371, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1373, 21, 1372, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1374, 21, 1373, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1375, 21, 1374, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1376, 21, 1375, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1377, 21, 1376, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1378, 21, 1377, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1379, 21, 1378, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1380, 21, 1379, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1381, 21, 1380, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1382, 21, 1381, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1383, 21, 1382, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1384, 21, 1383, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1385, 21, 1384, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1386, 21, 1385, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1387, 21, 1386, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1388, 21, 1387, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1389, 21, 1388, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1390, 21, 1389, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1391, 21, 1390, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1392, 21, 1391, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1393, 21, 1392, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1394, 21, 1393, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1395, 21, 1394, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1396, 21, 1395, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1397, 21, 1396, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1398, 21, 1397, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1399, 21, 1398, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1400, 21, 1399, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1401, 21, 1400, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1402, 21, 1401, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1403, 21, 1402, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1404, 21, 1403, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1405, 21, 1404, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1406, 21, 1405, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1407, 21, 1406, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1408, 21, 1407, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1409, 21, 1408, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1410, 21, 1409, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1411, 21, 1410, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1412, 21, 1411, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1413, 21, 1412, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1414, 21, 1413, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1415, 21, 1414, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1416, 21, 1415, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1417, 21, 1416, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1418, 21, 1417, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1419, 21, 1418, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1420, 21, 1419, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1421, 21, 1420, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1422, 21, 1421, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1423, 21, 1422, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1424, 21, 1423, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1425, 21, 1424, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1426, 21, 1425, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1427, 21, 1426, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1428, 21, 1427, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1429, 21, 1428, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1430, 21, 1429, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1431, 21, 1430, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1432, 21, 1431, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1433, 21, 1432, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1434, 21, 1433, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1435, 21, 1434, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1436, 21, 1435, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1437, 21, 1436, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1438, 21, 1437, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1439, 21, 1438, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1440, 21, 1439, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1441, 21, 1440, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1442, 21, 1441, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1443, 21, 1442, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1444, 21, 1443, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1445, 21, 1444, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1446, 21, 1445, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1447, 21, 1446, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1448, 21, 1447, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1449, 21, 1448, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1450, 21, 1449, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1451, 21, 1450, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1452, 21, 1451, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1453, 21, 1452, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1454, 21, 1453, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1455, 21, 1454, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1456, 21, 1455, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1457, 21, 1456, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1458, 21, 1457, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1459, 21, 1458, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1460, 21, 1459, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1461, 21, 1460, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1462, 21, 1461, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1463, 21, 1462, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1464, 21, 1463, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1465, 21, 1464, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1466, 21, 1465, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1467, 21, 1466, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1468, 21, 1467, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1469, 21, 1468, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1470, 21, 1469, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1471, 21, 1470, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1472, 21, 1471, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1473, 21, 1472, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1474, 21, 1473, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1475, 21, 1474, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1476, 21, 1475, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1477, 21, 1476, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1478, 21, 1477, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1479, 21, 1478, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1480, 21, 1479, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1481, 21, 1480, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1482, 21, 1481, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1483, 21, 1482, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1484, 21, 1483, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1485, 21, 1484, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1486, 21, 1485, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1487, 21, 1486, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1488, 21, 1487, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1489, 21, 1488, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1490, 21, 1489, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1491, 21, 1490, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1492, 21, 1491, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1493, 21, 1492, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1494, 21, 1493, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1495, 21, 1494, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1496, 21, 1495, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1497, 21, 1496, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1498, 21, 1497, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1499, 21, 1498, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1500, 21, 1499, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1501, 21, 1500, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1502, 21, 1501, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1503, 21, 1502, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1504, 21, 1503, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1505, 21, 1504, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1506, 21, 1505, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1507, 21, 1506, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1508, 21, 1507, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1509, 21, 1508, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1510, 21, 1509, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1511, 21, 1510, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1512, 21, 1511, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1513, 21, 1512, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1514, 21, 1513, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1515, 21, 1514, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1516, 21, 1515, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1517, 21, 1516, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1518, 21, 1517, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1519, 21, 1518, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1520, 21, 1519, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1521, 21, 1520, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1522, 21, 1521, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1523, 21, 1522, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1524, 21, 1523, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1525, 21, 1524, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1526, 21, 1525, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1527, 21, 1526, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1528, 21, 1527, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1529, 21, 1528, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1530, 21, 1529, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1531, 21, 1530, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1532, 21, 1531, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1533, 21, 1532, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1534, 21, 1533, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1535, 21, 1534, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1536, 21, 1535, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1537, 21, 1536, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1538, 21, 1537, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1539, 21, 1538, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1540, 21, 1539, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1541, 21, 1540, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1542, 21, 1541, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1543, 21, 1542, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1544, 21, 1543, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1545, 21, 1544, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1546, 21, 1545, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1547, 21, 1546, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1548, 21, 1547, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1549, 21, 1548, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1550, 21, 1549, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1551, 21, 1550, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1552, 21, 1551, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1553, 21, 1552, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1554, 21, 1553, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1555, 21, 1554, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1556, 21, 1555, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1557, 21, 1556, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1558, 21, 1557, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1559, 21, 1558, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1560, 21, 1559, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1561, 21, 1560, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1562, 21, 1561, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1563, 21, 1562, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1564, 21, 1563, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1565, 21, 1564, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1566, 21, 1565, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1567, 21, 1566, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1568, 21, 1567, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1569, 21, 1568, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1570, 21, 1569, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1571, 21, 1570, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1572, 21, 1571, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1573, 21, 1572, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1574, 21, 1573, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1575, 21, 1574, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1576, 21, 1575, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1577, 21, 1576, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1578, 21, 1577, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1579, 21, 1578, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1580, 21, 1579, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1581, 21, 1580, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1582, 21, 1581, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1583, 21, 1582, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1584, 21, 1583, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1585, 21, 1584, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1586, 21, 1585, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1587, 21, 1586, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1588, 21, 1587, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1589, 21, 1588, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1590, 21, 1589, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1591, 21, 1590, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1592, 21, 1591, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1593, 21, 1592, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1594, 21, 1593, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1595, 21, 1594, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1596, 21, 1595, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1597, 21, 1596, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1598, 21, 1597, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1599, 21, 1598, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1600, 21, 1599, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1601, 21, 1600, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1602, 21, 1601, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1603, 21, 1602, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1604, 21, 1603, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1605, 21, 1604, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1606, 21, 1605, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1607, 21, 1606, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1608, 21, 1607, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1609, 21, 1608, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1610, 21, 1609, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1611, 21, 1610, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1612, 21, 1611, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1613, 21, 1612, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1614, 21, 1613, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1615, 21, 1614, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1616, 21, 1615, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1617, 21, 1616, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1618, 21, 1617, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1619, 21, 1618, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1620, 21, 1619, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1621, 21, 1620, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1622, 21, 1621, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1623, 21, 1622, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1624, 21, 1623, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1625, 21, 1624, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1626, 21, 1625, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1627, 21, 1626, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1628, 21, 1627, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1629, 21, 1628, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1630, 21, 1629, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1631, 21, 1630, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1632, 21, 1631, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1633, 21, 1632, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1634, 21, 1633, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1635, 21, 1634, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1636, 21, 1635, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1637, 21, 1636, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1638, 21, 1637, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1639, 21, 1638, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1640, 21, 1639, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1641, 21, 1640, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1642, 21, 1641, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1643, 21, 1642, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1644, 21, 1643, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1645, 21, 1644, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1646, 21, 1645, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1647, 21, 1646, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1648, 21, 1647, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1649, 21, 1648, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1650, 21, 1649, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1651, 21, 1650, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1652, 21, 1651, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1653, 21, 1652, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1654, 21, 1653, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1655, 21, 1654, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1656, 21, 1655, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1657, 21, 1656, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1658, 21, 1657, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1659, 21, 1658, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1660, 21, 1659, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1661, 21, 1660, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1662, 21, 1661, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1663, 21, 1662, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1664, 21, 1663, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1665, 21, 1664, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1666, 21, 1665, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1667, 21, 1666, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1668, 21, 1667, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1669, 21, 1668, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1670, 21, 1669, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1671, 21, 1670, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1672, 21, 1671, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1673, 21, 1672, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1674, 21, 1673, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1675, 21, 1674, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1676, 21, 1675, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1677, 21, 1676, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1678, 21, 1677, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1679, 21, 1678, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1680, 21, 1679, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1681, 21, 1680, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1682, 21, 1681, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1683, 21, 1682, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1684, 21, 1683, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1685, 21, 1684, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1686, 21, 1685, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1687, 21, 1686, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1688, 21, 1687, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1689, 21, 1688, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1690, 21, 1689, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1691, 21, 1690, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1692, 21, 1691, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1693, 21, 1692, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1694, 21, 1693, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1695, 21, 1694, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1696, 21, 1695, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1697, 21, 1696, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1698, 21, 1697, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1699, 21, 1698, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1700, 21, 1699, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1701, 21, 1700, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1702, 21, 1701, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1703, 21, 1702, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1704, 21, 1703, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1705, 21, 1704, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1706, 21, 1705, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1707, 21, 1706, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1708, 21, 1707, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1709, 21, 1708, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1710, 21, 1709, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1711, 21, 1710, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1712, 21, 1711, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1713, 21, 1712, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1714, 21, 1713, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1715, 21, 1714, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1716, 21, 1715, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1717, 21, 1716, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1718, 21, 1717, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1719, 21, 1718, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1720, 21, 1719, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1721, 21, 1720, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1722, 21, 1721, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1723, 21, 1722, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1724, 21, 1723, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1725, 21, 1724, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1726, 21, 1725, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1727, 21, 1726, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1728, 21, 1727, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1729, 21, 1728, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1730, 21, 1729, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1731, 21, 1730, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1732, 21, 1731, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1733, 21, 1732, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1734, 21, 1733, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1735, 21, 1734, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1736, 21, 1735, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1737, 21, 1736, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1738, 21, 1737, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1739, 21, 1738, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1740, 21, 1739, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1741, 21, 1740, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1742, 21, 1741, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1743, 21, 1742, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1744, 21, 1743, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1745, 21, 1744, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1746, 21, 1745, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1747, 21, 1746, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1748, 21, 1747, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1749, 21, 1748, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1750, 21, 1749, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1751, 21, 1750, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1752, 21, 1751, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1753, 21, 1752, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1754, 21, 1753, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1755, 21, 1754, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1756, 21, 1755, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1757, 21, 1756, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1758, 21, 1757, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1759, 21, 1758, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1760, 21, 1759, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1761, 21, 1760, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1762, 21, 1761, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1763, 21, 1762, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1764, 21, 1763, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1765, 21, 1764, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1766, 21, 1765, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1767, 21, 1766, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1768, 21, 1767, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1769, 21, 1768, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1770, 21, 1769, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1771, 21, 1770, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1772, 21, 1771, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1773, 21, 1772, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1774, 21, 1773, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1775, 21, 1774, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1776, 21, 1775, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1777, 21, 1776, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1778, 21, 1777, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1779, 21, 1778, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1780, 21, 1779, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1781, 21, 1780, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1782, 21, 1781, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1783, 21, 1782, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1784, 21, 1783, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1785, 21, 1784, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1786, 21, 1785, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1787, 21, 1786, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1788, 21, 1787, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1789, 21, 1788, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1790, 21, 1789, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1791, 21, 1790, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1792, 21, 1791, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1793, 21, 1792, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1794, 21, 1793, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1795, 21, 1794, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1796, 21, 1795, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1797, 21, 1796, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1798, 21, 1797, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1799, 21, 1798, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1800, 21, 1799, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1801, 21, 1800, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1802, 21, 1801, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1803, 21, 1802, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1804, 21, 1803, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1805, 21, 1804, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1806, 21, 1805, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1807, 21, 1806, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1808, 21, 1807, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1809, 21, 1808, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1810, 21, 1809, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1811, 21, 1810, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1812, 21, 1811, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1813, 21, 1812, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1814, 21, 1813, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1815, 21, 1814, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1816, 21, 1815, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1817, 21, 1816, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1818, 21, 1817, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1819, 21, 1818, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1820, 21, 1819, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1821, 21, 1820, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1822, 21, 1821, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1823, 21, 1822, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1824, 21, 1823, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1825, 21, 1824, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1826, 21, 1825, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1827, 21, 1826, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1828, 21, 1827, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1829, 21, 1828, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1830, 21, 1829, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1831, 21, 1830, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1832, 21, 1831, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1833, 21, 1832, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1834, 21, 1833, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1835, 21, 1834, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1836, 21, 1835, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1837, 21, 1836, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1838, 21, 1837, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1839, 21, 1838, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1840, 21, 1839, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1841, 21, 1840, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1842, 21, 1841, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1843, 21, 1842, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1844, 21, 1843, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1845, 21, 1844, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1846, 21, 1845, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1847, 21, 1846, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1848, 21, 1847, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1849, 21, 1848, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1850, 21, 1849, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1851, 21, 1850, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1852, 21, 1851, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1853, 21, 1852, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1854, 21, 1853, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1855, 21, 1854, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1856, 21, 1855, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1857, 21, 1856, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1858, 21, 1857, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1859, 21, 1858, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1860, 21, 1859, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1861, 21, 1860, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1862, 21, 1861, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1863, 21, 1862, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1864, 21, 1863, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1865, 21, 1864, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1866, 21, 1865, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1867, 21, 1866, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1868, 21, 1867, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1869, 21, 1868, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1870, 21, 1869, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1871, 21, 1870, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1872, 21, 1871, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1873, 21, 1872, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1874, 21, 1873, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1875, 21, 1874, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1876, 21, 1875, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1877, 21, 1876, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1878, 21, 1877, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1879, 21, 1878, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1880, 21, 1879, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1881, 21, 1880, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1882, 21, 1881, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1883, 21, 1882, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1884, 21, 1883, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1885, 21, 1884, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1886, 21, 1885, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1887, 21, 1886, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1888, 21, 1887, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1889, 21, 1888, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1890, 21, 1889, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1891, 21, 1890, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1892, 21, 1891, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1893, 21, 1892, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1894, 21, 1893, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1895, 21, 1894, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1896, 21, 1895, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1897, 21, 1896, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1898, 21, 1897, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1899, 21, 1898, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1900, 21, 1899, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1901, 21, 1900, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1902, 21, 1901, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1903, 21, 1902, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1904, 21, 1903, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1905, 21, 1904, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1906, 21, 1905, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1907, 21, 1906, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1908, 21, 1907, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1909, 21, 1908, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1910, 21, 1909, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1911, 21, 1910, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1912, 21, 1911, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1913, 21, 1912, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1914, 21, 1913, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1915, 21, 1914, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1916, 21, 1915, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1917, 21, 1916, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1918, 21, 1917, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1919, 21, 1918, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1920, 21, 1919, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1921, 21, 1920, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1922, 21, 1921, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1923, 21, 1922, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1924, 21, 1923, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1925, 21, 1924, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1926, 21, 1925, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1927, 21, 1926, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1928, 21, 1927, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1929, 21, 1928, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1930, 21, 1929, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1931, 21, 1930, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1932, 21, 1931, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1933, 21, 1932, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1934, 21, 1933, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1935, 21, 1934, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1936, 21, 1935, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1937, 21, 1936, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1938, 21, 1937, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1939, 21, 1938, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1940, 21, 1939, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1941, 21, 1940, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1942, 21, 1941, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1943, 21, 1942, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1944, 21, 1943, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1945, 21, 1944, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1946, 21, 1945, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1947, 21, 1946, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1948, 21, 1947, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1949, 21, 1948, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1950, 21, 1949, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1951, 21, 1950, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1952, 21, 1951, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1953, 21, 1952, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1954, 21, 1953, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1955, 21, 1954, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1956, 21, 1955, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1957, 21, 1956, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1958, 21, 1957, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1959, 21, 1958, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1960, 21, 1959, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1961, 21, 1960, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1962, 21, 1961, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1963, 21, 1962, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1964, 21, 1963, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1965, 21, 1964, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1966, 21, 1965, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1967, 21, 1966, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1968, 21, 1967, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1969, 21, 1968, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1970, 21, 1969, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1971, 21, 1970, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1972, 21, 1971, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1973, 21, 1972, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1974, 21, 1973, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1975, 21, 1974, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1976, 21, 1975, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1977, 21, 1976, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1978, 21, 1977, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1979, 21, 1978, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1980, 21, 1979, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1981, 21, 1980, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1982, 21, 1981, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1983, 21, 1982, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1984, 21, 1983, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1985, 21, 1984, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1986, 21, 1985, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1987, 21, 1986, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1988, 21, 1987, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1989, 21, 1988, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1990, 21, 1989, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1991, 21, 1990, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1992, 21, 1991, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1993, 21, 1992, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1994, 21, 1993, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1995, 21, 1994, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1996, 21, 1995, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1997, 21, 1996, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1998, 21, 1997, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1999, 21, 1998, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2000, 21, 1999, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2001, 21, 2000, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2002, 21, 2001, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2003, 21, 2002, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2004, 21, 2003, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2005, 21, 2004, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2006, 21, 2005, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2007, 21, 2006, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2008, 21, 2007, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2009, 21, 2008, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2010, 21, 2009, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2011, 21, 2010, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2012, 21, 2011, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2013, 21, 2012, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2014, 21, 2013, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2015, 21, 2014, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2016, 21, 2015, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2017, 21, 2016, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2018, 21, 2017, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2019, 21, 2018, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2020, 21, 2019, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2021, 21, 2020, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2022, 21, 2021, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2023, 21, 2022, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2024, 21, 2023, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2025, 21, 2024, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2026, 21, 2025, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2027, 21, 2026, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2028, 21, 2027, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2029, 21, 2028, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2030, 21, 2029, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2031, 21, 2030, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2032, 21, 2031, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2033, 21, 2032, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2034, 21, 2033, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2035, 21, 2034, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2036, 21, 2035, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2037, 21, 2036, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2038, 21, 2037, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2039, 21, 2038, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2040, 21, 2039, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2041, 21, 2040, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2042, 21, 2041, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2043, 21, 2042, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2044, 21, 2043, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2045, 21, 2044, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2046, 21, 2045, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2047, 21, 2046, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2048, 21, 2047, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2049, 21, 2048, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2050, 21, 2049, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2051, 21, 2050, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2052, 21, 2051, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2053, 21, 2052, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2054, 21, 2053, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2055, 21, 2054, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2056, 21, 2055, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2057, 21, 2056, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2058, 21, 2057, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2059, 21, 2058, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2060, 21, 2059, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2061, 21, 2060, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2062, 21, 2061, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2063, 21, 2062, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2064, 21, 2063, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2065, 21, 2064, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2066, 21, 2065, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2067, 21, 2066, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2068, 21, 2067, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2069, 21, 2068, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2070, 21, 2069, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2071, 21, 2070, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2072, 21, 2071, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2073, 21, 2072, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2074, 21, 2073, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2075, 21, 2074, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2076, 21, 2075, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2077, 21, 2076, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2078, 21, 2077, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2079, 21, 2078, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2080, 21, 2079, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2081, 21, 2080, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2082, 21, 2081, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2083, 21, 2082, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2084, 21, 2083, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2085, 21, 2084, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2086, 21, 2085, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2087, 21, 2086, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2088, 21, 2087, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2089, 21, 2088, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2090, 21, 2089, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2091, 21, 2090, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2092, 21, 2091, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2093, 21, 2092, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2094, 21, 2093, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2095, 21, 2094, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2096, 21, 2095, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2097, 21, 2096, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2098, 21, 2097, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2099, 21, 2098, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2100, 21, 2099, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2101, 21, 2100, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2102, 21, 2101, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2103, 21, 2102, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2104, 21, 2103, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2105, 21, 2104, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2106, 21, 2105, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2107, 21, 2106, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2108, 21, 2107, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2109, 21, 2108, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2110, 21, 2109, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2111, 21, 2110, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2112, 21, 2111, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2113, 21, 2112, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2114, 21, 2113, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2115, 21, 2114, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2116, 21, 2115, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2117, 21, 2116, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2118, 21, 2117, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2119, 21, 2118, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2120, 21, 2119, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2121, 21, 2120, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2122, 21, 2121, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2123, 21, 2122, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2124, 21, 2123, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2125, 21, 2124, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2126, 21, 2125, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2127, 21, 2126, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2128, 21, 2127, 2129, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2129, 21, 2128, 2129, NULL, NULL, NULL);


--
-- TOC entry 2368 (class 0 OID 0)
-- Dependencies: 186
-- Name: associer_objet_pk_associer_objet_seq; Type: SEQUENCE SET; Schema: tables_objet; Owner: -
--

SELECT pg_catalog.setval('associer_objet_pk_associer_objet_seq', 1, false);


--
-- TOC entry 2353 (class 0 OID 19419)
-- Dependencies: 187
-- Data for Name: nom_objet; Type: TABLE DATA; Schema: tables_objet; Owner: -
--

INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1, true, 'Accarisi, Jacopo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (2, true, 'Huet, Pierre-Daniel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 2, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (3, true, 'Clavius, Christopher', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (4, true, 'Digby, Kenelm', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 4, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (5, true, 'Lipse, Juste', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 5, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (6, true, 'Du Bosc, Jacques', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 6, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (7, true, 'Cremonini, Cesare', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (8, true, 'Frey, Jean-Cécile', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 8, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (9, true, 'Liguori, Alfonso de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 9, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (10, true, 'Roberval, Gilles Personne de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 10, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (11, true, 'Descartes, René', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 11, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (12, true, 'Duval, André', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 12, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (13, true, 'Fabri, Filippo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 13, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (14, true, 'Fabri, Honoré', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 14, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (15, true, 'Surian, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (16, true, 'Zimara, Marco Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 16, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (17, true, 'Javelli, Grisostomo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 17, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (18, true, 'Aix de la Chaise, François d''', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 18, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (19, true, 'Licheto, Francesco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 19, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (20, true, 'Moreau, Charles', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 20, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (21, true, 'Hurtado, Tomás', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 21, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (22, true, 'Hurtado, Pedro - de Mendoza', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 22, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (23, true, 'Molina, Luis de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 23, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (24, true, 'Briceño, Alonso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 24, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (25, true, 'Fonseca, Pedro da', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 25, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (26, true, 'Grouchy, Nicolas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 26, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (27, true, 'Gouveia, António de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 27, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (28, true, 'Horváth, Johann Baptist', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 28, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (29, true, 'Sémery, André', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 29, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (30, true, 'Báñez, Domingo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 30, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (31, true, 'Herrera, Agustín de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 31, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (32, true, 'Wietrowski, Maximilian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 32, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (33, true, 'Vitoria, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 33, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (34, true, 'Meier, Georg Friedrich', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 34, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (35, true, 'Malafossa, Giacomino', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 35, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (36, true, 'Sepúlveda, Juan Ginés de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 36, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (37, true, 'Wolff, Christian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 37, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (38, true, 'Tetens, Johann Nikolaus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 38, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (39, true, 'Eschenbach, Johann Christian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 39, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (40, true, 'Aepinus, Franz Albert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 40, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (41, true, 'Thomasius, Christian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 41, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (42, true, 'Walch, Johann Georg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 42, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (43, true, 'Martini, Cornelius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 43, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (44, true, 'Brescia, Fortunato da', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 44, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (45, true, 'Rabe, Paul', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 45, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (46, true, 'Goclenius, Rudolph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 46, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (47, true, 'Soto, Domingo de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 47, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (48, true, 'Sotomayor, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 48, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (49, true, 'Chaves, Diego de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 49, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (50, true, 'Peña, Juan de la', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 50, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (51, true, 'Corpus Christi, Mancio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 51, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (52, true, 'Medina, Bartolomé de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 52, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (53, true, 'Guevara, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 53, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (54, true, 'León, Luis de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 54, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (55, true, 'Guzmán, Domingo de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 55, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (56, true, 'Luna, Alfonso de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 56, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (57, true, 'Ledesma, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 57, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (58, true, 'Herrera, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 58, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (59, true, 'Aragón, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 59, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (60, true, 'Mendoza, Alfonso de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 60, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (61, true, 'Márquez, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 61, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (62, true, 'Antolínez, Agustín', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 62, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (63, true, 'Lessius, Leonardus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 63, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (64, true, 'Genovesi, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 64, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (65, true, 'Casnedi, Carlo Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 65, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (66, true, 'Asson, Baudry d''', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 66, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (67, true, 'Baldelli, Niccolo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 67, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (68, true, 'Echeverria, Carlos de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 68, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (69, true, 'Edlman, Ferdinand', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 69, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (70, true, 'Izquierdo, Sebastián', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 70, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (71, true, 'Vergara, Antonio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 71, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (72, true, 'Vernaz, Ennemond', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 72, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (73, true, 'Viana, Manuel Martin - de San José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 73, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (74, true, 'Espinosa, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 74, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (75, true, 'Froidmont, Libert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 75, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (76, true, 'Elejondo, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 76, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (77, true, 'Elizalde, Miguel de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 77, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (78, true, 'Conceptione, Emmanuel a', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 78, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (79, true, 'Encinas, Fernando', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 79, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (80, true, 'Erber, Anton', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 80, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (81, true, 'Erndtlin, Joachim', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 81, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (82, true, 'Esbarroya, Agustin de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 82, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (83, true, 'Escobar y Mendoza, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 83, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (84, true, 'Estanyol, Angel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 84, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (85, true, 'Estius, Guillelmus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 85, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (86, true, 'Estrix, Egidius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 86, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (87, true, 'Saint-Paul, Eustache de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 87, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (88, true, 'Evrard, Christophe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 88, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (89, true, 'Ezterripa y Zuazu, Atanasio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 89, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (90, true, 'Iribarne e Uraburu, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 90, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (91, true, 'Iribarren, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 91, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (92, true, 'Irurozqui, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 92, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (93, true, 'Ubillos, Juan Antonio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 93, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (94, true, 'Ulloa, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 94, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (95, true, 'Uriarte, Lorenzo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 95, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (96, true, 'Uson, Juan Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 96, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (97, true, 'Vachières, Alipius de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 97, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (98, true, 'Valderrama, Fernando', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 98, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (99, true, 'Valencia, Gregorio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 99, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (100, true, 'Valera, Alfonso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 100, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (101, true, 'Valera, Jerónimo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 101, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (102, true, 'Valero, Angel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 102, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (103, true, 'Le Valois, Louis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 103, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (104, true, 'Valla, Lorenzo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 104, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (105, true, 'Van den Herreweghen, Aegidius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 105, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (106, true, 'Van der Moesen, Franciscus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 106, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (107, true, 'Vianen, Van', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 107, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (108, true, 'Varesio, Carlo Francesco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 108, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (109, true, 'Vargas, Bernardo de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 109, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (110, true, 'Vargas, Ignacio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 110, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (111, true, 'Vaughan, Richard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 111, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (112, true, 'Vautrin, Christophe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 112, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (113, true, 'Vázquez de Malpartida, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 113, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (114, true, 'Vázquez de Belmonte, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 114, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (115, true, 'Vázquez, Gabriel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 115, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (116, true, 'Vázquez de Padilla, Miguel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 116, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (117, true, 'Vega, Andrés de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 117, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (118, true, 'Vanderveken, Frans', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 118, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (119, true, 'Vega, Ildefonso de la', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 119, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (120, true, 'Veglia, Pio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 120, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (121, true, 'Velasco, Diego de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 121, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (122, true, 'Velasco, Matías de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 122, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (123, true, 'Vera Cruz, Alonso de la', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 123, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (124, true, 'Verani, Gaetano Felice', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 124, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (125, true, 'Verde, Francesco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 125, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (126, true, 'Gassendi, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 126, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (127, true, 'Vidal, Jeronimo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 127, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (128, true, 'Vieira, António', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 128, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (129, true, 'Vieroegg, Caesarius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 129, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (130, true, 'Vicens, Gaspar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 130, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (131, true, 'Vilar, Narciso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 131, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (132, true, 'Vilar, Tomás', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 132, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (133, true, 'Villafañe, Antonio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 133, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (134, true, 'Villalpando, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 134, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (135, true, 'Villamarin, Hernando de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 135, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (136, true, 'Villanueva, José de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 136, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (137, true, 'Villavicencio, Bartolomé de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 137, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (138, true, 'Vincent, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 138, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (139, true, 'Vinyals, Vicente', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 139, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (140, true, 'Vinyes, Domènec', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 140, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (141, true, 'Viola, Lorenzo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 141, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (142, true, 'Vischer, Ferdinand', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 142, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (143, true, 'Vitoria y Dávila, José de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 143, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (144, true, 'Vives, Jerónimo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 144, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (145, true, 'Vives, Juan Luis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 145, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (146, true, 'Voetius, Gisbert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 146, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (147, true, 'Volpi, Angelo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 147, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (148, true, 'Vuitasse, D.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 148, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (149, true, 'Yon de Jonage, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 149, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (150, true, 'Ysambert, Nicolas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 150, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (151, true, 'Paris, Yves de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 151, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (152, true, 'Zagaglia, Giuseppe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 152, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (153, true, 'Zambrana Dávalos, Francisco Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 153, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (154, true, 'Zamoro, Giuseppe Maria', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 154, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (155, true, 'Zañartu, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 155, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (156, true, 'Zapata, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 156, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (157, true, 'Zara, Antonius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 157, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (158, true, 'Zaragoza y Vilanova, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 158, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (159, true, 'Zenner, Albert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 159, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (160, true, 'Zingnis, Christoph &amp; Paul', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 160, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (161, true, 'Zuaznabar, Martin de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 161, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (162, true, 'Zuccoli, Vitale', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 162, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (163, true, 'Zumel, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 163, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (164, true, 'Abad, Agustin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 164, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (165, true, 'Abad, Diego José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 165, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (166, true, 'Abarca, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 166, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (167, true, 'Abegg, Johannes Rudolf', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 167, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (168, true, 'Abra de Raconis, Charles François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 168, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (169, true, 'Acevedo, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 169, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (170, true, 'Acevedo, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 170, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (171, true, 'Acosta, José de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 171, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (172, true, 'Agramunt, Pascual de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 172, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (173, true, 'Aguayo, Lupercio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 173, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (174, true, 'Aguiar, Antonio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 174, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (175, true, 'Aguilar, José de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 175, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (176, true, 'Aguirre, Juan Antonio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 176, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (177, true, 'Aguirre, Juan Bautista de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 177, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (178, true, 'Alamanni, Angelo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 178, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (179, true, 'Alamanni, Cosma', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 179, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (180, true, 'Alarcón, Diego de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 180, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (181, true, 'Albarracín, Martín', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 181, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (182, true, 'Alberich, Mariano', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 182, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (183, true, 'Albertini, Francesco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 183, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (184, true, 'Albergoni, Eleuterio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 184, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (185, true, 'Albiz, Martín de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 185, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (186, true, 'Albornoz, Bartolomé de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 186, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (187, true, 'Alcaraz, Cristóbal de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 187, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (188, true, 'Alcaraz, José de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 188, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (189, true, 'Aldrete, Bernardo de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 189, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (190, true, 'Algaba, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 190, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (191, true, 'Alonso, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 191, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (192, true, 'Alsted, Johann Heinrich', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 192, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (193, true, 'Althusius, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 193, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (194, true, 'Álvarado, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 194, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (195, true, 'Álvarez, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 195, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (196, true, 'Alvares, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 196, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (197, true, 'Ambrosini, Giovanni Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 197, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (198, true, 'Ames, William', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 198, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (199, true, 'Amico, Bartolomeo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 199, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (200, true, 'Amico, Francesco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 200, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (201, true, 'Amort, Eusebius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 201, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (202, true, 'Ampach, Rochus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 202, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (203, true, 'Amrhyn, Beatus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 203, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (204, true, 'Angermann, Adalbert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 204, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (205, true, 'Anglés, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 205, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (206, true, 'Annat, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 206, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (207, true, 'Anreiter, Thomas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 207, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (208, true, 'Antist, Vincens Iustinianus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 208, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (209, true, 'Aquario, Mattia', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 209, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (210, true, 'Aquena, Tommaso de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 210, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (211, true, 'Aranda, Felipe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 211, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (212, true, 'Araújo, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 212, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (213, true, 'Araujo, Ildefonso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 213, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (214, true, 'Arcayna, Juan Bautista', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 214, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (215, true, 'Arce y Suárez, Baltasara Petronila', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 215, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (216, true, 'Ardanuy, Orencio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 216, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (217, true, 'Arleth, Abundus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 217, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (218, true, 'Arniseus, Henning', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 218, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (219, true, 'Arnu, Nicolas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 219, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (220, true, 'Arriba, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 220, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (221, true, 'Arrubal, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 221, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (222, true, 'Arsdekin, Richard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 222, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (223, true, 'Astudillo, Diego de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 223, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (224, true, 'Aubelin, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 224, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (225, true, 'Avendaño, Diego de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 225, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (226, true, 'Avendaño, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 226, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (227, true, 'Avilés, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 227, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (228, true, 'Ayleworth, William', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 228, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (229, true, 'Aznar, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 229, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (230, true, 'Aymerich, Mateo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 230, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (231, true, 'Azor, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 231, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (232, true, 'Azpilcueta, Martín de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 232, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (233, true, 'Babenstuber, Ludwig', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 233, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (234, true, 'Baena, Gaspar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 234, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (235, true, 'Bagatta, Bonifacio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 235, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (236, true, 'Bay (Baius), Michel du', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 236, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (237, true, 'Baldwin, Frederick', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 237, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (238, true, 'Balfour, Robert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 238, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (239, true, 'Ballaster, Joan Ramon', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 239, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (240, true, 'Riez, Balthasar de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 240, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (241, true, 'Bancel, Louis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 241, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (242, true, 'Baquero, Martin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 242, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (243, true, 'Barbay, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 243, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (244, true, 'Barbiano, Giovanni (Juan)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 244, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (245, true, 'Barbieri da Castelvetro, Bartolomeo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 245, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (246, true, 'Gravina, Domenico', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 246, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (247, true, 'Baro, Bonaventura', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 247, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (248, true, 'Baronius, Robert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 248, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (249, true, 'Bartholinus, Kaspar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 249, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (250, true, 'Bary, René', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 250, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (251, true, 'Bassée, Eloi de la', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 251, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (252, true, 'Battaglini, Giovanni Battista', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 252, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (253, true, 'Baumeister, Friedrich Christian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 253, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (254, true, 'Bauny, Etienne', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 254, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (255, true, 'Bayon, Nicolas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 255, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (256, true, 'Bayona, Carlos de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 256, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (257, true, 'Bechmann, Friedemann', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 257, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (258, true, 'Bellarini, Giovanni', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 258, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (259, true, 'Belluto, Bonaventura', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 259, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (260, true, 'De Benedetti, Giovanni Battista', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 260, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (261, true, 'Benet, Cipriano', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 261, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (262, true, 'Benet, Louis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 262, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (263, true, 'Benjumea, Blasco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 263, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (264, true, 'Berart, Agustín', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 264, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (265, true, 'Béreur, Louis   -   ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 265, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (266, true, 'Bernal de Avila, Agustín', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 266, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (267, true, 'Bernaldo de Quirós, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 267, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (268, true, 'Bernique, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 268, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (269, true, 'Bertrand, Eutrope', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 269, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (270, true, 'Bérulle, Marc de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 270, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (271, true, 'Bérulle, Pierre de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 271, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (272, true, 'Beyer, Benedictus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 272, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (273, true, 'Biescas, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 273, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (274, true, 'Bimet, Père', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 274, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (275, true, 'Binder, Christoph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 275, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (276, true, 'Birag, Cornelius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 276, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (277, true, 'Bisterfeld, Johann Heinrich', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 277, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (278, true, 'Conceptione, Blasius a', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 278, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (279, true, 'Blázquez, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 279, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (280, true, 'Blondel, Antoine', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 280, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (281, true, 'Bocellin, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 281, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (282, true, 'Boety, Joseph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 282, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (283, true, 'Bofill, Francesc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 283, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (284, true, 'Bonne Espérance, François de la', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 284, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (285, true, 'Bonarte, Thomas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 285, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (286, true, 'Bonell, Joan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 286, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (287, true, 'Bono y Casasús, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 287, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (288, true, 'Bordas, Nicolas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 288, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (289, true, 'Bordonus, Franciscus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 289, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (290, true, 'Borgo, Enrico Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 290, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (291, true, 'Borrull, Matías', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 291, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (292, true, 'Bossat, P.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 292, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (293, true, 'Boucher, Claude', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 293, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (294, true, 'Boucher, Denis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 294, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (295, true, 'Boucher, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 295, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (296, true, 'Bouchuz, Jean-François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 296, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (297, true, 'Bouju, Théophraste', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 297, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (298, true, 'Bourdin, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 298, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (299, true, 'Boust, Guy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 299, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (300, true, 'Bouvier, Joseph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 300, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (301, true, 'Boyvin, Jean Gabriel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 301, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (302, true, 'Brancacio de Caravinea, Clemens', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 302, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (303, true, 'Brandolino, Giovanni', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 303, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (304, true, 'Brauczek, Vilém Anton', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 304, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (305, true, 'Braun, Josef', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 305, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (306, true, 'Briz, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 306, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (307, true, 'Brocà, Ramon', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 307, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (308, true, 'Bruni, Celestino', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 308, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (309, true, 'Brutscher, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 309, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (310, true, 'Buenaventura, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 310, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (311, true, 'Buffier, Claude', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 311, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (312, true, 'Bugis, Pierre de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 312, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (313, true, 'Buhon, Gaspar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 313, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (314, true, 'Buisson, Jean-Baptiste', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 314, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (315, true, 'Bulenger, Jules César', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 315, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (316, true, 'Burghaber, Adam', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 316, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (317, true, 'Burgy, Walter Ludwig', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 317, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (318, true, 'Busaeus, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 318, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (319, true, 'Busembaum, Hermann', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 319, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (320, true, 'Büttner, Christoph Andreas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 320, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (321, true, 'Cabane, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 321, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (322, true, 'Cabrera, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 322, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (323, true, 'Cadana, Salvatore', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 323, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (324, true, 'Calixt, Georg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 324, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (325, true, 'Cally, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 325, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (326, true, 'Calov, Abraham', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 326, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (327, true, 'Calvaria, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 327, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (328, true, 'Camarero, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 328, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (329, true, 'Camargo, Ignacio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 329, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (330, true, 'Cambiaso, Juan Tomas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 330, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (331, true, 'Campion, Edmund', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 331, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (332, true, 'Campo, Andrés del', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 332, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (333, true, 'Campos, Urbano', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 333, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (334, true, 'Campoverde, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 334, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (335, true, 'Campuzano, Bernabé', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 335, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (336, true, 'Guldin, Paul', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 336, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (337, true, 'Cano, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 337, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (338, true, 'Cantalapiedra, Martín Martínez de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 338, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (339, true, 'Cárdenas, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 339, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (340, true, 'Cárdenas Portocarrero, Lorenzo de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 340, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (341, true, 'Cardillo de Villalpando, Gaspar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 341, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (342, true, 'Carpenter, Nathanael', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 342, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (343, true, 'Carral, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 343, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (344, true, 'Carranza de Miranda, Sancho', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 344, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (345, true, 'Carreño, Bartolomé', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 345, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (346, true, 'Cartagena, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 346, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (347, true, 'Cartes y Valdivieso, Bernardo de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 347, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (348, true, 'Carvajal, Luis de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 348, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (349, true, 'Casas, Magin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 349, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (350, true, 'Cascia, V. de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 350, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (351, true, 'Casmann, Otto', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 351, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (352, true, 'Cassarelli, Francesco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 352, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (353, true, 'Castell, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 353, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (354, true, 'Castellano, Fernando', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 354, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (355, true, 'Castelvi, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 355, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (356, true, 'Castiglione, F.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 356, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (357, true, 'Hodierna, Giovanni Battista', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 357, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (358, true, 'Castilla, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 358, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (359, true, 'Castillo Velasco, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 359, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (360, true, 'Castro, Bartolomé de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 360, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (361, true, 'Castro, Cristobal de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 361, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (362, true, 'Castro, Melchor de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 362, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (363, true, 'Castropalao, Hernando de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 363, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (364, true, 'Castrovol, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 364, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (365, true, 'Caterus, Johan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 365, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (366, true, 'Cattaneo, O.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 366, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (367, true, 'Celaya, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 367, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (368, true, 'Censi, Girolamo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 368, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (369, true, 'Ceriziers, René de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 369, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (370, true, 'Céspedes, Baltasar de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 370, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (371, true, 'Céspedes, Valentín de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 371, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (372, true, 'Chabron, Guillaume', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 372, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (373, true, 'Chacón, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 373, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (374, true, 'Chacón, Manuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 374, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (375, true, 'Chalmers, William', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 375, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (376, true, 'Gallo, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 376, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (377, true, 'Chagoyen, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 377, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (378, true, 'Chamillard, Gaston', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 378, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (379, true, 'Chanevelle, Jacques', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 379, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (380, true, 'l''Assomption, Charles de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 380, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (381, true, 'Chastelier, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 381, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (382, true, 'Chazal de Lamorandin, Pierre-Amat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 382, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (383, true, 'Chevalier, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 383, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (384, true, 'Cienfuegos, Álvaro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 384, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (385, true, 'Cinammo, L.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 385, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (386, true, 'Ciorla, Vincenzo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 386, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (387, true, 'Cippullo, Gregorio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 387, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (388, true, 'Ciruelo, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 388, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (389, true, 'Clauberg, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 389, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (390, true, 'Clément, Claude', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 390, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (391, true, 'Clemente, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 391, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (392, true, 'Clenaerts, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 392, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (393, true, 'Cobos, Cristobal de los', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 393, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (394, true, 'Coccejus, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 394, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (395, true, 'Cochet, Jean-Baptiste', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 395, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (396, true, 'Colomb, Bonaventure', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 396, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (397, true, 'Combach, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 397, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (398, true, 'Compton Carleton, Thomas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 398, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (399, true, 'Collegium Complutense', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 399, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (400, true, 'Conimbricense, Collegium', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 400, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (401, true, 'Coninck, Gilles de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 401, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (402, true, 'Contenson, Vincent', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 402, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (403, true, 'Constesti, Rafael', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 403, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (404, true, 'Conti, Giovannbattista', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 404, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (405, true, 'Córdoba, Antonio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 405, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (406, true, 'Inchofer, Melchior', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 406, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (407, true, 'Cornaeus, Melchior', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 407, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (408, true, 'Cornejo, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 408, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (409, true, 'Cornejo de Pedrosa, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 409, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (410, true, 'Coronel, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 410, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (411, true, 'Coronel, Luis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 411, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (412, true, 'Corsini, Odoardo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 412, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (413, true, 'Coscan, Oswald', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 413, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (414, true, 'Cossé de Brissac, Charles', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 414, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (415, true, 'Cottet, Anton', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 415, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (416, true, 'Cottunio, Giovanni', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 416, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (417, true, 'Covarrubias y Leyva, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 417, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (418, true, 'Crab, Gilbert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 418, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (419, true, 'Crakanthorpe, Richard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 419, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (420, true, 'Crassot, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 420, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (421, true, 'Crespi de Borja, Luis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 421, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (422, true, 'Crespo, Andrés', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 422, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (423, true, 'Crom, Adrien', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 423, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (424, true, 'Cross, John', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 424, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (425, true, 'Crottat, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 425, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (426, true, 'Cruccio, Jacopo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 426, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (427, true, 'Crust, Thomas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 427, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (428, true, 'Cruz, Francisco de la', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 428, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (429, true, 'Cruzat, Gaspar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 429, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (430, true, 'Cuba y Arce, Cristóbal de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 430, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (431, true, 'Cuadrado, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 431, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (432, true, 'Cueto, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 432, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (433, true, 'Curcio Palomero, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 433, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (434, true, 'Curiel, Juan Alfonso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 434, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (435, true, 'Custurer, Jaume', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 435, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (436, true, 'Dabillon, André', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 436, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (437, true, 'Kepler, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 437, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (438, true, 'Dagoumer, Guillaume', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 438, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (439, true, 'Daneau, Lambert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 439, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (440, true, 'Daniel, Gabriel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 440, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (441, true, 'Darder, Tomàs', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 441, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (442, true, 'Daubenton, Guillaume', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 442, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (443, true, 'David, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 443, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (444, true, 'Dávila, Manuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 444, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (445, true, 'Dechales, Claude', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 445, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (446, true, 'Dechamps, Etienne-Agard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 446, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (447, true, 'Kircher, Athanasius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 447, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (448, true, 'Delgado, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 448, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (449, true, 'Della Faille, Jean Charles', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 449, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (450, true, 'Delpí, Felipe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 450, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (451, true, 'Del Rio, Martín Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 451, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (452, true, 'Marini, Domenico De', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 452, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (453, true, 'Derham, William', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 453, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (454, true, 'Kennis, Ignatius Der', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 454, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (455, true, 'Desgabets, Robert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 455, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (456, true, 'Desirant, Bernard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 456, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (457, true, 'Desmarets, Samuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 457, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (458, true, 'Deza, Diego de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 458, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (459, true, 'Diana, Antonino', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 459, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (460, true, 'Dias Franco, Luíz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 460, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (461, true, 'Diaz de Llanos, Froylan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 461, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (462, true, 'Dicastillo, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 462, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (463, true, 'Dierkens, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 463, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (464, true, 'Dieterich, Konrad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 464, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (465, true, 'Díez de Isla, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 465, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (466, true, 'Dijours, Valentin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 466, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (467, true, 'Diotallevi, Francesco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 467, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (468, true, 'Dolz del Castellar, Esteban', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 468, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (469, true, 'Donaldson, Walter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 469, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (470, true, 'Dreier, Christian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 470, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (471, true, 'Dubal, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 471, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (472, true, 'Bois, François Du', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 472, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (473, true, 'Duchek, Jan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 473, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (474, true, 'Dufort, Paulin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 474, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (475, true, 'Duhan, Laurent', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 475, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (476, true, 'Dullaert, Jan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 476, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (477, true, 'Pasquier, Sébastien Du', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 477, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (478, true, 'Las Casas, Bartolomé', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 478, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (479, true, 'Dupleix, Scipion', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 479, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (480, true, 'Duprenne, Jacques', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 480, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (481, true, 'Durand, Barthélémy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 481, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (482, true, 'Trieu, Philippe Du', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 482, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (483, true, 'Duval, Robert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 483, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (484, true, 'Eberhard, Georg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 484, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (485, true, 'Eberle, Wolfgang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 485, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (486, true, 'Edisford, John', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 486, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (487, true, 'Egel, Ambrosius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 487, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (488, true, 'Eggendorfer, Wolfgang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 488, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (489, true, 'Egues, Baltasar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 489, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (490, true, 'Escalera, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 490, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (491, true, 'Escazena, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 491, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (492, true, 'Espinosa, José de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 492, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (493, true, 'Espinosa, Miguel de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 493, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (494, true, 'Espinosa Medrano, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 494, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (495, true, 'Esquivel, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 495, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (496, true, 'Everard, Guillelmus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 496, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (497, true, 'Fabra, Francesc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 497, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (498, true, 'Fagnani, Prospero', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 498, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (499, true, 'Fajardo y Dávalos, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 499, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (500, true, 'Falconi, Gregorio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 500, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (501, true, 'Fantis, Antonio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 501, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (502, true, 'Fantono, Girolamo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 502, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (503, true, 'Farinoni, Guglielmo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 503, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (504, true, 'Farvacques, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 504, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (505, true, 'Fasani, Francesco Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 505, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (506, true, 'Fasolini, Benedetto', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 506, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (507, true, 'Fasolo, Girolamo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 507, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (508, true, 'Fassari, Vicenzo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 508, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (509, true, 'Leibniz, Wilhelm Gottfried', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 509, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (510, true, 'Fasson, Tomás', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 510, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (511, true, 'Faure, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 511, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (512, true, 'Fay, Pierre du', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 512, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (513, true, 'Faure, Jean-Baptiste', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 513, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (514, true, 'Faydit, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 514, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (515, true, 'Feder, Johann Georg Heinrich', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 515, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (516, true, 'Fédé, René', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 516, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (517, true, 'Felix de Molina, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 517, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (518, true, 'Felwinger, Johannes Paul', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 518, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (519, true, 'Fernández de Robles, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 519, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (520, true, 'Fernández de Torrejon, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 520, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (521, true, 'Ferran, Joan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 521, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (522, true, 'Ferrusola, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 522, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (523, true, 'Feu-Ardent Sr., François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 523, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (524, true, 'Feu-Ardent Jr., François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 524, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (525, true, 'Feu, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 525, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (526, true, 'Fezaye, Philibert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 526, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (527, true, 'Flavigny, Valérien de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 527, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (528, true, 'Flórez de Setién, Enrique', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 528, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (529, true, 'Florindas, Diego de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 529, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (530, true, 'Font, Bernardo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 530, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (531, true, 'Font, Joan Pau', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 531, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (532, true, 'Forbes, John', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 532, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (533, true, 'Forer, Laurenz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 533, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (534, true, 'Fornari, Martino', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 534, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (535, true, 'Forró, Georgius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 535, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (536, true, 'Forti, A.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 536, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (537, true, 'Foucher, Simon', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 537, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (538, true, 'Fournenc, Jacques', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 538, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (539, true, 'Cristo, Francisco do', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 539, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (540, true, 'Francisco de San Agustin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 540, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (541, true, 'Frkic, Mate', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 541, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (542, true, 'Freisleben, Franz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 542, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (543, true, 'Froidmont, Grégoire', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 543, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (544, true, 'Fuente, Francisco de la', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 544, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (545, true, 'Fuente, Juan de la', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 545, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (546, true, 'Fuente Hurtado, Diego de la', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 546, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (547, true, 'Fullana, Bartomeu Antoni', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 547, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (548, true, 'Gaget, Roch', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 548, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (549, true, 'Galatini, Pietro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 549, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (550, true, 'Galfard, Jean-Magloire', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 550, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (551, true, 'Galindo, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 551, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (552, true, 'Gradi, Stefano', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 552, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (553, true, 'Galitius de Carpenedulo, Marcus Antonius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 553, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (554, true, 'Gallego de Vera, Bernabé', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 554, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (555, true, 'Galliardi, Achille', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 555, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (556, true, 'Gamaches, Philippe de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 556, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (557, true, 'Gamarra y Dávalos, Juan Benito Díaz de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 557, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (558, true, 'Garau, Francesc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 558, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (559, true, 'García, Andrés', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 559, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (560, true, 'García, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 560, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (561, true, 'García, Domingo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 561, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (562, true, 'García, Eliseo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 562, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (563, true, 'García, Francisco José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 563, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (564, true, 'García, Manuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 564, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (565, true, 'García Bravo, Diego Felipe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 565, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (566, true, 'Garnier, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 566, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (567, true, 'Gaudinus, Ambrosius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 567, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (568, true, 'Gautruche, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 568, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (569, true, 'Gavardi, Frederico Nicola', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 569, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (570, true, 'Gavarró, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 570, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (571, true, 'Gayot, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 571, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (572, true, 'Gerhard, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 572, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (573, true, 'Geyss, Wilhelm', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 573, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (574, true, 'Giannini, Tommaso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 574, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (575, true, 'Giattini, Giovannbattista', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 575, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (576, true, 'Giattini, Giovannbattista', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 576, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (577, true, 'Gibieuf, Guillaume', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 577, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (578, true, 'Gil, Cristovão', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 578, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (579, true, 'Presentação, Gil da', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 579, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (580, true, 'Giner, Damián', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 580, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (581, true, 'Montefortino, Girolamo da', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 581, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (582, true, 'Godoy, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 582, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (583, true, 'Góis, Manuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 583, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (584, true, 'Lisboa, Gomes de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 584, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (585, true, 'Gooden, John', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 585, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (586, true, 'Gonet, Jean-Baptiste', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 586, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (587, true, 'González, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 587, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (588, true, 'González de Albelda, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 588, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (589, true, 'González de León, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 589, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (590, true, 'González Mateo, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 590, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (591, true, 'Gonzalez de Rosende, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 591, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (592, true, 'González de Santa Cruz, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 592, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (593, true, 'González de Santalla, Tirso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 593, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (594, true, 'Gonzalvus, Josephus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 594, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (595, true, 'Gordon, Andrew', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 595, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (596, true, 'Gormaz, Juan Bautista', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 596, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (597, true, 'Goudin, Antoine', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 597, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (598, true, 'Gozalvo, Marcelino', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 598, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (599, true, 'Gracián, Baltasar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 599, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (600, true, 'Grajal, Gaspar de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 600, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (601, true, 'Granado, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 601, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (602, true, 'Grandin, Martin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 602, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (603, true, 'Grange, Jean-Baptiste de la', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 603, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (604, true, 'Granger, Gabriel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 604, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (605, true, 'Monfort, Gratien de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 605, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (606, true, 'Grawer, Albert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 606, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (607, true, 'Saint-Vincent, Grégoire de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 607, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (608, true, 'Grégoire, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 608, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (609, true, 'Gregorio, Maurizio Di', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 609, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (610, true, 'Grimaldi, Francesco Maria', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 610, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (611, true, 'Lugo, Jean de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 611, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (612, true, 'Groll, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 612, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (613, true, 'Grotius, Hugo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 613, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (614, true, 'Grustdorff, Amandus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 614, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (615, true, 'Gruyer, Pierre-François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 615, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (616, true, 'Guérinois, Jacques Casimir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 616, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (617, true, 'Guerra, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 617, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (618, true, 'Guevara, Jeronimo de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 618, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (619, true, 'Guilleminot, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 619, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (620, true, 'Gutiérrez, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 620, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (621, true, 'Gutiérrez, Lorenzo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 621, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (622, true, 'Gutiérrez, Miguel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 622, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (623, true, 'Gutiérrez de la Sal, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 623, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (624, true, 'Gutke, Georg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 624, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (625, true, 'Gutzeit, François Antoine', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 625, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (626, true, 'Guyenard de Maisonforte, François-Marie', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 626, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (627, true, 'Habert, Isaac', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 627, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (628, true, 'Habert, Louis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 628, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (629, true, 'Haller, Gregor', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 629, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (630, true, 'Halloix, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 630, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (631, true, 'Hangest, Jérôme de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 631, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (632, true, 'Haunold, Christoph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 632, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (633, true, 'Hauser, Berthold', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 633, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (634, true, 'Hauzeur, Matthias', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 634, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (635, true, 'Revius, Jacobus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 635, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (636, true, 'Hawenreuter, Johann Ludwig', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 636, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (637, true, 'Hebenstreit, Johannes Paul', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 637, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (638, true, 'Heidelberger, Georg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 638, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (639, true, 'Hell, Caspar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 639, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (640, true, 'Hemelman, Jorge', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 640, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (641, true, 'Hemmerlin, Anton', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 641, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (642, true, 'Henao, Gabriel de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 642, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (643, true, 'd''Henau, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 643, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (644, true, 'Hennebel, Jean-Libert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 644, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (645, true, 'Henneguier, Jérôme', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 645, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (646, true, 'Henno, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 646, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (647, true, 'Henriques, Henrique', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 647, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (648, true, 'Heredia, Idelfonso de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 648, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (649, true, 'Macedo, Francisco - de Sao Agostinho', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 649, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (650, true, 'Herice, Valentín de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 650, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (651, true, 'Herincx, Willem', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 651, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (652, true, 'Hermann, Amandus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 652, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (653, true, 'Hermann, Ambrosius Celestinus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 653, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (654, true, 'Hermann, Georg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 654, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (655, true, 'Hernandes, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 655, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (656, true, 'Hernández de la Torre, Jacinto', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 656, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (657, true, 'Herrera, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 657, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (658, true, 'Herwart, Marquard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 658, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (659, true, 'Hevenesi, Gabriel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 659, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (660, true, 'Hickey, Anthony', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 660, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (661, true, 'Hidalgo, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 661, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (662, true, 'Hirnhaim, Hieronymus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 662, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (663, true, 'Hodieu, Alexis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 663, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (664, true, 'Hofman (Donatus a Transfiguratione Domini), Donatus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 664, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (665, true, 'Holzhai, Georg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 665, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (666, true, 'Horion, Jean de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 666, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (667, true, 'Housta, Baudouin de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 667, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (668, true, 'Huarte de San Juan, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 668, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (669, true, 'Hueber, Fortunatus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 669, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (670, true, 'Huertos, Marcos de los', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 670, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (671, true, 'Hugonius, Henricus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 671, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (672, true, 'Hurtado, Gaspar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 672, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (673, true, 'Hyperius, Andreas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 673, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (674, true, 'Ibarra, Esteban de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 674, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (675, true, 'Jack, Gilbert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 675, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (676, true, 'Jacinto de la Madre de Dios', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 676, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (677, true, 'Jacquier, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 677, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (678, true, 'Jansenius, Cornelius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 678, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (679, true, 'Jaúregui, Martín de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 679, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (680, true, 'Javier Sierra, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 680, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (681, true, 'Janson, Jacques', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 681, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (682, true, 'Jiménez, Ildefonso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 682, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (683, true, 'Jimenez Royo, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 683, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (684, true, 'Jonghe, Jean de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 684, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (685, true, 'Juan, Gabriel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 685, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (686, true, 'Juan, Ignacio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 686, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (687, true, 'Juan de San Miguel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 687, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (688, true, 'Julián, Jerónimo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 688, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (689, true, 'Jung, Joachim', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 689, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (690, true, 'Junius (Andrew Young), Andreas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 690, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (691, true, 'Juste, Tomás', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 691, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (692, true, 'Kazenberger, Kilian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 692, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (693, true, 'Keckermann, Bartholomäus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 693, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (694, true, 'Kesler, Andreas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 694, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (695, true, 'Keynes, Alexander', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 695, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (696, true, 'Kirchhueber, Barnabas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 696, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (697, true, 'Kirchner, Daniel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 697, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (698, true, 'Kisel, Valentin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 698, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (699, true, 'Kitzner, Balthasar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 699, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (700, true, 'Klainer, Georg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 700, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (701, true, 'Kleinermann, Peter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 701, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (702, true, 'Kochanowski, Dominicus Corvinus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 702, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (703, true, 'Kojalowicz-Wijuk, Albertus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 703, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (704, true, 'Kolek, Ladislaus Michael', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 704, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (705, true, 'Korona, Marcus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 705, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (706, true, 'Knittel, Kaspar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 706, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (707, true, 'Kreszlinger, Massaus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 707, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (708, true, 'Krilinski, Prosper', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 708, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (709, true, 'Krisper, Crescentius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 709, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (710, true, 'Krupka, Bernardinus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 710, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (711, true, 'Labat, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 711, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (712, true, 'La Chapelle, Claude', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 712, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (713, true, 'Lainez, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 713, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (714, true, 'Lalemendet, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 714, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (715, true, 'Lallemant, Nicolas-Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 715, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (716, true, 'Lamparter, Heinrich', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 716, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (717, true, 'La Napola da Trapani, Giuseppe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 717, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (718, true, 'Lanza, Francisco de la', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 718, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (719, true, 'Magni, Valeriano', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 719, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (720, true, 'Lariz, Esteban', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 720, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (721, true, 'Lourenço, Agostinho', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 721, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (722, true, 'Laymann, Paul', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 722, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (723, true, 'Lax, Gaspar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 723, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (724, true, 'Lazaro, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 724, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (725, true, 'Lázarraga, Jerónimo José de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 725, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (726, true, 'Lechner, Kaspar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 726, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (727, true, 'Le Clerc (Joannes Clericus), Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 727, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (728, true, 'Leclerc, M.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 728, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (729, true, 'Duarte, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 729, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (730, true, 'Gizel, Innokentii', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 730, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (731, true, 'Ledesma, Martín de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 731, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (732, true, 'Maignan, Emmanuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 732, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (733, true, 'Le Grand, Antoine', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 733, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (734, true, 'Lehmann, Christoph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 734, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (735, true, 'Le Mairat, Louis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 735, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (736, true, 'Le Maistre de La Garlaye, François-Marie', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 736, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (737, true, 'Le Moine, Alphonse', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 737, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (738, true, 'Lemonnier, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 738, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (739, true, 'Lentulus, Cyriacus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 739, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (740, true, 'Le Rées, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 740, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (741, true, 'Lerm, Roch', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 741, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (742, true, 'Lerma, Cosme de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 742, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (743, true, 'Lespinasse, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 743, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (744, true, 'Lestocq, Guillaume de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 744, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (745, true, 'Lherminier, Nicolas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 745, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (746, true, 'Libavus, Andreas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 746, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (747, true, 'Pedro - de Lievana', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 747, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (748, true, 'Litsich von Scheyern, Otto', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 748, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (749, true, 'Mesland, Denis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 749, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (750, true, 'Llamazares, Tomás', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 750, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (751, true, 'Rythovius, Martin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 751, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (752, true, 'Hessels, Jan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 752, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (753, true, 'Lobera, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 753, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (754, true, 'Locherer, Alipius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 754, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (755, true, 'Challemoux, Charles', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 755, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (756, true, 'Charlet, Etienne', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 756, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (757, true, 'Serry, Jacques-Hyacinthe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 757, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (758, true, 'Jenicot, Nicolas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 758, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (759, true, 'Verdin, Philippe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 759, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (760, true, 'Verdière, Michel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 760, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (761, true, 'Agathange de Saint-Clément', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 761, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (762, true, 'Henri de Saint-Ignace', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 762, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (763, true, 'Ancion, Antoine', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 763, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (764, true, 'D''Elbecque, Norbert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 764, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (765, true, 'Lodigeri, Callisto', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 765, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (766, true, 'Durand, Philippe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 766, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (767, true, 'Denis, Henri', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 767, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (768, true, 'Eyben, Arnold', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 768, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (769, true, 'Le Beau, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 769, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (770, true, 'De Hondt, J.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 770, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (771, true, 'Girken, Nikolaus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 771, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (772, true, 'Elisée de Saint-François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 772, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (773, true, 'Stock de Sainte-Marie, Simon', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 773, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (774, true, 'Balthasar de l''Enfant Jésus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 774, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (775, true, 'Boninchi, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 775, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (776, true, 'Lohner, Tobias', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 776, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (777, true, 'Minelli, Giovanni Felix', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 777, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (778, true, 'Ferro, Vincenzo Maria', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 778, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (779, true, 'Fostier, Jacques', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 779, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (780, true, 'Du Mont, Hyacinthe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 780, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (781, true, 'Loeber, Christoph Heinrich', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 781, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (782, true, 'Alciati, Terenzio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 782, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (783, true, 'Auger, Denis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 783, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (784, true, 'Ayrault, Guillaume', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 784, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (785, true, 'Longo, Francesco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 785, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (786, true, 'Deriennes, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 786, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (787, true, 'Dinet, Jacques', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 787, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (788, true, 'Fournier, Jacques', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 788, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (789, true, 'Gandillon, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 789, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (790, true, 'Girauld, Claude', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 790, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (791, true, 'Pinthereau, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 791, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (792, true, 'Sparilardus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 792, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (793, true, 'Della Croce, Giacomo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 793, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (794, true, 'Tasca, Lorenzo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 794, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (795, true, 'López, Blasco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 795, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (796, true, 'Lopez, Luis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 796, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (797, true, 'Manescal, Onofre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 797, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (798, true, 'Lorca, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 798, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (799, true, 'Lorini, Jean de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 799, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (800, true, 'Rampen, Henri', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 800, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (801, true, 'Deckers, Martin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 801, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (802, true, 'Losada, Domingo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 802, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (803, true, 'Losada, Luis de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 803, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (804, true, 'Losy, Johannes Antonius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 804, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (805, true, 'Lozano, Esteban', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 805, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (806, true, 'Lugo, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 806, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (807, true, 'Luis, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 807, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (808, true, 'Caspe, Luis de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 808, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (809, true, 'Lumbier y Angel, Raimundo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 809, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (810, true, 'Lupus, Chrétien', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 810, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (811, true, 'Luque, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 811, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (812, true, 'Lynch, Richard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 812, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (813, true, 'Pinelo, Gabriel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 813, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (814, true, 'Lucero, Fernando', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 814, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (815, true, 'McCaghwell, Hugh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 815, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (816, true, 'McDonogh, James', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 816, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (817, true, 'Macedo, Bento de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 817, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (818, true, 'Magistris (Jean Lemaître), Joannes de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 818, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (819, true, 'Fantuzzi, Giovanni', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 819, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (820, true, 'Capponi, Tommaso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 820, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (821, true, 'Mahler, Georg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 821, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (822, true, 'Mailhat, Raymond', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 822, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (823, true, 'Makar, Andras', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 823, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (824, true, 'Makowski, Jan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 824, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (825, true, 'Maldonado, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 825, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (826, true, 'Maldonado, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 826, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (827, true, 'Maldonado, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 827, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (828, true, 'Malebranche, Nicolas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 828, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (829, true, 'Mallet, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 829, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (830, true, 'Maluenda, Tomás', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 830, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (831, true, 'Schautheet, Fulgence', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 831, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (832, true, 'Schegk, Jakob', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 832, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (833, true, 'Scheibl, Christoph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 833, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (834, true, 'Scheibler, Christoph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 834, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (835, true, 'Scheidsach, Fructuosus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 835, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (836, true, 'Schellekens, Jacques (Jacobus)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 836, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (837, true, 'Davenport, Christopher', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 837, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (838, true, 'Mamiani della Rovere, Luigi Vicenzo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 838, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (839, true, 'Gorleaus, David', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 839, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (840, true, 'Manca de Prado, Francesco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 840, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (841, true, 'Marci, Johannes Marcus - of Kronland', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 841, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (842, true, 'Manderston, William', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 842, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (843, true, 'Mändl, Melchior von', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 843, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (844, true, 'Manente, Jaume', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 844, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (845, true, 'Manganellis, Luis de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 845, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (846, true, 'Mangold, Josef', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 846, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (847, true, 'Manrique, Ángel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 847, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (848, true, 'Manzoli, Bartholomaeus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 848, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (849, true, 'Marandé, Léonard de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 849, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (850, true, 'Meigret, Amédée', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 850, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (851, true, 'Marbeuf, Claude-François-Marie de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 851, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (852, true, 'Bauduen, Marc de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 852, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (853, true, 'Riez, Marcel de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 853, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (854, true, 'Marchant, Arnold', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 854, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (855, true, 'Marchant, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 855, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (856, true, 'Marcellius, Heinrich', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 856, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (857, true, 'Marcillo, Manuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 857, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (858, true, 'Marcillo, Ramón', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 858, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (859, true, 'Marcos, Miguel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 859, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (860, true, 'Margalho, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 860, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (861, true, 'Mariale, Sante', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 861, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (862, true, 'Viñas, Miguel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 862, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (863, true, 'Marín, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 863, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (864, true, 'Schoockius, Martin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 864, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (865, true, 'Marques de Piedrahita, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 865, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (866, true, 'Handerla, Ferenc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 866, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (867, true, 'Alting, Jacob', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 867, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (868, true, 'Duchesne, Joseph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 868, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (869, true, 'Marsigli, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 869, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (870, true, 'Lipstorp, Daniel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 870, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (871, true, 'Reimers (Reimarus), Nicolaus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 871, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (872, true, 'Röslin (Roeslin), Helisaeus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 872, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (873, true, 'Peucer, Caspar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 873, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (874, true, 'Martin, André', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 874, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (875, true, 'Eisenmenger, Samuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 875, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (876, true, 'Grynaeus, Simon', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 876, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (877, true, 'Nachenmoser, Adam', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 877, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (878, true, 'Gemma, Cornelius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 878, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (879, true, 'Turre, Giuseppe Maria de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 879, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (880, true, 'Reluz, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 880, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (881, true, 'Gómez, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 881, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (882, true, 'Ruiz Delgado, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 882, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (883, true, 'Martin, Simon', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 883, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (884, true, 'Ron, Manuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 884, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (885, true, 'Deza, Alonso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 885, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (886, true, 'Pisa, Alonso de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 886, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (887, true, 'Solano, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 887, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (888, true, 'Moreira, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 888, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (889, true, 'José da Assunção', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 889, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (890, true, 'Pereira de Santa Ana, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 890, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (891, true, 'Aliaga Martínez, Luis de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 891, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (892, true, 'Lanuza, Jerónimo Bautista de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 892, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (893, true, 'Alderete, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 893, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (894, true, 'Martínez, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 894, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (895, true, 'Bozio, Tommaso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 895, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (896, true, 'Florencia, Jerónimo de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 896, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (897, true, 'Tiedra, Jerónimo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 897, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (898, true, 'Ribas, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 898, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (899, true, 'Martínez, Nicolás', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 899, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (900, true, 'Martínez de Prado, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 900, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (901, true, 'Elbel, Benjamin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 901, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (902, true, 'Vlacic (Flacius), Matija', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 902, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (903, true, 'Egnazio (Egnati), Gianbattista', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 903, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (904, true, 'Segura, Jacinto', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 904, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (905, true, 'Màs, Luis Vicente', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 905, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (906, true, 'Navàsses, Mariano', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 906, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (907, true, 'Calatayud, Vicente', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 907, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (908, true, 'Ortì y Figuerola, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 908, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (909, true, 'Martínez de la Raga, Vicente', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 909, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (910, true, 'Brù, Estevan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 910, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (911, true, 'Sala, Pasqual', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 911, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (912, true, 'Antoine, Paul Gabriel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 912, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (913, true, 'Antoine de Laon', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 913, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (914, true, 'Annat, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 914, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (915, true, 'Martínez de Ripalda, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 915, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (916, true, 'Martínez Silíceo, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 916, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (917, true, 'Martini, Jakob', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 917, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (918, true, 'Martinon, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 918, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (919, true, 'Marçal, Francesc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 919, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (920, true, 'Mas, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 920, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (921, true, 'Martins Mascarenhas, Fernando', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 921, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (922, true, 'Massol de Montmoyen, Jean de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 922, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (923, true, 'Massoulié, Antonin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 923, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (924, true, 'Mattenburch, Petrus de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 924, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (925, true, 'Stiive, Gottfried', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 925, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (926, true, 'Steidle, Victorianus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 926, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (927, true, 'Matute, Bernabé de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 927, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (928, true, 'Stehle, Leo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 928, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (929, true, 'Handl, Franz-Josef von', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 929, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (930, true, 'Höss, Sebastian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 930, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (931, true, 'Umbhofer, Gerhard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 931, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (932, true, 'Höss, Tobias', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 932, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (933, true, 'Maura, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 933, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (934, true, 'Mayer, Jakob', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 934, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (935, true, 'Mayr, Anton', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 935, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (936, true, 'Mayr, Benno', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 936, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (937, true, 'Mazueco, Simón de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 937, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (938, true, 'Nájera, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 938, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (939, true, 'Schmalz, Valentin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 939, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (940, true, 'Socini (Sozzini, Socinus), Fausto', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 940, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (941, true, 'Pierre (Petrus), Barthélémy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 941, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (942, true, 'Navarrete, Baltasar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 942, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (943, true, 'Leullier, Claude', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 943, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (944, true, 'Bourdelot, Pierre Bonnet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 944, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (945, true, 'Navarro, Joaquín', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 945, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (946, true, 'Röell, Hermann Alexander', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 946, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (947, true, 'Navarro, Vicente', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 947, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (948, true, 'King, Paul', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 948, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (949, true, 'Pandolfi, Giacinto', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 949, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (950, true, 'Dongo, Daniel de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 950, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (951, true, 'Navasques, Domingo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 951, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (952, true, 'Pirhing, Heinrich', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 952, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (953, true, 'Marinis, Giovanni Battista de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 953, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (954, true, 'Naveros, Jacobo de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 954, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (955, true, 'Forsanus, Ioannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 955, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (956, true, 'O''Connor Kerry, Bonaventure', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 956, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (957, true, 'Nazario, Giovanni Paolo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 957, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (958, true, 'Courcier, Louis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 958, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (959, true, 'Pastel, Jean Antoine', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 959, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (960, true, 'Neubauer, Georg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 960, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (961, true, 'Voigt, Gottfried', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 961, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (962, true, 'Schrader, Friedrich', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 962, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (963, true, 'Le Chapelier de Moron, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 963, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (964, true, 'Neuhauser, Bernhard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 964, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (965, true, 'Robbe, Jacques', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 965, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (966, true, 'Brailles, Louis-Charles de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 966, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (967, true, 'Salmon, André', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 967, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (968, true, 'Ribailler, Ambroise', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 968, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (969, true, 'Bruget, Emmanuel-Clément-Chrétien', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 969, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (970, true, 'Boursier, Laurent-François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 970, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (971, true, 'Delan (de Lan), François-Hyacinthe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 971, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (972, true, 'Dubourg, Etienne', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 972, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (973, true, 'La Fleutrie, Barthélémy de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 973, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (974, true, 'Lambert, Joseph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 974, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (975, true, 'Nieremberg, Juan Eusebio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 975, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (976, true, 'Lefèvre, Noël-Antoine', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 976, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (977, true, 'Le Moine, Antoine', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 977, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (978, true, 'Maruel, Edmond', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 978, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (979, true, 'Ruel, Jean-Baptiste', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 979, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (980, true, 'Salmon, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 980, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (981, true, 'Touvenot, Charles-Antoine', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 981, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (982, true, 'Vivant, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 982, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (983, true, 'Belloy de Francières, Vincent-Charles-Antoine de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 983, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (984, true, 'Beyne, François-Pierre de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 984, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (985, true, 'Briquet, Jacques-Christophe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 985, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (986, true, 'Nicolaï, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 986, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (987, true, 'La Chassaigne, Antoine de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 987, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (988, true, 'La Mare, Guillaume de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 988, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (989, true, 'Baudry, Louis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 989, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (990, true, 'Poulain, Louis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 990, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (991, true, 'Nieto, Juan Martin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 991, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (992, true, 'Nihusius, Bartholdus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 992, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (993, true, 'Ninot i Ninot, Jeroni', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 993, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (994, true, 'Nizzoli (Nizolius), Mario', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 994, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (995, true, 'Noël, Etienne', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 995, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (996, true, 'Bruodin, Anthony', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 996, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (997, true, 'Noris, Enrico', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 997, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (998, true, 'Nostitz, Johannes von', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 998, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (999, true, 'Angran, Louis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 999, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1000, true, 'Brousse, Jacques', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1000, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1001, true, 'Nuñez Delgadillo, Agustín', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1001, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1002, true, 'Grangier, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1002, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1003, true, 'Gadbled, Christophe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1003, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1004, true, 'Nuño Cabezudo, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1004, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1005, true, 'Obiols, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1005, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1006, true, 'Ochoa, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1006, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1007, true, 'O''Deulin, Francis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1007, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1008, true, 'Pinto, Heitor', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1008, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1009, true, 'António de São Domingos', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1009, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1010, true, 'Vandensteen (a Lapide), Cornelissen (Cornelius)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1010, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1011, true, 'Miguet, Charles', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1011, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1012, true, 'Micard, Michel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1012, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1013, true, 'Molin, Etienne', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1013, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1014, true, 'Millieu, Antoine', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1014, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1015, true, 'Boniel, Claude', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1015, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1016, true, 'Molliasson, Bernardin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1016, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1017, true, 'Oignon, Michel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1017, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1018, true, 'Cochet, Claude', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1018, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1019, true, 'Delacoste, Philippe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1019, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1020, true, 'Gobillon, Nicolas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1020, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1021, true, 'Dubois (Du Bois), Philippe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1021, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1022, true, 'Salmon, Jacques Alexandre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1022, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1023, true, 'Olasso, Sebastián', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1023, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1024, true, 'Oliva, Josep', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1024, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1025, true, 'Oms, Ignasi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1025, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1026, true, 'Fourier, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1026, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1027, true, 'Pacheco, Miguel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1027, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1028, true, 'Núñez, Fernando', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1028, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1029, true, 'González Martínez, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1029, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1030, true, 'Sanz, Manuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1030, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1031, true, 'Tamburini, Michelangelo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1031, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1032, true, 'Quesada, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1032, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1033, true, 'Cazorla, Andrés de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1033, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1034, true, 'Olea, Nicolás de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1034, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1035, true, 'Oliveira, Antonio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1035, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1036, true, 'Olp, Jacinto de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1036, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1037, true, 'Olzina, Diego de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1037, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1038, true, 'Olzina, José de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1038, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1039, true, 'Gasch, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1039, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1040, true, 'Verdel, Claude', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1040, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1041, true, 'Raseiré, Etienne', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1041, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1042, true, 'Dubrueil, Hugues', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1042, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1043, true, 'Volckmar, Henning', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1043, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1044, true, 'Morquin, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1044, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1045, true, 'Frebour, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1045, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1046, true, 'François, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1046, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1047, true, 'Ortiz de Zayas, Ildefonso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1047, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1048, true, 'Bartolucci, Guido', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1048, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1049, true, 'Oña, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1049, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1050, true, 'Castellani, Francesco Maria', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1050, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1051, true, 'Gesualdo, Filippo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1051, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1052, true, 'Mossu, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1052, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1053, true, 'Facciolati, Iacopo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1053, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1054, true, 'Polanus, Amandus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1054, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1055, true, 'Wendelin, Markus Friedrich', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1055, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1056, true, 'Hollmann, Samuel Christian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1056, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1057, true, 'D''Avila, Baltasar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1057, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1058, true, 'Augier, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1058, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1059, true, 'Montmirat, Raymond', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1059, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1060, true, 'Opffermann, Lucas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1060, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1061, true, 'Solenne, Antoine', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1061, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1062, true, 'D''Aliez, Bernard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1062, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1063, true, 'Samblancat, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1063, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1064, true, 'Tapia, Gaspar de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1064, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1065, true, 'Silva y Pacheco, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1065, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1066, true, 'Ibáñez de Aoyz, Vicente Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1066, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1067, true, 'Barrasa, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1067, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1068, true, 'Xavierre, Jerónimo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1068, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1069, true, 'Ponz, Buenaventura', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1069, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1070, true, 'Burchardi, Christoph Martin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1070, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1071, true, 'Ordeñana, Miguel Ignacio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1071, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1072, true, 'Ledesma, Diego de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1072, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1073, true, 'Jessen, Johann von', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1073, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1074, true, 'Manso, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1074, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1075, true, 'Gómez, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1075, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1076, true, 'Jerónimo de Jaén', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1076, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1077, true, 'Fernández de Marmanillo, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1077, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1078, true, 'Ortì, Jacinto', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1078, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1079, true, 'Luis de Flandes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1079, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1080, true, 'Alcazar, Bartolomé', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1080, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1081, true, 'Ocaña, Agustín de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1081, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1082, true, 'Oria, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1082, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1083, true, 'Regnier, Antoine', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1083, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1084, true, 'Soares de Santa Maria, Diogo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1084, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1085, true, 'Ortega y Rojillo, Cristóbal de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1085, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1086, true, 'Suarez d''Aulan, Jean-François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1086, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1087, true, 'Ortiz, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1087, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1088, true, 'Ortiz, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1088, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1089, true, 'Ortiz, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1089, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1090, true, 'Ortiz de Moncada, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1090, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1091, true, 'Ortz, Raymund', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1091, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1092, true, 'Aguilar, Antonio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1092, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1093, true, 'Ayllon, Carlos de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1093, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1094, true, 'Valderrama, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1094, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1095, true, 'Villarán, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1095, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1096, true, 'Moreno, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1096, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1097, true, 'Herrera Escudero, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1097, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1098, true, 'Osiander, Johann Adam', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1098, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1099, true, 'Roldán, Ildefonso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1099, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1100, true, 'Casiani, Antonio Maria', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1100, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1101, true, 'Domínguez de Toledo, Julián', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1101, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1102, true, 'Blázquez, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1102, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1103, true, 'Cuadros (Quadros), Diego de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1103, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1104, true, 'Sancho Granado, Manuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1104, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1105, true, 'Calderón de la Barca, Manuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1105, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1106, true, 'Zarceño, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1106, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1107, true, 'Portillo, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1107, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1108, true, 'Yermo, José de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1108, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1109, true, 'Osório da Fonseca, Jerónimo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1109, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1110, true, 'Beaumont, José Antonio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1110, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1111, true, 'Torres, Isidoro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1111, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1112, true, 'Cordeiro, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1112, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1113, true, 'Pereira, João', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1113, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1114, true, 'Oswald, Albert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1114, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1115, true, 'Porres, Francisco Ignacio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1115, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1116, true, 'Berthelot, Robert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1116, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1117, true, 'Deville, Jean-Claude', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1117, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1118, true, 'Ovando, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1118, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1119, true, 'Aguado, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1119, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1120, true, 'Herrera, Ildefonso de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1120, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1121, true, 'Ovando de Paredes, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1121, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1122, true, 'Oviedo, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1122, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1123, true, 'Oviedo, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1123, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1124, true, 'Vidal, Ginés', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1124, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1125, true, 'González, Domingo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1125, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1126, true, 'Padial, Manuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1126, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1127, true, 'Pictet, Benoît', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1127, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1128, true, 'José del Espíritu Santo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1128, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1129, true, 'Manuel de San Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1129, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1130, true, 'Manuel de Jesús María', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1130, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1131, true, 'Alejandro de la Concepción', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1131, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1132, true, 'Bernardo de la Santísima Trinidad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1132, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1133, true, 'Cossío y Balmaseda, Manuel de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1133, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1134, true, 'Sánchez, Bernabé', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1134, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1135, true, 'Cangas, Antonio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1135, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1136, true, 'Padilla, Antonio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1136, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1137, true, 'Reygadas, Gaspar de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1137, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1138, true, 'Medrano, Joaquín de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1138, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1139, true, 'Miñano, Carlos José de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1139, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1140, true, 'Mújica, Manuel de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1140, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1141, true, 'Torrano, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1141, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1142, true, 'Rubio, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1142, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1143, true, 'Carrière, Accurse', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1143, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1144, true, 'Lambert, Louis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1144, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1145, true, 'Geoffroy, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1145, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1146, true, 'Villeneuve, François de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1146, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1147, true, 'Pagés, Magín', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1147, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1148, true, 'Chabrand, Jean-Baptiste', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1148, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1149, true, 'Hennequin, Jacques', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1149, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1150, true, 'Froger, Georges', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1150, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1151, true, 'Soria, Giovanni Gualberto de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1151, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1152, true, 'Zanardi, Pietro Maria', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1152, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1153, true, 'Valvasori, Girolamo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1153, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1154, true, 'Tapia, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1154, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1155, true, 'Ribera, Antonio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1155, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1156, true, 'Fernández, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1156, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1157, true, 'Heredia, Pedro Miguel de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1157, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1158, true, 'Paiva de Andrade, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1158, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1159, true, 'Palacios, Miguel de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1159, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1160, true, 'Palacios, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1160, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1161, true, 'Palanco, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1161, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1162, true, 'Palantieri, Giovanni Paolo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1162, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1163, true, 'Palencia, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1163, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1164, true, 'Panger, Marin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1164, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1165, true, 'Pardo, Jerónimo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1165, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1166, true, 'Parker, Thomas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1166, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1167, true, 'Quirini, Lauro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1167, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1168, true, 'Parra, Jacinto', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1168, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1169, true, 'Becerra, Martín de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1169, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1170, true, 'Camargo, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1170, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1171, true, 'Bautista, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1171, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1172, true, 'Oliva, Luis de la', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1172, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1173, true, 'Pedrosa, Gregorio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1173, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1174, true, 'Pascual, Felipe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1174, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1175, true, 'Alva y Astorga, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1175, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1176, true, 'Soyer, Léger', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1176, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1177, true, 'Houbereau, André', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1177, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1178, true, 'Le Normand, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1178, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1179, true, 'Le Goupil, Guillaume', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1179, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1180, true, 'Magnien, Charles', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1180, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1181, true, 'Le Brun, Bonaventure', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1181, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1182, true, 'Valdés, Fernando', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1182, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1183, true, 'Moya Coronel, Luis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1183, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1184, true, 'Pasmans, Barthélémy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1184, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1185, true, 'Francisco de la Presentación', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1185, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1186, true, 'Silvestre de la Asunción', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1186, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1187, true, 'Campuzano, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1187, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1188, true, 'Garate, Bernabé de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1188, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1189, true, 'Barcena, Diego de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1189, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1190, true, 'Toledo, Diego de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1190, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1191, true, 'Passerini, Pier Francesco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1191, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1192, true, 'Vallejo, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1192, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1193, true, 'Paniagua, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1193, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1194, true, 'Martín de San José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1194, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1195, true, 'Moreno, Alonso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1195, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1196, true, 'Pastrana, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1196, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1197, true, 'Ochoa y Murga, Buenaventura de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1197, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1198, true, 'Bravo, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1198, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1199, true, 'Gómez de Fuentes, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1199, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1200, true, 'Cáceres, Alonso de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1200, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1201, true, 'Liñores, Benito de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1201, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1202, true, 'Pastor, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1202, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1203, true, 'Francisco de San Elías', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1203, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1204, true, 'Machado, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1204, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1205, true, 'Stévart, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1205, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1206, true, 'Villiers, Célestin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1206, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1207, true, 'Billion, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1207, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1208, true, 'Campmans, Bernard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1208, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1209, true, 'Estrix Plebano, Gaspar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1209, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1210, true, 'Sanders, Antoon', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1210, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1211, true, 'Butkens, Christoph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1211, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1212, true, 'Martínez, Cristóbal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1212, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1213, true, 'Patu, André-Claude', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1213, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1214, true, 'Vitoria, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1214, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1215, true, 'Juan de San Agustín', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1215, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1216, true, 'Calenus, Hendrik', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1216, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1217, true, 'Coene, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1217, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1218, true, 'Nifo, Ferdinando', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1218, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1219, true, 'Van der Bandt, Leander', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1219, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1220, true, 'Baptista Burgos, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1220, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1221, true, 'Carranza, Miguel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1221, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1222, true, 'Ramírez, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1222, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1223, true, 'Jiménez, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1223, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1224, true, 'Pautrier, Joan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1224, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1225, true, 'Ruiz, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1225, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1226, true, 'Muñoz, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1226, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1227, true, 'Palacios, Nicolás de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1227, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1228, true, 'Serna, Alonso de la', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1228, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1229, true, 'Gonzaga, Francesco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1229, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1230, true, 'Beja Perestrelo, Luiz de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1230, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1231, true, 'Cassianus, Nicolaus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1231, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1232, true, 'Michel (Michaelis), Louis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1232, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1233, true, 'Vischer, Bartholomäus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1233, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1234, true, 'Payueta, Gaspar de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1234, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1235, true, 'Peinado, Ignacio Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1235, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1236, true, 'Pellicia, Giuseppe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1236, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1237, true, 'Peñafiel, Ildefonso de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1237, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1238, true, 'Peñafiel, Leonardo de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1238, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1239, true, 'Perera, Benet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1239, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1240, true, 'Torre, Manuel de la', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1240, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1241, true, 'Carrillo, Alonso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1241, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1242, true, 'Del Rio, Martín', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1242, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1243, true, 'Vergara, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1243, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1244, true, 'Pereira, Gómez', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1244, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1245, true, 'Sequeiros y Sotomayor, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1245, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1246, true, 'Pereira, Manuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1246, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1247, true, 'Pérez Valiende, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1247, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1248, true, 'Galarce, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1248, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1249, true, 'Pérez, Carlo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1249, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1250, true, 'Pérez, Domingo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1250, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1251, true, 'Pérez Albión, Luis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1251, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1252, true, 'Pérez de Ayala, Martin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1252, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1253, true, 'Pérez López, Juan Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1253, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1254, true, 'Pérez de Menacho, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1254, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1255, true, 'Pérez de Oliva, Agustín', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1255, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1256, true, 'Pérez de Quiroga, Manuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1256, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1257, true, 'Pérez de la Serna, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1257, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1258, true, 'Perkins, William', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1258, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1259, true, 'Perpinan, Pedro Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1259, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1260, true, 'Perret, Jodok', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1260, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1261, true, 'Persall, John', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1261, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1262, true, 'Petit, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1262, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1263, true, 'Petzelt, Leopold', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1263, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1264, true, 'Peuplus, Ambroise', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1264, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1265, true, 'Peyrer, Rochus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1265, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1266, true, 'Pezier, Matthieu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1266, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1267, true, 'Pfriemb, Joseph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1267, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1268, true, 'Philippe de la Très Sainte Trinité', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1268, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1269, true, 'Picazo, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1269, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1270, true, 'Picard, Charles', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1270, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1271, true, 'Piccart, Michael', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1271, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1272, true, 'Pichón Merinero, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1272, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1273, true, 'Saint-Joseph, Pierre de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1273, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1274, true, 'Pimentel, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1274, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1275, true, 'Dietzinger, Peter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1275, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1276, true, 'Driesch, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1276, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1277, true, 'Newendall, Christian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1277, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1278, true, 'Roth, Andreas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1278, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1279, true, 'Dempflen, Vincenz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1279, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1280, true, 'Pineda, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1280, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1281, true, 'Walenburg, Adrian van', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1281, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1282, true, 'Paulacius, Dominicus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1282, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1283, true, 'Filinger, Placidus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1283, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1284, true, 'Sotomayor, Antonio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1284, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1285, true, 'Girón, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1285, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1286, true, 'Del Cerro, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1286, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1287, true, 'Molina, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1287, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1288, true, 'Piovene, Giovanni', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1288, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1289, true, 'Piny, Alexandre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1289, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1290, true, 'Piscator, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1290, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1291, true, 'Pitard, Maître', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1291, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1292, true, 'Pitigianis, Francesco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1292, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1293, true, 'Plana, Dionísio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1293, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1294, true, 'Plano, Gaspar del', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1294, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1295, true, 'Plantier, Claude', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1295, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1296, true, 'Platel, Jacques', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1296, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1297, true, 'Plowden, Richard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1297, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1298, true, 'Poinsot, João', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1298, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1299, true, 'Poitevin, Gaspard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1299, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1300, true, 'Polanco, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1300, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1301, true, 'Polizzi, Giuseppe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1301, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1302, true, 'Ponce y Baca, Ignacio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1302, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1303, true, 'Ponce de León, Basilio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1303, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1304, true, 'Pons, Joannes Benedictus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1304, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1305, true, 'Pons i Rosselo, Antoni', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1305, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1306, true, 'Posewitz, Johann Heinrich', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1306, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1307, true, 'Pourchot, Edmond', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1307, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1308, true, 'Poza, Juan Bautista', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1308, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1309, true, 'Bielinski, Piotr', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1309, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1310, true, 'Prada, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1310, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1311, true, 'Prado, Manuel de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1311, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1312, true, 'Preston, William', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1312, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1313, true, 'Prévost, Jean Le', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1313, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1314, true, 'Puerto, Miguel del', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1314, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1315, true, 'Puig, Josep', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1315, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1316, true, 'Puigserver, Andrés', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1316, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1317, true, 'Puigserver, Bartolomé', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1317, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1318, true, 'Melanchthon', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1318, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1319, true, 'Puigserver i Mayol, Felipe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1319, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1320, true, 'Punch, John', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1320, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1321, true, 'Rabesano da Montursio, Livio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1321, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1322, true, 'Rada, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1322, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1323, true, 'Ramírez, Vicente', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1323, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1324, true, 'Ramis, Antoni', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1324, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1325, true, 'Ramm, Matthias', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1325, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1326, true, 'Ramoneda, Cristobal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1326, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1327, true, 'Ranahan, David', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1327, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1328, true, 'Rapine, Charles', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1328, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1329, true, 'Rassler, Christoph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1329, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1330, true, 'Rassler, Johann Ev.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1330, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1331, true, 'Recupito, Giulio Cesare', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1331, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1332, true, 'Reeb, Georg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1332, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1333, true, 'Régis, Pierre-Sylvain', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1333, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1334, true, 'Reginald, Antonin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1334, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1335, true, 'Regnault, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1335, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1336, true, 'Reihing, Conrad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1336, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1337, true, 'Reihing, Jakob', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1337, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1338, true, 'Reyna, Sebastian de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1338, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1339, true, 'Rehlinger, Franz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1339, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1340, true, 'Reiffenstuel, Anaklet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1340, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1341, true, 'Rhodes, Georges de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1341, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1342, true, 'Ribadeneira, Gaspar de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1342, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1343, true, 'Ribadeneyra, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1343, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1344, true, 'Ribadeneira, Ignacio Vicente de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1344, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1345, true, 'Ribas, Luis de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1345, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1346, true, 'Ribera, Jerónimo de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1346, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1347, true, 'Ribes, Narcís', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1347, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1348, true, 'Ricci, Giuseppe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1348, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1349, true, 'Richard, Claude', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1349, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1350, true, 'Riché, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1350, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1351, true, 'Rio, Galderico', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1351, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1352, true, 'Rius de Boix, Joan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1352, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1353, true, 'Rivard, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1353, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1354, true, 'Rivas, José de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1354, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1355, true, 'Robert, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1355, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1356, true, 'Rodríguez, Alfonso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1356, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1357, true, 'Rodríguez, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1357, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1358, true, 'Rodríguez Lusitano, Manuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1358, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1359, true, 'Rohault, Jacques', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1359, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1360, true, 'Rolin, Joseph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1360, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1361, true, 'Rolliers, Antoine', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1361, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1362, true, 'Roselli, Salvatore Maria', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1362, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1363, true, 'Rossi da Lugo, Alessandro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1363, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1364, true, 'Rovira, Pere', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1364, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1365, true, 'Royo, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1365, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1366, true, 'Rubio, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1366, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1367, true, 'Ruerk', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1367, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1368, true, 'Ruffat, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1368, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1369, true, 'Rufo, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1369, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1370, true, 'Ruiz, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1370, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1371, true, 'Ruiz, Gabriel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1371, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1372, true, 'Ruiz, Gregorio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1372, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1373, true, 'Ruiz de Montoya, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1373, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1374, true, 'Ruiz de Solano, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1374, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1375, true, 'Rutherford, Samuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1375, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1376, true, 'Sabbatié, G.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1376, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1377, true, 'Sadry, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1377, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1378, true, 'Sáenz de Aguirre, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1378, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1379, true, 'Saint-Bonnet, J.-B. de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1379, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1380, true, 'Saint-Léger, Diego de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1380, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1381, true, 'Sainte-Beuve, Jacques de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1381, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1382, true, 'Salabert, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1382, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1383, true, 'Salablanca, Cristobal de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1383, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1384, true, 'Sala, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1384, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1385, true, 'Salas, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1385, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1386, true, 'Salcedo, Cayetano', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1386, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1387, true, 'Sales, Ascensi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1387, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1388, true, 'Salmanticenses', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1388, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1389, true, 'Sanches, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1389, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1390, true, 'Sánchez, Alonso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1390, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1391, true, 'Sánchez, Tomás', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1391, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1392, true, 'Sánchez de Herrera, Benito', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1392, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1393, true, 'Sánchez de Ribera, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1393, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1394, true, 'Sánchez Sedeño, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1394, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1395, true, 'Sancho Granado, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1395, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1396, true, 'Sancho Granado, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1396, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1397, true, 'Sanders, Francis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1397, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1398, true, 'Sanderson, Robert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1398, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1399, true, 'Sanfftl, Bonifatius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1399, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1400, true, 'Sanmartí, Pere', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1400, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1401, true, 'Sans, Gaspar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1401, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1402, true, 'Sarmentero, Bartolomé', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1402, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1403, true, 'Sarasa, Antonio Alfonso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1403, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1404, true, 'Savarin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1404, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1405, true, 'Savonarola, Girolamo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1405, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1406, true, 'Scaliger, Julius Caesar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1406, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1407, true, 'Schaller, Johannes Damascenus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1407, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1408, true, 'Scherzer, Johann Adam', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1408, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1409, true, 'Schirmbeck, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1409, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1410, true, 'Schöttl, Reginald', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1410, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1411, true, 'Scribon, Jean-Marie', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1411, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1412, true, 'Segovia, Gaspar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1412, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1413, true, 'Segura, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1413, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1414, true, 'Segura, Martín de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1414, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1415, true, 'Sendín Calderón, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1415, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1416, true, 'Senespleda, Raymundo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1416, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1417, true, 'Senftleben, Johann', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1417, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1418, true, 'Seraphinus a Tuirio a', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1418, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1419, true, 'Sergeant, John', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1419, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1420, true, 'Serna, Pedro de la', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1420, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1421, true, 'Servera, Jaume', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1421, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1422, true, 'Sforza, Giovanni Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1422, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1423, true, 'Sghemma, Gaspare', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1423, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (2135, true, 'Leo X', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 21:46:22.985324', 2147, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1424, true, 'Siegesreiter, Johann', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1424, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1425, true, 'Simon, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1425, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1426, true, 'Simon, Johann Georg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1426, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1427, true, 'Sinnich, John', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1427, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1428, true, 'Serina (Sireno), Giulio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1428, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1429, true, 'Slaughter, Edward', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1429, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1430, true, 'Slevogt, Paul', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1430, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1431, true, 'Smiglecki, Marcin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1431, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1432, true, 'Smising, Theodor', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1432, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1433, true, 'Soares, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1433, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1434, true, 'Solerius, Joannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1434, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1435, true, 'Somoza, Mauro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1435, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1436, true, 'Sotelo, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1436, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1437, true, 'Soto y Marne, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1437, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1438, true, 'Sotomaior, Luís de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1438, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1439, true, 'Souchay, Maître', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1439, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1440, true, 'Sosa, Mateo de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1440, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1441, true, 'Sousa e Meneses, Jerónimo de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1441, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1442, true, 'Stahl, Daniel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1442, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1443, true, 'Staj, Benedikt', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1443, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1444, true, 'Stampa, Angelo Giuseppe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1444, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1445, true, 'Stapleton, Thomas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1445, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1446, true, 'Staudenhecht, Friedrich', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1446, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1447, true, 'Stella, Andrea', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1447, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1448, true, 'Stella, Cosma', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1448, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1449, true, 'Stella, Fulgenzio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1449, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1450, true, 'Stengel, Georg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1450, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1451, true, 'Steyaert, M.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1451, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1452, true, 'Stolz, Johann', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1452, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1453, true, 'Strigelius, Victorinus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1453, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1454, true, 'Stroz, Anton', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1454, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1455, true, 'Stuemel, Friedrich', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1455, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1456, true, 'Suárez, Cypriano', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1456, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1457, true, 'Suárez, Sebastián', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1457, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1458, true, 'Sudanus, Claudius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1458, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1459, true, 'Szent-Inany, Martin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1459, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1460, true, 'Tamariz de Taravia, Jerónimo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1460, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1461, true, 'Tamburini, Tommaso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1461, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1462, true, 'Tanner, Adam', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1462, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1463, true, 'Tapia, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1463, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1464, true, 'Tapper, Ruard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1464, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1465, true, 'Tartaret, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1465, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1466, true, 'Taurellus, Nikolaus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1466, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1467, true, 'Taylor, Jeremy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1467, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1468, true, 'Telles, Baltazar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1468, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1469, true, 'Téllez, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1469, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1470, true, 'Téllez, Gregorio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1470, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1471, true, 'Tellin, Ignatius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1471, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1472, true, 'Temmerman, Joseph de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1472, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1473, true, 'Terrill, Anthony', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1473, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1474, true, 'Tesauro, Emanuele', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1474, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1475, true, 'Tessaneck, Franz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1475, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1476, true, 'Tessaneck, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1476, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1477, true, 'Teuli, Bonaventura', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1477, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1478, true, 'Thaner, Johann', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1478, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1479, true, 'Thierry, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1479, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1480, true, 'Thió, Jaume', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1480, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1481, true, 'Thomasius, Jakob', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1481, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1482, true, 'Thomassin, Louis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1482, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1483, true, 'Thümming, Ludwig Philipp', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1483, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1484, true, 'Thuronius, Andreas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1484, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1485, true, 'Timpler, Clemens', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1485, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1486, true, 'Titone, Angelo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1486, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1487, true, 'Toledano, Alejandro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1487, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1488, true, 'Torres, Bartolomé', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1488, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1489, true, 'Torres, Luis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1489, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1490, true, 'Torres, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1490, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1491, true, 'Tosca, Tomás Vicente', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1491, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1492, true, 'Tournély, Honoré', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1492, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1493, true, 'Truchsess, Eusebius Graf von', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1493, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1494, true, 'Turrettini, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1494, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1495, true, 'Tyrie, James', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1495, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1496, true, 'Tylkowski, Wojciech', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1496, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1497, true, 'Twisse, William', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1497, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1498, true, 'Wadding, Peter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1498, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1499, true, 'Waim, Gervasius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1499, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1500, true, 'Wakeman, Joseph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1500, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1501, true, 'Walaeus, Antonius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1501, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1502, true, 'Walker, Obadiah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1502, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1503, true, 'Wallis, John', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1503, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1504, true, 'Wallis, Johannes Robertus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1504, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1505, true, 'Walt, Johann', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1505, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1506, true, 'Watson, Michael', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1506, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1507, true, 'Weber, Theodor', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1507, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1508, true, 'Weigel, Erhard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1508, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1509, true, 'Weinzierlin, Johann Andreas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1509, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1510, true, 'Wex, Jakob', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1510, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1511, true, 'White, Thomas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1511, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1512, true, 'Wigand, Martin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1512, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1513, true, 'Wiggers, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1513, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1514, true, 'Wildenberg, Hieronymus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1514, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1515, true, 'Williams, Francis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1515, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1516, true, 'Winkler, Angelus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1516, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1517, true, 'Wissingh, Anton', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1517, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1518, true, 'Witte, Michael de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1518, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1519, true, 'Wolff, Friedrich', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1519, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1520, true, 'Wolff, Medardus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1520, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1521, true, 'Wysing, Nikolaus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1521, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1522, true, 'Alexandre, Noël', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1522, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1523, true, 'Vries, Peter De', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1523, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1524, true, 'Baron, Vincent', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1524, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1525, true, 'Blundus, Franciscus Antonius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1525, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1526, true, 'Brachet, Maurice', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1526, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1527, true, 'Carranza de Miranda, Bartolomé', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1527, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1528, true, 'Dufour, Louis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1528, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1529, true, 'Ferrari, G.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1529, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1530, true, 'Grandi, Bonifazio Maria', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1530, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1531, true, 'Hidalgo, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1531, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1532, true, 'Komanus, A.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1532, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1533, true, 'Osorio y Bernaldo de Quirós, Salvador', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1533, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1534, true, 'Pérez, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1534, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1535, true, 'Pérez Pastor, José Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1535, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1536, true, 'Piccolomini, Francesco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1536, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1537, true, 'Soto, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1537, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1538, true, 'Nifo, Agostino', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1538, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1539, true, 'Oreggi, Agostino', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1539, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1540, true, 'Paz, Nicolás de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1540, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1541, true, 'Casati, Gio. Paolo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1541, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1542, true, 'Pontich, Miquel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1542, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1543, true, 'Ros, Antoni', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1543, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1544, true, 'Holiart, Joan Rafael', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1544, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1545, true, 'Burell, Agustí', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1545, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1546, true, 'Rodríguez, Bernardino', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1546, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1547, true, 'Domínguez, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1547, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1548, true, 'Sturm, Johann Christoph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1548, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1549, true, 'Pontanus, Jacobus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1549, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1550, true, 'Pasqualigo, Zaccaria', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1550, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1551, true, 'Patrizi, Francesco - da Cherso', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1551, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1552, true, 'Duodo, Pietro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1552, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1553, true, 'Pazmany', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1553, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1554, true, 'Peña, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1554, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1555, true, 'Molina, Baltasar de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1555, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1556, true, 'Miranda, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1556, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1557, true, 'Vorstius, Conrad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1557, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1558, true, 'Medina, Florentino de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1558, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1559, true, 'Pendasio, Federico', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1559, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1560, true, 'Medina, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1560, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1561, true, 'Medina Rincón, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1561, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1562, true, 'Medrano, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1562, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1563, true, 'Meichelbeck, Carl', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1563, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1564, true, 'Meisner, Balthasar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1564, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1565, true, 'Meister, Johannes Gottlieb', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1565, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1566, true, 'Melo, Gaspar de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1566, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1567, true, 'Mencholini, Luca', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1567, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1568, true, 'Mendo, Andrés', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1568, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1569, true, 'Mendoza, Luis de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1569, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1570, true, 'Pennotti, Gabriele', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1570, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1571, true, 'Menestrier, Claude-François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1571, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1572, true, 'Mercado, Tomás de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1572, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1573, true, 'Merinero López, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1573, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1574, true, 'Metzger, Wolfgang', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1574, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1575, true, 'Méron, Claude', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1575, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1576, true, 'Mezger, Franz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1576, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1577, true, 'Mezger, Joseph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1577, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1578, true, 'Mezger, Paul', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1578, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1579, true, 'Micraelius, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1579, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1580, true, 'Miguel, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1580, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1581, true, 'Pereira, Benito', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1581, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1582, true, 'Mini, Bonaventura', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1582, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1583, true, 'Milhet, Arnaud', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1583, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1584, true, 'Mira, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1584, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1585, true, 'Mitternachts, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1585, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1586, true, 'Mlaven, Andreas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1586, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1587, true, 'Mlodzianowski, Tomasz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1587, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1588, true, 'Mocquet, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1588, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1589, true, 'Moczkowicz, Raphael', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1589, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1590, true, 'Mogilnicki, Joseph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1590, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1591, true, 'Petau, Denis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1591, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1592, true, 'Montagnolo, Giovanni Domenico', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1592, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1593, true, 'Machin de Aquena, Ambrogio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1593, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1594, true, 'Agostini, Giuseppe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1594, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1595, true, 'Pomponazzi, Pietro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1595, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1596, true, 'Possevino, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1596, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1597, true, 'Pozzobonelli, Domenico Maria', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1597, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1598, true, 'Maestlin, Michele', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1598, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1599, true, 'Dupuy, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1599, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1600, true, 'Malderen, Jan van', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1600, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1601, true, 'Claire, Jean de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1601, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1602, true, 'Merchier, Guillaume', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1602, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1603, true, 'Medici, Girolamo de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1603, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1604, true, 'Alagona, Pietro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1604, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1605, true, 'Ituren, Tomás de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1605, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1606, true, 'Carbone, Ludovico', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1606, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1607, true, 'Capulli, Pietro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1607, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1608, true, 'Pesanzio, Alessandro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1608, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1609, true, 'Palombo di Ascanio, Marco Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1609, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1610, true, 'Bermingham, Francis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1610, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1611, true, 'Flavius, Melchior', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1611, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1612, true, 'Rochmanius, Andreas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1612, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1613, true, 'Ruggeri, Giacinto de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1613, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1614, true, 'Nise, Nicolaus de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1614, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1615, true, 'Andrea della Croce', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1615, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1616, true, 'Koptik, Odo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1616, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1617, true, 'Mosmiller, Floridus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1617, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1618, true, 'Berni, Juan Bautista', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1618, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1619, true, 'Sannig, Bernardus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1619, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1620, true, 'Brasavola, Ireneo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1620, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1621, true, 'Peri, Giacomo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1621, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1622, true, 'Bekker, Balthasar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1622, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1623, true, 'De Vries, Gerard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1623, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1624, true, 'Milchsack, Johann Joel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1624, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1625, true, 'Kalher, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1625, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1626, true, 'Samuel de Lublino', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1626, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1627, true, 'Zouch, Richard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1627, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1628, true, 'Raynaud, Théophile', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1628, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1629, true, 'Schopen, Wolter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1629, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1630, true, 'König, Clemens', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1630, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1631, true, 'Mauritius - a Berona', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1631, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1632, true, 'Bignamini, Carlo Giuseppe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1632, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1633, true, 'Riccardi, Niccolò', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1633, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1634, true, 'Puteanus, Erycius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1634, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1635, true, 'Derrez, Nicolas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1635, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1636, true, 'Gertman, Matthias', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1636, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1637, true, 'Cerf, Henri de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1637, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1638, true, 'Marchand, Hugues Noël', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1638, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1639, true, 'Gaud, Charles', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1639, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1640, true, 'Vial, Elie', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1640, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1641, true, 'Lombard, Paul', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1641, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1642, true, 'Ricci, Michelangelo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1642, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1643, true, 'Riccioli, Giovanni Battista', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1643, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1644, true, 'Colveniers, Georges', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1644, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1645, true, 'Gambier, Antoine', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1645, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1646, true, 'Ridolfi, Niccolò', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1646, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1647, true, 'Daniel de Saint-Joseph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1647, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1648, true, 'Séguy, Antoine', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1648, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1649, true, 'Randour, Valentin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1649, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1650, true, 'Martin, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1650, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1651, true, 'Damen, Hermann', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1651, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1652, true, 'Bouxhon, Nicolas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1652, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1653, true, 'Sabran, Louis de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1653, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1654, true, 'Loncin, Wauthier de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1654, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1655, true, 'Dumas, Hilaire', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1655, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1656, true, 'Brangier, Joseph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1656, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1657, true, 'Royer, Alexandre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1657, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1658, true, 'Reaux, Jean-Baptiste de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1658, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1659, true, 'Grangé, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1659, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1660, true, 'Barnier, Jacques', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1660, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1661, true, 'Rimbaud, Jacques', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1661, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1662, true, 'Benoît du Pertuis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1662, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1663, true, 'Fourmestraux, François de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1663, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1664, true, 'Aurnhammer, Dominikus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1664, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1665, true, 'Morstein, Ratholdus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1665, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1666, true, 'Denis, Martin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1666, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1667, true, 'Lannoy, Anselme de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1667, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1668, true, 'Cocquelin, Nicolas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1668, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1669, true, 'Riva, Raffaele', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1669, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1670, true, 'Feliciano, Giovanni Bernardo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1670, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1671, true, 'Cauvinus, Paulus Maria', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1671, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1672, true, 'Ferré, Vicent', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1672, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1673, true, 'Knippenberg, Sebastian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1673, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1674, true, 'Lince, Domingo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1674, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1675, true, 'Ricci, Paolo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1675, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1676, true, 'Sturm, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1676, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1677, true, 'Rocco, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1677, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1678, true, 'Soldo, Mauro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1678, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1679, true, 'Santoro, Giulio Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1679, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1680, true, 'Genua, Marcantonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1680, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1681, true, 'Piccolomini, Francesco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1681, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1682, true, 'Porzio, Simone', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1682, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1683, true, 'Mercenario, Arcangelo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1683, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1684, true, 'Boccadiferro, Ludovico', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1684, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1685, true, 'Lefèvre d''Etaples, Jacques', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1685, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1686, true, 'Lavinheta, Bernardo de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1686, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1687, true, 'Golius, Théophile', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1687, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1688, true, 'Heiland, Samuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1688, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1689, true, 'Zwinger, Theodor', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1689, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1690, true, 'Titelmans, Frans', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1690, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1691, true, 'Carrasco, Miguel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1691, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1692, true, 'Antonio de la Madre de Dios', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1692, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1693, true, 'Domingo de Santa Teresa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1693, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1694, true, 'Borrhaus, Martin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1694, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1695, true, 'Kahl, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1695, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1696, true, 'Tapolcsani, Laurent', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1696, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1697, true, 'Copperus, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1697, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1698, true, 'Preston, John', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1698, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1699, true, 'Galland, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1699, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1700, true, 'García de los Ríos, Eusebio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1700, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1701, true, 'Rodríguez, Bernardo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1701, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1702, true, 'Vicomercato, Francesco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1702, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1703, true, 'Martino, Spirito', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1703, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1704, true, 'Turnèbe, Adrien', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1704, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1705, true, 'Bukentop, Henri de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1705, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1706, true, 'Van Houten, André', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1706, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1707, true, 'Grouwels, Matthias', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1707, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1708, true, 'Vandenbosch, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1708, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1709, true, 'Erath, Augustinus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1709, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1710, true, 'Aler, Paul', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1710, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1711, true, 'Struggl, Markus Maria', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1711, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1712, true, 'Gassmayr, Ferdinand Maria', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1712, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1713, true, 'Markel, Amideus Maria', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1713, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1714, true, 'Ermblich, Berthold Maria', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1714, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1715, true, 'Crellius, Fortunatus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1715, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1716, true, 'Andreae, Jacob', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1716, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1717, true, 'Brenz, Johann', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1717, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1718, true, 'Ciaffoni, Bernardino', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1718, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1719, true, 'Scheiner, Christoph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1719, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1720, true, 'Gufl, Veremundus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1720, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1721, true, 'Gremner, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1721, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1722, true, 'Friderich, Philipp', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1722, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1723, true, 'Grande, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1723, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1724, true, 'Mateos y Romero, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1724, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1725, true, 'Vargas, Crisostomo de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1725, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1726, true, 'Zanchius, Hieronymus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1726, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1727, true, 'Quiñones, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1727, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1728, true, 'Aldalur, José Antonio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1728, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1729, true, 'Enciso y Tejada, Manuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1729, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1730, true, 'Grande, Cristóforo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1730, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1731, true, 'Camacho Dávila, Joaquín', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1731, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1732, true, 'Céspedes, Anselmo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1732, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1733, true, 'Rodríguez Malo, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1733, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1734, true, 'Roldán, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1734, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1735, true, 'Sologuren, Miguel de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1735, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1736, true, 'Vidarte, Agustín José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1736, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1737, true, 'Varela, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1737, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1738, true, 'De la Vera, Mariano', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1738, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1739, true, 'Millán de Zerezeda, Emiliano', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1739, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1740, true, 'Oronsoro, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1740, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1741, true, 'Del Camino, Manuel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1741, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1742, true, 'Mancilla, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1742, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1743, true, 'Perlín, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1743, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1744, true, 'Richard, Désiré', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1744, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1745, true, 'Palma, Luis de la', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1745, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1746, true, 'Oñate, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1746, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1747, true, 'Valero, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1747, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1748, true, 'Andreu, Joan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1748, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1749, true, 'Sá, Manuel de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1749, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1750, true, 'Sánchez, Rafael', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1750, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1751, true, 'De la Plaza, Jacinto', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1751, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1752, true, 'Martínez Paralejos, Miguel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1752, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1753, true, 'Paredes, Tomás de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1753, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1754, true, 'Mejino, Pedro', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1754, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1755, true, 'Sarria, Tomás de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1755, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1756, true, 'Frit, Johannes Philipp', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1756, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1757, true, 'Francisco de San Lorenzo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1757, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1758, true, 'Marcos de San Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1758, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1759, true, 'Manuel de San Pascual', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1759, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1760, true, 'Juan de la Natividad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1760, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1761, true, 'Carlos de la Concepción', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1761, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1762, true, 'Gregorio de San José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1762, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1763, true, 'Miguel de San Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1763, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1764, true, 'Francisco de San Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1764, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1765, true, 'Ramírez Blanco, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1765, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1766, true, 'Jiménez de Mejorada, Jacinto', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1766, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1767, true, 'Gutiérrez, Agustín', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1767, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1768, true, 'Ayala, Pedro de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1768, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1769, true, 'José de San Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1769, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1770, true, 'José de los Santos', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1770, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1771, true, 'Matías de Jesús María', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1771, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1772, true, 'Ildefonso de Santo Tomás', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1772, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1773, true, 'Pedro de Santo Tomás', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1773, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1774, true, 'Nicolás Cavero, José', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1774, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1775, true, 'Collegium Ripense', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1775, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1776, true, 'De Coninck, Peter Damasius', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1776, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1777, true, 'Du Perne, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1777, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1778, true, 'Orbea, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1778, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1779, true, 'Robles, Sebastián de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1779, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1780, true, 'Paravicino, Ortensio Felix', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1780, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1781, true, 'Biscioni, Andrea', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1781, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1782, true, 'Cordoniu, Antoni', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1782, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1783, true, 'Finestres i Monsalvo, Josep', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1783, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1784, true, 'Musoles, Felipe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1784, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1785, true, 'Couto, Sebastião do', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1785, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1786, true, 'Barreto, Gregorio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1786, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1787, true, 'Bonaventure de Langres', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1787, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1788, true, 'Laurent de Dijon', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1788, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1789, true, 'Furtado, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1789, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1790, true, 'Contreiras, Diogo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1790, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1791, true, 'Beleago, Melchior', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1791, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1792, true, 'Breydel, Nicolaus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1792, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1793, true, 'Danes, Pierre-Hilaire', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1793, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1794, true, 'Dingeon, Laurent', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1794, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1795, true, 'Gamiz, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1795, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1796, true, 'Ortiz, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1796, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1797, true, 'Palazol, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1797, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1798, true, 'Zingnis, Paul', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1798, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1799, true, 'Spina, Bartolomeo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1799, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1800, true, 'Baronio, Cesare', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1800, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1801, true, 'Zaragoza de Heredia, Pedro Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1801, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1802, true, 'Zúñiga, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1802, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1803, true, 'Zurita, Fernando', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1803, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1804, true, 'Suárez, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1804, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1805, true, 'Telesio, Bernardino', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1805, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1806, true, 'Basso, Sebastian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1806, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1807, true, 'Lens, Jean de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1807, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1808, true, 'Conry, Florence', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1808, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1809, true, 'Toledo, Francisco de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1809, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1810, true, 'Clancy, Bernardine', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1810, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1811, true, 'Tolomei, Giovanni Battista', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1811, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1812, true, 'Tomassi, Giovanni Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1812, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1813, true, 'Trombetta, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1813, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1814, true, 'Mousnier, Pierre', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1814, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1815, true, 'Paludanus, Joannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1815, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1816, true, 'Paludanus, Michaël', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1816, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1817, true, 'Musart, Carolus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1817, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1818, true, 'De Cleyn, François', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1818, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1819, true, 'Wadding, Luke', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1819, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1820, true, 'Schmutz, Dionys', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1820, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1821, true, 'Vanini, Giulio Cesare', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1821, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1822, true, 'Lestocq, Nicolas de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1822, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1823, true, 'Le Tellier, Jean', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1823, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1824, true, 'Letourneux, Nicolas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1824, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1825, true, 'Levermé, Gilbert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1825, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1826, true, 'Lièvremont, Gabriel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1826, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1827, true, 'Ivul, Gabriel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1827, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1828, true, 'Vernia, Nicoletto', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1828, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1829, true, 'Vitelleschi, Muzio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1829, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1830, true, 'Vatier, Antoine', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1830, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1831, true, 'Munareno, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1831, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1832, true, 'Musson, John', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1832, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1833, true, 'Muro, Salvador', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1833, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1834, true, 'Muñoz, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1834, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1835, true, 'Dedelley, Jakob', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1835, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1836, true, 'Lezana, Juan Bautista de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1836, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1837, true, 'Brennan, Patrick', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1837, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1838, true, 'Daly, Thadaeus', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1838, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1839, true, 'Moscatelli, Giordano', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1839, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1840, true, 'Murcia de la Llana, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1840, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1841, true, 'Mundbrot, Walter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1841, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1842, true, 'Hunger, Albert', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1842, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1843, true, 'Becanus, Martin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1843, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1844, true, 'Steborius, Christoph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1844, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1845, true, 'Brandis, Christoph', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1845, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1846, true, 'Kern, Georg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1846, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1847, true, 'White, Stephen', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1847, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1848, true, 'Vitus, Stephan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1848, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1849, true, 'Klumpius, Johannes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1849, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1850, true, 'Mayle, Matthias', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1850, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1851, true, 'Anselmus a Buxheim', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1851, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1852, true, 'Bernardi della Mirandola, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1852, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1853, true, 'Pallavicino, Niccolò Maria', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1853, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1854, true, 'Aresi, Paolo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1854, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1855, true, 'Strada, Gregorio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1855, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1856, true, 'Muniesa, Tomás', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1856, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1857, true, 'Nebridius a Mündelheim', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1857, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1858, true, 'Moya, Matías de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1858, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1859, true, 'Morsack, Joachim', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1859, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1860, true, 'Wadding, Luke', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1860, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1861, true, 'Moreno, Juan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1861, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1862, true, 'Morell, Josep', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1862, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1863, true, 'Morejón, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1863, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1864, true, 'Morejón, Diego', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1864, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1865, true, 'Morawski, Jan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1865, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1866, true, 'Morando, Giovanni', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1866, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1867, true, 'Morales, Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1867, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1868, true, 'Monzón, Bartolomé', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1868, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1869, true, 'Montoro, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1869, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1870, true, 'Monteiro, Inácio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1870, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1871, true, 'Monteiro, Francisco', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1871, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1872, true, 'Montllor, Juan Bautista', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1872, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1873, true, 'Montesinos, Luis de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1873, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1874, true, 'Montesinos, Antonio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1874, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1875, true, 'Montemayor, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1875, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1876, true, 'Montemayor, Prudencio de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1876, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1877, true, 'Montmorency, Florent de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1877, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1878, true, 'Morel, Cyrille', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1878, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type, type_nom) VALUES (1879, true, 'Montalvo, Juan de', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-19 18:15:27.152478', 1879, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, d