--
-- PostgreSQL database dump
--

-- Dumped from database version 9.3.1
-- Dumped by pg_dump version 9.3.1
-- Started on 2013-11-05 16:29:11 CET

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 9 (class 2615 OID 19472)
-- Name: tables_uc; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA tables_uc;


SET search_path = tables_uc, pg_catalog;

--
-- TOC entry 228 (class 1255 OID 19473)
-- Name: create_info_date_concatenated_date(); Type: FUNCTION; Schema: tables_uc; Owner: -
--

CREATE FUNCTION create_info_date_concatenated_date() RETURNS trigger
    LANGUAGE plpgsql
    AS $$

DECLARE variable_date text;

BEGIN

IF NEW.annee IS NOT NULL AND NEW.mois IS NULL THEN
	IF NEW.annee < 0 THEN
		variable_date := substring(to_char(NEW.annee, '0000')from 1 for 5);
	ELSE
		variable_date := substring(to_char(NEW.annee, '0000')from 2 for 5);
	END IF;
END IF;

IF NEW.annee IS NOT NULL AND NEW.mois IS NOT NULL AND NEW.jour IS NULL THEN
	IF NEW.annee < 0 THEN
		variable_date := substring(to_char(NEW.annee, '0000')from 1 for 5)||'-'||substring(to_char(NEW.mois, '00') from 2 for 3);	
	ELSE
		variable_date := substring(to_char(NEW.annee, '0000')from 2 for 5)||'-'||substring(to_char(NEW.mois, '00') from 2 for 3);
	END IF;
END IF;

IF NEW.annee IS NOT NULL AND NEW.mois IS NOT NULL AND NEW.jour IS NOT NULL THEN
	IF NEW.annee < 0 THEN
		variable_date := substring(to_char(NEW.annee, '0000')from 1 for 5)||'-'||substring(to_char(NEW.mois, '00') from 2 for 3)||'-'||substring(to_char(NEW.jour, '00') from 2 for 3);
	ELSE
		variable_date := substring(to_char(NEW.annee, '0000')from 2 for 5)||'-'||substring(to_char(NEW.mois, '00') from 2 for 3)||'-'||substring(to_char(NEW.jour, '00') from 2 for 3);
	END IF;
END IF;


IF NEW.annee IS NULL
THEN variable_date := NULL;
END IF;


IF  NEW.certitude_date = 1
THEN variable_date := variable_date;
ELSEIF NEW.certitude_date = 2
THEN variable_date := variable_date || ' r';

ELSEIF NEW.certitude_date = 3
THEN variable_date := variable_date || ' p';
END IF;




NEW.date_recomposee =  variable_date;

RETURN NEW;

END;
$$;


SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 195 (class 1259 OID 19474)
-- Name: associer_unite_connaissance_objet; Type: TABLE; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE TABLE associer_unite_connaissance_objet (
    pk_associer_unite_connaissance_objet integer NOT NULL,
    fk_unite_connaissance integer,
    fk_objet integer,
    fk_type_association_objet integer,
    notes text,
    descriptif text,
    reference_precise text
);


--
-- TOC entry 2386 (class 0 OID 0)
-- Dependencies: 195
-- Name: TABLE associer_unite_connaissance_objet; Type: COMMENT; Schema: tables_uc; Owner: -
--

COMMENT ON TABLE associer_unite_connaissance_objet IS 'Cette table fait la jointure entre les unités de connaissance et les objets qui permettent de classer, documenter, etc. les unités de connaissance';


--
-- TOC entry 196 (class 1259 OID 19480)
-- Name: associer_unite_connaissance_o_pk_associer_unite_connaissanc_seq; Type: SEQUENCE; Schema: tables_uc; Owner: -
--

CREATE SEQUENCE associer_unite_connaissance_o_pk_associer_unite_connaissanc_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2387 (class 0 OID 0)
-- Dependencies: 196
-- Name: associer_unite_connaissance_o_pk_associer_unite_connaissanc_seq; Type: SEQUENCE OWNED BY; Schema: tables_uc; Owner: -
--

ALTER SEQUENCE associer_unite_connaissance_o_pk_associer_unite_connaissanc_seq OWNED BY associer_unite_connaissance_objet.pk_associer_unite_connaissance_objet;


--
-- TOC entry 197 (class 1259 OID 19482)
-- Name: date_unite_connaissance; Type: TABLE; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE TABLE date_unite_connaissance (
    pk_date_unite_connaissance integer NOT NULL,
    fk_type_date integer,
    libelle_selon_source text,
    annee integer,
    mois integer,
    jour integer,
    date_recomposee character varying(20),
    certitude_date smallint,
    qualificatif_date smallint,
    marge_date integer,
    heures integer,
    minutes integer,
    secondes integer,
    descriptif text,
    notes text,
    fk_unite_connaissance integer
);


--
-- TOC entry 198 (class 1259 OID 19488)
-- Name: date_unite_connaissance_pk_date_unite_connaissance_seq; Type: SEQUENCE; Schema: tables_uc; Owner: -
--

CREATE SEQUENCE date_unite_connaissance_pk_date_unite_connaissance_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2388 (class 0 OID 0)
-- Dependencies: 198
-- Name: date_unite_connaissance_pk_date_unite_connaissance_seq; Type: SEQUENCE OWNED BY; Schema: tables_uc; Owner: -
--

ALTER SEQUENCE date_unite_connaissance_pk_date_unite_connaissance_seq OWNED BY date_unite_connaissance.pk_date_unite_connaissance;


--
-- TOC entry 199 (class 1259 OID 19490)
-- Name: propriete_texte; Type: TABLE; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE TABLE propriete_texte (
    pk_propriete_texte integer NOT NULL,
    texte text,
    descriptif text,
    notes text,
    code_langue character(3),
    fk_unite_connaissance integer,
    fk_type_propriete integer
);


--
-- TOC entry 200 (class 1259 OID 19496)
-- Name: propriete_texte_pk_propriete_texte_seq; Type: SEQUENCE; Schema: tables_uc; Owner: -
--

CREATE SEQUENCE propriete_texte_pk_propriete_texte_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2389 (class 0 OID 0)
-- Dependencies: 200
-- Name: propriete_texte_pk_propriete_texte_seq; Type: SEQUENCE OWNED BY; Schema: tables_uc; Owner: -
--

ALTER SEQUENCE propriete_texte_pk_propriete_texte_seq OWNED BY propriete_texte.pk_propriete_texte;


--
-- TOC entry 201 (class 1259 OID 19498)
-- Name: role; Type: TABLE; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE TABLE role (
    pk_role integer NOT NULL,
    libelle_selon_source text,
    valeur_numerique numeric,
    si_sujet_uc boolean,
    descriptif text,
    notes text,
    date_creation timestamp without time zone,
    fk_unite_connaissance integer,
    fk_objet_associe integer,
    fk_unite_connaissance_associee integer,
    fk_unite_mesure integer,
    fk_role_associe integer,
    notes_role_associe text,
    fk_type_role integer
);


--
-- TOC entry 202 (class 1259 OID 19504)
-- Name: role_pk_role_seq; Type: SEQUENCE; Schema: tables_uc; Owner: -
--

CREATE SEQUENCE role_pk_role_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2390 (class 0 OID 0)
-- Dependencies: 202
-- Name: role_pk_role_seq; Type: SEQUENCE OWNED BY; Schema: tables_uc; Owner: -
--

ALTER SEQUENCE role_pk_role_seq OWNED BY role.pk_role;


--
-- TOC entry 203 (class 1259 OID 19506)
-- Name: sourcer; Type: TABLE; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE TABLE sourcer (
    pk_sourcer integer NOT NULL,
    reference_precise text,
    descriptif text,
    notes text,
    fk_unite_connaissance integer,
    fk_objet integer
);


--
-- TOC entry 204 (class 1259 OID 19512)
-- Name: sourcer_pk_sourcer_seq; Type: SEQUENCE; Schema: tables_uc; Owner: -
--

CREATE SEQUENCE sourcer_pk_sourcer_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2391 (class 0 OID 0)
-- Dependencies: 204
-- Name: sourcer_pk_sourcer_seq; Type: SEQUENCE OWNED BY; Schema: tables_uc; Owner: -
--

ALTER SEQUENCE sourcer_pk_sourcer_seq OWNED BY sourcer.pk_sourcer;


--
-- TOC entry 205 (class 1259 OID 19514)
-- Name: unite_connaissance; Type: TABLE; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE TABLE unite_connaissance (
    pk_unite_connaissance integer NOT NULL,
    descriptif text,
    notes text,
    date_creation timestamp without time zone,
    fk_type_unite_connaissance integer
);


--
-- TOC entry 206 (class 1259 OID 19520)
-- Name: unite_connaissance_pk_unite_connaissance_seq; Type: SEQUENCE; Schema: tables_uc; Owner: -
--

CREATE SEQUENCE unite_connaissance_pk_unite_connaissance_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2392 (class 0 OID 0)
-- Dependencies: 206
-- Name: unite_connaissance_pk_unite_connaissance_seq; Type: SEQUENCE OWNED BY; Schema: tables_uc; Owner: -
--

ALTER SEQUENCE unite_connaissance_pk_unite_connaissance_seq OWNED BY unite_connaissance.pk_unite_connaissance;


--
-- TOC entry 207 (class 1259 OID 19522)
-- Name: v_libelle_uc; Type: VIEW; Schema: tables_uc; Owner: -
--

CREATE VIEW v_libelle_uc AS
 SELECT t1.pk_unite_connaissance, 
        CASE
            WHEN ((t1.descriptif IS NULL) OR (t1.descriptif = ''::text)) THEN t2.nom
            ELSE t1.descriptif
        END AS libelle_uc, 
    t1.fk_type_unite_connaissance
   FROM (unite_connaissance t1
   JOIN tables_types.type_unite_connaissance t2 ON ((t2.pk_type_unite_connaissance = t1.fk_type_unite_connaissance)));


--
-- TOC entry 208 (class 1259 OID 19526)
-- Name: v_associations_uc_objets; Type: VIEW; Schema: tables_uc; Owner: -
--

CREATE VIEW v_associations_uc_objets AS
 SELECT t1.pk_associer_unite_connaissance_objet, 
    t1.fk_unite_connaissance, 
    t1.fk_objet, 
    t1.fk_type_association_objet AS fk_type_association, 
    t1.reference_precise, 
    t1.descriptif, 
    t1.notes, 
        CASE
            WHEN (t1.fk_type_association_objet = 84) THEN 'UC classée par '::text
            WHEN (t1.fk_type_association_objet = 85) THEN 'UC documentée par '::text
            ELSE NULL::text
        END AS type_association, 
    t2.nom AS nom_objet, 
    t4.nom AS sous_type_objet, 
    t5.libelle_uc
   FROM ((((associer_unite_connaissance_objet t1
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t2 ON ((t2.fk_objet = t1.fk_objet)))
   LEFT JOIN tables_objet.objet t3 ON ((t3.pk_objet = t1.fk_objet)))
   LEFT JOIN tables_types.parametre t4 ON ((t4.pk_parametre = t3.fk_sous_type_objet)))
   LEFT JOIN v_libelle_uc t5 ON ((t5.pk_unite_connaissance = t1.fk_unite_connaissance)));


--
-- TOC entry 209 (class 1259 OID 19531)
-- Name: v_autres_objets_uc; Type: VIEW; Schema: tables_uc; Owner: -
--

CREATE VIEW v_autres_objets_uc AS
 SELECT t1.fk_unite_connaissance, 
    array_to_string(ARRAY( SELECT unnest(array_agg(
                CASE
                    WHEN (t3.nom IS NOT NULL) THEN t3.nom
                    ELSE t2.libelle_uc
                END)) AS unnest
          ORDER BY unnest(array_agg(
                CASE
                    WHEN (t3.nom IS NOT NULL) THEN t3.nom
                    ELSE t2.libelle_uc
                END))), ', '::text) AS autres_objets_uc
   FROM ((role t1
   LEFT JOIN v_libelle_uc t2 ON ((t2.pk_unite_connaissance = t1.fk_unite_connaissance_associee)))
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t3 ON ((t3.fk_objet = t1.fk_objet_associe)))
  WHERE (t1.si_sujet_uc IS NOT TRUE)
  GROUP BY t1.fk_unite_connaissance;


--
-- TOC entry 210 (class 1259 OID 19536)
-- Name: v_date_standard_uc; Type: VIEW; Schema: tables_uc; Owner: -
--

CREATE VIEW v_date_standard_uc AS
 SELECT date_unite_connaissance.fk_unite_connaissance, 
    (ARRAY( SELECT unnest(array_agg(date_unite_connaissance.date_recomposee)) AS unnest
          ORDER BY unnest(array_agg(date_unite_connaissance.fk_type_date))))[1] AS date_standard
   FROM date_unite_connaissance
  GROUP BY date_unite_connaissance.fk_unite_connaissance;


--
-- TOC entry 211 (class 1259 OID 19540)
-- Name: v_sujet_uc; Type: VIEW; Schema: tables_uc; Owner: -
--

CREATE VIEW v_sujet_uc AS
 SELECT t1.fk_unite_connaissance, 
    array_to_string(ARRAY( SELECT unnest(array_agg(
                CASE
                    WHEN (t3.nom IS NOT NULL) THEN t3.nom
                    ELSE t2.libelle_uc
                END)) AS unnest
          ORDER BY unnest(array_agg(
                CASE
                    WHEN (t3.nom IS NOT NULL) THEN t3.nom
                    ELSE t2.libelle_uc
                END))), ', '::text) AS sujet_uc
   FROM ((role t1
   LEFT JOIN v_libelle_uc t2 ON ((t2.pk_unite_connaissance = t1.fk_unite_connaissance_associee)))
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t3 ON ((t3.fk_objet = t1.fk_objet_associe)))
  WHERE (t1.si_sujet_uc IS TRUE)
  GROUP BY t1.fk_unite_connaissance;


--
-- TOC entry 212 (class 1259 OID 19545)
-- Name: v_role_avec_uc; Type: VIEW; Schema: tables_uc; Owner: -
--

CREATE VIEW v_role_avec_uc AS
 SELECT t1.pk_role, 
    t1.fk_objet_associe, 
    t1.fk_unite_connaissance_associee, 
        CASE
            WHEN ((t6.nom IS NOT NULL) OR (t6.nom <> ''::text)) THEN t6.nom
            ELSE t8.libelle_uc
        END AS objet_uc_associee, 
    t1.fk_type_role, 
    t1.descriptif AS descriptif_role, 
    t7.nom AS type_role, 
    t1.libelle_selon_source, 
    t1.si_sujet_uc, 
    t1.valeur_numerique, 
    t4.nom AS unite_mesure, 
    t9.sujet_uc, 
    t10.autres_objets_uc, 
    t2.libelle_uc, 
    t11.descriptif, 
    t3.date_standard, 
    t2.fk_type_unite_connaissance AS cle_type_uc, 
    t5.nom AS type_uc, 
    t2.pk_unite_connaissance
   FROM ((((((((((role t1
   JOIN unite_connaissance t11 ON ((t11.pk_unite_connaissance = t1.fk_unite_connaissance)))
   LEFT JOIN v_libelle_uc t2 ON ((t2.pk_unite_connaissance = t1.fk_unite_connaissance)))
   LEFT JOIN tables_types.type_unite_connaissance t5 ON ((t5.pk_type_unite_connaissance = t2.fk_type_unite_connaissance)))
   LEFT JOIN tables_types.type_role t7 ON ((t7.pk_type_role = t1.fk_type_role)))
   LEFT JOIN v_date_standard_uc t3 ON ((t3.fk_unite_connaissance = t1.fk_unite_connaissance)))
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t6 ON ((t6.fk_objet = t1.fk_objet_associe)))
   LEFT JOIN v_libelle_uc t8 ON ((t8.pk_unite_connaissance = t1.fk_unite_connaissance_associee)))
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t4 ON ((t4.fk_objet = t1.fk_unite_mesure)))
   LEFT JOIN v_sujet_uc t9 ON ((t9.fk_unite_connaissance = t1.fk_unite_connaissance)))
   LEFT JOIN v_autres_objets_uc t10 ON ((t10.fk_unite_connaissance = t1.fk_unite_connaissance)));


--
-- TOC entry 213 (class 1259 OID 19550)
-- Name: v_sources_avec_libelles; Type: VIEW; Schema: tables_uc; Owner: -
--

CREATE VIEW v_sources_avec_libelles AS
 SELECT t1.fk_unite_connaissance, 
    t3.libelle_uc, 
    t1.fk_objet, 
    t2.nom AS source, 
    t5.nom AS sous_type_objet, 
    t1.reference_precise, 
    t1.descriptif, 
    t1.notes, 
    t1.pk_sourcer
   FROM ((((sourcer t1
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t2 ON ((t2.fk_objet = t1.fk_objet)))
   LEFT JOIN tables_objet.objet t4 ON ((t4.pk_objet = t1.fk_objet)))
   LEFT JOIN tables_types.parametre t5 ON ((t5.pk_parametre = t4.fk_sous_type_objet)))
   LEFT JOIN v_libelle_uc t3 ON ((t3.pk_unite_connaissance = t1.fk_unite_connaissance)));


--
-- TOC entry 2224 (class 2604 OID 19555)
-- Name: pk_associer_unite_connaissance_objet; Type: DEFAULT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY associer_unite_connaissance_objet ALTER COLUMN pk_associer_unite_connaissance_objet SET DEFAULT nextval('associer_unite_connaissance_o_pk_associer_unite_connaissanc_seq'::regclass);


--
-- TOC entry 2225 (class 2604 OID 19556)
-- Name: pk_date_unite_connaissance; Type: DEFAULT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY date_unite_connaissance ALTER COLUMN pk_date_unite_connaissance SET DEFAULT nextval('date_unite_connaissance_pk_date_unite_connaissance_seq'::regclass);


--
-- TOC entry 2226 (class 2604 OID 19557)
-- Name: pk_propriete_texte; Type: DEFAULT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY propriete_texte ALTER COLUMN pk_propriete_texte SET DEFAULT nextval('propriete_texte_pk_propriete_texte_seq'::regclass);


--
-- TOC entry 2227 (class 2604 OID 19558)
-- Name: pk_role; Type: DEFAULT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY role ALTER COLUMN pk_role SET DEFAULT nextval('role_pk_role_seq'::regclass);


--
-- TOC entry 2228 (class 2604 OID 19559)
-- Name: pk_sourcer; Type: DEFAULT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY sourcer ALTER COLUMN pk_sourcer SET DEFAULT nextval('sourcer_pk_sourcer_seq'::regclass);


--
-- TOC entry 2229 (class 2604 OID 19560)
-- Name: pk_unite_connaissance; Type: DEFAULT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY unite_connaissance ALTER COLUMN pk_unite_connaissance SET DEFAULT nextval('unite_connaissance_pk_unite_connaissance_seq'::regclass);


--
-- TOC entry 2393 (class 0 OID 0)
-- Dependencies: 196
-- Name: associer_unite_connaissance_o_pk_associer_unite_connaissanc_seq; Type: SEQUENCE SET; Schema: tables_uc; Owner: -
--

SELECT pg_catalog.setval('associer_unite_connaissance_o_pk_associer_unite_connaissanc_seq', 1, false);


--
-- TOC entry 2370 (class 0 OID 19474)
-- Dependencies: 195
-- Data for Name: associer_unite_connaissance_objet; Type: TABLE DATA; Schema: tables_uc; Owner: -
--



--
-- TOC entry 2372 (class 0 OID 19482)
-- Dependencies: 197
-- Data for Name: date_unite_connaissance; Type: TABLE DATA; Schema: tables_uc; Owner: -
--

INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1, 6, NULL, 2011, 10, 15, '2011-10-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4375);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2, 4, NULL, 1628, 4, NULL, '1628-04 r', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9685);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (3, 4, NULL, 1628, 5, 25, '1628-05-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9655);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (4, 4, NULL, 1634, 4, 12, '1634-04-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9686);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (5, 4, NULL, 1573, NULL, NULL, '1573 r', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9648);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (6, 4, NULL, 1525, NULL, NULL, '1525 r', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8210);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (7, 4, NULL, 1624, 4, 24, '1624-04-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8281);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (8, 4, NULL, 1626, NULL, NULL, '1626', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9459);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (9, 4, NULL, 1497, 4, NULL, '1497-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8290);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (10, 4, NULL, 1538, NULL, NULL, '1538', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8955);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (11, 4, NULL, 1545, NULL, NULL, '1545', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9776);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (12, 4, NULL, 1586, NULL, NULL, '1586', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8239);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (13, 4, NULL, 1556, NULL, NULL, '1556', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9778);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (14, 4, NULL, 1560, NULL, NULL, '1560', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 559);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (15, 4, NULL, 1570, NULL, NULL, '1570', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8233);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (16, 4, NULL, 1570, 4, 28, '1570-04-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8235);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (17, 4, NULL, 1573, NULL, NULL, '1573', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8266);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (18, 4, NULL, 1574, NULL, NULL, '1574', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8268);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (19, 4, NULL, 1574, NULL, NULL, '1574', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8269);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (20, 4, NULL, 1576, NULL, NULL, '1576', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7387);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (21, 4, NULL, 1576, NULL, NULL, '1576', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7391);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (22, 4, NULL, 1576, NULL, NULL, '1576', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7389);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (23, 4, NULL, 1576, NULL, NULL, '1576', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7390);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (24, 4, NULL, 1579, NULL, NULL, '1579', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7277);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (25, 4, NULL, 1581, NULL, NULL, '1581', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 28);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (26, 4, NULL, 1584, NULL, NULL, '1584', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 521);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (27, 4, NULL, 1585, NULL, NULL, '1585', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9718);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (28, 4, NULL, 1586, NULL, NULL, '1586', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7502);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (29, 4, NULL, 1591, NULL, NULL, '1591', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8799);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (30, 4, NULL, 1591, NULL, NULL, '1591', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7252);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (31, 4, NULL, 1592, 8, NULL, '1592-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7251);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (32, 4, NULL, 1592, 9, 25, '1592-09-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9687);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (33, 4, NULL, 1592, 9, 25, '1592-09-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9688);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (34, 4, NULL, 1592, 9, 25, '1592-09-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8237);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (35, 4, NULL, 1593, NULL, NULL, '1593', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7250);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (36, 4, NULL, 1599, NULL, NULL, '1599', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7504);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (37, 4, NULL, 1603, 3, 19, '1603-03-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8853);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (38, 4, NULL, 1607, NULL, NULL, '1607', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7500);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (39, 4, NULL, 1608, 5, 24, '1608-05-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8855);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (40, 4, NULL, 1609, NULL, NULL, '1609', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7798);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (41, 4, NULL, 1610, NULL, NULL, '1610', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8886);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (42, 4, NULL, 1611, 1, 7, '1611-01-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 26);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (43, 4, NULL, 1612, NULL, NULL, '1612', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9723);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (44, 4, NULL, 1613, NULL, NULL, '1613', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 66);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (45, 4, NULL, 1613, 7, 20, '1613-07-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8885);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (46, 4, NULL, 1615, NULL, NULL, '1615', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7974);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (47, 4, NULL, 1615, 2, 6, '1615-02-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7979);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (48, 4, NULL, 1615, 4, 11, '1615-04-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7980);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (49, 4, NULL, 1615, 4, 12, '1615-04-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8939);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (50, 4, NULL, 1616, NULL, NULL, '1616', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 831);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (51, 4, NULL, 1627, NULL, NULL, '1627', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7392);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (52, 4, NULL, 1617, NULL, NULL, '1617', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7981);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (53, 4, NULL, 1619, NULL, NULL, '1619', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 833);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (54, 4, NULL, 1619, NULL, NULL, '1619', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9709);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (55, 4, NULL, 1619, NULL, NULL, '1619', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9332);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (56, 4, NULL, 1621, NULL, NULL, '1621', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8251);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (57, 4, NULL, 1625, NULL, NULL, '1625', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9463);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (58, 4, NULL, 1627, NULL, NULL, '1627', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 365);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (59, 4, NULL, 1627, NULL, NULL, '1627', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7393);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (60, 4, NULL, 1627, NULL, NULL, '1627', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9234);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (61, 4, NULL, 1629, NULL, NULL, '1629', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7199);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (62, 4, NULL, 1630, NULL, NULL, '1630', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7201);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (63, 4, NULL, 1630, NULL, NULL, '1630', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7984);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (64, 4, NULL, 1631, NULL, NULL, '1631', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 835);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (65, 4, NULL, 1631, NULL, NULL, '1631', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 837);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (66, 4, NULL, 1631, NULL, NULL, '1631', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7203);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (67, 4, NULL, 1632, NULL, NULL, '1632', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9082);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (68, 4, NULL, 1632, NULL, NULL, '1632', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3073);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (69, 4, NULL, 1632, NULL, NULL, '1632', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7205);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (70, 4, NULL, 1632, NULL, NULL, '1632', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7209);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (71, 4, NULL, 1633, NULL, NULL, '1633', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3076);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (72, 4, NULL, 1633, NULL, NULL, '1633', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7207);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (73, 4, NULL, 1633, 2, 23, '1633-02-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7962);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (74, 4, NULL, 1633, 2, 23, '1633-02-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1169);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (75, 4, NULL, 1633, 2, 23, '1633-02-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7977);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (76, 4, NULL, 1633, 7, 16, '1633-07-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7982);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (77, 4, NULL, 1633, 7, 16, '1633-07-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3416);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (78, 4, NULL, 1633, 7, 16, '1633-07-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7976);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (79, 4, NULL, 1633, 7, 16, '1633-07-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7978);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (80, 4, NULL, 1633, 7, 16, '1633-07-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7643);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (81, 4, NULL, 1633, 7, 16, '1633-07-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7983);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (82, 4, NULL, 1633, 7, 16, '1633-07-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1171);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (83, 4, NULL, 1634, NULL, NULL, '1634', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 839);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (84, 4, NULL, 1634, NULL, NULL, '1634', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9288);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (85, 4, NULL, 1635, NULL, NULL, '1635', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9331);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (86, 4, NULL, 1636, NULL, NULL, '1636', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3074);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (87, 4, NULL, 1636, NULL, NULL, '1636', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9333);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (88, 4, NULL, 1636, NULL, NULL, '1636', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9325);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (89, 4, NULL, 1637, NULL, NULL, '1637', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (90, 4, NULL, 1637, NULL, NULL, '1637', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7210);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (91, 4, NULL, 1637, NULL, NULL, '1637', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 154);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (92, 4, NULL, 1638, NULL, NULL, '1638', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (93, 4, NULL, 1638, NULL, NULL, '1638', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9335);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (94, 4, NULL, 1638, NULL, NULL, '1638', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9327);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (95, 4, NULL, 1639, NULL, NULL, '1639', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (96, 4, NULL, 1639, NULL, NULL, '1639', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7642);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (97, 4, NULL, 1639, NULL, NULL, '1639', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3078);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (98, 4, NULL, 1639, 5, NULL, '1639-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9323);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (99, 4, NULL, 1639, 5, 12, '1639-05-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9329);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (100, 4, NULL, 1641, NULL, NULL, '1641', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 158);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (101, 4, NULL, 1642, NULL, NULL, '1642', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9236);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (102, 4, NULL, 1644, NULL, NULL, '1644', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 156);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (103, 4, NULL, 1646, NULL, NULL, '1646', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9342);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (104, 4, NULL, 1651, NULL, NULL, '1651', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7715);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (105, 4, NULL, 1651, NULL, NULL, '1651', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7985);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (106, 4, NULL, 1651, NULL, NULL, '1651', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9266);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (107, 4, NULL, 1651, NULL, NULL, '1651', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9262);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (108, 4, NULL, 1652, NULL, NULL, '1652', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9773);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (109, 4, NULL, 1652, NULL, NULL, '1652', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4571);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (110, 4, NULL, 1653, NULL, NULL, '1653', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9337);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (111, 4, NULL, 1658, NULL, NULL, '1658', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9217);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (112, 4, NULL, 1658, NULL, NULL, '1658', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9213);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (113, 4, NULL, 1658, NULL, NULL, '1658', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9211);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (114, 4, NULL, 1658, NULL, NULL, '1658', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 146);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (115, 4, NULL, 1658, NULL, NULL, '1658', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9215);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (116, 4, NULL, 1658, NULL, NULL, '1658', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8250);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (117, 4, NULL, 1658, NULL, NULL, '1658', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9312);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (118, 4, NULL, 1663, NULL, NULL, '1663', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9255);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (119, 4, NULL, 1663, NULL, NULL, '1663', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9264);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (120, 4, NULL, 1663, NULL, NULL, '1663', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 150);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (121, 4, NULL, 1663, 9, NULL, '1663-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9257);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (122, 4, NULL, 1663, 9, NULL, '1663-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 152);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (123, 4, NULL, 1665, NULL, NULL, '1665', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7623);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (124, 4, NULL, 1665, NULL, NULL, '1665', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7627);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (125, 4, NULL, 1665, NULL, NULL, '1665', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4569);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (126, 4, NULL, 1668, NULL, NULL, '1668', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9201);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (127, 4, NULL, 1669, NULL, NULL, '1669', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9304);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (128, 4, NULL, 1671, NULL, NULL, '1671', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9306);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (129, 4, NULL, 1671, 11, 3, '1671-11-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9509);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (130, 4, NULL, 1671, 11, 3, '1671-11-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4570);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (131, 4, NULL, 1671, 11, 3, '1671-11-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 148);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (132, 4, NULL, 1673, NULL, NULL, '1673', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9505);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (133, 4, NULL, 1673, NULL, NULL, '1673', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4567);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (134, 4, NULL, 1673, 8, 1, '1673-08-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9310);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (135, 4, NULL, 1673, 11, 15, '1673-11-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9227);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (136, 4, NULL, 1674, NULL, NULL, '1674', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9315);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (137, 4, NULL, 1675, 8, 11, '1675-08-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9507);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (138, 4, NULL, 1676, 5, NULL, '1676-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9232);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (139, 4, NULL, 1680, NULL, NULL, '1680', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9308);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (140, 4, NULL, 1680, 10, NULL, '1680-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9229);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (141, 4, NULL, 1680, 11, 26, '1680-11-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9317);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (142, 4, NULL, 1695, NULL, NULL, '1695', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8273);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (143, 4, NULL, 1698, NULL, NULL, '1698', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8275);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (144, 4, NULL, 1703, NULL, NULL, '1703', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9275);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (145, 4, NULL, 1705, NULL, NULL, '1705', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9277);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (146, 4, NULL, 1707, NULL, NULL, '1707', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9280);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (147, 4, NULL, 1712, 5, 17, '1712-05-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9282);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (148, 4, NULL, 1717, NULL, NULL, '1717', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9286);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (149, 4, NULL, 1727, NULL, NULL, '1727', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1165);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (150, 4, NULL, 1734, NULL, NULL, '1734', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9284);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (151, 4, NULL, 1738, 1, 5, '1738-01-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9281);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (152, 4, NULL, 1740, NULL, NULL, '1740', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 612);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (153, 4, NULL, 1746, NULL, NULL, '1746', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9272);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (154, 4, NULL, 1749, NULL, NULL, '1749', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 616);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (155, 4, NULL, 1749, NULL, NULL, '1749', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 622);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (156, 4, NULL, 1751, NULL, NULL, '1751', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 618);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (157, 4, NULL, 1756, NULL, NULL, '1756', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 624);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (158, 4, NULL, 1756, NULL, NULL, '1756', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 620);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (159, 4, NULL, 1758, NULL, NULL, '1758', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9433);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (160, 4, NULL, 1767, NULL, NULL, '1767', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9273);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (161, 4, NULL, 1648, NULL, NULL, '1648', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9768);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (162, 4, NULL, 1649, NULL, NULL, '1649', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8248);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (163, 4, NULL, 1665, NULL, NULL, '1665', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 387);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (164, 4, NULL, 1634, 11, 10, '1634-11-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1248);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (165, 4, NULL, 1613, 1, 9, '1613-01-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7964);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (166, 4, NULL, 1611, 11, 12, '1611-11-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7966);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (167, 4, NULL, 1611, 12, 19, '1611-12-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7972);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (168, 4, NULL, 1611, 12, 26, '1611-12-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7968);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (169, 4, NULL, 1612, 7, 25, '1612-07-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7970);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (170, 4, NULL, 1670, NULL, NULL, '1670', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9203);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (171, 4, NULL, 1740, NULL, NULL, '1740', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 614);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (172, 4, NULL, 1754, NULL, NULL, '1754', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9268);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (173, 4, NULL, 1760, NULL, NULL, '1760', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9270);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (174, 4, NULL, 1665, NULL, NULL, '1665', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7625);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (175, 4, NULL, 1715, NULL, NULL, '1715', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9278);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (176, 4, NULL, 1705, NULL, NULL, '1705', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9279);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (177, 4, NULL, 1885, NULL, NULL, '1885', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9205);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (178, 4, NULL, 1611, 1, 7, '1611-01-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 10);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (179, 4, NULL, 1610, 4, 19, '1610-04-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3245);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (180, 4, NULL, 1597, 10, 13, '1597-10-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3247);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (181, 4, NULL, 1610, 8, 9, '1610-08-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3249);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (182, 4, NULL, 1610, 10, 25, '1610-10-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3251);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (183, 4, NULL, 1610, 12, 1, '1610-12-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3253);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (184, 4, NULL, 1611, 1, 9, '1611-01-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3255);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (185, 4, NULL, 1611, 3, 28, '1611-03-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3261);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (186, 4, NULL, 1598, 3, 26, '1598-03-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3265);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (187, 4, NULL, 1610, 8, 9, '1610-08-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3275);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (188, 4, NULL, 1613, 7, 18, '1613-07-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3267);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (189, 4, NULL, 1597, 9, 1, '1597-09-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3269);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (190, 4, NULL, 1610, 5, 10, '1610-05-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3263);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (191, 4, NULL, 1612, 11, 10, '1612-11-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3273);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (192, 4, NULL, 1610, 5, 3, '1610-05-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3271);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (193, 4, NULL, 1610, 10, 1, '1610-10-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3283);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (194, 4, NULL, 1610, 12, 18, '1610-12-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3277);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (195, 4, NULL, 1612, 3, 18, '1612-03-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3279);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (196, 4, NULL, 1618, 12, 1, '1618-12-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3281);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (197, 4, NULL, 1619, 10, 1, '1619-10-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3287);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (198, 4, NULL, 1611, 7, 1, '1611-07-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3285);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (199, 4, NULL, 1599, 7, 18, '1599-07-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3289);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (200, 4, NULL, 1594, NULL, NULL, '1594', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7247);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (201, 4, NULL, 1658, NULL, NULL, '1658', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1173);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (202, 4, NULL, 1739, NULL, NULL, '1739', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9372);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (203, 4, NULL, 1516, NULL, NULL, '1516', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7448);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (204, 4, NULL, 1504, NULL, NULL, '1504', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7450);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (205, 4, NULL, 1513, NULL, NULL, '1513', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7452);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (206, 4, NULL, 1516, NULL, NULL, '1516', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7482);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (207, 4, NULL, 1670, 9, 20, '1670-09-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7676);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (208, 4, NULL, 1670, NULL, NULL, '1670', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9223);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (209, 4, NULL, 1671, NULL, NULL, '1671', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9225);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (210, 4, NULL, 1684, NULL, NULL, '1684', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9221);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (211, 4, NULL, 1626, 6, 1, '1626-06-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9455);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (212, 4, NULL, 1626, 7, 6, '1626-07-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9457);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (213, 4, NULL, 1625, NULL, NULL, '1625', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9461);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (214, 4, NULL, 1625, NULL, NULL, '1625', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3295);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (215, 4, NULL, 1612, NULL, NULL, '1612', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 12);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (216, 4, NULL, 1534, NULL, NULL, '1534', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7454);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (217, 4, NULL, 1875, NULL, NULL, '1875', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9207);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (218, 4, NULL, 1636, NULL, NULL, '1636', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9770);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (219, 4, NULL, 1682, NULL, NULL, '1682', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9772);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (220, 4, NULL, 1669, NULL, NULL, '1669', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9468);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (221, 4, NULL, 1644, NULL, NULL, '1644', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9486);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (222, 4, NULL, 1711, NULL, NULL, '1711', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9492);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (223, 4, NULL, 1638, 11, NULL, '1638-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (224, 4, NULL, 1637, NULL, NULL, '1637', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (225, 4, NULL, 1629, NULL, NULL, '1629', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7640);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (226, 4, NULL, 1626, NULL, NULL, '1626', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7639);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (227, 4, NULL, 1637, NULL, NULL, '1637', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7644);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (228, 4, NULL, 1601, NULL, NULL, '1601', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8856);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (229, 4, NULL, 1601, NULL, NULL, '1601', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8857);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (230, 4, NULL, 1591, 10, 3, '1591-10-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7254);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (231, 4, NULL, 1600, 11, 25, '1600-11-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8241);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (232, 4, NULL, 1593, NULL, NULL, '1593', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7253);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (233, 4, NULL, 1592, 11, NULL, '1592-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7249);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (234, 4, NULL, 1518, 6, 13, '1518-06-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7486);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (235, 4, NULL, 1622, 8, 24, '1622-08-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7742);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (236, 4, NULL, 1628, 8, 14, '1628-08-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5294);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (237, 4, NULL, 1650, NULL, NULL, '1650', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9230);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (238, 4, NULL, 1654, NULL, NULL, '1654', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9231);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (239, 4, NULL, 1663, NULL, NULL, '1663', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9550);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (240, 4, NULL, 1645, NULL, NULL, '1645', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9554);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (241, 4, NULL, 1655, NULL, NULL, '1655', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9552);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (242, 4, NULL, 1650, NULL, NULL, '1650', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5296);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (243, 4, NULL, 1601, NULL, NULL, '1601', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9601);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (244, 4, NULL, 1607, NULL, NULL, '1607', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9603);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (245, 4, NULL, 1629, NULL, NULL, '1629', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7744);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (246, 4, NULL, 1458, 5, 30, '1458-05-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8367);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (247, 4, NULL, 1505, NULL, NULL, '1505', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8378);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (248, 4, NULL, 1492, 9, 12, '1492-09-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8376);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (249, 4, NULL, 1504, 4, 13, '1504-04-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8377);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (250, 4, NULL, 1516, 8, 21, '1516-08-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8375);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (251, 4, NULL, 1503, 8, 3, '1503-08-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7184);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (252, 4, NULL, 1521, NULL, NULL, '1521', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7170);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (253, 4, NULL, 1497, NULL, NULL, '1497', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7172);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (254, 4, NULL, 1499, 7, 20, '1499-07-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8359);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (255, 4, NULL, 1499, 7, 20, '1499-07-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8292);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (256, 4, NULL, 1499, 7, 15, '1499-07-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8361);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (257, 4, NULL, 1476, NULL, NULL, '1476', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8286);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (258, 4, NULL, 1499, 7, 13, '1499-07-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8362);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (259, 4, NULL, 1646, NULL, NULL, '1646', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9341);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (260, 4, NULL, 1520, NULL, NULL, '1520', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7462);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (261, 4, NULL, 1520, NULL, NULL, '1520', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7446);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (262, 4, NULL, 1567, NULL, NULL, '1567', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7464);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (263, 4, NULL, 1556, NULL, NULL, '1556', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7466);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (264, 4, NULL, 1637, NULL, NULL, '1637', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9080);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (265, 4, NULL, 1511, 11, 7, '1511-11-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8288);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (266, 4, NULL, 1545, NULL, NULL, '1545', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8209);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (267, 4, NULL, 1519, 9, 10, '1519-09-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8208);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (268, 4, NULL, 1509, 2, 15, '1509-02-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9533);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (269, 4, NULL, 1512, NULL, NULL, '1512', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9521);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (270, 4, NULL, 1510, 3, 15, '1510-03-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9519);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (271, 4, NULL, 1468, NULL, NULL, '1468', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8355);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (272, 4, NULL, 1495, 12, 29, '1495-12-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8368);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (273, 4, NULL, 1495, 12, 29, '1495-12-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7478);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (274, 4, NULL, 1497, 3, 1, '1497-03-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7174);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (275, 4, NULL, 1497, 3, 1, '1497-03-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7164);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (276, 4, NULL, 1497, 3, 1, '1497-03-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7166);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (277, 4, NULL, 1525, 3, 1, '1525-03-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7468);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (278, 4, NULL, 1499, NULL, NULL, '1499', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8363);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (279, 4, NULL, 1499, NULL, NULL, '1499', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7472);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (280, 4, NULL, 1500, 12, NULL, '1500-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7493);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (281, 4, NULL, 1515, NULL, NULL, '1515', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7494);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (282, 4, NULL, 1504, NULL, NULL, '1504', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7470);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (283, 4, NULL, 1504, NULL, NULL, '1504', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 444);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (284, 4, NULL, 1506, 3, 22, '1506-03-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 445);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (285, 4, NULL, 1500, NULL, NULL, '1500', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7460);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (286, 4, NULL, 1500, NULL, NULL, '1500', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 448);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (287, 4, NULL, 1503, 10, NULL, '1503-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 442);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (288, 4, NULL, 1503, 10, NULL, '1503-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7458);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (289, 4, NULL, 1505, 3, 26, '1505-03-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 446);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (290, 4, NULL, 1517, NULL, NULL, '1517', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7484);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (291, 4, NULL, 1513, 12, 19, '1513-12-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9525);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (292, 4, NULL, 1505, NULL, NULL, '1505', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8351);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (293, 4, NULL, 1505, NULL, NULL, '1505', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7168);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (294, 4, NULL, 1493, NULL, NULL, '1493', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9529);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (295, 4, NULL, 1487, 6, NULL, '1487-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7488);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (296, 4, NULL, 1509, NULL, NULL, '1509', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7456);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (297, 4, NULL, 1512, 5, 12, '1512-05-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 473);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (298, 4, NULL, 1517, 5, 8, '1517-05-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 474);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (299, 4, NULL, 1518, 5, 22, '1518-05-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 475);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (300, 4, NULL, 1518, 5, NULL, '1518-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 472);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (301, 4, NULL, 1518, 5, NULL, '1518-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 476);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (302, 4, NULL, 1517, 5, NULL, '1517-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 477);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (303, 4, NULL, 1517, 5, 8, '1517-05-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 471);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (304, 4, NULL, 1500, 12, 14, '1500-12-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7480);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (305, 4, NULL, 1483, 2, 11, '1483-02-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8364);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (306, 4, NULL, 1484, 1, 12, '1484-01-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7495);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (307, 4, NULL, 1487, 10, 23, '1487-10-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8365);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (308, 4, NULL, 1487, 10, 23, '1487-10-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7496);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (309, 4, NULL, 1465, 10, NULL, '1465-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8369);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (310, 4, NULL, 1469, 6, 2, '1469-06-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8357);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (311, 4, NULL, 1487, 12, 13, '1487-12-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8370);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (312, 4, NULL, 1487, NULL, NULL, '1487', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8366);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (313, 4, NULL, 1499, 8, 3, '1499-08-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8373);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (314, 4, NULL, 1489, 5, 4, '1489-05-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8371);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (315, 4, NULL, 1488, 9, NULL, '1488-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7474);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (316, 4, NULL, 1492, 9, 28, '1492-09-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7490);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (317, 4, NULL, 1495, 9, 8, '1495-09-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8372);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (318, 4, NULL, 1495, 9, 8, '1495-09-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7476);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (319, 4, NULL, 1495, 9, 8, '1495-09-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7178);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (320, 4, NULL, 1492, 11, NULL, '1492-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7180);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (321, 4, NULL, 1496, 3, NULL, '1496-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7492);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (322, 4, NULL, 1494, 10, NULL, '1494-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7182);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (323, 4, NULL, 1518, NULL, NULL, '1518', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7176);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (324, 4, NULL, 1536, NULL, NULL, '1536', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 460);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (325, 4, NULL, 1491, NULL, NULL, '1491', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9527);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (326, 4, NULL, 1491, NULL, NULL, '1491', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8353);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (327, 4, NULL, 1514, 12, 23, '1514-12-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9523);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (328, 4, NULL, 1469, 2, NULL, '1469-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9531);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (329, 4, NULL, 1590, NULL, NULL, '1590', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9725);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (330, 4, NULL, 1646, NULL, NULL, '1646', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4144);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (331, 4, NULL, 1651, NULL, NULL, '1651', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4142);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (332, 4, NULL, 1570, NULL, NULL, '1570', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8243);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (333, 4, NULL, 1503, NULL, NULL, '1503', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7497);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (334, 4, NULL, 1509, NULL, NULL, '1509', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9534);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (335, 4, NULL, 1492, NULL, NULL, '1492', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8374);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (336, 4, NULL, 1639, 9, 21, '1639-09-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1177);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (337, 4, NULL, 1641, 7, 12, '1641-07-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1179);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (338, 4, NULL, 1612, 6, 23, '1612-06-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8941);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (339, 4, NULL, 1611, 4, 19, '1611-04-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8943);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (340, 4, NULL, 1633, 6, 21, '1633-06-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1163);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (341, 4, NULL, 1602, 8, 15, '1602-08-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3257);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (342, 4, NULL, 1603, 8, 21, '1603-08-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3259);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (343, 4, NULL, 1611, 1, 13, '1611-01-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9684);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (344, 4, NULL, 1614, 3, 8, '1614-03-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9683);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (345, 4, NULL, 1616, 11, 3, '1616-11-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9682);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (346, 4, NULL, 1631, 4, 26, '1631-04-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9679);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (347, 4, NULL, 1632, 5, 1, '1632-05-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9681);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (348, 4, NULL, 1632, 8, 5, '1632-08-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9677);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (349, 4, NULL, 1632, 8, 21, '1632-08-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9675);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (350, 4, NULL, 1632, 9, 25, '1632-09-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9663);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (351, 4, NULL, 1632, 10, 22, '1632-10-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9665);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (352, 4, NULL, 1638, 7, 6, '1638-07-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9667);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (353, 4, NULL, 1635, 4, 15, '1635-04-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9671);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (354, 4, NULL, 1635, 5, 3, '1635-05-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9669);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (355, 4, NULL, 1635, 7, 2, '1635-07-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9673);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (356, 4, NULL, 1636, 2, 13, '1636-02-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7213);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (357, 4, NULL, 1588, 1, 16, '1588-01-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 20);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (358, 4, NULL, 1588, 3, 5, '1588-03-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 14);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (359, 4, NULL, 1604, 12, 18, '1604-12-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 16);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (360, 4, NULL, 1610, 12, 17, '1610-12-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (361, 4, NULL, 1611, 5, 27, '1611-05-27', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 22);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (362, 4, NULL, 1618, 1, 7, '1618-01-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 60);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (363, 4, NULL, 1618, 1, 20, '1618-01-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 62);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (364, 4, NULL, 1618, 5, 26, '1618-05-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 64);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (365, 4, NULL, 1639, 2, 20, '1639-02-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 112);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (366, 4, NULL, 1632, 11, 1, '1632-11-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 114);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (367, 4, NULL, 1633, 11, 30, '1633-11-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 116);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (368, 4, NULL, 1634, 2, 1, '1634-02-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 118);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (369, 4, NULL, 1634, 4, 1, '1634-04-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 120);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (370, 4, NULL, 1634, 5, 15, '1634-05-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 122);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (371, 4, NULL, 1634, 8, 14, '1634-08-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 124);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (372, 4, NULL, 1636, 3, 1, '1636-03-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 126);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (373, 4, NULL, 1638, 6, 29, '1638-06-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 128);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (374, 4, NULL, 1638, 7, 27, '1638-07-27', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 130);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (375, 4, NULL, 1638, 8, 23, '1638-08-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 132);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (376, 4, NULL, 1638, 10, 11, '1638-10-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 134);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (377, 4, NULL, 1638, 11, 15, '1638-11-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 136);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (378, 4, NULL, 1638, 12, 1, '1638-12-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 138);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (379, 4, NULL, 1639, 2, 9, '1639-02-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 140);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (380, 4, NULL, 1639, 2, 20, '1639-02-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 142);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (381, 4, NULL, 1641, 3, 31, '1641-03-31', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 144);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (382, 4, NULL, 1608, 8, 30, '1608-08-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7255);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (383, 4, NULL, 1608, 10, 10, '1608-10-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7257);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (384, 4, NULL, 1609, 3, 6, '1609-03-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7259);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (385, 4, NULL, 1609, 3, 10, '1609-03-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7261);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (386, 4, NULL, 1609, 3, 10, '1609-03-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7264);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (387, 4, NULL, 1609, 6, 29, '1609-06-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7263);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (388, 4, NULL, 1610, 10, 16, '1610-10-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7265);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (389, 4, NULL, 1631, 5, 31, '1631-05-31', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7641);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (390, 4, NULL, 1611, 3, 24, '1611-03-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (391, 4, NULL, 1610, 4, 16, '1610-04-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3296);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (392, 4, NULL, 1610, 5, 28, '1610-05-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3276);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (393, 4, NULL, 1588, 1, 8, '1588-01-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 31);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (394, 4, NULL, 1588, 2, 25, '1588-02-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 32);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (395, 4, NULL, 1610, 9, 17, '1610-09-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 30);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (396, 4, NULL, 1610, 12, 30, '1610-12-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 33);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (397, 4, NULL, 1611, 3, 5, '1611-03-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 34);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (398, 4, NULL, 1597, 8, 4, '1597-08-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3297);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (399, 4, NULL, 1610, 8, 19, '1610-08-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3298);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (400, 4, NULL, 1627, 8, 28, '1627-08-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3299);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (401, 4, NULL, 1640, 9, 21, '1640-09-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1125);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (402, 4, NULL, 1633, 8, 13, '1633-08-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1127);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (403, 4, NULL, 1633, 5, 10, '1633-05-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9689);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (404, 4, NULL, 1633, 5, 10, '1633-05-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1129);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (405, 4, NULL, 1625, 7, 20, '1625-07-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1131);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (406, 4, NULL, 1628, 3, 2, '1628-03-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1133);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (407, 4, NULL, 1630, 8, 30, '1630-08-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1135);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (408, 4, NULL, 1632, 3, 1, '1632-03-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1137);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (409, 4, NULL, 1632, 11, 1, '1632-11-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1139);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (410, 4, NULL, 1634, 1, 19, '1634-01-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1141);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (411, 4, NULL, 1636, 11, 18, '1636-11-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1143);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (412, 4, NULL, 1637, 2, 24, '1637-02-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1145);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (413, 4, NULL, 1637, 10, 13, '1637-10-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1147);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (414, 4, NULL, 1640, 8, 13, '1640-08-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1149);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (415, 4, NULL, 1633, 5, 6, '1633-05-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1151);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (416, 4, NULL, 1633, 8, 13, '1633-08-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1153);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (417, 4, NULL, 1633, 8, 3, '1633-08-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1155);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (418, 4, NULL, 1633, 12, 28, '1633-12-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1161);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (419, 4, NULL, 1634, 2, 11, '1634-02-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1157);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (420, 4, NULL, 1635, 10, 20, '1635-10-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1159);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (421, 4, NULL, 1614, 3, 15, '1614-03-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3978);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (422, 4, NULL, 1610, 3, 31, '1610-03-31', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3231);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (423, 4, NULL, 1610, 4, 6, '1610-04-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3233);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (424, 4, NULL, 1610, 4, 16, '1610-04-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3235);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (425, 4, NULL, 1610, 4, 27, '1610-04-27', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3237);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (426, 4, NULL, 1610, 5, 24, '1610-05-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3239);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (427, 4, NULL, 1610, 5, 26, '1610-05-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3241);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (428, 4, NULL, 1610, 6, 30, '1610-06-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3243);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (429, 4, NULL, 1637, 9, 8, '1637-09-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 110);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (430, 4, NULL, 1640, 11, 8, '1640-11-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1167);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (431, 4, NULL, 1612, 12, 11, '1612-12-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3292);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (432, 4, NULL, 1610, 9, 7, '1610-09-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7512);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (433, 4, NULL, 1610, 9, 7, '1610-09-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3290);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (434, 4, NULL, 1614, 5, 17, '1614-05-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7514);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (435, 4, NULL, 1614, 5, 17, '1614-05-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3291);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (436, 4, NULL, 1610, 4, 20, '1610-04-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3294);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (437, 4, NULL, 1610, 5, 26, '1610-05-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3293);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (438, 4, NULL, 1640, 11, 3, '1640-11-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4902);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (439, 4, NULL, 1633, 4, 1, '1633-04-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1175);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (440, 4, NULL, 1629, 11, 14, '1629-11-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9394);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (441, 4, NULL, 1635, 3, 26, '1635-03-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1242);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (442, 4, NULL, 1632, 2, 26, '1632-02-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1211);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (443, 4, NULL, 1633, 3, 2, '1633-03-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1122);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (444, 4, NULL, 1633, 6, 25, '1633-06-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1130);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (445, 4, NULL, 1633, 8, 12, '1633-08-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1120);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (446, 4, NULL, 1633, 9, 8, '1633-09-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1128);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (447, 4, NULL, 1633, 9, 27, '1633-09-27', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1191);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (448, 4, NULL, 1633, 12, 14, '1633-12-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1217);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (449, 4, NULL, 1633, 12, 20, '1633-12-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1235);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (450, 4, NULL, 1634, 1, 5, '1634-01-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1216);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (451, 4, NULL, 1634, 1, 17, '1634-01-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1126);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (452, 4, NULL, 1634, 1, 18, '1634-01-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1215);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (453, 4, NULL, 1634, 2, 1, '1634-02-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1213);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (454, 4, NULL, 1635, 4, 19, '1635-04-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1243);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (455, 4, NULL, 1635, 5, 26, '1635-05-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1220);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (456, 4, NULL, 1635, 5, 26, '1635-05-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1124);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (457, 4, NULL, 1635, 6, 2, '1635-06-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1219);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (458, 4, NULL, 1635, 6, 18, '1635-06-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1218);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (459, 4, NULL, 1638, 2, 5, '1638-02-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7151);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (460, 4, NULL, 1613, 10, 5, '1613-10-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3272);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (461, 4, NULL, 1614, 1, 1, '1614-01-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3282);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (462, 4, NULL, 1634, 8, 9, '1634-08-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7650);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (463, 4, NULL, 1611, 12, 17, '1611-12-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3286);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (464, 4, NULL, 1618, 10, 20, '1618-10-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3268);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (465, 4, NULL, 1619, 3, 13, '1619-03-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3274);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (466, 4, NULL, 1619, 7, 23, '1619-07-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3270);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (467, 4, NULL, 1619, 8, 13, '1619-08-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3266);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (468, 4, NULL, 1631, 5, 24, '1631-05-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7645);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (469, 4, NULL, 1631, 7, 19, '1631-07-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7646);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (470, 4, NULL, 1618, 5, 28, '1618-05-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7647);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (471, 4, NULL, 1631, 4, 25, '1631-04-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7648);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (472, 4, NULL, 1633, 12, 7, '1633-12-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7823);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (473, 4, NULL, 1618, 1, 13, '1618-01-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 67);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (474, 4, NULL, 1618, 1, 19, '1618-01-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 65);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (475, 4, NULL, 1611, 7, 23, '1611-07-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4109);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (476, 4, NULL, 1612, 9, 11, '1612-09-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3284);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (477, 4, NULL, 1610, 3, 12, '1610-03-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 11);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (478, 4, NULL, 1611, 2, 11, '1611-02-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (479, 4, NULL, 1613, 7, 10, '1613-07-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3278);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (480, 4, NULL, 1614, 2, 11, '1614-02-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3280);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (481, 4, NULL, 1613, 2, 2, '1613-02-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 353);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (482, 4, NULL, 1643, 11, 1, '1643-11-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1255);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (483, 4, NULL, 1644, 11, 1, '1644-11-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1229);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (484, 4, NULL, 1644, 9, 20, '1644-09-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1185);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (485, 4, NULL, 1634, 2, 16, '1634-02-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1207);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (486, 4, NULL, 1635, 2, 26, '1635-02-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1236);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (487, 4, NULL, 1634, 9, 7, '1634-09-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1234);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (488, 4, NULL, 1639, 12, NULL, '1639-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2379);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (489, 4, NULL, 1635, 7, 7, '1635-07-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9653);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (490, 4, NULL, 1624, 9, 20, '1624-09-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9649);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (491, 4, NULL, 1644, 9, 10, '1644-09-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9762);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (492, 4, NULL, 1644, 9, 10, '1644-09-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1194);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (493, 4, NULL, 1644, 7, 8, '1644-07-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9758);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (494, 4, NULL, 1644, 7, 8, '1644-07-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1204);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (495, 4, NULL, 1644, 6, 5, '1644-06-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9760);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (496, 4, NULL, 1645, 5, 11, '1645-05-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4422);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (497, 4, NULL, 1626, 7, 11, '1626-07-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2814);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (498, 4, NULL, 1625, 4, 12, '1625-04-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2812);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (499, 4, NULL, 1647, 6, 15, '1647-06-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9638);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (500, 4, NULL, 1642, 2, 6, '1642-02-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9645);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (501, 4, NULL, 1640, 1, 2, '1640-01-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9644);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (502, 4, NULL, 1648, 4, 16, '1648-04-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9643);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (503, 4, NULL, 1648, 2, 7, '1648-02-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 259);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (504, 4, NULL, 1631, 9, NULL, '1631-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 280);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (505, 4, NULL, 1637, 5, 17, '1637-05-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 262);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (506, 4, NULL, 1638, 4, NULL, '1638-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 281);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (507, 4, NULL, 1639, 11, 26, '1639-11-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 123);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (508, 4, NULL, 1639, 1, 9, '1639-01-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 274);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (509, 4, NULL, 1642, 9, 7, '1642-09-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2381);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (510, 4, NULL, 1642, 9, 7, '1642-09-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 261);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (511, 4, NULL, 1646, 11, 2, '1646-11-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 121);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (512, 4, NULL, 1646, 6, 15, '1646-06-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 282);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (513, 4, NULL, 1646, 3, 30, '1646-03-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 143);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (514, 4, NULL, 1646, 5, 15, '1646-05-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 283);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (515, 4, NULL, 1630, 12, 2, '1630-12-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 127);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (516, 4, NULL, 1638, 6, 29, '1638-06-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 340);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (517, 4, NULL, 1638, 3, 1, '1638-03-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 248);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (518, 4, NULL, 1646, 3, 2, '1646-03-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 284);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (519, 4, NULL, 1640, 11, 11, '1640-11-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 141);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (520, 4, NULL, 1638, 1, 25, '1638-01-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 285);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (521, 4, NULL, 1642, 4, 26, '1642-04-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 145);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (522, 4, NULL, 1638, 5, 27, '1638-05-27', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 117);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (523, 4, NULL, 1637, 3, 3, '1637-03-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 137);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (524, 4, NULL, 1637, 6, 8, '1637-06-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 286);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (525, 4, NULL, 1638, 4, 3, '1638-04-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 167);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (526, 4, NULL, 1646, 3, 11, '1646-03-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 287);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (527, 4, NULL, 1640, 3, 12, '1640-03-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 172);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (528, 4, NULL, 1643, 1, 14, '1643-01-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 249);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (529, 4, NULL, 1641, 1, 16, '1641-01-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 288);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (530, 4, NULL, 1643, 2, 18, '1643-02-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 171);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (531, 4, NULL, 1643, 11, 2, '1643-11-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 260);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (532, 4, NULL, 1637, 4, 20, '1637-04-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 289);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (533, 4, NULL, 1637, 5, 20, '1637-05-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 173);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (534, 4, NULL, 1642, 1, 22, '1642-01-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 174);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (535, 4, NULL, 1643, 5, 22, '1643-05-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 290);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (536, 4, NULL, 1637, 3, 22, '1637-03-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 170);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (537, 4, NULL, 1643, 5, 24, '1643-05-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 175);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (538, 4, NULL, 1637, 2, 25, '1637-02-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 291);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (539, 4, NULL, 1642, 4, 26, '1642-04-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 177);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (540, 4, NULL, 1644, 2, 26, '1644-02-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 176);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (541, 4, NULL, 1643, 6, 26, '1643-06-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 292);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (542, 4, NULL, 1641, 7, 29, '1641-07-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 169);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (543, 4, NULL, 1646, 11, 30, '1646-11-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 179);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (544, 4, NULL, 1642, 1, 31, '1642-01-31', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 293);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (545, 4, NULL, 1645, 8, 4, '1645-08-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 180);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (546, 4, NULL, 1643, 1, 5, '1643-01-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 178);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (547, 4, NULL, 1647, 12, 8, '1647-12-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 294);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (548, 4, NULL, 1639, 4, 30, '1639-04-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 181);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (549, 4, NULL, 1639, 4, 30, '1639-04-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 295);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (550, 4, NULL, 1641, 7, 22, '1641-07-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9797);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (551, 4, NULL, 1641, 7, 22, '1641-07-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 184);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (552, 4, NULL, 1630, 12, 2, '1630-12-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 182);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (553, 4, NULL, 1640, 1, 29, '1640-01-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 183);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (554, 4, NULL, 1640, 10, 28, '1640-10-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 296);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (555, 4, NULL, 1642, 3, NULL, '1642-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 185);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (556, 4, NULL, 1641, 2, 18, '1641-02-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 297);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (557, 4, NULL, 1641, 1, 21, '1641-01-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 341);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (558, 4, NULL, 1641, 4, 21, '1641-04-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 168);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (559, 4, NULL, 1640, 7, 29, '1640-07-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 298);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (560, 4, NULL, 1629, 11, 13, '1629-11-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 191);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (561, 4, NULL, 1632, 6, NULL, '1632-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 299);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (562, 4, NULL, 1632, 5, 10, '1632-05-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 192);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (563, 4, NULL, 1640, 12, 10, '1640-12-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 342);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (564, 4, NULL, 1631, 1, 13, '1631-01-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 190);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (565, 4, NULL, 1638, 7, 13, '1638-07-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 300);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (566, 4, NULL, 1639, 11, 13, '1639-11-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 193);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (567, 4, NULL, 1642, 10, 13, '1642-10-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 301);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (568, 4, NULL, 1630, 10, 14, '1630-10-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 194);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (569, 4, NULL, 1630, 4, 15, '1630-04-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 195);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (570, 4, NULL, 1647, 3, 15, '1647-03-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 196);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (571, 4, NULL, 1634, 9, 15, '1634-09-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 302);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (572, 4, NULL, 1641, 6, 16, '1641-06-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 197);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (573, 4, NULL, 1635, NULL, NULL, '1635', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 303);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (574, 4, NULL, 1635, NULL, NULL, '1635', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 200);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (575, 4, NULL, 1638, 5, 17, '1638-05-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 201);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (576, 4, NULL, 1630, 3, 18, '1630-03-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 199);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (577, 4, NULL, 1640, 4, 1, '1640-04-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 160);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (578, 4, NULL, 1638, 3, 1, '1638-03-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 304);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (579, 4, NULL, 1630, 12, 2, '1630-12-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 202);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (580, 4, NULL, 1629, 11, 20, '1629-11-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 305);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (581, 4, NULL, 1641, 1, 21, '1641-01-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 204);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (582, 4, NULL, 1641, 12, 22, '1641-12-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 203);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (583, 4, NULL, 1640, 7, 22, '1640-07-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 306);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (584, 4, NULL, 1641, 7, 22, '1641-07-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 198);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (585, 4, NULL, 1630, 12, 23, '1630-12-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 189);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (586, 4, NULL, 1640, 12, 24, '1640-12-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 187);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (587, 4, NULL, 1638, 1, 25, '1638-01-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 307);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (588, 4, NULL, 1647, 1, 25, '1647-01-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 206);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (589, 4, NULL, 1630, 11, 25, '1630-11-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 208);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (590, 4, NULL, 1641, 1, 28, '1641-01-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 308);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (591, 4, NULL, 1633, 11, 28, '1633-11-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 207);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (592, 4, NULL, 1630, 8, 15, '1630-08-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 210);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (593, 4, NULL, 1637, 6, 15, '1637-06-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 309);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (594, 4, NULL, 1638, 6, 3, '1638-06-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 209);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (595, 4, NULL, 1632, 5, 3, '1632-05-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 211);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (596, 4, NULL, 1640, 7, 30, '1640-07-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 310);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (597, 4, NULL, 1640, 12, 31, '1640-12-31', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 279);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (598, 4, NULL, 1630, 3, 4, '1630-03-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 212);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (599, 4, NULL, 1632, 4, 5, '1632-04-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 311);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (600, 4, NULL, 1638, 12, 5, '1638-12-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 215);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (601, 4, NULL, 1637, 10, 5, '1637-10-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 213);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (602, 4, NULL, 1637, 10, 5, '1637-10-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 312);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (603, 4, NULL, 1637, 6, 6, '1637-06-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 216);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (604, 4, NULL, 1630, 5, 6, '1630-05-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 214);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (605, 4, NULL, 1642, 9, 8, '1642-09-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 313);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (606, 4, NULL, 1629, 8, NULL, '1629-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 205);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (607, 4, NULL, 1634, 2, NULL, '1634-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 218);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (608, 4, NULL, 1625, NULL, NULL, '1625', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 314);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (609, 4, NULL, 1632, 7, NULL, '1632-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 220);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (610, 4, NULL, 1637, 12, NULL, '1637-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 315);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (611, 4, NULL, 1626, 2, NULL, '1626-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 219);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (612, 4, NULL, 1634, 2, NULL, '1634-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 217);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (613, 4, NULL, 1638, 1, NULL, '1638-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 221);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (614, 4, NULL, 1638, 1, NULL, '1638-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 316);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (615, 4, NULL, 1641, 7, NULL, '1641-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 222);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (616, 4, NULL, 1648, 7, 6, '1648-07-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 317);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (617, 4, NULL, 1635, 3, NULL, '1635-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 278);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (618, 4, NULL, 1636, 3, NULL, '1636-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 223);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (619, 4, NULL, 1630, 1, NULL, '1630-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 225);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (620, 4, NULL, 1632, 12, 11, '1632-12-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 318);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (621, 4, NULL, 1631, 11, 10, '1631-11-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 224);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (622, 4, NULL, 1641, 9, NULL, '1641-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 319);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (623, 4, NULL, 1647, 9, NULL, '1647-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 227);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (624, 4, NULL, 1637, 5, 17, '1637-05-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 226);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (625, 4, NULL, 1637, 5, 17, '1637-05-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 228);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (626, 4, NULL, 1634, 5, 1, '1634-05-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 320);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (627, 4, NULL, 1637, 4, 20, '1637-04-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 231);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (628, 4, NULL, 1630, 9, 20, '1630-09-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 321);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (629, 4, NULL, 1646, 3, 10, '1646-03-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 230);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (630, 4, NULL, 1646, 3, 10, '1646-03-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 276);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (631, 4, NULL, 1643, 12, 11, '1643-12-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 232);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (632, 4, NULL, 1640, 6, 11, '1640-06-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 235);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (633, 4, NULL, 1640, 3, 11, '1640-03-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 233);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (634, 4, NULL, 1640, 11, 11, '1640-11-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 234);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (635, 4, NULL, 1640, 11, 11, '1640-11-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 229);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (636, 4, NULL, 1639, 10, 16, '1639-10-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 323);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (637, 4, NULL, 1641, 11, 17, '1641-11-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 269);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (638, 4, NULL, 1638, 9, 12, '1638-09-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 264);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (639, 4, NULL, 1647, 12, 13, '1647-12-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 266);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (640, 4, NULL, 1646, 12, 14, '1646-12-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 322);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (641, 4, NULL, 1640, 9, 15, '1640-09-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 265);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (642, 4, NULL, 1642, 11, 17, '1642-11-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 267);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (643, 4, NULL, 1629, 12, 18, '1629-12-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 270);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (644, 4, NULL, 1641, 3, 18, '1641-03-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 324);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (645, 4, NULL, 1640, 11, 18, '1640-11-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 268);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (646, 4, NULL, 1642, 1, 19, '1642-01-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 325);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (647, 4, NULL, 1639, 6, 19, '1639-06-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 258);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (648, 4, NULL, 1646, 11, 2, '1646-11-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 271);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (649, 4, NULL, 1646, 11, 2, '1646-11-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 273);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (650, 4, NULL, 1646, 4, 20, '1646-04-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 272);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (651, 4, NULL, 1646, 4, 20, '1646-04-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 326);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (652, 4, NULL, 1642, 10, 20, '1642-10-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 263);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (653, 4, NULL, 1641, 4, 21, '1641-04-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 327);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (654, 4, NULL, 1641, 12, 22, '1641-12-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 277);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (655, 4, NULL, 1633, 7, 22, '1633-07-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 238);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (656, 4, NULL, 1643, 2, 23, '1643-02-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 236);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (657, 4, NULL, 1641, 6, 23, '1641-06-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 328);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (658, 4, NULL, 1643, 3, 23, '1643-03-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 239);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (659, 4, NULL, 1646, 11, 23, '1646-11-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 329);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (660, 4, NULL, 1639, 12, 25, '1639-12-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 240);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (661, 4, NULL, 1630, 2, 25, '1630-02-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 243);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (662, 4, NULL, 1643, 4, 26, '1643-04-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 330);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (663, 4, NULL, 1643, 4, 26, '1643-04-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 241);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (664, 4, NULL, 1647, 4, 26, '1647-04-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 244);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (665, 4, NULL, 1639, 8, 27, '1639-08-27', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 331);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (666, 4, NULL, 1640, 10, 28, '1640-10-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 242);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (667, 4, NULL, 1640, 1, 29, '1640-01-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 247);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (668, 4, NULL, 1640, 12, 3, '1640-12-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 332);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (669, 4, NULL, 1630, 6, 3, '1630-06-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 246);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (670, 4, NULL, 1638, 5, 3, '1638-05-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 245);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (671, 4, NULL, 1640, 8, 30, '1640-08-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 333);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (672, 4, NULL, 1639, 4, 30, '1639-04-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 237);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (673, 4, NULL, 1640, 7, 30, '1640-07-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 188);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (674, 4, NULL, 1643, 5, 30, '1643-05-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 334);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (675, 4, NULL, 1640, 9, 30, '1640-09-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 352);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (676, 4, NULL, 1648, 1, 31, '1648-01-31', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 251);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (677, 4, NULL, 1638, 3, 31, '1638-03-31', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 335);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (678, 4, NULL, 1648, 4, 4, '1648-04-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 250);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (679, 4, NULL, 1643, 1, 4, '1643-01-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 252);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (680, 4, NULL, 1641, 3, 4, '1641-03-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 336);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (681, 4, NULL, 1630, 11, 4, '1630-11-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 253);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (682, 4, NULL, 1646, 10, 5, '1646-10-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 337);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (683, 4, NULL, 1640, 8, 6, '1640-08-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 256);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (684, 4, NULL, 1642, 12, 7, '1642-12-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 255);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (685, 4, NULL, 1646, 9, 7, '1646-09-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 254);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (686, 4, NULL, 1629, 10, 8, '1629-10-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 338);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (687, 4, NULL, 1639, 1, 9, '1639-01-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 257);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (688, 4, NULL, 1638, 10, 11, '1638-10-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 339);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (689, 4, NULL, 1626, NULL, NULL, '1626', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 151);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (690, 4, NULL, 1647, 11, 13, '1647-11-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 92);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (691, 4, NULL, 1648, 1, 14, '1648-01-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 101);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (692, 4, NULL, 1647, 7, 17, '1647-07-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 105);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (693, 4, NULL, 1648, 3, 18, '1648-03-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 104);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (694, 4, NULL, 1648, 10, 21, '1648-10-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 103);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (695, 4, NULL, 1647, 7, 31, '1647-07-31', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 100);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (696, 4, NULL, 1647, 12, 4, '1647-12-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 102);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (697, 4, NULL, 1644, NULL, NULL, '1644', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 37);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (698, 4, NULL, 1644, NULL, NULL, '1644', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 35);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (699, 4, NULL, 1640, 2, 24, '1640-02-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 39);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (700, 4, NULL, 1640, 3, 15, '1640-03-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 40);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (701, 4, NULL, 1637, 10, 4, '1637-10-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (702, 4, NULL, 1628, 4, 13, '1628-04-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1262);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (703, 4, NULL, 1648, 11, 1, '1648-11-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1259);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (704, 4, NULL, 1643, 8, 9, '1643-08-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1184);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (705, 4, NULL, 1643, 8, 9, '1643-08-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 402);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (706, 4, NULL, 1646, 4, 2, '1646-04-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 404);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (707, 4, NULL, 1643, 8, 21, '1643-08-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 398);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (708, 4, NULL, 1647, 5, NULL, '1647-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8307);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (709, 4, NULL, 1647, 5, NULL, '1647-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 400);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (710, 4, NULL, 1636, 8, NULL, '1636-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 86);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (711, 4, NULL, 1636, 12, 16, '1636-12-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 90);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (712, 4, NULL, 1636, 11, 4, '1636-11-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 91);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (713, 4, NULL, 1628, 12, NULL, '1628-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1208);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (714, 4, NULL, 1645, 1, 28, '1645-01-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1264);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (715, 4, NULL, 1644, 10, 1, '1644-10-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1202);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (716, 4, NULL, 1644, 10, 15, '1644-10-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9764);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (717, 4, NULL, 1644, 10, 15, '1644-10-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1265);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (718, 4, NULL, 1644, 6, 25, '1644-06-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9766);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (719, 4, NULL, 1644, 6, 25, '1644-06-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1238);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (720, 4, NULL, 1634, 8, 29, '1634-08-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1203);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (721, 4, NULL, 1633, 4, 10, '1633-04-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1266);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (722, 4, NULL, 1633, 2, 16, '1633-02-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1221);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (723, 4, NULL, 1632, 11, 2, '1632-11-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1267);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (724, 4, NULL, 1633, 1, 20, '1633-01-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1237);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (725, 4, NULL, 1632, 11, 24, '1632-11-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1241);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (726, 4, NULL, 1633, 1, 31, '1633-01-31', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1268);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (727, 4, NULL, 1632, 5, 11, '1632-05-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1142);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (728, 4, NULL, 1643, 4, 4, '1643-04-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1181);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (729, 4, NULL, 1634, 9, 8, '1634-09-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1225);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (730, 4, NULL, 1630, 11, 22, '1630-11-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1170);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (731, 4, NULL, 1648, 3, 12, '1648-03-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1186);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (732, 4, NULL, 1647, 10, 25, '1647-10-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1269);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (733, 4, NULL, 1647, 1, 26, '1647-01-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1232);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (734, 4, NULL, 1643, 8, 20, '1643-08-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1240);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (735, 4, NULL, 1643, 8, 20, '1643-08-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 406);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (736, 4, NULL, 1629, 9, 14, '1629-09-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1270);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (737, 4, NULL, 1633, 5, 17, '1633-05-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1239);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (738, 4, NULL, 1634, 8, 22, '1634-08-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1210);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (739, 4, NULL, 1634, 1, 24, '1634-01-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1271);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (740, 4, NULL, 1637, 9, 29, '1637-09-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1118);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (741, 4, NULL, 1637, 11, 3, '1637-11-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1224);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (742, 4, NULL, 1629, 3, 8, '1629-03-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1311);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (743, 4, NULL, 1630, 9, 6, '1630-09-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1146);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (744, 4, NULL, 1630, 3, 8, '1630-03-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1132);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (745, 4, NULL, 1636, 2, 29, '1636-02-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1272);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (746, 4, NULL, 1643, 8, 10, '1643-08-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1176);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (747, 4, NULL, 1631, 7, 9, '1631-07-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1273);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (748, 4, NULL, 1647, 2, 19, '1647-02-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1198);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (749, 4, NULL, 1643, 9, 11, '1643-09-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1138);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (750, 4, NULL, 1642, 8, 15, '1642-08-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1312);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (751, 4, NULL, 1641, 3, 15, '1641-03-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1274);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (752, 4, NULL, 1641, 5, 17, '1641-05-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1260);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (753, 4, NULL, 1641, 7, 19, '1641-07-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1222);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (754, 4, NULL, 1643, 7, 24, '1643-07-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1192);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (755, 4, NULL, 1642, 7, 25, '1642-07-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1256);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (756, 4, NULL, 1648, 9, 25, '1648-09-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1258);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (757, 4, NULL, 1647, 7, 26, '1647-07-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1275);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (758, 4, NULL, 1644, 10, 28, '1644-10-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1172);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (759, 4, NULL, 1644, 1, 29, '1644-01-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1276);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (760, 4, NULL, 1641, 5, 3, '1641-05-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1136);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (761, 4, NULL, 1648, 9, 4, '1648-09-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1134);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (762, 4, NULL, 1644, 2, 5, '1644-02-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1313);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (763, 4, NULL, 1648, 6, 5, '1648-06-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1180);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (764, 4, NULL, 1634, 1, 29, '1634-01-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1277);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (765, 4, NULL, 1643, 1, 11, '1643-01-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1168);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (766, 4, NULL, 1635, 12, 13, '1635-12-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1278);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (767, 4, NULL, 1643, 1, 13, '1643-01-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1140);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (768, 4, NULL, 1635, 11, 2, '1635-11-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1223);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (769, 4, NULL, 1629, 2, 4, '1629-02-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1209);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (770, 4, NULL, 1646, 10, NULL, '1646-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1280);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (771, 4, NULL, 1630, 6, 16, '1630-06-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1166);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (772, 4, NULL, 1630, 3, 23, '1630-03-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1214);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (773, 4, NULL, 1635, 12, 15, '1635-12-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1254);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (774, 4, NULL, 1633, 8, 18, '1633-08-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1150);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (775, 4, NULL, 1628, 12, 2, '1628-12-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1251);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (776, 4, NULL, 1629, 7, 21, '1629-07-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1281);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (777, 4, NULL, 1630, 7, 21, '1630-07-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1148);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (778, 4, NULL, 1629, 8, 28, '1629-08-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1212);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (779, 4, NULL, 1631, 4, 28, '1631-04-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1187);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (780, 4, NULL, 1635, 11, 30, '1635-11-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1252);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (781, 4, NULL, 1635, 12, 8, '1635-12-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1164);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (782, 4, NULL, 1634, 3, 9, '1634-03-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1152);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (783, 4, NULL, 1641, 5, 16, '1641-05-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1282);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (784, 4, NULL, 1641, 5, 16, '1641-05-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 275);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (785, 4, NULL, 1647, 12, 13, '1647-12-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1247);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (786, 4, NULL, 1647, 2, 3, '1647-02-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1283);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (787, 4, NULL, 1630, 3, 12, '1630-03-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1250);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (788, 4, NULL, 1640, 7, 3, '1640-07-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3418);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (789, 4, NULL, 1640, 7, 3, '1640-07-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1154);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (790, 4, NULL, 1631, 1, 30, '1631-01-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1285);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (791, 4, NULL, 1641, 4, 8, '1641-04-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9250);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (792, 4, NULL, 1644, 2, 20, '1644-02-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9252);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (793, 4, NULL, 1644, 2, 20, '1644-02-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1174);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (794, 4, NULL, 1646, 11, 15, '1646-11-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1178);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (795, 4, NULL, 1649, 1, 20, '1649-01-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1156);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (796, 4, NULL, 1647, 8, 31, '1647-08-31', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1286);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (797, 4, NULL, 1647, 7, 5, '1647-07-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1197);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (798, 4, NULL, 1639, 11, NULL, '1639-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9641);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (799, 4, NULL, 1640, 3, 1, '1640-03-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9642);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (800, 4, NULL, 1640, 12, 7, '1640-12-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9640);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (801, 4, NULL, 1640, 8, 14, '1640-08-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 343);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (802, 4, NULL, 1647, 11, 14, '1647-11-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 155);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (803, 4, NULL, 1644, 2, 15, '1644-02-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 344);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (804, 4, NULL, 1641, 1, 15, '1641-01-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 159);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (805, 4, NULL, 1641, 7, 17, '1641-07-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 153);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (806, 4, NULL, 1637, 9, 18, '1637-09-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 345);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (807, 4, NULL, 1637, 3, 1, '1637-03-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 147);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (808, 4, NULL, 1643, 11, 2, '1643-11-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 346);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (809, 4, NULL, 1637, 3, 24, '1637-03-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 129);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (810, 4, NULL, 1637, 2, 25, '1637-02-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 163);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (811, 4, NULL, 1642, 1, 25, '1642-01-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 347);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (812, 4, NULL, 1642, 5, 26, '1642-05-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 162);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (813, 4, NULL, 1642, 4, 27, '1642-04-27', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 165);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (814, 4, NULL, 1640, 4, 29, '1640-04-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 348);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (815, 4, NULL, 1640, 10, 29, '1640-10-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 166);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (816, 4, NULL, 1637, 6, 2, '1637-06-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 164);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (817, 4, NULL, 1646, 2, 5, '1646-02-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 349);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (818, 4, NULL, 1637, 1, 5, '1637-01-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 186);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (819, 4, NULL, 1643, 6, 6, '1643-06-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 350);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (820, 4, NULL, 1643, 1, 7, '1643-01-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 125);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (821, 4, NULL, 1647, 1, 7, '1647-01-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 131);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (822, 4, NULL, 1640, 3, 8, '1640-03-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 351);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (823, 4, NULL, 1640, 10, 8, '1640-10-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 161);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (824, 4, NULL, 1629, 11, 6, '1629-11-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3288);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (825, 4, NULL, 1648, 3, 10, '1648-03-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3415);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (826, 4, NULL, 1639, 6, 2, '1639-06-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3417);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (827, 4, NULL, 1639, 6, 2, '1639-06-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1205);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (828, 4, NULL, 1634, 9, 23, '1634-09-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3419);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (829, 4, NULL, 1634, 9, 23, '1634-09-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1162);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (830, 4, NULL, 1647, 1, 16, '1647-01-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1246);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (831, 4, NULL, 1647, 3, 19, '1647-03-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1253);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (832, 4, NULL, 1646, 11, 24, '1646-11-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1289);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (833, 4, NULL, 1633, 4, 20, '1633-04-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1226);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (834, 4, NULL, 1633, 6, 4, '1633-06-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1290);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (835, 4, NULL, 1638, 2, 22, '1638-02-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 149);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (836, 4, NULL, 1648, 4, 14, '1648-04-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4522);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (837, 4, NULL, 1647, 11, 5, '1647-11-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4524);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (838, 4, NULL, 1647, 11, 5, '1647-11-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 89);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (839, 4, NULL, 1648, 7, 17, '1648-07-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4565);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (840, 4, NULL, 1647, 2, 4, '1647-02-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4563);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (841, 4, NULL, 1640, 1, 20, '1640-01-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3413);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (842, 4, NULL, 1646, 9, 22, '1646-09-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3420);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (843, 4, NULL, 1625, NULL, NULL, '1625', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7423);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (844, 4, NULL, 1642, 12, 13, '1642-12-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1391);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (845, 4, NULL, 1648, 4, 19, '1648-04-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9646);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (846, 4, NULL, 1639, 11, 1, '1639-11-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9639);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (847, 4, NULL, 1640, 11, 22, '1640-11-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9647);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (848, 4, NULL, 1639, 10, 15, '1639-10-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2292);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (849, 4, NULL, 1645, 10, 5, '1645-10-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7697);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (850, 4, NULL, 1635, 11, 15, '1635-11-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1189);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (851, 4, NULL, 1635, 11, 17, '1635-11-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1294);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (852, 4, NULL, 1636, 1, 1, '1636-01-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1144);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (853, 4, NULL, 1633, 1, 5, '1633-01-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1158);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (854, 4, NULL, 1638, 4, 28, '1638-04-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 133);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (855, 4, NULL, 1637, 2, 15, '1637-02-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 119);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (856, 4, NULL, 1644, NULL, NULL, '1644', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 354);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (857, 4, NULL, 1638, 8, 1, '1638-08-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 111);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (858, 4, NULL, 1646, 3, 22, '1646-03-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 113);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (859, 4, NULL, 1646, 5, 1, '1646-05-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8308);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (860, 4, NULL, 1647, 10, 1, '1647-10-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8305);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (861, 4, NULL, 1625, NULL, NULL, '1625', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 135);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (862, 4, NULL, 1626, 3, 2, '1626-03-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 115);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (863, 4, NULL, 1633, 9, 22, '1633-09-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1295);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (864, 4, NULL, 1630, 10, 31, '1630-10-31', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1183);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (865, 4, NULL, 1632, 3, 6, '1632-03-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1182);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (866, 4, NULL, 1648, 4, NULL, '1648-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5392);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (867, 4, NULL, 1633, 9, 10, '1633-09-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1297);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (868, 4, NULL, 1633, 6, 11, '1633-06-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1298);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (869, 4, NULL, 1635, 6, 2, '1635-06-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1293);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (870, 4, NULL, 1633, 3, 2, '1633-03-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1263);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (871, 4, NULL, 1633, 8, 20, '1633-08-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1291);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (872, 4, NULL, 1632, 12, 21, '1632-12-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1230);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (873, 4, NULL, 1633, 2, 22, '1633-02-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1284);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (874, 4, NULL, 1634, 2, 22, '1634-02-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1279);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (875, 4, NULL, 1635, 11, 23, '1635-11-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1228);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (876, 4, NULL, 1633, 2, 25, '1633-02-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1299);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (877, 4, NULL, 1635, 6, 27, '1635-06-27', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1199);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (878, 4, NULL, 1635, 12, 3, '1635-12-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1288);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (879, 4, NULL, 1635, 6, 3, '1635-06-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1300);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (880, 4, NULL, 1633, 2, 4, '1633-02-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1302);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (881, 4, NULL, 1635, 11, 5, '1635-11-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1233);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (882, 4, NULL, 1636, 1, 9, '1636-01-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1301);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (883, 4, NULL, 1646, 11, 19, '1646-11-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6157);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (884, 4, NULL, 1639, NULL, NULL, '1639', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6159);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (885, 4, NULL, 1634, 8, 29, '1634-08-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1193);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (886, 4, NULL, 1636, 4, 8, '1636-04-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1188);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (887, 4, NULL, 1636, 1, 12, '1636-01-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1304);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (888, 4, NULL, 1640, 5, 6, '1640-05-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7652);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (889, 4, NULL, 1648, 4, 29, '1648-04-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7628);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (890, 4, NULL, 1630, 11, 26, '1630-11-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1190);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (891, 4, NULL, 1642, 1, 6, '1642-01-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7654);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (892, 4, NULL, 1648, 3, 6, '1648-03-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7685);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (893, 4, NULL, 1646, 3, NULL, '1646-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7687);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (894, 4, NULL, 1645, 2, 12, '1645-02-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7706);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (895, 4, NULL, 1645, 3, 12, '1645-03-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7686);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (896, 4, NULL, 1645, 2, 18, '1645-02-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7703);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (897, 4, NULL, 1645, 6, 18, '1645-06-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7688);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (898, 4, NULL, 1647, 5, 18, '1647-05-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7690);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (899, 4, NULL, 1645, 3, 19, '1645-03-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7689);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (900, 4, NULL, 1647, 7, 1, '1647-07-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7707);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (901, 4, NULL, 1645, 4, 2, '1645-04-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7692);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (902, 4, NULL, 1645, 8, 20, '1645-08-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7708);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (903, 4, NULL, 1644, 12, 24, '1644-12-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7683);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (904, 4, NULL, 1645, 9, 24, '1645-09-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7680);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (905, 4, NULL, 1645, 2, 25, '1645-02-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7693);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (906, 4, NULL, 1645, 2, 26, '1645-02-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7709);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (907, 4, NULL, 1645, 3, 26, '1645-03-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7695);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (908, 4, NULL, 1645, 1, 28, '1645-01-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7702);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (909, 4, NULL, 1645, 4, 30, '1645-04-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7694);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (910, 4, NULL, 1644, 12, 31, '1644-12-31', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7678);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (911, 4, NULL, 1645, 2, 4, '1645-02-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7696);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (912, 4, NULL, 1645, 3, 5, '1645-03-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7673);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (913, 4, NULL, 1645, 1, 7, '1645-01-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7700);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (914, 4, NULL, 1647, 9, 7, '1647-09-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7675);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (915, 4, NULL, 1645, 6, 8, '1645-06-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7677);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (916, 4, NULL, 1645, 4, 9, '1645-04-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7699);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (917, 4, NULL, 1644, 12, 9, '1644-12-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7698);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (918, 4, NULL, 1646, 5, 30, '1646-05-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6450);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (919, 4, NULL, 1647, 4, 5, '1647-04-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6449);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (920, 4, NULL, 1646, 11, 6, '1646-11-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6447);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (921, 4, NULL, 1645, 1, 2, '1645-01-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1200);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (922, 4, NULL, 1646, 5, 15, '1646-05-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 95);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (923, 4, NULL, 1646, 9, NULL, '1646-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 139);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (924, 4, NULL, 1646, 9, NULL, '1646-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 88);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (925, 4, NULL, 1647, 9, 20, '1647-09-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 99);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (926, 4, NULL, 1645, 10, 20, '1645-10-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 87);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (927, 4, NULL, 1638, 4, 15, '1638-04-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 84);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (928, 4, NULL, 1643, 12, NULL, '1643-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 94);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (929, 4, NULL, 1643, 7, NULL, '1643-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 93);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (930, 4, NULL, 1645, 11, 1, '1645-11-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 106);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (931, 4, NULL, 1646, 2, 26, '1646-02-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 98);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (932, 4, NULL, 1637, 1, 6, '1637-01-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 97);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (933, 4, NULL, 1646, 2, 1, '1646-02-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 96);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (934, 4, NULL, 1638, 6, 1, '1638-06-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 82);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (935, 4, NULL, 1647, NULL, NULL, '1647', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 80);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (936, 4, NULL, 1638, 4, 15, '1638-04-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 157);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (937, 4, NULL, 1638, 4, 15, '1638-04-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 78);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (938, 4, NULL, 1647, 12, 11, '1647-12-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9260);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (939, 4, NULL, 1646, 10, NULL, '1646-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4113);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (940, 4, NULL, 1646, 5, 9, '1646-05-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4111);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (941, 4, NULL, 1644, 5, 10, '1644-05-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1292);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (942, 4, NULL, 1643, 10, 15, '1643-10-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1305);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (943, 4, NULL, 1644, 4, 18, '1644-04-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1227);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (944, 4, NULL, 1646, 9, 1, '1646-09-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1257);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (945, 4, NULL, 1643, 12, 23, '1643-12-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1306);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (946, 4, NULL, 1643, 5, 6, '1643-05-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1195);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (947, 4, NULL, 1642, 6, 8, '1642-06-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1307);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (948, 4, NULL, 1646, 2, 10, '1646-02-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7710);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (949, 4, NULL, 1645, 2, 11, '1645-02-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7701);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (950, 4, NULL, 1645, 3, 11, '1645-03-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7711);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (951, 4, NULL, 1645, 8, 12, '1645-08-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7679);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (952, 4, NULL, 1644, 12, 17, '1644-12-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7712);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (953, 4, NULL, 1645, 1, 17, '1645-01-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7713);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (954, 4, NULL, 1646, 3, 17, '1646-03-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7704);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (955, 4, NULL, 1647, 7, 20, '1647-07-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7682);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (956, 4, NULL, 1647, 6, 22, '1647-06-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7684);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (957, 4, NULL, 1647, 8, 24, '1647-08-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7681);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (958, 4, NULL, 1645, 2, 25, '1645-02-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7705);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (959, 4, NULL, 1646, 4, 7, '1646-04-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7691);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (960, 4, NULL, 1643, 10, 1, '1643-10-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 107);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (961, 4, NULL, 1646, 7, 7, '1646-07-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 108);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (962, 4, NULL, 1648, 9, 15, '1648-09-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1308);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (963, 4, NULL, 1644, 10, 18, '1644-10-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1231);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (964, 4, NULL, 1642, 8, 4, '1642-08-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1206);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (965, 4, NULL, 1644, 11, 8, '1644-11-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1287);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (966, 4, NULL, 1635, 7, 15, '1635-07-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1309);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (967, 4, NULL, 1634, 9, 15, '1634-09-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1310);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (968, 4, NULL, 1634, 6, 2, '1634-06-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1249);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (969, 4, NULL, 1633, 12, 5, '1633-12-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1196);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (970, 4, NULL, 1631, 1, 11, '1631-01-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9292);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (971, 4, NULL, 1631, 2, 14, '1631-02-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9296);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (972, 4, NULL, 1631, 1, 15, '1631-01-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9293);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (973, 4, NULL, 1630, 12, 19, '1630-12-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9301);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (974, 4, NULL, 1631, 3, 1, '1631-03-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9294);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (975, 4, NULL, 1631, 2, 21, '1631-02-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9289);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (976, 4, NULL, 1631, 7, 21, '1631-07-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9302);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (977, 4, NULL, 1630, 9, 26, '1630-09-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9291);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (978, 4, NULL, 1631, 3, 29, '1631-03-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9297);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (979, 4, NULL, 1631, 1, 30, '1631-01-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9300);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (980, 4, NULL, 1631, 2, 6, '1631-02-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9298);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (981, 4, NULL, 1631, 3, 8, '1631-03-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9299);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (982, 4, NULL, 1630, 6, NULL, '1630-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9287);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (983, 4, NULL, 1631, 6, 5, '1631-06-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9295);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (984, 4, NULL, 1640, 1, 14, '1640-01-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8386);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (985, 4, NULL, 1640, 10, NULL, '1640-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1390);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (986, 4, NULL, 1640, 1, 26, '1640-01-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1393);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (987, 4, NULL, 1639, 6, 8, '1639-06-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1392);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (988, 4, NULL, 1647, 10, 18, '1647-10-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1261);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (989, 4, NULL, 1646, 10, 19, '1646-10-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1244);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (990, 4, NULL, 1646, 9, 20, '1646-09-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1245);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (991, 4, NULL, 1643, 10, 25, '1643-10-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1201);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (992, 4, NULL, 1645, 11, 26, '1645-11-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1303);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (993, 4, NULL, 1646, 28, NULL, '1646-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1296);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (994, 4, NULL, 1635, 5, 1, '1635-05-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1160);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (995, 4, NULL, 1673, NULL, NULL, '1673', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9224);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (996, 4, NULL, 1681, 9, 1, '1681-09-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9228);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (997, 4, NULL, 1681, NULL, NULL, '1681', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7508);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (998, 4, NULL, 1599, NULL, NULL, '1599', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (999, 4, NULL, 1666, NULL, NULL, '1666', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7510);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1000, 4, NULL, 1578, NULL, NULL, '1578 r', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7743);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1001, 4, NULL, 1546, NULL, NULL, '1546 r', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9600);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1002, 4, NULL, 1597, NULL, NULL, '1597 r', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5297);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1003, 4, NULL, 1564, NULL, NULL, '1564 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8854);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1004, 4, NULL, 1585, NULL, NULL, '1585', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7638);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1005, 4, NULL, 1572, NULL, NULL, '1572', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9555);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1006, 4, NULL, 1616, NULL, NULL, '1616', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9226);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1007, 4, NULL, 1596, NULL, NULL, '1596 r', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9553);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1008, 4, NULL, 1623, NULL, NULL, '1623 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7506);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1009, 4, NULL, 1582, NULL, NULL, '1582 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8884);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1010, 4, NULL, 1617, NULL, NULL, '1617 r', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8726);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1011, 4, NULL, 1664, NULL, NULL, '1664', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8724);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1012, 4, NULL, 1673, NULL, NULL, '1673', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9551);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1013, 4, NULL, 1622, NULL, NULL, '1622', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9657);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1014, 4, NULL, 1611, 4, 20, '1611-04-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1015, 4, NULL, 1611, 4, 24, '1611-04-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8953);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1016, 4, NULL, 1990, NULL, NULL, '1990', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7445);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1017, 4, NULL, 1999, NULL, NULL, '1999', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7447);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1018, 4, NULL, 1966, NULL, NULL, '1966', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7449);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1019, 4, NULL, 1925, NULL, NULL, '1925', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7451);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1020, 4, NULL, 1957, NULL, NULL, '1957', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7455);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1021, 4, NULL, 1970, NULL, NULL, '1970', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7453);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1022, 4, NULL, 2004, NULL, NULL, '2004', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7459);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1023, 4, NULL, 1995, NULL, NULL, '1995', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7461);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1024, 4, NULL, 2004, NULL, NULL, '2004', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7457);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1025, 4, NULL, 2003, NULL, NULL, '2003', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7167);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1026, 4, NULL, 1538, NULL, NULL, '1538', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 459);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1027, 4, NULL, 1662, NULL, NULL, '1662', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 809);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1028, 4, NULL, 1600, NULL, NULL, '1600', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9049);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1029, 4, NULL, 1684, NULL, NULL, '1684', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9054);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1030, 4, NULL, 1606, NULL, NULL, '1606', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 908);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1031, 4, NULL, 1664, 9, 14, '1664-09-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9008);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1032, 4, NULL, 1720, NULL, NULL, '1720', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8337);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1033, 4, NULL, 1565, NULL, NULL, '1565', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 984);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1034, 4, NULL, 1589, NULL, NULL, '1589', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1000);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1035, 4, NULL, 1694, 1, 1, '1694-01-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1021);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1036, 4, NULL, 1645, 11, 23, '1645-11-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1035);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1037, 4, NULL, 1699, NULL, NULL, '1699', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1039);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1038, 4, NULL, 1574, 12, NULL, '1574-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1073);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1039, 4, NULL, 1643, 3, 7, '1643-03-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1324);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1040, 4, NULL, 1610, NULL, NULL, '1610', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1329);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1041, 4, NULL, 1505, NULL, NULL, '1505', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 548);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1042, 4, NULL, 1627, NULL, NULL, '1627', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1369);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1043, 4, NULL, 1597, NULL, NULL, '1597', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1434);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1044, 4, NULL, 1641, NULL, NULL, '1641', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3850);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1045, 4, NULL, 1644, 7, 15, '1644-07-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1446);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1046, 4, NULL, 1651, 2, 1, '1651-02-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1456);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1047, 4, NULL, 1551, NULL, NULL, '1551', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8795);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1048, 4, NULL, 1729, NULL, NULL, '1729', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1501);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1049, 4, NULL, 1741, 7, 24, '1741-07-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1505);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1050, 4, NULL, 1641, NULL, NULL, '1641', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1516);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1051, 4, NULL, 1658, 9, 4, '1658-09-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1529);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1052, 4, NULL, 1703, NULL, NULL, '1703', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1541);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1053, 4, NULL, 1612, 4, 26, '1612-04-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1547);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1054, 4, NULL, 1638, 3, 7, '1638-03-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1550);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1055, 4, NULL, 1666, 9, 7, '1666-09-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1558);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1056, 4, NULL, 1700, 5, 9, '1700-05-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1574);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1057, 4, NULL, 1740, 4, 11, '1740-04-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1578);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1058, 4, NULL, 1599, 5, 12, '1599-05-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1591);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1059, 4, NULL, 1613, 12, 17, '1613-12-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1651);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1060, 4, NULL, 1625, 12, 20, '1625-12-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1658);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1061, 4, NULL, 1617, 3, 15, '1617-03-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1666);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1062, 4, NULL, 1599, 4, 21, '1599-04-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1728);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1063, 4, NULL, 1581, NULL, NULL, '1581', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1782);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1064, 4, NULL, 1749, NULL, NULL, '1749', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4497);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1065, 4, NULL, 1635, 4, 7, '1635-04-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1866);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1066, 4, NULL, 1668, NULL, NULL, '1668', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1870);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1067, 4, NULL, 1656, NULL, NULL, '1656', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1878);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1068, 4, NULL, 1642, 9, 20, '1642-09-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1906);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1069, 4, NULL, 1621, NULL, NULL, '1621', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1919);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1070, 4, NULL, 1595, NULL, NULL, '1595', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1926);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1071, 4, NULL, 1559, NULL, NULL, '1559', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1954);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1072, 4, NULL, 1709, 9, 26, '1709-09-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2003);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1073, 4, NULL, 1611, 7, 1, '1611-07-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9385);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1074, 4, NULL, 1589, 7, 22, '1589-07-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 802);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1075, 4, NULL, 1620, NULL, NULL, '1620 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2023);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1076, 4, NULL, 1546, NULL, NULL, '1546', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 526);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1077, 4, NULL, 1691, 7, 20, '1691-07-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2038);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1078, 4, NULL, 1635, NULL, NULL, '1635', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2074);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1079, 4, NULL, 1631, NULL, NULL, '1631', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2076);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1080, 4, NULL, 1622, 5, 16, '1622-05-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7091);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1081, 4, NULL, 1593, 7, 20, '1593-07-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2175);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1082, 4, NULL, 1575, NULL, NULL, '1575', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2205);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1083, 4, NULL, 1560, NULL, NULL, '1560', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8936);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1084, 4, NULL, 1658, 2, 2, '1658-02-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2224);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1085, 4, NULL, 1603, NULL, NULL, '1603', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2252);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1086, 4, NULL, 1707, 9, 21, '1707-09-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2307);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1087, 4, NULL, 1635, NULL, NULL, '1635', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2319);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1088, 4, NULL, 1695, NULL, NULL, '1695', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2343);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1089, 4, NULL, 1673, 7, 17, '1673-07-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2348);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1090, 4, NULL, 1618, NULL, NULL, '1618', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2367);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1091, 4, NULL, 1605, 1, 30, '1605-01-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 503);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1092, 4, NULL, 1589, NULL, NULL, '1589', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2446);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1093, 4, NULL, 1566, NULL, NULL, '1566', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2457);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1094, 4, NULL, 1679, 9, 9, '1679-09-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2461);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1095, 4, NULL, 1606, NULL, NULL, '1606', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2469);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1096, 4, NULL, 1582, NULL, NULL, '1582', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2487);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1097, 4, NULL, 1563, NULL, NULL, '1563', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2491);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1098, 4, NULL, 1619, NULL, NULL, '1619', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2497);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1099, 4, NULL, 1662, 9, 2, '1662-09-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2545);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1100, 4, NULL, 1673, 4, 1, '1673-04-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2551);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1101, 4, NULL, 1630, NULL, NULL, '1630', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9222);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1102, 4, NULL, 1625, NULL, NULL, '1625', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9767);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1103, 4, NULL, 1627, NULL, NULL, '1627', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2583);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1104, 4, NULL, 1520, NULL, NULL, '1520', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7117);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1105, 4, NULL, 1646, 7, 19, '1646-07-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2616);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1106, 4, NULL, 1603, NULL, NULL, '1603', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2620);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1107, 4, NULL, 1620, NULL, NULL, '1620', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2485);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1108, 4, NULL, 1705, 9, 28, '1705-09-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2677);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1109, 4, NULL, 1569, 5, 4, '1569-05-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2685);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1110, 4, NULL, 1571, NULL, NULL, '1571', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2689);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1111, 4, NULL, 1598, 2, 8, '1598-02-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2695);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1112, 4, NULL, 1622, NULL, NULL, '1622', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2746);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1113, 4, NULL, 1610, 9, 26, '1610-09-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2753);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1114, 4, NULL, 1622, NULL, NULL, '1622', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2759);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1115, 4, NULL, 1641, 10, 16, '1641-10-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2795);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1116, 4, NULL, 1625, NULL, NULL, '1625', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2803);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1117, 4, NULL, 1571, 12, 24, '1571-12-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2816);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1118, 4, NULL, 1627, NULL, NULL, '1627', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1094);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1119, 4, NULL, 1612, NULL, NULL, '1612', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2888);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1120, 4, NULL, 1571, NULL, NULL, '1571', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2909);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1121, 4, NULL, 1617, NULL, NULL, '1617', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2954);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1122, 4, NULL, 1592, 10, 15, '1592-10-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3031);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1123, 4, NULL, 1657, 2, 2, '1657-02-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3047);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1124, 4, NULL, 1510, NULL, NULL, '1510', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3065);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1125, 4, NULL, 1576, 1, 2, '1576-01-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3096);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1126, 4, NULL, 1644, 3, 17, '1644-03-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3197);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1127, 4, NULL, 1697, NULL, NULL, '1697', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1093);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1128, 4, NULL, 1667, NULL, NULL, '1667', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3313);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1129, 4, NULL, 1636, NULL, NULL, '1636', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3374);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1130, 4, NULL, 1630, NULL, NULL, '1630', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3385);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1131, 4, NULL, 1613, NULL, NULL, '1613', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3423);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1132, 4, NULL, 1580, 5, 9, '1580-05-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3435);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1133, 4, NULL, 1614, 9, 26, '1614-09-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3461);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1134, 4, NULL, 1636, NULL, NULL, '1636', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3464);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1135, 4, NULL, 1470, NULL, NULL, '1470', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3475);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1136, 4, NULL, 1617, 6, 1, '1617-06-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3507);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1137, 4, NULL, 1603, NULL, NULL, '1603', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3625);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1138, 4, NULL, 1571, NULL, NULL, '1571', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3635);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1139, 4, NULL, 1643, NULL, NULL, '1643', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3648);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1140, 4, NULL, 1566, 1, 25, '1566-01-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8990);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1141, 4, NULL, 1720, 9, 7, '1720-09-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3650);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1142, 4, NULL, 1748, 9, 26, '1748-09-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3654);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1143, 4, NULL, 1666, NULL, NULL, '1666', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3661);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1144, 4, NULL, 1636, NULL, NULL, '1636', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3669);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1145, 4, NULL, 1636, NULL, 1, '1636', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 854);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1146, 4, NULL, 1712, NULL, NULL, '1712', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 864);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1147, 4, NULL, 1610, NULL, NULL, '1610', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 870);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1148, 4, NULL, 1657, NULL, NULL, '1657', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3673);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1149, 4, NULL, 1712, 10, 7, '1712-10-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3677);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1150, 4, NULL, 1605, NULL, NULL, '1605', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 886);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1151, 4, NULL, 1600, NULL, NULL, '1600', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3684);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1152, 4, NULL, 1620, 2, 1, '1620-02-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3691);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1153, 4, NULL, 1626, NULL, NULL, '1626', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 410);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1154, 4, NULL, 1604, NULL, NULL, '1604', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3714);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1155, 4, NULL, 1641, NULL, NULL, '1641', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3735);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1156, 4, NULL, 1593, NULL, NULL, '1593', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3749);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1157, 4, NULL, 1614, NULL, NULL, '1614', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3762);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1158, 4, NULL, 1733, 6, 13, '1733-06-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3771);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1159, 4, NULL, 1603, 6, 10, '1603-06-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3778);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1160, 4, NULL, 1662, NULL, NULL, '1662', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3789);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1161, 4, NULL, 1623, NULL, NULL, '1623', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3857);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1162, 4, NULL, 1591, NULL, NULL, '1591', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3867);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1163, 4, NULL, 1631, NULL, NULL, '1631', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3893);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1164, 4, NULL, 1655, NULL, NULL, '1655', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3927);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1165, 4, NULL, 1641, NULL, NULL, '1641', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3931);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1166, 4, NULL, 1703, 5, 12, '1703-05-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3939);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1167, 4, NULL, 1628, 10, 15, '1628-10-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3953);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1168, 4, NULL, 1621, NULL, NULL, '1621', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3957);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1169, 4, NULL, 1615, NULL, NULL, '1615', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3980);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1170, 4, NULL, 1558, 4, 25, '1558-04-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3999);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1171, 4, NULL, 1643, 3, 3, '1643-03-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4056);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1172, 4, NULL, 1668, NULL, NULL, '1668', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4068);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1173, 4, NULL, 1657, NULL, NULL, '1657', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4074);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1174, 4, NULL, 1680, NULL, NULL, '1680', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4076);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1175, 4, NULL, 1619, 5, 30, '1619-05-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4082);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1176, 4, NULL, 1586, NULL, NULL, '1586', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4093);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1177, 4, NULL, 1602, 1, 21, '1602-01-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4106);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1178, 4, NULL, 1649, NULL, NULL, '1649', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 807);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1179, 4, NULL, 1699, NULL, NULL, '1699', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 805);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1180, 4, NULL, 1558, NULL, NULL, '1558', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9011);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1181, 4, NULL, 1613, NULL, NULL, '1613', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9012);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1182, 4, NULL, 1671, 10, 26, '1671-10-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9020);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1183, 4, NULL, 1600, NULL, NULL, '1600', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9018);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1184, 4, NULL, 1684, NULL, NULL, '1684', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9027);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1185, 4, NULL, 1692, NULL, NULL, '1692', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9030);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1186, 4, NULL, 1705, 2, 9, '1705-02-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9037);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1187, 4, NULL, 1593, NULL, NULL, '1593', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9043);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1188, 4, NULL, 1634, NULL, NULL, '1634', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9041);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1189, 4, NULL, 1727, NULL, NULL, '1727', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9055);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1190, 4, NULL, 1573, NULL, NULL, '1573', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 910);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1191, 4, NULL, 1640, NULL, NULL, '1640', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 906);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1192, 4, NULL, 1648, 12, 24, '1648-12-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9005);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1193, 4, NULL, 1733, 4, 3, '1733-04-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9006);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1194, 4, NULL, 1470, NULL, NULL, '1470', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 461);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1195, 4, NULL, 1500, NULL, NULL, '1500', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 947);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1196, 4, NULL, 1563, NULL, NULL, '1563', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 949);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1197, 4, NULL, 1639, NULL, NULL, '1639', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 958);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1198, 4, NULL, 1723, NULL, NULL, '1723', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 954);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1199, 4, NULL, 1712, 8, 10, '1712-08-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 971);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1200, 4, NULL, 1773, NULL, NULL, '1773', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 969);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1201, 4, NULL, 1594, NULL, NULL, '1594', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 977);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1202, 4, NULL, 1638, 8, 22, '1638-08-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 973);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1203, 4, NULL, 1550, NULL, NULL, '1550', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 986);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1204, 4, NULL, 1603, NULL, NULL, '1603', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 988);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1205, 4, NULL, 1720, 7, 19, '1720-07-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 990);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1206, 4, NULL, 1568, NULL, NULL, '1568', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 998);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1207, 4, NULL, 1625, NULL, NULL, '1625', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 996);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1208, 4, NULL, 1585, NULL, NULL, '1585', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8328);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1209, 4, NULL, 1619, NULL, NULL, '1619', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8327);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1210, 4, NULL, 1712, NULL, NULL, '1712', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1019);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1211, 4, NULL, 1679, 3, 9, '1679-03-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1023);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1212, 4, NULL, 1752, 3, 19, '1752-03-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1024);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1213, 4, NULL, 1689, 10, 22, '1689-10-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1037);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1214, 4, NULL, 1686, NULL, NULL, '1686', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1041);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1215, 4, NULL, 1745, NULL, NULL, '1745', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1043);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1216, 4, NULL, 1549, NULL, NULL, '1549', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1047);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1217, 4, NULL, 1604, NULL, NULL, '1604', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1049);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1218, 4, NULL, 1559, NULL, NULL, '1559', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1069);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1219, 4, NULL, 1624, 7, 15, '1624-07-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1071);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1220, 4, NULL, 1596, NULL, NULL, '1596', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1082);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1221, 4, NULL, 1664, NULL, NULL, '1664', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1084);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1222, 4, NULL, 1507, NULL, NULL, '1507', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1104);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1223, 4, NULL, 1584, NULL, NULL, '1584', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1106);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1224, 4, NULL, 1608, NULL, NULL, '1608', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1317);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1225, 4, NULL, 1697, NULL, NULL, '1697', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1318);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1226, 4, NULL, 1628, 12, 5, '1628-12-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1326);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1227, 4, NULL, 1695, 9, 5, '1695-09-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1327);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1228, 4, NULL, 1588, NULL, NULL, '1588', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1338);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1229, 4, NULL, 1628, NULL, NULL, '1628', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1339);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1230, 4, NULL, 1737, NULL, NULL, '1737', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1353);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1231, 4, NULL, 1818, NULL, NULL, '1818', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1351);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1232, 4, NULL, 1486, NULL, NULL, '1486', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 550);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1233, 4, NULL, 1546, NULL, NULL, '1546', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 552);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1234, 4, NULL, 1684, NULL, NULL, '1684', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9376);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1235, 4, NULL, 1726, NULL, NULL, '1726', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9374);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1236, 4, NULL, 1612, NULL, NULL, '1612', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1365);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1237, 4, NULL, 1654, NULL, NULL, '1654', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1367);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1238, 4, NULL, 1492, NULL, NULL, '1492', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1373);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1239, 4, NULL, 1540, NULL, NULL, '1540', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1371);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1240, 4, NULL, 1589, NULL, NULL, '1589', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1386);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1241, 4, NULL, 1676, NULL, NULL, '1676', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1388);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1242, 4, NULL, 1569, NULL, NULL, '1569', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7295);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1243, 4, NULL, 1622, NULL, NULL, '1622', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7293);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1244, 4, NULL, 1590, NULL, NULL, '1590 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1397);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1245, 4, NULL, 1647, NULL, NULL, '1647', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1398);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1246, 4, NULL, 1569, NULL, NULL, '1569', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1404);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1247, 4, NULL, 1642, NULL, NULL, '1642', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1406);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1248, 4, NULL, 1590, NULL, NULL, '1590', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1411);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1249, 4, NULL, 1678, NULL, NULL, '1678', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1413);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1250, 4, NULL, 1533, NULL, NULL, '1533', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9442);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1251, 4, NULL, 1589, NULL, NULL, '1589', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9440);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1252, 4, NULL, 1579, NULL, NULL, '1579', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1436);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1253, 4, NULL, 1649, NULL, NULL, '1649', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1438);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1254, 4, NULL, 1726, 5, 14, '1726-05-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4161);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1255, 4, NULL, 1600, NULL, NULL, '1600', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4165);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1256, 4, NULL, 1631, NULL, NULL, '1631', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4169);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1257, 4, NULL, 1546, NULL, NULL, '1546', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 729);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1258, 4, NULL, 1592, NULL, NULL, '1592', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4200);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1259, 4, NULL, 1607, NULL, NULL, '1607', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4236);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1260, 4, NULL, 1589, NULL, NULL, '1589', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4240);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1261, 4, NULL, 1666, 9, 11, '1666-09-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4244);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1262, 4, NULL, 1626, 6, 4, '1626-06-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4250);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1263, 4, NULL, 1685, NULL, NULL, '1685', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9355);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1264, 4, NULL, 1650, NULL, NULL, '1650', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4258);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1265, 4, NULL, 1591, NULL, NULL, '1591', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4279);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1266, 4, NULL, 1710, 9, 29, '1710-09-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4290);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1267, 4, NULL, 1667, NULL, NULL, '1667', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 744);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1517, 4, NULL, 1642, NULL, NULL, '1642', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1840);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1268, 4, NULL, 1671, 10, 23, '1671-10-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4307);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1269, 4, NULL, 1607, 11, 1, '1607-11-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4309);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1270, 4, NULL, 1658, NULL, NULL, '1658', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4314);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1271, 4, NULL, 1594, NULL, NULL, '1594', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4321);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1272, 4, NULL, 1591, 8, 26, '1591-08-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4326);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1273, 4, NULL, 1595, 9, 12, '1595-09-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 486);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1274, 4, NULL, 1727, NULL, NULL, '1727', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4369);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1275, 4, NULL, 1657, 12, 3, '1657-12-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4382);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1276, 4, NULL, 1611, NULL, NULL, '1611', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4392);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1277, 4, NULL, 1643, NULL, NULL, '1643', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4398);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1278, 4, NULL, 1716, NULL, NULL, '1716', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4408);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1279, 4, NULL, 1674, NULL, NULL, '1674', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4415);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1280, 4, NULL, 1649, NULL, NULL, '1649', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4429);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1281, 4, NULL, 1701, NULL, NULL, '1701', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4438);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1282, 4, NULL, 1600, NULL, NULL, '1600', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4463);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1283, 4, NULL, 1609, NULL, NULL, '1609', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4470);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1284, 4, NULL, 1691, 3, 7, '1691-03-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4528);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1285, 4, NULL, 1593, NULL, NULL, '1593', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4546);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1286, 4, NULL, 1563, NULL, NULL, '1563', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 738);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1287, 4, NULL, 1570, NULL, NULL, '1570 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9111);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1288, 4, NULL, 1591, 3, 9, '1591-03-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4703);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1289, 4, NULL, 1544, NULL, NULL, '1544', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 717);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1290, 4, NULL, 1734, 2, 15, '1734-02-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4749);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1291, 4, NULL, 1575, 10, 2, '1575-10-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4764);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1292, 4, NULL, 1745, 3, 29, '1745-03-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4782);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1293, 4, NULL, 1627, NULL, NULL, '1627', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4800);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1294, 4, NULL, 1610, NULL, NULL, '1610', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4271);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1295, 4, NULL, 1648, NULL, NULL, '1648', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4846);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1296, 4, NULL, 1563, NULL, NULL, '1563', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4852);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1297, 4, NULL, 1524, NULL, NULL, '1524', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 696);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1298, 4, NULL, 1733, 9, 13, '1733-09-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4916);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1299, 4, NULL, 1592, NULL, NULL, '1592', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4921);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1300, 4, NULL, 1626, NULL, NULL, '1626', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4936);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1301, 4, NULL, 1601, NULL, NULL, '1601', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4941);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1302, 4, NULL, 1612, NULL, NULL, '1612', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4945);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1303, 4, NULL, 1671, NULL, NULL, '1671', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4952);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1304, 4, NULL, 1558, NULL, NULL, '1558', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4962);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1305, 4, NULL, 1671, 3, 20, '1671-03-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4985);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1306, 4, NULL, 1629, NULL, NULL, '1629', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5115);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1307, 4, NULL, 1604, NULL, NULL, '1604', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5191);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1308, 4, NULL, 1617, NULL, NULL, '1617', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9559);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1309, 4, NULL, 1593, 4, 22, '1593-04-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5217);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1310, 4, NULL, 1686, 5, 18, '1686-05-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5230);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1311, 4, NULL, 1689, NULL, NULL, '1689', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5237);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1312, 4, NULL, 1722, 7, 28, '1722-07-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5265);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1313, 4, NULL, 1592, NULL, NULL, '1592', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5279);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1314, 4, NULL, 1662, NULL, NULL, '1662', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5322);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1315, 4, NULL, 1680, NULL, NULL, '1680', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5436);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1316, 4, NULL, 1652, NULL, NULL, '1652', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5521);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1317, 4, NULL, 1676, NULL, NULL, '1676', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5532);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1318, 4, NULL, 1623, NULL, NULL, '1623', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5538);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1319, 4, NULL, 1731, NULL, NULL, '1731', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5646);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1320, 4, NULL, 1617, 3, 30, '1617-03-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5683);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1321, 4, NULL, 1635, 5, 10, '1635-05-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5701);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1322, 4, NULL, 1710, 1, 19, '1710-01-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7131);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1323, 4, NULL, 1619, 3, 7, '1619-03-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5788);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1324, 4, NULL, 1592, NULL, NULL, '1592', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5797);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1325, 4, NULL, 1681, 5, 5, '1681-05-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5805);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1326, 4, NULL, 1572, NULL, NULL, '1572', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5827);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1327, 4, NULL, 1607, NULL, NULL, '1607', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5857);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1328, 4, NULL, 1616, NULL, NULL, '1616', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7242);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1329, 4, NULL, 1638, NULL, NULL, '1638', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6062);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1330, 4, NULL, 1633, NULL, NULL, '1633', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6069);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1331, 4, NULL, 1610, NULL, NULL, '1610', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6078);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1332, 4, NULL, 1614, NULL, NULL, '1614', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6085);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1333, 4, NULL, 1619, NULL, NULL, '1619', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1864);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1334, 4, NULL, 1536, NULL, NULL, '1536', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9733);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1335, 4, NULL, 1613, NULL, NULL, '1613', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6116);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1336, 4, NULL, 1582, NULL, NULL, '1582', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6137);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1337, 4, NULL, 1705, NULL, NULL, '1705', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7148);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1338, 4, NULL, 1551, 9, 30, '1551-09-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6151);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1339, 4, NULL, 1608, NULL, NULL, '1608', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6192);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1340, 4, NULL, 1557, NULL, NULL, '1557', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6237);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1341, 4, NULL, 1609, 7, 17, '1609-07-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6251);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1342, 4, NULL, 1609, 3, 21, '1609-03-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6286);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1343, 4, NULL, 1666, 1, 19, '1666-01-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6293);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1344, 4, NULL, 1692, 4, 4, '1692-04-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6297);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1345, 4, NULL, 1592, 4, 24, '1592-04-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6305);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1346, 4, NULL, 1741, NULL, NULL, '1741', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6313);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1347, 4, NULL, 1717, NULL, NULL, '1717', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6318);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1348, 4, NULL, 1667, NULL, NULL, '1667', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6349);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1349, 4, NULL, 1669, NULL, NULL, '1669', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6360);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1350, 4, NULL, 1658, NULL, NULL, '1658', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6394);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1351, 4, NULL, 1613, NULL, NULL, '1613', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6401);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1352, 4, NULL, 1666, 8, 28, '1666-08-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6422);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1353, 4, NULL, 1588, NULL, NULL, '1588', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6434);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1354, 4, NULL, 1665, 5, 23, '1665-05-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6440);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1355, 4, NULL, 1557, NULL, NULL, '1557', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6466);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1356, 4, NULL, 1624, NULL, NULL, '1624', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6485);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1357, 4, NULL, 1569, 4, 18, '1569-04-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6504);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1358, 4, NULL, 1751, NULL, NULL, '1751', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6514);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1359, 4, NULL, 1627, 4, 15, '1627-04-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6517);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1360, 4, NULL, 1731, NULL, NULL, '1731', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6523);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1361, 4, NULL, 1576, NULL, NULL, '1576', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6531);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1362, 4, NULL, 1704, 1, 4, '1704-01-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6537);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1363, 4, NULL, 1645, NULL, NULL, '1645', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6554);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1364, 4, NULL, 1721, 9, 11, '1721-09-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6565);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1365, 4, NULL, 1565, NULL, NULL, '1565', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6597);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1366, 4, NULL, 1716, 6, 20, '1716-06-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6605);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1367, 4, NULL, 1677, 5, 24, '1677-05-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6612);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1368, 4, NULL, 1670, 2, 27, '1670-02-27', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6623);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1369, 4, NULL, 1640, NULL, NULL, '1640', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4872);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1370, 4, NULL, 1581, NULL, NULL, '1581', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6756);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1371, 4, NULL, 1619, 2, 5, '1619-02-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6766);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1372, 4, NULL, 1526, NULL, NULL, '1526', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 674);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1373, 4, NULL, 1518, NULL, NULL, '1518', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7157);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1374, 4, NULL, 1549, 7, 21, '1549-07-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6847);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1375, 4, NULL, 1683, 1, 23, '1683-01-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6851);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1376, 4, NULL, 1655, 1, 16, '1655-01-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5515);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1377, 4, NULL, 1601, 2, 28, '1601-02-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6875);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1378, 4, NULL, 1642, 7, 13, '1642-07-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6906);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1379, 4, NULL, 1647, 6, 20, '1647-06-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6914);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1380, 4, NULL, 1745, 10, 9, '1745-10-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6926);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1381, 4, NULL, 1745, 10, 9, '1745-10-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6930);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1382, 4, NULL, 1632, NULL, NULL, '1632', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6949);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1383, 4, NULL, 1563, 8, 19, '1563-08-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6996);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1384, 4, NULL, 1601, NULL, NULL, '1601', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7020);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1385, 4, NULL, 1677, 11, 13, '1677-11-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 546);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1386, 4, NULL, 1659, NULL, NULL, '1659 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7087);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1387, 4, NULL, 1564, NULL, NULL, '1564', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7238);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1388, 4, NULL, 1601, NULL, NULL, '1601', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9113);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1389, 4, NULL, 1599, 3, 15, '1599-03-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8589);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1390, 4, NULL, 1649, NULL, NULL, '1649', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8491);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1391, 4, NULL, 1572, 7, 7, '1572-07-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8646);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1392, 4, NULL, 1713, NULL, NULL, '1713', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7285);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1393, 4, NULL, 1553, NULL, NULL, '1553', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 493);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1394, 4, NULL, 1693, NULL, NULL, '1693', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7289);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1395, 4, NULL, 1558, NULL, NULL, '1558', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7350);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1396, 4, NULL, 1564, NULL, NULL, '1564', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7547);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1397, 4, NULL, 1577, NULL, NULL, '1577', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7553);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1398, 4, NULL, 1590, 10, 28, '1590-10-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8220);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1399, 4, NULL, 1709, NULL, NULL, '1709', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8398);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1400, 4, NULL, 1600, 10, 18, '1600-10-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8415);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1401, 4, NULL, 1603, NULL, NULL, '1603', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1953);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1402, 4, NULL, 1626, 3, 23, '1626-03-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8501);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1403, 4, NULL, 1665, NULL, NULL, '1665', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8524);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1404, 4, NULL, 1642, 3, 29, '1642-03-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8530);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1405, 4, NULL, 1735, NULL, NULL, '1735', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8547);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1406, 4, NULL, 1565, 7, 10, '1565-07-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8577);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1407, 4, NULL, 1573, 4, 3, '1573-04-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8583);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1408, 4, NULL, 1592, NULL, NULL, '1592', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8594);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1409, 4, NULL, 1640, NULL, NULL, '1640', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8618);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1410, 4, NULL, 1588, NULL, NULL, '1588', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8626);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1411, 4, NULL, 1583, 8, 15, '1583-08-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8379);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1412, 4, NULL, 1594, NULL, NULL, '1594', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8876);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1413, 4, NULL, 1725, NULL, NULL, '1725', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8913);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1414, 4, NULL, 1578, 11, 1, '1578-11-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8929);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1415, 4, NULL, 1587, NULL, NULL, '1587', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9140);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1416, 4, NULL, 1572, NULL, NULL, '1572', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4817);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1417, 4, NULL, 1509, NULL, NULL, '1509', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4929);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1418, 4, NULL, 1680, NULL, NULL, '1680', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4976);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1419, 4, NULL, 1564, NULL, NULL, '1564', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8212);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1420, 4, NULL, 1694, NULL, NULL, '1694', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5159);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1421, 4, NULL, 1762, NULL, NULL, '1762', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5226);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1422, 4, NULL, 1543, 4, 8, '1543-04-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5444);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1423, 4, NULL, 1592, 7, 11, '1592-07-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5457);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1424, 4, NULL, 1592, NULL, NULL, '1592', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5473);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1425, 4, NULL, 1604, NULL, NULL, '1604', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5475);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1426, 4, NULL, 1631, 9, 17, '1631-09-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5640);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1427, 4, NULL, 1657, NULL, NULL, '1657', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5766);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1428, 4, NULL, 1585, NULL, NULL, '1585', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2102);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1429, 4, NULL, 1562, 5, 17, '1562-05-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6052);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1430, 4, NULL, 1644, NULL, NULL, '1644', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7783);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1431, 4, NULL, 1613, NULL, NULL, '1613', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8168);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1432, 4, NULL, 1629, NULL, NULL, '1629', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2104);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1433, 4, NULL, 1695, NULL, NULL, '1695', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1440);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1434, 4, NULL, 1629, 8, NULL, '1629-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1445);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1435, 4, NULL, 1697, 4, 12, '1697-04-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1444);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1436, 4, NULL, 1574, NULL, NULL, '1574', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1448);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1437, 4, NULL, 1621, 12, 30, '1621-12-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1450);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1438, 4, NULL, 1627, 5, 5, '1627-05-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1454);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1439, 4, NULL, 1679, NULL, NULL, '1679', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1452);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1440, 4, NULL, 1698, NULL, NULL, '1698', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1473);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1441, 4, NULL, 1700, NULL, NULL, '1700', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1480);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1442, 4, NULL, 1630, NULL, NULL, '1630', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1485);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1443, 4, NULL, 1540, NULL, NULL, '1540', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1487);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1444, 4, NULL, 1607, NULL, NULL, '1607', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1489);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1445, 4, NULL, 1536, NULL, NULL, '1536', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8793);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1446, 4, NULL, 1598, NULL, NULL, '1598', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8791);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1447, 4, NULL, 1714, NULL, NULL, '1714', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1497);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1448, 4, NULL, 1791, NULL, NULL, '1791', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1500);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1449, 4, NULL, 1727, 7, 1, '1727-07-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1513);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1450, 4, NULL, 1779, 9, 30, '1779-09-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1503);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1451, 4, NULL, 1619, NULL, NULL, '1619', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1514);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1452, 4, NULL, 1697, NULL, NULL, '1697', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1515);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1453, 4, NULL, 1580, NULL, NULL, '1580', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1521);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1454, 4, NULL, 1646, NULL, NULL, '1646', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1522);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1455, 4, NULL, 1644, 10, 17, '1644-10-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1526);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1456, 4, NULL, 1712, 4, 16, '1712-04-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1527);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1457, 4, NULL, 1539, NULL, NULL, '1539', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1533);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1458, 4, NULL, 1600, NULL, NULL, '1600', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1534);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1459, 4, NULL, 1605, NULL, NULL, '1605', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9357);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1460, 4, NULL, 1688, NULL, NULL, '1688', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1539);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1461, 4, NULL, 1738, NULL, NULL, '1738', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1540);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1462, 4, NULL, 1594, NULL, NULL, '1594', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1545);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1463, 4, NULL, 1653, 5, 8, '1653-05-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1546);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1464, 4, NULL, 1701, 6, 24, '1701-06-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1552);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1465, 4, NULL, 1695, 9, 23, '1695-09-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1551);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1466, 4, NULL, 1652, 8, 7, '1652-08-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1562);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1467, 4, NULL, 1708, 2, 26, '1708-02-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1560);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1468, 4, NULL, 1748, 12, 7, '1748-12-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1572);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1469, 4, NULL, 1684, 1, 17, '1684-01-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1573);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1470, 4, NULL, 1725, 4, 11, '1725-04-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1577);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1471, 4, NULL, 1786, 6, 15, '1786-06-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1576);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1472, 4, NULL, 1559, NULL, NULL, '1559', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1584);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1473, 4, NULL, 1634, NULL, NULL, '1634', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1586);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1474, 4, NULL, 1585, NULL, NULL, '1585', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1595);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1475, 4, NULL, 1634, 10, 28, '1634-10-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1593);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1476, 4, NULL, 1552, NULL, NULL, '1552', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1604);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1477, 4, NULL, 1619, NULL, NULL, '1619', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1606);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1478, 4, NULL, 1560, NULL, NULL, '1560', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1624);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1479, 4, NULL, 1636, NULL, NULL, '1636', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1626);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1480, 4, NULL, 1570, NULL, NULL, '1570', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1632);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1481, 4, NULL, 1633, NULL, NULL, '1633', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1630);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1482, 4, NULL, 1596, NULL, NULL, '1596', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1649);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1483, 4, NULL, 1657, 9, 15, '1657-09-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1647);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1484, 4, NULL, 1609, NULL, NULL, '1609', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1657);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1485, 4, NULL, 1625, 7, 20, '1625-07-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1656);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1486, 4, NULL, 1600, NULL, NULL, '1600', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1662);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1487, 4, NULL, 1649, 9, 19, '1649-09-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1664);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1488, 4, NULL, 1588, NULL, NULL, '1588', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1679);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1489, 4, NULL, 1638, NULL, NULL, '1638', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1677);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1490, 4, NULL, 1557, NULL, NULL, '1557', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1726);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1491, 4, NULL, 1638, NULL, NULL, '1638', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1727);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1492, 4, NULL, 1578, NULL, NULL, '1578', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1729);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1493, 4, NULL, 1648, NULL, NULL, '1648', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1730);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1494, 4, NULL, 1550, NULL, NULL, '1550', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1739);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1495, 4, NULL, 1635, NULL, NULL, '1635', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1737);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1496, 4, NULL, 1576, NULL, NULL, '1576', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1763);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1497, 4, NULL, 1602, NULL, NULL, '1602', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1765);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1498, 4, NULL, 1562, NULL, NULL, '1562', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1778);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1499, 4, NULL, 1649, NULL, NULL, '1649', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1780);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1500, 4, NULL, 1578, NULL, NULL, '1578', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1786);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1501, 4, NULL, 1651, NULL, NULL, '1651', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1784);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1502, 4, NULL, 1692, NULL, NULL, '1692', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1794);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1503, 4, NULL, 1775, NULL, NULL, '1775', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1793);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1504, 4, NULL, 1636, NULL, NULL, '1636', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1796);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1505, 4, NULL, 1709, NULL, NULL, '1709', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1795);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1506, 4, NULL, 1588, NULL, NULL, '1588', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1804);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1507, 4, NULL, 1622, NULL, NULL, '1622', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5404);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1508, 4, NULL, 1706, NULL, NULL, '1706', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5405);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1509, 4, NULL, 1590, NULL, NULL, '1590', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1808);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1510, 4, NULL, 1670, NULL, NULL, '1670', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1810);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1511, 4, NULL, 1554, 12, 6, '1554-12-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 772);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1512, 4, NULL, 1626, 6, 19, '1626-06-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 774);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1513, 4, NULL, 1535, NULL, NULL, '1535 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1830);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1514, 4, NULL, 1591, NULL, NULL, '1591', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1829);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1515, 4, NULL, 1545, NULL, NULL, '1545', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 752);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1516, 4, NULL, 1592, NULL, NULL, '1592', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 754);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1518, 4, NULL, 1695, NULL, NULL, '1695', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1841);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1519, 4, NULL, 1580, NULL, NULL, '1580', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1846);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1520, 4, NULL, 1664, NULL, NULL, '1664', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1848);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1521, 4, NULL, 1612, NULL, NULL, '1612', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3847);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1522, 4, NULL, 1665, 3, 25, '1665-03-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1865);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1523, 4, NULL, 1652, NULL, NULL, '1652', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1868);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1524, 4, NULL, 1715, NULL, NULL, '1715', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1867);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1525, 4, NULL, 1704, NULL, NULL, '1704', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1872);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1526, 4, NULL, 1641, NULL, NULL, '1641', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1874);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1527, 4, NULL, 1692, NULL, NULL, '1692', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1875);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1528, 4, NULL, 1570, NULL, NULL, '1570', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1885);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1529, 4, NULL, 1636, NULL, NULL, '1636', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1884);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1530, 4, NULL, 1629, NULL, NULL, '1629', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1894);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1531, 4, NULL, 1692, NULL, NULL, '1692', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1892);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1532, 4, NULL, 1592, NULL, NULL, '1592', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9075);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1533, 4, NULL, 1667, NULL, NULL, '1667', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9079);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1534, 4, NULL, 1559, NULL, NULL, '1559', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1897);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1535, 4, NULL, 1608, NULL, NULL, '1608', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1898);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1536, 4, NULL, 1620, 3, 30, '1620-03-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1904);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1537, 4, NULL, 1693, 8, 31, '1693-08-31', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1905);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1538, 4, NULL, 1536, 1, 26, '1536-01-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1910);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1539, 4, NULL, 1594, NULL, NULL, '1594', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1915);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1540, 4, NULL, 1688, NULL, NULL, '1688', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1917);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1541, 4, NULL, 1606, NULL, NULL, '1606', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1921);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1542, 4, NULL, 1657, NULL, NULL, '1657', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1920);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1543, 4, NULL, 1589, NULL, NULL, '1589', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9456);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1544, 4, NULL, 1657, NULL, NULL, '1657', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9458);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1545, 4, NULL, 1580, NULL, NULL, '1580', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1924);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1546, 4, NULL, 1664, 10, 6, '1664-10-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1925);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1547, 4, NULL, 1621, NULL, NULL, '1621', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1931);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1548, 4, NULL, 1679, NULL, NULL, '1679', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1932);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1549, 4, NULL, 1733, NULL, NULL, '1733', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1939);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1550, 4, NULL, 1799, NULL, NULL, '1799', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1941);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1551, 4, NULL, 1536, NULL, NULL, '1536', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1952);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1552, 4, NULL, 1493, NULL, NULL, '1493', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1961);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1553, 4, NULL, 1586, NULL, NULL, '1586', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1959);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1554, 4, NULL, 1660, NULL, NULL, '1660', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1996);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1555, 4, NULL, 1726, NULL, NULL, '1726', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1997);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1556, 4, NULL, 1693, 12, 8, '1693-12-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2001);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1557, 4, NULL, 1738, 6, 19, '1738-06-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2002);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1558, 4, NULL, 1591, 7, 9, '1591-07-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9383);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1559, 4, NULL, 1664, 8, 23, '1664-08-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9381);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1560, 4, NULL, 1513, NULL, NULL, '1513', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2009);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1561, 4, NULL, 1589, 9, 16, '1589-09-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2011);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1562, 4, NULL, 1610, NULL, NULL, '1610', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9470);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1563, 4, NULL, 1669, NULL, NULL, '1669', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9472);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1564, 4, NULL, 1573, NULL, NULL, '1573', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 800);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1565, 4, NULL, 1627, NULL, NULL, '1627', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2016);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1566, 4, NULL, 1628, NULL, NULL, '1628', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2032);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1567, 4, NULL, 1685, NULL, NULL, '1685', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2030);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1568, 4, NULL, 1528, NULL, NULL, '1528', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 522);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1569, 4, NULL, 1604, NULL, NULL, '1604', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 524);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1570, 4, NULL, 1670, NULL, NULL, '1670', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2037);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1571, 4, NULL, 1709, 9, 20, '1709-09-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2036);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1572, 4, NULL, 1615, NULL, NULL, '1615', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2071);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1573, 4, NULL, 1676, NULL, NULL, '1676', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2072);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1574, 4, NULL, 1615, NULL, NULL, '1615', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2078);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1575, 4, NULL, 1697, NULL, NULL, '1697', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2080);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1576, 4, NULL, 1610, NULL, NULL, '1610', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2092);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1577, 4, NULL, 1696, 3, 18, '1696-03-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2094);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1578, 4, NULL, 1604, 5, 17, '1604-05-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7093);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1579, 4, NULL, 1674, 1, 21, '1674-01-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7095);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1580, 4, NULL, 1593, NULL, NULL, '1593', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2097);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1581, 4, NULL, 1639, NULL, NULL, '1639', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2099);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1582, 4, NULL, 1585, NULL, NULL, '1585', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2139);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1583, 4, NULL, 1670, NULL, NULL, '1670', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2137);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1584, 4, NULL, 1668, NULL, NULL, '1668', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 798);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1585, 4, NULL, 1709, 7, 17, '1709-07-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2165);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1586, 4, NULL, 1785, 10, 8, '1785-10-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2167);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1587, 4, NULL, 1564, NULL, NULL, '1564', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2171);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1588, 4, NULL, 1649, 7, 3, '1649-07-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2173);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1589, 4, NULL, 1570, NULL, NULL, '1570', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2189);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1590, 4, NULL, 1638, NULL, NULL, '1638', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2191);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1591, 4, NULL, 1563, NULL, NULL, '1563', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8440);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1592, 4, NULL, 1624, NULL, NULL, '1624', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8442);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1593, 4, NULL, 1628, NULL, NULL, '1628', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2201);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1594, 4, NULL, 1703, NULL, NULL, '1703', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2203);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1595, 4, NULL, 1552, NULL, NULL, '1552', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2209);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1596, 4, NULL, 1630, 8, 27, '1630-08-27', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2207);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1597, 4, NULL, 1542, NULL, NULL, '1542', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8942);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1598, 4, NULL, 1621, NULL, NULL, '1621', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8938);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1599, 4, NULL, 1600, NULL, NULL, '1600', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2219);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1600, 4, NULL, 1676, NULL, NULL, '1676', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2221);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1601, 4, NULL, 1641, 1, 25, '1641-01-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2225);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1602, 4, NULL, 1706, 5, 15, '1706-05-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2226);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1603, 4, NULL, 1589, NULL, NULL, '1589', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2248);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1604, 4, NULL, 1642, NULL, NULL, '1642', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2250);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1605, 4, NULL, 1613, NULL, NULL, '1613', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2256);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1606, 4, NULL, 1668, NULL, NULL, '1668', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2254);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1607, 4, NULL, 1616, NULL, NULL, '1616', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2269);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1608, 4, NULL, 1682, NULL, NULL, '1682', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2271);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1609, 4, NULL, 1575, NULL, NULL, '1575', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2275);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1610, 4, NULL, 1629, NULL, NULL, '1629', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2274);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1611, 4, NULL, 1582, NULL, NULL, '1582', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2277);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1612, 4, NULL, 1653, NULL, NULL, '1653', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2278);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1613, 4, NULL, 1571, NULL, NULL, '1571', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2281);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1614, 4, NULL, 1605, NULL, NULL, '1605', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2288);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1615, 4, NULL, 1655, NULL, NULL, '1655', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2290);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1616, 4, NULL, 1693, 7, 23, '1693-07-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2305);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1617, 4, NULL, 1741, 9, 13, '1741-09-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2303);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1618, 4, NULL, 1617, 6, 20, '1617-06-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2317);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1619, 4, NULL, 1677, 1, 5, '1677-01-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2315);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1620, 4, NULL, 1679, NULL, NULL, '1679', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2341);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1621, 4, NULL, 1740, NULL, NULL, '1740', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2339);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1622, 4, NULL, 1651, 1, 26, '1651-01-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2347);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1623, 4, NULL, 1733, 8, 8, '1733-08-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2345);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1624, 4, NULL, 1630, NULL, NULL, '1630', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2354);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1625, 4, NULL, 1615, NULL, NULL, '1615', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2358);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1626, 4, NULL, 1689, NULL, NULL, '1689', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2356);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1627, 4, NULL, 1603, NULL, NULL, '1603', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2364);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1628, 4, NULL, 1683, 11, 25, '1683-11-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2366);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1629, 4, NULL, 1550, NULL, NULL, '1550', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2370);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1630, 4, NULL, 1645, NULL, NULL, '1645', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2372);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1631, 4, NULL, 1595, NULL, NULL, '1595', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2385);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1632, 4, NULL, 1653, NULL, NULL, '1653', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2383);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1633, 4, NULL, 1605, NULL, NULL, '1605', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2394);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1634, 4, NULL, 1681, NULL, NULL, '1681', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2396);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1635, 4, NULL, 1612, NULL, NULL, '1612', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9506);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1636, 4, NULL, 1693, NULL, NULL, '1693', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9504);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1637, 4, NULL, 1587, NULL, NULL, '1587', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 501);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1638, 4, NULL, 1669, 11, 15, '1669-11-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 499);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1639, 4, NULL, 1585, NULL, NULL, '1585', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2432);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1640, 4, NULL, 1657, NULL, NULL, '1657', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2434);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1641, 4, NULL, 1545, NULL, NULL, '1545 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2455);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1642, 4, NULL, 1592, NULL, NULL, '1592', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2453);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1643, 4, NULL, 1661, 5, 25, '1661-05-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2459);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1644, 4, NULL, 1590, NULL, NULL, '1590', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2465);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1645, 4, NULL, 1680, 12, 13, '1680-12-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2467);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1646, 4, NULL, 1726, 6, 5, '1726-06-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2472);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1647, 4, NULL, 1558, NULL, NULL, '1558', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2483);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1648, 4, NULL, 1628, 8, 1, '1628-08-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2481);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1649, 4, NULL, 1590, NULL, NULL, '1590', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9237);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1650, 4, NULL, 1635, NULL, NULL, '1635', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9233);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1651, 4, NULL, 1547, NULL, NULL, '1547', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2495);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1652, 4, NULL, 1611, NULL, NULL, '1611', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2493);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1653, 4, NULL, 1600, NULL, NULL, '1600', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2501);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1654, 4, NULL, 1668, NULL, NULL, '1668', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2499);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1655, 4, NULL, 1534, NULL, NULL, '1534', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9522);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1656, 4, NULL, 1576, NULL, NULL, '1576', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2517);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1657, 4, NULL, 1656, NULL, NULL, '1656', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2515);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1658, 4, NULL, 1630, NULL, NULL, '1630', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2521);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1659, 4, NULL, 1709, NULL, NULL, '1709', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2519);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1660, 4, NULL, 1650, NULL, NULL, '1650', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2536);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1661, 4, NULL, 1722, NULL, NULL, '1722', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2537);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1662, 4, NULL, 1646, NULL, NULL, '1646', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 435);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1663, 4, NULL, 1639, NULL, NULL, '1639', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9650);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1664, 4, NULL, 1649, 5, 29, '1649-05-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2547);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1665, 4, NULL, 1696, 5, 21, '1696-05-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2549);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1666, 4, NULL, 1658, 10, 12, '1658-10-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2555);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1667, 4, NULL, 1737, 2, 12, '1737-02-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2553);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1668, 4, NULL, 1509, NULL, NULL, '1509', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9721);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1669, 4, NULL, 1560, NULL, NULL, '1560', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9722);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1670, 4, NULL, 1691, 4, 22, '1691-04-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9220);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1671, 4, NULL, 1614, NULL, NULL, '1614', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9727);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1672, 4, NULL, 1606, NULL, NULL, '1606', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9761);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1673, 4, NULL, 1613, NULL, NULL, '1613', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2579);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1674, 4, NULL, 1684, NULL, NULL, '1684', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2581);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1675, 4, NULL, 1589, NULL, NULL, '1589', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2601);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1676, 4, NULL, 1638, NULL, NULL, '1638', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2599);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1677, 4, NULL, 1690, 3, 9, '1690-03-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2603);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1678, 4, NULL, 1748, 3, 2, '1748-03-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2605);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1679, 4, NULL, 1503, NULL, NULL, '1503', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7113);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1680, 4, NULL, 1576, 5, 2, '1576-05-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7114);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1681, 4, NULL, 1632, 3, 8, '1632-03-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2612);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1682, 4, NULL, 1706, 7, 25, '1706-07-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2614);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1683, 4, NULL, 1565, NULL, NULL, '1565', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2619);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1684, 4, NULL, 1618, NULL, NULL, '1618', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2618);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1685, 4, NULL, 1500, NULL, NULL, '1500', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2627);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1686, 4, NULL, 1552, NULL, NULL, '1552', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2629);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1687, 4, NULL, 1633, NULL, NULL, '1633', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9318);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1688, 4, NULL, 1673, NULL, NULL, '1673', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9314);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1689, 4, NULL, 1562, NULL, NULL, '1562', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2636);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1690, 4, NULL, 1607, NULL, NULL, '1607', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2638);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1691, 4, NULL, 1655, NULL, NULL, '1655', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2644);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1692, 4, NULL, 1713, NULL, NULL, '1713', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2643);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1693, 4, NULL, 1633, NULL, NULL, '1633', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2648);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1694, 4, NULL, 1711, NULL, NULL, '1711', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2646);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1695, 4, NULL, 1637, NULL, NULL, '1637', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2654);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1696, 4, NULL, 1686, 4, 9, '1686-04-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2675);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1697, 4, NULL, 1750, 4, 16, '1750-04-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2676);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1698, 4, NULL, 1495, NULL, NULL, '1495', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9779);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1699, 4, NULL, 1588, NULL, NULL, '1588', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9777);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1700, 4, NULL, 1551, NULL, NULL, '1551', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2681);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1701, 4, NULL, 1615, 12, 2, '1615-12-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2683);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1702, 4, NULL, 1556, NULL, NULL, '1556', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2687);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1703, 4, NULL, 1599, 11, 2, '1599-11-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2688);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1704, 4, NULL, 1583, NULL, NULL, '1583', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2691);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1705, 4, NULL, 1633, 12, 1, '1633-12-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2693);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1706, 4, NULL, 1633, NULL, NULL, '1633', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2702);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1707, 4, NULL, 1679, NULL, NULL, '1679', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2700);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1708, 4, NULL, 1490, NULL, NULL, '1490', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2708);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1709, 4, NULL, 1558, NULL, NULL, '1558', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2706);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1710, 4, NULL, 1640, NULL, NULL, '1640', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2739);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1711, 4, NULL, 1603, NULL, NULL, '1603', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2743);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1712, 4, NULL, 1662, NULL, NULL, '1662', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2745);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1713, 4, NULL, 1595, 2, 14, '1595-02-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2750);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1714, 4, NULL, 1668, 9, 27, '1668-09-27', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2752);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1715, 4, NULL, 1601, NULL, NULL, '1601', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2755);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1716, 4, NULL, 1670, 1, 24, '1670-01-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2757);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1717, 4, NULL, 1578, NULL, NULL, '1578', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2763);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1718, 4, NULL, 1639, NULL, NULL, '1639', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2761);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1719, 4, NULL, 1622, NULL, NULL, '1622', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2767);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1720, 4, NULL, 1659, NULL, NULL, '1659', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7262);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1721, 4, NULL, 1678, NULL, NULL, '1678', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2773);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1722, 4, NULL, 1520, NULL, NULL, '1520', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2782);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1723, 4, NULL, 1575, NULL, NULL, '1575', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2783);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1724, 4, NULL, 1618, NULL, NULL, '1618', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2788);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1725, 4, NULL, 1679, NULL, NULL, '1679', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2789);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1726, 4, NULL, 1620, 5, 15, '1620-05-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2793);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1727, 4, NULL, 1699, 9, 5, '1699-09-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2791);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1728, 4, NULL, 1560, NULL, NULL, '1560', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5500);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1729, 4, NULL, 1636, NULL, NULL, '1636', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5501);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1730, 4, NULL, 1625, NULL, NULL, '1625', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2799);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1731, 4, NULL, 1686, NULL, NULL, '1686', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2801);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1732, 4, NULL, 1674, NULL, NULL, '1674', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3045);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1733, 4, NULL, 1734, NULL, NULL, '1734', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5424);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1734, 4, NULL, 1782, 10, 11, '1782-10-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5426);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1735, 4, NULL, 1577, NULL, NULL, '1577', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9739);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1736, 4, NULL, 1651, NULL, NULL, '1651', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9735);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1737, 4, NULL, 1630, 5, 26, '1630-05-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2815);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1738, 4, NULL, 1657, NULL, NULL, '1657', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2821);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1739, 4, NULL, 1739, NULL, NULL, '1739', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2823);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1740, 4, NULL, 1465, NULL, NULL, '1465', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2851);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1741, 4, NULL, 1548, NULL, NULL, '1548', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2849);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1742, 4, NULL, 1622, NULL, NULL, '1622', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2857);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1743, 4, NULL, 1665, NULL, NULL, '1665', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2859);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1744, 4, NULL, 1538, 3, 25, '1538-03-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 19);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1745, 4, NULL, 1612, NULL, NULL, '1612', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1746, 4, NULL, 1594, NULL, NULL, '1594', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2892);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1747, 4, NULL, 1642, 12, 23, '1642-12-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2890);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1748, 4, NULL, 1553, NULL, NULL, '1553', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2913);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1749, 4, NULL, 1611, NULL, NULL, '1611', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2911);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1750, 4, NULL, 1603, NULL, NULL, '1603', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2916);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1751, 4, NULL, 1669, NULL, NULL, '1669', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2918);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1752, 4, NULL, 1698, 8, 10, '1698-08-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2926);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1753, 4, NULL, 1771, 8, 8, '1771-08-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2928);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1754, 4, NULL, 1585, NULL, NULL, '1585', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2942);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1755, 4, NULL, 1651, NULL, NULL, '1651', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2940);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1756, 4, NULL, 1592, NULL, NULL, '1592', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9622);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1757, 4, NULL, 1670, NULL, NULL, '1670', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9626);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1758, 4, NULL, 1591, NULL, NULL, '1591', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2956);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1759, 4, NULL, 1666, NULL, NULL, '1666', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2958);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1760, 4, NULL, 1571, 12, 20, '1571-12-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3027);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1761, 4, NULL, 1633, 5, 31, '1633-05-31', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3029);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1762, 4, NULL, 1641, NULL, NULL, '1641', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3043);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1763, 4, NULL, 1485, NULL, NULL, '1485', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3067);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1764, 4, NULL, 1578, NULL, NULL, '1578', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3069);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1765, 4, NULL, 1598, NULL, NULL, '1598', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3081);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1766, 4, NULL, 1665, NULL, NULL, '1665', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3083);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1767, 4, NULL, 1555, NULL, NULL, '1555 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3094);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1768, 4, NULL, 1638, 8, 30, '1638-08-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3092);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1769, 4, NULL, 1566, NULL, NULL, '1566', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3101);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1770, 4, NULL, 1618, NULL, NULL, '1618', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3102);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1771, 4, NULL, 1531, 3, 1, '1531-03-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3120);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1772, 4, NULL, 1702, NULL, NULL, '1702', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3126);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1773, 4, NULL, 1765, NULL, NULL, '1765', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3128);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1774, 4, NULL, 1628, NULL, NULL, '1628', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3136);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1775, 4, NULL, 1572, NULL, NULL, '1572', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3142);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1776, 4, NULL, 1657, NULL, NULL, '1657', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3144);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1777, 4, NULL, 1512, NULL, NULL, '1512', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3147);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1778, 4, NULL, 1577, NULL, NULL, '1577', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3149);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1779, 4, NULL, 1553, NULL, NULL, '1553', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3151);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1780, 4, NULL, 1567, NULL, NULL, '1567', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3162);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1781, 4, NULL, 1624, NULL, NULL, '1624', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3164);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1782, 4, NULL, 1558, NULL, NULL, '1558', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3168);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1783, 4, NULL, 1616, NULL, NULL, '1616', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3166);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1784, 4, NULL, 1550, 12, 22, '1550-12-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 69);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1785, 4, NULL, 1631, 7, 19, '1631-07-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 68);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1786, 4, NULL, 1591, NULL, NULL, '1591', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3184);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1787, 4, NULL, 1651, NULL, NULL, '1651', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3185);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1788, 4, NULL, 1626, 1, NULL, '1626-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3201);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1789, 4, NULL, 1673, 8, 20, '1673-08-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3199);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1790, 4, NULL, 1545, NULL, NULL, '1545 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3213);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1791, 4, NULL, 1609, NULL, NULL, '1609', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3211);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1792, 4, NULL, 1664, NULL, NULL, '1664', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3224);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1793, 4, NULL, 1660, NULL, NULL, '1660', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3303);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1794, 4, NULL, 1745, NULL, NULL, '1745', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3301);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1795, 4, NULL, 1530, NULL, NULL, '1530', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3308);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1796, 4, NULL, 1595, NULL, NULL, '1595', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3306);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1797, 4, NULL, 1649, 2, 8, '1649-02-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3315);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1798, 4, NULL, 1728, 6, 23, '1728-06-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3317);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1799, 4, NULL, 1576, NULL, NULL, '1576', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5422);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1800, 4, NULL, 1644, NULL, NULL, '1644', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5420);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1801, 4, NULL, 1621, NULL, NULL, '1621', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3376);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1802, 4, NULL, 1678, 3, 22, '1678-03-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3378);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1803, 4, NULL, 1613, NULL, NULL, '1613', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3383);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1804, 4, NULL, 1701, NULL, NULL, '1701', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3381);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1805, 4, NULL, 1597, NULL, NULL, '1597', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3425);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1806, 4, NULL, 1654, NULL, NULL, '1654', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3427);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1807, 4, NULL, 1551, 5, 17, '1551-05-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3437);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1808, 4, NULL, 1608, 10, 19, '1608-10-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3439);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1809, 4, NULL, 1599, NULL, NULL, '1599', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3451);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1810, 4, NULL, 1669, NULL, NULL, '1669', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3453);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1811, 4, NULL, 1589, 3, 3, '1589-03-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3457);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1812, 4, NULL, 1656, 6, 20, '1656-06-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3459);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1813, 4, NULL, 1610, NULL, NULL, '1610', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3466);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1814, 4, NULL, 1678, NULL, NULL, '1678', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3467);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1815, 4, NULL, 1599, NULL, NULL, '1599', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3473);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1816, 4, NULL, 1673, NULL, NULL, '1673', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3471);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1817, 4, NULL, 1443, NULL, NULL, '1443', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3477);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1818, 4, NULL, 1523, NULL, NULL, '1523', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3479);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1819, 4, NULL, 1585, NULL, NULL, '1585', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3484);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1820, 4, NULL, 1663, NULL, NULL, '1663', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3483);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1821, 4, NULL, 1584, NULL, NULL, '1584', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3497);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1822, 4, NULL, 1653, NULL, NULL, '1653', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3499);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1823, 4, NULL, 1602, NULL, NULL, '1602', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3509);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1824, 4, NULL, 1654, 3, 20, '1654-03-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3510);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1825, 4, NULL, 1653, NULL, NULL, '1653', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3518);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1826, 4, NULL, 1726, NULL, NULL, '1726', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3516);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1827, 4, NULL, 1610, NULL, NULL, '1610', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3522);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1828, 4, NULL, 1688, NULL, NULL, '1688', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3524);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1829, 4, NULL, 1670, NULL, NULL, '1670', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3534);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1830, 4, NULL, 1581, NULL, NULL, '1581', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3538);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1831, 4, NULL, 1649, NULL, NULL, '1649', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3540);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1832, 4, NULL, 1624, NULL, NULL, '1624', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9347);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1833, 4, NULL, 1706, NULL, NULL, '1706', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9345);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1834, 4, NULL, 1656, NULL, NULL, '1656', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3573);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1835, 4, NULL, 1726, 12, 16, '1726-12-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3575);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1836, 4, NULL, 1569, NULL, NULL, '1569', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3603);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1837, 4, NULL, 1661, NULL, NULL, '1661', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3601);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1838, 4, NULL, 1580, NULL, NULL, '1580', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3629);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1839, 4, NULL, 1645, NULL, NULL, '1645', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3627);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1840, 4, NULL, 1564, NULL, NULL, '1564', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 358);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1841, 4, NULL, 1638, NULL, NULL, '1638', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 356);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1842, 4, NULL, 1555, NULL, NULL, '1555', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3637);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1843, 4, NULL, 1621, 1, 23, '1621-01-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3639);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1844, 4, NULL, 1620, NULL, NULL, '1620 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3646);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1845, 4, NULL, 1693, 10, 29, '1693-10-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3644);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1846, 4, NULL, 1546, NULL, NULL, '1546', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8991);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1847, 4, NULL, 1607, NULL, NULL, '1607', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8992);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1848, 4, NULL, 1700, 4, 14, '1700-04-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3651);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1849, 4, NULL, 1750, 3, 30, '1750-03-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3652);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1850, 4, NULL, 1732, 2, 2, '1732-02-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3658);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1851, 4, NULL, 1801, 2, 2, '1801-02-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3656);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1852, 4, NULL, 1648, 11, 15, '1648-11-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3665);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1853, 4, NULL, 1709, 2, 18, '1709-02-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3663);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1854, 4, NULL, 1621, NULL, NULL, '1621', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3670);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1855, 4, NULL, 1685, 6, 5, '1685-06-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3671);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1856, 4, NULL, 1618, NULL, NULL, '1618', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 850);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1857, 4, NULL, 1678, 11, 17, '1678-11-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 852);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1858, 4, NULL, 1695, 10, 12, '1695-10-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 866);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1859, 4, NULL, 1746, 10, 3, '1746-10-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 868);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1860, 4, NULL, 1590, NULL, NULL, '1590 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 872);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1861, 4, NULL, 1651, 11, NULL, '1651-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3674);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1862, 4, NULL, 1725, 1, 10, '1725-01-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3675);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1863, 4, NULL, 1696, 9, 12, '1696-09-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3678);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1864, 4, NULL, 1776, 11, 13, '1776-11-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3679);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1865, 4, NULL, 1589, NULL, NULL, '1589', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 884);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1866, 4, NULL, 1669, 7, 4, '1669-07-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 882);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1867, 4, NULL, 1606, NULL, NULL, '1606', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9613);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1868, 4, NULL, 1689, NULL, NULL, '1689', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9611);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1869, 4, NULL, 1580, NULL, NULL, '1580 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3686);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1870, 4, NULL, 1630, 10, 23, '1630-10-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3687);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1871, 4, NULL, 1632, NULL, NULL, '1632', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3689);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1872, 4, NULL, 1688, NULL, NULL, '1688', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3688);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1873, 4, NULL, 1605, NULL, NULL, '1605', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3693);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1874, 4, NULL, 1679, 12, 21, '1679-12-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3695);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1875, 4, NULL, 1542, NULL, NULL, '1542', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 893);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1876, 4, NULL, 1613, NULL, NULL, '1613', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 895);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1877, 4, NULL, 1624, NULL, NULL, '1624', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 902);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1878, 4, NULL, 1694, NULL, NULL, '1694', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 904);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1879, 4, NULL, 1738, 3, 12, '1738-03-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4642);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1880, 4, NULL, 1661, NULL, NULL, '1661', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9001);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1881, 4, NULL, 1704, NULL, NULL, '1704', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 932);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1882, 4, NULL, 1788, NULL, NULL, '1788', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 934);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1883, 4, NULL, 1564, NULL, NULL, '1564', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 366);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1884, 4, NULL, 1630, NULL, NULL, '1630', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 368);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1885, 4, NULL, 1607, 4, 5, '1607-04-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 408);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1886, 4, NULL, 1688, 3, 8, '1688-03-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 412);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1887, 4, NULL, 1588, 7, 2, '1588-07-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3703);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1888, 4, NULL, 1678, 8, 17, '1678-08-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3701);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1889, 4, NULL, 1589, NULL, NULL, '1589', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3716);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1890, 4, NULL, 1639, 7, 3, '1639-07-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3715);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1891, 4, NULL, 1462, NULL, NULL, '1462', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3730);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1892, 4, NULL, 1532, NULL, NULL, '1532', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3728);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1893, 4, NULL, 1622, NULL, NULL, '1622', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3737);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1894, 4, NULL, 1689, 7, 30, '1689-07-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3739);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1895, 4, NULL, 1681, 8, 6, '1681-08-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3744);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1896, 4, NULL, 1742, 11, 29, '1742-11-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3743);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1897, 4, NULL, 1564, NULL, NULL, '1564', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3746);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1898, 4, NULL, 1635, 6, 9, '1635-06-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3747);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1899, 4, NULL, 1567, NULL, NULL, '1567', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3753);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1900, 4, NULL, 1639, NULL, NULL, '1639', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3751);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1901, 4, NULL, 1599, NULL, NULL, '1599', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3764);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1902, 4, NULL, 1663, 7, 29, '1663-07-29', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3766);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1903, 4, NULL, 1716, NULL, NULL, '1716', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3773);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1904, 4, NULL, 1785, 11, 2, '1785-11-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3772);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1905, 4, NULL, 1687, 5, 11, '1687-05-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3776);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1906, 4, NULL, 1584, NULL, NULL, '1584', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3780);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1907, 4, NULL, 1639, 1, 20, '1639-01-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3680);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1908, 4, NULL, 1702, NULL, NULL, '1702', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3787);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1909, 4, NULL, 1779, NULL, NULL, '1779', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3786);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1910, 4, NULL, 1644, NULL, NULL, '1644', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3790);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1911, 4, NULL, 1733, NULL, NULL, '1733', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3791);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1912, 4, NULL, 1740, NULL, NULL, '1740', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3793);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1913, 4, NULL, 1821, NULL, NULL, '1821', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3794);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1914, 4, NULL, 1644, NULL, NULL, '1644', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3796);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1915, 4, NULL, 1716, NULL, NULL, '1716', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3795);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1916, 4, NULL, 1592, NULL, NULL, '1592', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3798);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1917, 4, NULL, 1650, NULL, NULL, '1650', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3799);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1918, 4, NULL, 1606, NULL, NULL, '1606', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3803);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1919, 4, NULL, 1681, NULL, NULL, '1681', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3801);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1920, 4, NULL, 1539, NULL, NULL, '1539', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3815);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1921, 4, NULL, 1607, NULL, NULL, '1607', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3816);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1922, 4, NULL, 1631, NULL, NULL, '1631', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3819);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1923, 4, NULL, 1633, NULL, NULL, '1633', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3821);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1924, 4, NULL, 1699, NULL, NULL, '1699', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3820);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1925, 4, NULL, 1600, NULL, NULL, '1600 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3825);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1926, 4, NULL, 1674, NULL, NULL, '1674', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3826);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1927, 4, NULL, 1715, 4, 8, '1715-04-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3833);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1928, 4, NULL, 1528, NULL, NULL, '1528', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 508);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1929, 4, NULL, 1599, NULL, NULL, '1599', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 507);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1930, 4, NULL, 1547, NULL, NULL, '1547', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3846);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1931, 4, NULL, 1571, NULL, NULL, '1571', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3851);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1932, 4, NULL, 1701, NULL, NULL, '1701', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 608);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1933, 4, NULL, 1754, NULL, NULL, '1754', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 610);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1934, 4, NULL, 1644, 1, 1, '1644-01-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3856);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1935, 4, NULL, 1696, 4, 27, '1696-04-27', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3855);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1936, 4, NULL, 1609, NULL, NULL, '1609', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3858);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1937, 4, NULL, 1665, NULL, NULL, '1665', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3859);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1938, 4, NULL, 1470, NULL, NULL, '1470', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8956);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1939, 4, NULL, 1553, NULL, NULL, '1553', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8958);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1940, 4, NULL, 1578, NULL, NULL, '1578', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3863);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1941, 4, NULL, 1620, NULL, NULL, '1620', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9493);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1942, 4, NULL, 1583, NULL, NULL, '1583', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3869);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1943, 4, NULL, 1669, NULL, NULL, '1669', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3871);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1944, 4, NULL, 1587, NULL, NULL, '1587', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 830);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1945, 4, NULL, 1638, NULL, NULL, '1638', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 832);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1946, 4, NULL, 1615, NULL, NULL, '1615', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3895);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1947, 4, NULL, 1688, 4, 30, '1688-04-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3897);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1948, 4, NULL, 1568, NULL, NULL, '1568', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3918);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1949, 4, NULL, 1625, NULL, NULL, '1625', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3920);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1950, 4, NULL, 1745, NULL, NULL, '1745', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3924);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1951, 4, NULL, 1784, NULL, NULL, '1784', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3925);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1952, 4, NULL, 1640, NULL, NULL, '1640', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3929);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1953, 4, NULL, 1701, NULL, NULL, '1701', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3928);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1954, 4, NULL, 1627, 11, 30, '1627-11-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3935);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1955, 4, NULL, 1706, 9, 10, '1706-09-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3933);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1956, 4, NULL, 1687, 11, NULL, '1687-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3940);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1957, 4, NULL, 1768, 1, 1, '1768-01-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3941);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1958, 4, NULL, 1612, 11, 11, '1612-11-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3954);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1959, 4, NULL, 1681, 10, 26, '1681-10-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3951);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1960, 4, NULL, 1592, 1, 22, '1592-01-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1114);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1961, 4, NULL, 1655, 10, 24, '1655-10-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1116);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1962, 4, NULL, 1602, NULL, NULL, '1602', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3961);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1963, 4, NULL, 1681, NULL, NULL, '1681', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3959);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1964, 4, NULL, 1640, NULL, NULL, '1640', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3965);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1965, 4, NULL, 1715, NULL, NULL, '1715', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3967);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1966, 4, NULL, 1712, 11, 1, '1712-11-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 787);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1967, 4, NULL, 1769, 9, 22, '1769-09-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 789);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1968, 4, NULL, 1582, NULL, NULL, '1582', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3972);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1969, 4, NULL, 1637, NULL, NULL, '1637', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3971);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1970, 4, NULL, 1601, NULL, NULL, '1601', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3982);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1971, 4, NULL, 1555, NULL, NULL, '1555', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3993);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1972, 4, NULL, 1608, NULL, NULL, '1608', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3995);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1973, 4, NULL, 1539, NULL, NULL, '1539', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4003);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1974, 4, NULL, 1626, 2, 8, '1626-02-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4001);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1975, 4, NULL, 1662, NULL, NULL, '1662', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4009);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1976, 4, NULL, 1738, NULL, NULL, '1738', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4011);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1977, 4, NULL, 1547, NULL, NULL, '1547', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 663);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1978, 4, NULL, 1628, NULL, NULL, '1628', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 661);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1979, 4, NULL, 1677, NULL, NULL, '1677', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4014);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1980, 4, NULL, 1571, NULL, NULL, '1571', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4019);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1981, 4, NULL, 1593, NULL, NULL, '1593', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4018);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1982, 4, NULL, 1513, NULL, NULL, '1513', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4022);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1983, 4, NULL, 1615, NULL, NULL, '1615', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4032);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1984, 4, NULL, 1681, NULL, NULL, '1681', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4031);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1985, 4, NULL, 1580, NULL, NULL, '1580 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4037);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1986, 4, NULL, 1622, NULL, NULL, '1622', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4039);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1987, 4, NULL, 1591, NULL, NULL, '1591', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4048);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1988, 4, NULL, 1661, NULL, NULL, '1661', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4050);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1989, 4, NULL, 1624, NULL, NULL, '1624', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4055);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1990, 4, NULL, 1701, NULL, NULL, '1701', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4053);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1991, 4, NULL, 1712, NULL, NULL, '1712', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4061);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1992, 4, NULL, 1751, NULL, NULL, '1751', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4060);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1993, 4, NULL, 1650, NULL, NULL, '1650', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4064);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1994, 4, NULL, 1708, NULL, NULL, '1708', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4066);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1995, 4, NULL, 1639, NULL, NULL, '1639', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4070);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1996, 4, NULL, 1695, NULL, NULL, '1695', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4072);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1997, 4, NULL, 1674, NULL, NULL, '1674', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4078);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1998, 4, NULL, 1730, NULL, NULL, '1730', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4079);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (1999, 4, NULL, 1601, 1, 8, '1601-01-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4080);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2000, 4, NULL, 1658, 12, 6, '1658-12-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4081);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2001, 4, NULL, 1530, NULL, NULL, '1530', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4086);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2002, 4, NULL, 1575, NULL, NULL, '1575', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4084);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2003, 4, NULL, 1571, NULL, NULL, '1571', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4090);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2004, 4, NULL, 1632, 1, 5, '1632-01-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4092);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2005, 4, NULL, 1604, NULL, NULL, '1604', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4095);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2006, 4, NULL, 1691, NULL, NULL, '1691', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4097);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2007, 4, NULL, 1650, 11, 21, '1650-11-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4104);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2008, 4, NULL, 1584, NULL, NULL, '1584', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4108);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2009, 4, NULL, 1667, NULL, NULL, '1667', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4110);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2010, 4, NULL, 1540, NULL, NULL, '1540', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4114);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2011, 4, NULL, 1597, NULL, NULL, '1597', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4116);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2012, 4, NULL, 1580, NULL, NULL, '1580 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4120);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2013, 4, NULL, 1651, NULL, NULL, '1651', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4122);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2014, 4, NULL, 1640, NULL, NULL, '1640', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4154);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2015, 4, NULL, 1703, NULL, NULL, '1703', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4155);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2016, 4, NULL, 1711, 2, 14, '1711-02-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4160);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2017, 4, NULL, 1767, NULL, NULL, '1767', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4158);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2018, 4, NULL, 1585, NULL, NULL, '1585', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4164);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2019, 4, NULL, 1649, 2, 19, '1649-02-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4163);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2020, 4, NULL, 1614, NULL, NULL, '1614', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4167);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2021, 4, NULL, 1680, 11, 24, '1680-11-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4168);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2022, 4, NULL, 1614, NULL, NULL, '1614 r', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9495);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2023, 4, NULL, 1701, 7, NULL, '1701-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9496);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2024, 4, NULL, 1622, NULL, NULL, '1622', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4173);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2025, 4, NULL, 1589, NULL, NULL, '1589', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4184);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2026, 4, NULL, 1634, NULL, NULL, '1634', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4186);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2027, 4, NULL, 1582, NULL, NULL, '1582', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 727);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2028, 4, NULL, 1600, NULL, NULL, '1600', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4191);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2029, 4, NULL, 1668, NULL, NULL, '1668', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4190);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2030, 4, NULL, 1635, NULL, NULL, '1635', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4194);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2031, 4, NULL, 1718, NULL, NULL, '1718', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4193);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2032, 4, NULL, 1571, NULL, NULL, '1571', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4196);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2033, 4, NULL, 1656, NULL, NULL, '1656', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4198);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2034, 4, NULL, 1480, NULL, NULL, '1480', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4207);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2035, 4, NULL, 1538, 9, 8, '1538-09-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4205);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2036, 4, NULL, 1610, NULL, NULL, '1610', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4211);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2037, 4, NULL, 1689, NULL, NULL, '1689', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4213);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2038, 4, NULL, 1589, NULL, NULL, '1589', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4221);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2039, 4, NULL, 1676, 11, 12, '1676-11-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4219);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2040, 4, NULL, 1613, 10, 13, '1613-10-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9251);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2041, 4, NULL, 1685, 7, 7, '1685-07-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9253);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2042, 4, NULL, 1592, NULL, NULL, '1592', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4233);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2043, 4, NULL, 1634, 10, 20, '1634-10-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4235);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2044, 4, NULL, 1574, NULL, NULL, '1574', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4238);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2045, 4, NULL, 1637, 6, 4, '1637-06-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4239);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2046, 4, NULL, 1648, 1, 7, '1648-01-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4243);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2047, 4, NULL, 1702, 5, 1, '1702-05-01', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4242);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2048, 4, NULL, 1612, 7, 20, '1612-07-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4248);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2049, 4, NULL, 1704, 2, 11, '1704-02-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4246);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2050, 4, NULL, 1652, 1, 20, '1652-01-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4253);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2051, 4, NULL, 1720, 8, 30, '1720-08-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4254);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2052, 4, NULL, 1633, NULL, NULL, '1633', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4259);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2053, 4, NULL, 1712, 3, 13, '1712-03-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4256);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2054, 4, NULL, 1552, NULL, NULL, '1552', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4263);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2055, 4, NULL, 1608, NULL, NULL, '1608', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4267);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2056, 4, NULL, 1572, NULL, NULL, '1572', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4281);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2057, 4, NULL, 1636, NULL, NULL, '1636', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4277);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2058, 4, NULL, 1621, NULL, NULL, '1621', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4284);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2059, 4, NULL, 1678, NULL, NULL, '1678', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4282);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2060, 4, NULL, 1693, NULL, NULL, '1693', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4293);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2061, 4, NULL, 1766, NULL, NULL, '1766', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4292);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2062, 4, NULL, 1623, NULL, NULL, '1623', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 542);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2063, 4, NULL, 1684, NULL, NULL, '1684', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 540);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2064, 4, NULL, 1551, NULL, NULL, '1551', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4301);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2065, 4, NULL, 1609, NULL, NULL, '1609', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4299);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2066, 4, NULL, 1548, NULL, NULL, '1548', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 748);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2067, 4, NULL, 1630, 12, 31, '1630-12-31', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 746);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2068, 4, NULL, 1656, NULL, NULL, '1656', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4306);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2069, 4, NULL, 1715, NULL, NULL, '1715', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4305);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2070, 4, NULL, 1586, NULL, NULL, '1586', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4311);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2071, 4, NULL, 1641, NULL, NULL, '1641', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4312);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2072, 4, NULL, 1637, NULL, NULL, '1637', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4315);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2073, 4, NULL, 1679, NULL, NULL, '1679', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4316);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2074, 4, NULL, 1597, 4, 13, '1597-04-13', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2659);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2075, 4, NULL, 1660, 4, 6, '1660-04-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2661);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2076, 4, NULL, 1571, NULL, NULL, '1571', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4323);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2077, 4, NULL, 1646, NULL, NULL, '1646', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4324);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2078, 4, NULL, 1573, 1, 8, '1573-01-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4328);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2079, 4, NULL, 1641, 8, 26, '1641-08-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4329);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2080, 4, NULL, 1732, NULL, NULL, '1732', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 513);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2081, 4, NULL, 1799, NULL, NULL, '1799', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 515);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2082, 4, NULL, 1677, NULL, NULL, '1677', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4335);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2083, 4, NULL, 1760, NULL, NULL, '1760', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4333);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2084, 4, NULL, 1529, NULL, NULL, '1529', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4341);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2085, 4, NULL, 1588, NULL, NULL, '1588', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4342);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2086, 4, NULL, 1630, NULL, NULL, '1630', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2087, 4, NULL, 1721, NULL, NULL, '1721', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2088, 4, NULL, 1575, NULL, NULL, '1575', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4352);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2089, 4, NULL, 1646, NULL, NULL, '1646', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4350);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2090, 4, NULL, 1589, NULL, NULL, '1589', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 482);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2091, 4, NULL, 1659, NULL, NULL, '1659', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 484);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2092, 4, NULL, 1578, NULL, NULL, '1578', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 490);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2093, 4, NULL, 1641, 11, 10, '1641-11-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 488);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2094, 4, NULL, 1511, NULL, NULL, '1511', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4356);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2095, 4, NULL, 1564, NULL, NULL, '1564', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4358);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2096, 4, NULL, 1590, NULL, NULL, '1590', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8330);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2097, 4, NULL, 1661, NULL, NULL, '1661', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8329);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2098, 4, NULL, 1718, 11, 9, '1718-11-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4361);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2099, 4, NULL, 1610, 4, 30, '1610-04-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8335);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2100, 4, NULL, 1686, NULL, NULL, '1686', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8333);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2101, 4, NULL, 1601, NULL, NULL, '1601', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 818);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2102, 4, NULL, 1681, NULL, NULL, '1681', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 820);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2103, 4, NULL, 1578, NULL, NULL, '1578', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4365);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2104, 4, NULL, 1628, NULL, NULL, '1628', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4363);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2105, 4, NULL, 1711, 6, 7, '1711-06-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4373);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2106, 4, NULL, 1788, 7, 3, '1788-07-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4371);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2107, 4, NULL, 1585, 10, 28, '1585-10-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4376);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2108, 4, NULL, 1638, 5, 6, '1638-05-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4377);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2109, 4, NULL, 1619, NULL, NULL, '1619', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4380);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2110, 4, NULL, 1640, 12, 9, '1640-12-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4384);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2111, 4, NULL, 1718, 9, 8, '1718-09-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4385);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2112, 4, NULL, 1547, NULL, NULL, '1547', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4389);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2113, 4, NULL, 1625, NULL, NULL, '1625', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4387);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2114, 4, NULL, 1595, NULL, NULL, '1595', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4396);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2115, 4, NULL, 1648, 8, 26, '1648-08-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4394);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2116, 4, NULL, 1628, NULL, NULL, '1628', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4400);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2117, 4, NULL, 1697, NULL, NULL, '1697', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4401);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2118, 4, NULL, 1595, NULL, NULL, '1595', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4403);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2119, 4, NULL, 1667, NULL, NULL, '1667', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4404);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2120, 4, NULL, 1700, NULL, NULL, '1700', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4410);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2121, 4, NULL, 1730, NULL, NULL, '1730', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4413);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2122, 4, NULL, 1660, NULL, NULL, '1660', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4416);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2123, 4, NULL, 1736, NULL, NULL, '1736', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4417);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2124, 4, NULL, 1587, NULL, NULL, '1587', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4420);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2125, 4, NULL, 1657, NULL, NULL, '1657', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4418);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2126, 4, NULL, 1619, NULL, NULL, '1619', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4433);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2127, 4, NULL, 1679, NULL, NULL, '1679', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4431);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2128, 4, NULL, 1683, NULL, NULL, '1683', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4442);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2129, 4, NULL, 1750, NULL, NULL, '1750', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4440);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2130, 4, NULL, 1681, 10, 19, '1681-10-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4448);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2131, 4, NULL, 1750, 5, 18, '1750-05-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4446);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2132, 4, NULL, 1572, NULL, NULL, '1572', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4452);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2133, 4, NULL, 1571, NULL, NULL, '1571', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3262);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2134, 4, NULL, 1630, NULL, NULL, '1630', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3264);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2135, 4, NULL, 1602, NULL, NULL, '1602', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3409);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2136, 4, NULL, 1680, NULL, NULL, '1680', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3411);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2137, 4, NULL, 1583, NULL, NULL, '1583', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4466);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2138, 4, NULL, 1640, NULL, NULL, '1640', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4465);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2139, 4, NULL, 1593, NULL, NULL, '1593', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4473);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2140, 4, NULL, 1640, NULL, NULL, '1640', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4472);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2141, 4, NULL, 1609, NULL, NULL, '1609', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4481);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2142, 4, NULL, 1677, NULL, NULL, '1677', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4482);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2143, 4, NULL, 1702, NULL, NULL, '1702', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4489);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2144, 4, NULL, 1679, NULL, NULL, '1679', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4496);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2145, 4, NULL, 1620, NULL, NULL, '1620 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4503);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2146, 4, NULL, 1670, 3, 30, '1670-03-30', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4504);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2147, 4, NULL, 1649, NULL, NULL, '1649', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 466);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2148, 4, NULL, 1709, NULL, NULL, '1709', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 464);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2149, 4, NULL, 1512, NULL, NULL, '1512', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4507);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2150, 4, NULL, 1565, 1, 19, '1565-01-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4508);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2151, 4, NULL, 1591, NULL, NULL, '1591', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4511);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2152, 4, NULL, 1647, NULL, NULL, '1647', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4512);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2153, 4, NULL, 1586, NULL, NULL, '1586', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4518);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2154, 4, NULL, 1649, NULL, NULL, '1649', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4519);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2155, 4, NULL, 1676, 12, 26, '1676-12-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4529);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2156, 4, NULL, 1731, 5, 23, '1731-05-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4530);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2157, 4, NULL, 1474, NULL, NULL, '1474', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3599);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2158, 4, NULL, 1566, NULL, NULL, '1566', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3598);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2159, 4, NULL, 1601, NULL, NULL, '1601', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9796);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2160, 4, NULL, 1678, NULL, NULL, '1678', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9798);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2161, 4, NULL, 1634, NULL, NULL, '1634', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4533);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2162, 4, NULL, 1695, NULL, NULL, '1695', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4534);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2163, 4, NULL, 1574, NULL, NULL, '1574', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4538);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2164, 4, NULL, 1635, NULL, NULL, '1635', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4540);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2165, 4, NULL, 1487, NULL, NULL, '1487', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4541);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2166, 4, NULL, 1560, NULL, NULL, '1560', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4542);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2167, 4, NULL, 1577, NULL, NULL, '1577', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4547);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2168, 4, NULL, 1657, NULL, NULL, '1657', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4551);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2169, 4, NULL, 1736, NULL, NULL, '1736', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4552);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2170, 4, NULL, 1509, NULL, NULL, '1509', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4560);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2171, 4, NULL, 1574, NULL, NULL, '1574', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4562);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2172, 4, NULL, 1544, NULL, NULL, '1544', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 740);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2173, 4, NULL, 1616, NULL, NULL, '1616', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 742);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2174, 4, NULL, 1629, NULL, NULL, '1629', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4574);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2175, 4, NULL, 1699, NULL, NULL, '1699', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4575);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2176, 4, NULL, 1646, 7, NULL, '1646-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3769);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2177, 4, NULL, 1716, 11, 14, '1716-11-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3770);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2178, 4, NULL, 1577, NULL, NULL, '1577', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4577);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2179, 4, NULL, 1664, NULL, NULL, '1664', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4579);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2180, 4, NULL, 1659, NULL, NULL, '1659', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4585);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2181, 4, NULL, 1550, NULL, NULL, '1550', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9110);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2182, 4, NULL, 1629, NULL, NULL, '1629', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9112);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2183, 4, NULL, 1528, NULL, NULL, '1528', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 713);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2184, 4, NULL, 1591, NULL, NULL, '1591', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 715);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2185, 4, NULL, 1554, NULL, NULL, '1554', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 781);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2186, 4, NULL, 1623, NULL, NULL, '1623', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 783);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2187, 4, NULL, 1704, NULL, NULL, '1704', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4598);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2188, 4, NULL, 1657, 11, 14, '1657-11-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4601);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2189, 4, NULL, 1735, 5, 9, '1735-05-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4603);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2190, 4, NULL, 1547, 9, 18, '1547-09-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 42);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2191, 4, NULL, 1606, 3, 24, '1606-03-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 44);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2192, 4, NULL, 1710, NULL, NULL, '1710', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4667);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2193, 4, NULL, 1562, NULL, NULL, '1562', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4711);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2194, 4, NULL, 1625, NULL, NULL, '1625', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4712);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2195, 4, NULL, 1718, 11, 28, '1718-11-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4751);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2196, 4, NULL, 1782, 2, 20, '1782-02-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4752);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2197, 4, NULL, 1561, NULL, NULL, '1561', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4758);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2198, 4, NULL, 1612, NULL, NULL, '1612', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4760);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2199, 4, NULL, 1610, NULL, NULL, '1610', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6600);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2200, 4, NULL, 1559, NULL, NULL, '1559', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4766);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2201, 4, NULL, 1634, 3, 26, '1634-03-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4768);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2202, 4, NULL, 1681, NULL, NULL, '1681', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4778);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2203, 4, NULL, 1748, NULL, NULL, '1748', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4779);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2204, 4, NULL, 1729, 10, 14, '1729-10-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4783);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2205, 4, NULL, 1784, 10, 6, '1784-10-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4784);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2206, 4, NULL, 1580, NULL, NULL, '1580', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4788);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2207, 4, NULL, 1652, NULL, NULL, '1652', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4789);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2208, 4, NULL, 1583, NULL, NULL, '1583', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4140);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2209, 4, NULL, 1660, NULL, NULL, '1660', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4138);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2210, 4, NULL, 1528, NULL, NULL, '1528', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4791);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2211, 4, NULL, 1602, NULL, NULL, '1602', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4792);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2212, 4, NULL, 1616, NULL, NULL, '1616', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4798);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2213, 4, NULL, 1684, NULL, NULL, '1684', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4797);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2214, 4, NULL, 1612, 6, 12, '1612-06-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4802);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2215, 4, NULL, 1681, 7, 10, '1681-07-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4804);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2216, 4, NULL, 1610, NULL, NULL, '1610', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4810);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2217, 4, NULL, 1676, NULL, NULL, '1676', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4812);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2218, 4, NULL, 1571, NULL, NULL, '1571', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4821);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2219, 4, NULL, 1626, 9, 22, '1626-09-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4823);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2220, 4, NULL, 1596, NULL, NULL, '1596', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4273);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2221, 4, NULL, 1681, NULL, NULL, '1681', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4275);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2222, 4, NULL, 1673, NULL, NULL, '1673', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5234);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2223, 4, NULL, 1586, NULL, NULL, '1586', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4523);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2224, 4, NULL, 1661, NULL, NULL, '1661', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4525);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2225, 4, NULL, 1601, NULL, NULL, '1601', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4564);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2226, 4, NULL, 1676, NULL, NULL, '1676', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4566);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2227, 4, NULL, 1626, NULL, NULL, '1626', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4840);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2228, 4, NULL, 1666, NULL, NULL, '1666', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4839);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2229, 4, NULL, 1467, NULL, NULL, '1467', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9693);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2230, 4, NULL, 1550, NULL, NULL, '1550', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9691);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2231, 4, NULL, 1588, NULL, NULL, '1588', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4842);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2232, 4, NULL, 1644, NULL, NULL, '1644', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4844);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2233, 4, NULL, 1633, NULL, NULL, '1633', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4848);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2234, 4, NULL, 1689, NULL, NULL, '1689', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4847);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2235, 4, NULL, 1533, NULL, NULL, '1533', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4850);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2236, 4, NULL, 1583, NULL, NULL, '1583', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4854);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2237, 4, NULL, 1638, NULL, NULL, '1638', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4861);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2238, 4, NULL, 1715, NULL, NULL, '1715', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4860);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2239, 4, NULL, 1565, NULL, NULL, '1565', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4865);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2240, 4, NULL, 1628, 5, 7, '1628-05-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4863);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2241, 4, NULL, 1507, NULL, NULL, '1507', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 698);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2242, 4, NULL, 1576, NULL, NULL, '1576', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 700);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2243, 4, NULL, 1716, 3, 2, '1716-03-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4918);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2244, 4, NULL, 1787, 5, 11, '1787-05-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4919);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2245, 4, NULL, 1577, NULL, NULL, '1577', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4923);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2246, 4, NULL, 1649, NULL, NULL, '1649', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4925);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2247, 4, NULL, 1609, NULL, NULL, '1609', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4938);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2248, 4, NULL, 1682, 8, 23, '1682-08-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4937);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2249, 4, NULL, 1585, NULL, NULL, '1585', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4942);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2250, 4, NULL, 1661, 11, 11, '1661-11-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4943);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2251, 4, NULL, 1593, 8, 8, '1593-08-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4949);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2252, 4, NULL, 1664, 4, 25, '1664-04-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4947);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2253, 4, NULL, 1677, NULL, NULL, '1677', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4904);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2254, 4, NULL, 1656, NULL, NULL, '1656', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4955);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2255, 4, NULL, 1694, NULL, NULL, '1694', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4954);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2256, 4, NULL, 1542, NULL, NULL, '1542', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4959);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2257, 4, NULL, 1600, NULL, NULL, '1600', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4961);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2258, 4, NULL, 1580, NULL, NULL, '1580', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4970);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2259, 4, NULL, 1660, NULL, NULL, '1660', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4974);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2260, 4, NULL, 1536, NULL, NULL, '1536', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9712);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2261, 4, NULL, 1623, NULL, NULL, '1623', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9710);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2262, 4, NULL, 1554, NULL, NULL, '1554', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9708);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2263, 4, NULL, 1654, 11, 9, '1654-11-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4981);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2264, 4, NULL, 1725, 6, 20, '1725-06-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4983);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2265, 4, NULL, 1565, NULL, NULL, '1565', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 764);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2266, 4, NULL, 1621, NULL, NULL, '1621', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 766);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2267, 4, NULL, 1621, NULL, NULL, '1621', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5030);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2268, 4, NULL, 1695, NULL, NULL, '1695', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5032);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2269, 4, NULL, 1617, NULL, NULL, '1617', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5117);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2270, 4, NULL, 1676, NULL, NULL, '1676', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5118);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2271, 4, NULL, 1605, NULL, NULL, '1605 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5122);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2272, 4, NULL, 1668, 2, 25, '1668-02-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5123);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2273, 4, NULL, 1693, NULL, NULL, '1693', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5151);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2274, 4, NULL, 1594, NULL, NULL, '1594', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5171);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2275, 4, NULL, 1648, NULL, NULL, '1648', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5168);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2276, 4, NULL, 1485, NULL, NULL, '1485', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5173);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2277, 4, NULL, 1557, 5, 31, '1557-05-31', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5175);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2278, 4, NULL, 1568, NULL, NULL, '1568', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 600);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2279, 4, NULL, 1621, NULL, NULL, '1621', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 602);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2280, 4, NULL, 1570, NULL, NULL, '1570', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5180);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2281, 4, NULL, 1649, NULL, NULL, '1649', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5182);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2282, 4, NULL, 1586, NULL, NULL, '1586', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5187);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2283, 4, NULL, 1662, 2, 5, '1662-02-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5189);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2284, 4, NULL, 1553, NULL, NULL, '1553', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5197);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2285, 4, NULL, 1608, NULL, NULL, '1608', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5195);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2286, 4, NULL, 1548, NULL, NULL, '1548', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5201);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2287, 4, NULL, 1628, NULL, NULL, '1628', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5203);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2288, 4, NULL, 1602, NULL, NULL, '1602', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9561);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2289, 4, NULL, 1673, NULL, NULL, '1673', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9557);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2290, 4, NULL, 1578, NULL, NULL, '1578', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5213);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2291, 4, NULL, 1629, 6, 26, '1629-06-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5215);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2292, 4, NULL, 1666, NULL, NULL, '1666', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5229);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2293, 4, NULL, 1619, NULL, NULL, '1619', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9218);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2294, 4, NULL, 1687, NULL, NULL, '1687', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9219);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2295, 4, NULL, 1749, NULL, NULL, '1749', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5236);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2296, 4, NULL, 1705, 7, 26, '1705-07-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5261);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2297, 4, NULL, 1780, 4, 26, '1780-04-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5263);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2298, 4, NULL, 1576, NULL, NULL, '1576', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5275);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2299, 4, NULL, 1649, NULL, NULL, '1649', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5277);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2300, 4, NULL, 1556, NULL, NULL, '1556', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5307);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2301, 4, NULL, 1645, NULL, NULL, '1645', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5309);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2302, 4, NULL, 1641, 4, 28, '1641-04-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5320);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2303, 4, NULL, 1715, 8, 26, '1715-08-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5321);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2304, 4, NULL, 1469, NULL, NULL, '1469', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7163);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2305, 4, NULL, 1539, NULL, NULL, '1539', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7165);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2306, 4, NULL, 1595, NULL, NULL, '1595', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5349);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2307, 4, NULL, 1658, NULL, NULL, '1658', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5347);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2308, 4, NULL, 1594, NULL, NULL, '1594', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5365);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2309, 4, NULL, 1673, NULL, NULL, '1673', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5364);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2310, 4, NULL, 1589, NULL, NULL, '1589', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5375);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2311, 4, NULL, 1657, NULL, NULL, '1657', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5377);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2312, 4, NULL, 1630, NULL, NULL, '1630 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5379);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2313, 4, NULL, 1498, NULL, NULL, '1498', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5385);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2314, 4, NULL, 1576, NULL, NULL, '1576', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5383);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2315, 4, NULL, 1612, NULL, NULL, '1612', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5391);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2316, 4, NULL, 1659, NULL, NULL, '1659', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5389);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2317, 4, NULL, 1631, NULL, NULL, '1631', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5397);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2318, 4, NULL, 1704, NULL, NULL, '1704', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5395);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2319, 4, NULL, 1580, NULL, NULL, '1580 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5409);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2320, 4, NULL, 1631, 7, 28, '1631-07-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5411);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2321, 4, NULL, 1570, NULL, NULL, '1570 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5431);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2322, 4, NULL, 1614, NULL, NULL, '1614', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5428);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2323, 4, NULL, 1666, NULL, NULL, '1666', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5433);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2324, 4, NULL, 1711, NULL, NULL, '1711', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5435);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2325, 4, NULL, 1564, NULL, NULL, '1564', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5440);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2326, 4, NULL, 1616, NULL, NULL, '1616', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5495);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2327, 4, NULL, 1648, NULL, NULL, '1648', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5496);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2328, 4, NULL, 1748, NULL, NULL, '1748', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5499);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2329, 4, NULL, 1817, NULL, NULL, '1817', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5498);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2330, 4, NULL, 1635, NULL, NULL, '1635', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5523);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2331, 4, NULL, 1705, NULL, NULL, '1705', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5525);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2332, 4, NULL, 1647, NULL, NULL, '1647', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5529);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2333, 4, NULL, 1695, NULL, NULL, '1695', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5530);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2334, 4, NULL, 1660, NULL, NULL, '1660', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5534);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2335, 4, NULL, 1744, NULL, NULL, '1744', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5536);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2336, 4, NULL, 1607, NULL, NULL, '1607', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5540);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2337, 4, NULL, 1667, NULL, NULL, '1667', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5539);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2338, 4, NULL, 1550, NULL, NULL, '1550', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5566);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2339, 4, NULL, 1626, NULL, NULL, '1626', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5570);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2340, 4, NULL, 1690, NULL, NULL, '1690', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5617);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2341, 4, NULL, 1750, NULL, NULL, '1750', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5619);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2342, 4, NULL, 1716, NULL, NULL, '1716', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5648);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2343, 4, NULL, 1773, NULL, NULL, '1773', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5647);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2344, 4, NULL, 1597, 12, 8, '1597-12-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5685);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2345, 4, NULL, 1686, 2, 22, '1686-02-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5687);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2346, 4, NULL, 1564, NULL, NULL, '1564', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5692);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2347, 4, NULL, 1625, NULL, NULL, '1625', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5693);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2348, 4, NULL, 1590, NULL, NULL, '1590 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5697);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2349, 4, NULL, 1640, NULL, NULL, '1640', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5696);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2350, 4, NULL, 1620, 9, 21, '1620-09-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5703);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2351, 4, NULL, 1697, 7, 11, '1697-07-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5705);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2352, 4, NULL, 1622, NULL, NULL, '1622', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5723);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2353, 4, NULL, 1697, NULL, NULL, '1697', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5725);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2354, 4, NULL, 1506, NULL, NULL, '1506', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5755);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2355, 4, NULL, 1802, NULL, NULL, '1802', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6698);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2356, 4, NULL, 1580, NULL, NULL, '1580', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5753);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2357, 4, NULL, 1694, 7, 28, '1694-07-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7133);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2358, 4, NULL, 1766, 8, 18, '1766-08-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7135);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2359, 4, NULL, 1610, NULL, NULL, '1610', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5782);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2360, 4, NULL, 1602, NULL, NULL, '1602', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5786);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2361, 4, NULL, 1651, 2, 9, '1651-02-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5790);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2362, 4, NULL, 1575, NULL, NULL, '1575 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5799);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2363, 4, NULL, 1649, NULL, NULL, '1649', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5795);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2364, 4, NULL, 1661, 4, 15, '1661-04-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5808);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2365, 4, NULL, 1725, 4, 28, '1725-04-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5807);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2366, 4, NULL, 1554, NULL, NULL, '1554', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5831);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2367, 4, NULL, 1611, NULL, NULL, '1611', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5829);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2368, 4, NULL, 1592, NULL, NULL, '1592', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5859);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2369, 4, NULL, 1649, NULL, NULL, '1649', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5861);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2370, 4, NULL, 1528, NULL, NULL, '1528', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5886);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2371, 4, NULL, 1575, NULL, NULL, '1575', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5884);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2372, 4, NULL, 1648, NULL, NULL, '1648', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5891);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2373, 4, NULL, 1711, 12, 21, '1711-12-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5893);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2374, 4, NULL, 1657, NULL, NULL, '1657', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5897);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2375, 4, NULL, 1720, NULL, NULL, '1720', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5896);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2376, 4, NULL, 1550, NULL, NULL, '1550 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5901);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2377, 4, NULL, 1606, NULL, NULL, '1606', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5899);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2378, 4, NULL, 1502, NULL, NULL, '1502', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5909);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2379, 4, NULL, 1664, NULL, NULL, '1664', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7240);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2380, 4, NULL, 1612, NULL, NULL, '1612', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5971);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2381, 4, NULL, 1695, NULL, NULL, '1695', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5972);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2382, 4, NULL, 1643, NULL, NULL, '1643', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5996);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2383, 4, NULL, 1697, NULL, NULL, '1697', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5995);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2384, 4, NULL, 1529, NULL, NULL, '1529', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7246);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2385, 4, NULL, 1597, NULL, NULL, '1597', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7248);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2386, 4, NULL, 1619, NULL, NULL, '1619', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6060);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2387, 4, NULL, 1686, NULL, NULL, '1686', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6064);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2388, 4, NULL, 1570, NULL, NULL, '1570', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7268);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2389, 4, NULL, 1637, NULL, NULL, '1637', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7266);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2390, 4, NULL, 1633, NULL, NULL, '1633', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6067);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2391, 4, NULL, 1696, NULL, NULL, '1696', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6071);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2392, 4, NULL, 1671, NULL, NULL, '1671', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6076);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2393, 4, NULL, 1737, NULL, NULL, '1737', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6075);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2394, 4, NULL, 1564, NULL, NULL, '1564', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 692);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2395, 4, NULL, 1594, NULL, NULL, '1594', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6082);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2396, 4, NULL, 1657, NULL, NULL, '1657', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6080);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2397, 4, NULL, 1597, NULL, NULL, '1597', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6088);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2398, 4, NULL, 1657, NULL, NULL, '1657', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6087);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2399, 4, NULL, 1636, NULL, NULL, '1636', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6092);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2400, 4, NULL, 1610, NULL, NULL, '1610', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6091);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2401, 4, NULL, 1599, NULL, NULL, '1599', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6112);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2402, 4, NULL, 1649, NULL, NULL, '1649', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6114);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2403, 4, NULL, 1710, NULL, NULL, '1710', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7139);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2404, 4, NULL, 1728, NULL, NULL, '1728', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6125);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2405, 4, NULL, 1503, NULL, NULL, '1503', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6127);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2406, 4, NULL, 1566, NULL, NULL, '1566', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6129);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2407, 4, NULL, 1724, NULL, NULL, '1724', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6131);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2408, 4, NULL, 1565, NULL, NULL, '1565', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6139);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2409, 4, NULL, 1626, 1, 20, '1626-01-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6135);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2410, 4, NULL, 1689, NULL, NULL, '1689', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7144);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2411, 4, NULL, 1755, NULL, NULL, '1755', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7146);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2412, 4, NULL, 1558, NULL, NULL, '1558', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6148);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2413, 4, NULL, 1602, NULL, NULL, '1602', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6147);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2414, 4, NULL, 1530, NULL, NULL, '1530', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6149);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2415, 4, NULL, 1566, 10, 28, '1566-10-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6150);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2416, 4, NULL, 1583, NULL, NULL, '1583', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7422);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2417, 4, NULL, 1652, NULL, NULL, '1652', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7420);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2418, 4, NULL, 1612, NULL, NULL, '1612', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7335);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2419, 4, NULL, 1733, 4, 23, '1733-04-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6161);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2420, 4, NULL, 1806, NULL, NULL, '1806', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6160);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2421, 4, NULL, 1658, NULL, NULL, '1658', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6164);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2422, 4, NULL, 1684, 9, 5, '1684-09-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6173);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2423, 4, NULL, 1574, NULL, NULL, '1574', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6181);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2424, 4, NULL, 1620, NULL, NULL, '1620', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6179);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2425, 4, NULL, 1520, NULL, NULL, '1520', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7155);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2426, 4, NULL, 1604, NULL, NULL, '1604', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7153);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2427, 4, NULL, 1594, NULL, NULL, '1594', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6187);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2428, 4, NULL, 1662, NULL, NULL, '1662', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6188);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2429, 4, NULL, 1594, NULL, NULL, '1594', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6190);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2430, 4, NULL, 1658, NULL, NULL, '1658', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6191);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2431, 4, NULL, 1646, NULL, NULL, '1646', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6217);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2432, 4, NULL, 1723, NULL, NULL, '1723', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6215);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2433, 4, NULL, 1640, NULL, NULL, '1640', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6220);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2434, 4, NULL, 1709, NULL, NULL, '1709', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6222);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2435, 4, NULL, 1705, NULL, NULL, '1705', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7607);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2436, 4, NULL, 1527, NULL, NULL, '1527', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6235);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2437, 4, NULL, 1569, NULL, NULL, '1569', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6233);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2438, 4, NULL, 1608, NULL, NULL, '1608', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6240);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2439, 4, NULL, 1681, NULL, NULL, '1681', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6242);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2440, 4, NULL, 1589, NULL, NULL, '1589', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6247);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2441, 4, NULL, 1644, NULL, NULL, '1644', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6249);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2442, 4, NULL, 1484, NULL, NULL, '1484', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9540);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2443, 4, NULL, 1553, NULL, NULL, '1553', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9536);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2444, 4, NULL, 1462, NULL, NULL, '1462', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7485);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2445, 4, NULL, 1525, NULL, NULL, '1525', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7487);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2446, 4, NULL, 1570, NULL, NULL, '1570', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6265);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2447, 4, NULL, 1629, NULL, NULL, '1629', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6263);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2448, 4, NULL, 1534, NULL, NULL, '1534', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7499);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2449, 4, NULL, 1611, NULL, NULL, '1611', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7501);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2450, 4, NULL, 1651, NULL, NULL, '1651', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6273);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2451, 4, NULL, 1734, NULL, NULL, '1734', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6271);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2452, 4, NULL, 1588, NULL, NULL, '1588', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6282);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2453, 4, NULL, 1659, 2, 6, '1659-02-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6284);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2454, 4, NULL, 1646, 1, 19, '1646-01-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6290);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2455, 4, NULL, 1703, 8, 7, '1703-08-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6292);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2456, 4, NULL, 1675, 7, 7, '1675-07-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6296);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2457, 4, NULL, 1749, 4, 3, '1749-04-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6295);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2458, 4, NULL, 1570, 3, 18, '1570-03-18', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6303);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2459, 4, NULL, 1634, 6, 8, '1634-06-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6301);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2460, 4, NULL, 1698, 1, 8, '1698-01-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6307);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2461, 4, NULL, 1764, NULL, NULL, '1764', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6308);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2462, 4, NULL, 1722, NULL, NULL, '1722', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6312);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2463, 4, NULL, 1801, NULL, NULL, '1801', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6311);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2464, 4, NULL, 1701, NULL, NULL, '1701', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6315);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2465, 4, NULL, 1765, NULL, NULL, '1765', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6317);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2466, 4, NULL, 1745, NULL, NULL, '1745', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6326);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2467, 4, NULL, 1821, NULL, NULL, '1821', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6325);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2468, 4, NULL, 1599, NULL, NULL, '1599', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6329);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2469, 4, NULL, 1661, 5, 26, '1661-05-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6331);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2470, 4, NULL, 1545, NULL, NULL, '1545', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6342);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2471, 4, NULL, 1608, NULL, NULL, '1608', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6340);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2472, 4, NULL, 1652, NULL, NULL, '1652', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6347);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2473, 4, NULL, 1721, NULL, NULL, '1721', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6345);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2474, 4, NULL, 1515, NULL, NULL, '1515', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9700);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2475, 4, NULL, 1572, NULL, NULL, '1572', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9702);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2476, 4, NULL, 1654, NULL, NULL, '1654', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6362);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2477, 4, NULL, 1723, NULL, NULL, '1723', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6364);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2478, 4, NULL, 1587, NULL, NULL, '1587', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7622);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2479, 4, NULL, 1663, NULL, NULL, '1663', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7624);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2480, 4, NULL, 1581, NULL, NULL, '1581', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6372);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2481, 4, NULL, 1647, NULL, NULL, '1647', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6370);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2482, 4, NULL, 1594, NULL, NULL, '1594', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6375);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2483, 4, NULL, 1662, NULL, NULL, '1662', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6376);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2484, 4, NULL, 1642, 7, 2, '1642-07-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6390);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2485, 4, NULL, 1703, 10, 5, '1703-10-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6392);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2486, 4, NULL, 1586, NULL, NULL, '1586', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4224);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2487, 4, NULL, 1658, NULL, NULL, '1658', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4226);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2488, 4, NULL, 1635, NULL, NULL, '1635', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7613);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2489, 4, NULL, 1597, NULL, NULL, '1597', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6398);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2490, 4, NULL, 1661, 5, 17, '1661-05-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6400);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2491, 4, NULL, 1611, NULL, NULL, '1611', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6403);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2492, 4, NULL, 1675, NULL, NULL, '1675', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6405);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2493, 4, NULL, 1526, NULL, NULL, '1526', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6409);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2494, 4, NULL, 1611, NULL, NULL, '1611', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6411);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2495, 4, NULL, 1570, NULL, NULL, '1570', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6413);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2496, 4, NULL, 1653, 2, 7, '1653-02-07', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6418);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2497, 4, NULL, 1693, 4, 3, '1693-04-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6420);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2498, 4, NULL, 1576, NULL, NULL, '1576', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6427);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2499, 4, NULL, 1647, 1, 3, '1647-01-03', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6425);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2500, 4, NULL, 1574, NULL, NULL, '1574', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6431);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2501, 4, NULL, 1655, NULL, NULL, '1655', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6433);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2502, 4, NULL, 1650, 7, 2, '1650-07-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6442);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2503, 4, NULL, 1713, 3, 17, '1713-03-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6438);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2504, 4, NULL, 1598, 4, 17, '1598-04-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7717);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2505, 4, NULL, 1671, 6, 25, '1671-06-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7721);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2506, 4, NULL, 1614, 9, 6, '1614-09-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7719);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2507, 4, NULL, 1589, NULL, NULL, '1589', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6446);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2508, 4, NULL, 1664, 10, 20, '1664-10-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6448);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2509, 4, NULL, 1606, NULL, NULL, '1606', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6444);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2510, 4, NULL, 1602, 8, 8, '1602-08-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 74);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2511, 4, NULL, 1675, 10, 27, '1675-10-27', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 76);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2512, 4, NULL, 1535, NULL, NULL, '1535 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6463);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2513, 4, NULL, 1616, NULL, NULL, '1616', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6465);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2514, 4, NULL, 1607, 11, 14, '1607-11-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6481);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2515, 4, NULL, 1686, 11, 2, '1686-11-02', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6483);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2516, 4, NULL, 1548, NULL, NULL, '1548', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6503);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2517, 4, NULL, 1615, 3, 8, '1615-03-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6501);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2518, 4, NULL, 1734, NULL, NULL, '1734', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6512);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2519, 4, NULL, 1774, NULL, NULL, '1774', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6510);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2520, 4, NULL, 1615, NULL, NULL, '1615', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6516);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2521, 4, NULL, 1713, NULL, NULL, '1713', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6519);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2522, 4, NULL, 1768, NULL, NULL, '1768', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6521);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2523, 4, NULL, 1562, NULL, NULL, '1562', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6527);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2524, 4, NULL, 1632, NULL, NULL, '1632', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6529);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2525, 4, NULL, 1688, 9, 16, '1688-09-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6541);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2526, 4, NULL, 1742, 1, 6, '1742-01-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6539);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2527, 4, NULL, 1600, NULL, NULL, '1600', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6545);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2528, 4, NULL, 1661, NULL, NULL, '1661', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6543);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2529, 4, NULL, 1723, NULL, NULL, '1723', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6550);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2530, 4, NULL, 1630, NULL, NULL, '1630', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6558);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2531, 4, NULL, 1699, NULL, NULL, '1699', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6556);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2532, 4, NULL, 1702, 7, 25, '1702-07-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6562);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2533, 4, NULL, 1757, 1, 25, '1757-01-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6564);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2534, 4, NULL, 1613, 4, 10, '1613-04-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6569);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2535, 4, NULL, 1677, 12, 15, '1677-12-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6567);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2536, 4, NULL, 1600, NULL, NULL, '1600', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6571);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2537, 4, NULL, 1665, NULL, NULL, '1665', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6570);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2538, 4, NULL, 1565, NULL, NULL, '1565', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6573);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2539, 4, NULL, 1606, 4, 14, '1606-04-14', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6575);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2540, 4, NULL, 1553, NULL, NULL, '1553', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6579);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2541, 4, NULL, 1612, NULL, NULL, '1612', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6581);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2542, 4, NULL, 1699, NULL, NULL, '1699', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6590);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2543, 4, NULL, 1766, NULL, NULL, '1766', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6591);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2544, 4, NULL, 1550, NULL, NULL, '1550', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6594);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2545, 4, NULL, 1623, NULL, NULL, '1623', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6596);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2546, 4, NULL, 1547, NULL, NULL, '1547', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6599);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2547, 4, NULL, 1593, NULL, NULL, '1593', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6598);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2548, 4, NULL, 1550, NULL, NULL, '1550', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6601);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2549, 4, NULL, 1701, 11, 25, '1701-11-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6607);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2550, 4, NULL, 1774, 2, 11, '1774-02-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6608);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2551, 4, NULL, 1664, 8, 8, '1664-08-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6616);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2552, 4, NULL, 1734, NULL, NULL, '1734', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6614);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2553, 4, NULL, 1652, 9, 12, '1652-09-12', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6619);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2554, 4, NULL, 1711, 7, 6, '1711-07-06', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6621);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2555, 4, NULL, 1587, NULL, NULL, '1587', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6629);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2556, 4, NULL, 1663, NULL, NULL, '1663', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6628);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2557, 4, NULL, 1720, NULL, NULL, '1720 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6633);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2558, 4, NULL, 1800, NULL, NULL, '1800', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6635);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2559, 4, NULL, 1618, NULL, NULL, '1618', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6641);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2560, 4, NULL, 1667, NULL, NULL, '1667', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6643);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2561, 4, NULL, 1484, 8, 23, '1484-08-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6650);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2562, 4, NULL, 1558, 10, 21, '1558-10-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6652);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2563, 4, NULL, 1623, NULL, NULL, '1623', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4871);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2564, 4, NULL, 1708, NULL, NULL, '1708', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4869);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2565, 4, NULL, 1511, NULL, NULL, '1511', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4874);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2566, 4, NULL, 1587, NULL, NULL, '1587', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4876);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2567, 4, NULL, 1589, NULL, NULL, '1589', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4878);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2568, 4, NULL, 1653, NULL, NULL, '1653', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4880);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2569, 4, NULL, 1573, 7, 25, '1573-07-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7967);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2570, 4, NULL, 1650, NULL, NULL, '1650', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7965);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2571, 4, NULL, 1595, NULL, NULL, '1595', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7963);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2572, 4, NULL, 1628, NULL, NULL, '1628', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6684);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2573, 4, NULL, 1683, NULL, NULL, '1683', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6682);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2574, 4, NULL, 1722, NULL, NULL, '1722', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6696);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2575, 4, NULL, 1630, 2, 8, '1630-02-08', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 519);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2576, 4, NULL, 1717, 1, 28, '1717-01-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 517);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2577, 4, NULL, 1652, 3, 10, '1652-03-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 520);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2578, 4, NULL, 1676, NULL, NULL, '1676', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6703);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2579, 4, NULL, 1648, NULL, NULL, '1648', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6708);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2580, 4, NULL, 1693, NULL, NULL, '1693', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6707);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2581, 4, NULL, 1572, NULL, NULL, '1572', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9330);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2582, 4, NULL, 1637, NULL, NULL, '1637', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9328);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2583, 4, NULL, 1490, NULL, NULL, '1490', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 568);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2584, 4, NULL, 1573, NULL, NULL, '1573', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 566);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2585, 4, NULL, 1622, NULL, NULL, '1622', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6712);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2586, 4, NULL, 1710, NULL, NULL, '1710', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6714);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2587, 4, NULL, 1583, NULL, NULL, '1583', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6717);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2588, 4, NULL, 1642, NULL, NULL, '1642', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6716);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2589, 4, NULL, 1722, NULL, NULL, '1722', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6720);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2590, 4, NULL, 1607, 11, 28, '1607-11-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9395);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2591, 4, NULL, 1667, 6, 5, '1667-06-05', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9393);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2592, 4, NULL, 1657, NULL, NULL, '1657', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6725);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2593, 4, NULL, 1636, NULL, NULL, '1636', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6738);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2594, 4, NULL, 1696, NULL, NULL, '1696', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6736);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2595, 4, NULL, 1606, NULL, NULL, '1606', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6742);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2596, 4, NULL, 1666, NULL, NULL, '1666', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6744);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2597, 4, NULL, 1593, NULL, NULL, '1593', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6748);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2598, 4, NULL, 1596, NULL, NULL, '1596', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6754);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2599, 4, NULL, 1655, NULL, NULL, '1655', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6752);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2600, 4, NULL, 1562, NULL, NULL, '1562', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6760);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2601, 4, NULL, 1618, 7, 26, '1618-07-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6758);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2602, 4, NULL, 1580, NULL, NULL, '1580', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6763);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2603, 4, NULL, 1626, NULL, NULL, '1626', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6764);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2604, 4, NULL, 1605, NULL, NULL, '1605', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6768);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2605, 4, NULL, 1659, 1, 19, '1659-01-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6770);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2606, 4, NULL, 1534, NULL, NULL, '1534', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6773);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2607, 4, NULL, 1612, NULL, NULL, '1612', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6772);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2608, 4, NULL, 1495, NULL, NULL, '1495', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 672);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2609, 4, NULL, 1560, NULL, NULL, '1560', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 670);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2610, 4, NULL, 1494, NULL, NULL, '1494', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7159);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2611, 4, NULL, 1563, NULL, NULL, '1563', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7161);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2612, 4, NULL, 1698, NULL, NULL, '1698', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6783);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2613, 4, NULL, 1770, NULL, NULL, '1770', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6781);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2614, 4, NULL, 1526, NULL, NULL, '1526', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6791);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2615, 4, NULL, 1610, NULL, NULL, '1610', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6793);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2616, 4, NULL, 1511, NULL, NULL, '1511', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 683);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2617, 4, NULL, 1564, NULL, NULL, '1564', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 685);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2618, 4, NULL, 1630, NULL, NULL, '1630 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6802);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2619, 4, NULL, 1711, NULL, NULL, '1711', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6800);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2620, 4, NULL, 1585, NULL, NULL, '1585', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6808);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2621, 4, NULL, 1654, NULL, NULL, '1654', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6806);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2622, 4, NULL, 1714, NULL, NULL, '1714', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6811);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2623, 4, NULL, 1801, NULL, NULL, '1801', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6813);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2624, 4, NULL, 1535, NULL, NULL, '1535', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6818);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2625, 4, NULL, 1598, NULL, NULL, '1598', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6816);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2626, 4, NULL, 1615, NULL, NULL, '1615', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6825);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2627, 4, NULL, 1673, NULL, NULL, '1673', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6824);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2628, 4, NULL, 1647, NULL, NULL, '1647', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6833);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2629, 4, NULL, 1701, NULL, NULL, '1701', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6835);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2630, 4, NULL, 1524, NULL, NULL, '1524', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6841);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2631, 4, NULL, 1569, NULL, NULL, '1569', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6839);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2632, 4, NULL, 1524, NULL, NULL, '1524', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6848);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2633, 4, NULL, 1593, 8, 19, '1593-08-19', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6849);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2634, 4, NULL, 1564, NULL, NULL, '1564', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8223);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2635, 4, NULL, 1617, NULL, NULL, '1617', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8225);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2636, 4, NULL, 1668, 1, 21, '1668-01-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6852);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2637, 4, NULL, 1738, 5, 25, '1738-05-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6853);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2638, 4, NULL, 1633, NULL, NULL, '1633', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6858);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2639, 4, NULL, 1705, NULL, NULL, '1705', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6859);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2640, 4, NULL, 1591, NULL, NULL, '1591', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6865);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2641, 4, NULL, 1675, NULL, NULL, '1675', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6866);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2642, 4, NULL, 1572, NULL, NULL, '1572', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6868);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2643, 4, NULL, 1632, NULL, NULL, '1632', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6870);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2644, 4, NULL, 1582, 3, 17, '1582-03-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6877);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2645, 4, NULL, 1657, 8, 25, '1657-08-25', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6879);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2646, 4, NULL, 1487, NULL, NULL, '1487', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6886);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2647, 4, NULL, 1559, NULL, NULL, '1559', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6884);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2648, 4, NULL, 1522, NULL, NULL, '1522', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6888);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2649, 4, NULL, 1620, NULL, NULL, '1620 p', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9254);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2650, 4, NULL, 1672, NULL, NULL, '1672', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9256);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2651, 4, NULL, 1547, NULL, NULL, '1547', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6890);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2652, 4, NULL, 1606, NULL, NULL, '1606', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6892);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2653, 4, NULL, 1613, NULL, NULL, '1613', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6897);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2654, 4, NULL, 1667, NULL, NULL, '1667', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6896);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2655, 4, NULL, 1509, NULL, NULL, '1509', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8236);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2656, 4, NULL, 1588, NULL, NULL, '1588', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8234);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2657, 4, NULL, 1596, 1, 11, '1596-01-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6900);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2658, 4, NULL, 1675, 4, NULL, '1675-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6901);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2659, 4, NULL, 1623, 7, 31, '1623-07-31', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6910);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2660, 4, NULL, 1699, 10, 15, '1699-10-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6908);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2661, 4, NULL, 1623, NULL, NULL, '1623', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6916);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2662, 4, NULL, 1676, 10, 11, '1676-10-11', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6917);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2663, 4, NULL, 1592, NULL, NULL, '1592', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6919);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2664, 4, NULL, 1675, NULL, NULL, '1675', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6923);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2665, 4, NULL, 1611, 11, 10, '1611-11-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6921);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2666, 4, NULL, 1730, 3, 4, '1730-03-04', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6928);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2667, 4, NULL, 1728, 12, 9, '1728-12-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6933);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2668, 4, NULL, 1788, 6, 22, '1788-06-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6932);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2669, 4, NULL, 1622, NULL, NULL, '1622', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6941);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2670, 4, NULL, 1684, NULL, NULL, '1684', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6943);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2671, 4, NULL, 1619, NULL, NULL, '1619', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6951);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2672, 4, NULL, 1695, NULL, NULL, '1695', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6953);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2673, 4, NULL, 1697, NULL, NULL, '1697', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6955);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2674, 4, NULL, 1728, NULL, NULL, '1728', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6956);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2675, 4, NULL, 1567, NULL, NULL, '1567', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6958);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2676, 4, NULL, 1624, NULL, NULL, '1624', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6960);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2677, 4, NULL, 1650, NULL, NULL, '1650', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6964);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2678, 4, NULL, 1710, NULL, NULL, '1710', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6963);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2679, 4, NULL, 1534, NULL, NULL, '1534', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8262);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2680, 4, NULL, 1596, NULL, NULL, '1596', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8264);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2681, 4, NULL, 1558, NULL, NULL, '1558', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8260);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2682, 4, NULL, 1653, NULL, NULL, '1653', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8274);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2683, 4, NULL, 1726, NULL, NULL, '1726', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8276);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2684, 4, NULL, 1512, NULL, NULL, '1512', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6968);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2685, 4, NULL, 1568, NULL, NULL, '1568', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6969);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2686, 4, NULL, 1562, NULL, NULL, '1562', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6972);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2687, 4, NULL, 1655, NULL, NULL, '1655', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6973);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2688, 4, NULL, 1651, NULL, NULL, '1651', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6978);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2689, 4, NULL, 1723, NULL, NULL, '1723', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6979);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2690, 4, NULL, 1658, 8, 28, '1658-08-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6981);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2691, 4, NULL, 1729, 12, 26, '1729-12-26', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6983);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2692, 4, NULL, 1436, NULL, NULL, '1436', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8296);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2693, 4, NULL, 1517, NULL, NULL, '1517', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8294);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2694, 4, NULL, 1631, NULL, NULL, '1631', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6989);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2695, 4, NULL, 1713, NULL, NULL, '1713', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6987);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2696, 4, NULL, 1623, NULL, NULL, '1623', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6994);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2697, 4, NULL, 1687, NULL, NULL, '1687', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6992);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2698, 4, NULL, 1543, NULL, NULL, '1543', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6999);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2699, 4, NULL, 1597, 3, 20, '1597-03-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6998);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2700, 4, NULL, 1624, NULL, NULL, '1624', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7005);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2701, 4, NULL, 1695, NULL, NULL, '1695', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7003);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2702, 4, NULL, 1578, NULL, NULL, '1578', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7015);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2703, 4, NULL, 1646, NULL, NULL, '1646', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7013);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2704, 4, NULL, 1588, NULL, NULL, '1588', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8508);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2705, 4, NULL, 1657, NULL, NULL, '1657', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8512);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2706, 4, NULL, 1583, NULL, NULL, '1583', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7019);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2707, 4, NULL, 1644, NULL, NULL, '1644', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7017);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2708, 4, NULL, 1491, NULL, NULL, '1491', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7023);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2709, 4, NULL, 1554, NULL, NULL, '1554', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7022);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2710, 4, NULL, 1573, NULL, NULL, '1573', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7029);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2711, 4, NULL, 1639, NULL, NULL, '1639', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7027);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2712, 4, NULL, 1616, NULL, NULL, '1616', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7031);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2713, 4, NULL, 1699, NULL, NULL, '1699', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7030);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2714, 4, NULL, 1616, 11, 23, '1616-11-23', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7035);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2715, 4, NULL, 1703, 9, 28, '1703-09-28', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7033);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2716, 4, NULL, 1681, NULL, NULL, '1681', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7045);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2717, 4, NULL, 1770, NULL, NULL, '1770', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7043);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2718, 4, NULL, 1625, NULL, NULL, '1625', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7050);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2719, 4, NULL, 1699, NULL, NULL, '1699', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7049);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2720, 4, NULL, 1593, NULL, NULL, '1593', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7058);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2721, 4, NULL, 1660, NULL, NULL, '1660', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 545);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2722, 4, NULL, 1737, NULL, NULL, '1737', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 544);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2723, 4, NULL, 1571, NULL, NULL, '1571', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7062);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2724, 4, NULL, 1639, NULL, NULL, '1639', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7064);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2725, 4, NULL, 1722, NULL, NULL, '1722', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7072);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2726, 4, NULL, 1780, NULL, NULL, '1780', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7071);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2727, 4, NULL, 1679, 1, 24, '1679-01-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 570);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2728, 4, NULL, 1754, 4, 9, '1754-04-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 572);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2729, 4, NULL, 1687, NULL, NULL, '1687', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7080);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2730, 4, NULL, 1745, NULL, NULL, '1745', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7081);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2731, 4, NULL, 1460, NULL, NULL, '1460', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 456);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2732, 4, NULL, 1532, NULL, NULL, '1532', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 458);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2733, 4, NULL, 1671, NULL, NULL, '1671', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 478);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2734, 4, NULL, 1639, NULL, NULL, '1639', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7086);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2735, 4, NULL, 1724, NULL, NULL, '1724', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7085);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2736, 4, NULL, 1718, NULL, NULL, '1718', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 558);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2737, 4, NULL, 1777, NULL, NULL, '1777', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 557);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2738, 4, NULL, 1736, 9, 16, '1736-09-16', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 577);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2739, 4, NULL, 1807, 8, 17, '1807-08-17', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 579);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2740, 4, NULL, 1719, NULL, NULL, '1719', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 586);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2741, 4, NULL, 1759, NULL, NULL, '1759', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 584);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2742, 4, NULL, 1673, 11, 15, '1673-11-15', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 588);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2743, 4, NULL, 1655, NULL, NULL, '1655', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 592);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2744, 4, NULL, 1656, NULL, NULL, '1656', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 659);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2745, 4, NULL, 1713, NULL, NULL, '1713', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 658);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2746, 4, NULL, 1596, NULL, NULL, '1596', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 732);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2747, 4, NULL, 1542, NULL, NULL, '1542', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7236);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2748, 4, NULL, 1626, NULL, NULL, '1626', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7234);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2749, 4, NULL, 1528, NULL, NULL, '1528', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 705);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2750, 4, NULL, 1580, NULL, NULL, '1580', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 709);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2751, 4, NULL, 1490, NULL, NULL, '1490', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7307);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2752, 4, NULL, 1546, NULL, NULL, '1546', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7309);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2753, 4, NULL, 1587, NULL, NULL, '1587', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7316);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2754, 4, NULL, 1626, NULL, NULL, '1626', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7314);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2755, 4, NULL, 1497, NULL, NULL, '1497', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6321);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2756, 4, NULL, 1565, NULL, NULL, '1565', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6322);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2757, 4, NULL, 1597, NULL, NULL, '1597', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7322);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2758, 4, NULL, 1608, NULL, NULL, '1608', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7330);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2759, 4, NULL, 1684, NULL, NULL, '1684', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7332);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2760, 4, NULL, 1591, NULL, NULL, '1591', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 760);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2761, 4, NULL, 1631, 3, 10, '1631-03-10', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7340);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2762, 4, NULL, 1646, NULL, NULL, '1646', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7342);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2763, 4, NULL, 1705, 1, 21, '1705-01-21', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7344);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2764, 4, NULL, 1530, NULL, NULL, '1530', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7346);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2765, 4, NULL, 1579, NULL, NULL, '1579', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7348);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2766, 4, NULL, 1583, 6, 24, '1583-06-24', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7355);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2767, 4, NULL, 1663, NULL, NULL, '1663', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7357);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2768, 4, NULL, 1584, NULL, NULL, '1584', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9485);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2769, 4, NULL, 1644, 8, 22, '1644-08-22', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9487);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2770, 4, NULL, 1597, NULL, NULL, '1597', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7382);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2771, 4, NULL, 1658, NULL, NULL, '1658', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7380);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2772, 4, NULL, 1679, NULL, NULL, '1679', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7291);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2773, 4, NULL, 1744, NULL, NULL, '1744', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7287);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2774, 4, NULL, 1622, NULL, NULL, '1622', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7407);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2775, 4, NULL, 1686, NULL, NULL, '1686', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7403);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2776, 4, NULL, 1697, NULL, NULL, '1697', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7282);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_connaissance) VALUES (2777, 4, NULL, 1764, NULL, NULL, '1764', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7284);
INSERT INTO date_unite_connaissance (pk_date_unite_connaissance, fk_type_date, libelle_selon_source, annee, mois, jour, date_recomposee, certitude_date, qualificatif_date, marge_date, heures, minutes, secondes, descriptif, notes, fk_unite_c