<?php

require_once("../connexion_base_individuelle.inc");
require_once("../html_parts.inc");
require_once("../traitement_slashes_magic_quotes.inc");
require_once("../fonctions.inc");

// prépare le tableau des variables préfixées avec 'form', fonction utilisateur, cf. echo $form_typeListe;
$tableau_variables = request_variables_sans_slashes($_REQUEST, 'form');

// prépare les variables du tableau
foreach ($tableau_variables as $cle => $element) {
	${$cle} = $element;
}

// récupère l'identifiant de l'objet
if (isset($_REQUEST['cleObjet'])) {
	$cle_objet = $_REQUEST['cleObjet'];
}
else { $cle_objet = '';
echo 'Attention :manque la clé de l\'objet' ; }


// récupère l'identifiant du type d'association
if (isset($_REQUEST['typeAssociation'])) {
	$type_association = $_REQUEST['typeAssociation'];
}
else { $type_association = '';
echo 'Attention :manque le type d\'association' ;
}






//ouvre la connection avec la fonction externe et récupère la variable
$connexion = connexion();


/* Noms standard de l'objet  */

// cette requête liste le ou les Noms standard de l'objet
$requete = "SELECT fk_objet,
	array_to_string(ARRAY (SELECT unnest(array_agg(nom)) ORDER BY 1),', ') AS noms_standard_objet
	FROM tables_objet.nom_objet
	WHERE fk_objet = ".$cle_objet.
	"AND   si_nom_standard
	GROUP BY fk_objet";


// effectuer la requête
$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

// récupérer le résultat dans une variable
if ($resultat) {
	$liste_resultats = pg_fetch_assoc($resultat);
	$liste_noms_standard = $liste_resultats['noms_standard_objet'];
}
else {
	$liste_noms_standard = 'Erreur : manque le nom !';
}

// Libérer le résultat
pg_free_result($resultat);

// ao = association objets

$actif_ao = '><a href="objet_associations.php?cleObjet='.$cle_objet.'&typeAssociation=ao"';
$actif_19 = '><a href="objet_associations.php?cleObjet='.$cle_objet.'&typeAssociation=19"';
$actif_hierarchie = '><a href="objet_associations.php?cleObjet='.$cle_objet.'&typeAssociation=hierarchie"';
$actif_hierarchie_classes = '><a href="objet_associations.php?cleObjet='.$cle_objet.'&typeAssociation=hierarchie_classes"';
$actif_uc = '><a href="objet_associations.php?cleObjet='.$cle_objet.'&typeAssociation=uc"';



switch ($type_association) {
	case 19 :
		$titre_liste_parents = 'classes auxquelles appartient cet objet';
		$titre_liste_enfants = 'objets classés par cet objet';
		$actif_19 = ' class="active"><a';
		break;
	case 'ao' :
		$titre_liste_parents = 'objets associés à cet objet';
		$titre_liste_enfants = 'objets concernés par l\'association';
		$actif_ao = ' class="active"><a';
		break;
	case 'hierarchie' :
		$titre_liste_parents = 'des objets associés à cet objet (hiérarchie)';
		$titre_liste_enfants = '';
		$actif_hierarchie = ' class="active"><a';
		break;
	case 'hierarchie_classes' :
		$titre_liste_parents = 'des classes associées à cet objet  (hiérarchie)';
		$titre_liste_enfants = '';
		$actif_hierarchie_classes = ' class="active"><a';
		break;
	case 'uc' :
		$titre_liste_parents = 'Unités de connaissance auxquelles est associé cet objet';
		$titre_liste_enfants = '';
		$actif_uc = ' class="active"><a';

}


/*Avec cet 'if' on fait la distinction entre les associations entre objets
 * et celles avec les Unités de connaissance via les Rôles*/

if ($type_association !=='uc' and $type_association !=='hierarchie' and $type_association !=='hierarchie_classes') {

	$nombre_uc_associees = '';


	// Préparer la requête qui cherche tous les objets associés
	if($type_association =='ao') {$requete = "SELECT *
		FROM tables_objet.v_objets_associes
		WHERE (fk_type_association_objet = 17 OR fk_type_association_objet = 18 OR fk_type_association_objet = 20 OR fk_type_association_objet = 79)
		AND fk_objet_concerne = ".$cle_objet.
		" ORDER BY nom_objet_associe" ;}
	else {$requete = "SELECT *
		FROM tables_objet.v_objets_associes
		WHERE fk_type_association_objet =".$type_association.
		" AND fk_objet_concerne = ".$cle_objet.
		" ORDER BY nom_objet_associe" ;
	}

	// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

	$nombre_objets_associes = pg_num_rows($resultat);

	// initialiser le tableau des noms
	$tableau_objets_associes = array() ;

	// Récupérer le résultat et le mettre dans un tableau
	while ($objet_resultat = pg_fetch_object ($resultat)) {

		$cle_objet_associe = $objet_resultat->fk_objet_associe;
		$cle_association = $objet_resultat->pk_associer_objet;
		$fk_type_association = $objet_resultat->fk_type_association_objet;

		switch ($fk_type_association) {
			case 17 :
				$specification_objet_associe = 'Documente:';
				break;
			case 18 :
				$specification_objet_associe = 'Reproduit:';
				break;
			case 20 :
				$specification_objet_associe = 'Compose:';
				break;
			case 79 :
				$specification_objet_associe = 'Concerne:';

		}

		if ( $fk_type_association == 19) {$affichage_type_association ='';}
		else { $affichage_type_association = '<td>'.$specification_objet_associe.'</td>';
		}


		// On sort le tableau résultant de la requête
		// supprimé : target="_blank"
		$tableau_objets_associes[] = '<tr>'.
		$affichage_type_association.
			'<td>'.$objet_resultat->nom_objet_associe.'</td>
			<td><a href="objet_associations.php?cleObjet='.$cle_objet_associe.'&typeAssociation='.$type_association.'" target="_blank">'.$objet_resultat->fk_objet_associe.'</a></td>
			<td>'.$objet_resultat->sous_type_objet_associe.'</td>
			<td>'.$objet_resultat->annee_debut_objet_associe.'</td>
			<td>'.$objet_resultat->reference_precise.'</td><td>'.$objet_resultat->descriptif.
			'</td><td>'.$objet_resultat->notes.'</td>
			<td><a href="association_objets_insert_update.php?cleAssociation='.$cle_association.'&cleObjet='.$cle_objet.'&cleObjetAssocie='.$cle_objet_associe.'">'.$cle_association.'</a></td></tr>';
	}


	// Ces fonctions sont définies dans : html_parts.inc

	if ($type_association == 19)
	{$tableau_objets_associes_output = liste_champs_objets_associes($tableau_objets_associes);}
	else { $tableau_objets_associes_output = liste_champs_objets_associes_avec_type($tableau_objets_associes);}



	$table_objets_associes_debut = '<div class="scrollingAreaObjetsAssocies">
				<table class="listeObjetsAssocies scrollable">
				<thead>'.
	$tableau_objets_associes_output.
				'</thead><tbody>';

	// Libérer le résultat
	pg_free_result($resultat);



	// Préparer la requête qui cherche tous les objets enfants ou concernés
	if($type_association =='ao') {$requete = "SELECT *
		FROM tables_objet.v_objets_associes
		WHERE (fk_type_association_objet = 17 OR fk_type_association_objet = 18 OR fk_type_association_objet = 20 OR fk_type_association_objet = 79)
		AND fk_objet_associe = ".$cle_objet.
		" ORDER BY nom_objet_concerne" ;}
	// Prépare l'affichage dans l'onglet 'Classes'
	elseif($type_association == 19) {
		$requete = "SELECT *
		FROM tables_objet.v_objets_associes
		WHERE fk_type_association_objet =".$type_association.
		" AND fk_objet_associe = ".$cle_objet.
		// Ne retient que les objets abstraits :
		// pour chercher d'autres objets, utiliser l'interface de recherche
		" AND type_objet_concerne = 'Objet abstrait'
		ORDER BY nom_objet_concerne" ;
	}
	else {$requete = "SELECT *
		FROM tables_objet.v_objets_associes
		WHERE fk_type_association_objet =".$type_association.
		" AND fk_objet_associe = ".$cle_objet.
		" ORDER BY nom_objet_concerne" ;
	}

	// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

	$nombre_objets_concernes = pg_num_rows($resultat);


	// initialiser le tableau des noms
	$tableau_objets_concernes = array() ;

	// Récupérer le résultat et le mettre dans un tableau
	while ($objet_resultat = pg_fetch_object ($resultat)) {

		$fk_type_association = $objet_resultat->fk_type_association_objet;

		switch ($fk_type_association) {
			case 17 :
				$specification_objet_concerne = 'Est documenté par:';
				break;
			case 18 :
				$specification_objet_concerne = 'Est reproduit par:';
				break;
			case 20 :
				$specification_objet_concerne = 'Est composé par:';
				break;
			case 79 :
				$specification_objet_concerne = 'Est concerné par:';

		}


		if ( $fk_type_association == 19) {$affichage_type_association ='';}
		else { $affichage_type_association = '<td>'.$specification_objet_concerne.'</td>';
		}


		// On sort le tableau résultant de la requête
		$tableau_objets_concernes[] = '<tr>'
		.$affichage_type_association.
			'<td>'.$objet_resultat->nom_objet_concerne.'</td>
			<td><a href="objet_associations.php?cleObjet='.$objet_resultat->fk_objet_concerne.'&typeAssociation='.$type_association.'" target="_blank">'.$objet_resultat->fk_objet_concerne.'</a></td>
			<td>'.$objet_resultat->sous_type_objet_concerne.'</td>
			<td>'.$objet_resultat->annee_debut_objet_concerne.'</td>
			<td>'.$objet_resultat->reference_precise.'</td><td>'.$objet_resultat->descriptif.
			'</td><td>'.$objet_resultat->notes.'</td>
			<td>'.$objet_resultat->pk_associer_objet.'</td></tr>';
	}





	// Ces fonctions sont définies dans : html_parts.inc

	if ($type_association == 19)
	{$tableau_objets_concernes_output = liste_champs_objets_associes($tableau_objets_concernes);}
	else { $tableau_objets_concernes_output = liste_champs_objets_associes_avec_type($tableau_objets_concernes);}


	if ($nombre_objets_concernes > 0) {
		$nombre_objets_concernes_output = ' ('.$nombre_objets_concernes.')';
	}
	else { $nombre_objets_concernes_output = '';}

	$table_objets_concernes ='<div><h4>Liste des '.$titre_liste_enfants.$nombre_objets_concernes_output.
		'</h4>
		<div class="scrollingAreaObjetsConcernes">
		<table class="listeObjetsAssocies scrollable">
		<thead>'.$tableau_objets_concernes_output.
		'</thead><tbody>';

	$fin_objet_concernes = '</tbody></table></div></div>';

	// Libérer le résultat
	pg_free_result($resultat);


}


/* Prépare les valeurs de l'onglet qui affiche les Unités de connaissance associées à l'objet */

elseif ($type_association =='uc') {

	$nombre_objets_associes = '';
	$table_objets_concernes = '';
	$nombre_objets_concernes = '';
	$fin_objet_concernes = '';
	$type_uc = '';
	$cle_type_uc = '';



	// préparer la requête qui liste les types d'unités de connaissance
	$requete = "SELECT pk_type_unite_connaissance,
		       nom
		FROM tables_types.type_unite_connaissance
		WHERE si_utilise IS TRUE
		ORDER BY nom;";

	//ouvre la connection avec la fonction externe et récupère la variable
	$connexion = connexion();


	// effectuer la requête qui liste les types de cet objet
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

	//préparer le résultat pour l'utilisation dans le formulaire
	$liste_types = array();
	while ($types = pg_fetch_object($resultat))
	{
		$liste_types[] = '<option value="'.$types->pk_type_unite_connaissance.'">'.$types->nom.'</option>';
	}

	// Libérer le résultat
	pg_free_result($resultat);


	$selectTypeUC = '';
	$nombre_uc_associees = '';

	if(!empty($form_typeUC)) $selectTypeUC = "AND cle_type_uc = ".$form_typeUC." ";
	else $selectTypeUC=''; $form_typeUC = '' ;
	if(!empty($form_typeTri)) $selectTypeTri = " ORDER BY date_standard ".$form_typeTri;
	else $selectTypeTri= " ORDER BY date_standard DESC";




	$requete ="SELECT  type_role,
					       date_standard,
					       sujet_uc,
					       autres_objets_uc,
					       type_uc,
					       autres_objets_uc,
					       pk_unite_connaissance,
					       valeur_numerique,
					       unite_mesure,
					       libelle_selon_source,
					       descriptif,
					       cle_type_uc
					FROM tables_uc.v_role_avec_uc
					WHERE fk_objet_associe =".$cle_objet.
	$selectTypeUC.$selectTypeTri;



	// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

	$nombre_uc_associees = pg_num_rows($resultat);

	// initialiser le tableau des noms
	$tableau_uc_associees = array() ;

	// Récupérer le résultat et le mettre dans un tableau
	while ($objet_resultat = pg_fetch_object($resultat)) {


		$type_uc = $objet_resultat->type_uc;
		$cle_type_uc = $objet_resultat->cle_type_uc;

		// On sort le tableau résultant de la requête
		$tableau_uc_associees[] = '<tr>
			<td>'.$objet_resultat->unite_mesure.'</td>
			<td>'.$objet_resultat->valeur_numerique.'</td>
			<td>'.$objet_resultat->libelle_selon_source.'</td>
			<td>'.$objet_resultat->type_role.'</td>
			<td><a href="../unite_connaissance/unite_connaissance_update.php?cleUC='.$objet_resultat->pk_unite_connaissance.'" target="_blank">'.$objet_resultat->pk_unite_connaissance.'</a></td>
			<td>'.$objet_resultat->date_standard.'</td>
			<td>'.$type_uc.'</td>
			<td>'.$objet_resultat->descriptif.'</td>
			<td>'.$objet_resultat->sujet_uc.'</td>
			<td>'.$objet_resultat->autres_objets_uc.'</td>
			</tr>';
	}

	if ($nombre_uc_associees > 0) {
		$table_objets_associes_debut = '<div class="scrollingAreaUnitesConnaissance">
						<table class="listeObjetsAssocies scrollable">
						<thead>
							<th>Unité de mesure</th>
							<th>Valeur</th>
							<th>Libellé objet selon la source</th>
							<th>Type rôle</th>
							<th>Clé UC</th>
							<th>Date UC</th>
							<th>Type UC</th>
							<th>Unité de connaissance</th>
							<th>Sujet UC</th>
							<th>Autres objets</th>
						</thead><tbody>';
	} else $table_objets_associes_debut = '';

	// Libérer le résultat
	pg_free_result($resultat);



}

//Traite le cas de l'onglet hiérarchie
elseif ($type_association =='hierarchie') {

	$nombre_objets_associes = '';
	$table_objets_concernes = '';
	$nombre_objets_concernes = '';
	$fin_objet_concernes = '';
	$type_uc = '';
	$cle_type_uc = '';





	$requete ="SELECT * FROM vues_sql.objet_ascendants_descendants (".$cle_objet.")";



	// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

	$nombre_objets_associes = pg_num_rows($resultat);

	// initialiser le tableau des noms
	$tableau_uc_associees = array() ;

	// Récupérer le résultat et le mettre dans un tableau
	while ($objet_resultat = pg_fetch_object($resultat)) {
			
		// traite l'affichage de l'objet CONCERNE auquel correspond la fiche actuelle
		if($objet_resultat->profondeur == 1) {
			$cle_objet_concerne= '...' ;
			$objet_concerne = '...';
		}
		else {
			$cle_objet_concerne = '<a href="objet_associations.php?cleObjet='.$objet_resultat->fk_objet_concerne.
						'&typeAssociation='.$type_association.'" target="_blank">'.$objet_resultat->fk_objet_concerne.'</a>'; 
			$objet_concerne = $objet_resultat->objet_concerne.' ['.$objet_resultat->type_objet_concerne.']';
		}
		// traite l'affichage de l'objet ASSOCIE auquel correspond la fiche actuelle
		if($objet_resultat->profondeur == -1) {
			$cle_objet_associe = '...' ;
			$objet_associe = '...';
		}
		else {
			$cle_objet_associe = '<a href="objet_associations.php?cleObjet='.$objet_resultat->fk_objet_associe.
						'&typeAssociation='.$type_association.'" target="_blank">'.$objet_resultat->fk_objet_associe.'</a>'; 
			$objet_associe = $objet_resultat->objet_associe.' ['.$objet_resultat->type_objet_associe.']';
		}
			


		// On sort le tableau résultant de la requête
		$tableau_objets_associes[] = '<tr>
			<td>'.$objet_resultat->profondeur.'</td>
			<td>'.$cle_objet_concerne.'</td>
			<td>'.$objet_concerne.'</td>
			<td>'.$objet_resultat->type_association.'</td>
			<td>'.$cle_objet_associe.'</td>
			<td>'.$objet_associe.'</td>
			<td>'.$objet_resultat->_path.'</td>
			</tr>';
	}

	if ($nombre_objets_associes > 0) {
		$table_objets_associes_debut = '<div class="scrollingAreaUnitesConnaissance">
						<table class="listeObjetsAssocies scrollable">
						<thead>
							<th>Profondeur</th>
							<th>Cle objet concerne</th>
							<th>Objet concerne</th>
							<th>Type association</th>
							<th>Cle objet associe</th>
							<th>Objet associe</th>
							<th>Chemin</th>
						</thead><tbody>';
	} else $table_objets_associes_debut = '';

	// Libérer le résultat
	pg_free_result($resultat);

}


//Traite le cas de l'onglet hiérarchie des classes
elseif ($type_association =='hierarchie_classes') {

	$nombre_objets_associes = '';
	$table_objets_concernes = '';
	//		$nombre_objets_concernes = '';
	//		$fin_objet_concernes = '';
	//		$type_uc = '';
	//		$cle_type_uc = '';


	$requete ="SELECT *
					FROM vues_sql.objet_ascendants_descendants (".$cle_objet.")
					WHERE type_association LIKE 'classé%'
					AND   type_objet_concerne = 'Objet abstrait';";



	// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

	$nombre_objets_associes = pg_num_rows($resultat);

	// initialiser le tableau des noms
	$tableau_uc_associees = array() ;

	// Récupérer le résultat et le mettre dans un tableau
	while ($objet_resultat = pg_fetch_object($resultat)) {
			
		// traite l'affichage de l'objet CONCERNE auquel correspond la fiche actuelle
		if($objet_resultat->profondeur == 1) {
			$cle_objet_concerne= '...' ;
			$objet_concerne = '...';
		}
		else {
			$cle_objet_concerne = '<a href="objet_associations.php?cleObjet='.$objet_resultat->fk_objet_concerne.
						'&typeAssociation='.$type_association.'" target="_blank">'.$objet_resultat->fk_objet_concerne.'</a>'; 
			$objet_concerne = $objet_resultat->objet_concerne.' ['.$objet_resultat->type_objet_concerne.']';
		}
		// traite l'affichage de l'objet ASSOCIE auquel correspond la fiche actuelle
		if($objet_resultat->profondeur == -1) {
			$cle_objet_associe = '...' ;
			$objet_associe = '...';
		}
		else {
			$cle_objet_associe = '<a href="objet_associations.php?cleObjet='.$objet_resultat->fk_objet_associe.
						'&typeAssociation='.$type_association.'" target="_blank">'.$objet_resultat->fk_objet_associe.'</a>'; 
			$objet_associe = $objet_resultat->objet_associe.' ['.$objet_resultat->type_objet_associe.']';
		}
			


		// On sort le tableau résultant de la requête
		$tableau_objets_associes[] = '<tr>
			<td>'.$objet_resultat->profondeur.'</td>
			<td>'.$cle_objet_concerne.'</td>
			<td>'.$objet_concerne.'</td>
			<td>'.$objet_resultat->type_association.'</td>
			<td>'.$cle_objet_associe.'</td>
			<td>'.$objet_associe.'</td>
			<td>'.$objet_resultat->_path.'</td>
			</tr>';
	}

	if ($nombre_objets_associes > 0) {
		$table_objets_associes_debut = '<div class="scrollingAreaUnitesConnaissance">
						<table class="listeObjetsAssocies scrollable">
						<thead>
							<th>Profondeur</th>
							<th>Cle objet concerne</th>
							<th>Objet concerne</th>
							<th>Type association</th>
							<th>Cle objet associe</th>
							<th>Objet associe</th>
							<th>Chemin</th>
						</thead><tbody>';
	} else $table_objets_associes_debut = '';

	// Libérer le résultat
	pg_free_result($resultat);

}
// Fermer la connexion
pg_close($connexion);

?>




<!-- Commence ici la partie HTML -->

<?php html_header ('Associations de l\'objet', '../css/objet.css'); ?>


<div class="en_tete_page">
<h1><?php echo $liste_noms_standard.' – <span class="font_smaller">'.$cle_objet.' (ObPe'.$cle_objet.') [Associations]</span>' ?></h1>
</div>

<div class="renvois">
<p><a href="objet_insert_update.php?cleObjet=<?php echo $cle_objet; ?>">Propriétés
de l'objet</a>
– <a href="objet_formulaire_insert.php" target="_blank">Créer un nouvel
objet</a> – <!-- Ajoute les boutons nécessaires pour bouger entre les fiches 
et pour naviguer dans la base de données --> <?php html_autres_possibilites() ; ?>
</p>

<p>
<form style="float: right"
	action="../unite_connaissance/unite_connaissance_formulaire_insert.php"
	method="get" target="_blank"><input type="hidden" name="si_insert"
	value="t" /> <input type="hidden" name="cleObjet"
	value="<?php echo $cle_objet; ?>" /> <input type="submit"
	value="Nouvelle unité de connaissance" style="float: left" /></form>
<form style="float: right" action="association_objets_insert_update.php"
	method="get"><input type="hidden" name="si_insert" value="t" /> <input
	type="hidden" name="cleObjet" value="<?php echo $cle_objet; ?>" /> <input
	type="submit" value="Nouvelle association" style="float: left" /></form>
</p>

</div>
<br />
<br />



<!-- Crée les onglets -->
<div id="menu">
<ul id="onglets">
	<li <?php echo $actif_ao;?>>Associations entre objets</a></li>
	<li <?php echo $actif_19;?>>Classes </a></li>
	<li <?php echo $actif_hierarchie;?>>Hiérarchie</a></li>
	<li <?php echo $actif_hierarchie_classes;?>>Hiérarchie classes</a></li>
	<li <?php echo $actif_uc;?>>Unités de connaissance </a></li>

</ul>
</div>

<div><?php
if ($type_association !== 'uc') {
	echo '<h4>Liste des '.$titre_liste_parents;
	if ($nombre_objets_associes > 0) echo ' ('.$nombre_objets_associes.')';
	// contains est une fonction définie dans le fichier des fonctions
	// si l'onglet 'hierarchie' est actif, il ne contient pas 'href'
	if (contains('href', $actif_hierarchie)==false)
	echo '<form style="float: right" action="../visualisation/hierarchies_d3_force_graph.php"
	method="get" target="_blank"><input type="hidden" name="cleObjet" value="'.$cle_objet.'"/> <input
	type="submit" value="Visualiser sous forme de graphe" style="float: left" />
	</form></h4>';
	else echo '</h4>' ;
}


if ($type_association == 'uc') {
	echo '<table class="invisible">
		<tr><td>Liste des Unités de connaissance ';
	if($type_uc and $cle_type_uc = $form_typeUC) echo 'de type "'.$type_uc.'" ';
	echo 'auxquelles est associé cet objet';
	if ($nombre_uc_associees > 0) echo ' ('.$nombre_uc_associees.')</td>';
	echo '<td><form action="objet_associations.php" method="get">
		 Type de l\'UC : <select name="typeUC">
		<option selected value=""></option>';
	foreach ($liste_types as $type) {
		echo $type;
	}
	echo '</select>
	Tri : <select name="typeTri">
	<option selected="selected" value="DESC">déscendant</option>
	<option value="ASC">ascendant</option>
	</select>
		<input type="hidden" name="cleObjet" value="'.$cle_objet.'">
		<input type="hidden" name="typeAssociation" value="uc"/>
		<input type="submit" value="Chercher" />
		</form></td></tr></table><br/>';
}

?> <?php echo $table_objets_associes_debut;
if ($nombre_objets_associes > 0) {
	foreach ($tableau_objets_associes as $ligne_objet_associe) {
		echo $ligne_objet_associe;
	}
}
if ($nombre_uc_associees > 0) {
	foreach ($tableau_uc_associees as $ligne_uc_associee) {
		echo $ligne_uc_associee;
	}
}?>
</tbody>
</table>
</div>

</div>
<br />


<?php 	echo $table_objets_concernes;
if ($nombre_objets_concernes > 0) {
	foreach ($tableau_objets_concernes as $ligne_objet_concerne) {
		echo $ligne_objet_concerne;}
}
echo $fin_objet_concernes;?>




</body>
</html>
