<?php

require_once("../connexion_base_individuelle.inc");
require_once("../html_parts.inc");

// déclarer variables
$url_objet = '';
$cle_objet_bhp = '';
$descriptif = '';
$notes = '';

// préparer la resuête qui liste les types de cet objet
$requete = "SELECT t1.pk_parametre,
		     	t1.nom
				FROM tables_types.parametre t1
				WHERE type_parametre = 'type_objet'
				ORDER BY t1.nom;";

//ouvre la connection avec la fonction externe et récupère la variable
$connexion = connexion();



// effectuer la requête qui liste les types de cet objet
$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

//préparer le résultat pour l'utilisation dans le formulaire
$liste_types = array();
while ($types = pg_fetch_object($resultat))
{
	if($types->pk_parametre == 13) $selected = ' selected="selected" '; else $selected = '';
	$liste_types[] = '<option '.$selected.'value="'.$types->pk_parametre.'">'.$types->nom.'</option>';
}

// Libérer le résultat
pg_free_result($resultat);


/* Certitude année début – fin */

// préparer la requête qui liste les paramètres année début – fin
$requete = "SELECT t1.pk_parametre,
       		t1.nom AS nom
			FROM tables_types.parametre t1 
			WHERE t1.type_parametre = 'certitude_date_annee'
			ORDER BY t1.nom;";

// effectuer la requête
$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

//préparer le résultat pour l'utilisation dans le formulaire
$liste_certitude_date = array();
while ($lignes = pg_fetch_object($resultat)) {
	$liste_certitude_date[] = '<option value="'.$lignes->pk_parametre.'">'.$lignes->nom.'</option>';
}

// Libérer le résultat
pg_free_result($resultat);
//tester si la valeur POST du nom est renseignée
$nom_POST= '';
$url_script= '';


// Fermer la connexion
pg_close($connexion);

?>



<?php html_header('Nouvel objet', '../css/objet.css'); ?>


<div>
<h2>Saisir un nouvel objet</h2>

<form action="objet_insert_update.php" method="post">
<p><span style="vertical-align: top;"> Nom (<strong>champs obligatoire</strong>)
: </span><textarea rows="2" cols="120" name="nom">zot</textarea> <?php if ($maj_bhp == 'activée') echo '<p>Clé objet BHP (<strong>obligatoire si le nom n\'est pas renseigné</strong>) : <input type="text" size="15" name="cleObjetBHP" value=""/>' ?>
</p>
<p>Type d'objet : <select name="typeObjet">
<?php foreach ($liste_types as $type) {
	echo $type;
}?>
</select> (Le sous-type doit être renseigné après la création de
l'objet)</p>
<p>Année début (format nombre) : <input type="text" size=3
	" name="anneeDebut" /> Mois début : <input type="text" size="1"
	name="moisDebut" /> Jour début : <input type="text" size="1"
	name="jourDebut" /> Certitude année début : <select
	name="certitudeDateDebut">
	<?php foreach ($liste_certitude_date as $valeur_certitude_dd) {
		echo $valeur_certitude_dd;
	}?>
</select></p>
<p>Année fin (format nombre) : <input type="text" size="3"
	name="anneeFin" /> Mois fin : <input type="text" size="1"
	name="moisFin" /> Jour fin : <input type="text" size="1" name="jourFin" />
Certitude année fin : <select name="certitudeDateFin">
<?php foreach ($liste_certitude_date as $valeur_certitude_dd) {
	echo $valeur_certitude_dd;
}?>
</select></p>

<?php html_descriptif_notes(3, $descriptif, $notes) ; ?>

<p>Url de l'objet : <input type="text" size="70" name="urlObjet"
	value="<?php echo $url_objet; ?>" /></p>
<input type="hidden" name="effectuer" value="insert"></input>
<p><input type="submit" value="Créer l'objet" /></p>
</form>

<?php html_autres_possibilites();?></div>
</body>
</html>
