--
-- PostgreSQL database dump
--

-- Dumped from database version 9.1.6
-- Dumped by pg_dump version 9.1.6
-- Started on 2012-11-02 22:25:45

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 8 (class 2615 OID 17977)
-- Name: tables_objet; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA tables_objet;


ALTER SCHEMA tables_objet OWNER TO postgres;

SET search_path = tables_objet, pg_catalog;

--
-- TOC entry 194 (class 1255 OID 17978)
-- Dependencies: 8
-- Name: majuscule_sans_accents(text); Type: FUNCTION; Schema: tables_objet; Owner: postgres
--

CREATE FUNCTION majuscule_sans_accents(text) RETURNS text
    LANGUAGE sql
    AS $_$
/* fonction modifiée par rapport à celle en ligne, ajoutée un translate avec minuscules */
SELECT translate(upper(translate($1, 'àáâåçèéêëìíîïñòóôõöùûüýÿ', 'aaaaceeeeiiiiinooooouuuyy')),  'ÁÀÂÄÃÅÇÉÈÊËÍÏÎÌÑÓÒÔÖÕÚÙÛÜÝ', 'AAAAAACEEEEIIIINOOOOOUUUUY')
$_$;


ALTER FUNCTION tables_objet.majuscule_sans_accents(text) OWNER TO postgres;

SET default_with_oids = false;

--
-- TOC entry 174 (class 1259 OID 17979)
-- Dependencies: 8
-- Name: associer_objet; Type: TABLE; Schema: tables_objet; Owner: postgres
--

CREATE TABLE associer_objet (
    pk_associer_objet integer NOT NULL,
    fk_type_association_objet integer,
    fk_objet_concerne integer,
    fk_objet_associe integer,
    descriptif text,
    reference_precise text,
    notes text
);


ALTER TABLE tables_objet.associer_objet OWNER TO postgres;

--
-- TOC entry 175 (class 1259 OID 17985)
-- Dependencies: 174 8
-- Name: associer_objet_pk_associer_objet_seq; Type: SEQUENCE; Schema: tables_objet; Owner: postgres
--

CREATE SEQUENCE associer_objet_pk_associer_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tables_objet.associer_objet_pk_associer_objet_seq OWNER TO postgres;

--
-- TOC entry 1932 (class 0 OID 0)
-- Dependencies: 175
-- Name: associer_objet_pk_associer_objet_seq; Type: SEQUENCE OWNED BY; Schema: tables_objet; Owner: postgres
--

ALTER SEQUENCE associer_objet_pk_associer_objet_seq OWNED BY associer_objet.pk_associer_objet;


--
-- TOC entry 1933 (class 0 OID 0)
-- Dependencies: 175
-- Name: associer_objet_pk_associer_objet_seq; Type: SEQUENCE SET; Schema: tables_objet; Owner: postgres
--

SELECT pg_catalog.setval('associer_objet_pk_associer_objet_seq', 12, true);


--
-- TOC entry 176 (class 1259 OID 17987)
-- Dependencies: 1913 8
-- Name: nom_objet; Type: TABLE; Schema: tables_objet; Owner: postgres
--

CREATE TABLE nom_objet (
    pk_nom_objet integer NOT NULL,
    si_nom_standard boolean,
    nom text,
    descriptif text,
    date_debut character varying(10),
    notes_dd text,
    date_fin character varying(10),
    notes_df text,
    code_langue character(3),
    notes text,
    creation timestamp without time zone DEFAULT now(),
    fk_objet integer,
    fk_type integer
);


ALTER TABLE tables_objet.nom_objet OWNER TO postgres;

--
-- TOC entry 1934 (class 0 OID 0)
-- Dependencies: 176
-- Name: COLUMN nom_objet.pk_nom_objet; Type: COMMENT; Schema: tables_objet; Owner: postgres
--

COMMENT ON COLUMN nom_objet.pk_nom_objet IS '
';


--
-- TOC entry 1935 (class 0 OID 0)
-- Dependencies: 176
-- Name: COLUMN nom_objet.fk_objet; Type: COMMENT; Schema: tables_objet; Owner: postgres
--

COMMENT ON COLUMN nom_objet.fk_objet IS '
';


--
-- TOC entry 177 (class 1259 OID 17994)
-- Dependencies: 176 8
-- Name: nom_objet_pk_nom_objet_seq; Type: SEQUENCE; Schema: tables_objet; Owner: postgres
--

CREATE SEQUENCE nom_objet_pk_nom_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tables_objet.nom_objet_pk_nom_objet_seq OWNER TO postgres;

--
-- TOC entry 1936 (class 0 OID 0)
-- Dependencies: 177
-- Name: nom_objet_pk_nom_objet_seq; Type: SEQUENCE OWNED BY; Schema: tables_objet; Owner: postgres
--

ALTER SEQUENCE nom_objet_pk_nom_objet_seq OWNED BY nom_objet.pk_nom_objet;


--
-- TOC entry 1937 (class 0 OID 0)
-- Dependencies: 177
-- Name: nom_objet_pk_nom_objet_seq; Type: SEQUENCE SET; Schema: tables_objet; Owner: postgres
--

SELECT pg_catalog.setval('nom_objet_pk_nom_objet_seq', 26, true);


--
-- TOC entry 178 (class 1259 OID 17996)
-- Dependencies: 1915 8
-- Name: objet; Type: TABLE; Schema: tables_objet; Owner: postgres
--

CREATE TABLE objet (
    pk_objet integer NOT NULL,
    cle_objet_bhp character varying(20),
    descriptif text,
    notes_dd text,
    notes_df text,
    notes text,
    creation timestamp without time zone DEFAULT now(),
    fk_type_objet integer,
    certitude_dd smallint,
    certitude_df smallint,
    url_objet text,
    fk_sous_type_objet integer,
    annee_debut integer,
    annee_fin integer,
    mois_debut integer,
    jour_debut integer,
    mois_fin integer,
    jour_fin integer,
    cle_importation integer
);


ALTER TABLE tables_objet.objet OWNER TO postgres;

--
-- TOC entry 1938 (class 0 OID 0)
-- Dependencies: 178
-- Name: COLUMN objet.annee_debut; Type: COMMENT; Schema: tables_objet; Owner: postgres
--

COMMENT ON COLUMN objet.annee_debut IS 'La date est exprimée seulement en années';


--
-- TOC entry 1939 (class 0 OID 0)
-- Dependencies: 178
-- Name: COLUMN objet.annee_fin; Type: COMMENT; Schema: tables_objet; Owner: postgres
--

COMMENT ON COLUMN objet.annee_fin IS 'La date est exprimée seulement en années';


--
-- TOC entry 179 (class 1259 OID 18003)
-- Dependencies: 8 178
-- Name: objet_pk_objet_seq; Type: SEQUENCE; Schema: tables_objet; Owner: postgres
--

CREATE SEQUENCE objet_pk_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tables_objet.objet_pk_objet_seq OWNER TO postgres;

--
-- TOC entry 1940 (class 0 OID 0)
-- Dependencies: 179
-- Name: objet_pk_objet_seq; Type: SEQUENCE OWNED BY; Schema: tables_objet; Owner: postgres
--

ALTER SEQUENCE objet_pk_objet_seq OWNED BY objet.pk_objet;


--
-- TOC entry 1941 (class 0 OID 0)
-- Dependencies: 179
-- Name: objet_pk_objet_seq; Type: SEQUENCE SET; Schema: tables_objet; Owner: postgres
--

SELECT pg_catalog.setval('objet_pk_objet_seq', 22, true);


--
-- TOC entry 180 (class 1259 OID 18005)
-- Dependencies: 1910 8
-- Name: v_noms_standards_objets_dans_ordre_chronologique; Type: VIEW; Schema: tables_objet; Owner: postgres
--

CREATE VIEW v_noms_standards_objets_dans_ordre_chronologique AS
    SELECT nom_objet.fk_objet, array_to_string(ARRAY(SELECT unnest(array_agg(nom_objet.nom)) AS unnest ORDER BY unnest(array_agg(nom_objet.date_debut))), ', '::text) AS nom FROM nom_objet WHERE (nom_objet.si_nom_standard IS TRUE) GROUP BY nom_objet.fk_objet ORDER BY array_to_string(ARRAY(SELECT unnest(array_agg(nom_objet.nom)) AS unnest ORDER BY unnest(array_agg(nom_objet.date_debut))), ', '::text);


ALTER TABLE tables_objet.v_noms_standards_objets_dans_ordre_chronologique OWNER TO postgres;

--
-- TOC entry 181 (class 1259 OID 18009)
-- Dependencies: 1911 8
-- Name: v_objets_associes; Type: VIEW; Schema: tables_objet; Owner: postgres
--

CREATE VIEW v_objets_associes AS
    SELECT t1.pk_associer_objet, t1.fk_objet_concerne, t4.nom AS nom_objet_concerne, (t8.nom)::text AS type_objet_concerne, t6.annee_debut AS annee_debut_objet_concerne, t1.fk_objet_associe, t2.nom AS nom_objet_associe, (t7.nom)::text AS type_objet_associe, t5.annee_debut AS annee_debut_objet_associe, t1.reference_precise, t1.fk_type_association_objet, (t3.nom)::text AS type_association, t1.descriptif, t1.notes FROM (((((((associer_objet t1 JOIN objet t5 ON ((t5.pk_objet = t1.fk_objet_associe))) JOIN objet t6 ON ((t6.pk_objet = t1.fk_objet_concerne))) JOIN tables_types.parametre t3 ON ((t3.pk_parametre = t1.fk_type_association_objet))) LEFT JOIN v_noms_standards_objets_dans_ordre_chronologique t2 ON ((t2.fk_objet = t1.fk_objet_associe))) LEFT JOIN v_noms_standards_objets_dans_ordre_chronologique t4 ON ((t4.fk_objet = t1.fk_objet_concerne))) LEFT JOIN tables_types.parametre t7 ON ((t7.pk_parametre = t5.fk_type_objet))) LEFT JOIN tables_types.parametre t8 ON ((t8.pk_parametre = t6.fk_type_objet)));


ALTER TABLE tables_objet.v_objets_associes OWNER TO postgres;

--
-- TOC entry 1912 (class 2604 OID 18014)
-- Dependencies: 175 174
-- Name: pk_associer_objet; Type: DEFAULT; Schema: tables_objet; Owner: postgres
--

ALTER TABLE ONLY associer_objet ALTER COLUMN pk_associer_objet SET DEFAULT nextval('associer_objet_pk_associer_objet_seq'::regclass);


--
-- TOC entry 1914 (class 2604 OID 18015)
-- Dependencies: 177 176
-- Name: pk_nom_objet; Type: DEFAULT; Schema: tables_objet; Owner: postgres
--

ALTER TABLE ONLY nom_objet ALTER COLUMN pk_nom_objet SET DEFAULT nextval('nom_objet_pk_nom_objet_seq'::regclass);


--
-- TOC entry 1916 (class 2604 OID 18016)
-- Dependencies: 179 178
-- Name: pk_objet; Type: DEFAULT; Schema: tables_objet; Owner: postgres
--

ALTER TABLE ONLY objet ALTER COLUMN pk_objet SET DEFAULT nextval('objet_pk_objet_seq'::regclass);


--
-- TOC entry 1925 (class 0 OID 17979)
-- Dependencies: 174 1928
-- Data for Name: associer_objet; Type: TABLE DATA; Schema: tables_objet; Owner: postgres
--

INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (1, 17, 1, 3, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (2, 18, 3, 7, '', '', '');
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (3, 19, 11, 12, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (4, 20, 13, 5, '', '1269-1272', '');
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (5, 17, 14, 15, '', '', '');
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (6, 20, 15, 5, '', '', '');
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (7, 19, 11, 16, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (8, 19, 4, 18, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (9, 19, 18, 10, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (10, 21, 2, 19, 'Associé provisoirement : vérifier s''il faut le garder dans cette population !', NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (11, 21, 1, 19, NULL, NULL, NULL);
INSERT INTO associer_objet (pk_associer_objet, fk_type_association_objet, fk_objet_concerne, fk_objet_associe, descriptif, reference_precise, notes) VALUES (12, 20, 21, 6, NULL, NULL, NULL);


--
-- TOC entry 1926 (class 0 OID 17987)
-- Dependencies: 176 1928
-- Data for Name: nom_objet; Type: TABLE DATA; Schema: tables_objet; Owner: postgres
--

INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (1, true, 'Levasseur, Emile', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-02 17:20:16.546', 1, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (2, true, 'Charles Roux, Jules', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-02 17:26:48.468', 2, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (3, true, 'Notice Wikipedia : Pierre Emile Levasseur', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-02 19:54:47.124', 3, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (5, true, 'Dictionnaire historique de la papauté, Philippe Levillain (sous la dir. de), Paris, Fayard, 1994', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-02 20:04:23.468', 5, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (6, true, 'Journal des économistes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-02 20:05:10.483', 6, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (7, true, 'Reproduction de la notice Levasseur de Wikipedia', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-02 20:06:28.655', 7, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (9, true, 'Paulus V ', '', '1605-05-16', 'Date de l''élection pontificale', '', '', 'lat', '', '2012-11-02 20:28:56.64', 8, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (8, true, 'Borghese, Camillo', '', '1552', '', '1605-05-16', 'Veille de l''élection pontificale', 'ita', '', '2012-11-02 20:11:28.28', 8, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (10, false, ' Paul V', 'Nom en français, ajouté en vue de la recherche', NULL, NULL, NULL, NULL, 'fra', NULL, '2012-11-02 20:30:20.452', 8, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (11, true, 'Lyon, Archives municipales, Paroisse Saint-Paul, Registre des mariages, 1GG453', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-02 20:31:57.108', 9, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (12, true, 'Société savante', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-02 20:36:35.452', 10, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (13, true, 'Histoire des doctrines économiques', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-02 20:38:05.093', 11, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (14, true, 'Histoire', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-02 20:39:06.952', 12, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (15, true, 'Philippe Boutry, "Paul V" ', '', '', '', '', '', '   ', '', '2012-11-02 20:42:53.718', 13, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (17, true, 'Urbanus VIII ', '', '1623-08-05', 'Date de l''élection pontificale', '', '', 'lat', '', '2012-11-02 20:47:06.108', 14, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (18, true, 'Renoux, Christian, "Urbain VIII"', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-02 20:47:55.749', 15, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (16, true, 'Barberini, Maffeo', '', '1568', '', '1623-08-05', 'Veille de l''élection pontificale', 'ita', '', '2012-11-02 20:45:34.608', 14, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (19, true, 'Economie', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-02 20:55:11.343', 16, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (20, true, 'Professeur', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-02 20:56:51.999', 17, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (21, true, 'Académie des sciences', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-02 20:59:18.233', 18, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (4, true, 'Académie des sciences', '', '', '', '', '', '   ', '', '2012-11-02 20:03:07.343', 4, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (22, false, 'Académie royale des sciences', NULL, '1666', NULL, NULL, NULL, NULL, NULL, '2012-11-02 21:02:28.765', 4, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (23, true, 'Population d''économistes de la fin du 19e siècle  ', '', '', '', '', '', '   ', '', '2012-11-02 21:05:23.046', 19, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (24, true, 'Paris', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-02 21:10:52.561', 20, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (25, true, 'Liste des principaux collaborateurs de la revue Journal des Economistes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-02 21:26:00.983', 21, NULL);
INSERT INTO nom_objet (pk_nom_objet, si_nom_standard, nom, descriptif, date_debut, notes_dd, date_fin, notes_df, code_langue, notes, creation, fk_objet, fk_type) VALUES (26, true, 'Cathédrale Saint-Jean de Lyon', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2012-11-02 21:28:16.015', 22, NULL);


--
-- TOC entry 1927 (class 0 OID 17996)
-- Dependencies: 178 1928
-- Data for Name: objet; Type: TABLE DATA; Schema: tables_objet; Owner: postgres
--

INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (1, '', '', '', '', '', '2012-11-02 17:20:16.515', 7, 1, 1, '', 22, 1828, 1911, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (2, '', '', '', '', '', '2012-11-02 17:26:48.453', 7, 1, 1, '', 22, 1841, 1918, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (5, '', '', '', '', '', '2012-11-02 20:04:23.468', 13, 1, 1, '', 28, 1994, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (6, NULL, 'Revue mensuelle de l''économie politique, des questions agricoles, manufacturières et commerciales', NULL, NULL, NULL, '2012-11-02 20:05:10.483', 13, 1, 1, NULL, NULL, 1841, 1940, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (8, NULL, 'Pape', NULL, NULL, NULL, '2012-11-02 20:11:28.265', 7, 1, 1, NULL, NULL, 1552, 1621, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (9, '', 'Volume du registre des mariages', '', '', '', '2012-11-02 20:31:57.093', 10, 1, 1, '', 62, 1643, 1643, 2, 15, 12, 17, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (10, '', 'Concept qui vise les institutions vouées à la production ou à la diffusion du savoir', '', '', '', '2012-11-02 20:36:35.452', 9, 1, 1, '', 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (11, '', 'Discipline appartenant à la fois au champs de l''économie et de l''histoire', '', '', '', '2012-11-02 20:38:05.093', 9, 1, 1, '', 50, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (12, '', 'Dicipline s''occupant de l''étude du passé', '', '', '', '2012-11-02 20:39:06.936', 9, 1, 1, '', 50, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (13, '', '', '', '', '', '2012-11-02 20:42:53.718', 11, 1, 1, '', 33, 1994, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (14, '', 'Cardinal (1606), pape (1623)', '', '', '', '2012-11-02 20:45:34.608', 7, 1, 1, '', 22, 1568, 1644, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (15, '', '', '', '', '', '2012-11-02 20:47:55.733', 11, 1, 1, '', 33, 1994, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (16, NULL, 'Discipline qui a pour objet "la production, la répartition et la consommation des richesses et de l''activité que les hommes vivant en société déploient à cet effet." (http://www.cnrtl.fr/definition/économie)', NULL, NULL, NULL, '2012-11-02 20:55:11.343', 9, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (17, '', '"Personne qui enseigne une discipline, une technique, un art." (http://www.cnrtl.fr/definition/professeur)', '', '', '', '2012-11-02 20:56:51.999', 16, 1, 1, '', 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (18, '', '"Une académie des sciences est une société savante dont le rôle est de promouvoir la recherche scientifique." (http://fr.wikipedia.org/wiki/Acad%C3%A9mie_des_sciences)', '', '', '', '2012-11-02 20:59:18.218', 9, 1, 1, '', 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (4, '', 'Etablissement réunissant savants et mathématiciens fondée par Colbert', '', '', '', '2012-11-02 20:03:07.343', 8, 1, 1, '', 25, 1666, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (19, '', 'Population d''acteurs définie en vue de la réalisation de mon travail de master', '', '', '', '2012-11-02 21:05:23.046', 9, 1, 1, '', 66, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (20, '', 'La ville de Paris en tant que lieu habité.', '', '', '', '2012-11-02 21:10:52.561', 14, 1, 1, '', 23, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (7, '', 'Notice avec mes notes. Classée dans le dossier P.E. Levasseur', '', '', '', '2012-11-02 20:06:28.655', 10, 1, 1, '', 60, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (3, '', '', '', '', '', '2012-11-02 19:54:47.124', 12, 1, 1, 'http://fr.wikipedia.org/wiki/Pierre_Émile_Levasseur', 53, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (21, '', '', '', '', '', '2012-11-02 21:26:00.968', 11, 1, 1, '', 32, 1900, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, cle_objet_bhp, descriptif, notes_dd, notes_df, notes, creation, fk_type_objet, certitude_dd, certitude_df, url_objet, fk_sous_type_objet, annee_debut, annee_fin, mois_debut, jour_debut, mois_fin, jour_fin, cle_importation) VALUES (22, '', 'Edifice actuel de l''église cathédrale', '', '', '', '2012-11-02 21:28:16.015', 15, 2, 1, '', 47, 1165, NULL, NULL, NULL, NULL, NULL, NULL);


--
-- TOC entry 1918 (class 2606 OID 18018)
-- Dependencies: 174 174 1929
-- Name: associer_objet_pkey; Type: CONSTRAINT; Schema: tables_objet; Owner: postgres
--

ALTER TABLE ONLY associer_objet
    ADD CONSTRAINT associer_objet_pkey PRIMARY KEY (pk_associer_objet);


--
-- TOC entry 1921 (class 2606 OID 18020)
-- Dependencies: 176 176 1929
-- Name: nom_objet_pkey; Type: CONSTRAINT; Schema: tables_objet; Owner: postgres
--

ALTER TABLE ONLY nom_objet
    ADD CONSTRAINT nom_objet_pkey PRIMARY KEY (pk_nom_objet);


--
-- TOC entry 1923 (class 2606 OID 18022)
-- Dependencies: 178 178 1929
-- Name: objet_pkey; Type: CONSTRAINT; Schema: tables_objet; Owner: postgres
--

ALTER TABLE ONLY objet
    ADD CONSTRAINT objet_pkey PRIMARY KEY (pk_objet);


--
-- TOC entry 1919 (class 1259 OID 18023)
-- Dependencies: 176 1929
-- Name: fki_nom_objet; Type: INDEX; Schema: tables_objet; Owner: postgres
--

CREATE INDEX fki_nom_objet ON nom_objet USING btree (fk_objet);


--
-- TOC entry 1924 (class 2606 OID 18024)
-- Dependencies: 176 178 1922 1929
-- Name: fk_nom_objet; Type: FK CONSTRAINT; Schema: tables_objet; Owner: postgres
--

ALTER TABLE ONLY nom_objet
    ADD CONSTRAINT fk_nom_objet FOREIGN KEY (fk_objet) REFERENCES objet(pk_objet);


-- Completed on 2012-11-02 22:25:46

--
-- PostgreSQL database dump complete
--
