<?php
require_once("../connexion_base_individuelle.inc");
require_once("../html_parts.inc");
require_once("../traitement_slashes_magic_quotes.inc");

// prépare le tableau des variables préfixées avec 'form', fonction utilisateur, cf. echo $form_typeListe;
$tableau_variables = request_variables_sans_slashes($_REQUEST, 'form');

// prépare les variables du tableau
foreach ($tableau_variables as $cle => $element) {
	${$cle} = $element;
}


if (isset($form_typeListe) and $form_typeListe=='select_specific') {

	// prépare les variables
	$selNom = '';
	$selCleTyUC = '';
	$selCleTyUCBHP='';
	$selActif = '';
	$selDescriptif = '';
	$selCategorie = '';

	// prépare les valeurs pour le tri en fonction de la colonne retenue
	switch ($form_champsTri) {
		case "nom":
			$sql_champsTri = "nom ".$form_ordreTri;
			break;
		case "cle_type_UC":
			$sql_champsTri = "cle_objet_bhp ".$form_ordreTri;
			break;
		case "cle":
			$sql_champsTri = "pk_type_unite_connaissance ".$form_ordreTri;
			break;
		default:
			$sql_champsTri = "nom ASC";
	}


	if($form_nom) $selNom = " AND tables_objet.majuscule_sans_accents(nom)
	 LIKE tables_objet.majuscule_sans_accents(E'%".addslashes($form_nom)."%')
	  OR tables_objet.majuscule_sans_accents(autres_noms)
	   LIKE tables_objet.majuscule_sans_accents(E'%".addslashes($form_nom)."%')  ";
	if($form_cleTyUC) $selCleTyUC = " AND pk_type_unite_connaissance = ".$form_cleTyUC;
	if($form_cleTyUCBHP) $selCleTyUCBHP = " AND cle_objet_bhp = '".$form_cleTyUCBHP."'";
	if($form_actif) $selActif = " AND si_utilise is ".$form_actif;
	if($form_descriptif) $selDescriptif = " AND tables_objet.majuscule_sans_accents(descriptif)
	 LIKE tables_objet.majuscule_sans_accents(E'%".addslashes($form_descriptif)."%')";
	if($form_categorie) $selCategorie = " AND categorie_uc = '".$form_categorie."'";


	$requete = "SELECT *,
				CASE WHEN length(descriptif) < 120 THEN descriptif ELSE substring(descriptif, 1, 120)||' [...]' END AS descriptif_tronque
				FROM tables_types.type_unite_connaissance
				WHERE pk_type_unite_connaissance > 0".
	$selNom.$selCleTyUC.$selCleTyUCBHP.$selActif.
	$selDescriptif.$selCategorie.
				" ORDER BY ".$sql_champsTri." ; ";


	$titre_div = 'Résultat de la recherche';
}
/*requête générique qui cherche les 15 derniers objets entrés dans la base */
else {
	$requete = "SELECT *,
					CASE WHEN length(descriptif) < 120 THEN descriptif ELSE substring(descriptif, 1, 120)||' [...]' END AS descriptif_tronque
					FROM tables_types.type_unite_connaissance
					ORDER BY pk_type_unite_connaissance;";

	$titre_div = 'Liste des types d\'unité de connaissance';
}


//ouvre la connection avec la fonction externe et récupère la variable
$connexion = connexion();

$resultat = pg_query($requete) or die('Query failed: ' . pg_last_error());

$nombre_lignes = pg_num_rows($resultat);

$tableau_lignes=array() ;

while ($objet_resultat = pg_fetch_object ($resultat))  {
	// On encode le titre pour le placer dans l'URL – pas utilisé pour l'instant
	//$titreURL = urlEncode ($objet_resultat->pk_objet);

	//Prépare la variable
	if ($objet_resultat->si_utilise == 't') $si_utilise = 'Oui' ; else $si_utilise = 'Non';

	// On sort le tableau résultant de la requête
	$tableau_lignes[] = '<tr><td class="cle"><a href="types_uc_insert_update.php?cleTyUC='.
	$objet_resultat->pk_type_unite_connaissance.'" target="_blank"><div><span class="font_smaller">'.
	$objet_resultat->pk_type_unite_connaissance.'</span></div></td>
	<td class="nom"><div>'.$objet_resultat->nom.'</div></td>
	<td class="debut"><div>'.$objet_resultat->cle_objet_bhp.'</div></td>
	<td class="fin"><div>'.$si_utilise.'</div></td>
	<td class="descriptif"><div>'.$objet_resultat->descriptif_tronque.'</div></td>
	<td class="type"><div>'.$objet_resultat->categorie_uc.'</div></td></tr>';
}



// Libérer le résultat
pg_free_result($resultat);


// Fermer la connexion
pg_close($connexion);


?>




<!-- Commence ici la partie HTML -->

<?php html_header ('Liste types d\'UC', '../css/type_unite_connaissance.css');

echo
'<div>
		<h2>'.$titre_div.' : '.$nombre_lignes.' ligne(s)</h2>
</div>';?>


<form action="types_uc_liste.php" method="post">

<p>Clé : <input type="text" size="4" name="cleTyUC" /> Nom : <input
	type="text" size="10" name="nom" /> Clé BHP (SyMoGIH) : <input
	type="text" size="5" name="cleTyUCBHP" /> Actif : <select name="actif">
	<option selected value=""></option>
	<option value="true">Oui</option>
	<option value="false">Non</option>
</select> Descriptif : <input type="text" size="10" name="descriptif" />
Catégorie : <select name="categorie">
	<option selected value=""></option>
	<option value="Info">Information</option>
	<option value="Cont">Contenu</option>
</select></p>
<p>Tri par: <select name="champsTri">

<?php
$champsTri = array('nom', 'cle_type_UC', 'cle');
foreach ($champsTri as $value) {
	if($form_champsTri == $value) $champsTriSelected = 'selected="selected"'; else $champsTriSelected = '';
	echo '<option value="'.$value.'" '.$champsTriSelected.'>'.$value.'</option>' ;}

	echo '</select>
		
		– Ordre de tri: <select name="ordreTri">';

	if($form_ordreTri == 'DESC') $ordreTriSelected = 'selected="selected"'; else $ordreTriSelected = '';

	echo'<option value="ASC">ascendant</option>
		<option '.$ordreTriSelected.' value="DESC">déscendant</option>
		</select> ' ?>


	<input type="submit" value="Chercher" /></p>
<input type="hidden" name="typeListe" value="select_specific" /></form>

<p><a href="../accueil.php">Accueil</a> – <a
	href="../objet/objet_liste.php">Objets</a> – <a
	href="../unite_connaissance/unite_connaissance_liste.php">Unités de
connaissance</a></p>


<div class="scrollingArea">
<table class="listeObjets scrollable">
	<thead>
		<tr>
			<th class="cle">
			<div>Clé</div>
			</th>
			<th class="nom">
			<div>Nom TyUC</div>
			</th>
			<th class="debut">
			<div>BHP</div>
			</th>
			<th class="fin">
			<div>Actif</div>
			</th>
			<th class="descriptif">
			<div>Descriptif</div>
			</th>
			<th class="type">
			<div>Catégorie</div>
			</th>
		</tr>
	</thead>
	<tbody>

	<?php
	foreach ($tableau_lignes as $ligne) {
		echo $ligne;}
		?>
	</tbody>
</table>
</div>
</div>
</body>
</html>
