<?php

require_once("../connexion_base_individuelle.inc");
require_once("../html_parts.inc");
require_once("../preparation_insert_update.inc");


// récupère l'identifiant de l'unité de connaissance
if (isset($form_cleRole)) $cle_role = $form_cleRole; else $form_cleRole = '';
if (isset($form_typeUC)) $type_uc = $form_typeUC; else $type_uc = 0;
if (isset($form_fkTypeRole)) $fk_type_role = $form_fkTypeRole; else $fk_type_role = '';
if (!empty($form_cleProprieteObjetAssocie)) $cle_propriete_objet_associe = $form_cleProprieteObjetAssocie; else $cle_propriete_objet_associe = NULL;



	//ouvre la connection avec la fonction externe et récupère la variable
	$connexion = connexion();

	// requête qui liste tous les objets abstraits
	$requete = "SELECT pk_objet,
				       nom
				FROM tables_objet.v_objet_nom_type_sous_type
				WHERE type_objet LIKE '%abstrait%'";
	
			// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());
	
	//préparer le résultat pour l'utilisation dans le formulaire
	$liste_objets_abstraits = array();
	while ($valeurs = pg_fetch_object($resultat))
	{
		$liste_objets_abstraits[] = '<option value="'.$valeurs->pk_objet.'" label="'.$valeurs->nom.'"/>';
	}
	
	// Libérer le résultat
	pg_free_result($resultat);
	
	
	
	
	
	// requête qui liste dynamiquement les valeurs utilisées pour le TYPE DE PROPRIÉTÉ
	$requete = "SELECT DISTINCT fk_type_propriete,
				         type_propriete
				  FROM vues_sql.v_proprietes_avec_noms
				  WHERE fk_type_role = ".$fk_type_role."
				ORDER BY type_propriete" ;
	
		// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());
	
	//préparer le résultat pour l'utilisation dans le formulaire
	$liste_types = array();
	while ($types = pg_fetch_object($resultat))
	{
		$liste_types[] = '<option value="'.$types->fk_type_propriete.'">'.$types->type_propriete.'</option>';
	}
	
	// Libérer le résultat
	pg_free_result($resultat);
	
	
	
	// requête qui liste dynamiquement les valeurs utilisées pour la PROPRIÉTÉ
	$requete = "SELECT DISTINCT fk_valeur_propriete,
				       valeur_propriete
				FROM vues_sql.v_proprietes_avec_noms
				WHERE fk_type_role = ".$fk_type_role."
				ORDER BY valeur_propriete" ;
	

		// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());
	
	//préparer le résultat pour l'utilisation dans le formulaire
	$liste_valeurs = array();
	while ($valeurs = pg_fetch_object($resultat))
	{
		$liste_valeurs[] = '<option value="'.$valeurs->fk_valeur_propriete.'">'.$valeurs->valeur_propriete.'</option>';
	}
	
	// Libérer le résultat
	pg_free_result($resultat);
	
	
	
	
// ce traitment s'applique lorsqu'un insert est appelé depuis la fiche de l'unité de connaissance :
// ce script fait alors fonction de formulaire de saisie

if (isset($form_effectuer) and $form_effectuer =='form_insert') {
	
				

	$titre_div_fomulaire = '<h2>Insérer une nouvelle propriété pour le Role'.$cle_role.'</h2>';
	$valeur_effectuer = 'insert';
	$value_submit= 'Créer nouvelle propriété';

	//déclarer et renseigner les variables en fonction des besoins


//	$complement_html ='';
//	$cle_role = '';
//	$cle_type_propriete_objet_associe = '';
//	$type_propriete;
//	$cle_valeur_propriete_objet_associe = '';
//	$valeur_propriete = '';
//	$cle_unite_mesure = '';
//	$unite_mesure = '';
//	$valeur_propriete_nombre = '';
//	$valeur_propriete_texte = '';
//	$notes = '';



}

// ce traitement s'applique dans les autres cas
else {

	
	$complement_html ='';

	// Gestion du bouton effectuer	: insert ou update.
	if  (!empty($form_effectuer))  {

		// UPDATE : Partie qui effectue l'UPDATE des paramères de l'association
		if ($form_effectuer == 'update') {
			
			if(empty($cle_propriete_objet_associe)) {
				html_header ('Attention', '../css/unite_connaissance.css');
				exit( '<p>Attention : il y a un problème, la mise-à-jour n\'est pas possible.</p>
				<p><form action="role_insert_update.php"  method="get" >
				<input type="hidden" name="tyupeUC" value="'.$type_uc.'" />
				<input type="hidden" name ="cleRole" value="'.$cle_role.'"></input>
				<input type="submit" value="OK" /></form></p></body></html>')	;
			};
			

			if (!empty($form_cleTypeProprieteObjetAssocie) and !is_numeric($form_cleTypeProprieteObjetAssocie)) {
				html_header ('Attention', '../css/unite_connaissance.css');
				exit( '<p>Attention : le types de propriété doit être au format numérique.</p>
				<p><form action="propriete_objet_insert_update.php"  method="get" >
				<input type="hidden" name="cleProprieteObjetAssocie" value="'.$form_cleProprieteObjetAssocie.'" />
				<input type="hidden" name="tyupeUC" value="'.$type_uc.'" />
				<input type="hidden" name ="cleRole" value="'.$cle_role.'"></input>
				<input type="submit" value="OK" /></form></p></body></html>')	;
			}

			
			$requete = "UPDATE  tables_uc.propriete_objet_associe 
						SET pk_propriete_objet_associe = ".$cle_propriete_objet_associe.
						", fk_role = ".$cle_role.
						$update_fk_type_propriete.$update_fk_valeur_propriete.
						$update_valeur_propriete_texte.$update_fk_unite_mesure.
						$update_valeur_propriete_nombre.$update_notes."
			\n WHERE pk_propriete_objet_associe = ".$cle_propriete_objet_associe;


			// effectuer la requête qui liste les types de cet objet
			$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

			// Libérer le résultat
			pg_free_result($resultat);

		}


		// INSERT : Partie qui effectue l'INSERT de l'association
		elseif ($form_effectuer == 'insert') {
			

			if (!empty($form_cleTypeProprieteObjetAssocie) and !is_numeric($form_cleTypeProprieteObjetAssocie)) {
				html_header ('Attention', '../css/unite_connaissance.css');
				exit( '<p>Attention : la clé de la propriété doit être au format numérique.</p>
					<p><form action="source_insert_update.php"  method="get" >
					<input type="hidden" name="effectuer" value="source_form_insert"/>
					<input type="hidden" name="tyupeUC" value="'.$type_uc.'" />
					<input type="hidden" name ="cleRole" value="'.$cle_role.'"></input>
					<input type="submit" value="OK" /></form></p></body></html>')	;
			}
			else {
				$complement_html = '';
			}


			$requete = "INSERT INTO tables_uc.propriete_objet_associe  (fk_role".
			$champs_fk_type_propriete.$champs_fk_valeur_propriete.
			$champs_valeur_propriete_texte.$champs_fk_unite_mesure.$champs_valeur_propriete_nombre.
			$champs_notes.")
							VALUES (".$cle_role.
			$partie_fk_type_propriete.$partie_fk_valeur_propriete.
			$partie_valeur_propriete_texte.$partie_fk_unite_mesure.$partie_valeur_propriete_nombre.
			$partie_notes.")";
			

			// effectuer la requête qui liste les types de cet objet
			$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

			// Libérer le résultat
			pg_free_result($resultat);


			// cherche la clé de la nouvelle association
			$requete = 'SELECT MAX(pk_propriete_objet_associe) AS pk_propriete_objet_associe
							FROM tables_uc.propriete_objet_associe';
			$resultat = pg_query($requete) or die('Query failed: ' . pg_last_error());
			if (!$resultat) {
				echo "Erreur.\n";
				exit;
			}
			while ($row = pg_fetch_object($resultat)) {
				$cle_propriete_objet_associe = $row->pk_propriete_objet_associe;
			}

			// Libérer le résultat
			pg_free_result($resultat);
		}
		
		else echo 'BBB';

	}
	$value_submit = 'Mettre à jour';




	// requête qui cherche les propriétés de cette propriété
	$requete = "SELECT t1. *,
       			t2.nom AS type_role
					FROM vues_sql.v_proprietes_avec_noms t1
				  	LEFT JOIN tables_types.type_role t2 ON t2.pk_type_role = t1.fk_type_role
					WHERE pk_propriete_objet_associe =".$cle_propriete_objet_associe;

	// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());
	
	// déclaration variables
	$type_role  = '';

	// récupérer le résultat dans une variable
	if ($resultat) {
		$champs = pg_fetch_assoc($resultat);
		$type_role = $champs['type_role'];
		$cle_type_propriete_objet_associe = $champs['fk_type_propriete'];
		$type_propriete = $champs['type_propriete'];
		$cle_valeur_propriete_objet_associe = $champs['fk_valeur_propriete'];
		$valeur_propriete = $champs['valeur_propriete'];
		$cle_unite_mesure = $champs['fk_unite_mesure'];
		$unite_mesure = $champs['unite_mesure'];
		$valeur_propriete_nombre = $champs['valeur_propriete_nombre'];
		$valeur_propriete_texte = $champs['valeur_propriete_texte'];
		$notes = $champs['notes'];
	}
	else {
		$liste_noms_standard = 'Erreur !';
	}

	if (strlen($type_role) > 0) $type_role_print = $type_role; else $type_role_print = ' manque !';
	
	// autres variables
	$valeur_effectuer = 'update';
	$titre_div_fomulaire = '<h2>Propriété: '.$cle_propriete_objet_associe.' – type de rôle: '.$type_role_print.'</h2>';


	// Libérer le résultat
	pg_free_result($resultat);
	
	
	
	
	

	// Fermer la connexion
	pg_close($connexion);

}




?>

<?php html_header ('Propriété du rôle', '../css/unite_connaissance.css'); ?>


<div><?php echo $titre_div_fomulaire; ?> <?php echo $complement_html; ?>


<!--Cf. http://www.alsacreations.com/article/lire/1334-html5-element-datalist.html-->

<form action="propriete_objet_associe_insert_update.php" method="post">

	<p>Cle type propriété: 
			<input id="input_1" type="text" list="liste_types"  name="cleTypeProprieteObjetAssocie" 
			value="<?php echo $cle_type_propriete_objet_associe;?>">
				<datalist id="liste_types">
					<?php lignes_tableau($liste_objets_abstraits);?>
				</datalist>
			</input>
		
 		<?php if(strlen($type_propriete)>0) echo ' – <strong>"'.$type_propriete.'"</strong>'; ?> – (ATTENTION : pour modifier effacer la valeur et taper les première lettres du nom ou coller une nouvelle clé)
 		 – C'est une clé numérique, un entier, qu'on doit entrer, sinon il y aura un message d'erreur.  Liste des types utilisés avec ce rôle: 
 		 <select>
 		 <?php lignes_tableau($liste_types);?>
 		 </select>
 		</p>
	
	
	
	<p>Cle valeur propriété : 
			<input id="input_2" type="text" list="liste_valeurs"  name="cleValeurProprieteObjetAssocie" 
			value="<?php echo $cle_valeur_propriete_objet_associe;?>">
				<datalist id="liste_valeurs">
					<?php lignes_tableau($liste_objets_abstraits);?>
				</datalist>
			</input>
		
 		<?php if(strlen($valeur_propriete)>0) echo ' – <strong>"'.$valeur_propriete.'"</strong>'; ?>  – (ATTENTION : pour modifier effacer la valeur et taper les première lettres du nom ou coller une nouvelle clé)
 		– C'est une clé numérique, un entier, qu'on doit entrer, sinon il y aura un message d'erreur. Liste des valeurs utilisés avec ce rôle: 
 		 <select>
 		 <?php lignes_tableau($liste_valeurs);?>
 		 </select>
	</p>
	
	
		
	<p><br/>Valeur propriété format texte : <input type="text" size="100"
		name="valeurProprieteTexte" value="<?php echo $valeur_propriete_texte ; ?>" /></p>
	
	
	<p>Cle unité de mesure : <input type="text" size="5" name="fkUniteMesure"
		value="<?php echo $cle_unite_mesure;?>" /> <?php if(strlen($unite_mesure)>0) echo ' – "'.$unite_mesure.'"'; ?>
	</p>
	
	
	<p>Valeur propriété format numérique (entier ou décimal, e.g. 3.5): <input type="text" size="10"
		name="valeurProprieteNombre" value="<?php echo $valeur_propriete_nombre ; ?>" /></p>
	
	
	<p>Notes : <input type="text" size="120"
		name="notes" value="<?php echo $notes ; ?>" /></p>
		
		
	<input
		type="hidden" name="effectuer" value="<?php echo $valeur_effectuer; ?>" />
		
	<input type="hidden" name="cleProprieteObjetAssocie"
		value="<?php echo $cle_propriete_objet_associe; ?>" /> 
		<input type="hidden"
		name="cleRole" value="<?php echo $cle_role; ?>" />
		<input type="hidden"
		name="fkTypeRole" value="<?php echo $fk_type_role; ?>" />
		
		<input
		type="hidden" name="typeUC" value="<?php echo $type_uc; ?>" />
	<p><input type="submit" value="<?php echo $value_submit; ?>" /></p>
	
</form>

<form action="role_insert_update.php" method="get">
    <input
	type="hidden" name="cleRole" value="<?php echo $cle_role; ?>" /> 
	<input
	type="hidden" name="typeUC" value="<?php echo $type_uc; ?>" />
<p></p>
<input type="submit" value="Fermer" />
</p>
</form>

</div>
</body>
</html>
