<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="html"/>

    <xsl:template match="/">
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="text">
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="body">
        <div class="texte_tei" style="background-color:#FBF2EF; display:block; padding:12px">
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    <xsl:template match="p">
        <p>
            <xsl:apply-templates/>
        </p>
    </xsl:template>
    <xsl:template match="name">
        <a>
            <xsl:if test="string-length(@ref)>4">
                <xsl:attribute name="href">
                    <xsl:text>http://symogih.org/resource/</xsl:text>
                    <xsl:value-of select="@ref"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </a>
    </xsl:template>
    <xsl:template match="ref">
        <a>
            <xsl:if test="string-length(@target)>4">
                <xsl:attribute name="href">
                    <xsl:value-of select="@target"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </a>
    </xsl:template>
    <xsl:template match="anchor">
        <xsl:apply-templates/>
    </xsl:template>

    <xsl:template match="span[@corresp]">
        <a>
            <xsl:if test="string-length(@corresp)>4">
                <xsl:attribute name="href">
                    <xsl:choose>
                        <xsl:when test="substring(@corresp, 1, 4)='Info'">
                            <xsl:text>https://bhp.ish-lyon.cnrs.fr/informations.php?action=display&amp;id=</xsl:text>
                            <xsl:value-of select="substring-after(@corresp, 'Info')"/>
                        </xsl:when>
                        <xsl:when test="substring(@corresp, 1, 4)='Cont'">
                            <xsl:text>https://bhp.ish-lyon.cnrs.fr/contents.php?action=display&amp;id=</xsl:text>
                            <xsl:value-of select="substring-after(@corresp, 'Cont')"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </a>
    </xsl:template>
    <xsl:template match="anchor">
        <xsl:apply-templates/>
    </xsl:template>

</xsl:stylesheet>
