<?php

require_once("../connexion_base_individuelle.inc");
require_once("../html_parts.inc");
require_once("../preparation_insert_update.inc");


// on arrive sur ce script depuis :
// ce même script (POST)
// unite_connaissance_update.php (GET)
//


// récupère l'identifiant de l'unité de connaissance
if (isset($form_cleUC)) $cle_uc = $form_cleUC; else {$cle_uc = ''; echo "Manque l'identifiant de l'unité de connaissance";}

$echo_cle_uc = 'Clé de l\'unité de connaissance : '.$cle_uc;

// ce traitment s'applique lorsqu'un insert est appelé depuis la fiche de l'objet :
// ce script fait alors fonction de formulaire de saisie
if (isset($form_effectuer) and $form_effectuer == 'form_insert') {
	$titre_div_fomulaire = '<h2>Insérer une nouvelle date</h2>';
	$value_submit= 'Nouvelle date';
	$valeur_effectuer = 'insert';

	//ouvre la connection avec la fonction externe et récupère la variable
	$connexion = connexion();

	$cle_date='';
	$annee = '';
	$mois = '';
	$jour = '';
	$libelle_selon_source = '';
	$marge_date = '';
	$descriptif = '';
	$notes = '';



	/* Type de date */

	// préparer la requête qui liste les paramètres du type de la date
	$requete = "SELECT t1.pk_parametre,
	    			t1.nom AS nom
					FROM tables_types.parametre t1 
					WHERE t1.type_parametre = 'type_date_uc'
					ORDER BY t1.nom;";

	// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

	//préparer le résultat pour l'utilisation dans le formulaire
	$liste_type_date = array();
	while ($lignes = pg_fetch_object($resultat))
	{
		$liste_type_date[] = '<option value="'.$lignes->pk_parametre.'">'.$lignes->nom.'</option>';
	}

	// Libérer le résultat
	pg_free_result($resultat);



	/* Certitude date */

	// préparer la requête qui liste les paramètres date
	$requete = "SELECT t1.pk_parametre,
	       			t1.nom AS nom
				FROM tables_types.parametre t1 
				WHERE t1.type_parametre = 'certitude_date_annee'
				ORDER BY t1.nom;";

	// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

	//préparer le résultat pour l'utilisation dans le formulaire
	$liste_certitude_date = array();
	while ($lignes = pg_fetch_object($resultat))
	{
		$liste_certitude_date[] = '<option value="'.$lignes->pk_parametre.'">'.$lignes->nom.'</option>';
	}


	// Libérer le résultat
	pg_free_result($resultat);


}

// ce traitement s'applique dans les autres cas
else {


	// récupère l'identifiant de la date
	if (isset($form_cleDate) and is_numeric($form_cleDate)) $cle_date = $form_cleDate;
	else {$cle_date = '';}


	// Gestion du bouton effectuer	: insert ou update.
	if  (isset($form_effectuer))  {

			
		// UPDATE : Partie qui effectue l'UPDATE du nom
		if ($form_effectuer == 'update') {
			//echo 'UPDATE';


			$requete = "UPDATE tables_uc.date_unite_connaissance SET fk_type_date=".$form_typeDate.
			$update_annee.$update_mois.$update_jour.$update_certitude_date.
			$update_marge_date.$update_libelle_selon_source.
			$update_descriptif.$update_notes."
				WHERE pk_date_unite_connaissance = ".$cle_date;

			//echo $requete;

			//ouvre la connection avec la fonction externe et récupère la variable
			$connexion = connexion();

			// effectuer la requête qui liste les types de cet objet
			$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

			// Libérer le résultat
			pg_free_result($resultat);



		}
		// INSERT : Partie qui effectue l'INSERT du nom
		elseif ($form_effectuer == 'insert') {

			// Ce test vérifie que les données à insérer dans la date soient bien numériques
			if (
			(!empty($form_annee) and !is_numeric($form_annee))
			or (is_numeric($form_annee) and
			(!empty($form_mois) and !is_numeric($form_mois) or !empty($form_jour) and !is_numeric($form_jour)) )
			) {
				html_header ('Attention', '../css/unite_connaissance.css');
				exit( '<p>Attention : l\'année, mois et jour doivent être au format numérique.</p>
					<p><form action="uc_date_insert_update.php"  method="post" >
					<input type="hidden" name ="effectuer" value="form_insert"></input>
					<input type="hidden" name ="cleUC" value="'.$cle_uc.'"></input>
					<input type="submit" value="OK" /></form></p></body></html>')	;
			}
			else {

				$requete = "INSERT INTO tables_uc.date_unite_connaissance  (fk_unite_connaissance, fk_type_date".
				$champs_annee.$champs_mois.$champs_jour.$champs_certitude_date.
				$champs_marge_date.$champs_libelle_selon_source.$champs_descriptif.$champs_notes.")
							VALUES (".$cle_uc.', '.$form_typeDate.
				$partie_annee.$partie_mois.$partie_jour.$partie_certitude_date.
				$partie_marge_date.$partie_libelle_selon_source.$partie_descriptif.$partie_notes.")";
					
				//echo $requete;
					
				//ouvre la connection avec la fonction externe et récupère la variable
				$connexion = connexion();
					
				// effectuer la requête qui liste les types de cet objet
				$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());
					
				// Libérer le résultat
				pg_free_result($resultat);

				// cherche la clé du nouveau nom
				$requete = 'SELECT MAX(pk_date_unite_connaissance) AS pk_date_unite_connaissance
							FROM tables_uc.date_unite_connaissance';
				$resultat = pg_query($requete) or die('Query failed: ' . pg_last_error());
				if (!$resultat) {
					echo "An error occured.\n";
					exit;
				}
				//initialise la variable
				$cle_date = '';
				while ($row = pg_fetch_object($resultat)) {
					$cle_date = $row->pk_date_unite_connaissance;
				}
					
				// Libérer le résultat
				pg_free_result($resultat);
					
			}
		}
	}

	//ouvre la connection avec la fonction externe et récupère la variable
	$connexion = connexion();


	/* Type de date */

	// préparer la requête qui liste les paramètres du type de la date
	$requete = "SELECT t1.pk_parametre,
	    			t1.nom AS nom,
	    			CASE
	         			WHEN pk_date_unite_connaissance IS NULL THEN NULL
    	     			ELSE 'selected'
       				END AS selected
					FROM tables_types.parametre t1 
					LEFT JOIN tables_uc.date_unite_connaissance t2 ON t2.fk_type_date = t1.pk_parametre 
					AND pk_date_unite_connaissance =".$cle_date.
					"WHERE t1.type_parametre = 'type_date_uc'
					ORDER BY t1.nom;";

	// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

	//préparer le résultat pour l'utilisation dans le formulaire
	$liste_type_date = array();
	while ($lignes = pg_fetch_object($resultat))
	{
		$liste_type_date[] = '<option '.$lignes->selected.' value="'.$lignes->pk_parametre.'">'.$lignes->nom.'</option>';
	}

	// Libérer le résultat
	pg_free_result($resultat);




	/* Certitude date */

	// préparer la requête qui liste les paramètres date
	$requete = "SELECT t1.pk_parametre,
	       			t1.nom AS nom,
	       			CASE
	         			WHEN pk_date_unite_connaissance IS NULL THEN NULL
    	     			ELSE 'selected'
       				END AS selected
				FROM tables_types.parametre t1 
				LEFT JOIN tables_uc.date_unite_connaissance t2 ON t2.certitude_date = t1.pk_parametre 
				AND pk_date_unite_connaissance =".$cle_date.
				"WHERE t1.type_parametre = 'certitude_date_annee'
				ORDER BY t1.nom;";

	// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

	//préparer le résultat pour l'utilisation dans le formulaire
	$liste_certitude_date = array();
	while ($lignes = pg_fetch_object($resultat))
	{
		$liste_certitude_date[] = '<option '.$lignes->selected.' value="'.$lignes->pk_parametre.'">'.$lignes->nom.'</option>';
	}


	// Libérer le résultat
	pg_free_result($resultat);


	/* Champs propres à la date */

	$requete = "SELECT t1.*, t2.nom AS type_date
				FROM tables_uc.date_unite_connaissance t1
				JOIN tables_types.parametre t2 ON t2.pk_parametre = t1.fk_type_date
				WHERE pk_date_unite_connaissance = ".$cle_date;

	// effectuer la requête qui liste les types de cet objet
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

	// récupérer le résultat dans une variable
	if ($resultat) {
		$champs_date = pg_fetch_assoc($resultat);
		$date_recomposee = $champs_date['date_recomposee'];
		$annee = $champs_date['annee'];
		$mois = $champs_date['mois'];
		$jour = $champs_date['jour'];
		$certitude_date = $champs_date['certitude_date'];
		$qualificatif_date = $champs_date['qualificatif_date'];
		$marge_date = $champs_date['marge_date'];
		$libelle_selon_source = $champs_date['libelle_selon_source'];
		$descriptif = $champs_date['descriptif'];
		$notes = $champs_date['notes'];
	}
	else {
		$liste_noms_standard = 'Erreur !';
	}



	// autres variables
	$titre_div_fomulaire = '<h2>'.$date_recomposee.'</h2>';
	$value_submit = 'Mettre à jour';
	$champs_obligatoire = '' ;
	$valeur_effectuer = 'update';

	// Libérer le résultat
	pg_free_result($resultat);
	
	
	
	

}


// Fermer la connexion
pg_close($connexion);

?>

<?php html_header ('Date', '../css/unite_connaissance.css'); ?>


<div><?php echo $titre_div_fomulaire; ?>

<form action="uc_date_insert_update.php" method="post">
<p><?php if (!empty($cle_date)) {echo 'Clé de la date : '.$cle_date.' – ';}?>

<?php echo $echo_cle_uc.'<br/>';?></p>


<p>Type de date : <select name="typeDate">
<?php foreach ($liste_type_date as $valeur_type_date) {
	echo $valeur_type_date;
}?>
</select> Année (<strong>format nombre</strong>) : <input type="text"
	size=3 " name="annee" value="<?php echo $annee; ?>" /> Mois : <input
	type="text" size="1" name="mois" value="<?php echo $mois; ?>" /> Jour :
<input type="text" size="1" name="jour" value="<?php echo $jour; ?>" />
– Certitude date : <select name="certitudeDate">
<?php foreach ($liste_certitude_date as $valeur_certitude_date) {
	echo $valeur_certitude_date;
}?>
</select></p>
<p>Marge date (nombre entier) : <input type="text" size="2"
	name="margeDate" value="<?php echo $marge_date; ?>" /> – Libellé selon
la source <input type="text" size="80" name="libelleSelonSource"
	value="<?php echo $libelle_selon_source; ?>" /></p>


<!-- appelle la partie du formulaire concernant descriptif et notes -->
<?php html_descriptif_notes(2, $descriptif, $notes) ; ?> <input
	type="hidden" name="effectuer" value="<?php echo $valeur_effectuer; ?>" />
<input type="hidden" name="cleDate" value="<?php echo $cle_date; ?>" />
<input type="hidden" name="cleUC" value="<?php echo $cle_uc; ?>" />
<p><input type="submit" value="<?php echo $value_submit; ?>" /></p>
</form>
<form action="unite_connaissance_update.php" method="get"><input
	type="hidden" name="cleUC" value="<?php echo $cle_uc; ?>" /> <input
	type="submit" value="Fermer" /></form>
</body>
</html>