<?php
require_once("../connexion_base_individuelle.inc");
require_once("../html_parts.inc");
require_once("../traitement_slashes_magic_quotes.inc");

// prépare le tableau des variables préfixées avec 'form', fonction utilisateur, cf. echo $form_typeListe;
$tableau_variables = request_variables_sans_slashes($_REQUEST, 'form');


// prépare les variables du tableau
foreach ($tableau_variables as $cle => $element) {
	${$cle} = $element;
}



if (isset($form_typeListe) and $form_typeListe=='select_specific') {

	// prépare les variables
	$selcleUC = '';
	$selSujet='';
	$selLibelle = '';
	$selType = '';
	$selCleType = '';
	$selDescriptif = '';
	$selAvantDate = '';
	$selApresDate = '';
	$partie_requete_objets = '';


	//	Clé  : <input type="text" size="3" name="cleUC"/>
	//  Sujet : <input type="text" size="10" name="sujet"/>
	//  Libellé : <input type="text" size="7" name="libelle"/>
	//  Après date : <input type="text" size="5" name="avantDate"/>
	//  Avant date : <input type="text" size="5" name="apresDAte"/>
	//  Type : <input type="text" size="5" name="type"/>
	//  Descriptif : <input type="text" size="7" name="descriptif"/>




	if($form_cleUC) $selcleUC = " AND t1.pk_unite_connaissance = ".$form_cleUC;
	if($form_sujet) $selSujet = " AND tables_objet.majuscule_sans_accents(t2.sujet_uc)
	 LIKE tables_objet.majuscule_sans_accents(E'%".addslashes($form_sujet)."%')";
	if($form_libelle) $selLibelle = " AND tables_objet.majuscule_sans_accents(t4.libelle_uc)
	 LIKE tables_objet.majuscule_sans_accents(E'%".addslashes($form_libelle)."%')";
	if($form_autresObjets) $selAutresObjets = " AND tables_objet.majuscule_sans_accents(t6.autres_objets_uc)
	 LIKE tables_objet.majuscule_sans_accents(E'%".addslashes($form_autresObjets)."%')";

	if($form_avantDate) $selAvantDate = " AND t3.date_standard <= '".$form_avantDate."'";
	if($form_apresDate) $selApresDate = " AND t3.date_standard >= '".$form_apresDate."'";

	if($form_typeUC) $selCleType = " AND t5.pk_type_unite_connaissance = ".$form_typeUC ;
	if($form_listeTypesUC) $selListeTypes = " AND t1.fk_type_unite_connaissance IN (".$form_listeTypesUC.") " ;



	// Traite une requête contenant une liste de clés d'objets séparée par virgule.
	// Crée une série de JOINs correspondant à chaque objet
	$j = 9;
	if($form_cleObjet) {
		$tableauClesObjets = array();
		$tableauClesObjets = explode(',', $form_cleObjet);
		//echo 'Nombre lignes : '. count($tableauClesObjets);
		$tableau_sortie = array();
		foreach ($tableauClesObjets as $item)
		{ if(is_numeric(trim($item))) {
			$tableau_sortie[] = " JOIN tables_uc.role t".$j." ON t".$j.".fk_unite_connaissance = t1.pk_unite_connaissance
	       			AND t".$j.".fk_objet_associe = ". $item;
			++$j;
		}
		}
		$partie_requete_objets = implode( ' ', $tableau_sortie);
		//		$j = $j-1;
	}


	// Traite une requête contenant une liste de clés d'objets associés à l'UC séparée par virgule.
	// Crée une série de JOINs correspondant à chaque objet
	if(isset($j) and $j > 8)
	{$i = $j ;} else {$i = 9;}

	if($form_cleObjetAssocie) {
		$tableauClesObjetsAssocies = array();
		$tableauClesObjetsAssocies = explode(',', $form_cleObjetAssocie);

		$tableau_sortie_asso = array();
		foreach ($tableauClesObjetsAssocies as $item)
		{ if(is_numeric(trim($item))) {
			$tableau_sortie_asso[] = " JOIN tables_uc.associer_unite_connaissance_objet t".$i." ".
			"ON t".$i.".fk_unite_connaissance = t1.pk_unite_connaissance
	       			AND t".$i.".fk_objet = ". $item;
			++$i;
		}
		}
		$partie_requete_objets_associes = implode( ' ', $tableau_sortie_asso);
	}




	$requete = "SELECT t1.pk_unite_connaissance,
					       t2.sujet_uc,
					       t4.libelle_uc,
					       t3.date_standard,
					       t5.nom as type_uc,
					       t1.descriptif,
					       t1.notes,
					       t6.autres_objets_uc,
					       t8.date_recomposee as date_fin,
					       COUNT(t7.pk_propriete_texte) AS nombre_proprietes_texte
					FROM tables_uc.unite_connaissance t1 
					  JOIN tables_types.type_unite_connaissance t5 ON t5.pk_type_unite_connaissance = t1.fk_type_unite_connaissance ".
	$partie_requete_objets.$partie_requete_objets_associes.
					" LEFT JOIN tables_uc.v_sujet_uc t2 ON t2.fk_unite_connaissance = t1.pk_unite_connaissance
					  LEFT JOIN tables_uc.v_date_standard_uc t3 ON t3.fk_unite_connaissance = t1.pk_unite_connaissance 
					  LEFT JOIN tables_uc.v_libelle_uc t4 ON t4.pk_unite_connaissance = t1.pk_unite_connaissance
					  LEFT JOIN vues_sql.v_autres_objets_uc t6 ON t6.fk_unite_connaissance = t1.pk_unite_connaissance
					  LEFT JOIN tables_uc.propriete_texte t7 ON t7.fk_unite_connaissance = t1.pk_unite_connaissance
					  LEFT JOIN tables_uc.date_unite_connaissance t8 ON t8.fk_unite_connaissance = t1.pk_unite_connaissance AND t8.fk_type_date = 6
				WHERE t1.pk_unite_connaissance > 0".
	$selcleUC.$selSujet.$selLibelle.
	$selCleType.
	$selListeTypes.
	$selAvantDate.$selApresDate
	.$selAutresObjets.
				  " GROUP BY t1.pk_unite_connaissance,
					         t2.sujet_uc,
					         t4.libelle_uc,
					         t3.date_standard,
					         t5.nom,
					         t1.descriptif,
					         t1.notes,
					         t6.autres_objets_uc,
					           t8.date_recomposee
					ORDER BY t3.date_standard ".$form_triDate."; ";


	$titre_div = 'Recherche d\'unités de connaissance';
}
/*requête générique qui cherche les 15 derniers objets entrés dans la base */
else {
	$requete = "SELECT t1.pk_unite_connaissance,
					       t2.sujet_uc,
					       t4.libelle_uc,
					       t3.date_standard,
					       t5.nom AS type_uc,
					       t1.descriptif,
					       t1.notes,
					       t6.autres_objets_uc,
					       COUNT(t7.pk_propriete_texte) AS nombre_proprietes_texte
					FROM tables_uc.unite_connaissance t1
					  JOIN tables_types.type_unite_connaissance t5 ON t5.pk_type_unite_connaissance = t1.fk_type_unite_connaissance
					  LEFT JOIN tables_uc.v_sujet_uc t2 ON t2.fk_unite_connaissance = t1.pk_unite_connaissance
					  LEFT JOIN tables_uc.v_date_standard_uc t3 ON t3.fk_unite_connaissance = t1.pk_unite_connaissance
					  LEFT JOIN tables_uc.v_libelle_uc t4 ON t4.pk_unite_connaissance = t1.pk_unite_connaissance
					  LEFT JOIN tables_uc.v_autres_objets_uc t6 ON t6.fk_unite_connaissance = t1.pk_unite_connaissance
					  LEFT JOIN tables_uc.propriete_texte t7 ON t7.fk_unite_connaissance = t1.pk_unite_connaissance
					GROUP BY t1.pk_unite_connaissance,
					         t2.sujet_uc,
					         t4.libelle_uc,
					         t3.date_standard,
					         t5.nom,
					         t1.descriptif,
					         t1.notes,
					         t6.autres_objets_uc
					ORDER BY t1.pk_unite_connaissance DESC LIMIT 15;";

	$titre_div = 'Recherche d\'unités de connaissance';
}


//ouvre la connection avec la fonction externe et récupère la variable
$connexion = connexion();

$resultat = pg_query($requete) or die('Query failed: ' . pg_last_error());

$nombre_lignes = pg_num_rows($resultat);

$tableau_lignes=array() ;

while ($objet_resultat = pg_fetch_object ($resultat))  {
	// On encode le titre pour le placer dans l'URL – pas utilisé pour l'instant
	//$titreURL = urlEncode ($objet_resultat->pk_objet);
	$descriptif = $objet_resultat->descriptif;
	$autres_objets_uc = $objet_resultat->autres_objets_uc;
	$nombre_proprietes_texte = $objet_resultat->nombre_proprietes_texte;
	if(!empty($descriptif) and !empty($autres_objets_uc)) {
		$descriptif_autres_objets = $descriptif.'. ['.$autres_objets_uc.']';
	} elseif (empty($descriptif) and !empty($autres_objets_uc)) {
		$descriptif_autres_objets = '['.$autres_objets_uc.']';
	} elseif (!empty($descriptif) and empty($autres_objets_uc)) {
		$descriptif_autres_objets = $descriptif;
	} else $descriptif_autres_objets = '';

	$longueur = strripos(substr($objet_resultat->notes, 0, 50), ' ');
	if(strlen($objet_resultat->notes) > 30 ) $notes_tronque = substr($objet_resultat->notes, 0, $longueur). ' [...]';
	else $notes_tronque = $objet_resultat->notes;



	//Prépare la variable – pas utilisé (10 novembre 2012)
	if (!empty($objet_resultat->sujet_uc)) $libelle_avec_sujet = $objet_resultat->sujet_uc.', '.$objet_resultat->libelle_uc;
	else $libelle_avec_sujet = $objet_resultat->libelle_uc;

	// On sort le tableau résultant de la requête
	$tableau_lignes[] = '<tr><td class="cle"><a href="unite_connaissance_update.php?cleUC='.
	$objet_resultat->pk_unite_connaissance.'" target="_blank"><div><span class="font_smaller">'.
	$objet_resultat->pk_unite_connaissance.'</span></div></a></td>
	<td class="date"><div>'.$objet_resultat->date_standard.'</div></td>
	<td class="nom"><div>'.$objet_resultat->sujet_uc.'</div></td>
	<td class="date"><div>'.$objet_resultat->type_uc.'</div></td>
	<td class="descriptif"><div>'.$descriptif_autres_objets.'</div></td>
	<td class="notes"><div>'.$notes_tronque.'</div></td>
	<td class="nombre_pt"><div><a href="unite_connaissance_update.php?cleUC='.
	$objet_resultat->pk_unite_connaissance.'&ongletActif=textes" target="_blank">'.$nombre_proprietes_texte.'</a></div></td></tr>'
	;



	//enlève les p et r de postulé et reconstitué
	$ladata = trim(strtr($objet_resultat->date_standard, 'pr', '  '));
	$ladata_f = trim(strtr($objet_resultat->date_fin, 'pr', '  '));
	
	
	$nc_ladata = strlen($ladata);

	// Traite les dates incomplètes ou manquantes pour la TimeLine qui a toujours besoin d'une date, attribut 'start'
	if ($nc_ladata < 1)
	{$date_debut = '0001-01-01';}
	elseif ($nc_ladata == 4)
	{$date_debut = $ladata.'-01-01';}
	elseif($nc_ladata == 7)
	{$date_debut = $ladata.'-01';}
	else
	{$date_debut = $ladata;}

	
	
   	$nc_ladata_f = strlen($ladata_f);

	// Traite les dates incomplètes ou manquantes pour la TimeLine qui a toujours besoin d'une date, attribut 'end'
	if ($nc_ladata_f < 1)
	{$date_fin = '';}
	elseif ($nc_ladata_f == 4)
	{$date_fin = $ladata_f.'-01-01';}
	elseif($nc_ladata == 7)
	{$date_fin = $ladata_f.'-01';}
	else
	{$date_fin = $ladata_f;}
		
	if(strlen($date_fin) > 0) $datation_fin = ' end="'.$date_fin.'" isDuration="true" '; else $datation_fin = '';
	
	//echo $datation_fin;

	$event = $event.'<event start="'.$date_debut.'" '.$datation_fin.' '.$color.
	' title="'.htmlspecialchars($objet_resultat->sujet_uc).' – '.htmlspecialchars($descriptif).
	'">&lt;a target="_blank" href="unite_connaissance_update.php?cleUC='.$objet_resultat->pk_unite_connaissance.
	'"  &gt;'.$date_debut.
	' / '.htmlspecialchars($autres_objets_uc).' – '.$objet_resultat->type_uc.
	'&lt;/a&gt; </event>';





}

$texte = '<data>'.$event.'</data>';


// choisit le fichier dans le même répertoire

$fichier = "events.xml";

// ouvre le fichier en mode écriture (créé si inexistant)

unlink($fichier);


$inF = fopen($fichier,"w");

// écrit dans le fichier
fwrite($inF,$texte);

// ferme le fichier
fclose($inF);


// Libérer le résultat
pg_free_result($resultat);



// préparer la requête qui liste les types d'unités de connaissance
$requete = "SELECT pk_type_unite_connaissance,
       nom,
       categorie_uc
FROM tables_types.type_unite_connaissance
WHERE si_utilise IS TRUE
ORDER BY nom;";

//ouvre la connection avec la fonction externe et récupère la variable
$connexion = connexion();


// effectuer la requête qui liste les types de cet objet
$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

//préparer le résultat pour l'utilisation dans le formulaire
$liste_types = array();
while ($types = pg_fetch_object($resultat))
{   if(isset($form_typeUC) and $types->pk_type_unite_connaissance == $form_typeUC) {$selected = 'selected="selected"' ;} else {$selected = ''; };
$liste_types[] = '<option '.$selected.' value="'.$types->pk_type_unite_connaissance.'">'.
$types->nom.' ['.$types->categorie_uc.' – Clé: '.
$types->pk_type_unite_connaissance.']</option>';
}

// Libérer le résultat
pg_free_result($resultat);


// Fermer la connexion
pg_close($connexion);


?>




<!-- Commence ici la partie HTML -->

<?php html_header ('Liste UC', '../css/unite_connaissance.css');

echo
'<div>
		<h2>'.$titre_div.'</h2>
</div>';?>


<form action="unite_connaissance_liste.php" method="get">

<table border="1">

	<tr>
		<th>Clé numérique</th>
		<th>Sujet UC</th>
		<th>Libellé UC</th>
		<th>Autres objets associés</th>
		<th>Type de l'UC</th>
		<th>Liste de types (séparés par virgule)</th>
	</tr>

	<tr>
		<td><input type="text" size="3" name="cleUC"
			value="<?php if (isset($form_cleUC)) echo $form_cleUC; ?>" /></td>
		<td><input type="text" size="20" name="sujet"
			value="<?php if(isset($form_sujet)) echo $form_sujet; ?>" /></td>
		<td><input type="text" size="20" name="libelle"
			value="<?php if(isset($form_libelle)) echo $form_libelle; ?>" />
		</td>
		<td><input type="text" size="20" name="autresObjets"
			value="<?php if(isset($form_autresObjets)) echo $form_autresObjets; ?>" /></td>
		<td><select name="typeUC">
			<option value=""></option>
			<?php foreach ($liste_types as $type) {
				echo $type;
			}?>
		</select></td>
		<td><input type="text" size="15" name="listeTypesUC"
			value="<?php if(isset($form_listeTypesUC)) echo $form_listeTypesUC; ?>" /></td>
	</tr>

</table>


<p>
<table border="1">

	<tr>
		<th>Après date</th>
		<th>Avant date</th>
		<th>Tri par date</th>
		<th><strong>Objets associés à l'UC via des rôles</strong> (clés
		séparées par virgule!)</th>
		<th>Objets qui classent et documentent les UC (idem!)</th>

	</tr>

	<tr>
		<td><input type="text" size="10" name="apresDate"
			value="<?php if(isset($form_apresDate)) echo $form_apresDate; ?>" /></td>
		<td><input type="text" size="10" name="avantDate"
			value="<?php if(isset($form_apresDate)) echo $form_avantDate; ?>"></td>
		<td><select name="triDate">
			<option value="ASC">ascendant</option>
			<option selected="selected" value="DESC">déscendant</option>
		</select></td>
		<td><input type="text" size="40" name="cleObjet"
			value="<?php if(isset($form_cleObjet)) echo $form_cleObjet; ?>" /></td>
		<td><input type="text" size="20" name="cleObjetAssocie"
			value="<?php if(isset($form_cleObjetAssocie)) echo $form_cleObjetAssocie; ?>" /></td>

	</tr>

</table>
</p>

<input type="submit" value="Chercher" />
<p></p>
<input type="hidden" name="typeListe" value="select_specific" /></form>
<p></p>

<h4
	class="ligne_horizontale_dessous"></h4>

<p>
<form
	action="../unite_connaissance/unite_connaissance_formulaire_insert.php"
	method="get"><input type="hidden" name="si_insert" value="t" /> <input
	type="submit" value="Nouvelle Unité de connaissance"
	style="float: left" /></form>

– <a href="unite_connaissance_liste.php">Recherche</a> – <a
	href="../accueil.php">Accueil</a> – <a href="../objet/objet_liste.php">Objets</a>
– <a href="../type_unite_connaissance/types_uc_liste.php"
	target="_blank">Liste des types d'unités de connaissance</a></p>


			<?php echo
'<div>
		<table class="invisible">
		    <tr>
				<td style="font-weight:bold; color:#0000FF; font-size:larger; float:right;">Resultat : '.$nombre_lignes.' ligne(s)</td>
				<td>		<form target="_blank" method="post" action="uc_timeline_resultat_select.php">
							 <input type="submit" value="Visualiser avec timeline"/><select name="type_timeline" >
								<option value="decade" selected>Décade – Année – mois</option>
								<option value="annee" selected>Année – mois</option>
								<option value="mois">Mois – semaine – jour</option>
							</select>
							</form>
                       </td>
        	</tr>
        </table>
</div>';

			//						onclick="window.open(\'uc_timeline_resultat_select.php\')"



			?>


<div class="scrollingArea">
<table class="listeObjets scrollable">
	<thead>
		<tr>
			<th class="cle">
			<div>Clé</div>
			</th>
			<th class="date">
			<div>Date</div>
			</th>
			<th class="nom">
			<div>Sujet</div>
			</th>
			<th class="date">
			<div>Type</div>
			</th>
			<th class="descriptif">
			<div>Libellé [liste des autres objets associés]</div>
			</th>
			<th class="notes">
			<div>Notes</div>
			</th>
			<th class="nombre_pt">
			<div>PT</div>
			</th>
		</tr>
	</thead>
	<tbody>


	<?php
	foreach ($tableau_lignes as $ligne) {
		echo $ligne;}
		?>
	</tbody>
</table>
</div>
<div></div>
<body></body>
<html></html>
