<?php
require_once("../connexion_base_individuelle.inc");
require_once("../html_parts.inc");
require_once("../traitement_slashes_magic_quotes.inc");

//ouvre la connection avec la fonction externe et récupère la variable
$connexion = connexion();



// prépare le tableau des variables préfixées avec 'form', fonction utilisateur, cf. echo $form_typeListe;
$tableau_variables = request_variables_sans_slashes($_REQUEST, 'form');


/* Types de l'association  */

// préparer la requête qui liste les types de l'association
$requete = "SELECT pk_parametre,
	      			nom
	 			FROM tables_types.parametre
	 			WHERE  type_parametre = 'type_association_objets'
	 			ORDER BY nom;";

// effectuer la requête
$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

//préparer le résultat pour l'utilisation dans le formulaire
$liste_types_association = array();
while ($types = pg_fetch_object($resultat))
{
	$parametre = $types->pk_parametre;
$type = $types->nom;
$liste_types_association[$parametre] = $type ;

}



// Libérer le résultat
pg_free_result($resultat);



/*Types */
// préparer la requête qui liste les types de cet objet
$requete = "SELECT pk_parametre, nom
FROM tables_types.parametre
WHERE type_parametre = 'type_objet'
ORDER BY nom";


// effectuer la requête qui liste les types de cet objet
$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

//préparer le résultat pour l'utilisation dans le formulaire
$liste_types = array();
while ($types = pg_fetch_object($resultat))
{ $parametre = $types->pk_parametre;
$type = $types->nom;
$liste_types[$parametre] = $type ;
}

// Libérer le résultat
pg_free_result($resultat);


/*Sous-types */
// préparer la requête qui liste les sous-types de cet objet
$requete = "SELECT pk_parametre, nom
FROM tables_types.parametre
WHERE type_parametre = 'sous_type_objets'
ORDER BY nom";


// effectuer la requête qui liste les types de cet objet
$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

//préparer le résultat pour l'utilisation dans le formulaire
$liste_sous_types = array();
while ($types = pg_fetch_object($resultat))
{
	$liste_sous_types[$types->pk_parametre] = $types->nom ;
}


// Libérer le résultat
pg_free_result($resultat);

// prépare les variables du tableau
foreach ($tableau_variables as $cle => $element) {
	${$cle} = $element;
}




if (isset($form_typeListe) and $form_typeListe=='select_specific') {

	
	// prépare les variables
	$selNom = '';
	$selCleObjet = '';
	$selTypeObjet='';
	$selSousTypeObjet = '';
	$selAnneeMin ='';
	$selMoisMin ='';
	$selJourMin ='';
	$selAnneeMax ='';
	$selMoisMax ='';
	$selJourMax ='';
	$selDescriptif = '';
	$selurlObjet = '';
	$selNotes = '';
	$selCleObjetBHP = '';
	$selTypeAssociation = '';
	$partie_requete_classes = '';

	if($form_nom) $selNom = 'AND tables_objet.majuscule_sans_accents(t1.nom) LIKE tables_objet.majuscule_sans_accents(E\'%'.addslashes($form_nom).'%\')';
	if($form_cleObjet) $selCleObjet= ' AND t2.pk_objet = '.$form_cleObjet ;
	if($form_typeObjet and $form_typeObjet !== 'vide') $selTypeObjet = ' AND t2.fk_type_objet = '.$form_typeObjet ;
	if($form_sousTypeObjet and $form_sousTypeObjet !== 'vide') $selSousTypeObjet = ' AND t2.fk_sous_type_objet = '.$form_sousTypeObjet ;
	if($form_anneeDebutMin) $selAnneeMin = ' AND t2.annee_debut >= '.$form_anneeDebutMin ;
	if($form_moisDebutMin) $selMoisMin = ' AND t2.mois_debut >= '.$form_moisDebutMin ;
	if($form_jourDebutMin) $selJourMin = ' AND t2.jour_debut >= '.$form_jourDebutMin ;
	if($form_anneeDebutMax) $selAnneeMax = ' AND t2.annee_debut <= '.$form_anneeDebutMax  ;
	if($form_moisDebutMax) $selMoisMax = ' AND t2.mois_debut <= '.$form_moisDebutMax  ;
	if($form_jourDebutMax) $selJourMax = ' AND t2.jour_debut <= '.$form_jourDebutMax  ;
	if($form_descriptif) $selDescriptif = ' AND tables_objet.majuscule_sans_accents(t2.descriptif) LIKE tables_objet.majuscule_sans_accents(E\'%'.addslashes($form_descriptif).'%\')';
	if($form_urlObjet) $selurlObjet = ' AND tables_objet.majuscule_sans_accents(t2.url_objet) LIKE tables_objet.majuscule_sans_accents(E\'%'.addslashes($form_urlObjet).'%\')' ;
	if($form_notes) $selNotes = ' AND tables_objet.majuscule_sans_accents(t2.notes) LIKE tables_objet.majuscule_sans_accents(E\'%'.addslashes($form_notes).'%\')';
	if($form_cleObjetBHP) $selCleObjetBHP = ' AND tables_objet.majuscule_sans_accents(t2.cle_objet_bhp) LIKE tables_objet.majuscule_sans_accents(\''.$form_cleObjetBHP.'\')';
	// numéro de l'alias de table de départ pour les objets associés
	$table_alias = 8;
	if($form_typeAssociation) $selTypeAssociation = " AND t".$table_alias.".fk_type_association_objet=".$form_typeAssociation ;

	
	// prépare les valeurs pour le tri en fonction de la colonne retenue
	switch ($form_champsTri) {
		case "nom":
			$sql_champsTri = "t4.nom ".$form_ordreTri;
			break;
		case "type":
			$sql_champsTri = "t3.nom ".$form_ordreTri.", t5.nom ".$form_ordreTri;
			break;
		case "date":
			$sql_champsTri = "t2.annee_debut ".$form_ordreTri.", t2.mois_debut ".$form_ordreTri.", t2.jour_debut ".$form_ordreTri.", t4.nom";
			break;
		default:
			$sql_champsTri = "t4.nom";
	}


	// Traite une requête contenant une liste de clés d'objets (classes ou thématiques) séparée par virgule.
	// Crée une série de JOINs correspondant à chaque objet
	if($form_cleClasse) {
		$tableauClesClasses = array();
		$tableauClesClasses = explode(',', $form_cleClasse);
		// test :
		// echo 'Nombre lignes : '. count($tableauClesClasses);
		$tableau_sortie = array();
		foreach ($tableauClesClasses as $item)
		{ if(is_numeric(trim($item))) {
			$tableau_sortie[] = "JOIN tables_objet.associer_objet t".$table_alias." ON t".$table_alias.".fk_objet_concerne = t2.pk_objet
				AND t".$table_alias.".fk_objet_associe = ".$item.$selTypeAssociation ;
			++$table_alias;
		}
		}
		$partie_requete_classes = implode( ' ', $tableau_sortie);
	}


	$requete = "WITH table_noms AS
		/* ATTENTION : cette partie permet de lister tous les noms de chaque objet 
		et d'effectuer la recherche sur tous les noms*/
		(SELECT fk_objet,
        array_to_string (ARRAY (SELECT unnest (array_agg (nom)) ORDER BY 1),', ') as nom 
		FROM tables_objet.nom_objet
		GROUP BY fk_objet
		)
		SELECT t2.pk_objet, t4.nom, 
		CASE WHEN length(t2.descriptif) < 120 THEN t2.descriptif ELSE substring(t2.descriptif, 1, 120)||' [...]' END AS descriptif, 
	   	t6.date_debut_recomposee,
	   	t7.date_fin_recomposee, 
	   	t3.nom AS type_objet,
	    t5.nom AS sous_type,
        t2.notes
	   	FROM table_noms t1 
	   	JOIN tables_objet.objet t2 ON t2.pk_objet = t1.fk_objet".$selTypeObjet.$selSousTypeObjet.
	   	" JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t4 ON t4.fk_objet = t2.pk_objet ".
	$partie_requete_classes.
	   	" LEFT JOIN tables_types.parametre t3 ON t3.pk_parametre = t2.fk_type_objet
	   	LEFT JOIN tables_types.parametre t5 ON t5.pk_parametre = t2.fk_sous_type_objet
	   	LEFT JOIN vues_sql.v_objet_date_debut_recomposee t6 ON t6.pk_objet = t1.fk_objet
	   	LEFT JOIN vues_sql.v_objet_date_fin_recomposee t7 ON t7.pk_objet = t1.fk_objet
	   	
	   	WHERE t2.pk_objet > 0".
	$selNom.$selCleObjet.$selAnneeMin.$selMoisMin.$selJourMin.$selAnneeMax.$selMoisMax.$selJourMax.$selDescriptif.$selurlObjet.$selNotes.$selCleObjetBHP.
	    " ORDER BY ".$sql_champsTri." ;" ;

	
	$titre_div = 'Résultat de la recherche';

	
	if($form_descriptif) $descriptif = $form_descriptif; else $descriptif = '';
	if($form_notes) $notes = $form_notes; else $notes = '';


}

/*requête générique qui cherche les 15 derniers objets entrés dans la base */
else {
	$requete = "SELECT t2.pk_objet,
       	t1.nom,
        CASE WHEN length(t2.descriptif) < 120 THEN t2.descriptif ELSE substring(t2.descriptif, 1, 120)||' [...]' END AS descriptif, 
        t5.date_debut_recomposee,
        t6.date_fin_recomposee,
        t3.nom AS type_objet,
        t4.nom AS sous_type,
        t2.notes
		FROM tables_objet.v_noms_standards_objets_dans_ordre_chronologique t1 
		  JOIN tables_objet.objet t2 ON t2.pk_objet = t1.fk_objet 
		  LEFT JOIN tables_types.parametre t3 ON t3.pk_parametre = t2.fk_type_objet
		  LEFT JOIN tables_types.parametre t4 ON t4.pk_parametre = t2.fk_sous_type_objet
		  LEFT JOIN vues_sql.v_objet_date_debut_recomposee t5 ON t5.pk_objet = t1.fk_objet
		  LEFT JOIN vues_sql.v_objet_date_fin_recomposee t6 ON t6.pk_objet = t1.fk_objet
		  
		ORDER BY t2.pk_objet desc LIMIT 15;";

	$titre_div = 'Liste des derniers objets crées (tri décroissant)';
}









$resultat = pg_query($requete) or die('Query failed: ' . pg_last_error());

$nombre_lignes = pg_num_rows($resultat);

$lignes_tableau=array() ;

while ($objet_resultat = pg_fetch_object ($resultat))

{
	// On encode le titre pour le placer dans l'URL – pas utilisé pour l'instant
	$titreURL = urlEncode ($objet_resultat->pk_objet);

	// On sort le tableau résultant de la requête
	$lignes_tableau[] = '<tr><td class="cle"><a href="objet_insert_update.php?cleObjet='.$objet_resultat->pk_objet.'" target="_blank"><div><span class="font_smaller">'.$objet_resultat->pk_objet.'</span></div></td>
<td class="nom"><div>'.$objet_resultat->nom.'</div></td>
<td class="debut"><div>'.$objet_resultat->date_debut_recomposee.'</div></td>
<td class="fin"><div>'.$objet_resultat->date_fin_recomposee.'</div></td>
<td class="descriptif"><div>'.$objet_resultat->descriptif.'</div></td>
<td class="type"><div>'.$objet_resultat->type_objet.'</div></td>
<td class="type"><div>'.$objet_resultat->sous_type.'</div></td>
</tr>';
}



// Libérer le résultat
pg_free_result($resultat);


// Fermer la connexion
pg_close($connexion);


?>




<!-- Commence ici la partie HTML -->



<?php html_header ('Liste objets', '../css/objet.css');?>


<div><h2>Recherche d'objets</h2>

<form action="objet_liste.php"  method="get">
	
		
<input type="hidden" name="typeListe" value="select_specific"/>		
		
		
<table border="1">


	<tr>
		<th>Nom</th>
		<th>Clé (nombre)</th>
		<th>Type d'objet<br/>(ou le sous-type, l'un ou l'autre)</th>
		<th>Sous-type d'objet<br/>(ou le type, l'un ou l'autre)</th>
		<th>Clé objet BHP<br/>(Recherche LIKE, ajouter % si souhaité)</th>
		<th>Tri par:</th>
		<th>Ordre de tri</th>
	</tr>

	<tr>
		<td><input type="text" size="15" name="nom"
			value="<?php if (isset($form_nom)) echo $form_nom; ?>" /></td>
		<td><input type="text" size="5" name="cleObjet"
			value="<?php echo $form_cleObjet; ?>" /></td>
		<td><select name="typeObjet" >
		<option value="vide"></option>
		<?php 
		foreach ($liste_types as $key => $type) {
		if($key == $form_typeObjet) $selected='selected'; else $selected = '';
		echo '<option '.$selected.' value="'.$key.'">'.$type.'</option>';} ;
		echo '</select>'
		?>
		</td>
		
		<td><select name="sousTypeObjet" value"<?php echo $form_sousTypeObjet; ?>">
		<option value="vide"></option>
		<?php 
		foreach ($liste_sous_types as $key => $sous_type) {
			echo $sous_type;
			if($key == $form_sousTypeObjet) $selected='selected'; else $selected = '';
			echo '<option '.$selected.' value="'.$key.'">'.$sous_type.'</option>';
		};
		?></select></td>
		<td><input type="text" size="5" name="cleObjetBHP" value="<?php echo $form_cleObjetBHP; ?>"/></td>
		<td><select name="champsTri">
		<?php 
			$champsTri = array('date', 'nom', 'type');
			foreach ($champsTri as $value) {
				if($form_champsTri == $value) $champsTriSelected = 'selected="selected"'; else $champsTriSelected = '';
				echo '<option value="'.$value.'" '.$champsTriSelected.'>'.$value.'</option>' ;}
		?>
		</select></td>
		<td><select name="ordreTri">
		<?php 
			if($form_ordreTri == 'ASC') 
				{$ordreTriSelectedAsc = 'selected="selected"';} 
				else {$ordreTriSelectedAsc = '';}
			echo'<option value="DESC">déscendant</option>
		   <option '.$ordreTriSelectedAsc.' value="ASC">ascendant</option>';
		?>
		</select> </td>
	</tr>
	<tr>
		<th>
		</th>
		<th>
		année
		</th>
		<th>
		mois
		</th>
		<th>
		jour
		</th>
		<th>
		année
		</th>
		<th>
		mois
		</th>
		<th>
		jour
		</th>
	</tr>
	<tr>
		<th>
		Date début après
		</th>
		<th>
		<input type="text" size="4" name="anneeDebutMin"  value="<?php echo $form_anneeDebutMin ; ?>" />
		</th>
		<th>
		<input type="text" size="4" name="moisDebutMin"  value="<?php echo $form_moisDebutMin ; ?>" />
		</th>
		<th>
		<input type="text" size="4" name="jourDebutMin"  value="<?php echo $form_jourDebutMin ; ?>" />
		– Date début avant
		</th>
		<th>
		<input type="text" size="4" name="anneeDebutMax"  value="<?php echo $form_anneeDebutMax ; ?>" />
		 </th>
		<th>
		<input type="text" size="4" name="moisDebutMax"  value="<?php echo $form_moisDebutMax ; ?>" />
		</th>
		<th>
		<input type="text" size="4" name="jourDebutMax"  value="<?php echo $form_jourDebutMax ; ?>" />
		</th>
	</tr>

<tr>
		<th>
		</th>
		<th>
		Type d'association
		</th>
		<th>
		Objet(s) (séparer par , )
		</th>
		<th>
		Descriptif
		</th>
		<th>
		Url de l'objet
		</th>
		<th>
		Notes
		</th>
		<th>
		</th>
	</tr>
	<tr>
		<th>
		Objets associés:
		</th>
		<th>
		<select name="typeAssociation">
		<option value=""/>
	
	<?php 
		foreach ($liste_types_association as $key => $type) {
		if($key == $form_typeAssociation) $selected='selected'; else $selected = '';
		echo '<option '.$selected.' value="'.$key.'">'.$type.'</option>';} ;
// 	echo $type; ???
		?>
        </select> 			
		</th>
		<th>
		<input type="text" size="18" name="cleClasse" value="<?php echo $form_cleClasse; ?>"/>
		</th>
		<th>
		<input type="text" size="25" name="descriptif" value="<?php $form_descriptif ; ?>"/>
		</th>
		<th>
		<input type="text" size="8" name="urlObjet" value="<?php echo $form_urlObjet ; ?>"/>
		</th>
		<th>
		<input type="text" size="8" name="notes" value="<?php echo $form_notes ; ?>"/>
		</th>
		<th>
		<input type="submit" value="Chercher" />  </p>
		</th>
	</tr>
	
</table>

</form>
</div>


<?php

//<div class="scrollableContainer"> </div>
echo '<div>
<h2>'.$titre_div.' : '.$nombre_lignes.' ligne(s)</h2>
</div>
<div class="renvois">
<p><a href="../accueil.php">Accueil</a> – <a href="objet_liste.php">Recherche / Liste des derniers objets</a>
  –  <a href="objet_formulaire_insert.php" target="_blank">Créer un nouvel objet</a></p></div>
 
 
<div class="scrollingArea">
<table class="listeObjets scrollable">
<thead>
<tr><th class="cle"><div>Clé objet</div></th>
<th class="nom"><div>Nom objet</div></th>
<th class="debut"><div>Date début</div></th>
<th class="fin"><div>Date fin</div></th>
<th class="descriptif"><div>Descriptif</div></th>
<th class="type"><div>Type objet</div></th>
<th class="type"><div>Sous-type</div></th>
</tr></thead>
<tbody >';

foreach ($lignes_tableau as $ligne) {
	echo $ligne;
}

?>
</tbody>
</table>
</div>
</div>
</body>
</html>
