<?php
require_once("../connexion_base_individuelle.inc");
require_once("../html_parts.inc");
require_once("../traitement_slashes_magic_quotes.inc");

// prépare le tableau des variables préfixées avec 'form', fonction utilisateur, cf. echo $form_typeListe;
$tableau_variables = request_variables_sans_slashes($_REQUEST, 'form');

// prépare les variables du tableau
foreach ($tableau_variables as $cle => $element) {
	${$cle} = $element;
}


if (!isset($form_typeObjet) ) $form_typeObjet = "";

// préparer la requête qui liste les types d'objets
$requete = "SELECT pk_parametre, nom
FROM tables_types.parametre
WHERE type_parametre = 'type_objet'
ORDER BY nom";

//ouvre la connection avec la fonction externe et récupère la variable
$connexion = connexion();

// effectuer la requête qui liste les types de cet objet
$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

//préparer le résultat pour l'utilisation dans le formulaire
$liste_types = array();
while ($types = pg_fetch_object($resultat))  {
	if ($types->pk_parametre == $form_typeObjet) {$selected = 'selected';} else {$selected = '';}

	$liste_types[] = '<option '.$selected.' value="'.$types->pk_parametre.'">'.$types->nom.'</option>';
}

// Libérer le résultat
pg_free_result($resultat);



/* Sélection d'un seul type d'objet et de ses sous-types */

if(is_numeric($form_typeObjet)) {
	$requete = "SELECT *
		FROM tables_types.v_types_sous_types_avec_noms
		WHERE fk_type = ".$form_typeObjet;
}
else {
	$requete = "SELECT *
		FROM tables_types.v_types_sous_types_avec_noms";

}

$titre_div = "Liste des types et sous-types d'objets";

//ouvre la connection avec la fonction externe et récupère la variable
$connexion = connexion();

$resultat = pg_query($requete) or die('Query failed: ' . pg_last_error());

//$nombre_lignes = pg_num_rows($resultat);

$lignes_tableau=array() ;

while ($objet_resultat = pg_fetch_object ($resultat))

{

	// pour l'instant, je n'affiche pas la colonne 'par défaut'
	//if ($objet_resultat->si_standard == 't') {$si_standard = 'par défaut';} else { $si_standard = '';}
	//<td >'.$si_standard.'</td>

	// On sort le tableau résultant de la requête
	$lignes_tableau[] = '<tr><td class="cle"><span class="font_smaller">'.$objet_resultat->fk_type.'</span></td>
<td class="strong">'.$objet_resultat->type_objet.'</td>
<td ><span class="font_smaller">'.$objet_resultat->fk_sous_type.'</span></td>
<td class="strong">'.$objet_resultat->sous_type_objet.'</td>
<td >'.$objet_resultat->descriptif_sous_type.'</td></tr>';
}



// Libérer le résultat
pg_free_result($resultat);


// Fermer la connexion
pg_close($connexion);


?>




<!-- Commence ici la partie HTML -->

<?php html_header ("Liste types d'objets", '../css/objet.css');
echo '<div>
<h2>'.$titre_div.'</h2>
</div>
<div class="renvois">
<p><a href="../accueil.php">Accueil</a> – <a href="objet_liste.php">Recherche / Liste des derniers objets</a>
  –  <a href="objet_formulaire_insert.php" target="_blank">Créer un nouvel objet</a></p></div>';

?>
<div class="scrollingAreaSousTypesObjets">
<table class="listeObjetsAssocies scrollable">
	<thead style="background-color: #E8E8E8">
		<tr>
			<th>Clé</th>
			<th>Type d'objet</th>
			<th>Clé</th>
			<th>Sous-type d'objet</th>
			<th>Descriptif du sous-type</th>
		</tr>
	</thead>
	<?php
	//liste_champs_objets_associes($tableau_documentations);
	echo '<tbody>';
	foreach ($lignes_tableau as $ligne) {
		echo $ligne;
	}?>
	</tbody>
</table>
</div>
<form action="objet_type_sous_type_liste.php" method="post">
<p>Type d'objet : <select name="typeObjet">
	<option <?php echo $selected ; ?> value="">[tous]</option>
	<?php foreach ($liste_types as $type) {
		echo $type;}?>
</select> <input type="submit" value="Sélectionner un type d'objet" /></p>
</form>


</body>
</html>
