--
-- PostgreSQL database dump
--

-- Dumped from database version 9.1.3
-- Dumped by pg_dump version 9.1.3
-- Started on 2012-11-09 12:28:26 CET

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 7 (class 2615 OID 19896)
-- Name: tables_uc; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA tables_uc;


SET search_path = tables_uc, pg_catalog;

--
-- TOC entry 212 (class 1255 OID 20557)
-- Dependencies: 7 604
-- Name: create_info_date_concatenated_date(); Type: FUNCTION; Schema: tables_uc; Owner: -
--

CREATE FUNCTION create_info_date_concatenated_date() RETURNS trigger
    LANGUAGE plpgsql
    AS $$

DECLARE variable_date text;

BEGIN

IF NEW.annee IS NOT NULL AND NEW.mois IS NULL THEN
	IF NEW.annee < 0 THEN
		variable_date := substring(to_char(NEW.annee, '0000')from 1 for 5);
	ELSE
		variable_date := substring(to_char(NEW.annee, '0000')from 2 for 5);
	END IF;
END IF;

IF NEW.annee IS NOT NULL AND NEW.mois IS NOT NULL AND NEW.jour IS NULL THEN
	IF NEW.annee < 0 THEN
		variable_date := substring(to_char(NEW.annee, '0000')from 1 for 5)||'-'||substring(to_char(NEW.mois, '00') from 2 for 3);	
	ELSE
		variable_date := substring(to_char(NEW.annee, '0000')from 2 for 5)||'-'||substring(to_char(NEW.mois, '00') from 2 for 3);
	END IF;
END IF;

IF NEW.annee IS NOT NULL AND NEW.mois IS NOT NULL AND NEW.jour IS NOT NULL THEN
	IF NEW.annee < 0 THEN
		variable_date := substring(to_char(NEW.annee, '0000')from 1 for 5)||'-'||substring(to_char(NEW.mois, '00') from 2 for 3)||'-'||substring(to_char(NEW.jour, '00') from 2 for 3);
	ELSE
		variable_date := substring(to_char(NEW.annee, '0000')from 2 for 5)||'-'||substring(to_char(NEW.mois, '00') from 2 for 3)||'-'||substring(to_char(NEW.jour, '00') from 2 for 3);
	END IF;
END IF;


IF NEW.annee IS NULL
THEN variable_date := NULL;
END IF;


IF  NEW.certitude_date = 1
THEN variable_date := variable_date;
ELSEIF NEW.certitude_date = 2
THEN variable_date := variable_date || ' r';

ELSEIF NEW.certitude_date = 3
THEN variable_date := variable_date || ' p';
END IF;




NEW.date_recomposee =  variable_date;

RETURN NEW;

END;
$$;


SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 171 (class 1259 OID 19947)
-- Dependencies: 7
-- Name: date_unite_connaissance; Type: TABLE; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE TABLE date_unite_connaissance (
    pk_date_unite_connaissance integer NOT NULL,
    fk_type_date integer,
    libelle_selon_source text,
    annee integer,
    mois integer,
    jour integer,
    date_recomposee character varying(20),
    certitude_date smallint,
    qualificatif_date smallint,
    marge_date integer,
    heures integer,
    minutes integer,
    secondes integer,
    descriptif text,
    notes text,
    fk_unite_connaissance integer
);


--
-- TOC entry 170 (class 1259 OID 19945)
-- Dependencies: 7 171
-- Name: date_unite_connaissance_pk_date_unite_connaissance_seq; Type: SEQUENCE; Schema: tables_uc; Owner: -
--

CREATE SEQUENCE date_unite_connaissance_pk_date_unite_connaissance_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2264 (class 0 OID 0)
-- Dependencies: 170
-- Name: date_unite_connaissance_pk_date_unite_connaissance_seq; Type: SEQUENCE OWNED BY; Schema: tables_uc; Owner: -
--

ALTER SEQUENCE date_unite_connaissance_pk_date_unite_connaissance_seq OWNED BY date_unite_connaissance.pk_date_unite_connaissance;


--
-- TOC entry 173 (class 1259 OID 19959)
-- Dependencies: 7
-- Name: propriete_texte; Type: TABLE; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE TABLE propriete_texte (
    pk_propriete_texte integer NOT NULL,
    texte text,
    descriptif text,
    notes text,
    code_langue character(3),
    fk_unite_connaissance integer,
    fk_type_propriete integer
);


--
-- TOC entry 172 (class 1259 OID 19957)
-- Dependencies: 7 173
-- Name: propriete_texte_pk_propriete_texte_seq; Type: SEQUENCE; Schema: tables_uc; Owner: -
--

CREATE SEQUENCE propriete_texte_pk_propriete_texte_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2265 (class 0 OID 0)
-- Dependencies: 172
-- Name: propriete_texte_pk_propriete_texte_seq; Type: SEQUENCE OWNED BY; Schema: tables_uc; Owner: -
--

ALTER SEQUENCE propriete_texte_pk_propriete_texte_seq OWNED BY propriete_texte.pk_propriete_texte;


--
-- TOC entry 167 (class 1259 OID 19925)
-- Dependencies: 7
-- Name: role; Type: TABLE; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE TABLE role (
    pk_role integer NOT NULL,
    libelle_selon_source text,
    valeur_numerique numeric,
    si_sujet_uc boolean,
    descriptif text,
    notes text,
    date_creation timestamp without time zone,
    fk_unite_connaissance integer,
    fk_objet_associe integer,
    fk_unite_connaissance_associee integer,
    fk_unite_mesure integer,
    fk_role_associe integer,
    notes_role_associe text,
    fk_type_role integer
);


--
-- TOC entry 166 (class 1259 OID 19923)
-- Dependencies: 7 167
-- Name: role_pk_role_seq; Type: SEQUENCE; Schema: tables_uc; Owner: -
--

CREATE SEQUENCE role_pk_role_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2266 (class 0 OID 0)
-- Dependencies: 166
-- Name: role_pk_role_seq; Type: SEQUENCE OWNED BY; Schema: tables_uc; Owner: -
--

ALTER SEQUENCE role_pk_role_seq OWNED BY role.pk_role;


--
-- TOC entry 169 (class 1259 OID 19936)
-- Dependencies: 7
-- Name: sourcer; Type: TABLE; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE TABLE sourcer (
    pk_sourcer integer NOT NULL,
    reference_precise text,
    descriptif text,
    notes text,
    fk_unite_connaissance integer,
    fk_objet integer
);


--
-- TOC entry 168 (class 1259 OID 19934)
-- Dependencies: 7 169
-- Name: sourcer_pk_sourcer_seq; Type: SEQUENCE; Schema: tables_uc; Owner: -
--

CREATE SEQUENCE sourcer_pk_sourcer_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2267 (class 0 OID 0)
-- Dependencies: 168
-- Name: sourcer_pk_sourcer_seq; Type: SEQUENCE OWNED BY; Schema: tables_uc; Owner: -
--

ALTER SEQUENCE sourcer_pk_sourcer_seq OWNED BY sourcer.pk_sourcer;


--
-- TOC entry 165 (class 1259 OID 19907)
-- Dependencies: 7
-- Name: unite_connaissance; Type: TABLE; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE TABLE unite_connaissance (
    pk_unite_connaissance integer NOT NULL,
    descriptif text,
    notes text,
    date_creation timestamp without time zone,
    fk_type_unite_connaissance integer
);


--
-- TOC entry 164 (class 1259 OID 19905)
-- Dependencies: 7 165
-- Name: unite_connaissance_pk_unite_connaissance_seq; Type: SEQUENCE; Schema: tables_uc; Owner: -
--

CREATE SEQUENCE unite_connaissance_pk_unite_connaissance_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2268 (class 0 OID 0)
-- Dependencies: 164
-- Name: unite_connaissance_pk_unite_connaissance_seq; Type: SEQUENCE OWNED BY; Schema: tables_uc; Owner: -
--

ALTER SEQUENCE unite_connaissance_pk_unite_connaissance_seq OWNED BY unite_connaissance.pk_unite_connaissance;


--
-- TOC entry 194 (class 1259 OID 20572)
-- Dependencies: 2234 7
-- Name: v_date_standard_uc; Type: VIEW; Schema: tables_uc; Owner: -
--

CREATE VIEW v_date_standard_uc AS
    SELECT date_unite_connaissance.fk_unite_connaissance, (ARRAY(SELECT unnest(array_agg(date_unite_connaissance.date_recomposee)) AS unnest ORDER BY unnest(array_agg(date_unite_connaissance.fk_type_date))))[1] AS date_standard FROM date_unite_connaissance GROUP BY date_unite_connaissance.fk_unite_connaissance;


--
-- TOC entry 193 (class 1259 OID 20568)
-- Dependencies: 2233 7
-- Name: v_libelle_uc; Type: VIEW; Schema: tables_uc; Owner: -
--

CREATE VIEW v_libelle_uc AS
    SELECT t1.pk_unite_connaissance, CASE WHEN ((t1.descriptif IS NULL) OR (t1.descriptif = ''::text)) THEN t2.nom ELSE t1.descriptif END AS libelle_uc, t1.fk_type_unite_connaissance FROM (unite_connaissance t1 JOIN tables_types.type_unite_connaissance t2 ON ((t2.pk_type_unite_connaissance = t1.fk_type_unite_connaissance)));


--
-- TOC entry 195 (class 1259 OID 20601)
-- Dependencies: 2235 7
-- Name: v_sujet_uc; Type: VIEW; Schema: tables_uc; Owner: -
--

CREATE VIEW v_sujet_uc AS
    SELECT t1.fk_unite_connaissance, array_to_string(ARRAY(SELECT unnest(array_agg(CASE WHEN (t3.nom IS NOT NULL) THEN t3.nom ELSE t2.libelle_uc END)) AS unnest ORDER BY unnest(array_agg(CASE WHEN (t3.nom IS NOT NULL) THEN t3.nom ELSE t2.libelle_uc END))), ', '::text) AS sujet_uc FROM ((role t1 LEFT JOIN v_libelle_uc t2 ON ((t2.pk_unite_connaissance = t1.fk_unite_connaissance_associee))) LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t3 ON ((t3.fk_objet = t1.fk_objet_associe))) WHERE (t1.si_sujet_uc IS TRUE) GROUP BY t1.fk_unite_connaissance;


--
-- TOC entry 196 (class 1259 OID 20606)
-- Dependencies: 2236 7
-- Name: v_role_avec_uc; Type: VIEW; Schema: tables_uc; Owner: -
--

CREATE VIEW v_role_avec_uc AS
    SELECT t1.pk_role, t1.fk_objet_associe, t1.fk_unite_connaissance_associee, CASE WHEN ((t6.nom IS NOT NULL) OR (t6.nom <> ''::text)) THEN t6.nom ELSE t8.libelle_uc END AS objet_uc_associee, t1.fk_type_role, t7.nom AS type_role, t1.libelle_selon_source, t1.si_sujet_uc, t1.valeur_numerique, t4.nom AS unite_mesure, t9.sujet_uc, t2.libelle_uc, t3.date_standard, t5.nom AS type_uc, t2.pk_unite_connaissance FROM ((((((((role t1 JOIN v_libelle_uc t2 ON ((t2.pk_unite_connaissance = t1.fk_unite_connaissance))) JOIN v_date_standard_uc t3 ON ((t3.fk_unite_connaissance = t1.fk_unite_connaissance))) JOIN tables_types.type_unite_connaissance t5 ON ((t5.pk_type_unite_connaissance = t2.fk_type_unite_connaissance))) JOIN tables_types.type_role t7 ON ((t7.pk_type_role = t1.fk_type_role))) LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t6 ON ((t6.fk_objet = t1.fk_objet_associe))) LEFT JOIN v_libelle_uc t8 ON ((t8.pk_unite_connaissance = t1.fk_unite_connaissance_associee))) LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t4 ON ((t4.fk_objet = t1.fk_unite_mesure))) LEFT JOIN v_sujet_uc t9 ON ((t9.fk_unite_connaissance = t1.fk_unite_connaissance)));


--
-- TOC entry 197 (class 1259 OID 20630)
-- Dependencies: 2237 7
-- Name: v_sources_avec_libelles; Type: VIEW; Schema: tables_uc; Owner: -
--

CREATE VIEW v_sources_avec_libelles AS
    SELECT t1.fk_unite_connaissance, t3.libelle_uc, t1.fk_objet, t2.nom AS source, t5.nom AS sous_type_objet, t1.reference_precise, t1.descriptif, t1.notes, t1.pk_sourcer FROM ((((sourcer t1 LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t2 ON ((t2.fk_objet = t1.fk_objet))) LEFT JOIN tables_objet.objet t4 ON ((t4.pk_objet = t1.fk_objet))) LEFT JOIN tables_types.parametre t5 ON ((t5.pk_parametre = t4.fk_sous_type_objet))) LEFT JOIN v_libelle_uc t3 ON ((t3.pk_unite_connaissance = t1.fk_unite_connaissance)));


--
-- TOC entry 2242 (class 2604 OID 19950)
-- Dependencies: 170 171 171
-- Name: pk_date_unite_connaissance; Type: DEFAULT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY date_unite_connaissance ALTER COLUMN pk_date_unite_connaissance SET DEFAULT nextval('date_unite_connaissance_pk_date_unite_connaissance_seq'::regclass);


--
-- TOC entry 2243 (class 2604 OID 19962)
-- Dependencies: 172 173 173
-- Name: pk_propriete_texte; Type: DEFAULT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY propriete_texte ALTER COLUMN pk_propriete_texte SET DEFAULT nextval('propriete_texte_pk_propriete_texte_seq'::regclass);


--
-- TOC entry 2240 (class 2604 OID 19928)
-- Dependencies: 167 166 167
-- Name: pk_role; Type: DEFAULT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY role ALTER COLUMN pk_role SET DEFAULT nextval('role_pk_role_seq'::regclass);


--
-- TOC entry 2241 (class 2604 OID 19939)
-- Dependencies: 169 168 169
-- Name: pk_sourcer; Type: DEFAULT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY sourcer ALTER COLUMN pk_sourcer SET DEFAULT nextval('sourcer_pk_sourcer_seq'::regclass);


--
-- TOC entry 2239 (class 2604 OID 19910)
-- Dependencies: 165 164 165
-- Name: pk_unite_connaissance; Type: DEFAULT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY unite_connaissance ALTER COLUMN pk_unite_connaissance SET DEFAULT nextval('unite_connaissance_pk_unite_connaissance_seq'::regclass);


--
-- TOC entry 2253 (class 2606 OID 19955)
-- Dependencies: 171 171
-- Name: date_unite_connaissance_pkey; Type: CONSTRAINT; Schema: tables_uc; Owner: -; Tablespace: 
--

ALTER TABLE ONLY date_unite_connaissance
    ADD CONSTRAINT date_unite_connaissance_pkey PRIMARY KEY (pk_date_unite_connaissance);


--
-- TOC entry 2256 (class 2606 OID 19967)
-- Dependencies: 173 173
-- Name: propriete_texte_pkey; Type: CONSTRAINT; Schema: tables_uc; Owner: -; Tablespace: 
--

ALTER TABLE ONLY propriete_texte
    ADD CONSTRAINT propriete_texte_pkey PRIMARY KEY (pk_propriete_texte);


--
-- TOC entry 2248 (class 2606 OID 19933)
-- Dependencies: 167 167
-- Name: role_pkey; Type: CONSTRAINT; Schema: tables_uc; Owner: -; Tablespace: 
--

ALTER TABLE ONLY role
    ADD CONSTRAINT role_pkey PRIMARY KEY (pk_role);


--
-- TOC entry 2251 (class 2606 OID 19944)
-- Dependencies: 169 169
-- Name: sourcer_pkey; Type: CONSTRAINT; Schema: tables_uc; Owner: -; Tablespace: 
--

ALTER TABLE ONLY sourcer
    ADD CONSTRAINT sourcer_pkey PRIMARY KEY (pk_sourcer);


--
-- TOC entry 2245 (class 2606 OID 19912)
-- Dependencies: 165 165
-- Name: unite_connaissance_pkey; Type: CONSTRAINT; Schema: tables_uc; Owner: -; Tablespace: 
--

ALTER TABLE ONLY unite_connaissance
    ADD CONSTRAINT unite_connaissance_pkey PRIMARY KEY (pk_unite_connaissance);


--
-- TOC entry 2246 (class 1259 OID 20442)
-- Dependencies: 167
-- Name: fki_cle_role; Type: INDEX; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE INDEX fki_cle_role ON role USING btree (fk_unite_connaissance);


--
-- TOC entry 2254 (class 1259 OID 20453)
-- Dependencies: 171
-- Name: fki_fkc_date; Type: INDEX; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE INDEX fki_fkc_date ON date_unite_connaissance USING btree (fk_unite_connaissance);


--
-- TOC entry 2249 (class 1259 OID 20459)
-- Dependencies: 169
-- Name: fki_fkc_sourcer; Type: INDEX; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE INDEX fki_fkc_sourcer ON sourcer USING btree (fk_unite_connaissance);


--
-- TOC entry 2261 (class 2620 OID 20559)
-- Dependencies: 212 171
-- Name: set_concatenated_date; Type: TRIGGER; Schema: tables_uc; Owner: -
--

CREATE TRIGGER set_concatenated_date BEFORE INSERT OR UPDATE ON date_unite_connaissance FOR EACH ROW EXECUTE PROCEDURE create_info_date_concatenated_date();


--
-- TOC entry 2259 (class 2606 OID 20552)
-- Dependencies: 165 171 2244
-- Name: fkc_date; Type: FK CONSTRAINT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY date_unite_connaissance
    ADD CONSTRAINT fkc_date FOREIGN KEY (fk_unite_connaissance) REFERENCES unite_connaissance(pk_unite_connaissance) ON DELETE CASCADE;


--
-- TOC entry 2260 (class 2606 OID 20616)
-- Dependencies: 165 173 2244
-- Name: fkc_propriete_texte; Type: FK CONSTRAINT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY propriete_texte
    ADD CONSTRAINT fkc_propriete_texte FOREIGN KEY (fk_unite_connaissance) REFERENCES unite_connaissance(pk_unite_connaissance) ON DELETE CASCADE;


--
-- TOC entry 2257 (class 2606 OID 20443)
-- Dependencies: 167 2244 165
-- Name: fkc_role; Type: FK CONSTRAINT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY role
    ADD CONSTRAINT fkc_role FOREIGN KEY (fk_unite_connaissance) REFERENCES unite_connaissance(pk_unite_connaissance) ON DELETE CASCADE;


--
-- TOC entry 2258 (class 2606 OID 20454)
-- Dependencies: 165 169 2244
-- Name: fkc_sourcer; Type: FK CONSTRAINT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY sourcer
    ADD CONSTRAINT fkc_sourcer FOREIGN KEY (fk_unite_connaissance) REFERENCES unite_connaissance(pk_unite_connaissance) ON DELETE CASCADE;


-- Completed on 2012-11-09 12:28:26 CET

--
-- PostgreSQL database dump complete
--
