<?php

// ATTENTION : ce script sert à créer également les unités de connaissance

require_once("../connexion_base_individuelle.inc");
require_once("../html_parts.inc");
require_once("../preparation_insert_update.inc");

//ouvre la connection avec la fonction externe et récupère la variable
$connexion = connexion();



/* INSERT – formulaire : insertion d'un nouveau rôle
 * à partir du formulaire des unités de connaissance –
 * ce script fait fonction de formulaire */

if (isset($form_effectuer) and $form_effectuer == 'role_form_insert') {


	if (!empty($form_cleUC)) $cle_uc = $form_cleUC ; else $cle_uc = '';


	//Variables diverses
	$debut_h1 = 'Nouveau rôle.';
	$cle_role = 0;

	$nom_objet_associe = '';
	$cle_objet = '';
	$fk_unite_connaissance_associee = '';
	$selected_false = 'selected';
	$selected_true = '';
	$libelle_selon_source = '';
	$valeur_numerique ='';
	$fk_unite_mesure = '';
	$nom_unite_mesure = '';
	$descriptif ='';
	$notes = '';
	$fk_unite_connaissance = $form_cleUC;
	$valeur_bouton = 'Créer le nouveau rôle';
	$valeur_effectuer = 'insert_new_role';
	$qualificatif_role = '';

}


/* Les autres cas : le formulaire est rempli */

else {

	/* ce traitment s'applique lorsqu'un INSERT d'une Unité de connaissance est appelé depuis le formulaire  */

	if (!empty($form_cleUC)) $cle_uc = $form_cleUC ; else $cle_uc = '';

	if (isset($form_effectuer) and $form_effectuer == 'insert_uc') {

		// Ce test vérifie que les données à insérer dans la date soient bien numériques
		if (
		(!empty($form_annee) and !is_numeric($form_annee))
		or (is_numeric($form_annee) and
		(!empty($form_mois) and !is_numeric($form_mois) or !empty($form_jour) and !is_numeric($form_jour)) )
		) {
			html_header ('Attention', '../css/unite_connaissance.css');
			exit( '<p>Attention : l\'année, mois et jour doivent être au format numérique.</p>
			<p><form action="unite_connaissance_formulaire_insert.php"  method="post" >
			<input type="hidden" name ="cleObjet" value="'.$cle_objet.'"></input>
			<input type="submit" value="OK" /></form></p></body></html>')	;
		}
		else
		{

			$requete = "INSERT INTO tables_uc.unite_connaissance
				( fk_type_unite_connaissance".$champs_descriptif.$champs_notes.", date_creation) 
				VALUES (".$form_typeUC.$partie_descriptif.$partie_notes.", now())";

			$resultat = pg_query($requete) or die('Query failed: ' . pg_last_error());

			if (!$resultat) {
				echo "An error occured.\n";
				exit;
			}

			// Libérer le résultat
			pg_free_result($resultat);


			// mettre dans la variable $cle_uc l'identifiant de l'unité de connaissance créée
			$requete = 'SELECT MAX(pk_unite_connaissance) AS pk_unite_connaissance
			FROM tables_uc.unite_connaissance;';

			$resultat = pg_query($requete) or die('Query failed: ' . pg_last_error());

			if (!$resultat) {
				echo "An error occured.\n";
				exit;
			}


			while ($row = pg_fetch_object($resultat)) {
				$cle_uc = $row->pk_unite_connaissance;
			}

			// Libérer le résultat
			pg_free_result($resultat);


			if (empty($form_annee) or !is_numeric($form_annee)) {
				echo 'Attention : manque la date !  Ce serait mieux, si possible, d\'en mettre une.';}
				else {
					// crééer la ligne date
					$requete = "INSERT INTO tables_uc.date_unite_connaissance (fk_unite_connaissance, annee, fk_type_date".
					$champs_mois.$champs_jour.$champs_certitude_date.")
						VALUES (".$cle_uc.", ".$form_annee.", ".$form_typeDate.
					$partie_mois.$partie_jour.$partie_certitude_date.")";
					$resultat = pg_query($requete) or die('Query failed: ' . pg_last_error());

					if (!$resultat) {
						echo "An error occured.\n";
						exit;
					}

					// Libérer le résultat
					pg_free_result($resultat);

				}
					
					
					
				// crééer la ligne rôle
				$requete = "INSERT INTO tables_uc.role (fk_unite_connaissance".$champs_fk_objet_associe.", date_creation)
				VALUES (".$cle_uc.$partie_fk_objet_associe.", now())";

				$resultat = pg_query($requete) or die('Query failed: ' . pg_last_error());

				if (!$resultat) {
					echo "An error occured.\n";
					exit;
				}

				// Test lors de la mise en place du script
				// $cmdtuples = pg_affected_rows($resultat);
				// echo '<br/>'.$cmdtuples . " tuples are affected.\n";

				// Libérer le résultat
				pg_free_result($resultat);
					
					
					
				// mettre dans la variable $cle_role l'identifiant du rôle créé
				$requete = 'SELECT MAX(pk_role) AS pk_role
			FROM tables_uc.role;';

				$resultat = pg_query($requete) or die('Query failed: ' . pg_last_error());

				if (!$resultat) {
		  	echo "An error occured.\n";
		  	exit;
				}

				$cle_role = '';

				while ($row = pg_fetch_object($resultat)) {
		  	$cle_role = $row->pk_role;
				}

				// Libérer le résultat
				pg_free_result($resultat);

					
				$cle_objet_source = ', '.$form_cleObjetSource;
				// crééer la ligne source
				if (isset($form_cleObjetSource) and is_numeric($form_cleObjetSource)) {
					$requete = "INSERT INTO tables_uc.sourcer (fk_unite_connaissance, fk_objet".$champs_reference_precise.")
					VALUES (".$cle_uc.$cle_objet_source.$partie_reference_precise.")";

					$resultat = pg_query($requete) or die('Query failed: ' . pg_last_error());

					if (!$resultat) {
						echo "An error occured.\n";
						exit;
					}

					// Test lors de la mise en place du script
					// $cmdtuples = pg_affected_rows($resultat);
					// echo '<br/>'.$cmdtuples . " tuples are affected.\n";

					// Libérer le résultat
					pg_free_result($resultat);




				}
		}


	}
	/* INSERT nouveau rôle pour unité de connaissance existante */


	elseif (isset($form_effectuer) and $form_effectuer == 'insert_new_role') {


		if(isset($form_fkTypeRole) and is_numeric($form_fkTypeRole)) {$fk_type_role = $form_fkTypeRole;}
		else {$fk_type_role = 'NULL';}

		$requete = "INSERT INTO tables_uc.role (fk_unite_connaissance, fk_type_role".
		$champs_fk_objet_associe.$champs_fk_unite_connaissance_associee.
		", si_sujet_uc".$champs_libelle_selon_source.
		$champs_valeur_numerique.$champs_fk_unite_mesure.
		$champs_descriptif.$champs_notes.$champs_fk_qualificatif_objet.
		$champs_fk_uc_qualificatif_objet.$champs_fk_qualificatif_role.
		", date_creation)
				VALUES (".$form_cleUC.", ".$fk_type_role.
		$partie_fk_objet_associe.$partie_fk_unite_connaissance_associee.
		", ".$form_siSujetUC.$partie_libelle_selon_source.
		$partie_valeur_numerique.$partie_fk_unite_mesure.
		$partie_descriptif.$partie_notes.$partie_fk_qualificatif_objet.
		$partie_fk_uc_qualificatif_objet.$partie_fk_qualificatif_role.
		", now())";


		// effectuer la requête
		$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

		// Libérer le résultat
		pg_free_result($resultat);

		// mettre dans la variable $cle_role l'identifiant du rôle créé
		$requete = 'SELECT MAX(pk_role) AS pk_role
		FROM tables_uc.role;';

		$resultat = pg_query($requete) or die('Query failed: ' . pg_last_error());

		if (!$resultat) {
			echo "An error occured.\n";
			exit;
		}

		$cle_role = '';

		while ($row = pg_fetch_object($resultat)) {
			$cle_role = $row->pk_role;
		}

		// Libérer le résultat
		pg_free_result($resultat);


	}


	/* UPDATE */

	elseif (isset($form_effectuer) and $form_effectuer == 'update_role') {


		$cle_role = $form_cleRole;
		if(isset($form_fkTypeRole) and is_numeric($form_fkTypeRole)) {$fk_type_role = $form_fkTypeRole;}
		else {$fk_type_role = 'NULL';}
		

		$requete = 'UPDATE tables_uc.role SET si_sujet_uc = '.$form_siSujetUC.', fk_type_role='.$fk_type_role.$update_fk_qualificatif_role.
		$update_cle_objet.$update_fk_unite_connaissance_associee.
		$update_fk_qualificatif_objet.$update_fk_uc_qualificatif_objet.$update_libelle_selon_source.
		$update_valeur_numerique.$update_fk_unite_mesure.
		$update_descriptif.$update_notes.
		' WHERE pk_role ='.$cle_role.';';


		// effectuer la requête
		$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

		// Libérer le résultat
		pg_free_result($resultat);
			
	}



	/* SELECT */

	if (empty($form_cleRole)) $cle_role = $cle_role; else $cle_role = $form_cleRole;

	
	 /* Déclaration de variables utilisées dans la requête (au cas où elles resteraient vides)*/

	$libelle_qualificatif_role = '';
	$libelle_uc = '';
	$uc_sujet_qualificatif_objet = '' ;
	$uc_autres_objets_qualificatif_objet = '';
	
	
	/* Propriétés du rôle*/

	// préparer la requête qui cherche les propriétés du rôle
	$requete = 'SELECT t5.nom AS libelle_objet_associe,
       t6.libelle_uc AS libelle_uc_associee,
       t10.sujet_uc,
       t9.autres_objets_uc,
       t2.nom AS libelle_qualificatif_role,
       t3.libelle_uc,
       t4.nom AS libelle_unite_mesure,
       t7.nom AS libelle_qualificatif_objet,
       t8.libelle_uc AS uc_libelle_qualificatif_objet,
       t1. *
FROM tables_uc.role t1
  LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t2 ON t2.fk_objet = t1.fk_qualificatif_role
  LEFT JOIN tables_uc.v_libelle_uc t3 ON t3.pk_unite_connaissance = t1.fk_unite_connaissance
  LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t4 ON t4.fk_objet = t1.fk_unite_mesure
  LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t5 ON t5.fk_objet = t1.fk_objet_associe
  LEFT JOIN tables_uc.v_libelle_uc t6 ON t6.pk_unite_connaissance = t1.fk_unite_connaissance_associee
  LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t7 ON t7.fk_objet = t1.fk_qualificatif_objet
  LEFT JOIN tables_uc.v_libelle_uc t8 ON t8.pk_unite_connaissance = t1.fk_uc_qualificatif_objet
  LEFT JOIN tables_uc.v_autres_objets_uc t9 ON t9.fk_unite_connaissance = t1.fk_uc_qualificatif_objet
  LEFT JOIN tables_uc.v_sujet_uc t10 ON t10.fk_unite_connaissance = t1.fk_uc_qualificatif_objet
  
WHERE pk_role ='.$cle_role;

	// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

	// récupérer le résultat dans une variable
	if ($resultat) {
		$champs_du_role = pg_fetch_assoc($resultat);
		$fk_type_role = $champs_du_role['fk_type_role'];
		$si_sujet_uc = $champs_du_role['si_sujet_uc'];
		$libelle_selon_source = $champs_du_role['libelle_selon_source'];
		$valeur_numerique = $champs_du_role['valeur_numerique'];
		$descriptif = $champs_du_role['descriptif'];
		$notes = $champs_du_role['notes'];
		$date_creation = $champs_du_role['date_creation'];
		$fk_unite_connaissance = $champs_du_role['fk_unite_connaissance'];
		$cle_objet = $champs_du_role['fk_objet_associe'];
		$fk_unite_connaissance_associee = $champs_du_role['fk_unite_connaissance_associee'];
		$fk_unite_mesure = $champs_du_role['fk_unite_mesure'];
		$fk_role_associe = $champs_du_role['fk_role_associe'];
		$notes_role_associe = $champs_du_role['notes_role_associe'];
		$qualificatif_role = $champs_du_role['fk_qualificatif_role'];
		$qualificatif_objet = $champs_du_role['fk_qualificatif_objet'];
		$uc_qualificatif_objet = $champs_du_role['fk_uc_qualificatif_objet'];
		$libelle_objet_associe = $champs_du_role['libelle_objet_associe'];
		$libelle_uc_associee = $champs_du_role['libelle_uc_associee'];
		$libelle_qualificatif_role = $champs_du_role['libelle_qualificatif_role'];
		$libelle_qualificatif_objet = $champs_du_role['libelle_qualificatif_objet'];
		$libelle_uc_qualificatif_objet = $champs_du_role['uc_libelle_qualificatif_objet'];
		$uc_sujet_qualificatif_objet = $champs_du_role['sujet_uc'];
		$uc_autres_objets_qualificatif_objet = $champs_du_role['autres_objets_uc'];
		$libelle_unite_mesure = $champs_du_role['libelle_unite_mesure'];
		$libelle_uc = $champs_du_role['libelle_uc'];
		

	}
	else {
		$liste_noms_standard = 'Erreur : manque le nom !';
	}

	// Vérifie si ce rôle est le sujet de l'unité de connaissance et prépare la variable pour le formulaire
	if ( $si_sujet_uc == 't') {
		$selected_false= '';
		$selected_true= 'selected';}
		else {$selected_false= 'selected';
		$selected_true= '';
		}
			
		// Libérer le résultat
		pg_free_result($resultat);
			

			
		/* Nom objet associé */
		// préparer la requête qui cherche le nom standard de l'objet

		$nom_objet_associe = '';


		if(isset($cle_objet) and is_numeric($cle_objet)) {
			$requete = "SELECT nom
				FROM tables_objet.v_noms_standards_objets_dans_ordre_chronologique
				WHERE fk_objet =".$cle_objet;

			// effectuer la requête
			$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

			//préparer le résultat pour l'utilisation dans le formulaire
			while ($noms = pg_fetch_object($resultat))
			{
				$nom_objet_associe = $noms->nom;
			}

			// Libérer le résultat
			pg_free_result($resultat);
		}
			
		//Variables diverses
		$debut_h1 = 'Rôle '.$cle_role;
		$valeur_bouton = 'Mettre à jour les propriétés du rôle';
		$valeur_effectuer = 'update_role';

		//fin de l' else général
}






/* Types de rôle  */
// préparer la requête qui liste les types de rôle en fonction du type d'unité de connaissance
$requete = "SELECT t1.fk_type_role,
	       t2.nom,
	       CASE
	         WHEN t3.pk_role IS NULL THEN NULL
	         ELSE 'selected'
	       END AS selected
		FROM tables_types.associer_type_uc_type_role t1 
	 	JOIN tables_types.type_role t2 ON t2.pk_type_role = t1.fk_type_role 
	  	LEFT JOIN tables_uc.role t3 ON t3.fk_type_role = t1.fk_type_role AND t3.pk_role = ".$cle_role.
		" WHERE fk_type_uc = ".$form_typeUC;

// effectuer la requête
$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

//préparer le résultat pour l'utilisation dans le formulaire
$liste_types = array();
while ($types = pg_fetch_object($resultat))
{
	$liste_types[] = '<option '.$types->selected.' value="'.$types->fk_type_role.'">'.$types->nom.'</option>';
}

// Libérer le résultat
pg_free_result($resultat);




// Préparer la requête qui cherche toutes les propriétés de l'objet associé via le rôle
		$requete = 'SELECT *
					FROM vues_sql.v_proprietes_avec_noms
					WHERE fk_role = '.$cle_role.'
					ORDER BY type_propriete';

		// effectuer la requête
		$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

		$nombre_roles = pg_num_rows($resultat);


		// Récupérer le résultat et le mettre dans un tableau

		while ($objet_resultat = pg_fetch_object ($resultat)) {

							
			// On sort le tableau résultant de la requête
			$tableau_proprietes_objets_associes[] = '<tr>
			<td><a href="../objet/objet_insert_update.php?cleObjet='.$objet_resultat->fk_type_propriete.'" target="_blank">'.$objet_resultat->type_propriete.'</a></td>
			<td><a href="../objet/objet_insert_update.php?cleObjet='.$objet_resultat->fk_valeur_propriete.'" target="_blank">'.$objet_resultat->valeur_propriete.'</a></td>
			<td>'.$objet_resultat->valeur_propriete_texte.'</td>
			<td><a href="../objet/objet_insert_update.php?cleObjet='.$objet_resultat->fk_unite_mesure.'" target="_blank">'.$objet_resultat->unite_mesure.'</a></td>
			<td>'.$objet_resultat->valeur_propriete_nombre.'</td>
			<td>'.$objet_resultat->notes.'</td>
			<td><a href="propriete_objet_associe_insert_update.php?cleProprieteObjetAssocie='.$objet_resultat->pk_propriete_objet_associe.
			'&cleRole='.$cle_role.'&typeUC='.$form_typeUC.'&fkTypeRole='.$fk_type_role.'">'
			.$objet_resultat->pk_propriete_objet_associe.'</a></td>
			
			</tr>';

		}


		// Libérer le résultat
		pg_free_result($resultat);
		
		
		

// Fermer la connexion
pg_close($connexion);

?>




<!-- Commence ici la partie HTML -->

<?php html_header ('Rôle', '../css/unite_connaissance.css'); ?>


<div class="en_tete_page">
<h1><?php 


if(strlen($libelle_objet_associe)>0 && strlen($libelle_uc_associee)<1) {$libelle_objet_ou_uc_associe = $libelle_objet_associe ;}
elseif (strlen($libelle_objet_associe)<1 && strlen($libelle_uc_associee)>0) $libelle_objet_ou_uc_associe = $libelle_uc_associee;
elseif (strlen($libelle_objet_associe)>0 && strlen($libelle_uc_associee)>0) $libelle_objet_ou_uc_associe = '<strong>ATTENTION</strong>: une seule valeur admise pour l\'objet associé! Enlevez la clé de l\'objet ou de l\'UC' ;

echo $debut_h1.' <span class="font_smaller"> – Objet / unité de connaissance associé(e) : </span>'.
$libelle_objet_ou_uc_associe;  
?></h1>
</div>

<div class="proprietes_role">
<p>Unité de connaissance concernée : 
<?php echo $cle_uc ;
if (strlen($libelle_uc)>0) echo ' – "'.$libelle_uc.'"';
?></p>

<form action="role_insert_update.php" method="post">

<h4 class="ligne_horizontale_dessous"></h4>

<p><strong>Type de rôle</strong> : <select name="fkTypeRole">
	<option value="" /><?php lignes_tableau($liste_types);?>

</select> – <strong>Qualificatif du rôle</strong> (objet abstrait) : <input
	type="text" size="3" name="qualificatifRole" value="<?php echo $qualificatif_role; ?>" /> 
	<?php if (strlen($libelle_qualificatif_role)>0) echo ' – <a href="../objet/objet_insert_update.php?cleObjet='.$qualificatif_role.'" target="_blank">'.$libelle_qualificatif_role.'</a>'; ?></p>



<h4 class="ligne_horizontale_dessous"></h4>


<p><strong>Clé de l'objet associé</strong> (format nombre) : <input
	type="text" size="3" name="cleObjet" value="<?php echo $cle_objet; ?>" />
	/ <strong>clé de l'unité de
connaissance associée</strong> (format nombre) :<input
	type="text" size="3" name="cleUCAssociee"
	value="<?php echo $fk_unite_connaissance_associee; ?>" /></p>



<p>Libéllé selon la source : <input type="text" size="80"
	name="libelleSelonSource" value="<?php echo $libelle_selon_source; ?>" /></p>
<p>Sujet de l'unité de connaissance: <select name="siSujetUC">
	<option <?php echo $selected_true; ?> value="TRUE">oui</option>
	<option <?php echo $selected_false; ?> value="FALSE">non</option>
</select> Valeur numérique (par ex. 25.14) : <input type="text" size="8" name="valeurNumerique"
	value="<?php echo $valeur_numerique; ?>" /> Unité de mesure (objet abstrait): <input
	type="text" size="2" name="fkUniteMesure"
	value="<?php echo $fk_unite_mesure; ?>" />
	<?php if (strlen($libelle_unite_mesure)>0) echo ' – "'.$libelle_unite_mesure.'"'; ?></p>
	
<p><strong>Qualificatif de l'objet ou de l'UC associée</strong> -> Objet: <input
	type="text" size="2" name="qualificatifObjet"
	value="<?php echo $qualificatif_objet; ?>" />
Unité de connaissance: <input
	type="text" size="2" name="ucQualificatifObjet"
	value="<?php echo $uc_qualificatif_objet; ?>" />
	
	<?php	if(strlen($libelle_qualificatif_objet)>0 && strlen($libelle_uc_qualificatif_objet)<1) {$libelle_objet_ou_uc_qualificatif = ' = <a href="../objet/objet_insert_update.php?cleObjet='.$qualificatif_objet.'" target="_blank">'.$libelle_qualificatif_objet.'</a>' ;}
			elseif (strlen($libelle_qualificatif_objet)<1 && strlen($libelle_uc_qualificatif_objet)>0) $libelle_objet_ou_uc_qualificatif = ' = <a href="../unite_connaissance/unite_connaissance_update.php?cleUC='.$uc_qualificatif_objet.'" target="_blank">'.$uc_sujet_qualificatif_objet.' – '.$libelle_uc_qualificatif_objet.' ['.$uc_autres_objets_qualificatif_objet.']</a>'  ;
			elseif (strlen($libelle_qualificatif_objet)>0 && strlen($libelle_uc_qualificatif_objet)>0) $libelle_objet_ou_uc_qualificatif = '<strong>ATTENTION</strong>: une seule valeur admise pour l\'objet associé! Enlevez la clé de l\'objet ou de l\'UC' ;
			else $libelle_objet_ou_uc_qualificatif = '';
        echo $libelle_objet_ou_uc_qualificatif; ?> 

</p>



<!-- appelle la partie du formulaire concernant descriptif et notes -->
<?php html_descriptif_notes(2, $descriptif, $notes) ; ?> <input
	type="hidden" name="cleUC"
	value="<?php echo $fk_unite_connaissance; ?>" /> <input type="hidden"
	name="typeUC" value="<?php echo $form_typeUC; ?>" /> <input
	type="hidden" name="effectuer" value="<?php echo $valeur_effectuer?>" />
<input type="hidden" name="cleRole" value="<?php echo $cle_role; ?>" />

<p><input type="submit" value="<?php echo $valeur_bouton?>" /></p>
</form>
<form action="unite_connaissance_update.php" method="post"><input
	type="hidden" name="cleUC"
	value="<?php echo $fk_unite_connaissance; ?>" /> <input type="hidden"
	name="ongletActif" value="roles" /> <input type="submit"
	value="Unité de connaissance" /></form>
	</div>

<!-- Tableau des propriété de l'objet associé via le rôle -->

<h4>Propriétés de l'objet associé</h4>

<div class="scrollingAreaObjetsAssociesTroisLignes">
				<table class="listeObjetsAssocies scrollable">
				<thead>
				<th>Type propriété</th>
				<th>Valeur propriété</th>
				<th>Valeur textuelle</th>
				<th>Unité de mesure</th>
				<th>Valeur numérique</th>
				<th>Notes</th>
				<th>Clé</th>
				</thead><tbody>
	<?php lignes_tableau($tableau_proprietes_objets_associes) ;?>	
</tbody></table>
<form action="propriete_objet_associe_insert_update.php" method="post">
	<input type="hidden" name="effectuer" value="form_insert" />
	<input type="hidden" name="cleRole" value="<?php echo $cle_role; ?>" /> 
	<input type="hidden" name="typeUC" value="<?php echo $form_typeUC; ?>" />
	<input type="hidden" name="fkTypeRole" value="<?php echo $fk_type_role ; ?>" />
	
	<p><input type="submit" value="Nouvelle propriété" style="float: right" /></p>

	</form>


</div>


</body>
</html>
