<?php

require_once("../connexion_base_individuelle.inc");
require_once("../html_parts.inc");
require_once("../preparation_insert_update.inc");


// on arrive sur ce script depuis :
// ce même script (POST)
// unite_connaissance_update.php (GET)
//


// récupère l'identifiant de l'unité de connaissance
if (isset($form_cleUC)) $cle_uc = $form_cleUC; else {$cle_uc = ''; echo "Manque l'identifiant de l'unité de connaissance";}

$echo_cle_uc = 'Clé de l\'unité de connaissance : '.$cle_uc;

// ce traitment s'applique lorsqu'un insert est appelé depuis la fiche de l'uc :
// ce script fait alors fonction de formulaire de saisie
if (isset($form_effectuer) and $form_effectuer == 'form_insert') {
	$titre_div_fomulaire = '<h2>Insérer une nouvelle propriété texte</h2>';
	$value_submit= 'Nouvelle propriété texte';
	$valeur_effectuer = 'insert';

	//ouvre la connection avec la fonction externe et récupère la variable
	$connexion = connexion();

	$cle_propriete_texte='';
	$texte = '';
	$descriptif = '';
	$notes = '';
	$code_langue = '';
	$type_propriete_texte ='';



	/* Type de propriété texte */

	// préparer la requête qui liste les paramètres du type de la propriété texte
	$requete = "SELECT t1.pk_parametre,
		    			t1.nom AS nom
						FROM tables_types.parametre t1 
						WHERE t1.type_parametre = 'type_propriete_texte_uc'
						ORDER BY t1.nom;";

	// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

	//préparer le résultat pour l'utilisation dans le formulaire
	$liste_type_propriete_texte = array();
	while ($lignes = pg_fetch_object($resultat))
	{
		$liste_type_propriete_texte[] = '<option value="'.$lignes->pk_parametre.'">'.$lignes->nom.'</option>';
	}

	// Libérer le résultat
	pg_free_result($resultat);

}

// ce traitement s'applique dans les autres cas
else {


	// récupère l'identifiant de l'objet
	if (isset($form_cleProprieteTexte) and is_numeric($form_cleProprieteTexte)) $cle_propriete_texte = $form_cleProprieteTexte;
	else {$cle_propriete_texte = '';}


	// Gestion du bouton effectuer	: insert ou update.
	if  (isset($form_effectuer))  {

			
		// UPDATE : Partie qui effectue l'UPDATE du nom
		if ($form_effectuer == 'update') {
			//echo 'UPDATE';


			$requete = "UPDATE tables_uc.propriete_texte SET fk_type_propriete=".$form_typeProprieteTexte.
			$update_texte.$update_code_langue.
			$update_descriptif.$update_notes."
				WHERE pk_propriete_texte = ".$cle_propriete_texte;

			//echo $requete;

			//ouvre la connection avec la fonction externe et récupère la variable
			$connexion = connexion();

			// effectuer la requête qui liste les types de cet objet
			$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

			// Libérer le résultat
			pg_free_result($resultat);



		}
		//  : Partie qui effectue l'INSERT du nouveau texte
		elseif ($form_effectuer == 'insert') {

			// Ce test vérifie les données à insérer
			if (!empty($text) and strlen($form_code_langue) > 3 )
			{
				html_header ('Attention', '../css/unite_connaissance.css');
				exit( '<p>Attention : il faut remplir le champs texte et le code lanque est sur trois lettres.</p>
					<p><form action="uc_propriete_texte_insert_update.php"  method="post" >
					<input type="hidden" name ="effectuer" value="form_insert"></input>
					<input type="hidden" name ="cleUC" value="'.$cle_uc.'"></input>
					<input type="submit" value="OK" /></form></p></body></html>')	;
			}
			else {

				$requete = "INSERT INTO tables_uc.propriete_texte  (fk_unite_connaissance, fk_type_propriete".
				$champs_texte.$champs_code_langue.$champs_descriptif.$champs_notes.")
							VALUES (".$cle_uc.', '.$form_typeProprieteTexte.
				$partie_texte.$partie_code_langue.$partie_descriptif.$partie_notes.")";
					
				//echo $requete;
					
				//ouvre la connection avec la fonction externe et récupère la variable
				$connexion = connexion();
					
				// effectuer la requête qui liste les types de cet objet
				$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());
					
				// Libérer le résultat
				pg_free_result($resultat);

				// cherche la clé du nouveau nom
				$requete = 'SELECT MAX(pk_propriete_texte) AS pk_propriete_texte
							FROM tables_uc.propriete_texte';
				$resultat = pg_query($requete) or die('Query failed: ' . pg_last_error());
				if (!$resultat) {
					echo "An error occured.\n";
					exit;
				}
				//initialise la variable
				$cle_propriete_texte = '';
				while ($row = pg_fetch_object($resultat)) {
					$cle_propriete_texte = $row->pk_propriete_texte;
				}
					
				// Libérer le résultat
				pg_free_result($resultat);
					
			}
		}
	}

	//ouvre la connection avec la fonction externe et récupère la variable
	$connexion = connexion();


	/* Type de propriété texte */

	// préparer la requête qui liste les paramètres du type de la propriété texte
	$requete = "SELECT t1.pk_parametre,
		    			t1.nom AS nom,
	       			CASE
	         			WHEN pk_propriete_texte IS NULL THEN NULL
    	     			ELSE 'selected'
       				END AS selected
						FROM tables_types.parametre t1 
						LEFT JOIN tables_uc.propriete_texte t2 ON t2.fk_type_propriete = t1.pk_parametre 
						AND pk_propriete_texte = ".$cle_propriete_texte.
						"WHERE t1.type_parametre = 'type_propriete_texte_uc'
						ORDER BY t1.nom;";



	// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

	//préparer le résultat pour l'utilisation dans le formulaire
	$liste_type_propriete_texte = array();
	while ($lignes = pg_fetch_object($resultat))
	{
		$liste_type_propriete_texte[] = '<option '.$lignes->selected.' value="'.$lignes->pk_parametre.'">'.$lignes->nom.'</option>';
	}

	// Libérer le résultat
	pg_free_result($resultat);






	/* Champs propres à la propriété texte */

	$requete = "SELECT t1.*, t2.nom AS type_propriete, t3.libelle_uc
				FROM tables_uc.propriete_texte t1
				JOIN tables_types.parametre t2 ON t2.pk_parametre = t1.fk_type_propriete
				JOIN tables_uc.v_libelle_uc t3 ON t3.pk_unite_connaissance = t1.fk_unite_connaissance
				WHERE pk_propriete_texte = ".$cle_propriete_texte;

	// effectuer la requête qui liste les types de cet objet
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

	// récupérer le résultat dans une variable
	if ($resultat) {
		$champs_pt = pg_fetch_assoc($resultat);
		$texte = $champs_pt['texte'];
		$code_langue = $champs_pt['code_langue'];
		$type_propriete = $champs_pt['type_propriete'];
		$descriptif = $champs_pt['descriptif'];
		$notes = $champs_pt['notes'];
		$libelle_uc =$champs_pt['libelle_uc'];
	}
	else {
		$liste_noms_standard = 'Erreur !';
	}



	// autres variables
	$titre_div_fomulaire = '<h2>UnCo'.$cle_uc.' – '.$libelle_uc.' (clé propriété texte : '.$cle_propriete_texte.')</h2>';
	$value_submit = 'Mettre à jour';
	$champs_obligatoire = '' ;
	$valeur_effectuer = 'update';

	// Libérer le résultat
	pg_free_result($resultat);

}


// Fermer la connexion
pg_close($connexion);

?>

<?php html_header ('Propriété', '../css/unite_connaissance.css'); ?>


<div><?php echo $titre_div_fomulaire; ?>

<form action="uc_propriete_texte_insert_update.php" method="post">
<p><?php if (!empty($cle_propriete_texte)) {echo 'Clé de la propriété texte : '.$cle_propriete_texte.' – ';}?>

<?php echo $echo_cle_uc.'<br/>';?></p>


<p>Type de propriété texte : <select name="typeProprieteTexte">
<?php foreach ($liste_type_propriete_texte as $valeur_type_propriete_texte) {
	echo $valeur_type_propriete_texte;
}?>
</select> Langue (<strong>Format ISO 639-2, 3 caractères</strong>) : <input
	type="text" size=2 " name="code_langue"
	value="<?php echo $code_langue; ?>" /></p>


<p>Texte :</p>
<textarea rows="5" cols="140" name="texte"><?php echo $texte; ?></textarea>


<!-- appelle la partie du formulaire concernant descriptif et notes -->
<?php html_descriptif_notes(3, $descriptif, $notes) ; ?> <input
	type="hidden" name="effectuer" value="<?php echo $valeur_effectuer; ?>" />
<input type="hidden" name="cleProprieteTexte"
	value="<?php echo $cle_propriete_texte; ?>" /> <input type="hidden"
	name="cleUC" value="<?php echo $cle_uc; ?>" />
<p><input type="submit" value="<?php echo $value_submit; ?>" /></p>
</form>

<form action="unite_connaissance_update.php" method="get"><input
	type="hidden" name="ongletActif" value="textes" /> <input type="hidden"
	name="cleUC" value="<?php echo $cle_uc; ?>" /> <input type="submit"
	value="Fermer" /></form>
</body>
</html>