--
-- PostgreSQL database dump
--

-- Dumped from database version 9.3.1
-- Dumped by pg_dump version 9.3.1
-- Started on 2014-10-03 11:52:03 CEST

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 8 (class 2615 OID 95830)
-- Name: objets; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA objets;


SET search_path = objets, pg_catalog;

--
-- TOC entry 201 (class 1255 OID 95831)
-- Name: update_created_column(); Type: FUNCTION; Schema: objets; Owner: -
--

CREATE FUNCTION update_created_column() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	   NEW.date_creation = now(); 
	   RETURN NEW;
	END;
$$;


--
-- TOC entry 202 (class 1255 OID 120308)
-- Name: update_updated_column(); Type: FUNCTION; Schema: objets; Owner: -
--

CREATE FUNCTION update_updated_column() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	   NEW.date_modification = now(); 
	   RETURN NEW;
	END;
$$;


SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 184 (class 1259 OID 112101)
-- Name: associer_objets; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE associer_objets (
    pk_associer_objets integer NOT NULL,
    fk_objet_source integer,
    fk_objet_cible integer,
    fk_type_association_objets integer,
    reference_precise text,
    url text,
    descriptif text,
    notes text,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone
);


--
-- TOC entry 183 (class 1259 OID 112099)
-- Name: associer_objets_pk_associer_objets_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE associer_objets_pk_associer_objets_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2271 (class 0 OID 0)
-- Dependencies: 183
-- Name: associer_objets_pk_associer_objets_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE associer_objets_pk_associer_objets_seq OWNED BY associer_objets.pk_associer_objets;


--
-- TOC entry 175 (class 1259 OID 95832)
-- Name: nom_objet; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE nom_objet (
    pk_nom_objet integer NOT NULL,
    nom text,
    langue character varying(255),
    notes text,
    fk_objet integer,
    est_standard boolean,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone,
    fk_type_nom integer,
    date_debut character varying(10),
    date_fin character varying(10)
);


--
-- TOC entry 176 (class 1259 OID 95838)
-- Name: nom_objet_cle_nom_objet_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE nom_objet_cle_nom_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2272 (class 0 OID 0)
-- Dependencies: 176
-- Name: nom_objet_cle_nom_objet_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE nom_objet_cle_nom_objet_seq OWNED BY nom_objet.pk_nom_objet;


--
-- TOC entry 177 (class 1259 OID 95840)
-- Name: objet; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE objet (
    pk_objet integer NOT NULL,
    definition text,
    notes text,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone,
    certitude_dd integer,
    certitude_df integer,
    cle_importation integer,
    cle_importation_txt text,
    longitude numeric,
    latitude numeric,
    date_debut character varying(10),
    date_fin character varying(10),
    texte_tei xml,
    fk_type_objet integer NOT NULL,
    sexe character(1)
);


--
-- TOC entry 178 (class 1259 OID 95846)
-- Name: objet_cle_objet_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE objet_cle_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2273 (class 0 OID 0)
-- Dependencies: 178
-- Name: objet_cle_objet_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE objet_cle_objet_seq OWNED BY objet.pk_objet;


--
-- TOC entry 2134 (class 2604 OID 112104)
-- Name: pk_associer_objets; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY associer_objets ALTER COLUMN pk_associer_objets SET DEFAULT nextval('associer_objets_pk_associer_objets_seq'::regclass);


--
-- TOC entry 2132 (class 2604 OID 95853)
-- Name: pk_nom_objet; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY nom_objet ALTER COLUMN pk_nom_objet SET DEFAULT nextval('nom_objet_cle_nom_objet_seq'::regclass);


--
-- TOC entry 2133 (class 2604 OID 95854)
-- Name: pk_objet; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY objet ALTER COLUMN pk_objet SET DEFAULT nextval('objet_cle_objet_seq'::regclass);


--
-- TOC entry 2266 (class 0 OID 112101)
-- Dependencies: 184
-- Data for Name: associer_objets; Type: TABLE DATA; Schema: objets; Owner: -
--

INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (1, 5, 17, 8, NULL, NULL, NULL, NULL, '2014-10-01 17:24:28.332882+02', '2014-10-01 17:31:30.126504+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (2, 6, 17, 8, NULL, NULL, NULL, NULL, '2014-10-01 17:34:45.975283+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (6, 13, 17, 8, NULL, NULL, NULL, NULL, '2014-10-01 18:45:00.132484+02', '2014-10-01 18:45:06.246479+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (5, 18, 9, 14, NULL, 'http://www.larousse.fr/encyclopedie/litterature/Peiresc/175946', NULL, NULL, '2014-10-01 18:41:42.716243+02', '2014-10-01 22:44:18.786132+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (7, 19, 18, 15, NULL, 'http://www.larousse.fr/encyclopedie', NULL, NULL, '2014-10-01 22:29:27.83624+02', '2014-10-01 22:53:52.85526+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (9, 26, 9, 14, NULL, NULL, NULL, NULL, '2014-10-03 00:38:09.937103+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (10, 24, 6, 14, NULL, NULL, NULL, NULL, '2014-10-03 00:38:59.368386+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (11, 28, 6, 14, NULL, NULL, NULL, NULL, '2014-10-03 09:12:45.180796+02', '2014-10-03 09:16:09.891234+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (12, 30, 8, 14, NULL, NULL, 'Ouvrage fondamental que je dois lire pour mon mémoire de master', NULL, '2014-10-03 09:31:41.936464+02', '2014-10-03 09:33:20.672138+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (13, 31, 8, 14, NULL, NULL, NULL, NULL, '2014-10-03 10:27:23.44267+02', '2014-10-03 10:27:26.947125+02');


--
-- TOC entry 2274 (class 0 OID 0)
-- Dependencies: 183
-- Name: associer_objets_pk_associer_objets_seq; Type: SEQUENCE SET; Schema: objets; Owner: -
--

SELECT pg_catalog.setval('associer_objets_pk_associer_objets_seq', 13, true);


--
-- TOC entry 2261 (class 0 OID 95832)
-- Dependencies: 175
-- Data for Name: nom_objet; Type: TABLE DATA; Schema: objets; Owner: -
--

INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (10, 'Merisi, Michelangelo, da Caravaggio', 'italien', NULL, 2, true, '2014-09-19 22:26:23.932658+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (8, 'Barberini, Maffeo', 'italien', NULL, 1, false, '2014-09-19 22:15:55.046286+02', NULL, 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (13, 'Mathématiques', NULL, NULL, 3, true, '2014-09-22 10:55:42.046401+02', NULL, 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (14, 'Galilei, Galileo', NULL, NULL, 5, true, '2014-09-30 07:22:43.025217+02', NULL, 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (11, 'Inquisition romaine', NULL, NULL, 4, true, '2014-09-22 10:54:57.463491+02', NULL, 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (12, 'Saint-Office', NULL, NULL, 4, false, '2014-09-22 10:55:15.342779+02', NULL, 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (16, 'Maestlin, Michael', NULL, NULL, 7, true, '2014-10-01 01:11:51.526866+02', NULL, 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (18, 'Fabri de Peiresc, Nicolas Claude', NULL, NULL, 9, true, '2014-10-01 09:32:02.393621+02', NULL, 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (19, 'Rodolphe II', 'français', NULL, 10, true, '2014-10-01 10:10:07.338795+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (20, 'Copernic, NIcolas', NULL, NULL, 11, true, '2014-10-01 10:13:39.735352+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (21, 'Charles Quint', 'français', NULL, 12, true, '2014-10-01 10:28:53.007398+02', NULL, 5, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (9, 'Urbain VIII', 'français', NULL, 1, true, '2014-09-19 22:16:24.269177+02', NULL, 5, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (15, 'Kepler, Johannes', 'allemand', NULL, 6, true, '2014-10-01 01:08:35.83893+02', NULL, 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (23, 'Population de savants', NULL, NULL, 17, true, '2014-10-01 17:22:58.918112+02', '2014-10-01 17:23:44.079059+02', 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (25, 'Site web', NULL, NULL, 19, true, '2014-10-01 17:45:30.78415+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (24, 'Encyclopédie Larousse', NULL, NULL, 18, true, '2014-10-01 17:44:52.371504+02', '2014-10-01 18:39:32.737874+02', 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (22, 'Brahe, Tycho', 'danois', NULL, 13, true, '2014-10-01 10:41:34.158809+02', '2014-10-01 23:47:25.925818+02', 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (26, 'Astronomie', NULL, NULL, 20, true, '2014-10-02 19:13:12.170589+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (27, 'Astronomie', NULL, NULL, 21, true, '2014-10-02 19:15:55.313405+02', '2014-10-02 19:17:02.962245+02', 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (28, 'Weil der Stadt', NULL, NULL, 22, true, '2014-10-02 19:22:44.190267+02', NULL, 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (29, 'Regensburg', 'allemand', NULL, 23, true, '2014-10-02 19:42:15.988656+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (30, 'Ratisbonne', 'français', NULL, 23, false, '2014-10-02 19:43:16.066025+02', '2014-10-02 19:46:27.458259+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (31, 'Johannes Kepler – notice Larousse', NULL, NULL, 24, true, '2014-10-02 20:20:39.403336+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (32, 'Newton, Isaac', 'anglais', NULL, 25, true, '2014-10-02 22:48:13.618384+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (34, 'Aristote', NULL, NULL, 27, true, '2014-10-03 00:21:17.569237+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (33, 'Peiresc – notice Larousse', NULL, NULL, 26, true, '2014-10-03 00:16:13.989861+02', '2014-10-03 08:42:33.980493+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (35, 'Depondt, Philippe / Véricourt, Guillemette de, Kepler. L’orbe tourmenté d’un astronome. Biographie (Rodez, Editions du Rouergue, 2005) ', NULL, NULL, 28, true, '2014-10-03 09:06:16.294152+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (36, 'Simon, Gérard, Kepler: astronome, astrologue (Paris, Gallimard, 1979)', NULL, NULL, 29, true, '2014-10-03 09:25:23.468639+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (17, 'Gassend, Pierre', 'français', NULL, 8, true, '2014-10-01 07:20:07.82895+02', '2014-10-03 09:30:57.976154+02', 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (38, 'Gassendi', 'français', NULL, 8, false, '2014-10-03 09:30:55.528311+02', '2014-10-03 09:31:00.752651+02', 13, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (39, 'Gassendi – Notice Larousse', NULL, NULL, 31, true, '2014-10-03 10:23:58.005062+02', '2014-10-03 10:27:09.638341+02', 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (37, 'Gassendi et l''Europe (1592-1792) : actes du colloque international de Paris "Gassendi et sa postérité (1592-1792)", ed. Murr, Sylvia (Paris , J. Vrin, 1997) ', 'français', NULL, 30, true, '2014-10-03 09:29:52.508511+02', '2014-10-03 10:30:02.039306+02', NULL, NULL, NULL);


--
-- TOC entry 2275 (class 0 OID 0)
-- Dependencies: 176
-- Name: nom_objet_cle_nom_objet_seq; Type: SEQUENCE SET; Schema: objets; Owner: -
--

SELECT pg_catalog.setval('nom_objet_cle_nom_objet_seq', 39, true);


--
-- TOC entry 2263 (class 0 OID 95840)
-- Dependencies: 177
-- Data for Name: objet; Type: TABLE DATA; Schema: objets; Owner: -
--

INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (1, 'Le pape ayant condamné Galilée', NULL, '2014-09-19 22:12:04.353976+02', '2014-10-03 08:40:12.638584+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '0');
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (26, 'Transcription TEI de la notice tirée du Larousse en ligne', NULL, '2014-10-03 00:16:08.11204+02', '2014-10-03 10:48:52.586601+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<TEI xmlns="http://www.tei-c.org/ns/1.0">
	<teiHeader>
		<fileDesc>
			<titleStmt>
				<title>Nicolas Claude Fabri de Peiresc</title>
				<author/>
			</titleStmt>
			<editionStmt>
				<edition>
					<date>2014-10-03</date>
				</edition>
			</editionStmt>
			<publicationStmt>
				<authority/>
			</publicationStmt>
			<sourceDesc>
				<p>Cet article est extrait de l''ouvrage Larousse « Dictionnaire mondial des littératures »<ptr target="http://www.larousse.fr/encyclopedie/litterature/Peiresc/175946"/>
				</p>
			</sourceDesc>
		</fileDesc>
		<revisionDesc>
			<change type="texte">
				<name/>
				<date>2014-10-03</date>
			</change>
		</revisionDesc>
	</teiHeader>
	<text>
		<body>
			<div>
				<p>Érudit et collectionneur français (Belgentier, Provence, 1580 – Aix-en-Provence 1637). 
Ce conseiller au parlement d''Aix voyagea à travers l''Europe et se lia avec les grands collectionneurs et bibliothécaires de son temps. Secrétaire du garde des sceaux Guillaume du Vair en 1616, il devient un membre assidu de l''Académie des frères Dupuy (où il rencontre <name key="ObPe8">Gassendi</name>, Guez de Balzac, Ducange). Témoin typique de la curiosité du xviie siècle, il réunit et observe les choses et les faits curieux dont on peut mesurer l''ampleur dans la correspondance qu''il a laissée. </p>
			</div>
		</body>
	</text>
</TEI>', 12, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (24, 'Transcription TEI de la notice', NULL, '2014-10-02 20:20:32.660926+02', '2014-10-03 08:43:02.979594+02', NULL, NULL, NULL, NULL, NULL, NULL, '2014-10-02', NULL, '<TEI xmlns="http://www.tei-c.org/ns/1.0">
	<teiHeader>
		<fileDesc>
			<titleStmt>
				<title>Johannes Kepler</title>
				<author/>
			</titleStmt>
			<editionStmt>
				<edition>
					<date>2014-10-02T20:59:39.494702000</date>
				</edition>
			</editionStmt>
			<publicationStmt>
				<authority/>
			</publicationStmt>
			<sourceDesc>
				<p>Source : <ptr target="http://www.larousse.fr/encyclopedie/personnage/Johannes_Kepler/127297"/>
				</p>
			</sourceDesc>
		</fileDesc>
		<revisionDesc>
			<change type="production">
				<name/>
				<date>2014-10-02T21:00:14.346914000</date>
			</change>
		</revisionDesc>
	</teiHeader>
	<text>
		<body>
			<div>
				<p> Astronome allemand (Weil, aujourd''hui Weil der Stadt, Wurtemberg, 1571-Ratisbonne 1630). </p>
			</div>
			<div>
				<head>Lois de Kepler</head>
				<p>
Savant génial et obstiné, il est l''un des fondateurs de l''astronomie moderne. 
Sa découverte, purement empirique, des lois du mouvement des planètes a bouleversé la pensée de son époque et ouvert la voie à <name key="ObPe25">Newton</name>. 
Une enfance dure, mais une intelligence précoce. Johannes Kepler connaît une enfance assez dure, dans une ambiance familiale peu propice à l''éveil d''une vocation scientifique. Son père, mercenaire dans l''armée du duc de Wurtenberg, est un « soldat brutal, querelleur et immoral » souvent en campagne et qui finira par abandonner sa famille ; sa mère fera l''objet d''un procès en sorcellerie. Atteint de la variole à 3 ans, l''enfant en conservera toute sa vie des séquelles et une santé précaire. De 1574 à 1576, il vit chez ses grands-parents. Il accompagne ensuite ses parents à Leonberg, où il fréquente l''école latine. En 1584, il est admis au séminaire protestant d''Adelberg. Le duc de Wurtenberg le repère et décide de le prendre sous sa tutelle : en 1589, il rejoint l''université de Tübingen, où il reçoit une formation très complète. Son professeur d''astronomie, <name key="ObPe7">Michael Mästlin</name>, lui enseigne le système de <name key="ObPe11">Copernic</name>, dont il est un prudent défenseur. Diplômé de l''université en 1591, Kepler poursuit des études de théologie, avec le projet de devenir pasteur. Mais c''est finalement vers la science qu''il va se tourner, car il est nommé, en 1594, professeur de mathématiques à Graz. Lorsque, vers 1600, les persécutions religieuses contre les protestants l''obligent à quitter cette ville, il se réfugie à Prague, où il devient le disciple et l''assistant de l''astronome danois Tycho Brahe, auquel il succède, en 1601, comme astronome de l''empereur Rodolphe II. 
				</p>
			
			</div>
			<div>
				<head>Le découvreur des lois du mouvement des planètes</head>
				<p>Devenu grâce à Mästlin un partisan convaincu de l''héliocentrisme, Kepler explique dans un premier ouvrage, le Prodomus… mysterium cosmographicum, publié en 1596, pourquoi le système de Ptolémée doit, selon lui, céder la place à la représentation copernicienne du monde. Mais, hanté par les idées pythagoriciennes, il croit l''Univers construit selon une architecture géométrique. Aussi élabore-t-il un ingénieux modèle géométrique du système de Copernic, dans lequel l''orbe de chaque planète occupe une sphère circonscrite à un polyèdre régulier et inscrite dans un autre. En fait, il a la conviction que le nombre de planètes, leurs distances au Soleil et leurs vitesses de révolution ne sont pas le fruit du hasard. Une étude systématique du mouvement de la planète Mars (dont la trajectoire reste mal interprétée par Ptolémée et par Copernic), après de laborieux calculs qu''il contrôle grâce aux observations précises de Tycho Brahe, le conduit à renoncer à l''hypothèse d''un mouvement circulaire – admise depuis Aristote – au profit d''une orbite elliptique. Ce travail amène Kepler à la découverte des deux premières lois qui vont immortaliser son nom. Il les publie en 1609 dans son Astronomia nova. La première énonce que chaque planète décrit dans le sens direct une ellipse dont le Soleil occupe un des foyers ; la seconde, que les aires décrites par le rayon vecteur allant du centre de la planète au centre du Soleil sont proportionnelles aux temps employés à les décrire. Kepler s''efforce ensuite de démontrer l''existence d''un rapport harmonique (au sens musical du terme) entre la plus grande et la plus petite vitesse des planètes. Il découvre ainsi la troisième loi fondamentale du mouvement des planètes, qu''il publie en 1619 dans son Harmonices mundi : les carrés des périodes de révolution des planètes sont proportionnels aux cubes des grands axes de leurs orbites. 
				Lors de leur publication, les lois de Kepler reçoivent un accueil mitigé : Galilée, par exemple, ne se ralliera jamais à l''idée du mouvement elliptique. Dans un premier temps, elles ne connaissent qu''un succès indirect : elles permettent de calculer des tables et des éphémérides astronomiques en excellent accord avec les observations. C''est Newton qui leur donnera une portée très générale, en montrant qu''elles découlent de la loi de l''attraction universelle et qu''elles s''appliquent à tout corps en mouvement orbital autour d''un autre, notamment aux satellites des planètes. 
Dans les dernières années de sa vie, Kepler s''attache à établir des tables des positions des planètes, fondées sur les lois qu''il a mises en évidence. Cette tâche requiert de longs calculs, heureusement abrégés par l''invention récente des logarithmes. Elle aboutit à la publication, en 1627, des Tabulae rudolphinae (Tables rudolphines, ainsi nommées en hommage à l''empereur Rodolphe II), qui surpassent largement en précision toutes celles publiées auparavant. 
Kepler meurt en 1630, dans un grand dénuement, mais livre encore, grâce à son gendre Jacob Bartsch (1600-1633), une œuvre posthume, Somnium seu astronomia lunari, véritable roman de science-fiction sur le thème du voyage vers la Lune. </p>
			
			</div>
		
	</body>
</text>
</TEI>', 12, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (3, 'Matière enseignée', NULL, '2014-09-22 00:15:05.135554+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (4, 'Institution créée par la papauté et vouée à la répression de l''hérésie', NULL, '2014-09-22 00:15:23.119833+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (5, 'Mathématicien et astronome italien', NULL, '2014-09-30 07:22:33.865782+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1564', NULL, NULL, 1, '0');
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (2, 'Peintre italien', 'Divers', '2014-09-19 22:24:22.597943+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '0');
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (6, 'Astronome allemand', NULL, '2014-10-01 01:08:08.332719+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1571', '1630', NULL, 1, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (7, 'Astronome allemand', NULL, '2014-10-01 01:11:01.547802+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '0');
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (8, 'Philosophe et savant français', NULL, '2014-10-01 07:19:33.761028+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1592', '1655', NULL, 1, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (9, 'Savant français', NULL, '2014-10-01 09:31:11.028347+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1580', '1637', NULL, 1, '0');
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (12, 'Empereur du Saint-Empire', NULL, '2014-10-01 10:28:46.387364+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (11, 'Astronome polonais', NULL, '2014-10-01 10:13:27.463726+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (10, 'Empereur du Saint-Empire', NULL, '2014-10-01 10:09:35.746291+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (17, 'Les objets appartenant à la population que je vais étudier', NULL, '2014-10-01 17:22:25.877375+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (18, 'Encyclopédie en ligne', NULL, '2014-10-01 17:44:45.12619+02', '2014-10-01 17:45:03.647227+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 12, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (13, 'Astronome danois', NULL, '2014-10-01 10:34:39.344328+02', '2014-10-01 18:44:43.24104+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '0');
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (20, 'Discipline dédiée à l''étude des astres et de leurs mouvements', NULL, '2014-10-02 19:13:07.27137+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (19, 'Tout site web. Objet utilisé pour classer les sites web', NULL, '2014-10-01 17:45:17.760892+02', '2014-10-02 19:15:03.104765+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (21, 'Discipline consacrée à l''étude des astres et de leurs mouvements', NULL, '2014-10-02 19:15:49.887956+02', '2014-10-02 19:16:05.528434+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (22, 'Ville située dans le Würtenberg', NULL, '2014-10-02 19:22:35.226786+02', '2014-10-02 19:37:57.364014+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 19, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (23, 'Ville allemande', NULL, '2014-10-02 19:41:58.566116+02', '2014-10-02 19:42:28.041945+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 19, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (25, 'Savant anglais, inventeur du concept de la gravitation universelle', NULL, '2014-10-02 22:48:00.923917+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (27, 'Philosophe grec', NULL, '2014-10-03 00:21:13.711991+02', '2014-10-03 08:41:45.278712+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (28, 'Biographie', NULL, '2014-10-03 09:06:07.924216+02', '2014-10-03 09:06:35.593472+02', NULL, NULL, NULL, NULL, NULL, NULL, '2005', NULL, NULL, 11, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (29, NULL, NULL, '2014-10-03 09:25:16.532517+02', '2014-10-03 09:25:32.773946+02', NULL, NULL, NULL, NULL, NULL, NULL, '1979', NULL, NULL, 11, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (30, 'Ouvrage fondamental que je dois lire pour mon mémoire de master', NULL, '2014-10-03 09:29:48.92256+02', '2014-10-03 09:33:11.404481+02', NULL, NULL, NULL, NULL, NULL, NULL, '1997', NULL, NULL, 11, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (31, 'Notice Larousse littératures, transcription TEI', NULL, '2014-10-03 10:23:43.833513+02', '2014-10-03 10:46:02.466239+02', NULL, NULL, NULL, NULL, NULL, NULL, '2014-10-03', NULL, '<?xml-stylesheet href="schemas/afficher_document_html_avec_contenus.xsl" type="text/xsl"?>
<TEI xmlns="http://www.tei-c.org/ns/1.0">
	<teiHeader>
		<fileDesc>
			<titleStmt>
				<title>Pierre Gassend, dit Gassendi</title>
				<author/>
			</titleStmt>
			<editionStmt>
				<edition>
					<date>2014-10-02T20:59:39.494702000</date>
				</edition>
			</editionStmt>
			<publicationStmt>
				<authority/>
			</publicationStmt>
			<sourceDesc>
				<p>Source : <ptr target="http://www.larousse.fr/encyclopedie/personnage/Pierre_Gassend_dit_Gassendi/120894"/>
				</p>
			</sourceDesc>
		</fileDesc>
		<revisionDesc>
			<change type="texte">
				<name/>
				<date>2014-10-03</date>
			</change>
		</revisionDesc>
	</teiHeader>
	<text>
		<body>
			<div>
				<p>Philosophe et savant français (Champtercier, près de Digne-les-Bains, 1592-Paris 1655). 
Docteur en théologie à Avignon en 1614, il entra dans les ordres en 1615. Résidant le plus souvent à Paris, il enseigna les mathématiques au Collège royal de 1645 à 1648. Il critiqua <name key="ObPe27">Aristote</name>, sans oser publier tous les livres où il faisait part de ses remarques, répondit à Descartes (Objections aux Méditations, 1644), développa une théorie atomiste à la manière de Démocrite, à laquelle il superposa une perspective harmoniste des éléments qui composent le monde. En astronomie, il fut un pionnier de l''observation des planètes à la lunette et fit la première description scientifique d''une aurore boréale (1621). En physique, il a étudié la chute des corps et les lois du choc, expliqué la hauteur des sons et mesuré leur vitesse de propagation. 
</p>			
			</div>
		</body>
	</text>
</TEI>', 12, NULL);


--
-- TOC entry 2276 (class 0 OID 0)
-- Dependencies: 178
-- Name: objet_cle_objet_seq; Type: SEQUENCE SET; Schema: objets; Owner: -
--

SELECT pg_catalog.setval('objet_cle_objet_seq', 31, true);


--
-- TOC entry 2143 (class 2606 OID 112109)
-- Name: associer_objets_pkey; Type: CONSTRAINT; Schema: objets; Owner: -; Tablespace: 
--

ALTER TABLE ONLY associer_objets
    ADD CONSTRAINT associer_objets_pkey PRIMARY KEY (pk_associer_objets);


--
-- TOC entry 2139 (class 2606 OID 95856)
-- Name: nom_objet_pkey; Type: CONSTRAINT; Schema: objets; Owner: -; Tablespace: 
--

ALTER TABLE ONLY nom_objet
    ADD CONSTRAINT nom_objet_pkey PRIMARY KEY (pk_nom_objet);


--
-- TOC entry 2141 (class 2606 OID 95858)
-- Name: objet_pkey; Type: CONSTRAINT; Schema: objets; Owner: -; Tablespace: 
--

ALTER TABLE ONLY objet
    ADD CONSTRAINT objet_pkey PRIMARY KEY (pk_objet);


--
-- TOC entry 2135 (class 1259 OID 95859)
-- Name: idx_fk_objet; Type: INDEX; Schema: objets; Owner: -; Tablespace: 
--

CREATE INDEX idx_fk_objet ON nom_objet USING btree (fk_objet);


--
-- TOC entry 2136 (class 1259 OID 120307)
-- Name: nom_objet_langue_idx; Type: INDEX; Schema: objets; Owner: -; Tablespace: 
--

CREATE INDEX nom_objet_langue_idx ON nom_objet USING btree (langue);


--
-- TOC entry 2137 (class 1259 OID 120313)
-- Name: nom_objet_nom_idx; Type: INDEX; Schema: objets; Owner: -; Tablespace: 
--

CREATE INDEX nom_objet_nom_idx ON nom_objet USING btree (nom);


--
-- TOC entry 2150 (class 2620 OID 120317)
-- Name: update_associer_objets_creatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_associer_objets_creatime BEFORE INSERT ON associer_objets FOR EACH ROW EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 2149 (class 2620 OID 120316)
-- Name: update_associer_objets_updatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_associer_objets_updatime BEFORE UPDATE ON associer_objets FOR EACH ROW EXECUTE PROCEDURE update_updated_column();


--
-- TOC entry 2145 (class 2620 OID 95860)
-- Name: update_nom_objet_creatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_nom_objet_creatime BEFORE INSERT ON nom_objet FOR EACH ROW EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 2146 (class 2620 OID 120314)
-- Name: update_nom_objet_updatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_nom_objet_updatime BEFORE UPDATE ON nom_objet FOR EACH ROW EXECUTE PROCEDURE update_updated_column();


--
-- TOC entry 2147 (class 2620 OID 95861)
-- Name: update_objet_creatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_objet_creatime BEFORE INSERT ON objet FOR EACH ROW EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 2148 (class 2620 OID 120309)
-- Name: update_objet_updatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_objet_updatime BEFORE UPDATE ON objet FOR EACH ROW EXECUTE PROCEDURE update_updated_column();


--
-- TOC entry 2144 (class 2606 OID 95862)
-- Name: nom_objet_fk_objet_fkey; Type: FK CONSTRAINT; Schema: objets; Owner: -
--

ALTER TABLE ONLY nom_objet
    ADD CONSTRAINT nom_objet_fk_objet_fkey FOREIGN KEY (fk_objet) REFERENCES objet(pk_objet) ON UPDATE CASCADE ON DELETE CASCADE;


-- Completed on 2014-10-03 11:52:03 CEST

--
-- PostgreSQL database dump complete
--

