--
-- PostgreSQL database dump
--

-- Dumped from database version 9.3.1
-- Dumped by pg_dump version 9.3.1
-- Started on 2014-10-03 11:54:21 CEST

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 8 (class 2615 OID 95830)
-- Name: objets; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA objets;


SET search_path = objets, pg_catalog;

--
-- TOC entry 201 (class 1255 OID 95831)
-- Name: update_created_column(); Type: FUNCTION; Schema: objets; Owner: -
--

CREATE FUNCTION update_created_column() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	   NEW.date_creation = now(); 
	   RETURN NEW;
	END;
$$;


--
-- TOC entry 202 (class 1255 OID 120308)
-- Name: update_updated_column(); Type: FUNCTION; Schema: objets; Owner: -
--

CREATE FUNCTION update_updated_column() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	   NEW.date_modification = now(); 
	   RETURN NEW;
	END;
$$;


SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 184 (class 1259 OID 112101)
-- Name: associer_objets; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE associer_objets (
    pk_associer_objets integer NOT NULL,
    fk_objet_source integer,
    fk_objet_cible integer,
    fk_type_association_objets integer,
    reference_precise text,
    url text,
    descriptif text,
    notes text,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone
);


--
-- TOC entry 183 (class 1259 OID 112099)
-- Name: associer_objets_pk_associer_objets_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE associer_objets_pk_associer_objets_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2265 (class 0 OID 0)
-- Dependencies: 183
-- Name: associer_objets_pk_associer_objets_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE associer_objets_pk_associer_objets_seq OWNED BY associer_objets.pk_associer_objets;


--
-- TOC entry 175 (class 1259 OID 95832)
-- Name: nom_objet; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE nom_objet (
    pk_nom_objet integer NOT NULL,
    nom text,
    langue character varying(255),
    notes text,
    fk_objet integer,
    est_standard boolean,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone,
    fk_type_nom integer,
    date_debut character varying(10),
    date_fin character varying(10)
);


--
-- TOC entry 176 (class 1259 OID 95838)
-- Name: nom_objet_cle_nom_objet_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE nom_objet_cle_nom_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2266 (class 0 OID 0)
-- Dependencies: 176
-- Name: nom_objet_cle_nom_objet_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE nom_objet_cle_nom_objet_seq OWNED BY nom_objet.pk_nom_objet;


--
-- TOC entry 177 (class 1259 OID 95840)
-- Name: objet; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE objet (
    pk_objet integer NOT NULL,
    definition text,
    notes text,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone,
    certitude_dd integer,
    certitude_df integer,
    cle_importation integer,
    cle_importation_txt text,
    longitude numeric,
    latitude numeric,
    date_debut character varying(10),
    date_fin character varying(10),
    texte_tei xml,
    fk_type_objet integer NOT NULL,
    sexe character(1)
);


--
-- TOC entry 178 (class 1259 OID 95846)
-- Name: objet_cle_objet_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE objet_cle_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2267 (class 0 OID 0)
-- Dependencies: 178
-- Name: objet_cle_objet_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE objet_cle_objet_seq OWNED BY objet.pk_objet;


--
-- TOC entry 2134 (class 2604 OID 112104)
-- Name: pk_associer_objets; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY associer_objets ALTER COLUMN pk_associer_objets SET DEFAULT nextval('associer_objets_pk_associer_objets_seq'::regclass);


--
-- TOC entry 2132 (class 2604 OID 95853)
-- Name: pk_nom_objet; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY nom_objet ALTER COLUMN pk_nom_objet SET DEFAULT nextval('nom_objet_cle_nom_objet_seq'::regclass);


--
-- TOC entry 2133 (class 2604 OID 95854)
-- Name: pk_objet; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY objet ALTER COLUMN pk_objet SET DEFAULT nextval('objet_cle_objet_seq'::regclass);


--
-- TOC entry 2143 (class 2606 OID 112109)
-- Name: associer_objets_pkey; Type: CONSTRAINT; Schema: objets; Owner: -; Tablespace: 
--

ALTER TABLE ONLY associer_objets
    ADD CONSTRAINT associer_objets_pkey PRIMARY KEY (pk_associer_objets);


--
-- TOC entry 2139 (class 2606 OID 95856)
-- Name: nom_objet_pkey; Type: CONSTRAINT; Schema: objets; Owner: -; Tablespace: 
--

ALTER TABLE ONLY nom_objet
    ADD CONSTRAINT nom_objet_pkey PRIMARY KEY (pk_nom_objet);


--
-- TOC entry 2141 (class 2606 OID 95858)
-- Name: objet_pkey; Type: CONSTRAINT; Schema: objets; Owner: -; Tablespace: 
--

ALTER TABLE ONLY objet
    ADD CONSTRAINT objet_pkey PRIMARY KEY (pk_objet);


--
-- TOC entry 2135 (class 1259 OID 95859)
-- Name: idx_fk_objet; Type: INDEX; Schema: objets; Owner: -; Tablespace: 
--

CREATE INDEX idx_fk_objet ON nom_objet USING btree (fk_objet);


--
-- TOC entry 2136 (class 1259 OID 120307)
-- Name: nom_objet_langue_idx; Type: INDEX; Schema: objets; Owner: -; Tablespace: 
--

CREATE INDEX nom_objet_langue_idx ON nom_objet USING btree (langue);


--
-- TOC entry 2137 (class 1259 OID 120313)
-- Name: nom_objet_nom_idx; Type: INDEX; Schema: objets; Owner: -; Tablespace: 
--

CREATE INDEX nom_objet_nom_idx ON nom_objet USING btree (nom);


--
-- TOC entry 2150 (class 2620 OID 120317)
-- Name: update_associer_objets_creatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_associer_objets_creatime BEFORE INSERT ON associer_objets FOR EACH ROW EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 2149 (class 2620 OID 120316)
-- Name: update_associer_objets_updatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_associer_objets_updatime BEFORE UPDATE ON associer_objets FOR EACH ROW EXECUTE PROCEDURE update_updated_column();


--
-- TOC entry 2145 (class 2620 OID 95860)
-- Name: update_nom_objet_creatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_nom_objet_creatime BEFORE INSERT ON nom_objet FOR EACH ROW EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 2146 (class 2620 OID 120314)
-- Name: update_nom_objet_updatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_nom_objet_updatime BEFORE UPDATE ON nom_objet FOR EACH ROW EXECUTE PROCEDURE update_updated_column();


--
-- TOC entry 2147 (class 2620 OID 95861)
-- Name: update_objet_creatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_objet_creatime BEFORE INSERT ON objet FOR EACH ROW EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 2148 (class 2620 OID 120309)
-- Name: update_objet_updatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_objet_updatime BEFORE UPDATE ON objet FOR EACH ROW EXECUTE PROCEDURE update_updated_column();


--
-- TOC entry 2144 (class 2606 OID 95862)
-- Name: nom_objet_fk_objet_fkey; Type: FK CONSTRAINT; Schema: objets; Owner: -
--

ALTER TABLE ONLY nom_objet
    ADD CONSTRAINT nom_objet_fk_objet_fkey FOREIGN KEY (fk_objet) REFERENCES objet(pk_objet) ON UPDATE CASCADE ON DELETE CASCADE;


-- Completed on 2014-10-03 11:54:21 CEST

--
-- PostgreSQL database dump complete
--

