--
-- PostgreSQL database dump
--

-- Dumped from database version 9.4.4
-- Dumped by pg_dump version 9.4.4
-- Started on 2015-10-05 13:56:52 CEST

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 6 (class 2615 OID 22723)
-- Name: objets; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA objets;


SET search_path = objets, pg_catalog;

--
-- TOC entry 201 (class 1255 OID 22726)
-- Name: update_created_column(); Type: FUNCTION; Schema: objets; Owner: -
--

CREATE FUNCTION update_created_column() RETURNS trigger
    LANGUAGE plpgsql
    AS $$

BEGIN

	   NEW.date_creation = now(); 

	   RETURN NEW;

	END;

$$;


--
-- TOC entry 214 (class 1255 OID 22727)
-- Name: update_updated_column(); Type: FUNCTION; Schema: objets; Owner: -
--

CREATE FUNCTION update_updated_column() RETURNS trigger
    LANGUAGE plpgsql
    AS $$

BEGIN

	   NEW.date_modification = now(); 

	   RETURN NEW;

	END;

$$;


SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 175 (class 1259 OID 22729)
-- Name: association_objets; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE association_objets (
    pk_association_objets integer NOT NULL,
    fk_objet_source integer,
    fk_objet_cible integer,
    fk_type_association_param integer,
    reference_precise_objet_source text,
    url_objet_source text,
    descriptif text,
    notes text,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone,
    fk_qualificatif_objet_source integer,
    fk_role_objet_source integer,
    libelle_original_objet_source text,
    valeur_objet_source double precision,
    fk_unite_de_mesure integer
);


--
-- TOC entry 176 (class 1259 OID 22735)
-- Name: associer_objets_pk_associer_objets_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE associer_objets_pk_associer_objets_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2392 (class 0 OID 0)
-- Dependencies: 176
-- Name: associer_objets_pk_associer_objets_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE associer_objets_pk_associer_objets_seq OWNED BY association_objets.pk_association_objets;


--
-- TOC entry 186 (class 1259 OID 22815)
-- Name: date_objet; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE date_objet (
    pk_date_objet integer NOT NULL,
    date_iso character varying(59),
    fk_type_date_param integer,
    libelle_original_date text,
    notes text,
    descriptif text,
    fk_objet integer,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone,
    certitude character(1)
);


--
-- TOC entry 185 (class 1259 OID 22813)
-- Name: date_objet_pk_date_objet_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE date_objet_pk_date_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2393 (class 0 OID 0)
-- Dependencies: 185
-- Name: date_objet_pk_date_objet_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE date_objet_pk_date_objet_seq OWNED BY date_objet.pk_date_objet;


--
-- TOC entry 177 (class 1259 OID 22737)
-- Name: nom_objet; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE nom_objet (
    pk_nom_objet integer NOT NULL,
    nom text DEFAULT 'Nom'::text,
    langue character varying(255),
    notes text,
    fk_objet integer,
    est_standard boolean DEFAULT true,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone,
    fk_type_nom_param integer,
    date_debut character varying(10),
    date_fin character varying(10)
);


--
-- TOC entry 178 (class 1259 OID 22744)
-- Name: nom_objet_cle_nom_objet_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE nom_objet_cle_nom_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2394 (class 0 OID 0)
-- Dependencies: 178
-- Name: nom_objet_cle_nom_objet_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE nom_objet_cle_nom_objet_seq OWNED BY nom_objet.pk_nom_objet;


--
-- TOC entry 179 (class 1259 OID 22746)
-- Name: objet; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE objet (
    pk_objet integer NOT NULL,
    definition text,
    notes text,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone,
    cle_importation integer,
    cle_importation_txt text,
    longitude double precision,
    latitude double precision,
    texte_xml xml,
    fk_type_objet_param integer NOT NULL,
    genre character(1),
    texte text,
    langue_texte character varying(255)
);


--
-- TOC entry 2395 (class 0 OID 0)
-- Dependencies: 179
-- Name: COLUMN objet.longitude; Type: COMMENT; Schema: objets; Owner: -
--

COMMENT ON COLUMN objet.longitude IS 'ALTER TABLE objets.objet

   ALTER COLUMN longitude TYPE double precision;

';


--
-- TOC entry 2396 (class 0 OID 0)
-- Dependencies: 179
-- Name: COLUMN objet.latitude; Type: COMMENT; Schema: objets; Owner: -
--

COMMENT ON COLUMN objet.latitude IS 'ALTER TABLE objets.objet

   ALTER COLUMN latitude TYPE double precision;

';


--
-- TOC entry 180 (class 1259 OID 22752)
-- Name: objet_cle_objet_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE objet_cle_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2397 (class 0 OID 0)
-- Dependencies: 180
-- Name: objet_cle_objet_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE objet_cle_objet_seq OWNED BY objet.pk_objet;


--
-- TOC entry 2231 (class 2604 OID 22778)
-- Name: pk_association_objets; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY association_objets ALTER COLUMN pk_association_objets SET DEFAULT nextval('associer_objets_pk_associer_objets_seq'::regclass);


--
-- TOC entry 2236 (class 2604 OID 22818)
-- Name: pk_date_objet; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY date_objet ALTER COLUMN pk_date_objet SET DEFAULT nextval('date_objet_pk_date_objet_seq'::regclass);


--
-- TOC entry 2233 (class 2604 OID 22779)
-- Name: pk_nom_objet; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY nom_objet ALTER COLUMN pk_nom_objet SET DEFAULT nextval('nom_objet_cle_nom_objet_seq'::regclass);


--
-- TOC entry 2235 (class 2604 OID 22780)
-- Name: pk_objet; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY objet ALTER COLUMN pk_objet SET DEFAULT nextval('objet_cle_objet_seq'::regclass);


--
-- TOC entry 2380 (class 0 OID 22729)
-- Dependencies: 175
-- Data for Name: association_objets; Type: TABLE DATA; Schema: objets; Owner: -
--

INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (1, 3, 2, 17, NULL, NULL, NULL, NULL, '2015-10-04 12:11:31.143556+02', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (2, 5, 2, 17, NULL, NULL, NULL, NULL, '2015-10-04 14:44:10.664694+02', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (3, 16, 15, 21, NULL, NULL, NULL, NULL, '2015-10-05 07:35:37.300968+02', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (4, 13, 3, 35, NULL, NULL, NULL, NULL, '2015-10-05 08:04:00.486892+02', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (5, 2, 13, 34, NULL, NULL, NULL, NULL, '2015-10-05 08:53:49.238243+02', '2015-10-05 08:59:57.794138+02', NULL, 23, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (6, 21, 13, 34, NULL, NULL, NULL, NULL, '2015-10-05 08:57:49.49488+02', '2015-10-05 09:14:00.426949+02', NULL, 22, NULL, NULL, NULL);


--
-- TOC entry 2398 (class 0 OID 0)
-- Dependencies: 176
-- Name: associer_objets_pk_associer_objets_seq; Type: SEQUENCE SET; Schema: objets; Owner: -
--

SELECT pg_catalog.setval('associer_objets_pk_associer_objets_seq', 6, true);


--
-- TOC entry 2387 (class 0 OID 22815)
-- Dependencies: 186
-- Data for Name: date_objet; Type: TABLE DATA; Schema: objets; Owner: -
--

INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (2, '1630', 27, NULL, NULL, NULL, 2, '2015-10-02 14:17:45.118701+02', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (4, '1642', 27, NULL, NULL, NULL, 7, '2015-10-02 22:28:35.936273+02', NULL, NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (7, '20151027', 26, NULL, NULL, NULL, 3, '2015-10-04 12:16:24.653578+02', NULL, NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (8, '1637', 27, NULL, NULL, NULL, 17, '2015-10-04 21:15:16.650704+02', NULL, NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (1, '1571', 25, NULL, NULL, NULL, 2, '2015-10-01 20:17:45+02', '2015-10-04 22:52:57.837407+02', NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (3, '1564', 25, NULL, NULL, NULL, 7, '2015-10-02 22:28:04.59748+02', '2015-10-04 23:06:33.201954+02', NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (9, '1571', 25, NULL, NULL, NULL, 13, '2015-10-05 08:44:24.207099+02', NULL, NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (6, '1580', 25, NULL, NULL, NULL, 17, '2015-10-03 10:56:25.356309+02', '2015-10-05 13:51:05.754774+02', NULL);


--
-- TOC entry 2399 (class 0 OID 0)
-- Dependencies: 185
-- Name: date_objet_pk_date_objet_seq; Type: SEQUENCE SET; Schema: objets; Owner: -
--

SELECT pg_catalog.setval('date_objet_pk_date_objet_seq', 9, true);


--
-- TOC entry 2382 (class 0 OID 22737)
-- Dependencies: 177
-- Data for Name: nom_objet; Type: TABLE DATA; Schema: objets; Owner: -
--

INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (8, 'concerner', NULL, NULL, 10, true, '2015-09-30 17:45:49.20009+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (9, 'Naissance', NULL, NULL, 11, true, '2015-09-30 17:52:16.518456+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (10, 'Naissance', NULL, NULL, 12, true, '2015-09-30 17:53:02.319296+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (11, 'Naissance de Kepler', NULL, NULL, 13, true, '2015-09-30 17:56:09.260378+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (4, 'Astronomie', NULL, NULL, 6, true, '2015-09-28 21:48:24.513948+02', '2015-10-02 23:15:26.894269+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (6, 'Element biographique', NULL, NULL, 8, true, '2015-09-30 17:26:14.167382+02', '2015-10-04 07:38:56.716102+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (7, 'Titre 1', NULL, NULL, 9, true, '2015-09-30 17:31:31.168992+02', '2015-10-04 07:39:14.467435+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (12, 'Caractérisation synthètique', NULL, NULL, 14, true, '2015-09-30 23:14:59.243403+02', '2015-10-04 07:39:28.32644+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (3, 'Notices tirées de la BNF', NULL, NULL, 5, true, '2015-09-26 10:20:04.358098+02', '2015-10-04 08:10:51.125626+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (16, 'Philosophe', NULL, NULL, 18, true, '2015-10-04 08:15:39.193019+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (17, 'Savant', NULL, NULL, 19, true, '2015-10-04 08:38:15.524569+02', '2015-10-04 08:38:35.212498+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (18, 'Notice', NULL, NULL, 20, true, '2015-10-04 10:40:12.841066+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (2, 'Notices concernant les astronomes', NULL, NULL, 3, true, '2015-09-25 22:44:01.114866+02', '2015-10-04 12:16:24.653578+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (1, 'Kepler, Jean', NULL, NULL, 2, true, '2015-09-25 22:42:29.469598+02', '2015-10-04 22:52:57.837407+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (19, 'Galilei, Galileo', NULL, NULL, 7, true, '2015-10-04 23:06:33.201954+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (20, 'Weil der Stadt', NULL, NULL, 21, true, '2015-10-05 08:46:30.390569+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (21, 'localiser', NULL, NULL, 22, true, '2015-10-05 08:48:23.727187+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (22, 'naître', NULL, NULL, 23, true, '2015-10-05 08:59:20.720318+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (14, 'Mathématicien', NULL, NULL, 16, true, '2015-10-03 09:57:19.385319+02', '2015-10-05 09:08:21.000977+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (15, 'Nicolas Claude Fabri de Peiresc', NULL, NULL, 17, true, '2015-10-03 09:57:48.242165+02', '2015-10-05 13:51:05.754774+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (13, 'Mathématiques', NULL, NULL, 15, true, '2015-10-02 23:54:54.414336+02', '2015-10-05 13:52:36.540175+02', 15, NULL, NULL);


--
-- TOC entry 2400 (class 0 OID 0)
-- Dependencies: 178
-- Name: nom_objet_cle_nom_objet_seq; Type: SEQUENCE SET; Schema: objets; Owner: -
--

SELECT pg_catalog.setval('nom_objet_cle_nom_objet_seq', 22, true);


--
-- TOC entry 2384 (class 0 OID 22746)
-- Dependencies: 179
-- Data for Name: objet; Type: TABLE DATA; Schema: objets; Owner: -
--

INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (20, 'Descriptif synthétique des caractéristiques d''un objet, tel un article de dictionnaire, etc.', NULL, '2015-10-04 10:40:12.841066+02', NULL, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (6, 'Discipline qui étudie les mouvements des astres', NULL, '2015-09-28 21:20:15.740526+02', NULL, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (11, 'Le fait de la naissance d''une personne, avec le lieu et la date', NULL, '2015-09-30 17:52:16.518456+02', '2015-09-30 17:54:18.455471+02', NULL, NULL, NULL, NULL, NULL, 37, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (12, 'La mention de la naissance d''une personne, avec le lieu et la date', NULL, '2015-09-30 17:53:02.319296+02', '2015-09-30 17:54:20.987123+02', NULL, NULL, NULL, NULL, NULL, 36, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (10, 'Associe l''objet concerné par l''unité de connaissance', NULL, '2015-09-30 17:45:49.20009+02', '2015-09-30 17:55:03.053551+02', NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (13, NULL, NULL, '2015-09-30 17:56:09.260378+02', NULL, NULL, NULL, NULL, NULL, NULL, 33, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (5, 'Notices tirées d''une requête SPARQL et nettoyée dans un tableur avec Calc', NULL, '2015-09-26 09:57:29.684167+02', '2015-10-04 11:42:34.847754+02', NULL, NULL, NULL, NULL, '<root><ud>
Hermann de Carinthie (<en type="li">île de Korčula (Croatie)</en>, <dat when="1105">1105</dat>) Philosophe, écrivain, mathématicien, astrologue et traducteur croate [http://data.bnf.fr/ark:/12148/cb16243624j#foaf:Person]
</ud>
<ud>
Hermann le Dalmate (<en type="li">Saint Peter en Istrie une partie du duché de Carinthie (au sud de l''Autriche)</en>, <dat when="1110">1110</dat>) Philosophe, astronome, astrologue, mathématicien et traducteur d''ouvrages scientifiques et de la littérature. - Il vint très jeune en 1135 en France à Paris et à Chartres. - Eut pour maître Thierry de Chartres. - L''abbé de Cluny, Pierre le Vénérable, poussa Herman à traduire à écrire sur la vie et l''oeuvre de Mahomet [http://data.bnf.fr/ark:/12148/cb12364029w#foaf:Person]
</ud>
<ud>
Bhāskarācārya (<en type="li">Dekkan, Inde</en>, <dat when="1114">1114</dat>) Mathématicien. - Astronome. - Fils de Maheśvara. - Auteur de :  "Siddhāntaśiromanī" (en 1150) ; "Karṇakutūhala" [http://data.bnf.fr/ark:/12148/cb14498624v#foaf:Person]
</ud>
<ud>
al-Muẓaffar ibn Muḥammad Šaraf al-Dīn Ṭūsī (<dat when="1151">1151</dat>) Mathématicien. - Originaire de Ṭūs, Hamad̲ān, Mosul, Alep, Damas. - Écrivait vers 1209 [http://data.bnf.fr/ark:/12148/cb120864072#foaf:Person]
</ud>
<ud>
Johannes de Sacro Bosco (<dat when="1151">1151</dat>) Mathématicien. - Chanoine prémontré de Holywood (comté de Dumfries, Écosse). - Professeur à l''Université de Paris. - Semble être né à Halifax (Yorkshire, Angleterre). - Mort en 1256 ou 1244 [http://data.bnf.fr/ark:/12148/cb121284153#foaf:Person]
</ud>
<ud>
Robertus Castrensis (<dat when="1151">1151</dat>) Traducteur de traités scientifiques et de mathématiques. - Sa période d''activité se situe aux alentours de 1145 [http://data.bnf.fr/ark:/12148/cb12223624k#foaf:Person]
</ud>
<ud>
Alexandre de Villedieu (<en type="li">Villedieu (Manche)</en>, <dat when="1170">1170</dat>) Franciscain. - Grammairien, mathématicien et poète. - Chanoine de la cathédrale Saint-André d''Avranches [http://data.bnf.fr/ark:/12148/cb12536245w#foaf:Person]
</ud>
<ud>
Leonardo Fibonacci (<dat when="1170">1170</dat>) Mathématicien. - Surnommé Leonardo Pisano [http://data.bnf.fr/ark:/12148/cb13092437c#foaf:Person]
</ud>
<ud>
Moḥamad ben Moḥamad Naṣīr al-Dīn Ṭōsī (<en type="li">Tus (Iran)</en>, <dat when="1201">1201</dat>) Mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb12399386c#foaf:Person]
</ud>
<ud>
Jean Pecham (<dat when="1220">1220</dat>) Provincial des franciscains d''Angleterre. - Archevêque de Cantorbéry (à partir de 1279). - Théologien, mathématicien et physicien [http://data.bnf.fr/ark:/12148/cb12459837w#foaf:Person]
</ud>
<ud>
Witelo (<dat when="1220">1220</dat>) Philosophe et mathématicien [http://data.bnf.fr/ark:/12148/cb12054316n#foaf:Person]
</ud>
<ud>
Maḥmūd ibn Mas´ūd Quṭb al-Dīn al- Šīrāzī (<en type="li">Shīrāz</en>, <dat when="1236">1236</dat>) Astronome, médecin, philosophe et théologien [http://data.bnf.fr/ark:/12148/cb12086388m#foaf:Person]
</ud>
<ud>
Jacob ben Machir (<en type="li">Marseille</en>, <dat when="1238">1238</dat>) Astronome. - Médecin. - Chancellier de la faculté de médecine de Montpellier [http://data.bnf.fr/ark:/12148/cb165406517#foaf:Person]
</ud>
<ud>
Grégoire Chioniadès (<dat when="1240">1240</dat>) Astronome, physicien et médecin byzantin. - Évêque de Tabriz, Iran [http://data.bnf.fr/ark:/12148/cb12007088c#foaf:Person]
</ud>
<ud>
Henri Baten (<dat when="1246">1246</dat>) Philosophe et théologien. - Astronome. - Poète et musicien [http://data.bnf.fr/ark:/12148/cb12220635h#foaf:Person]
</ud>
<ud>
al-Mufaḍḍal ibn ʿUmar Aṯīr al-Dīn al-Abharī (<dat when="1251">1251</dat>) Philosophe, logicien, astronome [http://data.bnf.fr/ark:/12148/cb15935708x#foaf:Person]
</ud>
<ud>
Bartolomeo da Parma (<dat when="1251">1251</dat>) Astrologue, géomancien et astronome. Fut professeur à l''Université de Bologne (1288-1297) [http://data.bnf.fr/ark:/12148/cb144790439#foaf:Person]
</ud>
<ud>
Campanus de Novare (<dat when="1251">1251</dat>) Astronome. - Mathématicien, commentateur d''Euclide [http://data.bnf.fr/ark:/12148/cb124917005#foaf:Person]
</ud>
<ud>
David ben Yom-Tov Poel (<dat when="1251">1251</dat>) Philosophe. - Médecin. - Père de l''astronome Jacob Poel [http://data.bnf.fr/ark:/12148/cb16540698w#foaf:Person]
</ud>
<ud>
Démétrius Triclinius (<en type="li">Thessalonique</en>, <dat when="1251">1251</dat>) Philologue. - Mathématicien et astrologue [http://data.bnf.fr/ark:/12148/cb12311753x#foaf:Person]
</ud>
<ud>
Geršon ben Salomon d''Arles (<en type="li">Béziers</en>, <dat when="1251">1251</dat>) Éxégète. - Astronome [http://data.bnf.fr/ark:/12148/cb134867338#foaf:Person]
</ud>
<ud>
Hui Yang (<dat when="1251">1251</dat>) Mathématicien chinois. En activité entre 1261 et 1275 [http://data.bnf.fr/ark:/12148/cb13746624q#foaf:Person]
</ud>
<ud>
Isaac ben Joseph Israeli (<dat when="1251">1251</dat>) Astronome. - Elève d''Asher ben Jehiel [http://data.bnf.fr/ark:/12148/cb16540863s#foaf:Person]
</ud>
<ud>
Jacopo da Firenze (<dat when="1251">1251</dat>) Mathématicien. - Actif en 1307 [http://data.bnf.fr/ark:/12148/cb157815579#foaf:Person]
</ud>
<ud>
Jordanus Nemorarius (<dat when="1251">1251</dat>) Mathématicien. - Probablement d''origine italienne [http://data.bnf.fr/ark:/12148/cb11986727x#foaf:Person]
</ud>
<ud>
Petrus Philomena de Dacia (<dat when="1251">1251</dat>) Mathématicien, astronome, philosophe. - Attesté entre 1290 et 1300. - Élève à l''Université de Bologne (1291-1292) puis de Paris. - Chanoine de Roskilde, Danemark. - A distinguer de Petrus de Dacia, recteur de l''Université de Paris en 1327 [http://data.bnf.fr/ark:/12148/cb11887258w#foaf:Person]
</ud>
<ud>
ʿAbd al-Ġaffār ibn ʿAbd al-Karīm Naǧm al-Dīn al- Qazwīnī (<dat when="1251">1251</dat>) Mathématicien et jurisconsulte chaféite [http://data.bnf.fr/ark:/12148/cb155674927#foaf:Person]
</ud>
<ud>
Andalò Di Negro (<en type="li">Gênes (?), Italie</en>, <dat when="1260">1260</dat>) Astronome. - Précepteur de Boccace. - Ambassadeur de la République de Gênes auprès de l''empereur Alexis Comnène (en 1314) [http://data.bnf.fr/ark:/12148/cb121998732#foaf:Person]
</ud>
<ud>
Théodore Métochite (<en type="li">Constantinople</en>, <dat when="1260">1260</dat>) Homme d''état, philosophe, poète, astronome et rhéteur [http://data.bnf.fr/ark:/12148/cb12000562c#foaf:Person]
</ud>
<ud>
Gersonide (Bagnols-sur-Cèze (<en type="li">Gard)</en>, <dat when="1288">1288</dat>) Exégète biblique, mathématicien, astronome, philosophe, physicien [http://data.bnf.fr/ark:/12148/cb12131941j#foaf:Person]
</ud>
<ud>
Barlaam de Seminara (<dat when="1290">1290</dat>) Moine basilien, abbé du Saint-Esprit à Constantinople (<dat when="1331">1331</dat>), évêque de Gérace (1342-1348). - Théologien, philosophe, mathématicien, astronome et helléniste [http://data.bnf.fr/ark:/12148/cb13549924x#foaf:Person]
</ud>
<ud>
Jacopo Dondi (<dat when="1290">1290</dat>) Philosophe, astronome, médecin italien célèbre pour la construction d''une pendule astrale à Padoue. - Père de Giovanni Dondi [http://data.bnf.fr/ark:/12148/cb124119184#foaf:Person]
</ud>
<ud>
Thomas Bradwardine (<dat when="1290">1290</dat>) Mathématicien, philosophe et théologien. - Surnommé le "Doctor Profundus". - Archevêque de Canterbury en 1349 [http://data.bnf.fr/ark:/12148/cb12269047v#foaf:Person]
</ud>
<ud>
Richard of Wallingford (<dat when="1292">1292</dat>) Mathématicien. - Astronome. - Abbé du monastère bénédictin de St Albans [http://data.bnf.fr/ark:/12148/cb12128305h#foaf:Person]
</ud>
<ud>
Jean de Murs (<dat when="1300">1300</dat>) Astronome, mathématicien et théoricien de la musique. - Maître-ès-arts de l''Université de Paris (<dat when="1321">1321</dat>) [http://data.bnf.fr/ark:/12148/cb121715011#foaf:Person]
</ud>
<ud>
Giovanni Dondi dall''Orologio (<en type="li">Chiogga, Italie</en>, <dat when="1318">1318</dat>) Médecin et poète. - Astronome et horloger, a terminé l''horloge astronomique, installée par son père : Dondi, Jacopo (1298-1359), à Padoue ou Pavie, Italie [http://data.bnf.fr/ark:/12148/cb122241024#foaf:Person]
</ud>
<ud>
Giacomo Allegretti (<dat when="1325">1325</dat>) Médecin , poète et astronome [http://data.bnf.fr/ark:/12148/cb14405998n#foaf:Person]
</ud>
<ud>
Blasius de Parma (<dat when="1347">1347</dat>) Philosophe, mathématicien, médecin. - Recteur de l''université de Parme (en 1412) [http://data.bnf.fr/ark:/12148/cb12182615f#foaf:Person]
</ud>
<ud>
Abū ʿAbd Allâh Muḥammad al- Baqqār (<dat when="1351">1351</dat>) Mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb155102056#foaf:Person]
</ud>
<ud>
Emmanuel ben Jacob de Tarascon Bonfils (<dat when="1351">1351</dat>) Astronome, médecin et mathématicien ayant vécu à Orange puis à Tarascon. Il est l''auteur de nombreux traités d''astronomie [http://data.bnf.fr/ark:/12148/cb15620448d#foaf:Person]
</ud>
<ud>
Ǧamšīd ibn Masʿūd Ġiyāṯ al-Dīn al- Kāšī (<dat when="1351">1351</dat>) Médecin, mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb11351746b#foaf:Person]
</ud>
<ud>
Johannes Danck (<dat when="1351">1351</dat>) Astronome. - A enseigné à l''Université de Paris de 1327 à 1355 [http://data.bnf.fr/ark:/12148/cb12531239r#foaf:Person]
</ud>
<ud>
Naǧm al-Dīn al- Miṣrī (<dat when="1351">1351</dat>) Auteur supposé de traités portant sur les instruments astronomiques [http://data.bnf.fr/ark:/12148/cb14566743g#foaf:Person]
</ud>
<ud>
Prosdocimus de Beldemandis (<dat when="1351">1351</dat>) Théoricien de la musique, mathématicien et physicien [http://data.bnf.fr/ark:/12148/cb127653823#foaf:Person]
</ud>
<ud>
Taddeo da Parma (<dat when="1351">1351</dat>) Philosophe averroïste et astronome. - A enseigné la philosophie à Bologne vers 1320 [http://data.bnf.fr/ark:/12148/cb10103512f#foaf:Person]
</ud>
<ud>
Théodore Méliténiote (<en type="li">Constantinople</en>, <dat when="1351">1351</dat>) Grand sacellaire de l''Église byzantine, maître des maîtres de l''École patriarcale et archidiacre du clergé palatin. - A laissé un ouvrage d''exégèse de l''Évangile, un traité d''astronomie et un poème allégorique [http://data.bnf.fr/ark:/12148/cb12153709d#foaf:Person]
</ud>
<ud>
Paolo dal Pozzo Toscanelli (<dat when="1397">1397</dat>) Mathématicien, physicien, géographe, astronome et astrologue. - Inventeur des gnomons modernes. - Conservateur de la Bibliothèque de Florence [http://data.bnf.fr/ark:/12148/cb12455406j#foaf:Person]
</ud>
<ud>
Ugolino Pisani (<en type="li">Parme, Italie</en>, <dat when="1405">1405</dat>) Philosophe, mathématicien, auteur de comédies [http://data.bnf.fr/ark:/12148/cb12689419t#foaf:Person]
</ud>
<ud>
Lorenzo Buonincontri (<en type="li">San Miniato, Italie</en>, <dat when="1411">1411</dat>) Militaire, mathématicien, astronome, astrologue, poète et historien. - Professeur d''astronomie à Naples [http://data.bnf.fr/ark:/12148/cb12536229n#foaf:Person]
</ud>
<ud>
ʿAlī ibn Muḥammad al- Qalaṣādī (<en type="li">Baza (Espagne)</en>, <dat when="1412">1412</dat>) Mathématicien, astronome, juriste et savant [http://data.bnf.fr/ark:/12148/cb12440997n#foaf:Person]
</ud>
<ud>
Piero della Francesca (<en type="li">Borgo San Sepolcro, Italie</en>, <dat when="1416">1416</dat>) Peintre. - A écrit des traités de mathématiques, perspective et géométrie et des écrits sur la science des couleurs et du paysage [http://data.bnf.fr/ark:/12148/cb12060279h#foaf:Person]
</ud>
<ud>
Georgius de Hungaria (<en type="li">Romosz, aujourd''hui Romos, Roumanie</en>, <dat when="1422">1422</dat>) Prisonnier des Turcs (1438-1458). - Dominicain. - Mathématicien [http://data.bnf.fr/ark:/12148/cb130923013#foaf:Person]
</ud>
<ud>
Antonio Manetti (<en type="li">Florence, Italie</en>, <dat when="1423">1423</dat>) Homme de lettres. - Architecte, astronome, mathématicien [http://data.bnf.fr/ark:/12148/cb11914242h#foaf:Person]
</ud>
<ud>
Georg von Peurbach (<en type="li">Peuerbach, Autriche</en>, <dat when="1423">1423</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb12374660w#foaf:Person]
</ud>
<ud>
Giovanni Pontano (<en type="li">Cerreto di Spoleto (Perouse), Italie</en>, <dat when="1426">1426</dat>) Homme politique. - Humaniste. - Auteur de traités astronomiques et philosophiques [http://data.bnf.fr/ark:/12148/cb123298807#foaf:Person]
</ud>
<ud>
Johannes Regiomontanus (<en type="li">Königsberg, Allemagne</en>, <dat when="1436">1436</dat>) Astronome. - Mathématicien [http://data.bnf.fr/ark:/12148/cb12159829r#foaf:Person]
</ud>
<ud>
Nīlakaṇṭha Somayajī (<dat when="1443">1443</dat>) Astronome et mathématicien de l''école de Kerala (Inde) [http://data.bnf.fr/ark:/12148/cb165324540#foaf:Person]
</ud>
<ud>
Luca Pacioli (<dat when="1445">1445</dat>) Mathématicien. - Franciscain [http://data.bnf.fr/ark:/12148/cb11918350c#foaf:Person]
</ud>
<ud>
Konrad Türst (<dat when="1450">1450</dat>) Mathématicien suisse de Zürich [http://data.bnf.fr/ark:/12148/cb15336511g#foaf:Person]
</ud>
<ud>
Agostino Ricci (<dat when="1451">1451</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb12539498r#foaf:Person]
</ud>
<ud>
Andrea Corsali (<dat when="1451">1451</dat>) Astronome, cosmographe, navigateur dans la péninsule arabique et aux Indes. - Pourrait avoir introduit l''imprimerie en Éthiopie (ca 1524), où vraisemblament il meurt [http://data.bnf.fr/ark:/12148/cb13517283d#foaf:Person]
</ud>
<ud>
Anianus (<dat when="1451">1451</dat>) Astronome et poète [http://data.bnf.fr/ark:/12148/cb125156549#foaf:Person]
</ud>
<ud>
Antonio Dolciati (<dat when="1451">1451</dat>) Augustinien et mathématicien [http://data.bnf.fr/ark:/12148/cb134854696#foaf:Person]
</ud>
<ud>
Bartolomeo da Messina (<dat when="1451">1451</dat>) Écclésiastique et mathématicien [http://data.bnf.fr/ark:/12148/cb125393703#foaf:Person]
</ud>
<ud>
Gaspar Torrella (<dat when="1451">1451</dat>) Médecin et mathématicien. - Évêque de Santa-Giusta (Sardaigne) en 1494. - Originaire de Valence (Espagne) [http://data.bnf.fr/ark:/12148/cb13486025q#foaf:Person]
</ud>
<ud>
Giovanni Abiosi (<dat when="1451">1451</dat>) Médecin, astronome, mathématicien et philosophe. - Né à Bagnuolo (Royaume de Naples), mort vers 1500 [http://data.bnf.fr/ark:/12148/cb12537367q#foaf:Person]
</ud>
<ud>
Giovanni Antonio Tagliente (<dat when="1451">1451</dat>) Calligraphe. - Mathématicien [http://data.bnf.fr/ark:/12148/cb12179148h#foaf:Person]
</ud>
<ud>
Giovanni Benedetto Moncetto (<dat when="1451">1451</dat>) Agostinien. - Théologien, philosophe et astronome [http://data.bnf.fr/ark:/12148/cb125688716#foaf:Person]
</ud>
<ud>
Giovanni Bianchini (<dat when="1451">1451</dat>) Astronome mort après 1469 [http://data.bnf.fr/ark:/12148/cb16163624s#foaf:Person]
</ud>
<ud>
Guillaume Hobit (<dat when="1451">1451</dat>) Astronome ; astrologue de Philippe le Bon, duc de Bourgogne [http://data.bnf.fr/ark:/12148/cb15063496s#foaf:Person]
</ud>
<ud>
Jacob Köbel (<en type="li">Heidelberg, Allemagne</en>, <dat when="1451">1451</dat>) Mathématicien, éditeur et libraire [http://data.bnf.fr/ark:/12148/cb10244031k#foaf:Person]
</ud>
<ud>
Louis Boulengier (<dat when="1451">1451</dat>) Astronome et géographe d''Albi [http://data.bnf.fr/ark:/12148/cb152949413#foaf:Person]
</ud>
<ud>
Rāmacandrācārya (<dat when="1451">1451</dat>) Grammairien et commentateur de Pāṇini (actif au 15e s.). - Fils de Kr̥ṣṇācārya. - A aussi écrit des ouvrages de philosophie (Vedānta) et d''astronomie [http://data.bnf.fr/ark:/12148/cb137708651#foaf:Person]
</ud>
<ud>
Sigismondo Fanti (<en type="li">Ferrare, Italie</en>, <dat when="1451">1451</dat>) Poète, philosophe et mathématicien. - Meurt après 1527 [http://data.bnf.fr/ark:/12148/cb12567416q#foaf:Person]
</ud>
<ud>
Willem Gilliszoon (<dat when="1451">1451</dat>) Astronome et mathématicien. - Originaire de Wissekerc (Zélande) [http://data.bnf.fr/ark:/12148/cb12548011q#foaf:Person]
</ud>
<ud>
Girolamo Donato (<dat when="1454">1454</dat>) Magistrat, poète, philosophe, théologien et mathématicien. - Fut gouverneur de Brescia (<dat when="1496">1496</dat>), de Ferrare (<dat when="1498">1498</dat>), ambassadeur de Venise près le pape Jules II (<dat when="1510">1510</dat>) [http://data.bnf.fr/ark:/12148/cb13325565p#foaf:Person]
</ud>
<ud>
Eliya Delmedigo (<dat when="1460">1460</dat>) Médecin. - Astronome. - Mathématicien. - Né en Crète. - Philosophe. - Maître d''hébreu de Pic de la Mirandole (1463-1494). - Commentateur des écrits d''Averroés (1126-1198) [http://data.bnf.fr/ark:/12148/cb122623668#foaf:Person]
</ud>
<ud>
Lodovico Pontico Virunio (<dat when="1467">1467</dat>) Professeur de lettres, philosophe, mathématicien et poète. - Fut chargé de l''éducation des fils de Ludovico Sforza, duc de Milan. - Eut l''intention de fonder une imprimerie grecque et latine à Reggio Emilia, mais ses caractères furent volés par Ludovico Bonaccioli, médecin de la duchesse de Ferrare. - Né à Belluno, meurt à Bologne [http://data.bnf.fr/ark:/12148/cb13324006j#foaf:Person]
</ud>
<ud>
Johannes Werner (<en type="li">Nuremberg, Allemagne</en>, <dat when="1468">1468</dat>) Mathématicien, astronome et cartographe [http://data.bnf.fr/ark:/12148/cb154028305#foaf:Person]
</ud>
<ud>
Jakob Ziegler (<en type="li">Landau (Allemagne)</en>, <dat when="1470">1470</dat>) Théologien, mathématicien, astronome et géographe. - Professeur de théologie. - Commentateur et auteur d''ouvrages historiques et théologiques [http://data.bnf.fr/ark:/12148/cb15029346k#foaf:Person]
</ud>
<ud>
Pedro Ciruelo (<en type="li">Daroca, Espagne</en>, <dat when="1470">1470</dat>) Professeur de théologie à l''Université d''Alcala (1510-), chanoine de la cathédrale de cette ville. - Fut l''un des précepteurs de Philippe II. - Étudia à Salamanque et à Paris, où il édita des oeuvres mathématiques et scientifiques. - Est également l''auteur d''un traité sur la sorcellerie dont la traduction espagnole eut une diffusion importante [http://data.bnf.fr/ark:/12148/cb128071494#foaf:Person]
</ud>
<ud>
Johann Stöffler (<en type="li">Justingen, Allemagne</en>, <dat when="1472">1472</dat>) Astronome et mathématicien [http://data.bnf.fr/ark:/12148/cb125156905#foaf:Person]
</ud>
<ud>
Josse Clicthove (Nieuport, Pays-Bas, <dat when="1472">1472</dat>) Théologien et mathématicien. - Théologal de Chartres. - Un des premiers à combattre les idées de Luther [http://data.bnf.fr/ark:/12148/cb12234610b#foaf:Person]
</ud>
<ud>
Bartolomeo Zamberti (<en type="li">Venise, Italie</en>, <dat when="1473">1473</dat>) Mathématicien et humaniste. - Professeur de lettres. - Notaire des Consuls des marchands de Venise [http://data.bnf.fr/ark:/12148/cb12033590z#foaf:Person]
</ud>
<ud>
Nicolas Copernic (<dat when="1473">1473</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb118976048#foaf:Person]
</ud>
<ud>
Luca Gaurico (<en type="li">Giffoni, Italie</en>, <dat when="1476">1476</dat>) Évêque de Civita Ducale (1545-1549). - Mathématicien, philosophe, astronome et astrologue [http://data.bnf.fr/ark:/12148/cb134849440#foaf:Person]
</ud>
<ud>
Johann Schöner (<dat when="1477">1477</dat>) Né à Karlstadt près de Würzburg. - Prédicateur protestant. - Astronome. - Géographe. - Professeur de mathématiques à Nuremberg. - A aussi écrit en latin [http://data.bnf.fr/ark:/12148/cb119992233#foaf:Person]
</ud>
<ud>
Girolamo Fracastoro (<en type="li">Vérone, Italie</en>, <dat when="1478">1478</dat>) Médecin, auteur du "De contagione et contagiosis morbis et curatione libri III" ; nommé par le pape Paul III médecin officiel du Concile de Trente. - Auteur de poèmes en latin, d''oeuvres de géographie, d''astronomie, de physique, de théologie et de philosophie. - Élève de Pomponazzi, ami de Copernic [http://data.bnf.fr/ark:/12148/cb120587788#foaf:Person]
</ud>
<ud>
Girolamo Francastoro (<dat when="1478">1478</dat>) Médecin, astronome, géologiste, poète, précurseur de la notion de contagion [http://data.bnf.fr/ark:/12148/cb15699396m#foaf:Person]
</ud>
<ud>
Celio Calcagnini (<en type="li">Ferrare, Italie</en>, <dat when="1479">1479</dat>) Poète, philologue, philosophe et astronome. - Accompagna Hippolyte d''Este en Hongrie et en Pologne [http://data.bnf.fr/ark:/12148/cb122157991#foaf:Person]
</ud>
<ud>
Charles de Bovelles (<dat when="1479">1479</dat>) Philosophe, mathématicien et linguiste. - Chanoine de Noyon. - Né avant le 28 mars 1479 [http://data.bnf.fr/ark:/12148/cb118932166#foaf:Person]
</ud>
<ud>
Prospero Calano (<en type="li">Sarzana, Italie</en>, <dat when="1480">1480</dat>) Médecin, astronome et philosophe [http://data.bnf.fr/ark:/12148/cb12568870v#foaf:Person]
</ud>
<ud>
Vannoccio Biringuccio (<en type="li">Sienne, Italie</en>, <dat when="1480">1480</dat>) Mathématicien, chimiste, architecte et ingénieur, spécialiste en métallurgie [http://data.bnf.fr/ark:/12148/cb12195640k#foaf:Person]
</ud>
<ud>
Michael Stifel (<dat when="1487">1487</dat>) Théologien et mathématicien. - Inventeur du logarithme. - Enseigna la théologie et les mathématiques à l''Université de Königsberg, puis les mathématiques à l''Université de Iéna [http://data.bnf.fr/ark:/12148/cb12795734z#foaf:Person]
</ud>
<ud>
Sebastian Münster (<en type="li">Ingelheim, Allemagne</en>, <dat when="1489">1489</dat>) Hébraïsant, géographe et mathématicien [http://data.bnf.fr/ark:/12148/cb11996987j#foaf:Person]
</ud>
<ud>
Albert Pighius (Kampen, Pays-Bas, <dat when="1490">1490</dat>) Théologien, mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb10448635x#foaf:Person]
</ud>
<ud>
Patrizio Tricasso (<en type="li">Ceresara, Italie</en>, <dat when="1491">1491</dat>) Dominicain. - Mathématicien et astrologue [http://data.bnf.fr/ark:/12148/cb107034397#foaf:Person]
</ud>
<ud>
Heinrich Schreiber (<en type="li">Erfurt, Allemagne</en>, <dat when="1492">1492</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb10734904t#foaf:Person]
</ud>
<ud>
Jean Borrel (<dat when="1492">1492</dat>) Géomètre et mathématicien. - Chanoine régulier de l''Ordre de Saint-Antoine [http://data.bnf.fr/ark:/12148/cb12515817n#foaf:Person]
</ud>
<ud>
Pedro Nunez (<dat when="1492">1492</dat>) Astronome et mathématicien [http://data.bnf.fr/ark:/12148/cb12548918m#foaf:Person]
</ud>
<ud>
Oronce Fine (Briançon (Hautes-Alpes), <dat when="1494">1494</dat>) Sieur de Champrouet. - Mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb122937307#foaf:Person]
</ud>
<ud>
Petrus Apian (<en type="li">Leisnig (Allemagne)</en>, <dat when="1495">1495</dat>) Astronome, cartographe et mathématicien. - Nommé Chevalier de l''Empire par Charles Quint. - Surnom de : Bienewitz (ou Bennewitz), Peter [http://data.bnf.fr/ark:/12148/cb12515640m#foaf:Person]
</ud>
<ud>
Andreas Osiander (<en type="li">Gunzenhausen, Allemagne</en>, <dat when="1498">1498</dat>) Théologien protestant, astronome et mathématicien. - Parfois désigné sous le nom "Andreas Osiander l''Ancien" [http://data.bnf.fr/ark:/12148/cb11988942v#foaf:Person]
</ud>
<ud>
Garcia da Orta (<en type="li">Castelo di Vide, Portugal</en>, <dat when="1499">1499</dat>) Médecin et naturaliste. - A enseigné les mathématiques à l''Université de Lisbonne [http://data.bnf.fr/ark:/12148/cb119983323#foaf:Person]
</ud>
<ud>
Giovanni Agostino Abate (<dat when="1499">1499</dat>) Mathématicien et historien [http://data.bnf.fr/ark:/12148/cb14624324z#foaf:Person]
</ud>
<ud>
Joachim Sterck van Ringelberg (<en type="li">Anvers, Belgique</en>, <dat when="1499">1499</dat>) Humaniste, mathématicien et astrologue. - Meurt selon les sources le 1er janvier 1531, en 1536 ou en 1556 [http://data.bnf.fr/ark:/12148/cb10645118k#foaf:Person]
</ud>
<ud>
Johann Carion (<en type="li">Bietigheim, Allemagne</en>, <dat when="1499">1499</dat>) Astrologue et mathématicien [http://data.bnf.fr/ark:/12148/cb12805831h#foaf:Person]
</ud>
<ud>
Johannes Dryander (<en type="li">Wetter, Allemagne</en>, <dat when="1500">1500</dat>) Mathématicien, physicien et astronome, professeur à Marburg, édité par Sebastian Münster et Abraham Ortelius [http://data.bnf.fr/ark:/12148/cb15379218m#foaf:Person]
</ud>
<ud>
Johannes Voegelin (<en type="li">Heilbronn, Allemagne</en>, <dat when="1500">1500</dat>) Astronome et mathématicien. - Professeur à l''Université de Vienne [http://data.bnf.fr/ark:/12148/cb10490264h#foaf:Person]
</ud>
<ud>
Niccolò Tartaglia (<dat when="1500">1500</dat>) Mathématicien, ingénieur et architecte. - Pseudonyme de Niccolò Fontana [http://data.bnf.fr/ark:/12148/cb12914492r#foaf:Person]
</ud>
<ud>
Gerolamo Cardano (<en type="li">Pavie, Italie</en>, <dat when="1501">1501</dat>) Médecin, mathématicien et philosophe [http://data.bnf.fr/ark:/12148/cb11895137c#foaf:Person]
</ud>
<ud>
Pedro Nunes (<en type="li">Alcácer do Sol (Portugal)</en>, <dat when="1502">1502</dat>) Astronome et mathématicien portugais [http://data.bnf.fr/ark:/12148/cb13510349t#foaf:Person]
</ud>
<ud>
Cosimo Bartoli (<en type="li">Florence, Italie</en>, <dat when="1503">1503</dat>) Ambassadeur, poète et mathématicien [http://data.bnf.fr/ark:/12148/cb125520809#foaf:Person]
</ud>
<ud>
Jean Cousin (<en type="li">Soucy (Yonne, France)</en>, <dat when="1503">1503</dat>) Peintre, sculpteur, graveur, architecte, mathématicien [http://data.bnf.fr/ark:/12148/cb12467444s#foaf:Person]
</ud>
<ud>
Ciriaco Strozzi (<en type="li">Capalle, Italie</en>, <dat when="1504">1504</dat>) Helléniste, philosophe, mathématicien et architecte [http://data.bnf.fr/ark:/12148/cb10418521b#foaf:Person]
</ud>
<ud>
Jacques Bassantin (<dat when="1504">1504</dat>) Astronome et mathématicien [http://data.bnf.fr/ark:/12148/cb12548014r#foaf:Person]
</ud>
<ud>
Achille Pirminius Gasser (<dat when="1505">1505</dat>) Médecin, historien et astronome [http://data.bnf.fr/ark:/12148/cb12516715x#foaf:Person]
</ud>
<ud>
Benedictus Aretius (<dat when="1505">1505</dat>) Théologien protestant. - Botaniste et astronome. - Professeur de logique à l''Université de Marbourg, puis professeur de théologie à Berne. - Fut lié avec Conrad Gesner. - Né et mort à Berne [http://data.bnf.fr/ark:/12148/cb12515850g#foaf:Person]
</ud>
<ud>
Alessandro Piccolomini (<en type="li">Sienne, Italie</en>, <dat when="1508">1508</dat>) Écrivain, dramaturge, astronome et traducteur d''oeuvres de l''Antiquité, de comédies, de traités philosophiques et scientifiques. - Membre de l''Accademia degli Intronati de Sienne, sous le pseudonyme : lo Stordito. - Archevêque de Patras et coadjuteur de l''archevêque de Sienne Francesco Bandini Piccolomini, du 28 juillet 1574 à 1578 [http://data.bnf.fr/ark:/12148/cb12240709n#foaf:Person]
</ud>
<ud>
Gemma Frisius (Dokkum (Pays-Bas), <dat when="1508">1508</dat>) Mathématicien et astronome. - Professeur et docteur en médecine de l''Université de Louvain [http://data.bnf.fr/ark:/12148/cb125195002#foaf:Person]
</ud>
<ud>
Federico Commandino (<en type="li">Sassocorvaro, Italie</en>, <dat when="1509">1509</dat>) Mathématicien. - A été le tuteur du duc d''Urbino [http://data.bnf.fr/ark:/12148/cb12562850s#foaf:Person]
</ud>
<ud>
Jean Gosselin (<en type="li">Vire, Calvados</en>, <dat when="1510">1510</dat>) Astrologue et mathématicien. - Conservateur de la bibliothèque du roi [http://data.bnf.fr/ark:/12148/cb133321861#foaf:Person]
</ud>
<ud>
Pietro Cataneo (<dat when="1510">1510</dat>) Architecte et mathématicien [http://data.bnf.fr/ark:/12148/cb12557068n#foaf:Person]
</ud>
<ud>
Erasmus Oswald Schreckenfuchs (<dat when="1511">1511</dat>) Hébraïsant. - Astronome [http://data.bnf.fr/ark:/12148/cb12115338j#foaf:Person]
</ud>
<ud>
Giovanni Battista Amici (<en type="li">Cosenza, Italie</en>, <dat when="1511">1511</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb15583428k#foaf:Person]
</ud>
<ud>
Juanelo Turriano (<dat when="1511">1511</dat>) Mathématicien et ingénieur [http://data.bnf.fr/ark:/12148/cb129309990#foaf:Person]
</ud>
<ud>
Gerard Mercator (<en type="li">Rupelmonde, Flandres</en>, <dat when="1512">1512</dat>) Géographe, cartographe, cosmographe et mathématicien [http://data.bnf.fr/ark:/12148/cb12789989j#foaf:Person]
</ud>
<ud>
Giovanni Battista Amico (<dat when="1512">1512</dat>) Philosophe, mathématicien et astrologue. - Originaire de Cosenza, fut assassiné à Padoue [http://data.bnf.fr/ark:/12148/cb12570280s#foaf:Person]
</ud>
<ud>
Juan Pérez de Moya (<dat when="1513">1513</dat>) Mathématicien et humaniste [http://data.bnf.fr/ark:/12148/cb12146300q#foaf:Person]
</ud>
<ud>
Rheticus (<dat when="1514">1514</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb13615799v#foaf:Person]
</ud>
<ud>
Bernardino Baldini (<dat when="1515">1515</dat>) Professeur de médecine à Pavie puis de mathématiques à Milan [http://data.bnf.fr/ark:/12148/cb13163998r#foaf:Person]
</ud>
<ud>
Petrus Ramus (<en type="li">Cuts (Aisne)</en>, <dat when="1515">1515</dat>) Philosophe, grammairien, mathématicien et humaniste. - Professeur de mathématique au Collège royal (Collège de France). - Se convertit au protestantisme et fut tué au cours du Massacre de la Saint-Barthélemy [http://data.bnf.fr/ark:/12148/cb120645094#foaf:Person]
</ud>
<ud>
Jean-Pierre de Mesmes (<dat when="1516">1516</dat>) Savant et poète. - Fils de Pierre de Mesmes, chambellan du roi de Navarre. - Etait lié avec Ronsard, du Bellay, Baïf, Charondas, Herberay, Jean Maugin, Ol. de Magny. - A était un des premiers auteurs à avoir écrit en français sur l''astronomie [http://data.bnf.fr/ark:/12148/cb125177720#foaf:Person]
</ud>
<ud>
Jacques Peletier (<dat when="1517">1517</dat>) Poète et critique humaniste. - Mathématicien. - A participé à la réforme de l''orthographe. - Traducteur d''Horace [http://data.bnf.fr/ark:/12148/cb122992680#foaf:Person]
</ud>
<ud>
Jeronimo Munoz (<dat when="1520">1520</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb14646245j#foaf:Person]
</ud>
<ud>
Livio Sanuto (<dat when="1520">1520</dat>) Géographe et mathématicien à Venise, fabriquant d''un globe avec son frère Giulio en 1561 [http://data.bnf.fr/ark:/12148/cb153816227#foaf:Person]
</ud>
<ud>
Melchior Ayrer (<dat when="1520">1520</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb162974318#foaf:Person]
</ud>
<ud>
Nicolaus Gugler (<en type="li">Nuremberg (Allemagne)</en>, <dat when="1521">1521</dat>) Médecin et astronome, a reçu une formation de juriste. - Fils de Hans Gugler (1480-1560) [http://data.bnf.fr/ark:/12148/cb16504896w#foaf:Person]
</ud>
<ud>
Valentin Mennher (<dat when="1521">1521</dat>) Mathématicien. - Membre de la guilde des instituteurs d''Anvers [http://data.bnf.fr/ark:/12148/cb12563197r#foaf:Person]
</ud>
<ud>
Hermann Witekind (<en type="li">Neuenrade (Allemagne)</en>, <dat when="1522">1522</dat>) Mathématicien et humaniste [http://data.bnf.fr/ark:/12148/cb162248258#foaf:Person]
</ud>
<ud>
Giovanni Maria Bonardo (<en type="li">Fratta Polesine, Italie</en>, <dat when="1523">1523</dat>) Poète. - Agronome. - Astronome [http://data.bnf.fr/ark:/12148/cb12181418p#foaf:Person]
</ud>
<ud>
Juan de Yciar (Durango (prov. de Vizcaya), <dat when="1523">1523</dat>) Pédagogue, mathématicien et calligraphe [http://data.bnf.fr/ark:/12148/cb128696315#foaf:Person]
</ud>
<ud>
Jacques Charpentier (Clermont-en-Beauvaisis (<en type="li">Oise)</en>, <dat when="1524">1524</dat>) Philosophe et médecin. - Lecteur de mathématiques au Collège de France. - Médecin du roi [http://data.bnf.fr/ark:/12148/cb121323921#foaf:Person]
</ud>
<ud>
Tadeáš Hájek (<en type="li">Prague</en>, <dat when="1525">1525</dat>) Mathématicien et médecin. - Reçu docteur à Bologne, occupa une chaire au Carolinum de Prague, fut premier médecin des empereurs Maximilien II et Rodolphe II [http://data.bnf.fr/ark:/12148/cb13009688n#foaf:Person]
</ud>
<ud>
Tilemann Stella (<en type="li">Siegen (Allemagne)</en>, <dat when="1525">1525</dat>) Mathématicien, astronome, géographe, architecte et bibliothécaire. - Cartographe à Wittenberg, ses cartes ont été éditées par Ortelius, Jode et Hondius [http://data.bnf.fr/ark:/12148/cb15376436c#foaf:Person]
</ud>
<ud>
Taqī al-Dīn Muḥammad Ibn Maʿrūf (<en type="li">Damas</en>, <dat when="1526">1526</dat>) Astronome et mathématicien ottoman [http://data.bnf.fr/ark:/12148/cb14599962n#foaf:Person]
</ud>
<ud>
John Dee (<dat when="1527">1527</dat>) Astrologue, mathématicien et antiquaire [http://data.bnf.fr/ark:/12148/cb119854464#foaf:Person]
</ud>
<ud>
Adam Lonicer (<en type="li">Marburg (Allemagne)</en>, <dat when="1528">1528</dat>) Medecin et botaniste. - Professeur de médecine, chimie et mathématiques. - Fils du théologien : Lonicer, Johann (1499-15969) [http://data.bnf.fr/ark:/12148/cb10279221n#foaf:Person]
</ud>
<ud>
Cornelius Blockland (<dat when="1530">1530</dat>) Musicien, astrologue, mathématicien et médecin. - Actif de 1571 à 1586. - Frère du peintre Anthonie Blockland van Montfort [http://data.bnf.fr/ark:/12148/cb13497580p#foaf:Person]
</ud>
<ud>
Giovanni Battista Benedetti (<en type="li">Venise, Italie</en>, <dat when="1530">1530</dat>) Mathématicien et ingénieur. - Fondateur de la géométrie analytique [http://data.bnf.fr/ark:/12148/cb11998820g#foaf:Person]
</ud>
<ud>
Jean Péna (<dat when="1530">1530</dat>) Mathématicien, traducteur et éditeur de textes mathématiques et géométriques antiques [http://data.bnf.fr/ark:/12148/cb13483147k#foaf:Person]
</ud>
<ud>
Conradus Dasypodius (<en type="li">Frauenfeld, Suisse</en>, <dat when="1531">1531</dat>) Mathématicien. - A tracé le plan de l''horloge astronomique de la cathédrale de Strasbourg [http://data.bnf.fr/ark:/12148/cb16534831x#foaf:Person]
</ud>
<ud>
Ercole Bottrigari (<dat when="1531">1531</dat>) Humaniste, mathématicien, musicien, poète, linguiste et philosophe [http://data.bnf.fr/ark:/12148/cb125347809#foaf:Person]
</ud>
<ud>
Giuseppe Moletti (<dat when="1531">1531</dat>) Cosmographe et géographe. - Professeur de médecine, de mathématique et d''astronomie à l''Université de Padoue [http://data.bnf.fr/ark:/12148/cb134849518#foaf:Person]
</ud>
<ud>
Philip Apian (<en type="li">Ingoldstadt, Allemagne</en>, <dat when="1531">1531</dat>) Cartographe, mathématicien et physicien. - Fils de Peter Apian, succède à son père à l''Université d''Ingolstadt [http://data.bnf.fr/ark:/12148/cb152383864#foaf:Person]
</ud>
<ud>
Fabrizio Mordente (<en type="li">Salerne, Italie</en>, <dat when="1532">1532</dat>) Mathématicien. - A inventé le compas de proportion à huit points [http://data.bnf.fr/ark:/12148/cb14643668k#foaf:Person]
</ud>
<ud>
Egnatio Danti (<en type="li">Pérouse, Italie</en>, <dat when="1536">1536</dat>) Mathématicien, astronome, cartographe et cosmographe. - Dominicain [http://data.bnf.fr/ark:/12148/cb145332908#foaf:Person]
</ud>
<ud>
Henri de Monantheuil (<dat when="1536">1536</dat>) Mathématicien et médecin. - Régent de la Faculté de médecine de Paris, puis professeur de mathématiques au Collège de France (1574-). - Né à Reims, meurt à Paris [http://data.bnf.fr/ark:/12148/cb13006651k#foaf:Person]
</ud>
<ud>
Christophorus Clavius (<dat when="1537">1537</dat>) Jésuite, musicien et professeur de mathématiques. - Fut chargé par Grégoire XIII de la réforme du calendrier [http://data.bnf.fr/ark:/12148/cb125466080#foaf:Person]
</ud>
<ud>
Francesco Barozzi (<en type="li">Heraklion, Grèce</en>, <dat when="1537">1537</dat>) Mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb10462395x#foaf:Person]
</ud>
<ud>
Giovanni Paolo Gallucci (<en type="li">Salò, Italie</en>, <dat when="1538">1538</dat>) Astronome. - Homme de lettres [http://data.bnf.fr/ark:/12148/cb106019703#foaf:Person]
</ud>
<ud>
Philips Mor (<dat when="1539">1539</dat>) Humaniste, mathématicien et poète néolatin. - Chanoine du chapitre de St Salvator d''Utrecht. - Fils du peintre Anthonis Mor van Dashorst (Antonio Moro) [http://data.bnf.fr/ark:/12148/cb12384177f#foaf:Person]
</ud>
<ud>
François Viète (Fontenay-le-Comte (<en type="li">Vendée)</en>, <dat when="1540">1540</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb120511976#foaf:Person]
</ud>
<ud>
Cormopede (<dat when="1541">1541</dat>) Mathématicien et astrologue. - Gentilhomme de la maison du Comte de Sterckenberg. - Date de naissance présumée d''après le "portrait de Cormopede à l''âge de 51 ans" figurant au F. A. 2 de l''"Almanach des almanachs pour l''an MDXCIII" [http://data.bnf.fr/ark:/12148/cb13491791f#foaf:Person]
</ud>
<ud>
Giovanni di Strasoldo (<dat when="1544">1544</dat>) Noble. - Homme d''arme. - Mathématicien. - Poète [http://data.bnf.fr/ark:/12148/cb15122132t#foaf:Person]
</ud>
<ud>
Guidobaldo Dal Monte (<dat when="1545">1545</dat>) Mathématicien et astronome. - Protégea Galilée et lui fit obtenir sa première chaire à Pise. - Né à Pesaro, meurt dans son chateau de Monte Baroccio [http://data.bnf.fr/ark:/12148/cb135173214#foaf:Person]
</ud>
<ud>
Renward Cysat (<en type="li">Lucerne (Suisse)</en>, <dat when="1545">1545</dat>) Chancelier de la ville de Lucerne, Suisse. - Historien, dramaturge, pharmacien et naturaliste. - Père de : Cysat, Johann Baptist (1587-1653), mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb12748433g#foaf:Person]
</ud>
<ud>
Maurice Bressieu (<dat when="1546">1546</dat>) Mathématicien, philosophe et humaniste. - Titulaire de la chaire de mathématiques au Collège de France (1575-), orateur des rois de France à Rome (1586-), intendant de la Bibliothèque vaticane [http://data.bnf.fr/ark:/12148/cb13495175h#foaf:Person]
</ud>
<ud>
Tycho Brahe (<en type="li">Knudstrup (Suède)</en>, <dat when="1546">1546</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb11893749j#foaf:Person]
</ud>
<ud>
Muḥammad ibn al-Ḥusayan Bahāʼ al-Dīn ʿĀmilī (<dat when="1547">1547</dat>) Érudit arabe, philosophe, théologien, astronome, grammairien, auteur d''anthologies [http://data.bnf.fr/ark:/12148/cb12451570z#foaf:Person]
</ud>
<ud>
Nicodemus Frischlin (<en type="li">Balingen, Allemagne</en>, <dat when="1547">1547</dat>) Philologue et écrivain. - A enseigné les belles-lettres et les mathématiques à l''Université de Tubingue. - Traducteur d''Aristophane, de Callimaque et de Tryphiodore. - Auteur d''une comédie, présentée devant l''empereur Rodolphe, qui lui décerna le titre de comte-palatin [http://data.bnf.fr/ark:/12148/cb12463064b#foaf:Person]
</ud>
<ud>
Michele Zappulo (<dat when="1548">1548</dat>) Docteur en droit canon et civil. - Astronome, historien et poète [http://data.bnf.fr/ark:/12148/cb125454264#foaf:Person]
</ud>
<ud>
Simon Stevin (<en type="li">Bruges, Belgique</en>, <dat when="1548">1548</dat>) Professeur de mathématiques de Maurice de Nassau [http://data.bnf.fr/ark:/12148/cb119941019#foaf:Person]
</ud>
<ud>
Michel Coignet (<dat when="1549">1549</dat>) Ingénieur, mathématicien, fabricant d''instruments de navigation, poète [http://data.bnf.fr/ark:/12148/cb124231863#foaf:Person]
</ud>
<ud>
Francisco Sánchez (<dat when="1550">1550</dat>) Médecin, philosophe, mathématicien et poète. - Également connu sous le pseudonyme d''El Escéptico [http://data.bnf.fr/ark:/12148/cb120172346#foaf:Person]
</ud>
<ud>
Giovanni Battista Crispo (<en type="li">Gallipoli, Italie</en>, <dat when="1550">1550</dat>) Prêtre. - Mathématicien, théologien et homme de lettres [http://data.bnf.fr/ark:/12148/cb10615268s#foaf:Person]
</ud>
<ud>
John Napier (<dat when="1550">1550</dat>) Mathématicien et théologien. - Baron de Merchiston [http://data.bnf.fr/ark:/12148/cb12353925j#foaf:Person]
</ud>
<ud>
Michael Moestlin (<dat when="1550">1550</dat>) Né à Göppingen (Wurtemberg). - Mathématicien. - Astronome. - Luthérien, hostile à la réforme grégorienne du calendrier [http://data.bnf.fr/ark:/12148/cb12330628m#foaf:Person]
</ud>
<ud>
Sigfridus Aronus Forsius (<dat when="1550">1550</dat>) Astronome et astrologue finlandais [http://data.bnf.fr/ark:/12148/cb131923734#foaf:Person]
</ud>
<ud>
Aegidius Martini (<dat when="1551">1551</dat>) Cartographe, mathématicien [http://data.bnf.fr/ark:/12148/cb15376579x#foaf:Person]
</ud>
<ud>
al-Silahî Nasuh (<dat when="1551">1551</dat>) Savant, miniaturiste et calligraphe ottoman. - A écrit plusieurs ouvrages sur les armes et les combats, sur la géométrie et les mathématiques ainsi que sur l''histoire. - Inventeur du jeu de "matraque", il est mieux connu sous son surnom "Matrakçı" : "Matrakçı Nasuh Efendi", "Nasuh al-Silahî", "Matraki", "Nasuh el-Mitraki", "Nasuh üs-Silahi", "Matraqçi Nasuh", "Nasuh b. Abdullah" et "Nasuh b. Karagöz el-Bosnevi" sont parmi les autres formes de référence [http://data.bnf.fr/ark:/12148/cb119562090#foaf:Person]
</ud>
<ud>
Anthoine Cathalan (<dat when="1551">1551</dat>) Professeur de mathématiques [http://data.bnf.fr/ark:/12148/cb14526861v#foaf:Person]
</ud>
<ud>
Bartolomeo Crescenzio (<dat when="1551">1551</dat>) Mathématicien, ingénieur naval et voyageur. - Fut capitaine de galère de la marine pontificale [http://data.bnf.fr/ark:/12148/cb125466487#foaf:Person]
</ud>
<ud>
Bernardo Gamucci (<en type="li">San Gimignano, Italie</en>, <dat when="1551">1551</dat>) Archéologue, architecte et mathématicien [http://data.bnf.fr/ark:/12148/cb10435220v#foaf:Person]
</ud>
<ud>
Camillo Agrippa (<dat when="1551">1551</dat>) Philosophe, mathématicien, architecte et ingénieur. - Est aussi l''auteur de l''un des premiers traité d''escrime [http://data.bnf.fr/ark:/12148/cb12536260s#foaf:Person]
</ud>
<ud>
Claude de Boissière (<dat when="1551">1551</dat>) Mathématicien. - Auteur d''un "Art poétique" [http://data.bnf.fr/ark:/12148/cb12509709h#foaf:Person]
</ud>
<ud>
Didier Henrion (<dat when="1551">1551</dat>) Professeur de mathématiques à Paris. - Ingénieur au service des Provinces-Unies. - N''est pas un pseudonyme de Clément Cyriaque de Mangin [http://data.bnf.fr/ark:/12148/cb144882445#foaf:Person]
</ud>
<ud>
Eilhard Lubbin (<dat when="1551">1551</dat>) Cartographe et mathématicien à Rostock [http://data.bnf.fr/ark:/12148/cb153777849#foaf:Person]
</ud>
<ud>
Faustus Verantius (Sebenico aujord''hui Šibenik (<en type="li">Croatie)</en>, <dat when="1551">1551</dat>) Lexicographe, physicien et mathématicien. - Évêque de Czanad (Hongrie) (<dat when="1594">1594</dat>) et de la République de Venise. - Neveu d''Antun Vrančić (1504-1573) [http://data.bnf.fr/ark:/12148/cb10703670x#foaf:Person]
</ud>
<ud>
Francesco Feliciano (<dat when="1551">1551</dat>) Mathématicien, augustinien et miniaturiste [http://data.bnf.fr/ark:/12148/cb13485419n#foaf:Person]
</ud>
<ud>
Francis Van Schoten (<dat when="1551">1551</dat>) Professeur de mathématiques à Leyde, cartographe [http://data.bnf.fr/ark:/12148/cb15337130w#foaf:Person]
</ud>
<ud>
Francisco Zarzoso (<en type="li">Cella, Espagne</en>, <dat when="1551">1551</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb119512329#foaf:Person]
</ud>
<ud>
Giacomo Lanteri (<en type="li">Paratico, Italie</en>, <dat when="1551">1551</dat>) Mathématicien et ingénieur [http://data.bnf.fr/ark:/12148/cb104024969#foaf:Person]
</ud>
<ud>
Girolamo Mercurio (<dat when="1551">1551</dat>) Dominicain. - Médecin, professeur de logique et de mathématique [http://data.bnf.fr/ark:/12148/cb13484092c#foaf:Person]
</ud>
<ud>
Giuseppe Unicorno (<dat when="1551">1551</dat>) Mathématicien. - Philosophe. - Astrologue. - Musicologue. - Théologien. - Originaire de Bergame [http://data.bnf.fr/ark:/12148/cb125394931#foaf:Person]
</ud>
<ud>
Helisaeus Röslin (<dat when="1551">1551</dat>) Mathématicien. - Astronome. - Médecin (pratiquait à Strasbourg et Francfort) [http://data.bnf.fr/ark:/12148/cb132003253#foaf:Person]
</ud>
<ud>
Jacques Besson (<en type="li">Colombières (Italie)</en>, <dat when="1551">1551</dat>) Ingénieur et mathématicien. - Né à Colombières, vallée d''Oulx (aujourd''hui en Italie), d''après Eugénie Droz [http://data.bnf.fr/ark:/12148/cb12376654f#foaf:Person]
</ud>
<ud>
Jacques Maretz (<dat when="1551">1551</dat>) Dessinateur et graveur, mathématicien [http://data.bnf.fr/ark:/12148/cb153705873#foaf:Person]
</ud>
<ud>
Jamet Mettayer (<dat when="1551">1551</dat>) Autre(s) graphie(s) : Metayer ; Messor ; Metayerus ; Mettayier. - Variante(s) de prénom : Jean ; Jean Jamet. - Imprimeur-libraire ; imprimeur du Roi pour les mathématiques (<dat when="1580">1580</dat>) et imprimeur ordinaire du Roi (1583-1605). - En 1588, le roi Henri III le fait imprimeur officiel de sa congrégation des pénitents de l''Annonciation. De 1588 à 1594, il suit le Roi et la Cour à Blois puis  à Tours. - De retour à Paris, doit partager sa charge avec Pierre L''Huillier et Fédéric II Morel en vertu de l''arrêt du Conseil du 20 avril 1594. Revend à Tours son atelier et sa boutique à l''imprimeur Maurice Bouguereau. En mars  1596, le Roi l''associe à la Compagnie des usages avec Pierre L''Huillier. Décédé avant le 12 fév. 1605. Des publications paraissent encore sous son nom jusqu''en 1614. - A travaillé en association avec Mathurin Challenge (<dat when="1573">1573</dat>) et Barthélemy Gomet à Blois. S''associe à Tours (oct. 1591 - oct. 1593) avec Jean Richer, Claude de Monstr''oeil, Sébastien Molin, Mathieu I Guillemot, Georges Drobet et Marc Orry, son gendre. Travaille en association étroite avec Pierre L''Huillier et avec son fils Pierre Mettayer qui se trouvaient eux aussi à Tours [http://data.bnf.fr/ark:/12148/cb125031934#foaf:Person]
</ud>
<ud>
Jean Brohon (<dat when="1551">1551</dat>) Médecin, botaniste et astronome. - Fut recteur de l''Université de Caen [http://data.bnf.fr/ark:/12148/cb12545367f#foaf:Person]
</ud>
<ud>
Jean de Seville (<dat when="1551">1551</dat>) Mathématicien et hydrographe [http://data.bnf.fr/ark:/12148/cb13496046w#foaf:Person]
</ud>
<ud>
Jean Maria Coloni (<dat when="1551">1551</dat>) Citoyen de Romans en Dauphiné. - Mathématicien et astrologue [http://data.bnf.fr/ark:/12148/cb13479237s#foaf:Person]
</ud>
<ud>
Jean Tagaut (<dat when="1551">1551</dat>) Poète. - Médecin, mathématicien, professeur à Lausanne et Genève [http://data.bnf.fr/ark:/12148/cb12249180j#foaf:Person]
</ud>
<ud>
Joannes Portantius (<dat when="1551">1551</dat>) Astronome, mathématicien et géographe à Anvers, édité par Ortelius et De Jode [http://data.bnf.fr/ark:/12148/cb153817246#foaf:Person]
</ud>
<ud>
Johann Georg Locher (<dat when="1551">1551</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb13006978f#foaf:Person]
</ud>
<ud>
Juan de Rojas Sarmiento (<en type="li">Palencia, Espagne</en>, <dat when="1551">1551</dat>) Mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb140653109#foaf:Person]
</ud>
<ud>
Marc Duncan (<dat when="1551">1551</dat>) Médecin, originaire d''Écosse, s''établit à Saumur en 1606 à l''appel de l''Académie protestante de la ville. - Professeur de mathématiques, de grec et d''humanités [http://data.bnf.fr/ark:/12148/cb13006401g#foaf:Person]
</ud>
<ud>
Martin Basanier (<dat when="1551">1551</dat>) Mathématicien, musicien [http://data.bnf.fr/ark:/12148/cb12510914p#foaf:Person]
</ud>
<ud>
Martinus Hortensius (<dat when="1551">1551</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb13007384z#foaf:Person]
</ud>
<ud>
Nicolaus Reimarus Ursus (<dat when="1551">1551</dat>) Mathématicien. - Astronome [http://data.bnf.fr/ark:/12148/cb145753184#foaf:Person]
</ud>
<ud>
Paschasius Hamellius (<dat when="1551">1551</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb13173242d#foaf:Person]
</ud>
<ud>
Paul Yvon (<dat when="1551">1551</dat>) Mathématicien. - Achète la seigneurie de Laleu en 1592 et y fait construire le château. - Maire de La Rochelle en 1616. - S'' installe à Paris en décembre 1633 et abjure le protestantisme [http://data.bnf.fr/ark:/12148/cb12135021d#foaf:Person]
</ud>
<ud>
Peter Laicksteen (<dat when="1551">1551</dat>) Cartographe et astronome [http://data.bnf.fr/ark:/12148/cb15370391s#foaf:Person]
</ud>
<ud>
Phillebert Charpentier (<dat when="1551">1551</dat>) Éditeur. - Marchand d''estampes et d''instruments de mathématiques [http://data.bnf.fr/ark:/12148/cb16553551w#foaf:Person]
</ud>
<ud>
Pierre Forcadel (<dat when="1551">1551</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb103947442#foaf:Person]
</ud>
<ud>
Pierre Hérigone (<dat when="1551">1551</dat>) Professeur de mathématiques à Paris. - N''est pas un pseudonyme de Clément Cyriaque de Mangin [http://data.bnf.fr/ark:/12148/cb144882503#foaf:Person]
</ud>
<ud>
Pierre Le Voirier (<dat when="1551">1551</dat>) Autre(s) graphie(s) : Le Voirrier ; Le Verrier. - Imprimeur du Roi pour les mathématiques. - Beau-père de Mathieu I Guillemot (<dat when="1584">1584</dat>). Encore en activité le 31 déc. 1589. Décédé entre 1591 et le 7 nov. 1594 (compte de succession) [http://data.bnf.fr/ark:/12148/cb12230743m#foaf:Person]
</ud>
<ud>
Teodato Osio (<dat when="1551">1551</dat>) Mathématicien. - Musicien [http://data.bnf.fr/ark:/12148/cb125559272#foaf:Person]
</ud>
<ud>
Walther Hermann Ryff (<dat when="1551">1551</dat>) Apothicaire, médecin, mathématicien et architecte [http://data.bnf.fr/ark:/12148/cb11948264d#foaf:Person]
</ud>
<ud>
William Welwod (<dat when="1551">1551</dat>) Mathématicien. - Professeur de droit [http://data.bnf.fr/ark:/12148/cb125630488#foaf:Person]
</ud>
<ud>
Jost Bürgi (<dat when="1552">1552</dat>) Horloger, astronome et mathématicien suisse [http://data.bnf.fr/ark:/12148/cb123814270#foaf:Person]
</ud>
<ud>
Bernardino Baldi (<en type="li">Urbino, Italie</en>, <dat when="1553">1553</dat>) Abbé de Guastalla. - Poète, prosateur, mathématicien et historien. - Polyglotte, connaissait le grec et le latin, l''hébreu, l''arabe, le persan et le hongrois [http://data.bnf.fr/ark:/12148/cb12179488k#foaf:Person]
</ud>
<ud>
Jacob Christmann (<dat when="1554">1554</dat>) Orientaliste, mathématicien et astronome. - A été le premier à utiliser le télescope avec d''autres instruments comme le sextant [http://data.bnf.fr/ark:/12148/cb12560133s#foaf:Person]
</ud>
<ud>
Giovanni Antonio Magini (<en type="li">Padoue, Italie</en>, <dat when="1555">1555</dat>) Astronome, mathématicien et géographe. - A occupé la chaire d''astronomie à l''Université de Bologne en 1588. - Auteur prétendu de prédictions et de nombreux almanachs publiés en France, en Allemagne et aux Pays-Bas jusqu''au 19e siècle [http://data.bnf.fr/ark:/12148/cb12162475b#foaf:Person]
</ud>
<ud>
Jean Du Temps (<dat when="1555">1555</dat>) Fils de l''avocat Jean Du Temps I, il fut lui-même avocat et avait des connaissances en astrologie et mathématique. Frère d''Adam Du Temps, spécialiste des fortifications qui participa peut-être à la carte du Blésois dont il est l''auteur [http://data.bnf.fr/ark:/12148/cb15302460t#foaf:Person]
</ud>
<ud>
Sethus Calvisius (<dat when="1556">1556</dat>) Organiste, compositeur et théoricien de la musique ; astronome ; historien ; libraire et éditeur de musique. - Natif de Gorsleben près de Sachsenburg (Thuringe) et issu d''une famille paysanne. Après des études aux universités de Leipzig et Helmstedt, il devient à partir de 1581 et jusqu''à sa mort "cantor" de plusieurs églises de Leipzig successivement. Auteur de plusieurs ouvrages théoriques et compositions musicales, ainsi que d''un "Opus chronologicum" (1605 ; au moins 6 rééd.) et d''un "Elenchus calendarii Gregoriani" (<dat when="1612">1612</dat>). Décédé à Leipzig en nov. 1615. À distinguer du pasteur et prédicateur de Quedlinburg Sethus Calvisius (ou : Seth Kal(l)witz) (1639-1698), parfois appelé à tort "Sethus Calvisius le fils" [http://data.bnf.fr/ark:/12148/cb12875550d#foaf:Person]
</ud>
<ud>
Guillaume de Nautonier (<dat when="1557">1557</dat>) Savant, mathématicien, astronome, d''origine protestante, géographe du roi Henri IV [http://data.bnf.fr/ark:/12148/cb12412403z#foaf:Person]
</ud>
<ud>
Christoph Meurer (<dat when="1558">1558</dat>) Professeur de mathématiques à Leipzig (<dat when="1613">1613</dat>). - Médecin [http://data.bnf.fr/ark:/12148/cb14333201g#foaf:Person]
</ud>
<ud>
Jean-Édouard Du Monin (<dat when="1559">1559</dat>) Mathématicien et spécialiste des langues anciennes. - Fut professeur à Paris, puis à Poitiers [http://data.bnf.fr/ark:/12148/cb12463074n#foaf:Person]
</ud>
<ud>
Thomas Hariot (<en type="li">Oxford, GB</en>, <dat when="1560">1560</dat>) Mathématicien et astronome. - Envoyé comme conseiller aux Amériques en 1585-86 [http://data.bnf.fr/ark:/12148/cb12215671c#foaf:Person]
</ud>
<ud>
Thomas Harriot (<dat when="1560">1560</dat>) Mathématicien, physicien et astronome anglais [http://data.bnf.fr/ark:/12148/cb124346111#foaf:Person]
</ud>
<ud>
Adrianus Romanus (<en type="li">Louvain</en>, <dat when="1561">1561</dat>) Médecin, mathématicien et voyageur. - Enseigna à Louvain et à Würzburg, fut mathématicien royal en Pologne [http://data.bnf.fr/ark:/12148/cb12459969s#foaf:Person]
</ud>
<ud>
Bartholomäus Pitiscus (<dat when="1561">1561</dat>) A aussi écrit en latin. - Prédicateur protestant à la cour de l''Électeur palatin. - Également auteur d''ouvrages mathématiques [http://data.bnf.fr/ark:/12148/cb121457326#foaf:Person]
</ud>
<ud>
Henry Briggs (<dat when="1561">1561</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb12305061c#foaf:Person]
</ud>
<ud>
Jean Tarde (La Roque-Gageac (<en type="li">Dordogne)</en>, <dat when="1561">1561</dat>) Mathématicien, historien, géographe et astronome. - Chanoine [http://data.bnf.fr/ark:/12148/cb12641353z#foaf:Person]
</ud>
<ud>
Jean Tarde (<dat when="1561">1561</dat>) Chanoine de Sarlat, mathématicien et cartographe [http://data.bnf.fr/ark:/12148/cb153143878#foaf:Person]
</ud>
<ud>
P. Christoph Grienberger (<dat when="1561">1561</dat>) Jésuite, mathématicien, astronome et architecte. Il a realisé les plans du Collège d''Aurillac et du Charleville [http://data.bnf.fr/ark:/12148/cb10686921r#foaf:Person]
</ud>
<ud>
Philippus Lansbergen (<en type="li">Gand (Belgique)</en>, <dat when="1561">1561</dat>) Mathématicien, astronome et pasteur [http://data.bnf.fr/ark:/12148/cb130073828#foaf:Person]
</ud>
<ud>
Christen Sørensen Longomontanus (<dat when="1562">1562</dat>) Astronome et mathématicien. - Fut l''élève de Tycho-Brahé. - Professeur de hautes mathématiques à l''Université de Copenhague [http://data.bnf.fr/ark:/12148/cb13011001c#foaf:Person]
</ud>
<ud>
Guangqi Xu (<en type="li">Shanghai</en>, <dat when="1562">1562</dat>) Haut fonctionnaire chinois, initié et converti au christianisme par le père jésuite Matteo Ricci. - Mathématicien. - Astronome. - Disciple de Matteo Ricci [http://data.bnf.fr/ark:/12148/cb150892932#foaf:Person]
</ud>
<ud>
Galileo Galilei (<en type="li">Pise, Italie</en>, <dat when="1564">1564</dat>) Physicien, philosophe, astronome [http://data.bnf.fr/ark:/12148/cb11903931b#foaf:Person]
</ud>
<ud>
Luis Teixeira (<dat when="1564">1564</dat>) Jésuite portugais, mathématicien et cartographe actif de 1564 à 1613 [http://data.bnf.fr/ark:/12148/cb153361957#foaf:Person]
</ud>
<ud>
Edward Brerewood (<dat when="1565">1565</dat>) Antiquaire et mathématicien, linguiste et humaniste. - Professeur d''astronomie au Gresham college de Londres [http://data.bnf.fr/ark:/12148/cb125109678#foaf:Person]
</ud>
<ud>
Eilhard Lubin (<dat when="1565">1565</dat>) Humaniste, philologue, cartographe, théologien et mathématicien [http://data.bnf.fr/ark:/12148/cb15040859j#foaf:Person]
</ud>
<ud>
Paolo Antonio Foscarini (<en type="li">Montalto Uffugo, Italie</en>, <dat when="1565">1565</dat>) Carme. - Théologien. - Mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb12377530d#foaf:Person]
</ud>
<ud>
Scipione Chiaramonti (<en type="li">Cesena, Italie</en>, <dat when="1565">1565</dat>) Astronome et philosophe. - Professeur de philosophie à l''Université de Pise [http://data.bnf.fr/ark:/12148/cb10545041n#foaf:Person]
</ud>
<ud>
Fr. François d'' Aguillon (<dat when="1566">1566</dat>) Jésuite, architecte et mathématicien. Auteur d''un projet pour le noviciat de Tournai. Préposé de la Maison professe, professeur d''Anvers [http://data.bnf.fr/ark:/12148/cb16240952w#foaf:Person]
</ud>
<ud>
Georg Ludwig Frobenius (<dat when="1566">1566</dat>) Libraire. - Natif d''Iphofen, près de Wurzbourg. Titulaire d''une maîtrise de théologie. Après des études aux universités de Tübingen et Wittenberg, travaille avec l''astronome Tycho Brahe jusqu''à la mort de celui-ci. Reçu ensuite bourgeois de Hambourg, où il s''établit libraire [http://data.bnf.fr/ark:/12148/cb12229506t#foaf:Person]
</ud>
<ud>
Marco Antonio De Dominis (l''île de Rab (<en type="li">Croatie)</en>, <dat when="1566">1566</dat>) Professeur de rhétorique, mathématiques et philosophie dans la Compagnie de Jésus, à Padoue et Brescia. - Evêque de Segna (Senj ou Zengg en Croatie) de 1600 à 1602; de Spalato (Split) de 1602 à 1615. - Gagné au protestantisme et exilé en Angleterre, doyen de Windsor. - Abjure et rentre en grâce (<dat when="1622">1622</dat>) [http://data.bnf.fr/ark:/12148/cb121335726#foaf:Person]
</ud>
<ud>
Marinus Ghetaldus (Raguse aujourd''hui Dubrovnik (<en type="li">Croatie)</en>, <dat when="1566">1566</dat>) Mathématicien et physicien. - Il exerça une grande influence sur le développement de l''application de l''algèbre à la géométrie. - Il mit au point le miroir parabolique, aujourd''hui conservé au National Maritime Museum de Londres. - Il collabora, entre autres, avec François Viète en France et avec Galilée en Italie [http://data.bnf.fr/ark:/12148/cb146476018#foaf:Person]
</ud>
<ud>
François de Aguilón (<dat when="1567">1567</dat>) Architecte et mathématicien belge d''origine espagnole [http://data.bnf.fr/ark:/12148/cb119998212#foaf:Person]
</ud>
<ud>
Johann Hartmann (<dat when="1568">1568</dat>) Mathématicien et naturaliste. - Professeur de chimie à l''Université de Marburg [http://data.bnf.fr/ark:/12148/cb13009199x#foaf:Person]
</ud>
<ud>
P. Jacques de Guernisac (<dat when="1568">1568</dat>) Jésuite et architecte, professeur de mathématique à Pont-à-Mousson puis à La Flèche, recteur du collège des Jésuites de Quimper [http://data.bnf.fr/ark:/12148/cb16215104d#foaf:Person]
</ud>
<ud>
Mutio Oddi (<dat when="1569">1569</dat>) Mathématicien. - Architecte [http://data.bnf.fr/ark:/12148/cb165299645#foaf:Person]
</ud>
<ud>
Andrea Argoli (<dat when="1570">1570</dat>) Mathématicien. - Astronome. - Professeur de mathématique à l''Université de Padoue [http://data.bnf.fr/ark:/12148/cb121593328#foaf:Person]
</ud>
<ud>
Erasmus Schmied (<dat when="1570">1570</dat>) Né à Delitzsch, près de Leipzig. - Professeur de grec et de mathématiques à Wittenberg [http://data.bnf.fr/ark:/12148/cb12045847b#foaf:Person]
</ud>
<ud>
Anders Bure (<dat when="1571">1571</dat>) Cartographe et mathématicien [http://data.bnf.fr/ark:/12148/cb14509982d#foaf:Person]
</ud>
<ud>
Giovanni Branca (<dat when="1571">1571</dat>) Architecte, ingénieur et mathématicien. - Né à Pesaro, meurt à Pérouse [http://data.bnf.fr/ark:/12148/cb121826472#foaf:Person]
</ud>
<ud>
Johannes Isaacus Pontanus (<en type="li">Elseneur (Danemark)</en>, <dat when="1571">1571</dat>) Historien. - Philologue. - Professeur de mathématiques et de physique [http://data.bnf.fr/ark:/12148/cb123875836#foaf:Person]
</ud>
<ud>
Johannes Kepler (<dat when="1571">1571</dat>) Astronome et mathématicien [http://data.bnf.fr/ark:/12148/cb11909597m#foaf:Person]
</ud>
<ud>
Willem Jansz Blaeu (<dat when="1571">1571</dat>) Autre(s) graphie(s) : Janssonius Blaeuw. - Imprimeur-libraire et éditeur de cartes et d''atlas. - Originaire d''Alkmaar ou des environs. Passe 2 ans auprès de Tycho Brahé au Danemark. À son retour à Amsterdam en 1596, s''établit cartographe et fabricant de globes terrestres et célestes. Monte ensuite une imprimerie et une fonderie. Également auteur d''ouvrages cartographiques et astronomiques [http://data.bnf.fr/ark:/12148/cb12169772t#foaf:Person]
</ud>
<ud>
Cornelius Drebbel (<dat when="1572">1572</dat>) Graveur. - Mathématicien. - Physicien. - Chimiste [http://data.bnf.fr/ark:/12148/cb12382467g#foaf:Person]
</ud>
<ud>
Rodolphus Goclenius (<dat when="1572">1572</dat>) Docteur en médecine en 1601. - Professeur de physique en 1608. - Professeur de mathématiques à l''Université de Marbourg en 1621 [http://data.bnf.fr/ark:/12148/cb121595722#foaf:Person]
</ud>
<ud>
Samuel Marolois (<dat when="1572">1572</dat>) Mathématicien français ayant vécu une grande partie de sa vie aux Pays-Bas [http://data.bnf.fr/ark:/12148/cb14912871p#foaf:Person]
</ud>
<ud>
Thomas Lydyat (<en type="li">Okerton, GB</en>, <dat when="1572">1572</dat>) Mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb12390032f#foaf:Person]
</ud>
<ud>
Christoph Scheiner (<dat when="1575">1575</dat>) Jésuite. - Physicien, mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb13483688j#foaf:Person]
</ud>
<ud>
Michelangelo Galilei (<dat when="1575">1575</dat>) Luthiste et compositeur italien de la Renaissance. - Fils du compositeur et théoricien Vincenzo Galilei, et frère de l''astronome Galileo Galilei [http://data.bnf.fr/ark:/12148/cb140013401#foaf:Person]
</ud>
<ud>
Octavio Pisani (<en type="li">Naples, Italie</en>, <dat when="1575">1575</dat>) Cosmographe et astronome, travaille à Anvers de 1612 à 1637 [http://data.bnf.fr/ark:/12148/cb15404394h#foaf:Person]
</ud>
<ud>
Francesco Ingoli (<en type="li">Ravenne (Italie)</en>, <dat when="1578">1578</dat>) Secrétaire de la propagande, débat avec Copernic (en 1616 et 1624) et écrit Relazione delle quattro parti del mondo avec pour objectif de soutenir missions et propagande religieuses. - Étudie l''astronomie, la cosmographie et la géographie et connait le grec, le français, l''espagnon et l''arabe. - Diplômé en droit civil et en droit canon à l''Université de Padoue, Italie [http://data.bnf.fr/ark:/12148/cb13749501h#foaf:Person]
</ud>
<ud>
Sybrandt Hansz. Cardinael (Harlingen (Pays-Bas), <dat when="1578">1578</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb15944052f#foaf:Person]
</ud>
<ud>
Cristóvão Ferreira (<dat when="1580">1580</dat>) Supérieur et procurateur de la mission jésuite au Japon, il abjura en 1633 et se convertit au zen. - Auteur en 1636 de la "Supercherie dévoilée". - Traducteur d''ouvrages d''astronomie et de chirurgie [http://data.bnf.fr/ark:/12148/cb13524212c#foaf:Person]
</ud>
<ud>
Godfried Wendelen (<dat when="1580">1580</dat>) Astronome et géomètre. - Avocat au Parlement de Paris puis doyen du chapitre de Rothnac, Belgique [http://data.bnf.fr/ark:/12148/cb123969373#foaf:Person]
</ud>
<ud>
Joannes Michael Gigas (<dat when="1580">1580</dat>) Docteur, mathématicien et géographe édité par Blaeu et Hondius [http://data.bnf.fr/ark:/12148/cb153239798#foaf:Person]
</ud>
<ud>
Johann Faulhaber (<dat when="1580">1580</dat>) Mathématicien allemand. S''est aussi intéressé à l''ingénierie des fortifications [http://data.bnf.fr/ark:/12148/cb137778453#foaf:Person]
</ud>
<ud>
Nicolas-Claude Fabri Peiresc (<en type="li">Belgentier (Var)</en>, <dat when="1580">1580</dat>) Conseiller au Parlement de Provence. - Astronome, archéologue et naturaliste [http://data.bnf.fr/ark:/12148/cb11918940q#foaf:Person]
</ud>
<ud>
Willebrordus Snellius (Leyde, Pays-Bas, <dat when="1580">1580</dat>) Mathématicien, astronome et géographe [http://data.bnf.fr/ark:/12148/cb15336105f#foaf:Person]
</ud>
<ud>
Claude-Gaspard Bachet (Bourg-en-Bresse (<en type="li">Ain)</en>, <dat when="1581">1581</dat>) Mathématicien et littérateur. - Sieur de Méziriac. - Érudit, auteur de poèmes en français, italien et latin. - Membre de l''Académie française (élu en 1634) [http://data.bnf.fr/ark:/12148/cb120028244#foaf:Person]
</ud>
<ud>
Alexandre Anderson (<dat when="1582">1582</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb16296598k#foaf:Person]
</ud>
<ud>
Jean François (<dat when="1582">1582</dat>) Nom en religion de Jean Charnage. - Jésuite. - Professeur de philosophie et de mathématiques à La Flèche [http://data.bnf.fr/ark:/12148/cb121629197#foaf:Person]
</ud>
<ud>
Mario Bettini (<en type="li">Bologne, Italie</en>, <dat when="1582">1582</dat>) Jésuite. - Philosophe et mathématicien [http://data.bnf.fr/ark:/12148/cb12545452p#foaf:Person]
</ud>
<ud>
Matthias Bernegger (<en type="li">Hallstatt (Autriche)</en>, <dat when="1582">1582</dat>) Philologue, historien, mathématicien et astronome. - Protestant. - Professeur d''histoire et d''éloquence à Strasbourg, recteur de l''Université de cette même ville [http://data.bnf.fr/ark:/12148/cb129928534#foaf:Person]
</ud>
<ud>
Jean-Baptiste Morin (Villefranche-sur-Saône (<en type="li">Rhône)</en>, <dat when="1583">1583</dat>) Astronome et mathématicien [http://data.bnf.fr/ark:/12148/cb11916881j#foaf:Person]
</ud>
<ud>
Orazio Grassi (<en type="li">Savone, Italie</en>, <dat when="1583">1583</dat>) Jésuite. - Mathématicien, astronome et architecte [http://data.bnf.fr/ark:/12148/cb125377863#foaf:Person]
</ud>
<ud>
Filippo Finella (<en type="li">Naples, Italie</en>, <dat when="1584">1584</dat>) Astrologue. - Astronome. - Auteur dramatique [http://data.bnf.fr/ark:/12148/cb122006609#foaf:Person]
</ud>
<ud>
Grégoire de Saint-Vincent (<dat when="1584">1584</dat>) Mathématicien. - Astronome [http://data.bnf.fr/ark:/12148/cb16197665z#foaf:Person]
</ud>
<ud>
James Hume (<dat when="1584">1584</dat>) Mathématicien. - Astronome. - Historien. - Hébraïsant. - Actif en 1639. - A vécu à Paris. - Fils de David Hume (1558-163.) et frère aîné de la poétesse et traductrice Anna Hume (1586?-16..) [http://data.bnf.fr/ark:/12148/cb12072629r#foaf:Person]
</ud>
<ud>
Claude Mydorge (<dat when="1585">1585</dat>) Mathématicien et physicien [http://data.bnf.fr/ark:/12148/cb144888873#foaf:Person]
</ud>
<ud>
Mario Guiducci (<en type="li">Florence, Italie</en>, <dat when="1585">1585</dat>) Homme de lettres et astronome. - A collaboré avec Galileo Galilei [http://data.bnf.fr/ark:/12148/cb144609004#foaf:Person]
</ud>
<ud>
Melchior Inchofer (<en type="li">Vienne</en>, <dat when="1585">1585</dat>) Jésuite. - Philosophe, mathématicien et théologien professeur à Messine, Italie [http://data.bnf.fr/ark:/12148/cb10735485h#foaf:Person]
</ud>
<ud>
Philipp Müller (<dat when="1585">1585</dat>) Mathématicien, médecin, chimiste et botaniste. - Professeur à l''université de Leipzig [http://data.bnf.fr/ark:/12148/cb14065362j#foaf:Person]
</ud>
<ud>
Jean L''Hoste (<en type="li">Nancy</en>, <dat when="1586">1586</dat>) Ingénieur. - Intendant des fortifications du duc de Lorraine. - Professeur de droit et de mathématiques à Pont-à-Mousson [http://data.bnf.fr/ark:/12148/cb16628764j#foaf:Person]
</ud>
<ud>
Niccolò Zucchi (<en type="li">Parme, Italie</en>, <dat when="1586">1586</dat>) Jésuite. - Recteur du Collegio romano (1646-1649). - Astronome [http://data.bnf.fr/ark:/12148/cb10077816w#foaf:Person]
</ud>
<ud>
Benedetto Castelli (<en type="li">Brescia, Italie</en>, <dat when="1587">1587</dat>) Dominicain. - Mathématicien, inventeur et écrivain. - Disciple de Galilée, dont il défendit les théories astronomiques [http://data.bnf.fr/ark:/12148/cb12545385c#foaf:Person]
</ud>
<ud>
Joachim Jungius (<dat when="1587">1587</dat>) Naturaliste, mathématicien et philosophe [http://data.bnf.fr/ark:/12148/cb120247195#foaf:Person]
</ud>
<ud>
Libert Froidmont (<en type="li">Liège</en>, <dat when="1587">1587</dat>) Théologien. - Mathématicien, physicien et géologue [http://data.bnf.fr/ark:/12148/cb14462868z#foaf:Person]
</ud>
<ud>
François Derand (<dat when="1588">1588</dat>) Jésuite. - Professeur de grammaire et de mathématiques. - Architecte. - Né à Vic s/Seille (Moselle), mort à Agde (Hérault) [http://data.bnf.fr/ark:/12148/cb13012148j#foaf:Person]
</ud>
<ud>
Jacques Grandami (<dat when="1588">1588</dat>) Jésuite. - Professeur de belles lettres, de philosophie et de théologie, puis recteur de Bourges, Rennes, La Flèche, Tours et Rouen. - Visiteur de la province de France. - Astronome [http://data.bnf.fr/ark:/12148/cb12155155d#foaf:Person]
</ud>
<ud>
Marin Mersenne (<dat when="1588">1588</dat>) Philosophe et savant, astronome, mathématicien. - Théoricien de la musique. - Minime [http://data.bnf.fr/ark:/12148/cb119157157#foaf:Person]
</ud>
<ud>
Eberhard Welper (<dat when="1590">1590</dat>) Imprimeur-libraire. - Natif de Lohra (comté de Lohenstein, près de Marburg, Allemagne). Mathématicien, astrologue et astronome, il se fixe à Strasbourg en 1618. Établi libraire en 1620 puis imprimeur dès 1621. Publie notamment chaque année un almanach et des prédictions. Auteur de plusieurs ouvrages scientifiques, dont des "Elementa geometrica..." (1re éd., <dat when="1620">1620</dat>), une "Gnomonica" (<dat when="1625">1625</dat>), un "Compendium astronomiae..." (<dat when="1634">1634</dat>) et un traité de la divination, "Rota-Fortunae, oder Glück-Rad..." (s. d., plusieurs rééd.). De 1634 à 1639, assure des fonctions d''enseignant au Gymnase (lycée) de Strasbourg. En 1654, sollicite en vain la charge d''imprimeur de l''évêché de Saverne. De 1653 à 1661, imprime sous le pseudonyme de Hartmann Bär quelques ouvrages pour l''académie des Jésuites à Molsheim. Son fils aîné Johann Welper (1642-1720) lui succède en 1664, mais des éditions paraissent encore sous son nom en 1689. Son autre fils Eberhard (II) Welper (1644-1670) sera lui aussi mathématicien, astrologue et astronome [http://data.bnf.fr/ark:/12148/cb158750586#foaf:Person]
</ud>
<ud>
Johannes Wilhelm Lauremberg (<dat when="1590">1590</dat>) Auteur, mathématicien et historien à Rostock [http://data.bnf.fr/ark:/12148/cb15377794m#foaf:Person]
</ud>
<ud>
Jean Leurechon (Bar-le-Duc, <dat when="1591">1591</dat>) Jésuite. - Professeur de philosophie et de mathématiques, à Pont-à-Mousson notamment. - Confesseur du duc de Lorraine Charles IV. - Henry Van Etten, qui signe la dédicace de la première édition des "Récréations mathématiques" n''est pas un pseudonyme de Jean Leurechon, mais le nom d''un de ses élèves, qui aurait réellement existé d''après Trevor H. Hall [http://data.bnf.fr/ark:/12148/cb13009618g#foaf:Person]
</ud>
<ud>
Joseph Salomon Delmedigo (<dat when="1591">1591</dat>) Médecin. - Astronome. - Mathématicien. - Né en Crète. - Fils d''Eliya Delmedigo (1460-1497) [http://data.bnf.fr/ark:/12148/cb122623548#foaf:Person]
</ud>
<ud>
Giovanni Battista Vertova (<en type="li">Bergame, Italie</en>, <dat when="1592">1592</dat>) Mathématicien et ingénieur militaire. - Chevalier de l''Ordre de Malte [http://data.bnf.fr/ark:/12148/cb15093021d#foaf:Person]
</ud>
<ud>
Johann Adam Schall von Bell (<dat when="1592">1592</dat>) Jésuite. - Missionnaire en Chine (de 1619 à sa mort). - Mathématicien. - Conseiller et astronome de la Cour impériale de Chine [http://data.bnf.fr/ark:/12148/cb12362941r#foaf:Person]
</ud>
<ud>
Pierre Gassendi (<en type="li">Champtercier, près de Digne</en>, <dat when="1592">1592</dat>) Philosophe, astronome, mathématicien, physicien, docteur en théologie et théoricien de la musique. - Entre dans les ordres en 1615 [http://data.bnf.fr/ark:/12148/cb120250393#foaf:Person]
</ud>
<ud>
Wilhelm Schickard (<en type="li">Herrenberg, Allemagne</en>, <dat when="1592">1592</dat>) Mathématicien, astronome, professeur d''agriculture [http://data.bnf.fr/ark:/12148/cb11969696s#foaf:Person]
</ud>
<ud>
Albert Girard (Saint-Mihiel, <dat when="1595">1595</dat>) Mathématicien et ingénieur. - Ingénieur dans l''armée de Frédéric de Nassau, prince d''Orange [http://data.bnf.fr/ark:/12148/cb121123333#foaf:Person]
</ud>
<ud>
Pierre Bardin (<en type="li">Rouen</en>, <dat when="1595">1595</dat>) Homme de lettres, philosophe et mathématicien. - Précepteur. - Membre de l''Académie française (élu en 1634) [http://data.bnf.fr/ark:/12148/cb125272379#foaf:Person]
</ud>
<ud>
Pierre Bourdin (<dat when="1595">1595</dat>) Jésuite. - Professeur de mathématiques [http://data.bnf.fr/ark:/12148/cb123902440#foaf:Person]
</ud>
<ud>
Daniel Mögling (<en type="li">Böblingen</en>, <dat when="1596">1596</dat>) Alchimiste, rosicrucien, médecin et astronome [http://data.bnf.fr/ark:/12148/cb167575369#foaf:Person]
</ud>
<ud>
Jacob Golius (<dat when="1596">1596</dat>) Orientaliste. - Mathématicien. - Philologue, spécialiste des littératures [http://data.bnf.fr/ark:/12148/cb123338386#foaf:Person]
</ud>
<ud>
René Descartes (Descartes (Indre-et-Loire), <dat when="1596">1596</dat>) Philosophe et mathématicien [http://data.bnf.fr/ark:/12148/cb11899775j#foaf:Person]
</ud>
<ud>
Giovanni Battista Hodierna (<dat when="1597">1597</dat>) Astronome italien [http://data.bnf.fr/ark:/12148/cb120704558#foaf:Person]
</ud>
<ud>
Bonaventura Cavalieri (<en type="li">Milan, Italie</en>, <dat when="1598">1598</dat>) Jésuite. - Mathématicien, géomètre et astronome, disciple de Galilée. - Fut professeur à l''Université de Bologne [http://data.bnf.fr/ark:/12148/cb12085151g#foaf:Person]
</ud>
<ud>
Giovanni Battista Riccioli (<en type="li">Ferrare, Italie</en>, <dat when="1598">1598</dat>) Jésuite. - Astronome. - Professeur de lettres, de philosophie et de théologie, à Parme puis à Bologne. - Mathématicien et historien de la géographie [http://data.bnf.fr/ark:/12148/cb12546680q#foaf:Person]
</ud>
<ud>
Pierre Petit (<dat when="1598">1598</dat>) Mathématicien et physicien. - Intendant général des ports et fortifications de France (<dat when="1649">1649</dat>) [http://data.bnf.fr/ark:/12148/cb123944733#foaf:Person]
</ud>
<ud>
Adam Olearius (<en type="li">Aschersleben, Allemagne</en>, <dat when="1599">1599</dat>) Voyageur, en particulier en Russie et en Perse. - Mathématicien [http://data.bnf.fr/ark:/12148/cb12817277v#foaf:Person]
</ud>
<ud>
Jacob Aertsz Colom (<dat when="1599">1599</dat>) Mathématicien, navigateur et cartographe. - Imprimeur à Amsterdam [http://data.bnf.fr/ark:/12148/cb153358650#foaf:Person]
</ud>
<ud>
Adriaan Vlacq (<dat when="1600">1600</dat>) Autre(s) graphie(s) : Ulack ; Vlac. - Variante(s) de prénom : Adriaen ; Adrien. - Imprimeur-libraire. - Originaire de Gouda. Édite différents périodiques dont "De Haegsche Vrijdaeghse Post-Tijdingen". A publié en 1659 une contrefaçon de Johannes Elzevier et de Pieter Leffen. A également publié sous les fausses adresses et pseudonymes de "Cologne, Pierre Du Marteau" et "Amsterdam, Peter Le Grand". - Également mathématicien connu pour ses travaux sur les logarithmes et auteur d''ouvrages d''astronomie et de pamphlets en faveur des royalistes anglais en 1652-1655. Mort peu avant le 8 avril 1667. Des éd. paraissent encore sous son nom jusqu''en 1669, en association avec Johannes Vlacq [http://data.bnf.fr/ark:/12148/cb121635061#foaf:Person]
</ud>
<ud>
Antoine de Laloubère (<dat when="1600">1600</dat>) Jésuite. - Mathématicien et géomètre, fut le premier scientifique à étudier les propriétés de l''hélice. - Polémiqua avec Pascal, qui l''appelle "Allouerus" dans l''"Histoire de la roulette". - Professeur de rhétorique, de théologie et de mathématiques au collège de Toulouse. - Né à Rieux, meurt à Toulouse [http://data.bnf.fr/ark:/12148/cb13006798h#foaf:Person]
</ud>
<ud>
Giacomo Oddi (<dat when="1600">1600</dat>) Cartographe et mathématicien. Etudie à Naples [http://data.bnf.fr/ark:/12148/cb153917817#foaf:Person]
</ud>
<ud>
Jakob Bartsch (<dat when="1600">1600</dat>) Médecin. - Professeur de mathématiques à Strasbourg. - Astronome. - Gendre et collaborateur de l''astronome Johann Kepler (1571-1630) [http://data.bnf.fr/ark:/12148/cb12163632v#foaf:Person]
</ud>
<ud>
Emmanuel Maignan (<dat when="1601">1601</dat>) Religieux minime. - Philosophe, mathématicien et peintre. - Membre de la Société des lanternistes [http://data.bnf.fr/ark:/12148/cb130127157#foaf:Person]
</ud>
<ud>
Florimond de Beaune (<dat when="1601">1601</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb11890827s#foaf:Person]
</ud>
<ud>
Ovidio Montalbani (<dat when="1601">1601</dat>) Docteur en philosophie et médecine de l'' Université de Bologne, professeur de mathématiques, chargé du musée Aldrovandi à partir de 1657, fut aussi un citoyen actif de Bologne, où il assura plusieurs magistratures ("giudice del Foro de mercanti, e de tribuni della plebe"). - Membre de l''Accademia dei Gelati de Bologne ("l''Innestato"), de l''Accademia degli Indomiti de Bologne ("lo Stellato"), et de l''Accademia della Notte de Bologne ("il Rugiadoso") [http://data.bnf.fr/ark:/12148/cb12064289s#foaf:Person]
</ud>
<ud>
Pierre de Fermat (Beaumont-de-Lomagne (Tarn-et-Garonne), <dat when="1601">1601</dat>) Mathématicien, célèbre pour son théorème. - On lui doit aussi le Principe de Fermat en optique. - Conseiller au Parlement de Toulouse et commissaire en la chambre des requêtes du Palais à Toulouse (mai 1631) [http://data.bnf.fr/ark:/12148/cb11902568b#foaf:Person]
</ud>
<ud>
Athanasius Kircher (<en type="li">Geisa (Allemagne)</en>, <dat when="1602">1602</dat>) Jésuite. - Professeur de physique, de mathématiques et de langues orientales, Collegio Romano, Rome. - Dessinateur et graveur [http://data.bnf.fr/ark:/12148/cb119097824#foaf:Person]
</ud>
<ud>
Gilles Personne de Roberval (<en type="li">Roberval, Oise</en>, <dat when="1602">1602</dat>) Professeur de philosophie (<dat when="1634">1634</dat>) et de mathématiques (<dat when="1655">1655</dat>) au Collège royal, Paris. - Membre fondateur de l''Académie royale des sciences [http://data.bnf.fr/ark:/12148/cb12144923j#foaf:Person]
</ud>
<ud>
Jacques de Billy (<dat when="1602">1602</dat>) Jésuite (à partir de 1619). - Mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb123773436#foaf:Person]
</ud>
<ud>
John Greaves (<en type="li">Colemore, GB</en>, <dat when="1602">1602</dat>) Mathématicien. - Orientaliste. - Professeur d''astronomie à Londres puis à Oxford [http://data.bnf.fr/ark:/12148/cb129277690#foaf:Person]
</ud>
<ud>
Pierre Gautruche (<dat when="1602">1602</dat>) Jésuite. - Professeur de philosophie, de théologie et de mathématiques. - Identifié par certains à Pierre Gautier (1599-16..), luthiste et compositeur [http://data.bnf.fr/ark:/12148/cb121990328#foaf:Person]
</ud>
<ud>
Blaise-François de Pagan (<en type="li">Avignon</en>, <dat when="1604">1604</dat>) Ingénieur et astronome [http://data.bnf.fr/ark:/12148/cb12155087r#foaf:Person]
</ud>
<ud>
Claude Hardy (<dat when="1604">1604</dat>) Fils de Sébastien Hardy. - Conseiller au Châtelet. - Mathématicien. - Ami de Mydorge, Descartes et du Père Mersenne ; souvent cité dans la correspondance de ces deux derniers [http://data.bnf.fr/ark:/12148/cb12134536k#foaf:Person]
</ud>
<ud>
Bernard Frénicle de Bessy (<dat when="1605">1605</dat>) Mathématicien, géomètre et arithméticien. - Membre de l''Académie des Sciences. - Conseiller à la Cour des monnaies [http://data.bnf.fr/ark:/12148/cb12459881c#foaf:Person]
</ud>
<ud>
Ismaël Boulliau (<en type="li">Loudun (Vienne)</en>, <dat when="1605">1605</dat>) Astronome. - Secrétaire de Jacques Du Puy et attaché au président de Thou [http://data.bnf.fr/ark:/12148/cb124621511#foaf:Person]
</ud>
<ud>
Juan de Caramuel y Lobkowitz (<en type="li">Madrid</en>, <dat when="1606">1606</dat>) Cistercien. - Evêque de Satriano et Campagna (1657-1673) puis de Vigevano (1673-). - Humaniste, théologien, mathématicien, philosophe et architecte. - Défenseur de la doctrine probabiliste [http://data.bnf.fr/ark:/12148/cb12392566m#foaf:Person]
</ud>
<ud>
Evangelista Torricelli (<en type="li">Faenza, Italie</en>, <dat when="1608">1608</dat>) Physicien et mathématicien [http://data.bnf.fr/ark:/12148/cb12117674q#foaf:Person]
</ud>
<ud>
Gaspar Schott (<en type="li">Königshaufen, Allemagne</en>, <dat when="1608">1608</dat>) Mathématicien et physicien. - Jésuite [http://data.bnf.fr/ark:/12148/cb12519717b#foaf:Person]
</ud>
<ud>
Giovanni Alfonso Borelli (<en type="li">Naples, Italie</en>, <dat when="1608">1608</dat>) Mathématicien, phycisien, médecin, philosophe. - Membre de l''Accademia del Cimento [http://data.bnf.fr/ark:/12148/cb12462534j#foaf:Person]
</ud>
<ud>
Giovan Battista Nicolosi (<en type="li">Paternò, Italie</en>, <dat when="1610">1610</dat>) Géographe et cartographe. - Professeur de mathématiques et de géographie à l''Université de Rome [http://data.bnf.fr/ark:/12148/cb15404103t#foaf:Person]
</ud>
<ud>
Józef Naronowicz-Naroński (<dat when="1610">1610</dat>) Mathématicien. - Cartographe. - Architecte au service de la famille Radzwill. - Né en Lituanie [http://data.bnf.fr/ark:/12148/cb150812338#foaf:Person]
</ud>
<ud>
Maria Cunitia (<dat when="1610">1610</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb162514419#foaf:Person]
</ud>
<ud>
Jan Heweliusz (<dat when="1611">1611</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb121054498#foaf:Person]
</ud>
<ud>
John Pell (<dat when="1611">1611</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb146515879#foaf:Person]
</ud>
<ud>
Michael Floris Van Langren (<dat when="1612">1612</dat>) Astronome et mathématicien du roi d''Espagne installé à Bruxelles [http://data.bnf.fr/ark:/12148/cb153283774#foaf:Person]
</ud>
<ud>
Francesco Maria Grimaldi (<dat when="1613">1613</dat>) Jésuite. - Philosophe, astronome, opticien et professeur de mathématiques. - Né et mort à Bologne [http://data.bnf.fr/ark:/12148/cb13326913s#foaf:Person]
</ud>
<ud>
François Chauveau (<dat when="1613">1613</dat>) Grava des cartouches notamment pour Nicolas Sanson. Eut un neveu du nom de François Chauveau. Son frère, Jean-Baptiste, habile ingénieur et mathématicien fut assassiné en 1670. [http://data.bnf.fr/ark:/12148/cb15302394v#foaf:Person]
</ud>
<ud>
Jean François Nicéron (<en type="li">Paris</en>, <dat when="1613">1613</dat>) Religieux de l''Ordre des minimes. - Mathématicien [http://data.bnf.fr/ark:/12148/cb14404933t#foaf:Person]
</ud>
<ud>
Tommaso Cornelio (<en type="li">Rovito, Italie</en>, <dat when="1614">1614</dat>) Médecin, philosophe et mathématicien [http://data.bnf.fr/ark:/12148/cb13484167f#foaf:Person]
</ud>
<ud>
Frans Van Schooten (<dat when="1615">1615</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb12529949q#foaf:Person]
</ud>
<ud>
John Wallis (<dat when="1616">1616</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb123396143#foaf:Person]
</ud>
<ud>
Jonas Moore (<dat when="1617">1617</dat>) Mathématicien britannique. - S''est intéressé aux mathématiques appliquées (astronomie, cosmographie, architecture...) [http://data.bnf.fr/ark:/12148/cb135104102#foaf:Person]
</ud>
<ud>
Tito Livio Burattini (<en type="li">Agordo, Italie</en>, <dat when="1617">1617</dat>) Mathématicien, cartographe et égyptologue [http://data.bnf.fr/ark:/12148/cb162142362#foaf:Person]
</ud>
<ud>
Anthelme (Chatenay-Vaudin (Haute-Marne), <dat when="1618">1618</dat>) Religieux de la Chartreuse de Dijon. - Astronome [http://data.bnf.fr/ark:/12148/cb106267229#foaf:Person]
</ud>
<ud>
Charles Cavendish (<dat when="1620">1620</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb14651592w#foaf:Person]
</ud>
<ud>
Jean Picard (<en type="li">La Flèche (Sarthe)</en>, <dat when="1620">1620</dat>) Astronome. - Membre de l''Académie des sciences (<dat when="1666">1666</dat>) [http://data.bnf.fr/ark:/12148/cb11941359d#foaf:Person]
</ud>
<ud>
Claude-François Milliet de Chales (<dat when="1621">1621</dat>) Mathématicien. - Professeur d''hydrographie à Marseille [http://data.bnf.fr/ark:/12148/cb12397222c#foaf:Person]
</ud>
<ud>
Adrien Auzout (<en type="li">Rouen</en>, <dat when="1622">1622</dat>) Astronome, physicien et mathématicien. - A contribué au développement du micromètre [http://data.bnf.fr/ark:/12148/cb134752474#foaf:Person]
</ud>
<ud>
Jean Bertet (<dat when="1622">1622</dat>) Jésuite, quitte la Compagnie en 1681 pour entrer chez les Bénédictins. - Professeur de rhétorique, philosophie et mathématiques. - Poète [http://data.bnf.fr/ark:/12148/cb11999230c#foaf:Person]
</ud>
<ud>
René-François De Sluse (<dat when="1622">1622</dat>) Mathématicien. - Chanoine de la Cathédrale de Liège et abbé d''Amay [http://data.bnf.fr/ark:/12148/cb12427294z#foaf:Person]
</ud>
<ud>
Vincenzo Viviani (<en type="li">Florence, Italie</en>, <dat when="1622">1622</dat>) Florentin. - Mathématicien. - Membre de l'' "accademia della Crusca" [http://data.bnf.fr/ark:/12148/cb12000373g#foaf:Person]
</ud>
<ud>
Blaise Pascal (Clermont-Ferrand (Puy-de-Dôme), <dat when="1623">1623</dat>) Mathématicien, physicien, écrivain. - Frère de : Pascal, Jacqueline (1625-1661) [http://data.bnf.fr/ark:/12148/cb11918679x#foaf:Person]
</ud>
<ud>
Ferdinand Verbiest (<en type="li">Pitthem, Belgique</en>, <dat when="1623">1623</dat>) Jésuite, missionnaire en Chine. - Astronome. - Fut placé à la tête du tribunal des mathématiques, chargé de la rédaction des éphémérides et de la direction des fonderies de canons. - A publié en langue chinoise, sous le nom de Nanhoai-jin, un grand nombre d''ouvrages scientifiques [http://data.bnf.fr/ark:/12148/cb12215344n#foaf:Person]
</ud>
<ud>
Camillo Guarino Guarini (<en type="li">Modène, Italie</en>, <dat when="1624">1624</dat>) Clerc régulier, théatin. - Architecte du duc de Savoie, philosophe et mathématicien [http://data.bnf.fr/ark:/12148/cb12348027r#foaf:Person]
</ud>
<ud>
Christoph Wittich (<dat when="1625">1625</dat>) Théologien. - Professeur de mathématiques et de théologie [http://data.bnf.fr/ark:/12148/cb13014027s#foaf:Person]
</ud>
<ud>
Erhard Weigel (<dat when="1625">1625</dat>) Philosophe. - Professeur de mathématiques, maître de Leibniz et de Pufendorf [http://data.bnf.fr/ark:/12148/cb11935908x#foaf:Person]
</ud>
<ud>
Jean-Dominique Cassini (<en type="li">Perinaldo (comté de Nice)</en>, <dat when="1625">1625</dat>) Titulaire de la chaire d''astronomie de Bologne de 1650 à 1669, surintendant des eaux du Bolonais de 1657 à 1669, surintendant des eaux de l''Etat pontifical et titulaire d''autres charges auprès du pape. - Appelé en France an avril 1669 par Louis XIV. - Membre de l''Académie des sciences, directeur de l''Observatoire de Paris (à partir de 1672). - Naturalisé français en 1673 [http://data.bnf.fr/ark:/12148/cb121019904#foaf:Person]
</ud>
<ud>
Johan de Witt (Dordrecht, Pays-Bas, <dat when="1625">1625</dat>) Homme d''état et mathématicien. - Grand pensionnaire de Hollande [http://data.bnf.fr/ark:/12148/cb13598046j#foaf:Person]
</ud>
<ud>
Johann Hecker (<en type="li">Gdansk (Pologne)</en>, <dat when="1625">1625</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb12875545t#foaf:Person]
</ud>
<ud>
Rasmus Bartholin (<en type="li">Roskilde, Danemark</en>, <dat when="1625">1625</dat>) Physicien. - Mathématicien. - Médecin. - Professeur de mathématiques et de médecine à Copenhague. - A découvert la difraction de la lumière. - Fils de Kaspar Bartholin [http://data.bnf.fr/ark:/12148/cb11890430k#foaf:Person]
</ud>
<ud>
Samuel Morland (<dat when="1625">1625</dat>) Mathématicien et inventeur [http://data.bnf.fr/ark:/12148/cb10365749d#foaf:Person]
</ud>
<ud>
Pietro Mengoli (<en type="li">Bologne (Italie)</en>, <dat when="1626">1626</dat>) Mathématicien. - Professeur de mécanique (1650-1678) puis titulaire de la chaire de mathématiques et d''astronomie (1678-1686) à l''université de Bologne [http://data.bnf.fr/ark:/12148/cb120851477#foaf:Person]
</ud>
<ud>
John Ray (<en type="li">Black Notley (Essex)</en>, <dat when="1627">1627</dat>) Professeur de mathématiques et de lettres. - Naturaliste. - Botaniste. - Membre de la Société royale de Londres [http://data.bnf.fr/ark:/12148/cb12220184b#foaf:Person]
</ud>
<ud>
Heinrich Scherer (<dat when="1628">1628</dat>) Jésuite, géographe et professeur de mathématiques à Munich [http://data.bnf.fr/ark:/12148/cb15317471w#foaf:Person]
</ud>
<ud>
Johannes Hudde (<dat when="1628">1628</dat>) Mathématicien, élève de Frans Van Schooten. - Bourgmestre de la ville d''Amsterdam [http://data.bnf.fr/ark:/12148/cb13488288n#foaf:Person]
</ud>
<ud>
Christiaan Huygens (<dat when="1629">1629</dat>) Mathématicien et astronome. - A vécu aux Pays-Bas et en France. - Élu membre de la "Royal society" de Londres (en 1663) [http://data.bnf.fr/ark:/12148/cb12192922r#foaf:Person]
</ud>
<ud>
Allain Manesson-Mallet (<en type="li">Paris (France)</en>, <dat when="1630">1630</dat>) Ingénieur et cartographe. - Maître de mathématiques des pages du roi de France, sergent-major d''artillerie du roi de Portugal [http://data.bnf.fr/ark:/12148/cb153363577#foaf:Person]
</ud>
<ud>
Isaac Barrow (<dat when="1630">1630</dat>) Mathématicien et théologien [http://data.bnf.fr/ark:/12148/cb12340135q#foaf:Person]
</ud>
<ud>
Jean Richer (<dat when="1630">1630</dat>) Astronome à l''Observatoire de Paris, il figure parmi les premiers membres de l''Académie des sciences (<dat when="1666">1666</dat>). - Chargé d''une mission géodésique à Cayenne (1672-73) [http://data.bnf.fr/ark:/12148/cb14064426q#foaf:Person]
</ud>
<ud>
Adam Adamady Kochánski (<dat when="1631">1631</dat>) Mathématicien polonais, auteur de la rectification approchée de la circonférence. Réside en 1677 à Wroclaw [http://data.bnf.fr/ark:/12148/cb16187484g#foaf:Person]
</ud>
<ud>
Francesco Lana Terzi (<en type="li">Brescia, Italie</en>, <dat when="1631">1631</dat>) Jésuite. - Mathématicien, naturaliste. - Pionnier de l''aéronautique [http://data.bnf.fr/ark:/12148/cb10681783j#foaf:Person]
</ud>
<ud>
Christopher Wren (<en type="li">East Knoyle, Wiltshire, GB</en>, <dat when="1632">1632</dat>) Architecte. - Mathématicien et astronome, Sir Christopher Wren fut l''un des membres fondateurs de la Société royale des sciences [http://data.bnf.fr/ark:/12148/cb121401670#foaf:Person]
</ud>
<ud>
Alessandro Marchetti (<en type="li">Empoli, Italie</en>, <dat when="1633">1633</dat>) Poète naturaliste, l''un des principaux animateurs du courant naturaliste toscan de la seconde moitié du XVIIe siècle. - Professeur de philosophie puis de mathématiques à l''Université de Pise [http://data.bnf.fr/ark:/12148/cb12570345j#foaf:Person]
</ud>
<ud>
Donato Rossetti (<en type="li">Livourne, Italie</en>, <dat when="1633">1633</dat>) Mathématicien. - Professeur de philosophie au "Studio" de Pise [http://data.bnf.fr/ark:/12148/cb144820894#foaf:Person]
</ud>
<ud>
Geminiano Montanari (<en type="li">Modène, Italie</en>, <dat when="1633">1633</dat>) Docteur en droit, mathématicien et astronome. - Enseigne à Florence, Modène (1661-1664), Bologne (chaire de mathématiques, 1664-1677) et Padoue (chaire d''astronomie, 1678-1687). - Membre de l''Accademia dei Gelati ("l''Elevato") et de l''Accademia della Treccia de Bologne [http://data.bnf.fr/ark:/12148/cb12309300z#foaf:Person]
</ud>
<ud>
Gerhard Wolter Molanus (<dat when="1633">1633</dat>) Théologien luthérien. - Mathématicien [http://data.bnf.fr/ark:/12148/cb12133744h#foaf:Person]
</ud>
<ud>
Giovanni Giustino Ciampini (<en type="li">Rome</en>, <dat when="1633">1633</dat>) Historien, archéologue, mathématicien. - Membre de la Curie pontificale [http://data.bnf.fr/ark:/12148/cb14323561z#foaf:Person]
</ud>
<ud>
Vitale Giordano (<dat when="1633">1633</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb15520924m#foaf:Person]
</ud>
<ud>
Johann Christoph Sturm (<en type="li">Hilpolstein, Allemagne</en>, <dat when="1635">1635</dat>) Philosophe, mathématicien et physicien. - Professeur à l''université d''Altdorf [http://data.bnf.fr/ark:/12148/cb133240234#foaf:Person]
</ud>
<ud>
Ignace-Gaston Pardies (<dat when="1636">1636</dat>) Mathématicien. - Jésuite. - Il a enseigné la philosophie puis les mathématiques au collège Louis-Le-Grand [http://data.bnf.fr/ark:/12148/cb12174258w#foaf:Person]
</ud>
<ud>
Elias van Lennep (Borculo, Pays-Bas, <dat when="1637">1637</dat>) Graveur. - Ingénieur et mathématicien [http://data.bnf.fr/ark:/12148/cb15053499m#foaf:Person]
</ud>
<ud>
Julius Reichelt (<dat when="1637">1637</dat>) Mathématicien strasbourgeois [http://data.bnf.fr/ark:/12148/cb15377331m#foaf:Person]
</ud>
<ud>
François Barrême (<en type="li">Tarascon, France</en>, <dat when="1638">1638</dat>) Mathématicien et financier [http://data.bnf.fr/ark:/12148/cb118903320#foaf:Person]
</ud>
<ud>
Georg Christoph Eimmart (<en type="li">Ratisbonne (Allemagne)</en>, <dat when="1638">1638</dat>) Peintre d''histoire, portraitiste, graveur, mathématicien et astronome. - Fils et élève du peintre Georg-Christoph Eimmart (1603-1658), dit le vieux [http://data.bnf.fr/ark:/12148/cb12983761h#foaf:Person]
</ud>
<ud>
James Gregory (<dat when="1638">1638</dat>) Mathématicien et opticien écossais [http://data.bnf.fr/ark:/12148/cb12459917j#foaf:Person]
</ud>
<ud>
Jean Bonfa (<en type="li">Nîmes</en>, <dat when="1638">1638</dat>) Est admis à la Société de Jésus en 1654. - Dans les années 1670 jusqu''en 1683, il enseigne les mathématiques et la théologie aux collèges jésuites de Grenoble, puis d''Avignon. - De 1680 à 1682, enseigne la géométrie et l''hydrographie. - Effectue des travaux astronomiques. - Devient membre correspondant de l''Académie royale des sciences (en 1699) [http://data.bnf.fr/ark:/12148/cb15130186g#foaf:Person]
</ud>
<ud>
Jacques Ozanam (Sainte-Olive (<en type="li">Ain)</en>, <dat when="1640">1640</dat>) Mathématicien. - Professeur de mathématiques à Paris et à Lyon [http://data.bnf.fr/ark:/12148/cb120960958#foaf:Person]
</ud>
<ud>
Philippe de La Hire (<en type="li">Paris (France)</en>, <dat when="1640">1640</dat>) Mathématicien. - Géomètre et astronome. - Professeur de mathématiques au Collège de France. - Membre de l''Académie des sciences (<dat when="1678">1678</dat>) [http://data.bnf.fr/ark:/12148/cb121592847#foaf:Person]
</ud>
<ud>
Pierre Ango (<dat when="1640">1640</dat>) Jésuite. - Enseigna les humanités, les mathématiques et la philosophie. - Né à Rouen, mort à La Flèche [http://data.bnf.fr/ark:/12148/cb12512101m#foaf:Person]
</ud>
<ud>
Denis Papin (<dat when="1642">1642</dat>) Physicien. - Un des précurseurs de l''invention de la machine à vapeur, qui eu l''idée du piston (dés 1690), et inspira la machine que l''Anglais Thomas Newcomen (1664-1729), mis au point ensuite (en 1712). - Quitta définitivement la France, après la révocation de l''Édit de Nantes (<dat when="1685">1685</dat>). - Occupa une chaire de mathématiques à l''Université de Marburg, Allemagne (<dat when="1687">1687</dat>). - Rédige un article (Ars nova ad aquam ignis...) présentant sa machine dans la revue " Acta Eruditorum", Leipzig (en 1707), revue célèbre pour les publications de Leibniz (1646-1716), sur le calcul différentiel et intégral [http://data.bnf.fr/ark:/12148/cb12087889k#foaf:Person]
</ud>
<ud>
Isaac Newton (Woolsthorpe, Lincolnshire (<en type="li">GB)</en>, <dat when="1642">1642</dat>) Physicien, mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb119176085#foaf:Person]
</ud>
<ud>
Johann Welper (<dat when="1642">1642</dat>) Variante(s) de prénom : Johannes ; Jean. - Imprimeur-libraire. - Fils et apprenti d''Eberhard Welper, imprimeur-libraire et mathématicien à Strasbourg. A été compagnon pendant 6 ans à Ulm, Augsbourg, Munich, Vienne, Leipzig et Nuremberg, avant de succéder à son père. L''enquête de 1700-1701 le dit âgé de 60 ans et "établi à Strasbourg depuis 42 ans". À sa mort, son entreprise est rachetée par Melchior Pauschinger [http://data.bnf.fr/ark:/12148/cb160636269#foaf:Person]
</ud>
<ud>
Michel Mourgues (<dat when="1642">1642</dat>) Jésuite. - Enseigna la rhétorique et les mathématiques à l''Université de Toulouse [http://data.bnf.fr/ark:/12148/cb124637183#foaf:Person]
</ud>
<ud>
Takakazu Seki (<dat when="1642">1642</dat>) Mathématicien japonais [http://data.bnf.fr/ark:/12148/cb12443516f#foaf:Person]
</ud>
<ud>
Jean Jombert (<dat when="1643">1643</dat>) Libraire. - Fils d''un fruitier et marchand de vins parisien. En apprentissage chez le libraire parisien Pierre II Baudouin à partir de janv. 1666, il travaille en 1670-1671 chez Louis Billaine et Pierre Le Petit, puis chez la veuve de Pierre I Baudouin à partir de 1672. Gendre en 1res noces (<dat when="1671">1671</dat>) du libraire Jean d''Houry. Publie sous son propre nom dès 1680, peut-être dès 1678, mais n''est reçu maître que le 17 sept. 1686. Publie de nombreux ouvrages de mathématiques. Dit âgé d''env. 60 ans lors de l''enquête de nov.-déc. 1701. Testaments le 9 août 1704 et le 6 oct. 1705. Décédé au début de nov. 1705. Sa veuve lui succède [http://data.bnf.fr/ark:/12148/cb15074749j#foaf:Person]
</ud>
<ud>
Antoine Thomas (<en type="li">Namur</en>, <dat when="1644">1644</dat>) Jésuite (à partir de 1660). - Mathématicien et astronome de l''empereur de Chine [http://data.bnf.fr/ark:/12148/cb10636254r#foaf:Person]
</ud>
<ud>
Johann Jakob Zimmermann (<en type="li">Vaihingen an der Enz, Allemagne</en>, <dat when="1644">1644</dat>) Théologien, mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb10721479d#foaf:Person]
</ud>
<ud>
Ole Rømer (<en type="li">Åarhus, Danemark</en>, <dat when="1644">1644</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb12324191r#foaf:Person]
</ud>
<ud>
Carlos de Sigüenza y Góngora (<en type="li">Mexico</en>, <dat when="1645">1645</dat>) Astronome, mathématicien, poète, historien. - Sa bibliothèque, comprenant des documents uniques sur l''histoire du Mexique, disparut dans un incendie lors de l''insurrection de 1692 [http://data.bnf.fr/ark:/12148/cb121021638#foaf:Person]
</ud>
<ud>
Eusebio Francisco Kino (<en type="li">Taio, Italie</en>, <dat when="1645">1645</dat>) Mathématicien et géographe de formation. - Jésuite, arrive au Mexique en 1681 [http://data.bnf.fr/ark:/12148/cb122190783#foaf:Person]
</ud>
<ud>
Maximilian Rassler (<en type="li">Waldsee (Allemagne)</en>, <dat when="1645">1645</dat>) Jésuite. - Professeur de réthorique, de mathématiques, philosophie et contreverse. - Recteur et chancelier de l''Université de Dillingen, Allemagne [http://data.bnf.fr/ark:/12148/cb158132748#foaf:Person]
</ud>
<ud>
Elena Lucrezia Cornaro Piscopia (<en type="li">Venise (Italie)</en>, <dat when="1646">1646</dat>) Philosophe et mathématicienne. - Première femme docteur en philosophie [http://data.bnf.fr/ark:/12148/cb16591183r#foaf:Person]
</ud>
<ud>
Francesco Maria Pompeo Colonna (<en type="li">Rome</en>, <dat when="1646">1646</dat>) Mathématicien, physicien et occultiste. - Vécut à Paris à partir de 1668 [http://data.bnf.fr/ark:/12148/cb118973978#foaf:Person]
</ud>
<ud>
Harald Vallerius (<dat when="1646">1646</dat>) Professeur universitaire de mathématiques [http://data.bnf.fr/ark:/12148/cb16032560b#foaf:Person]
</ud>
<ud>
John Flamsteed (<dat when="1646">1646</dat>) Astronome. - Fut le premier directeur de l''Observatoire de Greenwich, GB, fondé en 1675 [http://data.bnf.fr/ark:/12148/cb13524243n#foaf:Person]
</ud>
<ud>
John Flamsteed (<dat when="1646">1646</dat>) Astronome britannique. Fut le premier directeur de l''observatoire de Greenwich, fondé en 1675 [http://data.bnf.fr/ark:/12148/cb13510391m#foaf:Person]
</ud>
<ud>
Niccolò Partenio Giannettasio (<dat when="1648">1648</dat>) Jésuite. - Historien et poète. - Professeur de mathématiques et d''hébreu au Collège des Jésuites de Naples. - Né à Naples, meurt à Massa [http://data.bnf.fr/ark:/12148/cb133256727#foaf:Person]
</ud>
<ud>
Tommaso Ceva (<dat when="1648">1648</dat>) Jésuite. - Philosophe, astronome, physicien et poète. - Membre de l''Académie de l''Arcadie sous le pseudonyme : Callimaco Neridio [http://data.bnf.fr/ark:/12148/cb13321850h#foaf:Person]
</ud>
<ud>
Jean Le Febvre (<en type="li">Lisieux (Calvados)</en>, <dat when="1650">1650</dat>) Tisserand, puis astronome. - Membre de l''Académie des sciences de 1682 à 1702 [http://data.bnf.fr/ark:/12148/cb16176897g#foaf:Person]
</ud>
<ud>
Michelangelo Fardella (<dat when="1650">1650</dat>) Franciscain. - Philosophe, astronome et mathématicien. - Professeur de philosophie, de théologie, de mathématiques, professeur d''astronomie et de physique à l''Université de Padoue (1694-). - Né à Trapani, meurt à Naples [http://data.bnf.fr/ark:/12148/cb12093422f#foaf:Person]
</ud>
<ud>
Andreas Cellarius (<dat when="1651">1651</dat>) Mathématicien et géographe hollandais actif de 1656 à 1702. En 1660 il est recteur de l''Ecole latine de Hoorn [http://data.bnf.fr/ark:/12148/cb15338282n#foaf:Person]
</ud>
<ud>
Antoine-François Payen (<en type="li">Avignon</en>, <dat when="1651">1651</dat>) Jurisconsulte et astronome. - Enseigna la jurisprudence civile dès 1642 à Avignon [http://data.bnf.fr/ark:/12148/cb144713316#foaf:Person]
</ud>
<ud>
Arent Roggeveen (<dat when="1651">1651</dat>) Mathématicien, navigateur et hydrographe [http://data.bnf.fr/ark:/12148/cb153879695#foaf:Person]
</ud>
<ud>
Bingzhen Jiao (<dat when="1651">1651</dat>) Peintre et mathématicien à la cour de l''empereur Kangxi [http://data.bnf.fr/ark:/12148/cb14546684c#foaf:Person]
</ud>
<ud>
Caspar Dauthendey (<dat when="1651">1651</dat>) Architecte et mathématicien [http://data.bnf.fr/ark:/12148/cb153778194#foaf:Person]
</ud>
<ud>
Claude Bonjour (<dat when="1651">1651</dat>) Augustin du couvent de Pontarlier. Géographe et mathématicien [http://data.bnf.fr/ark:/12148/cb15294805z#foaf:Person]
</ud>
<ud>
Claude Comiers (<dat when="1651">1651</dat>) Théologien et mathématicien, né à Embrun. Chanoine d''Embrun, ingénieur des armées, puis prévôt de l''église collégiale de Ternant, professeur de mathématiques à Paris ; protonotaire apostolique et officier du Saint-Office. - Il a laissé des livres et des articles sur des sujets variés : géométrie, astronomie, médecine, occultisme, physique... [http://data.bnf.fr/ark:/12148/cb12250531g#foaf:Person]
</ud>
<ud>
Claude Irson (<dat when="1651">1651</dat>) Mathématicien et grammairien. - A été teneur de comptes vers 1678 [http://data.bnf.fr/ark:/12148/cb125155096#foaf:Person]
</ud>
<ud>
de La Roche (<dat when="1651">1651</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb13009642b#foaf:Person]
</ud>
<ud>
Ehrenfried Walter von Tschirnhaus (<en type="li">Kieslingswalde, Allemagne</en>, <dat when="1651">1651</dat>) Philosophe, mathématicien et biologiste. - Industriel, considéré comme l''inventeur de la porcellaine blanche en Europe [http://data.bnf.fr/ark:/12148/cb12515471b#foaf:Person]
</ud>
<ud>
Federico Gualdi (<dat when="1651">1651</dat>) Alchimiste, astronome, mathématicien. - Philosophe hermétique. - Membre de la Rose-croix d''Or. - Serait d''origine allemande ou italienne [http://data.bnf.fr/ark:/12148/cb150904929#foaf:Person]
</ud>
<ud>
Francesco Levera (<en type="li">Savoie</en>, <dat when="1651">1651</dat>) Philosophe, astronome et théologien [http://data.bnf.fr/ark:/12148/cb10442558v#foaf:Person]
</ud>
<ud>
François Chevalier (Sainte-Maur, <dat when="1651">1651</dat>) Elève de l''abbé Galloys. Associé géomètre à l''Académie des sciences en 1707. Pensionnaire mécanicien en 1725. Professeur de mathématiques au Collège de France. Maître de mathématiques du roi et des pages de la Petite Ecurie. Présenta en 1707 à l''Académie une méthode de collecte des informations cartographiques sur des châssis concentriques [http://data.bnf.fr/ark:/12148/cb153045899#foaf:Person]
</ud>
<ud>
François Noël (Hestrud, Pays-Bas Méridionaux, <dat when="1651">1651</dat>) Jésuite (à partir de 1670) ordonné prêtre en 1682. - Missionnaire en Chine, il fut envoyé à Rome à l''occasion de la querelle des rites, et ne put rentrer en Chinê. - Il enseigna ensuite à Prague. - Auteur de poésies et de théâtre, d''un traité d''astronomie, de traductions et d''un ouvrage catéchétique en chinois [http://data.bnf.fr/ark:/12148/cb16653645d#foaf:Person]
</ud>
<ud>
Guisnée (<dat when="1651">1651</dat>) Mathématicien. - Membre de l''Académie royale des sciences [http://data.bnf.fr/ark:/12148/cb14618149h#foaf:Person]
</ud>
<ud>
Jacques Mengau (<dat when="1651">1651</dat>) Professeur de mathématiques. - Auteur de mazarinades. - Actif de 1648 à 1652 [http://data.bnf.fr/ark:/12148/cb12166762s#foaf:Person]
</ud>
<ud>
Jean Bachou (<dat when="1651">1651</dat>) Mathématicien et alchimiste lyonnais. - Avocat au parlement [http://data.bnf.fr/ark:/12148/cb12158814g#foaf:Person]
</ud>
<ud>
Jean Glover (<dat when="1651">1651</dat>) Ingénieur et mathématicien originaire d''Écosse et établi en France. - Auteur notamment de plusieurs propositions de loteries et d''une "Nouvelle Manière d''exécuter les loteries..." (<en type="li">Paris</en>, <dat when="1705">1705</dat>). - Se qualifie d''"esquire, seigneur de Glaideny et de la baronnie de Baltillée en Ecosse" [http://data.bnf.fr/ark:/12148/cb15818830h#foaf:Person]
</ud>
<ud>
Jean-Baptiste Delure (<dat when="1651">1651</dat>) Éditeur d''estampes et de cartes géographiques. - Ingénieur pour les instruments de mathématiques et fabricant de cartes et de globes ; éditeur occasionnel [http://data.bnf.fr/ark:/12148/cb153164066#foaf:Person]
</ud>
<ud>
Joachim d'' Alencé (<dat when="1651">1651</dat>) Astronome et physicien [http://data.bnf.fr/ark:/12148/cb12397878n#foaf:Person]
</ud>
<ud>
Joanne Westenburg (<dat when="1651">1651</dat>) Cartographe, médecin et mathématicien [http://data.bnf.fr/ark:/12148/cb15377993t#foaf:Person]
</ud>
<ud>
Johann Andreas Planer (<en type="li">Strelen, Allemagne</en>, <dat when="1651">1651</dat>) Mathématicien. - Professeur de mathématiques à l''Université de Wittenberg [http://data.bnf.fr/ark:/12148/cb16672375p#foaf:Person]
</ud>
<ud>
Le Blanc (<dat when="1651">1651</dat>) Professeur de mathématiques (<dat when="1692">1692</dat>). - Réside rue de Seine à Paris en 1692 [http://data.bnf.fr/ark:/12148/cb16650697x#foaf:Person]
</ud>
<ud>
Le Demaine Godalles (<dat when="1651">1651</dat>) Hydrographe, Ingénieur du roi et professeur de Mathématiques, Architecte [http://data.bnf.fr/ark:/12148/cb15375819n#foaf:Person]
</ud>
<ud>
Philip Lea (<dat when="1651">1651</dat>) Cartographe, fabricant et éditeur de globes, de cartes, d''instruments de mathématiques, actif de 1666 à 1700 à Londres [http://data.bnf.fr/ark:/12148/cb15328427v#foaf:Person]
</ud>
<ud>
René Gaultier de Maignannes (<dat when="1651">1651</dat>) Mathématicien angevin. - Spécialiste de la perspective [http://data.bnf.fr/ark:/12148/cb12536157m#foaf:Person]
</ud>
<ud>
David François de Merveilleux (<dat when="1652">1652</dat>) Géographe et cartographe. Connaissances mathématiques étendues (il publie un traîté d''arithmétique et de géométrie). En 1695 il entre au service de Guillaume III qui lui accorde le brevet de Capitaine Ingénieur au service d''Angleterre et des Etats généraux [http://data.bnf.fr/ark:/12148/cb15304894q#foaf:Person]
</ud>
<ud>
Michel Rolle (Ambert (Puy-de-Dôme), <dat when="1652">1652</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb130110121#foaf:Person]
</ud>
<ud>
Nicolas Bion (<dat when="1652">1652</dat>) Ingénieur du roi pour les instruments de mathématique. - Avait un atelier à Paris, quai de l''Horloge, qui était l''un des mieux achalandés du temps. - Son "Usage des globes" connut 6 éditions entre 1699 et 1751. - Édita en 1694 le globe terrestre de P. Courtin (diam. 25 cm) et en 1712 une paire de globes de même diamètre, un globe céleste antérieur à 1710 atteignit 32 cm de diamètre [http://data.bnf.fr/ark:/12148/cb152909089#foaf:Person]
</ud>
<ud>
José Chaffrion (<dat when="1653">1653</dat>) Cartographe et mathématicien de Valence en Espagne [http://data.bnf.fr/ark:/12148/cb15330290b#foaf:Person]
</ud>
<ud>
Bernard Nieuwentijt (West Graftdijk, Pays-Bas, <dat when="1654">1654</dat>) Philosophe, médecin et mathématicien [http://data.bnf.fr/ark:/12148/cb14587835s#foaf:Person]
</ud>
<ud>
Jacques Bernoulli (<en type="li">Bâle, Suisse</en>, <dat when="1654">1654</dat>) Mathématicien et astronome. - Professeur de mathématiques à l''université de Bâle, Suisse [http://data.bnf.fr/ark:/12148/cb120751142#foaf:Person]
</ud>
<ud>
Jean Pigeon (<en type="li">Donzy (Nièvre)</en>, <dat when="1654">1654</dat>) Peintre, mathématicien et facteur de globes, géographe du Duc d''Orléans à partir de 1714 [http://data.bnf.fr/ark:/12148/cb15147433m#foaf:Person]
</ud>
<ud>
Jean-François Gerbillon (<dat when="1654">1654</dat>) Jésuite. - Mathématicien, fut envoyé en Chine par Louis XIV en 1685. - Écrivit des traités de géométrie et de l''usage de l''astrolabe en chinois et en tartare. - Supérieur général de la Mission française de Chine [http://data.bnf.fr/ark:/12148/cb124622770#foaf:Person]
</ud>
<ud>
Philippe Avril (<en type="li">Angoulême (Charente)</en>, <dat when="1654">1654</dat>) Missionnaire. - Voyageur, jésuite dès 1670, il enseigna les mathématiques à Louis-le-Grand. - Chercha un nouveau passage vers la Chine par la Tartarie, le Kurdistan et l''Arménie [http://data.bnf.fr/ark:/12148/cb15327596q#foaf:Person]
</ud>
<ud>
Philippe Naudé (<en type="li">Metz</en>, <dat when="1654">1654</dat>) Théologien et mathématicien. - Se réfugia en Prusse après la révocation de l''Édit de Nantes [http://data.bnf.fr/ark:/12148/cb10366497p#foaf:Person]
</ud>
<ud>
Pierre Varignon (<en type="li">Caen (Calvados)</en>, <dat when="1654">1654</dat>) Mathématicien. - Jésuite. - Membre de l''Académie des sciences, il entre au collège de France en 1704 [http://data.bnf.fr/ark:/12148/cb121123302#foaf:Person]
</ud>
<ud>
Louis Lecomte (<dat when="1655">1655</dat>) Jésuite. - Mathématicien [http://data.bnf.fr/ark:/12148/cb12151496v#foaf:Person]
</ud>
<ud>
Simon Tyssot de Patot (<en type="li">Londres</en>, <dat when="1655">1655</dat>) Professeur ordinaire de mathématiques à l''École illustre de Deventer (1699-1727 ; professeur extraordinaire dès 1690). - Vécut en France de 1658 environ à 1664, puis aux Pays-Bas [http://data.bnf.fr/ark:/12148/cb11927303t#foaf:Person]
</ud>
<ud>
Claude de Visdelou (Erquy (Côtes-d''Armor), <dat when="1656">1656</dat>) Jésuite. - Mathématicien. - Missionnaire en Chine. - Évèque titulaire de de Claudiopolis-en-Isaurie (à partir de 1708/1709). - Vicaire apostolique du Koueitchéou et du Yunnan, et administrateu du Houkouang (de 1708 à 1709) [http://data.bnf.fr/ark:/12148/cb150791582#foaf:Person]
</ud>
<ud>
Edmund Halley (<dat when="1656">1656</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb119960783#foaf:Person]
</ud>
<ud>
Nicolaas Hartsoeker (Gouda (Pays-Bas), <dat when="1656">1656</dat>) Physicien, micrographe et médecin. - Apporta des perfectionnements importants à la fabrication des verres de lunettes astronomiques, découvrit les animalcules spermatiques [http://data.bnf.fr/ark:/12148/cb13010358x#foaf:Person]
</ud>
<ud>
William Molyneux (<en type="li">Dublin</en>, <dat when="1656">1656</dat>) Mathématicien, astronome, physicien et philosophe. - Premier secrétaire de la Société philosophique de Dublin (en 1684) [http://data.bnf.fr/ark:/12148/cb124596616#foaf:Person]
</ud>
<ud>
Jean-Mathieu de Chazelles (<en type="li">Lyon</en>, <dat when="1657">1657</dat>) Cartographe, géographe et astronome associé à l''Académie des sciences [http://data.bnf.fr/ark:/12148/cb106281104#foaf:Person]
</ud>
<ud>
Jean-Matthieu de Chazelles (<en type="li">Lyon</en>, <dat when="1657">1657</dat>) Fit ses études chez les jésuites et devint l''auxiliaire de Cassini I. Fut associé aux travaux géodésiques menés par l''Académie des sciences. Dessina le planisphère de l''Observatoire. Collabora au Neptune françois. Associé astronome de l''Académie des sciences en 1695; associé mécanicien en 1699. Professeur d''hydrographie à Marseille [http://data.bnf.fr/ark:/12148/cb15304334g#foaf:Person]
</ud>
<ud>
Joseph Saurin (<en type="li">Courthézon (Vaucluse)</en>, <dat when="1659">1659</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb10330722j#foaf:Person]
</ud>
<ud>
Philippe Desplaces (<dat when="1659">1659</dat>) Astronome. - Auteur d''éphémérides [http://data.bnf.fr/ark:/12148/cb12223720g#foaf:Person]
</ud>
<ud>
Louis Feuillée (Mane (Alpes-de-Haute-Provence), <dat when="1660">1660</dat>) Astronome et botaniste. - Religieux de l''ordre des Minimes. - Initié à la botanique par le P. Plumier. Correspondant astronome de l''Académie des sciences, il obtient une mission dans le Levant. Revenu à Marseille en 1702, il embarque l''année suivante pour les Antilles et parvient à Carthagène en 1704. Nommé mathématicien du roi, il s''embarque pour l''Amérique du Sud en 1707. En 1724, il est chargé de déterminer la position exacte de l''île de Fer [http://data.bnf.fr/ark:/12148/cb15309142r#foaf:Person]
</ud>
<ud>
Thomas Fantet de Lagny (<en type="li">Lyon (Rhône)</en>, <dat when="1660">1660</dat>) Mathématicien. - Professeur [http://data.bnf.fr/ark:/12148/cb14548143w#foaf:Person]
</ud>
<ud>
Guillaume-François-Antoine de L''Hospital (<dat when="1661">1661</dat>) Marquis de Sainte-Mesme. - Mathématicien, membre de l''Académie des sciences [http://data.bnf.fr/ark:/12148/cb12000655c#foaf:Person]
</ud>
<ud>
Francesco Bianchini (<en type="li">Vérone, Italie</en>, <dat when="1662">1662</dat>) Théologien, historien, astronome et physicien [http://data.bnf.fr/ark:/12148/cb12452255g#foaf:Person]
</ud>
<ud>
Paolo Mattia Doria (<dat when="1662">1662</dat>) Philosophe et mathématicien italien [http://data.bnf.fr/ark:/12148/cb121118306#foaf:Person]
</ud>
<ud>
Jean-Pierre de Crousaz (<dat when="1663">1663</dat>) Professeur de philosophie et mathématiques à Lausanne et Groningue. - Conseiller de la légation de Suède en Hollande. - Membre des Académies de Bordeaux et Paris [http://data.bnf.fr/ark:/12148/cb12016566d#foaf:Person]
</ud>
<ud>
Johann Balthasar Lauterbach (<dat when="1663">1663</dat>) Mathématicien et architecte allemand [http://data.bnf.fr/ark:/12148/cb137778333#foaf:Person]
</ud>
<ud>
John Craig (<dat when="1663">1663</dat>) Mathématicien et théologien écossais [http://data.bnf.fr/ark:/12148/cb114408210#foaf:Person]
</ud>
<ud>
Katahiro Takebe (<dat when="1664">1664</dat>) Mathématicien japonais [http://data.bnf.fr/ark:/12148/cb12443517s#foaf:Person]
</ud>
<ud>
Lothar Zumbach von Coesfeld (<en type="li">Trèves (Allemagne)</en>, <dat when="1664">1664</dat>) Mathématicien, astronome, médecin, musicien. - Mathématicien et musicien de l''électeur de Trèves (1685-1688). - Lecteur en astronomie à l''université de Leyde. - Professeur de mathématiques au Carolinum de Kassel [http://data.bnf.fr/ark:/12148/cb14853628w#foaf:Person]
</ud>
<ud>
Abraham de Moivre (Vitry-le-François (<en type="li">Marne)</en>, <dat when="1667">1667</dat>) Mathématicien. - Émigra en Grande-Bretagne après la révocation de l''Édit de Nantes (en 1686). - Membre de la Royal Society, de l''Académie de Berlin et de l''Académie de Saint-Pétersbourg [http://data.bnf.fr/ark:/12148/cb130110001#foaf:Person]
</ud>
<ud>
Girolamo Saccheri (<en type="li">San Remo, Italie</en>, <dat when="1667">1667</dat>) Jésuite. - Professeur de mathématiques [http://data.bnf.fr/ark:/12148/cb13164455b#foaf:Person]
</ud>
<ud>
Johann Bernoulli (<en type="li">Bâle, Suisse</en>, <dat when="1667">1667</dat>) Mathématicien et physicien, maître d''Euler, professeur à l''Université de Groningue puis à l''Université de Bâle. - A travaillé sur le calcul différentiel, intégral et exponentiel. - Également auteur de traités de médecine, fondateur de la théorie mécanico-physique de la fermentation [http://data.bnf.fr/ark:/12148/cb122991692#foaf:Person]
</ud>
<ud>
William Whiston (Norton-juxta-Twycross (G. B.), <dat when="1667">1667</dat>) Théologien et astronome. - Professeur de mathématiques à Cambridge, d''où il fut exclu pour ses écrits théologiques. - Traducteur de Flavius Josèphe [http://data.bnf.fr/ark:/12148/cb11997914k#foaf:Person]
</ud>
<ud>
Guillaume Bonjour (Toulouse (Haute-Garonne), <dat when="1669">1669</dat>) Augustin. - Missionnaire en Chine. - Orientaliste, astronome et cartographe [http://data.bnf.fr/ark:/12148/cb13613529n#foaf:Person]
</ud>
<ud>
Leonhard Christoph Sturm (<en type="li">Aldorf, Allemagne</en>, <dat when="1669">1669</dat>) Mathématicien. - Architecte [http://data.bnf.fr/ark:/12148/cb143383238#foaf:Person]
</ud>
<ud>
Jean Terrasson (<en type="li">Lyon</en>, <dat when="1670">1670</dat>) Oratorien, mathématicien et philosophe. - Professeur de grec et latin au Collège de France. - Membre de l''Institut, Académie Française (élu en 1732) [http://data.bnf.fr/ark:/12148/cb119262217#foaf:Person]
</ud>
<ud>
Guido Grandi (<en type="li">Crémone, Italie</en>, <dat when="1671">1671</dat>) Mathématicien, théologien, biographe, antiquaire et poète. - Soutint Descartes contre l''aristotélisme. - Professeur de philosophie à l''Université de Pise. - Fut en correspondance avec Leibniz, Newton, Bernoulli. - Intendant général des eaux en Toscane [http://data.bnf.fr/ark:/12148/cb121384290#foaf:Person]
</ud>
<ud>
Johann Gabriel Doppelmayr (<dat when="1671">1671</dat>) Fils d''un riche négociant qui s''occupait de physique, et destiné d''abord à l''étude du droit, il la quitta pour celle des mathématiques et voyagea jusqu''en 1702. Professeur à Nuremberg et membre de la Royal Society de Londres [http://data.bnf.fr/ark:/12148/cb15327296w#foaf:Person]
</ud>
<ud>
Johann Gabriel Doppelmayr (<dat when="1671">1671</dat>) Mathématicien. - Membre de la Royal Society de Londres (<dat when="1713">1713</dat>) [http://data.bnf.fr/ark:/12148/cb12158680q#foaf:Person]
</ud>
<ud>
Johann Gabriel Doppelmayr (<dat when="1671">1671</dat>) Astronome et cartographe ayant véçu à Nuremberg, né en 1671 ou 1677 [http://data.bnf.fr/ark:/12148/cb15327296w#foaf:Person]
</ud>
<ud>
Johann Heinrich Müller (<dat when="1671">1671</dat>) Physicien, astronome, mathématicien. - Professeur à l''université d''Altdorf (Allemagne) [http://data.bnf.fr/ark:/12148/cb10706008k#foaf:Person]
</ud>
<ud>
John Keill (<dat when="1671">1671</dat>) Mathématicien écossais. - Professeur d''astronomie à Oxford [http://data.bnf.fr/ark:/12148/cb123670586#foaf:Person]
</ud>
<ud>
Étienne-Simon de Gamaches (<dat when="1672">1672</dat>) Astronome et moraliste. - Chanoine de Sainte Croix de La Bretonnerie. - Membre de l''Académie des sciences [http://data.bnf.fr/ark:/12148/cb12004341t#foaf:Person]
</ud>
<ud>
Johann Jacob Scheuchzer (<en type="li">Zürich</en>, <dat when="1672">1672</dat>) Médecin, naturaliste, historien, archéologue, numismate, astronome et physicien [http://data.bnf.fr/ark:/12148/cb123955592#foaf:Person]
</ud>
<ud>
Eustachio Manfredi (<dat when="1674">1674</dat>) Astronome. - Poète. - Fondateur de l''Académie de Bologne [http://data.bnf.fr/ark:/12148/cb12202194q#foaf:Person]
</ud>
<ud>
Julien Mahuet (<dat when="1674">1674</dat>) Jésuite. - Né à Reims. Entre au noviciat le 24 août 1692. Enseigne les humanités à Reims, la rhétorique à Metz et les mathématiques à Reims. - Écrit du théâtre pour le Collège de Reims [http://data.bnf.fr/ark:/12148/cb13165624v#foaf:Person]
</ud>
<ud>
Guillaume Delisle (<dat when="1675">1675</dat>) Cartographe. - Fils de Claude Delisle, fut l''élève de Jean-Dominique Cassini. Élève astronome à l''Académie des sciences en 1702, il en devint membre en 1718 ; enseigna la géographie au jeune Louis XV et fut nommé premier géographe du roi ; produisit quelque 100 cartes qu''il édita lui-même [http://data.bnf.fr/ark:/12148/cb15238363g#foaf:Person]
</ud>
<ud>
Humphry Ditton (Salisbury (G. B.), <dat when="1675">1675</dat>) Mathématicien et théologien [http://data.bnf.fr/ark:/12148/cb15994181b#foaf:Person]
</ud>
<ud>
Yves-Marie André (<dat when="1675">1675</dat>) Jésuite. - Professeur de mathématiques à Caen [http://data.bnf.fr/ark:/12148/cb12180932c#foaf:Person]
</ud>
<ud>
Jacopo Francesco Riccati (<dat when="1676">1676</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb120689750#foaf:Person]
</ud>
<ud>
Gabriel Philippe de La Hire (<en type="li">Paris</en>, <dat when="1677">1677</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb106522995#foaf:Person]
</ud>
<ud>
Jacques Cassini (<en type="li">Paris</en>, <dat when="1677">1677</dat>) Fils de Jean-Dominique Cassini et père de César-François Cassini de Thury. Associé astronome à l''Académie des sciences en 1699, pensionnaire en 1712. En 1700 participa à la mesure de la méridienne de l''Observatoire et y travailla jusqu''à son achèvement en 1718. En 1706 maître ordinaire à la Chambre des comptes. Etudia les planètes et leurs satellites. Soutint la thèse de l''allongement de la Terre aux pôles. [http://data.bnf.fr/ark:/12148/cb15238366h#foaf:Person]
</ud>
<ud>
Joseph Privat de Molières (Tarascon (ouches-du-Rhône), <dat when="1677">1677</dat>) Physicien et mathématicien. - Oratorien (vers 1709). - Professeur au collège royal (<dat when="1723">1723</dat>). - Adjoint (<dat when="1721">1721</dat>) puis associé (<dat when="1729">1729</dat>) de l''Académie royale des sciences [http://data.bnf.fr/ark:/12148/cb145391041#foaf:Person]
</ud>
<ud>
Gerard Keulen (<dat when="1678">1678</dat>) Graveur, cartographe, mathématicien et éditeur. - Fils de Johannes van Keulen [http://data.bnf.fr/ark:/12148/cb15332761m#foaf:Person]
</ud>
<ud>
Jacob Hermann (<dat when="1678">1678</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb12319998c#foaf:Person]
</ud>
<ud>
Jean-Jacques Dortous de Mairan (<en type="li">Béziers</en>, <dat when="1678">1678</dat>) Physicien et mathématicien. - Membre puis secrétaire perpétuel de l''Académie des sciences. - Membre de l''Académie française (élu en 1743) [http://data.bnf.fr/ark:/12148/cb12395086k#foaf:Person]
</ud>
<ud>
Louis Bourguet (<en type="li">Nïmes</en>, <dat when="1678">1678</dat>) Professeur de philosophie et de mathématiques à Neuchâtel. - Est l''un des fondateurs de la "Bibliothèque italique" (1728-) et du "Mercure suisse" (1732-). - Naturalisé Neuchâtelois en 1710 [http://data.bnf.fr/ark:/12148/cb12797692b#foaf:Person]
</ud>
<ud>
Pierre Rémond de Montmort (<en type="li">Paris</en>, <dat when="1678">1678</dat>) Mathématicien. - Spécialiste de probabilités [http://data.bnf.fr/ark:/12148/cb12391046c#foaf:Person]
</ud>
<ud>
Bernardino Zendrini (<en type="li">Saviore, Italie</en>, <dat when="1679">1679</dat>) Médecin. - Mathématicien. - Hydraulicien [http://data.bnf.fr/ark:/12148/cb13545066d#foaf:Person]
</ud>
<ud>
Christian Wolff (<en type="li">Breslau, Silésie (Wrocław, Pologne)</en>, <dat when="1679">1679</dat>) Juriste, mathématicien et philosophe [http://data.bnf.fr/ark:/12148/cb121387859#foaf:Person]
</ud>
<ud>
Firmin Abauzit (<en type="li">Uzès</en>, <dat when="1679">1679</dat>) Mathématicien, philosophe et bibliothécaire. - Fut bibliothécaire à la Bibliothèque de Genève. - Vécut à Genève après la révocation de l''Édit de Nantes [http://data.bnf.fr/ark:/12148/cb121711117#foaf:Person]
</ud>
<ud>
Claude Richer (<dat when="1680">1680</dat>) Abbé. - Mathématicien [http://data.bnf.fr/ark:/12148/cb12532604f#foaf:Person]
</ud>
<ud>
Pierre Jartoux (<dat when="1680">1680</dat>) Astronome et missionnaire jésuite en Chine [http://data.bnf.fr/ark:/12148/cb15367486z#foaf:Person]
</ud>
<ud>
Paolino Chelucci (<en type="li">Lucca, Italie</en>, <dat when="1681">1681</dat>) Professeur d''éloquence à l''Université de Rome. - Mathématicien [http://data.bnf.fr/ark:/12148/cb104300443#foaf:Person]
</ud>
<ud>
Roger Cotes (<en type="li">Burbage (Leicestershire)</en>, <dat when="1682">1682</dat>) Mathématicien. - Professeur d''astronomie et de philosophie expérimentale au Trinity College, Cambridge (1707-). - A édité la seconde édition des "Principia" de Newton [http://data.bnf.fr/ark:/12148/cb123946202#foaf:Person]
</ud>
<ud>
Noël Regnault (<dat when="1683">1683</dat>) Jésuite. - Professeur de mathématiques et physique au collège de Paris [http://data.bnf.fr/ark:/12148/cb12218681d#foaf:Person]
</ud>
<ud>
Johann Matthias Hase (<dat when="1684">1684</dat>) Géographe et cartographe ; historien. - Mathématicien [http://data.bnf.fr/ark:/12148/cb13007561v#foaf:Person]
</ud>
<ud>
Brook Taylor (<dat when="1685">1685</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb12315365s#foaf:Person]
</ud>
<ud>
Giovanni Poleni (<en type="li">Venise, Italie</en>, <dat when="1685">1685</dat>) Physicien, mathématicien et archéologue [http://data.bnf.fr/ark:/12148/cb12161210z#foaf:Person]
</ud>
<ud>
Jean-Edme Gallimard (<en type="li">Paris</en>, <dat when="1685">1685</dat>) Professeur de mathématiques [http://data.bnf.fr/ark:/12148/cb120827146#foaf:Person]
</ud>
<ud>
Jai Singh (<en type="li">Amber (Rajasthan, Inde)</en>, <dat when="1686">1686</dat>) Mahārāja de Jaipur (Rajasthan, Inde) de 1699 à 1743. - Fondateur de la ville de Jaipur (en 1727). - Chef du clan rajput des Kachhwa. - Bâtisseur de cinq observatoires astronomiques (yantra) dans l''Inde du Nord, à Delhi, Jaipur, Mathura, Varanasi et Ujjain. - Publia des tables astronomiques. - Les dates biographiques (1688-1743) sont aussi parfois retenues [http://data.bnf.fr/ark:/12148/cb16578505b#foaf:Person]
</ud>
<ud>
Nicolas Bernoulli (<dat when="1687">1687</dat>) Mathématicien et juriste suisse [http://data.bnf.fr/ark:/12148/cb13510346s#foaf:Person]
</ud>
<ud>
Robert Simson (<dat when="1687">1687</dat>) Mathématicien. - A été professeur à l''Université de Glasgow, GB [http://data.bnf.fr/ark:/12148/cb12399224j#foaf:Person]
</ud>
<ud>
Joseph-Nicolas Delisle (<en type="li">Paris</en>, <dat when="1688">1688</dat>) Astronome. - Il reçut l''enseignement de Cassini II. - Professeur de mathématiques au Collège de France et géographe de la marine. - Membre de l''Institut, Académie des sciences (<dat when="1714">1714</dat>). - Fondateur de l''École d''astronomie de Saint-Pétersbourg (à partir de 1725), a séjourné en Russie jusqu''en 1747 [http://data.bnf.fr/ark:/12148/cb12150746w#foaf:Person]
</ud>
<ud>
Louis-Bertrand Castel (<en type="li">Montpellier</en>, <dat when="1688">1688</dat>) Jésuite (<dat when="1703">1703</dat>). - Philosophe et mathématicien [http://data.bnf.fr/ark:/12148/cb12462543h#foaf:Person]
</ud>
<ud>
Pierre Brumoy (<en type="li">Rouen</en>, <dat when="1688">1688</dat>) Jésuite en 1704. - Professeur de rhétorique à Caen, précepteur du prince de Talmont, professeur de mathématiques au collège de Louis-le-Grand à Paris. - Collabore au Journal de Trévoux de 1722 à 1739. - Littérateur [http://data.bnf.fr/ark:/12148/cb12069382v#foaf:Person]
</ud>
<ud>
Willem Jacob''s Gravesande (<dat when="1688">1688</dat>) Physicien. - Philosophe. - Professeur de mathématique et astronomie à Leyde, Pays-Bas. - Éditeur du "Journal littéraire de la Haye", devenu "Journal de la République des Lettres" [http://data.bnf.fr/ark:/12148/cb12218384m#foaf:Person]
</ud>
<ud>
Antoine Gaubil (<en type="li">Gaillac (Aveyron)</en>, <dat when="1689">1689</dat>) Jésuite et missionnaire en Chine. - Établit un observatoire à Pékin, dans la résidence française. - Écrit sur l''astronomie, la géographie, l''histoire et la littérature de la Chine [http://data.bnf.fr/ark:/12148/cb12150997b#foaf:Person]
</ud>
<ud>
Giovanni Gaetano Bottari (<en type="li">Rome</en>, <dat when="1689">1689</dat>) Savant prélat. - A étudié les langues et la littérature de l''Antiquité, les mathématiques, la philosophie et la théologie. - Membre de l''Académie della Crusca. - Conservateur de la bibliothèque du Vatican [http://data.bnf.fr/ark:/12148/cb12516784r#foaf:Person]
</ud>
<ud>
Robert Smith (<en type="li">Lea, GB</en>, <dat when="1689">1689</dat>) Professeur de mathématiques et de philosophie naturelle à Cambridge [http://data.bnf.fr/ark:/12148/cb15075770m#foaf:Person]
</ud>
<ud>
Christian Goldbach (<dat when="1690">1690</dat>) Mathématicien allemand [http://data.bnf.fr/ark:/12148/cb124384045#foaf:Person]
</ud>
<ud>
Johann Friedrich Weidler (Gros-Neuhausen, Allemagne, <dat when="1691">1691</dat>) Écrivain, mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb151541516#foaf:Person]
</ud>
<ud>
Esprit Pezenas (<en type="li">Avignon</en>, <dat when="1692">1692</dat>) Jésuite. - Astronome et mathématicien. - Professeur d''hydrographie à Marseille et directeur de l''Observatoire de Marseille (<dat when="1749">1749</dat>) [http://data.bnf.fr/ark:/12148/cb12120600p#foaf:Person]
</ud>
<ud>
James Stirling (<en type="li">Garden, GB</en>, <dat when="1692">1692</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb13475586v#foaf:Person]
</ud>
<ud>
Petrus Van Musschenbroek (<dat when="1692">1692</dat>) Physicien, docteur en médecine et en philosophie. - Fut l''inventeur de la pyrométrie. - Fut professeur de philosophie naturelle, de mathématiques et d''astronomie à l''Université d''Utrecht, puis professeur à Leiden [http://data.bnf.fr/ark:/12148/cb13475113j#foaf:Person]
</ud>
<ud>
Diego de Torres Villarroel (<dat when="1693">1693</dat>) Prêtre catholique. - Homme de lettres. - Professeur de mathématiques à l''université de Salamanque [http://data.bnf.fr/ark:/12148/cb119268467#foaf:Person]
</ud>
<ud>
Giovanni Bianchi (<en type="li">Rimini (Italie)</en>, <dat when="1693">1693</dat>) Médecin. - Professeur d''anatomie à l''Université de Sienne (1741-). - Auteur d''ouvrages médicaux, archéologiques, astronomiques, etc. [http://data.bnf.fr/ark:/12148/cb10649342z#foaf:Person]
</ud>
<ud>
Christfried Kirch (<dat when="1694">1694</dat>) Astronome allemand. - Il succéda à son père Gottfried (1639-1710) dans la direction de l''Observatoire royal de Prusse (1716-1740). - Membre de l''Académie des sciences de Berlin (<dat when="1716">1716</dat>) et associé de celles de Paris (<dat when="1723">1723</dat>) et de Saint-Pétersbourg [http://data.bnf.fr/ark:/12148/cb12648455m#foaf:Person]
</ud>
<ud>
Dominique-François Rivard (<dat when="1697">1697</dat>) Mathématicien. - Philosophe. - Professeur au collège de Beauvais [http://data.bnf.fr/ark:/12148/cb119220838#foaf:Person]
</ud>
<ud>
Abbé Deidier (<en type="li">Marseille</en>, <dat when="1698">1698</dat>) Abbé. - Mathématicien. - Professeur d''artillerie à l''Ecole militaire de La Fère [http://data.bnf.fr/ark:/12148/cb102670411#foaf:Person]
</ud>
<ud>
Colin MacLaurin (<en type="li">Kilmodan, GB</en>, <dat when="1698">1698</dat>) Mathématicien et physicien [http://data.bnf.fr/ark:/12148/cb12534513m#foaf:Person]
</ud>
<ud>
Pierre-Louis Moreau de Maupertuis (Saint-Malo, Ille-et-Villaine, <dat when="1698">1698</dat>) Philosophe, astronome et physicien. - Fut invité par Frédéric II à réorganiser puis présider l''Académie de Berlin. - Ami puis ennemi de Voltaire, qui écrivit contre lui "Micromégas". - Membre de l''Académie française (élu en 1743) [http://data.bnf.fr/ark:/12148/cb11915229j#foaf:Person]
</ud>
<ud>
Charles-Étienne-Louis Camus (Crécy-en-Brie (Seine-et-Marne), <dat when="1699">1699</dat>) Mathématicien. - Astronome. - Participa à l''expédition de 1736 en Laponie. - Membre de l''Académie des sciences (<dat when="1727">1727</dat>) et de l''Académie d''architecture (<dat when="1739">1739</dat>) [http://data.bnf.fr/ark:/12148/cb12181030f#foaf:Person]
</ud>
<ud>
Johann Ludwig Levin Gebhardi (<en type="li">Braunschweig, Allemagne</en>, <dat when="1699">1699</dat>) Historien, professeur de philologie à l''académie équestre de Lüneburg (<dat when="1723">1723</dat>). - Mathématicien [http://data.bnf.fr/ark:/12148/cb143273694#foaf:Person]
</ud>
<ud>
Daniel Bernoulli (Groningue (Pays-Bas), <dat when="1700">1700</dat>) Mathématicien, physicien et astronome. - Fut professeur à Saint-Petersbourg (1725-1733) et à Bâle (1733-) [http://data.bnf.fr/ark:/12148/cb122991859#foaf:Person]
</ud>
<ud>
Sámuel Mikoviny (<en type="li">Ábelfalva, aujourd''hui Ábelová, Slovaquie</en>, <dat when="1700">1700</dat>) Cartographe. - Officier du génie. - Spécialiste en hydraulique. - Mathématicien. - Disciple de Bél Mátyás (1684-1749). - Études à Jena et à Nuremberg, Allemagne [http://data.bnf.fr/ark:/12148/cb103650124#foaf:Person]
</ud>
<ud>
Anders Celsius (<dat when="1701">1701</dat>) Astronome et naturaliste. - Professeur d''astronomie à l''université d''Uppsala (<dat when="1730">1730</dat>) [http://data.bnf.fr/ark:/12148/cb14606035v#foaf:Person]
</ud>
<ud>
Charles-Marie de La Condamine (<en type="li">Paris</en>, <dat when="1701">1701</dat>) Savant. - Astronome. - Géographe. Mesura l''arc du Méridien avec Godin et Bouguer. - Membre de l''Académie française (élu en 1760) [http://data.bnf.fr/ark:/12148/cb119102567#foaf:Person]
</ud>
<ud>
Georg Wolfgang Krafft (<en type="li">Tuttlingen (Allemagne)</en>, <dat when="1701">1701</dat>) Physicien, professeur de mathématiques et de physique [http://data.bnf.fr/ark:/12148/cb10587905k#foaf:Person]
</ud>
<ud>
Johannes Nicolaus Frobesius (<en type="li">Goslar, Allemagne</en>, <dat when="1701">1701</dat>) Mathématicien et professeur de philosophie [http://data.bnf.fr/ark:/12148/cb12355199c#foaf:Person]
</ud>
<ud>
Niccolò de Martino (<dat when="1701">1701</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb16265590z#foaf:Person]
</ud>
<ud>
Johann Lorenz Schmidt (<dat when="1702">1702</dat>) Fils de pasteur, a étudié la théologie et s''est intéressé à la  philosophie et aux mathématiques. - A publié en 1735 une traduction annotée de la première partie de la Bible, les cinq livres de Moïse (ou Torah ou Pentateuque), connue sous le nom de "Wertheimer Bible", laquelle a été censurée par l''empereur [http://data.bnf.fr/ark:/12148/cb150701237#foaf:Person]
</ud>
<ud>
Antoine Deparcieux (<dat when="1703">1703</dat>) Mathématicien et statisticien. - Fut constructeur de cadrans solaires et inventeur de machines pour élever les eaux et de presse pour le tabac. - Membre de l''Académie des sciences (<dat when="1746">1746</dat>) [http://data.bnf.fr/ark:/12148/cb121904326#foaf:Person]
</ud>
<ud>
Bernard-Laurent Soumille (<dat when="1703">1703</dat>) Mathématicien, physicien et agronome. - Prêtre-bénéficier du chapitre de Villeneuve-lès-Avignon (à partir de 1736, environ). - Correspondant de l''Académie royale des sciences de Paris [http://data.bnf.fr/ark:/12148/cb130919156#foaf:Person]
</ud>
<ud>
Thomas Le Seur (<dat when="1703">1703</dat>) Franciscain. - Professeur de mathématique à l''Université de la Sapience (Rome) [http://data.bnf.fr/ark:/12148/cb155933751#foaf:Person]
</ud>
<ud>
Gabriel Cramer (<en type="li">Genève, Suisse</en>, <dat when="1704">1704</dat>) Professeur de philosophie et de mathématiques des Académies et Sociétés royales de Londres, de Berlin, de Montpellier, de Lyon et de l''Académie de l''Institut de Bologne [http://data.bnf.fr/ark:/12148/cb15006804w#foaf:Person]
</ud>
<ud>
Guillaume Le Blond (<en type="li">Paris</en>, <dat when="1704">1704</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb14330967m#foaf:Person]
</ud>
<ud>
Henri Michel Sauvage (<en type="li">Verdun</en>, <dat when="1704">1704</dat>) Jésuite. - Professeur d''humanités, de mathématiques et de philosophie [http://data.bnf.fr/ark:/12148/cb16180102s#foaf:Person]
</ud>
<ud>
Jacopo Belgrado (<dat when="1704">1704</dat>) Jésuite. - Physicien, mathématicien et archéologue [http://data.bnf.fr/ark:/12148/cb12161284h#foaf:Person]
</ud>
<ud>
Johann Andreas von Segner (<dat when="1704">1704</dat>) Naturaliste, mathématicien, médecin, logicien, philosophe. - Né à Presbourg (l''actuelle Bratislava), il fit toute sa carrière en Allemagne (à Iéna, Göttingen, Halle notamment) [http://data.bnf.fr/ark:/12148/cb12316478n#foaf:Person]
</ud>
<ud>
Louis Godin (<en type="li">Paris</en>, <dat when="1704">1704</dat>) Astronome, membre de l''Académie des sciences [http://data.bnf.fr/ark:/12148/cb15004534h#foaf:Person]
</ud>
<ud>
John Nourse (<dat when="1705">1705</dat>) Variante(s) de prénom : Jean. - Libraire ; libraire (ordinaire) de Sa Majesté (<dat when="1762">1762</dat>) ; libraire de la "Society for the Encouragement of learning". - Baptisé à Oxford le 8 juillet 1705 ; fils d''un chirurgien. En apprentissage chez le libraire de Londres John I Osborne d''août 1722 à oct. 1729. Établi vers 1730. Succède au libraire William Mears après lui avoir été associé. Spécialiste des publications scientifiques, particulièrement de mathématiques, et des éditions étrangères, de philosophes notamment. Séjourne à Paris en 1780. Décédé à Kensington en avril 1765. Son frère Charles Nourse puis Francis Wingrave lui succèdent [http://data.bnf.fr/ark:/12148/cb13605346z#foaf:Person]
</ud>
<ud>
Edme-Gilles Guyot (<en type="li">Paris</en>, <dat when="1706">1706</dat>) Les ouvrages "Nouvelles récréations physiques et mathématiques" et "Essai sur la construction des ballons aérostatiques et sur la manière de les diriger" lui sont attribués par Hoefer et Quérard. - DBF et Michaud soulignent la confusion entre lui et Guillaume-Germain Guyot pour l''attribution de ces ouvrages [http://data.bnf.fr/ark:/12148/cb14651894d#foaf:Person]
</ud>
<ud>
Girolamo Settimo (<dat when="1706">1706</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb162655930#foaf:Person]
</ud>
<ud>
Giuseppe Maria Asclepi (<dat when="1706">1706</dat>) Jésuite, enseigna les mathématiques et les humanités [http://data.bnf.fr/ark:/12148/cb12240755t#foaf:Person]
</ud>
<ud>
Benjamin Robins (<en type="li">Bath, GB</en>, <dat when="1707">1707</dat>) Mathématicien et ingénieur militaire. - Pamphlétaire [http://data.bnf.fr/ark:/12148/cb121289860#foaf:Person]
</ud>
<ud>
Francesco Ottavio Magnocavalli (<en type="li">Casale, Italie</en>, <dat when="1707">1707</dat>) Architecte, mathématicien et poète [http://data.bnf.fr/ark:/12148/cb10732099c#foaf:Person]
</ud>
<ud>
Jean Paul Grandjean de Fouchy (<en type="li">Paris</en>, <dat when="1707">1707</dat>) Astronome. - Secrétaire perpétuel de l''Académie des Sciences (<dat when="1743">1743</dat>) [http://data.bnf.fr/ark:/12148/cb10667779b#foaf:Person]
</ud>
<ud>
José Quiroga (<dat when="1707">1707</dat>) Jésuite, mathématicien et pilote [http://data.bnf.fr/ark:/12148/cb12570261h#foaf:Person]
</ud>
<ud>
Leonhard Euler (<en type="li">Bâle (Suisse)</en>, <dat when="1707">1707</dat>) Mathématicien et physicien. - Philosophe, théologien et orientaliste. - Membre de l''Académie des sciences de Saint-Pétersbourg (à partir de 1733) et de celle de Berlin (à partir de 1741), et membre associé de celle de Paris (à partir de 1755) [http://data.bnf.fr/ark:/12148/cb12157666x#foaf:Person]
</ud>
<ud>
Giovanni Francesco Mauro Melchior Salvemini da Castiglione (<dat when="1708">1708</dat>) Professeur de mathématiques à Utrecht (<dat when="1751">1751</dat>) puis directeur de la classe de mathématiques de l''Académie de Berlin. - Découvrit la solution du problème consistant à inscrire dans un cercle un triangle dont les côtés passent par trois points donnés [http://data.bnf.fr/ark:/12148/cb130145422#foaf:Person]
</ud>
<ud>
Eustachio Zanotti (<en type="li">Bologne, Italie</en>, <dat when="1709">1709</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb12202196d#foaf:Person]
</ud>
<ud>
Giordano Riccati (<en type="li">Castelfranco Veneto, Italie</en>, <dat when="1709">1709</dat>) Comte. - Mathématicien, acousticien et théoricien de la musique. - Fut aussi physicien et architecte [http://data.bnf.fr/ark:/12148/cb12252383n#foaf:Person]
</ud>
<ud>
Georg Matthias Bose (<en type="li">Leipzig (Allemagne)</en>, <dat when="1710">1710</dat>) Astronome, physicien, mathématicien. - Professeur de physique à l''université de Wittenberg [http://data.bnf.fr/ark:/12148/cb14065311n#foaf:Person]
</ud>
<ud>
Jacques Audierne (<dat when="1710">1710</dat>) Auteur comique et mathématicien [http://data.bnf.fr/ark:/12148/cb10425836p#foaf:Person]
</ud>
<ud>
Johann Bernoulli (<dat when="1710">1710</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb14852857s#foaf:Person]
</ud>
<ud>
Thomas Simpson (<dat when="1710">1710</dat>) Membre de la société royale de Londres, professeur de mathématiques à Woolwich (en 1755) [http://data.bnf.fr/ark:/12148/cb103759851#foaf:Person]
</ud>
<ud>
Alexandre-Gui Pingré (<en type="li">Paris</en>, <dat when="1711">1711</dat>) Génovéfain. - Astronome. - Correspondant (à partir de 1753), puis associé libre de l''Académie des sciences. - Géographe de la Marine. - Chancelier de l''Université de Paris (1769-17..). - Bibliothécaire de Sainte-Geneviève (à partir de 1792) [http://data.bnf.fr/ark:/12148/cb12151017m#foaf:Person]
</ud>
<ud>
François Jacquier (Vitry-le-François (<en type="li">Marne)</en>, <dat when="1711">1711</dat>) Religieux de l''ordre des Minimes. - Professeur de physique et mathématiques [http://data.bnf.fr/ark:/12148/cb12198105d#foaf:Person]
</ud>
<ud>
Laura Bassi (<en type="li">Bologne, Italie</en>, <dat when="1711">1711</dat>) Mathématicienne et physicienne. - Professeur de biologie et de physique à l''Université de Bologne. - Première femme titulaire d''une chaire universitaire en Europe [http://data.bnf.fr/ark:/12148/cb135103950#foaf:Person]
</ud>
<ud>
Ottaviano Cametti (<en type="li">Gattinara, Italie</en>, <dat when="1711">1711</dat>) Mathématicien, physicien et historien [http://data.bnf.fr/ark:/12148/cb10464765k#foaf:Person]
</ud>
<ud>
Pierre Joseph de Rivaz (<dat when="1711">1711</dat>) Mathématicien, inventeur-mécanicien et historien. - Directeur des salines de Moutiers. - Né dans le Valais et mort à Moutiers (Tarentaise) [http://data.bnf.fr/ark:/12148/cb128398731#foaf:Person]
</ud>
<ud>
Rugerius Josephus Boscovich (Raguse aujourd''hui Dubrovnik (<en type="li">Croatie)</en>, <dat when="1711">1711</dat>) Jésuite. - Physicien, mathématicien, astronome et philosophe. - Professeur de mathématiques à Rome, Pavie et Milan. - Directeur de l''optique de la Marine royale à Paris et membre de la "Royal Society" à Londres. - Dans son ouvrage majeur "Théorie de la philosophie naturelle" il élabore la théorie initiale des forces et de la structure fondamentale de la matière, dont les concepts ont trouvé écho dans les découvertes de la physique moderne. - Il publie nombre d''ouvrages contenant ses découvertes en mathématiques, en astronomie, en géophysique et en archéologie. - Il mit au point différents instruments optiques, astronomiques et géodésiques et réalisa des expertises et des mesures hydrotechniques, géodésiques, cartographiques et statiques. - Il consolida la coupole de la basilique Saint-Pierre de Rome et de la flèche de la cathédrale de Milan [http://data.bnf.fr/ark:/12148/cb12054879x#foaf:Person]
</ud>
<ud>
Jean-Paul de Gua de Malves (<en type="li">Malves (Aude)</en>, <dat when="1712">1712</dat>) Abbé. - Mathématicien, géomètre, économiste politique. - Titulaire de la chaire de philosophie au Collège de France (1742-1749) [http://data.bnf.fr/ark:/12148/cb15325204x#foaf:Person]
</ud>
<ud>
Samuel König (<dat when="1712">1712</dat>) Date de mort : 21 août ou 22 juillet 1757. - A également écrit en français. - Mathématicien, philosophe et juriste [http://data.bnf.fr/ark:/12148/cb120941298#foaf:Person]
</ud>
<ud>
Alexis Claude Clairaut (<en type="li">Paris (France)</en>, <dat when="1713">1713</dat>) Mathématicien très précoce et astronome. - Ami de Voltaire et de la marquise Du Chatelet [http://data.bnf.fr/ark:/12148/cb124002538#foaf:Person]
</ud>
<ud>
Giammaria Ortes (<dat when="1713">1713</dat>) Moine camaldule. - Mathématicien, économiste et philosophe [http://data.bnf.fr/ark:/12148/cb13753557w#foaf:Person]
</ud>
<ud>
Nicolas-Louis de La Caille (<en type="li">Rumigny, Ardennes</en>, <dat when="1713">1713</dat>) Abbé. - Professeur de mathématiques au Collège Mazarin. - Membre de l''Académie royale des sciences [http://data.bnf.fr/ark:/12148/cb12124353d#foaf:Person]
</ud>
<ud>
Alessandro Vittorio Papacino d''Antoni (<en type="li">Villafranca, Italie</en>, <dat when="1714">1714</dat>) Ingénieur, mathématicien. - Membre de l''Académie des sciences de Turin [http://data.bnf.fr/ark:/12148/cb10709482t#foaf:Person]
</ud>
<ud>
César-François Cassini de Thury (Thury-sous-Clermont (<en type="li">Oise)</en>, <dat when="1714">1714</dat>) Astronome et géomètre. - Membre de l''Académie des sciences (<dat when="1736">1736</dat>). - Fils de Jacques Cassini (1677-1756) et père de Jean-Dominique Cassini (1748-1845). - Participa avec son père à la mesure de la perpendiculaire de l''Observatoire. - Son oeuvre principale est la carte de France, première carte de base de ce pays, dont la publication commença en 1756 [http://data.bnf.fr/ark:/12148/cb12241101g#foaf:Person]
</ud>
<ud>
Giovanni Battista Audiffredi (<en type="li">Saorge, Italie</en>, <dat when="1714">1714</dat>) Dominicain. - Astronome. - Préfet de la Biblioteca Casanatense, Rome (1759-1794). - Né Giulio Cesare Audiffredi, change de prénom en entrant chez les Dominicains (<dat when="1730">1730</dat>) [http://data.bnf.fr/ark:/12148/cb13595556h#foaf:Person]
</ud>
<ud>
John Winthrop (<dat when="1714">1714</dat>) Professeur de Mathématiques et de Philosophie naturelle à Harvard [http://data.bnf.fr/ark:/12148/cb14594660x#foaf:Person]
</ud>
<ud>
François-Joachim Duport-Dutertre (Saint-Servan (Ille-et-Vilaine), <dat when="1715">1715</dat>) Littérateur. - Mathématicien. - Voyageur [http://data.bnf.fr/ark:/12148/cb12533121w#foaf:Person]
</ud>
<ud>
Pierre-Charles Le Monnier (<en type="li">Paris</en>, <dat when="1715">1715</dat>) Astronome. - Membre de l''Académie des sciences (<dat when="1741">1741</dat>). - Professeur de physique au Collège de France (de 1749 à 1793), puis membre de la classe des sciences physiques et mathématiques de l''Institut [http://data.bnf.fr/ark:/12148/cb121064574#foaf:Person]
</ud>
<ud>
André-Pierre Le Guay de Prémontval (Charenton (Val-de-Marne), <dat when="1716">1716</dat>) Professeur de mathématiques. - Membre de l''Académie de Berlin [http://data.bnf.fr/ark:/12148/cb122271303#foaf:Person]
</ud>
<ud>
Eugénios Voúlgaris (<en type="li">Corfou (Îles Ioniennes, Grèce)</en>, <dat when="1716">1716</dat>) Métropolite de l''Église orthodoxe grecque. - Théologien, philosophe et mathématicien. - "Éducateur de la Nation" et précurseur des Lumières en Grèce ; traducteur de Voltaire et Virgile. - Nommé évêque en Russie [http://data.bnf.fr/ark:/12148/cb12564304q#foaf:Person]
</ud>
<ud>
Gottfried Ploucquet (<dat when="1716">1716</dat>) Philosophe, mathématicien et théologien. - Professeur de philosophie à l''université de Tübingen (1750-1782) [http://data.bnf.fr/ark:/12148/cb13324024g#foaf:Person]
</ud>
<ud>
Leonardo Ximenes (<en type="li">Trapani, Italie</en>, <dat when="1716">1716</dat>) Jésuite. - Geographe, astronome, mathématicien [http://data.bnf.fr/ark:/12148/cb106577403#foaf:Person]
</ud>
<ud>
D'' Alembert (<en type="li">Paris</en>, <dat when="1717">1717</dat>) Mathématicien et philosophe. - Nom patronymique : Jean Le Rond, d̲i̲t̲ d'' Alembert. - Membre de l''Institut, Académie française (élu en 1754) [http://data.bnf.fr/ark:/12148/cb118883708#foaf:Person]
</ud>
<ud>
Josef Anton Nagel (<dat when="1717">1717</dat>) Professeur, mathématicien, scientifique allemand [http://data.bnf.fr/ark:/12148/cb12091922b#foaf:Person]
</ud>
<ud>
Augustin Darquier de Pellepoix (<en type="li">Toulouse</en>, <dat when="1718">1718</dat>) Astronome. - Associé non résidant de l''Académie des sciences. - Receveur des tailles de la généralité d''Auch [http://data.bnf.fr/ark:/12148/cb12155190x#foaf:Person]
</ud>
<ud>
Claude-François Berthelot (<dat when="1718">1718</dat>) Ingénieur. - Professeur de mathématiques à l''École royale militaire. - Inventeur de l''"affut de Gribeauval" [http://data.bnf.fr/ark:/12148/cb134984423#foaf:Person]
</ud>
<ud>
François-César Le Tellier Courtanvaux (<dat when="1718">1718</dat>) Duc de Doudeauville. - Capitaine-colonel des cent-suisses de la garde du roi. - Astronome, membre de l''Académie des sciences [http://data.bnf.fr/ark:/12148/cb121904446#foaf:Person]
</ud>
<ud>
Gaspard-François-Anne de Forbin (<dat when="1718">1718</dat>) Né le 8 ou le 18 juillet 1718. - Embrassa d'' abord la carrière militaire. - Chevalier de Malte. - Mathématicien et Physicien [http://data.bnf.fr/ark:/12148/cb12108181n#foaf:Person]
</ud>
<ud>
István Hatvani (<en type="li">Rimaszombat, aujourd''hui Rimavská Sobota, Slovaquie</en>, <dat when="1718">1718</dat>) Mathématicien, physicien. - Médecin. - Pédagogue, professeur à Debrecen,Református Kollégium, Hongrie. - Diplômé de l''Université de Bâle, Suisse [http://data.bnf.fr/ark:/12148/cb10355679v#foaf:Person]
</ud>
<ud>
Jean-Philippe Loys de Chéseaux (<dat when="1718">1718</dat>) Astronome et physicien. - Né à Lausanne, mort à Paris [http://data.bnf.fr/ark:/12148/cb133196302#foaf:Person]
</ud>
<ud>
Joseph Amiot (<en type="li">Toulon</en>, <dat when="1718">1718</dat>) Jésuite de 1737 à 1773 (ordonné prêtre en 1749). - Sinologue et astronome. - Missionnaire en Chine (à partir de 1749) [http://data.bnf.fr/ark:/12148/cb12112654w#foaf:Person]
</ud>
<ud>
Maria Gaetana Agnesi (<en type="li">Milan, Italie</en>, <dat when="1718">1718</dat>) Mathématicienne [http://data.bnf.fr/ark:/12148/cb105423187#foaf:Person]
</ud>
<ud>
Abraham Gotthelf Kästner (<en type="li">Leipzig, Allemagne</en>, <dat when="1719">1719</dat>) Mathématicien. - Poète et épigrammatiste. - Critique [http://data.bnf.fr/ark:/12148/cb123392338#foaf:Person]
</ud>
<ud>
Giuseppe Toaldo (<en type="li">Pianezze, Italie</en>, <dat when="1719">1719</dat>) Prêtre. - Physicien. - Professeur d''astronomie, de géographie et de météorologie à l''Université de Padoue [http://data.bnf.fr/ark:/12148/cb10578331h#foaf:Person]
</ud>
<ud>
Jens Kraft (<dat when="1720">1720</dat>) Philosophe des lumières danois. - Professeur de mathématiques et de philosophie à Soroe [http://data.bnf.fr/ark:/12148/cb12442689p#foaf:Person]
</ud>
<ud>
Charles Walmesley (<dat when="1722">1722</dat>) Évêque de Rama. - Astronome [http://data.bnf.fr/ark:/12148/cb10748264x#foaf:Person]
</ud>
<ud>
Jean Chappe d''Auteroche (<en type="li">Mauriac (Cantal)</en>, <dat when="1722">1722</dat>) Astronome. - Explorateur en Sibérie et en Californie [http://data.bnf.fr/ark:/12148/cb12402595h#foaf:Person]
</ud>
<ud>
Jean-Louis Dupain-Triel (<dat when="1722">1722</dat>) Homme de lettres, poète. - S''intéressa aux mathématiques, à la géographie et à l''enseignement des arts [http://data.bnf.fr/ark:/12148/cb119011560#foaf:Person]
</ud>
<ud>
Louis-Jacques Goussier (<dat when="1722">1722</dat>) Mathématicien et inventeur [http://data.bnf.fr/ark:/12148/cb13485055d#foaf:Person]
</ud>
<ud>
Baien Miura (<dat when="1723">1723</dat>) Lettré du milieu de l''époque d''Edo. - A créé son propre système de pensée philosophique appelé "jōrigaku" : méthode de spéculation fondée sur l''éthique, la logique, les mathématiques et la physique, recourant à une pensée dialectique appelée "hankan gōitsu" [http://data.bnf.fr/ark:/12148/cb12293200x#foaf:Person]
</ud>
<ud>
Didier Robert de Vaugondy (<dat when="1723">1723</dat>) Géographe ordinaire du roi, professeur de mathématiques et de géographie, fils de Gilles Robert Vaugondy. - Didier signe "Robert de Vaugondy" [http://data.bnf.fr/ark:/12148/cb12380757h#foaf:Person]
</ud>
<ud>
Étienne-Nicolas Blondeau (<dat when="1723">1723</dat>) Professeur de mathématiques. - Ingénieur de la marine. - Collaborateur de l''Encyclopédie méthodique (1782-1783?) [http://data.bnf.fr/ark:/12148/cb10737141j#foaf:Person]
</ud>
<ud>
Johann Tobias Mayer (<dat when="1723">1723</dat>) Mathématicien et astronome, a travaillé avec Homann Herben de 1746 à 1751, puid pour Kilian à partir de 1752 [http://data.bnf.fr/ark:/12148/cb153509764#foaf:Person]
</ud>
<ud>
Johann Tobias Mayer (<dat when="1723">1723</dat>) Astronome allemand [http://data.bnf.fr/ark:/12148/cb11958863x#foaf:Person]
</ud>
<ud>
Nicole-Reine Lepaute (<en type="li">Paris</en>, <dat when="1723">1723</dat>) Née Nicole-Reine Étable de La Brière, épouse de Jean-André Lepaute, horloger du Roi. - Mathématicienne, astronome [http://data.bnf.fr/ark:/12148/cb14555447k#foaf:Person]
</ud>
<ud>
Tobias Mayer (<en type="li">Marbach (Allemagne)</en>, <dat when="1723">1723</dat>) Astronome, mathématicien. - Directeur de l''Observatoire de Göttingen, Allemagne [http://data.bnf.fr/ark:/12148/cb121551484#foaf:Person]
</ud>
<ud>
Edme-Sébastien Jeaurat (<dat when="1724">1724</dat>) Ingénieur-géographe et astronome. - Professeur à l''école militaire. - Membre de l''Académie des sciences [http://data.bnf.fr/ark:/12148/cb122175393#foaf:Person]
</ud>
<ud>
François Para Du Phanjas (Chabottes (Hautes-Alpes), <dat when="1724">1724</dat>) Philosophe et mathématicien [http://data.bnf.fr/ark:/12148/cb12528863r#foaf:Person]
</ud>
<ud>
Georges Louis Lesage (<en type="li">Genève</en>, <dat when="1724">1724</dat>) Mathématicien et physicien suisse. - Etudie à Genève puis Paris. - Etabli à Genève [http://data.bnf.fr/ark:/12148/cb155857475#foaf:Person]
</ud>
<ud>
Guillaume-Germain Guyot (<en type="li">Orléans</en>, <dat when="1724">1724</dat>) Les ouvrages "Nouvelles récréations physiques et mathématiques" et "Essai sur la construction des ballons aérostatiques et sur la manière de les diriger" lui sont attribués par le DBF et par Samuel Ersch dans "La France littéraire contenant les auteurs français de 1771 à 1796", DBF. - Quérard et Michaud soulignent la confusion entre lui et Edme-Gilles Guyot pour l''attribution de ces ouvrages [http://data.bnf.fr/ark:/12148/cb12214218k#foaf:Person]
</ud>
<ud>
Guillaume-Hyacinthe-Joseph-Jean-Baptiste Le Gentil de La Galaisière (<dat when="1725">1725</dat>) Astronome et voyageur. - Entre à l''Observatoire en 1750. - Membre de l''Académie des sciences en 1753 [http://data.bnf.fr/ark:/12148/cb12151459n#foaf:Person]
</ud>
<ud>
Jean-Étienne Montucla (<dat when="1725">1725</dat>) Historien des mathématiques [http://data.bnf.fr/ark:/12148/cb12127574n#foaf:Person]
</ud>
<ud>
Louis-Charles Desnos (<dat when="1725">1725</dat>) Libraire ; libraire et (ingénieur) géographe (pour les globes et les sphères) du roi de Danemark (ou : de Sa Majesté danoise) (1769-1789). - Fils d''un marchand drapier de Pont-Sainte-Maxence (Oise). Apprenti fondeur de caractères à Paris à partir d''avril 1745 (reçu maître fondeur en 1757).  Ingénieur géographe (de la ville de Paris à partir de 1769), fabricant et marchand de sphères et d''instruments astronomiques établi vers 1753 en succession de Jacques Hardy, après avoir épousé en 1749 la veuve de son fils Nicolas Hardy ; également marchand d''estampes et de cartes géographiques. Un des 12 libraires non jurés reçus le 4 oct. 1767. - Éditeur et auteur de nombreux atlas, almanachs et publications géographiques entre 1756 et 1795 env. Rédige également plusieurs catalogues de son fonds entre 1768 et 1792. Une partie de son fonds est rachetée en 1805 par Jean (17..-1839), marchand de cartes et d''estampes [http://data.bnf.fr/ark:/12148/cb12402252d#foaf:Person]
</ud>
<ud>
Rigobert Bonne (Raucourt (Meurthe-et-Moselle), <dat when="1727">1727</dat>) Ingénieur. - Géographe. - Hydrographe. - Célèbre par la projection qui porte son nom et qui remplacera pour la carte de France la projection de Cassini. D''abord ingénieur géographe et maître de mathématiques. En 1775 ingénieur hydrographe de la Marine. Fut mis à la retraite contre sa volonté en 1789. Collabora au Neptune américo-septentrional [http://data.bnf.fr/ark:/12148/cb12169793s#foaf:Person]
</ud>
<ud>
Chrysologue de Gy (Gy (Haute-Saône), <dat when="1728">1728</dat>) Capucin. - Astronome, cartographe et géologue [http://data.bnf.fr/ark:/12148/cb10728734z#foaf:Person]
</ud>
<ud>
Jean-Henri Lambert (<en type="li">Mulhouse, Suisse</en>, <dat when="1728">1728</dat>) Mathématicien, physicien, astronome et philosophe. - Spécialiste de géometrie. - En poste à l''Académie royale des sciences et belles lettres de Berlin (de 1765 à 1777) [http://data.bnf.fr/ark:/12148/cb12359659g#foaf:Person]
</ud>
<ud>
Le P.  Chrysologue (<en type="li">Gy</en>, <dat when="1728">1728</dat>) Capucin, nom de religion de Noël André. - Attiré par la géographie et l''astronomie, fut l''élève de Lemonnier. Mesura les altitudes des Vosges, du Jura et des Alpes. Se retira dans sa famille au moment de la Révolution.  En 1806 publia un important traité de géologie dont Cuvier fit un rapport élogieux [http://data.bnf.fr/ark:/12148/cb153054042#foaf:Person]
</ud>
<ud>
Paolo Frisi (<en type="li">Melegnano, Italie</en>, <dat when="1728">1728</dat>) Barnabite. - Mathématicien, astronome et écrivain. - Professeur dans les Écoles palatines de Milan (1764-) [http://data.bnf.fr/ark:/12148/cb120849325#foaf:Person]
</ud>
<ud>
Antonio Eximeno (<dat when="1729">1729</dat>) Théoricien de la musique et polémiste. - Jésuite, il devient professeur de rhétorique à l''Université de Valence, puis professeur de mathématiques à l''Académie militaire de Ségovie (<dat when="1764">1764</dat>). - Lorsque les jésuites sont expulsés d''Espagne en 1767, il se rend à Rome où il étudie la musique. - Connu aussi sous le pseud. : "Aristosseno Megareo" (BnF, Musique, fichier général auteurs), ou "Aristodemo Megareo" (Fétis) [http://data.bnf.fr/ark:/12148/cb13755053m#foaf:Person]
</ud>
<ud>
Charles Bossut (<dat when="1730">1730</dat>) Mathématicien, membre de l''Académie des sciences (<dat when="1779">1779</dat>), il participa à la rédaction de la partie mathématique de l''Encyclopédie [http://data.bnf.fr/ark:/12148/cb11763983g#foaf:Person]
</ud>
<ud>
Charles Bossut (<dat when="1730">1730</dat>) Mathématicien et physicien. - Membre de l''Académie des sciences, pensionnaire de la classe de mécanique (<dat when="1785">1785</dat>). - Écrivit plusieurs articles dans l''"Encyclopédie" [http://data.bnf.fr/ark:/12148/cb124599882#foaf:Person]
</ud>
<ud>
Charles Messier (Badonviller (Meurthe-et-Moselle), <dat when="1730">1730</dat>) Astronome de la marine. - Académicien (<dat when="1770">1770</dat>). - Membre de l''Institut [http://data.bnf.fr/ark:/12148/cb124827900#foaf:Person]
</ud>
<ud>
Étienne Bezout (<en type="li">Nemours</en>, <dat when="1730">1730</dat>) Mathématicien. - Membre de l''Académie des sciences [http://data.bnf.fr/ark:/12148/cb12267459g#foaf:Person]
</ud>
<ud>
Jean-Baptiste de Laborde (<dat when="1730">1730</dat>) Physicien et mathématicien. - Jésuite [http://data.bnf.fr/ark:/12148/cb13196726p#foaf:Person]
</ud>
<ud>
Joseph-Aignan Sigaud de La Fond (<en type="li">Bourges</en>, <dat when="1730">1730</dat>) Mathématicien, physicien et moraliste. - Professeur de physique à Bourges [http://data.bnf.fr/ark:/12148/cb12401095w#foaf:Person]
</ud>
<ud>
Pierre-Thomas Antelmy (<en type="li">Trigance, France</en>, <dat when="1730">1730</dat>) Mathématicien, professeur de mathématiques à l''École militaire [http://data.bnf.fr/ark:/12148/cb13011110m#foaf:Person]
</ud>
<ud>
Benito Bails (<dat when="1731">1731</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb162593727#foaf:Person]
</ud>
<ud>
Girolamo Francisco Cristiani (<en type="li">Brescia, Italie</en>, <dat when="1731">1731</dat>) Mathématicien et physicien [http://data.bnf.fr/ark:/12148/cb14065297x#foaf:Person]
</ud>
<ud>
Nicolas-Claude Duval-Le Roy (<dat when="1731">1731</dat>) Professeur de mathématiques et d''hydrographie, physicien et astronome. - Membre de l''Académie royale de marine. - Correspondant à l''Académie royale des sciences (<dat when="1789">1789</dat>), associé non résident de l''Institut (<dat when="1796">1796</dat>) [http://data.bnf.fr/ark:/12148/cb12548660k#foaf:Person]
</ud>
<ud>
Diderich Christian Fester (<dat when="1732">1732</dat>) Mathématicien et cartographe à Trondheim [http://data.bnf.fr/ark:/12148/cb15384550x#foaf:Person]
</ud>
<ud>
Jérôme de La Lande (Bourg-en-Bresse (<en type="li">Ain)</en>, <dat when="1732">1732</dat>) Astronome. - Membre de l''Académie de Berlin. - Membre de l''Académie des sciences (<dat when="1753">1753</dat>). - Professeur d''astronomie au Collège de France (<dat when="1762">1762</dat>). - Directeur de l''Observatoire de Paris de 1768 à sa mort [http://data.bnf.fr/ark:/12148/cb12012398h#foaf:Person]
</ud>
<ud>
Maurille-Antoine Moithey (<dat when="1732">1732</dat>) Éditeur et marchand de cartes géographiques ; libraire. - Ingénieur géographe du Roi et professeur de mathématiques des pages du prince et de la princesse de Conti. Auteur de plans, de cartes, d''ouvrages illustrés et d''atlas, qu''il publie et diffuse parfois lui-même de 1776 à 1792 au moins. Auteur notamment d''un "Dictionnaire hydrographique de la France..." (1re éd., l''auteur, 1787 ; rééd., Paris, Blanchon, <dat when="1803">1803</dat>) et d''une série de "Recherches historiques" sur les villes de France (Angers, Orléans, Reims, 1775-1776). Se qualifie de libraire en 1791-1792. Décédé à Paris le 21 frimaire an XIV (12 déc. 1805, Arch. de Paris) [http://data.bnf.fr/ark:/12148/cb13531657x#foaf:Person]
</ud>
<ud>
Nevil Maskelyne (<dat when="1732">1732</dat>) Astronome royal d''Angleterre. - Membre associé de l''Académie des sciences de Paris [http://data.bnf.fr/ark:/12148/cb12155150p#foaf:Person]
</ud>
<ud>
Jacques-François Dicquemare (<en type="li">Le Havre</en>, <dat when="1733">1733</dat>) Astronome. - Hydrographe. - Zoologue marin [http://data.bnf.fr/ark:/12148/cb15317071s#foaf:Person]
</ud>
<ud>
János Sajnovics (<en type="li">Tordas, Hongrie</en>, <dat when="1733">1733</dat>) Astronome. - Linguiste. - Père jésuite [http://data.bnf.fr/ark:/12148/cb12246417w#foaf:Person]
</ud>
<ud>
Jean-Charles Borda (<en type="li">Dax (Landes)</en>, <dat when="1733">1733</dat>) Officier de marine. - Membre de l''Académie de Marine (élu en 1769). - Entra dans le Génie militaire et se fit remarquer par ses travaux sur l''hydraulique. - Il détermina la longitude des Canaries (en 1776). - Prit part à la guerre d''indépendance américaine. - Participa avec Delambre et Méchain à la mesure de l''arc de méridien Dunkerque-Barcelone. - En qualité de commissaire de l''Académie des sciences participa à l''étude des montres marines sur la frégate la Flore (en 1771). - Membre de l''Institut, Académie des sciences (élu en 1772). - Membre de la Commission des poids et mesures (en 1791), il travailla à l''établissement du système métrique. - Membre de l''Institut national des sciences et arts, section mathématiques (actuel Institut de France) et du Bureau des longitudes (en 1795). - Co-fondateur de La Société de Borda (créée en 1876), avec Jacques-François de Borda d''Oro (1718-1804) [http://data.bnf.fr/ark:/12148/cb12482831r#foaf:Person]
</ud>
<ud>
Samuel Horsley (<dat when="1733">1733</dat>) Evêque; secrétaire de la Royal Society; publia des livres de théologie et de mathématiques [http://data.bnf.fr/ark:/12148/cb120697374#foaf:Person]
</ud>
<ud>
Achille Pierre Dionis du Séjour (<en type="li">Paris</en>, <dat when="1734">1734</dat>) Astronome et mathématicien [http://data.bnf.fr/ark:/12148/cb10680537k#foaf:Person]
</ud>
<ud>
Baudouin de Guémadeuc (<dat when="1734">1734</dat>) Homme de loi, homme de lettres, pamphlétaire puis astronome [http://data.bnf.fr/ark:/12148/cb144447840#foaf:Person]
</ud>
<ud>
Charles Duvaucel (<dat when="1734">1734</dat>) Astronome, spécialisé dans les éclipses du soleil. [http://data.bnf.fr/ark:/12148/cb15318527x#foaf:Person]
</ud>
<ud>
Mathieu Bernard Goudin (<en type="li">Paris</en>, <dat when="1734">1734</dat>) Magistrat. - Mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb10586154b#foaf:Person]
</ud>
<ud>
Alexandre-Théophile Vandermonde (<en type="li">Paris</en>, <dat when="1735">1735</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb12534847r#foaf:Person]
</ud>
<ud>
Antonio Maria Lorgna (<en type="li">Cerea, Italie</en>, <dat when="1735">1735</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb12387058m#foaf:Person]
</ud>
<ud>
Gregorio Fontana (<en type="li">Villa di Nogaredo, Italie</en>, <dat when="1735">1735</dat>) Mathématicien et physicien. - Recteur et professeur de calcul sublime à l''Ateneo lombardo. - Bibliothécaire du Collegio Ghisleri, Pavie [http://data.bnf.fr/ark:/12148/cb10601676b#foaf:Person]
</ud>
<ud>
Giovanni-Antonio Rizzi-Zannoni (<en type="li">Padoue, Italie</en>, <dat when="1736">1736</dat>) Géographe de la république de Venise, astronome, il voyage en Amérique du nord en 1757 [http://data.bnf.fr/ark:/12148/cb153024615#foaf:Person]
</ud>
<ud>
Jean Sylvain Bailly (<en type="li">Paris</en>, <dat when="1736">1736</dat>) Mathématicien, astronome et homme politique. - Entre à l''Académie des sciences (en 1763), à l''Académie française (en 1784) puis à l''Académie des inscriptions (en 1785). - Député du Tiers-État aux États-Généraux ; Maire de Paris ; Député à l''Assemblée Nationale Constituante [http://data.bnf.fr/ark:/12148/cb12516744h#foaf:Person]
</ud>
<ud>
Johann Nicolai Tetens (<en type="li">Tetenbüll, Allemagne</en>, <dat when="1736">1736</dat>) Mathématicien, physicien et philosophe [http://data.bnf.fr/ark:/12148/cb12531163b#foaf:Person]
</ud>
<ud>
Joseph-Louis Lagrange (<dat when="1736">1736</dat>) Mathématicien. - D''origine italienne. - A été à l''origine de la fondation de l''Académie des sciences de Turin. - Membre de l''Académie des sciences de Paris, Berlin, Turin. - A partir de 1787, enseigne à Paris à l''École normale et à l''École polytechnique [http://data.bnf.fr/ark:/12148/cb12125247f#foaf:Person]
</ud>
<ud>
Francesco Venini (<en type="li">Varenna, Italie</en>, <dat when="1737">1737</dat>) Abbé. - Mathématicien et poète [http://data.bnf.fr/ark:/12148/cb105963005#foaf:Person]
</ud>
<ud>
Giuseppe Maria Pagnini (<en type="li">Pistoia, Italie</en>, <dat when="1737">1737</dat>) Au siècle : Luca Antonio ; en religion, carme : Giuseppe Maria. - Poète. - Mathématicien. - Savant latiniste et helléniste. - Professeur à l'' Université de Parme puis de Pise [http://data.bnf.fr/ark:/12148/cb11996942k#foaf:Person]
</ud>
<ud>
Tommaso Valperga di Caluso (<en type="li">Turin, Italie</en>, <dat when="1737">1737</dat>) Abbé. - Homme de lettres, philosophe et mathématicien. - Chevalier de Malte [http://data.bnf.fr/ark:/12148/cb10748197m#foaf:Person]
</ud>
<ud>
William Bayly (<dat when="1737">1737</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb14065321z#foaf:Person]
</ud>
<ud>
Charles-Joseph Mathon de La Cour (<en type="li">Lyon (Rhône)</en>, <dat when="1738">1738</dat>) Économiste. - Philanthrope. - Fondateur du "Journal de Lyon". - Rédacteur de "L''Almanach musical" (1775-1778), et au "Journal de musique", Paris (1764-1768). - Fils de : Mathon de La Cour, Jacques (1712-1770), mathématicien [http://data.bnf.fr/ark:/12148/cb121925904#foaf:Person]
</ud>
<ud>
Flecheux (<dat when="1738">1738</dat>) Astronome et mécanicien français. - Adresse en 1784 : Paris, rue du Sentier, hôtel de madame la présidente de Meslay, n° 31 [http://data.bnf.fr/ark:/12148/cb15585605z#foaf:Person]
</ud>
<ud>
Joseph-François Marie (<en type="li">Rodez</en>, <dat when="1738">1738</dat>) Abbé. - Fut professeur de mathématiques au Collège Mazarin [http://data.bnf.fr/ark:/12148/cb146364765#foaf:Person]
</ud>
<ud>
Thomas Abbt (<en type="li">Ulm, Allemagne</en>, <dat when="1738">1738</dat>) Écrivain, philosophe, mathématicien, juriste et conseiller aulique [http://data.bnf.fr/ark:/12148/cb125347464#foaf:Person]
</ud>
<ud>
William Herschel (<en type="li">Hanovre, Allemagne</en>, <dat when="1738">1738</dat>) Astronome et compositeur. - A découvert la planète Uranus. - S''installe en Grande-Bretagne en 1757 [http://data.bnf.fr/ark:/12148/cb14064893z#foaf:Person]
</ud>
<ud>
Ermenegildo Pini (<en type="li">Milan, Italie</en>, <dat when="1739">1739</dat>) Barnabite. - Physicien, géologue, architecte. - Professeur de mathématiques, puis d''histoire naturelle au Collège Saint-Alexandre, Milan. - Dans le siècle : Pini, Carlo [http://data.bnf.fr/ark:/12148/cb13013593q#foaf:Person]
</ud>
<ud>
Jean-Louis Pictet (<dat when="1739">1739</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb146402484#foaf:Person]
</ud>
<ud>
Johann Schultz (<dat when="1739">1739</dat>) A été professeur de mathématiques à l''université de Königsberg, Allemagne [http://data.bnf.fr/ark:/12148/cb121741380#foaf:Person]
</ud>
<ud>
José Antonio Alzate y Ramírez (<dat when="1739">1739</dat>) Astronome et géographe [http://data.bnf.fr/ark:/12148/cb15376450x#foaf:Person]
</ud>
<ud>
András Dugonics (<en type="li">Szeged (Hongrie)</en>, <dat when="1740">1740</dat>) Écrivain. - Poète. - Piariste. - Professeur de mathématiques. - A fait des études de théologie  à Privigye (aujourd''hui Prievidza, Slovaquie) et à Nyitra (aujourd''hui Nitra, Slovaquie) [http://data.bnf.fr/ark:/12148/cb12246575b#foaf:Person]
</ud>
<ud>
Jacques-André Mallet (<dat when="1740">1740</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb10552198c#foaf:Person]
</ud>
<ud>
Joseph Anton Slop von Cadenberg (<dat when="1740">1740</dat>) Astronome. - À l''Observatoire de Pise à partir de 1765 [http://data.bnf.fr/ark:/12148/cb12159312n#foaf:Person]
</ud>
<ud>
Nicola Spedalieri (<en type="li">Bronte (Italie)</en>, <dat when="1740">1740</dat>) Professeur de philosophie, théologie et mathématique, poète, musicien, historien [http://data.bnf.fr/ark:/12148/cb16219670j#foaf:Person]
</ud>
<ud>
Nicolas-Antoine Nouet (<dat when="1740">1740</dat>) Astronome. - Attaché à l''Observatoire en 1785. - Participe à l''expédition d''Égypte en 1798. - Ingénieur au Bureau de la guerre en 1802 [http://data.bnf.fr/ark:/12148/cb12151453k#foaf:Person]
</ud>
<ud>
Thomas Bugge (<en type="li">Copenhague</en>, <dat when="1740">1740</dat>) Astronome et cartographe [http://data.bnf.fr/ark:/12148/cb121931908#foaf:Person]
</ud>
<ud>
Vicente Tofiño de San Miguel (<dat when="1740">1740</dat>) Astronome. - Capitaine de vaisseau. - Directeur des compagnies des gardes royales de la marine en 1786. - Membre de l''Académie d''histoire de Madrid. - Correspondant de l''Académie des sciences de Paris [http://data.bnf.fr/ark:/12148/cb12159995t#foaf:Person]
</ud>
<ud>
Alexis Rochon (<en type="li">Brest (Finistère)</en>, <dat when="1741">1741</dat>) Prêtre, astronome de la marine, physicien et inventeur. - Bibliothécaire de l''Académie royale de marine à Brest (1765-), astronome opticien de la Marine (<dat when="1787">1787</dat>), membre de la Commission des poids et mesures et des monnaies (<dat when="1792">1792</dat>). - Membre de l''Académie royale des sciences, puis membre de l''Institut. - Clerc tonsuré [http://data.bnf.fr/ark:/12148/cb129983745#foaf:Person]
</ud>
<ud>
Stanislaw Wydra (<dat when="1741">1741</dat>) Professeur de mathématiques [http://data.bnf.fr/ark:/12148/cb15512813z#foaf:Person]
</ud>
<ud>
Vincenzo Chiminello (<en type="li">Marostica, Italie</en>, <dat when="1741">1741</dat>) Abbé. - Astronome [http://data.bnf.fr/ark:/12148/cb10522164f#foaf:Person]
</ud>
<ud>
Georg Jonathan von Holland (<dat when="1742">1742</dat>) Théologien. - Mathématicien. - Précepteur des princes de Wurttemberg [http://data.bnf.fr/ark:/12148/cb119076602#foaf:Person]
</ud>
<ud>
Jacques Poitevin (<en type="li">Montpellier</en>, <dat when="1742">1742</dat>) Savant astronome et agriculteur. - Conseiller de préfecture du département de l''Hérault. - Membre de la Société royale des sciences de Montpellier [http://data.bnf.fr/ark:/12148/cb10644654k#foaf:Person]
</ud>
<ud>
Antonio Cagnoli (<en type="li">Zante, Grèce</en>, <dat when="1743">1743</dat>) Astronome et mathématicien. - Crée un observatoire d''astronomie à Vérone. - Enseigne les mathématiques à l''École militaire de Modène après la prise de Vérone par les Français (<dat when="1797">1797</dat>). - Membre de nombreuses académies d''Europe [http://data.bnf.fr/ark:/12148/cb12562781s#foaf:Person]
</ud>
<ud>
Eberhard August Wilhelm von Zimmermann (<en type="li">Uelzen, Allemagne</en>, <dat when="1743">1743</dat>) Géographe et naturaliste. - Professeur de mathématiques et de sciences naturelles au Collegium Carolinum de Brunswick de 1766 à 1815. - Conseiller aulique en 1786, puis conseiller d''état en 1801 [http://data.bnf.fr/ark:/12148/cb12330956p#foaf:Person]
</ud>
<ud>
Jean-Antoine-Nicolas de Caritat Condorcet (<dat when="1743">1743</dat>) Philosophe, mathématicien et  économiste. - Membre de l''Académie française (<dat when="1782">1782</dat>). - Homme politique. - A aussi écrit sous le pseudonyme M. Schwartz, pasteur à Bienne [http://data.bnf.fr/ark:/12148/cb118975118#foaf:Person]
</ud>
<ud>
Etienne Lenoir (<dat when="1744">1744</dat>) Ingénieur. - Mit au point plusieurs instruments d''astronomie et de géodésie [http://data.bnf.fr/ark:/12148/cb151423156#foaf:Person]
</ud>
<ud>
François Callet (<en type="li">Versailles</en>, <dat when="1744">1744</dat>) Professeur de mathématiques et d''hydrographie [http://data.bnf.fr/ark:/12148/cb10544471f#foaf:Person]
</ud>
<ud>
Jean Bernoulli (<en type="li">Bâle, Suisse</en>, <dat when="1744">1744</dat>) Mathématicien, astronome. - Membre des Académies des sciences de Berlin, de Petersbourg, de Stockholm, de Bologne, de Lyon, &amp; de Marseille, de la Société pour l''encouragement des arts, de Londres, de celle des physiciens de Bâle, de l''Académie des Arcades de Rome [http://data.bnf.fr/ark:/12148/cb14508854n#foaf:Person]
</ud>
<ud>
José Anastácio da Cunha (<dat when="1744">1744</dat>) Poète portugais. - Mathématicien, professeur de géométrie à l''Université de Coimbra. - Officier d''artillerie à Valença do Minho (1764-1778) [http://data.bnf.fr/ark:/12148/cb121612626#foaf:Person]
</ud>
<ud>
Pierre Méchain (<en type="li">Laon</en>, <dat when="1744">1744</dat>) Astronome français. - Prénoms complets : Pierre François André [http://data.bnf.fr/ark:/12148/cb12090251r#foaf:Person]
</ud>
<ud>
Caspar Wessel (<en type="li">Vestby, Norvège</en>, <dat when="1745">1745</dat>) Mathématicien. - Reçut la médaille d''argent de la Royal Danish academy [http://data.bnf.fr/ark:/12148/cb12563002z#foaf:Person]
</ud>
<ud>
Claude-François Guillemeau de Fréval (<en type="li">Paris</en>, <dat when="1745">1745</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb10017540p#foaf:Person]
</ud>
<ud>
Franz von Paula Triesnecker (<dat when="1745">1745</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb15115995f#foaf:Person]
</ud>
<ud>
Fulcrand Jean Joseph Aigrefeuille (<dat when="1745">1745</dat>) Gastronome [http://data.bnf.fr/ark:/12148/cb16296114m#foaf:Person]
</ud>
<ud>
Johann Hieronymus Schröter (<dat when="1745">1745</dat>) Magistrat et astronome amateur allemand [http://data.bnf.fr/ark:/12148/cb11973603q#foaf:Person]
</ud>
<ud>
Nicolas Charles Romme (Riom, Puy-de-Dôme, <dat when="1745">1745</dat>) Professeur de mathématiques et de navigation à l''École de Rochefort. - Membre de l''Institut [http://data.bnf.fr/ark:/12148/cb12805333t#foaf:Person]
</ud>
<ud>
Gaetano Del Ricco (<dat when="1746">1746</dat>) Piariste (17 mai 1761). - Mathématicien. - Librettiste. - Prénom de baptême : Vincenzo [http://data.bnf.fr/ark:/12148/cb16659347q#foaf:Person]
</ud>
<ud>
Gaspard Monge (<dat when="1746">1746</dat>) Mathématicien et géomètre. - Fondateur de l''École polytechnique et de l''École normale. - Président de l''Institut du Caire. - Membre de l''Institut, Académie des sciences. - Député au Conseil des Cinq-Cents, au Conseil des Anciens, ministre de la Marine (<dat when="1792">1792</dat>), sénateur (<dat when="1799">1799</dat>), comte de Péluse (<dat when="1808">1808</dat>) [http://data.bnf.fr/ark:/12148/cb121412336#foaf:Person]
</ud>
<ud>
Giovanni Battista Venturi (<en type="li">Bibbiano, Italie</en>, <dat when="1746">1746</dat>) Physicien et mathématicien. - Homme politique et diplomate [http://data.bnf.fr/ark:/12148/cb127228927#foaf:Person]
</ud>
<ud>
Giuseppe Piazzi (<en type="li">Ponte di Valtellina, Italie</en>, <dat when="1746">1746</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb12920801z#foaf:Person]
</ud>
<ud>
Jean-Claude-Gauthier-Louis de Benaben (<dat when="1746">1746</dat>) Oratorien et professeur de mathématiques. - Fut directeur de l''Ecole centrale d''Angers. - Fut président des Amis de la Constitution. - Fut commissaire civil du département de Maine-et-Loire [http://data.bnf.fr/ark:/12148/cb125680474#foaf:Person]
</ud>
<ud>
Jean Foucaud (<dat when="1747">1747</dat>) Prédicateur, mathématicien, philologue. - A écrit en patois limousin des fables imitées de La Fontaine, qu''il a aussi traduit dans cette même langue. - Fut l''un des rédacteurs du "Journal du département de la Haute-Vienne". - Fut à Limoges une personalité agissante du Club des jacobins, membre du Comité de salut public, juge de paix et payeur du département de Haute-Vienne. - Défroqué en 1793, il mourut réconcilié avec l''Église [http://data.bnf.fr/ark:/12148/cb119031941#foaf:Person]
</ud>
<ud>
Jean-Baptiste Bernard (<dat when="1747">1747</dat>) Libraire ; libraire de l''École polytechnique (<dat when="1800">1800</dat>) ; de l''École des Ponts et Chaussées (<dat when="1801">1801</dat>) ; des Écoles impériales polytechnique et des Ponts et chaussées (<dat when="1805">1805</dat>). - Né à Marseille. Libraire spécialisé dans les "mathématiques, sciences et arts", il travaille jusqu''en 1796 en association avec Régent au bureau du "Journal polytechnique" ou "Bulletin des Travaux publics..." Historien et philologue, éditeur des "Œuvres posthumes" de Montesquieu. Décédé à Saint-Maur-des-Fossés (Val-de-Marne) en oct. 1808. Sa veuve lui succède avant de revendre son fonds en 1810 à Jean Klostermann [http://data.bnf.fr/ark:/12148/cb122388832#foaf:Person]
</ud>
<ud>
Johann Elert Bode (<en type="li">Hambourg (Allemagne)</en>, <dat when="1747">1747</dat>) Astronome [http://data.bnf.fr/ark:/12148/cb104634498#foaf:Person]
</ud>
<ud>
Andreas Riedel (<en type="li">Vienne</en>, <dat when="1748">1748</dat>) Jacobin viennois. - Professeur de mathématiques, précepteur des enfants du Grand duc Léopold, futur empereur,  1779-1790, Florence (Italie). - Études de médecine, élève du professeur Franz Anton Mesmer. - Emprisonné à Brno (1806-1809). - Se réfugia en France 1810-1837 [http://data.bnf.fr/ark:/12148/cb14593357z#foaf:Person]
</ud>
<ud>
Jean-Dominique Cassini (<dat when="1748">1748</dat>) Astronome. - Membre de l''Académie des sciences (<dat when="1770">1770</dat>). - Fils de l''astronome César-François Cassini (1714-1784), qui était aussi appelé Cassini de Thury, car né à Thury (Oise) en 1714. - Succède à son père comme directeur de l''Observatoire de Paris (en 1784) [http://data.bnf.fr/ark:/12148/cb12157999q#foaf:Person]
</ud>
<ud>
Pietro Cossali (<en type="li">Vérone, Italie</en>, <dat when="1748">1748</dat>) Mathématicien. - A enseigné à l''université de Padoue [http://data.bnf.fr/ark:/12148/cb146340668#foaf:Person]
</ud>
<ud>
Pons-Joseph Bernard (<dat when="1748">1748</dat>) Mathématicien. - Directeur adjoint de l''Observatoire de Marseille [http://data.bnf.fr/ark:/12148/cb12306722n#foaf:Person]
</ud>
<ud>
Thaddäus Rinderle (<dat when="1748">1748</dat>) Moine bénédictin, mathématicien et horloger [http://data.bnf.fr/ark:/12148/cb15037954k#foaf:Person]
</ud>
<ud>
Giuseppe Calandrelli (<en type="li">Zagarolo, Italie</en>, <dat when="1749">1749</dat>) Astronome. - Directeur du "Collegio romano" [http://data.bnf.fr/ark:/12148/cb10544460s#foaf:Person]
</ud>
<ud>
Henri Bouchon-Dubournial (<dat when="1749">1749</dat>) Ingénieur et mathématicien. - Fut professeur à l''Ecole militaire et l''Ecole royale militaire. - Fut le traducteur de Cervantès [http://data.bnf.fr/ark:/12148/cb125620183#foaf:Person]
</ud>
<ud>
Jean-Baptiste Delambre (<en type="li">Amiens</en>, <dat when="1749">1749</dat>) Astronome. - Ses calculs ont servi à  déterminer la longueur du mètre. - Membre de l''Académie des sciences (<dat when="1792">1792</dat>) [http://data.bnf.fr/ark:/12148/cb12096096m#foaf:Person]
</ud>
<ud>
Paul-Louis Cirodde (<dat when="1749">1749</dat>) Professeur de mathématiques [http://data.bnf.fr/ark:/12148/cb102655606#foaf:Person]
</ud>
<ud>
Pierre-Simon de Laplace (Beaumont-en-Auge (<en type="li">Calvados)</en>, <dat when="1749">1749</dat>) Astronome, mathématicien et physicien. - Membre de l''Institut, Académie des sciences (élu en 1795), puis de l''Académie française (élu en 1816). - Obtint le titre de marquis (en 1817) [http://data.bnf.fr/ark:/12148/cb119110516#foaf:Person]
</ud>
<ud>
Vincenzo De Filippis (<dat when="1749">1749</dat>) Scientifique, mathématicien. - Ministre de la République parthénopéenne en février 1799, fut probablement victime de la répression au rétablissement des Bourbons en juin de la même année [http://data.bnf.fr/ark:/12148/cb12290835h#foaf:Person]
</ud>
<ud>
William Faden (<dat when="1749">1749</dat>) Libraire, éditeur et marchand de cartes et d''estampes ; également géographe ordinaire du roi d''Angleterre (1783-1820) et du prince de Galles (1790-1820). - Fils de l''imprimeur londonien William I Faden (à l''origine Mackfaden, 1711-1783). En apprentissage de juillet 1764 à août 1771. Travaille en association avec la famille du libraire et géographe du Roi Thomas Jefferys (m. 1771) jusqu''en 1776 env. Membre de la "Society of civil engineers". Beau-frère du peintre et astronome John Russell. Se retire en 1823 et cède son affaire à son ancien apprenti James Wyld. Décédé à Shepperton en mars 1836 [http://data.bnf.fr/ark:/12148/cb15615346f#foaf:Person]
</ud>
<ud>
Caroline Lucretia Herschel (Hanovre (Basse-Saxe,  Allemagne), <dat when="1750">1750</dat>) Astronome. - Assistante de son frère, William Herschel (1738-1822), lui aussi astronome [http://data.bnf.fr/ark:/12148/cb16108822m#foaf:Person]
</ud>
<ud>
Gilbert Romme (<dat when="1750">1750</dat>) Mathématicien, astronome et géographe. - Député du Puy-de-Dôme à l''Assemblée législative puis à la Convention, représentant en mission près l''armée de Cherbourg, préconise l''essai du télégraphe aérien de Chiappe. - A participé à l''établissement du calendrier révolutionnaire [http://data.bnf.fr/ark:/12148/cb12536106q#foaf:Person]
</ud>
<ud>
Lorenzo Mascheroni (<en type="li">Bergame, Italie</en>, <dat when="1750">1750</dat>) Mathématicien et poète. - Professeur de physique et de mathématique au Séminaire de Bergame, puis d''algèbre et de géométrie à l''Université de Pavie, dont il sera recteur. - Député au Corps législatif de Milan (<dat when="1799">1799</dat>), admirateur de Napoléon, fait partie des 29 qui signent l''appel à régner en Italie au Premier Consul après 1799 [http://data.bnf.fr/ark:/12148/cb119149502#foaf:Person]
</ud>
<ud>
Nicolas-Maurice Chompré (<en type="li">Paris (France)</en>, <dat when="1750">1750</dat>) Directeur, entre 1777 et 1786, de la Correspondance générale à la Division des mines et de l''agriculture du Contrôleur général des Finances Bertin. - Diplomate. - Auteur d''ouvrages de physique et de mathématiques [http://data.bnf.fr/ark:/12148/cb122074802#foaf:Person]
</ud>
<ud>
Scipione Breislak (<en type="li">Rome</en>, <dat when="1750">1750</dat>) Géologue. - Professeur de mathématiques à Raguse puis à Rome [http://data.bnf.fr/ark:/12148/cb151306996#foaf:Person]
</ud>
<ud>
Simon Lhuilier (<dat when="1750">1750</dat>) Mathématicien et philosophe. - Établi à Varsovie [http://data.bnf.fr/ark:/12148/cb13005974t#foaf:Person]
</ud>
<ud>
Alliette (<dat when="1751">1751</dat>) Cartomancien de la fin du 18e siècle. - Marchand d''estampes. - Professeur de mathématiques (vers 1753). - La forme "Etteilla" est l''anagramme d''Alliette [http://data.bnf.fr/ark:/12148/cb118885161#foaf:Person]
</ud>
<ud>
André-Charles Brotier (<en type="li">Paris</en>, <dat when="1751">1751</dat>) Abbé, mathématicien et homme politique. - Enseigna les mathématiques à l''Ecole militaire. - Collabora à l''"Année littéraire" et au "Journal de la France" [http://data.bnf.fr/ark:/12148/cb124621991#foaf:Person]
</ud>
<ud>
Antide Janvier (Lavans-lès-Saint-Claude (<en type="li">Jura)</en>, <dat when="1751">1751</dat>) Horloger, astronome [http://data.bnf.fr/ark:/12148/cb12614643k#foaf:Person]
</ud>
<ud>
Bazaine (<dat when="1751">1751</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb10735226f#foaf:Person]
</ud>
<ud>
Bernard Violle (<dat when="1751">1751</dat>) Mathématicien. - Géomètre. - Chevalier de Saint-Louis (<dat when="1815">1815</dat>) [http://data.bnf.fr/ark:/12148/cb13006994p#foaf:Person]
</ud>
<ud>
Bonaventure Abat (<dat when="1751">1751</dat>) Mathématicien et théologien, cordelier de l''Observance. - Fut membre associé de l''Académie royale des belles-lettres de Barcelone [http://data.bnf.fr/ark:/12148/cb134813469#foaf:Person]
</ud>
<ud>
G.-F. Olivier (<dat when="1751">1751</dat>) Bachelier ès sciences. - Professeur d''humanités et de mathématiques (en 1825). Professeur au collège de Troyes [http://data.bnf.fr/ark:/12148/cb10728006s#foaf:Person]
</ud>
<ud>
Guillelmus Beer (<dat when="1751">1751</dat>) Cartographe, géographe et peut-être astronome [http://data.bnf.fr/ark:/12148/cb15332855z#foaf:Person]
</ud>
<ud>
Hector-Jean Legros (<dat when="1751">1751</dat>) Adjoint-général pendant les guerres de Vendée et d''Italie. - Professeur de mathématiques [http://data.bnf.fr/ark:/12148/cb13484693c#foaf:Person]
</ud>
<ud>
Henri Jurain (<dat when="1751">1751</dat>) Abbé. - Professeur de mathématiques à Reims. - Correspondant de l''Académie des Sciences [http://data.bnf.fr/ark:/12148/cb12224993g#foaf:Person]
</ud>
<ud>
J.-B.-M. Duprat (<dat when="1751">1751</dat>) Libraire pour les mathématiques. - En activité de mars 1797 à 1803 au moins. Apparenté à Louis (-Alexis) Duprat-Duverger, en activité à partir de 1802, qui a pu se qualifier lui aussi de "libraire pour les mathématiques". Louis Courcier, "imprimeur et libraire pour les mathématiques", lui succède en 1803 à la même adresse (quai des Augustins, n° 71). Une "madame Duprat" est cependant répertoriée, à l''adresse du pont Saint-Michel, par le "Tableau des libraires" de Debray (Paris, janv. 1804) [http://data.bnf.fr/ark:/12148/cb16701987t#foaf:Person]
</ud>
<ud>
J.P. Audiffred (<dat when="1751">1751</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb125867381#foaf:Person]
</ud>
<ud>
Jacques Baradelle (<dat when="1751">1751</dat>) Etabli dès 1740 quai de l''Horloge du Palais, il fabriquait des instruments de navigation, des cadrans solaires, des sphères astronomiques et géographiques [http://data.bnf.fr/ark:/12148/cb15281028g#foaf:Person]
</ud>
<ud>
James Dodson (<dat when="1751">1751</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb153816258#foaf:Person]
</ud>
<ud>
Jean-Louis Gœury (<dat when="1751">1751</dat>) Libraire ; libraire pour les mathématiques et l''architecture ; libraire de l''École des Ponts et chaussées (<dat when="1802">1802</dat>) ; des ingénieurs et de l''École impériale des Ponts et chaussées (<dat when="1805">1805</dat>). - Semble avoir été commis du libraire parisien Charles-Antoine Jombert de 1770 à 1773 au moins. Père du médecin Jean-Louis Gœury-Duvivier, né le 2 mars 1803. En activité dès 1800. Breveté libraire le 1er oct. 1812 (brevet renouvelé le 11 sept. 1818). Décédé peu avant le 28 juin 1827, date à laquelle son fils Jean-Louis Gœury (dit plus tard Gœury-Duvivier) demande à succéder à son brevet [http://data.bnf.fr/ark:/12148/cb12230577c#foaf:Person]
</ud>
<ud>
Joseph Mouchet (<dat when="1751">1751</dat>) Professeur de rhétorique et de mathématiques, professeur de physique à l''université de Nantes de 1780 à 1784. - Aéronaute. - Membre de la Congrégation de l''Oratoire [http://data.bnf.fr/ark:/12148/cb16514291q#foaf:Person]
</ud>
<ud>
Joseph-Louis Vincens de Mauléon de Causans (<en type="li">Avignon</en>, <dat when="1751">1751</dat>) Mathématicien. - Colonel d''infanterie du régiment de Conti. - Chevalier de Malte [http://data.bnf.fr/ark:/12148/cb145658189#foaf:Person]
</ud>
<ud>
Le Professeur de mathématiques du Collège national de Toul (<dat when="1751">1751</dat>) Professeur de mathématiques du Collège national de Toul [http://data.bnf.fr/ark:/12148/cb125373980#foaf:Person]
</ud>
<ud>
Le Ratz de Lanthenée (<dat when="1751">1751</dat>) Gentilhomme liégeois. - Mathématicien et physicien [http://data.bnf.fr/ark:/12148/cb124022694#foaf:Person]
</ud>
<ud>
Louis Duprat-Duverger (<dat when="1751">1751</dat>) Variante(s) de prénom : Louis-Alexis. - Libraire pour les mathématiques ; également éditeur de cartes et d''atlas. - Apparenté au "libraire pour les mathématiques" J.-B.-M. Duprat, en activité à Paris entre 1797 et 1803. Établi dès 1802, d''abord en association sous la raison "L. Duprat, Letellier et compagnie" jusqu''en 1804, seul ensuite. Breveté libraire le 1er oct. 1812 ; brevet renouvelé le 15 mars 1817 ; duplicata délivré le 27 avril 1824. Encore en activité en 1829 [http://data.bnf.fr/ark:/12148/cb133399518#foaf:Person]
</ud>
<ud>
Madame Bailly (<dat when="1751">1751</dat>) Épouse de Jean-Sylvain Bailly, mathématicien, astronome et homme politique, guillotiné en 1793 [http://data.bnf.fr/ark:/12148/cb16541654h#foaf:Person]
</ud>
<ud>
Marie de La Fresnaye (<en type="li">Barfleur (Manche)</en>, <dat when="1751">1751</dat>) Professeur de littérature et de mathématiques [http://data.bnf.fr/ark:/12148/cb100430283#foaf:Person]
</ud>
<ud>
Marie-Louise Cartan (<dat when="1751">1751</dat>) Femme d''Elie Cartan, mère du compositeur Jean Cartan et du mathématicien Henri Cartan. - Née Marie-Louise Bianconi [http://data.bnf.fr/ark:/12148/cb148511208#foaf:Person]
</ud>
<ud>
Mathurin-Georges Girault de Keroudou (<dat when="1751">1751</dat>) Abbé. - Mathématicien français. - Principal du collège de Quimper. - Professeur de philosophie et de mathématiques au collège de Navarre à Paris. - Professeur au collège de Louis-le-Grand à Paris [http://data.bnf.fr/ark:/12148/cb15085298t#foaf:Person]
</ud>
<ud>
Nicolas Leverdé (<dat when="1751">1751</dat>) Astrologue et mathématicien. - Auteur d''almanachs [http://data.bnf.fr/ark:/12148/cb10403809w#foaf:Person]
</ud>
<ud>
Olaf Söderberg (<dat when="1751">1751</dat>) Botaniste et mathématicien [http://data.bnf.fr/ark:/12148/cb12563978p#foaf:Person]
</ud>
<ud>
Théodore Bouys (<dat when="1751">1751</dat>) Mathématicien favorable à Necker et à la Révolution [http://data.bnf.fr/ark:/12148/cb12240772d#foaf:Person]
</ud>
<ud>
Trabaud (<dat when="1751">1751</dat>) Maître de mathématiques [http://data.bnf.fr/ark:/12148/cb134811442#foaf:Person]
</ud>
<ud>
Vérologue (<dat when="1751">1751</dat>) "Seul imprimeur d''Apollon pour la satyre en prose". - Pseud. auquel est adjoint le qualificatif "seul imprimeur d''Apollon pour la satyre en prose" et qui, sous la fausse adresse "Sur l''imprimé au Parnasse", dissimule une impression française (parisienne selon Weller et G. Brunet, plutôt provinciale d''après le matériel typographique) de "La Nouvelle Astronomie du Parnasse françois, ou l''Apothéose des écrivains vivans dans la présente année 1740", due au chevalier Jean-Florent-Joseph de Neufville de Brunaubois-Montador [http://data.bnf.fr/ark:/12148/cb165246377#foaf:Person]
</ud>
<ud>
Veuve de Louis Courcier (<dat when="1751">1751</dat>) Nom patronymique : Victoire-Félicité Lemaire. - Imprimeur-libraire ; imprimeur-libraire pour les mathématiques, la marine, les sciences et les arts. - Brevetée imprimeur en succession de son mari le 12 août 1811 (brevet renouvelé le 15 oct. 1816) et libraire le 1er oct. 1812 (brevet renouvelé le 15 mars 1817). Deux de ses  gendres lui succèdent : Démophile Huzard (-Courcier) en mars 1820 (brevet du 14 mars 1820) comme imprimeur, et Victor Bachelier le 10 nov. 1821 comme libraire [http://data.bnf.fr/ark:/12148/cb124778683#foaf:Person]
</ud>
<ud>
Adrien-Marie Legendre (<dat when="1752">1752</dat>) Mathématicien. - Président de l''Académie des sciences (<dat when="1806">1806</dat>). - A aussi écrit avec Charles-Etienne Coquebert de Montbret et François Gattey sous le pseudonyme collectif "C.-G.-L. Métrophile" [http://data.bnf.fr/ark:/12148/cb12443375d#foaf:Person]
</ud>
<ud>
Barnaba Oriani (<en type="li">Carignano, Italie</en>, <dat when="1752">1752</dat>) Astronome de l''Observatoire de Brera (1777-), puis de Milan. - A découvert qu''Uranus était une planète à partir de son orbite. - Mathématicien [http://data.bnf.fr/ark:/12148/cb12537845s#foaf:Person]
</ud>
<ud>
Jean-Baptiste Labey (La Chapelle-Hainfray (Calvados), aujourd''hui Valsemé (<en type="li">Calvados)</en>, <dat when="1752">1752</dat>) Mathématicien. - Professeur à l''École militaire, à l''École centrale du Panthéon, à l''École polytechnique et au Lycée Napoléon de Paris [http://data.bnf.fr/ark:/12148/cb12112257t#foaf:Person]
</ud>
<ud>
Jean-Baptiste Pérès (Valence d''Agen (Tarn-et-Garonne), <dat when="1752">1752</dat>) Oratorien. - Professeur de mathématiques et de physique  à Lyon, membre de la Société des amis de la Constitution de la ville durant la Révolution, puis substitut du procureur général près la cour royale d''Agen et bibliothécaire de cette ville [http://data.bnf.fr/ark:/12148/cb126307361#foaf:Person]
</ud>
<ud>
Marc-Auguste Pictet (<en type="li">Genève (Suisse)</en>, <dat when="1752">1752</dat>) Naturaliste genevois, littérateur, chimiste, physicien et astronome. - Membre fondateur de la Société de physique et d''histoire naturelle de Genève, Suisse. - Correspondant de la Société royale de Londres [http://data.bnf.fr/ark:/12148/cb125386742#foaf:Person]
</ud>
<ud>
François Gattey (<dat when="1753">1753</dat>) Mathématicien. - Directeur du Bureau des poids et mesures (en 1795). - A aussi écrit avec Charles-Etienne Coquebert de Montbret et Adrien-Marie Legendre sous le pseudonyme collectif "C.-G.-L. Métrophile" [http://data.bnf.fr/ark:/12148/cb12447886d#foaf:Person]
</ud>
<ud>
Antoine de La Salle (<dat when="1754">1754</dat>) Philosophe. - Mathématicien [http://data.bnf.fr/ark:/12148/cb12173561c#foaf:Person]
</ud>
<ud>
Colin Mackenzie (Stornoway (Lewis, Western isles, Royaume-Uni), <dat when="1754">1754</dat>) Mathématicien. - Fonctionnaire collonial en Inde (1815-1821). - Chargé du relevé cartographique de l''Inde et de la description de ses régions. - Collectionneur de divers documents (manuscrits, dessins aquarelles...) constituant le fonds d''études indianistes, collection dispersée aujourd''hui entre l''India office library, Londres et : Government oriental manuscripts library, Madras et Calcutta [http://data.bnf.fr/ark:/12148/cb14374770r#foaf:Person]
</ud>
<ud>
Franz Xaver von Zach (<en type="li">Bratislava</en>, <dat when="1754">1754</dat>) Astronome. - Directeur de l''Observatoire du Seeberg (près de Gotha), de 1787 à 1808. - Dirigea les "Allgemeinen geographischen Ephemeriden" (1796-) [http://data.bnf.fr/ark:/12148/cb121732757#foaf:Person]
</ud>
<ud>
Jean-Baptiste Meusnier de La Place (Tours (Indre-et-Loire), <dat when="1754">1754</dat>) Mathématicien et Officier. - Elu à l''Académie des sciences en 1784 pour son étude locale des surfaces. - Prénoms complets : Jean-Baptiste Marie Charles [http://data.bnf.fr/ark:/12148/cb10732160m#foaf:Person]
</ud>
<ud>
Nicolas-François Canard (<dat when="1754">1754</dat>) Mathématicien et économiste [http://data.bnf.fr/ark:/12148/cb12519510c#foaf:Person]
</ud>
<ud>
Charles-Étienne Coquebert de Montbret (<en type="li">Paris</en>, <dat when="1755">1755</dat>) Diplomate, mathématicien et géographe. - Nommé responsable de l''organisation du nouveau système de poids et mesures (décret de 1793), professeur de géographie physique et gîtes de minerais à l''École des mines. - A aussi écrit avec François Gattey et Adrien-Marie Legendre sous le pseudonyme collectif "C.-G.-L. Métrophile". - Membre de l''Institut, membre libre de l''Académie des Sciences (en 1816) [http://data.bnf.fr/ark:/12148/cb12447869t#foaf:Person]
</ud>
<ud>
Claude Philippe Bertrand Bertrand (Autun (Saône-et-Loire), <dat when="1755">1755</dat>) Géographe et astronome [http://data.bnf.fr/ark:/12148/cb16506861q#foaf:Person]
</ud>
<ud>
Emmanuel-Étienne Duvillard de Durand (<en type="li">Genève</en>, <dat when="1755">1755</dat>) Mathématicien, statisticien. - A développé la mathématisation de l''économie [http://data.bnf.fr/ark:/12148/cb129987837#foaf:Person]
</ud>
<ud>
Gaspard-Clair-François-Marie Riche de Prony (<en type="li">Chamelet (Rhône)</en>, <dat when="1755">1755</dat>) Mathématicien et ingénieur. - Directeur de l''École des Ponts et Chaussées (1799-1830). - Membre de l''Académie des Sciences. - Baron à titre personnel (<dat when="1828">1828</dat>) [http://data.bnf.fr/ark:/12148/cb12535038t#foaf:Person]
</ud>
<ud>
Jean Anthelme Brillat-Savarin (<en type="li">Belley, Ain</en>, <dat when="1755">1755</dat>) Magistrat. - Député aux États Généraux (élu en 1789). - Gastronome [http://data.bnf.fr/ark:/12148/cb12305674c#foaf:Person]
</ud>
<ud>
Louis Courcier (<dat when="1755">1755</dat>) Imprimeur-libraire ; imprimeur-libraire pour les mathématiques (<dat when="1801">1801</dat>) ; imprimeur-libraire pour les mathématiques (, les sciences et les arts) (1804-1808). - Exerce l''imprimerie dès l''été 1790. Aurait été auparavant "marchand de peaux de lapin" d''après l''enquête des inspecteurs de la librairie de déc. 1810. Proche des Girondins, il émarge au budget du Bureau de l''Esprit public du ministre Jean-Marie Roland de La Platière en 1792. Dirige le "Courrier du Corps législatif et de la Guerre" (<dat when="1797">1797</dat>). Rachète le fonds du libraire J.-B.-M. Duprat et lui succède en 1803 ; rachète l''imprimerie de Jean-Georges-Antoine Stoupe après la mort de celui-ci (<dat when="1808">1808</dat>). Breveté imprimeur le 1er avril 1811. Dit âgé de 56 ans lors de son décès (30 juillet 1811). Sa veuve est brevetée en sa succession dès le 12 août 1811 [http://data.bnf.fr/ark:/12148/cb12421329b#foaf:Person]
</ud>
<ud>
Nicolas B. Halma (<dat when="1755">1755</dat>) Chanoine de Paris. - Astronome et mathématicien. - Professeur [http://data.bnf.fr/ark:/12148/cb11906753t#foaf:Person]
</ud>
<ud>
Nikolaus von Fuss (<dat when="1755">1755</dat>) Mathématicien, géomètre. - Né à Bâle, s''intalla à Saint-Pétersbourg en 1773 à la demande d''Euler. - Membre de l''Académie des sciences de Saint-Pétersbourg (1775-), secrétaire perpétuel (1800-). - Meurt à Saint-Pétersbourg le 23 décembre 1825 (style grégorien) [http://data.bnf.fr/ark:/12148/cb12359314p#foaf:Person]
</ud>
<ud>
Pierre Tédenat (<dat when="1755">1755</dat>) Docteur en mathématiques. - Recteur de l''académie Nîmes (1809-1818) et professeur de philosophie à la faculté des lettres de Nîmes [http://data.bnf.fr/ark:/12148/cb10379875d#foaf:Person]
</ud>
<ud>
Agricol-Joseph-François-Xavier-Pierre-Esprit-Simon-Paul-Antoine Fortia d''Urban (<en type="li">Avignon</en>, <dat when="1756">1756</dat>) Mathématicien et littérateur. - Chevalier de la Légion d''honneur en 1811, correspondant de l''Académie de Belgique en 1828 et membre libre de l''Académie des Inscriptions et belles-lettres en 1830 [http://data.bnf.fr/ark:/12148/cb121468483#foaf:Person]
</ud>
<ud>
Alexandre Ruelle (<en type="li">Blois</en>, <dat when="1756">1756</dat>) Astronome. - Professeur d''astronomie à l''Observatoire de Paris de 1783 à 1795 [http://data.bnf.fr/ark:/12148/cb121582720#foaf:Person]
</ud>
<ud>
Ernst Gottfried Fischer (<dat when="1756">1756</dat>) Physicien et mathématicien [http://data.bnf.fr/ark:/12148/cb124025182#foaf:Person]
</ud>
<ud>
Jan Chrzciciel Władysław Śniadecki (<dat when="1756">1756</dat>) Mathématicien et philosophe, un des plus grands savants polonais des Lumières [http://data.bnf.fr/ark:/12148/cb123726267#foaf:Person]
</ud>
<ud>
Joseph Mollet (Aix-en-Provence (Bouches-du-Rhône), <dat when="1756">1756</dat>) Oratorien. - Professeur de physique et de mathématique, École Centrale, Lyon, Rhône. - Doyen de la Faculté des sciences de Lyon (1809-1815) [http://data.bnf.fr/ark:/12148/cb12196474k#foaf:Person]
</ud>
<ud>
Carl-Christian von Langsdorf (<en type="li">Nauheim (Allemagne)</en>, <dat when="1757">1757</dat>) Mathématicien. - Ingénieur. - Professeur de mathématiques à Erlangen (Allemagne), de 1798 à 1804, puis à Vilnius (Lituanie) de 1804 à 1806. - Frère de Langsdorf, Johann-Wilhelm (1745-1827) [http://data.bnf.fr/ark:/12148/cb10661030m#foaf:Person]
</ud>
<ud>
Dominique Blanqui (<dat when="1757">1757</dat>) Professeur de philosophie et d''astronomie. - Député à la Convention. - Membre du Conseil des Cinq-cents [http://data.bnf.fr/ark:/12148/cb12534874n#foaf:Person]
</ud>
<ud>
Alexandre-Balthazar-Laurent Grimod de La Reynière (<en type="li">Paris</en>, <dat when="1758">1758</dat>) Avocat. - Pamphlétaire. - Gastronome, fondateur et président du "Jury dégustateur" [http://data.bnf.fr/ark:/12148/cb11905936j#foaf:Person]
</ud>
<ud>
Johann Christoph Schuster (<dat when="1759">1759</dat>) Mathématicien [http://data.bnf.fr/ark:/12148/cb16505504t#foaf:Person]
</ud>
<ud>
Louis-François-Antoine Arbogast (<en type="li">Mutzig, Alsace</en>, <dat when="1759">1759</dat>) Mathématicien. - Directeur du Collège royal (en 1791). - Député à l''Assemblée législative puis à la Convention nationale [http://data.bnf.fr/ark:/12148/cb12520232w#foaf:Person]
</ud>
<ud>
Pierre-René-Auguste Bremond d''Ars (<dat when="1759">1759</dat>) Député de la noblesse. - Fut professeur de mathématiques et de latin [http://data.bnf.fr/ark:/12148/cb12540611f#foaf:Person]
</ud>
<ud>
Thomas Keith (<en type="li">Winestead (GB)</en>, <dat when="1759">1759</dat>) Mathématicien. - Professeur [http://data.bnf.fr/ark:/12148/cb10275963j#foaf:Person]
</ud>
<ud>
Giovanni Paradisi (<en type="li">Reggio Emilia, Italie</en>, <dat when="1760">1760</dat>) Comte. - Homme politique. - Mathématicien. - Poète [http://data.bnf.fr/ark:/12148/cb105910991#foaf:Person]
</ud>
<ud>
Nicolas Antoine Guillard (<en type="li">Sorbais, Aisne</en>, <dat when="1760">1760</dat>) Professeur de mathématiques [http://data.bnf.fr/ark:/12148/cb10617134p#foaf:Person]
</ud></root>', 8, NULL, '{ud0}
Hermann de Carinthie ({en0li}île de Korčula (Croatie){/en}, {dat1105}1105{/dat}) Philosophe, écrivain, mathématicien, astrologue et traducteur croate [http://data.bnf.fr/ark:/12148/cb16243624j#foaf:Person]
{/ud}
{ud0}
Hermann le Dalmate ({en0li}Saint Peter en Istrie une partie du duché de Carinthie (au sud de l''Autriche){/en}, {dat1110}1110{/dat}) Philosophe, astronome, astrologue, mathématicien et traducteur d''ouvrages scientifiques et de la littérature. - Il vint très jeune en 1135 en France à Paris et à Chartres. - Eut pour maître Thierry de Chartres. - L''abbé de Cluny, Pierre le Vénérable, poussa Herman à traduire à écrire sur la vie et l''oeuvre de Mahomet [http://data.bnf.fr/ark:/12148/cb12364029w#foaf:Person]
{/ud}
{ud0}
Bhāskarācārya ({en0li}Dekkan, Inde{/en}, {dat1114}1114{/dat}) Mathématicien. - Astronome. - Fils de Maheśvara. - Auteur de :  "Siddhāntaśiromanī" (en 1150) ; "Karṇakutūhala" [http://data.bnf.fr/ark:/12148/cb14498624v#foaf:Person]
{/ud}
{ud0}
al-Muẓaffar ibn Muḥammad Šaraf al-Dīn Ṭūsī ({dat1151}1151{/dat}) Mathématicien. - Originaire de Ṭūs, Hamad̲ān, Mosul, Alep, Damas. - Écrivait vers 1209 [http://data.bnf.fr/ark:/12148/cb120864072#foaf:Person]
{/ud}
{ud0}
Johannes de Sacro Bosco ({dat1151}1151{/dat}) Mathématicien. - Chanoine prémontré de Holywood (comté de Dumfries, Écosse). - Professeur à l''Université de Paris. - Semble être né à Halifax (Yorkshire, Angleterre). - Mort en 1256 ou 1244 [http://data.bnf.fr/ark:/12148/cb121284153#foaf:Person]
{/ud}
{ud0}
Robertus Castrensis ({dat1151}1151{/dat}) Traducteur de traités scientifiques et de mathématiques. - Sa période d''activité se situe aux alentours de 1145 [http://data.bnf.fr/ark:/12148/cb12223624k#foaf:Person]
{/ud}
{ud0}
Alexandre de Villedieu ({en0li}Villedieu (Manche){/en}, {dat1170}1170{/dat}) Franciscain. - Grammairien, mathématicien et poète. - Chanoine de la cathédrale Saint-André d''Avranches [http://data.bnf.fr/ark:/12148/cb12536245w#foaf:Person]
{/ud}
{ud0}
Leonardo Fibonacci ({dat1170}1170{/dat}) Mathématicien. - Surnommé Leonardo Pisano [http://data.bnf.fr/ark:/12148/cb13092437c#foaf:Person]
{/ud}
{ud0}
Moḥamad ben Moḥamad Naṣīr al-Dīn Ṭōsī ({en0li}Tus (Iran){/en}, {dat1201}1201{/dat}) Mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb12399386c#foaf:Person]
{/ud}
{ud0}
Jean Pecham ({dat1220}1220{/dat}) Provincial des franciscains d''Angleterre. - Archevêque de Cantorbéry (à partir de 1279). - Théologien, mathématicien et physicien [http://data.bnf.fr/ark:/12148/cb12459837w#foaf:Person]
{/ud}
{ud0}
Witelo ({dat1220}1220{/dat}) Philosophe et mathématicien [http://data.bnf.fr/ark:/12148/cb12054316n#foaf:Person]
{/ud}
{ud0}
Maḥmūd ibn Mas´ūd Quṭb al-Dīn al- Šīrāzī ({en0li}Shīrāz{/en}, {dat1236}1236{/dat}) Astronome, médecin, philosophe et théologien [http://data.bnf.fr/ark:/12148/cb12086388m#foaf:Person]
{/ud}
{ud0}
Jacob ben Machir ({en0li}Marseille{/en}, {dat1238}1238{/dat}) Astronome. - Médecin. - Chancellier de la faculté de médecine de Montpellier [http://data.bnf.fr/ark:/12148/cb165406517#foaf:Person]
{/ud}
{ud0}
Grégoire Chioniadès ({dat1240}1240{/dat}) Astronome, physicien et médecin byzantin. - Évêque de Tabriz, Iran [http://data.bnf.fr/ark:/12148/cb12007088c#foaf:Person]
{/ud}
{ud0}
Henri Baten ({dat1246}1246{/dat}) Philosophe et théologien. - Astronome. - Poète et musicien [http://data.bnf.fr/ark:/12148/cb12220635h#foaf:Person]
{/ud}
{ud0}
al-Mufaḍḍal ibn ʿUmar Aṯīr al-Dīn al-Abharī ({dat1251}1251{/dat}) Philosophe, logicien, astronome [http://data.bnf.fr/ark:/12148/cb15935708x#foaf:Person]
{/ud}
{ud0}
Bartolomeo da Parma ({dat1251}1251{/dat}) Astrologue, géomancien et astronome. Fut professeur à l''Université de Bologne (1288-1297) [http://data.bnf.fr/ark:/12148/cb144790439#foaf:Person]
{/ud}
{ud0}
Campanus de Novare ({dat1251}1251{/dat}) Astronome. - Mathématicien, commentateur d''Euclide [http://data.bnf.fr/ark:/12148/cb124917005#foaf:Person]
{/ud}
{ud0}
David ben Yom-Tov Poel ({dat1251}1251{/dat}) Philosophe. - Médecin. - Père de l''astronome Jacob Poel [http://data.bnf.fr/ark:/12148/cb16540698w#foaf:Person]
{/ud}
{ud0}
Démétrius Triclinius ({en0li}Thessalonique{/en}, {dat1251}1251{/dat}) Philologue. - Mathématicien et astrologue [http://data.bnf.fr/ark:/12148/cb12311753x#foaf:Person]
{/ud}
{ud0}
Geršon ben Salomon d''Arles ({en0li}Béziers{/en}, {dat1251}1251{/dat}) Éxégète. - Astronome [http://data.bnf.fr/ark:/12148/cb134867338#foaf:Person]
{/ud}
{ud0}
Hui Yang ({dat1251}1251{/dat}) Mathématicien chinois. En activité entre 1261 et 1275 [http://data.bnf.fr/ark:/12148/cb13746624q#foaf:Person]
{/ud}
{ud0}
Isaac ben Joseph Israeli ({dat1251}1251{/dat}) Astronome. - Elève d''Asher ben Jehiel [http://data.bnf.fr/ark:/12148/cb16540863s#foaf:Person]
{/ud}
{ud0}
Jacopo da Firenze ({dat1251}1251{/dat}) Mathématicien. - Actif en 1307 [http://data.bnf.fr/ark:/12148/cb157815579#foaf:Person]
{/ud}
{ud0}
Jordanus Nemorarius ({dat1251}1251{/dat}) Mathématicien. - Probablement d''origine italienne [http://data.bnf.fr/ark:/12148/cb11986727x#foaf:Person]
{/ud}
{ud0}
Petrus Philomena de Dacia ({dat1251}1251{/dat}) Mathématicien, astronome, philosophe. - Attesté entre 1290 et 1300. - Élève à l''Université de Bologne (1291-1292) puis de Paris. - Chanoine de Roskilde, Danemark. - A distinguer de Petrus de Dacia, recteur de l''Université de Paris en 1327 [http://data.bnf.fr/ark:/12148/cb11887258w#foaf:Person]
{/ud}
{ud0}
ʿAbd al-Ġaffār ibn ʿAbd al-Karīm Naǧm al-Dīn al- Qazwīnī ({dat1251}1251{/dat}) Mathématicien et jurisconsulte chaféite [http://data.bnf.fr/ark:/12148/cb155674927#foaf:Person]
{/ud}
{ud0}
Andalò Di Negro ({en0li}Gênes (?), Italie{/en}, {dat1260}1260{/dat}) Astronome. - Précepteur de Boccace. - Ambassadeur de la République de Gênes auprès de l''empereur Alexis Comnène (en 1314) [http://data.bnf.fr/ark:/12148/cb121998732#foaf:Person]
{/ud}
{ud0}
Théodore Métochite ({en0li}Constantinople{/en}, {dat1260}1260{/dat}) Homme d''état, philosophe, poète, astronome et rhéteur [http://data.bnf.fr/ark:/12148/cb12000562c#foaf:Person]
{/ud}
{ud0}
Gersonide (Bagnols-sur-Cèze ({en0li}Gard){/en}, {dat1288}1288{/dat}) Exégète biblique, mathématicien, astronome, philosophe, physicien [http://data.bnf.fr/ark:/12148/cb12131941j#foaf:Person]
{/ud}
{ud0}
Barlaam de Seminara ({dat1290}1290{/dat}) Moine basilien, abbé du Saint-Esprit à Constantinople ({dat1331}1331{/dat}), évêque de Gérace (1342-1348). - Théologien, philosophe, mathématicien, astronome et helléniste [http://data.bnf.fr/ark:/12148/cb13549924x#foaf:Person]
{/ud}
{ud0}
Jacopo Dondi ({dat1290}1290{/dat}) Philosophe, astronome, médecin italien célèbre pour la construction d''une pendule astrale à Padoue. - Père de Giovanni Dondi [http://data.bnf.fr/ark:/12148/cb124119184#foaf:Person]
{/ud}
{ud0}
Thomas Bradwardine ({dat1290}1290{/dat}) Mathématicien, philosophe et théologien. - Surnommé le "Doctor Profundus". - Archevêque de Canterbury en 1349 [http://data.bnf.fr/ark:/12148/cb12269047v#foaf:Person]
{/ud}
{ud0}
Richard of Wallingford ({dat1292}1292{/dat}) Mathématicien. - Astronome. - Abbé du monastère bénédictin de St Albans [http://data.bnf.fr/ark:/12148/cb12128305h#foaf:Person]
{/ud}
{ud0}
Jean de Murs ({dat1300}1300{/dat}) Astronome, mathématicien et théoricien de la musique. - Maître-ès-arts de l''Université de Paris ({dat1321}1321{/dat}) [http://data.bnf.fr/ark:/12148/cb121715011#foaf:Person]
{/ud}
{ud0}
Giovanni Dondi dall''Orologio ({en0li}Chiogga, Italie{/en}, {dat1318}1318{/dat}) Médecin et poète. - Astronome et horloger, a terminé l''horloge astronomique, installée par son père : Dondi, Jacopo (1298-1359), à Padoue ou Pavie, Italie [http://data.bnf.fr/ark:/12148/cb122241024#foaf:Person]
{/ud}
{ud0}
Giacomo Allegretti ({dat1325}1325{/dat}) Médecin , poète et astronome [http://data.bnf.fr/ark:/12148/cb14405998n#foaf:Person]
{/ud}
{ud0}
Blasius de Parma ({dat1347}1347{/dat}) Philosophe, mathématicien, médecin. - Recteur de l''université de Parme (en 1412) [http://data.bnf.fr/ark:/12148/cb12182615f#foaf:Person]
{/ud}
{ud0}
Abū ʿAbd Allâh Muḥammad al- Baqqār ({dat1351}1351{/dat}) Mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb155102056#foaf:Person]
{/ud}
{ud0}
Emmanuel ben Jacob de Tarascon Bonfils ({dat1351}1351{/dat}) Astronome, médecin et mathématicien ayant vécu à Orange puis à Tarascon. Il est l''auteur de nombreux traités d''astronomie [http://data.bnf.fr/ark:/12148/cb15620448d#foaf:Person]
{/ud}
{ud0}
Ǧamšīd ibn Masʿūd Ġiyāṯ al-Dīn al- Kāšī ({dat1351}1351{/dat}) Médecin, mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb11351746b#foaf:Person]
{/ud}
{ud0}
Johannes Danck ({dat1351}1351{/dat}) Astronome. - A enseigné à l''Université de Paris de 1327 à 1355 [http://data.bnf.fr/ark:/12148/cb12531239r#foaf:Person]
{/ud}
{ud0}
Naǧm al-Dīn al- Miṣrī ({dat1351}1351{/dat}) Auteur supposé de traités portant sur les instruments astronomiques [http://data.bnf.fr/ark:/12148/cb14566743g#foaf:Person]
{/ud}
{ud0}
Prosdocimus de Beldemandis ({dat1351}1351{/dat}) Théoricien de la musique, mathématicien et physicien [http://data.bnf.fr/ark:/12148/cb127653823#foaf:Person]
{/ud}
{ud0}
Taddeo da Parma ({dat1351}1351{/dat}) Philosophe averroïste et astronome. - A enseigné la philosophie à Bologne vers 1320 [http://data.bnf.fr/ark:/12148/cb10103512f#foaf:Person]
{/ud}
{ud0}
Théodore Méliténiote ({en0li}Constantinople{/en}, {dat1351}1351{/dat}) Grand sacellaire de l''Église byzantine, maître des maîtres de l''École patriarcale et archidiacre du clergé palatin. - A laissé un ouvrage d''exégèse de l''Évangile, un traité d''astronomie et un poème allégorique [http://data.bnf.fr/ark:/12148/cb12153709d#foaf:Person]
{/ud}
{ud0}
Paolo dal Pozzo Toscanelli ({dat1397}1397{/dat}) Mathématicien, physicien, géographe, astronome et astrologue. - Inventeur des gnomons modernes. - Conservateur de la Bibliothèque de Florence [http://data.bnf.fr/ark:/12148/cb12455406j#foaf:Person]
{/ud}
{ud0}
Ugolino Pisani ({en0li}Parme, Italie{/en}, {dat1405}1405{/dat}) Philosophe, mathématicien, auteur de comédies [http://data.bnf.fr/ark:/12148/cb12689419t#foaf:Person]
{/ud}
{ud0}
Lorenzo Buonincontri ({en0li}San Miniato, Italie{/en}, {dat1411}1411{/dat}) Militaire, mathématicien, astronome, astrologue, poète et historien. - Professeur d''astronomie à Naples [http://data.bnf.fr/ark:/12148/cb12536229n#foaf:Person]
{/ud}
{ud0}
ʿAlī ibn Muḥammad al- Qalaṣādī ({en0li}Baza (Espagne){/en}, {dat1412}1412{/dat}) Mathématicien, astronome, juriste et savant [http://data.bnf.fr/ark:/12148/cb12440997n#foaf:Person]
{/ud}
{ud0}
Piero della Francesca ({en0li}Borgo San Sepolcro, Italie{/en}, {dat1416}1416{/dat}) Peintre. - A écrit des traités de mathématiques, perspective et géométrie et des écrits sur la science des couleurs et du paysage [http://data.bnf.fr/ark:/12148/cb12060279h#foaf:Person]
{/ud}
{ud0}
Georgius de Hungaria ({en0li}Romosz, aujourd''hui Romos, Roumanie{/en}, {dat1422}1422{/dat}) Prisonnier des Turcs (1438-1458). - Dominicain. - Mathématicien [http://data.bnf.fr/ark:/12148/cb130923013#foaf:Person]
{/ud}
{ud0}
Antonio Manetti ({en0li}Florence, Italie{/en}, {dat1423}1423{/dat}) Homme de lettres. - Architecte, astronome, mathématicien [http://data.bnf.fr/ark:/12148/cb11914242h#foaf:Person]
{/ud}
{ud0}
Georg von Peurbach ({en0li}Peuerbach, Autriche{/en}, {dat1423}1423{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb12374660w#foaf:Person]
{/ud}
{ud0}
Giovanni Pontano ({en0li}Cerreto di Spoleto (Perouse), Italie{/en}, {dat1426}1426{/dat}) Homme politique. - Humaniste. - Auteur de traités astronomiques et philosophiques [http://data.bnf.fr/ark:/12148/cb123298807#foaf:Person]
{/ud}
{ud0}
Johannes Regiomontanus ({en0li}Königsberg, Allemagne{/en}, {dat1436}1436{/dat}) Astronome. - Mathématicien [http://data.bnf.fr/ark:/12148/cb12159829r#foaf:Person]
{/ud}
{ud0}
Nīlakaṇṭha Somayajī ({dat1443}1443{/dat}) Astronome et mathématicien de l''école de Kerala (Inde) [http://data.bnf.fr/ark:/12148/cb165324540#foaf:Person]
{/ud}
{ud0}
Luca Pacioli ({dat1445}1445{/dat}) Mathématicien. - Franciscain [http://data.bnf.fr/ark:/12148/cb11918350c#foaf:Person]
{/ud}
{ud0}
Konrad Türst ({dat1450}1450{/dat}) Mathématicien suisse de Zürich [http://data.bnf.fr/ark:/12148/cb15336511g#foaf:Person]
{/ud}
{ud0}
Agostino Ricci ({dat1451}1451{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb12539498r#foaf:Person]
{/ud}
{ud0}
Andrea Corsali ({dat1451}1451{/dat}) Astronome, cosmographe, navigateur dans la péninsule arabique et aux Indes. - Pourrait avoir introduit l''imprimerie en Éthiopie (ca 1524), où vraisemblament il meurt [http://data.bnf.fr/ark:/12148/cb13517283d#foaf:Person]
{/ud}
{ud0}
Anianus ({dat1451}1451{/dat}) Astronome et poète [http://data.bnf.fr/ark:/12148/cb125156549#foaf:Person]
{/ud}
{ud0}
Antonio Dolciati ({dat1451}1451{/dat}) Augustinien et mathématicien [http://data.bnf.fr/ark:/12148/cb134854696#foaf:Person]
{/ud}
{ud0}
Bartolomeo da Messina ({dat1451}1451{/dat}) Écclésiastique et mathématicien [http://data.bnf.fr/ark:/12148/cb125393703#foaf:Person]
{/ud}
{ud0}
Gaspar Torrella ({dat1451}1451{/dat}) Médecin et mathématicien. - Évêque de Santa-Giusta (Sardaigne) en 1494. - Originaire de Valence (Espagne) [http://data.bnf.fr/ark:/12148/cb13486025q#foaf:Person]
{/ud}
{ud0}
Giovanni Abiosi ({dat1451}1451{/dat}) Médecin, astronome, mathématicien et philosophe. - Né à Bagnuolo (Royaume de Naples), mort vers 1500 [http://data.bnf.fr/ark:/12148/cb12537367q#foaf:Person]
{/ud}
{ud0}
Giovanni Antonio Tagliente ({dat1451}1451{/dat}) Calligraphe. - Mathématicien [http://data.bnf.fr/ark:/12148/cb12179148h#foaf:Person]
{/ud}
{ud0}
Giovanni Benedetto Moncetto ({dat1451}1451{/dat}) Agostinien. - Théologien, philosophe et astronome [http://data.bnf.fr/ark:/12148/cb125688716#foaf:Person]
{/ud}
{ud0}
Giovanni Bianchini ({dat1451}1451{/dat}) Astronome mort après 1469 [http://data.bnf.fr/ark:/12148/cb16163624s#foaf:Person]
{/ud}
{ud0}
Guillaume Hobit ({dat1451}1451{/dat}) Astronome ; astrologue de Philippe le Bon, duc de Bourgogne [http://data.bnf.fr/ark:/12148/cb15063496s#foaf:Person]
{/ud}
{ud0}
Jacob Köbel ({en0li}Heidelberg, Allemagne{/en}, {dat1451}1451{/dat}) Mathématicien, éditeur et libraire [http://data.bnf.fr/ark:/12148/cb10244031k#foaf:Person]
{/ud}
{ud0}
Louis Boulengier ({dat1451}1451{/dat}) Astronome et géographe d''Albi [http://data.bnf.fr/ark:/12148/cb152949413#foaf:Person]
{/ud}
{ud0}
Rāmacandrācārya ({dat1451}1451{/dat}) Grammairien et commentateur de Pāṇini (actif au 15e s.). - Fils de Kr̥ṣṇācārya. - A aussi écrit des ouvrages de philosophie (Vedānta) et d''astronomie [http://data.bnf.fr/ark:/12148/cb137708651#foaf:Person]
{/ud}
{ud0}
Sigismondo Fanti ({en0li}Ferrare, Italie{/en}, {dat1451}1451{/dat}) Poète, philosophe et mathématicien. - Meurt après 1527 [http://data.bnf.fr/ark:/12148/cb12567416q#foaf:Person]
{/ud}
{ud0}
Willem Gilliszoon ({dat1451}1451{/dat}) Astronome et mathématicien. - Originaire de Wissekerc (Zélande) [http://data.bnf.fr/ark:/12148/cb12548011q#foaf:Person]
{/ud}
{ud0}
Girolamo Donato ({dat1454}1454{/dat}) Magistrat, poète, philosophe, théologien et mathématicien. - Fut gouverneur de Brescia ({dat1496}1496{/dat}), de Ferrare ({dat1498}1498{/dat}), ambassadeur de Venise près le pape Jules II ({dat1510}1510{/dat}) [http://data.bnf.fr/ark:/12148/cb13325565p#foaf:Person]
{/ud}
{ud0}
Eliya Delmedigo ({dat1460}1460{/dat}) Médecin. - Astronome. - Mathématicien. - Né en Crète. - Philosophe. - Maître d''hébreu de Pic de la Mirandole (1463-1494). - Commentateur des écrits d''Averroés (1126-1198) [http://data.bnf.fr/ark:/12148/cb122623668#foaf:Person]
{/ud}
{ud0}
Lodovico Pontico Virunio ({dat1467}1467{/dat}) Professeur de lettres, philosophe, mathématicien et poète. - Fut chargé de l''éducation des fils de Ludovico Sforza, duc de Milan. - Eut l''intention de fonder une imprimerie grecque et latine à Reggio Emilia, mais ses caractères furent volés par Ludovico Bonaccioli, médecin de la duchesse de Ferrare. - Né à Belluno, meurt à Bologne [http://data.bnf.fr/ark:/12148/cb13324006j#foaf:Person]
{/ud}
{ud0}
Johannes Werner ({en0li}Nuremberg, Allemagne{/en}, {dat1468}1468{/dat}) Mathématicien, astronome et cartographe [http://data.bnf.fr/ark:/12148/cb154028305#foaf:Person]
{/ud}
{ud0}
Jakob Ziegler ({en0li}Landau (Allemagne){/en}, {dat1470}1470{/dat}) Théologien, mathématicien, astronome et géographe. - Professeur de théologie. - Commentateur et auteur d''ouvrages historiques et théologiques [http://data.bnf.fr/ark:/12148/cb15029346k#foaf:Person]
{/ud}
{ud0}
Pedro Ciruelo ({en0li}Daroca, Espagne{/en}, {dat1470}1470{/dat}) Professeur de théologie à l''Université d''Alcala (1510-), chanoine de la cathédrale de cette ville. - Fut l''un des précepteurs de Philippe II. - Étudia à Salamanque et à Paris, où il édita des oeuvres mathématiques et scientifiques. - Est également l''auteur d''un traité sur la sorcellerie dont la traduction espagnole eut une diffusion importante [http://data.bnf.fr/ark:/12148/cb128071494#foaf:Person]
{/ud}
{ud0}
Johann Stöffler ({en0li}Justingen, Allemagne{/en}, {dat1472}1472{/dat}) Astronome et mathématicien [http://data.bnf.fr/ark:/12148/cb125156905#foaf:Person]
{/ud}
{ud0}
Josse Clicthove (Nieuport, Pays-Bas, {dat1472}1472{/dat}) Théologien et mathématicien. - Théologal de Chartres. - Un des premiers à combattre les idées de Luther [http://data.bnf.fr/ark:/12148/cb12234610b#foaf:Person]
{/ud}
{ud0}
Bartolomeo Zamberti ({en0li}Venise, Italie{/en}, {dat1473}1473{/dat}) Mathématicien et humaniste. - Professeur de lettres. - Notaire des Consuls des marchands de Venise [http://data.bnf.fr/ark:/12148/cb12033590z#foaf:Person]
{/ud}
{ud0}
Nicolas Copernic ({dat1473}1473{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb118976048#foaf:Person]
{/ud}
{ud0}
Luca Gaurico ({en0li}Giffoni, Italie{/en}, {dat1476}1476{/dat}) Évêque de Civita Ducale (1545-1549). - Mathématicien, philosophe, astronome et astrologue [http://data.bnf.fr/ark:/12148/cb134849440#foaf:Person]
{/ud}
{ud0}
Johann Schöner ({dat1477}1477{/dat}) Né à Karlstadt près de Würzburg. - Prédicateur protestant. - Astronome. - Géographe. - Professeur de mathématiques à Nuremberg. - A aussi écrit en latin [http://data.bnf.fr/ark:/12148/cb119992233#foaf:Person]
{/ud}
{ud0}
Girolamo Fracastoro ({en0li}Vérone, Italie{/en}, {dat1478}1478{/dat}) Médecin, auteur du "De contagione et contagiosis morbis et curatione libri III" ; nommé par le pape Paul III médecin officiel du Concile de Trente. - Auteur de poèmes en latin, d''oeuvres de géographie, d''astronomie, de physique, de théologie et de philosophie. - Élève de Pomponazzi, ami de Copernic [http://data.bnf.fr/ark:/12148/cb120587788#foaf:Person]
{/ud}
{ud0}
Girolamo Francastoro ({dat1478}1478{/dat}) Médecin, astronome, géologiste, poète, précurseur de la notion de contagion [http://data.bnf.fr/ark:/12148/cb15699396m#foaf:Person]
{/ud}
{ud0}
Celio Calcagnini ({en0li}Ferrare, Italie{/en}, {dat1479}1479{/dat}) Poète, philologue, philosophe et astronome. - Accompagna Hippolyte d''Este en Hongrie et en Pologne [http://data.bnf.fr/ark:/12148/cb122157991#foaf:Person]
{/ud}
{ud0}
Charles de Bovelles ({dat1479}1479{/dat}) Philosophe, mathématicien et linguiste. - Chanoine de Noyon. - Né avant le 28 mars 1479 [http://data.bnf.fr/ark:/12148/cb118932166#foaf:Person]
{/ud}
{ud0}
Prospero Calano ({en0li}Sarzana, Italie{/en}, {dat1480}1480{/dat}) Médecin, astronome et philosophe [http://data.bnf.fr/ark:/12148/cb12568870v#foaf:Person]
{/ud}
{ud0}
Vannoccio Biringuccio ({en0li}Sienne, Italie{/en}, {dat1480}1480{/dat}) Mathématicien, chimiste, architecte et ingénieur, spécialiste en métallurgie [http://data.bnf.fr/ark:/12148/cb12195640k#foaf:Person]
{/ud}
{ud0}
Michael Stifel ({dat1487}1487{/dat}) Théologien et mathématicien. - Inventeur du logarithme. - Enseigna la théologie et les mathématiques à l''Université de Königsberg, puis les mathématiques à l''Université de Iéna [http://data.bnf.fr/ark:/12148/cb12795734z#foaf:Person]
{/ud}
{ud0}
Sebastian Münster ({en0li}Ingelheim, Allemagne{/en}, {dat1489}1489{/dat}) Hébraïsant, géographe et mathématicien [http://data.bnf.fr/ark:/12148/cb11996987j#foaf:Person]
{/ud}
{ud0}
Albert Pighius (Kampen, Pays-Bas, {dat1490}1490{/dat}) Théologien, mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb10448635x#foaf:Person]
{/ud}
{ud0}
Patrizio Tricasso ({en0li}Ceresara, Italie{/en}, {dat1491}1491{/dat}) Dominicain. - Mathématicien et astrologue [http://data.bnf.fr/ark:/12148/cb107034397#foaf:Person]
{/ud}
{ud0}
Heinrich Schreiber ({en0li}Erfurt, Allemagne{/en}, {dat1492}1492{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb10734904t#foaf:Person]
{/ud}
{ud0}
Jean Borrel ({dat1492}1492{/dat}) Géomètre et mathématicien. - Chanoine régulier de l''Ordre de Saint-Antoine [http://data.bnf.fr/ark:/12148/cb12515817n#foaf:Person]
{/ud}
{ud0}
Pedro Nunez ({dat1492}1492{/dat}) Astronome et mathématicien [http://data.bnf.fr/ark:/12148/cb12548918m#foaf:Person]
{/ud}
{ud0}
Oronce Fine (Briançon (Hautes-Alpes), {dat1494}1494{/dat}) Sieur de Champrouet. - Mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb122937307#foaf:Person]
{/ud}
{ud0}
Petrus Apian ({en0li}Leisnig (Allemagne){/en}, {dat1495}1495{/dat}) Astronome, cartographe et mathématicien. - Nommé Chevalier de l''Empire par Charles Quint. - Surnom de : Bienewitz (ou Bennewitz), Peter [http://data.bnf.fr/ark:/12148/cb12515640m#foaf:Person]
{/ud}
{ud0}
Andreas Osiander ({en0li}Gunzenhausen, Allemagne{/en}, {dat1498}1498{/dat}) Théologien protestant, astronome et mathématicien. - Parfois désigné sous le nom "Andreas Osiander l''Ancien" [http://data.bnf.fr/ark:/12148/cb11988942v#foaf:Person]
{/ud}
{ud0}
Garcia da Orta ({en0li}Castelo di Vide, Portugal{/en}, {dat1499}1499{/dat}) Médecin et naturaliste. - A enseigné les mathématiques à l''Université de Lisbonne [http://data.bnf.fr/ark:/12148/cb119983323#foaf:Person]
{/ud}
{ud0}
Giovanni Agostino Abate ({dat1499}1499{/dat}) Mathématicien et historien [http://data.bnf.fr/ark:/12148/cb14624324z#foaf:Person]
{/ud}
{ud0}
Joachim Sterck van Ringelberg ({en0li}Anvers, Belgique{/en}, {dat1499}1499{/dat}) Humaniste, mathématicien et astrologue. - Meurt selon les sources le 1er janvier 1531, en 1536 ou en 1556 [http://data.bnf.fr/ark:/12148/cb10645118k#foaf:Person]
{/ud}
{ud0}
Johann Carion ({en0li}Bietigheim, Allemagne{/en}, {dat1499}1499{/dat}) Astrologue et mathématicien [http://data.bnf.fr/ark:/12148/cb12805831h#foaf:Person]
{/ud}
{ud0}
Johannes Dryander ({en0li}Wetter, Allemagne{/en}, {dat1500}1500{/dat}) Mathématicien, physicien et astronome, professeur à Marburg, édité par Sebastian Münster et Abraham Ortelius [http://data.bnf.fr/ark:/12148/cb15379218m#foaf:Person]
{/ud}
{ud0}
Johannes Voegelin ({en0li}Heilbronn, Allemagne{/en}, {dat1500}1500{/dat}) Astronome et mathématicien. - Professeur à l''Université de Vienne [http://data.bnf.fr/ark:/12148/cb10490264h#foaf:Person]
{/ud}
{ud0}
Niccolò Tartaglia ({dat1500}1500{/dat}) Mathématicien, ingénieur et architecte. - Pseudonyme de Niccolò Fontana [http://data.bnf.fr/ark:/12148/cb12914492r#foaf:Person]
{/ud}
{ud0}
Gerolamo Cardano ({en0li}Pavie, Italie{/en}, {dat1501}1501{/dat}) Médecin, mathématicien et philosophe [http://data.bnf.fr/ark:/12148/cb11895137c#foaf:Person]
{/ud}
{ud0}
Pedro Nunes ({en0li}Alcácer do Sol (Portugal){/en}, {dat1502}1502{/dat}) Astronome et mathématicien portugais [http://data.bnf.fr/ark:/12148/cb13510349t#foaf:Person]
{/ud}
{ud0}
Cosimo Bartoli ({en0li}Florence, Italie{/en}, {dat1503}1503{/dat}) Ambassadeur, poète et mathématicien [http://data.bnf.fr/ark:/12148/cb125520809#foaf:Person]
{/ud}
{ud0}
Jean Cousin ({en0li}Soucy (Yonne, France){/en}, {dat1503}1503{/dat}) Peintre, sculpteur, graveur, architecte, mathématicien [http://data.bnf.fr/ark:/12148/cb12467444s#foaf:Person]
{/ud}
{ud0}
Ciriaco Strozzi ({en0li}Capalle, Italie{/en}, {dat1504}1504{/dat}) Helléniste, philosophe, mathématicien et architecte [http://data.bnf.fr/ark:/12148/cb10418521b#foaf:Person]
{/ud}
{ud0}
Jacques Bassantin ({dat1504}1504{/dat}) Astronome et mathématicien [http://data.bnf.fr/ark:/12148/cb12548014r#foaf:Person]
{/ud}
{ud0}
Achille Pirminius Gasser ({dat1505}1505{/dat}) Médecin, historien et astronome [http://data.bnf.fr/ark:/12148/cb12516715x#foaf:Person]
{/ud}
{ud0}
Benedictus Aretius ({dat1505}1505{/dat}) Théologien protestant. - Botaniste et astronome. - Professeur de logique à l''Université de Marbourg, puis professeur de théologie à Berne. - Fut lié avec Conrad Gesner. - Né et mort à Berne [http://data.bnf.fr/ark:/12148/cb12515850g#foaf:Person]
{/ud}
{ud0}
Alessandro Piccolomini ({en0li}Sienne, Italie{/en}, {dat1508}1508{/dat}) Écrivain, dramaturge, astronome et traducteur d''oeuvres de l''Antiquité, de comédies, de traités philosophiques et scientifiques. - Membre de l''Accademia degli Intronati de Sienne, sous le pseudonyme : lo Stordito. - Archevêque de Patras et coadjuteur de l''archevêque de Sienne Francesco Bandini Piccolomini, du 28 juillet 1574 à 1578 [http://data.bnf.fr/ark:/12148/cb12240709n#foaf:Person]
{/ud}
{ud0}
Gemma Frisius (Dokkum (Pays-Bas), {dat1508}1508{/dat}) Mathématicien et astronome. - Professeur et docteur en médecine de l''Université de Louvain [http://data.bnf.fr/ark:/12148/cb125195002#foaf:Person]
{/ud}
{ud0}
Federico Commandino ({en0li}Sassocorvaro, Italie{/en}, {dat1509}1509{/dat}) Mathématicien. - A été le tuteur du duc d''Urbino [http://data.bnf.fr/ark:/12148/cb12562850s#foaf:Person]
{/ud}
{ud0}
Jean Gosselin ({en0li}Vire, Calvados{/en}, {dat1510}1510{/dat}) Astrologue et mathématicien. - Conservateur de la bibliothèque du roi [http://data.bnf.fr/ark:/12148/cb133321861#foaf:Person]
{/ud}
{ud0}
Pietro Cataneo ({dat1510}1510{/dat}) Architecte et mathématicien [http://data.bnf.fr/ark:/12148/cb12557068n#foaf:Person]
{/ud}
{ud0}
Erasmus Oswald Schreckenfuchs ({dat1511}1511{/dat}) Hébraïsant. - Astronome [http://data.bnf.fr/ark:/12148/cb12115338j#foaf:Person]
{/ud}
{ud0}
Giovanni Battista Amici ({en0li}Cosenza, Italie{/en}, {dat1511}1511{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb15583428k#foaf:Person]
{/ud}
{ud0}
Juanelo Turriano ({dat1511}1511{/dat}) Mathématicien et ingénieur [http://data.bnf.fr/ark:/12148/cb129309990#foaf:Person]
{/ud}
{ud0}
Gerard Mercator ({en0li}Rupelmonde, Flandres{/en}, {dat1512}1512{/dat}) Géographe, cartographe, cosmographe et mathématicien [http://data.bnf.fr/ark:/12148/cb12789989j#foaf:Person]
{/ud}
{ud0}
Giovanni Battista Amico ({dat1512}1512{/dat}) Philosophe, mathématicien et astrologue. - Originaire de Cosenza, fut assassiné à Padoue [http://data.bnf.fr/ark:/12148/cb12570280s#foaf:Person]
{/ud}
{ud0}
Juan Pérez de Moya ({dat1513}1513{/dat}) Mathématicien et humaniste [http://data.bnf.fr/ark:/12148/cb12146300q#foaf:Person]
{/ud}
{ud0}
Rheticus ({dat1514}1514{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb13615799v#foaf:Person]
{/ud}
{ud0}
Bernardino Baldini ({dat1515}1515{/dat}) Professeur de médecine à Pavie puis de mathématiques à Milan [http://data.bnf.fr/ark:/12148/cb13163998r#foaf:Person]
{/ud}
{ud0}
Petrus Ramus ({en0li}Cuts (Aisne){/en}, {dat1515}1515{/dat}) Philosophe, grammairien, mathématicien et humaniste. - Professeur de mathématique au Collège royal (Collège de France). - Se convertit au protestantisme et fut tué au cours du Massacre de la Saint-Barthélemy [http://data.bnf.fr/ark:/12148/cb120645094#foaf:Person]
{/ud}
{ud0}
Jean-Pierre de Mesmes ({dat1516}1516{/dat}) Savant et poète. - Fils de Pierre de Mesmes, chambellan du roi de Navarre. - Etait lié avec Ronsard, du Bellay, Baïf, Charondas, Herberay, Jean Maugin, Ol. de Magny. - A était un des premiers auteurs à avoir écrit en français sur l''astronomie [http://data.bnf.fr/ark:/12148/cb125177720#foaf:Person]
{/ud}
{ud0}
Jacques Peletier ({dat1517}1517{/dat}) Poète et critique humaniste. - Mathématicien. - A participé à la réforme de l''orthographe. - Traducteur d''Horace [http://data.bnf.fr/ark:/12148/cb122992680#foaf:Person]
{/ud}
{ud0}
Jeronimo Munoz ({dat1520}1520{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb14646245j#foaf:Person]
{/ud}
{ud0}
Livio Sanuto ({dat1520}1520{/dat}) Géographe et mathématicien à Venise, fabriquant d''un globe avec son frère Giulio en 1561 [http://data.bnf.fr/ark:/12148/cb153816227#foaf:Person]
{/ud}
{ud0}
Melchior Ayrer ({dat1520}1520{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb162974318#foaf:Person]
{/ud}
{ud0}
Nicolaus Gugler ({en0li}Nuremberg (Allemagne){/en}, {dat1521}1521{/dat}) Médecin et astronome, a reçu une formation de juriste. - Fils de Hans Gugler (1480-1560) [http://data.bnf.fr/ark:/12148/cb16504896w#foaf:Person]
{/ud}
{ud0}
Valentin Mennher ({dat1521}1521{/dat}) Mathématicien. - Membre de la guilde des instituteurs d''Anvers [http://data.bnf.fr/ark:/12148/cb12563197r#foaf:Person]
{/ud}
{ud0}
Hermann Witekind ({en0li}Neuenrade (Allemagne){/en}, {dat1522}1522{/dat}) Mathématicien et humaniste [http://data.bnf.fr/ark:/12148/cb162248258#foaf:Person]
{/ud}
{ud0}
Giovanni Maria Bonardo ({en0li}Fratta Polesine, Italie{/en}, {dat1523}1523{/dat}) Poète. - Agronome. - Astronome [http://data.bnf.fr/ark:/12148/cb12181418p#foaf:Person]
{/ud}
{ud0}
Juan de Yciar (Durango (prov. de Vizcaya), {dat1523}1523{/dat}) Pédagogue, mathématicien et calligraphe [http://data.bnf.fr/ark:/12148/cb128696315#foaf:Person]
{/ud}
{ud0}
Jacques Charpentier (Clermont-en-Beauvaisis ({en0li}Oise){/en}, {dat1524}1524{/dat}) Philosophe et médecin. - Lecteur de mathématiques au Collège de France. - Médecin du roi [http://data.bnf.fr/ark:/12148/cb121323921#foaf:Person]
{/ud}
{ud0}
Tadeáš Hájek ({en0li}Prague{/en}, {dat1525}1525{/dat}) Mathématicien et médecin. - Reçu docteur à Bologne, occupa une chaire au Carolinum de Prague, fut premier médecin des empereurs Maximilien II et Rodolphe II [http://data.bnf.fr/ark:/12148/cb13009688n#foaf:Person]
{/ud}
{ud0}
Tilemann Stella ({en0li}Siegen (Allemagne){/en}, {dat1525}1525{/dat}) Mathématicien, astronome, géographe, architecte et bibliothécaire. - Cartographe à Wittenberg, ses cartes ont été éditées par Ortelius, Jode et Hondius [http://data.bnf.fr/ark:/12148/cb15376436c#foaf:Person]
{/ud}
{ud0}
Taqī al-Dīn Muḥammad Ibn Maʿrūf ({en0li}Damas{/en}, {dat1526}1526{/dat}) Astronome et mathématicien ottoman [http://data.bnf.fr/ark:/12148/cb14599962n#foaf:Person]
{/ud}
{ud0}
John Dee ({dat1527}1527{/dat}) Astrologue, mathématicien et antiquaire [http://data.bnf.fr/ark:/12148/cb119854464#foaf:Person]
{/ud}
{ud0}
Adam Lonicer ({en0li}Marburg (Allemagne){/en}, {dat1528}1528{/dat}) Medecin et botaniste. - Professeur de médecine, chimie et mathématiques. - Fils du théologien : Lonicer, Johann (1499-15969) [http://data.bnf.fr/ark:/12148/cb10279221n#foaf:Person]
{/ud}
{ud0}
Cornelius Blockland ({dat1530}1530{/dat}) Musicien, astrologue, mathématicien et médecin. - Actif de 1571 à 1586. - Frère du peintre Anthonie Blockland van Montfort [http://data.bnf.fr/ark:/12148/cb13497580p#foaf:Person]
{/ud}
{ud0}
Giovanni Battista Benedetti ({en0li}Venise, Italie{/en}, {dat1530}1530{/dat}) Mathématicien et ingénieur. - Fondateur de la géométrie analytique [http://data.bnf.fr/ark:/12148/cb11998820g#foaf:Person]
{/ud}
{ud0}
Jean Péna ({dat1530}1530{/dat}) Mathématicien, traducteur et éditeur de textes mathématiques et géométriques antiques [http://data.bnf.fr/ark:/12148/cb13483147k#foaf:Person]
{/ud}
{ud0}
Conradus Dasypodius ({en0li}Frauenfeld, Suisse{/en}, {dat1531}1531{/dat}) Mathématicien. - A tracé le plan de l''horloge astronomique de la cathédrale de Strasbourg [http://data.bnf.fr/ark:/12148/cb16534831x#foaf:Person]
{/ud}
{ud0}
Ercole Bottrigari ({dat1531}1531{/dat}) Humaniste, mathématicien, musicien, poète, linguiste et philosophe [http://data.bnf.fr/ark:/12148/cb125347809#foaf:Person]
{/ud}
{ud0}
Giuseppe Moletti ({dat1531}1531{/dat}) Cosmographe et géographe. - Professeur de médecine, de mathématique et d''astronomie à l''Université de Padoue [http://data.bnf.fr/ark:/12148/cb134849518#foaf:Person]
{/ud}
{ud0}
Philip Apian ({en0li}Ingoldstadt, Allemagne{/en}, {dat1531}1531{/dat}) Cartographe, mathématicien et physicien. - Fils de Peter Apian, succède à son père à l''Université d''Ingolstadt [http://data.bnf.fr/ark:/12148/cb152383864#foaf:Person]
{/ud}
{ud0}
Fabrizio Mordente ({en0li}Salerne, Italie{/en}, {dat1532}1532{/dat}) Mathématicien. - A inventé le compas de proportion à huit points [http://data.bnf.fr/ark:/12148/cb14643668k#foaf:Person]
{/ud}
{ud0}
Egnatio Danti ({en0li}Pérouse, Italie{/en}, {dat1536}1536{/dat}) Mathématicien, astronome, cartographe et cosmographe. - Dominicain [http://data.bnf.fr/ark:/12148/cb145332908#foaf:Person]
{/ud}
{ud0}
Henri de Monantheuil ({dat1536}1536{/dat}) Mathématicien et médecin. - Régent de la Faculté de médecine de Paris, puis professeur de mathématiques au Collège de France (1574-). - Né à Reims, meurt à Paris [http://data.bnf.fr/ark:/12148/cb13006651k#foaf:Person]
{/ud}
{ud0}
Christophorus Clavius ({dat1537}1537{/dat}) Jésuite, musicien et professeur de mathématiques. - Fut chargé par Grégoire XIII de la réforme du calendrier [http://data.bnf.fr/ark:/12148/cb125466080#foaf:Person]
{/ud}
{ud0}
Francesco Barozzi ({en0li}Heraklion, Grèce{/en}, {dat1537}1537{/dat}) Mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb10462395x#foaf:Person]
{/ud}
{ud0}
Giovanni Paolo Gallucci ({en0li}Salò, Italie{/en}, {dat1538}1538{/dat}) Astronome. - Homme de lettres [http://data.bnf.fr/ark:/12148/cb106019703#foaf:Person]
{/ud}
{ud0}
Philips Mor ({dat1539}1539{/dat}) Humaniste, mathématicien et poète néolatin. - Chanoine du chapitre de St Salvator d''Utrecht. - Fils du peintre Anthonis Mor van Dashorst (Antonio Moro) [http://data.bnf.fr/ark:/12148/cb12384177f#foaf:Person]
{/ud}
{ud0}
François Viète (Fontenay-le-Comte ({en0li}Vendée){/en}, {dat1540}1540{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb120511976#foaf:Person]
{/ud}
{ud0}
Cormopede ({dat1541}1541{/dat}) Mathématicien et astrologue. - Gentilhomme de la maison du Comte de Sterckenberg. - Date de naissance présumée d''après le "portrait de Cormopede à l''âge de 51 ans" figurant au F. A. 2 de l''"Almanach des almanachs pour l''an MDXCIII" [http://data.bnf.fr/ark:/12148/cb13491791f#foaf:Person]
{/ud}
{ud0}
Giovanni di Strasoldo ({dat1544}1544{/dat}) Noble. - Homme d''arme. - Mathématicien. - Poète [http://data.bnf.fr/ark:/12148/cb15122132t#foaf:Person]
{/ud}
{ud0}
Guidobaldo Dal Monte ({dat1545}1545{/dat}) Mathématicien et astronome. - Protégea Galilée et lui fit obtenir sa première chaire à Pise. - Né à Pesaro, meurt dans son chateau de Monte Baroccio [http://data.bnf.fr/ark:/12148/cb135173214#foaf:Person]
{/ud}
{ud0}
Renward Cysat ({en0li}Lucerne (Suisse){/en}, {dat1545}1545{/dat}) Chancelier de la ville de Lucerne, Suisse. - Historien, dramaturge, pharmacien et naturaliste. - Père de : Cysat, Johann Baptist (1587-1653), mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb12748433g#foaf:Person]
{/ud}
{ud0}
Maurice Bressieu ({dat1546}1546{/dat}) Mathématicien, philosophe et humaniste. - Titulaire de la chaire de mathématiques au Collège de France (1575-), orateur des rois de France à Rome (1586-), intendant de la Bibliothèque vaticane [http://data.bnf.fr/ark:/12148/cb13495175h#foaf:Person]
{/ud}
{ud0}
Tycho Brahe ({en0li}Knudstrup (Suède){/en}, {dat1546}1546{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb11893749j#foaf:Person]
{/ud}
{ud0}
Muḥammad ibn al-Ḥusayan Bahāʼ al-Dīn ʿĀmilī ({dat1547}1547{/dat}) Érudit arabe, philosophe, théologien, astronome, grammairien, auteur d''anthologies [http://data.bnf.fr/ark:/12148/cb12451570z#foaf:Person]
{/ud}
{ud0}
Nicodemus Frischlin ({en0li}Balingen, Allemagne{/en}, {dat1547}1547{/dat}) Philologue et écrivain. - A enseigné les belles-lettres et les mathématiques à l''Université de Tubingue. - Traducteur d''Aristophane, de Callimaque et de Tryphiodore. - Auteur d''une comédie, présentée devant l''empereur Rodolphe, qui lui décerna le titre de comte-palatin [http://data.bnf.fr/ark:/12148/cb12463064b#foaf:Person]
{/ud}
{ud0}
Michele Zappulo ({dat1548}1548{/dat}) Docteur en droit canon et civil. - Astronome, historien et poète [http://data.bnf.fr/ark:/12148/cb125454264#foaf:Person]
{/ud}
{ud0}
Simon Stevin ({en0li}Bruges, Belgique{/en}, {dat1548}1548{/dat}) Professeur de mathématiques de Maurice de Nassau [http://data.bnf.fr/ark:/12148/cb119941019#foaf:Person]
{/ud}
{ud0}
Michel Coignet ({dat1549}1549{/dat}) Ingénieur, mathématicien, fabricant d''instruments de navigation, poète [http://data.bnf.fr/ark:/12148/cb124231863#foaf:Person]
{/ud}
{ud0}
Francisco Sánchez ({dat1550}1550{/dat}) Médecin, philosophe, mathématicien et poète. - Également connu sous le pseudonyme d''El Escéptico [http://data.bnf.fr/ark:/12148/cb120172346#foaf:Person]
{/ud}
{ud0}
Giovanni Battista Crispo ({en0li}Gallipoli, Italie{/en}, {dat1550}1550{/dat}) Prêtre. - Mathématicien, théologien et homme de lettres [http://data.bnf.fr/ark:/12148/cb10615268s#foaf:Person]
{/ud}
{ud0}
John Napier ({dat1550}1550{/dat}) Mathématicien et théologien. - Baron de Merchiston [http://data.bnf.fr/ark:/12148/cb12353925j#foaf:Person]
{/ud}
{ud0}
Michael Moestlin ({dat1550}1550{/dat}) Né à Göppingen (Wurtemberg). - Mathématicien. - Astronome. - Luthérien, hostile à la réforme grégorienne du calendrier [http://data.bnf.fr/ark:/12148/cb12330628m#foaf:Person]
{/ud}
{ud0}
Sigfridus Aronus Forsius ({dat1550}1550{/dat}) Astronome et astrologue finlandais [http://data.bnf.fr/ark:/12148/cb131923734#foaf:Person]
{/ud}
{ud0}
Aegidius Martini ({dat1551}1551{/dat}) Cartographe, mathématicien [http://data.bnf.fr/ark:/12148/cb15376579x#foaf:Person]
{/ud}
{ud0}
al-Silahî Nasuh ({dat1551}1551{/dat}) Savant, miniaturiste et calligraphe ottoman. - A écrit plusieurs ouvrages sur les armes et les combats, sur la géométrie et les mathématiques ainsi que sur l''histoire. - Inventeur du jeu de "matraque", il est mieux connu sous son surnom "Matrakçı" : "Matrakçı Nasuh Efendi", "Nasuh al-Silahî", "Matraki", "Nasuh el-Mitraki", "Nasuh üs-Silahi", "Matraqçi Nasuh", "Nasuh b. Abdullah" et "Nasuh b. Karagöz el-Bosnevi" sont parmi les autres formes de référence [http://data.bnf.fr/ark:/12148/cb119562090#foaf:Person]
{/ud}
{ud0}
Anthoine Cathalan ({dat1551}1551{/dat}) Professeur de mathématiques [http://data.bnf.fr/ark:/12148/cb14526861v#foaf:Person]
{/ud}
{ud0}
Bartolomeo Crescenzio ({dat1551}1551{/dat}) Mathématicien, ingénieur naval et voyageur. - Fut capitaine de galère de la marine pontificale [http://data.bnf.fr/ark:/12148/cb125466487#foaf:Person]
{/ud}
{ud0}
Bernardo Gamucci ({en0li}San Gimignano, Italie{/en}, {dat1551}1551{/dat}) Archéologue, architecte et mathématicien [http://data.bnf.fr/ark:/12148/cb10435220v#foaf:Person]
{/ud}
{ud0}
Camillo Agrippa ({dat1551}1551{/dat}) Philosophe, mathématicien, architecte et ingénieur. - Est aussi l''auteur de l''un des premiers traité d''escrime [http://data.bnf.fr/ark:/12148/cb12536260s#foaf:Person]
{/ud}
{ud0}
Claude de Boissière ({dat1551}1551{/dat}) Mathématicien. - Auteur d''un "Art poétique" [http://data.bnf.fr/ark:/12148/cb12509709h#foaf:Person]
{/ud}
{ud0}
Didier Henrion ({dat1551}1551{/dat}) Professeur de mathématiques à Paris. - Ingénieur au service des Provinces-Unies. - N''est pas un pseudonyme de Clément Cyriaque de Mangin [http://data.bnf.fr/ark:/12148/cb144882445#foaf:Person]
{/ud}
{ud0}
Eilhard Lubbin ({dat1551}1551{/dat}) Cartographe et mathématicien à Rostock [http://data.bnf.fr/ark:/12148/cb153777849#foaf:Person]
{/ud}
{ud0}
Faustus Verantius (Sebenico aujord''hui Šibenik ({en0li}Croatie){/en}, {dat1551}1551{/dat}) Lexicographe, physicien et mathématicien. - Évêque de Czanad (Hongrie) ({dat1594}1594{/dat}) et de la République de Venise. - Neveu d''Antun Vrančić (1504-1573) [http://data.bnf.fr/ark:/12148/cb10703670x#foaf:Person]
{/ud}
{ud0}
Francesco Feliciano ({dat1551}1551{/dat}) Mathématicien, augustinien et miniaturiste [http://data.bnf.fr/ark:/12148/cb13485419n#foaf:Person]
{/ud}
{ud0}
Francis Van Schoten ({dat1551}1551{/dat}) Professeur de mathématiques à Leyde, cartographe [http://data.bnf.fr/ark:/12148/cb15337130w#foaf:Person]
{/ud}
{ud0}
Francisco Zarzoso ({en0li}Cella, Espagne{/en}, {dat1551}1551{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb119512329#foaf:Person]
{/ud}
{ud0}
Giacomo Lanteri ({en0li}Paratico, Italie{/en}, {dat1551}1551{/dat}) Mathématicien et ingénieur [http://data.bnf.fr/ark:/12148/cb104024969#foaf:Person]
{/ud}
{ud0}
Girolamo Mercurio ({dat1551}1551{/dat}) Dominicain. - Médecin, professeur de logique et de mathématique [http://data.bnf.fr/ark:/12148/cb13484092c#foaf:Person]
{/ud}
{ud0}
Giuseppe Unicorno ({dat1551}1551{/dat}) Mathématicien. - Philosophe. - Astrologue. - Musicologue. - Théologien. - Originaire de Bergame [http://data.bnf.fr/ark:/12148/cb125394931#foaf:Person]
{/ud}
{ud0}
Helisaeus Röslin ({dat1551}1551{/dat}) Mathématicien. - Astronome. - Médecin (pratiquait à Strasbourg et Francfort) [http://data.bnf.fr/ark:/12148/cb132003253#foaf:Person]
{/ud}
{ud0}
Jacques Besson ({en0li}Colombières (Italie){/en}, {dat1551}1551{/dat}) Ingénieur et mathématicien. - Né à Colombières, vallée d''Oulx (aujourd''hui en Italie), d''après Eugénie Droz [http://data.bnf.fr/ark:/12148/cb12376654f#foaf:Person]
{/ud}
{ud0}
Jacques Maretz ({dat1551}1551{/dat}) Dessinateur et graveur, mathématicien [http://data.bnf.fr/ark:/12148/cb153705873#foaf:Person]
{/ud}
{ud0}
Jamet Mettayer ({dat1551}1551{/dat}) Autre(s) graphie(s) : Metayer ; Messor ; Metayerus ; Mettayier. - Variante(s) de prénom : Jean ; Jean Jamet. - Imprimeur-libraire ; imprimeur du Roi pour les mathématiques ({dat1580}1580{/dat}) et imprimeur ordinaire du Roi (1583-1605). - En 1588, le roi Henri III le fait imprimeur officiel de sa congrégation des pénitents de l''Annonciation. De 1588 à 1594, il suit le Roi et la Cour à Blois puis  à Tours. - De retour à Paris, doit partager sa charge avec Pierre L''Huillier et Fédéric II Morel en vertu de l''arrêt du Conseil du 20 avril 1594. Revend à Tours son atelier et sa boutique à l''imprimeur Maurice Bouguereau. En mars  1596, le Roi l''associe à la Compagnie des usages avec Pierre L''Huillier. Décédé avant le 12 fév. 1605. Des publications paraissent encore sous son nom jusqu''en 1614. - A travaillé en association avec Mathurin Challenge ({dat1573}1573{/dat}) et Barthélemy Gomet à Blois. S''associe à Tours (oct. 1591 - oct. 1593) avec Jean Richer, Claude de Monstr''oeil, Sébastien Molin, Mathieu I Guillemot, Georges Drobet et Marc Orry, son gendre. Travaille en association étroite avec Pierre L''Huillier et avec son fils Pierre Mettayer qui se trouvaient eux aussi à Tours [http://data.bnf.fr/ark:/12148/cb125031934#foaf:Person]
{/ud}
{ud0}
Jean Brohon ({dat1551}1551{/dat}) Médecin, botaniste et astronome. - Fut recteur de l''Université de Caen [http://data.bnf.fr/ark:/12148/cb12545367f#foaf:Person]
{/ud}
{ud0}
Jean de Seville ({dat1551}1551{/dat}) Mathématicien et hydrographe [http://data.bnf.fr/ark:/12148/cb13496046w#foaf:Person]
{/ud}
{ud0}
Jean Maria Coloni ({dat1551}1551{/dat}) Citoyen de Romans en Dauphiné. - Mathématicien et astrologue [http://data.bnf.fr/ark:/12148/cb13479237s#foaf:Person]
{/ud}
{ud0}
Jean Tagaut ({dat1551}1551{/dat}) Poète. - Médecin, mathématicien, professeur à Lausanne et Genève [http://data.bnf.fr/ark:/12148/cb12249180j#foaf:Person]
{/ud}
{ud0}
Joannes Portantius ({dat1551}1551{/dat}) Astronome, mathématicien et géographe à Anvers, édité par Ortelius et De Jode [http://data.bnf.fr/ark:/12148/cb153817246#foaf:Person]
{/ud}
{ud0}
Johann Georg Locher ({dat1551}1551{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb13006978f#foaf:Person]
{/ud}
{ud0}
Juan de Rojas Sarmiento ({en0li}Palencia, Espagne{/en}, {dat1551}1551{/dat}) Mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb140653109#foaf:Person]
{/ud}
{ud0}
Marc Duncan ({dat1551}1551{/dat}) Médecin, originaire d''Écosse, s''établit à Saumur en 1606 à l''appel de l''Académie protestante de la ville. - Professeur de mathématiques, de grec et d''humanités [http://data.bnf.fr/ark:/12148/cb13006401g#foaf:Person]
{/ud}
{ud0}
Martin Basanier ({dat1551}1551{/dat}) Mathématicien, musicien [http://data.bnf.fr/ark:/12148/cb12510914p#foaf:Person]
{/ud}
{ud0}
Martinus Hortensius ({dat1551}1551{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb13007384z#foaf:Person]
{/ud}
{ud0}
Nicolaus Reimarus Ursus ({dat1551}1551{/dat}) Mathématicien. - Astronome [http://data.bnf.fr/ark:/12148/cb145753184#foaf:Person]
{/ud}
{ud0}
Paschasius Hamellius ({dat1551}1551{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb13173242d#foaf:Person]
{/ud}
{ud0}
Paul Yvon ({dat1551}1551{/dat}) Mathématicien. - Achète la seigneurie de Laleu en 1592 et y fait construire le château. - Maire de La Rochelle en 1616. - S'' installe à Paris en décembre 1633 et abjure le protestantisme [http://data.bnf.fr/ark:/12148/cb12135021d#foaf:Person]
{/ud}
{ud0}
Peter Laicksteen ({dat1551}1551{/dat}) Cartographe et astronome [http://data.bnf.fr/ark:/12148/cb15370391s#foaf:Person]
{/ud}
{ud0}
Phillebert Charpentier ({dat1551}1551{/dat}) Éditeur. - Marchand d''estampes et d''instruments de mathématiques [http://data.bnf.fr/ark:/12148/cb16553551w#foaf:Person]
{/ud}
{ud0}
Pierre Forcadel ({dat1551}1551{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb103947442#foaf:Person]
{/ud}
{ud0}
Pierre Hérigone ({dat1551}1551{/dat}) Professeur de mathématiques à Paris. - N''est pas un pseudonyme de Clément Cyriaque de Mangin [http://data.bnf.fr/ark:/12148/cb144882503#foaf:Person]
{/ud}
{ud0}
Pierre Le Voirier ({dat1551}1551{/dat}) Autre(s) graphie(s) : Le Voirrier ; Le Verrier. - Imprimeur du Roi pour les mathématiques. - Beau-père de Mathieu I Guillemot ({dat1584}1584{/dat}). Encore en activité le 31 déc. 1589. Décédé entre 1591 et le 7 nov. 1594 (compte de succession) [http://data.bnf.fr/ark:/12148/cb12230743m#foaf:Person]
{/ud}
{ud0}
Teodato Osio ({dat1551}1551{/dat}) Mathématicien. - Musicien [http://data.bnf.fr/ark:/12148/cb125559272#foaf:Person]
{/ud}
{ud0}
Walther Hermann Ryff ({dat1551}1551{/dat}) Apothicaire, médecin, mathématicien et architecte [http://data.bnf.fr/ark:/12148/cb11948264d#foaf:Person]
{/ud}
{ud0}
William Welwod ({dat1551}1551{/dat}) Mathématicien. - Professeur de droit [http://data.bnf.fr/ark:/12148/cb125630488#foaf:Person]
{/ud}
{ud0}
Jost Bürgi ({dat1552}1552{/dat}) Horloger, astronome et mathématicien suisse [http://data.bnf.fr/ark:/12148/cb123814270#foaf:Person]
{/ud}
{ud0}
Bernardino Baldi ({en0li}Urbino, Italie{/en}, {dat1553}1553{/dat}) Abbé de Guastalla. - Poète, prosateur, mathématicien et historien. - Polyglotte, connaissait le grec et le latin, l''hébreu, l''arabe, le persan et le hongrois [http://data.bnf.fr/ark:/12148/cb12179488k#foaf:Person]
{/ud}
{ud0}
Jacob Christmann ({dat1554}1554{/dat}) Orientaliste, mathématicien et astronome. - A été le premier à utiliser le télescope avec d''autres instruments comme le sextant [http://data.bnf.fr/ark:/12148/cb12560133s#foaf:Person]
{/ud}
{ud0}
Giovanni Antonio Magini ({en0li}Padoue, Italie{/en}, {dat1555}1555{/dat}) Astronome, mathématicien et géographe. - A occupé la chaire d''astronomie à l''Université de Bologne en 1588. - Auteur prétendu de prédictions et de nombreux almanachs publiés en France, en Allemagne et aux Pays-Bas jusqu''au 19e siècle [http://data.bnf.fr/ark:/12148/cb12162475b#foaf:Person]
{/ud}
{ud0}
Jean Du Temps ({dat1555}1555{/dat}) Fils de l''avocat Jean Du Temps I, il fut lui-même avocat et avait des connaissances en astrologie et mathématique. Frère d''Adam Du Temps, spécialiste des fortifications qui participa peut-être à la carte du Blésois dont il est l''auteur [http://data.bnf.fr/ark:/12148/cb15302460t#foaf:Person]
{/ud}
{ud0}
Sethus Calvisius ({dat1556}1556{/dat}) Organiste, compositeur et théoricien de la musique ; astronome ; historien ; libraire et éditeur de musique. - Natif de Gorsleben près de Sachsenburg (Thuringe) et issu d''une famille paysanne. Après des études aux universités de Leipzig et Helmstedt, il devient à partir de 1581 et jusqu''à sa mort "cantor" de plusieurs églises de Leipzig successivement. Auteur de plusieurs ouvrages théoriques et compositions musicales, ainsi que d''un "Opus chronologicum" (1605 ; au moins 6 rééd.) et d''un "Elenchus calendarii Gregoriani" ({dat1612}1612{/dat}). Décédé à Leipzig en nov. 1615. À distinguer du pasteur et prédicateur de Quedlinburg Sethus Calvisius (ou : Seth Kal(l)witz) (1639-1698), parfois appelé à tort "Sethus Calvisius le fils" [http://data.bnf.fr/ark:/12148/cb12875550d#foaf:Person]
{/ud}
{ud0}
Guillaume de Nautonier ({dat1557}1557{/dat}) Savant, mathématicien, astronome, d''origine protestante, géographe du roi Henri IV [http://data.bnf.fr/ark:/12148/cb12412403z#foaf:Person]
{/ud}
{ud0}
Christoph Meurer ({dat1558}1558{/dat}) Professeur de mathématiques à Leipzig ({dat1613}1613{/dat}). - Médecin [http://data.bnf.fr/ark:/12148/cb14333201g#foaf:Person]
{/ud}
{ud0}
Jean-Édouard Du Monin ({dat1559}1559{/dat}) Mathématicien et spécialiste des langues anciennes. - Fut professeur à Paris, puis à Poitiers [http://data.bnf.fr/ark:/12148/cb12463074n#foaf:Person]
{/ud}
{ud0}
Thomas Hariot ({en0li}Oxford, GB{/en}, {dat1560}1560{/dat}) Mathématicien et astronome. - Envoyé comme conseiller aux Amériques en 1585-86 [http://data.bnf.fr/ark:/12148/cb12215671c#foaf:Person]
{/ud}
{ud0}
Thomas Harriot ({dat1560}1560{/dat}) Mathématicien, physicien et astronome anglais [http://data.bnf.fr/ark:/12148/cb124346111#foaf:Person]
{/ud}
{ud0}
Adrianus Romanus ({en0li}Louvain{/en}, {dat1561}1561{/dat}) Médecin, mathématicien et voyageur. - Enseigna à Louvain et à Würzburg, fut mathématicien royal en Pologne [http://data.bnf.fr/ark:/12148/cb12459969s#foaf:Person]
{/ud}
{ud0}
Bartholomäus Pitiscus ({dat1561}1561{/dat}) A aussi écrit en latin. - Prédicateur protestant à la cour de l''Électeur palatin. - Également auteur d''ouvrages mathématiques [http://data.bnf.fr/ark:/12148/cb121457326#foaf:Person]
{/ud}
{ud0}
Henry Briggs ({dat1561}1561{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb12305061c#foaf:Person]
{/ud}
{ud0}
Jean Tarde (La Roque-Gageac ({en0li}Dordogne){/en}, {dat1561}1561{/dat}) Mathématicien, historien, géographe et astronome. - Chanoine [http://data.bnf.fr/ark:/12148/cb12641353z#foaf:Person]
{/ud}
{ud0}
Jean Tarde ({dat1561}1561{/dat}) Chanoine de Sarlat, mathématicien et cartographe [http://data.bnf.fr/ark:/12148/cb153143878#foaf:Person]
{/ud}
{ud0}
P. Christoph Grienberger ({dat1561}1561{/dat}) Jésuite, mathématicien, astronome et architecte. Il a realisé les plans du Collège d''Aurillac et du Charleville [http://data.bnf.fr/ark:/12148/cb10686921r#foaf:Person]
{/ud}
{ud0}
Philippus Lansbergen ({en0li}Gand (Belgique){/en}, {dat1561}1561{/dat}) Mathématicien, astronome et pasteur [http://data.bnf.fr/ark:/12148/cb130073828#foaf:Person]
{/ud}
{ud0}
Christen Sørensen Longomontanus ({dat1562}1562{/dat}) Astronome et mathématicien. - Fut l''élève de Tycho-Brahé. - Professeur de hautes mathématiques à l''Université de Copenhague [http://data.bnf.fr/ark:/12148/cb13011001c#foaf:Person]
{/ud}
{ud0}
Guangqi Xu ({en0li}Shanghai{/en}, {dat1562}1562{/dat}) Haut fonctionnaire chinois, initié et converti au christianisme par le père jésuite Matteo Ricci. - Mathématicien. - Astronome. - Disciple de Matteo Ricci [http://data.bnf.fr/ark:/12148/cb150892932#foaf:Person]
{/ud}
{ud0}
Galileo Galilei ({en0li}Pise, Italie{/en}, {dat1564}1564{/dat}) Physicien, philosophe, astronome [http://data.bnf.fr/ark:/12148/cb11903931b#foaf:Person]
{/ud}
{ud0}
Luis Teixeira ({dat1564}1564{/dat}) Jésuite portugais, mathématicien et cartographe actif de 1564 à 1613 [http://data.bnf.fr/ark:/12148/cb153361957#foaf:Person]
{/ud}
{ud0}
Edward Brerewood ({dat1565}1565{/dat}) Antiquaire et mathématicien, linguiste et humaniste. - Professeur d''astronomie au Gresham college de Londres [http://data.bnf.fr/ark:/12148/cb125109678#foaf:Person]
{/ud}
{ud0}
Eilhard Lubin ({dat1565}1565{/dat}) Humaniste, philologue, cartographe, théologien et mathématicien [http://data.bnf.fr/ark:/12148/cb15040859j#foaf:Person]
{/ud}
{ud0}
Paolo Antonio Foscarini ({en0li}Montalto Uffugo, Italie{/en}, {dat1565}1565{/dat}) Carme. - Théologien. - Mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb12377530d#foaf:Person]
{/ud}
{ud0}
Scipione Chiaramonti ({en0li}Cesena, Italie{/en}, {dat1565}1565{/dat}) Astronome et philosophe. - Professeur de philosophie à l''Université de Pise [http://data.bnf.fr/ark:/12148/cb10545041n#foaf:Person]
{/ud}
{ud0}
Fr. François d'' Aguillon ({dat1566}1566{/dat}) Jésuite, architecte et mathématicien. Auteur d''un projet pour le noviciat de Tournai. Préposé de la Maison professe, professeur d''Anvers [http://data.bnf.fr/ark:/12148/cb16240952w#foaf:Person]
{/ud}
{ud0}
Georg Ludwig Frobenius ({dat1566}1566{/dat}) Libraire. - Natif d''Iphofen, près de Wurzbourg. Titulaire d''une maîtrise de théologie. Après des études aux universités de Tübingen et Wittenberg, travaille avec l''astronome Tycho Brahe jusqu''à la mort de celui-ci. Reçu ensuite bourgeois de Hambourg, où il s''établit libraire [http://data.bnf.fr/ark:/12148/cb12229506t#foaf:Person]
{/ud}
{ud0}
Marco Antonio De Dominis (l''île de Rab ({en0li}Croatie){/en}, {dat1566}1566{/dat}) Professeur de rhétorique, mathématiques et philosophie dans la Compagnie de Jésus, à Padoue et Brescia. - Evêque de Segna (Senj ou Zengg en Croatie) de 1600 à 1602; de Spalato (Split) de 1602 à 1615. - Gagné au protestantisme et exilé en Angleterre, doyen de Windsor. - Abjure et rentre en grâce ({dat1622}1622{/dat}) [http://data.bnf.fr/ark:/12148/cb121335726#foaf:Person]
{/ud}
{ud0}
Marinus Ghetaldus (Raguse aujourd''hui Dubrovnik ({en0li}Croatie){/en}, {dat1566}1566{/dat}) Mathématicien et physicien. - Il exerça une grande influence sur le développement de l''application de l''algèbre à la géométrie. - Il mit au point le miroir parabolique, aujourd''hui conservé au National Maritime Museum de Londres. - Il collabora, entre autres, avec François Viète en France et avec Galilée en Italie [http://data.bnf.fr/ark:/12148/cb146476018#foaf:Person]
{/ud}
{ud0}
François de Aguilón ({dat1567}1567{/dat}) Architecte et mathématicien belge d''origine espagnole [http://data.bnf.fr/ark:/12148/cb119998212#foaf:Person]
{/ud}
{ud0}
Johann Hartmann ({dat1568}1568{/dat}) Mathématicien et naturaliste. - Professeur de chimie à l''Université de Marburg [http://data.bnf.fr/ark:/12148/cb13009199x#foaf:Person]
{/ud}
{ud0}
P. Jacques de Guernisac ({dat1568}1568{/dat}) Jésuite et architecte, professeur de mathématique à Pont-à-Mousson puis à La Flèche, recteur du collège des Jésuites de Quimper [http://data.bnf.fr/ark:/12148/cb16215104d#foaf:Person]
{/ud}
{ud0}
Mutio Oddi ({dat1569}1569{/dat}) Mathématicien. - Architecte [http://data.bnf.fr/ark:/12148/cb165299645#foaf:Person]
{/ud}
{ud0}
Andrea Argoli ({dat1570}1570{/dat}) Mathématicien. - Astronome. - Professeur de mathématique à l''Université de Padoue [http://data.bnf.fr/ark:/12148/cb121593328#foaf:Person]
{/ud}
{ud0}
Erasmus Schmied ({dat1570}1570{/dat}) Né à Delitzsch, près de Leipzig. - Professeur de grec et de mathématiques à Wittenberg [http://data.bnf.fr/ark:/12148/cb12045847b#foaf:Person]
{/ud}
{ud0}
Anders Bure ({dat1571}1571{/dat}) Cartographe et mathématicien [http://data.bnf.fr/ark:/12148/cb14509982d#foaf:Person]
{/ud}
{ud0}
Giovanni Branca ({dat1571}1571{/dat}) Architecte, ingénieur et mathématicien. - Né à Pesaro, meurt à Pérouse [http://data.bnf.fr/ark:/12148/cb121826472#foaf:Person]
{/ud}
{ud0}
Johannes Isaacus Pontanus ({en0li}Elseneur (Danemark){/en}, {dat1571}1571{/dat}) Historien. - Philologue. - Professeur de mathématiques et de physique [http://data.bnf.fr/ark:/12148/cb123875836#foaf:Person]
{/ud}
{ud0}
Johannes Kepler ({dat1571}1571{/dat}) Astronome et mathématicien [http://data.bnf.fr/ark:/12148/cb11909597m#foaf:Person]
{/ud}
{ud0}
Willem Jansz Blaeu ({dat1571}1571{/dat}) Autre(s) graphie(s) : Janssonius Blaeuw. - Imprimeur-libraire et éditeur de cartes et d''atlas. - Originaire d''Alkmaar ou des environs. Passe 2 ans auprès de Tycho Brahé au Danemark. À son retour à Amsterdam en 1596, s''établit cartographe et fabricant de globes terrestres et célestes. Monte ensuite une imprimerie et une fonderie. Également auteur d''ouvrages cartographiques et astronomiques [http://data.bnf.fr/ark:/12148/cb12169772t#foaf:Person]
{/ud}
{ud0}
Cornelius Drebbel ({dat1572}1572{/dat}) Graveur. - Mathématicien. - Physicien. - Chimiste [http://data.bnf.fr/ark:/12148/cb12382467g#foaf:Person]
{/ud}
{ud0}
Rodolphus Goclenius ({dat1572}1572{/dat}) Docteur en médecine en 1601. - Professeur de physique en 1608. - Professeur de mathématiques à l''Université de Marbourg en 1621 [http://data.bnf.fr/ark:/12148/cb121595722#foaf:Person]
{/ud}
{ud0}
Samuel Marolois ({dat1572}1572{/dat}) Mathématicien français ayant vécu une grande partie de sa vie aux Pays-Bas [http://data.bnf.fr/ark:/12148/cb14912871p#foaf:Person]
{/ud}
{ud0}
Thomas Lydyat ({en0li}Okerton, GB{/en}, {dat1572}1572{/dat}) Mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb12390032f#foaf:Person]
{/ud}
{ud0}
Christoph Scheiner ({dat1575}1575{/dat}) Jésuite. - Physicien, mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb13483688j#foaf:Person]
{/ud}
{ud0}
Michelangelo Galilei ({dat1575}1575{/dat}) Luthiste et compositeur italien de la Renaissance. - Fils du compositeur et théoricien Vincenzo Galilei, et frère de l''astronome Galileo Galilei [http://data.bnf.fr/ark:/12148/cb140013401#foaf:Person]
{/ud}
{ud0}
Octavio Pisani ({en0li}Naples, Italie{/en}, {dat1575}1575{/dat}) Cosmographe et astronome, travaille à Anvers de 1612 à 1637 [http://data.bnf.fr/ark:/12148/cb15404394h#foaf:Person]
{/ud}
{ud0}
Francesco Ingoli ({en0li}Ravenne (Italie){/en}, {dat1578}1578{/dat}) Secrétaire de la propagande, débat avec Copernic (en 1616 et 1624) et écrit Relazione delle quattro parti del mondo avec pour objectif de soutenir missions et propagande religieuses. - Étudie l''astronomie, la cosmographie et la géographie et connait le grec, le français, l''espagnon et l''arabe. - Diplômé en droit civil et en droit canon à l''Université de Padoue, Italie [http://data.bnf.fr/ark:/12148/cb13749501h#foaf:Person]
{/ud}
{ud0}
Sybrandt Hansz. Cardinael (Harlingen (Pays-Bas), {dat1578}1578{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb15944052f#foaf:Person]
{/ud}
{ud0}
Cristóvão Ferreira ({dat1580}1580{/dat}) Supérieur et procurateur de la mission jésuite au Japon, il abjura en 1633 et se convertit au zen. - Auteur en 1636 de la "Supercherie dévoilée". - Traducteur d''ouvrages d''astronomie et de chirurgie [http://data.bnf.fr/ark:/12148/cb13524212c#foaf:Person]
{/ud}
{ud0}
Godfried Wendelen ({dat1580}1580{/dat}) Astronome et géomètre. - Avocat au Parlement de Paris puis doyen du chapitre de Rothnac, Belgique [http://data.bnf.fr/ark:/12148/cb123969373#foaf:Person]
{/ud}
{ud0}
Joannes Michael Gigas ({dat1580}1580{/dat}) Docteur, mathématicien et géographe édité par Blaeu et Hondius [http://data.bnf.fr/ark:/12148/cb153239798#foaf:Person]
{/ud}
{ud0}
Johann Faulhaber ({dat1580}1580{/dat}) Mathématicien allemand. S''est aussi intéressé à l''ingénierie des fortifications [http://data.bnf.fr/ark:/12148/cb137778453#foaf:Person]
{/ud}
{ud0}
Nicolas-Claude Fabri Peiresc ({en0li}Belgentier (Var){/en}, {dat1580}1580{/dat}) Conseiller au Parlement de Provence. - Astronome, archéologue et naturaliste [http://data.bnf.fr/ark:/12148/cb11918940q#foaf:Person]
{/ud}
{ud0}
Willebrordus Snellius (Leyde, Pays-Bas, {dat1580}1580{/dat}) Mathématicien, astronome et géographe [http://data.bnf.fr/ark:/12148/cb15336105f#foaf:Person]
{/ud}
{ud0}
Claude-Gaspard Bachet (Bourg-en-Bresse ({en0li}Ain){/en}, {dat1581}1581{/dat}) Mathématicien et littérateur. - Sieur de Méziriac. - Érudit, auteur de poèmes en français, italien et latin. - Membre de l''Académie française (élu en 1634) [http://data.bnf.fr/ark:/12148/cb120028244#foaf:Person]
{/ud}
{ud0}
Alexandre Anderson ({dat1582}1582{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb16296598k#foaf:Person]
{/ud}
{ud0}
Jean François ({dat1582}1582{/dat}) Nom en religion de Jean Charnage. - Jésuite. - Professeur de philosophie et de mathématiques à La Flèche [http://data.bnf.fr/ark:/12148/cb121629197#foaf:Person]
{/ud}
{ud0}
Mario Bettini ({en0li}Bologne, Italie{/en}, {dat1582}1582{/dat}) Jésuite. - Philosophe et mathématicien [http://data.bnf.fr/ark:/12148/cb12545452p#foaf:Person]
{/ud}
{ud0}
Matthias Bernegger ({en0li}Hallstatt (Autriche){/en}, {dat1582}1582{/dat}) Philologue, historien, mathématicien et astronome. - Protestant. - Professeur d''histoire et d''éloquence à Strasbourg, recteur de l''Université de cette même ville [http://data.bnf.fr/ark:/12148/cb129928534#foaf:Person]
{/ud}
{ud0}
Jean-Baptiste Morin (Villefranche-sur-Saône ({en0li}Rhône){/en}, {dat1583}1583{/dat}) Astronome et mathématicien [http://data.bnf.fr/ark:/12148/cb11916881j#foaf:Person]
{/ud}
{ud0}
Orazio Grassi ({en0li}Savone, Italie{/en}, {dat1583}1583{/dat}) Jésuite. - Mathématicien, astronome et architecte [http://data.bnf.fr/ark:/12148/cb125377863#foaf:Person]
{/ud}
{ud0}
Filippo Finella ({en0li}Naples, Italie{/en}, {dat1584}1584{/dat}) Astrologue. - Astronome. - Auteur dramatique [http://data.bnf.fr/ark:/12148/cb122006609#foaf:Person]
{/ud}
{ud0}
Grégoire de Saint-Vincent ({dat1584}1584{/dat}) Mathématicien. - Astronome [http://data.bnf.fr/ark:/12148/cb16197665z#foaf:Person]
{/ud}
{ud0}
James Hume ({dat1584}1584{/dat}) Mathématicien. - Astronome. - Historien. - Hébraïsant. - Actif en 1639. - A vécu à Paris. - Fils de David Hume (1558-163.) et frère aîné de la poétesse et traductrice Anna Hume (1586?-16..) [http://data.bnf.fr/ark:/12148/cb12072629r#foaf:Person]
{/ud}
{ud0}
Claude Mydorge ({dat1585}1585{/dat}) Mathématicien et physicien [http://data.bnf.fr/ark:/12148/cb144888873#foaf:Person]
{/ud}
{ud0}
Mario Guiducci ({en0li}Florence, Italie{/en}, {dat1585}1585{/dat}) Homme de lettres et astronome. - A collaboré avec Galileo Galilei [http://data.bnf.fr/ark:/12148/cb144609004#foaf:Person]
{/ud}
{ud0}
Melchior Inchofer ({en0li}Vienne{/en}, {dat1585}1585{/dat}) Jésuite. - Philosophe, mathématicien et théologien professeur à Messine, Italie [http://data.bnf.fr/ark:/12148/cb10735485h#foaf:Person]
{/ud}
{ud0}
Philipp Müller ({dat1585}1585{/dat}) Mathématicien, médecin, chimiste et botaniste. - Professeur à l''université de Leipzig [http://data.bnf.fr/ark:/12148/cb14065362j#foaf:Person]
{/ud}
{ud0}
Jean L''Hoste ({en0li}Nancy{/en}, {dat1586}1586{/dat}) Ingénieur. - Intendant des fortifications du duc de Lorraine. - Professeur de droit et de mathématiques à Pont-à-Mousson [http://data.bnf.fr/ark:/12148/cb16628764j#foaf:Person]
{/ud}
{ud0}
Niccolò Zucchi ({en0li}Parme, Italie{/en}, {dat1586}1586{/dat}) Jésuite. - Recteur du Collegio romano (1646-1649). - Astronome [http://data.bnf.fr/ark:/12148/cb10077816w#foaf:Person]
{/ud}
{ud0}
Benedetto Castelli ({en0li}Brescia, Italie{/en}, {dat1587}1587{/dat}) Dominicain. - Mathématicien, inventeur et écrivain. - Disciple de Galilée, dont il défendit les théories astronomiques [http://data.bnf.fr/ark:/12148/cb12545385c#foaf:Person]
{/ud}
{ud0}
Joachim Jungius ({dat1587}1587{/dat}) Naturaliste, mathématicien et philosophe [http://data.bnf.fr/ark:/12148/cb120247195#foaf:Person]
{/ud}
{ud0}
Libert Froidmont ({en0li}Liège{/en}, {dat1587}1587{/dat}) Théologien. - Mathématicien, physicien et géologue [http://data.bnf.fr/ark:/12148/cb14462868z#foaf:Person]
{/ud}
{ud0}
François Derand ({dat1588}1588{/dat}) Jésuite. - Professeur de grammaire et de mathématiques. - Architecte. - Né à Vic s/Seille (Moselle), mort à Agde (Hérault) [http://data.bnf.fr/ark:/12148/cb13012148j#foaf:Person]
{/ud}
{ud0}
Jacques Grandami ({dat1588}1588{/dat}) Jésuite. - Professeur de belles lettres, de philosophie et de théologie, puis recteur de Bourges, Rennes, La Flèche, Tours et Rouen. - Visiteur de la province de France. - Astronome [http://data.bnf.fr/ark:/12148/cb12155155d#foaf:Person]
{/ud}
{ud0}
Marin Mersenne ({dat1588}1588{/dat}) Philosophe et savant, astronome, mathématicien. - Théoricien de la musique. - Minime [http://data.bnf.fr/ark:/12148/cb119157157#foaf:Person]
{/ud}
{ud0}
Eberhard Welper ({dat1590}1590{/dat}) Imprimeur-libraire. - Natif de Lohra (comté de Lohenstein, près de Marburg, Allemagne). Mathématicien, astrologue et astronome, il se fixe à Strasbourg en 1618. Établi libraire en 1620 puis imprimeur dès 1621. Publie notamment chaque année un almanach et des prédictions. Auteur de plusieurs ouvrages scientifiques, dont des "Elementa geometrica..." (1re éd., {dat1620}1620{/dat}), une "Gnomonica" ({dat1625}1625{/dat}), un "Compendium astronomiae..." ({dat1634}1634{/dat}) et un traité de la divination, "Rota-Fortunae, oder Glück-Rad..." (s. d., plusieurs rééd.). De 1634 à 1639, assure des fonctions d''enseignant au Gymnase (lycée) de Strasbourg. En 1654, sollicite en vain la charge d''imprimeur de l''évêché de Saverne. De 1653 à 1661, imprime sous le pseudonyme de Hartmann Bär quelques ouvrages pour l''académie des Jésuites à Molsheim. Son fils aîné Johann Welper (1642-1720) lui succède en 1664, mais des éditions paraissent encore sous son nom en 1689. Son autre fils Eberhard (II) Welper (1644-1670) sera lui aussi mathématicien, astrologue et astronome [http://data.bnf.fr/ark:/12148/cb158750586#foaf:Person]
{/ud}
{ud0}
Johannes Wilhelm Lauremberg ({dat1590}1590{/dat}) Auteur, mathématicien et historien à Rostock [http://data.bnf.fr/ark:/12148/cb15377794m#foaf:Person]
{/ud}
{ud0}
Jean Leurechon (Bar-le-Duc, {dat1591}1591{/dat}) Jésuite. - Professeur de philosophie et de mathématiques, à Pont-à-Mousson notamment. - Confesseur du duc de Lorraine Charles IV. - Henry Van Etten, qui signe la dédicace de la première édition des "Récréations mathématiques" n''est pas un pseudonyme de Jean Leurechon, mais le nom d''un de ses élèves, qui aurait réellement existé d''après Trevor H. Hall [http://data.bnf.fr/ark:/12148/cb13009618g#foaf:Person]
{/ud}
{ud0}
Joseph Salomon Delmedigo ({dat1591}1591{/dat}) Médecin. - Astronome. - Mathématicien. - Né en Crète. - Fils d''Eliya Delmedigo (1460-1497) [http://data.bnf.fr/ark:/12148/cb122623548#foaf:Person]
{/ud}
{ud0}
Giovanni Battista Vertova ({en0li}Bergame, Italie{/en}, {dat1592}1592{/dat}) Mathématicien et ingénieur militaire. - Chevalier de l''Ordre de Malte [http://data.bnf.fr/ark:/12148/cb15093021d#foaf:Person]
{/ud}
{ud0}
Johann Adam Schall von Bell ({dat1592}1592{/dat}) Jésuite. - Missionnaire en Chine (de 1619 à sa mort). - Mathématicien. - Conseiller et astronome de la Cour impériale de Chine [http://data.bnf.fr/ark:/12148/cb12362941r#foaf:Person]
{/ud}
{ud0}
Pierre Gassendi ({en0li}Champtercier, près de Digne{/en}, {dat1592}1592{/dat}) Philosophe, astronome, mathématicien, physicien, docteur en théologie et théoricien de la musique. - Entre dans les ordres en 1615 [http://data.bnf.fr/ark:/12148/cb120250393#foaf:Person]
{/ud}
{ud0}
Wilhelm Schickard ({en0li}Herrenberg, Allemagne{/en}, {dat1592}1592{/dat}) Mathématicien, astronome, professeur d''agriculture [http://data.bnf.fr/ark:/12148/cb11969696s#foaf:Person]
{/ud}
{ud0}
Albert Girard (Saint-Mihiel, {dat1595}1595{/dat}) Mathématicien et ingénieur. - Ingénieur dans l''armée de Frédéric de Nassau, prince d''Orange [http://data.bnf.fr/ark:/12148/cb121123333#foaf:Person]
{/ud}
{ud0}
Pierre Bardin ({en0li}Rouen{/en}, {dat1595}1595{/dat}) Homme de lettres, philosophe et mathématicien. - Précepteur. - Membre de l''Académie française (élu en 1634) [http://data.bnf.fr/ark:/12148/cb125272379#foaf:Person]
{/ud}
{ud0}
Pierre Bourdin ({dat1595}1595{/dat}) Jésuite. - Professeur de mathématiques [http://data.bnf.fr/ark:/12148/cb123902440#foaf:Person]
{/ud}
{ud0}
Daniel Mögling ({en0li}Böblingen{/en}, {dat1596}1596{/dat}) Alchimiste, rosicrucien, médecin et astronome [http://data.bnf.fr/ark:/12148/cb167575369#foaf:Person]
{/ud}
{ud0}
Jacob Golius ({dat1596}1596{/dat}) Orientaliste. - Mathématicien. - Philologue, spécialiste des littératures [http://data.bnf.fr/ark:/12148/cb123338386#foaf:Person]
{/ud}
{ud0}
René Descartes (Descartes (Indre-et-Loire), {dat1596}1596{/dat}) Philosophe et mathématicien [http://data.bnf.fr/ark:/12148/cb11899775j#foaf:Person]
{/ud}
{ud0}
Giovanni Battista Hodierna ({dat1597}1597{/dat}) Astronome italien [http://data.bnf.fr/ark:/12148/cb120704558#foaf:Person]
{/ud}
{ud0}
Bonaventura Cavalieri ({en0li}Milan, Italie{/en}, {dat1598}1598{/dat}) Jésuite. - Mathématicien, géomètre et astronome, disciple de Galilée. - Fut professeur à l''Université de Bologne [http://data.bnf.fr/ark:/12148/cb12085151g#foaf:Person]
{/ud}
{ud0}
Giovanni Battista Riccioli ({en0li}Ferrare, Italie{/en}, {dat1598}1598{/dat}) Jésuite. - Astronome. - Professeur de lettres, de philosophie et de théologie, à Parme puis à Bologne. - Mathématicien et historien de la géographie [http://data.bnf.fr/ark:/12148/cb12546680q#foaf:Person]
{/ud}
{ud0}
Pierre Petit ({dat1598}1598{/dat}) Mathématicien et physicien. - Intendant général des ports et fortifications de France ({dat1649}1649{/dat}) [http://data.bnf.fr/ark:/12148/cb123944733#foaf:Person]
{/ud}
{ud0}
Adam Olearius ({en0li}Aschersleben, Allemagne{/en}, {dat1599}1599{/dat}) Voyageur, en particulier en Russie et en Perse. - Mathématicien [http://data.bnf.fr/ark:/12148/cb12817277v#foaf:Person]
{/ud}
{ud0}
Jacob Aertsz Colom ({dat1599}1599{/dat}) Mathématicien, navigateur et cartographe. - Imprimeur à Amsterdam [http://data.bnf.fr/ark:/12148/cb153358650#foaf:Person]
{/ud}
{ud0}
Adriaan Vlacq ({dat1600}1600{/dat}) Autre(s) graphie(s) : Ulack ; Vlac. - Variante(s) de prénom : Adriaen ; Adrien. - Imprimeur-libraire. - Originaire de Gouda. Édite différents périodiques dont "De Haegsche Vrijdaeghse Post-Tijdingen". A publié en 1659 une contrefaçon de Johannes Elzevier et de Pieter Leffen. A également publié sous les fausses adresses et pseudonymes de "Cologne, Pierre Du Marteau" et "Amsterdam, Peter Le Grand". - Également mathématicien connu pour ses travaux sur les logarithmes et auteur d''ouvrages d''astronomie et de pamphlets en faveur des royalistes anglais en 1652-1655. Mort peu avant le 8 avril 1667. Des éd. paraissent encore sous son nom jusqu''en 1669, en association avec Johannes Vlacq [http://data.bnf.fr/ark:/12148/cb121635061#foaf:Person]
{/ud}
{ud0}
Antoine de Laloubère ({dat1600}1600{/dat}) Jésuite. - Mathématicien et géomètre, fut le premier scientifique à étudier les propriétés de l''hélice. - Polémiqua avec Pascal, qui l''appelle "Allouerus" dans l''"Histoire de la roulette". - Professeur de rhétorique, de théologie et de mathématiques au collège de Toulouse. - Né à Rieux, meurt à Toulouse [http://data.bnf.fr/ark:/12148/cb13006798h#foaf:Person]
{/ud}
{ud0}
Giacomo Oddi ({dat1600}1600{/dat}) Cartographe et mathématicien. Etudie à Naples [http://data.bnf.fr/ark:/12148/cb153917817#foaf:Person]
{/ud}
{ud0}
Jakob Bartsch ({dat1600}1600{/dat}) Médecin. - Professeur de mathématiques à Strasbourg. - Astronome. - Gendre et collaborateur de l''astronome Johann Kepler (1571-1630) [http://data.bnf.fr/ark:/12148/cb12163632v#foaf:Person]
{/ud}
{ud0}
Emmanuel Maignan ({dat1601}1601{/dat}) Religieux minime. - Philosophe, mathématicien et peintre. - Membre de la Société des lanternistes [http://data.bnf.fr/ark:/12148/cb130127157#foaf:Person]
{/ud}
{ud0}
Florimond de Beaune ({dat1601}1601{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb11890827s#foaf:Person]
{/ud}
{ud0}
Ovidio Montalbani ({dat1601}1601{/dat}) Docteur en philosophie et médecine de l'' Université de Bologne, professeur de mathématiques, chargé du musée Aldrovandi à partir de 1657, fut aussi un citoyen actif de Bologne, où il assura plusieurs magistratures ("giudice del Foro de mercanti, e de tribuni della plebe"). - Membre de l''Accademia dei Gelati de Bologne ("l''Innestato"), de l''Accademia degli Indomiti de Bologne ("lo Stellato"), et de l''Accademia della Notte de Bologne ("il Rugiadoso") [http://data.bnf.fr/ark:/12148/cb12064289s#foaf:Person]
{/ud}
{ud0}
Pierre de Fermat (Beaumont-de-Lomagne (Tarn-et-Garonne), {dat1601}1601{/dat}) Mathématicien, célèbre pour son théorème. - On lui doit aussi le Principe de Fermat en optique. - Conseiller au Parlement de Toulouse et commissaire en la chambre des requêtes du Palais à Toulouse (mai 1631) [http://data.bnf.fr/ark:/12148/cb11902568b#foaf:Person]
{/ud}
{ud0}
Athanasius Kircher ({en0li}Geisa (Allemagne){/en}, {dat1602}1602{/dat}) Jésuite. - Professeur de physique, de mathématiques et de langues orientales, Collegio Romano, Rome. - Dessinateur et graveur [http://data.bnf.fr/ark:/12148/cb119097824#foaf:Person]
{/ud}
{ud0}
Gilles Personne de Roberval ({en0li}Roberval, Oise{/en}, {dat1602}1602{/dat}) Professeur de philosophie ({dat1634}1634{/dat}) et de mathématiques ({dat1655}1655{/dat}) au Collège royal, Paris. - Membre fondateur de l''Académie royale des sciences [http://data.bnf.fr/ark:/12148/cb12144923j#foaf:Person]
{/ud}
{ud0}
Jacques de Billy ({dat1602}1602{/dat}) Jésuite (à partir de 1619). - Mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb123773436#foaf:Person]
{/ud}
{ud0}
John Greaves ({en0li}Colemore, GB{/en}, {dat1602}1602{/dat}) Mathématicien. - Orientaliste. - Professeur d''astronomie à Londres puis à Oxford [http://data.bnf.fr/ark:/12148/cb129277690#foaf:Person]
{/ud}
{ud0}
Pierre Gautruche ({dat1602}1602{/dat}) Jésuite. - Professeur de philosophie, de théologie et de mathématiques. - Identifié par certains à Pierre Gautier (1599-16..), luthiste et compositeur [http://data.bnf.fr/ark:/12148/cb121990328#foaf:Person]
{/ud}
{ud0}
Blaise-François de Pagan ({en0li}Avignon{/en}, {dat1604}1604{/dat}) Ingénieur et astronome [http://data.bnf.fr/ark:/12148/cb12155087r#foaf:Person]
{/ud}
{ud0}
Claude Hardy ({dat1604}1604{/dat}) Fils de Sébastien Hardy. - Conseiller au Châtelet. - Mathématicien. - Ami de Mydorge, Descartes et du Père Mersenne ; souvent cité dans la correspondance de ces deux derniers [http://data.bnf.fr/ark:/12148/cb12134536k#foaf:Person]
{/ud}
{ud0}
Bernard Frénicle de Bessy ({dat1605}1605{/dat}) Mathématicien, géomètre et arithméticien. - Membre de l''Académie des Sciences. - Conseiller à la Cour des monnaies [http://data.bnf.fr/ark:/12148/cb12459881c#foaf:Person]
{/ud}
{ud0}
Ismaël Boulliau ({en0li}Loudun (Vienne){/en}, {dat1605}1605{/dat}) Astronome. - Secrétaire de Jacques Du Puy et attaché au président de Thou [http://data.bnf.fr/ark:/12148/cb124621511#foaf:Person]
{/ud}
{ud0}
Juan de Caramuel y Lobkowitz ({en0li}Madrid{/en}, {dat1606}1606{/dat}) Cistercien. - Evêque de Satriano et Campagna (1657-1673) puis de Vigevano (1673-). - Humaniste, théologien, mathématicien, philosophe et architecte. - Défenseur de la doctrine probabiliste [http://data.bnf.fr/ark:/12148/cb12392566m#foaf:Person]
{/ud}
{ud0}
Evangelista Torricelli ({en0li}Faenza, Italie{/en}, {dat1608}1608{/dat}) Physicien et mathématicien [http://data.bnf.fr/ark:/12148/cb12117674q#foaf:Person]
{/ud}
{ud0}
Gaspar Schott ({en0li}Königshaufen, Allemagne{/en}, {dat1608}1608{/dat}) Mathématicien et physicien. - Jésuite [http://data.bnf.fr/ark:/12148/cb12519717b#foaf:Person]
{/ud}
{ud0}
Giovanni Alfonso Borelli ({en0li}Naples, Italie{/en}, {dat1608}1608{/dat}) Mathématicien, phycisien, médecin, philosophe. - Membre de l''Accademia del Cimento [http://data.bnf.fr/ark:/12148/cb12462534j#foaf:Person]
{/ud}
{ud0}
Giovan Battista Nicolosi ({en0li}Paternò, Italie{/en}, {dat1610}1610{/dat}) Géographe et cartographe. - Professeur de mathématiques et de géographie à l''Université de Rome [http://data.bnf.fr/ark:/12148/cb15404103t#foaf:Person]
{/ud}
{ud0}
Józef Naronowicz-Naroński ({dat1610}1610{/dat}) Mathématicien. - Cartographe. - Architecte au service de la famille Radzwill. - Né en Lituanie [http://data.bnf.fr/ark:/12148/cb150812338#foaf:Person]
{/ud}
{ud0}
Maria Cunitia ({dat1610}1610{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb162514419#foaf:Person]
{/ud}
{ud0}
Jan Heweliusz ({dat1611}1611{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb121054498#foaf:Person]
{/ud}
{ud0}
John Pell ({dat1611}1611{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb146515879#foaf:Person]
{/ud}
{ud0}
Michael Floris Van Langren ({dat1612}1612{/dat}) Astronome et mathématicien du roi d''Espagne installé à Bruxelles [http://data.bnf.fr/ark:/12148/cb153283774#foaf:Person]
{/ud}
{ud0}
Francesco Maria Grimaldi ({dat1613}1613{/dat}) Jésuite. - Philosophe, astronome, opticien et professeur de mathématiques. - Né et mort à Bologne [http://data.bnf.fr/ark:/12148/cb13326913s#foaf:Person]
{/ud}
{ud0}
François Chauveau ({dat1613}1613{/dat}) Grava des cartouches notamment pour Nicolas Sanson. Eut un neveu du nom de François Chauveau. Son frère, Jean-Baptiste, habile ingénieur et mathématicien fut assassiné en 1670. [http://data.bnf.fr/ark:/12148/cb15302394v#foaf:Person]
{/ud}
{ud0}
Jean François Nicéron ({en0li}Paris{/en}, {dat1613}1613{/dat}) Religieux de l''Ordre des minimes. - Mathématicien [http://data.bnf.fr/ark:/12148/cb14404933t#foaf:Person]
{/ud}
{ud0}
Tommaso Cornelio ({en0li}Rovito, Italie{/en}, {dat1614}1614{/dat}) Médecin, philosophe et mathématicien [http://data.bnf.fr/ark:/12148/cb13484167f#foaf:Person]
{/ud}
{ud0}
Frans Van Schooten ({dat1615}1615{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb12529949q#foaf:Person]
{/ud}
{ud0}
John Wallis ({dat1616}1616{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb123396143#foaf:Person]
{/ud}
{ud0}
Jonas Moore ({dat1617}1617{/dat}) Mathématicien britannique. - S''est intéressé aux mathématiques appliquées (astronomie, cosmographie, architecture...) [http://data.bnf.fr/ark:/12148/cb135104102#foaf:Person]
{/ud}
{ud0}
Tito Livio Burattini ({en0li}Agordo, Italie{/en}, {dat1617}1617{/dat}) Mathématicien, cartographe et égyptologue [http://data.bnf.fr/ark:/12148/cb162142362#foaf:Person]
{/ud}
{ud0}
Anthelme (Chatenay-Vaudin (Haute-Marne), {dat1618}1618{/dat}) Religieux de la Chartreuse de Dijon. - Astronome [http://data.bnf.fr/ark:/12148/cb106267229#foaf:Person]
{/ud}
{ud0}
Charles Cavendish ({dat1620}1620{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb14651592w#foaf:Person]
{/ud}
{ud0}
Jean Picard ({en0li}La Flèche (Sarthe){/en}, {dat1620}1620{/dat}) Astronome. - Membre de l''Académie des sciences ({dat1666}1666{/dat}) [http://data.bnf.fr/ark:/12148/cb11941359d#foaf:Person]
{/ud}
{ud0}
Claude-François Milliet de Chales ({dat1621}1621{/dat}) Mathématicien. - Professeur d''hydrographie à Marseille [http://data.bnf.fr/ark:/12148/cb12397222c#foaf:Person]
{/ud}
{ud0}
Adrien Auzout ({en0li}Rouen{/en}, {dat1622}1622{/dat}) Astronome, physicien et mathématicien. - A contribué au développement du micromètre [http://data.bnf.fr/ark:/12148/cb134752474#foaf:Person]
{/ud}
{ud0}
Jean Bertet ({dat1622}1622{/dat}) Jésuite, quitte la Compagnie en 1681 pour entrer chez les Bénédictins. - Professeur de rhétorique, philosophie et mathématiques. - Poète [http://data.bnf.fr/ark:/12148/cb11999230c#foaf:Person]
{/ud}
{ud0}
René-François De Sluse ({dat1622}1622{/dat}) Mathématicien. - Chanoine de la Cathédrale de Liège et abbé d''Amay [http://data.bnf.fr/ark:/12148/cb12427294z#foaf:Person]
{/ud}
{ud0}
Vincenzo Viviani ({en0li}Florence, Italie{/en}, {dat1622}1622{/dat}) Florentin. - Mathématicien. - Membre de l'' "accademia della Crusca" [http://data.bnf.fr/ark:/12148/cb12000373g#foaf:Person]
{/ud}
{ud0}
Blaise Pascal (Clermont-Ferrand (Puy-de-Dôme), {dat1623}1623{/dat}) Mathématicien, physicien, écrivain. - Frère de : Pascal, Jacqueline (1625-1661) [http://data.bnf.fr/ark:/12148/cb11918679x#foaf:Person]
{/ud}
{ud0}
Ferdinand Verbiest ({en0li}Pitthem, Belgique{/en}, {dat1623}1623{/dat}) Jésuite, missionnaire en Chine. - Astronome. - Fut placé à la tête du tribunal des mathématiques, chargé de la rédaction des éphémérides et de la direction des fonderies de canons. - A publié en langue chinoise, sous le nom de Nanhoai-jin, un grand nombre d''ouvrages scientifiques [http://data.bnf.fr/ark:/12148/cb12215344n#foaf:Person]
{/ud}
{ud0}
Camillo Guarino Guarini ({en0li}Modène, Italie{/en}, {dat1624}1624{/dat}) Clerc régulier, théatin. - Architecte du duc de Savoie, philosophe et mathématicien [http://data.bnf.fr/ark:/12148/cb12348027r#foaf:Person]
{/ud}
{ud0}
Christoph Wittich ({dat1625}1625{/dat}) Théologien. - Professeur de mathématiques et de théologie [http://data.bnf.fr/ark:/12148/cb13014027s#foaf:Person]
{/ud}
{ud0}
Erhard Weigel ({dat1625}1625{/dat}) Philosophe. - Professeur de mathématiques, maître de Leibniz et de Pufendorf [http://data.bnf.fr/ark:/12148/cb11935908x#foaf:Person]
{/ud}
{ud0}
Jean-Dominique Cassini ({en0li}Perinaldo (comté de Nice){/en}, {dat1625}1625{/dat}) Titulaire de la chaire d''astronomie de Bologne de 1650 à 1669, surintendant des eaux du Bolonais de 1657 à 1669, surintendant des eaux de l''Etat pontifical et titulaire d''autres charges auprès du pape. - Appelé en France an avril 1669 par Louis XIV. - Membre de l''Académie des sciences, directeur de l''Observatoire de Paris (à partir de 1672). - Naturalisé français en 1673 [http://data.bnf.fr/ark:/12148/cb121019904#foaf:Person]
{/ud}
{ud0}
Johan de Witt (Dordrecht, Pays-Bas, {dat1625}1625{/dat}) Homme d''état et mathématicien. - Grand pensionnaire de Hollande [http://data.bnf.fr/ark:/12148/cb13598046j#foaf:Person]
{/ud}
{ud0}
Johann Hecker ({en0li}Gdansk (Pologne){/en}, {dat1625}1625{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb12875545t#foaf:Person]
{/ud}
{ud0}
Rasmus Bartholin ({en0li}Roskilde, Danemark{/en}, {dat1625}1625{/dat}) Physicien. - Mathématicien. - Médecin. - Professeur de mathématiques et de médecine à Copenhague. - A découvert la difraction de la lumière. - Fils de Kaspar Bartholin [http://data.bnf.fr/ark:/12148/cb11890430k#foaf:Person]
{/ud}
{ud0}
Samuel Morland ({dat1625}1625{/dat}) Mathématicien et inventeur [http://data.bnf.fr/ark:/12148/cb10365749d#foaf:Person]
{/ud}
{ud0}
Pietro Mengoli ({en0li}Bologne (Italie){/en}, {dat1626}1626{/dat}) Mathématicien. - Professeur de mécanique (1650-1678) puis titulaire de la chaire de mathématiques et d''astronomie (1678-1686) à l''université de Bologne [http://data.bnf.fr/ark:/12148/cb120851477#foaf:Person]
{/ud}
{ud0}
John Ray ({en0li}Black Notley (Essex){/en}, {dat1627}1627{/dat}) Professeur de mathématiques et de lettres. - Naturaliste. - Botaniste. - Membre de la Société royale de Londres [http://data.bnf.fr/ark:/12148/cb12220184b#foaf:Person]
{/ud}
{ud0}
Heinrich Scherer ({dat1628}1628{/dat}) Jésuite, géographe et professeur de mathématiques à Munich [http://data.bnf.fr/ark:/12148/cb15317471w#foaf:Person]
{/ud}
{ud0}
Johannes Hudde ({dat1628}1628{/dat}) Mathématicien, élève de Frans Van Schooten. - Bourgmestre de la ville d''Amsterdam [http://data.bnf.fr/ark:/12148/cb13488288n#foaf:Person]
{/ud}
{ud0}
Christiaan Huygens ({dat1629}1629{/dat}) Mathématicien et astronome. - A vécu aux Pays-Bas et en France. - Élu membre de la "Royal society" de Londres (en 1663) [http://data.bnf.fr/ark:/12148/cb12192922r#foaf:Person]
{/ud}
{ud0}
Allain Manesson-Mallet ({en0li}Paris (France){/en}, {dat1630}1630{/dat}) Ingénieur et cartographe. - Maître de mathématiques des pages du roi de France, sergent-major d''artillerie du roi de Portugal [http://data.bnf.fr/ark:/12148/cb153363577#foaf:Person]
{/ud}
{ud0}
Isaac Barrow ({dat1630}1630{/dat}) Mathématicien et théologien [http://data.bnf.fr/ark:/12148/cb12340135q#foaf:Person]
{/ud}
{ud0}
Jean Richer ({dat1630}1630{/dat}) Astronome à l''Observatoire de Paris, il figure parmi les premiers membres de l''Académie des sciences ({dat1666}1666{/dat}). - Chargé d''une mission géodésique à Cayenne (1672-73) [http://data.bnf.fr/ark:/12148/cb14064426q#foaf:Person]
{/ud}
{ud0}
Adam Adamady Kochánski ({dat1631}1631{/dat}) Mathématicien polonais, auteur de la rectification approchée de la circonférence. Réside en 1677 à Wroclaw [http://data.bnf.fr/ark:/12148/cb16187484g#foaf:Person]
{/ud}
{ud0}
Francesco Lana Terzi ({en0li}Brescia, Italie{/en}, {dat1631}1631{/dat}) Jésuite. - Mathématicien, naturaliste. - Pionnier de l''aéronautique [http://data.bnf.fr/ark:/12148/cb10681783j#foaf:Person]
{/ud}
{ud0}
Christopher Wren ({en0li}East Knoyle, Wiltshire, GB{/en}, {dat1632}1632{/dat}) Architecte. - Mathématicien et astronome, Sir Christopher Wren fut l''un des membres fondateurs de la Société royale des sciences [http://data.bnf.fr/ark:/12148/cb121401670#foaf:Person]
{/ud}
{ud0}
Alessandro Marchetti ({en0li}Empoli, Italie{/en}, {dat1633}1633{/dat}) Poète naturaliste, l''un des principaux animateurs du courant naturaliste toscan de la seconde moitié du XVIIe siècle. - Professeur de philosophie puis de mathématiques à l''Université de Pise [http://data.bnf.fr/ark:/12148/cb12570345j#foaf:Person]
{/ud}
{ud0}
Donato Rossetti ({en0li}Livourne, Italie{/en}, {dat1633}1633{/dat}) Mathématicien. - Professeur de philosophie au "Studio" de Pise [http://data.bnf.fr/ark:/12148/cb144820894#foaf:Person]
{/ud}
{ud0}
Geminiano Montanari ({en0li}Modène, Italie{/en}, {dat1633}1633{/dat}) Docteur en droit, mathématicien et astronome. - Enseigne à Florence, Modène (1661-1664), Bologne (chaire de mathématiques, 1664-1677) et Padoue (chaire d''astronomie, 1678-1687). - Membre de l''Accademia dei Gelati ("l''Elevato") et de l''Accademia della Treccia de Bologne [http://data.bnf.fr/ark:/12148/cb12309300z#foaf:Person]
{/ud}
{ud0}
Gerhard Wolter Molanus ({dat1633}1633{/dat}) Théologien luthérien. - Mathématicien [http://data.bnf.fr/ark:/12148/cb12133744h#foaf:Person]
{/ud}
{ud0}
Giovanni Giustino Ciampini ({en0li}Rome{/en}, {dat1633}1633{/dat}) Historien, archéologue, mathématicien. - Membre de la Curie pontificale [http://data.bnf.fr/ark:/12148/cb14323561z#foaf:Person]
{/ud}
{ud0}
Vitale Giordano ({dat1633}1633{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb15520924m#foaf:Person]
{/ud}
{ud0}
Johann Christoph Sturm ({en0li}Hilpolstein, Allemagne{/en}, {dat1635}1635{/dat}) Philosophe, mathématicien et physicien. - Professeur à l''université d''Altdorf [http://data.bnf.fr/ark:/12148/cb133240234#foaf:Person]
{/ud}
{ud0}
Ignace-Gaston Pardies ({dat1636}1636{/dat}) Mathématicien. - Jésuite. - Il a enseigné la philosophie puis les mathématiques au collège Louis-Le-Grand [http://data.bnf.fr/ark:/12148/cb12174258w#foaf:Person]
{/ud}
{ud0}
Elias van Lennep (Borculo, Pays-Bas, {dat1637}1637{/dat}) Graveur. - Ingénieur et mathématicien [http://data.bnf.fr/ark:/12148/cb15053499m#foaf:Person]
{/ud}
{ud0}
Julius Reichelt ({dat1637}1637{/dat}) Mathématicien strasbourgeois [http://data.bnf.fr/ark:/12148/cb15377331m#foaf:Person]
{/ud}
{ud0}
François Barrême ({en0li}Tarascon, France{/en}, {dat1638}1638{/dat}) Mathématicien et financier [http://data.bnf.fr/ark:/12148/cb118903320#foaf:Person]
{/ud}
{ud0}
Georg Christoph Eimmart ({en0li}Ratisbonne (Allemagne){/en}, {dat1638}1638{/dat}) Peintre d''histoire, portraitiste, graveur, mathématicien et astronome. - Fils et élève du peintre Georg-Christoph Eimmart (1603-1658), dit le vieux [http://data.bnf.fr/ark:/12148/cb12983761h#foaf:Person]
{/ud}
{ud0}
James Gregory ({dat1638}1638{/dat}) Mathématicien et opticien écossais [http://data.bnf.fr/ark:/12148/cb12459917j#foaf:Person]
{/ud}
{ud0}
Jean Bonfa ({en0li}Nîmes{/en}, {dat1638}1638{/dat}) Est admis à la Société de Jésus en 1654. - Dans les années 1670 jusqu''en 1683, il enseigne les mathématiques et la théologie aux collèges jésuites de Grenoble, puis d''Avignon. - De 1680 à 1682, enseigne la géométrie et l''hydrographie. - Effectue des travaux astronomiques. - Devient membre correspondant de l''Académie royale des sciences (en 1699) [http://data.bnf.fr/ark:/12148/cb15130186g#foaf:Person]
{/ud}
{ud0}
Jacques Ozanam (Sainte-Olive ({en0li}Ain){/en}, {dat1640}1640{/dat}) Mathématicien. - Professeur de mathématiques à Paris et à Lyon [http://data.bnf.fr/ark:/12148/cb120960958#foaf:Person]
{/ud}
{ud0}
Philippe de La Hire ({en0li}Paris (France){/en}, {dat1640}1640{/dat}) Mathématicien. - Géomètre et astronome. - Professeur de mathématiques au Collège de France. - Membre de l''Académie des sciences ({dat1678}1678{/dat}) [http://data.bnf.fr/ark:/12148/cb121592847#foaf:Person]
{/ud}
{ud0}
Pierre Ango ({dat1640}1640{/dat}) Jésuite. - Enseigna les humanités, les mathématiques et la philosophie. - Né à Rouen, mort à La Flèche [http://data.bnf.fr/ark:/12148/cb12512101m#foaf:Person]
{/ud}
{ud0}
Denis Papin ({dat1642}1642{/dat}) Physicien. - Un des précurseurs de l''invention de la machine à vapeur, qui eu l''idée du piston (dés 1690), et inspira la machine que l''Anglais Thomas Newcomen (1664-1729), mis au point ensuite (en 1712). - Quitta définitivement la France, après la révocation de l''Édit de Nantes ({dat1685}1685{/dat}). - Occupa une chaire de mathématiques à l''Université de Marburg, Allemagne ({dat1687}1687{/dat}). - Rédige un article (Ars nova ad aquam ignis...) présentant sa machine dans la revue " Acta Eruditorum", Leipzig (en 1707), revue célèbre pour les publications de Leibniz (1646-1716), sur le calcul différentiel et intégral [http://data.bnf.fr/ark:/12148/cb12087889k#foaf:Person]
{/ud}
{ud0}
Isaac Newton (Woolsthorpe, Lincolnshire ({en0li}GB){/en}, {dat1642}1642{/dat}) Physicien, mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb119176085#foaf:Person]
{/ud}
{ud0}
Johann Welper ({dat1642}1642{/dat}) Variante(s) de prénom : Johannes ; Jean. - Imprimeur-libraire. - Fils et apprenti d''Eberhard Welper, imprimeur-libraire et mathématicien à Strasbourg. A été compagnon pendant 6 ans à Ulm, Augsbourg, Munich, Vienne, Leipzig et Nuremberg, avant de succéder à son père. L''enquête de 1700-1701 le dit âgé de 60 ans et "établi à Strasbourg depuis 42 ans". À sa mort, son entreprise est rachetée par Melchior Pauschinger [http://data.bnf.fr/ark:/12148/cb160636269#foaf:Person]
{/ud}
{ud0}
Michel Mourgues ({dat1642}1642{/dat}) Jésuite. - Enseigna la rhétorique et les mathématiques à l''Université de Toulouse [http://data.bnf.fr/ark:/12148/cb124637183#foaf:Person]
{/ud}
{ud0}
Takakazu Seki ({dat1642}1642{/dat}) Mathématicien japonais [http://data.bnf.fr/ark:/12148/cb12443516f#foaf:Person]
{/ud}
{ud0}
Jean Jombert ({dat1643}1643{/dat}) Libraire. - Fils d''un fruitier et marchand de vins parisien. En apprentissage chez le libraire parisien Pierre II Baudouin à partir de janv. 1666, il travaille en 1670-1671 chez Louis Billaine et Pierre Le Petit, puis chez la veuve de Pierre I Baudouin à partir de 1672. Gendre en 1res noces ({dat1671}1671{/dat}) du libraire Jean d''Houry. Publie sous son propre nom dès 1680, peut-être dès 1678, mais n''est reçu maître que le 17 sept. 1686. Publie de nombreux ouvrages de mathématiques. Dit âgé d''env. 60 ans lors de l''enquête de nov.-déc. 1701. Testaments le 9 août 1704 et le 6 oct. 1705. Décédé au début de nov. 1705. Sa veuve lui succède [http://data.bnf.fr/ark:/12148/cb15074749j#foaf:Person]
{/ud}
{ud0}
Antoine Thomas ({en0li}Namur{/en}, {dat1644}1644{/dat}) Jésuite (à partir de 1660). - Mathématicien et astronome de l''empereur de Chine [http://data.bnf.fr/ark:/12148/cb10636254r#foaf:Person]
{/ud}
{ud0}
Johann Jakob Zimmermann ({en0li}Vaihingen an der Enz, Allemagne{/en}, {dat1644}1644{/dat}) Théologien, mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb10721479d#foaf:Person]
{/ud}
{ud0}
Ole Rømer ({en0li}Åarhus, Danemark{/en}, {dat1644}1644{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb12324191r#foaf:Person]
{/ud}
{ud0}
Carlos de Sigüenza y Góngora ({en0li}Mexico{/en}, {dat1645}1645{/dat}) Astronome, mathématicien, poète, historien. - Sa bibliothèque, comprenant des documents uniques sur l''histoire du Mexique, disparut dans un incendie lors de l''insurrection de 1692 [http://data.bnf.fr/ark:/12148/cb121021638#foaf:Person]
{/ud}
{ud0}
Eusebio Francisco Kino ({en0li}Taio, Italie{/en}, {dat1645}1645{/dat}) Mathématicien et géographe de formation. - Jésuite, arrive au Mexique en 1681 [http://data.bnf.fr/ark:/12148/cb122190783#foaf:Person]
{/ud}
{ud0}
Maximilian Rassler ({en0li}Waldsee (Allemagne){/en}, {dat1645}1645{/dat}) Jésuite. - Professeur de réthorique, de mathématiques, philosophie et contreverse. - Recteur et chancelier de l''Université de Dillingen, Allemagne [http://data.bnf.fr/ark:/12148/cb158132748#foaf:Person]
{/ud}
{ud0}
Elena Lucrezia Cornaro Piscopia ({en0li}Venise (Italie){/en}, {dat1646}1646{/dat}) Philosophe et mathématicienne. - Première femme docteur en philosophie [http://data.bnf.fr/ark:/12148/cb16591183r#foaf:Person]
{/ud}
{ud0}
Francesco Maria Pompeo Colonna ({en0li}Rome{/en}, {dat1646}1646{/dat}) Mathématicien, physicien et occultiste. - Vécut à Paris à partir de 1668 [http://data.bnf.fr/ark:/12148/cb118973978#foaf:Person]
{/ud}
{ud0}
Harald Vallerius ({dat1646}1646{/dat}) Professeur universitaire de mathématiques [http://data.bnf.fr/ark:/12148/cb16032560b#foaf:Person]
{/ud}
{ud0}
John Flamsteed ({dat1646}1646{/dat}) Astronome. - Fut le premier directeur de l''Observatoire de Greenwich, GB, fondé en 1675 [http://data.bnf.fr/ark:/12148/cb13524243n#foaf:Person]
{/ud}
{ud0}
John Flamsteed ({dat1646}1646{/dat}) Astronome britannique. Fut le premier directeur de l''observatoire de Greenwich, fondé en 1675 [http://data.bnf.fr/ark:/12148/cb13510391m#foaf:Person]
{/ud}
{ud0}
Niccolò Partenio Giannettasio ({dat1648}1648{/dat}) Jésuite. - Historien et poète. - Professeur de mathématiques et d''hébreu au Collège des Jésuites de Naples. - Né à Naples, meurt à Massa [http://data.bnf.fr/ark:/12148/cb133256727#foaf:Person]
{/ud}
{ud0}
Tommaso Ceva ({dat1648}1648{/dat}) Jésuite. - Philosophe, astronome, physicien et poète. - Membre de l''Académie de l''Arcadie sous le pseudonyme : Callimaco Neridio [http://data.bnf.fr/ark:/12148/cb13321850h#foaf:Person]
{/ud}
{ud0}
Jean Le Febvre ({en0li}Lisieux (Calvados){/en}, {dat1650}1650{/dat}) Tisserand, puis astronome. - Membre de l''Académie des sciences de 1682 à 1702 [http://data.bnf.fr/ark:/12148/cb16176897g#foaf:Person]
{/ud}
{ud0}
Michelangelo Fardella ({dat1650}1650{/dat}) Franciscain. - Philosophe, astronome et mathématicien. - Professeur de philosophie, de théologie, de mathématiques, professeur d''astronomie et de physique à l''Université de Padoue (1694-). - Né à Trapani, meurt à Naples [http://data.bnf.fr/ark:/12148/cb12093422f#foaf:Person]
{/ud}
{ud0}
Andreas Cellarius ({dat1651}1651{/dat}) Mathématicien et géographe hollandais actif de 1656 à 1702. En 1660 il est recteur de l''Ecole latine de Hoorn [http://data.bnf.fr/ark:/12148/cb15338282n#foaf:Person]
{/ud}
{ud0}
Antoine-François Payen ({en0li}Avignon{/en}, {dat1651}1651{/dat}) Jurisconsulte et astronome. - Enseigna la jurisprudence civile dès 1642 à Avignon [http://data.bnf.fr/ark:/12148/cb144713316#foaf:Person]
{/ud}
{ud0}
Arent Roggeveen ({dat1651}1651{/dat}) Mathématicien, navigateur et hydrographe [http://data.bnf.fr/ark:/12148/cb153879695#foaf:Person]
{/ud}
{ud0}
Bingzhen Jiao ({dat1651}1651{/dat}) Peintre et mathématicien à la cour de l''empereur Kangxi [http://data.bnf.fr/ark:/12148/cb14546684c#foaf:Person]
{/ud}
{ud0}
Caspar Dauthendey ({dat1651}1651{/dat}) Architecte et mathématicien [http://data.bnf.fr/ark:/12148/cb153778194#foaf:Person]
{/ud}
{ud0}
Claude Bonjour ({dat1651}1651{/dat}) Augustin du couvent de Pontarlier. Géographe et mathématicien [http://data.bnf.fr/ark:/12148/cb15294805z#foaf:Person]
{/ud}
{ud0}
Claude Comiers ({dat1651}1651{/dat}) Théologien et mathématicien, né à Embrun. Chanoine d''Embrun, ingénieur des armées, puis prévôt de l''église collégiale de Ternant, professeur de mathématiques à Paris ; protonotaire apostolique et officier du Saint-Office. - Il a laissé des livres et des articles sur des sujets variés : géométrie, astronomie, médecine, occultisme, physique... [http://data.bnf.fr/ark:/12148/cb12250531g#foaf:Person]
{/ud}
{ud0}
Claude Irson ({dat1651}1651{/dat}) Mathématicien et grammairien. - A été teneur de comptes vers 1678 [http://data.bnf.fr/ark:/12148/cb125155096#foaf:Person]
{/ud}
{ud0}
de La Roche ({dat1651}1651{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb13009642b#foaf:Person]
{/ud}
{ud0}
Ehrenfried Walter von Tschirnhaus ({en0li}Kieslingswalde, Allemagne{/en}, {dat1651}1651{/dat}) Philosophe, mathématicien et biologiste. - Industriel, considéré comme l''inventeur de la porcellaine blanche en Europe [http://data.bnf.fr/ark:/12148/cb12515471b#foaf:Person]
{/ud}
{ud0}
Federico Gualdi ({dat1651}1651{/dat}) Alchimiste, astronome, mathématicien. - Philosophe hermétique. - Membre de la Rose-croix d''Or. - Serait d''origine allemande ou italienne [http://data.bnf.fr/ark:/12148/cb150904929#foaf:Person]
{/ud}
{ud0}
Francesco Levera ({en0li}Savoie{/en}, {dat1651}1651{/dat}) Philosophe, astronome et théologien [http://data.bnf.fr/ark:/12148/cb10442558v#foaf:Person]
{/ud}
{ud0}
François Chevalier (Sainte-Maur, {dat1651}1651{/dat}) Elève de l''abbé Galloys. Associé géomètre à l''Académie des sciences en 1707. Pensionnaire mécanicien en 1725. Professeur de mathématiques au Collège de France. Maître de mathématiques du roi et des pages de la Petite Ecurie. Présenta en 1707 à l''Académie une méthode de collecte des informations cartographiques sur des châssis concentriques [http://data.bnf.fr/ark:/12148/cb153045899#foaf:Person]
{/ud}
{ud0}
François Noël (Hestrud, Pays-Bas Méridionaux, {dat1651}1651{/dat}) Jésuite (à partir de 1670) ordonné prêtre en 1682. - Missionnaire en Chine, il fut envoyé à Rome à l''occasion de la querelle des rites, et ne put rentrer en Chinê. - Il enseigna ensuite à Prague. - Auteur de poésies et de théâtre, d''un traité d''astronomie, de traductions et d''un ouvrage catéchétique en chinois [http://data.bnf.fr/ark:/12148/cb16653645d#foaf:Person]
{/ud}
{ud0}
Guisnée ({dat1651}1651{/dat}) Mathématicien. - Membre de l''Académie royale des sciences [http://data.bnf.fr/ark:/12148/cb14618149h#foaf:Person]
{/ud}
{ud0}
Jacques Mengau ({dat1651}1651{/dat}) Professeur de mathématiques. - Auteur de mazarinades. - Actif de 1648 à 1652 [http://data.bnf.fr/ark:/12148/cb12166762s#foaf:Person]
{/ud}
{ud0}
Jean Bachou ({dat1651}1651{/dat}) Mathématicien et alchimiste lyonnais. - Avocat au parlement [http://data.bnf.fr/ark:/12148/cb12158814g#foaf:Person]
{/ud}
{ud0}
Jean Glover ({dat1651}1651{/dat}) Ingénieur et mathématicien originaire d''Écosse et établi en France. - Auteur notamment de plusieurs propositions de loteries et d''une "Nouvelle Manière d''exécuter les loteries..." ({en0li}Paris{/en}, {dat1705}1705{/dat}). - Se qualifie d''"esquire, seigneur de Glaideny et de la baronnie de Baltillée en Ecosse" [http://data.bnf.fr/ark:/12148/cb15818830h#foaf:Person]
{/ud}
{ud0}
Jean-Baptiste Delure ({dat1651}1651{/dat}) Éditeur d''estampes et de cartes géographiques. - Ingénieur pour les instruments de mathématiques et fabricant de cartes et de globes ; éditeur occasionnel [http://data.bnf.fr/ark:/12148/cb153164066#foaf:Person]
{/ud}
{ud0}
Joachim d'' Alencé ({dat1651}1651{/dat}) Astronome et physicien [http://data.bnf.fr/ark:/12148/cb12397878n#foaf:Person]
{/ud}
{ud0}
Joanne Westenburg ({dat1651}1651{/dat}) Cartographe, médecin et mathématicien [http://data.bnf.fr/ark:/12148/cb15377993t#foaf:Person]
{/ud}
{ud0}
Johann Andreas Planer ({en0li}Strelen, Allemagne{/en}, {dat1651}1651{/dat}) Mathématicien. - Professeur de mathématiques à l''Université de Wittenberg [http://data.bnf.fr/ark:/12148/cb16672375p#foaf:Person]
{/ud}
{ud0}
Le Blanc ({dat1651}1651{/dat}) Professeur de mathématiques ({dat1692}1692{/dat}). - Réside rue de Seine à Paris en 1692 [http://data.bnf.fr/ark:/12148/cb16650697x#foaf:Person]
{/ud}
{ud0}
Le Demaine Godalles ({dat1651}1651{/dat}) Hydrographe, Ingénieur du roi et professeur de Mathématiques, Architecte [http://data.bnf.fr/ark:/12148/cb15375819n#foaf:Person]
{/ud}
{ud0}
Philip Lea ({dat1651}1651{/dat}) Cartographe, fabricant et éditeur de globes, de cartes, d''instruments de mathématiques, actif de 1666 à 1700 à Londres [http://data.bnf.fr/ark:/12148/cb15328427v#foaf:Person]
{/ud}
{ud0}
René Gaultier de Maignannes ({dat1651}1651{/dat}) Mathématicien angevin. - Spécialiste de la perspective [http://data.bnf.fr/ark:/12148/cb12536157m#foaf:Person]
{/ud}
{ud0}
David François de Merveilleux ({dat1652}1652{/dat}) Géographe et cartographe. Connaissances mathématiques étendues (il publie un traîté d''arithmétique et de géométrie). En 1695 il entre au service de Guillaume III qui lui accorde le brevet de Capitaine Ingénieur au service d''Angleterre et des Etats généraux [http://data.bnf.fr/ark:/12148/cb15304894q#foaf:Person]
{/ud}
{ud0}
Michel Rolle (Ambert (Puy-de-Dôme), {dat1652}1652{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb130110121#foaf:Person]
{/ud}
{ud0}
Nicolas Bion ({dat1652}1652{/dat}) Ingénieur du roi pour les instruments de mathématique. - Avait un atelier à Paris, quai de l''Horloge, qui était l''un des mieux achalandés du temps. - Son "Usage des globes" connut 6 éditions entre 1699 et 1751. - Édita en 1694 le globe terrestre de P. Courtin (diam. 25 cm) et en 1712 une paire de globes de même diamètre, un globe céleste antérieur à 1710 atteignit 32 cm de diamètre [http://data.bnf.fr/ark:/12148/cb152909089#foaf:Person]
{/ud}
{ud0}
José Chaffrion ({dat1653}1653{/dat}) Cartographe et mathématicien de Valence en Espagne [http://data.bnf.fr/ark:/12148/cb15330290b#foaf:Person]
{/ud}
{ud0}
Bernard Nieuwentijt (West Graftdijk, Pays-Bas, {dat1654}1654{/dat}) Philosophe, médecin et mathématicien [http://data.bnf.fr/ark:/12148/cb14587835s#foaf:Person]
{/ud}
{ud0}
Jacques Bernoulli ({en0li}Bâle, Suisse{/en}, {dat1654}1654{/dat}) Mathématicien et astronome. - Professeur de mathématiques à l''université de Bâle, Suisse [http://data.bnf.fr/ark:/12148/cb120751142#foaf:Person]
{/ud}
{ud0}
Jean Pigeon ({en0li}Donzy (Nièvre){/en}, {dat1654}1654{/dat}) Peintre, mathématicien et facteur de globes, géographe du Duc d''Orléans à partir de 1714 [http://data.bnf.fr/ark:/12148/cb15147433m#foaf:Person]
{/ud}
{ud0}
Jean-François Gerbillon ({dat1654}1654{/dat}) Jésuite. - Mathématicien, fut envoyé en Chine par Louis XIV en 1685. - Écrivit des traités de géométrie et de l''usage de l''astrolabe en chinois et en tartare. - Supérieur général de la Mission française de Chine [http://data.bnf.fr/ark:/12148/cb124622770#foaf:Person]
{/ud}
{ud0}
Philippe Avril ({en0li}Angoulême (Charente){/en}, {dat1654}1654{/dat}) Missionnaire. - Voyageur, jésuite dès 1670, il enseigna les mathématiques à Louis-le-Grand. - Chercha un nouveau passage vers la Chine par la Tartarie, le Kurdistan et l''Arménie [http://data.bnf.fr/ark:/12148/cb15327596q#foaf:Person]
{/ud}
{ud0}
Philippe Naudé ({en0li}Metz{/en}, {dat1654}1654{/dat}) Théologien et mathématicien. - Se réfugia en Prusse après la révocation de l''Édit de Nantes [http://data.bnf.fr/ark:/12148/cb10366497p#foaf:Person]
{/ud}
{ud0}
Pierre Varignon ({en0li}Caen (Calvados){/en}, {dat1654}1654{/dat}) Mathématicien. - Jésuite. - Membre de l''Académie des sciences, il entre au collège de France en 1704 [http://data.bnf.fr/ark:/12148/cb121123302#foaf:Person]
{/ud}
{ud0}
Louis Lecomte ({dat1655}1655{/dat}) Jésuite. - Mathématicien [http://data.bnf.fr/ark:/12148/cb12151496v#foaf:Person]
{/ud}
{ud0}
Simon Tyssot de Patot ({en0li}Londres{/en}, {dat1655}1655{/dat}) Professeur ordinaire de mathématiques à l''École illustre de Deventer (1699-1727 ; professeur extraordinaire dès 1690). - Vécut en France de 1658 environ à 1664, puis aux Pays-Bas [http://data.bnf.fr/ark:/12148/cb11927303t#foaf:Person]
{/ud}
{ud0}
Claude de Visdelou (Erquy (Côtes-d''Armor), {dat1656}1656{/dat}) Jésuite. - Mathématicien. - Missionnaire en Chine. - Évèque titulaire de de Claudiopolis-en-Isaurie (à partir de 1708/1709). - Vicaire apostolique du Koueitchéou et du Yunnan, et administrateu du Houkouang (de 1708 à 1709) [http://data.bnf.fr/ark:/12148/cb150791582#foaf:Person]
{/ud}
{ud0}
Edmund Halley ({dat1656}1656{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb119960783#foaf:Person]
{/ud}
{ud0}
Nicolaas Hartsoeker (Gouda (Pays-Bas), {dat1656}1656{/dat}) Physicien, micrographe et médecin. - Apporta des perfectionnements importants à la fabrication des verres de lunettes astronomiques, découvrit les animalcules spermatiques [http://data.bnf.fr/ark:/12148/cb13010358x#foaf:Person]
{/ud}
{ud0}
William Molyneux ({en0li}Dublin{/en}, {dat1656}1656{/dat}) Mathématicien, astronome, physicien et philosophe. - Premier secrétaire de la Société philosophique de Dublin (en 1684) [http://data.bnf.fr/ark:/12148/cb124596616#foaf:Person]
{/ud}
{ud0}
Jean-Mathieu de Chazelles ({en0li}Lyon{/en}, {dat1657}1657{/dat}) Cartographe, géographe et astronome associé à l''Académie des sciences [http://data.bnf.fr/ark:/12148/cb106281104#foaf:Person]
{/ud}
{ud0}
Jean-Matthieu de Chazelles ({en0li}Lyon{/en}, {dat1657}1657{/dat}) Fit ses études chez les jésuites et devint l''auxiliaire de Cassini I. Fut associé aux travaux géodésiques menés par l''Académie des sciences. Dessina le planisphère de l''Observatoire. Collabora au Neptune françois. Associé astronome de l''Académie des sciences en 1695; associé mécanicien en 1699. Professeur d''hydrographie à Marseille [http://data.bnf.fr/ark:/12148/cb15304334g#foaf:Person]
{/ud}
{ud0}
Joseph Saurin ({en0li}Courthézon (Vaucluse){/en}, {dat1659}1659{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb10330722j#foaf:Person]
{/ud}
{ud0}
Philippe Desplaces ({dat1659}1659{/dat}) Astronome. - Auteur d''éphémérides [http://data.bnf.fr/ark:/12148/cb12223720g#foaf:Person]
{/ud}
{ud0}
Louis Feuillée (Mane (Alpes-de-Haute-Provence), {dat1660}1660{/dat}) Astronome et botaniste. - Religieux de l''ordre des Minimes. - Initié à la botanique par le P. Plumier. Correspondant astronome de l''Académie des sciences, il obtient une mission dans le Levant. Revenu à Marseille en 1702, il embarque l''année suivante pour les Antilles et parvient à Carthagène en 1704. Nommé mathématicien du roi, il s''embarque pour l''Amérique du Sud en 1707. En 1724, il est chargé de déterminer la position exacte de l''île de Fer [http://data.bnf.fr/ark:/12148/cb15309142r#foaf:Person]
{/ud}
{ud0}
Thomas Fantet de Lagny ({en0li}Lyon (Rhône){/en}, {dat1660}1660{/dat}) Mathématicien. - Professeur [http://data.bnf.fr/ark:/12148/cb14548143w#foaf:Person]
{/ud}
{ud0}
Guillaume-François-Antoine de L''Hospital ({dat1661}1661{/dat}) Marquis de Sainte-Mesme. - Mathématicien, membre de l''Académie des sciences [http://data.bnf.fr/ark:/12148/cb12000655c#foaf:Person]
{/ud}
{ud0}
Francesco Bianchini ({en0li}Vérone, Italie{/en}, {dat1662}1662{/dat}) Théologien, historien, astronome et physicien [http://data.bnf.fr/ark:/12148/cb12452255g#foaf:Person]
{/ud}
{ud0}
Paolo Mattia Doria ({dat1662}1662{/dat}) Philosophe et mathématicien italien [http://data.bnf.fr/ark:/12148/cb121118306#foaf:Person]
{/ud}
{ud0}
Jean-Pierre de Crousaz ({dat1663}1663{/dat}) Professeur de philosophie et mathématiques à Lausanne et Groningue. - Conseiller de la légation de Suède en Hollande. - Membre des Académies de Bordeaux et Paris [http://data.bnf.fr/ark:/12148/cb12016566d#foaf:Person]
{/ud}
{ud0}
Johann Balthasar Lauterbach ({dat1663}1663{/dat}) Mathématicien et architecte allemand [http://data.bnf.fr/ark:/12148/cb137778333#foaf:Person]
{/ud}
{ud0}
John Craig ({dat1663}1663{/dat}) Mathématicien et théologien écossais [http://data.bnf.fr/ark:/12148/cb114408210#foaf:Person]
{/ud}
{ud0}
Katahiro Takebe ({dat1664}1664{/dat}) Mathématicien japonais [http://data.bnf.fr/ark:/12148/cb12443517s#foaf:Person]
{/ud}
{ud0}
Lothar Zumbach von Coesfeld ({en0li}Trèves (Allemagne){/en}, {dat1664}1664{/dat}) Mathématicien, astronome, médecin, musicien. - Mathématicien et musicien de l''électeur de Trèves (1685-1688). - Lecteur en astronomie à l''université de Leyde. - Professeur de mathématiques au Carolinum de Kassel [http://data.bnf.fr/ark:/12148/cb14853628w#foaf:Person]
{/ud}
{ud0}
Abraham de Moivre (Vitry-le-François ({en0li}Marne){/en}, {dat1667}1667{/dat}) Mathématicien. - Émigra en Grande-Bretagne après la révocation de l''Édit de Nantes (en 1686). - Membre de la Royal Society, de l''Académie de Berlin et de l''Académie de Saint-Pétersbourg [http://data.bnf.fr/ark:/12148/cb130110001#foaf:Person]
{/ud}
{ud0}
Girolamo Saccheri ({en0li}San Remo, Italie{/en}, {dat1667}1667{/dat}) Jésuite. - Professeur de mathématiques [http://data.bnf.fr/ark:/12148/cb13164455b#foaf:Person]
{/ud}
{ud0}
Johann Bernoulli ({en0li}Bâle, Suisse{/en}, {dat1667}1667{/dat}) Mathématicien et physicien, maître d''Euler, professeur à l''Université de Groningue puis à l''Université de Bâle. - A travaillé sur le calcul différentiel, intégral et exponentiel. - Également auteur de traités de médecine, fondateur de la théorie mécanico-physique de la fermentation [http://data.bnf.fr/ark:/12148/cb122991692#foaf:Person]
{/ud}
{ud0}
William Whiston (Norton-juxta-Twycross (G. B.), {dat1667}1667{/dat}) Théologien et astronome. - Professeur de mathématiques à Cambridge, d''où il fut exclu pour ses écrits théologiques. - Traducteur de Flavius Josèphe [http://data.bnf.fr/ark:/12148/cb11997914k#foaf:Person]
{/ud}
{ud0}
Guillaume Bonjour (Toulouse (Haute-Garonne), {dat1669}1669{/dat}) Augustin. - Missionnaire en Chine. - Orientaliste, astronome et cartographe [http://data.bnf.fr/ark:/12148/cb13613529n#foaf:Person]
{/ud}
{ud0}
Leonhard Christoph Sturm ({en0li}Aldorf, Allemagne{/en}, {dat1669}1669{/dat}) Mathématicien. - Architecte [http://data.bnf.fr/ark:/12148/cb143383238#foaf:Person]
{/ud}
{ud0}
Jean Terrasson ({en0li}Lyon{/en}, {dat1670}1670{/dat}) Oratorien, mathématicien et philosophe. - Professeur de grec et latin au Collège de France. - Membre de l''Institut, Académie Française (élu en 1732) [http://data.bnf.fr/ark:/12148/cb119262217#foaf:Person]
{/ud}
{ud0}
Guido Grandi ({en0li}Crémone, Italie{/en}, {dat1671}1671{/dat}) Mathématicien, théologien, biographe, antiquaire et poète. - Soutint Descartes contre l''aristotélisme. - Professeur de philosophie à l''Université de Pise. - Fut en correspondance avec Leibniz, Newton, Bernoulli. - Intendant général des eaux en Toscane [http://data.bnf.fr/ark:/12148/cb121384290#foaf:Person]
{/ud}
{ud0}
Johann Gabriel Doppelmayr ({dat1671}1671{/dat}) Fils d''un riche négociant qui s''occupait de physique, et destiné d''abord à l''étude du droit, il la quitta pour celle des mathématiques et voyagea jusqu''en 1702. Professeur à Nuremberg et membre de la Royal Society de Londres [http://data.bnf.fr/ark:/12148/cb15327296w#foaf:Person]
{/ud}
{ud0}
Johann Gabriel Doppelmayr ({dat1671}1671{/dat}) Mathématicien. - Membre de la Royal Society de Londres ({dat1713}1713{/dat}) [http://data.bnf.fr/ark:/12148/cb12158680q#foaf:Person]
{/ud}
{ud0}
Johann Gabriel Doppelmayr ({dat1671}1671{/dat}) Astronome et cartographe ayant véçu à Nuremberg, né en 1671 ou 1677 [http://data.bnf.fr/ark:/12148/cb15327296w#foaf:Person]
{/ud}
{ud0}
Johann Heinrich Müller ({dat1671}1671{/dat}) Physicien, astronome, mathématicien. - Professeur à l''université d''Altdorf (Allemagne) [http://data.bnf.fr/ark:/12148/cb10706008k#foaf:Person]
{/ud}
{ud0}
John Keill ({dat1671}1671{/dat}) Mathématicien écossais. - Professeur d''astronomie à Oxford [http://data.bnf.fr/ark:/12148/cb123670586#foaf:Person]
{/ud}
{ud0}
Étienne-Simon de Gamaches ({dat1672}1672{/dat}) Astronome et moraliste. - Chanoine de Sainte Croix de La Bretonnerie. - Membre de l''Académie des sciences [http://data.bnf.fr/ark:/12148/cb12004341t#foaf:Person]
{/ud}
{ud0}
Johann Jacob Scheuchzer ({en0li}Zürich{/en}, {dat1672}1672{/dat}) Médecin, naturaliste, historien, archéologue, numismate, astronome et physicien [http://data.bnf.fr/ark:/12148/cb123955592#foaf:Person]
{/ud}
{ud0}
Eustachio Manfredi ({dat1674}1674{/dat}) Astronome. - Poète. - Fondateur de l''Académie de Bologne [http://data.bnf.fr/ark:/12148/cb12202194q#foaf:Person]
{/ud}
{ud0}
Julien Mahuet ({dat1674}1674{/dat}) Jésuite. - Né à Reims. Entre au noviciat le 24 août 1692. Enseigne les humanités à Reims, la rhétorique à Metz et les mathématiques à Reims. - Écrit du théâtre pour le Collège de Reims [http://data.bnf.fr/ark:/12148/cb13165624v#foaf:Person]
{/ud}
{ud0}
Guillaume Delisle ({dat1675}1675{/dat}) Cartographe. - Fils de Claude Delisle, fut l''élève de Jean-Dominique Cassini. Élève astronome à l''Académie des sciences en 1702, il en devint membre en 1718 ; enseigna la géographie au jeune Louis XV et fut nommé premier géographe du roi ; produisit quelque 100 cartes qu''il édita lui-même [http://data.bnf.fr/ark:/12148/cb15238363g#foaf:Person]
{/ud}
{ud0}
Humphry Ditton (Salisbury (G. B.), {dat1675}1675{/dat}) Mathématicien et théologien [http://data.bnf.fr/ark:/12148/cb15994181b#foaf:Person]
{/ud}
{ud0}
Yves-Marie André ({dat1675}1675{/dat}) Jésuite. - Professeur de mathématiques à Caen [http://data.bnf.fr/ark:/12148/cb12180932c#foaf:Person]
{/ud}
{ud0}
Jacopo Francesco Riccati ({dat1676}1676{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb120689750#foaf:Person]
{/ud}
{ud0}
Gabriel Philippe de La Hire ({en0li}Paris{/en}, {dat1677}1677{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb106522995#foaf:Person]
{/ud}
{ud0}
Jacques Cassini ({en0li}Paris{/en}, {dat1677}1677{/dat}) Fils de Jean-Dominique Cassini et père de César-François Cassini de Thury. Associé astronome à l''Académie des sciences en 1699, pensionnaire en 1712. En 1700 participa à la mesure de la méridienne de l''Observatoire et y travailla jusqu''à son achèvement en 1718. En 1706 maître ordinaire à la Chambre des comptes. Etudia les planètes et leurs satellites. Soutint la thèse de l''allongement de la Terre aux pôles. [http://data.bnf.fr/ark:/12148/cb15238366h#foaf:Person]
{/ud}
{ud0}
Joseph Privat de Molières (Tarascon (ouches-du-Rhône), {dat1677}1677{/dat}) Physicien et mathématicien. - Oratorien (vers 1709). - Professeur au collège royal ({dat1723}1723{/dat}). - Adjoint ({dat1721}1721{/dat}) puis associé ({dat1729}1729{/dat}) de l''Académie royale des sciences [http://data.bnf.fr/ark:/12148/cb145391041#foaf:Person]
{/ud}
{ud0}
Gerard Keulen ({dat1678}1678{/dat}) Graveur, cartographe, mathématicien et éditeur. - Fils de Johannes van Keulen [http://data.bnf.fr/ark:/12148/cb15332761m#foaf:Person]
{/ud}
{ud0}
Jacob Hermann ({dat1678}1678{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb12319998c#foaf:Person]
{/ud}
{ud0}
Jean-Jacques Dortous de Mairan ({en0li}Béziers{/en}, {dat1678}1678{/dat}) Physicien et mathématicien. - Membre puis secrétaire perpétuel de l''Académie des sciences. - Membre de l''Académie française (élu en 1743) [http://data.bnf.fr/ark:/12148/cb12395086k#foaf:Person]
{/ud}
{ud0}
Louis Bourguet ({en0li}Nïmes{/en}, {dat1678}1678{/dat}) Professeur de philosophie et de mathématiques à Neuchâtel. - Est l''un des fondateurs de la "Bibliothèque italique" (1728-) et du "Mercure suisse" (1732-). - Naturalisé Neuchâtelois en 1710 [http://data.bnf.fr/ark:/12148/cb12797692b#foaf:Person]
{/ud}
{ud0}
Pierre Rémond de Montmort ({en0li}Paris{/en}, {dat1678}1678{/dat}) Mathématicien. - Spécialiste de probabilités [http://data.bnf.fr/ark:/12148/cb12391046c#foaf:Person]
{/ud}
{ud0}
Bernardino Zendrini ({en0li}Saviore, Italie{/en}, {dat1679}1679{/dat}) Médecin. - Mathématicien. - Hydraulicien [http://data.bnf.fr/ark:/12148/cb13545066d#foaf:Person]
{/ud}
{ud0}
Christian Wolff ({en0li}Breslau, Silésie (Wrocław, Pologne){/en}, {dat1679}1679{/dat}) Juriste, mathématicien et philosophe [http://data.bnf.fr/ark:/12148/cb121387859#foaf:Person]
{/ud}
{ud0}
Firmin Abauzit ({en0li}Uzès{/en}, {dat1679}1679{/dat}) Mathématicien, philosophe et bibliothécaire. - Fut bibliothécaire à la Bibliothèque de Genève. - Vécut à Genève après la révocation de l''Édit de Nantes [http://data.bnf.fr/ark:/12148/cb121711117#foaf:Person]
{/ud}
{ud0}
Claude Richer ({dat1680}1680{/dat}) Abbé. - Mathématicien [http://data.bnf.fr/ark:/12148/cb12532604f#foaf:Person]
{/ud}
{ud0}
Pierre Jartoux ({dat1680}1680{/dat}) Astronome et missionnaire jésuite en Chine [http://data.bnf.fr/ark:/12148/cb15367486z#foaf:Person]
{/ud}
{ud0}
Paolino Chelucci ({en0li}Lucca, Italie{/en}, {dat1681}1681{/dat}) Professeur d''éloquence à l''Université de Rome. - Mathématicien [http://data.bnf.fr/ark:/12148/cb104300443#foaf:Person]
{/ud}
{ud0}
Roger Cotes ({en0li}Burbage (Leicestershire){/en}, {dat1682}1682{/dat}) Mathématicien. - Professeur d''astronomie et de philosophie expérimentale au Trinity College, Cambridge (1707-). - A édité la seconde édition des "Principia" de Newton [http://data.bnf.fr/ark:/12148/cb123946202#foaf:Person]
{/ud}
{ud0}
Noël Regnault ({dat1683}1683{/dat}) Jésuite. - Professeur de mathématiques et physique au collège de Paris [http://data.bnf.fr/ark:/12148/cb12218681d#foaf:Person]
{/ud}
{ud0}
Johann Matthias Hase ({dat1684}1684{/dat}) Géographe et cartographe ; historien. - Mathématicien [http://data.bnf.fr/ark:/12148/cb13007561v#foaf:Person]
{/ud}
{ud0}
Brook Taylor ({dat1685}1685{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb12315365s#foaf:Person]
{/ud}
{ud0}
Giovanni Poleni ({en0li}Venise, Italie{/en}, {dat1685}1685{/dat}) Physicien, mathématicien et archéologue [http://data.bnf.fr/ark:/12148/cb12161210z#foaf:Person]
{/ud}
{ud0}
Jean-Edme Gallimard ({en0li}Paris{/en}, {dat1685}1685{/dat}) Professeur de mathématiques [http://data.bnf.fr/ark:/12148/cb120827146#foaf:Person]
{/ud}
{ud0}
Jai Singh ({en0li}Amber (Rajasthan, Inde){/en}, {dat1686}1686{/dat}) Mahārāja de Jaipur (Rajasthan, Inde) de 1699 à 1743. - Fondateur de la ville de Jaipur (en 1727). - Chef du clan rajput des Kachhwa. - Bâtisseur de cinq observatoires astronomiques (yantra) dans l''Inde du Nord, à Delhi, Jaipur, Mathura, Varanasi et Ujjain. - Publia des tables astronomiques. - Les dates biographiques (1688-1743) sont aussi parfois retenues [http://data.bnf.fr/ark:/12148/cb16578505b#foaf:Person]
{/ud}
{ud0}
Nicolas Bernoulli ({dat1687}1687{/dat}) Mathématicien et juriste suisse [http://data.bnf.fr/ark:/12148/cb13510346s#foaf:Person]
{/ud}
{ud0}
Robert Simson ({dat1687}1687{/dat}) Mathématicien. - A été professeur à l''Université de Glasgow, GB [http://data.bnf.fr/ark:/12148/cb12399224j#foaf:Person]
{/ud}
{ud0}
Joseph-Nicolas Delisle ({en0li}Paris{/en}, {dat1688}1688{/dat}) Astronome. - Il reçut l''enseignement de Cassini II. - Professeur de mathématiques au Collège de France et géographe de la marine. - Membre de l''Institut, Académie des sciences ({dat1714}1714{/dat}). - Fondateur de l''École d''astronomie de Saint-Pétersbourg (à partir de 1725), a séjourné en Russie jusqu''en 1747 [http://data.bnf.fr/ark:/12148/cb12150746w#foaf:Person]
{/ud}
{ud0}
Louis-Bertrand Castel ({en0li}Montpellier{/en}, {dat1688}1688{/dat}) Jésuite ({dat1703}1703{/dat}). - Philosophe et mathématicien [http://data.bnf.fr/ark:/12148/cb12462543h#foaf:Person]
{/ud}
{ud0}
Pierre Brumoy ({en0li}Rouen{/en}, {dat1688}1688{/dat}) Jésuite en 1704. - Professeur de rhétorique à Caen, précepteur du prince de Talmont, professeur de mathématiques au collège de Louis-le-Grand à Paris. - Collabore au Journal de Trévoux de 1722 à 1739. - Littérateur [http://data.bnf.fr/ark:/12148/cb12069382v#foaf:Person]
{/ud}
{ud0}
Willem Jacob''s Gravesande ({dat1688}1688{/dat}) Physicien. - Philosophe. - Professeur de mathématique et astronomie à Leyde, Pays-Bas. - Éditeur du "Journal littéraire de la Haye", devenu "Journal de la République des Lettres" [http://data.bnf.fr/ark:/12148/cb12218384m#foaf:Person]
{/ud}
{ud0}
Antoine Gaubil ({en0li}Gaillac (Aveyron){/en}, {dat1689}1689{/dat}) Jésuite et missionnaire en Chine. - Établit un observatoire à Pékin, dans la résidence française. - Écrit sur l''astronomie, la géographie, l''histoire et la littérature de la Chine [http://data.bnf.fr/ark:/12148/cb12150997b#foaf:Person]
{/ud}
{ud0}
Giovanni Gaetano Bottari ({en0li}Rome{/en}, {dat1689}1689{/dat}) Savant prélat. - A étudié les langues et la littérature de l''Antiquité, les mathématiques, la philosophie et la théologie. - Membre de l''Académie della Crusca. - Conservateur de la bibliothèque du Vatican [http://data.bnf.fr/ark:/12148/cb12516784r#foaf:Person]
{/ud}
{ud0}
Robert Smith ({en0li}Lea, GB{/en}, {dat1689}1689{/dat}) Professeur de mathématiques et de philosophie naturelle à Cambridge [http://data.bnf.fr/ark:/12148/cb15075770m#foaf:Person]
{/ud}
{ud0}
Christian Goldbach ({dat1690}1690{/dat}) Mathématicien allemand [http://data.bnf.fr/ark:/12148/cb124384045#foaf:Person]
{/ud}
{ud0}
Johann Friedrich Weidler (Gros-Neuhausen, Allemagne, {dat1691}1691{/dat}) Écrivain, mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb151541516#foaf:Person]
{/ud}
{ud0}
Esprit Pezenas ({en0li}Avignon{/en}, {dat1692}1692{/dat}) Jésuite. - Astronome et mathématicien. - Professeur d''hydrographie à Marseille et directeur de l''Observatoire de Marseille ({dat1749}1749{/dat}) [http://data.bnf.fr/ark:/12148/cb12120600p#foaf:Person]
{/ud}
{ud0}
James Stirling ({en0li}Garden, GB{/en}, {dat1692}1692{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb13475586v#foaf:Person]
{/ud}
{ud0}
Petrus Van Musschenbroek ({dat1692}1692{/dat}) Physicien, docteur en médecine et en philosophie. - Fut l''inventeur de la pyrométrie. - Fut professeur de philosophie naturelle, de mathématiques et d''astronomie à l''Université d''Utrecht, puis professeur à Leiden [http://data.bnf.fr/ark:/12148/cb13475113j#foaf:Person]
{/ud}
{ud0}
Diego de Torres Villarroel ({dat1693}1693{/dat}) Prêtre catholique. - Homme de lettres. - Professeur de mathématiques à l''université de Salamanque [http://data.bnf.fr/ark:/12148/cb119268467#foaf:Person]
{/ud}
{ud0}
Giovanni Bianchi ({en0li}Rimini (Italie){/en}, {dat1693}1693{/dat}) Médecin. - Professeur d''anatomie à l''Université de Sienne (1741-). - Auteur d''ouvrages médicaux, archéologiques, astronomiques, etc. [http://data.bnf.fr/ark:/12148/cb10649342z#foaf:Person]
{/ud}
{ud0}
Christfried Kirch ({dat1694}1694{/dat}) Astronome allemand. - Il succéda à son père Gottfried (1639-1710) dans la direction de l''Observatoire royal de Prusse (1716-1740). - Membre de l''Académie des sciences de Berlin ({dat1716}1716{/dat}) et associé de celles de Paris ({dat1723}1723{/dat}) et de Saint-Pétersbourg [http://data.bnf.fr/ark:/12148/cb12648455m#foaf:Person]
{/ud}
{ud0}
Dominique-François Rivard ({dat1697}1697{/dat}) Mathématicien. - Philosophe. - Professeur au collège de Beauvais [http://data.bnf.fr/ark:/12148/cb119220838#foaf:Person]
{/ud}
{ud0}
Abbé Deidier ({en0li}Marseille{/en}, {dat1698}1698{/dat}) Abbé. - Mathématicien. - Professeur d''artillerie à l''Ecole militaire de La Fère [http://data.bnf.fr/ark:/12148/cb102670411#foaf:Person]
{/ud}
{ud0}
Colin MacLaurin ({en0li}Kilmodan, GB{/en}, {dat1698}1698{/dat}) Mathématicien et physicien [http://data.bnf.fr/ark:/12148/cb12534513m#foaf:Person]
{/ud}
{ud0}
Pierre-Louis Moreau de Maupertuis (Saint-Malo, Ille-et-Villaine, {dat1698}1698{/dat}) Philosophe, astronome et physicien. - Fut invité par Frédéric II à réorganiser puis présider l''Académie de Berlin. - Ami puis ennemi de Voltaire, qui écrivit contre lui "Micromégas". - Membre de l''Académie française (élu en 1743) [http://data.bnf.fr/ark:/12148/cb11915229j#foaf:Person]
{/ud}
{ud0}
Charles-Étienne-Louis Camus (Crécy-en-Brie (Seine-et-Marne), {dat1699}1699{/dat}) Mathématicien. - Astronome. - Participa à l''expédition de 1736 en Laponie. - Membre de l''Académie des sciences ({dat1727}1727{/dat}) et de l''Académie d''architecture ({dat1739}1739{/dat}) [http://data.bnf.fr/ark:/12148/cb12181030f#foaf:Person]
{/ud}
{ud0}
Johann Ludwig Levin Gebhardi ({en0li}Braunschweig, Allemagne{/en}, {dat1699}1699{/dat}) Historien, professeur de philologie à l''académie équestre de Lüneburg ({dat1723}1723{/dat}). - Mathématicien [http://data.bnf.fr/ark:/12148/cb143273694#foaf:Person]
{/ud}
{ud0}
Daniel Bernoulli (Groningue (Pays-Bas), {dat1700}1700{/dat}) Mathématicien, physicien et astronome. - Fut professeur à Saint-Petersbourg (1725-1733) et à Bâle (1733-) [http://data.bnf.fr/ark:/12148/cb122991859#foaf:Person]
{/ud}
{ud0}
Sámuel Mikoviny ({en0li}Ábelfalva, aujourd''hui Ábelová, Slovaquie{/en}, {dat1700}1700{/dat}) Cartographe. - Officier du génie. - Spécialiste en hydraulique. - Mathématicien. - Disciple de Bél Mátyás (1684-1749). - Études à Jena et à Nuremberg, Allemagne [http://data.bnf.fr/ark:/12148/cb103650124#foaf:Person]
{/ud}
{ud0}
Anders Celsius ({dat1701}1701{/dat}) Astronome et naturaliste. - Professeur d''astronomie à l''université d''Uppsala ({dat1730}1730{/dat}) [http://data.bnf.fr/ark:/12148/cb14606035v#foaf:Person]
{/ud}
{ud0}
Charles-Marie de La Condamine ({en0li}Paris{/en}, {dat1701}1701{/dat}) Savant. - Astronome. - Géographe. Mesura l''arc du Méridien avec Godin et Bouguer. - Membre de l''Académie française (élu en 1760) [http://data.bnf.fr/ark:/12148/cb119102567#foaf:Person]
{/ud}
{ud0}
Georg Wolfgang Krafft ({en0li}Tuttlingen (Allemagne){/en}, {dat1701}1701{/dat}) Physicien, professeur de mathématiques et de physique [http://data.bnf.fr/ark:/12148/cb10587905k#foaf:Person]
{/ud}
{ud0}
Johannes Nicolaus Frobesius ({en0li}Goslar, Allemagne{/en}, {dat1701}1701{/dat}) Mathématicien et professeur de philosophie [http://data.bnf.fr/ark:/12148/cb12355199c#foaf:Person]
{/ud}
{ud0}
Niccolò de Martino ({dat1701}1701{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb16265590z#foaf:Person]
{/ud}
{ud0}
Johann Lorenz Schmidt ({dat1702}1702{/dat}) Fils de pasteur, a étudié la théologie et s''est intéressé à la  philosophie et aux mathématiques. - A publié en 1735 une traduction annotée de la première partie de la Bible, les cinq livres de Moïse (ou Torah ou Pentateuque), connue sous le nom de "Wertheimer Bible", laquelle a été censurée par l''empereur [http://data.bnf.fr/ark:/12148/cb150701237#foaf:Person]
{/ud}
{ud0}
Antoine Deparcieux ({dat1703}1703{/dat}) Mathématicien et statisticien. - Fut constructeur de cadrans solaires et inventeur de machines pour élever les eaux et de presse pour le tabac. - Membre de l''Académie des sciences ({dat1746}1746{/dat}) [http://data.bnf.fr/ark:/12148/cb121904326#foaf:Person]
{/ud}
{ud0}
Bernard-Laurent Soumille ({dat1703}1703{/dat}) Mathématicien, physicien et agronome. - Prêtre-bénéficier du chapitre de Villeneuve-lès-Avignon (à partir de 1736, environ). - Correspondant de l''Académie royale des sciences de Paris [http://data.bnf.fr/ark:/12148/cb130919156#foaf:Person]
{/ud}
{ud0}
Thomas Le Seur ({dat1703}1703{/dat}) Franciscain. - Professeur de mathématique à l''Université de la Sapience (Rome) [http://data.bnf.fr/ark:/12148/cb155933751#foaf:Person]
{/ud}
{ud0}
Gabriel Cramer ({en0li}Genève, Suisse{/en}, {dat1704}1704{/dat}) Professeur de philosophie et de mathématiques des Académies et Sociétés royales de Londres, de Berlin, de Montpellier, de Lyon et de l''Académie de l''Institut de Bologne [http://data.bnf.fr/ark:/12148/cb15006804w#foaf:Person]
{/ud}
{ud0}
Guillaume Le Blond ({en0li}Paris{/en}, {dat1704}1704{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb14330967m#foaf:Person]
{/ud}
{ud0}
Henri Michel Sauvage ({en0li}Verdun{/en}, {dat1704}1704{/dat}) Jésuite. - Professeur d''humanités, de mathématiques et de philosophie [http://data.bnf.fr/ark:/12148/cb16180102s#foaf:Person]
{/ud}
{ud0}
Jacopo Belgrado ({dat1704}1704{/dat}) Jésuite. - Physicien, mathématicien et archéologue [http://data.bnf.fr/ark:/12148/cb12161284h#foaf:Person]
{/ud}
{ud0}
Johann Andreas von Segner ({dat1704}1704{/dat}) Naturaliste, mathématicien, médecin, logicien, philosophe. - Né à Presbourg (l''actuelle Bratislava), il fit toute sa carrière en Allemagne (à Iéna, Göttingen, Halle notamment) [http://data.bnf.fr/ark:/12148/cb12316478n#foaf:Person]
{/ud}
{ud0}
Louis Godin ({en0li}Paris{/en}, {dat1704}1704{/dat}) Astronome, membre de l''Académie des sciences [http://data.bnf.fr/ark:/12148/cb15004534h#foaf:Person]
{/ud}
{ud0}
John Nourse ({dat1705}1705{/dat}) Variante(s) de prénom : Jean. - Libraire ; libraire (ordinaire) de Sa Majesté ({dat1762}1762{/dat}) ; libraire de la "Society for the Encouragement of learning". - Baptisé à Oxford le 8 juillet 1705 ; fils d''un chirurgien. En apprentissage chez le libraire de Londres John I Osborne d''août 1722 à oct. 1729. Établi vers 1730. Succède au libraire William Mears après lui avoir été associé. Spécialiste des publications scientifiques, particulièrement de mathématiques, et des éditions étrangères, de philosophes notamment. Séjourne à Paris en 1780. Décédé à Kensington en avril 1765. Son frère Charles Nourse puis Francis Wingrave lui succèdent [http://data.bnf.fr/ark:/12148/cb13605346z#foaf:Person]
{/ud}
{ud0}
Edme-Gilles Guyot ({en0li}Paris{/en}, {dat1706}1706{/dat}) Les ouvrages "Nouvelles récréations physiques et mathématiques" et "Essai sur la construction des ballons aérostatiques et sur la manière de les diriger" lui sont attribués par Hoefer et Quérard. - DBF et Michaud soulignent la confusion entre lui et Guillaume-Germain Guyot pour l''attribution de ces ouvrages [http://data.bnf.fr/ark:/12148/cb14651894d#foaf:Person]
{/ud}
{ud0}
Girolamo Settimo ({dat1706}1706{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb162655930#foaf:Person]
{/ud}
{ud0}
Giuseppe Maria Asclepi ({dat1706}1706{/dat}) Jésuite, enseigna les mathématiques et les humanités [http://data.bnf.fr/ark:/12148/cb12240755t#foaf:Person]
{/ud}
{ud0}
Benjamin Robins ({en0li}Bath, GB{/en}, {dat1707}1707{/dat}) Mathématicien et ingénieur militaire. - Pamphlétaire [http://data.bnf.fr/ark:/12148/cb121289860#foaf:Person]
{/ud}
{ud0}
Francesco Ottavio Magnocavalli ({en0li}Casale, Italie{/en}, {dat1707}1707{/dat}) Architecte, mathématicien et poète [http://data.bnf.fr/ark:/12148/cb10732099c#foaf:Person]
{/ud}
{ud0}
Jean Paul Grandjean de Fouchy ({en0li}Paris{/en}, {dat1707}1707{/dat}) Astronome. - Secrétaire perpétuel de l''Académie des Sciences ({dat1743}1743{/dat}) [http://data.bnf.fr/ark:/12148/cb10667779b#foaf:Person]
{/ud}
{ud0}
José Quiroga ({dat1707}1707{/dat}) Jésuite, mathématicien et pilote [http://data.bnf.fr/ark:/12148/cb12570261h#foaf:Person]
{/ud}
{ud0}
Leonhard Euler ({en0li}Bâle (Suisse){/en}, {dat1707}1707{/dat}) Mathématicien et physicien. - Philosophe, théologien et orientaliste. - Membre de l''Académie des sciences de Saint-Pétersbourg (à partir de 1733) et de celle de Berlin (à partir de 1741), et membre associé de celle de Paris (à partir de 1755) [http://data.bnf.fr/ark:/12148/cb12157666x#foaf:Person]
{/ud}
{ud0}
Giovanni Francesco Mauro Melchior Salvemini da Castiglione ({dat1708}1708{/dat}) Professeur de mathématiques à Utrecht ({dat1751}1751{/dat}) puis directeur de la classe de mathématiques de l''Académie de Berlin. - Découvrit la solution du problème consistant à inscrire dans un cercle un triangle dont les côtés passent par trois points donnés [http://data.bnf.fr/ark:/12148/cb130145422#foaf:Person]
{/ud}
{ud0}
Eustachio Zanotti ({en0li}Bologne, Italie{/en}, {dat1709}1709{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb12202196d#foaf:Person]
{/ud}
{ud0}
Giordano Riccati ({en0li}Castelfranco Veneto, Italie{/en}, {dat1709}1709{/dat}) Comte. - Mathématicien, acousticien et théoricien de la musique. - Fut aussi physicien et architecte [http://data.bnf.fr/ark:/12148/cb12252383n#foaf:Person]
{/ud}
{ud0}
Georg Matthias Bose ({en0li}Leipzig (Allemagne){/en}, {dat1710}1710{/dat}) Astronome, physicien, mathématicien. - Professeur de physique à l''université de Wittenberg [http://data.bnf.fr/ark:/12148/cb14065311n#foaf:Person]
{/ud}
{ud0}
Jacques Audierne ({dat1710}1710{/dat}) Auteur comique et mathématicien [http://data.bnf.fr/ark:/12148/cb10425836p#foaf:Person]
{/ud}
{ud0}
Johann Bernoulli ({dat1710}1710{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb14852857s#foaf:Person]
{/ud}
{ud0}
Thomas Simpson ({dat1710}1710{/dat}) Membre de la société royale de Londres, professeur de mathématiques à Woolwich (en 1755) [http://data.bnf.fr/ark:/12148/cb103759851#foaf:Person]
{/ud}
{ud0}
Alexandre-Gui Pingré ({en0li}Paris{/en}, {dat1711}1711{/dat}) Génovéfain. - Astronome. - Correspondant (à partir de 1753), puis associé libre de l''Académie des sciences. - Géographe de la Marine. - Chancelier de l''Université de Paris (1769-17..). - Bibliothécaire de Sainte-Geneviève (à partir de 1792) [http://data.bnf.fr/ark:/12148/cb12151017m#foaf:Person]
{/ud}
{ud0}
François Jacquier (Vitry-le-François ({en0li}Marne){/en}, {dat1711}1711{/dat}) Religieux de l''ordre des Minimes. - Professeur de physique et mathématiques [http://data.bnf.fr/ark:/12148/cb12198105d#foaf:Person]
{/ud}
{ud0}
Laura Bassi ({en0li}Bologne, Italie{/en}, {dat1711}1711{/dat}) Mathématicienne et physicienne. - Professeur de biologie et de physique à l''Université de Bologne. - Première femme titulaire d''une chaire universitaire en Europe [http://data.bnf.fr/ark:/12148/cb135103950#foaf:Person]
{/ud}
{ud0}
Ottaviano Cametti ({en0li}Gattinara, Italie{/en}, {dat1711}1711{/dat}) Mathématicien, physicien et historien [http://data.bnf.fr/ark:/12148/cb10464765k#foaf:Person]
{/ud}
{ud0}
Pierre Joseph de Rivaz ({dat1711}1711{/dat}) Mathématicien, inventeur-mécanicien et historien. - Directeur des salines de Moutiers. - Né dans le Valais et mort à Moutiers (Tarentaise) [http://data.bnf.fr/ark:/12148/cb128398731#foaf:Person]
{/ud}
{ud0}
Rugerius Josephus Boscovich (Raguse aujourd''hui Dubrovnik ({en0li}Croatie){/en}, {dat1711}1711{/dat}) Jésuite. - Physicien, mathématicien, astronome et philosophe. - Professeur de mathématiques à Rome, Pavie et Milan. - Directeur de l''optique de la Marine royale à Paris et membre de la "Royal Society" à Londres. - Dans son ouvrage majeur "Théorie de la philosophie naturelle" il élabore la théorie initiale des forces et de la structure fondamentale de la matière, dont les concepts ont trouvé écho dans les découvertes de la physique moderne. - Il publie nombre d''ouvrages contenant ses découvertes en mathématiques, en astronomie, en géophysique et en archéologie. - Il mit au point différents instruments optiques, astronomiques et géodésiques et réalisa des expertises et des mesures hydrotechniques, géodésiques, cartographiques et statiques. - Il consolida la coupole de la basilique Saint-Pierre de Rome et de la flèche de la cathédrale de Milan [http://data.bnf.fr/ark:/12148/cb12054879x#foaf:Person]
{/ud}
{ud0}
Jean-Paul de Gua de Malves ({en0li}Malves (Aude){/en}, {dat1712}1712{/dat}) Abbé. - Mathématicien, géomètre, économiste politique. - Titulaire de la chaire de philosophie au Collège de France (1742-1749) [http://data.bnf.fr/ark:/12148/cb15325204x#foaf:Person]
{/ud}
{ud0}
Samuel König ({dat1712}1712{/dat}) Date de mort : 21 août ou 22 juillet 1757. - A également écrit en français. - Mathématicien, philosophe et juriste [http://data.bnf.fr/ark:/12148/cb120941298#foaf:Person]
{/ud}
{ud0}
Alexis Claude Clairaut ({en0li}Paris (France){/en}, {dat1713}1713{/dat}) Mathématicien très précoce et astronome. - Ami de Voltaire et de la marquise Du Chatelet [http://data.bnf.fr/ark:/12148/cb124002538#foaf:Person]
{/ud}
{ud0}
Giammaria Ortes ({dat1713}1713{/dat}) Moine camaldule. - Mathématicien, économiste et philosophe [http://data.bnf.fr/ark:/12148/cb13753557w#foaf:Person]
{/ud}
{ud0}
Nicolas-Louis de La Caille ({en0li}Rumigny, Ardennes{/en}, {dat1713}1713{/dat}) Abbé. - Professeur de mathématiques au Collège Mazarin. - Membre de l''Académie royale des sciences [http://data.bnf.fr/ark:/12148/cb12124353d#foaf:Person]
{/ud}
{ud0}
Alessandro Vittorio Papacino d''Antoni ({en0li}Villafranca, Italie{/en}, {dat1714}1714{/dat}) Ingénieur, mathématicien. - Membre de l''Académie des sciences de Turin [http://data.bnf.fr/ark:/12148/cb10709482t#foaf:Person]
{/ud}
{ud0}
César-François Cassini de Thury (Thury-sous-Clermont ({en0li}Oise){/en}, {dat1714}1714{/dat}) Astronome et géomètre. - Membre de l''Académie des sciences ({dat1736}1736{/dat}). - Fils de Jacques Cassini (1677-1756) et père de Jean-Dominique Cassini (1748-1845). - Participa avec son père à la mesure de la perpendiculaire de l''Observatoire. - Son oeuvre principale est la carte de France, première carte de base de ce pays, dont la publication commença en 1756 [http://data.bnf.fr/ark:/12148/cb12241101g#foaf:Person]
{/ud}
{ud0}
Giovanni Battista Audiffredi ({en0li}Saorge, Italie{/en}, {dat1714}1714{/dat}) Dominicain. - Astronome. - Préfet de la Biblioteca Casanatense, Rome (1759-1794). - Né Giulio Cesare Audiffredi, change de prénom en entrant chez les Dominicains ({dat1730}1730{/dat}) [http://data.bnf.fr/ark:/12148/cb13595556h#foaf:Person]
{/ud}
{ud0}
John Winthrop ({dat1714}1714{/dat}) Professeur de Mathématiques et de Philosophie naturelle à Harvard [http://data.bnf.fr/ark:/12148/cb14594660x#foaf:Person]
{/ud}
{ud0}
François-Joachim Duport-Dutertre (Saint-Servan (Ille-et-Vilaine), {dat1715}1715{/dat}) Littérateur. - Mathématicien. - Voyageur [http://data.bnf.fr/ark:/12148/cb12533121w#foaf:Person]
{/ud}
{ud0}
Pierre-Charles Le Monnier ({en0li}Paris{/en}, {dat1715}1715{/dat}) Astronome. - Membre de l''Académie des sciences ({dat1741}1741{/dat}). - Professeur de physique au Collège de France (de 1749 à 1793), puis membre de la classe des sciences physiques et mathématiques de l''Institut [http://data.bnf.fr/ark:/12148/cb121064574#foaf:Person]
{/ud}
{ud0}
André-Pierre Le Guay de Prémontval (Charenton (Val-de-Marne), {dat1716}1716{/dat}) Professeur de mathématiques. - Membre de l''Académie de Berlin [http://data.bnf.fr/ark:/12148/cb122271303#foaf:Person]
{/ud}
{ud0}
Eugénios Voúlgaris ({en0li}Corfou (Îles Ioniennes, Grèce){/en}, {dat1716}1716{/dat}) Métropolite de l''Église orthodoxe grecque. - Théologien, philosophe et mathématicien. - "Éducateur de la Nation" et précurseur des Lumières en Grèce ; traducteur de Voltaire et Virgile. - Nommé évêque en Russie [http://data.bnf.fr/ark:/12148/cb12564304q#foaf:Person]
{/ud}
{ud0}
Gottfried Ploucquet ({dat1716}1716{/dat}) Philosophe, mathématicien et théologien. - Professeur de philosophie à l''université de Tübingen (1750-1782) [http://data.bnf.fr/ark:/12148/cb13324024g#foaf:Person]
{/ud}
{ud0}
Leonardo Ximenes ({en0li}Trapani, Italie{/en}, {dat1716}1716{/dat}) Jésuite. - Geographe, astronome, mathématicien [http://data.bnf.fr/ark:/12148/cb106577403#foaf:Person]
{/ud}
{ud0}
D'' Alembert ({en0li}Paris{/en}, {dat1717}1717{/dat}) Mathématicien et philosophe. - Nom patronymique : Jean Le Rond, d̲i̲t̲ d'' Alembert. - Membre de l''Institut, Académie française (élu en 1754) [http://data.bnf.fr/ark:/12148/cb118883708#foaf:Person]
{/ud}
{ud0}
Josef Anton Nagel ({dat1717}1717{/dat}) Professeur, mathématicien, scientifique allemand [http://data.bnf.fr/ark:/12148/cb12091922b#foaf:Person]
{/ud}
{ud0}
Augustin Darquier de Pellepoix ({en0li}Toulouse{/en}, {dat1718}1718{/dat}) Astronome. - Associé non résidant de l''Académie des sciences. - Receveur des tailles de la généralité d''Auch [http://data.bnf.fr/ark:/12148/cb12155190x#foaf:Person]
{/ud}
{ud0}
Claude-François Berthelot ({dat1718}1718{/dat}) Ingénieur. - Professeur de mathématiques à l''École royale militaire. - Inventeur de l''"affut de Gribeauval" [http://data.bnf.fr/ark:/12148/cb134984423#foaf:Person]
{/ud}
{ud0}
François-César Le Tellier Courtanvaux ({dat1718}1718{/dat}) Duc de Doudeauville. - Capitaine-colonel des cent-suisses de la garde du roi. - Astronome, membre de l''Académie des sciences [http://data.bnf.fr/ark:/12148/cb121904446#foaf:Person]
{/ud}
{ud0}
Gaspard-François-Anne de Forbin ({dat1718}1718{/dat}) Né le 8 ou le 18 juillet 1718. - Embrassa d'' abord la carrière militaire. - Chevalier de Malte. - Mathématicien et Physicien [http://data.bnf.fr/ark:/12148/cb12108181n#foaf:Person]
{/ud}
{ud0}
István Hatvani ({en0li}Rimaszombat, aujourd''hui Rimavská Sobota, Slovaquie{/en}, {dat1718}1718{/dat}) Mathématicien, physicien. - Médecin. - Pédagogue, professeur à Debrecen,Református Kollégium, Hongrie. - Diplômé de l''Université de Bâle, Suisse [http://data.bnf.fr/ark:/12148/cb10355679v#foaf:Person]
{/ud}
{ud0}
Jean-Philippe Loys de Chéseaux ({dat1718}1718{/dat}) Astronome et physicien. - Né à Lausanne, mort à Paris [http://data.bnf.fr/ark:/12148/cb133196302#foaf:Person]
{/ud}
{ud0}
Joseph Amiot ({en0li}Toulon{/en}, {dat1718}1718{/dat}) Jésuite de 1737 à 1773 (ordonné prêtre en 1749). - Sinologue et astronome. - Missionnaire en Chine (à partir de 1749) [http://data.bnf.fr/ark:/12148/cb12112654w#foaf:Person]
{/ud}
{ud0}
Maria Gaetana Agnesi ({en0li}Milan, Italie{/en}, {dat1718}1718{/dat}) Mathématicienne [http://data.bnf.fr/ark:/12148/cb105423187#foaf:Person]
{/ud}
{ud0}
Abraham Gotthelf Kästner ({en0li}Leipzig, Allemagne{/en}, {dat1719}1719{/dat}) Mathématicien. - Poète et épigrammatiste. - Critique [http://data.bnf.fr/ark:/12148/cb123392338#foaf:Person]
{/ud}
{ud0}
Giuseppe Toaldo ({en0li}Pianezze, Italie{/en}, {dat1719}1719{/dat}) Prêtre. - Physicien. - Professeur d''astronomie, de géographie et de météorologie à l''Université de Padoue [http://data.bnf.fr/ark:/12148/cb10578331h#foaf:Person]
{/ud}
{ud0}
Jens Kraft ({dat1720}1720{/dat}) Philosophe des lumières danois. - Professeur de mathématiques et de philosophie à Soroe [http://data.bnf.fr/ark:/12148/cb12442689p#foaf:Person]
{/ud}
{ud0}
Charles Walmesley ({dat1722}1722{/dat}) Évêque de Rama. - Astronome [http://data.bnf.fr/ark:/12148/cb10748264x#foaf:Person]
{/ud}
{ud0}
Jean Chappe d''Auteroche ({en0li}Mauriac (Cantal){/en}, {dat1722}1722{/dat}) Astronome. - Explorateur en Sibérie et en Californie [http://data.bnf.fr/ark:/12148/cb12402595h#foaf:Person]
{/ud}
{ud0}
Jean-Louis Dupain-Triel ({dat1722}1722{/dat}) Homme de lettres, poète. - S''intéressa aux mathématiques, à la géographie et à l''enseignement des arts [http://data.bnf.fr/ark:/12148/cb119011560#foaf:Person]
{/ud}
{ud0}
Louis-Jacques Goussier ({dat1722}1722{/dat}) Mathématicien et inventeur [http://data.bnf.fr/ark:/12148/cb13485055d#foaf:Person]
{/ud}
{ud0}
Baien Miura ({dat1723}1723{/dat}) Lettré du milieu de l''époque d''Edo. - A créé son propre système de pensée philosophique appelé "jōrigaku" : méthode de spéculation fondée sur l''éthique, la logique, les mathématiques et la physique, recourant à une pensée dialectique appelée "hankan gōitsu" [http://data.bnf.fr/ark:/12148/cb12293200x#foaf:Person]
{/ud}
{ud0}
Didier Robert de Vaugondy ({dat1723}1723{/dat}) Géographe ordinaire du roi, professeur de mathématiques et de géographie, fils de Gilles Robert Vaugondy. - Didier signe "Robert de Vaugondy" [http://data.bnf.fr/ark:/12148/cb12380757h#foaf:Person]
{/ud}
{ud0}
Étienne-Nicolas Blondeau ({dat1723}1723{/dat}) Professeur de mathématiques. - Ingénieur de la marine. - Collaborateur de l''Encyclopédie méthodique (1782-1783?) [http://data.bnf.fr/ark:/12148/cb10737141j#foaf:Person]
{/ud}
{ud0}
Johann Tobias Mayer ({dat1723}1723{/dat}) Mathématicien et astronome, a travaillé avec Homann Herben de 1746 à 1751, puid pour Kilian à partir de 1752 [http://data.bnf.fr/ark:/12148/cb153509764#foaf:Person]
{/ud}
{ud0}
Johann Tobias Mayer ({dat1723}1723{/dat}) Astronome allemand [http://data.bnf.fr/ark:/12148/cb11958863x#foaf:Person]
{/ud}
{ud0}
Nicole-Reine Lepaute ({en0li}Paris{/en}, {dat1723}1723{/dat}) Née Nicole-Reine Étable de La Brière, épouse de Jean-André Lepaute, horloger du Roi. - Mathématicienne, astronome [http://data.bnf.fr/ark:/12148/cb14555447k#foaf:Person]
{/ud}
{ud0}
Tobias Mayer ({en0li}Marbach (Allemagne){/en}, {dat1723}1723{/dat}) Astronome, mathématicien. - Directeur de l''Observatoire de Göttingen, Allemagne [http://data.bnf.fr/ark:/12148/cb121551484#foaf:Person]
{/ud}
{ud0}
Edme-Sébastien Jeaurat ({dat1724}1724{/dat}) Ingénieur-géographe et astronome. - Professeur à l''école militaire. - Membre de l''Académie des sciences [http://data.bnf.fr/ark:/12148/cb122175393#foaf:Person]
{/ud}
{ud0}
François Para Du Phanjas (Chabottes (Hautes-Alpes), {dat1724}1724{/dat}) Philosophe et mathématicien [http://data.bnf.fr/ark:/12148/cb12528863r#foaf:Person]
{/ud}
{ud0}
Georges Louis Lesage ({en0li}Genève{/en}, {dat1724}1724{/dat}) Mathématicien et physicien suisse. - Etudie à Genève puis Paris. - Etabli à Genève [http://data.bnf.fr/ark:/12148/cb155857475#foaf:Person]
{/ud}
{ud0}
Guillaume-Germain Guyot ({en0li}Orléans{/en}, {dat1724}1724{/dat}) Les ouvrages "Nouvelles récréations physiques et mathématiques" et "Essai sur la construction des ballons aérostatiques et sur la manière de les diriger" lui sont attribués par le DBF et par Samuel Ersch dans "La France littéraire contenant les auteurs français de 1771 à 1796", DBF. - Quérard et Michaud soulignent la confusion entre lui et Edme-Gilles Guyot pour l''attribution de ces ouvrages [http://data.bnf.fr/ark:/12148/cb12214218k#foaf:Person]
{/ud}
{ud0}
Guillaume-Hyacinthe-Joseph-Jean-Baptiste Le Gentil de La Galaisière ({dat1725}1725{/dat}) Astronome et voyageur. - Entre à l''Observatoire en 1750. - Membre de l''Académie des sciences en 1753 [http://data.bnf.fr/ark:/12148/cb12151459n#foaf:Person]
{/ud}
{ud0}
Jean-Étienne Montucla ({dat1725}1725{/dat}) Historien des mathématiques [http://data.bnf.fr/ark:/12148/cb12127574n#foaf:Person]
{/ud}
{ud0}
Louis-Charles Desnos ({dat1725}1725{/dat}) Libraire ; libraire et (ingénieur) géographe (pour les globes et les sphères) du roi de Danemark (ou : de Sa Majesté danoise) (1769-1789). - Fils d''un marchand drapier de Pont-Sainte-Maxence (Oise). Apprenti fondeur de caractères à Paris à partir d''avril 1745 (reçu maître fondeur en 1757).  Ingénieur géographe (de la ville de Paris à partir de 1769), fabricant et marchand de sphères et d''instruments astronomiques établi vers 1753 en succession de Jacques Hardy, après avoir épousé en 1749 la veuve de son fils Nicolas Hardy ; également marchand d''estampes et de cartes géographiques. Un des 12 libraires non jurés reçus le 4 oct. 1767. - Éditeur et auteur de nombreux atlas, almanachs et publications géographiques entre 1756 et 1795 env. Rédige également plusieurs catalogues de son fonds entre 1768 et 1792. Une partie de son fonds est rachetée en 1805 par Jean (17..-1839), marchand de cartes et d''estampes [http://data.bnf.fr/ark:/12148/cb12402252d#foaf:Person]
{/ud}
{ud0}
Rigobert Bonne (Raucourt (Meurthe-et-Moselle), {dat1727}1727{/dat}) Ingénieur. - Géographe. - Hydrographe. - Célèbre par la projection qui porte son nom et qui remplacera pour la carte de France la projection de Cassini. D''abord ingénieur géographe et maître de mathématiques. En 1775 ingénieur hydrographe de la Marine. Fut mis à la retraite contre sa volonté en 1789. Collabora au Neptune américo-septentrional [http://data.bnf.fr/ark:/12148/cb12169793s#foaf:Person]
{/ud}
{ud0}
Chrysologue de Gy (Gy (Haute-Saône), {dat1728}1728{/dat}) Capucin. - Astronome, cartographe et géologue [http://data.bnf.fr/ark:/12148/cb10728734z#foaf:Person]
{/ud}
{ud0}
Jean-Henri Lambert ({en0li}Mulhouse, Suisse{/en}, {dat1728}1728{/dat}) Mathématicien, physicien, astronome et philosophe. - Spécialiste de géometrie. - En poste à l''Académie royale des sciences et belles lettres de Berlin (de 1765 à 1777) [http://data.bnf.fr/ark:/12148/cb12359659g#foaf:Person]
{/ud}
{ud0}
Le P.  Chrysologue ({en0li}Gy{/en}, {dat1728}1728{/dat}) Capucin, nom de religion de Noël André. - Attiré par la géographie et l''astronomie, fut l''élève de Lemonnier. Mesura les altitudes des Vosges, du Jura et des Alpes. Se retira dans sa famille au moment de la Révolution.  En 1806 publia un important traité de géologie dont Cuvier fit un rapport élogieux [http://data.bnf.fr/ark:/12148/cb153054042#foaf:Person]
{/ud}
{ud0}
Paolo Frisi ({en0li}Melegnano, Italie{/en}, {dat1728}1728{/dat}) Barnabite. - Mathématicien, astronome et écrivain. - Professeur dans les Écoles palatines de Milan (1764-) [http://data.bnf.fr/ark:/12148/cb120849325#foaf:Person]
{/ud}
{ud0}
Antonio Eximeno ({dat1729}1729{/dat}) Théoricien de la musique et polémiste. - Jésuite, il devient professeur de rhétorique à l''Université de Valence, puis professeur de mathématiques à l''Académie militaire de Ségovie ({dat1764}1764{/dat}). - Lorsque les jésuites sont expulsés d''Espagne en 1767, il se rend à Rome où il étudie la musique. - Connu aussi sous le pseud. : "Aristosseno Megareo" (BnF, Musique, fichier général auteurs), ou "Aristodemo Megareo" (Fétis) [http://data.bnf.fr/ark:/12148/cb13755053m#foaf:Person]
{/ud}
{ud0}
Charles Bossut ({dat1730}1730{/dat}) Mathématicien, membre de l''Académie des sciences ({dat1779}1779{/dat}), il participa à la rédaction de la partie mathématique de l''Encyclopédie [http://data.bnf.fr/ark:/12148/cb11763983g#foaf:Person]
{/ud}
{ud0}
Charles Bossut ({dat1730}1730{/dat}) Mathématicien et physicien. - Membre de l''Académie des sciences, pensionnaire de la classe de mécanique ({dat1785}1785{/dat}). - Écrivit plusieurs articles dans l''"Encyclopédie" [http://data.bnf.fr/ark:/12148/cb124599882#foaf:Person]
{/ud}
{ud0}
Charles Messier (Badonviller (Meurthe-et-Moselle), {dat1730}1730{/dat}) Astronome de la marine. - Académicien ({dat1770}1770{/dat}). - Membre de l''Institut [http://data.bnf.fr/ark:/12148/cb124827900#foaf:Person]
{/ud}
{ud0}
Étienne Bezout ({en0li}Nemours{/en}, {dat1730}1730{/dat}) Mathématicien. - Membre de l''Académie des sciences [http://data.bnf.fr/ark:/12148/cb12267459g#foaf:Person]
{/ud}
{ud0}
Jean-Baptiste de Laborde ({dat1730}1730{/dat}) Physicien et mathématicien. - Jésuite [http://data.bnf.fr/ark:/12148/cb13196726p#foaf:Person]
{/ud}
{ud0}
Joseph-Aignan Sigaud de La Fond ({en0li}Bourges{/en}, {dat1730}1730{/dat}) Mathématicien, physicien et moraliste. - Professeur de physique à Bourges [http://data.bnf.fr/ark:/12148/cb12401095w#foaf:Person]
{/ud}
{ud0}
Pierre-Thomas Antelmy ({en0li}Trigance, France{/en}, {dat1730}1730{/dat}) Mathématicien, professeur de mathématiques à l''École militaire [http://data.bnf.fr/ark:/12148/cb13011110m#foaf:Person]
{/ud}
{ud0}
Benito Bails ({dat1731}1731{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb162593727#foaf:Person]
{/ud}
{ud0}
Girolamo Francisco Cristiani ({en0li}Brescia, Italie{/en}, {dat1731}1731{/dat}) Mathématicien et physicien [http://data.bnf.fr/ark:/12148/cb14065297x#foaf:Person]
{/ud}
{ud0}
Nicolas-Claude Duval-Le Roy ({dat1731}1731{/dat}) Professeur de mathématiques et d''hydrographie, physicien et astronome. - Membre de l''Académie royale de marine. - Correspondant à l''Académie royale des sciences ({dat1789}1789{/dat}), associé non résident de l''Institut ({dat1796}1796{/dat}) [http://data.bnf.fr/ark:/12148/cb12548660k#foaf:Person]
{/ud}
{ud0}
Diderich Christian Fester ({dat1732}1732{/dat}) Mathématicien et cartographe à Trondheim [http://data.bnf.fr/ark:/12148/cb15384550x#foaf:Person]
{/ud}
{ud0}
Jérôme de La Lande (Bourg-en-Bresse ({en0li}Ain){/en}, {dat1732}1732{/dat}) Astronome. - Membre de l''Académie de Berlin. - Membre de l''Académie des sciences ({dat1753}1753{/dat}). - Professeur d''astronomie au Collège de France ({dat1762}1762{/dat}). - Directeur de l''Observatoire de Paris de 1768 à sa mort [http://data.bnf.fr/ark:/12148/cb12012398h#foaf:Person]
{/ud}
{ud0}
Maurille-Antoine Moithey ({dat1732}1732{/dat}) Éditeur et marchand de cartes géographiques ; libraire. - Ingénieur géographe du Roi et professeur de mathématiques des pages du prince et de la princesse de Conti. Auteur de plans, de cartes, d''ouvrages illustrés et d''atlas, qu''il publie et diffuse parfois lui-même de 1776 à 1792 au moins. Auteur notamment d''un "Dictionnaire hydrographique de la France..." (1re éd., l''auteur, 1787 ; rééd., Paris, Blanchon, {dat1803}1803{/dat}) et d''une série de "Recherches historiques" sur les villes de France (Angers, Orléans, Reims, 1775-1776). Se qualifie de libraire en 1791-1792. Décédé à Paris le 21 frimaire an XIV (12 déc. 1805, Arch. de Paris) [http://data.bnf.fr/ark:/12148/cb13531657x#foaf:Person]
{/ud}
{ud0}
Nevil Maskelyne ({dat1732}1732{/dat}) Astronome royal d''Angleterre. - Membre associé de l''Académie des sciences de Paris [http://data.bnf.fr/ark:/12148/cb12155150p#foaf:Person]
{/ud}
{ud0}
Jacques-François Dicquemare ({en0li}Le Havre{/en}, {dat1733}1733{/dat}) Astronome. - Hydrographe. - Zoologue marin [http://data.bnf.fr/ark:/12148/cb15317071s#foaf:Person]
{/ud}
{ud0}
János Sajnovics ({en0li}Tordas, Hongrie{/en}, {dat1733}1733{/dat}) Astronome. - Linguiste. - Père jésuite [http://data.bnf.fr/ark:/12148/cb12246417w#foaf:Person]
{/ud}
{ud0}
Jean-Charles Borda ({en0li}Dax (Landes){/en}, {dat1733}1733{/dat}) Officier de marine. - Membre de l''Académie de Marine (élu en 1769). - Entra dans le Génie militaire et se fit remarquer par ses travaux sur l''hydraulique. - Il détermina la longitude des Canaries (en 1776). - Prit part à la guerre d''indépendance américaine. - Participa avec Delambre et Méchain à la mesure de l''arc de méridien Dunkerque-Barcelone. - En qualité de commissaire de l''Académie des sciences participa à l''étude des montres marines sur la frégate la Flore (en 1771). - Membre de l''Institut, Académie des sciences (élu en 1772). - Membre de la Commission des poids et mesures (en 1791), il travailla à l''établissement du système métrique. - Membre de l''Institut national des sciences et arts, section mathématiques (actuel Institut de France) et du Bureau des longitudes (en 1795). - Co-fondateur de La Société de Borda (créée en 1876), avec Jacques-François de Borda d''Oro (1718-1804) [http://data.bnf.fr/ark:/12148/cb12482831r#foaf:Person]
{/ud}
{ud0}
Samuel Horsley ({dat1733}1733{/dat}) Evêque; secrétaire de la Royal Society; publia des livres de théologie et de mathématiques [http://data.bnf.fr/ark:/12148/cb120697374#foaf:Person]
{/ud}
{ud0}
Achille Pierre Dionis du Séjour ({en0li}Paris{/en}, {dat1734}1734{/dat}) Astronome et mathématicien [http://data.bnf.fr/ark:/12148/cb10680537k#foaf:Person]
{/ud}
{ud0}
Baudouin de Guémadeuc ({dat1734}1734{/dat}) Homme de loi, homme de lettres, pamphlétaire puis astronome [http://data.bnf.fr/ark:/12148/cb144447840#foaf:Person]
{/ud}
{ud0}
Charles Duvaucel ({dat1734}1734{/dat}) Astronome, spécialisé dans les éclipses du soleil. [http://data.bnf.fr/ark:/12148/cb15318527x#foaf:Person]
{/ud}
{ud0}
Mathieu Bernard Goudin ({en0li}Paris{/en}, {dat1734}1734{/dat}) Magistrat. - Mathématicien et astronome [http://data.bnf.fr/ark:/12148/cb10586154b#foaf:Person]
{/ud}
{ud0}
Alexandre-Théophile Vandermonde ({en0li}Paris{/en}, {dat1735}1735{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb12534847r#foaf:Person]
{/ud}
{ud0}
Antonio Maria Lorgna ({en0li}Cerea, Italie{/en}, {dat1735}1735{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb12387058m#foaf:Person]
{/ud}
{ud0}
Gregorio Fontana ({en0li}Villa di Nogaredo, Italie{/en}, {dat1735}1735{/dat}) Mathématicien et physicien. - Recteur et professeur de calcul sublime à l''Ateneo lombardo. - Bibliothécaire du Collegio Ghisleri, Pavie [http://data.bnf.fr/ark:/12148/cb10601676b#foaf:Person]
{/ud}
{ud0}
Giovanni-Antonio Rizzi-Zannoni ({en0li}Padoue, Italie{/en}, {dat1736}1736{/dat}) Géographe de la république de Venise, astronome, il voyage en Amérique du nord en 1757 [http://data.bnf.fr/ark:/12148/cb153024615#foaf:Person]
{/ud}
{ud0}
Jean Sylvain Bailly ({en0li}Paris{/en}, {dat1736}1736{/dat}) Mathématicien, astronome et homme politique. - Entre à l''Académie des sciences (en 1763), à l''Académie française (en 1784) puis à l''Académie des inscriptions (en 1785). - Député du Tiers-État aux États-Généraux ; Maire de Paris ; Député à l''Assemblée Nationale Constituante [http://data.bnf.fr/ark:/12148/cb12516744h#foaf:Person]
{/ud}
{ud0}
Johann Nicolai Tetens ({en0li}Tetenbüll, Allemagne{/en}, {dat1736}1736{/dat}) Mathématicien, physicien et philosophe [http://data.bnf.fr/ark:/12148/cb12531163b#foaf:Person]
{/ud}
{ud0}
Joseph-Louis Lagrange ({dat1736}1736{/dat}) Mathématicien. - D''origine italienne. - A été à l''origine de la fondation de l''Académie des sciences de Turin. - Membre de l''Académie des sciences de Paris, Berlin, Turin. - A partir de 1787, enseigne à Paris à l''École normale et à l''École polytechnique [http://data.bnf.fr/ark:/12148/cb12125247f#foaf:Person]
{/ud}
{ud0}
Francesco Venini ({en0li}Varenna, Italie{/en}, {dat1737}1737{/dat}) Abbé. - Mathématicien et poète [http://data.bnf.fr/ark:/12148/cb105963005#foaf:Person]
{/ud}
{ud0}
Giuseppe Maria Pagnini ({en0li}Pistoia, Italie{/en}, {dat1737}1737{/dat}) Au siècle : Luca Antonio ; en religion, carme : Giuseppe Maria. - Poète. - Mathématicien. - Savant latiniste et helléniste. - Professeur à l'' Université de Parme puis de Pise [http://data.bnf.fr/ark:/12148/cb11996942k#foaf:Person]
{/ud}
{ud0}
Tommaso Valperga di Caluso ({en0li}Turin, Italie{/en}, {dat1737}1737{/dat}) Abbé. - Homme de lettres, philosophe et mathématicien. - Chevalier de Malte [http://data.bnf.fr/ark:/12148/cb10748197m#foaf:Person]
{/ud}
{ud0}
William Bayly ({dat1737}1737{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb14065321z#foaf:Person]
{/ud}
{ud0}
Charles-Joseph Mathon de La Cour ({en0li}Lyon (Rhône){/en}, {dat1738}1738{/dat}) Économiste. - Philanthrope. - Fondateur du "Journal de Lyon". - Rédacteur de "L''Almanach musical" (1775-1778), et au "Journal de musique", Paris (1764-1768). - Fils de : Mathon de La Cour, Jacques (1712-1770), mathématicien [http://data.bnf.fr/ark:/12148/cb121925904#foaf:Person]
{/ud}
{ud0}
Flecheux ({dat1738}1738{/dat}) Astronome et mécanicien français. - Adresse en 1784 : Paris, rue du Sentier, hôtel de madame la présidente de Meslay, n° 31 [http://data.bnf.fr/ark:/12148/cb15585605z#foaf:Person]
{/ud}
{ud0}
Joseph-François Marie ({en0li}Rodez{/en}, {dat1738}1738{/dat}) Abbé. - Fut professeur de mathématiques au Collège Mazarin [http://data.bnf.fr/ark:/12148/cb146364765#foaf:Person]
{/ud}
{ud0}
Thomas Abbt ({en0li}Ulm, Allemagne{/en}, {dat1738}1738{/dat}) Écrivain, philosophe, mathématicien, juriste et conseiller aulique [http://data.bnf.fr/ark:/12148/cb125347464#foaf:Person]
{/ud}
{ud0}
William Herschel ({en0li}Hanovre, Allemagne{/en}, {dat1738}1738{/dat}) Astronome et compositeur. - A découvert la planète Uranus. - S''installe en Grande-Bretagne en 1757 [http://data.bnf.fr/ark:/12148/cb14064893z#foaf:Person]
{/ud}
{ud0}
Ermenegildo Pini ({en0li}Milan, Italie{/en}, {dat1739}1739{/dat}) Barnabite. - Physicien, géologue, architecte. - Professeur de mathématiques, puis d''histoire naturelle au Collège Saint-Alexandre, Milan. - Dans le siècle : Pini, Carlo [http://data.bnf.fr/ark:/12148/cb13013593q#foaf:Person]
{/ud}
{ud0}
Jean-Louis Pictet ({dat1739}1739{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb146402484#foaf:Person]
{/ud}
{ud0}
Johann Schultz ({dat1739}1739{/dat}) A été professeur de mathématiques à l''université de Königsberg, Allemagne [http://data.bnf.fr/ark:/12148/cb121741380#foaf:Person]
{/ud}
{ud0}
José Antonio Alzate y Ramírez ({dat1739}1739{/dat}) Astronome et géographe [http://data.bnf.fr/ark:/12148/cb15376450x#foaf:Person]
{/ud}
{ud0}
András Dugonics ({en0li}Szeged (Hongrie){/en}, {dat1740}1740{/dat}) Écrivain. - Poète. - Piariste. - Professeur de mathématiques. - A fait des études de théologie  à Privigye (aujourd''hui Prievidza, Slovaquie) et à Nyitra (aujourd''hui Nitra, Slovaquie) [http://data.bnf.fr/ark:/12148/cb12246575b#foaf:Person]
{/ud}
{ud0}
Jacques-André Mallet ({dat1740}1740{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb10552198c#foaf:Person]
{/ud}
{ud0}
Joseph Anton Slop von Cadenberg ({dat1740}1740{/dat}) Astronome. - À l''Observatoire de Pise à partir de 1765 [http://data.bnf.fr/ark:/12148/cb12159312n#foaf:Person]
{/ud}
{ud0}
Nicola Spedalieri ({en0li}Bronte (Italie){/en}, {dat1740}1740{/dat}) Professeur de philosophie, théologie et mathématique, poète, musicien, historien [http://data.bnf.fr/ark:/12148/cb16219670j#foaf:Person]
{/ud}
{ud0}
Nicolas-Antoine Nouet ({dat1740}1740{/dat}) Astronome. - Attaché à l''Observatoire en 1785. - Participe à l''expédition d''Égypte en 1798. - Ingénieur au Bureau de la guerre en 1802 [http://data.bnf.fr/ark:/12148/cb12151453k#foaf:Person]
{/ud}
{ud0}
Thomas Bugge ({en0li}Copenhague{/en}, {dat1740}1740{/dat}) Astronome et cartographe [http://data.bnf.fr/ark:/12148/cb121931908#foaf:Person]
{/ud}
{ud0}
Vicente Tofiño de San Miguel ({dat1740}1740{/dat}) Astronome. - Capitaine de vaisseau. - Directeur des compagnies des gardes royales de la marine en 1786. - Membre de l''Académie d''histoire de Madrid. - Correspondant de l''Académie des sciences de Paris [http://data.bnf.fr/ark:/12148/cb12159995t#foaf:Person]
{/ud}
{ud0}
Alexis Rochon ({en0li}Brest (Finistère){/en}, {dat1741}1741{/dat}) Prêtre, astronome de la marine, physicien et inventeur. - Bibliothécaire de l''Académie royale de marine à Brest (1765-), astronome opticien de la Marine ({dat1787}1787{/dat}), membre de la Commission des poids et mesures et des monnaies ({dat1792}1792{/dat}). - Membre de l''Académie royale des sciences, puis membre de l''Institut. - Clerc tonsuré [http://data.bnf.fr/ark:/12148/cb129983745#foaf:Person]
{/ud}
{ud0}
Stanislaw Wydra ({dat1741}1741{/dat}) Professeur de mathématiques [http://data.bnf.fr/ark:/12148/cb15512813z#foaf:Person]
{/ud}
{ud0}
Vincenzo Chiminello ({en0li}Marostica, Italie{/en}, {dat1741}1741{/dat}) Abbé. - Astronome [http://data.bnf.fr/ark:/12148/cb10522164f#foaf:Person]
{/ud}
{ud0}
Georg Jonathan von Holland ({dat1742}1742{/dat}) Théologien. - Mathématicien. - Précepteur des princes de Wurttemberg [http://data.bnf.fr/ark:/12148/cb119076602#foaf:Person]
{/ud}
{ud0}
Jacques Poitevin ({en0li}Montpellier{/en}, {dat1742}1742{/dat}) Savant astronome et agriculteur. - Conseiller de préfecture du département de l''Hérault. - Membre de la Société royale des sciences de Montpellier [http://data.bnf.fr/ark:/12148/cb10644654k#foaf:Person]
{/ud}
{ud0}
Antonio Cagnoli ({en0li}Zante, Grèce{/en}, {dat1743}1743{/dat}) Astronome et mathématicien. - Crée un observatoire d''astronomie à Vérone. - Enseigne les mathématiques à l''École militaire de Modène après la prise de Vérone par les Français ({dat1797}1797{/dat}). - Membre de nombreuses académies d''Europe [http://data.bnf.fr/ark:/12148/cb12562781s#foaf:Person]
{/ud}
{ud0}
Eberhard August Wilhelm von Zimmermann ({en0li}Uelzen, Allemagne{/en}, {dat1743}1743{/dat}) Géographe et naturaliste. - Professeur de mathématiques et de sciences naturelles au Collegium Carolinum de Brunswick de 1766 à 1815. - Conseiller aulique en 1786, puis conseiller d''état en 1801 [http://data.bnf.fr/ark:/12148/cb12330956p#foaf:Person]
{/ud}
{ud0}
Jean-Antoine-Nicolas de Caritat Condorcet ({dat1743}1743{/dat}) Philosophe, mathématicien et  économiste. - Membre de l''Académie française ({dat1782}1782{/dat}). - Homme politique. - A aussi écrit sous le pseudonyme M. Schwartz, pasteur à Bienne [http://data.bnf.fr/ark:/12148/cb118975118#foaf:Person]
{/ud}
{ud0}
Etienne Lenoir ({dat1744}1744{/dat}) Ingénieur. - Mit au point plusieurs instruments d''astronomie et de géodésie [http://data.bnf.fr/ark:/12148/cb151423156#foaf:Person]
{/ud}
{ud0}
François Callet ({en0li}Versailles{/en}, {dat1744}1744{/dat}) Professeur de mathématiques et d''hydrographie [http://data.bnf.fr/ark:/12148/cb10544471f#foaf:Person]
{/ud}
{ud0}
Jean Bernoulli ({en0li}Bâle, Suisse{/en}, {dat1744}1744{/dat}) Mathématicien, astronome. - Membre des Académies des sciences de Berlin, de Petersbourg, de Stockholm, de Bologne, de Lyon, & de Marseille, de la Société pour l''encouragement des arts, de Londres, de celle des physiciens de Bâle, de l''Académie des Arcades de Rome [http://data.bnf.fr/ark:/12148/cb14508854n#foaf:Person]
{/ud}
{ud0}
José Anastácio da Cunha ({dat1744}1744{/dat}) Poète portugais. - Mathématicien, professeur de géométrie à l''Université de Coimbra. - Officier d''artillerie à Valença do Minho (1764-1778) [http://data.bnf.fr/ark:/12148/cb121612626#foaf:Person]
{/ud}
{ud0}
Pierre Méchain ({en0li}Laon{/en}, {dat1744}1744{/dat}) Astronome français. - Prénoms complets : Pierre François André [http://data.bnf.fr/ark:/12148/cb12090251r#foaf:Person]
{/ud}
{ud0}
Caspar Wessel ({en0li}Vestby, Norvège{/en}, {dat1745}1745{/dat}) Mathématicien. - Reçut la médaille d''argent de la Royal Danish academy [http://data.bnf.fr/ark:/12148/cb12563002z#foaf:Person]
{/ud}
{ud0}
Claude-François Guillemeau de Fréval ({en0li}Paris{/en}, {dat1745}1745{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb10017540p#foaf:Person]
{/ud}
{ud0}
Franz von Paula Triesnecker ({dat1745}1745{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb15115995f#foaf:Person]
{/ud}
{ud0}
Fulcrand Jean Joseph Aigrefeuille ({dat1745}1745{/dat}) Gastronome [http://data.bnf.fr/ark:/12148/cb16296114m#foaf:Person]
{/ud}
{ud0}
Johann Hieronymus Schröter ({dat1745}1745{/dat}) Magistrat et astronome amateur allemand [http://data.bnf.fr/ark:/12148/cb11973603q#foaf:Person]
{/ud}
{ud0}
Nicolas Charles Romme (Riom, Puy-de-Dôme, {dat1745}1745{/dat}) Professeur de mathématiques et de navigation à l''École de Rochefort. - Membre de l''Institut [http://data.bnf.fr/ark:/12148/cb12805333t#foaf:Person]
{/ud}
{ud0}
Gaetano Del Ricco ({dat1746}1746{/dat}) Piariste (17 mai 1761). - Mathématicien. - Librettiste. - Prénom de baptême : Vincenzo [http://data.bnf.fr/ark:/12148/cb16659347q#foaf:Person]
{/ud}
{ud0}
Gaspard Monge ({dat1746}1746{/dat}) Mathématicien et géomètre. - Fondateur de l''École polytechnique et de l''École normale. - Président de l''Institut du Caire. - Membre de l''Institut, Académie des sciences. - Député au Conseil des Cinq-Cents, au Conseil des Anciens, ministre de la Marine ({dat1792}1792{/dat}), sénateur ({dat1799}1799{/dat}), comte de Péluse ({dat1808}1808{/dat}) [http://data.bnf.fr/ark:/12148/cb121412336#foaf:Person]
{/ud}
{ud0}
Giovanni Battista Venturi ({en0li}Bibbiano, Italie{/en}, {dat1746}1746{/dat}) Physicien et mathématicien. - Homme politique et diplomate [http://data.bnf.fr/ark:/12148/cb127228927#foaf:Person]
{/ud}
{ud0}
Giuseppe Piazzi ({en0li}Ponte di Valtellina, Italie{/en}, {dat1746}1746{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb12920801z#foaf:Person]
{/ud}
{ud0}
Jean-Claude-Gauthier-Louis de Benaben ({dat1746}1746{/dat}) Oratorien et professeur de mathématiques. - Fut directeur de l''Ecole centrale d''Angers. - Fut président des Amis de la Constitution. - Fut commissaire civil du département de Maine-et-Loire [http://data.bnf.fr/ark:/12148/cb125680474#foaf:Person]
{/ud}
{ud0}
Jean Foucaud ({dat1747}1747{/dat}) Prédicateur, mathématicien, philologue. - A écrit en patois limousin des fables imitées de La Fontaine, qu''il a aussi traduit dans cette même langue. - Fut l''un des rédacteurs du "Journal du département de la Haute-Vienne". - Fut à Limoges une personalité agissante du Club des jacobins, membre du Comité de salut public, juge de paix et payeur du département de Haute-Vienne. - Défroqué en 1793, il mourut réconcilié avec l''Église [http://data.bnf.fr/ark:/12148/cb119031941#foaf:Person]
{/ud}
{ud0}
Jean-Baptiste Bernard ({dat1747}1747{/dat}) Libraire ; libraire de l''École polytechnique ({dat1800}1800{/dat}) ; de l''École des Ponts et Chaussées ({dat1801}1801{/dat}) ; des Écoles impériales polytechnique et des Ponts et chaussées ({dat1805}1805{/dat}). - Né à Marseille. Libraire spécialisé dans les "mathématiques, sciences et arts", il travaille jusqu''en 1796 en association avec Régent au bureau du "Journal polytechnique" ou "Bulletin des Travaux publics..." Historien et philologue, éditeur des "Œuvres posthumes" de Montesquieu. Décédé à Saint-Maur-des-Fossés (Val-de-Marne) en oct. 1808. Sa veuve lui succède avant de revendre son fonds en 1810 à Jean Klostermann [http://data.bnf.fr/ark:/12148/cb122388832#foaf:Person]
{/ud}
{ud0}
Johann Elert Bode ({en0li}Hambourg (Allemagne){/en}, {dat1747}1747{/dat}) Astronome [http://data.bnf.fr/ark:/12148/cb104634498#foaf:Person]
{/ud}
{ud0}
Andreas Riedel ({en0li}Vienne{/en}, {dat1748}1748{/dat}) Jacobin viennois. - Professeur de mathématiques, précepteur des enfants du Grand duc Léopold, futur empereur,  1779-1790, Florence (Italie). - Études de médecine, élève du professeur Franz Anton Mesmer. - Emprisonné à Brno (1806-1809). - Se réfugia en France 1810-1837 [http://data.bnf.fr/ark:/12148/cb14593357z#foaf:Person]
{/ud}
{ud0}
Jean-Dominique Cassini ({dat1748}1748{/dat}) Astronome. - Membre de l''Académie des sciences ({dat1770}1770{/dat}). - Fils de l''astronome César-François Cassini (1714-1784), qui était aussi appelé Cassini de Thury, car né à Thury (Oise) en 1714. - Succède à son père comme directeur de l''Observatoire de Paris (en 1784) [http://data.bnf.fr/ark:/12148/cb12157999q#foaf:Person]
{/ud}
{ud0}
Pietro Cossali ({en0li}Vérone, Italie{/en}, {dat1748}1748{/dat}) Mathématicien. - A enseigné à l''université de Padoue [http://data.bnf.fr/ark:/12148/cb146340668#foaf:Person]
{/ud}
{ud0}
Pons-Joseph Bernard ({dat1748}1748{/dat}) Mathématicien. - Directeur adjoint de l''Observatoire de Marseille [http://data.bnf.fr/ark:/12148/cb12306722n#foaf:Person]
{/ud}
{ud0}
Thaddäus Rinderle ({dat1748}1748{/dat}) Moine bénédictin, mathématicien et horloger [http://data.bnf.fr/ark:/12148/cb15037954k#foaf:Person]
{/ud}
{ud0}
Giuseppe Calandrelli ({en0li}Zagarolo, Italie{/en}, {dat1749}1749{/dat}) Astronome. - Directeur du "Collegio romano" [http://data.bnf.fr/ark:/12148/cb10544460s#foaf:Person]
{/ud}
{ud0}
Henri Bouchon-Dubournial ({dat1749}1749{/dat}) Ingénieur et mathématicien. - Fut professeur à l''Ecole militaire et l''Ecole royale militaire. - Fut le traducteur de Cervantès [http://data.bnf.fr/ark:/12148/cb125620183#foaf:Person]
{/ud}
{ud0}
Jean-Baptiste Delambre ({en0li}Amiens{/en}, {dat1749}1749{/dat}) Astronome. - Ses calculs ont servi à  déterminer la longueur du mètre. - Membre de l''Académie des sciences ({dat1792}1792{/dat}) [http://data.bnf.fr/ark:/12148/cb12096096m#foaf:Person]
{/ud}
{ud0}
Paul-Louis Cirodde ({dat1749}1749{/dat}) Professeur de mathématiques [http://data.bnf.fr/ark:/12148/cb102655606#foaf:Person]
{/ud}
{ud0}
Pierre-Simon de Laplace (Beaumont-en-Auge ({en0li}Calvados){/en}, {dat1749}1749{/dat}) Astronome, mathématicien et physicien. - Membre de l''Institut, Académie des sciences (élu en 1795), puis de l''Académie française (élu en 1816). - Obtint le titre de marquis (en 1817) [http://data.bnf.fr/ark:/12148/cb119110516#foaf:Person]
{/ud}
{ud0}
Vincenzo De Filippis ({dat1749}1749{/dat}) Scientifique, mathématicien. - Ministre de la République parthénopéenne en février 1799, fut probablement victime de la répression au rétablissement des Bourbons en juin de la même année [http://data.bnf.fr/ark:/12148/cb12290835h#foaf:Person]
{/ud}
{ud0}
William Faden ({dat1749}1749{/dat}) Libraire, éditeur et marchand de cartes et d''estampes ; également géographe ordinaire du roi d''Angleterre (1783-1820) et du prince de Galles (1790-1820). - Fils de l''imprimeur londonien William I Faden (à l''origine Mackfaden, 1711-1783). En apprentissage de juillet 1764 à août 1771. Travaille en association avec la famille du libraire et géographe du Roi Thomas Jefferys (m. 1771) jusqu''en 1776 env. Membre de la "Society of civil engineers". Beau-frère du peintre et astronome John Russell. Se retire en 1823 et cède son affaire à son ancien apprenti James Wyld. Décédé à Shepperton en mars 1836 [http://data.bnf.fr/ark:/12148/cb15615346f#foaf:Person]
{/ud}
{ud0}
Caroline Lucretia Herschel (Hanovre (Basse-Saxe,  Allemagne), {dat1750}1750{/dat}) Astronome. - Assistante de son frère, William Herschel (1738-1822), lui aussi astronome [http://data.bnf.fr/ark:/12148/cb16108822m#foaf:Person]
{/ud}
{ud0}
Gilbert Romme ({dat1750}1750{/dat}) Mathématicien, astronome et géographe. - Député du Puy-de-Dôme à l''Assemblée législative puis à la Convention, représentant en mission près l''armée de Cherbourg, préconise l''essai du télégraphe aérien de Chiappe. - A participé à l''établissement du calendrier révolutionnaire [http://data.bnf.fr/ark:/12148/cb12536106q#foaf:Person]
{/ud}
{ud0}
Lorenzo Mascheroni ({en0li}Bergame, Italie{/en}, {dat1750}1750{/dat}) Mathématicien et poète. - Professeur de physique et de mathématique au Séminaire de Bergame, puis d''algèbre et de géométrie à l''Université de Pavie, dont il sera recteur. - Député au Corps législatif de Milan ({dat1799}1799{/dat}), admirateur de Napoléon, fait partie des 29 qui signent l''appel à régner en Italie au Premier Consul après 1799 [http://data.bnf.fr/ark:/12148/cb119149502#foaf:Person]
{/ud}
{ud0}
Nicolas-Maurice Chompré ({en0li}Paris (France){/en}, {dat1750}1750{/dat}) Directeur, entre 1777 et 1786, de la Correspondance générale à la Division des mines et de l''agriculture du Contrôleur général des Finances Bertin. - Diplomate. - Auteur d''ouvrages de physique et de mathématiques [http://data.bnf.fr/ark:/12148/cb122074802#foaf:Person]
{/ud}
{ud0}
Scipione Breislak ({en0li}Rome{/en}, {dat1750}1750{/dat}) Géologue. - Professeur de mathématiques à Raguse puis à Rome [http://data.bnf.fr/ark:/12148/cb151306996#foaf:Person]
{/ud}
{ud0}
Simon Lhuilier ({dat1750}1750{/dat}) Mathématicien et philosophe. - Établi à Varsovie [http://data.bnf.fr/ark:/12148/cb13005974t#foaf:Person]
{/ud}
{ud0}
Alliette ({dat1751}1751{/dat}) Cartomancien de la fin du 18e siècle. - Marchand d''estampes. - Professeur de mathématiques (vers 1753). - La forme "Etteilla" est l''anagramme d''Alliette [http://data.bnf.fr/ark:/12148/cb118885161#foaf:Person]
{/ud}
{ud0}
André-Charles Brotier ({en0li}Paris{/en}, {dat1751}1751{/dat}) Abbé, mathématicien et homme politique. - Enseigna les mathématiques à l''Ecole militaire. - Collabora à l''"Année littéraire" et au "Journal de la France" [http://data.bnf.fr/ark:/12148/cb124621991#foaf:Person]
{/ud}
{ud0}
Antide Janvier (Lavans-lès-Saint-Claude ({en0li}Jura){/en}, {dat1751}1751{/dat}) Horloger, astronome [http://data.bnf.fr/ark:/12148/cb12614643k#foaf:Person]
{/ud}
{ud0}
Bazaine ({dat1751}1751{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb10735226f#foaf:Person]
{/ud}
{ud0}
Bernard Violle ({dat1751}1751{/dat}) Mathématicien. - Géomètre. - Chevalier de Saint-Louis ({dat1815}1815{/dat}) [http://data.bnf.fr/ark:/12148/cb13006994p#foaf:Person]
{/ud}
{ud0}
Bonaventure Abat ({dat1751}1751{/dat}) Mathématicien et théologien, cordelier de l''Observance. - Fut membre associé de l''Académie royale des belles-lettres de Barcelone [http://data.bnf.fr/ark:/12148/cb134813469#foaf:Person]
{/ud}
{ud0}
G.-F. Olivier ({dat1751}1751{/dat}) Bachelier ès sciences. - Professeur d''humanités et de mathématiques (en 1825). Professeur au collège de Troyes [http://data.bnf.fr/ark:/12148/cb10728006s#foaf:Person]
{/ud}
{ud0}
Guillelmus Beer ({dat1751}1751{/dat}) Cartographe, géographe et peut-être astronome [http://data.bnf.fr/ark:/12148/cb15332855z#foaf:Person]
{/ud}
{ud0}
Hector-Jean Legros ({dat1751}1751{/dat}) Adjoint-général pendant les guerres de Vendée et d''Italie. - Professeur de mathématiques [http://data.bnf.fr/ark:/12148/cb13484693c#foaf:Person]
{/ud}
{ud0}
Henri Jurain ({dat1751}1751{/dat}) Abbé. - Professeur de mathématiques à Reims. - Correspondant de l''Académie des Sciences [http://data.bnf.fr/ark:/12148/cb12224993g#foaf:Person]
{/ud}
{ud0}
J.-B.-M. Duprat ({dat1751}1751{/dat}) Libraire pour les mathématiques. - En activité de mars 1797 à 1803 au moins. Apparenté à Louis (-Alexis) Duprat-Duverger, en activité à partir de 1802, qui a pu se qualifier lui aussi de "libraire pour les mathématiques". Louis Courcier, "imprimeur et libraire pour les mathématiques", lui succède en 1803 à la même adresse (quai des Augustins, n° 71). Une "madame Duprat" est cependant répertoriée, à l''adresse du pont Saint-Michel, par le "Tableau des libraires" de Debray (Paris, janv. 1804) [http://data.bnf.fr/ark:/12148/cb16701987t#foaf:Person]
{/ud}
{ud0}
J.P. Audiffred ({dat1751}1751{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb125867381#foaf:Person]
{/ud}
{ud0}
Jacques Baradelle ({dat1751}1751{/dat}) Etabli dès 1740 quai de l''Horloge du Palais, il fabriquait des instruments de navigation, des cadrans solaires, des sphères astronomiques et géographiques [http://data.bnf.fr/ark:/12148/cb15281028g#foaf:Person]
{/ud}
{ud0}
James Dodson ({dat1751}1751{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb153816258#foaf:Person]
{/ud}
{ud0}
Jean-Louis Gœury ({dat1751}1751{/dat}) Libraire ; libraire pour les mathématiques et l''architecture ; libraire de l''École des Ponts et chaussées ({dat1802}1802{/dat}) ; des ingénieurs et de l''École impériale des Ponts et chaussées ({dat1805}1805{/dat}). - Semble avoir été commis du libraire parisien Charles-Antoine Jombert de 1770 à 1773 au moins. Père du médecin Jean-Louis Gœury-Duvivier, né le 2 mars 1803. En activité dès 1800. Breveté libraire le 1er oct. 1812 (brevet renouvelé le 11 sept. 1818). Décédé peu avant le 28 juin 1827, date à laquelle son fils Jean-Louis Gœury (dit plus tard Gœury-Duvivier) demande à succéder à son brevet [http://data.bnf.fr/ark:/12148/cb12230577c#foaf:Person]
{/ud}
{ud0}
Joseph Mouchet ({dat1751}1751{/dat}) Professeur de rhétorique et de mathématiques, professeur de physique à l''université de Nantes de 1780 à 1784. - Aéronaute. - Membre de la Congrégation de l''Oratoire [http://data.bnf.fr/ark:/12148/cb16514291q#foaf:Person]
{/ud}
{ud0}
Joseph-Louis Vincens de Mauléon de Causans ({en0li}Avignon{/en}, {dat1751}1751{/dat}) Mathématicien. - Colonel d''infanterie du régiment de Conti. - Chevalier de Malte [http://data.bnf.fr/ark:/12148/cb145658189#foaf:Person]
{/ud}
{ud0}
Le Professeur de mathématiques du Collège national de Toul ({dat1751}1751{/dat}) Professeur de mathématiques du Collège national de Toul [http://data.bnf.fr/ark:/12148/cb125373980#foaf:Person]
{/ud}
{ud0}
Le Ratz de Lanthenée ({dat1751}1751{/dat}) Gentilhomme liégeois. - Mathématicien et physicien [http://data.bnf.fr/ark:/12148/cb124022694#foaf:Person]
{/ud}
{ud0}
Louis Duprat-Duverger ({dat1751}1751{/dat}) Variante(s) de prénom : Louis-Alexis. - Libraire pour les mathématiques ; également éditeur de cartes et d''atlas. - Apparenté au "libraire pour les mathématiques" J.-B.-M. Duprat, en activité à Paris entre 1797 et 1803. Établi dès 1802, d''abord en association sous la raison "L. Duprat, Letellier et compagnie" jusqu''en 1804, seul ensuite. Breveté libraire le 1er oct. 1812 ; brevet renouvelé le 15 mars 1817 ; duplicata délivré le 27 avril 1824. Encore en activité en 1829 [http://data.bnf.fr/ark:/12148/cb133399518#foaf:Person]
{/ud}
{ud0}
Madame Bailly ({dat1751}1751{/dat}) Épouse de Jean-Sylvain Bailly, mathématicien, astronome et homme politique, guillotiné en 1793 [http://data.bnf.fr/ark:/12148/cb16541654h#foaf:Person]
{/ud}
{ud0}
Marie de La Fresnaye ({en0li}Barfleur (Manche){/en}, {dat1751}1751{/dat}) Professeur de littérature et de mathématiques [http://data.bnf.fr/ark:/12148/cb100430283#foaf:Person]
{/ud}
{ud0}
Marie-Louise Cartan ({dat1751}1751{/dat}) Femme d''Elie Cartan, mère du compositeur Jean Cartan et du mathématicien Henri Cartan. - Née Marie-Louise Bianconi [http://data.bnf.fr/ark:/12148/cb148511208#foaf:Person]
{/ud}
{ud0}
Mathurin-Georges Girault de Keroudou ({dat1751}1751{/dat}) Abbé. - Mathématicien français. - Principal du collège de Quimper. - Professeur de philosophie et de mathématiques au collège de Navarre à Paris. - Professeur au collège de Louis-le-Grand à Paris [http://data.bnf.fr/ark:/12148/cb15085298t#foaf:Person]
{/ud}
{ud0}
Nicolas Leverdé ({dat1751}1751{/dat}) Astrologue et mathématicien. - Auteur d''almanachs [http://data.bnf.fr/ark:/12148/cb10403809w#foaf:Person]
{/ud}
{ud0}
Olaf Söderberg ({dat1751}1751{/dat}) Botaniste et mathématicien [http://data.bnf.fr/ark:/12148/cb12563978p#foaf:Person]
{/ud}
{ud0}
Théodore Bouys ({dat1751}1751{/dat}) Mathématicien favorable à Necker et à la Révolution [http://data.bnf.fr/ark:/12148/cb12240772d#foaf:Person]
{/ud}
{ud0}
Trabaud ({dat1751}1751{/dat}) Maître de mathématiques [http://data.bnf.fr/ark:/12148/cb134811442#foaf:Person]
{/ud}
{ud0}
Vérologue ({dat1751}1751{/dat}) "Seul imprimeur d''Apollon pour la satyre en prose". - Pseud. auquel est adjoint le qualificatif "seul imprimeur d''Apollon pour la satyre en prose" et qui, sous la fausse adresse "Sur l''imprimé au Parnasse", dissimule une impression française (parisienne selon Weller et G. Brunet, plutôt provinciale d''après le matériel typographique) de "La Nouvelle Astronomie du Parnasse françois, ou l''Apothéose des écrivains vivans dans la présente année 1740", due au chevalier Jean-Florent-Joseph de Neufville de Brunaubois-Montador [http://data.bnf.fr/ark:/12148/cb165246377#foaf:Person]
{/ud}
{ud0}
Veuve de Louis Courcier ({dat1751}1751{/dat}) Nom patronymique : Victoire-Félicité Lemaire. - Imprimeur-libraire ; imprimeur-libraire pour les mathématiques, la marine, les sciences et les arts. - Brevetée imprimeur en succession de son mari le 12 août 1811 (brevet renouvelé le 15 oct. 1816) et libraire le 1er oct. 1812 (brevet renouvelé le 15 mars 1817). Deux de ses  gendres lui succèdent : Démophile Huzard (-Courcier) en mars 1820 (brevet du 14 mars 1820) comme imprimeur, et Victor Bachelier le 10 nov. 1821 comme libraire [http://data.bnf.fr/ark:/12148/cb124778683#foaf:Person]
{/ud}
{ud0}
Adrien-Marie Legendre ({dat1752}1752{/dat}) Mathématicien. - Président de l''Académie des sciences ({dat1806}1806{/dat}). - A aussi écrit avec Charles-Etienne Coquebert de Montbret et François Gattey sous le pseudonyme collectif "C.-G.-L. Métrophile" [http://data.bnf.fr/ark:/12148/cb12443375d#foaf:Person]
{/ud}
{ud0}
Barnaba Oriani ({en0li}Carignano, Italie{/en}, {dat1752}1752{/dat}) Astronome de l''Observatoire de Brera (1777-), puis de Milan. - A découvert qu''Uranus était une planète à partir de son orbite. - Mathématicien [http://data.bnf.fr/ark:/12148/cb12537845s#foaf:Person]
{/ud}
{ud0}
Jean-Baptiste Labey (La Chapelle-Hainfray (Calvados), aujourd''hui Valsemé ({en0li}Calvados){/en}, {dat1752}1752{/dat}) Mathématicien. - Professeur à l''École militaire, à l''École centrale du Panthéon, à l''École polytechnique et au Lycée Napoléon de Paris [http://data.bnf.fr/ark:/12148/cb12112257t#foaf:Person]
{/ud}
{ud0}
Jean-Baptiste Pérès (Valence d''Agen (Tarn-et-Garonne), {dat1752}1752{/dat}) Oratorien. - Professeur de mathématiques et de physique  à Lyon, membre de la Société des amis de la Constitution de la ville durant la Révolution, puis substitut du procureur général près la cour royale d''Agen et bibliothécaire de cette ville [http://data.bnf.fr/ark:/12148/cb126307361#foaf:Person]
{/ud}
{ud0}
Marc-Auguste Pictet ({en0li}Genève (Suisse){/en}, {dat1752}1752{/dat}) Naturaliste genevois, littérateur, chimiste, physicien et astronome. - Membre fondateur de la Société de physique et d''histoire naturelle de Genève, Suisse. - Correspondant de la Société royale de Londres [http://data.bnf.fr/ark:/12148/cb125386742#foaf:Person]
{/ud}
{ud0}
François Gattey ({dat1753}1753{/dat}) Mathématicien. - Directeur du Bureau des poids et mesures (en 1795). - A aussi écrit avec Charles-Etienne Coquebert de Montbret et Adrien-Marie Legendre sous le pseudonyme collectif "C.-G.-L. Métrophile" [http://data.bnf.fr/ark:/12148/cb12447886d#foaf:Person]
{/ud}
{ud0}
Antoine de La Salle ({dat1754}1754{/dat}) Philosophe. - Mathématicien [http://data.bnf.fr/ark:/12148/cb12173561c#foaf:Person]
{/ud}
{ud0}
Colin Mackenzie (Stornoway (Lewis, Western isles, Royaume-Uni), {dat1754}1754{/dat}) Mathématicien. - Fonctionnaire collonial en Inde (1815-1821). - Chargé du relevé cartographique de l''Inde et de la description de ses régions. - Collectionneur de divers documents (manuscrits, dessins aquarelles...) constituant le fonds d''études indianistes, collection dispersée aujourd''hui entre l''India office library, Londres et : Government oriental manuscripts library, Madras et Calcutta [http://data.bnf.fr/ark:/12148/cb14374770r#foaf:Person]
{/ud}
{ud0}
Franz Xaver von Zach ({en0li}Bratislava{/en}, {dat1754}1754{/dat}) Astronome. - Directeur de l''Observatoire du Seeberg (près de Gotha), de 1787 à 1808. - Dirigea les "Allgemeinen geographischen Ephemeriden" (1796-) [http://data.bnf.fr/ark:/12148/cb121732757#foaf:Person]
{/ud}
{ud0}
Jean-Baptiste Meusnier de La Place (Tours (Indre-et-Loire), {dat1754}1754{/dat}) Mathématicien et Officier. - Elu à l''Académie des sciences en 1784 pour son étude locale des surfaces. - Prénoms complets : Jean-Baptiste Marie Charles [http://data.bnf.fr/ark:/12148/cb10732160m#foaf:Person]
{/ud}
{ud0}
Nicolas-François Canard ({dat1754}1754{/dat}) Mathématicien et économiste [http://data.bnf.fr/ark:/12148/cb12519510c#foaf:Person]
{/ud}
{ud0}
Charles-Étienne Coquebert de Montbret ({en0li}Paris{/en}, {dat1755}1755{/dat}) Diplomate, mathématicien et géographe. - Nommé responsable de l''organisation du nouveau système de poids et mesures (décret de 1793), professeur de géographie physique et gîtes de minerais à l''École des mines. - A aussi écrit avec François Gattey et Adrien-Marie Legendre sous le pseudonyme collectif "C.-G.-L. Métrophile". - Membre de l''Institut, membre libre de l''Académie des Sciences (en 1816) [http://data.bnf.fr/ark:/12148/cb12447869t#foaf:Person]
{/ud}
{ud0}
Claude Philippe Bertrand Bertrand (Autun (Saône-et-Loire), {dat1755}1755{/dat}) Géographe et astronome [http://data.bnf.fr/ark:/12148/cb16506861q#foaf:Person]
{/ud}
{ud0}
Emmanuel-Étienne Duvillard de Durand ({en0li}Genève{/en}, {dat1755}1755{/dat}) Mathématicien, statisticien. - A développé la mathématisation de l''économie [http://data.bnf.fr/ark:/12148/cb129987837#foaf:Person]
{/ud}
{ud0}
Gaspard-Clair-François-Marie Riche de Prony ({en0li}Chamelet (Rhône){/en}, {dat1755}1755{/dat}) Mathématicien et ingénieur. - Directeur de l''École des Ponts et Chaussées (1799-1830). - Membre de l''Académie des Sciences. - Baron à titre personnel ({dat1828}1828{/dat}) [http://data.bnf.fr/ark:/12148/cb12535038t#foaf:Person]
{/ud}
{ud0}
Jean Anthelme Brillat-Savarin ({en0li}Belley, Ain{/en}, {dat1755}1755{/dat}) Magistrat. - Député aux États Généraux (élu en 1789). - Gastronome [http://data.bnf.fr/ark:/12148/cb12305674c#foaf:Person]
{/ud}
{ud0}
Louis Courcier ({dat1755}1755{/dat}) Imprimeur-libraire ; imprimeur-libraire pour les mathématiques ({dat1801}1801{/dat}) ; imprimeur-libraire pour les mathématiques (, les sciences et les arts) (1804-1808). - Exerce l''imprimerie dès l''été 1790. Aurait été auparavant "marchand de peaux de lapin" d''après l''enquête des inspecteurs de la librairie de déc. 1810. Proche des Girondins, il émarge au budget du Bureau de l''Esprit public du ministre Jean-Marie Roland de La Platière en 1792. Dirige le "Courrier du Corps législatif et de la Guerre" ({dat1797}1797{/dat}). Rachète le fonds du libraire J.-B.-M. Duprat et lui succède en 1803 ; rachète l''imprimerie de Jean-Georges-Antoine Stoupe après la mort de celui-ci ({dat1808}1808{/dat}). Breveté imprimeur le 1er avril 1811. Dit âgé de 56 ans lors de son décès (30 juillet 1811). Sa veuve est brevetée en sa succession dès le 12 août 1811 [http://data.bnf.fr/ark:/12148/cb12421329b#foaf:Person]
{/ud}
{ud0}
Nicolas B. Halma ({dat1755}1755{/dat}) Chanoine de Paris. - Astronome et mathématicien. - Professeur [http://data.bnf.fr/ark:/12148/cb11906753t#foaf:Person]
{/ud}
{ud0}
Nikolaus von Fuss ({dat1755}1755{/dat}) Mathématicien, géomètre. - Né à Bâle, s''intalla à Saint-Pétersbourg en 1773 à la demande d''Euler. - Membre de l''Académie des sciences de Saint-Pétersbourg (1775-), secrétaire perpétuel (1800-). - Meurt à Saint-Pétersbourg le 23 décembre 1825 (style grégorien) [http://data.bnf.fr/ark:/12148/cb12359314p#foaf:Person]
{/ud}
{ud0}
Pierre Tédenat ({dat1755}1755{/dat}) Docteur en mathématiques. - Recteur de l''académie Nîmes (1809-1818) et professeur de philosophie à la faculté des lettres de Nîmes [http://data.bnf.fr/ark:/12148/cb10379875d#foaf:Person]
{/ud}
{ud0}
Agricol-Joseph-François-Xavier-Pierre-Esprit-Simon-Paul-Antoine Fortia d''Urban ({en0li}Avignon{/en}, {dat1756}1756{/dat}) Mathématicien et littérateur. - Chevalier de la Légion d''honneur en 1811, correspondant de l''Académie de Belgique en 1828 et membre libre de l''Académie des Inscriptions et belles-lettres en 1830 [http://data.bnf.fr/ark:/12148/cb121468483#foaf:Person]
{/ud}
{ud0}
Alexandre Ruelle ({en0li}Blois{/en}, {dat1756}1756{/dat}) Astronome. - Professeur d''astronomie à l''Observatoire de Paris de 1783 à 1795 [http://data.bnf.fr/ark:/12148/cb121582720#foaf:Person]
{/ud}
{ud0}
Ernst Gottfried Fischer ({dat1756}1756{/dat}) Physicien et mathématicien [http://data.bnf.fr/ark:/12148/cb124025182#foaf:Person]
{/ud}
{ud0}
Jan Chrzciciel Władysław Śniadecki ({dat1756}1756{/dat}) Mathématicien et philosophe, un des plus grands savants polonais des Lumières [http://data.bnf.fr/ark:/12148/cb123726267#foaf:Person]
{/ud}
{ud0}
Joseph Mollet (Aix-en-Provence (Bouches-du-Rhône), {dat1756}1756{/dat}) Oratorien. - Professeur de physique et de mathématique, École Centrale, Lyon, Rhône. - Doyen de la Faculté des sciences de Lyon (1809-1815) [http://data.bnf.fr/ark:/12148/cb12196474k#foaf:Person]
{/ud}
{ud0}
Carl-Christian von Langsdorf ({en0li}Nauheim (Allemagne){/en}, {dat1757}1757{/dat}) Mathématicien. - Ingénieur. - Professeur de mathématiques à Erlangen (Allemagne), de 1798 à 1804, puis à Vilnius (Lituanie) de 1804 à 1806. - Frère de Langsdorf, Johann-Wilhelm (1745-1827) [http://data.bnf.fr/ark:/12148/cb10661030m#foaf:Person]
{/ud}
{ud0}
Dominique Blanqui ({dat1757}1757{/dat}) Professeur de philosophie et d''astronomie. - Député à la Convention. - Membre du Conseil des Cinq-cents [http://data.bnf.fr/ark:/12148/cb12534874n#foaf:Person]
{/ud}
{ud0}
Alexandre-Balthazar-Laurent Grimod de La Reynière ({en0li}Paris{/en}, {dat1758}1758{/dat}) Avocat. - Pamphlétaire. - Gastronome, fondateur et président du "Jury dégustateur" [http://data.bnf.fr/ark:/12148/cb11905936j#foaf:Person]
{/ud}
{ud0}
Johann Christoph Schuster ({dat1759}1759{/dat}) Mathématicien [http://data.bnf.fr/ark:/12148/cb16505504t#foaf:Person]
{/ud}
{ud0}
Louis-François-Antoine Arbogast ({en0li}Mutzig, Alsace{/en}, {dat1759}1759{/dat}) Mathématicien. - Directeur du Collège royal (en 1791). - Député à l''Assemblée législative puis à la Convention nationale [http://data.bnf.fr/ark:/12148/cb12520232w#foaf:Person]
{/ud}
{ud0}
Pierre-René-Auguste Bremond d''Ars ({dat1759}1759{/dat}) Député de la noblesse. - Fut professeur de mathématiques et de latin [http://data.bnf.fr/ark:/12148/cb12540611f#foaf:Person]
{/ud}
{ud0}
Thomas Keith ({en0li}Winestead (GB){/en}, {dat1759}1759{/dat}) Mathématicien. - Professeur [http://data.bnf.fr/ark:/12148/cb10275963j#foaf:Person]
{/ud}
{ud0}
Giovanni Paradisi ({en0li}Reggio Emilia, Italie{/en}, {dat1760}1760{/dat}) Comte. - Homme politique. - Mathématicien. - Poète [http://data.bnf.fr/ark:/12148/cb105910991#foaf:Person]
{/ud}
{ud0}
Nicolas Antoine Guillard ({en0li}Sorbais, Aisne{/en}, {dat1760}1760{/dat}) Professeur de mathématiques [http://data.bnf.fr/ark:/12148/cb10617134p#foaf:Person]
{/ud}', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (3, NULL, NULL, '2015-09-25 22:47:03.926285+02', '2015-10-04 12:16:24.653578+02', NULL, NULL, NULL, NULL, '<root><ud ana="8 20">
<eud ana="9">Johannes Kepler</eud>

<seg ana="8 999">De <dat when="1574" type="dd">1574</dat> <dat when="1576" type="df" cert="r">pendant deux ans</dat>, il vit chez ses grands-parents.</seg>

<seg ana="14">Astronome allemand</seg> (<in ana="11"><en ref="2"  type="ai" ana="10"></en>Weil, aujourd''hui <en type="li">Weil der Stadt</en>, Wurtemberg, <dat when="1571">1571</dat></in>-Ratisbonne 1630). 
Lois de Kepler 
<seg><en type="cs" ana="14 999">Savant</en> génial et obstiné</seg>, il est l''un des fondateurs de l''astronomie moderne. Sa découverte, purement empirique, des <en type="oa">lois du <en type="oa">mouvement</en></en> des planètes a bouleversé la pensée de son époque et ouvert la voie à <en>Newton</en>. 
Une enfance dure, mais une intelligence précoce
Johannes Kepler connaît une enfance assez dure, dans une ambiance familiale peu propice à l''éveil d''une vocation scientifique. Son père, mercenaire dans l''armée du duc de Wurtenberg, est un « soldat brutal, querelleur et immoral » souvent en campagne et qui finira par abandonner sa famille ; sa mère fera l''objet d''un procès en sorcellerie. Atteint de la variole à 3 ans, l''enfant en conservera toute sa vie des séquelles et une santé précaire.<seg ana="8">De <dat when="1574" type="dd">1574</dat> <dat when="1576" type="df" cert="r">pendant deux ans</dat>, il vit chez ses grands-parents.</seg> Il accompagne ensuite ses parents à Leonberg, où il fréquente l''école latine. En 1584, il est admis au séminaire protestant d''Adelberg. Le duc de Wurtenberg le repère et décide de le prendre sous sa tutelle : en 1589, il rejoint l''université de Tübingen, où il reçoit une formation très complète. Son professeur d''astronomie, Michael Mästlin, lui enseigne le système de Copernic, dont il est un prudent défenseur. Diplômé de l''université en 1591, Kepler poursuit des études de théologie, avec le projet de devenir pasteur. Mais c''est finalement vers la science qu''il va se tourner, car il est nommé, en 1594, professeur de mathématiques à Graz. Lorsque, vers 1600, les persécutions religieuses contre les protestants l''obligent à quitter cette ville, il se réfugie à Prague, où il devient le disciple et l''assistant de l''astronome danois Tycho Brahe, auquel il succède, en 1601, comme astronome de l''empereur Rodolphe II. 
Le découvreur des lois du mouvement des planètes
Devenu grâce à Mästlin un partisan convaincu de l''héliocentrisme, Kepler explique dans un premier ouvrage, le Prodomus… mysterium cosmographicum, publié en 1596, pourquoi le système de Ptolémée doit, selon lui, céder la place à la représentation copernicienne du monde. Mais, hanté par les idées pythagoriciennes, il croit l''Univers construit selon une architecture géométrique. Aussi élabore-t-il un ingénieux modèle géométrique du système de Copernic, dans lequel l''orbe de chaque planète occupe une sphère circonscrite à un polyèdre régulier et inscrite dans un autre. En fait, il a la conviction que le nombre de planètes, leurs distances au Soleil et leurs vitesses de révolution ne sont pas le fruit du hasard. Une étude systématique du mouvement de la planète Mars (dont la trajectoire reste mal interprétée par Ptolémée et par Copernic), après de laborieux calculs qu''il contrôle grâce aux observations précises de Tycho Brahe, le conduit à renoncer à l''hypothèse d''un mouvement circulaire – admise depuis Aristote – au profit d''une orbite elliptique. Ce travail amène Kepler à la découverte des deux premières lois qui vont immortaliser son nom. Il les publie en 1609 dans son Astronomia nova. La première énonce que chaque planète décrit dans le sens direct une ellipse dont le Soleil occupe un des foyers ; la seconde, que les aires décrites par le rayon vecteur allant du centre de la planète au centre du Soleil sont proportionnelles aux temps employés à les décrire. Kepler s''efforce ensuite de démontrer l''existence d''un rapport harmonique (au sens musical du terme) entre la plus grande et la plus petite vitesse des planètes. Il découvre ainsi la troisième loi fondamentale du mouvement des planètes, qu''il publie en 1619 dans son Harmonices mundi : les carrés des périodes de révolution des planètes sont proportionnels aux cubes des grands axes de leurs orbites. 
Lors de leur publication, les lois de Kepler reçoivent un accueil mitigé :<en ref="7" >Galilée</en>, par exemple, ne se ralliera jamais à l''idée du mouvement elliptique. Dans un premier temps, elles ne connaissent qu''un succès indirect : elles permettent de calculer des tables et des éphémérides astronomiques en excellent accord avec les observations. C''est Newton qui leur donnera une portée très générale, en montrant qu''elles découlent de la loi de l''attraction universelle et qu''elles s''appliquent à tout corps en mouvement orbital autour d''un autre, notamment aux satellites des planètes. 
Dans les dernières années de sa vie, Kepler s''attache à établir des tables des positions des planètes, fondées sur les lois qu''il a mises en évidence. Cette tâche requiert de longs calculs, heureusement abrégés par l''invention récente des logarithmes. Elle aboutit à la publication, en 1627, des Tabulae rudolphinae (Tables rudolphines, ainsi nommées en hommage à l''empereur Rodolphe II), qui surpassent largement en précision toutes celles publiées auparavant. 
Kepler meurt en 1630, dans un grand dénuement, mais livre encore, grâce à son gendre Jacob Bartsch (1600-1633), une œuvre posthume, Somnium seu astronomia lunari, véritable roman de science-fiction sur le thème du voyage vers la Lune. 

Source : http://www.larousse.fr/encyclopedie/personnage/Johannes_Kepler/127297
</ud>

<ud>
<eud>Nicolas Claude Fabri de Peiresc</eud>
<seg ana="14">Savant français</seg> (Belgentier, Var, 1580-Aix-en-Provence 1637). 
Il fut l''un des premiers utilisateurs français de la lunette de<en ref="7" >Galilée</en> et découvrit en 1611 la nébuleuse d''Orion. 
Source : http://www.larousse.fr/encyclopedie/litterature/Peiresc/175946
</ud>

<ud>
<eud>Nicolas Claude Fabri de Peiresc</eud>
Cet article est extrait de l''ouvrage Larousse « Dictionnaire mondial des littératures ». 
<seg ana="14">Érudit et collectionneur français</seg> (Belgentier, Provence, 1580 – Aix-en-Provence 1637). 
Ce conseiller au parlement d''Aix voyagea à travers l''Europe et se lia avec les grands collectionneurs et bibliothécaires de son temps. Secrétaire du garde des sceaux Guillaume du Vair en 1616, il devient un membre assidu de l''Académie des frères Dupuy (où il rencontre Gassendi, Guez de Balzac, Ducange). Témoin typique de la curiosité du xviie siècle, il réunit et observe les choses et les faits curieux dont on peut mesurer l''ampleur dans la correspondance qu''il a laissée. 
 Source : http://www.larousse.fr/encyclopedie/litterature/Peiresc/175946
</ud>

<ud>
<eud>Pierre Gassend, dit Gassendi</eud>
<seg ana="14"><ro ref="18 19"  type="cs" ana="10 999">Philosophe et savant français</ro></seg> (Champtercier, près de Digne-les-Bains, 1592-Paris 1655). 
Docteur en théologie à Avignon en 1614, il entra dans les ordres en 1615. Résidant le plus souvent à Paris, il enseigna les mathématiques au Collège royal de 1645 à 1648. Il critiqua Aristote, sans oser publier tous les livres où il faisait part de ses remarques, répondit à Descartes (Objections aux Méditations, 1644), développa une théorie atomiste à la manière de Démocrite, à laquelle il superposa une perspective harmoniste des éléments qui composent le monde. En astronomie, il fut un pionnier de l''observation des planètes à la lunette et fit la première description scientifique d''une aurore boréale (1621). En physique, il a étudié la chute des corps et les lois du choc, expliqué la hauteur des sons et mesuré leur vitesse de propagation. 

Source : http://www.larousse.fr/encyclopedie/personnage/Pierre_Gassend_dit_Gassendi/120894
</ud></root>', 8, NULL, '{ud0_8|20}
{eud_9}Johannes Kepler{/eud}

{seg_8|999}De {dat1574_dd}1574{/dat} {dat1576r_df}pendant deux ans{/dat}, il vit chez ses grands-parents.{/seg}

{seg_14}Astronome allemand{/seg} ({in0_11}{en2ai_10}{/en}Weil, aujourd''hui {en0li}Weil der Stadt{/en}, Wurtemberg, {dat1571}1571{/dat}{/in}-Ratisbonne 1630). 
Lois de Kepler 
{seg}{en0cs_14|999}Savant{/en} génial et obstiné{/seg}, il est l''un des fondateurs de l''astronomie moderne. Sa découverte, purement empirique, des {en0oa}lois du {en0oa}mouvement{/en}{/en} des planètes a bouleversé la pensée de son époque et ouvert la voie à {en0}Newton{/en}. 
Une enfance dure, mais une intelligence précoce
Johannes Kepler connaît une enfance assez dure, dans une ambiance familiale peu propice à l''éveil d''une vocation scientifique. Son père, mercenaire dans l''armée du duc de Wurtenberg, est un « soldat brutal, querelleur et immoral » souvent en campagne et qui finira par abandonner sa famille ; sa mère fera l''objet d''un procès en sorcellerie. Atteint de la variole à 3 ans, l''enfant en conservera toute sa vie des séquelles et une santé précaire.{seg_8}De {dat1574_dd}1574{/dat} {dat1576r_df}pendant deux ans{/dat}, il vit chez ses grands-parents.{/seg} Il accompagne ensuite ses parents à Leonberg, où il fréquente l''école latine. En 1584, il est admis au séminaire protestant d''Adelberg. Le duc de Wurtenberg le repère et décide de le prendre sous sa tutelle : en 1589, il rejoint l''université de Tübingen, où il reçoit une formation très complète. Son professeur d''astronomie, Michael Mästlin, lui enseigne le système de Copernic, dont il est un prudent défenseur. Diplômé de l''université en 1591, Kepler poursuit des études de théologie, avec le projet de devenir pasteur. Mais c''est finalement vers la science qu''il va se tourner, car il est nommé, en 1594, professeur de mathématiques à Graz. Lorsque, vers 1600, les persécutions religieuses contre les protestants l''obligent à quitter cette ville, il se réfugie à Prague, où il devient le disciple et l''assistant de l''astronome danois Tycho Brahe, auquel il succède, en 1601, comme astronome de l''empereur Rodolphe II. 
Le découvreur des lois du mouvement des planètes
Devenu grâce à Mästlin un partisan convaincu de l''héliocentrisme, Kepler explique dans un premier ouvrage, le Prodomus… mysterium cosmographicum, publié en 1596, pourquoi le système de Ptolémée doit, selon lui, céder la place à la représentation copernicienne du monde. Mais, hanté par les idées pythagoriciennes, il croit l''Univers construit selon une architecture géométrique. Aussi élabore-t-il un ingénieux modèle géométrique du système de Copernic, dans lequel l''orbe de chaque planète occupe une sphère circonscrite à un polyèdre régulier et inscrite dans un autre. En fait, il a la conviction que le nombre de planètes, leurs distances au Soleil et leurs vitesses de révolution ne sont pas le fruit du hasard. Une étude systématique du mouvement de la planète Mars (dont la trajectoire reste mal interprétée par Ptolémée et par Copernic), après de laborieux calculs qu''il contrôle grâce aux observations précises de Tycho Brahe, le conduit à renoncer à l''hypothèse d''un mouvement circulaire – admise depuis Aristote – au profit d''une orbite elliptique. Ce travail amène Kepler à la découverte des deux premières lois qui vont immortaliser son nom. Il les publie en 1609 dans son Astronomia nova. La première énonce que chaque planète décrit dans le sens direct une ellipse dont le Soleil occupe un des foyers ; la seconde, que les aires décrites par le rayon vecteur allant du centre de la planète au centre du Soleil sont proportionnelles aux temps employés à les décrire. Kepler s''efforce ensuite de démontrer l''existence d''un rapport harmonique (au sens musical du terme) entre la plus grande et la plus petite vitesse des planètes. Il découvre ainsi la troisième loi fondamentale du mouvement des planètes, qu''il publie en 1619 dans son Harmonices mundi : les carrés des périodes de révolution des planètes sont proportionnels aux cubes des grands axes de leurs orbites. 
Lors de leur publication, les lois de Kepler reçoivent un accueil mitigé :{en7}Galilée{/en}, par exemple, ne se ralliera jamais à l''idée du mouvement elliptique. Dans un premier temps, elles ne connaissent qu''un succès indirect : elles permettent de calculer des tables et des éphémérides astronomiques en excellent accord avec les observations. C''est Newton qui leur donnera une portée très générale, en montrant qu''elles découlent de la loi de l''attraction universelle et qu''elles s''appliquent à tout corps en mouvement orbital autour d''un autre, notamment aux satellites des planètes. 
Dans les dernières années de sa vie, Kepler s''attache à établir des tables des positions des planètes, fondées sur les lois qu''il a mises en évidence. Cette tâche requiert de longs calculs, heureusement abrégés par l''invention récente des logarithmes. Elle aboutit à la publication, en 1627, des Tabulae rudolphinae (Tables rudolphines, ainsi nommées en hommage à l''empereur Rodolphe II), qui surpassent largement en précision toutes celles publiées auparavant. 
Kepler meurt en 1630, dans un grand dénuement, mais livre encore, grâce à son gendre Jacob Bartsch (1600-1633), une œuvre posthume, Somnium seu astronomia lunari, véritable roman de science-fiction sur le thème du voyage vers la Lune. 

Source : http://www.larousse.fr/encyclopedie/personnage/Johannes_Kepler/127297
{/ud}

{ud0}
{eud}Nicolas Claude Fabri de Peiresc{/eud}
{seg_14}Savant français{/seg} (Belgentier, Var, 1580-Aix-en-Provence 1637). 
Il fut l''un des premiers utilisateurs français de la lunette de{en7}Galilée{/en} et découvrit en 1611 la nébuleuse d''Orion. 
Source : http://www.larousse.fr/encyclopedie/litterature/Peiresc/175946
{/ud}

{ud0}
{eud}Nicolas Claude Fabri de Peiresc{/eud}
Cet article est extrait de l''ouvrage Larousse « Dictionnaire mondial des littératures ». 
{seg_14}Érudit et collectionneur français{/seg} (Belgentier, Provence, 1580 – Aix-en-Provence 1637). 
Ce conseiller au parlement d''Aix voyagea à travers l''Europe et se lia avec les grands collectionneurs et bibliothécaires de son temps. Secrétaire du garde des sceaux Guillaume du Vair en 1616, il devient un membre assidu de l''Académie des frères Dupuy (où il rencontre Gassendi, Guez de Balzac, Ducange). Témoin typique de la curiosité du xviie siècle, il réunit et observe les choses et les faits curieux dont on peut mesurer l''ampleur dans la correspondance qu''il a laissée. 
 Source : http://www.larousse.fr/encyclopedie/litterature/Peiresc/175946
{/ud}

{ud0}
{eud}Pierre Gassend, dit Gassendi{/eud}
{seg_14}{ro18|19cs_10|999}Philosophe et savant français{/ro}{/seg} (Champtercier, près de Digne-les-Bains, 1592-Paris 1655). 
Docteur en théologie à Avignon en 1614, il entra dans les ordres en 1615. Résidant le plus souvent à Paris, il enseigna les mathématiques au Collège royal de 1645 à 1648. Il critiqua Aristote, sans oser publier tous les livres où il faisait part de ses remarques, répondit à Descartes (Objections aux Méditations, 1644), développa une théorie atomiste à la manière de Démocrite, à laquelle il superposa une perspective harmoniste des éléments qui composent le monde. En astronomie, il fut un pionnier de l''observation des planètes à la lunette et fit la première description scientifique d''une aurore boréale (1621). En physique, il a étudié la chute des corps et les lois du choc, expliqué la hauteur des sons et mesuré leur vitesse de propagation. 

Source : http://www.larousse.fr/encyclopedie/personnage/Pierre_Gassend_dit_Gassendi/120894
{/ud}', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (2, 'Astronome, mathématicien de l''empereur du Saint-Empire', NULL, '2015-09-25 22:41:54.367439+02', '2015-10-04 22:52:57.837407+02', NULL, NULL, NULL, NULL, NULL, 1, 'm', NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (7, 'Astronome et mathématicien', NULL, '2015-09-28 22:42:59.619909+02', '2015-10-04 23:06:33.201954+02', NULL, NULL, NULL, NULL, NULL, 1, 'm', NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (21, NULL, NULL, '2015-10-05 08:46:30.390569+02', NULL, NULL, NULL, 8.86666699999999963, 48.75, NULL, 9, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (22, 'Associe un objet qui localiser l''unité de connaissance', NULL, '2015-10-05 08:48:23.727187+02', NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (23, 'Associe l''acteur concern; par l''UC ''naissance''', NULL, '2015-10-05 08:59:20.720318+02', NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (16, 'Celui ou celle qui pratique ou enseigne les mathématiques', NULL, '2015-10-03 09:57:19.385319+02', '2015-10-05 09:08:21.000977+02', NULL, NULL, NULL, NULL, NULL, 4, NULL, 'test', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (17, NULL, NULL, '2015-10-03 09:57:48.242165+02', '2015-10-05 13:51:05.754774+02', NULL, NULL, NULL, NULL, NULL, 1, 'm', NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (15, 'Discipline enseignée dans les universités qui s''intéresse aux nombres et à leurs relations', NULL, '2015-10-02 23:54:54.414336+02', '2015-10-05 13:52:36.540175+02', NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (8, 'Type de segment', NULL, '2015-09-30 17:26:14.167382+02', '2015-10-04 07:38:56.716102+02', NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (9, 'Premier niveau de titre', NULL, '2015-09-30 17:31:31.168992+02', '2015-10-04 07:39:14.467435+02', NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (14, 'En quelques mots l''essentiel de l''activité de l''acteur est résumé', NULL, '2015-09-30 23:14:59.243403+02', '2015-10-04 07:39:28.32644+02', NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (18, 'Personne qui pratique ou enseigne la philosophie', NULL, '2015-10-04 08:15:39.193019+02', NULL, NULL, NULL, NULL, NULL, NULL, 4, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (19, 'Personne qui se consacre à l''étude des disciplines du savoir', NULL, '2015-10-04 08:38:15.524569+02', '2015-10-04 08:38:35.212498+02', NULL, NULL, NULL, NULL, NULL, 4, NULL, NULL, NULL);


--
-- TOC entry 2401 (class 0 OID 0)
-- Dependencies: 180
-- Name: objet_cle_objet_seq; Type: SEQUENCE SET; Schema: objets; Owner: -
--

SELECT pg_catalog.setval('objet_cle_objet_seq', 23, true);


--
-- TOC entry 2238 (class 2606 OID 22785)
-- Name: associer_objets_pkey; Type: CONSTRAINT; Schema: objets; Owner: -; Tablespace: 
--

ALTER TABLE ONLY association_objets
    ADD CONSTRAINT associer_objets_pkey PRIMARY KEY (pk_association_objets);


--
-- TOC entry 2247 (class 2606 OID 22826)
-- Name: date_objet_pkey; Type: CONSTRAINT; Schema: objets; Owner: -; Tablespace: 
--

ALTER TABLE ONLY date_objet
    ADD CONSTRAINT date_objet_pkey PRIMARY KEY (pk_date_objet);


--
-- TOC entry 2243 (class 2606 OID 22787)
-- Name: nom_objet_pkey; Type: CONSTRAINT; Schema: objets; Owner: -; Tablespace: 
--

ALTER TABLE ONLY nom_objet
    ADD CONSTRAINT nom_objet_pkey PRIMARY KEY (pk_nom_objet);


--
-- TOC entry 2245 (class 2606 OID 22789)
-- Name: objet_pkey; Type: CONSTRAINT; Schema: objets; Owner: -; Tablespace: 
--

ALTER TABLE ONLY objet
    ADD CONSTRAINT objet_pkey PRIMARY KEY (pk_objet);


--
-- TOC entry 2239 (class 1259 OID 22794)
-- Name: idx_fk_objet; Type: INDEX; Schema: objets; Owner: -; Tablespace: 
--

CREATE INDEX idx_fk_objet ON nom_objet USING btree (fk_objet);


--
-- TOC entry 2240 (class 1259 OID 22795)
-- Name: nom_objet_langue_idx; Type: INDEX; Schema: objets; Owner: -; Tablespace: 
--

CREATE INDEX nom_objet_langue_idx ON nom_objet USING btree (langue);


--
-- TOC entry 2241 (class 1259 OID 22796)
-- Name: nom_objet_nom_idx; Type: INDEX; Schema: objets; Owner: -; Tablespace: 
--

CREATE INDEX nom_objet_nom_idx ON nom_objet USING btree (nom);


--
-- TOC entry 2250 (class 2620 OID 22797)
-- Name: update_associer_objets_creatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_associer_objets_creatime BEFORE INSERT ON association_objets FOR EACH ROW EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 2251 (class 2620 OID 22798)
-- Name: update_associer_objets_updatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_associer_objets_updatime BEFORE UPDATE ON association_objets FOR EACH ROW EXECUTE PROCEDURE update_updated_column();


--
-- TOC entry 2256 (class 2620 OID 22832)
-- Name: update_date_objet_creatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_date_objet_creatime BEFORE INSERT ON date_objet FOR EACH ROW EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 2257 (class 2620 OID 22833)
-- Name: update_date_objet_updatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_date_objet_updatime BEFORE UPDATE ON date_objet FOR EACH ROW EXECUTE PROCEDURE update_updated_column();


--
-- TOC entry 2252 (class 2620 OID 22799)
-- Name: update_nom_objet_creatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_nom_objet_creatime BEFORE INSERT ON nom_objet FOR EACH ROW EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 2253 (class 2620 OID 22800)
-- Name: update_nom_objet_updatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_nom_objet_updatime BEFORE UPDATE ON nom_objet FOR EACH ROW EXECUTE PROCEDURE update_updated_column();


--
-- TOC entry 2254 (class 2620 OID 22801)
-- Name: update_objet_creatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_objet_creatime BEFORE INSERT ON objet FOR EACH ROW EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 2255 (class 2620 OID 22802)
-- Name: update_objet_updatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_objet_updatime BEFORE UPDATE ON objet FOR EACH ROW EXECUTE PROCEDURE update_updated_column();


--
-- TOC entry 2249 (class 2606 OID 22827)
-- Name: date_objet_fk_objet_fkey; Type: FK CONSTRAINT; Schema: objets; Owner: -
--

ALTER TABLE ONLY date_objet
    ADD CONSTRAINT date_objet_fk_objet_fkey FOREIGN KEY (fk_objet) REFERENCES objet(pk_objet) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 2248 (class 2606 OID 22808)
-- Name: nom_objet_fk_objet_fkey; Type: FK CONSTRAINT; Schema: objets; Owner: -
--

ALTER TABLE ONLY nom_objet
    ADD CONSTRAINT nom_objet_fk_objet_fkey FOREIGN KEY (fk_objet) REFERENCES objet(pk_objet) ON UPDATE CASCADE ON DELETE CASCADE;


-- Completed on 2015-10-05 13:56:52 CEST

--
-- PostgreSQL database dump complete
--

