<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                   ATTENTION!
 * If you see this message in your browser (Internet Explorer, Mozilla Firefox, Google Chrome, etc.)
 * this means that PHP is not properly installed on your web server. Please refer to the PHP manual
 * for more details: http://php.net/manual/install.php 
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */


    include_once dirname(__FILE__) . '/' . 'components/utils/check_utils.php';
    CheckPHPVersion();
    CheckTemplatesCacheFolderIsExistsAndWritable();


    include_once dirname(__FILE__) . '/' . 'phpgen_settings.php';
    include_once dirname(__FILE__) . '/' . 'database_engine/pgsql_engine.php';
    include_once dirname(__FILE__) . '/' . 'components/page.php';


    function GetConnectionOptions()
    {
        $result = GetGlobalConnectionOptions();
        $result['client_encoding'] = 'utf8';
        GetApplication()->GetUserAuthorizationStrategy()->ApplyIdentityToConnectionOptions($result);
        return $result;
    }

    
    // OnGlobalBeforePageExecute event handler
    
    
    // OnBeforePageExecute event handler
    
    
    
    class objets_date_objetPage extends Page
    {
        protected function DoBeforeCreate()
        {
            $this->dataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"objets"."date_objet"');
            $field = new IntegerField('pk_date_objet', null, null, true);
            $field->SetIsNotNull(true);
            $this->dataset->AddField($field, true);
            $field = new StringField('date_iso');
            $this->dataset->AddField($field, false);
            $field = new IntegerField('fk_type_date_param');
            $this->dataset->AddField($field, false);
            $field = new StringField('libelle_original_date');
            $this->dataset->AddField($field, false);
            $field = new StringField('notes');
            $this->dataset->AddField($field, false);
            $field = new StringField('descriptif');
            $this->dataset->AddField($field, false);
            $field = new IntegerField('fk_objet');
            $this->dataset->AddField($field, false);
            $field = new DateTimeField('date_creation');
            $this->dataset->AddField($field, false);
            $field = new DateTimeField('date_modification');
            $this->dataset->AddField($field, false);
            $field = new StringField('certitude');
            $this->dataset->AddField($field, false);
            $this->dataset->AddLookupField('fk_objet', 'vues.vm_objet_vue_de_base', new IntegerField('pk_objet'), new StringField('nom', 'fk_objet_nom', 'fk_objet_nom_vues_vm_objet_vue_de_base'), 'fk_objet_nom_vues_vm_objet_vue_de_base');
            $this->dataset->AddLookupField('fk_type_date_param', 'vues.vn_types_date', new IntegerField('pk_parametre_systeme'), new StringField('valeur', 'fk_type_date_param_valeur', 'fk_type_date_param_valeur_vues_vn_types_date'), 'fk_type_date_param_valeur_vues_vn_types_date');
            $this->dataset->AddLookupField('certitude', 'vues.vn_valeurs_type_certitude_date', new StringField('valeur'), new StringField('valeur', 'certitude_valeur', 'certitude_valeur_vues_vn_valeurs_type_certitude_date'), 'certitude_valeur_vues_vn_valeurs_type_certitude_date');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        public function GetPageList()
        {
            $currentPageCaption = $this->GetShortCaption();
            $result = new PageList($this);
            $result->AddGroup($this->RenderText('Objets'));
            $result->AddGroup($this->RenderText('Paramtres'));
            if (GetCurrentUserGrantForDataSource('vues.vm_objet_vue_de_base')->HasViewGrant())
                $result->AddPage(new PageLink($this->RenderText('Vue de base des objets'), 'vues.vm_objet_vue_de_base.php', $this->RenderText('Vue de base des objets'), $currentPageCaption == $this->RenderText('Vue de base des objets'), false, $this->RenderText('Objets')));
            if (GetCurrentUserGrantForDataSource('parametres.parametre_systeme')->HasViewGrant())
                $result->AddPage(new PageLink($this->RenderText('Paramtres'), 'parametres.parametre_systeme.php', $this->RenderText('Paramtres'), $currentPageCaption == $this->RenderText('Paramtres'), false, $this->RenderText('Paramtres')));
            if (GetCurrentUserGrantForDataSource('objets.date_objet')->HasViewGrant())
                $result->AddPage(new PageLink($this->RenderText('Dates des objets'), 'objets.date_objet.php', $this->RenderText('Dates des objets'), $currentPageCaption == $this->RenderText('Dates des objets'), false, $this->RenderText('Objets')));
            if (GetCurrentUserGrantForDataSource('objets.nom_objet')->HasViewGrant())
                $result->AddPage(new PageLink($this->RenderText('Noms des objets'), 'objets.nom_objet.php', $this->RenderText('Noms des objets'), $currentPageCaption == $this->RenderText('Noms des objets'), false, $this->RenderText('Objets')));
            if (GetCurrentUserGrantForDataSource('vues.vm_association_objets')->HasViewGrant())
                $result->AddPage(new PageLink($this->RenderText('Associations des objets source'), 'vues.vm_association_objets.php', $this->RenderText('Associations des objets source'), $currentPageCaption == $this->RenderText('Associations des objets source'), false, $this->RenderText('Objets')));
            if (GetCurrentUserGrantForDataSource('vues.vm_association_objets_inv')->HasViewGrant())
                $result->AddPage(new PageLink($this->RenderText('Associations des objets cible'), 'vues.vm_association_objets_inv.php', $this->RenderText('Associations des objets cible'), $currentPageCaption == $this->RenderText('Associations des objets cible'), false, $this->RenderText('Objets')));
            
            if ( HasAdminPage() && GetApplication()->HasAdminGrantForCurrentUser() ) {
              $result->AddGroup('Admin area');
              $result->AddPage(new PageLink($this->GetLocalizerCaptions()->GetMessageString('AdminPage'), 'phpgen_admin.php', $this->GetLocalizerCaptions()->GetMessageString('AdminPage'), false, false, 'Admin area'));
            }
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function CreateGridSearchControl(Grid $grid)
        {
            $grid->UseFilter = true;
            $grid->SearchControl = new SimpleSearch('objets_date_objetssearch', $this->dataset,
                array('fk_objet_nom', 'date_iso', 'fk_type_date_param_valeur', 'certitude_valeur', 'libelle_original_date', 'descriptif', 'notes', 'pk_date_objet', 'date_creation', 'date_modification'),
                array($this->RenderText('Fk Objet'), $this->RenderText('Date Iso'), $this->RenderText('Fk Type Date Param'), $this->RenderText('Certitude'), $this->RenderText('Libelle Original Date'), $this->RenderText('Descriptif'), $this->RenderText('Notes'), $this->RenderText('Pk Date Objet'), $this->RenderText('Date Creation'), $this->RenderText('Date Modification')),
                array(
                    '=' => $this->GetLocalizerCaptions()->GetMessageString('equals'),
                    '<>' => $this->GetLocalizerCaptions()->GetMessageString('doesNotEquals'),
                    '<' => $this->GetLocalizerCaptions()->GetMessageString('isLessThan'),
                    '<=' => $this->GetLocalizerCaptions()->GetMessageString('isLessThanOrEqualsTo'),
                    '>' => $this->GetLocalizerCaptions()->GetMessageString('isGreaterThan'),
                    '>=' => $this->GetLocalizerCaptions()->GetMessageString('isGreaterThanOrEqualsTo'),
                    'ILIKE' => $this->GetLocalizerCaptions()->GetMessageString('Like'),
                    'STARTS' => $this->GetLocalizerCaptions()->GetMessageString('StartsWith'),
                    'ENDS' => $this->GetLocalizerCaptions()->GetMessageString('EndsWith'),
                    'CONTAINS' => $this->GetLocalizerCaptions()->GetMessageString('Contains')
                    ), $this->GetLocalizerCaptions(), $this, 'CONTAINS'
                );
        }
    
        protected function CreateGridAdvancedSearchControl(Grid $grid)
        {
            $this->AdvancedSearchControl = new AdvancedSearchControl('objets_date_objetasearch', $this->dataset, $this->GetLocalizerCaptions(), $this->GetColumnVariableContainer(), $this->CreateLinkBuilder());
            $this->AdvancedSearchControl->setTimerInterval(1000);
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vm_objet_vue_de_base"');
            $field = new IntegerField('pk_objet');
            $lookupDataset->AddField($field, true);
            $field = new IntegerField('fk_type_objet_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('nom');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_nom_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('definition');
            $lookupDataset->AddField($field, false);
            $field = new StringField('date_iso');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_date_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('certitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('latitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('longitude');
            $lookupDataset->AddField($field, false);
            $field = new StringField('genre');
            $lookupDataset->AddField($field, false);
            $field = new StringField('notes');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new BooleanField('si_texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_creation');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_modification');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_nom_objet');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_date_objet');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('nom', GetOrderTypeAsSQL(otAscending));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateLookupSearchInput('fk_objet', $this->RenderText('Fk Objet'), $lookupDataset, 'pk_objet', 'nom', false, 8));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('date_iso', $this->RenderText('Date Iso')));
            
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vn_types_date"');
            $field = new IntegerField('pk_parametre_systeme');
            $lookupDataset->AddField($field, false);
            $field = new StringField('valeur');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('valeur', GetOrderTypeAsSQL(otAscending));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateLookupSearchInput('fk_type_date_param', $this->RenderText('Fk Type Date Param'), $lookupDataset, 'pk_parametre_systeme', 'valeur', false, 8));
            
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vn_valeurs_type_certitude_date"');
            $field = new IntegerField('pk_parametre_systeme');
            $lookupDataset->AddField($field, false);
            $field = new StringField('valeur');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('valeur', GetOrderTypeAsSQL(otAscending));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateLookupSearchInput('certitude', $this->RenderText('Certitude'), $lookupDataset, 'valeur', 'valeur', false, 8));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('libelle_original_date', $this->RenderText('Libelle Original Date')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('descriptif', $this->RenderText('Descriptif')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('notes', $this->RenderText('Notes')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('pk_date_objet', $this->RenderText('Pk Date Objet')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateDateTimeSearchInput('date_creation', $this->RenderText('Date Creation'), 'Y-m-d H:i:s'));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateDateTimeSearchInput('date_modification', $this->RenderText('Date Modification'), 'Y-m-d H:i:s'));
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actionsBandName = 'actions';
            $grid->AddBandToBegin($actionsBandName, $this->GetLocalizerCaptions()->GetMessageString('Actions'), true);
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $column = new ModalDialogEditRowColumn(
                    $this->GetLocalizerCaptions()->GetMessageString('Edit'), $this->dataset,
                    $this->GetLocalizerCaptions()->GetMessageString('Edit'),
                    $this->GetModalGridEditingHandler());
                $grid->AddViewColumn($column, $actionsBandName);
                $column->SetImagePath('images/edit_action.png');
                $column->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            if ($this->GetSecurityInfo()->HasDeleteGrant())
            {
                $column = new RowOperationByLinkColumn($this->GetLocalizerCaptions()->GetMessageString('Delete'), OPERATION_DELETE, $this->dataset);
                $grid->AddViewColumn($column, $actionsBandName);
                $column->SetImagePath('images/delete_action.png');
                $column->OnShow->AddListener('ShowDeleteButtonHandler', $this);
                $column->SetAdditionalAttribute('data-modal-delete', 'true');
                $column->SetAdditionalAttribute('data-delete-handler-name', $this->GetModalGridDeleteHandler());
            }
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $column = new ModalDialogCopyRowColumn(
                    $this->GetLocalizerCaptions()->GetMessageString('Copy'), $this->dataset,
                    $this->GetLocalizerCaptions()->GetMessageString('Copy'),
                    $this->GetModalGridCopyHandler());
                $grid->AddViewColumn($column, $actionsBandName);
                $column->SetImagePath('images/copy_action.png');
            }
        }
    
        protected function AddFieldColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('fk_objet_nom', 'Fk Objet', $this->dataset);
            $column->SetOrderable(true);
            $column = new ExtendedHyperLinkColumnDecorator($column, $this->dataset, 'vues.vm_objet_vue_de_base.php?operation=edit&pk0=%fk_objet%' , '_blank');
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for date_iso field
            //
            $column = new TextViewColumn('date_iso', 'Date Iso', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for valeur field
            //
            $column = new TextViewColumn('fk_type_date_param_valeur', 'Fk Type Date Param', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for valeur field
            //
            $column = new TextViewColumn('certitude_valeur', 'Certitude', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for libelle_original_date field
            //
            $column = new TextViewColumn('libelle_original_date', 'Libelle Original Date', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('objets_date_objetGrid_libelle_original_date_handler_list');
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for descriptif field
            //
            $column = new TextViewColumn('descriptif', 'Descriptif', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('objets_date_objetGrid_descriptif_handler_list');
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('objets_date_objetGrid_notes_handler_list');
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for pk_date_objet field
            //
            $column = new TextViewColumn('pk_date_objet', 'Pk Date Objet', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for date_creation field
            //
            $column = new DateTimeViewColumn('date_creation', 'Date Creation', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for date_modification field
            //
            $column = new DateTimeViewColumn('date_modification', 'Date Modification', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('fk_objet_nom', 'Fk Objet', $this->dataset);
            $column->SetOrderable(true);
            $column = new ExtendedHyperLinkColumnDecorator($column, $this->dataset, 'vues.vm_objet_vue_de_base.php?operation=edit&pk0=%fk_objet%' , '_blank');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_iso field
            //
            $column = new TextViewColumn('date_iso', 'Date Iso', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for valeur field
            //
            $column = new TextViewColumn('fk_type_date_param_valeur', 'Fk Type Date Param', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for valeur field
            //
            $column = new TextViewColumn('certitude_valeur', 'Certitude', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for libelle_original_date field
            //
            $column = new TextViewColumn('libelle_original_date', 'Libelle Original Date', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('objets_date_objetGrid_libelle_original_date_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for descriptif field
            //
            $column = new TextViewColumn('descriptif', 'Descriptif', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('objets_date_objetGrid_descriptif_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('objets_date_objetGrid_notes_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for pk_date_objet field
            //
            $column = new TextViewColumn('pk_date_objet', 'Pk Date Objet', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_creation field
            //
            $column = new DateTimeViewColumn('date_creation', 'Date Creation', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_modification field
            //
            $column = new DateTimeViewColumn('date_modification', 'Date Modification', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for fk_objet field
            //
            $editor = new ComboBox('fk_objet_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vm_objet_vue_de_base"');
            $field = new IntegerField('pk_objet');
            $lookupDataset->AddField($field, true);
            $field = new IntegerField('fk_type_objet_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('nom');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_nom_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('definition');
            $lookupDataset->AddField($field, false);
            $field = new StringField('date_iso');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_date_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('certitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('latitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('longitude');
            $lookupDataset->AddField($field, false);
            $field = new StringField('genre');
            $lookupDataset->AddField($field, false);
            $field = new StringField('notes');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new BooleanField('si_texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_creation');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_modification');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_nom_objet');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_date_objet');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('nom', GetOrderTypeAsSQL(otAscending));
            $editColumn = new LookUpEditColumn(
                'Fk Objet', 
                'fk_objet', 
                $editor, 
                $this->dataset, 'pk_objet', 'nom', $lookupDataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_iso field
            //
            $editor = new TextEdit('date_iso_edit');
            $editor->SetSize(59);
            $editor->SetMaxLength(59);
            $editColumn = new CustomEditColumn('Date Iso', 'date_iso', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fk_type_date_param field
            //
            $editor = new ComboBox('fk_type_date_param_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vn_types_date"');
            $field = new IntegerField('pk_parametre_systeme');
            $lookupDataset->AddField($field, false);
            $field = new StringField('valeur');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('valeur', GetOrderTypeAsSQL(otAscending));
            $editColumn = new LookUpEditColumn(
                'Fk Type Date Param', 
                'fk_type_date_param', 
                $editor, 
                $this->dataset, 'pk_parametre_systeme', 'valeur', $lookupDataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for certitude field
            //
            $editor = new ComboBox('certitude_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vn_valeurs_type_certitude_date"');
            $field = new IntegerField('pk_parametre_systeme');
            $lookupDataset->AddField($field, false);
            $field = new StringField('valeur');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('valeur', GetOrderTypeAsSQL(otAscending));
            $editColumn = new LookUpEditColumn(
                'Certitude', 
                'certitude', 
                $editor, 
                $this->dataset, 'valeur', 'valeur', $lookupDataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for libelle_original_date field
            //
            $editor = new TextAreaEdit('libelle_original_date_edit', 50, 8);
            $editColumn = new CustomEditColumn('Libelle Original Date', 'libelle_original_date', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for descriptif field
            //
            $editor = new TextAreaEdit('descriptif_edit', 50, 8);
            $editColumn = new CustomEditColumn('Descriptif', 'descriptif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for notes field
            //
            $editor = new TextAreaEdit('notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_creation field
            //
            $editor = new DateTimeEdit('date_creation_edit', true, 'Y-m-d H:i:s', GetFirstDayOfWeek());
            $editColumn = new CustomEditColumn('Date Creation', 'date_creation', $editor, $this->dataset);
            $editColumn->SetReadOnly(true);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_modification field
            //
            $editor = new DateTimeEdit('date_modification_edit', true, 'Y-m-d H:i:s', GetFirstDayOfWeek());
            $editColumn = new CustomEditColumn('Date Modification', 'date_modification', $editor, $this->dataset);
            $editColumn->SetReadOnly(true);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for fk_objet field
            //
            $editor = new ComboBox('fk_objet_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vm_objet_vue_de_base"');
            $field = new IntegerField('pk_objet');
            $lookupDataset->AddField($field, true);
            $field = new IntegerField('fk_type_objet_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('nom');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_nom_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('definition');
            $lookupDataset->AddField($field, false);
            $field = new StringField('date_iso');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_date_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('certitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('latitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('longitude');
            $lookupDataset->AddField($field, false);
            $field = new StringField('genre');
            $lookupDataset->AddField($field, false);
            $field = new StringField('notes');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new BooleanField('si_texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_creation');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_modification');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_nom_objet');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_date_objet');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('nom', GetOrderTypeAsSQL(otAscending));
            $editColumn = new LookUpEditColumn(
                'Fk Objet', 
                'fk_objet', 
                $editor, 
                $this->dataset, 'pk_objet', 'nom', $lookupDataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_iso field
            //
            $editor = new TextEdit('date_iso_edit');
            $editor->SetSize(59);
            $editor->SetMaxLength(59);
            $editColumn = new CustomEditColumn('Date Iso', 'date_iso', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fk_type_date_param field
            //
            $editor = new ComboBox('fk_type_date_param_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vn_types_date"');
            $field = new IntegerField('pk_parametre_systeme');
            $lookupDataset->AddField($field, false);
            $field = new StringField('valeur');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('valeur', GetOrderTypeAsSQL(otAscending));
            $editColumn = new LookUpEditColumn(
                'Fk Type Date Param', 
                'fk_type_date_param', 
                $editor, 
                $this->dataset, 'pk_parametre_systeme', 'valeur', $lookupDataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for certitude field
            //
            $editor = new ComboBox('certitude_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vn_valeurs_type_certitude_date"');
            $field = new IntegerField('pk_parametre_systeme');
            $lookupDataset->AddField($field, false);
            $field = new StringField('valeur');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('valeur', GetOrderTypeAsSQL(otAscending));
            $editColumn = new LookUpEditColumn(
                'Certitude', 
                'certitude', 
                $editor, 
                $this->dataset, 'valeur', 'valeur', $lookupDataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for libelle_original_date field
            //
            $editor = new TextAreaEdit('libelle_original_date_edit', 50, 8);
            $editColumn = new CustomEditColumn('Libelle Original Date', 'libelle_original_date', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for descriptif field
            //
            $editor = new TextAreaEdit('descriptif_edit', 50, 8);
            $editColumn = new CustomEditColumn('Descriptif', 'descriptif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for notes field
            //
            $editor = new TextAreaEdit('notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_creation field
            //
            $editor = new DateTimeEdit('date_creation_edit', true, 'Y-m-d H:i:s', GetFirstDayOfWeek());
            $editColumn = new CustomEditColumn('Date Creation', 'date_creation', $editor, $this->dataset);
            $editColumn->SetReadOnly(true);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_modification field
            //
            $editor = new DateTimeEdit('date_modification_edit', true, 'Y-m-d H:i:s', GetFirstDayOfWeek());
            $editColumn = new CustomEditColumn('Date Modification', 'date_modification', $editor, $this->dataset);
            $editColumn->SetReadOnly(true);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $grid->SetShowAddButton(true);
                $grid->SetShowInlineAddButton(false);
            }
            else
            {
                $grid->SetShowInlineAddButton(false);
                $grid->SetShowAddButton(false);
            }
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('fk_objet_nom', 'Fk Objet', $this->dataset);
            $column->SetOrderable(true);
            $column = new ExtendedHyperLinkColumnDecorator($column, $this->dataset, 'vues.vm_objet_vue_de_base.php?operation=edit&pk0=%fk_objet%' , '_blank');
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_iso field
            //
            $column = new TextViewColumn('date_iso', 'Date Iso', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for valeur field
            //
            $column = new TextViewColumn('fk_type_date_param_valeur', 'Fk Type Date Param', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for valeur field
            //
            $column = new TextViewColumn('certitude_valeur', 'Certitude', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for libelle_original_date field
            //
            $column = new TextViewColumn('libelle_original_date', 'Libelle Original Date', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for descriptif field
            //
            $column = new TextViewColumn('descriptif', 'Descriptif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for pk_date_objet field
            //
            $column = new TextViewColumn('pk_date_objet', 'Pk Date Objet', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_creation field
            //
            $column = new DateTimeViewColumn('date_creation', 'Date Creation', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_modification field
            //
            $column = new DateTimeViewColumn('date_modification', 'Date Modification', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('fk_objet_nom', 'Fk Objet', $this->dataset);
            $column->SetOrderable(true);
            $column = new ExtendedHyperLinkColumnDecorator($column, $this->dataset, 'vues.vm_objet_vue_de_base.php?operation=edit&pk0=%fk_objet%' , '_blank');
            $grid->AddExportColumn($column);
            
            //
            // View column for date_iso field
            //
            $column = new TextViewColumn('date_iso', 'Date Iso', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for valeur field
            //
            $column = new TextViewColumn('fk_type_date_param_valeur', 'Fk Type Date Param', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for valeur field
            //
            $column = new TextViewColumn('certitude_valeur', 'Certitude', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for libelle_original_date field
            //
            $column = new TextViewColumn('libelle_original_date', 'Libelle Original Date', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for descriptif field
            //
            $column = new TextViewColumn('descriptif', 'Descriptif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for pk_date_objet field
            //
            $column = new TextViewColumn('pk_date_objet', 'Pk Date Objet', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_creation field
            //
            $column = new DateTimeViewColumn('date_creation', 'Date Creation', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_modification field
            //
            $column = new DateTimeViewColumn('date_modification', 'Date Modification', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
        public function GetModalGridEditingHandler() { return 'objets_date_objet_inline_edit'; }
        protected function GetEnableModalGridEditing() { return true; }
        public function ShowEditButtonHandler(&$show)
        {
            if ($this->GetRecordPermission() != null)
                $show = $this->GetRecordPermission()->HasEditGrant($this->GetDataset());
        }
        public function ShowDeleteButtonHandler(&$show)
        {
            if ($this->GetRecordPermission() != null)
                $show = $this->GetRecordPermission()->HasDeleteGrant($this->GetDataset());
        }
        
        public function GetModalGridDeleteHandler() { return 'objets_date_objet_modal_delete'; }
        protected function GetEnableModalGridDelete() { return true; }
        
        public function GetModalGridCopyHandler() { return 'objets_date_objet_inline_edit'; }
        protected function GetEnableModalGridCopy() { return true; }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset, 'objets_date_objetGrid');
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(false);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetDefaultOrdering('fk_objet_nom', otAscending);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(false);
            $result->SetUseModalInserting(true);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
            $this->CreateGridSearchControl($result);
            $this->CreateGridAdvancedSearchControl($result);
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
    
            $this->SetShowPageList(true);
            $this->SetHidePageListByDefault(false);
            $this->SetExportToExcelAvailable(true);
            $this->SetExportToWordAvailable(true);
            $this->SetExportToXmlAvailable(true);
            $this->SetExportToCsvAvailable(true);
            $this->SetExportToPdfAvailable(true);
            $this->SetPrinterFriendlyAvailable(true);
            $this->SetSimpleSearchAvailable(true);
            $this->SetAdvancedSearchAvailable(true);
            $this->SetFilterRowAvailable(true);
            $this->SetVisualEffectsEnabled(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(true);
    
            //
            // Http Handlers
            //
            //
            // View column for libelle_original_date field
            //
            $column = new TextViewColumn('libelle_original_date', 'Libelle Original Date', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'objets_date_objetGrid_libelle_original_date_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for descriptif field
            //
            $column = new TextViewColumn('descriptif', 'Descriptif', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'objets_date_objetGrid_descriptif_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'objets_date_objetGrid_notes_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);//
            // View column for libelle_original_date field
            //
            $column = new TextViewColumn('libelle_original_date', 'Libelle Original Date', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'objets_date_objetGrid_libelle_original_date_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for descriptif field
            //
            $column = new TextViewColumn('descriptif', 'Descriptif', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'objets_date_objetGrid_descriptif_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'objets_date_objetGrid_notes_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            return $result;
        }
        
        public function OpenAdvancedSearchByDefault()
        {
            return false;
        }
    
        protected function DoGetGridHeader()
        {
            return '';
        }
    }



    try
    {
        $Page = new objets_date_objetPage("objets.date_objet.php", "objets_date_objet", GetCurrentUserGrantForDataSource("objets.date_objet"), 'UTF-8');
        $Page->SetShortCaption('Dates des objets');
        $Page->SetHeader(GetPagesHeader());
        $Page->SetFooter(GetPagesFooter());
        $Page->SetCaption('Dates des objets');
        $Page->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource("objets.date_objet"));
        GetApplication()->SetEnableLessRunTimeCompile(GetEnableLessFilesRunTimeCompilation());
        GetApplication()->SetCanUserChangeOwnPassword(
            !function_exists('CanUserChangeOwnPassword') || CanUserChangeOwnPassword());
        GetApplication()->SetMainPage($Page);
        GetApplication()->Run();
    }
    catch(Exception $e)
    {
        ShowErrorPage($e->getMessage());
    }
	
