<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                   ATTENTION!
 * If you see this message in your browser (Internet Explorer, Mozilla Firefox, Google Chrome, etc.)
 * this means that PHP is not properly installed on your web server. Please refer to the PHP manual
 * for more details: http://php.net/manual/install.php 
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */


    include_once dirname(__FILE__) . '/' . 'components/utils/check_utils.php';
    CheckPHPVersion();
    CheckTemplatesCacheFolderIsExistsAndWritable();


    include_once dirname(__FILE__) . '/' . 'phpgen_settings.php';
    include_once dirname(__FILE__) . '/' . 'database_engine/pgsql_engine.php';
    include_once dirname(__FILE__) . '/' . 'components/page.php';


    function GetConnectionOptions()
    {
        $result = GetGlobalConnectionOptions();
        $result['client_encoding'] = 'utf8';
        GetApplication()->GetUserAuthorizationStrategy()->ApplyIdentityToConnectionOptions($result);
        return $result;
    }

    
    // OnGlobalBeforePageExecute event handler
    
    
    // OnBeforePageExecute event handler
    
    
    
    class objets_nom_objetPage extends Page
    {
        protected function DoBeforeCreate()
        {
            $this->dataset = new TableDataset(
                new PgPDOConnectionFactory(),
                GetConnectionOptions(),
                '"objets"."nom_objet"');
            $field = new IntegerField('pk_nom_objet', null, null, true);
            $field->SetIsNotNull(true);
            $this->dataset->AddField($field, true);
            $field = new StringField('nom');
            $this->dataset->AddField($field, false);
            $field = new StringField('langue');
            $this->dataset->AddField($field, false);
            $field = new StringField('notes');
            $this->dataset->AddField($field, false);
            $field = new IntegerField('fk_objet');
            $this->dataset->AddField($field, false);
            $field = new BooleanField('est_standard');
            $this->dataset->AddField($field, false);
            $field = new DateTimeField('date_creation');
            $this->dataset->AddField($field, false);
            $field = new DateTimeField('date_modification');
            $this->dataset->AddField($field, false);
            $field = new IntegerField('fk_type_nom_param');
            $this->dataset->AddField($field, false);
            $field = new StringField('date_debut');
            $this->dataset->AddField($field, false);
            $field = new StringField('date_fin');
            $this->dataset->AddField($field, false);
            $this->dataset->AddLookupField('fk_objet', 'vues.vm_objet_vue_de_base', new IntegerField('pk_objet'), new StringField('nom', 'fk_objet_nom', 'fk_objet_nom_vues_vm_objet_vue_de_base'), 'fk_objet_nom_vues_vm_objet_vue_de_base');
            $this->dataset->AddLookupField('fk_type_nom_param', 'vues.vn_types_nom_objet', new IntegerField('pk_parametre_systeme'), new StringField('valeur', 'fk_type_nom_param_valeur', 'fk_type_nom_param_valeur_vues_vn_types_nom_objet'), 'fk_type_nom_param_valeur_vues_vn_types_nom_objet');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function CreateGridSearchControl(Grid $grid)
        {
            $grid->UseFilter = true;
            $grid->SearchControl = new SimpleSearch('objets_nom_objetssearch', $this->dataset,
                array('fk_objet_nom', 'nom', 'fk_type_nom_param_valeur', 'est_standard', 'langue', 'date_debut', 'date_fin', 'notes', 'pk_nom_objet', 'date_creation', 'date_modification'),
                array($this->RenderText('Fk Objet'), $this->RenderText('Nom'), $this->RenderText('Fk Type Nom Param'), $this->RenderText('Est Standard'), $this->RenderText('Langue'), $this->RenderText('Date Debut'), $this->RenderText('Date Fin'), $this->RenderText('Notes'), $this->RenderText('Pk Nom Objet'), $this->RenderText('Date Creation'), $this->RenderText('Date Modification')),
                array(
                    '=' => $this->GetLocalizerCaptions()->GetMessageString('equals'),
                    '<>' => $this->GetLocalizerCaptions()->GetMessageString('doesNotEquals'),
                    '<' => $this->GetLocalizerCaptions()->GetMessageString('isLessThan'),
                    '<=' => $this->GetLocalizerCaptions()->GetMessageString('isLessThanOrEqualsTo'),
                    '>' => $this->GetLocalizerCaptions()->GetMessageString('isGreaterThan'),
                    '>=' => $this->GetLocalizerCaptions()->GetMessageString('isGreaterThanOrEqualsTo'),
                    'ILIKE' => $this->GetLocalizerCaptions()->GetMessageString('Like'),
                    'STARTS' => $this->GetLocalizerCaptions()->GetMessageString('StartsWith'),
                    'ENDS' => $this->GetLocalizerCaptions()->GetMessageString('EndsWith'),
                    'CONTAINS' => $this->GetLocalizerCaptions()->GetMessageString('Contains')
                    ), $this->GetLocalizerCaptions(), $this, 'CONTAINS'
                );
        }
    
        protected function CreateGridAdvancedSearchControl(Grid $grid)
        {
            $this->AdvancedSearchControl = new AdvancedSearchControl('objets_nom_objetasearch', $this->dataset, $this->GetLocalizerCaptions(), $this->GetColumnVariableContainer(), $this->CreateLinkBuilder());
            $lookupDataset = new TableDataset(
                new PgPDOConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vm_objet_vue_de_base"');
            $field = new IntegerField('pk_objet');
            $lookupDataset->AddField($field, true);
            $field = new IntegerField('fk_type_objet_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('nom');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_nom_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('definition');
            $lookupDataset->AddField($field, false);
            $field = new StringField('date_iso');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_date_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('certitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('latitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('longitude');
            $lookupDataset->AddField($field, false);
            $field = new StringField('genre');
            $lookupDataset->AddField($field, false);
            $field = new StringField('notes');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new BooleanField('si_texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_creation');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_modification');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_nom_objet');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_date_objet');
            $lookupDataset->AddField($field, false);
            $lookupDataset->setOrderByField('nom', GetOrderTypeAsSQL(otAscending));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateLookupSearchInput('fk_objet', $this->RenderText('Fk Objet'), $lookupDataset, 'pk_objet', 'nom', false, 8));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('nom', $this->RenderText('Nom')));
            
            $lookupDataset = new TableDataset(
                new PgPDOConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vn_types_nom_objet"');
            $field = new IntegerField('pk_parametre_systeme');
            $lookupDataset->AddField($field, false);
            $field = new StringField('valeur');
            $lookupDataset->AddField($field, false);
            $lookupDataset->setOrderByField('valeur', GetOrderTypeAsSQL(otAscending));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateLookupSearchInput('fk_type_nom_param', $this->RenderText('Fk Type Nom Param'), $lookupDataset, 'pk_parametre_systeme', 'valeur', false, 8));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('est_standard', $this->RenderText('Est Standard')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('langue', $this->RenderText('Langue')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('date_debut', $this->RenderText('Date Debut')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('date_fin', $this->RenderText('Date Fin')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('notes', $this->RenderText('Notes')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('pk_nom_objet', $this->RenderText('Pk Nom Objet')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateDateTimeSearchInput('date_creation', $this->RenderText('Date Creation'), 'Y-m-d H:i:s'));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateDateTimeSearchInput('date_modification', $this->RenderText('Date Modification'), 'Y-m-d H:i:s'));
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new ModalEditOperation(
                    $this->GetLocalizerCaptions()->GetMessageString('Edit'),
                    $this->GetLocalizerCaptions()->GetMessageString('Edit'), $this->dataset,
                    $this->GetModalGridEditingHandler(), $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            if ($this->GetSecurityInfo()->HasDeleteGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Delete'), OPERATION_DELETE, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
                $operation->SetAdditionalAttribute('data-modal-operation', 'delete');
                $operation->SetAdditionalAttribute('data-delete-handler-name', $this->GetModalGridDeleteHandler());
            }
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new ModalCopyOperation(
                    $this->GetLocalizerCaptions()->GetMessageString('Copy'),
                    $this->GetLocalizerCaptions()->GetMessageString('Copy'), $this->dataset,
                    $this->GetModalGridCopyHandler(), $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('fk_objet_nom', 'Fk Objet', $this->dataset);
            $column->SetOrderable(true);
            $column = new ExtendedHyperLinkColumnDecorator($column, $this->dataset, 'vues.vm_objet_vue_de_base.php?operation=edit&pk0=%fk_objet%' , '_blank');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('objets_nom_objetGrid_nom_handler_list');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for valeur field
            //
            $column = new TextViewColumn('fk_type_nom_param_valeur', 'Fk Type Nom Param', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for est_standard field
            //
            $column = new TextViewColumn('est_standard', 'Est Standard', $this->dataset);
            $column->SetOrderable(true);
            $column = new CheckBoxFormatValueViewColumnDecorator($column);
            $column->SetDisplayValues($this->RenderText('<span class="pg-row-checkbox checked"></span>'), $this->RenderText('<span class="pg-row-checkbox"></span>'));
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for langue field
            //
            $column = new TextViewColumn('langue', 'Langue', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('objets_nom_objetGrid_langue_handler_list');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for date_debut field
            //
            $column = new TextViewColumn('date_debut', 'Date Debut', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for date_fin field
            //
            $column = new TextViewColumn('date_fin', 'Date Fin', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('objets_nom_objetGrid_notes_handler_list');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for pk_nom_objet field
            //
            $column = new TextViewColumn('pk_nom_objet', 'Pk Nom Objet', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for date_creation field
            //
            $column = new DateTimeViewColumn('date_creation', 'Date Creation', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for date_modification field
            //
            $column = new DateTimeViewColumn('date_modification', 'Date Modification', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('fk_objet_nom', 'Fk Objet', $this->dataset);
            $column->SetOrderable(true);
            $column = new ExtendedHyperLinkColumnDecorator($column, $this->dataset, 'vues.vm_objet_vue_de_base.php?operation=edit&pk0=%fk_objet%' , '_blank');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('objets_nom_objetGrid_nom_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for valeur field
            //
            $column = new TextViewColumn('fk_type_nom_param_valeur', 'Fk Type Nom Param', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for est_standard field
            //
            $column = new TextViewColumn('est_standard', 'Est Standard', $this->dataset);
            $column->SetOrderable(true);
            $column = new CheckBoxFormatValueViewColumnDecorator($column);
            $column->SetDisplayValues($this->RenderText('<span class="pg-row-checkbox checked"></span>'), $this->RenderText('<span class="pg-row-checkbox"></span>'));
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for langue field
            //
            $column = new TextViewColumn('langue', 'Langue', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('objets_nom_objetGrid_langue_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_debut field
            //
            $column = new TextViewColumn('date_debut', 'Date Debut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_fin field
            //
            $column = new TextViewColumn('date_fin', 'Date Fin', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('objets_nom_objetGrid_notes_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for pk_nom_objet field
            //
            $column = new TextViewColumn('pk_nom_objet', 'Pk Nom Objet', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_creation field
            //
            $column = new DateTimeViewColumn('date_creation', 'Date Creation', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_modification field
            //
            $column = new DateTimeViewColumn('date_modification', 'Date Modification', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for fk_objet field
            //
            $editor = new ComboBox('fk_objet_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $lookupDataset = new TableDataset(
                new PgPDOConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vm_objet_vue_de_base"');
            $field = new IntegerField('pk_objet');
            $lookupDataset->AddField($field, true);
            $field = new IntegerField('fk_type_objet_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('nom');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_nom_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('definition');
            $lookupDataset->AddField($field, false);
            $field = new StringField('date_iso');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_date_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('certitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('latitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('longitude');
            $lookupDataset->AddField($field, false);
            $field = new StringField('genre');
            $lookupDataset->AddField($field, false);
            $field = new StringField('notes');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new BooleanField('si_texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_creation');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_modification');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_nom_objet');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_date_objet');
            $lookupDataset->AddField($field, false);
            $lookupDataset->setOrderByField('nom', GetOrderTypeAsSQL(otAscending));
            $editColumn = new LookUpEditColumn(
                'Fk Objet', 
                'fk_objet', 
                $editor, 
                $this->dataset, 'pk_objet', 'nom', $lookupDataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for nom field
            //
            $editor = new TextAreaEdit('nom_edit', 50, 8);
            $editColumn = new CustomEditColumn('Nom', 'nom', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fk_type_nom_param field
            //
            $editor = new ComboBox('fk_type_nom_param_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $lookupDataset = new TableDataset(
                new PgPDOConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vn_types_nom_objet"');
            $field = new IntegerField('pk_parametre_systeme');
            $lookupDataset->AddField($field, false);
            $field = new StringField('valeur');
            $lookupDataset->AddField($field, false);
            $lookupDataset->setOrderByField('valeur', GetOrderTypeAsSQL(otAscending));
            $editColumn = new LookUpEditColumn(
                'Fk Type Nom Param', 
                'fk_type_nom_param', 
                $editor, 
                $this->dataset, 'pk_parametre_systeme', 'valeur', $lookupDataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for est_standard field
            //
            $editor = new CheckBox('est_standard_edit');
            $editColumn = new CustomEditColumn('Est Standard', 'est_standard', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for langue field
            //
            $editor = new TextAreaEdit('langue_edit', 50, 8);
            $editColumn = new CustomEditColumn('Langue', 'langue', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_debut field
            //
            $editor = new TextEdit('date_debut_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Date Debut', 'date_debut', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_fin field
            //
            $editor = new TextEdit('date_fin_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Date Fin', 'date_fin', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for notes field
            //
            $editor = new TextAreaEdit('notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_creation field
            //
            $editor = new DateTimeEdit('date_creation_edit', false, 'Y-m-d H:i:s', GetFirstDayOfWeek());
            $editColumn = new CustomEditColumn('Date Creation', 'date_creation', $editor, $this->dataset);
            $editColumn->SetReadOnly(true);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_modification field
            //
            $editor = new DateTimeEdit('date_modification_edit', false, 'Y-m-d H:i:s', GetFirstDayOfWeek());
            $editColumn = new CustomEditColumn('Date Modification', 'date_modification', $editor, $this->dataset);
            $editColumn->SetReadOnly(true);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for fk_objet field
            //
            $editor = new ComboBox('fk_objet_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $lookupDataset = new TableDataset(
                new PgPDOConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vm_objet_vue_de_base"');
            $field = new IntegerField('pk_objet');
            $lookupDataset->AddField($field, true);
            $field = new IntegerField('fk_type_objet_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('nom');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_nom_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('definition');
            $lookupDataset->AddField($field, false);
            $field = new StringField('date_iso');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_date_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('certitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('latitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('longitude');
            $lookupDataset->AddField($field, false);
            $field = new StringField('genre');
            $lookupDataset->AddField($field, false);
            $field = new StringField('notes');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new BooleanField('si_texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_creation');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_modification');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_nom_objet');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_date_objet');
            $lookupDataset->AddField($field, false);
            $lookupDataset->setOrderByField('nom', GetOrderTypeAsSQL(otAscending));
            $editColumn = new LookUpEditColumn(
                'Fk Objet', 
                'fk_objet', 
                $editor, 
                $this->dataset, 'pk_objet', 'nom', $lookupDataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for nom field
            //
            $editor = new TextAreaEdit('nom_edit', 50, 8);
            $editColumn = new CustomEditColumn('Nom', 'nom', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $editColumn->SetAllowSetToDefault(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fk_type_nom_param field
            //
            $editor = new ComboBox('fk_type_nom_param_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $lookupDataset = new TableDataset(
                new PgPDOConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vn_types_nom_objet"');
            $field = new IntegerField('pk_parametre_systeme');
            $lookupDataset->AddField($field, false);
            $field = new StringField('valeur');
            $lookupDataset->AddField($field, false);
            $lookupDataset->setOrderByField('valeur', GetOrderTypeAsSQL(otAscending));
            $editColumn = new LookUpEditColumn(
                'Fk Type Nom Param', 
                'fk_type_nom_param', 
                $editor, 
                $this->dataset, 'pk_parametre_systeme', 'valeur', $lookupDataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for est_standard field
            //
            $editor = new CheckBox('est_standard_edit');
            $editColumn = new CustomEditColumn('Est Standard', 'est_standard', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $editColumn->SetAllowSetToDefault(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for langue field
            //
            $editor = new TextAreaEdit('langue_edit', 50, 8);
            $editColumn = new CustomEditColumn('Langue', 'langue', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_debut field
            //
            $editor = new TextEdit('date_debut_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Date Debut', 'date_debut', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_fin field
            //
            $editor = new TextEdit('date_fin_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Date Fin', 'date_fin', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for notes field
            //
            $editor = new TextAreaEdit('notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_creation field
            //
            $editor = new DateTimeEdit('date_creation_edit', false, 'Y-m-d H:i:s', GetFirstDayOfWeek());
            $editColumn = new CustomEditColumn('Date Creation', 'date_creation', $editor, $this->dataset);
            $editColumn->SetReadOnly(true);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_modification field
            //
            $editor = new DateTimeEdit('date_modification_edit', false, 'Y-m-d H:i:s', GetFirstDayOfWeek());
            $editColumn = new CustomEditColumn('Date Modification', 'date_modification', $editor, $this->dataset);
            $editColumn->SetReadOnly(true);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $grid->SetShowAddButton(true);
                $grid->SetShowInlineAddButton(false);
            }
            else
            {
                $grid->SetShowInlineAddButton(false);
                $grid->SetShowAddButton(false);
            }
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('fk_objet_nom', 'Fk Objet', $this->dataset);
            $column->SetOrderable(true);
            $column = new ExtendedHyperLinkColumnDecorator($column, $this->dataset, 'vues.vm_objet_vue_de_base.php?operation=edit&pk0=%fk_objet%' , '_blank');
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for valeur field
            //
            $column = new TextViewColumn('fk_type_nom_param_valeur', 'Fk Type Nom Param', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for est_standard field
            //
            $column = new TextViewColumn('est_standard', 'Est Standard', $this->dataset);
            $column->SetOrderable(true);
            $column = new CheckBoxFormatValueViewColumnDecorator($column);
            $column->SetDisplayValues($this->RenderText('<span class="pg-row-checkbox checked"></span>'), $this->RenderText('<span class="pg-row-checkbox"></span>'));
            $grid->AddPrintColumn($column);
            
            //
            // View column for langue field
            //
            $column = new TextViewColumn('langue', 'Langue', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_debut field
            //
            $column = new TextViewColumn('date_debut', 'Date Debut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_fin field
            //
            $column = new TextViewColumn('date_fin', 'Date Fin', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for pk_nom_objet field
            //
            $column = new TextViewColumn('pk_nom_objet', 'Pk Nom Objet', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_creation field
            //
            $column = new DateTimeViewColumn('date_creation', 'Date Creation', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_modification field
            //
            $column = new DateTimeViewColumn('date_modification', 'Date Modification', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('fk_objet_nom', 'Fk Objet', $this->dataset);
            $column->SetOrderable(true);
            $column = new ExtendedHyperLinkColumnDecorator($column, $this->dataset, 'vues.vm_objet_vue_de_base.php?operation=edit&pk0=%fk_objet%' , '_blank');
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for valeur field
            //
            $column = new TextViewColumn('fk_type_nom_param_valeur', 'Fk Type Nom Param', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for est_standard field
            //
            $column = new TextViewColumn('est_standard', 'Est Standard', $this->dataset);
            $column->SetOrderable(true);
            $column = new CheckBoxFormatValueViewColumnDecorator($column);
            $column->SetDisplayValues($this->RenderText('<span class="pg-row-checkbox checked"></span>'), $this->RenderText('<span class="pg-row-checkbox"></span>'));
            $grid->AddExportColumn($column);
            
            //
            // View column for langue field
            //
            $column = new TextViewColumn('langue', 'Langue', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_debut field
            //
            $column = new TextViewColumn('date_debut', 'Date Debut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_fin field
            //
            $column = new TextViewColumn('date_fin', 'Date Fin', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for pk_nom_objet field
            //
            $column = new TextViewColumn('pk_nom_objet', 'Pk Nom Objet', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_creation field
            //
            $column = new DateTimeViewColumn('date_creation', 'Date Creation', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_modification field
            //
            $column = new DateTimeViewColumn('date_modification', 'Date Modification', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
        public function GetModalGridEditingHandler() { return 'objets_nom_objet_inline_edit'; }
        protected function GetEnableModalGridEditing() { return true; }
        public function ShowEditButtonHandler(&$show)
        {
            if ($this->GetRecordPermission() != null)
                $show = $this->GetRecordPermission()->HasEditGrant($this->GetDataset());
        }
        public function ShowDeleteButtonHandler(&$show)
        {
            if ($this->GetRecordPermission() != null)
                $show = $this->GetRecordPermission()->HasDeleteGrant($this->GetDataset());
        }
        
        public function GetModalGridDeleteHandler() { return 'objets_nom_objet_modal_delete'; }
        protected function GetEnableModalGridDelete() { return true; }
        
        public function GetModalGridCopyHandler() { return 'objets_nom_objet_inline_edit'; }
        protected function GetEnableModalGridCopy() { return true; }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset, 'objets_nom_objetGrid');
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(false);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $defaultSortedColumns = array();
            $defaultSortedColumns[] = new SortColumn('fk_objet_nom', 'ASC');
            $result->setDefaultOrdering($defaultSortedColumns);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->SetUseModalInserting(true);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
            $this->CreateGridSearchControl($result);
            $this->CreateGridAdvancedSearchControl($result);
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
    
            $this->SetShowPageList(true);
            $this->SetExportToExcelAvailable(true);
            $this->SetExportToWordAvailable(true);
            $this->SetExportToXmlAvailable(true);
            $this->SetExportToCsvAvailable(true);
            $this->SetExportToPdfAvailable(true);
            $this->SetPrinterFriendlyAvailable(true);
            $this->SetSimpleSearchAvailable(true);
            $this->SetAdvancedSearchAvailable(true);
            $this->SetVisualEffectsEnabled(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(true);
    
            //
            // Http Handlers
            //
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'objets_nom_objetGrid_nom_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for langue field
            //
            $column = new TextViewColumn('langue', 'Langue', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'objets_nom_objetGrid_langue_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'objets_nom_objetGrid_notes_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);//
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'objets_nom_objetGrid_nom_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for langue field
            //
            $column = new TextViewColumn('langue', 'Langue', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'objets_nom_objetGrid_langue_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'objets_nom_objetGrid_notes_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            return $result;
        }
        
        public function OpenAdvancedSearchByDefault()
        {
            return false;
        }
    
        protected function DoGetGridHeader()
        {
            return '';
        }
    }



    try
    {
        $Page = new objets_nom_objetPage("objets.nom_objet.php", "objets_nom_objet", GetCurrentUserGrantForDataSource("objets.nom_objet"), 'UTF-8');
        $Page->SetShortCaption('Noms des objets');
        $Page->SetHeader(GetPagesHeader());
        $Page->SetFooter(GetPagesFooter());
        $Page->SetCaption('Noms des objets');
        $Page->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource("objets.nom_objet"));
        GetApplication()->SetEnableLessRunTimeCompile(GetEnableLessFilesRunTimeCompilation());
        GetApplication()->SetCanUserChangeOwnPassword(
            !function_exists('CanUserChangeOwnPassword') || CanUserChangeOwnPassword());
        GetApplication()->SetMainPage($Page);
        GetApplication()->Run();
    }
    catch(Exception $e)
    {
        ShowErrorPage($e->getMessage());
    }
	
