--
-- PostgreSQL database dump
--

-- Dumped from database version 9.3.1
-- Dumped by pg_dump version 9.3.1
-- Started on 2014-11-01 09:58:39 CET

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 8 (class 2615 OID 95830)
-- Name: objets; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA objets;


SET search_path = objets, pg_catalog;

--
-- TOC entry 215 (class 1255 OID 95831)
-- Name: update_created_column(); Type: FUNCTION; Schema: objets; Owner: -
--

CREATE FUNCTION update_created_column() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	   NEW.date_creation = now(); 
	   RETURN NEW;
	END;
$$;


--
-- TOC entry 216 (class 1255 OID 120308)
-- Name: update_updated_column(); Type: FUNCTION; Schema: objets; Owner: -
--

CREATE FUNCTION update_updated_column() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	   NEW.date_modification = now(); 
	   RETURN NEW;
	END;
$$;


SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 184 (class 1259 OID 112101)
-- Name: associer_objets; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE associer_objets (
    pk_associer_objets integer NOT NULL,
    fk_objet_source integer,
    fk_objet_cible integer,
    fk_type_association_objets integer,
    reference_precise text,
    url text,
    descriptif text,
    notes text,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone
);


--
-- TOC entry 183 (class 1259 OID 112099)
-- Name: associer_objets_pk_associer_objets_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE associer_objets_pk_associer_objets_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2316 (class 0 OID 0)
-- Dependencies: 183
-- Name: associer_objets_pk_associer_objets_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE associer_objets_pk_associer_objets_seq OWNED BY associer_objets.pk_associer_objets;


--
-- TOC entry 175 (class 1259 OID 95832)
-- Name: nom_objet; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE nom_objet (
    pk_nom_objet integer NOT NULL,
    nom text,
    langue character varying(255),
    notes text,
    fk_objet integer,
    est_standard boolean,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone,
    fk_type_nom integer,
    date_debut character varying(10),
    date_fin character varying(10)
);


--
-- TOC entry 176 (class 1259 OID 95838)
-- Name: nom_objet_cle_nom_objet_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE nom_objet_cle_nom_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2317 (class 0 OID 0)
-- Dependencies: 176
-- Name: nom_objet_cle_nom_objet_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE nom_objet_cle_nom_objet_seq OWNED BY nom_objet.pk_nom_objet;


--
-- TOC entry 177 (class 1259 OID 95840)
-- Name: objet; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE objet (
    pk_objet integer NOT NULL,
    definition text,
    notes text,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone,
    certitude_dd integer,
    certitude_df integer,
    cle_importation integer,
    cle_importation_txt text,
    longitude double precision,
    latitude double precision,
    date_debut character varying(10),
    date_fin character varying(10),
    texte_tei xml,
    fk_type_objet integer NOT NULL,
    sexe character(1)
);


--
-- TOC entry 2318 (class 0 OID 0)
-- Dependencies: 177
-- Name: COLUMN objet.longitude; Type: COMMENT; Schema: objets; Owner: -
--

COMMENT ON COLUMN objet.longitude IS 'ALTER TABLE objets.objet
   ALTER COLUMN longitude TYPE double precision;
';


--
-- TOC entry 2319 (class 0 OID 0)
-- Dependencies: 177
-- Name: COLUMN objet.latitude; Type: COMMENT; Schema: objets; Owner: -
--

COMMENT ON COLUMN objet.latitude IS 'ALTER TABLE objets.objet
   ALTER COLUMN latitude TYPE double precision;
';


--
-- TOC entry 178 (class 1259 OID 95846)
-- Name: objet_cle_objet_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE objet_cle_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2320 (class 0 OID 0)
-- Dependencies: 178
-- Name: objet_cle_objet_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE objet_cle_objet_seq OWNED BY objet.pk_objet;


--
-- TOC entry 2177 (class 2604 OID 112104)
-- Name: pk_associer_objets; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY associer_objets ALTER COLUMN pk_associer_objets SET DEFAULT nextval('associer_objets_pk_associer_objets_seq'::regclass);


--
-- TOC entry 2175 (class 2604 OID 95853)
-- Name: pk_nom_objet; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY nom_objet ALTER COLUMN pk_nom_objet SET DEFAULT nextval('nom_objet_cle_nom_objet_seq'::regclass);


--
-- TOC entry 2176 (class 2604 OID 95854)
-- Name: pk_objet; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY objet ALTER COLUMN pk_objet SET DEFAULT nextval('objet_cle_objet_seq'::regclass);


--
-- TOC entry 2311 (class 0 OID 112101)
-- Dependencies: 184
-- Data for Name: associer_objets; Type: TABLE DATA; Schema: objets; Owner: -
--

INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (1, 5, 17, 8, NULL, NULL, NULL, NULL, '2014-10-01 17:24:28.332882+02', '2014-10-01 17:31:30.126504+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (2, 6, 17, 8, NULL, NULL, NULL, NULL, '2014-10-01 17:34:45.975283+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (6, 13, 17, 8, NULL, NULL, NULL, NULL, '2014-10-01 18:45:00.132484+02', '2014-10-01 18:45:06.246479+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (5, 18, 9, 14, NULL, 'http://www.larousse.fr/encyclopedie/litterature/Peiresc/175946', NULL, NULL, '2014-10-01 18:41:42.716243+02', '2014-10-01 22:44:18.786132+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (7, 19, 18, 15, NULL, 'http://www.larousse.fr/encyclopedie', NULL, NULL, '2014-10-01 22:29:27.83624+02', '2014-10-01 22:53:52.85526+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (9, 26, 9, 14, NULL, NULL, NULL, NULL, '2014-10-03 00:38:09.937103+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (10, 24, 6, 14, NULL, NULL, NULL, NULL, '2014-10-03 00:38:59.368386+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (12, 30, 8, 14, NULL, NULL, 'Ouvrage fondamental que je dois lire pour mon mémoire de master', NULL, '2014-10-03 09:31:41.936464+02', '2014-10-03 09:33:20.672138+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (13, 31, 8, 14, NULL, NULL, NULL, NULL, '2014-10-03 10:27:23.44267+02', '2014-10-03 10:27:26.947125+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (14, 11, 17, 8, NULL, NULL, NULL, NULL, '2014-10-06 16:03:17.267635+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (15, 3, 34, 8, NULL, NULL, NULL, NULL, '2014-10-06 16:23:41.033349+02', '2014-10-06 16:25:41.083099+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (16, 21, 34, 8, NULL, NULL, NULL, NULL, '2014-10-06 16:27:17.277625+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (17, 33, 34, 8, NULL, NULL, NULL, NULL, '2014-10-06 16:27:35.286256+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (11, 28, 6, 14, 'pp.78-99', NULL, NULL, NULL, '2014-10-03 09:12:45.180796+02', '2014-10-06 16:35:30.289287+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (18, 36, 37, 8, NULL, NULL, NULL, NULL, '2014-10-08 18:52:53.234141+02', '2014-10-08 18:55:22.821323+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (19, 38, 37, 8, NULL, NULL, NULL, NULL, '2014-10-08 18:57:27.385722+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (20, NULL, 40, 15, NULL, NULL, NULL, NULL, '2014-10-08 23:21:31.065467+02', '2014-10-08 23:21:54.446986+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (21, 40, 13, 14, NULL, NULL, NULL, NULL, '2014-10-08 23:22:04.220005+02', '2014-10-08 23:22:06.819011+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (22, 19, 41, 14, NULL, 'http://en.wikipedia.org/wiki/Knutstorp_Castle', NULL, NULL, '2014-10-08 23:53:25.039002+02', '2014-10-08 23:53:48.332702+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (23, 1, NULL, 8, NULL, NULL, NULL, NULL, '2014-10-11 09:33:46.631272+02', '2014-10-12 07:56:50.304434+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (24, 42, 37, 8, NULL, NULL, NULL, NULL, '2014-10-13 11:20:37.140047+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (25, 43, 44, 14, NULL, NULL, NULL, NULL, '2014-10-13 15:05:11.736957+02', '2014-10-13 15:06:17.878751+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (26, 29, 45, 8, NULL, NULL, NULL, NULL, '2014-10-13 15:16:13.654128+02', '2014-10-13 15:16:25.649171+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (27, 43, NULL, 14, NULL, NULL, NULL, NULL, '2014-10-13 18:10:56.304058+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (28, 46, 43, 15, NULL, NULL, NULL, NULL, '2014-10-13 18:11:19.42667+02', '2014-10-13 18:11:46.281011+02');


--
-- TOC entry 2321 (class 0 OID 0)
-- Dependencies: 183
-- Name: associer_objets_pk_associer_objets_seq; Type: SEQUENCE SET; Schema: objets; Owner: -
--

SELECT pg_catalog.setval('associer_objets_pk_associer_objets_seq', 28, true);


--
-- TOC entry 2306 (class 0 OID 95832)
-- Dependencies: 175
-- Data for Name: nom_objet; Type: TABLE DATA; Schema: objets; Owner: -
--

INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (52, 'Knudstrup', 'danois', NULL, 41, true, '2014-10-08 23:36:50.062865+02', '2014-10-08 23:37:17.876007+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (50, 'Knutstorp Manor', 'anglais', NULL, 41, false, '2014-10-08 23:33:22.411218+02', '2014-10-08 23:37:18.994208+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (64, 'Doctrine professée', NULL, NULL, 51, true, '2014-10-31 13:41:09.673437+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (65, 'Opinions', NULL, NULL, 52, true, '2014-10-31 22:43:13.292289+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (13, 'Mathématiques', NULL, NULL, 3, true, '2014-09-22 10:55:42.046401+02', NULL, 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (66, 'Encyclopédie générale Larousse, 3 t., Paris : Libraire Larousse, 1967-1975', NULL, NULL, 53, true, '2014-11-01 08:44:13.519732+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (11, 'Inquisition romaine', NULL, NULL, 4, true, '2014-09-22 10:54:57.463491+02', NULL, 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (12, 'Saint-Office', NULL, NULL, 4, false, '2014-09-22 10:55:15.342779+02', NULL, 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (16, 'Maestlin, Michael', NULL, NULL, 7, true, '2014-10-01 01:11:51.526866+02', NULL, 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (18, 'Fabri de Peiresc, Nicolas Claude', NULL, NULL, 9, true, '2014-10-01 09:32:02.393621+02', NULL, 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (19, 'Rodolphe II', 'français', NULL, 10, true, '2014-10-01 10:10:07.338795+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (20, 'Copernic, NIcolas', NULL, NULL, 11, true, '2014-10-01 10:13:39.735352+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (21, 'Charles Quint', 'français', NULL, 12, true, '2014-10-01 10:28:53.007398+02', NULL, 5, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (8, 'Barberini, Maffeo', 'italien', NULL, 1, false, '2014-09-19 22:15:55.046286+02', '2014-10-09 23:07:09.922706+02', 3, '1568', '1623-08-05');
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (15, 'Kepler, Johannes', 'allemand', NULL, 6, true, '2014-10-01 01:08:35.83893+02', NULL, 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (23, 'Population de savants', NULL, NULL, 17, true, '2014-10-01 17:22:58.918112+02', '2014-10-01 17:23:44.079059+02', 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (25, 'Site web', NULL, NULL, 19, true, '2014-10-01 17:45:30.78415+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (24, 'Encyclopédie Larousse', NULL, NULL, 18, true, '2014-10-01 17:44:52.371504+02', '2014-10-01 18:39:32.737874+02', 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (22, 'Brahe, Tycho', 'danois', NULL, 13, true, '2014-10-01 10:41:34.158809+02', '2014-10-01 23:47:25.925818+02', 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (27, 'Astronomie', NULL, NULL, 21, true, '2014-10-02 19:15:55.313405+02', '2014-10-02 19:17:02.962245+02', 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (28, 'Weil der Stadt', NULL, NULL, 22, true, '2014-10-02 19:22:44.190267+02', NULL, 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (29, 'Regensburg', 'allemand', NULL, 23, true, '2014-10-02 19:42:15.988656+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (30, 'Ratisbonne', 'français', NULL, 23, false, '2014-10-02 19:43:16.066025+02', '2014-10-02 19:46:27.458259+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (31, 'Johannes Kepler – notice Larousse', NULL, NULL, 24, true, '2014-10-02 20:20:39.403336+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (32, 'Newton, Isaac', 'anglais', NULL, 25, true, '2014-10-02 22:48:13.618384+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (34, 'Aristote', NULL, NULL, 27, true, '2014-10-03 00:21:17.569237+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (33, 'Peiresc – notice Larousse', NULL, NULL, 26, true, '2014-10-03 00:16:13.989861+02', '2014-10-03 08:42:33.980493+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (36, 'Simon, Gérard, Kepler: astronome, astrologue (Paris, Gallimard, 1979)', NULL, NULL, 29, true, '2014-10-03 09:25:23.468639+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (17, 'Gassend, Pierre', 'français', NULL, 8, true, '2014-10-01 07:20:07.82895+02', '2014-10-03 09:30:57.976154+02', 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (38, 'Gassendi', 'français', NULL, 8, false, '2014-10-03 09:30:55.528311+02', '2014-10-03 09:31:00.752651+02', 13, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (39, 'Gassendi – Notice Larousse', NULL, NULL, 31, true, '2014-10-03 10:23:58.005062+02', '2014-10-03 10:27:09.638341+02', 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (37, 'Gassendi et l''Europe (1592-1792) : actes du colloque international de Paris "Gassendi et sa postérité (1592-1792)", ed. Murr, Sylvia (Paris , J. Vrin, 1997) ', 'français', NULL, 30, true, '2014-10-03 09:29:52.508511+02', '2014-10-03 10:30:02.039306+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (40, 'Descriptif d''un objet', NULL, NULL, 32, true, '2014-10-05 17:24:17.053407+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (9, 'Urbain VIII', 'français', NULL, 1, true, '2014-09-19 22:16:24.269177+02', '2014-10-09 23:07:12.658384+02', 5, '1623-08-06', '1644');
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (42, 'Médecine', 'français', NULL, 33, true, '2014-10-06 16:15:19.021943+02', '2014-10-06 16:15:42.261297+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (43, 'Discipline enseignée à l''Université', 'français', NULL, 34, true, '2014-10-06 16:20:47.078147+02', '2014-10-06 16:20:53.205843+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (44, 'Graz', NULL, NULL, 35, true, '2014-10-07 15:40:00.611719+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (45, 'Naissance', NULL, NULL, 36, true, '2014-10-08 18:49:59.189079+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (46, 'Valeurs @ana', NULL, NULL, 37, true, '2014-10-08 18:54:59.536276+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (47, 'Décès', NULL, NULL, 38, true, '2014-10-08 18:56:33.113638+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (48, 'Belgentier', NULL, NULL, 39, true, '2014-10-08 22:47:31.519657+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (49, 'Tycho Brahe – Notice Larousse', NULL, NULL, 40, true, '2014-10-08 23:13:31.804493+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (51, 'Knutstorps slott', 'suédois', NULL, 41, false, '2014-10-08 23:36:30.876032+02', '2014-10-08 23:36:41.828987+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (10, 'Merisi, Michelangelo, da Caravaggio', 'italien', NULL, 2, true, '2014-09-19 22:26:23.932658+02', '2014-10-10 23:21:05.406245+02', 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (14, 'Galilei, Galileo', 'italien', NULL, 5, true, '2014-09-30 07:22:43.025217+02', '2014-10-11 00:19:42.438119+02', 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (35, 'Depondt, Philippe / Véricourt, Guillemette de, Kepler. L’orbe tourmenté d’un astronome. Biographie (Rodez, Editions du Rouergue, 2005) ', NULL, NULL, 28, true, '2014-10-03 09:06:16.294152+02', '2014-10-12 08:09:20.790636+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (53, 'Exercice de fonction', NULL, NULL, 42, true, '2014-10-13 11:18:24.47867+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (54, 'Lyon, AM, 78WP011', NULL, NULL, 43, true, '2014-10-13 14:56:03.362676+02', '2014-10-13 14:56:30.531915+02', 25, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (55, 'Exposition universelle de Paris de 1889', 'français', NULL, 44, true, '2014-10-13 14:58:10.053419+02', '2014-10-13 14:58:36.819732+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (56, 'Sources', NULL, NULL, 45, true, '2014-10-13 15:14:37.214361+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (57, 'www.archives_municipales_NNN.fr', NULL, NULL, 46, true, '2014-10-13 18:08:17.357242+02', NULL, 25, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (58, 'Lyon', 'français', NULL, 47, true, '2014-10-17 15:14:56.281726+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (26, 'Enfance', NULL, NULL, 20, true, '2014-10-02 19:13:12.170589+02', '2014-10-31 12:07:16.045595+01', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (59, 'Formation', 'français', NULL, 48, true, '2014-10-31 12:17:08.739655+01', '2014-10-31 12:17:14.849675+01', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (60, 'Carrière', NULL, NULL, 49, true, '2014-10-31 12:18:46.696253+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (61, 'Profession', NULL, 'Utilisé pour la recherche, j''ai préféré le temre de carrière au sens de parcours', 49, false, '2014-10-31 12:19:35.344819+01', '2014-10-31 12:20:03.004296+01', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (62, 'Parcours', NULL, NULL, 49, false, '2014-10-31 12:20:11.748689+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (63, 'Origines familiales', NULL, NULL, 50, true, '2014-10-31 13:36:30.016733+01', NULL, 7, NULL, NULL);


--
-- TOC entry 2322 (class 0 OID 0)
-- Dependencies: 176
-- Name: nom_objet_cle_nom_objet_seq; Type: SEQUENCE SET; Schema: objets; Owner: -
--

SELECT pg_catalog.setval('nom_objet_cle_nom_objet_seq', 66, true);


--
-- TOC entry 2308 (class 0 OID 95840)
-- Dependencies: 177
-- Data for Name: objet; Type: TABLE DATA; Schema: objets; Owner: -
--

INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (8, 'Philosophe et savant français', NULL, '2014-10-01 07:19:33.761028+02', '2014-10-03 20:26:15.0649+02', NULL, NULL, NULL, NULL, NULL, NULL, '1592', '1655', NULL, 1, 'M');
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (9, 'Savant français', NULL, '2014-10-01 09:31:11.028347+02', '2014-10-03 20:26:24.8484+02', NULL, NULL, NULL, NULL, NULL, NULL, '1580', '1637', NULL, 1, 'M');
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (13, 'Astronome danois', NULL, '2014-10-01 10:34:39.344328+02', '2014-10-03 20:26:36.616239+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'M');
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (7, 'Astronome allemand', NULL, '2014-10-01 01:11:01.547802+02', '2014-10-03 20:26:39.752096+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'M');
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (32, 'Type une unité de connaissance ou un segment de texte qui contient la description d''un objet', NULL, '2014-10-05 17:24:07.884147+02', '2014-10-05 17:24:39.615261+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 21, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (3, 'Matière enseignée', NULL, '2014-09-22 00:15:05.135554+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (22, 'Ville située dans le Würtenberg', NULL, '2014-10-02 19:22:35.226786+02', '2014-10-08 23:11:46.583041+02', NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 19, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (1, 'Le pape qui a condamné Galilée', NULL, '2014-09-19 22:12:04.353976+02', '2014-10-09 23:07:33.802807+02', NULL, NULL, NULL, NULL, NULL, NULL, '1568', '1644', NULL, 1, 'M');
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (37, 'Codage TEI, valeurs utilisées dans l''attribut @ana: grâce à cet objet abstrait on peut classer ces valeurs et les retrouver plus facilement', NULL, '2014-10-08 18:54:44.544218+02', '2014-10-09 23:12:00.352011+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (2, 'Peintre italien', 'Divers', '2014-09-19 22:24:22.597943+02', '2014-10-11 00:09:30.126395+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (36, 'Un segment de type "naissance", qui relate la naissance d''un acteur', NULL, '2014-10-08 18:49:54.711862+02', '2014-10-08 18:50:11.873341+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (4, 'Institution créée par la papauté et vouée à la répression de l''hérésie', NULL, '2014-09-22 00:15:23.119833+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (5, 'Mathématicien et astronome italien', ' ', '2014-09-30 07:22:33.865782+02', '2014-10-11 08:18:02.132039+02', 25, NULL, NULL, NULL, NULL, NULL, '1564', NULL, NULL, 1, 'M');
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (6, 'Astronome allemand', NULL, '2014-10-01 01:08:08.332719+02', '2014-10-13 14:48:19.647527+02', NULL, NULL, NULL, NULL, NULL, NULL, '1571', '1630', NULL, 1, 'M');
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (38, 'Un segment de type "décès", qui relate la mort d''un acteur, avec son lieu et sa date', NULL, '2014-10-08 18:56:26.980992+02', '2014-10-08 18:56:37.979289+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (12, 'Empereur du Saint-Empire', NULL, '2014-10-01 10:28:46.387364+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (11, 'Astronome polonais', NULL, '2014-10-01 10:13:27.463726+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (10, 'Empereur du Saint-Empire', NULL, '2014-10-01 10:09:35.746291+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (17, 'Les objets appartenant à la population que je vais étudier', NULL, '2014-10-01 17:22:25.877375+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (19, 'Tout site web. Objet utilisé pour classer les sites web', NULL, '2014-10-01 17:45:17.760892+02', '2014-10-02 19:15:03.104765+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (21, 'Discipline consacrée à l''étude des astres et de leurs mouvements', NULL, '2014-10-02 19:15:49.887956+02', '2014-10-02 19:16:05.528434+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (23, 'Ville allemande', NULL, '2014-10-02 19:41:58.566116+02', '2014-10-02 19:42:28.041945+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 19, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (25, 'Savant anglais, inventeur du concept de la gravitation universelle', NULL, '2014-10-02 22:48:00.923917+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (27, 'Philosophe grec', NULL, '2014-10-03 00:21:13.711991+02', '2014-10-03 08:41:45.278712+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (28, 'Biographie', NULL, '2014-10-03 09:06:07.924216+02', '2014-10-03 09:06:35.593472+02', NULL, NULL, NULL, NULL, NULL, NULL, '2005', NULL, NULL, 11, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (29, NULL, NULL, '2014-10-03 09:25:16.532517+02', '2014-10-03 09:25:32.773946+02', NULL, NULL, NULL, NULL, NULL, NULL, '1979', NULL, NULL, 11, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (33, 'Art de soigner les patients. Egalement discipline enseignée.', NULL, '2014-10-06 16:15:10.98898+02', '2014-10-06 16:16:26.805769+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (30, 'Ouvrage fondamental que je dois lire pour mon mémoire de master', NULL, '2014-10-03 09:29:48.92256+02', '2014-10-03 09:33:11.404481+02', NULL, NULL, NULL, NULL, NULL, NULL, '1997', NULL, NULL, 11, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (34, 'Les disciplines universitaires de la Renaissance qui m''intéressent pour mon master', NULL, '2014-10-06 16:20:13.581063+02', '2014-10-06 16:21:03.340636+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (42, 'Balisage sémantique: récence un exercice de fonction, profession, etc.', NULL, '2014-10-13 11:18:16.791979+02', '2014-10-13 11:18:28.123638+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (44, 'Exposition universelle', NULL, '2014-10-13 14:57:50.117979+02', '2014-10-13 14:59:42.024917+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (43, 'Carton d''archives: j''ai mis les reproductions photographiques dans mon carton...', NULL, '2014-10-13 14:55:18.686475+02', '2014-10-13 15:08:17.831889+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (45, 'Les ouvrages bibliographiques que j''utilise comme source', NULL, '2014-10-13 15:14:23.651696+02', '2014-10-13 15:14:59.116106+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (46, 'Site web des archives municipales de NNN', NULL, '2014-10-13 18:07:32.010378+02', '2014-10-13 18:07:44.525731+02', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 12, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (40, 'Tycho Brahe – Notice Larousse', NULL, '2014-10-08 23:13:13.015999+02', '2014-11-01 08:29:59.984819+01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<?xml-stylesheet href="transformation/visualisation_navigateur.xsl" type="text/xsl"?>
<TEI xmlns="http://www.tei-c.org/ns/1.0" xml:id="ObPe40">
	<teiHeader>
		<fileDesc>
			<titleStmt>
				<title>Tycho Brahe</title>
				<author/>
			</titleStmt>
			<publicationStmt>
				<p>Document à usage personnel</p>
			</publicationStmt>
			<sourceDesc>
				<bibl>
					<ref target="http://www.larousse.fr/encyclopedie/personnage/Tycho_Brahe/109965">Cet article est extrait de l''encyclopédie Larousse</ref>
				</bibl>
			</sourceDesc>
		</fileDesc>
		<profileDesc>
			<creation>
				<name type="place" key=""/>
				<date when="2014"/>
			</creation>
		</profileDesc>
		<revisionDesc>
			<change type="synchronisation_base" when="2014-11-01"/>
			<change type="production_texte" when="2014-10-02"/>
			<change type="structure" when="2014-11-01"/>
			<change type="semantique" when="2014-11-01">J''ai encodé toutes les entités nommées qui figurent dans ce texte</change>
		</revisionDesc>
	</teiHeader>
	<text>
		<body>
			<div type="structure">
				<div type="transcription">
					<p>Astronome danois (<seg ana="ObPe36"><name ref="ObPe13"/>
							<name ref="ObPe41">Knudstrup</name>, aujourd''hui en Suède, <date when="1546">1546</date>
						</seg>-Prague 1601).</p>
				
				</div>
				<div type="transcription">
					<p>
						<seg ana="ObPe50">Issu d''une famille de l''aristocratie danoise</seg>,<seg ana="ObPe20"> il apprend le latin à sept ans</seg> et, <seg ana="ObPe48">en 1559, âgé de treize ans, entre à l''université de Copenhague, où il s''initie à la rhétorique et à la philosophie</seg>. En août 1560, une éclipse partielle de Soleil, qu''il contemple, l''impressionne fortement. Ce n''est pas tant le phénomène lui-même qui l''émerveille, que le fait qu''on ait pu le prévoir, par une bonne connaissance du mouvement des astres.<seg ana="ObPe48"> Sa famille le destine à une carrière politique, mais il décide de devenir astronome. En 1563, il quitte l''université de Copenhague pour celle de Leipzig, puis celles de Wittenberg, de Rostock, de Bâle et d''Augsbourg.</seg> Doté d''une forte personnalité et d''un caractère belliqueux, il se bat en duel ; d''un coup d''épée, son adversaire lui tranche le nez. Il se fait alors confectionner une prothèse en or et en argent qu''il portera toute sa vie.</p>
					<p>Tout en poursuivant ses études, Tycho Brahe passe des nuits entières à scruter le ciel. Sa première observation importante a lieu en août 1563. Les planètes Jupiter et Saturne se trouvent alors très proches l''une de l''autre dans le ciel. il les observe quotidiennement et note que leur rapprochement le plus serré se produit le 17 août. Or, les tables astronomiques de l''époque sigalent cette « conjonction » des deux planètes avec une erreur de plusieurs jours. Cela l''incite à établir de nouvelles tables, fondées sur des observations plus précises, faites au moyen d''instruments de grandes dimensions. <seg ana="ObPe49"><date from="1569" to="1571">De 1569 à 1571</date>, il vit à Augsbourg</seg>. Grâce au bourgmestre de la ville, il construit un quadrant d''environ 5 m de rayon pour mesurer la hauteur des astres.</p>
				</div>
				
				<div type="transcription">
					<head>La supernova de 1572</head>
					<p>En 1571, Tycho Brahe, âgé de 25 ans, rentre dans son pays natal. Il rejoint un oncle qui a fondé la première papeterie et la première verrerie au Danemark. Dans la soirée du 11 novembre 1572, il remarque un astre plus brillant que Vénus, au nord-ouest de Cassiopée, à un endroit du ciel où la veille encore on ne distinguait aucun objet. Cet astre nouveau brillera pendant dix-huit mois. S''agit-il d''une étoile ? N''est-ce pas plutôt une comète ? Grâce à des observations très précises, Tycho Brahe lève le doute : l''astre inconnu reste immobile par rapport aux autres étoiles et est très éloigné de la Terre puisque sa parallaxe semble nulle. Ce ne peut donc être qu''une nouvelle étoile, comme il l''explique dans l''opuscule De stella nova qu''il publie en 1573. Selon la terminologie moderne, c''est une supernova. Cet événement exceptionnel bouleverse le concept aristotélicien de l''immuabilité des cieux.</p>
				
				</div>
				
				<div type="transcription">
					
					<head>Le château des étoiles</head>
					<p>En 1575, Tycho Brahe, devenu célèbre, voyage à travers l''Europe ; il s''arrête à Francfort-sur-le-Main et à Bâle, va jusqu''à Venise et revient par Cassel, où il se fixe quelque temps chez le landgrave Guillaume IV, passionné d''astronomie,. Les deux hommes sympathisent et Guillaume IV écrit au roi du Danemark, Frédéric II, déjà bien disposé envers les Brahe, pour l''engager à fournir à Tycho les moyens de construire un observatoire. En 1576, Frédéric II offre à Tycho Brahe l''île de Hveen, dans le Sund, entre Elseneur et Copenhague, afin qu''il y construise l''observatoire de ses rêves et y travaille en toute liberté. Séduit par cette proposition, Tycho Brahe renonce à son projet de s''installer à Bâle et rentre au Danemark. Avec les subsides royaux et une partie de sa fortune personnelle, il fait édifier Uraniborg (le château d''Uranie), à la fois maison d''habitation et observatoire pourvu d''un atelier de construction d''instruments, d''une imprimerie, d''une papeterie, etc. Vers 1584, il y ajoutera une annexe, en partie souterraine (pour protéger les instruments du vent), Stellaeborg (le château des étoiles). Là, pendant vingt ans, Tycho Brahe et ses assistants multiplient les observations des positions de la Lune, du Soleil, des planètes et des étoiles. L''utilisation d''instruments de grandes dimensions,soigneusement gradués et munis de systèmes de visée, leur permet d''accumuler une quantité exceptionnelle de mesures dont la précision, voisine de deux minutes d''arc, est dix fois meilleure que celle des observations antérieures. À l''actif de Tycho Brahe figurent, entre autres, un catalogue de 777 étoiles et la découverte de deux inégalités du mouvement de la Lune, de la variation de l''obliquité de l''écliptique, de l''inclinaison de l''orbite de la Lune sur l''écliptique, etc.</p>
					<p>Le 13 novembre 1577, Tycho Brahe aperçoit une nouvelle comète, dont il va suivre nuit après nuit la trajectoire parmi les étoiles. En comparant ses relevés avec ceux d''autres observateurs, il montre que sa distance doit être au moins six fois celle de la Lune. Ce n''est donc pas un phénomène atmosphérique, comme la plupart des astronomes le pensent à l''époque, mais bien un objet céleste. L''observation ultérieure d''autres comètes, apparues en 1580, 1582, et 1585 confirmera leur nature astronomique.</p>
					<p ana="ObPe52">Brillant observateur, Tycho Brahe est beaucoup moins inspiré comme théoricien. Récusant l''héliocentrisme, pour des raisons à la fois physiques et métaphysiques, il rejette le système de Copernic, sans pour autant admettre celui de Ptolémée, dont il connaît les insuffisances. Dans son ouvrage De mundi aetheri recentioribus phaenomenis , publié en 1588,.il propose un système cosmologique hybride, selon lequel les planètes accompagnent le Soleil dans sa révolution autour d''une Terre immobile.
					</p>
				</div>
				
				<div type="transcription" ana="ObPe49">
					<head>L''exil et la rencontre avec Kepler</head>
					<p>Arrogant, dédaigneux, régnant en tyran sur son île, qu''il administre de façon déplorable, Tycho Brahe s''attire beaucoup d''inimitiés et finit par tomber en disgrâce. En 1597, le souverain Christian IV, qui a succédé à son père, Frédéric II, en 1588, lui supprime sa pension. Tycho Brahe regagne Copenhague puis parcourt l''Europe du Nord avant de gagner l''Allemagne. En 1599, il trouve refuge à Prague, auprès de l''empereur Rodolphe II, qui le nomme mathématicien impérial et met à sa disposition d''importants moyens. </p>
					<p>En 1600, Kepler, professeur de mathématiques à l''université calviniste de Graz, contraint de quitter son poste pour échapper aux persécutions religieuses, vient travailler auprès de lui. Tycho Brahe lui confie le soin d''étudier le mouvement de la planète Mars. Leur collaboration sera malheureusement de courte durée, car Tycho Brahe meurt le 24 octobre 1601. L''empereur lui organise de magnifiques obsèques et charge Kepler de poursuivre son oeuvre.</p>
				</div>
			</div>
		</body>
	</text>
</TEI>', 12, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (18, 'Encyclopédie en ligne', NULL, '2014-10-01 17:44:45.12619+02', '2014-10-31 22:48:54.733756+01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 12, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (24, 'Transcription TEI de la notice', NULL, '2014-10-02 20:20:32.660926+02', '2014-11-01 08:24:36.307877+01', NULL, NULL, NULL, NULL, NULL, NULL, '2014-10-02', NULL, '<?xml-stylesheet href="transformation/visualisation_navigateur.xsl" type="text/xsl"?>
<TEI xmlns="http://www.tei-c.org/ns/1.0" xml:id="ObPe24">
	<teiHeader>
		<fileDesc>
			<titleStmt>
				<title>Johannes Kepler</title>
				<author/>
			</titleStmt>
			<publicationStmt>
				<p>Document à usage personnel</p>
			</publicationStmt>
			<sourceDesc>
				<bibl>
					<ref target="http://www.larousse.fr/encyclopedie/personnage/Johannes_Kepler/127297">Notice tirée de l''encyclopédie Larousse</ref>
				</bibl>
			</sourceDesc>
		</fileDesc>
		<profileDesc>
			<creation>
				<name type="place"/>
				<date when="2014"/>
			</creation>
		</profileDesc>
		<revisionDesc>
			<change type="synchronisation_base" when="2014-11-01"/>
			<change type="production_texte" when="2014-10-02"/>
			<change type="structure" when="2014-10-03"/>
			<change type="semantique" when="2014-11-01">J''ai encodé toutes les entités nommées qui figurent dans ce texte</change>
		</revisionDesc>
	</teiHeader>
	<text>
		<body>
			<div type="structure">
				<p> Astronome allemand (<seg ana="ObPe36"><name ref="ObPe6"/>Weil, aujourd''hui <name ref="ObPe22" type="place">Weil der Stadt, Wurtemberg</name>, <date when="1571-12-27 ">le vingtseptième jour du mois de décembre 1571</date>
					</seg>-<seg ana="ObPe38">Ratisbonne 1630</seg>). </p>
				
				<div type="transcription">
					<head>
						<rs>Lois de <name ref="ObPe6">Kepler</name>
						</rs>
					</head>
					<p>Savant génial et obstiné, <seg ana="ObPe32"><rs ref="ObPe6">il</rs> est l''un des <rs>fondateurs de l''<name ref="ObPe20">astronomie</name> moderne</rs>
						</seg>.  Sa découverte, purement empirique, des lois du mouvement des planètes a bouleversé la pensée de son époque et ouvert la voie à <name ref="ObPe25">Newton</name>.  </p>
				</div>
				<div type="transcription">
					<head>Une enfance dure, mais une intelligence précoce.</head>
					<p ana="ObPe20">Johannes Kepler connaît une enfance assez dure, dans une ambiance familiale peu propice à l''éveil d''une vocation scientifique. Son père, mercenaire dans l''armée du duc de Wurtenberg, est un « soldat brutal, querelleur et immoral » souvent en campagne et qui finira par abandonner sa famille ; sa mère fera l''objet d''un procès en sorcellerie. Atteint de la variole à 3 ans, l''enfant en conservera toute sa vie des séquelles et une santé précaire. De 1574 à 1576, il vit chez ses grands-parents. Il accompagne ensuite ses parents à Leonberg, où il fréquente l''école latine. </p>
					<p>
						<seg ana="ObPe48">En 1584, il est admis au séminaire protestant d''Adelberg. Le duc de Wurtenberg le repère et décide de le prendre sous sa tutelle : en 1589, il rejoint l''université de Tübingen, où il reçoit une formation très complète. Son professeur d''astronomie, <name ref="ObPe7">Michael Mästlin</name>, lui enseigne le système de <name ref="ObPe11">Copernic</name>, dont il est un prudent défenseur. Diplômé de l''université en 1591, Kepler poursuit des études de théologie, avec le projet de devenir pasteur.</seg>
						<seg ana="ObPe49">Mais c''est finalement vers la science qu''il va se tourner, car il est nommé, en 1594, professeur de mathématiques à <name ref="ObPe35">Graz</name>. Lorsque, vers 1600, les persécutions religieuses contre les protestants l''obligent à quitter cette ville, il se réfugie à Prague, où il devient le disciple et l''assistant de l''astronome danois Tycho Brahe, auquel il succède, en 1601, comme astronome de l''empereur Rodolphe II.</seg>
					</p>
				</div>
				<div type="transcription">
					<head>Le découvreur des lois du mouvement des planètes</head>
					<p>Devenu grâce à Mästlin un partisan convaincu de l''héliocentrisme, Kepler explique dans un premier ouvrage, le <bibl><title>Prodomus… mysterium cosmographicum</title>, publié en 1596</bibl>, pourquoi le système de Ptolémée doit, selon lui, céder la place à la représentation copernicienne du monde. Mais, <seg ana="ObPe51">hanté par les idées pythagoriciennes, il croit l''Univers construit selon une architecture géométrique</seg>. Aussi élabore-t-il un ingénieux modèle géométrique du système de Copernic, dans lequel l''orbe de chaque planète occupe une sphère circonscrite à un polyèdre régulier et inscrite dans un autre. En fait, il a la conviction que le nombre de planètes, leurs distances au Soleil et leurs vitesses de révolution ne sont pas le fruit du hasard. Une étude systématique du mouvement de la planète Mars (dont la trajectoire reste mal interprétée par Ptolémée et par Copernic), après de laborieux calculs qu''il contrôle grâce aux observations précises de Tycho Brahe, le conduit à renoncer à l''hypothèse d''un mouvement circulaire – admise depuis Aristote – au profit d''une orbite elliptique. Ce travail amène Kepler à la découverte des deux premières lois qui vont immortaliser son nom. Il les publie en 1609 dans son Astronomia nova. La première énonce que chaque planète décrit dans le sens direct une ellipse dont le Soleil occupe un des foyers ; la seconde, que les aires décrites par le rayon vecteur allant du centre de la planète au centre du Soleil sont proportionnelles aux temps employés à les décrire. Kepler s''efforce ensuite de démontrer l''existence d''un rapport harmonique (au sens musical du terme) entre la plus grande et la plus petite vitesse des planètes. Il découvre ainsi la troisième loi fondamentale du mouvement des planètes, qu''il publie en 1619 dans son Harmonices mundi : les carrés des périodes de révolution des planètes sont proportionnels aux cubes des grands axes de leurs orbites. </p>
					<p>Lors de leur publication, les lois de Kepler reçoivent un accueil mitigé : Galilée, par exemple, ne se ralliera jamais à l''idée du mouvement elliptique. Dans un premier temps, elles ne connaissent qu''un succès indirect : elles permettent de calculer des tables et des éphémérides astronomiques en excellent accord avec les observations. C''est Newton qui leur donnera une portée très générale, en montrant qu''elles découlent de la loi de l''attraction universelle et qu''elles s''appliquent à tout corps en mouvement orbital autour d''un autre, notamment aux satellites des planètes. </p>
					<p>Dans les dernières années de sa vie, Kepler s''attache à établir des tables des positions des planètes, fondées sur les lois qu''il a mises en évidence. Cette tâche requiert de longs calculs, heureusement abrégés par l''invention récente des logarithmes. Elle aboutit à la publication, en 1627, des <bibl><title>Tabulae rudolphinae</title>
						</bibl> (Tables rudolphines, ainsi nommées en hommage à l''empereur Rodolphe II), qui surpassent largement en précision toutes celles publiées auparavant.</p>
					<p>Kepler meurt en 1630, dans un grand dénuement, mais livre encore, grâce à son gendre Jacob Bartsch (1600-1633), une œuvre posthume, <bibl><title>Somnium seu astronomia lunari</title>
						</bibl>, véritable roman de science-fiction sur le thème du voyage vers la Lune. </p>
				</div>
			</div>
		</body>
	</text>
</TEI>', 12, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (39, 'Lieu habité en Provence', NULL, '2014-10-08 22:47:27.575059+02', '2014-10-15 15:06:00.369184+02', NULL, NULL, NULL, NULL, 5.45000000000000018, 43, NULL, NULL, NULL, 19, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (35, 'Ville en Autriche', NULL, '2014-10-07 15:39:56.221982+02', '2014-10-17 15:08:13.017269+02', NULL, NULL, NULL, NULL, 5.7889999999999997, 55.990000000000002, NULL, NULL, NULL, 19, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (47, 'Ville française', NULL, '2014-10-17 15:14:50.383761+02', '2014-10-17 15:40:32.62372+02', NULL, NULL, NULL, NULL, 4.83351199999999981, 45.7674629999999993, NULL, NULL, NULL, 19, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (41, 'Chateau situé dans la municipalité de Svalöv, Scania, en Suède méridionale. Lieu de naissance de Tycho Brahe', NULL, '2014-10-08 23:33:09.47834+02', '2014-10-17 15:41:58.586644+02', NULL, NULL, NULL, NULL, 13.1351849999999999, 55.9797530000000023, NULL, NULL, NULL, 20, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (20, '"Premières années de la vie d''un être humain jusqu''à l''adolescence." (http://www.cnrtl.fr/definition/enfance)
Utilisé comme type de texte XML', NULL, '2014-10-02 19:13:07.27137+02', '2014-10-31 12:13:49.974994+01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (48, 'Fait de se former ou d''être formé. Les années de formation d''une personne', NULL, '2014-10-31 12:17:05.446502+01', '2014-10-31 12:17:23.680541+01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (49, '"Profession où l''on s''engage et dont on peut parcourir les degrés." (http://www.cnrtl.fr/definition/carrière)', NULL, '2014-10-31 12:18:33.103302+01', '2014-10-31 12:19:16.685062+01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (50, 'Tout ce qui concerne les origines familiales d''un acteur', NULL, '2014-10-31 13:36:21.209184+01', '2014-10-31 13:36:35.975334+01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (51, 'Doctrine professée, éventuellement inventée par un acteur', NULL, '2014-10-31 13:40:49.480921+01', '2014-10-31 13:41:27.76696+01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (52, 'Classe de texte concernant les opinions d''un acteur', NULL, '2014-10-31 22:43:08.356992+01', '2014-10-31 22:43:19.375011+01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (31, 'Notice Larousse littératures, transcription TEI', NULL, '2014-10-03 10:23:43.833513+02', '2014-10-31 22:50:26.275308+01', NULL, NULL, NULL, NULL, NULL, NULL, '2014-10-03', NULL, '<?xml-stylesheet href="transformation/visualisation_navigateur.xsl" type="text/xsl"?>
<TEI xmlns="http://www.tei-c.org/ns/1.0" xml:id="ObPe31">
	<teiHeader>
		<fileDesc>
			<titleStmt>
				<title>Pierre Gassend, dit Gassendi</title>
				<author/>
			</titleStmt>
			<publicationStmt>
				<p>Document à usage personnel</p>
			</publicationStmt>
			<sourceDesc>
				<bibl>
					<ref target="http://www.larousse.fr/encyclopedie/personnage/Pierre_Gassend_dit_Gassendi/120894">Notice</ref>
				</bibl>
			</sourceDesc>
		</fileDesc>
		<revisionDesc>
			<change type="synchronisation_base" when="2014-10-19">
					Mise-à-jour effectuée
				</change>
			<change type="production_texte" when="2014-10-02"/>
			<change type="structure" when="2014-10-03"/>
			<change type="semantique" when="2014-10-03">J''ai encodé toutes les entités nommées qui figurent dans ce texte</change>
		</revisionDesc>
	</teiHeader>
	<text>
		<body>
			<div type="transcription">
				<p>Philosophe et savant français (Champtercier, près de Digne-les-Bains, 1592-Paris 1655). </p>
				<p>
					<seg ana="ObPe48">Docteur en théologie à Avignon en <date when="1614">1614</date>
					</seg>, <seg ana="ObPe49">il entra dans les ordres en <date when="1615">1615</date>
					</seg>. Résidant le plus souvent à Paris,<seg ana="ObPe49"> il enseigna les mathématiques au Collège royal <date from="1645" to="1648">de 1645 à 1648</date>
					</seg>.
					</p>
				<p ana="ObPe52">Il critiqua <name ref="ObPe27">Aristote</name>, sans oser publier tous les livres où il faisait part de ses remarques, répondit à Descartes (Objections aux Méditations, 1644), développa une théorie atomiste à la manière de Démocrite, à laquelle il superposa une perspective harmoniste des éléments qui composent le monde. En astronomie, il fut un pionnier de l''observation des planètes à la lunette et fit la première description scientifique d''une aurore boréale (1621). En physique, il a étudié la chute des corps et les lois du choc, expliqué la hauteur des sons et mesuré leur vitesse de propagation. </p>
			</div>
		</body>
	</text>
</TEI>', 12, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (26, 'Transcription TEI de la notice tirée du Larousse en ligne', NULL, '2014-10-03 00:16:08.11204+02', '2014-11-01 08:26:30.201155+01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<?xml-stylesheet href="transformation/visualisation_navigateur.xsl" type="text/xsl"?>
<TEI xmlns="http://www.tei-c.org/ns/1.0" xml:id="ObPe26">
	<teiHeader>
		<fileDesc>
			<titleStmt>
				<title>Nicolas Claude Fabri de Peiresc</title>
				<author/>
			</titleStmt>
			<publicationStmt>
				<p>Document à usage personnel</p>
			</publicationStmt>
			<sourceDesc>
				<bibl>Cet <ref target="http://www.larousse.fr/encyclopedie/litterature/Peiresc/175946">article</ref> est extrait de l''ouvrage Larousse « Dictionnaire mondial des littératures »</bibl>
			</sourceDesc>
		</fileDesc>
		<revisionDesc>
			<change type="synchronisation_base" when="2014-11-01"/>
			<change type="production_texte" when="2014-10-02"/>
			<change type="structure" when="2014-10-03"/>
			<change type="semantique" when="2014-11-01">J''ai encodé toutes les entités nommées qui figurent dans ce texte</change>
		</revisionDesc>
	</teiHeader>
	<text>
		<body>
			<div type="structure">
				<p>Érudit et collectionneur français (<seg ana="ObPe36"><name ref="ObPe9"/>
						<name ref="ObPe39">Belgentier, Provence</name>, <date when="1580">1580</date>
					</seg> – Aix-en-Provence 1637). </p>
				<div type="transcription">
					<p>Ce <seg ana="ObPe49">conseiller au parlement d''Aix</seg> voyagea à travers l''Europe et se lia avec les grands collectionneurs et bibliothécaires de son temps.</p>
					<p><seg ana="ObPe49">Secrétaire du garde des sceaux Guillaume du Vair en 1616</seg>, il devient un membre assidu de l''Académie des frères Dupuy (où il rencontre <name ref="ObPe8">Gassendi</name>, Guez de Balzac, Ducange).</p>
					<p>Témoin typique de la curiosité du xviie siècle, il réunit et observe les choses et les faits curieux dont on peut mesurer l''ampleur dans la correspondance qu''il a laissée. </p></div>
				</div>
			</body>
		</text>
	</TEI>', 12, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, certitude_dd, certitude_df, cle_importation, cle_importation_txt, longitude, latitude, date_debut, date_fin, texte_tei, fk_type_objet, sexe) VALUES (53, 'Encyclopédie', NULL, '2014-11-01 08:43:36.719667+01', '2014-11-01 08:44:30.530647+01', NULL, NULL, NULL, NULL, NULL, NULL, '1967', '1975', NULL, 11, NULL);


--
-- TOC entry 2323 (class 0 OID 0)
-- Dependencies: 178
-- Name: objet_cle_objet_seq; Type: SEQUENCE SET; Schema: objets; Owner: -
--

SELECT pg_catalog.setval('objet_cle_objet_seq', 53, true);


--
-- TOC entry 2186 (class 2606 OID 112109)
-- Name: associer_objets_pkey; Type: CONSTRAINT; Schema: objets; Owner: -; Tablespace: 
--

ALTER TABLE ONLY associer_objets
    ADD CONSTRAINT associer_objets_pkey PRIMARY KEY (pk_associer_objets);


--
-- TOC entry 2182 (class 2606 OID 95856)
-- Name: nom_objet_pkey; Type: CONSTRAINT; Schema: objets; Owner: -; Tablespace: 
--

ALTER TABLE ONLY nom_objet
    ADD CONSTRAINT nom_objet_pkey PRIMARY KEY (pk_nom_objet);


--
-- TOC entry 2184 (class 2606 OID 95858)
-- Name: objet_pkey; Type: CONSTRAINT; Schema: objets; Owner: -; Tablespace: 
--

ALTER TABLE ONLY objet
    ADD CONSTRAINT objet_pkey PRIMARY KEY (pk_objet);


--
-- TOC entry 2178 (class 1259 OID 95859)
-- Name: idx_fk_objet; Type: INDEX; Schema: objets; Owner: -; Tablespace: 
--

CREATE INDEX idx_fk_objet ON nom_objet USING btree (fk_objet);


--
-- TOC entry 2179 (class 1259 OID 120307)
-- Name: nom_objet_langue_idx; Type: INDEX; Schema: objets; Owner: -; Tablespace: 
--

CREATE INDEX nom_objet_langue_idx ON nom_objet USING btree (langue);


--
-- TOC entry 2180 (class 1259 OID 120313)
-- Name: nom_objet_nom_idx; Type: INDEX; Schema: objets; Owner: -; Tablespace: 
--

CREATE INDEX nom_objet_nom_idx ON nom_objet USING btree (nom);


--
-- TOC entry 2193 (class 2620 OID 120317)
-- Name: update_associer_objets_creatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_associer_objets_creatime BEFORE INSERT ON associer_objets FOR EACH ROW EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 2192 (class 2620 OID 120316)
-- Name: update_associer_objets_updatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_associer_objets_updatime BEFORE UPDATE ON associer_objets FOR EACH ROW EXECUTE PROCEDURE update_updated_column();


--
-- TOC entry 2188 (class 2620 OID 95860)
-- Name: update_nom_objet_creatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_nom_objet_creatime BEFORE INSERT ON nom_objet FOR EACH ROW EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 2189 (class 2620 OID 120314)
-- Name: update_nom_objet_updatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_nom_objet_updatime BEFORE UPDATE ON nom_objet FOR EACH ROW EXECUTE PROCEDURE update_updated_column();


--
-- TOC entry 2190 (class 2620 OID 95861)
-- Name: update_objet_creatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_objet_creatime BEFORE INSERT ON objet FOR EACH ROW EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 2191 (class 2620 OID 120309)
-- Name: update_objet_updatime; Type: TRIGGER; Schema: objets; Owner: -
--

CREATE TRIGGER update_objet_updatime BEFORE UPDATE ON objet FOR EACH ROW EXECUTE PROCEDURE update_updated_column();


--
-- TOC entry 2187 (class 2606 OID 95862)
-- Name: nom_objet_fk_objet_fkey; Type: FK CONSTRAINT; Schema: objets; Owner: -
--

ALTER TABLE ONLY nom_objet
    ADD CONSTRAINT nom_objet_fk_objet_fkey FOREIGN KEY (fk_objet) REFERENCES objet(pk_objet) ON UPDATE CASCADE ON DELETE CASCADE;


-- Completed on 2014-11-01 09:58:40 CET

--
-- PostgreSQL database dump complete
--

