--
-- PostgreSQL database dump
--

-- Dumped from database version 9.3.1
-- Dumped by pg_dump version 9.3.1
-- Started on 2014-11-01 10:06:16 CET

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 10 (class 2615 OID 112093)
-- Name: vues_analyse; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA vues_analyse;


SET search_path = vues_analyse, pg_catalog;

--
-- TOC entry 201 (class 1259 OID 145256)
-- Name: v_xml_balises_avec_ana; Type: VIEW; Schema: vues_analyse; Owner: -
--

CREATE VIEW v_xml_balises_avec_ana AS
 WITH ta1 AS (
         SELECT t1_1.pk_objet, 
            unnest(xpath('//tei:*[@ana]'::text, t1_1.texte_tei, ARRAY[ARRAY['tei'::text, 'http://www.tei-c.org/ns/1.0'::text]])) AS texte_xml, 
            (unnest(xpath('//tei:*[@ana]/@ana'::text, t1_1.texte_tei, ARRAY[ARRAY['tei'::text, 'http://www.tei-c.org/ns/1.0'::text]])))::text AS type_texte
           FROM objets.objet t1_1
        )
 SELECT ('ObPe'::text || t1.pk_objet) AS cle_texte, 
    t3.nom_cible AS objet_concerne, 
    (unnest(xpath('name(/*)'::text, t1.texte_xml)))::text AS nom_balise, 
    t2.nom AS typologie, 
        CASE
            WHEN "xmlexists"('/*/date'::text, t1.texte_xml) THEN (unnest(xpath('/*/date/@when|/*/date/@from'::text, t1.texte_xml)))::text
            ELSE ''::text
        END AS date_debut, 
    btrim(regexp_replace(regexp_replace(regexp_replace(regexp_replace((unnest(xpath('/'::text, t1.texte_xml)))::text, '(.*?)<(\w+)\s+.*?>(.*)'::text, '\1<\2>\3'::text, 'g'::text), '(\n){0,5}(<\w*>)'::text, ''::text, 'g'::text), '</\w*>'::text, ''::text, 'g'::text), '(\t)'::text, ''::text, 'g'::text)) AS texte_sans_balises
   FROM ((ta1 t1
   LEFT JOIN vues_affichage.v_proprietes_standard_objet t2 ON ((t2.cle_objet = t1.type_texte)))
   LEFT JOIN vues_affichage.v_associations_objets t3 ON ((t3.pk_source = t1.pk_objet)))
  WHERE (t3.cle_type_association = 14)
  ORDER BY t1.pk_objet;


-- Completed on 2014-11-01 10:06:16 CET

--
-- PostgreSQL database dump complete
--

