--
-- PostgreSQL database dump
--

-- Dumped from database version 9.3.1
-- Dumped by pg_dump version 9.3.1
-- Started on 2014-11-21 13:38:10 CET

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 8 (class 2615 OID 95830)
-- Name: objets; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA objets;


--
-- TOC entry 7 (class 2615 OID 112069)
-- Name: parametres; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA parametres;


--
-- TOC entry 11 (class 2615 OID 145552)
-- Name: types_uc; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA types_uc;


--
-- TOC entry 12 (class 2615 OID 146203)
-- Name: unites_de_connaissance; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA unites_de_connaissance;


--
-- TOC entry 9 (class 2615 OID 112092)
-- Name: vues_affichage; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA vues_affichage;


--
-- TOC entry 10 (class 2615 OID 112093)
-- Name: vues_analyse; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA vues_analyse;


--
-- TOC entry 217 (class 3079 OID 12018)
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- TOC entry 2483 (class 0 OID 0)
-- Dependencies: 217
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: -
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = objets, pg_catalog;

--
-- TOC entry 230 (class 1255 OID 95831)
-- Name: update_created_column(); Type: FUNCTION; Schema: objets; Owner: -
--

CREATE FUNCTION update_created_column() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	   NEW.date_creation = now(); 
	   RETURN NEW;
	END;
$$;


--
-- TOC entry 231 (class 1255 OID 120308)
-- Name: update_updated_column(); Type: FUNCTION; Schema: objets; Owner: -
--

CREATE FUNCTION update_updated_column() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	   NEW.date_modification = now(); 
	   RETURN NEW;
	END;
$$;


SET search_path = unites_de_connaissance, pg_catalog;

--
-- TOC entry 232 (class 1255 OID 146204)
-- Name: create_info_date_concatenated_date(); Type: FUNCTION; Schema: unites_de_connaissance; Owner: -
--

CREATE FUNCTION create_info_date_concatenated_date() RETURNS trigger
    LANGUAGE plpgsql
    AS $$

DECLARE variable_date text;

BEGIN

IF NEW.annee IS NOT NULL AND NEW.mois IS NULL THEN
	IF NEW.annee < 0 THEN
		variable_date := substring(to_char(NEW.annee, '0000')from 1 for 5);
	ELSE
		variable_date := substring(to_char(NEW.annee, '0000')from 2 for 5);
	END IF;
END IF;

IF NEW.annee IS NOT NULL AND NEW.mois IS NOT NULL AND NEW.jour IS NULL THEN
	IF NEW.annee < 0 THEN
		variable_date := substring(to_char(NEW.annee, '0000')from 1 for 5)||'-'||substring(to_char(NEW.mois, '00') from 2 for 3);	
	ELSE
		variable_date := substring(to_char(NEW.annee, '0000')from 2 for 5)||'-'||substring(to_char(NEW.mois, '00') from 2 for 3);
	END IF;
END IF;

IF NEW.annee IS NOT NULL AND NEW.mois IS NOT NULL AND NEW.jour IS NOT NULL THEN
	IF NEW.annee < 0 THEN
		variable_date := substring(to_char(NEW.annee, '0000')from 1 for 5)||'-'||substring(to_char(NEW.mois, '00') from 2 for 3)||'-'||substring(to_char(NEW.jour, '00') from 2 for 3);
	ELSE
		variable_date := substring(to_char(NEW.annee, '0000')from 2 for 5)||'-'||substring(to_char(NEW.mois, '00') from 2 for 3)||'-'||substring(to_char(NEW.jour, '00') from 2 for 3);
	END IF;
END IF;


IF NEW.annee IS NULL
THEN variable_date := NULL;
END IF;


IF  NEW.certitude_date = 1
THEN variable_date := variable_date;
ELSEIF NEW.certitude_date = 2
THEN variable_date := variable_date || ' r';

ELSEIF NEW.certitude_date = 3
THEN variable_date := variable_date || ' p';
END IF;




NEW.date_recomposee =  variable_date;

RETURN NEW;

END;
$$;


SET search_path = objets, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 185 (class 1259 OID 112101)
-- Name: associer_objets; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE associer_objets (
    pk_associer_objets integer NOT NULL,
    fk_objet_source integer,
    fk_objet_cible integer,
    fk_type_association_objets integer,
    reference_precise text,
    url text,
    descriptif text,
    notes text,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone
);


--
-- TOC entry 184 (class 1259 OID 112099)
-- Name: associer_objets_pk_associer_objets_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE associer_objets_pk_associer_objets_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2484 (class 0 OID 0)
-- Dependencies: 184
-- Name: associer_objets_pk_associer_objets_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE associer_objets_pk_associer_objets_seq OWNED BY associer_objets.pk_associer_objets;


--
-- TOC entry 176 (class 1259 OID 95832)
-- Name: nom_objet; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE nom_objet (
    pk_nom_objet integer NOT NULL,
    nom text,
    langue character varying(255),
    notes text,
    fk_objet integer,
    est_standard boolean,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone,
    fk_type_nom integer,
    date_debut character varying(10),
    date_fin character varying(10)
);


--
-- TOC entry 177 (class 1259 OID 95838)
-- Name: nom_objet_cle_nom_objet_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE nom_objet_cle_nom_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2485 (class 0 OID 0)
-- Dependencies: 177
-- Name: nom_objet_cle_nom_objet_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE nom_objet_cle_nom_objet_seq OWNED BY nom_objet.pk_nom_objet;


--
-- TOC entry 178 (class 1259 OID 95840)
-- Name: objet; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE objet (
    pk_objet integer NOT NULL,
    definition text,
    notes text,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone,
    certitude_dd integer,
    certitude_df integer,
    cle_importation integer,
    cle_importation_txt text,
    longitude double precision,
    latitude double precision,
    date_debut character varying(10),
    date_fin character varying(10),
    texte_tei xml,
    fk_type_objet integer NOT NULL,
    sexe character(1)
);


--
-- TOC entry 2486 (class 0 OID 0)
-- Dependencies: 178
-- Name: COLUMN objet.longitude; Type: COMMENT; Schema: objets; Owner: -
--

COMMENT ON COLUMN objet.longitude IS 'ALTER TABLE objets.objet
   ALTER COLUMN longitude TYPE double precision;
';


--
-- TOC entry 2487 (class 0 OID 0)
-- Dependencies: 178
-- Name: COLUMN objet.latitude; Type: COMMENT; Schema: objets; Owner: -
--

COMMENT ON COLUMN objet.latitude IS 'ALTER TABLE objets.objet
   ALTER COLUMN latitude TYPE double precision;
';


--
-- TOC entry 179 (class 1259 OID 95846)
-- Name: objet_cle_objet_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE objet_cle_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2488 (class 0 OID 0)
-- Dependencies: 179
-- Name: objet_cle_objet_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE objet_cle_objet_seq OWNED BY objet.pk_objet;


SET search_path = parametres, pg_catalog;

--
-- TOC entry 180 (class 1259 OID 112070)
-- Name: associer_parametres_systeme; Type: TABLE; Schema: parametres; Owner: -; Tablespace: 
--

CREATE TABLE associer_parametres_systeme (
    pk_associer_parametres_systeme integer NOT NULL,
    fk_parametre_source integer,
    fk_parametre_cible integer,
    descriptif text,
    notes text,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone
);


--
-- TOC entry 181 (class 1259 OID 112076)
-- Name: associer_parametres_systeme_pk_associer_parametres_systeme_seq; Type: SEQUENCE; Schema: parametres; Owner: -
--

CREATE SEQUENCE associer_parametres_systeme_pk_associer_parametres_systeme_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2489 (class 0 OID 0)
-- Dependencies: 181
-- Name: associer_parametres_systeme_pk_associer_parametres_systeme_seq; Type: SEQUENCE OWNED BY; Schema: parametres; Owner: -
--

ALTER SEQUENCE associer_parametres_systeme_pk_associer_parametres_systeme_seq OWNED BY associer_parametres_systeme.pk_associer_parametres_systeme;


--
-- TOC entry 182 (class 1259 OID 112078)
-- Name: parametre_systeme; Type: TABLE; Schema: parametres; Owner: -; Tablespace: 
--

CREATE TABLE parametre_systeme (
    pk_parametre_systeme integer NOT NULL,
    valeur character varying(255),
    definition text,
    notes text,
    type_valeur character varying(255),
    champ_concerne character varying(255),
    date_creation timestamp with time zone,
    date_modification timestamp with time zone,
    classe_concernee character varying(255)
);


--
-- TOC entry 183 (class 1259 OID 112084)
-- Name: parametres_systeme_pk_parametre_systeme_seq; Type: SEQUENCE; Schema: parametres; Owner: -
--

CREATE SEQUENCE parametres_systeme_pk_parametre_systeme_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2490 (class 0 OID 0)
-- Dependencies: 183
-- Name: parametres_systeme_pk_parametre_systeme_seq; Type: SEQUENCE OWNED BY; Schema: parametres; Owner: -
--

ALTER SEQUENCE parametres_systeme_pk_parametre_systeme_seq OWNED BY parametre_systeme.pk_parametre_systeme;


SET search_path = types_uc, pg_catalog;

--
-- TOC entry 190 (class 1259 OID 145553)
-- Name: associer_type_uc_type_role; Type: TABLE; Schema: types_uc; Owner: -; Tablespace: 
--

CREATE TABLE associer_type_uc_type_role (
    pk_associer_type_uc_type_role integer NOT NULL,
    descriptif text,
    notes text,
    fk_type_uc integer,
    type_uc_cle_objet_bhp character varying(20),
    fk_type_role integer,
    type_role_cle_objet_bhp character varying(20),
    date_mise_a_jour timestamp without time zone,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone,
    cle_association character varying(30)
);


--
-- TOC entry 191 (class 1259 OID 145559)
-- Name: associer_type_uc_type_role_pk_associer_type_uc_type_role_seq; Type: SEQUENCE; Schema: types_uc; Owner: -
--

CREATE SEQUENCE associer_type_uc_type_role_pk_associer_type_uc_type_role_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2491 (class 0 OID 0)
-- Dependencies: 191
-- Name: associer_type_uc_type_role_pk_associer_type_uc_type_role_seq; Type: SEQUENCE OWNED BY; Schema: types_uc; Owner: -
--

ALTER SEQUENCE associer_type_uc_type_role_pk_associer_type_uc_type_role_seq OWNED BY associer_type_uc_type_role.pk_associer_type_uc_type_role;


--
-- TOC entry 192 (class 1259 OID 145561)
-- Name: type_role; Type: TABLE; Schema: types_uc; Owner: -; Tablespace: 
--

CREATE TABLE type_role (
    pk_type_role integer NOT NULL,
    nom text,
    autres_noms text,
    descriptif text,
    notes text,
    cle_objet_bhp character varying(20),
    date_mise_a_jour timestamp without time zone,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone
);


--
-- TOC entry 193 (class 1259 OID 145567)
-- Name: type_role_pk_type_role_seq; Type: SEQUENCE; Schema: types_uc; Owner: -
--

CREATE SEQUENCE type_role_pk_type_role_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2492 (class 0 OID 0)
-- Dependencies: 193
-- Name: type_role_pk_type_role_seq; Type: SEQUENCE OWNED BY; Schema: types_uc; Owner: -
--

ALTER SEQUENCE type_role_pk_type_role_seq OWNED BY type_role.pk_type_role;


--
-- TOC entry 194 (class 1259 OID 145569)
-- Name: type_unite_connaissance; Type: TABLE; Schema: types_uc; Owner: -; Tablespace: 
--

CREATE TABLE type_unite_connaissance (
    pk_type_unite_connaissance integer NOT NULL,
    nom text,
    autres_noms text,
    descriptif text,
    notes text,
    cle_objet_bhp character varying(20),
    date_mise_a_jour timestamp without time zone,
    si_utilise boolean DEFAULT false,
    categorie_uc character varying(15),
    date_creation timestamp with time zone,
    date_modification timestamp with time zone
);


--
-- TOC entry 195 (class 1259 OID 145576)
-- Name: type_unite_connaissance_pk_type_unite_connaissance_seq; Type: SEQUENCE; Schema: types_uc; Owner: -
--

CREATE SEQUENCE type_unite_connaissance_pk_type_unite_connaissance_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2493 (class 0 OID 0)
-- Dependencies: 195
-- Name: type_unite_connaissance_pk_type_unite_connaissance_seq; Type: SEQUENCE OWNED BY; Schema: types_uc; Owner: -
--

ALTER SEQUENCE type_unite_connaissance_pk_type_unite_connaissance_seq OWNED BY type_unite_connaissance.pk_type_unite_connaissance;


SET search_path = unites_de_connaissance, pg_catalog;

--
-- TOC entry 197 (class 1259 OID 146205)
-- Name: associer_unite_connaissance_objet; Type: TABLE; Schema: unites_de_connaissance; Owner: -; Tablespace: 
--

CREATE TABLE associer_unite_connaissance_objet (
    pk_associer_unite_connaissance_objet integer NOT NULL,
    fk_unite_connaissance integer,
    fk_objet integer,
    fk_type_association_objet integer,
    notes text,
    descriptif text,
    reference_precise text,
    date_creation time with time zone,
    date_modification time with time zone
);


--
-- TOC entry 2494 (class 0 OID 0)
-- Dependencies: 197
-- Name: TABLE associer_unite_connaissance_objet; Type: COMMENT; Schema: unites_de_connaissance; Owner: -
--

COMMENT ON TABLE associer_unite_connaissance_objet IS 'Cette table fait la jointure entre les unités de connaissance et les objets qui permettent de classer, documenter, etc. les unités de connaissance';


--
-- TOC entry 198 (class 1259 OID 146211)
-- Name: associer_unite_connaissance_o_pk_associer_unite_connaissanc_seq; Type: SEQUENCE; Schema: unites_de_connaissance; Owner: -
--

CREATE SEQUENCE associer_unite_connaissance_o_pk_associer_unite_connaissanc_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2495 (class 0 OID 0)
-- Dependencies: 198
-- Name: associer_unite_connaissance_o_pk_associer_unite_connaissanc_seq; Type: SEQUENCE OWNED BY; Schema: unites_de_connaissance; Owner: -
--

ALTER SEQUENCE associer_unite_connaissance_o_pk_associer_unite_connaissanc_seq OWNED BY associer_unite_connaissance_objet.pk_associer_unite_connaissance_objet;


--
-- TOC entry 199 (class 1259 OID 146213)
-- Name: date_unite_connaissance; Type: TABLE; Schema: unites_de_connaissance; Owner: -; Tablespace: 
--

CREATE TABLE date_unite_connaissance (
    pk_date_unite_connaissance integer NOT NULL,
    fk_type_date integer,
    libelle_selon_source text,
    annee integer,
    mois integer,
    jour integer,
    date_recomposee character varying(20),
    certitude_date smallint,
    qualificatif_date smallint,
    marge_date integer,
    heures integer,
    minutes integer,
    secondes integer,
    descriptif text,
    notes text,
    fk_unite_connaissance integer,
    date_creation time with time zone,
    date_modification time with time zone,
    certitude_heure smallint,
    marge_heure integer,
    cle_importation integer
);


--
-- TOC entry 200 (class 1259 OID 146219)
-- Name: date_unite_connaissance_pk_date_unite_connaissance_seq; Type: SEQUENCE; Schema: unites_de_connaissance; Owner: -
--

CREATE SEQUENCE date_unite_connaissance_pk_date_unite_connaissance_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2496 (class 0 OID 0)
-- Dependencies: 200
-- Name: date_unite_connaissance_pk_date_unite_connaissance_seq; Type: SEQUENCE OWNED BY; Schema: unites_de_connaissance; Owner: -
--

ALTER SEQUENCE date_unite_connaissance_pk_date_unite_connaissance_seq OWNED BY date_unite_connaissance.pk_date_unite_connaissance;


--
-- TOC entry 201 (class 1259 OID 146221)
-- Name: propriete_texte; Type: TABLE; Schema: unites_de_connaissance; Owner: -; Tablespace: 
--

CREATE TABLE propriete_texte (
    pk_propriete_texte integer NOT NULL,
    texte text,
    descriptif text,
    notes text,
    code_langue character(3),
    fk_unite_connaissance integer,
    fk_type_propriete integer,
    date_creation time with time zone,
    date_modification time with time zone
);


--
-- TOC entry 202 (class 1259 OID 146227)
-- Name: propriete_texte_pk_propriete_texte_seq; Type: SEQUENCE; Schema: unites_de_connaissance; Owner: -
--

CREATE SEQUENCE propriete_texte_pk_propriete_texte_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2497 (class 0 OID 0)
-- Dependencies: 202
-- Name: propriete_texte_pk_propriete_texte_seq; Type: SEQUENCE OWNED BY; Schema: unites_de_connaissance; Owner: -
--

ALTER SEQUENCE propriete_texte_pk_propriete_texte_seq OWNED BY propriete_texte.pk_propriete_texte;


--
-- TOC entry 203 (class 1259 OID 146229)
-- Name: role; Type: TABLE; Schema: unites_de_connaissance; Owner: -; Tablespace: 
--

CREATE TABLE role (
    pk_role integer NOT NULL,
    libelle_selon_source text,
    valeur_numerique numeric,
    si_sujet_uc boolean,
    descriptif text,
    notes text,
    date_creation timestamp without time zone,
    fk_unite_connaissance integer,
    fk_objet_associe integer,
    fk_unite_connaissance_associee integer,
    fk_unite_mesure_valeur_numerique integer,
    fk_role_associe integer,
    notes_role_associe text,
    fk_type_role integer,
    fk_qualificatif_objet integer,
    fk_type_valeur_numerique integer,
    fk_uc_qualificatif_objet integer,
    date_modification time with time zone,
    cle_importation_objet_associe character varying(200),
    cle_importation_type_role character varying(200),
    cle_importation integer
);


--
-- TOC entry 204 (class 1259 OID 146235)
-- Name: role_pk_role_seq; Type: SEQUENCE; Schema: unites_de_connaissance; Owner: -
--

CREATE SEQUENCE role_pk_role_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2498 (class 0 OID 0)
-- Dependencies: 204
-- Name: role_pk_role_seq; Type: SEQUENCE OWNED BY; Schema: unites_de_connaissance; Owner: -
--

ALTER SEQUENCE role_pk_role_seq OWNED BY role.pk_role;


--
-- TOC entry 205 (class 1259 OID 146237)
-- Name: sourcer; Type: TABLE; Schema: unites_de_connaissance; Owner: -; Tablespace: 
--

CREATE TABLE sourcer (
    pk_sourcer integer NOT NULL,
    reference_precise text,
    descriptif text,
    notes text,
    fk_unite_connaissance integer,
    fk_objet integer,
    date_creation time with time zone,
    date_modification time with time zone
);


--
-- TOC entry 206 (class 1259 OID 146243)
-- Name: sourcer_pk_sourcer_seq; Type: SEQUENCE; Schema: unites_de_connaissance; Owner: -
--

CREATE SEQUENCE sourcer_pk_sourcer_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2499 (class 0 OID 0)
-- Dependencies: 206
-- Name: sourcer_pk_sourcer_seq; Type: SEQUENCE OWNED BY; Schema: unites_de_connaissance; Owner: -
--

ALTER SEQUENCE sourcer_pk_sourcer_seq OWNED BY sourcer.pk_sourcer;


--
-- TOC entry 207 (class 1259 OID 146245)
-- Name: unite_connaissance; Type: TABLE; Schema: unites_de_connaissance; Owner: -; Tablespace: 
--

CREATE TABLE unite_connaissance (
    pk_unite_connaissance integer NOT NULL,
    descriptif text,
    notes text,
    date_creation timestamp without time zone,
    fk_type_unite_connaissance integer,
    date_modification timestamp with time zone,
    cle_importation character varying(30),
    cle_importation_type_uc integer
);


--
-- TOC entry 208 (class 1259 OID 146251)
-- Name: unite_connaissance_pk_unite_connaissance_seq; Type: SEQUENCE; Schema: unites_de_connaissance; Owner: -
--

CREATE SEQUENCE unite_connaissance_pk_unite_connaissance_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2500 (class 0 OID 0)
-- Dependencies: 208
-- Name: unite_connaissance_pk_unite_connaissance_seq; Type: SEQUENCE OWNED BY; Schema: unites_de_connaissance; Owner: -
--

ALTER SEQUENCE unite_connaissance_pk_unite_connaissance_seq OWNED BY unite_connaissance.pk_unite_connaissance;


SET search_path = vues_affichage, pg_catalog;

--
-- TOC entry 186 (class 1259 OID 112116)
-- Name: v_association_parametres; Type: VIEW; Schema: vues_affichage; Owner: -
--

CREATE VIEW v_association_parametres AS
 SELECT t1.pk_parametre_systeme AS cle_source, 
    t1.valeur AS valeur_source, 
    t1.type_valeur AS type_valeur_source, 
    t1.classe_concernee AS classe_concernee_source, 
    t1.champ_concerne AS champ_source, 
    t3.pk_parametre_systeme AS cle_cible, 
    t3.valeur AS valeur_cible, 
    t3.type_valeur AS type_objet_cible, 
    t3.classe_concernee AS classe_concernee_cible, 
    t3.champ_concerne AS champ_cible
   FROM parametres.parametre_systeme t1, 
    parametres.associer_parametres_systeme t2, 
    parametres.parametre_systeme t3
  WHERE ((t1.pk_parametre_systeme = t2.fk_parametre_source) AND (t3.pk_parametre_systeme = t2.fk_parametre_cible));


--
-- TOC entry 196 (class 1259 OID 145593)
-- Name: v_association_uc_roles_definition; Type: VIEW; Schema: vues_affichage; Owner: -
--

CREATE VIEW v_association_uc_roles_definition AS
 SELECT t1.fk_type_uc, 
    t2.nom, 
    t1.descriptif AS usage_particulier, 
    t2.descriptif AS definition_generale, 
    t2.pk_type_role, 
    t2.cle_objet_bhp AS cle_symogih
   FROM (types_uc.associer_type_uc_type_role t1
   LEFT JOIN types_uc.type_role t2 ON ((t2.pk_type_role = t1.fk_type_role)))
  ORDER BY t1.fk_type_uc;


--
-- TOC entry 187 (class 1259 OID 128501)
-- Name: v_proprietes_standard_objet; Type: TABLE; Schema: vues_affichage; Owner: -; Tablespace: 
--

CREATE TABLE v_proprietes_standard_objet (
    pk_objet integer,
    cle_objet text,
    nom text,
    type_objet character varying(255),
    date_debut character varying(10),
    date_fin character varying(10),
    definition text,
    tous_les_noms text,
    classes text,
    texte_tei xml
);


--
-- TOC entry 188 (class 1259 OID 128506)
-- Name: v_associations_objets; Type: VIEW; Schema: vues_affichage; Owner: -
--

CREATE VIEW v_associations_objets AS
 SELECT t2.pk_objet AS pk_source, 
    ('ObPe'::text || t2.pk_objet) AS cle_source, 
    t2.nom AS nom_source, 
    t2.type_objet AS type_source, 
    t4.valeur AS type_association, 
    t3.nom AS nom_cible, 
    t3.pk_objet AS pk_cible, 
    ('ObPe'::text || t3.pk_objet) AS cle_cible, 
    t3.type_objet AS type_cible, 
    t1.pk_associer_objets, 
    t1.fk_type_association_objets AS cle_type_association, 
    t2.classes AS classes_source, 
    t3.classes AS classes_cible
   FROM (((objets.associer_objets t1
   LEFT JOIN v_proprietes_standard_objet t2 ON ((t2.pk_objet = t1.fk_objet_source)))
   LEFT JOIN v_proprietes_standard_objet t3 ON ((t3.pk_objet = t1.fk_objet_cible)))
   LEFT JOIN parametres.parametre_systeme t4 ON ((t4.pk_parametre_systeme = t1.fk_type_association_objets)));


--
-- TOC entry 209 (class 1259 OID 146319)
-- Name: v_date_standard_uc; Type: VIEW; Schema: vues_affichage; Owner: -
--

CREATE VIEW v_date_standard_uc AS
 SELECT date_unite_connaissance.fk_unite_connaissance, 
    (ARRAY( SELECT unnest(array_agg(date_unite_connaissance.date_recomposee)) AS unnest
          ORDER BY unnest(array_agg(date_unite_connaissance.fk_type_date))))[1] AS date_standard
   FROM unites_de_connaissance.date_unite_connaissance
  GROUP BY date_unite_connaissance.fk_unite_connaissance;


--
-- TOC entry 210 (class 1259 OID 146323)
-- Name: v_roles_infos; Type: VIEW; Schema: vues_affichage; Owner: -
--

CREATE VIEW v_roles_infos AS
 SELECT t0.pk_objet, 
    t0.nom AS nom_objet, 
    t0.date_debut, 
    t0.type_objet, 
    t4.nom AS type_role, 
    t1.libelle_selon_source, 
    t5.date_standard, 
    t3.nom AS type_uc
   FROM v_proprietes_standard_objet t0, 
    unites_de_connaissance.role t1, 
    unites_de_connaissance.unite_connaissance t2, 
    types_uc.type_unite_connaissance t3, 
    types_uc.type_role t4, 
    v_date_standard_uc t5
  WHERE (((((t1.fk_objet_associe = t0.pk_objet) AND (t2.pk_unite_connaissance = t1.fk_unite_connaissance)) AND (t3.pk_type_unite_connaissance = t2.fk_type_unite_connaissance)) AND (t4.pk_type_role = t1.fk_type_role)) AND (t5.fk_unite_connaissance = t2.pk_unite_connaissance));


--
-- TOC entry 211 (class 1259 OID 146332)
-- Name: v_roles_infos_test; Type: VIEW; Schema: vues_affichage; Owner: -
--

CREATE VIEW v_roles_infos_test AS
 SELECT t0.pk_objet, 
    t0.nom AS nom_objet, 
    t0.date_debut, 
    t0.type_objet, 
    t4.nom AS type_role, 
    t1.pk_role, 
    t1.libelle_selon_source, 
    t2.pk_unite_connaissance, 
    t2.cle_importation, 
    t5.date_standard, 
    t3.nom AS type_uc
   FROM v_proprietes_standard_objet t0, 
    unites_de_connaissance.role t1, 
    unites_de_connaissance.unite_connaissance t2, 
    types_uc.type_unite_connaissance t3, 
    types_uc.type_role t4, 
    v_date_standard_uc t5
  WHERE (((((t1.fk_objet_associe = t0.pk_objet) AND (t2.pk_unite_connaissance = t1.fk_unite_connaissance)) AND (t3.pk_type_unite_connaissance = t2.fk_type_unite_connaissance)) AND (t4.pk_type_role = t1.fk_type_role)) AND (t5.fk_unite_connaissance = t2.pk_unite_connaissance));


SET search_path = vues_analyse, pg_catalog;

--
-- TOC entry 212 (class 1259 OID 146510)
-- Name: t_enseignements; Type: TABLE; Schema: vues_analyse; Owner: -; Tablespace: 
--

CREATE TABLE t_enseignements (
    id_ligne integer,
    pk_unite_connaissance integer,
    date_standard character varying,
    cle_acteur integer,
    cle_acteur_bhp character varying(200),
    nom text,
    matiere text,
    cle_matiere integer,
    institution text,
    cle_institution integer,
    cle_instituttion_bhp character varying(200)
);


--
-- TOC entry 213 (class 1259 OID 146518)
-- Name: t_enseignements_enrichie_20141120; Type: TABLE; Schema: vues_analyse; Owner: -; Tablespace: 
--

CREATE TABLE t_enseignements_enrichie_20141120 (
    id_ligne_new integer NOT NULL,
    id_ligne integer,
    cle_acteur integer,
    cle_acteur_bhp character varying(200),
    nom text,
    cle_institution integer,
    cle_instituttion_bhp character varying(200),
    cle_matiere integer,
    date_standard character varying,
    institution text,
    cle_lieu_enseignement character varying(16),
    lieu_enseignement character varying(1000),
    longitude numeric(9,6),
    latitude numeric(9,6),
    matiere text,
    pk_unite_connaissance integer,
    cle_institution_appartenance character varying(16),
    institution_appartenance character varying
);


--
-- TOC entry 215 (class 1259 OID 146532)
-- Name: v_enseignements; Type: VIEW; Schema: vues_analyse; Owner: -
--

CREATE VIEW v_enseignements AS
 SELECT (row_number() OVER (ORDER BY t3.date_standard))::integer AS id_ligne, 
    t1.pk_unite_connaissance, 
    t3.date_standard, 
    t2.fk_objet_associe AS cle_acteur, 
    t2.cle_importation_objet_associe AS cle_acteur_bhp, 
    t4.nom, 
    t6.nom AS matiere, 
    t6.pk_objet AS cle_matiere, 
    t8.nom AS institution, 
    t8.pk_objet AS cle_institution, 
    t7.cle_importation_objet_associe AS cle_instituttion_bhp
   FROM (((((((unites_de_connaissance.unite_connaissance t1
   LEFT JOIN vues_affichage.v_date_standard_uc t3 ON ((t3.fk_unite_connaissance = t1.pk_unite_connaissance)))
   LEFT JOIN unites_de_connaissance.role t2 ON (((t2.fk_unite_connaissance = t1.pk_unite_connaissance) AND (t2.fk_type_role = 24))))
   LEFT JOIN vues_affichage.v_proprietes_standard_objet t4 ON ((t4.pk_objet = t2.fk_objet_associe)))
   LEFT JOIN unites_de_connaissance.role t5 ON (((t5.fk_unite_connaissance = t1.pk_unite_connaissance) AND (t5.fk_type_role = 37))))
   LEFT JOIN vues_affichage.v_proprietes_standard_objet t6 ON ((t6.pk_objet = t5.fk_objet_associe)))
   LEFT JOIN unites_de_connaissance.role t7 ON (((t7.fk_unite_connaissance = t1.pk_unite_connaissance) AND (t7.fk_type_role = 102))))
   LEFT JOIN vues_affichage.v_proprietes_standard_objet t8 ON ((t8.pk_objet = t7.fk_objet_associe)))
  WHERE (t1.fk_type_unite_connaissance = 28)
  ORDER BY t3.date_standard;


--
-- TOC entry 214 (class 1259 OID 146528)
-- Name: v_enseignements_enrichie; Type: VIEW; Schema: vues_analyse; Owner: -
--

CREATE VIEW v_enseignements_enrichie AS
 SELECT DISTINCT t_enseignements_enrichie_20141120.cle_acteur, 
    t_enseignements_enrichie_20141120.nom, 
    t_enseignements_enrichie_20141120.date_standard, 
    t_enseignements_enrichie_20141120.institution, 
    t_enseignements_enrichie_20141120.longitude, 
    t_enseignements_enrichie_20141120.latitude, 
    t_enseignements_enrichie_20141120.matiere, 
    t_enseignements_enrichie_20141120.institution_appartenance, 
    t_enseignements_enrichie_20141120.lieu_enseignement
   FROM t_enseignements_enrichie_20141120;


--
-- TOC entry 216 (class 1259 OID 146537)
-- Name: v_naissance_acteurs; Type: VIEW; Schema: vues_analyse; Owner: -
--

CREATE VIEW v_naissance_acteurs AS
 SELECT t3.date_standard, 
    t2.fk_objet_associe, 
    t4.nom, 
    t6.nom AS lieu, 
    t7.longitude, 
    t7.latitude
   FROM ((((((unites_de_connaissance.unite_connaissance t1
   JOIN vues_affichage.v_date_standard_uc t3 ON ((t3.fk_unite_connaissance = t1.pk_unite_connaissance)))
   LEFT JOIN unites_de_connaissance.role t2 ON (((t2.fk_unite_connaissance = t1.pk_unite_connaissance) AND (t2.fk_type_role = 122))))
   LEFT JOIN vues_affichage.v_proprietes_standard_objet t4 ON ((t4.pk_objet = t2.fk_objet_associe)))
   LEFT JOIN unites_de_connaissance.role t5 ON (((t5.fk_unite_connaissance = t1.pk_unite_connaissance) AND (t5.fk_type_role = 165))))
   LEFT JOIN vues_affichage.v_proprietes_standard_objet t6 ON ((t6.pk_objet = t5.fk_objet_associe)))
   LEFT JOIN objets.objet t7 ON ((t7.pk_objet = t5.fk_objet_associe)))
  WHERE (t1.fk_type_unite_connaissance = 42)
  ORDER BY t3.date_standard;


--
-- TOC entry 189 (class 1259 OID 145256)
-- Name: v_xml_balises_avec_ana; Type: VIEW; Schema: vues_analyse; Owner: -
--

CREATE VIEW v_xml_balises_avec_ana AS
 WITH ta1 AS (
         SELECT t1_1.pk_objet, 
            unnest(xpath('//tei:*[@ana]'::text, t1_1.texte_tei, ARRAY[ARRAY['tei'::text, 'http://www.tei-c.org/ns/1.0'::text]])) AS texte_xml, 
            (unnest(xpath('//tei:*[@ana]/@ana'::text, t1_1.texte_tei, ARRAY[ARRAY['tei'::text, 'http://www.tei-c.org/ns/1.0'::text]])))::text AS type_texte
           FROM objets.objet t1_1
        )
 SELECT ('ObPe'::text || t1.pk_objet) AS cle_texte, 
    t3.nom_cible AS objet_concerne, 
    (unnest(xpath('name(/*)'::text, t1.texte_xml)))::text AS nom_balise, 
    t2.nom AS typologie, 
        CASE
            WHEN "xmlexists"('/*/date'::text, t1.texte_xml) THEN (unnest(xpath('/*/date/@when|/*/date/@from'::text, t1.texte_xml)))::text
            ELSE ''::text
        END AS date_debut, 
    btrim(regexp_replace(regexp_replace(regexp_replace(regexp_replace((unnest(xpath('/'::text, t1.texte_xml)))::text, '(.*?)<(\w+)\s+.*?>(.*)'::text, '\1<\2>\3'::text, 'g'::text), '(\n){0,5}(<\w*>)'::text, ''::text, 'g'::text), '</\w*>'::text, ''::text, 'g'::text), '(\t)'::text, ''::text, 'g'::text)) AS texte_sans_balises
   FROM ((ta1 t1
   LEFT JOIN vues_affichage.v_proprietes_standard_objet t2 ON ((t2.cle_objet = t1.type_texte)))
   LEFT JOIN vues_affichage.v_associations_objets t3 ON ((t3.pk_source = t1.pk_objet)))
  WHERE (t3.cle_type_association = 14)
  ORDER BY t1.pk_objet;


SET search_path = objets, pg_catalog;

--
-- TOC entry 2248 (class 2604 OID 112104)
-- Name: pk_associer_objets; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY associer_objets ALTER COLUMN pk_associer_objets SET DEFAULT nextval('associer_objets_pk_associer_objets_seq'::regclass);


--
-- TOC entry 2244 (class 2604 OID 95853)
-- Name: pk_nom_objet; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY nom_objet ALTER COLUMN pk_nom_objet SET DEFAULT nextval('nom_objet_cle_nom_objet_seq'::regclass);


--
-- TOC entry 2245 (class 2604 OID 95854)
-- Name: pk_objet; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY objet ALTER COLUMN pk_objet SET DEFAULT nextval('objet_cle_objet_seq'::regclass);


SET search_path = parametres, pg_catalog;

--
-- TOC entry 2246 (class 2604 OID 112086)
-- Name: pk_associer_parametres_systeme; Type: DEFAULT; Schema: parametres; Owner: -
--

ALTER TABLE ONLY associer_parametres_systeme ALTER COLUMN pk_associer_parametres_systeme SET DEFAULT nextval('associer_parametres_systeme_pk_associer_parametres_systeme_seq'::regclass);


--
-- TOC entry 2247 (class 2604 OID 112115)
-- Name: pk_parametre_systeme; Type: DEFAULT; Schema: parametres; Owner: -
--

ALTER TABLE ONLY parametre_systeme ALTER COLUMN pk_parametre_systeme SET DEFAULT nextval('parametres_systeme_pk_parametre_systeme_seq'::regclass);


SET search_path = types_uc, pg_catalog;

--
-- TOC entry 2249 (class 2604 OID 145578)
-- Name: pk_associer_type_uc_type_role; Type: DEFAULT; Schema: types_uc; Owner: -
--

ALTER TABLE ONLY associer_type_uc_type_role ALTER COLUMN pk_associer_type_uc_type_role SET DEFAULT nextval('associer_type_uc_type_role_pk_associer_type_uc_type_role_seq'::regclass);


--
-- TOC entry 2250 (class 2604 OID 145579)
-- Name: pk_type_role; Type: DEFAULT; Schema: types_uc; Owner: -
--

ALTER TABLE ONLY type_role ALTER COLUMN pk_type_role SET DEFAULT nextval('type_role_pk_type_role_seq'::regclass);


--
-- TOC entry 2252 (class 2604 OID 145580)
-- Name: pk_type_unite_connaissance; Type: DEFAULT; Schema: types_uc; Owner: -
--

ALTER TABLE ONLY type_unite_connaissance ALTER COLUMN pk_type_unite_connaissance SET DEFAULT nextval('type_unite_connaissance_pk_type_unite_connaissance_seq'::regclass);


SET search_path = unites_de_connaissance, pg_catalog;

--
-- TOC entry 2253 (class 2604 OID 146257)
-- Name: pk_associer_unite_connaissance_objet; Type: DEFAULT; Schema: unites_de_connaissance; Owner: -
--

ALTER TABLE ONLY associer_unite_connaissance_objet ALTER COLUMN pk_associer_unite_connaissance_objet SET DEFAULT nextval('associer_unite_connaissance_o_pk_associer_unite_connaissanc_seq'::regclass);


--
-- TOC entry 2254 (class 2604 OID 146258)
-- Name: pk_date_unite_connaissance; Type: DEFAULT; Schema: unites_de_connaissance; Owner: -
--

ALTER TABLE ONLY date_unite_connaissance ALTER COLUMN pk_date_unite_connaissance SET DEFAULT nextval('date_unite_connaissance_pk_date_unite_connaissance_seq'::regclass);


--
-- TOC entry 2255 (class 2604 OID 146259)
-- Name: pk_propriete_texte; Type: DEFAULT; Schema: unites_de_connaissance; Owner: -
--

ALTER TABLE ONLY propriete_texte ALTER COLUMN pk_propriete_texte SET DEFAULT nextval('propriete_texte_pk_propriete_texte_seq'::regclass);


--
-- TOC entry 2256 (class 2604 OID 146260)
-- Name: pk_role; Type: DEFAULT; Schema: unites_de_connaissance; Owner: -
--

ALTER TABLE ONLY role ALTER COLUMN pk_role SET DEFAULT nextval('role_pk_role_seq'::regclass);


--
-- TOC entry 2257 (class 2604 OID 146261)
-- Name: pk_sourcer; Type: DEFAULT; Schema: unites_de_connaissance; Owner: -
--

ALTER TABLE ONLY sourcer ALTER COLUMN pk_sourcer SET DEFAULT nextval('sourcer_pk_sourcer_seq'::regclass);


--
-- TOC entry 2258 (class 2604 OID 146262)
-- Name: pk_unite_connaissance; Type: DEFAULT; Schema: unites_de_connaissance; Owner: -
--

ALTER TABLE ONLY unite_connaissance ALTER COLUMN pk_unite_connaissance SET DEFAULT nextval('unite_connaissance_pk_unite_connaissance_seq'::regclass);


SET search_path = objets, pg_catalog;

--
-- TOC entry 2456 (class 0 OID 112101)
-- Dependencies: 185
-- Data for Name: associer_objets; Type: TABLE DATA; Schema: objets; Owner: -
--

INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (1, 5, 17, 8, NULL, NULL, NULL, NULL, '2014-10-01 17:24:28.332882+02', '2014-10-01 17:31:30.126504+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (2, 6, 17, 8, NULL, NULL, NULL, NULL, '2014-10-01 17:34:45.975283+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (6, 13, 17, 8, NULL, NULL, NULL, NULL, '2014-10-01 18:45:00.132484+02', '2014-10-01 18:45:06.246479+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (5, 18, 9, 14, NULL, 'http://www.larousse.fr/encyclopedie/litterature/Peiresc/175946', NULL, NULL, '2014-10-01 18:41:42.716243+02', '2014-10-01 22:44:18.786132+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (7, 19, 18, 15, NULL, 'http://www.larousse.fr/encyclopedie', NULL, NULL, '2014-10-01 22:29:27.83624+02', '2014-10-01 22:53:52.85526+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (9, 26, 9, 14, NULL, NULL, NULL, NULL, '2014-10-03 00:38:09.937103+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (10, 24, 6, 14, NULL, NULL, NULL, NULL, '2014-10-03 00:38:59.368386+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (12, 30, 8, 14, NULL, NULL, 'Ouvrage fondamental que je dois lire pour mon mémoire de master', NULL, '2014-10-03 09:31:41.936464+02', '2014-10-03 09:33:20.672138+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (13, 31, 8, 14, NULL, NULL, NULL, NULL, '2014-10-03 10:27:23.44267+02', '2014-10-03 10:27:26.947125+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (14, 11, 17, 8, NULL, NULL, NULL, NULL, '2014-10-06 16:03:17.267635+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (15, 3, 34, 8, NULL, NULL, NULL, NULL, '2014-10-06 16:23:41.033349+02', '2014-10-06 16:25:41.083099+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (16, 21, 34, 8, NULL, NULL, NULL, NULL, '2014-10-06 16:27:17.277625+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (17, 33, 34, 8, NULL, NULL, NULL, NULL, '2014-10-06 16:27:35.286256+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (11, 28, 6, 14, 'pp.78-99', NULL, NULL, NULL, '2014-10-03 09:12:45.180796+02', '2014-10-06 16:35:30.289287+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (18, 36, 37, 8, NULL, NULL, NULL, NULL, '2014-10-08 18:52:53.234141+02', '2014-10-08 18:55:22.821323+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (19, 38, 37, 8, NULL, NULL, NULL, NULL, '2014-10-08 18:57:27.385722+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (20, NULL, 40, 15, NULL, NULL, NULL, NULL, '2014-10-08 23:21:31.065467+02', '2014-10-08 23:21:54.446986+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (21, 40, 13, 14, NULL, NULL, NULL, NULL, '2014-10-08 23:22:04.220005+02', '2014-10-08 23:22:06.819011+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (22, 19, 41, 14, NULL, 'http://en.wikipedia.org/wiki/Knutstorp_Castle', NULL, NULL, '2014-10-08 23:53:25.039002+02', '2014-10-08 23:53:48.332702+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (23, 1, NULL, 8, NULL, NULL, NULL, NULL, '2014-10-11 09:33:46.631272+02', '2014-10-12 07:56:50.304434+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (24, 42, 37, 8, NULL, NULL, NULL, NULL, '2014-10-13 11:20:37.140047+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (25, 43, 44, 14, NULL, NULL, NULL, NULL, '2014-10-13 15:05:11.736957+02', '2014-10-13 15:06:17.878751+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (26, 29, 45, 8, NULL, NULL, NULL, NULL, '2014-10-13 15:16:13.654128+02', '2014-10-13 15:16:25.649171+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (27, 43, NULL, 14, NULL, NULL, NULL, NULL, '2014-10-13 18:10:56.304058+02', NULL);
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (28, 46, 43, 15, NULL, NULL, NULL, NULL, '2014-10-13 18:11:19.42667+02', '2014-10-13 18:11:46.281011+02');
INSERT INTO associer_objets (pk_associer_objets, fk_objet_source, fk_objet_cible, fk_type_association_objets, reference_precise, url, descriptif, notes, date_creation, date_modification) VALUES (29, 57, NULL, 15, NULL, NULL, NULL, NULL, '2014-11-03 15:21:05.651178+01', NULL);


--
-- TOC entry 2501 (class 0 OID 0)
-- Dependencies: 184
-- Name: associer_objets_pk_associer_objets_seq; Type: SEQUENCE SET; Schema: objets; Owner: -
--

SELECT pg_catalog.setval('associer_objets_pk_associer_objets_seq', 29, true);


--
-- TOC entry 2447 (class 0 OID 95832)
-- Dependencies: 176
-- Data for Name: nom_objet; Type: TABLE DATA; Schema: objets; Owner: -
--

INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (52, 'Knudstrup', 'danois', NULL, 41, true, '2014-10-08 23:36:50.062865+02', '2014-10-08 23:37:17.876007+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (50, 'Knutstorp Manor', 'anglais', NULL, 41, false, '2014-10-08 23:33:22.411218+02', '2014-10-08 23:37:18.994208+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (64, 'Doctrine professée', NULL, NULL, 51, true, '2014-10-31 13:41:09.673437+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (65, 'Opinions', NULL, NULL, 52, true, '2014-10-31 22:43:13.292289+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (13, 'Mathématiques', NULL, NULL, 3, true, '2014-09-22 10:55:42.046401+02', NULL, 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (71, 'Alsted, Johann Heinrich', NULL, NULL, 86, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (66, 'Encyclopédie générale Larousse, 3 t., Paris : Libraire Larousse, 1967-1975', NULL, NULL, 53, true, '2014-11-01 08:44:13.519732+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (67, 'Champtercier', NULL, NULL, 54, true, '2014-11-03 08:10:19.512822+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (68, 'Enseignement', NULL, NULL, 55, true, '2014-11-03 11:07:10.386959+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (11, 'Inquisition romaine', NULL, NULL, 4, true, '2014-09-22 10:54:57.463491+02', NULL, 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (12, 'Saint-Office', NULL, NULL, 4, false, '2014-09-22 10:55:15.342779+02', NULL, 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (72, 'Inquisiteur', NULL, NULL, 87, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (16, 'Maestlin, Michael', NULL, NULL, 7, true, '2014-10-01 01:11:51.526866+02', NULL, 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (73, 'Brescia', NULL, NULL, 88, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (18, 'Fabri de Peiresc, Nicolas Claude', NULL, NULL, 9, true, '2014-10-01 09:32:02.393621+02', NULL, 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (19, 'Rodolphe II', 'français', NULL, 10, true, '2014-10-01 10:10:07.338795+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (20, 'Copernic, NIcolas', NULL, NULL, 11, true, '2014-10-01 10:13:39.735352+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (21, 'Charles Quint', 'français', NULL, 12, true, '2014-10-01 10:28:53.007398+02', NULL, 5, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (74, 'Logique', NULL, NULL, 89, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (8, 'Barberini, Maffeo', 'italien', NULL, 1, false, '2014-09-19 22:15:55.046286+02', '2014-10-09 23:07:09.922706+02', 3, '1568', '1623-08-05');
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (15, 'Kepler, Johannes', 'allemand', NULL, 6, true, '2014-10-01 01:08:35.83893+02', NULL, 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (75, 'Sforza Pallavicino, Pietro', NULL, NULL, 90, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (23, 'Population de savants', NULL, NULL, 17, true, '2014-10-01 17:22:58.918112+02', '2014-10-01 17:23:44.079059+02', 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (76, 'Azpilcueta, Martín de', NULL, NULL, 91, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (25, 'Site web', NULL, NULL, 19, true, '2014-10-01 17:45:30.78415+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (24, 'Encyclopédie Larousse', NULL, NULL, 18, true, '2014-10-01 17:44:52.371504+02', '2014-10-01 18:39:32.737874+02', 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (22, 'Brahe, Tycho', 'danois', NULL, 13, true, '2014-10-01 10:41:34.158809+02', '2014-10-01 23:47:25.925818+02', 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (77, 'Royaume-Uni de Grande-Bretagne', NULL, NULL, 92, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (27, 'Astronomie', NULL, NULL, 21, true, '2014-10-02 19:15:55.313405+02', '2014-10-02 19:17:02.962245+02', 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (28, 'Weil der Stadt', NULL, NULL, 22, true, '2014-10-02 19:22:44.190267+02', NULL, 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (29, 'Regensburg', 'allemand', NULL, 23, true, '2014-10-02 19:42:15.988656+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (78, 'Valencia', NULL, NULL, 93, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (30, 'Ratisbonne', 'français', NULL, 23, false, '2014-10-02 19:43:16.066025+02', '2014-10-02 19:46:27.458259+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (31, 'Johannes Kepler – notice Larousse', NULL, NULL, 24, true, '2014-10-02 20:20:39.403336+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (32, 'Newton, Isaac', 'anglais', NULL, 25, true, '2014-10-02 22:48:13.618384+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (79, 'Nifo, Agostino', NULL, NULL, 94, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (34, 'Aristote', NULL, NULL, 27, true, '2014-10-03 00:21:17.569237+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (33, 'Peiresc – notice Larousse', NULL, NULL, 26, true, '2014-10-03 00:16:13.989861+02', '2014-10-03 08:42:33.980493+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (36, 'Simon, Gérard, Kepler: astronome, astrologue (Paris, Gallimard, 1979)', NULL, NULL, 29, true, '2014-10-03 09:25:23.468639+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (80, 'Bary, René', NULL, NULL, 95, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (81, 'Métaphysique', NULL, NULL, 96, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (82, 'Amsterdam ', NULL, NULL, 97, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (17, 'Gassend, Pierre', 'français', NULL, 8, true, '2014-10-01 07:20:07.82895+02', '2014-10-03 09:30:57.976154+02', 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (38, 'Gassendi', 'français', NULL, 8, false, '2014-10-03 09:30:55.528311+02', '2014-10-03 09:31:00.752651+02', 13, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (83, 'Douai', NULL, NULL, 98, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (84, 'Barbay, Pierre', NULL, NULL, 99, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (39, 'Gassendi – Notice Larousse', NULL, NULL, 31, true, '2014-10-03 10:23:58.005062+02', '2014-10-03 10:27:09.638341+02', 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (37, 'Gassendi et l''Europe (1592-1792) : actes du colloque international de Paris "Gassendi et sa postérité (1592-1792)", ed. Murr, Sylvia (Paris , J. Vrin, 1997) ', 'français', NULL, 30, true, '2014-10-03 09:29:52.508511+02', '2014-10-03 10:30:02.039306+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (40, 'Descriptif d''un objet', NULL, NULL, 32, true, '2014-10-05 17:24:17.053407+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (69, 'Astronome', NULL, NULL, 56, true, '2014-11-03 11:14:40.729113+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (70, 'Transcription de la Vie de Boniface', NULL, NULL, 57, true, '2014-11-03 15:19:02.27555+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (85, 'Belgique, Royaume de ', NULL, NULL, 100, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (9, 'Urbain VIII', 'français', NULL, 1, true, '2014-09-19 22:16:24.269177+02', '2014-10-09 23:07:12.658384+02', 5, '1623-08-06', '1644');
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (86, 'Sevilla', NULL, NULL, 101, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (87, 'Celaya, Juan de', NULL, NULL, 102, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (42, 'Médecine', 'français', NULL, 33, true, '2014-10-06 16:15:19.021943+02', '2014-10-06 16:15:42.261297+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (88, 'Bois, François Du', NULL, NULL, 103, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (43, 'Discipline enseignée à l''Université', 'français', NULL, 34, true, '2014-10-06 16:20:47.078147+02', '2014-10-06 16:20:53.205843+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (44, 'Graz', NULL, NULL, 35, true, '2014-10-07 15:40:00.611719+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (45, 'Naissance', NULL, NULL, 36, true, '2014-10-08 18:49:59.189079+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (46, 'Valeurs @ana', NULL, NULL, 37, true, '2014-10-08 18:54:59.536276+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (47, 'Décès', NULL, NULL, 38, true, '2014-10-08 18:56:33.113638+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (48, 'Belgentier', NULL, NULL, 39, true, '2014-10-08 22:47:31.519657+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (49, 'Tycho Brahe – Notice Larousse', NULL, NULL, 40, true, '2014-10-08 23:13:31.804493+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (89, 'Théologie morale', NULL, NULL, 104, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (51, 'Knutstorps slott', 'suédois', NULL, 41, false, '2014-10-08 23:36:30.876032+02', '2014-10-08 23:36:41.828987+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (90, 'Scaliger, Julius Caesar', NULL, NULL, 105, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (10, 'Merisi, Michelangelo, da Caravaggio', 'italien', NULL, 2, true, '2014-09-19 22:26:23.932658+02', '2014-10-10 23:21:05.406245+02', 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (14, 'Galilei, Galileo', 'italien', NULL, 5, true, '2014-09-30 07:22:43.025217+02', '2014-10-11 00:19:42.438119+02', 3, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (91, 'Physique', NULL, NULL, 106, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (35, 'Depondt, Philippe / Véricourt, Guillemette de, Kepler. L’orbe tourmenté d’un astronome. Biographie (Rodez, Editions du Rouergue, 2005) ', NULL, NULL, 28, true, '2014-10-03 09:06:16.294152+02', '2014-10-12 08:09:20.790636+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (53, 'Exercice de fonction', NULL, NULL, 42, true, '2014-10-13 11:18:24.47867+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (54, 'Lyon, AM, 78WP011', NULL, NULL, 43, true, '2014-10-13 14:56:03.362676+02', '2014-10-13 14:56:30.531915+02', 25, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (92, 'Universidad de Alcalá', NULL, NULL, 107, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (55, 'Exposition universelle de Paris de 1889', 'français', NULL, 44, true, '2014-10-13 14:58:10.053419+02', '2014-10-13 14:58:36.819732+02', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (56, 'Sources', NULL, NULL, 45, true, '2014-10-13 15:14:37.214361+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (93, 'Université de Padoue', NULL, NULL, 108, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (57, 'www.archives_municipales_NNN.fr', NULL, NULL, 46, true, '2014-10-13 18:08:17.357242+02', NULL, 25, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (58, 'Lyon', 'français', NULL, 47, true, '2014-10-17 15:14:56.281726+02', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (26, 'Enfance', NULL, NULL, 20, true, '2014-10-02 19:13:12.170589+02', '2014-10-31 12:07:16.045595+01', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (94, 'Dechamps, Etienne-Agard', NULL, NULL, 109, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (59, 'Formation', 'français', NULL, 48, true, '2014-10-31 12:17:08.739655+01', '2014-10-31 12:17:14.849675+01', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (60, 'Carrière', NULL, NULL, 49, true, '2014-10-31 12:18:46.696253+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (61, 'Profession', NULL, 'Utilisé pour la recherche, j''ai préféré le temre de carrière au sens de parcours', 49, false, '2014-10-31 12:19:35.344819+01', '2014-10-31 12:20:03.004296+01', NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (62, 'Parcours', NULL, NULL, 49, false, '2014-10-31 12:20:11.748689+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (63, 'Origines familiales', NULL, NULL, 50, true, '2014-10-31 13:36:30.016733+01', NULL, 7, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (95, 'Maître général de l''Ordre dominicain', NULL, NULL, 110, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (96, 'Universität Salzburg', NULL, NULL, 111, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (97, 'Secrétaire de la Congrégation de l''Index', NULL, NULL, 112, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (98, 'Bassée, Eloi de la', NULL, NULL, 113, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (99, 'Clauberg, Johannes', NULL, NULL, 114, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (100, 'Palermo', NULL, NULL, 115, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (101, 'Álvarez, Diego', NULL, NULL, 116, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (102, 'Colegio de San Pablo (Compañía de Jesús) (Granada)', NULL, NULL, 117, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (103, 'Iavelli, Crisostomo', NULL, NULL, 118, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (104, 'Rhétorique', NULL, NULL, 119, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (105, 'Saint-Paul, Eustache de', NULL, NULL, 120, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (106, 'Valladolid', NULL, NULL, 121, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (107, 'Herborn', NULL, NULL, 122, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (108, 'Chasteignier, Henri-Louis - de La Rochepozay', NULL, NULL, 123, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (109, 'Trombetta, Antonio', NULL, NULL, 124, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (110, 'Philosophie naturelle', NULL, NULL, 125, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (111, 'Fasolo, Girolamo', NULL, NULL, 126, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (112, 'Firenze', NULL, NULL, 127, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (113, 'Frankfurt am Main', NULL, NULL, 128, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (114, 'Duhan, Laurent', NULL, NULL, 129, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (115, 'Mexique', NULL, NULL, 130, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (116, 'Cardinal', NULL, NULL, 131, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (117, 'Fabri, Filippo', NULL, NULL, 132, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (118, 'Boyvin, Jean Gabriel', NULL, NULL, 133, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (119, 'Riccioli, Giovanni Battista', NULL, NULL, 134, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (120, 'Paris, Yves de', NULL, NULL, 135, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (121, 'Augsburg', NULL, NULL, 136, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (122, 'Milano', NULL, NULL, 137, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (123, 'Leiden', NULL, NULL, 138, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (124, 'Zaragoza y Vilanova, José', NULL, NULL, 139, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (125, 'Albertini, Francesco', NULL, NULL, 140, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (126, 'Adam, Jean', NULL, NULL, 141, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (127, 'Ecriture Sainte', NULL, NULL, 142, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (128, 'Bauny, Etienne', NULL, NULL, 143, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (129, 'La Flèche, Collège des Jésuites', NULL, NULL, 144, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (130, 'Portugal', NULL, NULL, 145, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (131, 'Bonne Espérance, François de la', NULL, NULL, 146, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (132, 'Thomisme', NULL, NULL, 147, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (133, 'Rouen', NULL, NULL, 148, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (134, 'Castro, Alfonso de', NULL, NULL, 149, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (135, 'Coronel, Antonio', NULL, NULL, 150, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (136, 'Alonso, Francisco', NULL, NULL, 151, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (137, 'Universität Wittenberg', NULL, NULL, 152, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (138, 'Bruxelles', NULL, NULL, 153, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (139, 'Báñez, Domingo', NULL, NULL, 154, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (140, 'Annat, François', NULL, NULL, 155, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (141, 'Frkic, Mate', NULL, NULL, 156, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (142, 'Compton Carleton, Thomas', NULL, NULL, 157, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (143, 'Araújo, Francisco de', NULL, NULL, 158, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (144, 'Ermites de Saint Augustin', NULL, NULL, 159, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (145, 'Zaragoza', NULL, NULL, 160, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (146, 'Collegio Massimo della Compagnia di Gesù (Napoli)', NULL, NULL, 161, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (147, 'Collège de Sorbonne', NULL, NULL, 162, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (148, 'Coninck, Gilles de', NULL, NULL, 163, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (149, 'Contenson, Vincent', NULL, NULL, 164, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (150, 'Genève', NULL, NULL, 165, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (151, 'Bellarmino, Roberto', NULL, NULL, 166, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (152, 'Ingolstadt', NULL, NULL, 167, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (153, 'Aguilar, José de', NULL, NULL, 168, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (154, 'Zimara, Marco Antonio', NULL, NULL, 169, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (155, 'Vázquez, Gabriel', NULL, NULL, 170, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (156, 'Lisboa', NULL, NULL, 171, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (157, 'Hodierna, Giovanni Battista', NULL, NULL, 172, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (158, 'Jesuitenkolleg (Ingolstadt)', NULL, NULL, 173, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (159, 'Baron, Vincent', NULL, NULL, 174, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (160, 'Becanus, Martin', NULL, NULL, 175, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (161, 'Assesseur du Saint-Office', NULL, NULL, 176, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (162, 'Cienfuegos, Álvaro', NULL, NULL, 177, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (163, 'Pomponazzi, Pietro', NULL, NULL, 178, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (164, 'Collège de France', NULL, NULL, 179, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (165, 'Bellarini, Giovanni', NULL, NULL, 180, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (166, 'Grecque', NULL, NULL, 181, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (167, 'Autriche', NULL, NULL, 182, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (168, 'Clément, Claude', NULL, NULL, 183, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (169, 'Busiatti, Vincenzo - da Montesanto', NULL, NULL, 184, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (170, 'Barbieri da Castelvetro, Bartolomeo', NULL, NULL, 185, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (171, 'Seghizzi, Michelangelo', NULL, NULL, 186, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (172, 'Universidad de Salamanca', NULL, NULL, 187, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (173, 'Toledo', NULL, NULL, 188, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (174, 'Franciscains conventuels', NULL, NULL, 189, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (175, 'Liege', NULL, NULL, 190, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (176, 'Théologie dogmatique', NULL, NULL, 191, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (177, 'Tylkowski, Wojciech', NULL, NULL, 192, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (178, 'Compagnie de Jésus', NULL, NULL, 58, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (179, 'Paris', NULL, NULL, 59, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (180, 'Théologie', NULL, NULL, 60, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (181, 'Venezia', NULL, NULL, 61, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (182, 'Philosophie', NULL, NULL, 62, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (183, 'Espagne ', NULL, NULL, 63, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (184, 'Roma', NULL, NULL, 64, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (185, 'France', NULL, NULL, 65, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (186, 'Collège romain', NULL, NULL, 66, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (187, 'Antwerpen', NULL, NULL, 67, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (188, 'Allemagne', NULL, NULL, 68, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (189, 'Köln', NULL, NULL, 69, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (190, 'MADRID', NULL, NULL, 70, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (191, 'Italie (région géographique) ', NULL, NULL, 71, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (192, 'Padova', NULL, NULL, 72, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (193, 'Alcala'' De Henares', NULL, NULL, 73, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (194, 'Evêque (catholique)', NULL, NULL, 74, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (195, 'Maître du Sacré Palais', NULL, NULL, 75, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (196, 'Ordre dominicain', NULL, NULL, 76, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (197, 'Fabri, Honoré', NULL, NULL, 77, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (198, 'Brescia, Fortunato da', NULL, NULL, 78, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (199, 'Commissaire du Saint-Office (Italie)', NULL, NULL, 79, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (200, 'Conimbricenses', NULL, NULL, 80, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (201, 'Mastri, Bartolomeo', NULL, NULL, 81, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (202, 'Daniel, Gabriel', NULL, NULL, 82, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (203, 'Napoli', NULL, NULL, 83, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (204, 'Bologna', NULL, NULL, 84, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (205, 'Salamanca', NULL, NULL, 85, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (206, 'Suárez, Francisco', NULL, NULL, 193, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (207, 'Gallamini, Agostino', NULL, NULL, 194, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (208, 'Universidad de Salamanca, Facultad de Teología', NULL, NULL, 195, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (209, 'Bourdin, Pierre', NULL, NULL, 196, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (210, 'Combach, Johannes', NULL, NULL, 197, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (211, 'Colegio Mayor de la Compañía de Jesús (Alcala)', NULL, NULL, 198, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (212, 'Fagnani, Prospero', NULL, NULL, 199, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (213, 'Burgos', NULL, NULL, 200, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (214, 'Ruiz de Montoya, Diego', NULL, NULL, 201, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (215, 'Ames, William', NULL, NULL, 202, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (216, 'Mezger, Franz', NULL, NULL, 203, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (217, 'Drago, Alberto', NULL, NULL, 204, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (218, 'Théologie scolastique', NULL, NULL, 205, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (219, 'Barcelona', NULL, NULL, 206, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (220, 'Cardillo de Villalpando, Gaspar', NULL, NULL, 207, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (221, 'Cochet, Jean-Baptiste', NULL, NULL, 208, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (222, 'Mauri, Silvestro', NULL, NULL, 209, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (223, 'Maculani, Vincenzo - da Fiorenzuola', NULL, NULL, 210, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (224, 'l''Assomption, Charles de', NULL, NULL, 211, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (225, 'Ulloa, Juan de', NULL, NULL, 212, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (226, 'Politi, Ambrogio Catarino', NULL, NULL, 213, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (227, 'Université de Coimbra', NULL, NULL, 214, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (228, 'Vives, Juan Luis', NULL, NULL, 215, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (229, 'Hébreu', NULL, NULL, 216, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (230, 'Burgersdijk, Franco', NULL, NULL, 217, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (231, 'Capizucchi, Raimondo', NULL, NULL, 218, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (232, 'Grammaire', NULL, NULL, 219, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (233, 'Cornaeus, Melchior', NULL, NULL, 220, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (234, 'Bail, Louis', NULL, NULL, 221, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (235, 'Toulouse', NULL, NULL, 222, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (236, 'Reiffenstuel, Anaklet', NULL, NULL, 223, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (237, 'Vanderveken, Frans', NULL, NULL, 224, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (238, 'Vázquez de Padilla, Miguel', NULL, NULL, 225, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (239, 'Caen', NULL, NULL, 226, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (240, 'Zabarella, Giacomo', NULL, NULL, 227, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (241, 'Franciscains observants', NULL, NULL, 228, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (242, 'Della Faille, Jean Charles', NULL, NULL, 229, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (243, 'Erndtlin, Joachim', NULL, NULL, 230, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (244, 'Adjoint du commissaire du Saint-Office (premier adjoint)', NULL, NULL, 231, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (245, 'Pamplona', NULL, NULL, 232, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (246, 'Genova', NULL, NULL, 233, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (247, 'Bancel, Louis', NULL, NULL, 234, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (248, 'Porzio, Simone', NULL, NULL, 235, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (249, 'Crab, Gilbert', NULL, NULL, 236, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (250, 'Campoverde, Juan de', NULL, NULL, 237, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (251, 'Dupleix, Scipion', NULL, NULL, 238, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (252, 'Mainz', NULL, NULL, 239, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (253, 'London', NULL, NULL, 240, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (254, 'Mezger, Joseph', NULL, NULL, 241, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (255, 'Beccaria, Ippolito Maria', NULL, NULL, 242, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (256, 'Chaire de Prime', NULL, NULL, 243, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (257, 'Chaire de Vêpres', NULL, NULL, 244, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (258, 'Arriaga, Rodrigo de', NULL, NULL, 245, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (259, 'Università di Pisa', NULL, NULL, 246, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (260, 'Ordre cistercien', NULL, NULL, 247, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (261, 'Du Bosc, Jacques', NULL, NULL, 248, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (262, 'Capponi, Serafino', NULL, NULL, 249, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (263, 'Wurzburg', NULL, NULL, 250, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (264, 'Colegio Imperial de la Compañía de Jesús (Madrid)', NULL, NULL, 251, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (265, 'Rossi da Lugo, Alessandro', NULL, NULL, 252, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (266, 'Théologie scotiste', NULL, NULL, 253, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (267, 'David, Pierre', NULL, NULL, 254, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (268, 'Presentação, Gil da', NULL, NULL, 255, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (269, 'Cordoba', NULL, NULL, 256, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (270, 'Riccardi, Niccolò', NULL, NULL, 257, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (271, 'Scotisme', NULL, NULL, 258, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (272, 'Malafossa, Giacomino', NULL, NULL, 259, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (273, 'Leuven', NULL, NULL, 260, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (274, 'Albiz, Martín de', NULL, NULL, 261, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (275, 'Collège de la Compagnie de Jésus (Louvain)', NULL, NULL, 262, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (276, 'Professeur ordinaire de philosophie naturelle (Université de Padoue)', NULL, NULL, 263, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (277, 'Avignon', NULL, NULL, 264, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (278, 'Jesuitenkolleg & Universität (Dillingen)', NULL, NULL, 265, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (279, 'Ferrara', NULL, NULL, 266, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (280, 'Zwinger, Joseph', NULL, NULL, 267, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (281, 'Coccejus, Johannes', NULL, NULL, 268, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (282, 'Zuñiga, Diego de', NULL, NULL, 269, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (283, 'Dillingen (Saar)', NULL, NULL, 270, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (284, 'Curiel, Juan Alfonso', NULL, NULL, 271, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (285, 'Chanevelle, Jacques', NULL, NULL, 272, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (286, 'Benet, Cipriano', NULL, NULL, 273, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (287, 'Durand, Barthélémy', NULL, NULL, 274, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (288, 'Herrera, Pedro de', NULL, NULL, 275, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (289, 'Collegium Complutense', NULL, NULL, 276, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (290, 'Pérez Valiende, Antonio', NULL, NULL, 277, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (291, 'Colegio de Santiago (Compañía de Jesús) (Arequipa)', NULL, NULL, 278, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (292, 'Baronio, Bonaventura', NULL, NULL, 279, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (293, 'Vitelleschi, Muzio', NULL, NULL, 280, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (294, 'Colegio del Espiritu Santo (Compañía de Jesús) (Salamanca)', NULL, NULL, 281, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (295, 'Azor, Juan', NULL, NULL, 282, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (296, 'Bagot, Jean', NULL, NULL, 283, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (297, 'Nazario, Giovanni Paolo', NULL, NULL, 284, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (298, 'Ethique', NULL, NULL, 285, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (299, 'Vatier, Antoine', NULL, NULL, 286, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (300, 'Giattini, Giovannbattista', NULL, NULL, 287, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (301, 'Université de Bâle', NULL, NULL, 288, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (302, 'Chalmers, William', NULL, NULL, 289, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (303, 'Dicastillo, Juan de', NULL, NULL, 290, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (304, 'Consulteur de la Congrégation de l''Inquisition', NULL, NULL, 291, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (305, 'Duval, André', NULL, NULL, 292, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (306, 'Scaglia, Desiderio', NULL, NULL, 293, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (307, 'Siège inquisitorial de Milano', NULL, NULL, 294, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (308, 'Rheticus, Georg Joachim', NULL, NULL, 295, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (309, 'Zumel, Francisco', NULL, NULL, 296, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (310, 'Eberhard, Georg', NULL, NULL, 297, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (311, 'Universität Marburg', NULL, NULL, 298, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (312, 'Université de Louvain', NULL, NULL, 299, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (313, 'Bordeaux', NULL, NULL, 300, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (314, 'Laymann, Paul', NULL, NULL, 301, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (315, 'Dabillon, André', NULL, NULL, 302, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (316, 'Capiferro Maddaleni, Francesco', NULL, NULL, 303, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (317, 'Rotondo, Felix', NULL, NULL, 304, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (318, 'Universität Jena', NULL, NULL, 305, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (319, 'Zwinger, Theodor', NULL, NULL, 306, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (320, 'Lanci, Giovanni Battista', NULL, NULL, 307, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (321, 'Lima', NULL, NULL, 308, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (322, 'Cremonini, Cesare', NULL, NULL, 309, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (323, 'République tchèque', NULL, NULL, 310, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (324, 'Alarcón, Diego de', NULL, NULL, 311, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (325, 'Spina, Bartolomeo', NULL, NULL, 312, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (326, 'Siège inquisitorial de Genova', NULL, NULL, 313, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (327, 'Soto y Marne, Francisco', NULL, NULL, 314, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (328, 'Mariana, Juan de', NULL, NULL, 315, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (329, 'Xavierre, Hieronymus', NULL, NULL, 316, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (330, 'Clavius, Christopher', NULL, NULL, 317, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (331, 'Trani', NULL, NULL, 318, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (332, 'Montesinos, Luis de', NULL, NULL, 319, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (333, 'Toledo, Francisco de', NULL, NULL, 320, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (334, 'Zanchius, Hieronymus', NULL, NULL, 321, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (335, 'Egel, Ambrosius', NULL, NULL, 322, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (336, 'Humanités', NULL, NULL, 323, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (337, 'Collège de Clermont (Paris)', NULL, NULL, 324, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (338, 'Università La Sapienza (Roma)', NULL, NULL, 325, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (339, 'Corbusio, Ludovico - da Montone', NULL, NULL, 326, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (340, 'Universität Tübingen', NULL, NULL, 327, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (341, 'Escobar y Mendoza, Antonio', NULL, NULL, 328, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (342, 'Blázquez, Juan', NULL, NULL, 329, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (343, 'Sghemma, Gaspare', NULL, NULL, 330, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (344, 'Leipzig', NULL, NULL, 331, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (345, 'Jesuitenkolleg (München)', NULL, NULL, 332, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (346, 'Tapia, Pedro de', NULL, NULL, 333, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (347, 'Vernia, Nicoletto', NULL, NULL, 334, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (348, 'Logrono', NULL, NULL, 335, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (349, 'Wien', NULL, NULL, 336, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (350, 'Coimbra', NULL, NULL, 337, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (351, 'Dubal, Francisco', NULL, NULL, 338, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (352, 'Marinis, Giovanni Battista de', NULL, NULL, 339, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (353, 'Université de Napoli', NULL, NULL, 340, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (354, 'Challemoux, Charles', NULL, NULL, 341, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (355, 'Colegio de San Agustín (Alcala)', NULL, NULL, 342, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (356, 'Notaire de la Congrégation du Saint-Office', NULL, NULL, 343, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (357, 'Hurtado, Pedro - de Mendoza', NULL, NULL, 344, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (358, 'Cobos, Cristobal de los', NULL, NULL, 345, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (359, 'Capucins', NULL, NULL, 346, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (360, 'Tesauro, Emanuele', NULL, NULL, 347, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (361, 'Boniel, Claude', NULL, NULL, 348, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (362, 'Université de Louvain, Faculté de Théologie', NULL, NULL, 349, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (363, 'Archevêque', NULL, NULL, 350, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (364, 'Morales, Antonio', NULL, NULL, 351, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (365, 'Crassot, Jean', NULL, NULL, 352, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (366, 'Kraków', NULL, NULL, 353, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (367, 'Torino', NULL, NULL, 354, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (368, 'Corpus Christi, Mancio de', NULL, NULL, 355, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (369, 'Facultade de Teologia (Universidade de Coimbra)', NULL, NULL, 356, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (370, 'Lacman, Jean', NULL, NULL, 357, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (371, 'Baldelli, Niccolo', NULL, NULL, 358, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (372, 'Abad, Diego José', NULL, NULL, 359, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (373, 'Vaz, Gaspar', NULL, NULL, 360, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (374, 'Halle (Saale)', NULL, NULL, 361, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (375, 'Procureur général de l''Ordre dominicain', NULL, NULL, 362, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (376, 'Simón Abril, Pedro', NULL, NULL, 363, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (377, 'Delgadillo, Cristóbal', NULL, NULL, 364, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (378, 'Aldrete, Bernardo de', NULL, NULL, 365, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (379, 'Vandensteen (a Lapide), Cornelissen (Cornelius)', NULL, NULL, 366, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (380, 'Urbino', NULL, NULL, 367, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (381, 'Diocèse d''Urbino (Urbinaten-sis)', NULL, NULL, 368, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (382, 'Pisa, Alonso de', NULL, NULL, 369, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (383, 'Froidmont, Libert', NULL, NULL, 370, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (384, 'Poitiers', NULL, NULL, 371, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (385, 'Ledesma, Pedro de', NULL, NULL, 372, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (386, 'León, Luis de', NULL, NULL, 373, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (387, 'Brutscher, Johannes', NULL, NULL, 374, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (388, 'Elizalde, Miguel de', NULL, NULL, 375, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (389, 'Heidelberg', NULL, NULL, 376, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (390, 'Messina', NULL, NULL, 377, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (391, 'Université de Douai, Faculté de Théologie', NULL, NULL, 378, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (392, 'Théologie Thomiste', NULL, NULL, 379, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (393, 'Rassler, Christoph', NULL, NULL, 380, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (394, 'Arts libéraux', NULL, NULL, 381, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (395, 'Heidelberg, Université', NULL, NULL, 382, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (396, 'Mazarino, Michele', NULL, NULL, 383, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (397, 'Verona', NULL, NULL, 384, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (398, 'Major, John', NULL, NULL, 385, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (399, 'Ridolfi, Niccolò', NULL, NULL, 386, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (400, 'Corsini, Odoardo', NULL, NULL, 387, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (401, 'Possevino, Antonio', NULL, NULL, 388, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (402, 'Gautruche, Pierre', NULL, NULL, 389, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (403, 'Schoockius, Martin', NULL, NULL, 390, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (404, 'Molina, Luis de', NULL, NULL, 391, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (405, 'Ramus, Petrus', NULL, NULL, 392, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (406, 'Droit canonique', NULL, NULL, 393, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (407, 'Libelli, Giacinto', NULL, NULL, 394, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (408, 'Aversa, Raffaello', NULL, NULL, 395, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (409, 'Marburg An Der Lahn', NULL, NULL, 396, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (410, 'Latin', NULL, NULL, 397, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (411, 'Campanella, Tommaso', NULL, NULL, 398, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (412, 'Fuente, Gaspar de la', NULL, NULL, 399, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (413, 'Fassari, Vicenzo', NULL, NULL, 400, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (414, 'Viva, Domenico', NULL, NULL, 401, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (415, 'Jacquier, François', NULL, NULL, 402, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (416, 'Eberle, Wolfgang', NULL, NULL, 403, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (417, 'Naveros, Jacobo de', NULL, NULL, 404, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (418, 'Milich, Jakob', NULL, NULL, 405, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (419, 'Giustiniani, Andrea', NULL, NULL, 406, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (420, 'Pourchot, Edmond', NULL, NULL, 407, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (421, 'Cesena', NULL, NULL, 408, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (422, 'Deza, Diego de', NULL, NULL, 409, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (423, 'Bayon, Nicolas', NULL, NULL, 410, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (424, 'Bernardi della Mirandola, Antonio', NULL, NULL, 411, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (425, 'Pallavicini, Tommaso', NULL, NULL, 412, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (426, 'Baronius, Robert', NULL, NULL, 413, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (427, 'Petroni, Giacinto', NULL, NULL, 414, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (428, 'Colegio de Santa Catarina (Compañía de Jesús) (Cordoba)', NULL, NULL, 415, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (429, 'Torni, Serafino', NULL, NULL, 416, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (430, 'Mezger, Paul', NULL, NULL, 417, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (431, 'Gavardi, Frederico Nicola', NULL, NULL, 418, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (432, 'Vicariis, Stefano de', NULL, NULL, 419, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (433, 'Arnu, Nicolas', NULL, NULL, 420, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (434, 'Duisburg', NULL, NULL, 421, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (435, 'Fracastoro, Gerolamo', NULL, NULL, 422, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (436, 'Sarria, Tomás de', NULL, NULL, 423, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (437, 'Cano, Melchior', NULL, NULL, 424, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (438, 'Conti, Giovannbattista', NULL, NULL, 425, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (439, 'Nürnberg', NULL, NULL, 426, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (440, 'Fay, Pierre du', NULL, NULL, 427, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (441, 'Ruiz, Gabriel', NULL, NULL, 428, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (442, 'Buffier, Claude', NULL, NULL, 429, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (443, 'Uson, Juan Antonio', NULL, NULL, 430, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (444, 'Cally, Pierre', NULL, NULL, 431, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (445, 'Pozzobonelli, Domenico Maria', NULL, NULL, 432, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (446, 'Aragón, Pedro de', NULL, NULL, 433, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (447, 'Caietano, Tommaso - de Vio', NULL, NULL, 434, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (448, 'Groningen', NULL, NULL, 435, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (449, 'Grenoble', NULL, NULL, 436, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (450, 'Pays-Bas', NULL, NULL, 437, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (451, 'Merchier, Guillaume', NULL, NULL, 438, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (452, 'Rancati, Ilarione', NULL, NULL, 439, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (453, 'Busembaum, Hermann', NULL, NULL, 440, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (454, 'Bonardi, Vincenzo', NULL, NULL, 441, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (455, 'Bugis, Pierre de', NULL, NULL, 442, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (456, 'Oratoire de France', NULL, NULL, 443, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (457, 'Borelli, Giovanni Alfonso', NULL, NULL, 444, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (458, 'Amico, Bartolomeo', NULL, NULL, 445, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (459, 'Colegio de San Hermenegildo (Compañía de Jesús) (Sevilla)', NULL, NULL, 446, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (460, 'Ystella, Lodovico', NULL, NULL, 447, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (461, 'PRAHA (PRAGUE)', NULL, NULL, 448, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (462, 'Chambery', NULL, NULL, 449, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (463, 'Telesio, Bernardino', NULL, NULL, 450, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (464, 'Echeverria, Carlos de', NULL, NULL, 451, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (465, 'Modena', NULL, NULL, 452, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (466, 'Konstanz', NULL, NULL, 453, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (467, 'Chaire de métaphysique in via Scoti', NULL, NULL, 454, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (468, 'Lille', NULL, NULL, 455, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (469, 'WARSZAWA (WARSAW)', NULL, NULL, 456, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (470, 'Goclenius, Rudolph', NULL, NULL, 457, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (471, 'Colegio Máximo de San Pablo (Compañía de Jesús) (Lima)', NULL, NULL, 458, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (472, 'Bérulle, Marc de', NULL, NULL, 459, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (473, 'Dagoumer, Guillaume', NULL, NULL, 460, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (474, 'St. Andrews', NULL, NULL, 461, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (475, 'Esparza, Martin de', NULL, NULL, 462, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (476, 'Babenstuber, Ludwig', NULL, NULL, 463, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (477, 'Roberval, Gilles Personne de', NULL, NULL, 464, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (478, 'Tournély, Honoré', NULL, NULL, 465, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (479, 'Ferrari, Tommaso Maria', NULL, NULL, 466, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (480, 'Ponce de León, Basilio', NULL, NULL, 467, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (481, 'Murcia', NULL, NULL, 468, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (482, 'Grynaeus, Simon', NULL, NULL, 469, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (483, 'Archidiocèse de Trani', NULL, NULL, 470, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (484, 'Lipse, Juste', NULL, NULL, 471, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (485, 'Grimani, Domenico', NULL, NULL, 472, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (486, 'Chabron, Guillaume', NULL, NULL, 473, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (487, 'Pico, Paolo', NULL, NULL, 474, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (488, 'Maldonado, Juan', NULL, NULL, 475, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (489, 'Siège inquisitorial de Faenza', NULL, NULL, 476, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (490, 'Nonce', NULL, NULL, 477, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (491, 'Toledo', NULL, NULL, 478, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (492, 'Durandisme', NULL, NULL, 479, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (493, 'Mlodzianowski, Tomasz', NULL, NULL, 480, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (494, 'González de Santalla, Tirso', NULL, NULL, 481, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (495, 'Florindas, Diego de', NULL, NULL, 482, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (496, 'Guanzelli, Giovanni Maria - da Brisighella', NULL, NULL, 483, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (497, 'Gentili, Deodato', NULL, NULL, 484, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (498, 'Universidad de Zaragoza', NULL, NULL, 485, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (499, 'Sanches, Francisco', NULL, NULL, 486, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (500, 'Pasqualigo, Zaccaria', NULL, NULL, 487, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (501, 'Siena', NULL, NULL, 488, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (502, 'Séminaire (Salerno)', NULL, NULL, 489, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (503, 'Farvacques, François', NULL, NULL, 490, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (504, 'Mathématiques supérieures', NULL, NULL, 491, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (505, 'Coronelli, Vincenzo Maria', NULL, NULL, 492, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (506, 'Fabri, Sisto', NULL, NULL, 493, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (507, 'Vázquez de Malpartida, Francisco', NULL, NULL, 494, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (508, 'Gozalvo, Marcelino', NULL, NULL, 495, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (509, 'Zobbio, Tommaso', NULL, NULL, 496, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (510, 'Mercado, Tomás de', NULL, NULL, 497, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (511, 'Adjoint du maître du Sacré Palais', NULL, NULL, 498, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (512, 'Qualificateur de la Congrégation de l''Inquisition', NULL, NULL, 499, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (513, 'Gormaz, Juan Bautista', NULL, NULL, 500, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (514, 'Bordas, Nicolas', NULL, NULL, 501, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (515, 'Hollmann, Samuel Christian', NULL, NULL, 502, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (516, 'Fuente Hurtado, Diego de la', NULL, NULL, 503, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (517, 'Collège du Mont (Compagnie de Jésus) (Caen)', NULL, NULL, 504, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (518, 'Cremona', NULL, NULL, 505, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (519, 'Bosi, Tommaso Maria', NULL, NULL, 506, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (520, 'Colegio de la Compañía de Jesús (Avila)', NULL, NULL, 507, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (521, 'Siège inquisitorial de Padova', NULL, NULL, 508, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (522, 'Aberdeen', NULL, NULL, 509, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (523, 'Belmonte', NULL, NULL, 510, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (524, 'Scheiner, Christoph', NULL, NULL, 511, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (525, 'Bernal de Avila, Agustín', NULL, NULL, 512, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (526, 'Pinto, Heitor', NULL, NULL, 513, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (527, 'Montemayor, Juan de', NULL, NULL, 514, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (528, 'Richard, Claude', NULL, NULL, 515, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (529, 'Giattini, Giovanni Battista', NULL, NULL, 516, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (530, 'Esquivel, Pedro', NULL, NULL, 517, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (531, 'Trnava', NULL, NULL, 518, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (532, 'Provincial', NULL, NULL, 519, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (533, 'Marini, Domenico De', NULL, NULL, 520, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (534, 'Soto, Pedro de', NULL, NULL, 521, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (535, 'Plazza, Benedetto', NULL, NULL, 522, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (536, 'Fantono, Girolamo', NULL, NULL, 523, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (537, 'Boscovich, Ruggiero Giuseppe', NULL, NULL, 524, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (538, 'Genovesi, Antonio', NULL, NULL, 525, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (539, 'Franciscains récollets', NULL, NULL, 526, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (540, 'Ambrogi, Paolo Antonio', NULL, NULL, 527, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (541, 'Hongrie', NULL, NULL, 528, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (542, 'Ordre de Saint-Benoît', NULL, NULL, 529, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (543, 'Collège d''Evora (Evora)', NULL, NULL, 530, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (544, 'Zapata, Pedro', NULL, NULL, 531, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (545, 'Piccinardi, Serafino', NULL, NULL, 532, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (546, 'Caramuel Lobkowitz, Juan', NULL, NULL, 533, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (547, 'Penketh, Thomas', NULL, NULL, 534, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (548, 'Convento de San Esteban (Salamanca)', NULL, NULL, 535, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (549, 'Monroy, Antonio de', NULL, NULL, 536, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (550, 'Fiscal du Saint-Office romain', NULL, NULL, 537, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (551, 'Gênes (République de)', NULL, NULL, 538, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (552, 'Maffei, Tommaso Pio', NULL, NULL, 539, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (553, 'Cárdenas, Juan de', NULL, NULL, 540, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (554, 'Collegio dei Gesuiti (Macerata)', NULL, NULL, 541, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (555, 'Hortensius, Martinus', NULL, NULL, 542, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (556, 'Borrull, Matías', NULL, NULL, 543, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (557, 'Feroni, Giuseppe Maria', NULL, NULL, 544, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (558, 'Sáenz de Aguirre, José', NULL, NULL, 545, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (559, 'St Isidore’s College (Roma)', NULL, NULL, 546, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (560, 'Tolomei, Giovanni Battista', NULL, NULL, 547, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (561, 'Rennes', NULL, NULL, 548, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (562, 'Vercelli, Antonio - da Lendinara', NULL, NULL, 549, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (563, 'Dreier, Christian', NULL, NULL, 550, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (564, 'Oreggi, Agostino', NULL, NULL, 551, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (565, 'Fani, Vincenzo', NULL, NULL, 552, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (566, 'De Angelis, Agostino', NULL, NULL, 553, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (567, 'Gregorio, Maurizio Di', NULL, NULL, 554, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (568, 'Costabili, Paolo', NULL, NULL, 555, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (569, 'Collège de Poznan (Poznan)', NULL, NULL, 556, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (570, 'Colégio das Artes (Universidade de Coimbra)', NULL, NULL, 557, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (571, 'López Yáñez de Quesada, Ginés', NULL, NULL, 558, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (572, 'Toulouse, Casimir de', NULL, NULL, 559, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (573, 'Reinhold, Erasmus', NULL, NULL, 560, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (574, 'Diocèse de Bergamo', NULL, NULL, 561, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (575, 'Ezterripa y Zuazu, Atanasio de', NULL, NULL, 562, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (576, 'Noris, Enrico', NULL, NULL, 563, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (577, 'Pisa', NULL, NULL, 564, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (578, 'Kennis, Ignatius Der', NULL, NULL, 565, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (579, 'Grenade', NULL, NULL, 566, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (580, 'Poza, Juan Bautista', NULL, NULL, 567, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (581, 'Miranda, Francisco de', NULL, NULL, 568, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (582, 'Iribarne e Uraburu, Juan', NULL, NULL, 569, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (583, 'Lucarini, Reginaldo', NULL, NULL, 570, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (584, 'Mariale, Sante', NULL, NULL, 571, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (585, 'Pérez de Menacho, Juan', NULL, NULL, 572, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (586, 'Mathématiques élémentaires', NULL, NULL, 573, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (587, 'Tellin, Ignatius', NULL, NULL, 574, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (588, 'Hell, Caspar', NULL, NULL, 575, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (589, 'Université de Leipzig', NULL, NULL, 576, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (590, 'Javelli, Grisostomo', NULL, NULL, 577, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (591, 'Chaire de métaphysique in via s. Thomae', NULL, NULL, 578, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (592, 'Bulenger, Jules César', NULL, NULL, 579, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (593, 'Medici, Girolamo de', NULL, NULL, 580, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (594, 'Nizzoli (Nizolius), Mario', NULL, NULL, 581, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (595, 'Bernaldo de Quirós, Antonio', NULL, NULL, 582, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (596, 'Pologne', NULL, NULL, 583, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (597, 'Erber, Anton', NULL, NULL, 584, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (598, 'Spinula, Stefano', NULL, NULL, 585, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (599, 'Reghezzi, Giovanni Vincenzio - da Tabia', NULL, NULL, 586, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (600, 'Mexico', NULL, NULL, 587, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (601, 'Accarisi, Jacopo', NULL, NULL, 588, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (602, 'Bilbao', NULL, NULL, 589, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (603, 'Béziers', NULL, NULL, 590, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (604, 'Diaz de Llanos, Froylan', NULL, NULL, 591, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (605, 'Briceño, Alonso', NULL, NULL, 592, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (606, 'Wolff, Christian', NULL, NULL, 593, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (607, 'Oxford', NULL, NULL, 594, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (608, 'Boucher, Claude', NULL, NULL, 595, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (609, 'Rutherford, Samuel', NULL, NULL, 596, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (610, 'Bay (Baius), Michel du', NULL, NULL, 597, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (611, 'Basel', NULL, NULL, 598, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (612, 'Nice', NULL, NULL, 599, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (613, 'Faenza', NULL, NULL, 600, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (614, 'Jesuiten (Landshut)', NULL, NULL, 601, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (615, 'Province de Lombardie (Ordre dominicain)', NULL, NULL, 602, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (616, 'Thomasius, Jakob', NULL, NULL, 603, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (617, 'Halloix, Pierre', NULL, NULL, 604, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (618, 'Adjoint du notaire de la Congrégation du Saint-Office', NULL, NULL, 605, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (619, 'Röell, Hermann Alexander', NULL, NULL, 606, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (620, 'Siège inquisitorial de Firenze', NULL, NULL, 607, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (621, 'Pontanus, Jacobus', NULL, NULL, 608, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (622, 'Carreño, Bartolomé', NULL, NULL, 609, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (623, 'Baldovinetti, Giovanni Carlo', NULL, NULL, 610, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (624, 'Universidad de Alcalá, Facultad de Teología', NULL, NULL, 611, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (625, 'Avendaño, Pedro de', NULL, NULL, 612, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (626, 'Guzmán, Domingo de', NULL, NULL, 613, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (627, 'Bisterfeld, Johann Heinrich', NULL, NULL, 614, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (628, 'Collège en Isle (Compagnie de Jésus) (Liège)', NULL, NULL, 615, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (629, 'Lupus, Chrétien', NULL, NULL, 616, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (630, 'Inchofer, Melchior', NULL, NULL, 617, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (631, 'Padial, Manuel', NULL, NULL, 618, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (632, 'Cavazzi, Domenico', NULL, NULL, 619, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (633, 'Gerona', NULL, NULL, 620, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (634, 'Gutiérrez, Lorenzo', NULL, NULL, 621, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (635, 'Comenius, Johann Amos', NULL, NULL, 622, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (636, 'Castellini, Luc', NULL, NULL, 623, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (637, 'Colegio de la Compañía de Jesús (Pamplona)', NULL, NULL, 624, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (638, 'Rocaberti, Juan Tomas de', NULL, NULL, 625, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (639, 'Quito', NULL, NULL, 626, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (640, 'Lugo, Jean de', NULL, NULL, 627, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (641, 'Aymerich, Mateo', NULL, NULL, 628, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (642, 'Conti, Pietro', NULL, NULL, 629, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (643, 'Colegio de la Compañía de Jesús (Cuzco)', NULL, NULL, 630, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (644, 'Lynch, Richard', NULL, NULL, 631, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (645, 'Ceriziers, René de', NULL, NULL, 632, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (646, 'Aquario, Mattia', NULL, NULL, 633, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (647, 'Christine - reine de Suède', NULL, NULL, 634, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (648, 'Licheto, Francesco', NULL, NULL, 635, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (649, 'Villafañe, Antonio de', NULL, NULL, 636, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (650, 'Girolami, Raffaele Cosimo', NULL, NULL, 637, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (651, 'Orleans', NULL, NULL, 638, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (652, 'Ysambert, Nicolas', NULL, NULL, 639, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (653, 'Université de Paris', NULL, NULL, 640, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (654, 'Ricci, Giacomo', NULL, NULL, 641, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (655, 'Santiago', NULL, NULL, 642, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (656, 'Bianchi, Giulio Maria', NULL, NULL, 643, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (657, 'Sotomayor, Pedro de', NULL, NULL, 644, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (658, 'Lange, Johannes Joachim', NULL, NULL, 645, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (659, 'Controverses (théologiques)', NULL, NULL, 646, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (660, 'Gennari, Tommaso Maria - da Chioggia', NULL, NULL, 647, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (661, 'Voetius, Gisbert', NULL, NULL, 648, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (662, 'Preti, Vincenzo', NULL, NULL, 649, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (663, 'Donati, Gregorio', NULL, NULL, 650, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (664, 'Wroclaw Breslau', NULL, NULL, 651, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (665, 'Lessius, Leonardus', NULL, NULL, 652, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (666, 'Philosophie morale', NULL, NULL, 653, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (667, 'Ledesma, Martín de', NULL, NULL, 654, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (668, 'Santiago de Querétaro', NULL, NULL, 655, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (669, 'Volpi, Angelo', NULL, NULL, 656, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (670, 'Ciorla, Vincenzo', NULL, NULL, 657, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (671, 'Balfour, Robert', NULL, NULL, 658, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (672, 'Flórez de Setién, Enrique', NULL, NULL, 659, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (673, 'Universiteit Leiden', NULL, NULL, 660, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (674, 'Secchi, Serafino', NULL, NULL, 661, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (675, 'Lanci, Ippolito - d'' Acquanegra', NULL, NULL, 662, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (676, 'Oria, Juan de', NULL, NULL, 663, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (677, 'Tessaneck, Johannes', NULL, NULL, 664, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (678, 'Bechmann, Friedemann', NULL, NULL, 665, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (679, 'Pont-à-Mousson', NULL, NULL, 666, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (680, 'Zamoro, Giuseppe Maria', NULL, NULL, 667, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (681, 'Bérigard, Claude', NULL, NULL, 668, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (682, 'Huesca', NULL, NULL, 669, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (683, 'Nieuhoff, Bernardus', NULL, NULL, 670, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (684, 'Cosenza', NULL, NULL, 671, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (685, 'Córdoba, Antonio de', NULL, NULL, 672, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (686, 'Grandin, Martin', NULL, NULL, 673, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (687, 'Aquileia', NULL, NULL, 674, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (688, 'Biescas, Juan', NULL, NULL, 675, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (689, 'Tartaglia, Giovanni Agostino', NULL, NULL, 676, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (690, 'Fornari, Martino', NULL, NULL, 677, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (691, 'Gutiérrez, Juan', NULL, NULL, 678, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (692, 'Eggendorfer, Wolfgang', NULL, NULL, 679, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (693, 'Arganda', NULL, NULL, 680, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (694, 'Agnani, Gian Domenico', NULL, NULL, 681, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (695, 'Candido, Vincenzo', NULL, NULL, 682, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (696, 'Ricci, Paolo', NULL, NULL, 683, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (697, 'Chacón, Manuel', NULL, NULL, 684, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (698, 'Ibarra, Esteban de', NULL, NULL, 685, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (699, 'Université d''Aix-en-Provence', NULL, NULL, 686, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (700, 'Giglioli, Alfonso', NULL, NULL, 687, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (701, 'Ponz, Buenaventura', NULL, NULL, 688, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (702, 'Albergoni, Eleuterio', NULL, NULL, 689, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (703, 'Schegk, Jakob', NULL, NULL, 690, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (704, 'Aldalur, José Antonio de', NULL, NULL, 691, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (705, 'Martini, Cornelius', NULL, NULL, 692, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (706, 'Albizzi, Francesco', NULL, NULL, 693, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (707, 'Dialectique', NULL, NULL, 694, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (708, 'Caserta', NULL, NULL, 695, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (709, 'Lipstorp, Daniel', NULL, NULL, 696, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (710, 'Fantis, Antonio de', NULL, NULL, 697, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (711, 'Siracusa', NULL, NULL, 698, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (712, 'Polizzi, Giuseppe', NULL, NULL, 699, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (713, 'Mechelen', NULL, NULL, 700, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (714, 'Carrillo, Alonso', NULL, NULL, 701, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (715, 'Franeker', NULL, NULL, 702, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (716, 'Dechales, Claude-François Milliet', NULL, NULL, 703, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (717, 'Pontoise', NULL, NULL, 704, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (718, 'Verdun', NULL, NULL, 705, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (719, 'Diocèse de Gravina', NULL, NULL, 706, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (720, 'Alamanni, Angelo', NULL, NULL, 707, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (721, 'Faydit, Pierre', NULL, NULL, 708, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (722, 'Nikolaischule', NULL, NULL, 709, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (723, 'Universiteit Utrecht', NULL, NULL, 710, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (724, 'Hurtado, Gaspar', NULL, NULL, 711, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (725, 'Melles, Etienne de', NULL, NULL, 712, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (726, 'Estius, Guillelmus', NULL, NULL, 713, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (727, 'Deventer', NULL, NULL, 714, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (728, 'Peña, Francisco', NULL, NULL, 715, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (729, 'Cloche, Antonin', NULL, NULL, 716, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (730, 'Rio, Galderico', NULL, NULL, 717, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (731, 'English College (Lisboa)', NULL, NULL, 718, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (732, 'Arsdekin, Richard', NULL, NULL, 719, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (733, 'Université d''Osuna', NULL, NULL, 720, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (734, 'Jiménez Samaniego, José', NULL, NULL, 721, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (735, 'Gabrielli, Gabriele de''', NULL, NULL, 722, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (736, 'Pinelo, Gabriel', NULL, NULL, 723, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (737, 'Del Rio, Martín Antonio', NULL, NULL, 724, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (738, 'Cork', NULL, NULL, 725, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (739, 'Università di Ferrara', NULL, NULL, 726, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (740, 'Guevara, Jeronimo de', NULL, NULL, 727, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (741, 'Collège du Chateau', NULL, NULL, 728, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (742, 'Cas de conscience', NULL, NULL, 729, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (743, 'Medina, Bartolomé de', NULL, NULL, 730, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (744, 'Belluno', NULL, NULL, 731, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (745, 'Fardella, Michelangelo', NULL, NULL, 732, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (746, 'Esbarroya, Agustin de', NULL, NULL, 733, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (747, 'Fernández de Robles, Francisco', NULL, NULL, 734, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (748, 'Truchsess, Eusebius Graf von', NULL, NULL, 735, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (749, 'Medina, Juan de', NULL, NULL, 736, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (750, 'Filonardi, Mario', NULL, NULL, 737, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (751, 'Archidiocèse de Taranto', NULL, NULL, 738, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (752, 'Casmann, Otto', NULL, NULL, 739, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (753, 'Molloy, Francis', NULL, NULL, 740, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (754, 'Campos, Urbano', NULL, NULL, 741, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (755, 'Peucer, Caspar', NULL, NULL, 742, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (756, 'Maignan, Emmanuel', NULL, NULL, 743, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (757, 'Pazmany', NULL, NULL, 744, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (758, 'Alagona, Pietro', NULL, NULL, 745, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (759, 'Cornejo, Francisco', NULL, NULL, 746, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (760, 'Suisse', NULL, NULL, 747, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (761, 'Ancona', NULL, NULL, 748, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (762, 'Stahl, Daniel', NULL, NULL, 749, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (763, 'Collège jésuite (Halle)', NULL, NULL, 750, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (764, 'Macedo, Francisco - de Sao Agostinho', NULL, NULL, 751, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (765, 'Vives, Jerónimo', NULL, NULL, 752, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (766, 'Mazza, Tommaso', NULL, NULL, 753, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (767, 'Mulet, Corneille', NULL, NULL, 754, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (768, 'Tasca, Lorenzo', NULL, NULL, 755, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (769, 'Montefortino, Girolamo da', NULL, NULL, 756, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (770, 'Munchen', NULL, NULL, 757, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (771, 'Cornejo de Pedrosa, Pedro', NULL, NULL, 758, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (772, 'Casimirianum Neustadt', NULL, NULL, 759, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (773, 'Buhon, Gaspar', NULL, NULL, 760, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (774, 'Colegio de la Compañía de Jesús (Callao)', NULL, NULL, 761, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (775, 'Timpler, Clemens', NULL, NULL, 762, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (776, 'Basso, Sebastian', NULL, NULL, 763, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (777, 'Sicile (île) ', NULL, NULL, 764, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (778, 'Lucini, Luigi Maria', NULL, NULL, 765, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (779, 'Convento San Pablo (Dominicos) (Valladolid)', NULL, NULL, 766, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (780, 'Turco, Tommaso', NULL, NULL, 767, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (781, 'Wittenberg', NULL, NULL, 768, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (782, 'Valenti, Ludovico', NULL, NULL, 769, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (783, 'Zamora', NULL, NULL, 770, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (784, 'Recupito, Giulio Cesare', NULL, NULL, 771, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (785, 'Saguens, Jean', NULL, NULL, 772, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (786, 'Termoli', NULL, NULL, 773, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (787, 'Valera, Jerónimo', NULL, NULL, 774, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (788, 'Miranda, Bartolomeo da', NULL, NULL, 775, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (789, 'Brancacio de Caravinea, Clemens', NULL, NULL, 776, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (790, 'Chaire de théologie scotiste', NULL, NULL, 777, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (791, 'Ciruelo, Pedro', NULL, NULL, 778, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (792, 'Danes, Pierre-Hilaire', NULL, NULL, 779, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (793, 'Busaeus, Johannes', NULL, NULL, 780, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (794, 'Smiglecki, Marcin', NULL, NULL, 781, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (795, 'Zurich', NULL, NULL, 782, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (796, 'Macedo, Bento de', NULL, NULL, 783, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (797, 'Utrecht', NULL, NULL, 784, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (798, 'Strasbourg', NULL, NULL, 785, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (799, 'Oviedo, Pedro de', NULL, NULL, 786, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (800, 'Rocco, Antonio', NULL, NULL, 787, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (801, 'Freisleben, Franz', NULL, NULL, 788, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (802, 'Machin de Aquena, Ambrogio', NULL, NULL, 789, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (803, 'Moneda, Andrés de la', NULL, NULL, 790, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (804, 'Sainte-Beuve, Jacques de', NULL, NULL, 791, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (805, 'Martinengo, Giovanni Battista da', NULL, NULL, 792, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (806, 'Wadding, Luke', NULL, NULL, 793, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (807, 'La Napola da Trapani, Giuseppe', NULL, NULL, 794, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (808, 'Jesuitenkolleg (Luzern)', NULL, NULL, 795, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (809, 'Cottet, Anton', NULL, NULL, 796, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (810, 'Law, John', NULL, NULL, 797, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (811, 'Facciolati, Iacopo', NULL, NULL, 798, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (812, 'Fonseca, Pedro da', NULL, NULL, 799, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (813, 'Universität Ingolstadt', NULL, NULL, 800, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (814, 'Trapolin, Pietro', NULL, NULL, 801, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (815, 'Lodi', NULL, NULL, 802, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (816, 'Crellius, Fortunatus', NULL, NULL, 803, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (817, 'Brenz, Johannes', NULL, NULL, 804, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (818, 'Habert, Louis', NULL, NULL, 805, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (819, 'Tetens, Johann Nikolaus', NULL, NULL, 806, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (820, 'Ricci, Giuseppe', NULL, NULL, 807, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (821, 'Eisenmenger, Samuel', NULL, NULL, 808, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (822, 'Marseille', NULL, NULL, 809, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (823, 'Sixtus V', NULL, NULL, 810, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (824, 'Sotomaior, Luís de', NULL, NULL, 811, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (825, 'Manrique, Ángel', NULL, NULL, 812, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (826, 'Bernardini, Paolino', NULL, NULL, 813, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (827, 'Camotto, Tommaso', NULL, NULL, 814, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (828, 'Cantalapiedra, Martín Martínez de', NULL, NULL, 815, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (829, 'Segovia', NULL, NULL, 816, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (830, 'Steyaert, M.', NULL, NULL, 817, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (831, 'Cruzat, Gaspar', NULL, NULL, 818, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (832, 'Denis, Martin', NULL, NULL, 819, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (833, 'Grizi, Consalvo - da Esio', NULL, NULL, 820, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (834, 'Sessa Aurunca', NULL, NULL, 821, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (835, 'Congrégation de l''Inquisition', NULL, NULL, 822, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (836, 'Obiols, Francisco', NULL, NULL, 823, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (837, 'Poinsot, João', NULL, NULL, 824, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (838, 'Grande, Cristóforo', NULL, NULL, 825, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (839, 'Parma', NULL, NULL, 826, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (840, 'Magnien, Charles', NULL, NULL, 827, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (841, 'Pédagogie', NULL, NULL, 828, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (842, 'Bernini, Pietro Filippo', NULL, NULL, 829, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (843, 'Plieningen', NULL, NULL, 830, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (844, 'Gonzaga, Francesco', NULL, NULL, 831, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (845, 'Noël, Etienne', NULL, NULL, 832, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (846, 'Pimentel, Pedro', NULL, NULL, 833, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (847, 'Roi / reine', NULL, NULL, 834, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (848, 'Accademia degli Oziosi', NULL, NULL, 835, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (849, 'Médecin', NULL, NULL, 836, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (850, 'Moya, Matías de', NULL, NULL, 837, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (851, 'Galilei, Giovanni', NULL, NULL, 838, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (852, 'Felwinger, Johannes Paul', NULL, NULL, 839, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (853, 'Acquaviva, Tommaso', NULL, NULL, 840, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (854, 'Guischard, Pierre', NULL, NULL, 841, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (855, 'Couvent des dominicains (Albi)', NULL, NULL, 842, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (856, 'Cartagena, Juan de', NULL, NULL, 843, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (857, 'Ayleworth, William', NULL, NULL, 844, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (858, 'Gracián, Baltasar', NULL, NULL, 845, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (859, 'Résidence des Jésuites (Pontoise)', NULL, NULL, 846, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (860, 'Martínez, Nicolás', NULL, NULL, 847, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (861, 'Convento de Santo Tomás (Avila)', NULL, NULL, 848, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (862, 'Ortiz de Moncada, Diego', NULL, NULL, 849, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (863, 'Carranza de Miranda, Bartolomé', NULL, NULL, 850, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (864, 'Soto, Domingo de', NULL, NULL, 851, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (865, 'Hirnhaim, Hieronymus', NULL, NULL, 852, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (866, 'Vicomercato, Francesco', NULL, NULL, 853, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (867, 'Osorio y Bernaldo de Quirós, Salvador', NULL, NULL, 854, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (868, 'Assomption, Charles de l'', Thomistarum triumphus id est Sanctorum Augustini et Thomae
gemini ecclesiae solis summa concordia, I. De scientiâ mediâ, II. De
naturâ purâ, seu duplici Dei amore, III. De libertate, IV. De
contritione, V. De probabilitate (Douai , Balthasar Beller, 1672)', NULL, NULL, 855, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (869, 'Vire', NULL, NULL, 856, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (870, 'Jiménez, Ildefonso', NULL, NULL, 857, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (871, 'Peinado, Ignacio Francisco', NULL, NULL, 858, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (872, 'Melfi', NULL, NULL, 859, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (873, 'Fabri, Honoré, Physica, id est, scientia rerum corporearum, in decem tractatus distributa, 4 vol. (Lyon , Laurent Anisson, 1669)', NULL, NULL, 860, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (874, 'Vilar, Narciso', NULL, NULL, 861, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (875, 'Morejón, Francisco', NULL, NULL, 862, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (876, 'Brancati, Lorenzo - da Lauria', NULL, NULL, 863, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (877, 'Hevenesi, Gabriel', NULL, NULL, 864, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (878, 'Botto, Antonino', NULL, NULL, 865, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (879, 'Crespi de Borja, Luis', NULL, NULL, 866, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (880, 'Tamburini, Michelangelo', NULL, NULL, 867, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (881, 'Gil Becerra, Benito', NULL, NULL, 868, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (882, 'Universidad de Alcalá, Facultad Artes', NULL, NULL, 869, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (883, 'Díez de Isla, Juan', NULL, NULL, 870, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (884, 'Acevedo, Francisco', NULL, NULL, 871, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (885, 'Haye, La', NULL, NULL, 872, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (886, 'Guerra, Antonio', NULL, NULL, 873, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (887, 'García, Andrés', NULL, NULL, 874, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (888, 'Ranfoldi, Lattanzio', NULL, NULL, 875, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (889, 'Espinosa, Miguel de', NULL, NULL, 876, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (890, 'Rossi da Lugo, Alessandro, Controversiae theologicae inter scotistas, in quibus potiores difficultates examinantur atque germana mens Scoti aperitur, 2 vol. (Bologna, 1652)', NULL, NULL, 877, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (891, 'Le Tellier, Jean', NULL, NULL, 878, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (892, 'Olzina, José de', NULL, NULL, 879, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (893, 'Cordeiro, Antonio', NULL, NULL, 880, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (894, 'Bonaventure de Langres', NULL, NULL, 881, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (895, 'Javier Sierra, Francisco', NULL, NULL, 882, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (896, 'Silésie', NULL, NULL, 883, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (897, 'Archiviste de la Congrégation du Saint-Office', NULL, NULL, 884, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (898, 'Pérez Pastor, José Antonio', NULL, NULL, 885, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (899, 'Manganellis, Luis de', NULL, NULL, 886, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (900, 'Mathématicien de la cour', NULL, NULL, 887, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (901, 'Coccejus, Johannes, Opera Theologica, Exegetica, Didactica, Polemica, Philologica, divisa in octo volumina (Amstelodami, 1673)', NULL, NULL, 888, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (902, 'Schautheet, Fulgence', NULL, NULL, 889, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (903, 'Chiodini, Giovanni Battista - da Monte Mellone', NULL, NULL, 890, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (904, 'Domingo de San Pedro de Alcántara', NULL, NULL, 891, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (905, 'Galilei, Livia', NULL, NULL, 892, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (906, 'Delan (de Lan), François-Hyacinthe', NULL, NULL, 893, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (907, 'Couvent des Franciscains conventuels (Nice)', NULL, NULL, 894, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (908, 'Couvent Dominicain (Toro)', NULL, NULL, 895, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (909, 'Acevedo, Francisco', NULL, NULL, 896, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (910, 'Lvov', NULL, NULL, 897, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (911, 'Chanoines réguliers de Prémontré', NULL, NULL, 898, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (912, 'Soria, Giovanni Gualberto de', NULL, NULL, 899, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (913, 'Couvent des Jacobins (Rouen', NULL, NULL, 900, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (994, 'Plock', NULL, NULL, 981, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (914, 'Ribadeneyra, Pedro de', NULL, NULL, 901, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (915, 'Cenicero', NULL, NULL, 902, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (916, 'Kitzner, Balthasar', NULL, NULL, 903, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (917, 'Iribarren, Antonio', NULL, NULL, 904, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (918, 'Heereboord, Adriaan', NULL, NULL, 905, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (919, 'Gallasini, Francesco', NULL, NULL, 906, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (920, 'Passerini, Pier Francesco', NULL, NULL, 907, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (921, 'Noris, Enrico, Henrici Norisii Veronensis augustiniani opera omnia nunc primum collecta atque ordinata, 4 vol. (Verona, 1729)', NULL, NULL, 908, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (922, 'Polignano a Mare', NULL, NULL, 909, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (923, 'Ministre général de l''ordre des Franciscains conventuels', NULL, NULL, 910, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (924, 'Castropalao, Hernando de', NULL, NULL, 911, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (925, 'Meurisse, Martin', NULL, NULL, 912, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (926, 'Arras', NULL, NULL, 913, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (927, 'Bauny, Etienne, De sacramentis ac personis sacris, earum dignitate, obligationibus ac iure, iuxta sacrarum litterarum
testimonia, SS. Patrum sententias, canonum ac conciliorum sanctiones, cum summariis, indice duplici, uno 
tractatuum et quaestionum, rerum altero theologiae moralis, 2 in-fol. (Paris, 1640)', NULL, NULL, 914, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (928, 'Bayona, Carlos de', NULL, NULL, 915, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (929, 'Kirchner, Daniel', NULL, NULL, 916, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (930, 'Sturm, Johann Christoph', NULL, NULL, 917, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (931, 'Alexandre, Noël', NULL, NULL, 918, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (932, 'Zouch, Richard', NULL, NULL, 919, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (933, 'Maldonado, Francisco', NULL, NULL, 920, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (934, 'Convento franciscano conventuale (Bologna)', NULL, NULL, 921, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (935, 'Arnu, Nicolas, Divus Thomas Aquinas divinae voluntatis et sui ipsius in Summa theologiae fidissimus interpres, 4 vol. (Roma / Lyon , N.-A. Tinassi, 1679)', NULL, NULL, 922, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (936, 'Olzina, Diego de', NULL, NULL, 923, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (937, 'Bidermann, Jakob', NULL, NULL, 924, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (938, 'Hurtado, Tomás', NULL, NULL, 925, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (939, 'Riez, Marcel de', NULL, NULL, 926, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (940, 'Faculté des Arts de l''Université de Wittemberg', NULL, NULL, 927, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (941, 'Feder, Johann Georg Heinrich', NULL, NULL, 928, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (942, 'Palazol, Juan de', NULL, NULL, 929, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (943, 'Riom', NULL, NULL, 930, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (944, 'Encinas, Fernando', NULL, NULL, 931, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (945, 'Büttner, Christoph Andreas', NULL, NULL, 932, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (946, 'Ramírez, Vicente', NULL, NULL, 933, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (947, 'Barbieri da Castelvetro, Bartolomeo, Glossa seu summa ex omnibus S. Bonaventurae expositionibus
in Sacram Scripturam exactè collecta &amp;amp; in facilem usum studiosis,
ac concionatoribus secundùm ordinem biblicum concinnata : tomus primus, contient : I. Tomus primus : continens libros Genesis, Erodi, Levitie,
Numerorum, Deuteromonii Josue, Judicum, Ruth, Regum, Paralipomenon,
Esdrae, Tobiae, Judith, Esther &amp;amp; Job. II. Tomus secundus :
continens omnes Psalmos III. Tomus tertius : continens libros
sapientiales et omnes prophetas, nec non duos libros Machabaeorum. IV.
Tomus quartus : continens totum Testamentum Novum. V. Tabula seu index
generalis in opera omnia S. Bonaventurae (Lyon , typ. Anisson &amp;amp; J. Posuel, 1681)', NULL, NULL, 934, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (948, 'Convento franciscano (Murcia)', NULL, NULL, 935, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (949, 'Giannini, Tommaso', NULL, NULL, 936, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (950, 'Bellarini, Giovanni, Ascencion del entendimiento a Dios por escalas de la cosas criadas, traduction espagnole par le minime Lucas de Montoya en Ms. BNE 7784 : 1. f. 1-52v (1636)', NULL, NULL, 937, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (951, 'Mancilla, Antonio', NULL, NULL, 938, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (952, 'Dandino, Girolamo', NULL, NULL, 939, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (953, 'Macerata', NULL, NULL, 940, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (954, 'Piccolomini, Francesco', NULL, NULL, 941, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (955, 'Siège inquisitorial de Modena', NULL, NULL, 942, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (956, 'Lezana, Juan Bautista de', NULL, NULL, 943, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (957, 'Filonardi, Paolo Emilio', NULL, NULL, 944, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (958, 'Colegio San Pablo (Compañía de Jesús) (Chuquisaca)', NULL, NULL, 945, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (959, 'Röslin (Roeslin), Helisaeus', NULL, NULL, 946, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (960, 'Trapani', NULL, NULL, 947, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (961, 'Piny, Alexandre', NULL, NULL, 948, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (962, 'Barbeito, Antonio', NULL, NULL, 949, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (963, 'Studium dominicain de Bologne', NULL, NULL, 950, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (964, 'Firenzuola', NULL, NULL, 951, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (965, 'Consulteur de la Congrégation de l''Index', NULL, NULL, 952, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (966, 'Tyrie, James', NULL, NULL, 953, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (967, 'Linz', NULL, NULL, 954, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (968, 'Amort, Eusebius', NULL, NULL, 955, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (969, 'Poésie', NULL, NULL, 956, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (970, 'Navarro, Vicente', NULL, NULL, 957, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (971, 'Collège des Jésuites (Tournon)', NULL, NULL, 958, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (972, 'Serry, Jacques-Hyacinthe', NULL, NULL, 959, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (973, 'Béreur, Louis   -   ', NULL, NULL, 960, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (974, 'Sánchez de Ribera, Diego', NULL, NULL, 961, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (975, 'Galilei, Giovanni', NULL, NULL, 962, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (976, 'Suárez, Cypriano', NULL, NULL, 963, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (977, 'Colegio de la Compañía de Jesús (La Plata)', NULL, NULL, 964, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (978, 'Sanctis, Santo de', NULL, NULL, 965, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (979, 'Besoigne, Jérôme', NULL, NULL, 966, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (980, 'Hay, John', NULL, NULL, 967, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (981, 'Collège de la Trinité', NULL, NULL, 968, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (982, 'Veringendorf', NULL, NULL, 969, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (983, 'Foscarini, Paolo Antonio', NULL, NULL, 970, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (984, 'Galilei, Vincenzio', NULL, NULL, 971, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (985, 'Aguiar, Antonio de', NULL, NULL, 972, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (986, 'De Benedetti, Giovanni Battista', NULL, NULL, 973, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (987, 'Castilla, Francisco de', NULL, NULL, 974, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (988, 'Baro, Bonaventura', NULL, NULL, 975, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (989, 'Zumel, Francisco, De Deo, eiusque operibus.Commentaria in primam partem Sancti Thomae Aquinatis consecrata, 2 vols. (Venetiis , Fioravanti Prato, 1597)', NULL, NULL, 976, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (990, 'Universidad San Gregorio Magno, Universidad Gregoriana (Compañía de Jesús) (Quito)', NULL, NULL, 977, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (991, 'Siège inquisitorial de Tortona', NULL, NULL, 978, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (992, 'Daroca', NULL, NULL, 979, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (993, 'San Sebastian', NULL, NULL, 980, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (995, 'Ruffat, Jean', NULL, NULL, 982, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (996, 'Sancho Granado, Francisco', NULL, NULL, 983, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (997, 'Cappello, Girolamo - da Casalmaggiore', NULL, NULL, 984, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (998, 'Picazo, Juan', NULL, NULL, 985, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (999, 'Mouvement de la terre', NULL, NULL, 986, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1000, 'Catanzaro', NULL, NULL, 987, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1001, 'Matute, Bernabé de', NULL, NULL, 988, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1002, 'Pieri, Pietro Paolo', NULL, NULL, 989, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1003, 'Cartes y Valdivieso, Bernardo de', NULL, NULL, 990, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1004, 'Droit', NULL, NULL, 991, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1005, 'Marcellius, Heinrich', NULL, NULL, 992, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1006, 'Marcos, Miguel', NULL, NULL, 993, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1007, 'Paris, Yves de, La théologie naturelle, 4 vol. (Paris, 1633)', NULL, NULL, 994, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1008, 'Sancho Granado, José', NULL, NULL, 995, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1009, 'Corsini, Odoardo, Institutiones philosophicae ad usum scholarum piarum, 5 vols. (Bologne , ex typographia Laelii a Vulpe, 1741)', NULL, NULL, 996, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1010, 'Colegio San Ignacio (Valladolid)', NULL, NULL, 997, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1011, 'Convento dei cappuccini (Ferrara)', NULL, NULL, 998, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1012, 'Maluenda, Tomás', NULL, NULL, 999, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1013, 'Fajardo y Dávalos, Diego', NULL, NULL, 1000, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1014, 'Mantova', NULL, NULL, 1001, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1015, 'Rodríguez Malo, José', NULL, NULL, 1002, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1016, 'Médecine Théorique', NULL, NULL, 1003, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1017, 'Prieur du collège des médecins et des philosophes', NULL, NULL, 1004, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1018, 'Payueta, Gaspar de', NULL, NULL, 1005, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1019, 'Rossetti, Donato', NULL, NULL, 1006, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1020, 'Colegio de la Compañía de Jesús (Tarija)', NULL, NULL, 1007, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1021, 'Oviedo, Francisco de', NULL, NULL, 1008, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1022, 'Collège des Jésuites (Dole)', NULL, NULL, 1009, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1023, 'Cappellone, Paolo Antonio', NULL, NULL, 1010, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1024, 'Fagnani, Prospero, Jus canonicum, sive Commentaria absolutissima in V libros decretales, cum indice (Widenfeldt, 1681)', NULL, NULL, 1011, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1025, 'Oña, Pedro de', NULL, NULL, 1012, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1026, 'Genua, Marcantonio', NULL, NULL, 1013, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1027, 'Juste, Tomás', NULL, NULL, 1014, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1028, 'Ardanuy, Orencio de', NULL, NULL, 1015, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1029, 'Ribadeneira, Ignacio Vicente de', NULL, NULL, 1016, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1030, 'Thomasius, Christian', NULL, NULL, 1017, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1031, 'Colegio San Miguel (Compañía de Jesús) (Leon)', NULL, NULL, 1018, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1032, 'Brescia, Fortunato da, Elementa mathematica in quatuor tomos digesta (Brescia, 1738)', NULL, NULL, 1019, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1033, 'Cottunio, Giovanni', NULL, NULL, 1020, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1034, 'Weigel, Erhard', NULL, NULL, 1021, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1035, 'Carmes de l''antique observance', NULL, NULL, 1022, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1036, 'Abbaye Notre-Dame de Cambron (Cambron-Casteau)', NULL, NULL, 1023, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1037, 'Bellarmino, Roberto, Los cinco libros de la eterna felicidad de los Santos o del Reino de Dios, traduction espagnole par le minime Lucas de Montoya en Ms. BNE 7784 : 2. ff. 56-105 (1636)', NULL, NULL, 1024, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1038, 'Universität Helmstedt', NULL, NULL, 1025, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1039, 'Sémery, André', NULL, NULL, 1026, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1040, 'Couvent des Augustins (Bruxelles)', NULL, NULL, 1027, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1041, 'Sologuren, Miguel de', NULL, NULL, 1028, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1042, 'Menestrier, Claude-François', NULL, NULL, 1029, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1043, 'Arequipa', NULL, NULL, 1095, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1044, 'Horion, Jean de', NULL, NULL, 1167, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1045, 'Roselli, Salvatore Maria, Summa philosophica ad mentem angelici doctoriis. Thomae Aquinatis. Editio secunda, 3 vol. (Roma , Antonio Fulgonio, 1783)', NULL, NULL, 1030, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1046, 'Gadbled, Christophe', NULL, NULL, 1031, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1047, 'Montefortino, Girolamo da, Duns Scoti (...) Summa Theologica ex universis eius operis concinnata, 5 vol. (Roma, 1728)', NULL, NULL, 1032, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1048, 'Université de Toulouse, Faculté des Arts', NULL, NULL, 1033, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1049, 'Vincent, Jean', NULL, NULL, 1034, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1050, 'Puigserver, Andrés', NULL, NULL, 1035, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1051, 'Mas, Diego', NULL, NULL, 1036, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1052, 'Colegio de la Compañía de Jesús (Potosi)', NULL, NULL, 1037, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1053, 'Ituren, Tomás de', NULL, NULL, 1038, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1054, 'Baquero, Martin', NULL, NULL, 1039, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1055, 'Zara, Antonius', NULL, NULL, 1040, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1056, 'Bartoli, Sebastiano', NULL, NULL, 1041, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1057, 'Hannover', NULL, NULL, 1042, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1058, 'Collège de la Compagnie de Jésus (Nice)', NULL, NULL, 1043, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1059, 'Peñafiel, Leonardo de', NULL, NULL, 1044, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1060, 'Collège (Utrecht)', NULL, NULL, 1045, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1061, 'Colegio de San Ignacio (Compañía de Jesús) (Queretaro)', NULL, NULL, 1046, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1062, 'Preston, John', NULL, NULL, 1047, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1063, 'Studium dominicain de la Minerve (Roma)', NULL, NULL, 1048, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1064, 'Fabri, Filippo, Disputationes theologicae librum primum Sententiarum
continentes... In secundum Sententiarum complectentes materiam de
Creatione et de Angelis... In tertium Sententiarum complectentes
materiam de Incarnatione... In quartum Sententiarum complectentes ea
quae spectant ad Sacramenta in genere et in specie ad Baptismum,
Confirmatione et Eucharistiam ... in hac secunda editione ab auctore recognita (Venezia , Bartolomeo Ginammi, 1618)', NULL, NULL, 1049, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1065, 'Jesuitenkolleg (Augsburg)', NULL, NULL, 1050, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1066, 'Philippe - II', NULL, NULL, 1051, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1067, 'Vidarte, Agustín José', NULL, NULL, 1052, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1068, 'Bérulle, Marc de, Theologia universa ad mentem Scoti... iuxta ordinem Magistri Sententiarum, 12 vol. (Grenoble , Robert Philippes, 1668)', NULL, NULL, 1053, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1069, 'Alamanni, Cosma', NULL, NULL, 1054, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1070, 'Henao, Gabriel de', NULL, NULL, 1055, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1071, 'Punch, John', NULL, NULL, 1056, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1072, 'Faculté de médecine (Toulouse)', NULL, NULL, 1057, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1073, 'Abarca, Pedro', NULL, NULL, 1058, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1074, 'Collège des Jésuites (Avignon)', NULL, NULL, 1059, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1075, 'Rappi, Cristoforo', NULL, NULL, 1060, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1076, 'Mansi, Giovanni Domenico', NULL, NULL, 1061, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1077, 'Ecole lutérienne du Stift (Graz)', NULL, NULL, 1062, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1078, 'Hemelman, Jorge', NULL, NULL, 1063, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1079, 'Tubingen', NULL, NULL, 1064, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1080, 'Marín, Juan', NULL, NULL, 1065, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1081, 'Université de Göttingen', NULL, NULL, 1066, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1082, 'Conceptione, Emmanuel a', NULL, NULL, 1067, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1083, 'Flavigny, Valérien de', NULL, NULL, 1068, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1084, 'Tessaneck, Franz', NULL, NULL, 1069, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1085, 'Colegio de la Compañía de Jesús (Palencia)', NULL, NULL, 1070, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1086, 'Bruni, Celestino', NULL, NULL, 1071, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1087, 'Professeur extraordinaire de philosophie naturelle (Université de Padoue)', NULL, NULL, 1072, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1088, 'Crespo, Andrés', NULL, NULL, 1073, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1089, 'Sperling, Johannes', NULL, NULL, 1074, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1090, 'Viñas, Miguel', NULL, NULL, 1075, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1091, 'Hickey, Anthony', NULL, NULL, 1076, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1092, 'Polizzi, Giuseppe, Disputationes in universam philosophiam (Palerme, 1675)', NULL, NULL, 1077, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1093, 'Faculté de théologie de Bologna', NULL, NULL, 1078, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1094, 'Supérieur général des Piaristes', NULL, NULL, 1079, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1095, 'Avilés, Pedro de', NULL, NULL, 1080, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1096, 'Gymnasium (Bremen)', NULL, NULL, 1081, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1097, 'Loudun', NULL, NULL, 1082, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1098, 'Saint-Léger, Diego de', NULL, NULL, 1083, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1099, 'Brisighella', NULL, NULL, 1084, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1100, 'Diocèse de Teramo', NULL, NULL, 1085, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1101, 'Egues, Baltasar', NULL, NULL, 1086, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1102, 'Arcayna, Juan Bautista', NULL, NULL, 1087, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1103, 'Schmalz, Valentin', NULL, NULL, 1088, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1104, 'Lippomano, Niccolò', NULL, NULL, 1089, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1105, 'Lippomano, Pietro', NULL, NULL, 1090, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1106, 'Holzhai, Georg', NULL, NULL, 1091, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1107, 'Colegio San Ambrosio (Valladolid)', NULL, NULL, 1092, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1108, 'Innsbruck', NULL, NULL, 1093, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1109, 'Lecce', NULL, NULL, 1094, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1110, 'Reimarus Ursus, Nicolaus', NULL, NULL, 1096, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1111, 'Avendaño, Diego de', NULL, NULL, 1097, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1112, 'Universität (Konigsberg)', NULL, NULL, 1098, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1113, 'Université d''Uppsala', NULL, NULL, 1099, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1114, 'Montagnolo, Giovanni Domenico', NULL, NULL, 1100, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1115, 'Quirini, Lauro', NULL, NULL, 1101, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1116, 'Tomassi, Giovanni Antonio', NULL, NULL, 1102, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1117, 'Quaestionum theologicarum libri sex, 6 vol. (Roma, 1676)', NULL, NULL, 1103, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1118, 'Terill, Anthony', NULL, NULL, 1104, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1119, 'Eiselin, Michael', NULL, NULL, 1105, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1120, 'Porrentruy', NULL, NULL, 1106, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1121, 'Monastère des franciscains récollets (Douai)', NULL, NULL, 1107, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1122, 'Olea, Nicolás de', NULL, NULL, 1108, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1123, 'Recupito, Giulio Cesare, ractatus primus de Deo uno. Pars prima et secunda, 2 vols (Neapoli , apud Octavium Beltranum Impressor, 1637)', NULL, NULL, 1109, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1124, 'Bonarte, Thomas', NULL, NULL, 1110, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1125, 'Lauvaux, J.', NULL, NULL, 1111, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1126, 'Gotha', NULL, NULL, 1112, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1127, 'Dupuy, Jean', NULL, NULL, 1113, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1128, 'Diocèse de Volturara (Volturarien-sis)', NULL, NULL, 1114, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1129, 'Agostini, Giuseppe', NULL, NULL, 1115, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1130, 'Nocera Inferiore', NULL, NULL, 1116, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1131, 'Baumeister, Friedrich Christian', NULL, NULL, 1117, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1132, 'Universität Duiburg', NULL, NULL, 1118, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1133, 'Marcillo, Manuel', NULL, NULL, 1119, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1134, 'Desgabets, Robert', NULL, NULL, 1120, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1135, 'Collegium Clementinum, Université jésuite (Prague)', NULL, NULL, 1121, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1136, 'Besançon', NULL, NULL, 1122, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1137, 'Young, Patrick', NULL, NULL, 1123, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1138, 'Hermann, Georg', NULL, NULL, 1124, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1139, 'Sánchez, Alonso', NULL, NULL, 1125, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1140, 'Visconti, Raffaello', NULL, NULL, 1126, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1141, 'Soldo, Mauro', NULL, NULL, 1127, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1142, 'Baronio, Cesare', NULL, NULL, 1128, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1143, 'Peñafiel, Ildefonso de', NULL, NULL, 1129, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1144, 'Galilei, Ruberto', NULL, NULL, 1130, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1145, 'Rufo, José', NULL, NULL, 1131, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1146, 'Forlì', NULL, NULL, 1132, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1147, 'Agramunt, Pascual de', NULL, NULL, 1133, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1148, 'Collège de la Trinité (Louvain)', NULL, NULL, 1134, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1149, 'Solano, Juan', NULL, NULL, 1135, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1150, 'Medina De Rioseco', NULL, NULL, 1136, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1151, 'Xavierre, Jerónimo', NULL, NULL, 1137, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1152, 'Garnier, Jean', NULL, NULL, 1138, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1153, 'Porzio, Lucantonio', NULL, NULL, 1139, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1154, 'Aguayo, Lupercio', NULL, NULL, 1140, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1155, 'Dini, Piero', NULL, NULL, 1141, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1156, 'Montalvo, Juan de', NULL, NULL, 1142, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1157, 'Philosophie scolastique', NULL, NULL, 1143, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1158, 'Quiroga', NULL, NULL, 1144, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1159, 'Ypres', NULL, NULL, 1145, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1160, 'Lucca', NULL, NULL, 1146, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1161, 'Cardinal secrétaire de la Congrégation du Saint-Office', NULL, NULL, 1147, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1162, 'Charlet, Etienne', NULL, NULL, 1148, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1163, 'Algaba, Juan de', NULL, NULL, 1149, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1164, 'Université de Kosice, Collegium Cassoviense (Compagnie de Jésus)', NULL, NULL, 1150, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1165, 'Perera, Benet', NULL, NULL, 1151, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1166, 'Collège des Jésuites (Aix-en-Provence)', NULL, NULL, 1152, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1167, 'Suárez, Sebastián', NULL, NULL, 1153, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1168, 'Cabrera, Pedro de', NULL, NULL, 1154, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1169, 'Haddington', NULL, NULL, 1155, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1170, 'Ottoboni, Pietro', NULL, NULL, 1156, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1171, 'Bérulle, Marc de, Briefve et claire explication de toute la sainte Bible selon le sens littéral, 3 vol. in-fol. (Grenoble, 1679)', NULL, NULL, 1157, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1172, 'Gandillon, François', NULL, NULL, 1158, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1173, 'Hunger, Albert', NULL, NULL, 1159, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1174, 'Jesuiten (Graz)', NULL, NULL, 1160, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1175, 'Jesuiten (Freiburg)', NULL, NULL, 1161, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1176, 'Siège inquisitorial de Brescia', NULL, NULL, 1162, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1177, 'Nonciature de Toscane', NULL, NULL, 1163, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1178, 'Université San Marcos (Lima)', NULL, NULL, 1164, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1179, 'Colegio Máximo de San Miguel (Compañía de Jesús) (Santiago de Chile)', NULL, NULL, 1165, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1180, 'Alciati, Terenzio', NULL, NULL, 1166, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1181, 'Goudin, Antoine', NULL, NULL, 1168, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1182, 'Descartes, René', NULL, NULL, 1169, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1183, 'Garasse, François', NULL, NULL, 1170, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1184, 'Chanevelle, Jacques, Physica particularis iuxta principia Aristotelis, 3 tomes (Paris , Edmond Martin, 1669)', NULL, NULL, 1171, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1185, 'Universidad de Salamanca, Facultad de Leyes', NULL, NULL, 1172, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1186, 'Esquivel, Pedro de', NULL, NULL, 1173, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1187, 'Munster (westfalen)', NULL, NULL, 1174, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1188, 'Sauli, Alessandro Pio', NULL, NULL, 1175, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1189, 'Rotterdam', NULL, NULL, 1176, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1190, 'Lariz, Esteban', NULL, NULL, 1177, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1191, 'Guilleminot, Jean', NULL, NULL, 1178, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1192, 'Maura, Pedro', NULL, NULL, 1179, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1193, 'Gamba, Marina', NULL, NULL, 1180, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1194, 'Morejón, Diego', NULL, NULL, 1181, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1195, 'Gutmayer, Andreas', NULL, NULL, 1182, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1196, 'Perpinan, Pedro Juan', NULL, NULL, 1183, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1197, 'Céspedes, Valentín de', NULL, NULL, 1184, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1198, 'Brancacio de Caravinea, Clemens, De Deo trino et uno tomus primus, in quo agitur de
absolutis ubi germana Scoti mens aperitur atque ad eius institutum
disceptatur. Tomus secundus in quo agitur de respectivis sive de tribus
personis divinis (Neapoli, 1638)', NULL, NULL, 1185, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1199, 'Collegio dei Gesuiti / Jesuitenkolleg (Trento)', NULL, NULL, 1186, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1200, 'Collège de Saint-Vaast (Douai)', NULL, NULL, 1187, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1201, 'Paris, Yves de, Les morales chrétiennes, 4 vol. (Paris, 1638)', NULL, NULL, 1188, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1202, 'Colegio Máximo de San Pedro y San Pablo (Compañía de Jesús) (Mexico)', NULL, NULL, 1189, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1203, 'Rabe, Paul', NULL, NULL, 1190, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1204, 'Vilar, Tomás', NULL, NULL, 1191, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1205, 'Royaume de Suède', NULL, NULL, 1192, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1206, 'Wadding, Peter', NULL, NULL, 1193, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1207, 'Burghausen', NULL, NULL, 1194, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1208, 'Thomassin, Louis', NULL, NULL, 1195, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1209, 'Herice, Valentín de', NULL, NULL, 1196, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1210, 'Abad, Agustin', NULL, NULL, 1197, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1211, 'Castro, Cristobal de', NULL, NULL, 1198, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1212, 'Sforza Pallavicino, Pietro, Vera Concilii Tridentini Historia, contra falsam Petri Suavis Polani narrationem, trad. latine par J. B. Giattino, 3 en 1 vol. (Cologne , Franz Metternich, 1717)', NULL, NULL, 1199, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1213, 'Barbiano, Giovanni (Juan)', NULL, NULL, 1200, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1214, 'Contenson, Vincent, Theologia mentis et cordis seu speculationes universae doctrinae sacrae (Lyon, 1668)', NULL, NULL, 1201, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1215, 'Ruiz, Diego', NULL, NULL, 1202, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1216, 'Coutances', NULL, NULL, 1203, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1217, 'Cattaneo, O.', NULL, NULL, 1204, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1218, 'Báñez, Domingo, Scholastica commentaria in primam partem angelici doctoris S. Thomae (Venise, 1585)', NULL, NULL, 1205, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1219, 'Monasterio y Colegio San Vicente (Salamanque)', NULL, NULL, 1206, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1220, 'Collège de la Compagnie de Jésus (Antwerpen)', NULL, NULL, 1207, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1221, 'Soares, Francisco', NULL, NULL, 1208, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1222, 'Iribarren, Antonio, Cursus philosophicus, 4 vol. (Caesaraugustae, 1695)', NULL, NULL, 1209, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1223, 'Petau, Denis', NULL, NULL, 1210, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1224, 'Trieu, Philippe Du', NULL, NULL, 1211, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1225, 'Galilei, Michele', NULL, NULL, 1212, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1226, 'Orsi, Stefano', NULL, NULL, 1213, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1227, 'Limoges', NULL, NULL, 1214, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1228, 'Mazzolini, Silvestro - da Prierio', NULL, NULL, 1215, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1229, 'Colegio de la Compañía de Jesús (La Paz)', NULL, NULL, 1216, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1230, 'Azor, Juan, Institutionum moralium in quibus universae quaestiones ad conscientiae recte aut prave factorum pertinentes, breviter tractantur. Pars prima, Editio postremo caeterarum omnium tersissima, 3 t. (Lugduni, 1610)', NULL, NULL, 1217, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1231, 'Juan, Ignacio', NULL, NULL, 1218, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1232, 'Dolz del Castellar, Esteban', NULL, NULL, 1219, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1233, 'Mastri, Bartolomeo, Disputationes in XII libros Metaphysicorum, 2 vol. (Venezia , Ginammi, 1646)', NULL, NULL, 1220, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1234, 'Ridolfi, Niccolò Luigi', NULL, NULL, 1221, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1235, 'Bukentop, Henri de', NULL, NULL, 1222, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1236, 'Dioecesis Biturgensis seu Burgi Sancti Sepulchri', NULL, NULL, 1223, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1237, 'Carmes déchaussés', NULL, NULL, 1224, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1238, 'Alvares, Baltasar', NULL, NULL, 1225, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1239, 'García, Domingo', NULL, NULL, 1226, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1240, 'Aguirre, Juan Antonio de', NULL, NULL, 1227, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1241, 'Rodríguez, Luis', NULL, NULL, 1228, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1242, 'Cambron-Casteau', NULL, NULL, 1229, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1243, 'Memmoli, Decio', NULL, NULL, 1230, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1244, 'Lancioni, Antonio', NULL, NULL, 1231, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1245, 'Potosi', NULL, NULL, 1298, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1246, 'Summa philosophiae scholasticae et scotisticae, 4 volumes (Lyon , Briasson, 1692)', NULL, NULL, 1232, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1247, 'Isola di Capo Rizzuto', NULL, NULL, 1233, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1248, 'Molina, Baltasar de', NULL, NULL, 1234, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1249, 'Collège de Standonk (Louvain)', NULL, NULL, 1235, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1250, 'Ornans', NULL, NULL, 1236, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1251, 'Martini, Jakob', NULL, NULL, 1237, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1252, 'Socini (Sozzini, Socinus), Fausto', NULL, NULL, 1238, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1253, 'Vinyes, Domènec', NULL, NULL, 1239, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1254, 'Bonfigli, Giacinto', NULL, NULL, 1240, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1255, 'Medina Del Campo', NULL, NULL, 1241, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1256, 'Arriaga, Rodrigo de, Disputationes theologicae, 8 vol. (Anvers, 1643)', NULL, NULL, 1242, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1257, 'Varela, José', NULL, NULL, 1243, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1258, 'Ragusa', NULL, NULL, 1244, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1345, 'Dagoumer, Guillaume, Philosophia ad usum scholae accomodata, 3 vol. (Paris , P. Aubouin, C. Clousier &amp;amp; B. Girin, 1702)', NULL, NULL, 1332, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1602, 'Szczecin', NULL, NULL, 1587, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1259, 'Durand, Barthélémy, Clypeus scoticae theologiae contra nova eius impugnatores... Tomus primus de Deo uno et trino, editio novissima... Tomus secundus continens tractatus de angelis, de homine, de beatitudine, de Actibus humanis, eorumque moralitate,
et de vitiis et peccatis... Tomus tertius continens tractatus de gratia, de virtutibus, et de Incarnatione verbi divini Tomus quartus continens tractatus de sacramentis, 4 vol. (Marseille , C. Brebion, 1685)', NULL, NULL, 1245, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1260, 'Álvarez, Diego, Commentarii in Isaiam, 2 vol. (Roma, 1599)', NULL, NULL, 1246, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1261, 'Gymnasium illustre (Steinfurt)', NULL, NULL, 1247, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1262, 'Melo, Gaspar de', NULL, NULL, 1248, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1263, 'Castro, Melchor de', NULL, NULL, 1249, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1264, 'Mastri, Bartolomeo, Disputationes theologicae in libros sententiarum quibus ab
adversantibus tum veterum tum recentiorum iaculis Scoti theologia
vindicatur, 4 vol. (1655)', NULL, NULL, 1250, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1265, 'Roselli, Salvatore Maria', NULL, NULL, 1251, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1266, 'Bartoli, Daniello', NULL, NULL, 1252, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1267, 'Magnen, Jean-Chrysostome', NULL, NULL, 1253, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1268, 'Cambridge', NULL, NULL, 1254, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1269, 'Taurellus, Nikolaus', NULL, NULL, 1255, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1270, 'Géographie', NULL, NULL, 1256, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1271, 'Morell, Josep', NULL, NULL, 1257, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1272, 'Martinon, Jean', NULL, NULL, 1258, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1273, 'Navarrete', NULL, NULL, 1259, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1274, 'Université de Salerno', NULL, NULL, 1260, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1275, 'Bono y Casasús, Francisco', NULL, NULL, 1261, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1276, 'Innocenzi, Antonio Leonardo', NULL, NULL, 1262, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1277, 'Turrettini, François', NULL, NULL, 1263, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1278, 'Académie protestante de Saumur', NULL, NULL, 1264, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1279, 'Collège jésuite (Polatsk)', NULL, NULL, 1265, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1280, 'Casati, Gio. Paolo, Vacuum proscriptum (Genuae , Ioannes D. Peri, 1649)', NULL, NULL, 1266, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1281, 'Ath', NULL, NULL, 1267, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1282, 'Brescia, Fortunato da, Elementa mathematica in quatuor tomos digesta (Brescia, 1755)', NULL, NULL, 1268, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1283, 'Medici, Girolamo de, Formalis explicatio Summae theologiae D. Thomae Aquinatis Doctoris Angelici tribus partibus absoluta, 1ère éd. (1614)', NULL, NULL, 1269, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1284, 'Leon', NULL, NULL, 1270, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1285, 'Alcaraz', NULL, NULL, 1271, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1286, 'Académie de Deventer', NULL, NULL, 1272, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1287, 'Granado, Diego', NULL, NULL, 1273, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1288, 'Brenz, Johannes', NULL, NULL, 1274, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1289, 'Neubauer, Georg', NULL, NULL, 1275, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1290, 'Galilei, Michelangiolo', NULL, NULL, 1276, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1291, 'Tortona', NULL, NULL, 1277, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1292, 'Baena, Gaspar', NULL, NULL, 1278, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1293, 'Collèges des Jésuites (Porrentruy)', NULL, NULL, 1279, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1294, 'Bruges', NULL, NULL, 1280, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1295, 'Henri de Saint-Ignace', NULL, NULL, 1281, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1296, 'Jimenez Royo, Diego', NULL, NULL, 1282, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1297, 'Claire, Jean de', NULL, NULL, 1283, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1298, 'Pagés, Magín', NULL, NULL, 1284, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1299, 'Wietrowski, Maximilian', NULL, NULL, 1285, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1300, 'Manresa', NULL, NULL, 1286, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1301, 'Saint-Omer', NULL, NULL, 1287, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1302, 'Escalera, Pedro de', NULL, NULL, 1288, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1303, 'Elbe', NULL, NULL, 1289, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1304, 'Amico, Francesco', NULL, NULL, 1290, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1305, 'Julián, Jerónimo', NULL, NULL, 1291, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1306, 'Grindl, Wolfgang', NULL, NULL, 1292, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1307, 'Tarija', NULL, NULL, 1293, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1308, 'Navarro, Joaquín', NULL, NULL, 1294, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1309, 'Chaves', NULL, NULL, 1295, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1310, 'Hohe Schule Herborn (Academia Nassauensis)', NULL, NULL, 1296, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1311, 'Angoulême', NULL, NULL, 1297, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1312, 'Ammannati, Giulia', NULL, NULL, 1299, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1313, 'Patrizi, Francesco - da Cherso', NULL, NULL, 1300, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1314, 'Rinaldini, Carlo', NULL, NULL, 1301, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1315, 'Histoire', NULL, NULL, 1302, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1316, 'Soria', NULL, NULL, 1303, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1317, 'Collège des Jésuites (Clermont-Ferrand)', NULL, NULL, 1304, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1318, 'Université Lutérienne d''Altdorf', NULL, NULL, 1305, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1319, 'Pavia', NULL, NULL, 1306, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1320, 'Antequera', NULL, NULL, 1307, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1321, 'Puig, Josep', NULL, NULL, 1308, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1322, 'Galilei, Benedetto', NULL, NULL, 1309, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1323, 'Ribera, Jerónimo de', NULL, NULL, 1310, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1324, 'Zuanelli, Giovanni Benedetto', NULL, NULL, 1311, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1325, 'Summa theologiae scotisticae, 8 volumes (Padova , Manfrè, 1719)', NULL, NULL, 1312, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1326, 'Prado, Manuel de', NULL, NULL, 1313, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1327, 'Álvarado, Juan de', NULL, NULL, 1314, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1328, 'Volpi, Angelo, Sacra theologiae summa Ioannis Duns Scoti Doctoris Subtilissimi et commentaria quibus eius doctrina elucidatur, comprobatur, defenditur, 12 vols (Neapoli , apud Lazarum Scorigium, Anelli Cassetae, Camilli Cavalli, 1622)', NULL, NULL, 1315, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1329, 'Vlacic (Flacius), Matija', NULL, NULL, 1316, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1330, 'Camarda, Antonio Serafino', NULL, NULL, 1317, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1331, 'Collège Saint-Michel (Compagnie de Jésus) (Bruxelles)', NULL, NULL, 1318, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1332, 'Hanau', NULL, NULL, 1319, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1333, 'Virieu-le-Grand', NULL, NULL, 1320, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1334, 'Mastri, Bartolomeo, Compilatio præcipuarum disputationum, et quæstionum, cum suis probabilioribus opinionibus Theologiæ moralis a. r. p. m. B.M, 4 vol. (Girona, 1680)', NULL, NULL, 1321, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1335, 'Colegio de Belén (Compañía de Jesús) (Barcelona)', NULL, NULL, 1322, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1336, 'Ochoa, Juan de', NULL, NULL, 1323, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1337, 'Sforza Pallavicino, Pietro, Istoria del Concilio di Trento, 2 vol. (1656)', NULL, NULL, 1324, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1338, 'Henneguier, Jérôme', NULL, NULL, 1325, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1339, 'Plano, Gaspar del', NULL, NULL, 1326, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1340, 'Universidad de Huesca', NULL, NULL, 1327, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1341, 'Rodríguez, Alfonso', NULL, NULL, 1328, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1342, 'Millieu, Antoine', NULL, NULL, 1329, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1343, 'Couvent des Jacobins (Dominicains) (Toulouse)', NULL, NULL, 1330, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1344, 'Jamieu, Joseph', NULL, NULL, 1331, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1346, 'Riva, Raffaele', NULL, NULL, 1333, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1347, 'Vázquez de Belmonte, Francisco', NULL, NULL, 1334, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1348, 'Gerace', NULL, NULL, 1335, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1349, 'Agelli, Paolo Antonio', NULL, NULL, 1336, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1350, 'Rubio, Antonio', NULL, NULL, 1337, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1351, 'Piaristes', NULL, NULL, 1338, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1352, 'Zenner, Albert', NULL, NULL, 1339, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1353, 'Boyvin, Jean Gabriel, Theologia scoti a prolixitate et subtilitas eius ab obscuritate libera et vindicata, 4 vol. (Caen , M. Yvon, 1665)', NULL, NULL, 1340, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1354, 'Trento', NULL, NULL, 1341, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1355, 'Uncastillo', NULL, NULL, 1342, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1356, 'Universitas Tyrnaviensis (Societatis Iesu) (Trnava)', NULL, NULL, 1343, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1357, 'Université d''Ettal', NULL, NULL, 1344, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1358, 'Robles, Benito de', NULL, NULL, 1345, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1359, 'Baldini, Arcangelo', NULL, NULL, 1346, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1360, 'Salablanca, Cristobal de', NULL, NULL, 1347, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1361, 'Zúñiga, Francisco de', NULL, NULL, 1348, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1362, 'Rinaldini, Carlo, Ars analytica mathematum in tres partes distributa (Firenze / Padova, ex typographia Iosephi Cocchini ad insigne Stellae / typis Petri Mariae Frambotti bibliopolae (vol. 2-3), 1668)', NULL, NULL, 1349, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1363, 'Valencia, Gregorio de', NULL, NULL, 1350, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1364, 'Ortega y Rojillo, Cristóbal de', NULL, NULL, 1351, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1365, 'Gravina, Domenico', NULL, NULL, 1352, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1366, 'Cuzco', NULL, NULL, 1353, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1367, 'Cappasanta, Pio Felice', NULL, NULL, 1354, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1368, 'Dominikanerkloster Heilig Kreuz (Köln)', NULL, NULL, 1355, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1369, 'Capponi, Serafino, Commentarii in Psalterium Davidicum. Opus posthumum, 4 vol. (Bologna , Typografia S. Tommaso d''Aquino, 1736)', NULL, NULL, 1356, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1370, 'Carbone, Ludovico', NULL, NULL, 1357, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1371, 'Moncé, Philippe', NULL, NULL, 1358, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1372, 'Lemos, Thomas de', NULL, NULL, 1359, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1373, 'Vautrin, Christophe', NULL, NULL, 1360, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1374, 'Prévost, Jean Le', NULL, NULL, 1361, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1375, 'Colegio de la Compañía de Jesús (Jaén)', NULL, NULL, 1362, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1376, 'Fédé, René', NULL, NULL, 1522, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1377, 'Lázarraga, Jerónimo José de', NULL, NULL, 1363, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1378, 'Waterford', NULL, NULL, 1364, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1379, 'Université de Kosice', NULL, NULL, 1365, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1380, 'Lambert, Louis', NULL, NULL, 1366, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1381, 'Université de Santiago', NULL, NULL, 1367, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1382, 'Bologne', NULL, NULL, 1368, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1383, 'Colegio de la Compañía de Jesús (Juli)', NULL, NULL, 1369, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1384, 'Höss, Tobias', NULL, NULL, 1370, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1385, 'Prada, Pedro de', NULL, NULL, 1371, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1386, 'Briceño, Alonso, Celebriores controversias in primum Sententiarum Ioannis Duns Scoti Doctoris subtilis Theologorum facile Principis, 2 vol. (Madriti, 1638)', NULL, NULL, 1372, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1387, 'La Paz', NULL, NULL, 1373, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1388, 'Siège inquisitorial de Siena', NULL, NULL, 1374, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1389, 'Collegio dei Gesuiti (Messina)', NULL, NULL, 1375, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1390, 'Trinità dei Monti (Roma)', NULL, NULL, 1376, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1391, 'Celaya, Juan de, Expositio in primum tractatum Summularum magistri Petri Hispani (Valentiae, 1529)', NULL, NULL, 1377, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1392, 'Palma', NULL, NULL, 1378, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1393, 'Villalon De Campos', NULL, NULL, 1379, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1394, 'Lubeck', NULL, NULL, 1380, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1395, 'Marchant, Pierre', NULL, NULL, 1381, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1396, 'Lorini, Jean de', NULL, NULL, 1382, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1397, 'Galilei, Antonio', NULL, NULL, 1383, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1398, 'Diocèse de Molfetta (Melphiten-sis)', NULL, NULL, 1384, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1399, 'Benavente', NULL, NULL, 1385, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1400, 'Volturara Irpina', NULL, NULL, 1386, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1401, 'Fourmestraux, François de', NULL, NULL, 1387, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1402, 'Aguirre, Juan Bautista de', NULL, NULL, 1388, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1403, 'Malaga', NULL, NULL, 1389, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1404, 'Edisford, John', NULL, NULL, 1390, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1405, 'Strenzi, Eustachius', NULL, NULL, 1391, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1406, 'Régent des études', NULL, NULL, 1392, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1407, 'Desmarets, Samuel', NULL, NULL, 1393, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1408, 'Azor, Juan, Institutionum moralium in quibus universae quaestiones ad conscientiae recte aut prave factorum pertinentes, breviter tractantur. Pars prima, Nunc primum in Germaniae editae, 3 t. (Coloniae Agrippinae, 1613)', NULL, NULL, 1394, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1409, 'Garau, Francesc', NULL, NULL, 1395, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1410, 'Mangold, Josef', NULL, NULL, 1396, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1411, 'Araujo, Ildefonso', NULL, NULL, 1397, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1412, 'Sturm, Johannes', NULL, NULL, 1398, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1413, 'Cambrai', NULL, NULL, 1399, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1414, 'Fournenc, Jacques', NULL, NULL, 1400, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1415, 'Sforza Pallavicino, Pietro, Istoria del Concilio di Trento, 6 vol. (S.L. , ed. F.A. Zaccaria, 1792)', NULL, NULL, 1401, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1416, 'Vecchietti, Girolamo', NULL, NULL, 1402, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1417, 'Fasson, Tomás', NULL, NULL, 1403, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1418, 'Lozano, Esteban', NULL, NULL, 1404, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1419, 'Simon, Johann Georg', NULL, NULL, 1405, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1420, 'Clavius, Christopher, Opera mathematica V tomis distributa (Mainz, 1611)', NULL, NULL, 1406, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1421, 'Mayr, Anton', NULL, NULL, 1407, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1422, 'Collège de maître Gervais (Paris)', NULL, NULL, 1408, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1423, 'Antoine, Paul Gabriel', NULL, NULL, 1409, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1424, 'Escazena, Juan de', NULL, NULL, 1410, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1425, 'Collège anglais (Saint-Omer)', NULL, NULL, 1411, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1426, 'Krisper, Crescentius', NULL, NULL, 1412, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1427, 'Cornejo de Pedrosa, Pedro, Publici Salamanticensis Academiae cathedrarii diversarum materiarum quas in eodem gymnasio dictavit, 2 vols. (Pintia, 1628)', NULL, NULL, 1413, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1428, 'Vargas, Bernardo de', NULL, NULL, 1414, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1429, 'Sforza Pallavicino, Pietro, Istoria del Concilio di Trento, 3 vol. (1663)', NULL, NULL, 1415, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1430, 'Pendasio, Federico', NULL, NULL, 1416, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1431, 'Université de Toulouse', NULL, NULL, 1417, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1432, 'Bernique, Juan', NULL, NULL, 1418, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1433, 'Oñate, Pedro de', NULL, NULL, 1419, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1434, 'Ruiz de Solano, Diego', NULL, NULL, 1420, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1435, 'Convento de San Francisco (Totimihuacán)', NULL, NULL, 1421, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1436, 'Bartholinus, Kaspar', NULL, NULL, 1422, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1437, 'Pinelli, Francesco', NULL, NULL, 1423, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1438, 'Villanueva, José de', NULL, NULL, 1424, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1439, 'Collège Saint Thomas (Strasbourg)', NULL, NULL, 1425, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1440, 'Vignola ', NULL, NULL, 1426, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1441, 'Summules', NULL, NULL, 1427, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1442, 'Dias Franco, Luíz', NULL, NULL, 1428, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1443, 'Vives, Juan Luis, De initiis, sectis et laudibus philosophiae (1518)', NULL, NULL, 1659, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1444, 'Bancel, Louis, Brevis universae theologiae tam moralis quam scholasticae
cursus iuxta inconcussa tutissimaque Doctoris Angelici D. Thomae dogmata, 6 vol., la fin du cours a été éditée à titre posthume par son correligionnaire Joseph Patin. (Avignon , Pierre Offray, 1684)', NULL, NULL, 1429, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1445, 'La Plata', NULL, NULL, 1430, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1446, 'Troyes', NULL, NULL, 1431, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1447, 'Convento dei cappuccini (Fidenza)', NULL, NULL, 1432, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1448, 'Sionite, Gabriel', NULL, NULL, 1433, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1449, 'Maffei, Marco', NULL, NULL, 1434, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1450, 'Montmorency, Florent de', NULL, NULL, 1435, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1451, 'Fabri, Filippo, Disputationes theologicae librum primum Sententiarum
continentes... In secundum Sententiarum complectentes materiam de
Creatione et de Angelis... In tertium Sententiarum complectentes
materiam de Incarnatione... In quartum Sententiarum complectentes ea
quae spectant ad Sacramenta in genere et in specie ad Baptismum,
Confirmatione et Eucharistiam (Venezia , Bartolomeo Ginammi, 1613)', NULL, NULL, 1436, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1452, 'Brière, Etienne', NULL, NULL, 1437, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1453, 'Molfetta', NULL, NULL, 1438, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1454, 'Collège anglais (Douai)', NULL, NULL, 1439, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1455, 'Juli', NULL, NULL, 1440, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1456, 'Bellarmino, Roberto, Los dos libros del arte de bien morir, traduction espagnole par le minime Lucas de Montoya en Ms. BNE 7784 : 3. f. 107-164 (1636)', NULL, NULL, 1441, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1457, 'Slevogt, Paul', NULL, NULL, 1442, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1458, 'Meisner, Balthasar', NULL, NULL, 1443, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1459, 'Alicante', NULL, NULL, 1444, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1460, 'Covilha', NULL, NULL, 1445, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1461, 'Vitoria, Francisco de', NULL, NULL, 1446, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1462, 'Muniesa, Tomás', NULL, NULL, 1447, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1463, 'Brasavola, Ireneo', NULL, NULL, 1448, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1464, 'Padilla, Antonio de', NULL, NULL, 1449, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1465, 'Junius (Andrew Young), Andreas', NULL, NULL, 1450, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1466, 'Rhodes, Georges de', NULL, NULL, 1451, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1467, 'Aix-en-Provence', NULL, NULL, 1452, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1468, 'Muro, Salvador', NULL, NULL, 1453, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1469, 'Lherminier, Nicolas', NULL, NULL, 1454, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1470, 'Collège de Navarre, Paris', NULL, NULL, 1455, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1471, 'Trevi (PG)', NULL, NULL, 1456, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1472, 'Gent', NULL, NULL, 1457, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1473, 'Ribadeneira, Gaspar de', NULL, NULL, 1458, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1474, 'Clemens VIII', NULL, NULL, 1459, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1475, 'Buenaventura, Francisco', NULL, NULL, 1460, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1476, 'Grand Couvent des Cordeliers de Paris', NULL, NULL, 1461, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1477, 'Ordeñana, Miguel Ignacio de', NULL, NULL, 1462, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1478, 'Hemmerlin, Anton', NULL, NULL, 1463, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1479, 'López, Blasco', NULL, NULL, 1464, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1480, 'Launoy, Jean de', NULL, NULL, 1465, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1481, 'Souchay, Maître', NULL, NULL, 1466, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1482, 'Armsfeld', NULL, NULL, 1467, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1483, 'Zabarella Giacomo, Commentarii in III. Aristotelis libros de anima, Frankfrut a. M. 1606, sumptibus Lazari Zetzneri bibliopolae (réimpression Frankfurrt a. M., Minerva, 1966). (1606)', NULL, NULL, 1468, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1484, 'Barbay, Pierre, Commentarius in Aristotelis Metaphysicam (Parisiis, 1675)', NULL, NULL, 1469, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1485, 'Baron, Vincent, Duo postremi apologiae libri, quibus praeter defensionem
familiae dominicanae et scholae thomiticae et plures dogmatum et morum
iuris
factique quaestiones addita sunt compendium Pii V vitae, et
supplementum vitae Bartholomaei a Martyribus ex Lusitana historia, quo
Gallica confirmatur, et Responsio ad novas Launoii obiectiones.
Exercitatio in postremum quintae partis epistolarum Joh. Launoii ad
Thomam
Fortinum parisiensem theologum (Paris, 1666)', NULL, NULL, 1470, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1486, 'Académie des sciences (Paris)', NULL, NULL, 1471, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1487, 'Stockholm', NULL, NULL, 1472, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1488, 'Baronius, Robert, Philosophia theologiae ancillans (Saint Andrews, 1621)', NULL, NULL, 1473, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1489, 'Compton Carleton, Thomas, Disputationes in tres libros Aristotelis de anima. Editions partielles (Salamanca, 1717)', NULL, NULL, 1474, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1490, 'Buffier, Claude, Cours de sciences, sur les principes nouveaux et simples, pour
former le langage, l''esprit et le cœur, dans l''usage ordinaire de la vie (Paris , Guillaume Cavelier &amp; Pierre-François Giffart, 1732)', NULL, NULL, 1475, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1491, 'Machin de Aquena, Ambrogio, Commentarii una cum disputationibus in primam partem Sancti Thomae. Tomus secundus-tertius (Cagliari , Bartolomeo Giobetti, 1634)', NULL, NULL, 1476, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1492, 'Riccioli, Giovanni Battista, Geographicae nucis fabrica et virus ad repraesentandam... omnem
dierum noctiumque ortuum solis &amp;amp; occasuum... &amp;amp; descernendas
reprones eclipsibus... idoneas : Accessere exemple ergo eclipses toto
hoc saeculo (Bologna, 1643)', NULL, NULL, 1477, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1493, 'Sforza Pallavicino, Pietro, De universa philosophia a marchione Sfortia Pallavicino publice asserta in Collegio Romano Societatis Iesu libri III ad Urbanum VIII (Romae, 1625)', NULL, NULL, 1478, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1494, 'Clemente, Juan', NULL, NULL, 1479, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1495, 'Bartoli, Sebastiano, Astronomiae microcosmicae systema novum, cui accessit exercitationum paradoxicarum decas in eversionem scholasticae medicinae, s.l. 1650. (1650)', NULL, NULL, 1480, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1496, 'Lestocq, Nicolas de', NULL, NULL, 1660, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1497, 'David, Pierre, La philosophie, dans un ordre nouveau, qui fait connaître
en peu de temps et en peu de paroles la nature de l''être, de la substance et de l''accident (Paris , François Le Cointe, 1664)', NULL, NULL, 1481, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1498, 'Collegium Complutense, Dialecticae institutiones sive logica parva (Compluti, 1694)', NULL, NULL, 1482, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1499, 'Suarez Francisco, Opus de triplici virtute theologia, fide, spe et charitate. Tractatus primi de fide theologica, Paris 1621. (1621)', NULL, NULL, 1483, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2991, 'Zeuchfeld', NULL, NULL, 2977, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1500, 'Brescia, Fortunato da, Philosophia mentis methodice tractata atque ad usus academicos accomodata, tomus 2 : Metaphysica (Brescia, 1749)', NULL, NULL, 1484, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1501, 'Dietzinger, Peter', NULL, NULL, 1485, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1502, 'Saint-Paul, Eustache de, Summa philosophiae quadripartita, de rebus dialecticis, moralibus et metaphysicis (Parisiis, 1623)', NULL, NULL, 1486, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1503, 'Cardillo de Villalpando, Gaspar, Commentarius in Aristotelis logica (Compluti, 1577)', NULL, NULL, 1487, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1504, 'Agnani, Giovanni Domenico, Epistola ad amicum circa systemata Physices, quae his diebus grandescunt in Scholis, ab eodem Autoris Amico in gratiam Peripateticae Scholae Candidatorum in lucem edita, Bononiae : typis Constantini Pifarri, sub Signo S. Michaelis, 1717 (1717)', NULL, NULL, 1488, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1505, 'Wiggers, Jean', NULL, NULL, 1489, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1506, 'Dechamps, Etienne-Agard, Quaestio facti. Utrum Theologorum Societati Iesu Propriae
sint istae Sententiae duae: prima, ex duabus opinionibus probabilibus
possumus sequi minus tutam. Secunda, ex duabus opinionibus probabilibus
licitum est amplecti minus probabilem (Paris , Sébastien Cramoisy, 1659)', NULL, NULL, 1490, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1507, 'Aversa, Raffaello, Prima secunda partis in qua de Deo ultimo fine et mediis eum assequendum accurate disseritur (Roma, 1635)', NULL, NULL, 1491, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1508, 'Dechamps, Etienne-Agard, De haeresi ianseniana ab apostolica sede merito proscripta
libri tres. Opus ante annos novem sub Antonii Ricardi nomine inchoatum (S.L. , ed. Etienne Souciet, Paris, Gabriel Martin, Francis Montalant, Jean-Baptiste Coignard, Hippolyte-Louis Guérin, 1728)', NULL, NULL, 1492, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1509, 'Mendo, Andrés', NULL, NULL, 1493, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1510, 'Volckmar, Henning', NULL, NULL, 1494, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1511, 'Chanevelle, Jacques, Metaphysica generalis iuxta principia Aristotelis, 2 tomes (Paris , Edmond Martin, 1677)', NULL, NULL, 1495, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1512, 'Capponi, Serafino, Elucidationes formales in tertiam partem D. Thomae de Aquino de sacramentis etc. (Venezia , Giunta, 1596)', NULL, NULL, 1496, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1513, 'Fabri, Honoré, Historia compendiaria de vita et morte P. Petri Pauli Simii (Lyon , Lions, 1682)', NULL, NULL, 1497, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1514, 'Conceptione, Blasius A., Philosophia moralis in III libros divisa (Paris , Denis Thierry, 1647)', NULL, NULL, 1498, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1515, 'Barbay, Pierre, Commentarius in Aristotelis Logicam (Parisiis, 1690)', NULL, NULL, 1499, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1516, 'Mercenario, Arcangelo', NULL, NULL, 1500, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1517, 'Compton Carleton, Thomas, Philosophia universa (Anvers , typ. Jacob Meursius, 1649)', NULL, NULL, 1501, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1518, 'Lugo, Jean de, Disputationes scholasticae et Morales. Tractatus de virtute fidei divinae, Lyon 1646. (1646)', NULL, NULL, 1502, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1519, 'Durand, Barthélémy, Dissertationes ecclesiasticae pro foro tam sacramentali
quam contentioso, seu Opus morale ad normam universi iuris canonici
exactum (Avignon, 1703)', NULL, NULL, 1503, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1520, 'Adam, Jean, Via ad aeternitatem sive tria opuscula SS. Eucherii
episcopi Lugdunensis et Hilarii episc. Arelatensis, in quibus
Christiani a vanitate ad veritatem, a mundo ad coelum, a tempore ad
aeternitatem invilantur (Paris , Sébastien Marbre-Cramoisy, 1673)', NULL, NULL, 1504, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1521, 'Nazario, Giovanni Paolo, Opuscula varia (Bononiae, 1630)', NULL, NULL, 1505, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1522, 'Alsted, Johann Heinrich, Cursus philosophici Encyclopedia libri XXVI (Herborn, 1620)', NULL, NULL, 1506, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1523, 'Yon de Jonage, François', NULL, NULL, 1507, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1524, 'Alsted, Johann Heinrich, Artium liberalium ac facultatem omnium Systema Mnemoricum de modo discendi (Frakfurt, 1609)', NULL, NULL, 1508, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1525, 'Berni, Juan Bautista', NULL, NULL, 1509, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1526, 'Bois, François Du, Opera omnia, t. I-IV, In Summam Sancti Thomae (Antwerpen , Mercier, 1682)', NULL, NULL, 1510, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1527, 'Daniel, Gabriel, Viaggio per il mondo di Cartesio (Venezia, 1739)', NULL, NULL, 1511, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1528, 'Fabri, Honoré, Historia compendiaria de vita et morte P. Petri Pauli Simii (Wien , Schwendimann, 1731)', NULL, NULL, 1512, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1529, 'Locati Umberto, Opus quod Iudiciale Inquisitorum dicitur, ex diuersis theologis et i.u.d per fratrem Umbertum Locatum […] nuper extractum…, Romae 1570. (1570)', NULL, NULL, 1513, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1530, 'Pereira de Santa Ana, José', NULL, NULL, 1514, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1531, 'Socini (Sozzini, Socinus), Fausto, Praelectiones theologicae (Raków , Typis Sebastiani Sternacii, 1609)', NULL, NULL, 1515, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1532, 'Fabri, Honoré, Lettera di Eustachio Divini intorno
alle macchie nuouamente scoperte nel mese di Luglio 1665 nel Pianeta di
Gioue con suoi Cannocchiali. Al''Illvstriss Sig. Conte Carlo Antonio
Manzini (Roma , Giacomo Dragondelli, 1666)', NULL, NULL, 1516, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1533, 'Udine', NULL, NULL, 1517, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1534, 'Van den Herreweghen, Aegidius, Conclusiones ex theologia morali, quas praeside F.
Balduino de Housta ... defendent Josephus de Temmerman, Jacobus
Schellekens, Joannes d''Henau, Franciscus Vander Moesen, Aegidius Vanden
Hereweghen ... Gerardimontibus in Templo S. Martyris Adriani, praes. Baudouin de Housta (Bruxelles , typ. Zacharie Bettens, 1715)', NULL, NULL, 1518, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1535, 'Kircher, Athanasius', NULL, NULL, 1519, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1536, 'de Ulloa, Juan, Physica speculativa quatuor distinctionibus distincta (Roma , typis Jo. Francisci Chracas, 1713)', NULL, NULL, 1520, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1537, 'Mauri, Silvestro, Aristotelis Opera quae extant omnia, brevi paraphrasi ac litterae perpetuo inhaerente explanatione illustrata, 6 vol., Romae : sumptibus F. Franzini, 1668 (1668)', NULL, NULL, 1521, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1538, 'de Ubillos, Juan Antoni, Philosophia
rationalis : alm. Prouinciae Cantabriae Regularis Obseruantiae Seraph.
P.N. Francisci jussu edita, et ad mentem Venerabilis Subtilis, et
Mariani Doctoris Scoti, pro studiosa juventute accommodata (San Sebastian, 1755)', NULL, NULL, 1523, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1539, 'Sousa Antonio de, Relectio de censuris bullae Coenae,...  Ulyssipone : typis P. Crasbeeck, 1615. (1615)', NULL, NULL, 1524, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1540, 'Bary, René, Lettre à Boyer, in Les véritables frères rivaux, tragi-comédie, par Urbain Chevreau (Paris , Augustin Courbé, 1641)', NULL, NULL, 1525, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1541, 'Klodzko', NULL, NULL, 1526, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1542, 'Dati, Carlo Roberto', NULL, NULL, 1527, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1543, 'Adam, Jean, Abrégé de la vie de S. François de Borgia (Bordeaux , G. de la Court, 1672)', NULL, NULL, 1528, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1544, 'Nifo, Agostino, In Aristotelis libros Posteriorum analyticorum commentaria (Venetiis, 1553)', NULL, NULL, 1529, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1545, 'Colegio de San Ildefonso (Alcala)', NULL, NULL, 1530, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1599, 'Bauny, Etienne, Somme des péchés qui se commettent en tous états, de leurs conditions et qualités, en quelles occurrences ils sont mortels
ou véniels et en quelle façon le confesseur doit interroger son pénitent (Paris, 1634)', NULL, NULL, 1584, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1546, 'Alberghini Giovanni, Manuale Qualificatorum Sanctiss. Inquisitionis, in quo omnia, quae ad illus Tribunal, ac haeresum censuram pertinent, breui methodo adducuntur. Episcopis inquisitoribus, eorum Ministris, Theologis, Consultoribus, Confessarii, &amp; Juris consultis perutile &amp; necessarium, Palermo 1642. (1642)', NULL, NULL, 1531, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1547, 'Paris, Yves de, Traité de la nécessité (Paris, 1656)', NULL, NULL, 1532, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1548, 'Annat, François, Le libellé intitulé : la théologie morale des Jésuites contredit et convaincu en tous ses chefs (Cahors, 1645)', NULL, NULL, 1533, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1549, 'Barnabites', NULL, NULL, 1534, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1550, 'Prost, André', NULL, NULL, 1535, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1551, 'Miedes', NULL, NULL, 1536, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1552, 'Bois, François Du, Commentarii in totam secundam secundae partem S. Tho. Aquinatis (Douai , Gérard Patté, 1628)', NULL, NULL, 1537, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1553, 'Sardaigne (île) ', NULL, NULL, 1538, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1554, 'Aragón, Pedro de, In Secundam-Secundae divi Thomae doctoris Angelici commentariorum. Tomus primus (Salamanca, 1584)', NULL, NULL, 1539, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1555, 'Bary, René, Ample traité des mots, des phrases, des périodes, des figures et des transitions (Paris, 1665)', NULL, NULL, 1540, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1556, 'Hodierna, Giovanni Battista, Novissimae Additiones, et observationes ad decisiones
Mantuani Senatus IO. Petri Surdi Quibus hac quartâ editione praeter
antiguas nouae insigniores ... opus advocatis, causidicis, caeterisque (Genève , Johann Hermann Widerhold, 1669)', NULL, NULL, 1541, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1557, 'Fantono, Girolamo, Indicem in quatuor volumina Capreoli, seu tabulam ut dicitur, tam accurate, ut si quis eam habuerit, totum habere se
Capreolum sub epitomate perspicue, gloriari possit (Venezia, 1519)', NULL, NULL, 1542, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1558, 'Saint-Malo', NULL, NULL, 1543, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1559, 'Toledo, Diego de', NULL, NULL, 1544, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1560, 'Coventry', NULL, NULL, 1545, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1561, 'Venosa', NULL, NULL, 1546, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1562, 'Báñez, Domingo, De fide, spe et charitate. Scholastica commentaria in 2am 2ae Angelici Doctoris partem, quae ad quaest. 45 protenduntur (Salmanticae, , 1584)', NULL, NULL, 1547, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1563, 'Collège des Jésuites (Fribourg)', NULL, NULL, 1548, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1564, 'Riccioli, Giovanni Battista, Geographiae et hydrographiae reformatae : nuper recognitae, &amp;amp; auctae, libri duodecim (Venezia , typ. Ioannis La Noù, 1672)', NULL, NULL, 1549, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1565, 'Fabri, Honoré, Lettera di Eustachio Divini
all''Ill. Sig. Conte Carl''Antonio Manzini. Si ragguaglia di un nuovo
lavoro e componimento di Lenti, che servono a occhialoni o semplici, o
composti (Roma , Giacomo Dragondelli, 1633)', NULL, NULL, 1550, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1566, 'Alsted, Johann Heinrich, Encyclopedia universa (Lyon, 1647)', NULL, NULL, 1551, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1567, 'Viva, Domenico, Cursus theologicus ad usum Tyronum elucubratus (Patavii, 1712)', NULL, NULL, 1552, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1568, 'Luazes y Somoza, José Cayetano de', NULL, NULL, 1553, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1569, 'Colegio Santo Antão (Lisboa / Jesuitas)', NULL, NULL, 1554, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1570, 'Fourier, Jean', NULL, NULL, 1555, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1571, 'Barbay, Pierre, Commentarius in Aristotelis Logicam (Parisiis, 1680)', NULL, NULL, 1556, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1572, 'Menghini Tommaso, Regole del tribunale del S. Officio praticate in alcuni casi imaginarii, Milano 1689. (1689)', NULL, NULL, 1557, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1573, 'Albertini, Francesco, Traduction latine, Libellus de Angelo custode (Krakow, 1663)', NULL, NULL, 1558, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1574, 'Peña, Francisco, Directorium Inquisitorum cum commentariis Francisci Pegnae (Rome, 1578)', NULL, NULL, 1559, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1575, 'Université de Caen', NULL, NULL, 1560, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1576, 'Baron, Vincent, Manuductionis ad moralem theologiam pars altera, qua D.
Thomae vera mens de singulis vitae humanae et christianae officiis
inter
rigidas et laxiores opiniones media defenditur contra Amadeum
Guimenium, Apologistam, et Wendrochium. His addita est confirmatio 33
capitum de moribus
ex censura sacrae facultatis Parisiensis contra Amadeum (Paris , Simon Piget, 1665)', NULL, NULL, 1561, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1577, 'Vitoria', NULL, NULL, 1562, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1578, 'Puente la Reina', NULL, NULL, 1563, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1579, 'Zumel, Francisco, De Deo, eiusque operibus.Commentaria in primam partem Sancti Thomae Aquinatis consecrata, tomus primus (Salamanca , Pedro Lasso, 1585)', NULL, NULL, 1564, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1580, 'Dupleix, Scipion, Corps de philosophie, contenant la logique, l''éthique, la physique et la métaphysique (Genève, 1627)', NULL, NULL, 1565, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1581, 'Gamarra y Dávalos, Juan Benito Díaz de', NULL, NULL, 1566, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1582, 'Alsted, Johann Heinrich, Thesaurus artis memorativae (Frankfurt, 1612)', NULL, NULL, 1567, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1583, 'De la Vera, Mariano', NULL, NULL, 1568, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1584, 'Fabri, Honoré, repr. in Johann Eberhard Nidhard, Examen
theologicum quatuor propositionum quorundam authorum anonymorum, quibus aspergunt maculam cultui, festo, objecto et sententiae piae de
Immaculata sanctissimae Dei matris virginis conceptione nec non constitutioni S. D. N. Alexandri VII. octavo decemb. anni 1661 in
ejusdem favorem expeditae elaboratum ab E. D. P. Joanne Everardo Nidhardo,... Editio secunda juxta exemplar Matriti... apud Didacum Diaz
a Carera anno 1665 impressum, cui praefigitur Corolla virginae ab Hugone Sifilino, P. A. (Antwerpen , typ. H. Van Dunwalt, 1682)', NULL, NULL, 1569, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1585, 'Carmona', NULL, NULL, 1570, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1586, 'Morawski, Jan', NULL, NULL, 1571, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1587, 'Scaliger, Julius Caesar, Adversus D. Erasmum orationes duae eloquentiae romanae vindices cum auctoris opusculis (Toulouse, 1621)', NULL, NULL, 1572, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1588, 'Du Bosc, Jacques, De la vraye rétractation des sectaires et de leurs sectateurs (1655)', NULL, NULL, 1573, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1589, 'Capponi, Serafino, Summa totius theologia D. Thomae de Aquino […] cum elucidationibus formalibus, Venetiis 1612, apud Iuntas. (1612)', NULL, NULL, 1574, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1590, 'Serna, Pedro de la', NULL, NULL, 1575, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1591, 'Ocana', NULL, NULL, 1576, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1592, 'Melanchthon', NULL, NULL, 1577, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1593, 'Hessels, Jan', NULL, NULL, 1578, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1594, 'Gil Becerra, Benito, Asserto theo-subtilia, vel theologica sisthemate de essentia et efficacia voluntatis divinae et moralitate voluntatis humanae (Barcelona , José Geralt, 1745)', NULL, NULL, 1579, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1595, 'Slaughter, Edward', NULL, NULL, 1580, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1596, 'Politi, Ambrogio Catarino, De officio et dignitate sacerdotum (Lyon, 1537)', NULL, NULL, 1581, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1597, 'Freixo de Numao', NULL, NULL, 1582, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1598, 'Mazowsze', NULL, NULL, 1583, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1600, 'Siège inquisitorial de Ferrara', NULL, NULL, 1585, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1601, 'de Ulloa, Juan, De Anima disputationes quatuor (Roma , typis Jo. Francisci Chracas, 1715)', NULL, NULL, 1586, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1603, 'Collegium Complutense, Disputationes in tres libros Aristotelis de anima iuxta miram Angelici Doctoris D. Thomae doctrinam et eius scholam (Lyon, 1651)', NULL, NULL, 1588, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1604, 'Coninck, Gilles de, Commentariorum ac disputationum in universam doctrinam D. Thomae de sacramentis et censuris tomi duo (Lyon, 1643)', NULL, NULL, 1589, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1605, 'Ivul, Gabriel', NULL, NULL, 1590, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1606, 'Dupleix, Scipion, Les causes de la veille et du sommeil, des songes et de la vie et de la mort (Rouen , David du Petit Val, 1631)', NULL, NULL, 1591, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1607, 'Monmouth', NULL, NULL, 1592, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1608, 'Camacho Dávila, Joaquín', NULL, NULL, 1593, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1609, 'Dandini Anselmo, De suspectis de haeresi opus in duas partes distributum … , Romae 1703. (1703)', NULL, NULL, 1594, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1610, 'Albertini, Francesco, Trattato dell''Angelo Custode, cavato fedelmente da alcune prediche (Roma, 1612)', NULL, NULL, 1595, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1611, 'Pineda Ioannis de, In ecclesiasten commentariorum liber unus, Antverpiae 1620, Apud Petrum &amp; Joannem Belleros. (1620)', NULL, NULL, 1596, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1612, 'Tyrol', NULL, NULL, 1597, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1613, 'Bonne Espérance, François de la, Commentarii tres in universam Aristotelis philosophiam (Bruxelles, 1652)', NULL, NULL, 1598, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1614, 'Antonio de Santa María', NULL, NULL, 1599, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1615, 'Rossetti, Donato, Antignome fisico-matematiche, Livorno, appresso Gio. Vinc. Bonfigli, 1667 (1667)', NULL, NULL, 1600, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1616, 'Crespo, Andrés, Tractatus de Angelis (Alcala, 1751)', NULL, NULL, 1601, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1617, 'Nifo, Agostino, Super libros Priorum Aristotelis (Venetiis, 1553)', NULL, NULL, 1602, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1618, 'Foucher, Simon', NULL, NULL, 1603, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1619, 'Vives, Juan Luis, Introductio ad veram sapientiam (1524)', NULL, NULL, 1604, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1620, 'Gutke, Georg', NULL, NULL, 1605, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1621, 'Chalmers, William, Scotianae Ecclesiae infantia, virilis aetas, senectus (Paris, 1643)', NULL, NULL, 1606, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1622, 'González Martínez, Juan', NULL, NULL, 1607, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1623, 'Fasolo, Girolamo, In primam partem Summae S. Thomae Commentaria, , vol. I, Quaestiones 1-13 (Lyon , Louis Prost &amp;amp; héritiers Rouillé, 1623)', NULL, NULL, 1608, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1624, 'Vásárosmiske', NULL, NULL, 1609, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1625, 'Scaliger, Julius Caesar, Exotericarum exercitationum liber quintus decimus de subtilitate ad Hieronymum Cardanum (Paris , typ. Michel Vascosane, 1557)', NULL, NULL, 1610, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1626, 'Mastri, Bartolomeo, Disputationes theologicae in libros sententiarum quibus ab
adversantibus tum veterum tum recentiorum iaculis Scoti theologia
vindicatur, 4 vol. (Venezia , J.J. Hertz, 1684)', NULL, NULL, 1611, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1627, 'Casnedi, Carlo Antonio', NULL, NULL, 1612, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1628, 'Carerio Ludovico, Practica nova causarum criminalium, Venezia 1548. (1548)', NULL, NULL, 1613, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1629, 'Leibniz, Wilhelm Gottfried', NULL, NULL, 1614, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1630, 'Collegium Complutense, Metaphysica in tres libros
divisa, in quibus metaphysicales quae ad integritatem Philosophici
Carmelit. Excalceatorum Complutens. Cursus desiderabantur Quaestiones
disputantur, iuxta
eximiam Angelici Doctoris D. Thomae et scholae eius doctrinam. editio secunda (Lyon, 1651)', NULL, NULL, 1615, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1631, 'Juan, Gabriel', NULL, NULL, 1661, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1632, 'Assomption, Charles de l'', Funiculus triplex, quo necessitas angelici luminis D.
Thomae ad veram S. Augustini intellegentiam insolubiliter stringitur,
Baius, Molina, Jansenius (Cambrai , Gaspar Mairesse, 1675)', NULL, NULL, 1616, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1633, 'Gräter, Margarete', NULL, NULL, 1617, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1634, 'Korbach', NULL, NULL, 1618, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1635, 'Toulouse, Casimir de, Atomi peripateticae sive tum veterum tum recentiorum Atomistarum placita, 6 vol. (Béziers, 1674)', NULL, NULL, 1619, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1636, 'Gottingen', NULL, NULL, 1620, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1637, 'Borelli, Giovanni Alfonso, De motionibus naturalibus a gravitate pendentibus, liber Io. Alphonsi Borrelli ..., Regio Iulio : in officina Dominici Ferri, 1670 (1670)', NULL, NULL, 1621, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1638, 'Ordre des Célestins', NULL, NULL, 1622, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1639, 'Trombetta, Antonio, De animarum humanarum plurificatione, [Venetiis] : [Bonetus Locatellus] : [per Octavianus Scotus], 1498 (1497)', NULL, NULL, 1623, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1640, 'Commentarius et animadversiones in VI libros de causis plantarum Theophrasti (1598)', NULL, NULL, 1624, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1641, 'Bauny, Etienne, Somme des péchés qui se commettent en tous états, de leurs conditions et qualités, en quelles occurrences ils sont mortels
ou véniels et en quelle façon le confesseur doit interroger son pénitent (Paris, 1630)', NULL, NULL, 1625, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1642, 'Sotelo, Francisco', NULL, NULL, 1626, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1643, 'Campos, Urbano, Magni Raymundi Lumbier Ordinis Carmelitarum Elogium, in José Boneta Racionero, Vida exemplar del Venerable Padre M. Fr. Raymundo Lumbier (Zaragoza , typ. Domingo Gascon, 1687)', NULL, NULL, 1627, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1644, 'Baron, Vincent, Theologiae moralis adversus laxiores probabilistas. Pars prior,
qua vera mens D. Thomae et eius scholae de opinionum ex lege delectu in
qualibet
re morali explicata et defensa, adversus D. Caramuelis apologema in D.
Fragnanum, Anonymi nodos in P. Mercorum, Theophili Raynaudi exceptionem
et Amadei Guimenii tractatus quindecim (Paris , Simon Piget, 1665)', NULL, NULL, 1628, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1645, 'Hortensius, Martin, Oratio de dignitate et utilitate matheseos habita in illustri Gymnasio Senatus populique Amstelodamensis [...] VIII eid. Maii 1634 (Amsterdam, ex typographia Guilelmi Blaeu, 1634)', NULL, NULL, 1629, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1646, 'Opffermann, Lucas', NULL, NULL, 1630, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1647, 'Amico, Bartolomeo, In universam Aristotelis logicam explicatio et quaestiones (Rome, 1622)', NULL, NULL, 1631, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1648, 'Bauny, Etienne, Somme des péchés qui se commettent en tous états, de leurs conditions et qualités, en quelles occurrences ils sont mortels
ou véniels et en quelle façon le confesseur doit interroger son pénitent (Paris, 1641)', NULL, NULL, 1632, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1649, 'Accademia sacra fiorentina', NULL, NULL, 1633, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1650, 'Ripa Cesare, Della più nuovissima iconologia, Padova 1630. (1630)', NULL, NULL, 1634, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1651, 'Conimbricense, Collegium, Brevissimum totius Conimbricensis logicae compendium, un abrégé de l''ensemble du cours de logique. (London, 1627)', NULL, NULL, 1635, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1652, 'Randour, Valentin', NULL, NULL, 1636, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1653, 'Fabri, Filippo, Disputationes theologicae de sacramento ordinis, de poenis et censuris (Venezia , Ginammus, 1628)', NULL, NULL, 1637, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1717, 'Diana Antonino, Resolutiones morales, 12 t., Lugduni 1638. (1638)', NULL, NULL, 1704, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1718, 'Telesio, Bernardino, De rerum natura iuxta propria principia libri IX, Neapoli (S.L. , apud Horatium Salvianum, 1586)', NULL, NULL, 1705, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1654, 'Hodierna, Giovanni Battista, Archimede redivivo con la Stadera del momento del Dor Don
Gio. Battista Hodierna,... dove non solamente s''insegna il modo di
scoprir le frodi nella falsificatione dell'' oro e dell'' argento, ma si
notifica l''uso delli pesi, e delle misure civili presso diverse nationi
del mondo e di questo regno di Sicilia (Palermo , D. Cirillo, 1644)', NULL, NULL, 1638, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1655, 'Stévart, Pierre', NULL, NULL, 1639, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1656, 'Frkic, Mate, Osservationi sopra il Goffredo del signor Torquato Tasso (Padova , typ. Giambattista Pasquati, 1642)', NULL, NULL, 1640, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1657, 'Boursier, Laurent-François', NULL, NULL, 1641, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1658, 'Brescia, Fortunato da, Cornelii Jansensi sistema de gratia Christi methodice expositum et theologice confutatum (Brescia, 1757)', NULL, NULL, 1642, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1659, 'Bay (Baius), Michel du, Opuscula omnia priore impressione edita, cum aliquot alijs hactenus non visis, quorum catalogus sequens pagella indicabit (Louvain , apud Ioannem Bogardium, 1566)', NULL, NULL, 1643, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1660, 'Osiander, Johann Adam', NULL, NULL, 1644, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1661, 'David, Pierre, Les résolutions généreuses d''une âme sainte pendant la
retraite des dix jours, avec une vérité nécessaire pour l''instruction
des âmes désireuses de pratiquer la plus parfaite contemplation (Paris , François Le Cointe, 1662)', NULL, NULL, 1645, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1662, 'Aquena, Tommaso de', NULL, NULL, 1646, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1663, 'Maraffi, Luigi', NULL, NULL, 1647, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1664, 'Báñez, Domingo, Scholastica commentaria in primam partem angelici doctoris S. Thomae (Douai, 1614)', NULL, NULL, 1648, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1665, 'González de la Peña, Vicente', NULL, NULL, 1649, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1666, 'Grienberger, Christoforo, Catalogus veteres affixarum longitudines ac latitudines conferens cum novis ecc. CHRISTOPHORI GRIENBERGERI Oeni Halensis, S. I., calculo ac delineatione elaborata (Romae , apud Bartholomaeum Zannettum, 1912)', NULL, NULL, 1650, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1667, 'Sanders, Antoon', NULL, NULL, 1651, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1668, 'Font, Bernardo', NULL, NULL, 1652, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1669, 'Le Moine, Alphonse', NULL, NULL, 1653, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1670, 'Clauberg, Johannes, Paraphrasis in R. Descartes meditationes de prima Philosophia (Duisburg, 1658)', NULL, NULL, 1654, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1671, 'Fantis, Antonio de, Commentarium in Primum et Secundum Sententiarum (Lyon, 1530)', NULL, NULL, 1655, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1672, 'Belém (Lisboa)', NULL, NULL, 1656, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1673, 'Simancas D., Enchiridion iudicum violatae religionis, Venezia 1568. (1568)', NULL, NULL, 1657, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1674, 'Grégoire, Pierre', NULL, NULL, 1658, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1675, 'Nifo, Agostino, Parva naturalia (Venise, 1523)', NULL, NULL, 1662, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1676, 'Bayon, Nicolas, Solutions des cas de conscience (Verdun, 1620)', NULL, NULL, 1663, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1677, 'Perkins, William', NULL, NULL, 1664, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1678, 'Pourchot, Edmond, Institutiones philosophicae ad faciliorem veterum et recentiorum philosophorum intelligentiam comparatae (Lyon, apud frates Bruyset, 1733)', NULL, NULL, 1665, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1679, 'Iavelli, Crisostomo, Opera omnia, 3t. en 2 vol. (Lyon, 1580)', NULL, NULL, 1666, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1680, 'Capponi, Serafino, Elucidationes formales in tertiam partem D. Thomae de Aquino de sacramentis etc. (Venezia , Giunta, 1588)', NULL, NULL, 1667, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1681, 'Cabrera, Pedro de, In tertiam partem Sancti Thomae Aquinatis commentarij et
disputationes : a quaestione decima vsque ad vigessimam sextam
inclusiuè (Cordoba , Andrés Barrera, 1602)', NULL, NULL, 1668, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1682, 'Summa theologiae scotisticae, 8 volumes (Chambéry , Blondet, 1708)', NULL, NULL, 1669, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1683, 'Sinnich, John', NULL, NULL, 1670, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1684, 'Bois, François Du, t. VI : In Genesim, Exodum, Leviticum, Numerorum (S.L. ,  Verdussen, 1698)', NULL, NULL, 1671, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1685, 'Gambais', NULL, NULL, 1672, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1686, 'Paludanus, Michaël', NULL, NULL, 1673, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1687, 'Ecija', NULL, NULL, 1674, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1688, 'Carranza de Miranda, Sancho', NULL, NULL, 1675, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1689, 'Abbaye de Port-Royal des champs', NULL, NULL, 1676, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1690, 'Bourdin, Pierre, Prima geometriae elementa (Paris, 1639)', NULL, NULL, 1677, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1691, 'Acosta, José de', NULL, NULL, 1678, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1692, 'Alcalà de Xivert', NULL, NULL, 1679, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1693, 'Université d''Oxford', NULL, NULL, 1680, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1694, 'Lorini, Giovanni, In acta apostolorum commentaria numquam hactenus edita et magno cum labore et studio, diligenriaque confecta, Lyon 1605, «Apud Horatii Cardon». (1606)', NULL, NULL, 1681, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1695, 'Sforza Pallavicino, Pietro, Assertionum theologicarum liber sextus de sacramentis (Rome , Corbelletti, 1650)', NULL, NULL, 1682, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1696, 'Bouju, Théophraste', NULL, NULL, 1683, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1697, 'Nuñez Delgadillo, Agustín', NULL, NULL, 1684, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1698, 'Toledano, Alejandro', NULL, NULL, 1685, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1699, 'Frkic, Mate, De Personis producentibus Spiritum Sanctum (Padova, 1644)', NULL, NULL, 1686, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1700, 'Cabra', NULL, NULL, 1687, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1701, 'Gouveia, António de', NULL, NULL, 1688, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1702, 'Traslavina', NULL, NULL, 1689, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1703, 'O''Connor Kerry, Bonaventure', NULL, NULL, 1690, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1704, 'Conimbricense, Collegium, In tres libros de Anima Aristotelis Stagiritae (Köln, 1610)', NULL, NULL, 1691, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1705, 'Adam, Jean, Calvin deffait par soy-mesme et par les armes de S. Augustin
qu''il avait injustement usurpées sur les matières de la Grâce, de la
Liberté et de la Predestination (1689)', NULL, NULL, 1692, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1706, 'Bernier, François, Abrégé de la philosophie de M. Gassendi, 2e éd. rev. et augm., Lyon : Anisson, Posuel et Rigaud, 1684,  7 tomes en 6 vol. (1684)', NULL, NULL, 1693, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1707, 'Paramo Ludovicus a, De origine et progressu officii sanctae inquisitionis […], Madrid 1598. (1598)', NULL, NULL, 1694, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1708, 'Angers', NULL, NULL, 1695, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1709, 'Baronio, Bonaventura, Io. Duns Scotus defensus et amplificatus de Angelis (Florentiae, 1676)', NULL, NULL, 1696, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1710, 'Campoverde, Juan de, Tractatus de Incarnatione Verbi Divini. Divisus in tres tomos. Tomo primus (Alcala, 1711)', NULL, NULL, 1697, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1711, 'Chieti', NULL, NULL, 1698, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1712, 'Vives, Juan Luis, De institutione foeminae christianae (1524)', NULL, NULL, 1699, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1713, 'Scaliger, Julius Caesar, Epistolae et Orationes (Leiden, 1600)', NULL, NULL, 1700, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1714, 'Ocana', NULL, NULL, 1701, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1715, 'Nazario, Giovanni Paolo, Commentaria et controversiae in tertiam partem Summae D. Thomae Aquinatis, 3 vols (1627)', NULL, NULL, 1702, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1716, 'Gasch, José', NULL, NULL, 1703, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1719, 'Azpilcueta, Martín de, Enchiridon sive Manuale confessariorum et poenitentium (Venise , Frères Guerra, 1580)', NULL, NULL, 1706, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1720, 'Bois, François Du, Commentarii in totam primam partem S. Tho. Aquinatis (Anvers , apud Vam et filium J. B. Verdussen, 1693)', NULL, NULL, 1707, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1721, 'Walker, Obadiah', NULL, NULL, 1708, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1722, 'Ruggeri, Giacinto de, Defensorium doctrinae Divi Thomae contra objecta Patri magistri Angelis Vulpis (Neapoli , ex Typographia Honuphrii Savii, 1655)', NULL, NULL, 1709, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1723, 'Barbay, Pierre, Commentarius in Aristotelis Metaphysicam (Parisiis, 1690)', NULL, NULL, 1710, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1724, 'Mariale, Sante, Controversiae ad universam summam theologiae S. Thomae Aquinatis
nec non ad quatuor libros Mag. Sententiarum, in quibus postremo Scotistarum perillustris schola cum thomistica quoad fieri potest conciliantur: Scoti doctrina, ubi ab Aquinate dissidet, mira facilitate explicatur atque defenditur vindicaturque a calumniis (Venetiis , apud Franciscum Bolzetam, 1624)', NULL, NULL, 1711, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1725, 'Rodríguez, Bernardino', NULL, NULL, 1712, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1726, 'Pont Canavese', NULL, NULL, 1713, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1727, 'Crab, Gilbert, Tractatus noticiarum (Paris , Bernard Aubry, 1518)', NULL, NULL, 1714, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1728, 'Derham, William, Théologie physique, ou démonstration de l''existence et des attributs de Dieu, tirée des Oeuvres de la Création, Accompagnée d''un
grand nombre de Remarques et d''Observations curieuses, traduite de l''Anglois par Jacques Lufneu, Seconde édition revue et corrigée (La Haye , typ. Pierre Paupie, 1740)', NULL, NULL, 1715, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1729, 'Bellarini, Giovanni, Doctrina d. Concilii Tridentini et cathechismi romani de symbolo
apostolorum, de sacramentis et iustificatione, oratione dominica et
Decalogo. Opusculis
de Santo Evangelio ipsoque catechismo et examine ad ordines,
confessiones, conciones, beneficia et curam animarum (Lyon, 1683)', NULL, NULL, 1716, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1730, 'Frkic, Mate, Vestigationes peripateticae (Padova , typ. P. Frambotti, 1639)', NULL, NULL, 1717, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1731, 'Antibes', NULL, NULL, 1718, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1732, 'Arrubal, Pedro', NULL, NULL, 1719, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1733, 'Physique expérimentale', NULL, NULL, 1720, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1734, 'Aznar, Juan, Termini secundum viam realium (Valentiae , per Iohannem Ioffre, 1513)', NULL, NULL, 1721, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1735, 'Gamiz, Juan de', NULL, NULL, 1722, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1736, 'Fullana, Bartomeu Antoni', NULL, NULL, 1723, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1737, 'Thümming, Ludwig Philipp', NULL, NULL, 1724, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1738, 'Cárdenas, Juan de, Crisis theologica bipartita, sive disputationes selectae ex morali theologia, 
in quibus pro votis Illustrissimi D.D. Ioannes Caramuelis, utque operi eius interrogatorio respondeatur, quamplurimae
eius opiniones et argumentationes ad praefatam crisim vocantur, pars prima [et pars altera] (Lyon , Laurent Arnaud &amp;amp; Pierre Borde, 1670)', NULL, NULL, 1725, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1739, 'Faverges', NULL, NULL, 1726, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1740, 'Olp, Jacinto de', NULL, NULL, 1727, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1741, 'González de Santa Cruz, Francisco', NULL, NULL, 1728, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1742, 'Gaeta', NULL, NULL, 1729, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1743, 'Tolomei, Giovanni Battista, Philosophia mentis et sensuum, secundum utramque Aristotelis methodum pertractata, metaphysice et empirice (Roma, 1696)', NULL, NULL, 1730, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1744, 'Riccioli, Giovanni Battista, Almagestum novum astronomiam veterem novamque complectens, 2 vol. (Bologna, 1651)', NULL, NULL, 1731, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1745, 'Castro, Alfonso de, De potestate legis peonalis libri duo (Lugduni , apud Sebastianum Bartholomaei Honorati, 1556)', NULL, NULL, 1732, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1746, 'Ames, William, Disputatio theologica adversus metaphysicam (Leiden, 1632)', NULL, NULL, 1733, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1747, 'Galindo, José', NULL, NULL, 1734, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1748, 'Alsted, Johann Heinrich, Encyclopaedia septem tomis distincta (Herborn, 1630)', NULL, NULL, 1735, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1749, 'Ehingen an der Donau', NULL, NULL, 1736, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1750, 'Bugis, Pierre de, Tractatus de mysterio incarnationis (Lyon , Ph. Borde, L. Arnaud &amp;amp; P. Borde, 1668)', NULL, NULL, 1737, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1751, 'Ysambert, Nicolas, Procès-verbal fait par M. le lieutenant criminel d''Orléans
(M. Houmain) sur la remontrance du procureur du roi que
l''éclaircissement et résolution de plusieurs questions résultantes des
procès criminels faits par ledit sieur lieutenant à plusieurs prévenus
et accusés dudit crime doit être prise des docteurs de théologie avant
le jugement desdits procès, au pied duquel sont les décrets et
décisions de MM. les docteurs de Sorbonne (A. Du Val, Ph. de Gamaches,
Le Clerc, N. Ysambert), rendues sur lesdites questions (Orléans, 1625)', NULL, NULL, 1738, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1752, 'Gotti Vincenzo Lodovico, Theologia scolastica dogmatica …, 4 t., Bologna 1727-1734. (1727)', NULL, NULL, 1739, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1753, 'Feliciano, Giovanni Bernardo', NULL, NULL, 1740, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1754, 'Politi, Ambrogio Catarino, Excusatio disputationis contra Lutherum ad universas Ecclesias (Florence, 1521)', NULL, NULL, 1741, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1755, 'Diaz de Llanos, Froylan, Dialectica disputata per quaestiones et articulus distincta iusta mentem D. Thomae (Madrid, 1694)', NULL, NULL, 1742, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1756, 'Burgersdijk, Franco, Idea philosophiae naturalis (Leiden, 1627)', NULL, NULL, 1743, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1757, 'Iavelli, Crisostomo, Epitome in octo libros Aristotelis de physica (Venise, 1564)', NULL, NULL, 1744, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1758, 'Fribourg', NULL, NULL, 1745, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1759, 'Grand Couvent des Capucins (Paris)', NULL, NULL, 1746, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1760, 'Hauzeur, Matthias', NULL, NULL, 1747, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1761, 'González, Juan', NULL, NULL, 1748, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1762, 'Conimbricense, Collegium, In libros Aristotelis, qui Parva Naturalia appellantur (Lyon , Horace Cardon, 1608)', NULL, NULL, 1749, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1763, 'Péronne', NULL, NULL, 1750, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1764, 'Oradea', NULL, NULL, 1751, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1765, 'Vives, Juan Luis, De anima et vita libri III (1538)', NULL, NULL, 1752, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1766, 'Milan (duché de)', NULL, NULL, 1753, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1767, 'Mondeja', NULL, NULL, 1754, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1768, 'Clauberg, Johannes, Differentia inter Cartesianum et alias in Scholis usitatam Philosophiam (Groningen, 1680)', NULL, NULL, 1755, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1769, 'Bassée, Eloi de la, Supplementum ad Flores theologiae practicae, sive tomus secundus (Lyon, Laurent Anisson (cédant la moitié de son privilège à Jérôme de la Garde), 1663)', NULL, NULL, 1756, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1770, 'Wadding, Luke', NULL, NULL, 1757, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1771, 'Benevento', NULL, NULL, 1758, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1772, 'Ammannati, Dorotea', NULL, NULL, 1759, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1773, 'Ames, William, Bellarminus enervatus, vel disputationes anti-bellarminianae (London, 1633)', NULL, NULL, 1760, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1774, 'Almazan', NULL, NULL, 1761, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3300, 'Hasselt', NULL, NULL, 3284, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1775, 'Stampa, Angelo Giuseppe, Theses ex universa philosophia selecta (Milano, 1740)', NULL, NULL, 1762, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1776, 'Serravalle', NULL, NULL, 1763, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1777, 'Garessio', NULL, NULL, 1764, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1778, 'Fabri, Filippo, Philosophia naturalis Joannis Duns Scoti ex quatuor libri Sententiarum et Quodlibetis collecta, in theoremata distributa et contra adversarios omnes tum Veteres quam Recentiores, impugnationibus
et defensionibus illustrata ac dilucidata... (Venezia , haer. Giovanni Battista Bertoni, 1622)', NULL, NULL, 1765, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1779, 'Cappello, Paola', NULL, NULL, 1766, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1780, 'Conimbricense, Collegium, In quatuor libros de Coelo Aristotelis Stagiritae (Lyon , Ex officina Iuntarum, 1598)', NULL, NULL, 1767, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1781, 'Alsted, Johann Heinrich, Methodus admirandorum mathematicorum (Herborn, 1623)', NULL, NULL, 1768, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1782, 'Bernardi della Mirandola, Antonio, In tertium librum Rethoricae Aristotelis egregia explicatio. Cui additum est in Aristotelis Rethoricam prooemium universalem, nec non in cap. I et II libri I Rhetoricae Aristotelis expositio (Bononiae , Apud Ioannem Rossium, 1589)', NULL, NULL, 1769, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1783, 'Coronel, Antonio, Commentaria super librum Praedicamentorum Aristotelis (Paris , B. Aubry, 1518)', NULL, NULL, 1770, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1784, 'Théatins', NULL, NULL, 1771, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1785, 'Verviers', NULL, NULL, 1772, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1786, 'Bail, Louis, Summa conciliorum, 2 vol. (Paris, 1659)', NULL, NULL, 1773, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1787, 'Alsted, Johann Heinrich, Systema Mmnemonicum Duplex. I. Minus, Succincto praeceptorum ordine
Quatuor libris adornatum. II. Maius, pleniore praeceptorum Methodo, et
Commentariis scriptis ad praeceptorum illustrationem adornatum Septem
libris. In Quibus artis memorativae praecepta plene et methodice
traduntur (Frankfurt, 1610)', NULL, NULL, 1774, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1788, 'Marchand, Hugues Noël', NULL, NULL, 1775, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1789, 'Bechmann, Friedemann, Disputatio academica de praedestinatione prima : in
qua de voce praedestinationis, eius genere, causis eius in genere,
&amp;amp; in specie de causa efficiente agitur (S.L. , def. Johannes Paul Hebenstreit, Jena, Werther, 1680)', NULL, NULL, 1776, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1790, 'Fracastoro, Girolamo, De contagione (1546)', NULL, NULL, 1777, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1791, 'Toulouse, Casimir de, Vie du duc de modène, capucin (Béziers, 1674)', NULL, NULL, 1778, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1792, 'Gutzeit, François Antoine', NULL, NULL, 1779, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1793, 'Du Bosc, Jacques, La découverte d''une nouvelle hérésie (1662)', NULL, NULL, 1780, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1794, 'Porreta Terme', NULL, NULL, 1781, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1795, 'Dechamps, Etienne-Agard, Invictissimo principi Ludovico Borbonio, Enguiennensium duci, ad
Rocroyam victori, Theodonis Villae expugnatori, Canna Mellonis quam
nupera ex pugna victor retulit (Paris , Sébastien Cramoisy, 1643)', NULL, NULL, 1782, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1796, 'Álvarez, Diego, Disputationes theologicae in Iam-IIae S. Thomae (Trani, 1620)', NULL, NULL, 1783, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1797, 'Avendaño, Diego de, Problemata theologica, 2 vols (Antwerpen, 1668)', NULL, NULL, 1784, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1798, 'Ferrari, G., Physica sive de corpore (Milano, 1631)', NULL, NULL, 1785, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1799, 'Bernal de Avila, Agustín, Disputationes de sacramentis in genere, in eucharistia et ordine et particulari (Lugduni, 1651)', NULL, NULL, 1786, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1800, 'Gmund am Tegernsee', NULL, NULL, 1787, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1801, 'Aepinus, Franz Albert', NULL, NULL, 1788, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1802, 'Assomption, Charles de l'', Défence de la pratique commune de l''Eglise, présentée au Roy contre la nouveauté des rigoristes sur l''usage de l''absolution (Cambrai , Gaspar Mairesse, 1684)', NULL, NULL, 1789, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1803, 'Argentré Charles Duplessis, Collectio judiciorum de nouis erroribus qui ab initio duodecimi saeculi post Incarnationem Verbi, usque ad annum 1713 in Ecclesia proscripti sunt &amp; notati, [3 tomes en 4 voll.], Lutetiae Parisiorum 1724 sqq (1724)', NULL, NULL, 1790, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1804, 'Angra do Heroismo', NULL, NULL, 1791, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1805, 'Hodierna, Giovanni Battista, Universae facultatis directionum physiotheorica, opus astronomicum (Palermo , A. de Insula, 1629)', NULL, NULL, 1792, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1806, 'Haye, La', NULL, NULL, 1793, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1807, 'Adam, Jean, Le Triomphe de la Très Sainte Eucharistie, ou la Présence
réelle du corps et du sang de Jésus-Christ dans cet adorable sacrement,
prouvée par l''Escriture sainte et par les témoignages des Pères des
premiers siècles (Sedan , G. de Meerbec, 1671)', NULL, NULL, 1794, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1808, 'Mendoza, Alfonso de', NULL, NULL, 1795, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1809, 'Maignan, Emmanuel, De usu licito pecuniae dissertatio theologica, Toulouse 1673-1674, B. Bosc, in 8°. (1673)', NULL, NULL, 1796, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1810, 'Clément, Claude, Dissertatio christiano-politica ad Philippum IV ... : in
qua machiavellismo ex impietatis penetralibus producto [et] iugulato,
firmitas, felicitas [et] incrementa hispanicae monarchiae, atque
Austriacae maiestatis ... referentur (Madrid , Francisco Martinez, 1636)', NULL, NULL, 1797, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1811, 'Rottweil', NULL, NULL, 1798, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1812, 'Castelli, Benedetto', NULL, NULL, 1799, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1813, 'Mastri, Bartolomeo, Philosophiae ad mentem Scoti cursus integer (Venezia , Nicola Pezzana, 1727)', NULL, NULL, 1800, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1814, 'Brescia, Fortunato da, Cornelii Jansensi sistema de gratia Christi methodice expositum et theologice confutatum (Brescia, 1751)', NULL, NULL, 1801, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1815, 'Cursus philosophicus (Palerme, 1702)', NULL, NULL, 1802, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1816, 'Jesuitenkolleg (Mindelheim)', NULL, NULL, 1803, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1817, 'Brescia, Fortunato da, Philosophia mentis methodice tractata atque ad usus academicos accomodata, tomus 2 : Metaphysica (Brescia, 1768)', NULL, NULL, 1804, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1818, 'Cauvinus, Paulus Maria, Cursus philometaphysicus scilicet continens tum universae philosophiae cum famosiores metaphysicae speculationes (...) ad mentem angelici praeceptoris divi Thomae Aquinatis (Bologna, 1692)', NULL, NULL, 1805, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1819, 'Estrix, Egidius', NULL, NULL, 1806, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1820, 'Royaume des Deux Siciles ', NULL, NULL, 1807, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1821, 'Barbay, Pierre, Commentarius in Aristotelis Metaphysicam (Parisiis, 1680)', NULL, NULL, 1808, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1822, 'Titone, Angelo', NULL, NULL, 1809, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1823, 'Daniel, Gabriel, Entretiens de Cléandre et d''Eudoxe sur les Lettres au provincial, 10e éd. avec quelques idées qui ont du rapport à la mesme matière (Rouen , Pierre Marteau, 1694)', NULL, NULL, 1810, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1824, 'Couvent de Klosterneuburg', NULL, NULL, 1811, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1825, 'David, Pierre, Le chemin de vérité qui conduit une âme désireuse de faire son salut à la perfection de la sainteté (Paris, 1661)', NULL, NULL, 1812, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1826, 'Clauberg, Johannes, Chilias thesium ad philosophiam naturalem pertinentium... disputanda in Academia Duisburgensi (Groningen, 1668)', NULL, NULL, 1813, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1827, 'Ames, William, Bellarminus enervatus, vel disputationes anti-bellarminianae (Franeker, 1625)', NULL, NULL, 1814, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1828, 'Dabillon, André, Nouveau cours de philosophie en françois, divisé en quatre
parties contenant la logique, physique et morale, suivans la doctrine
des plus
célèbres auteurs (Paris, 1643)', NULL, NULL, 1815, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1829, 'Vázquez, Gabriel, Paraphrasis et explicatio ad nonnullas Pauli Epistolas (alcala, 1612)', NULL, NULL, 1816, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1830, 'Valdemoro', NULL, NULL, 1817, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1831, 'Cadana, Salvatore, Dicta philosophica in VIII libros physicorum ad mentem Scoti (Torino, 1650)', NULL, NULL, 1818, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1832, 'Brugmans, Antonius', NULL, NULL, 1819, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1833, 'Araújo, Francisco de, Commentaria in universam Aristotelis metaphysicam tomus primus, quinque libros complectens (Burgos , Juan Bautista Varesio, 1617)', NULL, NULL, 1820, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1834, 'Daniel, Gabriel, Novae
difficultates a peripatetico propositae auctori Itineris per mundum
Cartesii, circa cognitionem brutorum, cum refutatione duplicis
defensionibus systematis mundi
Cartesii,traduction latine (Amsterdam , Abraham Wolfgang, 1694)', NULL, NULL, 1821, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1835, 'Francisco de San Diego', NULL, NULL, 1822, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1836, 'Clavius, Christopher, In Sphaeram Ioannis de Sacro Bosco Commentarius (Roma, 1570)', NULL, NULL, 1823, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1837, 'Paris, Yves de, Le magistrat chrétien (Paris, 1688)', NULL, NULL, 1824, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1838, 'Chasteignier, Henri-Louis de La Rochepozay, Exercitationes in varios Bibliorum libros (Poitiers , Thoreau, 1640)', NULL, NULL, 1825, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1839, 'D''Elbecque, Norbert', NULL, NULL, 1826, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1840, 'Cochet, Jean-Baptiste, La morale (Paris , Hérissant, 1755)', NULL, NULL, 1827, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1841, 'Mini, Bonaventura', NULL, NULL, 1828, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1842, 'Aguilar, José de, ermones varios, predicados en la Ciudad de Lima (Bruxelles, 1684)', NULL, NULL, 1829, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1843, 'Vanderveken, Frans, In canonen Sacrificii Missae brevis ac luculenta et ad pietatem utilis expositio (Madrid , Geronimo Ortega, 1788)', NULL, NULL, 1830, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1844, 'Miguel de San Francisco', NULL, NULL, 1831, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1845, 'Benet, Cipriano, Hortatoria vehemens Pont. max. electi ad accelerandum iter (Roma , Marcellus Silber, 1522)', NULL, NULL, 1832, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1846, 'Góis, Manuel', NULL, NULL, 1833, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1847, 'Mastri, Bartolomeo, Disputationes in Aristotelis libros Physicorum (Venezia, 1644)', NULL, NULL, 1834, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1848, 'Saint-Paul, Eustache de, Summa philosophiae quadripartita, de rebus dialecticis, moralibus et metaphysicis (1629)', NULL, NULL, 1835, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1849, 'Bayonne', NULL, NULL, 1836, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1850, 'Chalmers, William, Antiquitatis de novitate victoria sive justa defensio premotionis physicae (Fastemburg, 1634)', NULL, NULL, 1837, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1851, 'Zabarella, Giacomo, Opera logica (1578)', NULL, NULL, 1838, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1852, 'Leti Gregorio, Il nipotismo di Roma: O vero, Relatione delle raggioni che muovono i pontifici all''aggrandimento de'' nipoti, Amsterdam 1667. (1667)', NULL, NULL, 1839, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1853, 'Montero, Manuel', NULL, NULL, 1840, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1854, 'Wissingh, Anton', NULL, NULL, 1841, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1855, 'Steyr', NULL, NULL, 1842, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1856, 'Grangier, Jean', NULL, NULL, 1843, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1857, 'Siebenbürgische Akademie Weißenburg (Weissenburg)', NULL, NULL, 1844, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1858, 'Possendorf', NULL, NULL, 1845, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1859, 'Sghemma, Gaspare, Sermoni del Santissimo sacramento dell''Inmacolata Concettione di Maria Vergine (Palermo, 1643)', NULL, NULL, 1846, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1860, 'Librorum post Indicem Clementis VIII. prohibitorum decreta omnia hactenus edita (Romae , Ex typographia Reu. Cam. Apost., 1624)', NULL, NULL, 1847, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1861, 'Conimbricense, Collegium, In tres libros de Anima Aristotelis Stagiritae (Köln , typ. Zetzner, 1600)', NULL, NULL, 1848, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1862, 'Polanus, Amandus', NULL, NULL, 1849, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1863, 'Deza, Diego de, Novarum defensiones doctrinae beati Thomae de Aquino super libros Sententiarum quaestiones, 3 vol. (Séville, 1517)', NULL, NULL, 1850, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1864, 'Galilei, Ottavio', NULL, NULL, 1851, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1865, 'Boyvin, Jean Gabriel, Theologia scoti a prolixitate et subtilitas eius ab obscuritate libera et vindicata, 4 vol., septima editio correctior (Venezia , Gaspare de Stortis, 1698)', NULL, NULL, 1852, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1866, 'Alsted, Johann Heinrich, Elementale mathematicum in quo mathesis methodice traditur per praecepta brevia, theoremata perspicua, commentaria succincta (Frankfurt, 1611)', NULL, NULL, 1853, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1867, 'Manso, Pedro', NULL, NULL, 1854, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1868, 'Baronio, Bonaventura, Panegyrici sacro-prophani (Romae, 1643)', NULL, NULL, 1855, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1869, 'Baron, Vincent, Responsio ad librum Johannis de Cardenas (1672)', NULL, NULL, 1856, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1870, 'Bagot, Jean, Pars posterior. Demonstratio dogmatum christianorum (Paris, 1645)', NULL, NULL, 1857, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1871, 'Brasavola, Ireneo, Quaestiones quolibetales, seu miscellaneae theologicae. Ac philosophicae, omnibus, praecipue que doctrinam Scoti profitentibus necessariae (Venetiis , apud Marcum Variscum, 1600)', NULL, NULL, 1858, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1872, 'Grimaldi, Francesco Maria, Physico-mathesis de lumine (Bologna, 1665)', NULL, NULL, 1859, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1873, 'Reggio Emilia', NULL, NULL, 1860, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1874, 'Sannig, Bernardus', NULL, NULL, 1861, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1875, 'de Ulloa, Juan, De primis et ultimis temporibus, seu De Principio et Fine Mundi, Disputationes quatuor cum tribus indicibus (Augsburg, 1719)', NULL, NULL, 1862, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1876, 'Azpilcueta, Martín de, Enchiridon sive Manuale confessariorum et poenitentium (Rome , Vittorio Eliano, 1573)', NULL, NULL, 1863, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1877, 'Billuart, Carolus Renatus', NULL, NULL, 1864, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1878, 'Musson, John', NULL, NULL, 1865, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1879, 'Teruel', NULL, NULL, 1866, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1880, 'Diaz de Llanos, Froylan, Logica rationalis (Valladolid, 1695)', NULL, NULL, 1867, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1881, 'Cerf, Henri de', NULL, NULL, 1868, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1882, 'Bary, René, La rhétorique françoise ou pour principale augmentation l''on trouve les secrets de nostre langue (Paris , Pierre Le Petit, 1673)', NULL, NULL, 1869, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1883, 'Celaya, Juan de, Dialecticae introductiones (Paris , expensis Nicolai de Pratis &amp;amp; Jean de Gourmont, 1512)', NULL, NULL, 1870, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1884, 'Clauberg, Johannes, De Cognitione Dei et nostri, quatenus naturali rationis
lumine, secundum veram philosophiam, potest comparari, exercitationes
centum (Duisburg, 1656)', NULL, NULL, 1871, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1885, 'Saint-Paul, Eustache de, Summa philosophiae quadripartita, de rebus dialecticis, moralibus et metaphysicis (1649)', NULL, NULL, 1872, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3551, 'Cologne', NULL, NULL, 3538, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1886, 'Dagoumer, Guillaume, Philosophia ad usum scholae accomodata, 6 vol. (Lyon , Frères Duplain, 1757)', NULL, NULL, 1873, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1887, 'Ayrault, Guillaume', NULL, NULL, 1874, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1888, 'Mastri, Bartolomeo, Commentarii in libros de anima (Venezia, 1643)', NULL, NULL, 1875, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1889, 'Brinne-e-Hinnot', NULL, NULL, 1876, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1890, 'Costacciaro', NULL, NULL, 1877, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1891, 'Cardillo de Villalpando, Gaspar, Commentarius in Aristotelis logica (Compluti, 1557)', NULL, NULL, 1878, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1892, 'Scaccia Sigismundus, Tractatus de sententia et re iudicata. omnibus admodum utilis, Iudicibus auterm, Ducibus, Regibus aliisq. Principibus magna ex parte necessarius, Roma 1628. (1628)', NULL, NULL, 1879, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1893, 'Galilei, Vincenzo', NULL, NULL, 1880, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1894, 'Barbieri da Castelvetro, Bartolomeo, Esercizio della presenza di Dio (1673)', NULL, NULL, 1881, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1895, 'Saint-Paul, Eustache de, Summa philosophiae quadripartita, de rebus dialecticis, moralibus et metaphysicis (Parisiis, 1611)', NULL, NULL, 1882, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1896, 'Collegium Complutense, Disputationes in Aristotelis dialecticam iuxta miram angelici doctoris D. Thomae doctrinam et eius scholam (Lyon, 1668)', NULL, NULL, 1883, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1897, 'Bois, François Du, Explicatio doctrinae sancti Thomae Aquinatis,... et
confirmatio thesium et impertinentium ex eodem de motione primi motoris
disputatorum in collegio regio Duaci (Amsterdam , J. L''Ecaillé, 1663)', NULL, NULL, 1884, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1898, 'Valera, Alfonso', NULL, NULL, 1885, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1899, 'Tanner, Adam', NULL, NULL, 1886, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1900, 'Frédéric III de - Saxe', NULL, NULL, 1887, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1901, 'Bordoni Francesco, Sacrum Tribunal iudicum in causis sanctae fidei contra haereticos et de haeresi suspectos. Omnibus Episcopis, Inquisitoribus, Consultoribus, Iudicibus, Confessariis, Procuratoribus, &amp; Aduocatis valde necessarium. Cum explicatione omnium bullarum, &amp; decretorum spectantium ad S. Inquisitionis Officium hactenus publicatorum, Romae 1648, Typis haeredum Corbelletti. (1648)', NULL, NULL, 1888, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1902, 'Zaragoza y Vilanova, José, Geometriae magnae in minimis pars tertia : de solidis (Toledo, 1674)', NULL, NULL, 1889, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1903, 'County of Dorset', NULL, NULL, 1890, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1904, 'Becanus, Martin, Compendium manualis controversiarum huius temporis, de fide ac religione. Lugduni : apud Hilarium Baritel (1628)', NULL, NULL, 1891, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1905, 'Daniel, Gabriel, Lettre touchant une ancienne heresie renouvelée depuis peu (Cologne , Isaac Anteline, 1690)', NULL, NULL, 1892, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1906, 'Urbano VIII Maffeo Barberini, Poëmata, Roma 1631 [!!! 2 edizioni ?]. (1631)', NULL, NULL, 1893, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1907, 'Bertrand, Eutrope', NULL, NULL, 1894, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1908, 'Hesronita, Johannes', NULL, NULL, 1895, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1909, 'Alexander VII', NULL, NULL, 1896, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1910, 'Bernaldo de Quirós, Antonio, Selectae disputationes theologicae de praedestinatione, Trinitate et angelis (Lugduni, 1658)', NULL, NULL, 1897, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1911, 'Alsted, Johann Heinrich, Clavis artis Lullianae (Strasbourg, 1651)', NULL, NULL, 1898, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1912, 'Estaing', NULL, NULL, 1899, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1913, 'Mastri, Bartolomeo, Compendium totius theologiae moralis B.M. de Meldula (Ravenna, 1686)', NULL, NULL, 1900, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1914, 'Sforza Pallavicino, Pietro, Assertionum theologicarum libri V. 1. De actibus humanis. 2. De gratia (Rome , Corbelletti, 1649)', NULL, NULL, 1901, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1915, 'Neustadt an der Weinstrasse', NULL, NULL, 1902, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1916, 'Adam, Jean, Octave de controverse sur le Très Saint Sacrement de
l''autel, où les paroles du Testament de Jésus-Christ sont prises en
figure par les protestans et en vérité par les catholiques (Bordeaux , G. de la Court, 1675)', NULL, NULL, 1903, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1917, 'Conimbricense, Collegium, In libros Ethicorum Aristotelis ad Nicomachum, aliquot
Conimbricensis Cursus disputationes in quibus praecipua quaedam Ethicae
disciplinae capita continentur (Lisboa, 1593)', NULL, NULL, 1904, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1918, 'Henriques, Henrique', NULL, NULL, 1905, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1919, 'Bary, René, la Vie triomphante de Louis le Juste, inJean Nicolaï (OP), Les
Triomphes de Louis le Juste, XIII. du nom, roy de France et de Navarre,
contenans les plus grandes actions où S.M. s''est trouvée en personne,
représentées en figures aenigmatiques, exposées par un poème héroïque
de Charles Beys, et accompagnées de vers françois sous chaque figure,
composez par P. de Corneille, avec les Portraits des rois, princes et
généraux d''armées qui ont assisté ou servy ce belliqueux Louis le Juste
combattant, et leurs devises et expositions en forme d''éloges, par
Henry Estienne,... sieur des Fossez... ensemble le Plan des villes,
sièges et batailles, avec un Abrégé de la vie de ce grand monarque, par
René Barry,... le tout traduit en latin par le R.P. Nicolai,... ouvrage
entrepris et finy par Jean Valdor,... calcographe du Roy... (Paris , Impr. Royale, 1649)', NULL, NULL, 1906, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1920, 'Daniel, Gabriel, Cleander et Eudoxus : seu de provincialibus quas vocant, literis, Dialogi,traduction latine (Puteolis, 1695)', NULL, NULL, 1907, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1921, 'Daniel, Gabriel, Histoire de France depuis l''établissement de la monarchie françoise dans les Gaules (Paris, 1729)', NULL, NULL, 1908, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1922, 'Adam, Jean, La Conduite des fidelles par les règles de la foy, les
maximes de l''Évangile et les saints devoirs des chrestiens dans tous
les estats, tirée de l''Escriture Sainte et des Pères de l''Église (Paris, 1680)', NULL, NULL, 1909, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1923, 'Ricci, Paolo, Sal foederis : philosophica, prophetica ac talmudistica pro christiana veritate tuenda cum iuniori hebreorum synagoga mirabili ingenii disputatio (Augsburg, 1515)', NULL, NULL, 1910, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1924, 'Summa theologiae scotisticae, 8 volumes (Chambéry , Blondet, 1718)', NULL, NULL, 1911, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1925, 'Adam, Jean, Response à la lettre de M. Daillé, ministre de Charenton,
publiée contre l''honneur de M. Cottiby, ministre de Poictiers converty
à la foy catholique, où sont réfutées les calomnies de ce ministre
contre le Pape, le Roy, les évesques et contre toute l''Eglise (Poitiers , J. Fleuriau, 1660)', NULL, NULL, 1912, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1926, 'Jiménez de Mejorada, Jacinto', NULL, NULL, 1913, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1927, 'Azpilcueta, Martín de, Enchiridon sive Manuale confessariorum et poenitentium (Paris , Michel Sonnius, 1602)', NULL, NULL, 1914, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1928, 'Titelmans, Frans', NULL, NULL, 1915, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1929, 'Castiglione, F., Cursus philosophicus (Venise, 1690)', NULL, NULL, 1916, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1930, 'Delgadillo, Cristóbal, Theoremata sacra. Theologia sacra, theologia subtilis scholastica, expositiva, theandrica et mariana (Roma , Iacobus Dragonellus, 1654)', NULL, NULL, 1917, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1931, 'Biblioteca Brancacciana', NULL, NULL, 1918, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1932, 'Aguilar, José de, Tractationes postumae in primam partem D. Thomae, 5 vol. (Córdoba de Tucumán, 1731)', NULL, NULL, 1919, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (4109, 'Bocholt', NULL, NULL, 4096, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1933, 'Scaliger, Julius Caesar, Oratio pro Cicerone contra Erasmum (Paris, 1531)', NULL, NULL, 1920, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1934, 'Vitry-le-François', NULL, NULL, 1921, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1935, 'Bassée, Eloi de la, Supplementum ad Flores theologiae practicae, sive tomus secundus (Anvers , Verdussen, 1660)', NULL, NULL, 1922, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1936, 'Cardillo de Villalpando, Gaspar, Commentarius in Aristotelis logica (Compluti, 1569)', NULL, NULL, 1923, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1937, 'Echeverria, Carlos de, Sermon de acción de gracias al dulcissimo Padre, illustrissimo Doctor y gloriosissimo patriarcha San Bernardo (Alcalá, 1693)', NULL, NULL, 1924, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1938, 'David, Pierre, Brevis et accurata summula totius philosophiae ad mentem doctoris subtilis, tria praesertim capita ista complectens : de ente,
substantia et accidente (Paris , Georges Josse, 1649)', NULL, NULL, 1925, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1939, 'Bellori G. B., Nota delli musei, librerie, galerie, et ornamenti di statue e pitture ne'' palazzi, nelle case e ne'' giardini di Roma, Roma 1664. (1664)', NULL, NULL, 1926, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1940, 'Manzoli, Bartholomaeus', NULL, NULL, 1927, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1941, 'Scaliger, Julius Caesar, De comicis dimensionibus (Lyon, 1539)', NULL, NULL, 1928, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1942, 'Vitoria, Francisco de', NULL, NULL, 1929, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1943, 'Cally, Pierre, Institutio philosophiae, 2 vol. (Caen, 1674)', NULL, NULL, 1930, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1944, 'Secrétaire chargé de la correspondance de la Congrégation du Saint-Office', NULL, NULL, 1931, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1945, 'anversa', NULL, NULL, 1932, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1946, 'Bonne Espérance, François de la, Christi Fidelium parochiale apologeticum (Bruxelles, 1667)', NULL, NULL, 1933, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1947, 'Jonghe, Jean de', NULL, NULL, 1934, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1948, 'Couvent des Grands Augustins (Paris)', NULL, NULL, 1935, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1949, 'Boucher, Jean', NULL, NULL, 1936, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1950, 'Scaliger, Julius Caesar, Primi tomi miscellaneorvm De Rervm causis &amp;amp; successibus atq. secretiori methodo ibidem expressa (Köln, 1570)', NULL, NULL, 1937, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1951, 'Egel, Ambrosius, Positiones de organo auditus et sono (Würzburg, 1772)', NULL, NULL, 1938, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1952, 'Azpilcueta, Martín de, Enchiridon sive Manuale confessariorum et poenitentium (Lyon , Guillaume Rouillé, 1580)', NULL, NULL, 1939, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1953, 'Crakanthorpe, Richard', NULL, NULL, 1940, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1954, 'Tamburini, Tommaso', NULL, NULL, 1941, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1955, 'L''attrition suffisante pour la rémission des péches dans le sacrement de pénitence (Lyon , Anisson, Posuel &amp;amp; Rigaud, 1687)', NULL, NULL, 1942, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1956, 'Tivoli', NULL, NULL, 1943, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1957, 'Benjumea, Blasco de', NULL, NULL, 1944, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1958, 'Fabri, Honoré, ractatus duo quorum prior est de plantis et De generatione animalium, posterior De homine (Paris , typ. François Muguet, 1666)', NULL, NULL, 1945, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1959, 'Bofill, Francesc', NULL, NULL, 1946, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1960, 'Montoro, Francisco', NULL, NULL, 1947, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1961, 'Fontana Vincenzo Maria, Monumenta dominicana breviter in synopsim collecta, Roma 1675. (1675)', NULL, NULL, 1948, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1962, 'Baron, Pierre', NULL, NULL, 1949, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1963, 'Abad, Diego José, De Deo Deoque homine heroica (Venezia , Pitteri, 1773)', NULL, NULL, 1950, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1964, 'Cornaeus, Melchior, Curriculum philosophiae peripateticae (Würzburg, 1657)', NULL, NULL, 1951, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1965, 'Weiss, Johann Baptist', NULL, NULL, 1952, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1966, 'Rodríguez, Luis, Dialecticae Aristotelis compendium, commentaria pluresque articuli super logicam Ioannis Duns Scoti (Salamanca , Antonio Rodríguez, 1624)', NULL, NULL, 1953, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1967, 'Bail, Louis, De triplici examine ordinandorum, confessariorum et paenitentium (Lyon, 1670)', NULL, NULL, 1954, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1968, 'Cippullo, Gregorio, Commentaria scholastica in tertiam D. Thomae partem (Roma, 1646)', NULL, NULL, 1955, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1969, 'Cattaneo, O., Cursus philosophicus in quatuor tomos divisus, le tome IV (complectens quaestiones et disputationes in universam metaphysicam) est mis à l''index "donec corrigatur" le 13 mars 1679 (Roma , Nicolo Angelo Tignasi, 1677)', NULL, NULL, 1956, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1970, 'Crom, Adrien', NULL, NULL, 1957, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1971, 'Benet, Cipriano, De prima Orbis sede de consilio et ecclesiastica potestate ac de S.D.N. Papae supremo insuperabilique domine Opus (Roma , Iaco. Mazzochius, 1512)', NULL, NULL, 1958, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1972, 'Bernini Domenico,  Historia di tutte l’heresie, 4 voll., Roma 1705-1708. (1705)', NULL, NULL, 1959, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1973, 'Combach, Johannes, Disputatio physica de coelo (Marburg, 1619)', NULL, NULL, 1960, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1974, 'Fyrbas, Simon', NULL, NULL, 1961, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1975, 'Castrovol, Pedro de', NULL, NULL, 1962, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1976, 'Ecuador', NULL, NULL, 1963, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1977, 'Páramo, Luis de', NULL, NULL, 1964, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1978, 'Rubio, Juan', NULL, NULL, 1965, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1979, 'Álvarez, Diego, Commentarii in Isaiam, 2 vol. (Roma, 1615)', NULL, NULL, 1966, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1980, 'Dedelley, Jakob', NULL, NULL, 1967, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1981, 'Campanella, Tommaso, Philosophia sensibus demonstrata (Naples, 1591)', NULL, NULL, 1968, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1982, 'Sghemma, Gaspare, Opusculum scoticum de scientia et voluntate Dei (Panormi , ex Typographia Petri de Isola, 1651)', NULL, NULL, 1969, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1983, 'Mamiani della Rovere, Luigi Vicenzo', NULL, NULL, 1970, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1984, 'Abad, Diego José, De Deo Deoque homine heroica (Cesena , Blasini, 1780)', NULL, NULL, 1971, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1985, 'Barbay, Pierre, Commentarius in Aristotelis Logicam (Parisiis, 1676)', NULL, NULL, 1972, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1986, 'Citta Della Pieve', NULL, NULL, 1973, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1987, 'Brennan, Patrick', NULL, NULL, 1974, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1988, 'Fabri, Honoré, Probabilismus methodo mathematica demonstratus, autor patre Pithanophilo (Lyon, 1747)', NULL, NULL, 1975, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1989, 'Brescia, Fortunato da, Dissertatio physico-theologica de qualitatibus corporum sensibilibus, Brixiae : excudebat Joannes-Maria Rizzardi, 1740 (1740)', NULL, NULL, 1976, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1990, 'Combach, Johannes, Disputatio metaphysica de causa et causato (Marburg, 1618)', NULL, NULL, 1977, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1991, 'Zaragoza y Vilanova, José, Trigonometria
hispana : resolutio triangulorum plani &amp;amp; Sphaerici, constructio
sinuum, tangentium, secantium &amp;amp; logarithmorum, eorumque vsus (Valencia, 1673)', NULL, NULL, 1978, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1992, 'Leerdam', NULL, NULL, 1979, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1993, 'Arias, Juan de', NULL, NULL, 1980, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1994, 'Barbay, Pierre, In universam Aristotelis philosophiam introductio (Parisiis, 1676)', NULL, NULL, 1981, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1995, 'Núñez de Losada, Cristóbal', NULL, NULL, 1982, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1996, 'Fantono, Girolamo, Repertorium locupletissimum tam librorum quam Sententiaru, quam Quodlibetarum doctoris subtilis Joannis Duns Scoti,
olim a doctissimo P.M.F. Hieronymum de Ferrariis Fantano Viglevanensi ordinis praedicatorum et haereticae pravitatis inquisitore (Venezia ,  ed. Julius Hissopus Cesenas, 1588)', NULL, NULL, 1983, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1997, 'Facciolati, Iacopo, Logicae disciplinae rudimenta (Padova , Giovanni Battista Albrizzi, 1728)', NULL, NULL, 1984, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1998, 'Sponde Henri de (Spondanus Henricus), Annalium ecclesiasticorum [… illustrissimis cardinalis ?] Caesaris Baronii continuatio ab anno 1197, quo is desiit, ad finem 1646, 2 t., Lyon 1678. (1647)', NULL, NULL, 1985, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (1999, 'Hesse', NULL, NULL, 1986, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2000, 'Buxheim', NULL, NULL, 1987, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2001, 'Saint-Paulien', NULL, NULL, 1988, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2002, 'Galilei, Mariotto', NULL, NULL, 1989, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2003, 'Bois, François Du, Commentarii in totam primam partem S. Tho. Aquinatis (Anvers , J. Meursius, 1667)', NULL, NULL, 1990, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2004, 'Politi, Ambrogio Catarino, Summa doctrinae de praedestinatione (...) adiicitur et lucubratio De
veritate enunciiationum; Summa idem doctrinae de peccato originali,
adiicitur et dialogus de justificatione (Rome, 1550)', NULL, NULL, 1991, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2005, 'Chasteignier, Henri-Louis de La Rochepozay, Celebriorum distinctionum, tum philosophicarum, tum theologicarum synopsis (Leiden, 1616)', NULL, NULL, 1992, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2006, 'Saint-Paul, Eustache de, Summa philosophiae quadripartita, de rebus dialecticis, moralibus et metaphysicis (Parisiis, 1614)', NULL, NULL, 1993, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2007, 'Siège inquisitorial de Venezia', NULL, NULL, 1994, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2008, 'Schöner, Johannes', NULL, NULL, 1995, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2009, 'Clavius, Christopher, Geometria practica (Roma, 1604)', NULL, NULL, 1996, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2010, 'Bary, René, La rhétorique françoise ou pour principale augmentation l''on trouve les secrets de nostre langue (Lyon , Amaulry, 1676)', NULL, NULL, 1997, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2011, 'Politi, Ambrogio Catarino, Defensio catholicorum pro possibili certitudine gratiae (Venise, 1547)', NULL, NULL, 1998, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2012, 'Araújo, Francisco de, Opuscula Tripartita : hoc est in tres controversias
triplicis Theologiae divisa, in quarum prima variae disputationes De
pure Scholastica, in secunda De morali et intertia De expositiva
theologia ; utiliter expenduntur (Douai , Bartholomé Bardou, 1633)', NULL, NULL, 1999, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2013, 'Duhan, Laurent, Philosophus in utramque partem, sive selectae et limatae difficultates in utramque partem, cum responsionibus ad usum scholae (Paris , Veuve C. Thiboust &amp;amp; P. Esclassan, 1697)', NULL, NULL, 2000, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2014, 'Piccinardi, Serafino, De Approbatione doctrinae sancti Thomae Aquinatis libri septem, tribus comprehensi tomis... auctore F. Seraphino Piccinardo,...,  Patavii : P.-M. Frambottus, 1683, 3 vol. (1683)', NULL, NULL, 2001, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2015, 'Del Camino, Manuel', NULL, NULL, 2002, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2016, 'Baronio, Bonaventura, Divus Anitius Manlius Boetius absolutus: sive De consolatione theologiae, libri quatuor (Romae, 1653)', NULL, NULL, 2003, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2017, 'Lemonnier, Pierre', NULL, NULL, 2004, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2018, 'Boyvin, Jean Gabriel, Theologia scoti a prolixitate et subtilitas eius ab obscuritate libera et vindicata, 4 vol., nona editio, correctior (Venezia , Girolamo Savioni, 1734)', NULL, NULL, 2005, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2019, 'Opava', NULL, NULL, 2006, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2020, 'Albiz, Martín de, De altissima scientia, inscrutabili voluntate, investigabili praedestinatione ac ineffabili Trinitate (Alcala, 1632)', NULL, NULL, 2007, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2021, 'Dingeon, Laurent', NULL, NULL, 2008, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2022, 'Mini, Bonaventura, Decisiones theologicae ex 4 Sententiarum libris Ioannis Duns Scoti selectae (1695)', NULL, NULL, 2009, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2023, 'Lestocq, Guillaume de', NULL, NULL, 2010, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2024, 'Bernique, Juan, Tractatus theologicus de Divina Scientia ad creaturas terminata iuxta mentem Mariani, subtilisque Magistri ac theologarum
Principis, Ioannis Duns Scoti Opus posthumum (Alcala, 1705)', NULL, NULL, 2011, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2025, 'Pomponazzi, Pietro, Tractatus de immortalitate animae, Bologna 1516 (1516)', NULL, NULL, 2012, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2026, 'Castelli, Benedetto, Opuscoli filosofici, Bologna : per G. Monti, 1669 (1669)', NULL, NULL, 2013, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2027, 'Falces de S. Stephano Ioannes, Ars ad solvenda omnia argumenta haereticorum cum evidentia falsitatis eorum, ex doctrina S. Thomae Aquinatis &amp; Sanctorum Patru…, Roma 1623 (1623)', NULL, NULL, 2014, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2028, 'Pampelonne', NULL, NULL, 2015, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2029, 'Hodierna, Giovanni Battista, Practicarum quaestionum ad famigeratum textum L. "hac edictali", C. "de secund. nupt.", semicenturia (Genève , Johann Hermann Widerhold, 1677)', NULL, NULL, 2016, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2030, 'Telesio, Bernardino, De Rerum Natura iuxta propria principia Libri IX. Neapoli, Apud Horatium Salvianum, MDLXXXVI (1586)', NULL, NULL, 2017, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2031, 'Palatino, Giovanni Battista, Libro di Giovanbattista Palatino,... nel qual s''insegna à scriver ogni sorte lettera, antica et moderna, di qualunque natione, con le sue regole, et misure, et essempi, et con un breve et util discorso de le cifre, riveduto nuovamente et corretto dal proprio autore... (Roma , A. Blado Arsolano, 1553)', NULL, NULL, 2018, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2032, 'Mariale, Sante, Biblioteca interpretum ad universam Summam theologiae divi Thomae Aquinatis Ecclesiae Doctoris. Hoc est solers examen universorum, quae a scriptoribus quibus quibuscunque tum antiquis, tum recentibus ad scholasticam theologiam hactenus evulgata sunt (Venetiis  , sumptibus Combi et La Nou, 1638)', NULL, NULL, 2019, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2033, 'Valero, Juan de', NULL, NULL, 2020, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2034, 'Maignan, Emmanuel, Cursus philosophicus, Toulouse 1652 (1652)', NULL, NULL, 2021, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2035, 'Saint-Paul, Eustache de, Summa philosophiae quadripartita, de rebus dialecticis, moralibus et metaphysicis (1619)', NULL, NULL, 2022, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2036, 'Villers-en-Prayères', NULL, NULL, 2023, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2037, 'Bayon, Nicolas, De decem Decalogi et quinque Ecclesiae praeceptis (Verdun, 1621)', NULL, NULL, 2024, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2038, 'Coccejus, Johannes, Ad Ultima Mosis, hoc est sex postrema capita Deuteronomii
considerationes, in quibus fundamentales veritates religionis
christianae ac canon prophetiae perspicue proponuntur (Franekerae, 1650)', NULL, NULL, 2025, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2039, 'Erndtlin, Joachim, Disputatio physica de corporum naturalium principis (Regensburg, 1620)', NULL, NULL, 2026, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2040, 'Leonardus Duardus, Commentaria in Bullam Pauli V lectam in die coenae Domini anno 1618, 3 ll., Mediolani 1619. (1619)', NULL, NULL, 2027, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2041, 'Azpilcueta, Martín de, Enchiridon sive Manuale confessariorum et poenitentium (Mayence , Balthasar Lippius (Arnold Mylius), 1601)', NULL, NULL, 2028, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2042, 'Diocèse de Rieti', NULL, NULL, 2029, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2554, 'Galitius de Carpenedulo, Marcus Antonius', NULL, NULL, 2541, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2043, 'Azpilcueta, Martín de, Enchiridon sive Manuale confessariorum et poenitentium (Anvers , Philippe Nutius, 1584)', NULL, NULL, 2030, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2044, 'Marischal College (University of Aberdeen)', NULL, NULL, 2031, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2045, 'Bruni, Celestino, Quodlibeticarum disputationum &lt;/i&gt;&lt;i&gt;pars prior theologica (Napoli, 1644)', NULL, NULL, 2032, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2046, 'Fabri, Honoré, Metaphysica demonstrativa, sive scientia rationum universalium, auctore Petro Mousnero, cuncta excerpta ex praelectionibus Honorati Fabri (Lyon , typ. Jean Champion, 1648)', NULL, NULL, 2033, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2047, 'Bail, Louis, La théologie affective ou saint Thomas en méditations (Paris, 1654)', NULL, NULL, 2034, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2048, 'McCaghwell, Hugh', NULL, NULL, 2035, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2049, 'Iribarne e Uraburu, Juan, Question comentatoria y declaratoria de la clausula decernentes etc.
del motu proprio de N.S.P. Gregorio XV despachado en favor de los
Padres Descalços a 24 de noviembre de 1621. Y juntamente oratoria y
supplicatoria de su revocacion o suspension: endereçada a los dos
Monarchas del mundo, Papa y Rey catholico Felipe III (1621)', NULL, NULL, 2036, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2050, 'Ferré, Vicent', NULL, NULL, 2037, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2051, 'Azpilcueta, Martín de, Enchiridon sive Manuale confessariorum et poenitentium (Valladolid , Diego Fernandez de Cordoba, 1589)', NULL, NULL, 2038, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2052, 'Bonne Espérance, François de la, Historico-theologicum carmeli armamentarium (Anvers, 1669)', NULL, NULL, 2039, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2053, 'Araújo, Francisco de, In tertiam partem diui Thomae commentarii : tomus secundus (Salamanca , ed. Convento de San Esteban, 1636)', NULL, NULL, 2040, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2054, 'Lingen', NULL, NULL, 2041, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2055, 'Luna, Alfonso de', NULL, NULL, 2042, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2056, 'Chasteignier, Henri-Louis de La Rochepozay, Celebriorum distinctionum, tum philosophicarum, tum theologicarum synopsis (Leiden , Wyngaerden, 1653)', NULL, NULL, 2043, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2057, 'Nifo, Agostino, De immortalitate animae libellus (Venetijs , impensa heredum quondam domini Octauiani Scoti Modoetiensis ac sociorum / 27 Octobris 1518, 1518)', NULL, NULL, 2044, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2058, 'Curiel, Juan Alfonso, Lecturae seu quaestiones in D. Thomae Primam Secundae (Duaci, 1618)', NULL, NULL, 2045, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2059, 'Peri, Giacomo, Subtilissimae contradictiones in prologum primum atque secundum Sententiarum Scoti. Opus perutile omnibus doctrinam Scoti profitentibus, aliorumque theologorum per modum dialogi digestum ac triplici indice ornatum (Florentiae , apud Petrum Cecconcellium, 1621)', NULL, NULL, 2046, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2060, 'Aymerich, Mateo, Quinti Moderati Censorini de vita et morte linguae latinae paradoxa
philologica criticis nonnullis dissertationibus exposita asserta et
probata (Ferrare, 1780)', NULL, NULL, 2047, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2061, 'Convento de San Juan de los Reyes (Toledo)', NULL, NULL, 2048, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2062, 'Boscovich, Ruggiero Giuseppe, Philosophiae naturalis theoria (Venise, 1763)', NULL, NULL, 2049, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2063, 'Riccioli, Giovanni Battista, Evangelium unicum Domini Nostri Iesu Christi ex verbis ipsis quatuor Evangelistarum conflatum et in meditationes distributum (Bologna, 1667)', NULL, NULL, 2050, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2064, 'Bassée, Eloi de la, Supplementum ad Flores theologiae practicae, sive tomus secundus (Lyon , Laurent Anisson, 1663)', NULL, NULL, 2051, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2065, 'Ramm, Matthias', NULL, NULL, 2052, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2066, 'Jesuitenkolleg (Neuburg)', NULL, NULL, 2053, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2067, 'Convento de Nossa Senhora da Piedade', NULL, NULL, 2054, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2068, 'Segura, Jacinto', NULL, NULL, 2055, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2069, 'Dreier, Christian, Sapientia seu Philosophia prima ex Aristotele et optimis
antiquis Graecis praesertim commentatoribus Methodo scientifica
conscripta et XX disputationibus in Academia Regiomontana
in usum discentium publice proposita (Königsberg, 1644)', NULL, NULL, 2056, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2070, 'Giannini, Tommaso, De substantia caeli &amp;amp; stellarum efficentia disputationes Aristotelicae (Venezia , Meietti, 1618)', NULL, NULL, 2057, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2071, 'Maffei, Tommaso Pio, Congressus scientificus publice habendi in Bibliotheca SS. Joannis et Pauli Venetiarum (Venetiis , ex typ. Poletana, 1693)', NULL, NULL, 2058, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2072, 'Daniel, Gabriel, Litterae ad Alexandrum dominicanum, in quibus thomistarum doctrina cum doctrina theologorum societatis Iesu comparatur, traduction latine (Augsburg-Dillingen , Bencard, 1700)', NULL, NULL, 2059, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2073, 'Casmann, Otto, Psychologia anthropologica, sive animae humanae doctrina, methodice informata (Hanau, 1594)', NULL, NULL, 2060, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2074, 'Russiliano Sesto Calabrese, Tiberio', NULL, NULL, 2061, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2075, 'Vieira, António', NULL, NULL, 2062, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2076, 'Aliaga Martínez, Luis de', NULL, NULL, 2063, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2077, 'Bary, René, Réflexions chrétiennes sur les plus beaux principes de la morale (Paris , C. Osmont, 1678)', NULL, NULL, 2064, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2078, 'Alsted, Johann Heinrich, Physica
harmonica, quatuor libellis methodice proponens I. Physicam Mosaicum.
II. Physicam Hebræorum. III. Physicam Peripateticam. IV. Physicam
chemicam (1616)', NULL, NULL, 2065, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2079, 'Fabri, Honoré, Corolla virgenea opusculum, in quo, nova methodo, quid de controversia Immaculatae Conceptionis Virginis Deiparae censendum sit
ex constitutionibus et decretis apostolicis concluditur (Palermo, 1655)', NULL, NULL, 2066, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2080, 'Mencholini, Luca', NULL, NULL, 2067, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2081, 'Nifo, Agostino, Agostino, Aristotelis topica inventio interpretata atque exposita (Paris, 1540)', NULL, NULL, 2068, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2082, 'Bary, René, Journal de la conversation, où les plus belles matières sont agitées de part et d''autre (Paris , Jean Couterot, 1673)', NULL, NULL, 2069, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2083, 'Riccioli, Giovanni Battista, Ristretto della vita di S. Rosalia vergine palermitana (Bologna, 1666)', NULL, NULL, 2070, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2084, 'Galilei, Roberto', NULL, NULL, 2071, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2085, 'Bancel, Louis, Moralis divi Thomae doctoris angelici ordinis praedicatorum, ex
omnibus ipsius operibus ita exacte deprompta, ut censeri possit opus
novum: omnibus cuiusque conditionis personis, sed maxime confessariis,
&amp;amp; concionatoribus vtilissimum ... Adiecta sunt variis in locis
decreta summorum pontificum ... Accedit quoque opusculum de castitate (Venezia , Andrea Poletti, 1723)', NULL, NULL, 2072, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2086, 'Adam, Jean, Heures catholiques en latin et en françois, suivant le saint Concile de Trente (Paris, 1651)', NULL, NULL, 2073, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2087, 'Brescia, Fortunato da, Cornelii Jansensi sistema de gratia Christi methodice expositum et theologice confutatum (Madrid, 1760)', NULL, NULL, 2074, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2088, 'Forti, A.', NULL, NULL, 2075, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2089, 'Valderas', NULL, NULL, 2076, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2090, 'Galilei, Galileo, Systema cosmicum, ed. Bernegger, Matthias (Strasbourg, Impensis Elzeviriorum, typis Davidis Hautti, 1635)', NULL, NULL, 2077, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2652, 'Vianen, Van', NULL, NULL, 2637, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2091, 'Rossi da Lugo, Alessandro, Commentaria in libros Aristotelis de anima (Bologna, 1659)', NULL, NULL, 2078, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2092, 'Trombetta, Antonio, Questio profunda de efficientia primi principij ad mentem
Aristotelis ; adiecta sublili questione Nunquid adultus non baptizatus
saluari possit (Venetiis, 1513)', NULL, NULL, 2079, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2093, 'Paris, Yves de, Digestum sapientiae, 4 vol. (Paris, 1643)', NULL, NULL, 2080, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2094, 'Cinammo, L.', NULL, NULL, 2127, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2095, 'Conimbricense, Collegium, In quatuor libros de Coelo Aristotelis Stagiritae (Lyon , Guichard Jullieron / Ex officina Iuntarum, 1594)', NULL, NULL, 2081, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2096, 'Riché, Jean', NULL, NULL, 2082, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2097, 'Friedberg', NULL, NULL, 2083, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2098, 'Ortiz, José', NULL, NULL, 2084, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2099, 'Ecole unitarienne (Smigel)', NULL, NULL, 2085, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2100, 'Trombetta, Antonio, Quinque illustrium auctorum formalitatum libelli. Nempe, Antonij
Syrecti, cum annotationibus Mauritij. Stephani Burlipheri. Mauritij
Hibernatis. Antonij Trombetae, &amp;amp; Laurentij Brixiensis. Cum indice
amplissimo (Venetiis , apud Franciscum de Franciscis Senensem, 1588)', NULL, NULL, 2086, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2101, 'Summa philosophiae scholasticae et scotisticae, 4 volumes (Padova , typis Seminarii &amp;amp; J. Manfrè, 1718)', NULL, NULL, 2087, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2102, 'Boyvin, Jean Gabriel, Theologia scoti a prolixitate et subtilitas eius ab obscuritate libera et vindicata, 4 vol., Tertia editio correctior (Paris , Edmond Couterot, 1677)', NULL, NULL, 2088, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2103, 'Taranto', NULL, NULL, 2089, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2104, 'Lorin Jean [Lorini], Commentariorum in librum Psalmorum Tomus I / Tomus III, Lyon 1612-1616. (1612)', NULL, NULL, 2090, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2105, 'de Ulloa, Juan, Prodomus, seu prolegomena ad scholasticas disciplinas (Madrid , ex typografia Antonii Marin, 1748)', NULL, NULL, 2091, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2106, 'Melun', NULL, NULL, 2092, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2107, 'Vernaz, Ennemond, Theses theologicae, praes. Simon Martin et Thomas Crust (Chambéry, 1723)', NULL, NULL, 2093, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2108, 'Henri III', NULL, NULL, 2094, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2109, 'Latini, Simone', NULL, NULL, 2095, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2110, 'Lobera, Antonio', NULL, NULL, 2096, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2111, 'Luzern', NULL, NULL, 2097, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2112, 'Lippomano, Tommaso', NULL, NULL, 2098, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2113, 'Alonso, Francisco, Disputationes in octo libros Physicorum (Alcalá , typ. Antonio Vazquez, 1640)', NULL, NULL, 2099, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2114, 'Brescia, Fortunato da, Philosophia sensuum mechanica methodica tractata atque ad usus accomadata, tomus 4 : Physices particularis pars secunda (Venise, 1761)', NULL, NULL, 2100, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2115, 'Bancel, Louis, Moralis D. Thomae Aquinatis doctoris Angelici ordinis praedicatorum
ex operis ipsius exacte deprompta, in unum collecta, &amp;amp; alphabetico
ordine congesta ad modum dictionarii theologico-moralis, 2 vol. (Venezia, J.B. Novelli, 1757)', NULL, NULL, 2101, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2116, 'Báñez, Domingo, Scholastica commentaria in primam partem angelici doctoris S. Thomae (Salamanque , Matias Gast, 1585)', NULL, NULL, 2102, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2117, 'Coccejus, Johannes, Lexicon et Commentarius sermonis Hebraici et Chaldaici, editio altera... opera atque studio Johannis Henrici Maji (Francofurti, 1689)', NULL, NULL, 2103, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2118, 'Parker, Thomas', NULL, NULL, 2104, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2119, 'Casa Profesa São Roque (Lisboa / Jesuitas)', NULL, NULL, 2105, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2120, 'Burgersdijk, Franco, Idea oeconomicae et politicae doctrinae (Leiden, 1644)', NULL, NULL, 2106, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2121, 'Mastri, Bartolomeo, Philosophiae ad mentem Scoti cursus integer (Venezia, 1688)', NULL, NULL, 2107, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2122, 'Serry J. H., De romano pontificie in ferendo de fide moribusque judicio, falli et fallere nescio. Eodemque Conciliis oecumenicis auctoritate potestate jurisdictione, superiori: dissertatio duplex. Accedit appendix De mente ecclesiae gallicanae et academaie parisiensis, circa duo illa sedis apostolicae privilegia, Patavii 1732, in 8°. (1732)', NULL, NULL, 2108, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2123, 'Pierre (Petrus), Barthélémy', NULL, NULL, 2109, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2124, 'Azpilcueta, Martín de, Enchiridon sive Manuale confessariorum et poenitentium (Lyon , Guillaume Rouillé, 1574)', NULL, NULL, 2110, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2125, 'Neustadt', NULL, NULL, 2111, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2126, 'Conimbricense, Collegium, In Universam Dialecticam Aristotelis (Köln, 1607)', NULL, NULL, 2112, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2127, 'Iavelli, Crisostomo, Metaphysica (Lyon, 1553)', NULL, NULL, 2113, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2128, 'Sforza Pallavicino, Pietro, Assertionum theologicarum liber septimus de poenitentia (Rome , Corbelletti, 1652)', NULL, NULL, 2114, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2129, 'Álvarez, Diego, Opus praeclarum nunquam hactenus editum : in quo argumentis
... Concordia liberi arbitrii cum divina praescientia,
praedestinatione, &amp;amp; efficacia Gratiae praeuenientis ad mentem S.
Thomae, &amp;amp; omnium tho mistrarum contra los qui eam impugnare volunt,
defenditur &amp;amp; explicatur / huic accessit historia de origine
pelagianae heresis / ab eodem authore ex variis authoribus collecta (Douai, 1635)', NULL, NULL, 2115, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2130, 'Cano, Juan, Cursus philosophicus (Salamanca, 1689)', NULL, NULL, 2116, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2131, 'Frkic, Mate, Apologiae pro Ioanne Duns Scoto doctore subtili libri tres : in
Ioannem Fridericum Matenesium, in Abrahamum Bzouium Polonum, in Paulum
Iouium Nouocomensem (Bologna , typ. Sebastiano Bonomii, 1620)', NULL, NULL, 2117, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2132, 'Bonnet, Charles', NULL, NULL, 2118, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2133, 'Pasqualigo, Zaccaria, Disputationes metaphysicae, vol. I (romae, 1634)', NULL, NULL, 2119, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2134, 'Convento de Santo Domingo (Plasencia)', NULL, NULL, 2120, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2135, 'Conti, Pietro, Tractatus de intellectu et scientia Dei (Patavii , Typis Petri Maria Frambotti, 1684)', NULL, NULL, 2121, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2136, 'Millán de Zerezeda, Emiliano', NULL, NULL, 2122, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2137, 'Busembaum, Hermann, editio ultima ab auctore recognita (Lille , Ignace &amp;amp; Nicolas de la Rache, 1654)', NULL, NULL, 2123, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2138, 'Siège inquisitorial de Belluno', NULL, NULL, 2124, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2139, 'Senftleben, Johann', NULL, NULL, 2125, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2140, 'Pourchot, Edmond, Institutiones philosophicæ ad faciliorem veterum, ac recentiorum philosophorum lectionum comparatæ (Padova, ex Typographia Seminarii : apud Joannem Manfrè, 1738)', NULL, NULL, 2126, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2141, 'Dechamps, Etienne-Agard, Defensio
censurae sacrae facultatis theologiae Parisiensis latae XXVII. Iunij
anni MDLX. seu disputatio theologica de libero arbitrio. Editio quinta, iuxta Parisiensem auctiorem 1646, incl. Responsio eiusdem ad obiectiones Vincentianas Vincentii Lenis (Köln , Jodocus Kalcovius &amp;amp; Socios, 1650)', NULL, NULL, 2128, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2142, 'Conimbricense, Collegium, In octo libros Physicorum Aristotelis Stagiritae (Venezia , apud Iacobum Vincentium et Riccardum Amadinum, 1606)', NULL, NULL, 2129, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2143, 'Fracastoro, Girolamo, De causis criticorum dierum (1538)', NULL, NULL, 2130, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2144, 'Archidona', NULL, NULL, 2131, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2145, 'Mastri, Bartolomeo, Theologia moralis ad mentem S. Bonaventurae et Scoti (Venezia, 1688)', NULL, NULL, 2132, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2146, 'Cahors', NULL, NULL, 2133, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2147, 'Bonne Espérance, François de la, Historico-theologicum carmeli armamentarium (Cologne, 1669)', NULL, NULL, 2134, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2148, 'Galilei, Galileo, Opere (Firenze, nella Stamp. di s.a.r. per Gio. Gaetano Tartini e Santi Franchi, 1718)', NULL, NULL, 2135, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2149, 'Malafossa, Giacomino, Oratio seu deprecatio deuotissima ad obtinendam remissionem omnium peccatorum, gratiamque omnem juste petitam a Deo (Patavii, 1562)', NULL, NULL, 2136, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2150, 'Vázquez, Gabriel, Commentariorum in tertiam partem, 4 vol. (Alcala, 1609)', NULL, NULL, 2137, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2151, 'Inchofer Melchior, Historiae sacrae latinitatis libri VI : lectiunculis exquisitis, jucundisque narrationibus animus relaxantes auctore Melchiore Inchofer, Monachii : apud Melchiorem Segen, anno 1638. (1638)', NULL, NULL, 2138, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2152, 'Medrano, Joaquín de', NULL, NULL, 2139, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2153, 'Caramuel Lobkowitz, Juan, Anitius Manlius Torquatus Severinus Boetius, expresso stylo Caramuelis, Pragae, Ex Typographia Georgii Schyparz, 1648 (1648)', NULL, NULL, 2140, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2154, 'Riccardi Niccolò, Historiae concilii Tidentini Emaculatae Synopsis, Roma 1637, L. Grignani, 29 p. (1637)', NULL, NULL, 2141, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2155, 'Legrand, Jean', NULL, NULL, 2142, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2156, 'Rocco, Antonio, De immortalitate animae rationalis via peripatetica libri duo (S.L. , Francofurtii, 1644)', NULL, NULL, 2143, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2157, 'Castellano, Fernando', NULL, NULL, 2144, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2158, 'Frkic, Mate, Epitome theologicum M.F. Veglensis ... ex Magistro
Sententiarum [i.e. Petrus Lombardus] et ... Jo. [Duns] Scoto, a M.P.M.
Rusca ... evulgatum, 4 vol. (Padova, 1647)', NULL, NULL, 2145, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2159, 'Descartes, René, Meditationes de prima philosophia, Paris 1641 (1641)', NULL, NULL, 2146, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2160, 'Compton Carleton, Thomas, Philosophia universa. Editio tertia (Anvers, 1697)', NULL, NULL, 2147, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2161, 'Bois, François Du, t. V : Opuscula varia (S.L. , Verdussen, 1698)', NULL, NULL, 2148, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2162, 'Celaya, Juan de, Expositio in primum tractatum Summularum magistri Petri Hispani (Paris , Jean du Pré / Jacques Le Messier, 1515)', NULL, NULL, 2149, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2163, 'Olp', NULL, NULL, 2150, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2164, 'Mencholini, Luca, Contradictiones Scoti, tam litterales, tum virtualiter tales tum dictis sanctorum et philosophorum oppositis in prologum, primum, atque secundum Sententiarum Subtilis Doctoris (Florentiae, 1621)', NULL, NULL, 2151, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2165, 'Jansenius, Cornelius', NULL, NULL, 2152, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2166, 'Pennotti, Gabriele', NULL, NULL, 2153, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2167, 'Baronio, Bonaventura, Joannes Duns Scotus,... de Deo trino, contra adversantes quosque defensus (Lugduni, 1668)', NULL, NULL, 2154, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2168, 'Mastri, Bartolomeo, Poema eroicum in laudem S. Bonaventura (Bologna, 1620)', NULL, NULL, 2155, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2169, 'Chalmers, William, Selectae disputationes philosophicae (Paris, 1630)', NULL, NULL, 2156, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2170, 'Damen, Hermann', NULL, NULL, 2157, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2171, 'Fasolini, Benedetto', NULL, NULL, 2158, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2172, 'Saint-Paul, Eustache de, Summa philosophiae quadripartita, de rebus dialecticis, moralibus et metaphysicis (S.L. , Lugduni, 1620)', NULL, NULL, 2159, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2173, 'Calatayud, Vicente', NULL, NULL, 2160, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2174, 'Castro, Alfonso de, Adversus omnes haereses libri XIIII (Paris, 1560)', NULL, NULL, 2161, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2175, 'Albacete', NULL, NULL, 2162, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2176, 'Dabillon, André, La physique des bons esprits, ou l''Idée et abrégé d''une physique familière et solide divisée en cinq livres (Paris, 1643)', NULL, NULL, 2163, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2177, 'Landau In Der Pfalz', NULL, NULL, 2164, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2178, 'Duhan, Laurent, Philosophus in utramque partem, sive selectae et limatae difficultates in utramque partem, cum responsionibus ad usum scholae (Paris , Sumptibus Societatis, 1728)', NULL, NULL, 2165, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2179, 'Estanyol, Angel', NULL, NULL, 2166, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2180, 'Encinas, Fernando, Primus tractatus summularum (Compluti , in officina Petri Rigaudi, Guillermus impressit, 1523)', NULL, NULL, 2167, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2181, 'Compton Carleton, Thomas, Cursus theologicus tomus prior ea brevitate conscriptus,
quam tot, tantaque rerum amplitudo et varietas patitur, quas prima pars
et prima secundae Divi Thomae complectuntur, quaestiones insuper ad
mores, et praxim spectantes quae peculiarem cum scholasticis habent
connexionem declarantur (Liège, 1659)', NULL, NULL, 2168, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2182, 'Mennekens, Arnold', NULL, NULL, 2169, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2183, 'Azpilcueta, Martín de, Enchiridon sive Manuale confessariorum et poenitentium (Anvers , Voeuve &amp;amp; Héritiers de Pierre Bellère (André Bacx), 1608)', NULL, NULL, 2170, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2184, 'Brandis, Christoph', NULL, NULL, 2171, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2185, 'Córdoba, Antonio de, Opera, libris quinque digesta : I. Quaestionarium theologicum, II. De ignorantia, III. De conscientia, 
IV. Arma fidei et Ecclesiae, seu de potestate Papae, V. De Indulgentiis (Venise, 1569)', NULL, NULL, 2212, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2186, 'Paludanus, Henricus', NULL, NULL, 2213, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2187, 'Ricci, Giuseppe, Fundamentum theologiae moralis, seu de conscientia probabili : opus in quo summa concordia et doctrinae
uniformitas maxima inter omnes Doctores catholicos tam probabilistas quam probabilioristas in assignanda proxima regula
honestatis et formanda conscientia in materia opinativa seu probabili, ob oculos proponitur, et solum rem esse cum novatoribus (Napoli, 1702)', NULL, NULL, 2172, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2188, 'Riva', NULL, NULL, 2173, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2189, 'Contenson, Vincent, Theologia mentis et cordis seu speculationes universae doctrinae sacrae (Cologne, 1722)', NULL, NULL, 2174, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2190, 'Boyvin, Jean Gabriel, Theologia scoti a prolixitate et subtilitas eius ab obscuritate libera et vindicata, 4 vol., editio quarta multum aucta (Paris , Edmond Couterot, 1678)', NULL, NULL, 2175, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2191, 'Cardillo de Villalpando, Gaspar, Commentarius in Aristotelis logica (Compluti, 1584)', NULL, NULL, 2176, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2192, 'Universidad de Barcelona, Facultad de Teología', NULL, NULL, 2177, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2193, 'Mauri, Silvestro, Quaestionum philosophicarum libri quinque, Romae 1670 (1670)', NULL, NULL, 2178, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2194, 'Olivieri, Maurizio Benedetto', NULL, NULL, 2179, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2195, 'Saint-Paul, Eustache de, Summa philosophiae quadripartita, de rebus dialecticis, moralibus et metaphysicis (1647)', NULL, NULL, 2180, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2196, 'Oropesa', NULL, NULL, 2181, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2653, 'Milan, Duché de', NULL, NULL, 2638, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2197, 'Duhan, Laurent, Philosophus in utramque partem, sive selectae et limatae difficultates in utramque partem, cum responsionibus ad usum scholae (Paris , Veuve C. Thiboust &amp;amp; P. Esclassan, 1694)', NULL, NULL, 2182, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2198, 'Levermé, Gilbert', NULL, NULL, 2183, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2199, 'Tesauro, Emanuele, Il Cannocchiale aristotelico, o sia l''idea dell''arguta e
ingeniosa elocutione che ferue a tutta l''arte oratoria, lapidaria et
simbolica esaminata co'' principii del divino
Aristotele (Torino, 1670)', NULL, NULL, 2184, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2200, 'Bauny, Etienne, Tractatus de censuris ecclesiasticis (Paris, 1642)', NULL, NULL, 2185, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2201, 'Royal Society', NULL, NULL, 2186, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2202, 'Helmond', NULL, NULL, 2187, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2203, 'Clauberg, Johannes, Initiatio philosophi, sive dubitatio Cartesiana, ad metaphysicam certitudinem viam aperiens (Leiden, 1655)', NULL, NULL, 2188, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2204, 'Bois, François Du, Commentarii in totam primam secundae partem S. Tho. Aquinatis (Anvers , J. Meursius, 1667)', NULL, NULL, 2189, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2205, 'Albertini, Francesco, Explicatio I et II Posteriorum analyticorum (Venezia, 1606)', NULL, NULL, 2190, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2206, 'Siège inquisitorial de Bologna', NULL, NULL, 2191, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2207, 'Iavelli, Crisostomo, Commentarii in VIII libros Physicorum Aristotelis (Lyon, 1556)', NULL, NULL, 2192, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2208, 'White, Thomas', NULL, NULL, 2193, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2209, 'Musoles, Felipe', NULL, NULL, 2194, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2210, 'Campuzano, Francisco', NULL, NULL, 2195, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2211, 'Albertini, Francesco, Trattato dell''Angelo Custode, cavato fedelmente da alcune prediche (Napoli, 1612)', NULL, NULL, 2196, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2212, 'Plettenberg Hunold, Notitia Congregationum et Tribunalium Romanae Curiae, Hildesii 1693, Typ. J. Lonardi Schlegel. (1693)', NULL, NULL, 2197, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2213, 'Nesselwang', NULL, NULL, 2198, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2214, 'Gil Becerra, Benito, Asserto theo-subtilia, vel theologica sisthemate de essentia et efficacia voluntatis divinae et moralitate voluntatis humanae (Barcelona , José Geralt, 1737)', NULL, NULL, 2199, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2215, 'Benoît du Pertuis', NULL, NULL, 2200, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2216, 'Adam, Jean, Projet présenté à MM. de la religion prétendue réformée de
la ville et souveraineté de Sedan, qui ont témoigné durant la vie de
Monseigneur le maréchal de Fabert de grandes dispositions à r''entrer
dans l''Église catholique, apostolique et romaine (Paris , F. Muguet, 1663)', NULL, NULL, 2201, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2217, 'Casimir III - le Grand', NULL, NULL, 2202, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2218, 'Clauberg, Johannes, Ontosophia nova, quae vulgo Metaphysica, Theologiae,
Iurisprudentiae et Philologiae, praesertim Germanicae studiosis
accomodata. Accessit Logica contracta, et quae ex ea demonstratur
Orthographia Germanica (Duisburg, 1660)', NULL, NULL, 2203, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2219, 'Crab, Gilbert, Habes humanissime lector aethice. seu moralium libros decem
Ari. traditionem Joannis Argiropili: In quibus humane vite decursus
perpulchre describit de novo correctos ac emendatos nusque policiores
inventos: cum marginalibus additionibus textum elucidantibus
Preterea capiti invenies adiunctas annotationes seu declarationes
Gilberti Crab, ponentes difinitiones divisiones: Et notanda in decem
perdictos libros: quibus intellectis facile quis textus obscuritat ...
discernit (Paris , Gilles de Gourmont, 1510)', NULL, NULL, 2204, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2220, 'Trombetta, Antonio, Insigne formalitatum opus de mente Doctoris Subtilis vna cum
editione ... Urbinatis episcopi Antonij Trombete ... Excussum latebris
habes volumen Sirecti (Venetiis , Octauiani Scoti Modoetiensis, et sociorum, 1516)', NULL, NULL, 2205, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2221, 'Clauberg, Johannes, De philosophiae fontibus derivata ; id est, via
Germanicarum vocum et origines et praestantiam detegendi ; cum plurium
tum harum Vernunft, Suchen, Außspruch exemplis atque exinde enatis
regulis praemonstrata (Duisburg, 1663)', NULL, NULL, 2206, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2222, 'Bassée, Eloi de la, Abrégé des deux précédents par Grégoire de Salamanque 
sous forme d''un Compendium, hoc est summa summae ex summario et supplemento quaestionum stylo elaborata, ac coordinata, 1 vol. in-fol. (Lyon, 1674)', NULL, NULL, 2207, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2223, 'Erndtlin, Joachim, Disputatio philosophica de quibus difficultatibus logicis (Ingolstadt, 1619)', NULL, NULL, 2208, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2224, 'Mastri, Bartolomeo, Disputationes theologicae in libros sententiarum quibus ab
adversantibus tum veterum tum recentiorum iaculis Scoti theologia
vindicatur, 4 vol. (Venezia , Typ. Balleoniana, 1698)', NULL, NULL, 2209, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2225, 'Jiménez Samaniego, José, Vida del venerable padre Juan Dunsio Escoto, doctor mariano y subtil (Madrid , Bernardo de Villadiego, 1668)', NULL, NULL, 2210, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2226, 'Cadana, Salvatore', NULL, NULL, 2211, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2227, 'Torres Vedras', NULL, NULL, 2214, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2228, 'Delft', NULL, NULL, 2215, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2229, 'Adam, Jean, Calvin deffait par soy-mesme et par les armes de S. Augustin
qu''il avait injustement usurpées sur les matières de la Grâce, de la
Liberté et de la Predestination (paris , Gaspar Meturas, 1650)', NULL, NULL, 2216, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2230, 'Bartoli, Daniello, La tensione e la pressione disputanti qual di loro sostenga l''argentovivo ne'' cannelli dopo fattone il vuoto, Roma 1677 (1677)', NULL, NULL, 2217, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2231, 'Saint-Paul, Eustache de, Summa theologiae tripartita : de Deo, rebusque divinis ac supernaturalibus (Parisiis, 1616)', NULL, NULL, 2218, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2232, 'Scribon, Jean-Marie', NULL, NULL, 2219, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2233, 'Alsted, Johann Heinrich, Systema physicae harmonicae : quatuor libellis methodice propositum (Herborn, 1612)', NULL, NULL, 2220, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2234, 'Bary, René, Les secrets de nostre langue&lt;/i&gt; [seconde partie de la &lt;i&gt;Rhétorique françoise (Paris , Pierre Le Petit, 1665)', NULL, NULL, 2221, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2235, 'Volmar, Johannes', NULL, NULL, 2222, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2236, 'Sforza Pallavicino, Pietro, Vindicationes Societatis Iesu quibus multorum accusationes in eius institutum, leges, gymnasia, mores refelluntur (Rome , Dom. Menelfo, 1649)', NULL, NULL, 2223, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2237, 'Gallo, Juan', NULL, NULL, 2224, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2238, 'Daniel, Gabriel, Cleander
et Eudoxus seu de provincialibus litteris dialogi, quibus Societas Jesu
a gravibus adversantium calumniis in geniose, eleganter, docte, solide
vindicatur (Augsburg-Dillingen , Bencard, 1696)', NULL, NULL, 2225, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2239, 'Azpilcueta, Martín de, Enchiridon sive Manuale confessariorum et poenitentium (Würzburg , Georg Fleischmann, 1593)', NULL, NULL, 2226, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2240, 'Guglielmini, Giovanni Battista', NULL, NULL, 2227, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2288, 'Morin Jean Baptiste, Famosi et antiqui problematis de telluris motu vel quiete: cactenus optata solutio, Parisii 1631. (1631)', NULL, NULL, 2275, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2289, 'Bayon, Nicolas, De sacramentis Ecclesiae et sacrosanctae missae sacrificio liber (Verdun, 1620)', NULL, NULL, 2276, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2654, 'Strigelius, Victorinus', NULL, NULL, 2639, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2241, 'Sessa Giovanni Antonio (Antonius da Panormo), Scrutinium doctrinarum qualificandis assertionibus, thesibus ac libris conducentium, exemplis propositionum a Conciliis oecumenicis, vel ab Apostolica Sede reprobatarum ditatum, ac plerisque miscellaneis resolutionibus dogmatico-moralibus ad uberiorem censurarum theologicarum notitiam collimantibus refertum […], Roma 1709, Rochi Bernabò, in-fol., [XXXVI]/561/[LX] p. (1709)', NULL, NULL, 2228, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2242, 'Island', NULL, NULL, 2229, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2243, 'Conimbricense, Collegium, In octo libros Physicorum Aristotelis Stagiritae (Köln , Lazarus Zetzner, 1616)', NULL, NULL, 2230, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2244, 'Elbel, Benjamin', NULL, NULL, 2231, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2245, 'Fabri, Honoré, Opusculum geometricum de linea sinuum et cycloide (Roma , typ. F. Corbelletti, 1659)', NULL, NULL, 2232, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2246, 'Báñez, Domingo, Scholastica commentaria in primam partem angelici doctoris S. Thomae (Venise, 1602)', NULL, NULL, 2233, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2247, 'Monzón, Bartolomé', NULL, NULL, 2234, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2248, 'Chabron, Guillaume, Philosophia per argumenta breviter explicata ad usum et exemplum huius scientiae studio vacantium, 
vol. 1 : Logica et metaphysica ; vol. 2 : Prima pars physicae ; vol. 3 : Altera pars physicae et moralis, Editio nova (Paris , Gaspar Meturas, 1664)', NULL, NULL, 2235, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2249, 'Benet, Cipriano, Tractatus de non mutando Paschate et contra servile pecus Iudeorum Aculeus (Roma , Marcellus Silber alias Franck, 1515)', NULL, NULL, 2236, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2250, 'Brescia, Fortunato da, Cornelii Jansensi sistema de gratia Christi methodice expositum et theologice confutatum (Brescia, 1766)', NULL, NULL, 2237, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2251, 'Della Faille, Jean Charles, Theoremata de centro gravitatis partium circuli et ellipsis (Anvers, 1632)', NULL, NULL, 2238, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2252, 'Baldelli, Niccolo, Disputationum ex morali theologia libri quinque. I. De humanis
actionibus in universum. II. De vitiis et peccatis. III. De vitiis capitalibus. IV. De conscientia. V. De legibus quae omnia, tum ex principiis et doctrina S. Thomae, veterumque theologorum, tum vero ex
decretis sacrorum canonum summorumque pontificium sanctionibus, et ex placitis utriusque juris doctorum accuratissime disseruntur (Lyon , Gabriel Boissat, 1637)', NULL, NULL, 2239, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2253, 'Paravicino, Ortensio Felix', NULL, NULL, 2240, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2254, 'Piccart, Michael', NULL, NULL, 2241, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2255, 'Vives, Jerónimo, De primatu divinae libertatis ad sciendum, et decernendum de contingentibus, Liber et tomus primus contra Scientiam mediam (Valence, 1654)', NULL, NULL, 2242, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2256, 'Zuaznabar, Martin de', NULL, NULL, 2243, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2257, 'Coccejus, Johannes, Opera Anecdota Theologica et Philologica, divisa in duo Volumina (Amstelodami, 1706)', NULL, NULL, 2244, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2258, 'Telles, Baltazar', NULL, NULL, 2245, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2259, 'Zaragoza y Vilanova, José, Canon trigonometricus : continens logarithmos, sinuum et
tangentium, ad singula scrupula totius semicirculi : radij logarithmo,
10.0000000 (Madrid, 1672)', NULL, NULL, 2246, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2260, 'Adam, Jean, Les Pseaumes de David en latin et en françois, avec les
onze cantiques dont l''Eglie [sic] se sert dans l''office pour toute
l''année. Et quelques prieres &amp;amp; veritez catholiques tirées des
Pseaumes &amp;amp; des Cantiques (Paris, 1651)', NULL, NULL, 2247, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2261, 'Barbay, Pierre, Commentarius in Aristotelis Physicam (Parisiis, 1980)', NULL, NULL, 2248, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2262, 'Mastri, Bartolomeo, Compilatio præcipuarum disputationum, et quæstionum, cum suis probabilioribus opinionibus Theologiæ moralis a. r. p. m. B.M, 4 vol. (Barcelona, 1687)', NULL, NULL, 2249, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2263, 'Spinula, Stefano, Novissima Philosophia, Gênes 1651 (1651)', NULL, NULL, 2250, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2264, 'Crab, Gilbert, Aristotelis Ethicorum decem libri ad Nicomachum Argyropylo
Byzantino traductore. Cum subtili et eliminata textibus explanatione:
adiectis etiam difficultates morales &amp;amp; theologicas a Gilberto
Crabartium precepto (Lyon , Simon Vincent &amp;amp; Jacques Maréchal, 1517)', NULL, NULL, 2251, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2265, 'Palencia', NULL, NULL, 2252, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2266, 'Couvent des Célestins (Paris)', NULL, NULL, 2253, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2267, 'Cuéllar, José de', NULL, NULL, 2254, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2268, 'Fantuzzi, Giovanni', NULL, NULL, 2255, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2269, 'Arnu, Nicolas, Clypeus philosophiae thomisticae veridica S. Thomae Aquinatis
Doctoris Angelici et Alberti Magni doctrina exornatus validisque eorum
rationibus munitus contra novos ejus impugnatores, 6 vol. in-18 (Béziers , Henri Martel, 1672)', NULL, NULL, 2256, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2270, 'Agostini, Giuseppe, Commentarii in primam partem Summa S. Thomae. Tomus primus complectens prima tresdecim quaestiones (Panormi , ex typographia eiusdem Collegii Panormitani, 1639)', NULL, NULL, 2257, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2271, 'Vanderveken, Frans, Sex actum primarum virtutum II. Hymnus puerorum in gratias post missam. III. Psalmus miserere pro poenitente christiano (Cologne , Johannes Kinckius, 1645)', NULL, NULL, 2258, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2272, 'Azpilcueta, Martín de, Enchiridon sive Manuale confessariorum et poenitentium (Paris , Nicolas Buon (François Huby), 1602)', NULL, NULL, 2259, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2273, 'Henfield', NULL, NULL, 2260, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2274, 'González de León, Juan', NULL, NULL, 2261, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2275, 'Boccadiferro, Ludovico', NULL, NULL, 2262, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2276, 'Bonne Espérance, François de la, Liber apologeticus pro Joanne XLIV, episcopo et patriarcha Jerosolymitano (Anvers, 1666)', NULL, NULL, 2263, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2277, 'Barnier, Jacques', NULL, NULL, 2264, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2278, 'Borrull, Matías, Tractatus duo, de essentia et attributis et visione Dei, cum prooemialibus theologiae (Lugduni, 1663)', NULL, NULL, 2265, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2279, 'Cardillo de Villalpando, Gaspar, Commentarius in Aristotelis logica (Compluti, 1583)', NULL, NULL, 2266, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2280, 'Wavre', NULL, NULL, 2267, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2281, 'Aguilar, José de, Cursus philosophicus dictatus Limae, 3 vol. (Sevilla, 1701)', NULL, NULL, 2268, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2282, 'Brutscher, Johannes, Disputatio philosophica in IV libros de coelo, resp. Günther Vischer OSB (Ingolstadt, 1602)', NULL, NULL, 2269, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2283, 'Bois, François Du, Commentaria in tertiam partem S. Thomae Aquinatis... et in ejusdem supplementum centesima quaestione auctum (Douai , Marc Wyon, 1618)', NULL, NULL, 2270, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2284, 'Accarisi, Jacopo, Terrae quies solisque motus demonstratur primum theologicis, tum pluribus philosophicis rationibus. Disputatio (Roma , Typis Francisci Corbelletti, 1637)', NULL, NULL, 2271, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2285, 'Sforza Pallavicino, Pietro, Disputationum in primam secundae Divi Thomae (Lyon , Philippe Borde, Laurent Arnaud &amp;amp; Claude Rigaud, 1653)', NULL, NULL, 2272, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2286, 'Vives, Juan Luis, De ratione dicendi (1533)', NULL, NULL, 2273, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2287, 'Compton Carleton, Thomas, Uniuersa Aristotelis Dialectica. Editions partielles (Salamanca, 1675)', NULL, NULL, 2274, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2290, 'Capulli, Pietro, Commentaria in primum Sententiarum librum D. Bonaventurae (Venetiis , apud Guerilium, 1622)', NULL, NULL, 2277, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2291, 'Fasti Palatio, Cardinalium omnium Sanctae Romanae Ecclesiae, Venetii (1703) (1703)', NULL, NULL, 2278, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2292, 'Ruerk', NULL, NULL, 2279, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2293, 'Diaz de Llanos, Froylan, Dialectica disputata per quaestiones et articulus distincta iusta mentem D. Thomae (Valladolid, 1746)', NULL, NULL, 2280, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2294, 'Schwandorf', NULL, NULL, 2281, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2295, 'Alonso, Francisco, Disputationes in octo libros Physicorum (Alcala, 1665)', NULL, NULL, 2282, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2296, 'Castro, Alfonso de, Alonso de, De iusta haereticorum punitione libri tres (Antverpiae, 1568)', NULL, NULL, 2283, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2297, 'Littérature', NULL, NULL, 2284, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2298, 'Clément, Claude, El machiauelismo degollado por la christiana sabiduria de España y de Austria : discurso christiano-politico (Alcala , Antonio Vazquez, 1637)', NULL, NULL, 2285, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2299, 'Castiglione', NULL, NULL, 2286, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2300, 'Barbay, Pierre, Commentarius in Aristotelis Physicam (Parisiis, 1984)', NULL, NULL, 2287, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2301, 'Véria', NULL, NULL, 2288, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2302, 'Lavinheta, Bernardo de', NULL, NULL, 2289, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2303, 'Gardelegen', NULL, NULL, 2290, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2304, 'Albergoni, Eleuterio, Resolutio doctrinae scoticae, in quid Doctor Subtilis circa
singulas, quas exagitat quaestiones sentiat, et si oppositum alii
opinentur, brevibus ostenditur (Padoue, 1593)', NULL, NULL, 2291, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2305, 'Fabri, Honoré, Brevis annotatio in Systema Saturnium Christiani Eugenii (Roma , typ. Giacomo Dragondelli, 1660)', NULL, NULL, 2292, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2306, 'Gerhard, Johannes', NULL, NULL, 2293, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2307, 'Ciorla, Vincenzo, Disputationes in libros de generatione et corruptione, de anima et metaphysica (Naples, 1651)', NULL, NULL, 2294, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2308, 'Zaragoza y Vilanova, José, Trigonometria española : resolucion de los triangulos planos, y esfericos, fabrica, y uso de los senos, y logarithmos (Palma, 1672)', NULL, NULL, 2295, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2309, 'Jesuitenkolleg (Solothurn)', NULL, NULL, 2296, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2310, 'Arriaga, Rodrigo de, Cursus philosophicus (Paris , Quesnel, 1639)', NULL, NULL, 2297, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2311, 'Annat, François, Informatio de quinque porpositionibus ex Jansenii théologia collectis (Paris, 1653)', NULL, NULL, 2298, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2312, 'Martin, André', NULL, NULL, 2299, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2313, 'Iavelli, Crisostomo, Quaestiones Naturales super octo lib. Physicorum Aristotelis
Singularum quaestionum nuper adpositae sunt in margine... conclusiones
quambrevissimae (Lyon, 1557)', NULL, NULL, 2300, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2314, 'Pontevedra', NULL, NULL, 2301, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2315, 'De Cleyn, François', NULL, NULL, 2394, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2316, 'Delgadillo, Cristóbal, Tractatus de sacramentis in genere et aliquibus in specie, in doctrinam Subtilis Doctoris Scoti (Alcalá , María Fernández, 1654)', NULL, NULL, 2302, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2317, 'Aversa, Raffaello, acra theologia cum doctore angelico in tres partes distributa. Prima pars in qua de Deo in se et quatenus rerum principio
accurate disseritur (Romae , typis Iacobis Mascardi, sumptibus Octavii Ingrillani, 1631)', NULL, NULL, 2303, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2318, 'Alsted, Johann Heinrich, Definitiones theologicae secundum ordinem locorum communium traditae (Frankfurt, 1626)', NULL, NULL, 2304, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2319, 'Trombetta, Antonio, Opus doctrinae Scoticae in Thomistas (Venetiis , Hieronymus de Paganinis, 1493)', NULL, NULL, 2305, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2320, 'Boyvin, Jean Gabriel, Theologia scoti a prolixitate et subtilitas eius ab obscuritate libera et vindicata, 4 vol., &gt;sexta editio, correctior (Paris , Edmond Couterot, 1688)', NULL, NULL, 2306, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2321, 'Haunold, Christoph', NULL, NULL, 2307, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2322, 'Prost, les frères', NULL, NULL, 2308, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2323, 'Riccioli, Giovanni Battista, Ristretto della vita di S. Rosalia vergine palermitana (Genova, 1665)', NULL, NULL, 2309, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2324, 'Cienfuegos, Álvaro, Varii dialogi et catecheses de intima reali, &amp;amp; mutua
conjunctione digné cõ municantis cum Anima Christi Domini, etiam
destructis speciebus Eucharisticis (Valencia, 1735)', NULL, NULL, 2310, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2325, 'Barbay, Pierre, Commentarius in Aristotelis Moralem (Parisiis, 1676)', NULL, NULL, 2311, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2326, 'Torres, Pedro de', NULL, NULL, 2312, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2327, 'Cally, Pierre, Primum philosophiae perficiendae rudimentum, anthropologia sive tractatus de homine (Caen, 1683)', NULL, NULL, 2313, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2328, 'Lucera', NULL, NULL, 2314, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2329, 'Alzano Lombardo', NULL, NULL, 2315, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2330, 'David, Pierre, Sermones adventus de adoptione filiorum Dei (Paris, 1663)', NULL, NULL, 2316, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2331, 'Kennis, Ignatius Der, De Deo uno trino et creatore (Bruxelles , typ. François Foppens, 1655)', NULL, NULL, 2317, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2332, 'Domingo de Santa Teresa', NULL, NULL, 2318, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2333, 'Genovesi, Antonio, Lezioni di commercio (1765)', NULL, NULL, 2319, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2334, 'Desmarets, Samuel, Disputationes aliquot theologicae (Genève, 1661)', NULL, NULL, 2320, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2335, 'Scaliger, Julius Caesar, In duos Aristotelis libros de plantis libri II (1556)', NULL, NULL, 2321, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2336, 'Diaz de Llanos, Froylan, Dialectica disputata per quaestiones et articulus distincta iusta mentem D. Thomae (Valladolid, 1701)', NULL, NULL, 2322, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2337, 'Bois, François Du, Opera omnia, t. I-IV, In Summam Sancti Thomae (S.L. , Verdussen, 1693)', NULL, NULL, 2323, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2338, 'Gibert Jean-Pierre, Usages de l''Eglise gallicane concernant les censures et l''irrégularité […] expliquez…, Paris 1724, Mariette. (1724)', NULL, NULL, 2324, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2339, 'Celaya, Juan de, Expositio in quatuor libros de coelo et mundo Aristotelis cum quaestionibus (Parisiis , ab Hemundo le Feuvre, impr. J. du Pré et J. Le Messier, 1518)', NULL, NULL, 2325, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2340, 'Ribetti, Pietro Antonio, Giardino serafico istorico fecondo di fiori, e frutti di virtù, di zelo, e di santità nelli tre Ordini instituiti dal gran patriarca de poveri S. Francesco (Venezia, per Domenico Lovisa, 1710)', NULL, NULL, 2326, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2341, 'Chacon (Ciaconius) Alfonso, Vitae et res gestae Pontificum Romanorum et S. R. E. Cardinalium, 4 t., Roma (1677). (1677)', NULL, NULL, 2327, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2342, 'Armagh', NULL, NULL, 2328, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2343, 'Duval, André, Vie admirable de la Soeur Marie de l''Incarnation (Paris, 1621)', NULL, NULL, 2329, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2344, 'Collège Louis-le-Grand (Paris)', NULL, NULL, 2330, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2345, 'Iavelli, Crisostomo, Compendium opere ac doctrina iuxta librorum logicae (Paris, 1573)', NULL, NULL, 2331, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2346, 'García de los Ríos, Eusebio', NULL, NULL, 2332, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2454, 'Sepúlveda, Juan Ginés de', NULL, NULL, 2441, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2347, 'Chasteignier, Henri-Louis de La Rochepozay, Celebriorum distinctionum, tum philosophicarum, tum theologicarum synopsis, Addimento selectorum axiomatum (Leiden , Paets, 1614)', NULL, NULL, 2333, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2348, 'Celaya, Juan de, Dialectice
introductiones, sive Termini magistri Joannis de Celaya, Valentini cum
nonnullis (magistri Joannis Ribeyro Ulyxbonensis, sui discipuli)
additionibus, recenter impresse, et per eundem sue integritati restitute (Paris , Le Fèvre, 1520)', NULL, NULL, 2334, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2349, 'Universidad Real y Pontificia de Mexico', NULL, NULL, 2335, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2350, 'Auvillar', NULL, NULL, 2336, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2351, 'Simancas, Diego', NULL, NULL, 2337, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2352, 'Gooden, John', NULL, NULL, 2338, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2353, 'Palacios, Miguel de', NULL, NULL, 2339, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2354, 'Chasteignier, Henri-Louis de La Rochepozay, Celebriorum distinctionum, tum philosophicarum, tum theologicarum synopsis (Zürich, 1667)', NULL, NULL, 2340, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2355, 'Coronel, Antonio, Expositio super libros posteriorum Aristotelis (Paris , Olivier Senant, 1511)', NULL, NULL, 2341, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2356, 'Dechamps, Etienne-Agard, Jugement legitime porte contre les
prestres de l''oratoire de Mons avec des reflexions pour servir de
reponse au P. Jean Bauduin de meme oratoire. Par Louis Benoit licentie
en theologie (Cologne , Pierre Marteau (lieu et nom de l''éditeur faux), 1692)', NULL, NULL, 2342, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2357, 'Collegio dei Gesuiti (Mondovi)', NULL, NULL, 2343, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2358, 'Villecomtal', NULL, NULL, 2344, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2359, 'Clavius, Christopher, Romani calendarii a Gregorio XIII P.M. restituti Explicatio (Roma, 1603)', NULL, NULL, 2345, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2360, 'Fracastoro, Girolamo, Syphilis (1521)', NULL, NULL, 2346, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2361, 'Brescia, Fortunato da, Philosophia sensuum mechanica methodica tractata atque ad usus accomadata, 
tomus 1 : Physices generalis pars prima (Brescia, 1751)', NULL, NULL, 2391, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2362, 'Crespi de Borja, Luis, Propugnaculum theologicum diffinibilitatis proximae sententiae
piae negantis, beatissimam Virginem Mariam in primo suae Conceptionis
instanti originali labe fuisse infectam, obiectum Hyacinto Arpalego...
defensa Conceptio immaculata (Valencia, 1653)', NULL, NULL, 2347, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2363, 'Diotallevi, Francesco, De concursu Dei ad actus liberos voluntatis creatae, ac de scientia quam Deus habet de contingentibus sub conditione futuris prius ratione quam libere quidquam decernat, opuscula theologica (Lyon , Horace Cardon, 1611)', NULL, NULL, 2348, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2364, 'Barbay, Pierre, Commentarius in Aristotelis Physicam (Parisiis, 1690)', NULL, NULL, 2349, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2365, 'Castro, Alfonso de, Adversus omnes haereses (Antwerpen, 1556)', NULL, NULL, 2350, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2366, 'Alsted, Johann Heinrich, Compendium philosophicum exhibens methodum, definitiones, canones, distinctiones &amp;amp; quaestiones per universam philosophiam (Herborn, 1626)', NULL, NULL, 2351, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2367, 'Bernaldo de Quirós, Antonio, Opus philosophicum, hoc est Cursus integer (Lugduni, 1666)', NULL, NULL, 2352, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2368, 'Salvador de Bahia', NULL, NULL, 2353, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2369, 'Quiñones, Antonio', NULL, NULL, 2354, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2370, 'Cally, Pierre, Universae philosophiae institutio (Caen, 1695)', NULL, NULL, 2355, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2371, 'Toledo, Francisco de, Commentaria, una cum quaestionibus, in tres libros Aristotelis ''De Anima'' (Venezia, Apud Iuntas, 1574)', NULL, NULL, 2356, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2372, 'Bauny, Etienne, Libri tres in quibus quae in contractuum ac quasi contractuum materia videntur ardua ac difficilia enucleantur (Paris, 1645)', NULL, NULL, 2357, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2373, 'Daniel, Gabriel, Voyage du monde de Descartes (La Haye , Gosse, 1739)', NULL, NULL, 2358, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2374, 'Báñez, Domingo, Commentaria in Secundam Secundae Angelici Doctoris S. Thomae (Venise , Francesco Ziletti, 1586)', NULL, NULL, 2359, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2375, 'Leonardus Duardus, Brevis expositio propositionum damnatorum… , (?) 1635. (1635)', NULL, NULL, 2360, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2376, 'Brescia, Fortunato da, robabilismus methodo mathematica demonstratus auctore Patre Pithanophilo (Brescia, 1747)', NULL, NULL, 2361, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2377, 'Nivnice', NULL, NULL, 2362, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2378, 'Duval, Robert', NULL, NULL, 2363, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2379, 'Ciechanow', NULL, NULL, 2364, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2380, 'Porzio, Simone, De humana mente disputatio (Florentiis, 1551)', NULL, NULL, 2365, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2381, 'Izquierdo, Sebastián', NULL, NULL, 2366, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2382, 'Salas, Juan de', NULL, NULL, 2367, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2383, 'Conimbricense, Collegium, In quatuor libros de Coelo Aristotelis Stagiritae (Lyon , Horace Cardon, 1608)', NULL, NULL, 2368, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2384, 'Valderrama, Fernando', NULL, NULL, 2369, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2385, 'de Ulloa, Juan, Logica maior (Roma , ex Officina Cajetani Zenobii, 1712)', NULL, NULL, 2370, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2386, 'Curiel, Juan Alfonso, Lecturae seu quaestiones in D. Thomae Primam Secundae (Anvers, 1621)', NULL, NULL, 2371, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2387, 'Bassée, Eloi de la, Flores totius theologiae practicae, tum sacramentalis, tum moralis (Lyon , Jérôme de La Garde, 1653)', NULL, NULL, 2372, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2388, 'Franciscains déchaux', NULL, NULL, 2373, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2389, 'Jesi', NULL, NULL, 2374, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2390, 'Sarasa, Antonio Alfonso', NULL, NULL, 2375, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2391, 'Moneva', NULL, NULL, 2376, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2392, 'Kepler, Johannes, Epitome astronomiae copernicanae, I-III (Linz, excudebat Johannes Plancus, 1618)', NULL, NULL, 2377, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2393, 'In primam partem Summae S. Thomae Commentaria, vol. II (Lyon, 1629)', NULL, NULL, 2378, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2394, 'Bois, François Du, Commentaria in tertiam partem S. Thomae Aquinatis... et in ejusdem supplementum centesima quaestione auctum (Anvers , J. Meursius, 1667)', NULL, NULL, 2379, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2395, 'Riccioli, Giovanni Battista, Prosodia bononiensis nouis regulis, exceptionibus,
appendicibus ex latinis, graecis &amp;amp; hebraicis fontibus aucta,
poetarum clasicorum versibus confirmata ac tandem (Milano , ex typographia Ludouici Modoetiae ad instan. Francisci Mognaghae, 1649)', NULL, NULL, 2380, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2396, 'Benet, Cipriano, Spiritualis sapientie Breviloquium sive Dialogus (Roma , Steph. Guill. de Lothorangia, 1510)', NULL, NULL, 2381, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2397, 'Breydel, Nicolaus', NULL, NULL, 2382, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2398, 'Conimbricense, Collegium, In libros Meteorum Aristotelis Stagiritae (Lisboa, 1593)', NULL, NULL, 2383, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2399, 'Soria, Giovanni Gualberto de, Rationalis philosophiae institutiones, sive de emendanda, regendaque mente (Amstelodami apud Petrum Humbert, 1741)', NULL, NULL, 2384, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2400, 'Dissertatio de motu animalium (Mainz, 1768)', NULL, NULL, 2385, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2401, 'Dechamps, Etienne-Agard, Defense du "Secret du jansénisme" (du P. Dechamps) contre l''Ecrit de Monsieur Gery (Paris , Etienne Michallet, 1690)', NULL, NULL, 2386, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2402, 'Hunger, Albert, De prouidentia diuina oratio : qua prophanorum sacrorumque de hoc argumento dissertationes non minus dilucidè quàm breuiter continentur, an M.D. LXX. VII. Cal. Octob. in alma Vniuersitate Ingolstandiensi publicè habita (Ingolstadii , Ex Officina VVeissenhorniana, 1577)', NULL, NULL, 2387, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2403, 'Vives, Juan Luis, De puellarum institutione (1523)', NULL, NULL, 2388, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2404, 'Arriaga, Rodrigo de, Cursus philosophicus, Antwerpiae 1632, Ex officina plantiniana Balthasaris Moreti. (1632)', NULL, NULL, 2389, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2405, 'Crab, Gilbert, Textus Ethicorum Aristotelis ad Nycomachum iuxta antiquam
translationem, cum familiarissimo in eundem commentario ... Praeterea
recenter addite fuerunt florulente questiones suis cum dubiis ad
singulos tractatus vltimorum quattuor librorum per venerabiles
magistros Gilbertum Crab Scotum et Nicolaum Du Puy edite (Paris , Antoine Bonnemere &amp;amp; Denis Roce, 1509)', NULL, NULL, 2390, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2406, 'Vernaz, Ennemond', NULL, NULL, 2392, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2407, 'Dillingen an der Donau', NULL, NULL, 2393, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2408, 'Eymerich Nicholaus, Directorium inquisitorum,  Francisco Peña (éd.), Roma, in Aedibus Populi Romani, 1578. (1578)', NULL, NULL, 2395, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2409, 'Montemayor, Prudencio de', NULL, NULL, 2396, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2410, 'Gizel, Innokentii', NULL, NULL, 2397, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2411, 'Règles des religieuses de Sainte Claire donnée par le pape
Urbain IV comme encore un traité de leur profession et de leurs quatre
voeux (Grenoble , Jacques Petit, 1673)', NULL, NULL, 2398, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2412, 'Compton Carleton, Thomas, Philosophia universa (Anvers , typ. Jacob Meursius, 1664)', NULL, NULL, 2399, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2413, 'Gagliardi, Achilles', NULL, NULL, 2400, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2414, 'Merinero López, Juan', NULL, NULL, 2401, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2415, 'Annat, François, Recueil de plusieurs faussetez et impostures contenues dans
l''imprimé qui a pour titre : Septième écrit des curez, ou journal de ce
qui s''est passé (Paris, 1659)', NULL, NULL, 2402, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2416, 'Arce y Suárez, Baltasara Petronila', NULL, NULL, 2403, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2417, 'Becanus, Martin, Summa theologiae scholasticae. Pars prima de Deo, attributisque divinis, sanctissima Trinitate, Angelis &amp;amp; Daemonibus, operibus dierum, ac statu innocentiae (Lyon , Nicolas Gay, 1644)', NULL, NULL, 2404, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2418, 'Ferrari, G.', NULL, NULL, 2405, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2419, 'Bary, René, Les triomphes de Louis le juste XIII du nom Roy de Navarre. Abrégé de la vie de ce roi par René Bary (Paris , Antoine Estienne, 1649)', NULL, NULL, 2406, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2420, 'Como', NULL, NULL, 2407, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2421, 'David, Pierre, Les saints exercices des dix jours sur les dix principales vertus de la Très-Sainte Vierge (Paris , François le Cointe, 1666)', NULL, NULL, 2408, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2422, 'Oreggi, Agostino, Aristotelis vera de rationalis animae immortalitate sententia accurate explicata (Romae, 1632)', NULL, NULL, 2409, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2423, 'Celaya, Juan de, Expositio in primum tractatum Summularum magistri Petri Hispani (Parisiis , Venalia
prostant in Clauso Brunello, sub signo Scuti Britannie, 1525)', NULL, NULL, 2410, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2424, 'Vuitasse, D.', NULL, NULL, 2411, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2425, 'Lorenzo Maria del Sanctissimo Sacramento', NULL, NULL, 2412, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2426, 'Pastor, José', NULL, NULL, 2413, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2427, 'Coronel, Antonio, Quaestiones logicae, secundum viam realium et nominalium una cum textus explanatione (Salamanticae, 1518)', NULL, NULL, 2414, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2428, 'Sergeant, John', NULL, NULL, 2415, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2429, 'Politi, Ambrogio Catarino, Claves duae ad aperiendas intelligendasve S. Scritpuras (Lyon, 1543)', NULL, NULL, 2416, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2430, 'Celaya, Juan de, Clarissimi resolutissimique ac proinde doctissimi Doctoris
Parisiensis Magistri Joannis a Celaia Valentini scripta, quam
brevissima pariter et absolutissima adde etiam et omnium quae hactenus
scripta sunt, facile clarissima in Tertium volumen Sententiarum (Valentiae, 1530)', NULL, NULL, 2417, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2431, 'Stampa, Angelo Giuseppe', NULL, NULL, 2418, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2432, 'Gazzolo', NULL, NULL, 2419, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2433, 'Luis de Flandes', NULL, NULL, 2420, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2434, 'Bonne Espérance, François de la, Clypeus contritionalis (Anvers, 1670)', NULL, NULL, 2421, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2435, 'Casati, Gio. Paolo', NULL, NULL, 2422, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2436, 'Lázaro y Terrer, Pedro', NULL, NULL, 2423, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2437, 'Jack, Gilbert', NULL, NULL, 2424, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2438, 'Mastri, Bartolomeo, Theologia moralis ad mentem S. Bonaventurae et Scoti (Venezia , J.J. Hertz, 1683)', NULL, NULL, 2425, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2439, 'Scaccia Sigismundus, Tractatus de iudiciis causarum civilium, criminalium et haereticalium. Liber primus, Venezia 1596. (1596)', NULL, NULL, 2426, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2440, 'Álvarez, Diego, Responsionum ad obiectionum adversus concordiam liberi arbitrii cum divina praedestinatione (Trani, 1622)', NULL, NULL, 2427, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2441, 'Daniel, Gabriel, Histoire de la milice françoise, et des changemens qui s''y
sont faits depuis l''établissement de la monarchie françoise dans les
Gaules, jusqu''à la fin du regne de Louis Le Grand, 2 vol. (Paris , Denis Mariette, Jean-Baptiste Delespine &amp;amp; Jean-Baptiste Coignard, 1721)', NULL, NULL, 2428, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2442, 'Williams, Francis', NULL, NULL, 2429, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2443, 'Riccioli, Giovanni Battista, Prosodia bononiensis nouis regulis, exceptionibus,
appendicibus ex latinis, graecis &amp;amp; hebraicis fontibus aucta,
poetarum clasicorum versibus confirmata ac tandem (Torino , typ. Francesco Ferrusino, 1649)', NULL, NULL, 2430, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2444, 'Alsted, Johann Heinrich, Thesaurus chronologiae (Herborn, 1637)', NULL, NULL, 2431, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2445, 'Eberhard, Georg, Disputatio theologica de statu religiosum (Dilligen, 1587)', NULL, NULL, 2432, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2446, 'Martino, Spirito, Dialogus de entelechia (Paris , Chr. Wechel, 1543)', NULL, NULL, 2433, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2447, 'Tiedra, Jerónimo', NULL, NULL, 2434, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2448, 'Rossi da Lugo, Alessandro, Resolutiones morales in quibus potiores casus conscientiae
frequentius in qualibet materia occurrentes iuxta mentem Scoti et
Thomae examinantur et solvuntur (Bologna, 1664)', NULL, NULL, 2435, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2449, 'Collegium Casimiranum', NULL, NULL, 2436, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2450, 'Morale', NULL, NULL, 2437, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2451, 'Dechamps, Etienne-Agard, Lettre du prince de
Conti, ou l''Accord du libre arbitre avec la grâce de Jésus-Christ,
enseigné par son Alt. Sérénissime au P. De Champs,... avec plusieurs
autres pièces sur la même matière (Cologne , N. Schouten, 1689)', NULL, NULL, 2438, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2452, 'Farinoni, Guglielmo', NULL, NULL, 2439, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2453, 'Fabri, Honoré, Apologeticus doctrinae moralis eiusdem Societatis : in qua
variis tractatibus diuersorum auctorum opuscula confutantur... : in
duas partes sectus, Editio altera, in Germania prima, duplo auctior (Köln , typ. J. Busaei, 1672)', NULL, NULL, 2440, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2455, 'Brescia, Fortunato da, Philosophia sensuum mechanica methodica tractata atque ad usus accomadata, tomus 2 : Physices generalis pars secunda (Venise, 1761)', NULL, NULL, 2442, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2456, 'Couvent de San Francisco (Ciudad Rodrigo)', NULL, NULL, 2443, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2457, 'Conimbricense, Collegium, In octo libros Physicorum Aristotelis Stagiritae (Köln , Lazarus Zetzner, 1599)', NULL, NULL, 2444, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2458, 'Collegium Complutense, Disputationes in Aristotelis philosophiam naturalem iuxta miram angelici doctoris D. Thomae doctrinam et eius scholam (Madrid, 1627)', NULL, NULL, 2445, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2459, 'Scaliger, Julius Caesar, Opera diversa (Paris, 1612)', NULL, NULL, 2446, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2460, 'Fabri, Honoré, Dialogi physici : in quibus de motu Terrae disputatur, marini aestus nova causa proponitur necnon aquarum &amp; Mercurii supra libellam elevatio examinatur, Lyon, sumptibus Christophori Fourmy, 1665, [4], 218, [16] p. (1665)', NULL, NULL, 2447, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2461, 'Jesuitenkolleg (Amberg)', NULL, NULL, 2448, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2462, 'Azor, Juan, Institutionum moralium in quibus universae quaestiones ad conscientiae recte aut prave factorum pertinentes, breviter tractantur. Pars prima (Parisii, 1602)', NULL, NULL, 2449, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2463, 'Clonmel', NULL, NULL, 2450, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2464, 'Scotland', NULL, NULL, 2451, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2465, 'Hodierna, Giovanni Battista, Novissimae Additiones, et observationes ad decisiones
Mantuani Senatus IO. Petri Surdi Quibus hac quartâ editione praeter
antiguas nouae insigniores ... opus advocatis, causidicis, caeterisque (Genève , Johann Hermann Widerhold, 1677)', NULL, NULL, 2452, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2466, 'Clément, Claude, Tabla chronologica de las cosas mas ilustres de España : desde su primera poblacion hasta el nacimiento de Iesu Christo (Zaragoza , Herederos de Diego Dormer, 1676)', NULL, NULL, 2453, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2467, 'Fernández de Torrejon, Pedro', NULL, NULL, 2454, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2468, 'Du Perne, Jean', NULL, NULL, 2455, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2469, 'Crassot, Jean, La science morale d''Aristote réduite en abrégé, fort méthodiquement expliquée (1617)', NULL, NULL, 2456, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2470, 'Chacón, Juan', NULL, NULL, 2457, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2471, 'Index librorum prohibitorum Alexandri VII. pontificis Maximi iussu editus, Romae 1664, Ex Typographia Reverendae Camerae Apostolicae 1664, XXVI / 411 p. (1664)', NULL, NULL, 2458, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2472, 'Ortiz de Zayas, Ildefonso', NULL, NULL, 2459, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2473, 'Paris, Yves de, Digestum sapientiae, 4 vol. (Lyon, 1674)', NULL, NULL, 2460, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2474, 'Alarcón, Diego de, Parecer (Colegio de Alcalá, 1631)', NULL, NULL, 2461, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2475, 'Malafossa, Giacomino, Duae quaestiones R.P.M. Iacobini Bargij scotistae clarissimi, in Petri
Tartareti Parisiensis Ioan. duns. Scoti doctoris subtilis, sectatoris
fidelissimi *In Aristotelis philosophiam, naturalem, diuinam, et
moralem exactissima commentaria. Per R.P.F. Liuium a Lege Venetum aug.
s.t. doct. nunc recens summo studio recognita, et ab infinitis prope
mendis repurgata... Cum syllabo copiosissimo. Tertia pars. (Patavii , ed. Salvatore Bartolucci, 1592)', NULL, NULL, 2462, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2476, 'Cristo, Francisco do', NULL, NULL, 2463, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2477, 'Encinas, Fernando, Tractatus summularum cum textu Petri Hispani (Salmanticae , Alonso de Porras, 1527)', NULL, NULL, 2464, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2478, 'Brescia, Fortunato da, Osservazioni critiche del P. F. Fortunato da Brescia Minor
Riformato sopra certo articolo delle novelle letterarie di Firenze al
num. 27 e 28 dell''anno 1752, in cui
si rende publica una lettera della stessa autore, indinizzata
all''eminentissimo Cardinale Querini (Brescia, 1758)', NULL, NULL, 2465, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2479, 'Ricci, Paolo, Sal foederis : philosophica, prophetica ac talmudistica pro christiana veritate tuenda cum iuniori hebreorum synagoga mirabili ingenii disputatio (Augsburg, 1510)', NULL, NULL, 2466, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2480, 'Adam, Melchior', NULL, NULL, 2467, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2481, 'Combach, Johannes, Disputatio philosophica De coelo (Marburg, 1617)', NULL, NULL, 2468, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2482, 'Celaya, Juan de, Dialectice
introductiones, sive Termini magistri Joannis de Celaya, Valentini cum
nonnullis (magistri Joannis Ribeyro Ulyxbonensis, sui discipuli)
additionibus, recenter impresse, et per eundem sue integritati restitute (Valencia, 1528)', NULL, NULL, 2469, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2483, 'Büttner, Christoph Andreas, Cursus philosophicus omnes philosophiae partes complectens, vol. I : Philosophia theoretica (Halle, 1734)', NULL, NULL, 2470, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2484, 'Nifo, Agostino, De sensu agente, Venezia, 1497 (1497)', NULL, NULL, 2471, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2485, 'Salelles Sebastian, SJ, De materia tribunalium S. Inquisitionis seu de regulis multiplicibux pro formando quovis eorum Ministro, praesertim Consultore praemissis XIII. Prolegomenis de origine et progressu dictorum Tribunalium, 3 vol., Roma 1651-1656. (1651)', NULL, NULL, 2472, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2486, 'Lisboa, Gomes de', NULL, NULL, 2473, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2487, 'Labin', NULL, NULL, 2474, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2488, 'Frit, Johannes Philipp', NULL, NULL, 2475, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2489, 'Celaya, Juan de, novissime
accuratiori lima revisa, cum nonnullis additionibus pro lucidiori
intelligentia vie nominalium Joannis Quintini Hedui ejus discipuli (Parisiis , Prigent Calvarin In clauso brunello ad insigne geminarum
cipparum, 1520)', NULL, NULL, 2476, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2490, 'Altdorf (Schweiz)', NULL, NULL, 2477, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2491, 'Martin, François', NULL, NULL, 2478, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2492, 'Maella', NULL, NULL, 2479, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2493, 'Charmey', NULL, NULL, 2480, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2494, 'Bary, René, La rhétorique françoise ou pour principale augmentation l''on trouve les secrets de nostre langue (Paris , Pierre Le Petit, 1653)', NULL, NULL, 2481, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2495, 'Iavelli, Crisostomo, Epitome in uniuersam Aristotelis, Platonis et Christianam Philosophiam moralem in certas partes distincta (Venise, 1577)', NULL, NULL, 2482, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2496, 'Brescia, Fortunato da, Philosophia sensuum mechanica methodica tractata atque ad usus accomadata, tomus 3 : Physices particularis pars prima (Brescia, 1752)', NULL, NULL, 2483, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2497, 'Cuéllar, José de, Theologiae cursus iuxta mentem et ordinem venerabilis doctoris subtilis (Madrid , Antonio Martín, 1725)', NULL, NULL, 2484, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2498, 'Pedro - de Lievana', NULL, NULL, 2485, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2499, 'Escobar y Mendoza, Antonio de, Liber theologiae moralis iginti &amp; quator Societatis Iesu Doctoribus reseratus, 1ère éd. latine : Post trigesimam-septimam Hispanicam Editionem, prodit prima additionibus illustrata (Lugduni , Apud Haered. Ionae Gautherin, 1646)', NULL, NULL, 2486, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2500, 'Marini, Domenico De, Expositio commentaria in tertiam partem Summae Doctoris
Angelici S. Thomae, complectens ea quae spectant ad ineffabile
Incarnationis mysterium (Lyon , Philippe Borde, Laurent Arnaud, Pierre Borde, Guillaume Barbier, 1666)', NULL, NULL, 2487, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2552, 'Bary, René, La Deffence de la jalousie (Paris , P. Rocolet, 1642)', NULL, NULL, 2539, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2553, 'Chieri', NULL, NULL, 2540, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2501, 'Dechamps, Etienne-Agard, Le secret du jansénisme descouvert et réfuté par un docteur catholique (Paris , S. &amp;amp; G. Cramoisy, 1651)', NULL, NULL, 2488, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2502, 'Saint-Joseph, Pierre de', NULL, NULL, 2489, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2503, 'Dubal, Francisco, Vida de San Norberto (Valladolid, 1667)', NULL, NULL, 2490, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2504, 'Burgersdijk, Franco, Institutionum metaphysicarum libri duo (Leiden , Hieronymus de Vogel, 1640)', NULL, NULL, 2491, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2505, 'Trombetta, Antonio, Insigne formalitatum opus de mente doctoris subtilis vna cum
editione subtilssima reuerendi Vrbinatis episcopi Antonij Trombete:
adiunctisque resolutissimis celeberrimi Tuanensis archiepiscopi
Mauritij: necnon excellentissimi doctoris Antonij de Fantis Taruisini
Annotationibus nuperrime summa cum ipsius diligentia ab innumeris
erroribus absolutum (Venetiis , Giunta, 1517)', NULL, NULL, 2492, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2506, 'Aldrete, Bernardo de, Commentariorum ac diputationum in tertiam partem S. Thom. de Mysterio Incarnationis Verbi Divini tomus prior (Lyon, 1652)', NULL, NULL, 2493, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2507, 'Magni, Valeriano', NULL, NULL, 2494, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2508, 'Nieuport', NULL, NULL, 2495, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2509, 'Convento de San Gabriel (Cholula)', NULL, NULL, 2496, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2510, 'Bary, René, Esprit de cour ou les conversations galantes (Paris , Charles de Sercy, 1681)', NULL, NULL, 2497, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2511, 'Annat, François, Opuscula theologica (Paris, 1666)', NULL, NULL, 2498, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2512, 'Le Valois, Louis', NULL, NULL, 2499, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2513, 'Brù, Estevan', NULL, NULL, 2500, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2514, 'Le Mairat, Louis', NULL, NULL, 2501, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2515, 'Araújo, Francisco de, In primam secundae diui Thomae lecturarum, tomus primus (Salamanca , Diego Garcia / Convento de San Esteban, 1638)', NULL, NULL, 2502, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2516, 'Losada, Luis de', NULL, NULL, 2503, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2517, 'Scaliger, Julius Caesar, Commentarius et animadversiones in VI libros de causis plantarum Theophrasti (1566)', NULL, NULL, 2504, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2518, 'Peurbach, Georg', NULL, NULL, 2505, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2519, 'Pfalzgrafschaft Pfalz-Sulzbach ', NULL, NULL, 2506, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2520, 'Fabri, Honoré, Hermanni Conringii concussio excussa et romanae fidei firmitas inconcussa (Augsburg , typ. Simon Utzschneider, 1664)', NULL, NULL, 2507, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2521, 'Davenport, Christopher', NULL, NULL, 2508, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2522, 'Martínez de la Raga, Vicente', NULL, NULL, 2509, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2523, 'Evrard, Christophe', NULL, NULL, 2510, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2524, 'Alonso, Francisco, Disputationes in tres libros Aristotelis de Anima (Alcala, 1640)', NULL, NULL, 2511, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2525, 'Puigserver i Mayol, Felipe', NULL, NULL, 2512, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2526, 'Vivant, François', NULL, NULL, 2513, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2527, 'Bail, Louis, La théologie affective ou saint Thomas en méditations (Paris, 1659)', NULL, NULL, 2514, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2528, 'Vázquez, Gabriel, Disputationes metaphysicae desumptae ex variis locis suorum operum (Madrid , ed. Francisco Murcia de la Llana, 1617)', NULL, NULL, 2515, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2529, 'Banares', NULL, NULL, 2516, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2530, 'Lendinara', NULL, NULL, 2517, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2531, 'Barbieri da Castelvetro, Bartolomeo, Cursus theologicus ad mentem seraphici doctoris S.
Bonaventurae, in duos tomos distributus : tomus primus ; continens
primum &amp;amp; secundum librum sententiarum ; tomus secundus : continens
tertium &amp;amp; quartum librum sententiarum (Lyon , typ. François Comba, 1687)', NULL, NULL, 2518, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2532, 'Martínez Silíceo, Juan', NULL, NULL, 2519, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2533, 'Rodríguez, Francisco', NULL, NULL, 2520, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2534, 'Scherzer, Johann Adam', NULL, NULL, 2521, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2535, 'Arriaga, Rodrigo de, Cursus philosophicus (Paris , apud Martinum Durand, 1637)', NULL, NULL, 2522, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2536, 'Crab, Gilbert, Habes humanissime lector aethice. seu moralium libros decem
Ari. traditionem Joannis Argiropili: In quibus humane vite decursus
perpulchre describit de novo correctos ac emendatos nusque policiores
inventos: cum marginalibus additionibus textum elucidantibus
Preterea capiti invenies adiunctas annotationes seu declarationes
Gilberti Crab, ponentes difinitiones divisiones: Et notanda in decem
perdictos libros: quibus intellectis facile quis textus obscuritat ...
discernit (Mareschal, 1511)', NULL, NULL, 2523, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2537, 'Barbay, Pierre, Commentarius in Aristotelis Moralem (Parisiis, 1680)', NULL, NULL, 2524, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2538, 'Álvarez, Diego, De auxiliis divinae gratiae et human arbitrii viribus et libertate libri duodecim (Lyon, 1620)', NULL, NULL, 2525, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2539, 'Iribarne e Uraburu, Juan, Tractatus de actibus humanis, iuxta mentem Scoti. Editio secunda, in
qua errata primae editionis purgantur; et quae supersunt notantur (Saragosse, 1643)', NULL, NULL, 2526, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2540, 'Bail, Louis, De triplici examine ordinandorum, confessariorum et paenitentium (Paris, 1651)', NULL, NULL, 2527, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2541, 'Poilly', NULL, NULL, 2528, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2542, 'Cienfuegos, Álvaro, La heroyca vida, virtudes, y milagros del grande S. Francisco de Borja de la Compañia de Jesus (Madrid, 1717)', NULL, NULL, 2529, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2543, 'Cento', NULL, NULL, 2530, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2544, '[Sestini Francesco], Il maestro di camera. Trattato di Francesco Sestini da Bibbiena. All''illustriss. e reverendiss.principe Carlo Cardinale de Medici. In Firenze. Per Zanobi Pignoni. 1621. Con licenza de Superiori. (1621)', NULL, NULL, 2531, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2545, 'Daniel, Gabriel, Apologia
doctrinae Jesuitarum, data ad R. D. Episcopum Atrebatensem : occasione
censurae, quam contra casistam Germanum edidit ex Gallico idiomate in
Latinum traducta, traduction latine (Köln , Noethen, 1706)', NULL, NULL, 2532, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2546, 'Villanueva, José de, Cursus philosophicus ad mentem Aegidii Romani, complectens antepraedicamenta, praedicamenta, postpraedicamenta, Peryhermeneias, et Posteriora (Valencia, 1677)', NULL, NULL, 2533, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2547, 'Ceriziers, René de, Le philosophe français (Paris, 1643)', NULL, NULL, 2534, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2548, 'Trombetta, Antonio, Formalitates Scoti. Excultum formalitatum opus de mente &amp;amp;
intentione doctoris subtilis: vna cum Mauritij Hybernici ac Stephani
Burlifer epithomatibus. Nec non ... Antonij Trombete Patauini
expositione. Resolutissimisque eiusdem Mauritij annotationibus: ac
Antonij de Fantis glossis (Venetiis, expensis Luce Antonij Iuncta, 1525)', NULL, NULL, 2535, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2549, 'Daniel, Gabriel, Réponse aux Lettres provinciales de L. de Montalte, ou Entretiens de Cleandre et d''Eudoxe (Rouen , Pierre Marteau, 1696)', NULL, NULL, 2536, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2550, 'Aurnhammer, Dominikus', NULL, NULL, 2537, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2551, 'Trombetta, Antonio, Opus in Metaphysicam Arist. Padue in thomistas discussum cum
qomnibus perutilissimis antiquioribus adiectis in optimam seriem
redactis: et formalitates eiusdem cum additionibus et dilucidatione
diligenti exculte (Venetiis, 1504)', NULL, NULL, 2538, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2555, '[Lunadori Girolamo, Relatione della Corte di Roma, (Padova) 1635, Frambotto] (1635)', NULL, NULL, 2542, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2556, 'Toro', NULL, NULL, 2543, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2557, 'Galilei, Virginia', NULL, NULL, 2544, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2558, 'Pérez de Ayala, Martin', NULL, NULL, 2545, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2559, 'Bellarini, Giovanni, Doctrina d. Concilii Tridentini et cathechismi romani de symbolo
apostolorum, de sacramentis et iustificatione, oratione dominica et
Decalogo. Opusculis
de Santo Evangelio ipsoque catechismo et examine ad ordines,
confessiones, conciones, beneficia et curam animarum (Brescia, 1603)', NULL, NULL, 2546, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2560, 'Basso, Sebastian, Philosophiae naturalis adversus Aristotelem libri XII. in quibus abstrusa Veterum physiologia restauratur et Aristotelis errores solidis rationibus refellutnur, Genève, apud P. de La Rovière, 1621, XL/701 p. (1621)', NULL, NULL, 2547, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2561, 'José de los Santos', NULL, NULL, 2548, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2562, 'Esbarroya, Agustin de, Expositio primi[-quarti] tractatus sumularum Magistri Petri Hispani (Hispali , apud Barth. Perez, 1533)', NULL, NULL, 2549, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2563, 'Ledesma, Diego de', NULL, NULL, 2550, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2564, 'Sanmartí, Pere', NULL, NULL, 2551, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2565, 'Universidad de Zaragoza, Facultad de Teología', NULL, NULL, 2552, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2566, 'Clauberg, Johannes, Logica vetus et nova, modum inveniendae ac tradendae veritatis in Genesi simul et analysi facile methodo exhibens. Editio princeps (Amsterdam, 1654)', NULL, NULL, 2553, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2567, 'Chasteignier, Henri-Louis de La Rochepozay, Celebriorum distinctionum, tum philosophicarum, tum theologicarum synopsis (Leiden, 1645)', NULL, NULL, 2554, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2568, 'Du Moulin, Pierre, De monarchia temporali pontificis romani liber (Londres, ex officina Nortoniana, 1614)', NULL, NULL, 2555, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2569, 'Osona', NULL, NULL, 2556, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2570, 'Compton Carleton, Thomas, Prometheus Christianus seu liber Moralium in quo
philosophiae moralis finis et scopus aperitur, simulque media quibus in
homine formando in hominem utitur declarantur ex antiquorum
Philosophorum monumentis declarantur (Anvers, 1652)', NULL, NULL, 2557, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2571, 'Scaliger, Julius Caesar, Poetices libri septem ad Sylvium filium (Leiden, 1581)', NULL, NULL, 2558, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2572, 'Vives, Juan Luis, De Disciplinis, incl. De causis corruptarum artium (1531)', NULL, NULL, 2559, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2573, 'Eichsätt', NULL, NULL, 2560, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2574, 'Nisbet', NULL, NULL, 2561, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2575, 'Tolomei, Giovanni Battista, Philosophia mentis et sensuum, secundum utramque Aristotelis methodum pertractata, metaphysice et empirice (Roma, 1702)', NULL, NULL, 2562, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2576, 'Bayon, Nicolas, Tractatus de contractibus tam in genere quam in specie (Paris, 1633)', NULL, NULL, 2563, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2577, 'Vázquez, Gabriel, Commentariorum in primam-secundae S. Thomae, 2 vol. (Alcala, 1598)', NULL, NULL, 2564, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2578, 'Copernic, Nicolas, De revolutionibus orbium coelestium libri sex (Nürnberg, apud Jo. Petreium, 1543)', NULL, NULL, 2565, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2579, 'Zara, Antonius, Anatomia ingeniorum et scientiarum sectionibus quattuor comprehensa (Venetiis, 1615)', NULL, NULL, 2566, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2580, 'Andrea della Croce, In primam partem D. Thomae disputationes theologicae (Genuae , per Ioannem Mariam Farronem, 1650)', NULL, NULL, 2567, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2581, 'Amberg', NULL, NULL, 2568, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2582, 'Peurbach, Georg, Theoricae novae planetarum... ab Erasmo Reinholdo... pluribus figuris auctae et illustratae scholijs... Inserta item methodicae tractatio de illuminatione lunae, Vitembergae : J. Lufftt, 1542 (1542)', NULL, NULL, 2569, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2583, 'Busembaum, Hermann, Medulla theologiae moralis facili ac perspicua methodo resolvens
casus conscientiae ex veris probatisque authoribus concinnata,
paenitentibus aeque ac confessariis utilis (Münster, 1650)', NULL, NULL, 2570, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2584, 'Groningen', NULL, NULL, 2571, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2585, 'Grouchy, Nicolas', NULL, NULL, 2936, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2586, 'Castro, Alfonso de, Adversus omnes haereses libri XIIII (Paris, 1564)', NULL, NULL, 2572, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2587, 'Dubrueil, Hugues', NULL, NULL, 2573, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2588, 'Neri Giovanni Battista, De Iudice S. Inquisitionis opusculum, Florentiae 1685, ex typographia Petri Matini sub signo Leonis. (1685)', NULL, NULL, 2574, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2589, 'Duval, André, De suprema Romani Pontificis in Ecclesiam potestate disputatio quadripartita (Paris , D. Langlaeus, 1614)', NULL, NULL, 2575, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2590, 'Ibáñez de Aoyz, Vicente Antonio', NULL, NULL, 2576, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2591, 'Fabri, Filippo, Disputationes theologicae de restitutione et extrema-unctione (Venezia , Marco Ginammi, 1624)', NULL, NULL, 2577, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2592, 'Serina (Sireno), Giulio', NULL, NULL, 2578, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2593, 'Vigevano', NULL, NULL, 2579, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2594, 'Nifo, Agostino, Super tres libros de anima (Venetiis, 1559)', NULL, NULL, 2580, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2595, 'Annat, François, Réponse à quelques demandes dont l''éclaircissement est nécessaire au temps présent (Paris, 1656)', NULL, NULL, 2581, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2596, 'Lezno', NULL, NULL, 2582, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2597, 'Adam, Jean, Lettre à M. Hesperien, ministre de Soubize (Bordeaux, 1675)', NULL, NULL, 2583, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2598, 'Celaya, Juan de, Expositio magistri Johannis de Celaya, Valentini, in
librum Predicabilium Porphyrij cum questionibus ejusdem secundum
triplicem viam beati Thome, realium et nominalium (Parisiis , Hémon Le Fèvre, 1516)', NULL, NULL, 2584, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2599, 'Bois, François Du, Commentarii in totam primam partem S. Tho. Aquinatis (Douai , Gérard Patté, 1662)', NULL, NULL, 2585, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2600, 'Boyvin, Jean Gabriel, Theologia scoti a prolixitate et subtilitas eius ab obscuritate libera et vindicata, 4 vol., Secunda editio correctior (Paris , Edmond Couterot, 1671)', NULL, NULL, 2586, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2601, 'Galland, Pierre', NULL, NULL, 2587, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2602, 'Clauberg, Johannes, Tobias Andreae praes., Tessarakas thesium philosophicarum de logicae ab aliis disciplinis quibuscum vulgo confundi assolet distinctione (Groningen, 1646)', NULL, NULL, 2588, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2603, 'Zuñiga, Diego de, De vera religione in omnes sui temporis haereticos libri tres (Salamanca , M. Gastius, 1577)', NULL, NULL, 2589, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2604, 'Azpilcueta, Martín de, Enchiridon sive Manuale confessariorum et poenitentium (Venise , Joannes Guerili, 1616)', NULL, NULL, 2590, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2605, 'Bourdelot, Pierre Bonnet', NULL, NULL, 2591, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2606, 'Fabri, Honoré, Euphyander, seu vir ingeniosus... in quo scilicet
brevissime et clarissime adolescentis ingeniosi partes ac dotes tum
corporis, tum animi describuntur (Lyon , Antoine Molin, 1669)', NULL, NULL, 2592, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2607, 'Ellwangen', NULL, NULL, 2593, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2655, 'Castro, Alfonso de, De iusta haereticorum punitione libri tres (Lugduni, 1556)', NULL, NULL, 2640, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2608, 'Borelli, Giovanni Alfonso, De vi percussionis, et motionibus naturalibus a gravitate pendentibus / Johannes Alphonsus Borellus ; accurante J. Broen, Lugduni Batavorum, 1686. (1686)', NULL, NULL, 2594, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2609, 'Vanderveken, Frans, In canonen Sacrificii Missae brevis ac luculenta et ad pietatem utilis expositio (Cologne , Johannes Kinckius, 1644)', NULL, NULL, 2595, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2610, 'Jesuitenkolleg (Burghausen)', NULL, NULL, 2596, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2611, 'Holiart, Joan Rafael', NULL, NULL, 2597, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2612, 'Annat, François, Scienttia media contra novos ejus impugnatores defensa (Paris , S. Cramoisy, 1662)', NULL, NULL, 2598, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2613, 'Adam, Jean, Le Tombeau du jansénisme ou le Nouveau Party destruit par Sainct Augustin et la bulle du pape Innocent X (Paris , Gaspar Meturas, 1654)', NULL, NULL, 2599, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2614, 'Heredia, Pedro Miguel de', NULL, NULL, 2600, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2615, 'Daniel, Gabriel, Réponse aux Lettres provinciales de L. de Montalte, ou Entretiens de Cleandre et d''Eudoxe (Amsterdam , Donati, 1697)', NULL, NULL, 2601, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2616, 'Walaeus, Antonius', NULL, NULL, 2602, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2617, 'Fabri, Honoré, Synopsis geometrica, cui accessere tria opuscula, nimirum,
de linea sinuum et cycloide, de maximis et minimis centuria, et
synopsis trigonometriae planae (Lyon , A. Molin, 1669)', NULL, NULL, 2603, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2618, 'Chasteignier, Henri-Louis de La Rochepozay, Celebriorum distinctionum, tum philosophicarum, tum theologicarum synopsis (London , Societas Stationariorum, 1617)', NULL, NULL, 2604, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2619, 'Compton Carleton, Thomas, Disputationes physicae ubi etiam De generatione et corruptione. Editions partielles (Salamanca, 1676)', NULL, NULL, 2605, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2620, 'Fabri, Filippo, Theologicae disputationes de praedestinatione dei &amp;amp; alia quae in primo libro sententiarum desiderabantur (Venezia , Marco Ginammi, 1623)', NULL, NULL, 2606, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2621, 'Yermo, José de', NULL, NULL, 2607, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2622, 'Barbieri da Castelvetro, Bartolomeo, Flores et fructus seraphici ex seraphico paradiso excerpti, seu Cursus philosophicus ad mentem sancti Bonaventurae, 3 vol. : 
pars prima, continens totam logicam cum tractatu formalitatum; 
pars secunda, continens totam physicam &amp;amp; tractatum de celo &amp;amp; mundo;pars tertia, continens Tractatus de Generatione &amp;amp; Corruptione,
de Anima &amp;amp; Physiognomia hominis, de Metaphysica &amp;amp; de Maximis (Lyon , typ. Laurent Arnaud, Pierre Borde, Jean et Pierre Arnaud, 1677)', NULL, NULL, 2608, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2623, 'Buhon, Gaspar, Philosophia ad morem Gymnasiorum finemque accomodata, 4 vol., t. 1 : Logica; t. 2 : Physica; t. 3 : Tractatus de mundo, de anima
et theologia naturalis; t. 4 : Metaphysica et moralia, 4 t. en 2 vols (Venise , Typographia Balleoniana, 1724)', NULL, NULL, 2609, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2624, 'Fabri, Filippo, Expositiones et disputationes in XII libros Aristotelis Metaphysicorum, quibus doctrina Scoti magna cum facilitate illustratur (Venezia , ed. Matteo Ferchie, Marco Ginammi, 1637)', NULL, NULL, 2610, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2625, 'Sansepolcro', NULL, NULL, 2611, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2626, 'Bassée, Eloi de la, Flores totius theologiae practicae, tum sacramentalis, tum moralis, Editio sexta ab auctore recognita (Anvers, Hieronymus &amp;amp; Ioan. Bapt. Verdussen, 1659)', NULL, NULL, 2612, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2627, 'Imbault, Bernard', NULL, NULL, 3080, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2628, 'Compton Carleton, Thomas, Prometheus Christianus seu liber Moralium in quo
philosophiae moralis finis et scopus aperitur, simulque media quibus in
homine formando in hominem utitur declarantur ex antiquorum
Philosophorum monumentis declarantur. Secunda editio priore multo correctior et ab ipso Auctore revisa (Liège, 1653)', NULL, NULL, 2613, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2629, 'Alonso, Francisco, Institutionum dialectarum libri quinque (Alcala, 1642)', NULL, NULL, 2614, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2630, 'Foscarini, Paolo Antonio, Lettera sopra l''opinione de'' Pitagorici e del Copernico. Della mobilità della Terra e stabilità del Sole, e del nuovo Pittagorico Sistema del Mondo. Al Reverendiss. P.M. Sebastiano Fantone Generale dell''Ordine Carmelitano (Napoli , Lazaro Scoriggio, 1615)', NULL, NULL, 2615, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2631, 'Riccioli, Giovanni Battista, Argomento fisico-mattematico contro il moto diurno della terra (Bologna, 1668)', NULL, NULL, 2616, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2632, 'Zaragoza y Vilanova, José, Arithmetica universal : que comprehende el arte menor y maior, algebra vulgar y especiosa (Valencia, 1669)', NULL, NULL, 2617, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2633, 'Eberhard, Georg, Disputatio theologica de sanctissimo Trinitatis mysterio (Dillingen, 1588)', NULL, NULL, 2618, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2634, 'Bernaldo de Quirós, Antonio, Selectae disputationes theologicae de Deo (Lyon, 1654)', NULL, NULL, 2619, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2635, 'González de Albelda, Juan', NULL, NULL, 2620, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2636, 'Daniel, Gabriel, Apologie pour la doctrine des jesuites, envoyée a
Monseigneur d''Arras à l''occasion de la censure qu''il a faite du livre
d''un Casuiste Allemand (Liège , Daniel Moumal, 1704)', NULL, NULL, 2621, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2637, 'Cippullo, Gregorio', NULL, NULL, 2622, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2638, 'Alsted, Johann Heinrich, Physica
harmonica, quatuor libellis methodice proponens I. Physicam Mosaicum.
II. Physicam Hebræorum. III. Physicam Peripateticam. IV. Physicam
chemicam (1642)', NULL, NULL, 2623, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2639, 'Memmingen', NULL, NULL, 2624, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2640, 'Palacios, Pedro de', NULL, NULL, 2625, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2641, 'Duhan, Laurent, Philosophus in utramque partem, sive selectae et limatae difficultates in utramque partem, cum responsionibus ad usum scholae (Venezia , Lorenzo Baseggio, 1768)', NULL, NULL, 2626, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2642, 'Egel, Ambrosius, Observationes in historiam Phosphorum naturalium (Würzburg, 1773)', NULL, NULL, 2627, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2643, 'Université de Kiel', NULL, NULL, 2628, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2644, 'Vázquez, Gabriel, Opuscula moralia (Venise, 1618)', NULL, NULL, 2629, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2645, 'Medici Girolamo de'' (O.P., Le P.)
Titre(s) :  Primae [-Primae secundae] partis Summae theologiae sancti Thomae Aquinatis,... formalis explicatio... auctore F. Hieronymo de Medicis a Camerino,... [Texte imprimé]
Publication :  Venetiis : apud A. et B. Dei fratres, 1614
Description matérielle :  2 vol. in-4 ? (1614)', NULL, NULL, 2630, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2646, 'Landsberg', NULL, NULL, 2631, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2647, 'Villanueva, José de, Cursus philosophicus ad mentem Aegidii Romani, complectens summulas, prooemialia, entia rationis, universalia, et praedicabilia (Valencia, 1677)', NULL, NULL, 2632, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2648, 'Bourdin, Pierre, Sol flamma, sive tractatus de sole, ut flamma est, eiusque
pabulo sol exurens montes, et radios igneos exsufflans Eccles. 43.
Aphorisimi analogici parvi mundi
ad magnum magni ad parvuum (Paris, 1646)', NULL, NULL, 2633, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2649, 'Sanders, Francis', NULL, NULL, 2634, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2650, 'Bourdin, Pierre, L''architecture militaire ou l''art de fortifier les places régulières et irrégulières (Paris, 1655)', NULL, NULL, 2635, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2651, 'Clauberg, Johannes, Physica, quibus rerum corporearum vis et natura... explicantur (Amsterdam, 1664)', NULL, NULL, 2636, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2656, 'Sforza Pallavicino, Pietro, praes. Kotulinksi, Fridericus Alexander, Conclusiones theologicae de justitia et jure (Collegium Romanum, pridie nonas Septembris 1648) (Romae , typ. Corbelletti, 1648)', NULL, NULL, 2641, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2657, 'Bayona, Carlos de, Primum: Theologiae splendor disciplinae nisi
integerrimae vitae cultoribus plene non illuxit. Secundum: Ut sacrae
semina
sapientiae insereret coelestis agricola areolam procidit, dum sacram
Catharinam Senensem suorum stigmatum munere decoravit.
Tertium: Nec otiose: in coelesti quippe curia preeminet, perenni
magisterii lauro, doctorum, inquam feliciter redimata. Propugnaturus
Fr. Carolus Bayona (Valladolid, 1666)', NULL, NULL, 2642, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2658, 'Inchofer, Melchior, Tractatus syllepticus, In quo, quid de terrae, solisq. motu, vel statione, secundum S. Scripturam, &amp; Sanctos Patres sentiedum, quaue cetitudine alterutra sententia tenenda sit, breviter ostenditur, Roma, L. Grignani, 1633 (1633)', NULL, NULL, 2643, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2659, 'Assomption, Charles de l'', Complainte a Jesus-Christ, redempteur de tous les pecheurs,
penitens &amp;amp; impenitens, contre les rigoristes qui retirent les
hommes de la confession (Liège , Arnould Bronckart, 1683)', NULL, NULL, 2644, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2660, 'Scaliger, Julius Caesar, De sapientia et beatitudine libri VIII (1573)', NULL, NULL, 2645, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2661, 'Céspedes, Anselmo', NULL, NULL, 2646, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2662, 'Possevino, Antonio, Bibliotheca selecta, qua agitur de ratione studiorum in historia, in disciplinis, in salute omnium procuranda (Romae , ex typographia Apostolica Vaticana, 1593)', NULL, NULL, 2647, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2663, 'Noris, Enrico, Historia pelagiana et dissertatio de synodo V. Oecumenica in qua Origenis
ac Theodori Mopsuesteni Pelagiani erroris Auctorum iusta damnatio exponitur,
et Aquileiense Schisma describitur, additis
Vindiciis Augustininanis pro libris a S. Doctore contra Pelagianos ac Semipelagianos scriptis (Padova , Pietro Maria Frambotti, 1673)', NULL, NULL, 2648, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2664, 'Cossé de Brissac, Charles', NULL, NULL, 2649, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2665, 'Daniel, Gabriel, Entretiens de Cléandre et d''Eudoxe sur les Lettres au provincial (Cologne , Pierre Marteau, 1694)', NULL, NULL, 2650, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2666, 'Borrhaus, Martin', NULL, NULL, 2651, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2667, 'Alcira', NULL, NULL, 2652, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2668, 'Margalho, Pedro', NULL, NULL, 2653, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2669, 'Collège des Irlandais (Paris)', NULL, NULL, 2654, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2670, 'Clauberg, Johannes, Logica vetus et nova, modum inveniendae ac tradendae veritatis in Genesi simul et analysi facile methodo exhibens. Editio secunda (Amsterdam, 1658)', NULL, NULL, 2655, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2671, 'Brahe, Tycho, Epistolarum astronomicarum libri, Norimbergae, 1601 (1601)', NULL, NULL, 2656, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2672, 'Mastri, Bartolomeo, Disputationes in libros generatione et corruptione (Venezia, 1640)', NULL, NULL, 2657, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2673, 'Reluz, Francisco', NULL, NULL, 2658, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2674, 'Bullarium Romanum magnum a Leone Magno ad opus absolutissimum Laertii Cherubini […], 12 t., Lugduni et Luxemburgi 1739-1748, in fol. (1739)', NULL, NULL, 2659, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2675, 'Calov, Abraham', NULL, NULL, 2660, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2676, 'Borrull, Matías, Divina scientia futurorum contingentium praecipue media, contra novissimos impugnatores defenda (Lugduni, 1656)', NULL, NULL, 2661, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2677, 'Chelsea College (London)', NULL, NULL, 2662, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2678, 'Laurent de Dijon', NULL, NULL, 2663, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2679, 'Brescia, Fortunato da, Philosophia mentis methodice tractata atque ad usus academicos accomodata, 
tomus 1 : Logica (Brescia, 1768)', NULL, NULL, 2664, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2680, 'Mastri, Bartolomeo, Disputationes theologicae in libros sententiarum quibus ab
adversantibus tum veterum tum recentiorum iaculis Scoti theologia
vindicatur. In quartum Sententiarum (Venezia , Valvasensis, 1664)', NULL, NULL, 2665, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2681, 'Campoverde, Juan de, Tractatus de Incarnatione Verbi Divini. Divisus in tres tomos. Tomus tertius (Alcala, 1712)', NULL, NULL, 2666, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2682, 'Elizalde, Miguel de, Forma verae religionis quaerendae et inveniendae (Napoli, 1662)', NULL, NULL, 2667, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2683, 'Convento de San Francisco (Puebla)', NULL, NULL, 2668, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2684, 'Dechamps, Etienne-Agard, Responsio ad obiectiones Vincentianas: qua Vincentii Lenis theriacam praesentissimum esse venenum demonstratur (Paris , Sébastien Cramoisy, 1648)', NULL, NULL, 2669, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2685, 'Friderich, Philipp', NULL, NULL, 2670, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2686, 'Baumeister, Friedrich Christian, Institutiones metaphysicae (Wittenberg, 1736)', NULL, NULL, 2671, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2687, 'Nifo, Ferdinando', NULL, NULL, 2672, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2688, 'Sforza Pallavicino, Pietro, Istoria del Concilio di Trento (S.L. , édition latine, ed. G.B. Giattino, 1670)', NULL, NULL, 2673, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2689, 'Araújo, Francisco de, Commentaria in universam Aristotelis metaphysicam tomus primus, quinque libros complectens (Salamanca , Antonia Ramirez, 1617)', NULL, NULL, 2674, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2690, 'Alexander VI', NULL, NULL, 2675, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2691, 'Pomponazzi, Pietro, Utrum anima sit mortalis vel immortalis (1514-1515) (S.L. , éd. W. van Dooren, Nouvelles de la République des Lettres, 1989)', NULL, NULL, 2676, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2692, 'Dechamps, Etienne-Agard, Defensio
censurae sacrae facultatis theologiae Parisiensis latae XXVII. Iunij
anni MDLX. seu disputatio theologica de libero arbitrio. Editio secunda (Paris , Cramoisy, 1645)', NULL, NULL, 2677, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2693, 'Straubing', NULL, NULL, 2678, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2694, 'Centum quinquaginta psalmi Davidici (Anvers, 1652)', NULL, NULL, 2679, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2695, 'Botto, Antonino, Disputationes in Aristotelis Logicam, philosophiam naturalem et metaphysicam : in tres tomos distributa, 3 vols (Genuae , ex typographia Antonij Georgij Franchelli, 1671)', NULL, NULL, 2680, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2696, 'Gravina, Domenico, Totius Summae theologicae S. Thomae Aquinatis compendium rhytmicum (Neapoli , ex typographia Lazari Scorigij, 1625)', NULL, NULL, 2681, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2697, 'Benet, Cipriano, De sacro sancto Eucharistie sacramento et de eiusdem ministro nova admodum et facillima quotlibeta (Roma , Iacobum de Mazochis, 1512)', NULL, NULL, 2682, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2698, 'Vincent, Jean, Cursus philosophicus (Tolosea, 1660)', NULL, NULL, 2683, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2699, 'Collège des Jésuites (Bratislava)', NULL, NULL, 2684, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2700, 'Bagot, Jean, Apologeticus fidei pars prior. Institutio theologica de vera religione (Paris, 1644)', NULL, NULL, 2685, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2701, 'Paris, Yves de, Jus naturale (Rennes, 1653)', NULL, NULL, 2686, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2702, 'Nifo, Agostino, Expositio super octo Aristotelis libros de physico auditu (Venetiis, 1552)', NULL, NULL, 2687, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2703, 'Chasteignier, Henri-Louis de La Rochepozay, Celebriorum distinctionum, tum philosophicarum, tum theologicarum synopsis (Zürich , Bodmer, 1659)', NULL, NULL, 2688, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2704, 'Summa theologiae scotisticae, 8 volumes (Lyon , Horace Molin, 1698)', NULL, NULL, 2689, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2705, 'Della Croce, Giacomo', NULL, NULL, 2690, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2706, 'Scaliger, Julius Caesar, De causis linguae latinae libri XIII (Lyon , typ. Pierre Saint-André, 1580)', NULL, NULL, 2691, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2707, 'Persall, John', NULL, NULL, 2692, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2708, 'Becanus, Martin, Summa theologiae scholasticae. Pars prima de Deo, attributisque divinis, sanctissima Trinitate, Angelis &amp;amp; Daemonibus, operibus dierum, ac statu innocentiae (1612)', NULL, NULL, 2693, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2709, 'Villanova, Jerónimo de', NULL, NULL, 2694, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2710, 'Celaya, Juan de, cum parvis ejusdem a magistro Johanne Ribeyro novissime castigate sueque integritati restitute et de novo Cadomi impresse (Caen , M.A. Angier, 1527)', NULL, NULL, 2695, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2711, 'Conimbricense, Collegium, In tres libros de Anima Aristotelis Stagiritae (Köln, 1629)', NULL, NULL, 2696, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2712, 'Catania', NULL, NULL, 2697, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2713, 'Mecklenburg', NULL, NULL, 2788, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2714, 'Gemma, Cornelius', NULL, NULL, 2934, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2715, 'Dechamps, Etienne-Agard, Tradition de l''Eglise catholique et de la fausse eglise des
heretiques du dernier siecle: sur la doctrine de Jansenius, touchant le libre arbitre &amp;amp; la grace. Par le p. Estienne de Champs, de la
Compagnie de Jesus (Paris , Etienne Michallet, 1688)', NULL, NULL, 2698, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2716, 'Contenson, Vincent, Theologia mentis et cordis seu speculationes universae doctrinae sacrae (Venise, 1727)', NULL, NULL, 2699, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2717, 'Cally, Pierre, Durand commenté ou l''accord de la philosophie avec la théologie touchant la transubstantiation (Cologne, 1700)', NULL, NULL, 2700, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2718, 'Dullaert, Jan, Quaestiones super octo libros Physicorum Aristotelis necnon super libros de caelo &amp;amp; mundo (Paris , Jean Petit, 1523)', NULL, NULL, 2701, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2719, 'Wolff, Medardus', NULL, NULL, 2702, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2720, 'Fassari, Vicenzo, Immaculata Deiparae conceptio theologicae commissa trutinae
ad dignoscendam et firmandam certitudinem eius. Lucubratio opuscula
varia complectens (Lyon, 1666)', NULL, NULL, 2703, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2721, 'Eberle, Wolfgang, Divinatio rationalis de infinito et quantitate aliisque philosophicis (Dillingen, 1662)', NULL, NULL, 2704, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2722, 'Caravaca', NULL, NULL, 2705, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2723, 'Château de Neuville (Gambais)', NULL, NULL, 2706, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2724, 'Conimbricense, Collegium, In octo libros Physicorum Aristotelis Stagiritae (Lyon , Horace Cardon, 1602)', NULL, NULL, 2707, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2725, 'Eger', NULL, NULL, 2708, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2726, 'Chasteignier, Henri-Louis de La Rochepozay, Celebriorum distinctionum, tum philosophicarum, tum theologicarum synopsis (La Haye, 1651)', NULL, NULL, 2709, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2727, 'Riez, Balthasar de', NULL, NULL, 2710, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2728, 'Astudillo, Diego de', NULL, NULL, 2711, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2729, 'Mastri, Bartolomeo, Disputationes in organum Aristotelis ou Commentarii in Logicam (Napoli, 1660)', NULL, NULL, 2712, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2730, 'Mastri, Bartolomeo, Theologia moralis ad mentem S. Bonaventurae et Scoti (Venezia , Balleonius, 1758)', NULL, NULL, 2713, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2731, 'Bellotti, Antonio Maria - da Piacenza', NULL, NULL, 2714, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2732, 'Torreglia', NULL, NULL, 2715, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2733, 'Clauberg, Johannes, Dictata physica privata, id est physica contracta seu theses physicae, commentario perpetuo explicatae (Frankfurt, 1689)', NULL, NULL, 2716, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2734, 'Chaumorat, Nicolas', NULL, NULL, 2717, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2735, 'Baron, Vincent, Theologiae moralis summa bipartita de regulis conscientiae,
et de singulis vitae humanae et christianae officiis. Pars prior vera
mens D. Thomae
et eius scholae de opinionum ex lege delectu in qualibet re morali
explicata et defensa, adversus D. Caramuelis apologema in D. Fagnanum
aliosque
laxiores aut rigidiores theologos (Paris, Simon Piget, 1667)', NULL, NULL, 2718, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2736, 'Gravina Domenico, Catholicarum praescriptionum adversus nostrorum temporum haereses, continuatio secundae partis tom. IV ubi de legitimo, et praecipuo magistro, et iudice infallibili Romano Pontifice, in fidei, morum, et Ecclesiasticae disciplinae, Canonizationis, et cultus Sanctorum, decretis, disseritr, ex Antiquitate, Universitate, Patrum Consensione, et Angelii methodo, atque doctrina, Neapoli 1639, Typis Jacobi Gaffari. (1639)', NULL, NULL, 2719, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2737, 'Daniel, Gabriel, Voyage du monde de Descartes (Amsterdam, 1713)', NULL, NULL, 2720, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2738, 'Morelia', NULL, NULL, 2721, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2739, 'Anglés, José', NULL, NULL, 2722, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2740, 'Brescia, Fortunato da, Philosophia mentis methodice tractata atque ad usus academicos accomodata, tomus 1 : Logica (Brescia, 1741)', NULL, NULL, 2723, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2741, 'Vaughan, Richard', NULL, NULL, 2724, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2742, 'Borelli, Giovanni Alfonso, De vi percussionis Liber ..., Bologna 1667, Monti (1667)', NULL, NULL, 2725, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2743, 'Celaya, Juan de, Insolubilia et obligationes magistri Joannis de celaya valentini (Parisiis , Hémon Le Fèvre, 1517)', NULL, NULL, 2726, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2744, 'Hilpoltstein', NULL, NULL, 2727, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2745, 'Zanchius, Hieronymus, De trebus Elohim (Francfort/M. , G. Corvinus, 1572)', NULL, NULL, 2728, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2746, 'Gómez de Fuentes, Juan', NULL, NULL, 2729, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2747, 'Polacco Giorgio, Anticopernicus catholicus, seu de terrae statione, et de solis motu, contra systema Copernicanum, Catholicae Assertiones, Venetiis 1644. (1644)', NULL, NULL, 2730, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2748, 'Chabrand, Jean-Baptiste', NULL, NULL, 2731, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2749, 'Combach, Johannes, Themata de sole sequentia (Marburg, 1615)', NULL, NULL, 2732, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2750, 'Coronel, Antonio, nuper multis in locis castigate et marginalibus indicibus illustrate (Lugduni, 1520)', NULL, NULL, 2733, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2751, 'Brescia, Fortunato da, Elementa matheseos ad mechanicam philosophiam (Brescia, 1750)', NULL, NULL, 2734, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2752, 'Rampen, Henri', NULL, NULL, 2735, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2753, 'Steen Cornelis van den (A Lapide), [Commentarii in Eccl. Cant. Sap., … 1694], p. 27 (1694)', NULL, NULL, 2736, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2754, 'Bonnet, Charles, La palingénésie philosophique, ou Idées sur l''état passé et sur l''état futur des êtres vivans: ouvrage destiné à servir de supplément aux derniers écrits de l''auteur et qui contient principalement le précis de ses recherches sur le christianisme (Genève , C. Philibert et B. Chirol, 1770, 1770)', NULL, NULL, 2737, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2755, 'Beringen', NULL, NULL, 2738, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2756, 'Universidad de Valencia', NULL, NULL, 2739, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2757, 'Brescia, Fortunato da, Philosophia sensuum mechanica methodica tractata atque ad usus accomadata, 
tomus 1 : Physices generalis pars prima (Venise, 1761)', NULL, NULL, 2740, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2758, 'Del Rio, Martín Antonio, In Canticum Canticorum Salomonis commentarius litteralis et catena mystica (Parisiis , Pierre Chevalier, 1609)', NULL, NULL, 2741, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2759, 'Viana de Duero', NULL, NULL, 2935, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2760, 'Boyvin, Jean Gabriel, Philosophia Scoti a prolixitate et subtilitas ejus ab obscuritate libera et vindicata: I. Logica; II. Physica; III. Metaphysica; IV. Philosophia moralis, 4 vols (Venezia , Gaspare de Stortis, 1701)', NULL, NULL, 2742, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2761, 'Mannheim', NULL, NULL, 2743, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2762, 'Celaya, Juan de, Clarissimi resolutissimique ac proinde doctissimi Doctoris
Parisiensis Magistri Joannis a Celaia Valentini scripta, quam
brevissima pariter et absolutissima adde etiam et omnium quae hactenus
scripta sunt facile clarissima in Secundum volumen Sententiarum (Valantiae, 1531)', NULL, NULL, 2744, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2763, 'Castro, Alfonso de, De potestate legis peonalis libri duo (Salmanticae, 1551)', NULL, NULL, 2745, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2764, 'Couvent de Llombay', NULL, NULL, 2746, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2765, 'Langenstein', NULL, NULL, 2747, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2766, 'Segovia, Gaspar', NULL, NULL, 2748, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2767, 'Marsigli, Antonio', NULL, NULL, 2749, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2768, 'Paris, Yves de, Les heureux succès de la piété (Paris, 1632)', NULL, NULL, 2750, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2769, 'Rivard, François', NULL, NULL, 2751, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2770, 'Conimbricense, Collegium, In tres libros de Anima Aristotelis Stagiritae (Lyon , Horace Cardon, 1600)', NULL, NULL, 2752, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2771, 'Albertini, Francesco, Corollarium seu quaestionum theologicarum tomus primus
continens corollaria deducta ex principiis philosophicis complexis
praecipue in primam et tertiam partem Sancti Thomae (Lyon, 1629)', NULL, NULL, 2753, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2772, 'Monte Sant'' Angelo', NULL, NULL, 2754, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2773, 'Fontainebleau', NULL, NULL, 2755, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2774, 'Alsted, Johann Heinrich, Logicae systema harmonicum : in quo universus bene
disserendi modus ex authoribus Peripateticis juxtà et Raméis traditur ;
Per Praecepta Brevia, Canones Selectos, et Commentaria Dilucida ;
Quibus non solùm scientia nobilissimae artis, sed etiam usus, et is
quidem inprimis continetur (Herborn, 1614)', NULL, NULL, 2756, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2775, 'Mastri, Bartolomeo, Compendium totius theologiae moralis B.M. de Meldula (Brno , G. Lehmann, 1706)', NULL, NULL, 2757, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2776, 'Dresden', NULL, NULL, 2758, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2777, 'Baptista Burgos, Juan', NULL, NULL, 2759, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2778, 'Guglielmini, Giovanni Battista, De diurno terrae motu, experimentis physico-mathematicis confirmato (Bologna , S. Tommaso d''Aquino, 1792)', NULL, NULL, 2760, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2779, 'Adam, Jean, Heures catholiques en latin et en françois, suivant le saint Concile de Trente (Paris , L. d''Houry, 1690)', NULL, NULL, 2761, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2780, 'Bauny, Etienne, Somme des péchés qui se commettent en tous états, de leurs conditions et qualités, en quelles occurrences ils sont mortels
ou véniels et en quelle façon le confesseur doit interroger son pénitent (Rouen, 1643)', NULL, NULL, 2762, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2781, 'Lugo', NULL, NULL, 2763, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2782, 'Collège de la Propagande (Rome)', NULL, NULL, 2764, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2783, 'Ames, William, De conscientia, ejus jure et casibus (Cambridge, 1603)', NULL, NULL, 2765, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2784, 'Bassée, Eloi de la, Flores totius theologiae practicae, tum sacramentalis, tum moralis (Lyon , Jérôme de la Garde, 1663)', NULL, NULL, 2766, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2785, 'Pasqualigo, Zaccaria, Sacra speculativa doctrina de Deo caeterisque divinitus revelatis ex theologicis principijs ad scholasticae lecturae methodum deducta (Venetiis , apud Bertanos, 1650)', NULL, NULL, 2767, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2786, 'Tuam', NULL, NULL, 2768, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2787, 'Bellarini, Giovanni, Doctrina S. Thomae de physicis praemotionibus et de generica determinatione omnium rerum et causarum ad actu operandum (Milano, 1624)', NULL, NULL, 2769, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2788, 'Varazdin', NULL, NULL, 2770, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2789, 'Riccioli, Giovanni Battista, Astonomia reformata, 2 vol. (Bologna, 1665)', NULL, NULL, 2771, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2790, 'Amort, Eusebius, Philosophia pollingiana ad normam Burgundicae, Cet ouvrage se compose des parties suivantes : Summulae ; Logica ; Physica (Augsburg, 1730)', NULL, NULL, 2772, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2791, 'Conimbricense, Collegium, In libros Meteorum Aristotelis Stagiritae (Lyon , Horace Cardon, 1608)', NULL, NULL, 2773, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2792, 'Daniel, Gabriel, Conférences Théologiques et Morales, par demandes et
réponses, sur les Commandements du Décalogue et sur les commandements
de l''Eglise et sur les sacrements (Paris , Hérissant Fils, 1741)', NULL, NULL, 2774, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2793, 'Alonso, Francisco, Disputationes in duos libros Aristotelis de generatione et corruptione, in quatuor libros de meteoris et in tres de caelo (Alcala, 1641)', NULL, NULL, 2775, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2794, 'Scaliger, Julius Caesar, Poemata (Genève, 1574)', NULL, NULL, 2776, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2795, 'Zaragoza y Vilanova, José, Geometria especulatiua y pratica de los planos, y solidos (Valencia, 1671)', NULL, NULL, 2777, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2796, 'Fagnani, Prospero, De opinione probabili. Tractatus ex Commentariis Prosperi Fagnani super Decretalibus seorsum recusus (Roma, 1665)', NULL, NULL, 2778, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2797, 'Azpilcueta, Martín de, Enchiridon sive Manuale confessariorum et poenitentium (Lyon , Jean-Baptiste Buisson, 1592)', NULL, NULL, 2779, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2798, 'Mastri, Bartolomeo, Theologia moralis ad mentem S. Bonaventurae et Scoti (Venezia, J.J. Hertz, 1671)', NULL, NULL, 2780, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2799, 'Cross, John', NULL, NULL, 2781, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2800, 'Boucher, Denis', NULL, NULL, 2782, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2801, 'Oreggi, Agostino, De Deo uno tractatus primus (Rome, 1629)', NULL, NULL, 2783, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2802, 'Possevino, Antonio, De sectariorum nostri temporis atheismis liber (Coloniae, , 1586)', NULL, NULL, 2784, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2803, 'Possevino, Antonio, Bibliotheca selecta ad rationem studiorum, ad disciplinas et ad salutem omnium gentium procurandam, Coloniae 1607 (1607)', NULL, NULL, 2785, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2804, 'Benet, Louis', NULL, NULL, 2786, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2805, 'Castel Bolognese', NULL, NULL, 2787, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2806, 'Mastri, Bartolomeo, Disputationes theologicae in libros sententiarum quibus ab
adversantibus tum veterum tum recentiorum iaculis Scoti theologia
vindicatur, 4 vol. (Venezia , J.J. Hertz, 1675)', NULL, NULL, 2789, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2807, 'Barbay, Pierre, Commentarius in Aristotelis Moralem (Parisiis, 1675)', NULL, NULL, 2790, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2808, 'De Vries, Gerard', NULL, NULL, 2791, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2809, 'Wallis, John', NULL, NULL, 2792, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2810, 'Collegium Complutense, Collegii Sancti Thomae Complutensis in universam Aristotelis logicam quaestiones (Compluti, 1677)', NULL, NULL, 2793, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2811, 'Van Helmont, Jan Baptist', NULL, NULL, 2794, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2812, 'Donaldson, Walter', NULL, NULL, 2795, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2813, 'Asson, Baudry d''', NULL, NULL, 2796, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2814, 'Wendelin, Markus Friedrich', NULL, NULL, 2797, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2927, 'Diotallevi, Francesco', NULL, NULL, 2909, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2815, 'Barbosa Agostino, De Iure Ecclesiast. libri 3, Lyon 1634. (1634)', NULL, NULL, 2798, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2816, 'Sarotti, Paolo', NULL, NULL, 2799, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2817, 'Académie Franeker', NULL, NULL, 2800, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2818, 'Mastri, Bartolomeo, Theologia moralis ad mentem S. Bonaventurae et Scoti (Venezia , M. Hertz, 1719)', NULL, NULL, 2801, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2819, 'Alsted, Johann Heinrich, Metaphysica exemplaris (Wittenberg, 1625)', NULL, NULL, 2802, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2820, 'Iavelli, Crisostomo, Epitome in omnibus
Metaphysicae libris quaesita textualia, metaphysicali modo determinata
: in quibus clarissime resoluuntur dubia Aristotelis (Lyon, 1559)', NULL, NULL, 2803, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2821, 'Castro Alfonso de, De iusta haereticorum punitione,  Antuerpiae 1545. (1545)', NULL, NULL, 2804, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2822, 'Baronius, Robert, Philosophia theologiae ancillans (Oxford, 1658)', NULL, NULL, 2805, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2823, 'Arniseus, Henning', NULL, NULL, 2806, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2824, 'Cassel', NULL, NULL, 2807, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2825, 'Royaume de Naples', NULL, NULL, 2808, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2826, 'Goa', NULL, NULL, 2809, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2827, 'Tapolcsani, Laurent', NULL, NULL, 2810, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2828, 'Rabesano da Montursio, Livio, Cursus philosophicus ad mentem Doctoris Subtilis Ioannis Duns Scoti pro Tyronibus Scotistis planiori stylo exaratus, etc, 3 part. (Venetiis , apud Nicolaum Pezzanam, 1665)', NULL, NULL, 2811, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2829, 'Morandi, Orazio', NULL, NULL, 2812, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2830, 'Duchesne, Joseph', NULL, NULL, 2813, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2831, 'Stilo ', NULL, NULL, 2814, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2832, 'Fassari, Vicenzo, Parte seconda delle Meditationi della prima dimora di
Christo Nostro Signore nel ventre della SS. Vergine doppo l''istante
della su Concettione (Palermo, 1646)', NULL, NULL, 2815, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2833, 'Du Bosc, Jacques, Le Triomphe de saint Augustin (1653)', NULL, NULL, 2816, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2834, 'Escobar y Mendoza, Antonio de, Liber theologiae moralis iginti &amp; quator Societatis Iesu Doctoribus reseratus, 1ère éd. latine : Post trigesimam-septimam Hispanicam Editionem, prodit prima additionibus illustrata (Venetiis , apud Paulum Baleonium, 1645)', NULL, NULL, 2817, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2835, 'Modolell, Francesc', NULL, NULL, 2818, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2836, 'Paris, Yves de, Les miséricordes de Dieu (Paris, 1644)', NULL, NULL, 2819, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2837, 'Duhan, Laurent, Philosophus in utramque partem, sive selectae et limatae difficultates in utramque partem, cum responsionibus ad usum scholae (Paris , Sumptibus Societatis, 1711)', NULL, NULL, 2820, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2838, 'Caltanissetta', NULL, NULL, 2821, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2839, 'Rojas (Roias) Juan de, Opus tripartitum: De successionibus. De haereticis. Singularia in fidei fauorem, Salmanticae 1581. (1581)', NULL, NULL, 2822, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2840, 'Derrez, Nicolas', NULL, NULL, 2823, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2841, 'Bibliotheca maxima pontificia, Joannes Thomas de Rocaberti de Perelada (éd.), 21 t., Romae 1697-1699. (1697)', NULL, NULL, 2824, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2842, 'Bail, Louis, De triplici examine ordinandorum, confessariorum et paenitentium (Paris, 1668)', NULL, NULL, 2825, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2843, 'Coninck, Gilles de, De moralitate, natura et effectibus actuum supernaturalium in genere et fide, spe ac caritate speciatim libri quatuor (Lyon, 1623)', NULL, NULL, 2826, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2844, 'Cagliari', NULL, NULL, 2827, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2845, 'Azpilcueta, Martín de, Enchiridon sive Manuale confessariorum et poenitentium (Paris , Joseph Cottereau, 1607)', NULL, NULL, 2828, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2846, 'Lardizabal y Elorza, Juan Antonio', NULL, NULL, 2829, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2847, 'Dechamps, Etienne-Agard, De haeresi ianseniana ab apostolica sede merito proscripta
libri tres. Opus ante annos novem sub Antonii Ricardi nomine inchoatum (Paris , Sébastien &amp;amp; Gabriel Cramoisy, 1654)', NULL, NULL, 2830, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2848, 'Cruz, Francisco de la, Cursus artium, 4 vol. (Sevilla, 1672)', NULL, NULL, 2831, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2849, 'Conimbricense, Collegium, In quatuor libros de Coelo Aristotelis Stagiritae (Köln , Lazarus Zetzner, 1603)', NULL, NULL, 2832, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2850, 'Chanevelle, Jacques, Ethica seu philosophia moralis iuxta principia Aristotelis, 2 vol. (Paris , Edmond Martin, 1666)', NULL, NULL, 2833, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2851, 'Erndtlin, Joachim, Disputatio physica de corporum naturalium proprietatibus in communi (Regensburg, 1620)', NULL, NULL, 2834, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2852, 'Iribarne e Uraburu, Juan, ommentarii in quartum librum Sententiarum Ioannis Duns Scoti, tomus
primus. Adduntur sex dubia ab eodem authore, in quibus confutatur impugnatio qua Gabriel Vazquez in Scoti molitur doctrinam urgere (Saragosse, 1614)', NULL, NULL, 2835, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2853, 'Quaestionum philosophicarum libri quatuor, 4 vol. (Romae, 1658)', NULL, NULL, 2836, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2854, 'Tellado, Buenaventura', NULL, NULL, 2837, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2855, 'Politi, Ambrogio Catarino, Annotationes in excerpta quaedam de commentariis... Caietani... dogmata (Paris, 1535)', NULL, NULL, 2933, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2856, 'Malafossa, Giacomino, Super primum sententiarum doctoris subtilis theologorum principis Ioannis Scoti exactissima enarratio absolutissimaque expositio. In qua centum et triginta contradictiones Scoti, quae in hoc primo hactenus latitarunt, acie ingenii luculenter dissolvuntur, Patavii 1560. (1560)', NULL, NULL, 2838, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2857, 'Moscatelli, Giordano', NULL, NULL, 2839, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2858, 'Espinosa, José de', NULL, NULL, 2840, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2859, 'Preston, William', NULL, NULL, 2841, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2860, 'Brescia, Fortunato da, Philosophia mentis methodice tractata atque ad usus academicos accomodata, 
tomus 1 : Logica (Venise, 1769)', NULL, NULL, 2842, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2861, 'Alcaraz, Cristóbal de', NULL, NULL, 2843, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2862, 'Baena', NULL, NULL, 2844, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2863, 'Celaya, Juan de, Expositio in libros Aristotelis de generatione et corruptione cum quaestionibus (Parisiis , ab Hemundo le Feuvre, 1518)', NULL, NULL, 2845, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2864, 'Salo', NULL, NULL, 2846, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2865, 'Droit naturel', NULL, NULL, 2847, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2866, 'Furtado, Francisco', NULL, NULL, 2848, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2867, 'Fabri, Honoré, Pulvis Peruvianus vindicatus de ventilatore ejusdemque suspecta defensio (Roma , Corbelletti, 1655)', NULL, NULL, 2849, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2868, 'Chasteignier, Henri-Louis de La Rochepozay, Celebriorum distinctionum, tum philosophicarum, tum theologicarum synopsis (Leiden , Apud Viduam Ioannis Patii, 1625)', NULL, NULL, 2850, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2869, 'Launoy Jean de, Syllabus rationum quibus causa Durandi de modo coniunctionis concursuum Dei et creaturae defenditur, et inofficiosa quorundam recentiorum censura repellitur, Parisiis 1636, 37 p. (1636)', NULL, NULL, 2851, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2870, 'Montepulciano', NULL, NULL, 2852, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2871, 'Iavelli, Crisostomo, Commentarii in logicam Aristotelis (Lyon, 1556)', NULL, NULL, 2853, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2872, 'Oswald, Albert', NULL, NULL, 2854, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2873, 'Riccardi, Niccolò, La prima [-seconda] parte dei ragionamenti sopra le litanie di Nostra Signora..., 2 vol., Genova : per Giuseppe Pavoni, 1626 (1626)', NULL, NULL, 2855, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2874, 'Morelles, Cosme Gil', NULL, NULL, 2856, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2875, 'Savona', NULL, NULL, 2857, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2876, 'Coninck, Gilles de, Commentariorum ac disputationum in universam doctrinam D. Thomae de sacramentis et censuris tomi duo (Anvers, 1616)', NULL, NULL, 2858, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2877, 'Clément, Claude, Tablas chronologicas, y breve compendio de las historias
mas notables de España, politicas y eclesiasticas, desde su fundacion
hasta el año de 1545 (Madrid , Carlos Sanchez, 1645)', NULL, NULL, 2859, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2878, 'Cordoba', NULL, NULL, 2860, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2879, 'Brésil', NULL, NULL, 2861, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2880, 'Barbay, Pierre, Compendium theologiae (Parisiis, 1693)', NULL, NULL, 2862, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2881, 'Ordre des Chartreux', NULL, NULL, 2863, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2882, 'Aragón, Pedro de, In Secundam-Secundae Divi Thomae doctoris Angelici commentaria. De iustitia et iure (Salamanca, 1590)', NULL, NULL, 2864, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2883, 'Pirhing, Heinrich', NULL, NULL, 2865, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2884, 'Brangier, Joseph', NULL, NULL, 2866, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2885, 'Bary, René, Esprit de cour ou les conversations galantes (Paris , Charles de Sercy, 1662)', NULL, NULL, 2867, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2886, 'Baron, Vincent, SS. Augustini et Thomae vera et una mens de libertate
humana et gratia divina explicatur et scholae thomisticae asseritur
adversus duos
Theophili Raynaudi libros, aliosque huius aetatis melioris notae
theologos. Manuductionis tertia pars dogmatica (Paris , Simon Piget, 1666)', NULL, NULL, 2868, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2887, 'Le Grand, Antoine', NULL, NULL, 2869, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2888, 'Cochet, Jean-Baptiste, Quaestio theologica : quis sapiens ? praes.Gaspar Thévenot (Paris, 1730)', NULL, NULL, 2870, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2889, 'Crab, Gilbert, Aristotelis ... Aethicorum ad Nichomacum libri decem. Cum annotationibus ... Magistri Gilberti Crab (Lyon , de la Place, 1516)', NULL, NULL, 2871, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2890, 'Bois, François Du, Commentarii in totam primam partem S. Tho. Aquinatis (Anvers , J.B. Verdussen, 1684)', NULL, NULL, 2872, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2891, 'Bauny, Etienne, Somme des péchés qui se commettent en tous états, de leurs conditions et qualités, en quelles occurrences ils sont mortels
ou véniels et en quelle façon le confesseur doit interroger son pénitent (Paris, 1643)', NULL, NULL, 2873, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2892, 'Cabane, Pierre', NULL, NULL, 2874, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2893, 'Albertini, Francesco, Corollaria seu Quaestiones theologicas de Trinitate,
Incarnatione Verbi et de Eucharistia, etc., ex principiis philosophicis
incomplexis seu praedicamentis substantiae, quantitatis, ubi et Ad
aliquid, iuxta irrefragabilem doctrinam philosophicam et theologicam S.
Thomae Aquinatis Doctoris Angelici... Tomus secundus (Lyon, 1629)', NULL, NULL, 2875, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2894, 'Frkic, Mate, Istri seu Danubii ortus aliorumque fluminum ab Aristotele in primo Meteoro inductorum. Accessit Lacus Asphaltitis confirmatio (Padova , ex typ. B. Carectoni, 1632)', NULL, NULL, 2876, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2895, 'Ruiz Delgado, José', NULL, NULL, 2877, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2896, 'Solenne, Antoine', NULL, NULL, 2878, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2897, 'Sommiste du Saint-Office romain', NULL, NULL, 2879, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2898, 'Durand, Barthélémy, Fides vindicata quatuor libris comprehensa in quibus
referuntur et refutantur haereses quae a reparatione mundi ad nostra
usque tempora
insurrexerunt (Venezia, 1726)', NULL, NULL, 2880, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2899, 'Cavazzi, Filippo', NULL, NULL, 2881, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2900, 'Martres', NULL, NULL, 2882, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2901, 'Origanus David, […] Ephemerides Brandeburgicae […], 1609. (1609)', NULL, NULL, 2883, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2902, 'Paludanus, Joannes', NULL, NULL, 2884, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2903, 'Mellini, Gian Garsia', NULL, NULL, 2885, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2904, 'Boyvin, Jean Gabriel, Theologia scoti a prolixitate et subtilitas eius ab obscuritate libera et vindicata, 4 vol., sexta editio, correctior (Paris , Edmond Couterot, 1690)', NULL, NULL, 2886, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2905, 'Rivas, José de', NULL, NULL, 2887, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2906, 'Cortona', NULL, NULL, 2888, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2907, 'Bassée, La', NULL, NULL, 2889, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2908, 'Ashford', NULL, NULL, 2890, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2909, 'Coccejus, Johannes, Summa Theologiae ex Scripturis repetita; adjecta eiusdem Autoris Doctrina de Foedere et Testamento (Genevae, 1665)', NULL, NULL, 2891, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2910, 'Celaya, Juan de, Expositio in libros Posteriorum Aristotelis, cum
quaestionibus secundum varias doctorum sententias, beati Thomae, Scoti,
Ockham, Gregorii de Arimino et aliorum doctorum nominalium (Paris, 1521)', NULL, NULL, 2892, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2911, 'Bary, René, Esprit de cour ou les conversations galantes (Paris , Charles de Sercy, 1666)', NULL, NULL, 2893, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2912, 'Aix de la Chaise, François d''', NULL, NULL, 2894, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2913, 'Azpilcueta, Martín de, Enchiridon sive Manuale confessariorum et poenitentium (Turin , Héritiers de Niccolo Bevilacqua, 1582)', NULL, NULL, 2895, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2914, 'Soares de Santa Maria, Diogo', NULL, NULL, 2896, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2915, 'Daniel, Gabriel, Reize door de wereld van Deskartes, traduction néérlandaise (Rotterdam , Bos, 1700)', NULL, NULL, 2897, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2916, 'Viola, Lorenzo, Arcana fere omnia tum theologiae tum philosophiae quaestiones disputatae ac ultimae voluntates Subtilissimi Doctoris I. Duns Scoti (Neapoli , ex typographia Tarquinii Longi, 1618)', NULL, NULL, 2898, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2917, 'Saint-Paul, Eustache de, Summa philosophiae quadripartita, de rebus dialecticis, moralibus et metaphysicis (1618)', NULL, NULL, 2899, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2918, 'Bourdin, Pierre, Cours de mathématiques, 3e ed. (Paris, 1661)', NULL, NULL, 2900, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2919, 'Spina, Bartolomeo, Tractatus de praeeminentia sacrae theologiae super alias omnes scientias, et praecipuae humanarum legum (1525)', NULL, NULL, 2901, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2920, 'Vázquez, Gabriel, Disputationes metaphysicae desumptae ex variis locis suorum operum (Anvers , ed. Francisco Murcia de la Llana, 1618)', NULL, NULL, 2902, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2921, 'Daniel, Gabriel, Iter per mundum Cartesii, traduction latine (Amsterdam , Wolfgang, 1694)', NULL, NULL, 2903, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2922, 'Steen Cornelis van den (A Lapide), In Pentateuchum Mosis commentaria, Paris 1637. (1637)', NULL, NULL, 2904, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2923, 'Alsted, Johann Heinrich, Theologia naturalis (1615)', NULL, NULL, 2905, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2924, 'Azpilcueta, Martín de, Enchiridon sive Manuale confessariorum et poenitentium (Lyon , Héritiers de Guillaume Rouillé, 1592)', NULL, NULL, 2906, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2925, 'Daniel, Gabriel, Suite du Voyage du monde de Descartes, ou nouvelles difficultez proposées à l''auteur du Voyage du monde de Descartes, 
avec la réfutation de deux défenses du système général du monde de Descartes (Amsterdam, 1713)', NULL, NULL, 2907, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2926, 'Ireland', NULL, NULL, 2908, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2928, 'Ayleworth, William, Metaphysica scholastica (Coloniae Agrippinae, 1675)', NULL, NULL, 2910, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2929, 'Genovesi, Antonio, Elementa logicae (1745)', NULL, NULL, 2911, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2930, 'Winkler, Angelus', NULL, NULL, 2912, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2931, 'Sala, Antonio', NULL, NULL, 2913, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2932, 'Lupi, Ignazio, Noua Lux in edictum S. Inquisitionis ad praxim sacramenti poenitentiae pro cuiuscumque status, ac conditione […] quae omnes Christi fideles illuminantur […] Ad intelligendum potissimum materiam denunciationum S. Officii […], (Bergomi , typis Marci Antonij Rubei, 1648)', NULL, NULL, 2914, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2933, 'Azpilcueta, Martín de, Enchiridon sive Manuale confessariorum et poenitentium (Anvers , Christophe Plantin, 1579)', NULL, NULL, 2915, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2934, 'Fabri, Honoré, Tractatus physicus de motu locali, in quo effectus omnes, qui ad impetum, motum naturalem, violentum et mixtum pertinent,
explicantur et ex principiis physicis demonstrantur, auctore Petro Mousnerio, cuncta excerpta ex praelectionibus R.P. Honorati Fabry
Societatis Iesu (Lyon , typ. Jean Champion, 1646)', NULL, NULL, 2916, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2935, 'Alonso, Francisco, Institutionum dialectarum libri quinque (Alcala, 1639)', NULL, NULL, 2917, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2936, 'Bary, René, Méthode pour bien prononcer un discours et pour le bien animer. 
Ouvrage très utile à tous ceux qui parlent en public, particulièrement aux prédicateurs et aux avocats (Paris , Denis Thierry, 1679)', NULL, NULL, 2918, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2937, 'Bozio, Tommaso', NULL, NULL, 2919, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2938, 'Caietano, Tommaso de Vio, Commentaria in libros Aristotelis de anima novissime recognita: cumcusquem erroribus expurgata, Venetiis : per Georgium Arrivabenum, 1514 (1514)', NULL, NULL, 2920, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2939, 'Riphoz, Rafael', NULL, NULL, 2921, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2940, 'Bouju, Théophraste, Corpus de toute la philosophie (Paris, 1614)', NULL, NULL, 2922, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2941, 'Golius, Théophile', NULL, NULL, 2923, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2942, 'Sforza Pallavicino, Pietro, Vera Concilii Tridentini Historia, contra falsam Petri Suavis Polani narrationem, trad. latine par J. B. Giattino (Augsbourg , Matthias Rieger &amp;amp; Söhne, 1769)', NULL, NULL, 2924, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2943, 'Ituren', NULL, NULL, 2925, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2944, 'Ildefonso de Santo Tomás', NULL, NULL, 2926, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2945, 'La Roda', NULL, NULL, 2927, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2946, 'Oliva, Josep', NULL, NULL, 2928, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2947, 'Campuzano, Bernabé', NULL, NULL, 2929, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2948, 'António de São Domingos', NULL, NULL, 2930, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2949, 'Mastri, Bartolomeo, Philosophiae ad mentem Scoti cursus integer (Venezia, 1708)', NULL, NULL, 2931, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2950, 'Siège inquisitorial d''Ancona', NULL, NULL, 2932, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2951, 'Kilkenny', NULL, NULL, 2937, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2952, 'de Ulloa, Juan, Dialectica, seu logica minor (Roma , ex Typographia Paul Komareck, 1711)', NULL, NULL, 2938, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2953, 'Munareno, Antonio', NULL, NULL, 2939, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2954, 'Jaen', NULL, NULL, 2940, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2955, 'Tournai', NULL, NULL, 2941, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2956, 'Struggl, Markus Maria', NULL, NULL, 2942, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2957, 'Curiel, Juan Alfonso, Controversiae in diversa loca Sacrae Scripturae (Salamanque, 1611)', NULL, NULL, 2943, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2958, 'O''Fihely, Maurice', NULL, NULL, 2944, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2959, 'Villaescusa de Haro', NULL, NULL, 2945, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2960, 'Baronio, Bonaventura, Panegyrici sacro-prophani (Lugduni, 1656)', NULL, NULL, 2946, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2961, 'Blanco, Tomás', NULL, NULL, 2947, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2962, 'Port Royal', NULL, NULL, 2948, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2963, 'Conimbricense, Collegium, In quatuor libros de Coelo Aristotelis Stagiritae (Köln , Lazarus Zetzner, 1596)', NULL, NULL, 2949, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2964, 'Bamberg', NULL, NULL, 2950, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2965, 'Politique', NULL, NULL, 2951, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2966, 'Conimbricense, Collegium, In tres libros de Anima Aristotelis Stagiritae (Köln, 1609)', NULL, NULL, 2952, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2967, 'Lippomano, Girolamo', NULL, NULL, 2953, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2968, 'Fabri, Filippo, Philosophia naturalis Joannis Duns Scoti ex quatuor libri Sententiarum et Quodlibetis collecta, in theoremata distributa et contra adversarios omnes tum Veteres quam Recentiores, impugnationibus
et defensionibus illustrata ac dilucidata... (Venezia , Battista Bertoni, 1606)', NULL, NULL, 2954, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2969, 'De poenitentia qua virtute qua sacramento disputationes theologicae circa textum D. Thomae Angelici (Douai, 1626)', NULL, NULL, 2955, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2970, 'Biblioteca ambrosiana', NULL, NULL, 2956, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2971, 'Daniel, Gabriel, Lettres au R. P. Alexandre, dans lesquelles on fait le
parallèle de la doctrine des Thomistes avec celle des Jésuites sur la
probabilité et sur la grace (Cologne, 1704)', NULL, NULL, 2957, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2972, 'Robles, Sebastián de', NULL, NULL, 2958, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2973, 'Dias Franco, Luíz, Doctrina philosophica (Lisbonne, 1618)', NULL, NULL, 2959, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2974, 'Ames, William, Demonstratio logicae verae (Leiden, 1632)', NULL, NULL, 2960, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2975, 'Université d’Avignon, Faculté de Théologie', NULL, NULL, 2961, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2976, 'Gravina Di Puglia', NULL, NULL, 2962, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2977, 'Luis, Pedro', NULL, NULL, 2963, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2978, 'Jesuitenkolleg (Ellwangen)', NULL, NULL, 2964, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2979, 'Brescia, Fortunato da, Philosophia mentis methodice tractata atque ad usus academicos accomodata, tomus 2 : Metaphysica (Brescia, 1742)', NULL, NULL, 2965, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2980, 'Baronius, Robert, Philosophia theologiae ancillans (Amsterdam , typ. Joannes Janssonius, 1649)', NULL, NULL, 2966, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2981, 'Paris, Yves de, Les progrès de l''amour divin, 4 vol. (Paris, 1640)', NULL, NULL, 2967, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2982, 'Clenaerts, Pierre', NULL, NULL, 2968, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2983, 'Burgersdijk, Franco, Idea philosophiae moralis (Leiden, 1623)', NULL, NULL, 2969, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2984, 'Biscioni, Andrea', NULL, NULL, 2970, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2985, 'Villeneuve, François de', NULL, NULL, 2971, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2986, 'Bianchi, Antonio Maria', NULL, NULL, 2972, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2987, 'Iavelli, Crisostomo, Epitome in parva naturalia Aristotelis et in libros de coelo (Lyon, 1555)', NULL, NULL, 2973, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2988, 'Fabri, Honoré, Philosophiae tomus primus, qui complectitur scientiarum methodum
sex libris explicatam, logicam analyticam, duodecim libris demonstratam, et aliquot controversias logicas, breviter disputatas auctore Petro Mosnerio,... Cuncta excerpta ex praelectionibus R.P. Hon.
Fabry (Lyon , typ. Jean Champion, 1646)', NULL, NULL, 2974, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2989, 'Bonne Espérance, François de la, Noctua belgica, ad Aquilam germanicam ex P. Caramuelis (Louvain, 1651)', NULL, NULL, 2975, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2990, 'Barbay, Pierre, Commentarius in Aristotelis Moralem (Parisiis, 1690)', NULL, NULL, 2976, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2992, 'Alsted, Johann Heinrich, Quadriga splendidissima virtutum moralium (Herborn, 1616)', NULL, NULL, 2978, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2993, 'Elizalde, Miguel de, De recta doctrina morum quatuor libris distincta (Lyon , Pierre Chevallier, 1670)', NULL, NULL, 2979, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2994, 'Tosca, Tomás Vicente', NULL, NULL, 2980, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2995, 'Zabarella, Giacomo, De naturalis scientiae constitutione (1586)', NULL, NULL, 2981, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2996, 'Conceptione, Blasius a', NULL, NULL, 2982, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2997, 'Daniel, Gabriel, Défense de saint Augustin contre un livre qui paroît depuis
peu sous le nom de M. de Launoy, où l''on veut faire passer ce saint
Père pour un novateur (Paris , Nicolas Le Clerc &amp;amp; Jacques Josse, 1704)', NULL, NULL, 2983, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2998, 'Bois, François Du, Commentarii in totam primam partem S. Tho. Aquinatis (Douai , Gérard Patté, 1631)', NULL, NULL, 2984, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (2999, 'Fabri, Honoré, Brevis annotatio in systema saturnium Christiani Hugenii... una cum Christiani Hugenii responsio (Den Haag , typ. A. Vlacq, 1660)', NULL, NULL, 2985, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3000, 'Baronio, Bonaventura, Prolusiones philosophicae, logicis et physicis materiis bipartitae (Romae, 1651)', NULL, NULL, 2986, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3001, 'Maffei, Tommaso Pio, De cyclorum solilunarium inconstantia et emendatione (Venetiis, 1706)', NULL, NULL, 2987, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3002, 'Palombo di Ascanio, Marco Antonio, In primam partem Angelici Doctoris S. Thomae de Aquino De Deo uno et trino commentarius literae, et doctrinae, quae in litera continetur scholasticum examen (Neapoli , apud Aegidium Longum, 1631)', NULL, NULL, 2988, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3003, 'Bellarini, Giovanni, Speculum humanae atque divinae sapientiae (Milano, 1630)', NULL, NULL, 2989, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3004, 'Cremonini, Cesare, Disputatio de coelo, in tres partes divisa ... Apologia dictorum Aristotelis, De via lactae, De facie in orbe lunae (Venezia, Apud Th. Balionum, 1613)', NULL, NULL, 2990, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3005, 'Echeverria, Carlos de, Tractatus de angelis (Compluti, 1697)', NULL, NULL, 2991, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3006, 'Montbard', NULL, NULL, 2992, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3007, 'Clément, Claude, Musei siue Bibliothecae tam privatae quam publicae extructio,
instructio, cura, vsus libri IV : accessit accurata descriptio Regiae
Bibliothecae S. Laurentii Escurialis (Lyon , Jacques Prost, 1635)', NULL, NULL, 2993, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3008, 'Durand, Barthélémy, Fides vindicata quatuor libris comprehensa in quibus
referuntur et refutantur haereses quae a reparatione mundi ad nostra
usque tempora
insurrexerunt (Avignon , Fr.-Sébastien Offray, 1709)', NULL, NULL, 2994, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3009, 'Amico, Bartolomeo, Commentaria in S. Thomae. Quaestiones de iure. Repertorium Decisionum Rotalium (Napoli , Ms. Brancacciani V A 3, 1619)', NULL, NULL, 2995, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3010, 'Saint-Omer', NULL, NULL, 2996, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3011, 'Aversa, Raffaello, Tertia pars in qua de Deo Incarnato eiusdem Christi Domini mysteriis et sacramentis ab eo institutis accurate disseritur (Genova, 1640)', NULL, NULL, 2997, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3012, 'Dinet, Jacques', NULL, NULL, 2998, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3013, 'Brescia, Fortunato da, Animadversiones criticae in Epistolam apologeticam R.P. Uldarici Weis (Brescia, 1751)', NULL, NULL, 2999, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3014, 'Viterbo', NULL, NULL, 3000, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3015, 'Du Bosc, Jacques, Jésus Christ mort pour tous (1651)', NULL, NULL, 3001, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3016, 'Bérulle, Pierre de', NULL, NULL, 3002, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3017, 'Capiferro Maddaleni, Francesco, Elenchus librorum omnium tum in Tridentino, Clementinoque Indice, tum in aliis omnibus sacrae Indicis Congregationis particularibus decretis hactenus prohibitorum, Roma, Ex Typographia Camerae Aposoticae, 1632. (1632)', NULL, NULL, 3003, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3018, 'Bassée, Eloi de la, Supplementum ad Flores theologiae practicae, sive tomus secundus (Lyon , Jérôme de la Garde, 1653)', NULL, NULL, 3004, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3019, 'Couvent des franciscains conventuels (Serravalle)', NULL, NULL, 3005, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3020, 'Duhan, Laurent, Philosophus in utramque partem, sive selectae et limatae difficultates in utramque partem, cum responsionibus ad usum scholae (Paris , G. Vandive, 1704)', NULL, NULL, 3006, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3021, 'Arriaga, Rodrigo de, De Oratore libri quatuor, Köln, 1637 (1637)', NULL, NULL, 3007, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3022, 'Fabri, Filippo, Adversus impios atheos disputationes quatuor philosophicae (Venezia, 1627)', NULL, NULL, 3008, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3023, 'Alghero', NULL, NULL, 3009, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3024, 'Boyvin, Jean Gabriel, Philosophia Scoti a prolixitate et subtilitas ejus ab obscuritate libera et vindicata: I. Logica; II. Physica; III. Metaphysica; IV. Philosophia moralis, 4 vols (Paris , Edmond Couterot, 1690)', NULL, NULL, 3010, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3025, 'Simi, Niccolò', NULL, NULL, 3011, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3026, 'Araújo, Francisco de, In tertiam partem D. Thomae commentarii : tomus primus (Salamanca , ed. Convento de San Esteban, 1636)', NULL, NULL, 3012, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3027, 'Cambrils', NULL, NULL, 3013, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3028, 'Mariana, Juan de, Scholia in Vetus et Novum Testamentum (Madrid, , 1619)', NULL, NULL, 3014, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3029, 'Conti, Pietro, Disputationes metaphysicae theologice exagitatae, occasione examinandi an detur ens rationis obiectivum ? (München, 1658)', NULL, NULL, 3015, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3030, 'Artena', NULL, NULL, 3016, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3031, 'Bariola Luigi, Flores directorii inquisitorum […], Mediolani 1625. (1625)', NULL, NULL, 3017, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3032, 'Glasgow', NULL, NULL, 3018, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3033, 'Castro, Alfonso de, De iusta haereticorum punitione libri tres (Salamanticae, 1547)', NULL, NULL, 3019, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3034, 'Auch', NULL, NULL, 3020, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3035, 'Tetenbüll', NULL, NULL, 3021, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3036, 'Azpilcueta, Martín de, Enchiridon sive Manuale confessariorum et poenitentium (Lyon , Guillaume Rouillé, 1587)', NULL, NULL, 3022, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3037, 'Rythovius, Martin', NULL, NULL, 3023, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3038, 'Bassée, Eloi de la, Flores totius theologiae practicae, tum sacramentalis, tum moralis (Venezia , Nicola Pezzana, 1666)', NULL, NULL, 3024, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3039, 'Balfour, Robert, Commentarii in Organum Logicum Aristotelis (Bordeaux, 1620)', NULL, NULL, 3025, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3040, 'Eggendorfer, Wolfgang, Conclusiones ex universa theologia (Wien, 1692)', NULL, NULL, 3026, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3041, 'Bois, François Du, Commentaria in tertiam partem S. Thomae Aquinatis... et in ejusdem supplementum centesima quaestione auctum (Anvers , J. Meursius, 1680)', NULL, NULL, 3027, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3042, 'Daniel, Gabriel, Voyage du monde de Descartes (Paris , Veuve de Simon Bénard, 1691)', NULL, NULL, 3028, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3043, 'Académie de Genève (Genève)', NULL, NULL, 3029, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3044, 'Iavelli, Crisostomo, Quaestiones super octo libros Aristotelis de physico auditu (Venise, 1555)', NULL, NULL, 3030, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3045, 'Dabillon, André, La métaphysique des bons esprits, ou l''Idée d''une métaphysique familière et solide (Paris , typ. Sébastien Picquet, 1642)', NULL, NULL, 3031, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3046, 'Las Higueras', NULL, NULL, 3032, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3047, 'Erath, Augustinus', NULL, NULL, 3033, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3048, 'Coronel, Antonio, Prima pars Rosarii magistri Anthonii Coronel in qua de
propositione multa notanda, de materiis propositionum, de
contradictoriis in obliquis, de conditionatis et conversionibus ex
libro consequentiarum ejusdem assumptis, de modalibus, de
propositionibus, de futuro contingenti et de modo arguendi ab
affirmativa ad negativam, omnia de novo ab erratis multis castigata (Parisiis , Olivier Senant, 1512)', NULL, NULL, 3034, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3049, 'Bautzen', NULL, NULL, 3035, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3050, 'Evrard, Christophe, Theses ex universa theologia pro licentiatu et doctoratu theologico (Pont-à-Mousson , typ. François Maret, 1727)', NULL, NULL, 3036, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3051, 'Bassée, Eloi de la, Supplementum ad Flores theologiae practicae, sive tomus secundus (Lyon, sumptibus Laurent Anisson, &amp;amp; Ioannis Baptistae Deuenet, 1658)', NULL, NULL, 3037, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3052, 'Aymerich, Mateo, Nomina et Acta episcoporum Barcinonensium (Barcelone, 1760)', NULL, NULL, 3038, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3053, 'Université de Messina', NULL, NULL, 3039, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3054, 'Bugis, Pierre de, Tractatus de Deo uno duodecim libris comprehensus (Bordeaux, 1676)', NULL, NULL, 3040, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3055, 'Tauste', NULL, NULL, 3041, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3056, 'Meiningen', NULL, NULL, 3042, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3057, 'Barbay, Pierre, Commentarius in Aristotelis Logicam (Parisiis, 1684)', NULL, NULL, 3043, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3058, 'Hodierna, Giovanni Battista, Controversiarum Forensium liber unicus, in quo
abstrusissimae quaeque dissertationes in supremis Regni Neapolitani
Senatibus pertranctur (Venezia , apud Bertanas, 1662)', NULL, NULL, 3044, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3059, 'Cienfuegos, Álvaro, La heroyca vida, virtudes, y milagros del grande S. Francisco de Borja de la Compañia de Jesus (Madrid, 1726)', NULL, NULL, 3045, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3060, 'Goppingen', NULL, NULL, 3046, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3061, 'Bassée, Eloi de la, Flores totius theologiae practicae, tum sacramentalis, tum moralis (Anvers , Cornelius Woons, 1659)', NULL, NULL, 3047, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3062, 'Vitoria y Dávila, José de', NULL, NULL, 3048, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3063, 'Sá, Manuel de', NULL, NULL, 3049, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3064, 'Gilbert, William, On the magnet, 1600. (1600)', NULL, NULL, 3050, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3065, 'Chachapoyas', NULL, NULL, 3051, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3066, 'Goslar', NULL, NULL, 3052, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3067, 'Esbarroya, Agustin de, Libro intitulado Purificador de la Consciencia (Salamanca , en casa de Pedro Lasso, 1569)', NULL, NULL, 3053, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3068, 'Piccinardi, Serafino, De imputato scholasticis studio effraeni in Aristotelem, Patavii, typis Petri Mariae Frambotti, 1676 (1676)', NULL, NULL, 3054, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3069, 'Longo, Francesco', NULL, NULL, 3055, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3070, 'Pereira, Benito', NULL, NULL, 3056, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3071, 'Barbay, Pierre, Compendium theologiae (Parisiis, 1685)', NULL, NULL, 3057, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3072, 'Baron, Vincent, Theologiae moralis pars altera de singulis vitae humanae et
christianae officiis, contra fici Amadei et veri Martini de Moia
Hispani tractatus
XV. Editio altera ad mentem Alexandri VII aucta eiusdem S. Pontificis
45 propositionum censuris et tribus cum Joanne Launoio diatribis de
forma
absolutionis et primatu Petri et verborum injuriis (Paris , Simon Piget, 1668)', NULL, NULL, 3058, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3073, 'Colegio de San Pablo (Agustinos) (Mexico)', NULL, NULL, 3059, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3074, 'Duhan, Laurent, Philosophus in utramque partem, sive selectae et limatae difficultates in utramque partem, cum responsionibus ad usum scholae (Paris , Thibault, 1699)', NULL, NULL, 3060, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3075, 'Fassari, Vicenzo, Disputationes de quantitate (Palermo, 1644)', NULL, NULL, 3061, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3076, 'Casmann, Otto, Secunda pars anthropologiae: hoc est fabrica humani corporis (Hanau, 1596)', NULL, NULL, 3062, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3077, 'Zingnis, Christoph &amp; Paul', NULL, NULL, 3063, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3078, 'Inchofer Melchior, Epistolae b. virginis Mariae ad Messanenses veritas vindicata ac plurimis gravissimorum scriptorum testimoniis et rationibus erudite illustrata authore P. Melchiore Inchofer Austriaco Soc. Jesu, Messanae [1629] (1629)', NULL, NULL, 3064, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3079, 'Julius II', NULL, NULL, 3065, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3080, 'Celaya, Juan de, Clarissimi resolutissimique ac proinde doctissimi Doctoris
Parisiensis Magistri Joannis a Celaia Valentini scripta, quam
brevissima pariter et absolutissima adde etiam et omnium quae hactenus
scripta sunt, facile clarissima in Quartum volumen Sententiarum, quae
in Valentino Gymnasio die Jovis quarto decimo calendas Novembris...
inchoata sunt, anno a Christo nato 1525, quibusque iustissimus colophon
additus est die martis ad octavum calendas octobreis anno 1526 (Valentiae, 1528)', NULL, NULL, 3066, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3081, 'Jesuitenkolleg (Hall)', NULL, NULL, 3067, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3082, 'Manganellis, Luis de, Liber secundus correspondens secundo libro Sententiarum
Scoti... Discursus... per quos habetur expositio primi, secundi et
tertii capituli Cantic. Salomonis (Matriti, 1619)', NULL, NULL, 3068, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3083, 'Serravalle Scrivia', NULL, NULL, 3069, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3084, 'Conimbricense, Collegium, In tres libros de Anima Aristotelis Stagiritae (Köln, 1617)', NULL, NULL, 3070, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3085, 'Ramírez Blanco, José', NULL, NULL, 3071, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3086, 'Le Brun, Bonaventure', NULL, NULL, 3072, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3087, 'Galilei, Galileo, Opere (Padova, Nella stamperia del Seminario appreso Gio. Manfré, 1744)', NULL, NULL, 3073, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3088, 'Du Bosc, Jacques, Le pacificateur apostolique (Paris, Impr. d''E. Martin, 1663)', NULL, NULL, 3074, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3089, 'Iavelli, Crisostomo, Dispositio post peripateticam, academicamque moralem, divinae et christianae philosophiae moralis dispositio (Venise, 1565)', NULL, NULL, 3075, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3090, 'Universidad San Fulgencia (Agostinos) (Quito)', NULL, NULL, 3076, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3091, 'Bonarte, Thomas, Concordia scientiae cum fide e difficillimis philosophiae et theologicae scholasticae quaestionibus concinnata (Cologne, 1659)', NULL, NULL, 3077, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3092, 'Zaragoza y Vilanova, José, Tabula logarithmica : continens undecim numerorum chiliades
cum suis logarithmis ab vnitale, scilicèt ad 11100 : dispositis nova
methodo et proportione astronomicae applicatis in gratiam astronomorun (Madrid, 1672)', NULL, NULL, 3078, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3093, 'Alarcón, Diego de, Prima pars theologiae scholasticae (Lyon , Jacques Cardon, 1633)', NULL, NULL, 3079, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3094, 'Cárdenas, Juan de, Crisis theologica bipartita, sive disputationes selectae ex morali theologia, 
in quibus pro votis Illustrissimi D.D. Ioannes Caramuelis, utque operi eius interrogatorio respondeatur, quamplurimae
eius opiniones et argumentationes ad praefatam crisim vocantur, pars prima [et pars altera] (Venise , Nicola Pezzana, 1710)', NULL, NULL, 3081, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3095, 'Cienfuegos, Álvaro, Allegatio theologica physico-polemica pro unione eucharistica (Valencia, 1732)', NULL, NULL, 3082, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3096, 'Hodierna, Giovanni Battista, Controversiarum Forensium liber unicus, in quo
abstrusissimae quaeque dissertationes in supremis Regni Neapolitani
Senatibus pertranctur (Genève , Johann Hermann Widerhold, 1667)', NULL, NULL, 3083, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3097, 'Bertrand, Eutrope, Lecturae theologicae de sacramentis (Toulouse , B. Fauchac &amp;amp; Fr. Boude, 1657)', NULL, NULL, 3084, true, '2014-11-07 18:30:57.417844+01', NULL, NULL, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom, date_debut, date_fin) VALUES (3098, 'Colegio dos Jesu