<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:tei="http://www.tei-c.org/ns/1.0"
  xmlns:bhp="http://larhra.ish-lyon.cnrs.fr/ns/BHP" version="1.0">
  <xsl:output method="html" indent="yes" omit-xml-declaration="yes"/>


  <xsl:template match="/">
    <html>
      <head>
        <link rel="stylesheet" href="transformation/visualisation_navigateur.css"/>
        <title>
          <xsl:value-of select="/tei:TEI/@xml:id"/>
        </title>
      </head>
      <body>
        <xsl:apply-templates/>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="tei:TEI">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="tei:teiHeader">
    <xsl:apply-templates select="tei:fileDesc/tei:titleStmt"/>
    <xsl:apply-templates select="tei:fileDesc/tei:sourceDesc"/>
    <xsl:apply-templates select="tei:profileDesc"/>

  </xsl:template>

  <xsl:template match="tei:publicationStmt"/>


  <xsl:template match="tei:sourceDesc">
    <p>
      <xsl:text>Source: </xsl:text>
      <xsl:apply-templates/>
    </p>
  </xsl:template>


  <xsl:template match="tei:profileDesc">
    <p>
      <xsl:text>Date/lieu du texte: </xsl:text>
      <xsl:apply-templates select="descendant::tei:date/@when"/>
    </p>
    <br/>
  </xsl:template>

  <xsl:template match="tei:text">
    <xsl:apply-templates/>
  </xsl:template>
  <xsl:template match="tei:front">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="tei:head">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="tei:title">
    <xsl:choose>
      <xsl:when test="not(parent::tei:bibl)">
        <h3>
          <xsl:value-of select="."/>
        </h3>
      </xsl:when>
      <xsl:otherwise>
        <em>
          <xsl:value-of select="."/>
        </em>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="tei:msDesc">
    <p class="identification_doc">
      <xsl:apply-templates select="descendant::tei:msItemStruct"/>
      <xsl:text>.</xsl:text>
      <xsl:apply-templates select="descendant::tei:physDesc"/>
      <xsl:apply-templates select="descendant::tei:summary"/>
      <xsl:apply-templates select="descendant::tei:additional"/>
    </p>
  </xsl:template>


  <xsl:template match="tei:msIdentifier">
    <span style="font-weight:bold">
      <xsl:choose>
        <xsl:when test="child::tei:repository[@ref]">
          <xsl:value-of select="child::tei:repository/@ref"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="tei:settlement"/>
          <xsl:if test="string-length(tei:settlement)!=0">
            <xsl:text>, </xsl:text>
          </xsl:if>
          <xsl:value-of select="tei:repository"/>
        </xsl:otherwise>
      </xsl:choose>
    </span>
    <xsl:if test="string-length(tei:idno)!=0">
      <xsl:text>, </xsl:text>
    </xsl:if>
    <xsl:apply-templates select="tei:idno"/>
  </xsl:template>
  <xsl:template match="tei:head/tei:note">
    <xsl:apply-templates select="node()"/>
  </xsl:template>

  <xsl:template match="tei:head/tei:ref">
    <xsl:apply-templates select="node()"/>
  </xsl:template>



  <xsl:template match="tei:ref/tei:rs">
    <xsl:for-each select="node()">
      <a>
        <xsl:attribute name="href">
          <xsl:value-of select="."/>
          <xsl:text>.xml</xsl:text>
        </xsl:attribute>
        <xsl:value-of select="."/>
      </a>
    </xsl:for-each>
  </xsl:template>


  <xsl:template match="tei:ref">
    <xsl:choose>
      <xsl:when test="ancestor::tei:sourceDesc">
        <a>
          <xsl:attribute name="href">
            <xsl:value-of select="@target"/>
          </xsl:attribute>
          <xsl:apply-templates/>
        </a>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template match="tei:physDesc">
    <xsl:text> - </xsl:text>
    <xsl:value-of select="tei:handDesc"/>
    <xsl:text>.</xsl:text>
  </xsl:template>


  <xsl:template match="tei:name">
    <span class="name">
      <xsl:apply-templates/>
    </span>
    <xsl:if test="@ref">
      <span class="name_ref">
        <xsl:text> [</xsl:text>
        <xsl:value-of select="@ref"/>
        <xsl:text>]</xsl:text>
      </span>
    </xsl:if>
  </xsl:template>


  <xsl:template match="tei:bibl">
    <xsl:apply-templates/>
  </xsl:template>




  <xsl:template match="tei:rs">
    <span class="rs">
      <xsl:apply-templates/>
    </span>
    <span class="rs_ref">
      <xsl:if test="@ref">
        <xsl:text> [</xsl:text>
        <xsl:value-of select="@ref"/>
        <xsl:text>]</xsl:text>
      </xsl:if>
    </span>
  </xsl:template>



  <xsl:template match="tei:body">
    <xsl:apply-templates/>
    <xsl:for-each select="//tei:note">
      <p>
        <a>
          <xsl:attribute name="id">
            <xsl:number level="any" count="tei:note"/>
          </xsl:attribute>
          <xsl:number level="any" count="tei:note"/>
        </a>
        <xsl:text>. </xsl:text>
        <xsl:value-of select="."/>
      </p>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="tei:div">
    <xsl:variable name="depth">
      <xsl:value-of select="count(ancestor::tei:div)"/>
    </xsl:variable>

    <!-- tratiement de l'élément 'head' des 'div' -->
    <p>      
      <xsl:attribute name="style">
        <xsl:text> text-indent:</xsl:text>
        <xsl:value-of select="$depth * 2"/>
        <xsl:text>%; font-weight:bold;</xsl:text>
      </xsl:attribute>
      <xsl:choose>
        <xsl:when test="child::tei:head and string-length(child::tei:head/text())&gt;1">
          <xsl:apply-templates select="tei:head"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="class">
            <xsl:text>small</xsl:text>
          </xsl:attribute>
          <xsl:text>['div' sans titre (</xsl:text>
          <xsl:value-of select="./@type"/>
          <xsl:text>)]</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
      
      <xsl:if test="@ana">
        <span class="seg_ana">
          <xsl:text> [ana:</xsl:text>
          <xsl:value-of select="@ana"/>
          <xsl:text>] </xsl:text>
        </span>
      </xsl:if>
      
    </p>

    <xsl:apply-templates select="child::*[not(name()='head')]"/>
  </xsl:template>

  <xsl:template match="tei:p">
    <p class="paragraphe">
      <xsl:if test="@ana">
        <span class="seg_ana">
          <xsl:text> [ana:</xsl:text>
          <xsl:value-of select="@ana"/>
          <xsl:text>] </xsl:text>
        </span>
      </xsl:if>
      <xsl:apply-templates/>
    </p>
  </xsl:template>
  <xsl:template match="tei:ab">
    <p class="ab">
      <xsl:apply-templates/>
    </p>
  </xsl:template>

  <xsl:template match="tei:seg">
    <span class="segment">
      <xsl:if test="@ana">
        <span class="seg_ana">
          <xsl:text> [ana:</xsl:text>
          <xsl:value-of select="@ana"/>
          <xsl:text>] </xsl:text>
        </span>
      </xsl:if>
      <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="tei:note">
    <xsl:text> (</xsl:text>
    <a>
      <xsl:attribute name="href">
        <xsl:text>#</xsl:text>
        <xsl:number level="any" count="tei:note"/>
      </xsl:attribute>
      <xsl:number level="any" count="tei:note"/>
    </a>
    <xsl:text>) </xsl:text>
  </xsl:template>
</xsl:stylesheet>
