--
-- PostgreSQL database dump
--

-- Dumped from database version 9.3.1
-- Dumped by pg_dump version 9.3.1
-- Started on 2014-02-25 11:16:55 CET

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 8 (class 2615 OID 37830)
-- Name: tables_objet; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA tables_objet;


SET search_path = tables_objet, pg_catalog;

--
-- TOC entry 245 (class 1255 OID 37831)
-- Name: majuscule_sans_accents(text); Type: FUNCTION; Schema: tables_objet; Owner: -
--

CREATE FUNCTION majuscule_sans_accents(text) RETURNS text
    LANGUAGE sql
    AS $_$
/* fonction modifiée par rapport à celle en ligne, ajoutée un translate avec minuscules */
SELECT translate(upper(translate($1, 'àáâåçèéêëìíîïñòóôõöùûüýÿ', 'aaaaceeeeiiiiinooooouuuyy')),  'ÁÀÂÄÃÅÇÉÈÊËÍÏÎÌÑÓÒÔÖÕÚÙÛÜÝ', 'AAAAAACEEEEIIIINOOOOOUUUUY')
$_$;


SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 188 (class 1259 OID 37832)
-- Name: associer_objet; Type: TABLE; Schema: tables_objet; Owner: -; Tablespace: 
--

CREATE TABLE associer_objet (
    pk_associer_objet integer NOT NULL,
    fk_type_association_objet integer,
    fk_objet_concerne integer,
    fk_objet_associe integer,
    descriptif text,
    reference_precise text,
    notes text
);


--
-- TOC entry 190 (class 1259 OID 37840)
-- Name: nom_objet; Type: TABLE; Schema: tables_objet; Owner: -; Tablespace: 
--

CREATE TABLE nom_objet (
    pk_nom_objet integer NOT NULL,
    si_nom_standard boolean,
    nom text,
    descriptif text,
    date_debut character varying(10),
    notes_dd text,
    date_fin character varying(10),
    notes_df text,
    code_langue character(3),
    notes text,
    creation timestamp without time zone DEFAULT now(),
    fk_objet integer,
    fk_type integer,
    type_nom character varying(30)
);


--
-- TOC entry 2417 (class 0 OID 0)
-- Dependencies: 190
-- Name: COLUMN nom_objet.pk_nom_objet; Type: COMMENT; Schema: tables_objet; Owner: -
--

COMMENT ON COLUMN nom_objet.pk_nom_objet IS '
';


--
-- TOC entry 2418 (class 0 OID 0)
-- Dependencies: 190
-- Name: COLUMN nom_objet.fk_objet; Type: COMMENT; Schema: tables_objet; Owner: -
--

COMMENT ON COLUMN nom_objet.fk_objet IS '
';


--
-- TOC entry 192 (class 1259 OID 37849)
-- Name: objet; Type: TABLE; Schema: tables_objet; Owner: -; Tablespace: 
--

CREATE TABLE objet (
    pk_objet integer NOT NULL,
    cle_objet_bhp character varying(20),
    descriptif text,
    notes_dd text,
    notes_df text,
    notes text,
    creation timestamp without time zone DEFAULT now(),
    fk_type_objet integer,
    certitude_dd smallint,
    certitude_df smallint,
    url_objet text,
    fk_sous_type_objet integer,
    annee_debut integer,
    annee_fin integer,
    mois_debut integer,
    jour_debut integer,
    mois_fin integer,
    jour_fin integer,
    cle_importation integer,
    cle_jointure_zotero character varying(30),
    sexe integer,
    longitude numeric,
    latitude numeric
);


--
-- TOC entry 2419 (class 0 OID 0)
-- Dependencies: 192
-- Name: COLUMN objet.annee_debut; Type: COMMENT; Schema: tables_objet; Owner: -
--

COMMENT ON COLUMN objet.annee_debut IS 'La date est exprimée seulement en années';


--
-- TOC entry 2420 (class 0 OID 0)
-- Dependencies: 192
-- Name: COLUMN objet.annee_fin; Type: COMMENT; Schema: tables_objet; Owner: -
--

COMMENT ON COLUMN objet.annee_fin IS 'La date est exprimée seulement en années';


--
-- TOC entry 194 (class 1259 OID 37858)
-- Name: v_noms_standards_objets_dans_ordre_chronologique; Type: VIEW; Schema: tables_objet; Owner: -
--

CREATE VIEW v_noms_standards_objets_dans_ordre_chronologique AS
 SELECT nom_objet.fk_objet, 
    array_to_string(ARRAY( SELECT unnest(array_agg(nom_objet.nom)) AS unnest
          ORDER BY unnest(array_agg(nom_objet.date_debut))), '/'::text) AS nom
   FROM nom_objet
  WHERE (nom_objet.si_nom_standard IS TRUE)
  GROUP BY nom_objet.fk_objet
  ORDER BY array_to_string(ARRAY( SELECT unnest(array_agg(nom_objet.nom)) AS unnest
          ORDER BY unnest(array_agg(nom_objet.date_debut))), '/'::text);


--
-- TOC entry 189 (class 1259 OID 37838)
-- Name: associer_objet_pk_associer_objet_seq; Type: SEQUENCE; Schema: tables_objet; Owner: -
--

CREATE SEQUENCE associer_objet_pk_associer_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2421 (class 0 OID 0)
-- Dependencies: 189
-- Name: associer_objet_pk_associer_objet_seq; Type: SEQUENCE OWNED BY; Schema: tables_objet; Owner: -
--

ALTER SEQUENCE associer_objet_pk_associer_objet_seq OWNED BY associer_objet.pk_associer_objet;


--
-- TOC entry 191 (class 1259 OID 37847)
-- Name: nom_objet_pk_nom_objet_seq; Type: SEQUENCE; Schema: tables_objet; Owner: -
--

CREATE SEQUENCE nom_objet_pk_nom_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2422 (class 0 OID 0)
-- Dependencies: 191
-- Name: nom_objet_pk_nom_objet_seq; Type: SEQUENCE OWNED BY; Schema: tables_objet; Owner: -
--

ALTER SEQUENCE nom_objet_pk_nom_objet_seq OWNED BY nom_objet.pk_nom_objet;


--
-- TOC entry 193 (class 1259 OID 37856)
-- Name: objet_pk_objet_seq; Type: SEQUENCE; Schema: tables_objet; Owner: -
--

CREATE SEQUENCE objet_pk_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2423 (class 0 OID 0)
-- Dependencies: 193
-- Name: objet_pk_objet_seq; Type: SEQUENCE OWNED BY; Schema: tables_objet; Owner: -
--

ALTER SEQUENCE objet_pk_objet_seq OWNED BY objet.pk_objet;


--
-- TOC entry 195 (class 1259 OID 37862)
-- Name: v_objet_avec_type; Type: VIEW; Schema: tables_objet; Owner: -
--

CREATE VIEW v_objet_avec_type AS
 SELECT t1.pk_objet, 
    t2.nom AS type_objet, 
    t3.nom AS sous_type_objet
   FROM ((objet t1
   LEFT JOIN tables_types.parametre t2 ON ((t2.pk_parametre = t1.fk_type_objet)))
   LEFT JOIN tables_types.parametre t3 ON ((t3.pk_parametre = t1.fk_sous_type_objet)));


--
-- TOC entry 196 (class 1259 OID 37867)
-- Name: v_objet_nom_type_sous_type; Type: VIEW; Schema: tables_objet; Owner: -
--

CREATE VIEW v_objet_nom_type_sous_type AS
 SELECT t1.pk_objet, 
    t4.nom, 
    t2.nom AS type_objet, 
    t3.nom AS sous_type_objet
   FROM (((objet t1
   LEFT JOIN tables_types.parametre t2 ON ((t2.pk_parametre = t1.fk_type_objet)))
   LEFT JOIN tables_types.parametre t3 ON ((t3.pk_parametre = t1.fk_sous_type_objet)))
   LEFT JOIN v_noms_standards_objets_dans_ordre_chronologique t4 ON ((t4.fk_objet = t1.pk_objet)));


--
-- TOC entry 197 (class 1259 OID 37872)
-- Name: v_objets_associes; Type: VIEW; Schema: tables_objet; Owner: -
--

CREATE VIEW v_objets_associes AS
 SELECT t1.pk_associer_objet, 
    t1.fk_objet_concerne, 
    t4.nom AS nom_objet_concerne, 
    (t8.nom)::text AS type_objet_concerne, 
    (t10.nom)::text AS sous_type_objet_concerne, 
    t6.annee_debut AS annee_debut_objet_concerne, 
    t1.fk_objet_associe, 
    t2.nom AS nom_objet_associe, 
    (t7.nom)::text AS type_objet_associe, 
    (t9.nom)::text AS sous_type_objet_associe, 
    t5.annee_debut AS annee_debut_objet_associe, 
    t1.reference_precise, 
    t1.fk_type_association_objet, 
    (t3.nom)::text AS type_association, 
    t1.descriptif, 
    t1.notes
   FROM (((((((((associer_objet t1
   JOIN objet t5 ON ((t5.pk_objet = t1.fk_objet_associe)))
   JOIN objet t6 ON ((t6.pk_objet = t1.fk_objet_concerne)))
   JOIN tables_types.parametre t3 ON ((t3.pk_parametre = t1.fk_type_association_objet)))
   LEFT JOIN v_noms_standards_objets_dans_ordre_chronologique t2 ON ((t2.fk_objet = t1.fk_objet_associe)))
   LEFT JOIN v_noms_standards_objets_dans_ordre_chronologique t4 ON ((t4.fk_objet = t1.fk_objet_concerne)))
   LEFT JOIN tables_types.parametre t7 ON ((t7.pk_parametre = t5.fk_type_objet)))
   LEFT JOIN tables_types.parametre t8 ON ((t8.pk_parametre = t6.fk_type_objet)))
   LEFT JOIN tables_types.parametre t9 ON ((t9.pk_parametre = t5.fk_sous_type_objet)))
   LEFT JOIN tables_types.parametre t10 ON ((t10.pk_parametre = t6.fk_sous_type_objet)));


--
-- TOC entry 2267 (class 2604 OID 37877)
-- Name: pk_associer_objet; Type: DEFAULT; Schema: tables_objet; Owner: -
--

ALTER TABLE ONLY associer_objet ALTER COLUMN pk_associer_objet SET DEFAULT nextval('associer_objet_pk_associer_objet_seq'::regclass);


--
-- TOC entry 2269 (class 2604 OID 37878)
-- Name: pk_nom_objet; Type: DEFAULT; Schema: tables_objet; Owner: -
--

ALTER TABLE ONLY nom_objet ALTER COLUMN pk_nom_objet SET DEFAULT nextval('nom_objet_pk_nom_objet_seq'::regclass);


--
-- TOC entry 2271 (class 2604 OID 37879)
-- Name: pk_objet; Type: DEFAULT; Schema: tables_objet; Owner: -
--

ALTER TABLE ONLY objet ALTER COLUMN pk_objet SET DEFAULT nextval('objet_pk_objet_seq'::regclass);


--
-- TOC entry 2273 (class 2606 OID 37881)
-- Name: associer_objet_pkey; Type: CONSTRAINT; Schema: tables_objet; Owner: -; Tablespace: 
--

ALTER TABLE ONLY associer_objet
    ADD CONSTRAINT associer_objet_pkey PRIMARY KEY (pk_associer_objet);


--
-- TOC entry 2276 (class 2606 OID 37883)
-- Name: nom_objet_pkey; Type: CONSTRAINT; Schema: tables_objet; Owner: -; Tablespace: 
--

ALTER TABLE ONLY nom_objet
    ADD CONSTRAINT nom_objet_pkey PRIMARY KEY (pk_nom_objet);


--
-- TOC entry 2278 (class 2606 OID 37885)
-- Name: objet_pkey; Type: CONSTRAINT; Schema: tables_objet; Owner: -; Tablespace: 
--

ALTER TABLE ONLY objet
    ADD CONSTRAINT objet_pkey PRIMARY KEY (pk_objet);


--
-- TOC entry 2274 (class 1259 OID 37886)
-- Name: fki_nom_objet; Type: INDEX; Schema: tables_objet; Owner: -; Tablespace: 
--

CREATE INDEX fki_nom_objet ON nom_objet USING btree (fk_objet);


--
-- TOC entry 2279 (class 2606 OID 37887)
-- Name: fk_nom_objet; Type: FK CONSTRAINT; Schema: tables_objet; Owner: -
--

ALTER TABLE ONLY nom_objet
    ADD CONSTRAINT fk_nom_objet FOREIGN KEY (fk_objet) REFERENCES objet(pk_objet);


-- Completed on 2014-02-25 11:16:56 CET

--
-- PostgreSQL database dump complete
--

