SELECT
 "pk_textes_annotes",
 "titre",
 "definition",
 "texte",
 "notes"
 FROM "cours_2019_fb"."atom_test"."textes_annotes" LIMIT 1000;

 SELECT
  "pk_textes_annotes",
  xpath('//xhtml:a/text()', "texte", ARRAY[ARRAY['xhtml', 'http://www.w3.org/1999/xhtml']])
  FROM "cours_2019_fb"."atom_test"."textes_annotes" LIMIT 1000;

  SELECT "pk_textes_annotes",
     xpath('//tei:seg', "texte", ARRAY[ARRAY['tei', 'http://www.tei-c.org/ns/1.0']])
     FROM "cours_2019_fb"."atom_test"."textes_annotes" LIMIT 1000;

     with tw1 as  (
     SELECT "pk_textes_annotes" id_doc,
     	row_number() OVER (ORDER BY 1)::INTEGER id_fragment,
        unnest(xpath('//tei:seg', "texte", ARRAY[ARRAY['tei', 'http://www.tei-c.org/ns/1.0']])) fragment_xml
        FROM "cours_2019_fb"."atom_test"."textes_annotes" LIMIT 100 ),
        tw2 as (
        select id_doc,	row_number() OVER (ORDER BY 1)::INTEGER id_fragment,
     	   fragment_xml
     	   from tw1)

       select id_fragment, fragment_xml,
      unnest(xpath('//child::tei:*', "fragment_xml", ARRAY[ARRAY['tei', 'http://www.tei-c.org/ns/1.0']])) from tw2;



  SELECT
   "pk_textes_annotes",
   xpath('//tei:date/text()', "texte", ARRAY[ARRAY['tei', 'http://www.tei-c.org/ns/1.0']])
   FROM "cours_2019_fb"."atom_test"."textes_annotes" LIMIT 1000;



 SELECT
 "pk_peit",
 "fk_class",
 "standard_label",
 "definition",
 "notes",
 "date_debut",
 "date_fin"
 FROM "cours_2019_fb"."atom_test"."persistent_item" LIMIT 1000;
